// url/mojom/origin.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef URL_MOJOM_ORIGIN_MOJOM_SEND_VALIDATION_H_
#define URL_MOJOM_ORIGIN_MOJOM_SEND_VALIDATION_H_

#include "url/mojom/origin.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"

#include "url/mojom/origin.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::url::mojom::OriginDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::url::mojom::OriginDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::url::mojom::internal::Origin_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scheme)::BaseType> scheme_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_scheme,
        scheme_fragment);

      fragment->scheme.Set(
          scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scheme.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scheme in Origin struct");

      decltype(Traits::host(input)) in_host = Traits::host(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host)::BaseType> host_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_host,
        host_fragment);

      fragment->host.Set(
          host_fragment.is_null() ? nullptr : host_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host in Origin struct");

      fragment->port = Traits::port(input);

      decltype(Traits::nonce_if_opaque(input)) in_nonce_if_opaque = Traits::nonce_if_opaque(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nonce_if_opaque)::BaseType> nonce_if_opaque_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_nonce_if_opaque,
        nonce_if_opaque_fragment);

      fragment->nonce_if_opaque.Set(
          nonce_if_opaque_fragment.is_null() ? nullptr : nonce_if_opaque_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // URL_MOJOM_ORIGIN_MOJOM_SEND_VALIDATION_H_