// ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { TimeSpec as mojoBase_mojom_TimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const AnswerStatusSpec = { $: mojo.internal.Enum() };
export var AnswerStatus;
(function (AnswerStatus) {
    AnswerStatus[AnswerStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    AnswerStatus[AnswerStatus["MAX_VALUE"] = 7] = "MAX_VALUE";
    AnswerStatus[AnswerStatus["kUnspecified"] = 0] = "kUnspecified";
    AnswerStatus[AnswerStatus["kLoading"] = 1] = "kLoading";
    AnswerStatus[AnswerStatus["kSuccess"] = 2] = "kSuccess";
    AnswerStatus[AnswerStatus["kUnanswerable"] = 3] = "kUnanswerable";
    AnswerStatus[AnswerStatus["kModelUnavailable"] = 4] = "kModelUnavailable";
    AnswerStatus[AnswerStatus["kExecutionFailure"] = 5] = "kExecutionFailure";
    AnswerStatus[AnswerStatus["kExecutionCanceled"] = 6] = "kExecutionCanceled";
    AnswerStatus[AnswerStatus["kFiltered"] = 7] = "kFiltered";
})(AnswerStatus || (AnswerStatus = {}));
export const UserFeedbackSpec = { $: mojo.internal.Enum() };
export var UserFeedback;
(function (UserFeedback) {
    UserFeedback[UserFeedback["MIN_VALUE"] = 0] = "MIN_VALUE";
    UserFeedback[UserFeedback["MAX_VALUE"] = 2] = "MAX_VALUE";
    UserFeedback[UserFeedback["kUserFeedbackUnspecified"] = 0] = "kUserFeedbackUnspecified";
    UserFeedback[UserFeedback["kUserFeedbackNegative"] = 1] = "kUserFeedbackNegative";
    UserFeedback[UserFeedback["kUserFeedbackPositive"] = 2] = "kUserFeedbackPositive";
})(UserFeedback || (UserFeedback = {}));
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'history_embeddings.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setPage(page) {
        this.proxy.sendMessage(0, PageHandler_SetPage_ParamsSpec.$, null, [
            page
        ], false);
    }
    search(query) {
        this.proxy.sendMessage(1, PageHandler_Search_ParamsSpec.$, null, [
            query
        ], false);
    }
    sendQualityLog(selectedIndices, numEnteredChars) {
        this.proxy.sendMessage(2, PageHandler_SendQualityLog_ParamsSpec.$, null, [
            selectedIndices,
            numEnteredChars
        ], false);
    }
    recordSearchResultsMetrics(nonEmptyResults, userClickedResult, answerShown, answerCitationClicked, otherHistoryResultClicked, queryWordCount) {
        this.proxy.sendMessage(3, PageHandler_RecordSearchResultsMetrics_ParamsSpec.$, null, [
            nonEmptyResults,
            userClickedResult,
            answerShown,
            answerCitationClicked,
            otherHistoryResultClicked,
            queryWordCount
        ], false);
    }
    setUserFeedback(feedback) {
        this.proxy.sendMessage(4, PageHandler_SetUserFeedback_ParamsSpec.$, null, [
            feedback
        ], false);
    }
    maybeShowFeaturePromo() {
        this.proxy.sendMessage(5, PageHandler_MaybeShowFeaturePromo_ParamsSpec.$, null, [], false);
    }
    openSettingsPage() {
        this.proxy.sendMessage(6, PageHandler_OpenSettingsPage_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_SetPage_ParamsSpec.$, null, impl.setPage.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_Search_ParamsSpec.$, null, impl.search.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_SendQualityLog_ParamsSpec.$, null, impl.sendQualityLog.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_RecordSearchResultsMetrics_ParamsSpec.$, null, impl.recordSearchResultsMetrics.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_SetUserFeedback_ParamsSpec.$, null, impl.setUserFeedback.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_MaybeShowFeaturePromo_ParamsSpec.$, null, impl.maybeShowFeaturePromo.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_OpenSettingsPage_ParamsSpec.$, null, impl.openSettingsPage.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "history_embeddings.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    setPage;
    search;
    sendQualityLog;
    recordSearchResultsMetrics;
    setUserFeedback;
    maybeShowFeaturePromo;
    openSettingsPage;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_SetPage_ParamsSpec.$, null, this.setPage.createReceiverHandler(false /* expectsResponse */), false);
        this.search =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_Search_ParamsSpec.$, null, this.search.createReceiverHandler(false /* expectsResponse */), false);
        this.sendQualityLog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_SendQualityLog_ParamsSpec.$, null, this.sendQualityLog.createReceiverHandler(false /* expectsResponse */), false);
        this.recordSearchResultsMetrics =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_RecordSearchResultsMetrics_ParamsSpec.$, null, this.recordSearchResultsMetrics.createReceiverHandler(false /* expectsResponse */), false);
        this.setUserFeedback =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_SetUserFeedback_ParamsSpec.$, null, this.setUserFeedback.createReceiverHandler(false /* expectsResponse */), false);
        this.maybeShowFeaturePromo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_MaybeShowFeaturePromo_ParamsSpec.$, null, this.maybeShowFeaturePromo.createReceiverHandler(false /* expectsResponse */), false);
        this.openSettingsPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_OpenSettingsPage_ParamsSpec.$, null, this.openSettingsPage.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'history_embeddings.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    searchResultChanged(result) {
        this.proxy.sendMessage(0, Page_SearchResultChanged_ParamsSpec.$, null, [
            result
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_SearchResultChanged_ParamsSpec.$, null, impl.searchResultChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "history_embeddings.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    searchResultChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.searchResultChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_SearchResultChanged_ParamsSpec.$, null, this.searchResultChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const AnswerDataSpec = { $: {} };
export const SearchResultItemSpec = { $: {} };
export const SearchQuerySpec = { $: {} };
export const SearchResultSpec = { $: {} };
export const PageHandler_SetPage_ParamsSpec = { $: {} };
export const PageHandler_Search_ParamsSpec = { $: {} };
export const PageHandler_SendQualityLog_ParamsSpec = { $: {} };
export const PageHandler_RecordSearchResultsMetrics_ParamsSpec = { $: {} };
export const PageHandler_SetUserFeedback_ParamsSpec = { $: {} };
export const PageHandler_MaybeShowFeaturePromo_ParamsSpec = { $: {} };
export const PageHandler_OpenSettingsPage_ParamsSpec = { $: {} };
export const Page_SearchResultChanged_ParamsSpec = { $: {} };
mojo.internal.Struct(AnswerDataSpec.$, 'AnswerData', [
    mojo.internal.StructField('answerTextDirectives', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SearchResultItemSpec.$, 'SearchResultItem', [
    mojo.internal.StructField('title', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('urlForDisplay', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('relativeTime', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shortDateTime', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastUrlVisitTimestamp', 40, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sourcePassage', 48, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('answerData', 56, 0, AnswerDataSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isUrlKnownToSync', 64, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 80],]);
mojo.internal.Struct(SearchQuerySpec.$, 'SearchQuery', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timeRangeStart', 8, 0, mojoBase_mojom_TimeSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SearchResultSpec.$, 'SearchResult', [
    mojo.internal.StructField('query', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('answerStatus', 8, 0, AnswerStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('answer', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('items', 24, 0, mojo.internal.Array(SearchResultItemSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$, 'PageHandler_SetPage_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_Search_ParamsSpec.$, 'PageHandler_Search_Params', [
    mojo.internal.StructField('query', 0, 0, SearchQuerySpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SendQualityLog_ParamsSpec.$, 'PageHandler_SendQualityLog_Params', [
    mojo.internal.StructField('selectedIndices', 0, 0, mojo.internal.Array(mojo.internal.Uint32, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numEnteredChars', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_RecordSearchResultsMetrics_ParamsSpec.$, 'PageHandler_RecordSearchResultsMetrics_Params', [
    mojo.internal.StructField('nonEmptyResults', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('userClickedResult', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('answerShown', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('answerCitationClicked', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('otherHistoryResultClicked', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('queryWordCount', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetUserFeedback_ParamsSpec.$, 'PageHandler_SetUserFeedback_Params', [
    mojo.internal.StructField('feedback', 0, 0, UserFeedbackSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_MaybeShowFeaturePromo_ParamsSpec.$, 'PageHandler_MaybeShowFeaturePromo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenSettingsPage_ParamsSpec.$, 'PageHandler_OpenSettingsPage_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_SearchResultChanged_ParamsSpec.$, 'Page_SearchResultChanged_Params', [
    mojo.internal.StructField('result', 0, 0, SearchResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
