import './context_menu_entrypoint.js';
import './file_carousel.js';
import './recent_tab_chip.js';
import './icons.html.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { CrIconButtonElement } from '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { TabInfo } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import type { UnguessableToken } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import type { ComposeboxFile } from './common.js';
import { FileUploadErrorType, FileUploadStatus } from './composebox_query.mojom-webui.js';
import type { ComposeboxFileCarouselElement } from './file_carousel.js';
import type { RecentTabChipElement } from './recent_tab_chip.js';
export declare enum ComposeboxMode {
    DEFAULT = "",
    DEEP_SEARCH = "deep-search",
    CREATE_IMAGE = "create-image"
}
export interface ContextualEntrypointAndCarouselElement {
    $: {
        fileInput: HTMLInputElement;
        fileUploadButton: CrIconButtonElement;
        carousel: ComposeboxFileCarouselElement;
        imageInput: HTMLInputElement;
        imageUploadButton: CrIconButtonElement;
        recentTabChip: RecentTabChipElement;
    };
}
declare const ContextualEntrypointAndCarouselElement_base: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface);
export declare class ContextualEntrypointAndCarouselElement extends ContextualEntrypointAndCarouselElement_base {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        showDropdown: {
            type: BooleanConstructor;
        };
        realboxLayoutMode: {
            type: StringConstructor;
        };
        tabSuggestions: {
            type: ArrayConstructor;
        };
        entrypointName: {
            type: StringConstructor;
        };
        parentFocused: {
            type: BooleanConstructor;
        };
        attachmentFileTypes_: {
            type: StringConstructor;
        };
        contextMenuEnabled_: {
            type: BooleanConstructor;
        };
        files_: {
            type: ObjectConstructor;
        };
        addedTabsIds_: {
            type: ObjectConstructor;
        };
        imageFileTypes_: {
            type: StringConstructor;
        };
        inputsDisabled_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        recentTabChipDisabled_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        composeboxShowPdfUpload_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        showContextMenuDescription_: {
            type: BooleanConstructor;
        };
        showFileCarousel_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        showRecentTabChip_: {
            type: BooleanConstructor;
        };
        inDeepSearchMode_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        inCreateImageMode_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        recentTabInContext_: {
            type: BooleanConstructor;
        };
    };
    accessor showDropdown: boolean;
    accessor realboxLayoutMode: string;
    accessor entrypointName: string;
    accessor tabSuggestions: TabInfo[];
    accessor parentFocused: boolean;
    protected accessor attachmentFileTypes_: string;
    protected accessor contextMenuEnabled_: boolean;
    protected accessor files_: Map<UnguessableToken, ComposeboxFile>;
    protected accessor addedTabsIds_: Set<number>;
    protected accessor imageFileTypes_: string;
    protected accessor inputsDisabled_: boolean;
    protected accessor recentTabChipDisabled_: boolean;
    protected accessor composeboxShowPdfUpload_: boolean;
    protected accessor showContextMenuDescription_: boolean;
    protected accessor showRecentTabChip_: boolean;
    protected accessor showFileCarousel_: boolean;
    protected accessor inDeepSearchMode_: boolean;
    protected accessor inCreateImageMode_: boolean;
    protected accessor recentTabInContext_: boolean;
    private hasTabSuggestions_;
    protected get inToolMode_(): boolean;
    protected get shouldShowRecentTabChip_(): boolean;
    private maxFileCount_;
    private maxFileSize_;
    private createImageModeEnabled_;
    willUpdate(changedProperties: PropertyValues<this>): void;
    private computeRecentTabInContext_;
    setContextFiles(files: ComposeboxFile[]): void;
    setInitialMode(mode: ComposeboxMode): void;
    updateFileStatus(token: UnguessableToken, status: FileUploadStatus, errorType: FileUploadErrorType): {
        file: ComposeboxFile | undefined;
        errorMessage: string | null;
    };
    resetContextFiles(): void;
    resetModes(): void;
    hasImageFiles(): boolean;
    protected onDeleteFile_(e: CustomEvent): void;
    protected onFileChange_(e: Event): void;
    protected addFileContext_(filesToUpload: File[], isImage: boolean): void;
    protected addTabContext_(e: CustomEvent<{
        id: number;
        title: string;
        url: Url;
    }>): void;
    protected openImageUpload_(): void;
    protected openFileUpload_(): void;
    protected onDeepSearchClick_(): void;
    protected onCreateImageClick_(): void;
    private recordFileValidationMetric_;
}
declare global {
    interface HTMLElementTagNameMap {
        'contextual-entrypoint-and-carousel': ContextualEntrypointAndCarouselElement;
    }
}
export {};
