import './composebox_match.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { AutocompleteMatch, AutocompleteResult } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
export declare class ComposeboxDropdownElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        result: {
            type: ObjectConstructor;
        };
        selectedMatchIndex: {
            type: NumberConstructor;
            notify: boolean;
        };
        lastQueriedInput: {
            type: StringConstructor;
            notify: boolean;
        };
    };
    accessor result: AutocompleteResult | null;
    accessor selectedMatchIndex: number;
    accessor lastQueriedInput: string;
    /** Unselects the currently selected match, if any. */
    unselect(): void;
    /** Focuses the selected match, if any. */
    focusSelected(): void;
    /** Selects the first match. */
    selectFirst(): void;
    /** Selects the match at the given index. */
    selectIndex(index: number): void;
    /**
     * Selects the previous match with respect to the currently selected one.
     * Selects the last match if the first one or no match is currently selected.
     */
    selectPrevious(): void;
    /** Selects the last match. */
    selectLast(): void;
    /**
     * Selects the next match with respect to the currently selected one.
     * Selects the first match if the last one or no match is currently selected.
     */
    selectNext(): void;
    /**
     * @returns Index of the match in the autocomplete result. Passed to the match
     *     so it knows its position in the list of matches.
     */
    protected matchIndex_(match: AutocompleteMatch): number;
    protected isSelected_(match: AutocompleteMatch): boolean;
    /**
     * Returns whether the given index corresponds to the last match.
     */
    protected isLastMatch_(index: number): boolean;
    /**
     * Hides the match if its a verbatim match. This match should be hidden
     * for all typed suggestions. It will still be "selected" when the
     * autocomplete result changes, and the user can still navigate to this
     * verbatim match by navigating to the input text. Zero suggest does not
     * have verbatim matches.
     */
    protected hideVerbatimMatch_(index: number): boolean;
    protected computeAriaLabel_(match: AutocompleteMatch): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'ntp-composebox-dropdown': ComposeboxDropdownElement;
    }
}
