// components/omnibox/browser/searchbox.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  BigBufferSpec as mojoBase_mojom_BigBufferSpec,
  BigBuffer as mojoBase_mojom_BigBuffer
} from '../../../mojo/public/mojom/base/big_buffer.mojom-webui.js';
import {
  String16Spec as mojoBase_mojom_String16Spec,
  String16 as mojoBase_mojom_String16
} from '../../../mojo/public/mojom/base/string16.mojom-webui.js';
import {
  JSTimeSpec as mojoBase_mojom_JSTimeSpec,
  JSTime as mojoBase_mojom_JSTime,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec,
  TimeTicks as mojoBase_mojom_TimeTicks
} from '../../../mojo/public/mojom/base/time.mojom-webui.js';
import {
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec,
  UnguessableToken as mojoBase_mojom_UnguessableToken
} from '../../../mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '../../../url/mojom/url.mojom-webui.js';
import {
  FileUploadErrorTypeSpec as composeboxQuery_mojom_FileUploadErrorTypeSpec,
  FileUploadErrorType as composeboxQuery_mojom_FileUploadErrorType,
  FileUploadStatusSpec as composeboxQuery_mojom_FileUploadStatusSpec,
  FileUploadStatus as composeboxQuery_mojom_FileUploadStatus
} from '../composebox/composebox_query.mojom-webui.js';
import {
  NavigationPredictorSpec as omnibox_mojom_NavigationPredictorSpec,
  NavigationPredictor as omnibox_mojom_NavigationPredictor
} from './omnibox.mojom-webui.js';





export const SideTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SideType {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kDefaultPrimary = 0,
  kSecondary = 1,
}

export const RenderTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum RenderType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kDefaultVertical = 0,
  kHorizontal = 1,
  kGrid = 2,
}

export const SelectionLineStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SelectionLineState {

  MIN_VALUE = 1,
  MAX_VALUE = 4,
  kNormal = 1,
  kKeywordMode = 2,
  kFocusedButtonAction = 3,
  kFocusedButtonRemoveSuggestion = 4,
}



export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'searchbox.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  setPage(page: PageRemote): void;
  onFocusChanged(focused: boolean): void;
  queryAutocomplete(input: mojoBase_mojom_String16, preventInlineAutocomplete: boolean): void;
  stopAutocomplete(clearResult: boolean): void;
  openAutocompleteMatch(line: number, url: url_mojom_Url, areMatchesShowing: boolean, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
  onNavigationLikely(line: number, url: url_mojom_Url, navigationPredictor: omnibox_mojom_NavigationPredictor): void;
  deleteAutocompleteMatch(line: number, url: url_mojom_Url): void;
  activateKeyword(line: number, url: url_mojom_Url, matchSelectionTimestamp: mojoBase_mojom_TimeTicks, isMouseEvent: boolean): void;
  executeAction(line: number, actionIndex: number, url: url_mojom_Url, matchSelectionTimestamp: mojoBase_mojom_TimeTicks, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
  onThumbnailRemoved(): void;
  getPlaceholderConfig(): Promise<{
        config: PlaceholderConfig, }>;
  getRecentTabs(): Promise<{
        tabs: TabInfo[], }>;
  getTabPreview(tabId: number): Promise<{
        previewDataUrl: (string | null), }>;
  notifySessionStarted(): void;
  notifySessionAbandoned(): void;
  addFileContext(fileInfo: SelectedFileInfo, fileBytes: mojoBase_mojom_BigBuffer): Promise<{
        token: mojoBase_mojom_UnguessableToken, }>;
  addTabContext(tabId: number): Promise<{
        token: (mojoBase_mojom_UnguessableToken | null), }>;
  deleteContext(token: mojoBase_mojom_UnguessableToken): void;
  clearFiles(): void;
  submitQuery(queryText: string, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setPage(
      page: PageRemote): void {
    this.proxy.sendMessage(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        [
          page
        ],
        false);
  }

  onFocusChanged(
      focused: boolean): void {
    this.proxy.sendMessage(
        1,
        PageHandler_OnFocusChanged_ParamsSpec.$,
        null,
        [
          focused
        ],
        false);
  }

  queryAutocomplete(
      input: mojoBase_mojom_String16,
      preventInlineAutocomplete: boolean): void {
    this.proxy.sendMessage(
        2,
        PageHandler_QueryAutocomplete_ParamsSpec.$,
        null,
        [
          input,
          preventInlineAutocomplete
        ],
        false);
  }

  stopAutocomplete(
      clearResult: boolean): void {
    this.proxy.sendMessage(
        3,
        PageHandler_StopAutocomplete_ParamsSpec.$,
        null,
        [
          clearResult
        ],
        false);
  }

  openAutocompleteMatch(
      line: number,
      url: url_mojom_Url,
      areMatchesShowing: boolean,
      mouseButton: number,
      altKey: boolean,
      ctrlKey: boolean,
      metaKey: boolean,
      shiftKey: boolean): void {
    this.proxy.sendMessage(
        4,
        PageHandler_OpenAutocompleteMatch_ParamsSpec.$,
        null,
        [
          line,
          url,
          areMatchesShowing,
          mouseButton,
          altKey,
          ctrlKey,
          metaKey,
          shiftKey
        ],
        false);
  }

  onNavigationLikely(
      line: number,
      url: url_mojom_Url,
      navigationPredictor: omnibox_mojom_NavigationPredictor): void {
    this.proxy.sendMessage(
        5,
        PageHandler_OnNavigationLikely_ParamsSpec.$,
        null,
        [
          line,
          url,
          navigationPredictor
        ],
        false);
  }

  deleteAutocompleteMatch(
      line: number,
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        6,
        PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,
        null,
        [
          line,
          url
        ],
        false);
  }

  activateKeyword(
      line: number,
      url: url_mojom_Url,
      matchSelectionTimestamp: mojoBase_mojom_TimeTicks,
      isMouseEvent: boolean): void {
    this.proxy.sendMessage(
        7,
        PageHandler_ActivateKeyword_ParamsSpec.$,
        null,
        [
          line,
          url,
          matchSelectionTimestamp,
          isMouseEvent
        ],
        false);
  }

  executeAction(
      line: number,
      actionIndex: number,
      url: url_mojom_Url,
      matchSelectionTimestamp: mojoBase_mojom_TimeTicks,
      mouseButton: number,
      altKey: boolean,
      ctrlKey: boolean,
      metaKey: boolean,
      shiftKey: boolean): void {
    this.proxy.sendMessage(
        8,
        PageHandler_ExecuteAction_ParamsSpec.$,
        null,
        [
          line,
          actionIndex,
          url,
          matchSelectionTimestamp,
          mouseButton,
          altKey,
          ctrlKey,
          metaKey,
          shiftKey
        ],
        false);
  }

  onThumbnailRemoved(): void {
    this.proxy.sendMessage(
        9,
        PageHandler_OnThumbnailRemoved_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getPlaceholderConfig(): Promise<{
        config: PlaceholderConfig, }> {
    return this.proxy.sendMessage(
        10,
        PageHandler_GetPlaceholderConfig_ParamsSpec.$,
        PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getRecentTabs(): Promise<{
        tabs: TabInfo[], }> {
    return this.proxy.sendMessage(
        11,
        PageHandler_GetRecentTabs_ParamsSpec.$,
        PageHandler_GetRecentTabs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getTabPreview(
      tabId: number): Promise<{
        previewDataUrl: (string | null), }> {
    return this.proxy.sendMessage(
        12,
        PageHandler_GetTabPreview_ParamsSpec.$,
        PageHandler_GetTabPreview_ResponseParamsSpec.$,
        [
          tabId
        ],
        false);
  }

  notifySessionStarted(): void {
    this.proxy.sendMessage(
        13,
        PageHandler_NotifySessionStarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  notifySessionAbandoned(): void {
    this.proxy.sendMessage(
        14,
        PageHandler_NotifySessionAbandoned_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  addFileContext(
      fileInfo: SelectedFileInfo,
      fileBytes: mojoBase_mojom_BigBuffer): Promise<{
        token: mojoBase_mojom_UnguessableToken, }> {
    return this.proxy.sendMessage(
        15,
        PageHandler_AddFileContext_ParamsSpec.$,
        PageHandler_AddFileContext_ResponseParamsSpec.$,
        [
          fileInfo,
          fileBytes
        ],
        false);
  }

  addTabContext(
      tabId: number): Promise<{
        token: (mojoBase_mojom_UnguessableToken | null), }> {
    return this.proxy.sendMessage(
        16,
        PageHandler_AddTabContext_ParamsSpec.$,
        PageHandler_AddTabContext_ResponseParamsSpec.$,
        [
          tabId
        ],
        false);
  }

  deleteContext(
      token: mojoBase_mojom_UnguessableToken): void {
    this.proxy.sendMessage(
        17,
        PageHandler_DeleteContext_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }

  clearFiles(): void {
    this.proxy.sendMessage(
        18,
        PageHandler_ClearFiles_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  submitQuery(
      queryText: string,
      mouseButton: number,
      altKey: boolean,
      ctrlKey: boolean,
      metaKey: boolean,
      shiftKey: boolean): void {
    this.proxy.sendMessage(
        19,
        PageHandler_SubmitQuery_ParamsSpec.$,
        null,
        [
          queryText,
          mouseButton,
          altKey,
          ctrlKey,
          metaKey,
          shiftKey
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        impl.setPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_OnFocusChanged_ParamsSpec.$,
        null,
        impl.onFocusChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_QueryAutocomplete_ParamsSpec.$,
        null,
        impl.queryAutocomplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_StopAutocomplete_ParamsSpec.$,
        null,
        impl.stopAutocomplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_OpenAutocompleteMatch_ParamsSpec.$,
        null,
        impl.openAutocompleteMatch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_OnNavigationLikely_ParamsSpec.$,
        null,
        impl.onNavigationLikely.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,
        null,
        impl.deleteAutocompleteMatch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_ActivateKeyword_ParamsSpec.$,
        null,
        impl.activateKeyword.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_ExecuteAction_ParamsSpec.$,
        null,
        impl.executeAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_OnThumbnailRemoved_ParamsSpec.$,
        null,
        impl.onThumbnailRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetPlaceholderConfig_ParamsSpec.$,
        PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,
        impl.getPlaceholderConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_GetRecentTabs_ParamsSpec.$,
        PageHandler_GetRecentTabs_ResponseParamsSpec.$,
        impl.getRecentTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_GetTabPreview_ParamsSpec.$,
        PageHandler_GetTabPreview_ResponseParamsSpec.$,
        impl.getTabPreview.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        PageHandler_NotifySessionStarted_ParamsSpec.$,
        null,
        impl.notifySessionStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        PageHandler_NotifySessionAbandoned_ParamsSpec.$,
        null,
        impl.notifySessionAbandoned.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        PageHandler_AddFileContext_ParamsSpec.$,
        PageHandler_AddFileContext_ResponseParamsSpec.$,
        impl.addFileContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        PageHandler_AddTabContext_ParamsSpec.$,
        PageHandler_AddTabContext_ResponseParamsSpec.$,
        impl.addTabContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        PageHandler_DeleteContext_ParamsSpec.$,
        null,
        impl.deleteContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        PageHandler_ClearFiles_ParamsSpec.$,
        null,
        impl.clearFiles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        PageHandler_SubmitQuery_ParamsSpec.$,
        null,
        impl.submitQuery.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "searchbox.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onFocusChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  queryAutocomplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stopAutocomplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openAutocompleteMatch: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onNavigationLikely: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteAutocompleteMatch: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  activateKeyword: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onThumbnailRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getPlaceholderConfig: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getRecentTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTabPreview: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifySessionStarted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifySessionAbandoned: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addFileContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addTabContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearFiles: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  submitQuery: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        this.setPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onFocusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_OnFocusChanged_ParamsSpec.$,
        null,
        this.onFocusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.queryAutocomplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_QueryAutocomplete_ParamsSpec.$,
        null,
        this.queryAutocomplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.stopAutocomplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_StopAutocomplete_ParamsSpec.$,
        null,
        this.stopAutocomplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openAutocompleteMatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_OpenAutocompleteMatch_ParamsSpec.$,
        null,
        this.openAutocompleteMatch.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onNavigationLikely =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_OnNavigationLikely_ParamsSpec.$,
        null,
        this.onNavigationLikely.createReceiverHandler(false /* expectsResponse */),
        false);
    this.deleteAutocompleteMatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,
        null,
        this.deleteAutocompleteMatch.createReceiverHandler(false /* expectsResponse */),
        false);
    this.activateKeyword =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_ActivateKeyword_ParamsSpec.$,
        null,
        this.activateKeyword.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_ExecuteAction_ParamsSpec.$,
        null,
        this.executeAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onThumbnailRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_OnThumbnailRemoved_ParamsSpec.$,
        null,
        this.onThumbnailRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getPlaceholderConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_GetPlaceholderConfig_ParamsSpec.$,
        PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,
        this.getPlaceholderConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getRecentTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_GetRecentTabs_ParamsSpec.$,
        PageHandler_GetRecentTabs_ResponseParamsSpec.$,
        this.getRecentTabs.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getTabPreview =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_GetTabPreview_ParamsSpec.$,
        PageHandler_GetTabPreview_ResponseParamsSpec.$,
        this.getTabPreview.createReceiverHandler(true /* expectsResponse */),
        false);
    this.notifySessionStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        PageHandler_NotifySessionStarted_ParamsSpec.$,
        null,
        this.notifySessionStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifySessionAbandoned =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        PageHandler_NotifySessionAbandoned_ParamsSpec.$,
        null,
        this.notifySessionAbandoned.createReceiverHandler(false /* expectsResponse */),
        false);
    this.addFileContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        PageHandler_AddFileContext_ParamsSpec.$,
        PageHandler_AddFileContext_ResponseParamsSpec.$,
        this.addFileContext.createReceiverHandler(true /* expectsResponse */),
        false);
    this.addTabContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        PageHandler_AddTabContext_ParamsSpec.$,
        PageHandler_AddTabContext_ResponseParamsSpec.$,
        this.addTabContext.createReceiverHandler(true /* expectsResponse */),
        false);
    this.deleteContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        PageHandler_DeleteContext_ParamsSpec.$,
        null,
        this.deleteContext.createReceiverHandler(false /* expectsResponse */),
        false);
    this.clearFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        PageHandler_ClearFiles_ParamsSpec.$,
        null,
        this.clearFiles.createReceiverHandler(false /* expectsResponse */),
        false);
    this.submitQuery =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        PageHandler_SubmitQuery_ParamsSpec.$,
        null,
        this.submitQuery.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'searchbox.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  autocompleteResultChanged(result: AutocompleteResult): void;
  updateSelection(oldSelection: OmniboxPopupSelection, selection: OmniboxPopupSelection): void;
  setInputText(input: string): void;
  setThumbnail(thumbnailUrl: string, isDeletable: boolean): void;
  onContextualInputStatusChanged(token: mojoBase_mojom_UnguessableToken, status: composeboxQuery_mojom_FileUploadStatus, errorType: (composeboxQuery_mojom_FileUploadErrorType | null)): void;
  onTabStripChanged(): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  autocompleteResultChanged(
      result: AutocompleteResult): void {
    this.proxy.sendMessage(
        0,
        Page_AutocompleteResultChanged_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  updateSelection(
      oldSelection: OmniboxPopupSelection,
      selection: OmniboxPopupSelection): void {
    this.proxy.sendMessage(
        1,
        Page_UpdateSelection_ParamsSpec.$,
        null,
        [
          oldSelection,
          selection
        ],
        false);
  }

  setInputText(
      input: string): void {
    this.proxy.sendMessage(
        2,
        Page_SetInputText_ParamsSpec.$,
        null,
        [
          input
        ],
        false);
  }

  setThumbnail(
      thumbnailUrl: string,
      isDeletable: boolean): void {
    this.proxy.sendMessage(
        3,
        Page_SetThumbnail_ParamsSpec.$,
        null,
        [
          thumbnailUrl,
          isDeletable
        ],
        false);
  }

  onContextualInputStatusChanged(
      token: mojoBase_mojom_UnguessableToken,
      status: composeboxQuery_mojom_FileUploadStatus,
      errorType: (composeboxQuery_mojom_FileUploadErrorType | null)): void {
    this.proxy.sendMessage(
        4,
        Page_OnContextualInputStatusChanged_ParamsSpec.$,
        null,
        [
          token,
          status,
          errorType
        ],
        false);
  }

  onTabStripChanged(): void {
    this.proxy.sendMessage(
        5,
        Page_OnTabStripChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_AutocompleteResultChanged_ParamsSpec.$,
        null,
        impl.autocompleteResultChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_UpdateSelection_ParamsSpec.$,
        null,
        impl.updateSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_SetInputText_ParamsSpec.$,
        null,
        impl.setInputText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_SetThumbnail_ParamsSpec.$,
        null,
        impl.setThumbnail.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Page_OnContextualInputStatusChanged_ParamsSpec.$,
        null,
        impl.onContextualInputStatusChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Page_OnTabStripChanged_ParamsSpec.$,
        null,
        impl.onTabStripChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "searchbox.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  autocompleteResultChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateSelection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setInputText: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setThumbnail: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onContextualInputStatusChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onTabStripChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.autocompleteResultChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_AutocompleteResultChanged_ParamsSpec.$,
        null,
        this.autocompleteResultChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_UpdateSelection_ParamsSpec.$,
        null,
        this.updateSelection.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setInputText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_SetInputText_ParamsSpec.$,
        null,
        this.setInputText.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setThumbnail =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_SetThumbnail_ParamsSpec.$,
        null,
        this.setThumbnail.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onContextualInputStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Page_OnContextualInputStatusChanged_ParamsSpec.$,
        null,
        this.onContextualInputStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onTabStripChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Page_OnTabStripChanged_ParamsSpec.$,
        null,
        this.onTabStripChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ACMatchClassificationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ActionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SuggestionAnswerSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AutocompleteMatchSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SelectedFileInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SuggestionGroupSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AutocompleteResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OmniboxPopupSelectionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PlaceholderConfigSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnFocusChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_QueryAutocomplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_StopAutocomplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenAutocompleteMatch_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnNavigationLikely_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteAutocompleteMatch_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ActivateKeyword_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ExecuteAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnThumbnailRemoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetPlaceholderConfig_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetPlaceholderConfig_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetRecentTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetRecentTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabPreview_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTabPreview_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_NotifySessionStarted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_NotifySessionAbandoned_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_AddFileContext_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_AddFileContext_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_AddTabContext_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_AddTabContext_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeleteContext_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ClearFiles_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SubmitQuery_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_AutocompleteResultChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_UpdateSelection_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetInputText_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetThumbnail_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnContextualInputStatusChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnTabStripChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ACMatchClassificationMojoType {
  offset: number;
  style: number;
}


export type ACMatchClassification = ACMatchClassificationMojoType;
mojo.internal.Struct<ACMatchClassificationMojoType>(
    ACMatchClassificationSpec.$,
    'ACMatchClassification',
    [
      mojo.internal.StructField<ACMatchClassificationMojoType, number>(
        'offset', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ACMatchClassificationMojoType, number>(
        'style', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ActionMojoType {
  hint: string;
  suggestionContents: string;
  iconPath: string;
  a11yLabel: string;
}


export type Action = ActionMojoType;
mojo.internal.Struct<ActionMojoType>(
    ActionSpec.$,
    'Action',
    [
      mojo.internal.StructField<ActionMojoType, string>(
        'hint', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionMojoType, string>(
        'suggestionContents', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionMojoType, string>(
        'iconPath', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionMojoType, string>(
        'a11yLabel', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface SuggestionAnswerMojoType {
  firstLine: mojoBase_mojom_String16;
  secondLine: mojoBase_mojom_String16;
}


export type SuggestionAnswer = SuggestionAnswerMojoType;
mojo.internal.Struct<SuggestionAnswerMojoType>(
    SuggestionAnswerSpec.$,
    'SuggestionAnswer',
    [
      mojo.internal.StructField<SuggestionAnswerMojoType, mojoBase_mojom_String16>(
        'firstLine', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SuggestionAnswerMojoType, mojoBase_mojom_String16>(
        'secondLine', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AutocompleteMatchMojoType {
  a11yLabel: mojoBase_mojom_String16;
  allowedToBeDefaultMatch: boolean;
  isWeatherAnswerSuggestion: (boolean | null);
  isNoncannedAimSuggestion: boolean;
  isRichSuggestion: boolean;
  isSearchType: boolean;
  isEnterpriseSearchAggregatorPeopleType: boolean;
  swapContentsAndDescription: boolean;
  supportsDeletion: boolean;
  hasInstantKeyword: boolean;
  suggestionGroupId: number;
  actions: Action[];
  answer: (SuggestionAnswer | null);
  contents: mojoBase_mojom_String16;
  contentsClass: ACMatchClassification[];
  description: mojoBase_mojom_String16;
  descriptionClass: ACMatchClassification[];
  destinationUrl: url_mojom_Url;
  inlineAutocompletion: mojoBase_mojom_String16;
  fillIntoEdit: mojoBase_mojom_String16;
  iconPath: string;
  iconUrl: url_mojom_Url;
  imageDominantColor: string;
  imageUrl: string;
  type: string;
  removeButtonA11yLabel: mojoBase_mojom_String16;
  tailSuggestCommonPrefix: (mojoBase_mojom_String16 | null);
  keywordChipHint: string;
  keywordChipA11y: string;
}


export type AutocompleteMatch = AutocompleteMatchMojoType;
mojo.internal.Struct<AutocompleteMatchMojoType>(
    AutocompleteMatchSpec.$,
    'AutocompleteMatch',
    [
      mojo.internal.StructField<AutocompleteMatchMojoType, mojoBase_mojom_String16>(
        'a11yLabel', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'allowedToBeDefaultMatch', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, Action[]>(
        'actions', 16,
        0,
        mojo.internal.Array(ActionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, SuggestionAnswer>(
        'answer', 24,
        0,
        SuggestionAnswerSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, mojoBase_mojom_String16>(
        'contents', 32,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, ACMatchClassification[]>(
        'contentsClass', 40,
        0,
        mojo.internal.Array(ACMatchClassificationSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, mojoBase_mojom_String16>(
        'description', 48,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, ACMatchClassification[]>(
        'descriptionClass', 56,
        0,
        mojo.internal.Array(ACMatchClassificationSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, url_mojom_Url>(
        'destinationUrl', 64,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, mojoBase_mojom_String16>(
        'inlineAutocompletion', 72,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, mojoBase_mojom_String16>(
        'fillIntoEdit', 80,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'is_weather_answer_suggestion_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_weather_answer_suggestion_$value",
          originalFieldName: "isWeatherAnswerSuggestion",
        },
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'is_weather_answer_suggestion_$value', 8,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isWeatherAnswerSuggestion",
        },
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'iconPath', 88,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, url_mojom_Url>(
        'iconUrl', 96,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'imageDominantColor', 104,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'imageUrl', 112,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'isNoncannedAimSuggestion', 8,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'isRichSuggestion', 8,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'isSearchType', 8,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'isEnterpriseSearchAggregatorPeopleType', 8,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'type', 120,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, mojoBase_mojom_String16>(
        'removeButtonA11yLabel', 128,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'swapContentsAndDescription', 8,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, number>(
        'suggestionGroupId', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'supportsDeletion', 9,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, mojoBase_mojom_String16>(
        'tailSuggestCommonPrefix', 136,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, boolean>(
        'hasInstantKeyword', 9,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'keywordChipHint', 144,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteMatchMojoType, string>(
        'keywordChipA11y', 152,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 168],]);





export interface TabInfoMojoType {
  tabId: number;
  title: string;
  url: url_mojom_Url;
  lastActive: mojoBase_mojom_TimeTicks;
}


export type TabInfo = TabInfoMojoType;
mojo.internal.Struct<TabInfoMojoType>(
    TabInfoSpec.$,
    'TabInfo',
    [
      mojo.internal.StructField<TabInfoMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabInfoMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabInfoMojoType, url_mojom_Url>(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabInfoMojoType, mojoBase_mojom_TimeTicks>(
        'lastActive', 24,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface SelectedFileInfoMojoType {
  fileName: string;
  mimeType: string;
  selectionTime: mojoBase_mojom_JSTime;
}


export type SelectedFileInfo = SelectedFileInfoMojoType;
mojo.internal.Struct<SelectedFileInfoMojoType>(
    SelectedFileInfoSpec.$,
    'SelectedFileInfo',
    [
      mojo.internal.StructField<SelectedFileInfoMojoType, string>(
        'fileName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SelectedFileInfoMojoType, string>(
        'mimeType', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SelectedFileInfoMojoType, mojoBase_mojom_JSTime>(
        'selectionTime', 16,
        0,
        mojoBase_mojom_JSTimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface SuggestionGroupMojoType {
  header: mojoBase_mojom_String16;
  renderType: RenderType;
  sideType: SideType;
}


export type SuggestionGroup = SuggestionGroupMojoType;
mojo.internal.Struct<SuggestionGroupMojoType>(
    SuggestionGroupSpec.$,
    'SuggestionGroup',
    [
      mojo.internal.StructField<SuggestionGroupMojoType, mojoBase_mojom_String16>(
        'header', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SuggestionGroupMojoType, RenderType>(
        'renderType', 8,
        0,
        RenderTypeSpec.$,
        RenderType.kDefaultVertical,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SuggestionGroupMojoType, SideType>(
        'sideType', 12,
        0,
        SideTypeSpec.$,
        SideType.kDefaultPrimary,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AutocompleteResultMojoType {
  input: mojoBase_mojom_String16;
  suggestionGroupsMap: {[key: number]: SuggestionGroup};
  matches: AutocompleteMatch[];
  smartComposeInlineHint: (mojoBase_mojom_String16 | null);
}


export type AutocompleteResult = AutocompleteResultMojoType;
mojo.internal.Struct<AutocompleteResultMojoType>(
    AutocompleteResultSpec.$,
    'AutocompleteResult',
    [
      mojo.internal.StructField<AutocompleteResultMojoType, mojoBase_mojom_String16>(
        'input', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteResultMojoType, {[key: number]: SuggestionGroup}>(
        'suggestionGroupsMap', 8,
        0,
        mojo.internal.Map(mojo.internal.Int32, SuggestionGroupSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteResultMojoType, AutocompleteMatch[]>(
        'matches', 16,
        0,
        mojo.internal.Array(AutocompleteMatchSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AutocompleteResultMojoType, mojoBase_mojom_String16>(
        'smartComposeInlineHint', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface OmniboxPopupSelectionMojoType {
  line: number;
  actionIndex: number;
  state: SelectionLineState;
}


export type OmniboxPopupSelection = OmniboxPopupSelectionMojoType;
mojo.internal.Struct<OmniboxPopupSelectionMojoType>(
    OmniboxPopupSelectionSpec.$,
    'OmniboxPopupSelection',
    [
      mojo.internal.StructField<OmniboxPopupSelectionMojoType, number>(
        'line', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPopupSelectionMojoType, SelectionLineState>(
        'state', 4,
        0,
        SelectionLineStateSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OmniboxPopupSelectionMojoType, number>(
        'actionIndex', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PlaceholderConfigMojoType {
  texts: mojoBase_mojom_String16[];
  changeTextAnimationInterval: mojoBase_mojom_TimeDelta;
  fadeTextAnimationDuration: mojoBase_mojom_TimeDelta;
}


export type PlaceholderConfig = PlaceholderConfigMojoType;
mojo.internal.Struct<PlaceholderConfigMojoType>(
    PlaceholderConfigSpec.$,
    'PlaceholderConfig',
    [
      mojo.internal.StructField<PlaceholderConfigMojoType, mojoBase_mojom_String16[]>(
        'texts', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_String16Spec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PlaceholderConfigMojoType, mojoBase_mojom_TimeDelta>(
        'changeTextAnimationInterval', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PlaceholderConfigMojoType, mojoBase_mojom_TimeDelta>(
        'fadeTextAnimationDuration', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_SetPage_ParamsMojoType {
  page: PageRemote;
}


export type PageHandler_SetPage_Params = PageHandler_SetPage_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetPage_ParamsMojoType>(
    PageHandler_SetPage_ParamsSpec.$,
    'PageHandler_SetPage_Params',
    [
      mojo.internal.StructField<PageHandler_SetPage_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OnFocusChanged_ParamsMojoType {
  focused: boolean;
}


export type PageHandler_OnFocusChanged_Params = PageHandler_OnFocusChanged_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnFocusChanged_ParamsMojoType>(
    PageHandler_OnFocusChanged_ParamsSpec.$,
    'PageHandler_OnFocusChanged_Params',
    [
      mojo.internal.StructField<PageHandler_OnFocusChanged_ParamsMojoType, boolean>(
        'focused', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_QueryAutocomplete_ParamsMojoType {
  input: mojoBase_mojom_String16;
  preventInlineAutocomplete: boolean;
}


export type PageHandler_QueryAutocomplete_Params = PageHandler_QueryAutocomplete_ParamsMojoType;
mojo.internal.Struct<PageHandler_QueryAutocomplete_ParamsMojoType>(
    PageHandler_QueryAutocomplete_ParamsSpec.$,
    'PageHandler_QueryAutocomplete_Params',
    [
      mojo.internal.StructField<PageHandler_QueryAutocomplete_ParamsMojoType, mojoBase_mojom_String16>(
        'input', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_QueryAutocomplete_ParamsMojoType, boolean>(
        'preventInlineAutocomplete', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_StopAutocomplete_ParamsMojoType {
  clearResult: boolean;
}


export type PageHandler_StopAutocomplete_Params = PageHandler_StopAutocomplete_ParamsMojoType;
mojo.internal.Struct<PageHandler_StopAutocomplete_ParamsMojoType>(
    PageHandler_StopAutocomplete_ParamsSpec.$,
    'PageHandler_StopAutocomplete_Params',
    [
      mojo.internal.StructField<PageHandler_StopAutocomplete_ParamsMojoType, boolean>(
        'clearResult', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenAutocompleteMatch_ParamsMojoType {
  line: number;
  areMatchesShowing: boolean;
  altKey: boolean;
  ctrlKey: boolean;
  metaKey: boolean;
  shiftKey: boolean;
  mouseButton: number;
  url: url_mojom_Url;
}


export type PageHandler_OpenAutocompleteMatch_Params = PageHandler_OpenAutocompleteMatch_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenAutocompleteMatch_ParamsMojoType>(
    PageHandler_OpenAutocompleteMatch_ParamsSpec.$,
    'PageHandler_OpenAutocompleteMatch_Params',
    [
      mojo.internal.StructField<PageHandler_OpenAutocompleteMatch_ParamsMojoType, number>(
        'line', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenAutocompleteMatch_ParamsMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenAutocompleteMatch_ParamsMojoType, boolean>(
        'areMatchesShowing', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenAutocompleteMatch_ParamsMojoType, number>(
        'mouseButton', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenAutocompleteMatch_ParamsMojoType, boolean>(
        'altKey', 1,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenAutocompleteMatch_ParamsMojoType, boolean>(
        'ctrlKey', 1,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenAutocompleteMatch_ParamsMojoType, boolean>(
        'metaKey', 1,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenAutocompleteMatch_ParamsMojoType, boolean>(
        'shiftKey', 1,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_OnNavigationLikely_ParamsMojoType {
  line: number;
  navigationPredictor: omnibox_mojom_NavigationPredictor;
  url: url_mojom_Url;
}


export type PageHandler_OnNavigationLikely_Params = PageHandler_OnNavigationLikely_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnNavigationLikely_ParamsMojoType>(
    PageHandler_OnNavigationLikely_ParamsSpec.$,
    'PageHandler_OnNavigationLikely_Params',
    [
      mojo.internal.StructField<PageHandler_OnNavigationLikely_ParamsMojoType, number>(
        'line', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnNavigationLikely_ParamsMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnNavigationLikely_ParamsMojoType, omnibox_mojom_NavigationPredictor>(
        'navigationPredictor', 4,
        0,
        omnibox_mojom_NavigationPredictorSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_DeleteAutocompleteMatch_ParamsMojoType {
  line: number;
  url: url_mojom_Url;
}


export type PageHandler_DeleteAutocompleteMatch_Params = PageHandler_DeleteAutocompleteMatch_ParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteAutocompleteMatch_ParamsMojoType>(
    PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,
    'PageHandler_DeleteAutocompleteMatch_Params',
    [
      mojo.internal.StructField<PageHandler_DeleteAutocompleteMatch_ParamsMojoType, number>(
        'line', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_DeleteAutocompleteMatch_ParamsMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ActivateKeyword_ParamsMojoType {
  line: number;
  isMouseEvent: boolean;
  url: url_mojom_Url;
  matchSelectionTimestamp: mojoBase_mojom_TimeTicks;
}


export type PageHandler_ActivateKeyword_Params = PageHandler_ActivateKeyword_ParamsMojoType;
mojo.internal.Struct<PageHandler_ActivateKeyword_ParamsMojoType>(
    PageHandler_ActivateKeyword_ParamsSpec.$,
    'PageHandler_ActivateKeyword_Params',
    [
      mojo.internal.StructField<PageHandler_ActivateKeyword_ParamsMojoType, number>(
        'line', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ActivateKeyword_ParamsMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ActivateKeyword_ParamsMojoType, mojoBase_mojom_TimeTicks>(
        'matchSelectionTimestamp', 16,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ActivateKeyword_ParamsMojoType, boolean>(
        'isMouseEvent', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_ExecuteAction_ParamsMojoType {
  line: number;
  actionIndex: number;
  mouseButton: number;
  altKey: boolean;
  ctrlKey: boolean;
  metaKey: boolean;
  shiftKey: boolean;
  url: url_mojom_Url;
  matchSelectionTimestamp: mojoBase_mojom_TimeTicks;
}


export type PageHandler_ExecuteAction_Params = PageHandler_ExecuteAction_ParamsMojoType;
mojo.internal.Struct<PageHandler_ExecuteAction_ParamsMojoType>(
    PageHandler_ExecuteAction_ParamsSpec.$,
    'PageHandler_ExecuteAction_Params',
    [
      mojo.internal.StructField<PageHandler_ExecuteAction_ParamsMojoType, number>(
        'line', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ExecuteAction_ParamsMojoType, number>(
        'actionIndex', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ExecuteAction_ParamsMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ExecuteAction_ParamsMojoType, mojoBase_mojom_TimeTicks>(
        'matchSelectionTimestamp', 16,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ExecuteAction_ParamsMojoType, number>(
        'mouseButton', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ExecuteAction_ParamsMojoType, boolean>(
        'altKey', 3,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ExecuteAction_ParamsMojoType, boolean>(
        'ctrlKey', 3,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ExecuteAction_ParamsMojoType, boolean>(
        'metaKey', 3,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ExecuteAction_ParamsMojoType, boolean>(
        'shiftKey', 3,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_OnThumbnailRemoved_ParamsMojoType {
}


export type PageHandler_OnThumbnailRemoved_Params = PageHandler_OnThumbnailRemoved_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnThumbnailRemoved_ParamsMojoType>(
    PageHandler_OnThumbnailRemoved_ParamsSpec.$,
    'PageHandler_OnThumbnailRemoved_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetPlaceholderConfig_ParamsMojoType {
}


export type PageHandler_GetPlaceholderConfig_Params = PageHandler_GetPlaceholderConfig_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetPlaceholderConfig_ParamsMojoType>(
    PageHandler_GetPlaceholderConfig_ParamsSpec.$,
    'PageHandler_GetPlaceholderConfig_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetPlaceholderConfig_ResponseParamsMojoType {
  config: PlaceholderConfig;
}


export type PageHandler_GetPlaceholderConfig_ResponseParams = PageHandler_GetPlaceholderConfig_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetPlaceholderConfig_ResponseParamsMojoType>(
    PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,
    'PageHandler_GetPlaceholderConfig_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetPlaceholderConfig_ResponseParamsMojoType, PlaceholderConfig>(
        'config', 0,
        0,
        PlaceholderConfigSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetRecentTabs_ParamsMojoType {
}


export type PageHandler_GetRecentTabs_Params = PageHandler_GetRecentTabs_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetRecentTabs_ParamsMojoType>(
    PageHandler_GetRecentTabs_ParamsSpec.$,
    'PageHandler_GetRecentTabs_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetRecentTabs_ResponseParamsMojoType {
  tabs: TabInfo[];
}


export type PageHandler_GetRecentTabs_ResponseParams = PageHandler_GetRecentTabs_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetRecentTabs_ResponseParamsMojoType>(
    PageHandler_GetRecentTabs_ResponseParamsSpec.$,
    'PageHandler_GetRecentTabs_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetRecentTabs_ResponseParamsMojoType, TabInfo[]>(
        'tabs', 0,
        0,
        mojo.internal.Array(TabInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetTabPreview_ParamsMojoType {
  tabId: number;
}


export type PageHandler_GetTabPreview_Params = PageHandler_GetTabPreview_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabPreview_ParamsMojoType>(
    PageHandler_GetTabPreview_ParamsSpec.$,
    'PageHandler_GetTabPreview_Params',
    [
      mojo.internal.StructField<PageHandler_GetTabPreview_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetTabPreview_ResponseParamsMojoType {
  previewDataUrl: (string | null);
}


export type PageHandler_GetTabPreview_ResponseParams = PageHandler_GetTabPreview_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTabPreview_ResponseParamsMojoType>(
    PageHandler_GetTabPreview_ResponseParamsSpec.$,
    'PageHandler_GetTabPreview_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTabPreview_ResponseParamsMojoType, string>(
        'previewDataUrl', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_NotifySessionStarted_ParamsMojoType {
}


export type PageHandler_NotifySessionStarted_Params = PageHandler_NotifySessionStarted_ParamsMojoType;
mojo.internal.Struct<PageHandler_NotifySessionStarted_ParamsMojoType>(
    PageHandler_NotifySessionStarted_ParamsSpec.$,
    'PageHandler_NotifySessionStarted_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_NotifySessionAbandoned_ParamsMojoType {
}


export type PageHandler_NotifySessionAbandoned_Params = PageHandler_NotifySessionAbandoned_ParamsMojoType;
mojo.internal.Struct<PageHandler_NotifySessionAbandoned_ParamsMojoType>(
    PageHandler_NotifySessionAbandoned_ParamsSpec.$,
    'PageHandler_NotifySessionAbandoned_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_AddFileContext_ParamsMojoType {
  fileInfo: SelectedFileInfo;
  fileBytes: mojoBase_mojom_BigBuffer;
}


export type PageHandler_AddFileContext_Params = PageHandler_AddFileContext_ParamsMojoType;
mojo.internal.Struct<PageHandler_AddFileContext_ParamsMojoType>(
    PageHandler_AddFileContext_ParamsSpec.$,
    'PageHandler_AddFileContext_Params',
    [
      mojo.internal.StructField<PageHandler_AddFileContext_ParamsMojoType, SelectedFileInfo>(
        'fileInfo', 0,
        0,
        SelectedFileInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_AddFileContext_ParamsMojoType, mojoBase_mojom_BigBuffer>(
        'fileBytes', 8,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_AddFileContext_ResponseParamsMojoType {
  token: mojoBase_mojom_UnguessableToken;
}


export type PageHandler_AddFileContext_ResponseParams = PageHandler_AddFileContext_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_AddFileContext_ResponseParamsMojoType>(
    PageHandler_AddFileContext_ResponseParamsSpec.$,
    'PageHandler_AddFileContext_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_AddFileContext_ResponseParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_AddTabContext_ParamsMojoType {
  tabId: number;
}


export type PageHandler_AddTabContext_Params = PageHandler_AddTabContext_ParamsMojoType;
mojo.internal.Struct<PageHandler_AddTabContext_ParamsMojoType>(
    PageHandler_AddTabContext_ParamsSpec.$,
    'PageHandler_AddTabContext_Params',
    [
      mojo.internal.StructField<PageHandler_AddTabContext_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_AddTabContext_ResponseParamsMojoType {
  token: (mojoBase_mojom_UnguessableToken | null);
}


export type PageHandler_AddTabContext_ResponseParams = PageHandler_AddTabContext_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_AddTabContext_ResponseParamsMojoType>(
    PageHandler_AddTabContext_ResponseParamsSpec.$,
    'PageHandler_AddTabContext_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_AddTabContext_ResponseParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DeleteContext_ParamsMojoType {
  token: mojoBase_mojom_UnguessableToken;
}


export type PageHandler_DeleteContext_Params = PageHandler_DeleteContext_ParamsMojoType;
mojo.internal.Struct<PageHandler_DeleteContext_ParamsMojoType>(
    PageHandler_DeleteContext_ParamsSpec.$,
    'PageHandler_DeleteContext_Params',
    [
      mojo.internal.StructField<PageHandler_DeleteContext_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ClearFiles_ParamsMojoType {
}


export type PageHandler_ClearFiles_Params = PageHandler_ClearFiles_ParamsMojoType;
mojo.internal.Struct<PageHandler_ClearFiles_ParamsMojoType>(
    PageHandler_ClearFiles_ParamsSpec.$,
    'PageHandler_ClearFiles_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_SubmitQuery_ParamsMojoType {
  queryText: string;
  mouseButton: number;
  altKey: boolean;
  ctrlKey: boolean;
  metaKey: boolean;
  shiftKey: boolean;
}


export type PageHandler_SubmitQuery_Params = PageHandler_SubmitQuery_ParamsMojoType;
mojo.internal.Struct<PageHandler_SubmitQuery_ParamsMojoType>(
    PageHandler_SubmitQuery_ParamsSpec.$,
    'PageHandler_SubmitQuery_Params',
    [
      mojo.internal.StructField<PageHandler_SubmitQuery_ParamsMojoType, string>(
        'queryText', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SubmitQuery_ParamsMojoType, number>(
        'mouseButton', 8,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SubmitQuery_ParamsMojoType, boolean>(
        'altKey', 9,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SubmitQuery_ParamsMojoType, boolean>(
        'ctrlKey', 9,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SubmitQuery_ParamsMojoType, boolean>(
        'metaKey', 9,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SubmitQuery_ParamsMojoType, boolean>(
        'shiftKey', 9,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_AutocompleteResultChanged_ParamsMojoType {
  result: AutocompleteResult;
}


export type Page_AutocompleteResultChanged_Params = Page_AutocompleteResultChanged_ParamsMojoType;
mojo.internal.Struct<Page_AutocompleteResultChanged_ParamsMojoType>(
    Page_AutocompleteResultChanged_ParamsSpec.$,
    'Page_AutocompleteResultChanged_Params',
    [
      mojo.internal.StructField<Page_AutocompleteResultChanged_ParamsMojoType, AutocompleteResult>(
        'result', 0,
        0,
        AutocompleteResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_UpdateSelection_ParamsMojoType {
  oldSelection: OmniboxPopupSelection;
  selection: OmniboxPopupSelection;
}


export type Page_UpdateSelection_Params = Page_UpdateSelection_ParamsMojoType;
mojo.internal.Struct<Page_UpdateSelection_ParamsMojoType>(
    Page_UpdateSelection_ParamsSpec.$,
    'Page_UpdateSelection_Params',
    [
      mojo.internal.StructField<Page_UpdateSelection_ParamsMojoType, OmniboxPopupSelection>(
        'oldSelection', 0,
        0,
        OmniboxPopupSelectionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_UpdateSelection_ParamsMojoType, OmniboxPopupSelection>(
        'selection', 8,
        0,
        OmniboxPopupSelectionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_SetInputText_ParamsMojoType {
  input: string;
}


export type Page_SetInputText_Params = Page_SetInputText_ParamsMojoType;
mojo.internal.Struct<Page_SetInputText_ParamsMojoType>(
    Page_SetInputText_ParamsSpec.$,
    'Page_SetInputText_Params',
    [
      mojo.internal.StructField<Page_SetInputText_ParamsMojoType, string>(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_SetThumbnail_ParamsMojoType {
  thumbnailUrl: string;
  isDeletable: boolean;
}


export type Page_SetThumbnail_Params = Page_SetThumbnail_ParamsMojoType;
mojo.internal.Struct<Page_SetThumbnail_ParamsMojoType>(
    Page_SetThumbnail_ParamsSpec.$,
    'Page_SetThumbnail_Params',
    [
      mojo.internal.StructField<Page_SetThumbnail_ParamsMojoType, string>(
        'thumbnailUrl', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_SetThumbnail_ParamsMojoType, boolean>(
        'isDeletable', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_OnContextualInputStatusChanged_ParamsMojoType {
  token: mojoBase_mojom_UnguessableToken;
  status: composeboxQuery_mojom_FileUploadStatus;
  errorType: (composeboxQuery_mojom_FileUploadErrorType | null);
}


export type Page_OnContextualInputStatusChanged_Params = Page_OnContextualInputStatusChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnContextualInputStatusChanged_ParamsMojoType>(
    Page_OnContextualInputStatusChanged_ParamsSpec.$,
    'Page_OnContextualInputStatusChanged_Params',
    [
      mojo.internal.StructField<Page_OnContextualInputStatusChanged_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'token', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnContextualInputStatusChanged_ParamsMojoType, composeboxQuery_mojom_FileUploadStatus>(
        'status', 8,
        0,
        composeboxQuery_mojom_FileUploadStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnContextualInputStatusChanged_ParamsMojoType, boolean>(
        'error_type_$flag', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "error_type_$value",
          originalFieldName: "errorType",
        },
        undefined,
    ),
      mojo.internal.StructField<Page_OnContextualInputStatusChanged_ParamsMojoType, composeboxQuery_mojom_FileUploadErrorType>(
        'error_type_$value', 16,
        0,
        composeboxQuery_mojom_FileUploadErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "errorType",
        },
        undefined,
    ),
    ],
    [[0, 32],]);





export interface Page_OnTabStripChanged_ParamsMojoType {
}


export type Page_OnTabStripChanged_Params = Page_OnTabStripChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnTabStripChanged_ParamsMojoType>(
    Page_OnTabStripChanged_ParamsSpec.$,
    'Page_OnTabStripChanged_Params',
    [
    ],
    [[0, 8],]);



