// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{isAndroid,isIOS}from"./platform.js";function getSupportedScaleFactors(){const supportedScaleFactors=[];if(!isIOS){supportedScaleFactors.push(1)}if(!isIOS&&!isAndroid){supportedScaleFactors.push(2)}else{supportedScaleFactors.push(window.devicePixelRatio)}return supportedScaleFactors}export function getUrlForCss(s){const s2=s.replace(/(\(|\)|\,|\s|\'|\"|\\)/g,"\\$1");return`url("${s2}")`}export function getFileIconUrl(filePath){const url=new URL("chrome://fileicon/");url.searchParams.set("path",filePath);url.searchParams.set("scale",window.devicePixelRatio+"x");return url.toString()}function getImageSet(path){const supportedScaleFactors=getSupportedScaleFactors();const replaceStartIndex=path.indexOf("SCALEFACTOR");if(replaceStartIndex<0){return getUrlForCss(path)}let s="";for(let i=0;i<supportedScaleFactors.length;++i){const scaleFactor=supportedScaleFactors[i];const pathWithScaleFactor=path.substr(0,replaceStartIndex)+scaleFactor+path.substr(replaceStartIndex+"scalefactor".length);s+=getUrlForCss(pathWithScaleFactor)+" "+scaleFactor+"x";if(i!==supportedScaleFactors.length-1){s+=", "}}return"image-set("+s+")"}export function getImage(path){const chromeThemePath="chrome://theme";const isChromeThemeUrl=path.slice(0,chromeThemePath.length)===chromeThemePath;return isChromeThemeUrl?getImageSet(path+"@SCALEFACTORx"):getUrlForCss(path)}function getBaseFaviconUrl(){const faviconUrl=new URL("chrome://favicon2/");faviconUrl.searchParams.set("size","16");faviconUrl.searchParams.set("scaleFactor","SCALEFACTORx");return faviconUrl}export function getFavicon(url){const faviconUrl=getBaseFaviconUrl();faviconUrl.searchParams.set("iconUrl",url);return getImageSet(faviconUrl.toString())}function getDefaultFaviconUrlParams(){return{isSyncedUrlForHistoryUi:false,remoteIconUrlForUma:"",size:16,forceLightMode:false,fallbackToHost:true,forceEmptyDefaultFavicon:false,scaleFactor:""}}export function getFaviconUrl(url,optionalParams){const params=Object.assign(getDefaultFaviconUrlParams(),optionalParams);const faviconUrl=getBaseFaviconUrl();faviconUrl.searchParams.set("pageUrl",url);faviconUrl.searchParams.set("size",params.size.toString());const fallback=params.isSyncedUrlForHistoryUi?"1":"0";faviconUrl.searchParams.set("allowGoogleServerFallback",fallback);if(params.isSyncedUrlForHistoryUi){faviconUrl.searchParams.set("iconUrl",params.remoteIconUrlForUma)}if(params.forceLightMode){faviconUrl.searchParams.set("forceLightMode","true")}if(!params.fallbackToHost){faviconUrl.searchParams.set("fallbackToHost","0")}if(params.forceEmptyDefaultFavicon){faviconUrl.searchParams.set("forceEmptyDefaultFavicon","1")}if(params.scaleFactor){faviconUrl.searchParams.set("scaleFactor",params.scaleFactor)}return faviconUrl.toString()}export function getFaviconForPageURL(url,isSyncedUrlForHistoryUi,remoteIconUrlForUma="",size=16,forceLightMode=false,fallbackToHost=true,forceEmptyDefaultFavicon=false,scaleFactor=""){return getImageSet(getFaviconUrl(url,{isSyncedUrlForHistoryUi:isSyncedUrlForHistoryUi,remoteIconUrlForUma:remoteIconUrlForUma,size:size,forceLightMode:forceLightMode,fallbackToHost:fallbackToHost,forceEmptyDefaultFavicon:forceEmptyDefaultFavicon,scaleFactor:scaleFactor}))}