// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../cr_icon_button/cr_icon_button.js";import"../icons.html.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{CrSearchFieldMixinLit}from"../cr_search_field/cr_search_field_mixin_lit.js";import{getCss}from"./cr_toolbar_search_field.css.js";import{getHtml}from"./cr_toolbar_search_field.html.js";const CrToolbarSearchFieldElementBase=CrSearchFieldMixinLit(CrLitElement);export class CrToolbarSearchFieldElement extends CrToolbarSearchFieldElementBase{static get is(){return"cr-toolbar-search-field"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{narrow:{type:Boolean,reflect:true},showingSearch:{type:Boolean,notify:true,reflect:true},disabled:{type:Boolean,reflect:true},autofocus:{type:Boolean,reflect:true},spinnerActive:{type:Boolean,reflect:true},searchFocused_:{type:Boolean,reflect:true},iconOverride:{type:String},inputAriaDescription:{type:String}}}#narrow_accessor_storage=false;get narrow(){return this.#narrow_accessor_storage}set narrow(value){this.#narrow_accessor_storage=value}#showingSearch_accessor_storage=false;get showingSearch(){return this.#showingSearch_accessor_storage}set showingSearch(value){this.#showingSearch_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#autofocus_accessor_storage=false;get autofocus(){return this.#autofocus_accessor_storage}set autofocus(value){this.#autofocus_accessor_storage=value}#spinnerActive_accessor_storage=false;get spinnerActive(){return this.#spinnerActive_accessor_storage}set spinnerActive(value){this.#spinnerActive_accessor_storage=value}#searchFocused__accessor_storage=false;get searchFocused_(){return this.#searchFocused__accessor_storage}set searchFocused_(value){this.#searchFocused__accessor_storage=value}#iconOverride_accessor_storage;get iconOverride(){return this.#iconOverride_accessor_storage}set iconOverride(value){this.#iconOverride_accessor_storage=value}#inputAriaDescription_accessor_storage="";get inputAriaDescription(){return this.#inputAriaDescription_accessor_storage}set inputAriaDescription(value){this.#inputAriaDescription_accessor_storage=value}firstUpdated(){this.addEventListener("click",(e=>this.showSearch_(e)))}getSearchInput(){return this.$.searchInput}isSearchFocused(){return this.searchFocused_}async showAndFocus(){this.showingSearch=true;await this.updateComplete;this.focus_()}onSearchTermNativeBeforeInput(e){this.fire("search-term-native-before-input",{e:e})}onSearchTermInput(){super.onSearchTermInput();this.showingSearch=this.hasSearchText||this.isSearchFocused()}onSearchTermNativeInput(e){this.onSearchTermInput();this.fire("search-term-native-input",{e:e,inputValue:this.getValue()})}getIconTabIndex_(){return this.narrow&&!this.hasSearchText?0:-1}getIconAriaHidden_(){return Boolean(!this.narrow||this.hasSearchText).toString()}shouldShowSpinner_(){return this.spinnerActive&&this.showingSearch}onSearchIconClicked_(){this.fire("search-icon-clicked")}focus_(){this.getSearchInput().focus()}onInputFocus_(){this.searchFocused_=true}onInputBlur_(){this.searchFocused_=false;if(!this.hasSearchText){this.showingSearch=false}}onSearchTermKeydown_(e){if(e.key==="Escape"){this.showingSearch=false;this.setValue("");this.getSearchInput().blur()}}async showSearch_(e){if(e.target!==this.shadowRoot.querySelector("#clearSearch")){this.showingSearch=true}if(this.narrow){await this.updateComplete;this.focus_()}}clearSearch_(){this.setValue("");this.focus_();this.spinnerActive=false;this.fire("search-term-cleared")}}customElements.define(CrToolbarSearchFieldElement.is,CrToolbarSearchFieldElement);