// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./searchbox_compose_button.js";import"./searchbox_dropdown.js";import"./searchbox_icon.js";import"./searchbox_thumbnail.js";import"//resources/cr_components/composebox/contextual_entrypoint_and_carousel.js";import"//resources/cr_components/composebox/error_scrim.js";import{ComposeboxMode}from"//resources/cr_components/composebox/contextual_entrypoint_and_carousel.js";import{I18nMixinLit}from"//resources/cr_elements/i18n_mixin_lit.js";import{WebUiListenerMixinLit}from"//resources/cr_elements/web_ui_listener_mixin_lit.js";import{assert}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{MetricsReporterImpl}from"//resources/js/metrics_reporter/metrics_reporter.js";import{hasKeyModifiers}from"//resources/js/util.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{NavigationPredictor}from"//resources/mojo/components/omnibox/browser/omnibox.mojom-webui.js";import{SideType}from"//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js";import{FileUploadStatus}from"//resources/mojo/components/omnibox/composebox/composebox_query.mojom-webui.js";import{getCss}from"./searchbox.css.js";import{getHtml}from"./searchbox.html.js";import{SearchboxBrowserProxy}from"./searchbox_browser_proxy.js";import{decodeString16,mojoString16}from"./utils.js";const LENS_GHOST_LOADER_TAG_NAME="cr-searchbox-ghost-loader";const DESKTOP_CHROME_NTP_REALBOX_ENTRY_POINT_VALUE="42";CSS.registerProperty({name:"--placeholder-opacity",syntax:"<number>",initialValue:"1",inherits:true});var AnimationState;(function(AnimationState){AnimationState[AnimationState["FADE_IN"]=0]="FADE_IN";AnimationState[AnimationState["HOLD"]=1]="HOLD";AnimationState[AnimationState["FADE_OUT"]=2]="FADE_OUT"})(AnimationState||(AnimationState={}));export class PlaceholderTextCycler{input_;animation_=null;placeholderTexts_=[];placeholderTextsCurrentIndex_=0;changePlaceholderTextIntervalMs_=4e3;fadePlaceholderTextDurationMs_=250;constructor(animatedPlaceholderContainer,placeholderTexts,changeTextAnimationIntervalMs,fadeTextAnimationDurationMs){assert(placeholderTexts.length>0);this.input_=animatedPlaceholderContainer;this.placeholderTexts_=placeholderTexts;this.changePlaceholderTextIntervalMs_=changeTextAnimationIntervalMs;this.fadePlaceholderTextDurationMs_=fadeTextAnimationDurationMs}start(){this.stop();this.placeholderTextsCurrentIndex_=0;this.animate_(AnimationState.HOLD)}stop(){if(this.animation_){this.animation_.cancel();this.animation_=null}this.placeholderTextsCurrentIndex_=0;this.input_.placeholder=this.placeholderTexts_[this.placeholderTextsCurrentIndex_]}animate_(state){let animationDetails=null;switch(state){case AnimationState.FADE_IN:this.input_.placeholder=this.placeholderTexts_[this.placeholderTextsCurrentIndex_];animationDetails={startOpacity:0,endOpacity:1,duration:this.fadePlaceholderTextDurationMs_,nextAnimationState:AnimationState.HOLD};break;case AnimationState.HOLD:animationDetails={startOpacity:1,endOpacity:1,duration:this.changePlaceholderTextIntervalMs_,nextAnimationState:AnimationState.FADE_OUT};break;case AnimationState.FADE_OUT:this.placeholderTextsCurrentIndex_=(this.placeholderTextsCurrentIndex_+1)%this.placeholderTexts_.length;animationDetails={startOpacity:1,endOpacity:0,duration:this.fadePlaceholderTextDurationMs_,nextAnimationState:AnimationState.FADE_IN};break}this.animation_=this.input_.animate([{"--placeholder-opacity":animationDetails.startOpacity},{"--placeholder-opacity":animationDetails.endOpacity}],{duration:animationDetails.duration});this.animation_.onfinish=()=>{if(this.animation_){this.animate_(animationDetails.nextAnimationState)}}}}const SearchboxElementBase=I18nMixinLit(WebUiListenerMixinLit(CrLitElement));export class SearchboxElement extends SearchboxElementBase{static get is(){return"cr-searchbox"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{canShowSecondarySide:{type:Boolean,reflect:true},colorSourceIsBaseline:{type:Boolean,reflect:true},dropdownIsVisible:{type:Boolean,reflect:true},hadSecondarySide:{type:Boolean,reflect:true,notify:true},hasSecondarySide:{type:Boolean,reflect:true},isDark:{type:Boolean,reflect:true},matchSearchbox:{type:Boolean,reflect:true},searchboxAriaDescription:{type:String},searchboxLensSearchEnabled:{type:Boolean,reflect:true},searchboxChromeRefreshTheming:{type:Boolean,reflect:true},searchboxSteadyStateShadow:{type:Boolean,reflect:true},realboxLayoutMode:{type:String,reflect:true},ntpRealboxNextEnabled:{type:Boolean,reflect:true},cyclingPlaceholders:{type:Boolean},composeboxEnabled:{type:Boolean},composeButtonEnabled:{type:Boolean},placeholderText:{type:String,reflect:true,notify:true},inputFocused_:{type:Boolean,reflect:true},isLensSearchbox_:{type:Boolean,reflect:true},enableThumbnailSizingTweaks_:{type:Boolean,reflect:true},isDeletingInput_:{type:Boolean},lastIgnoredEnterEvent_:{type:Object},lastInput_:{type:Object},lastQueriedInput_:{type:String},pastedInInput_:{type:Boolean},searchboxIcon_:{type:String},searchboxVoiceSearchEnabled_:{type:Boolean,reflect:true},searchboxLensSearchEnabled_:{type:Boolean,reflect:true},result_:{type:Object},selectedMatch_:{type:Object},selectedMatchIndex_:{type:Number},showThumbnail:{type:Boolean,reflect:true},thumbnailUrl_:{type:String},isThumbnailDeletable_:{type:Boolean},inputAriaLive_:{type:String},useWebkitSearchIcons_:{type:Boolean,reflect:true},tabSuggestions_:{type:Array}}}#canShowSecondarySide_accessor_storage=false;get canShowSecondarySide(){return this.#canShowSecondarySide_accessor_storage}set canShowSecondarySide(value){this.#canShowSecondarySide_accessor_storage=value}#colorSourceIsBaseline_accessor_storage=false;get colorSourceIsBaseline(){return this.#colorSourceIsBaseline_accessor_storage}set colorSourceIsBaseline(value){this.#colorSourceIsBaseline_accessor_storage=value}#dropdownIsVisible_accessor_storage=false;get dropdownIsVisible(){return this.#dropdownIsVisible_accessor_storage}set dropdownIsVisible(value){this.#dropdownIsVisible_accessor_storage=value}#hadSecondarySide_accessor_storage=false;get hadSecondarySide(){return this.#hadSecondarySide_accessor_storage}set hadSecondarySide(value){this.#hadSecondarySide_accessor_storage=value}#hasSecondarySide_accessor_storage=false;get hasSecondarySide(){return this.#hasSecondarySide_accessor_storage}set hasSecondarySide(value){this.#hasSecondarySide_accessor_storage=value}#isDark_accessor_storage=false;get isDark(){return this.#isDark_accessor_storage}set isDark(value){this.#isDark_accessor_storage=value}#matchSearchbox_accessor_storage=loadTimeData.getBoolean("searchboxMatchSearchboxTheme");get matchSearchbox(){return this.#matchSearchbox_accessor_storage}set matchSearchbox(value){this.#matchSearchbox_accessor_storage=value}#searchboxAriaDescription_accessor_storage="";get searchboxAriaDescription(){return this.#searchboxAriaDescription_accessor_storage}set searchboxAriaDescription(value){this.#searchboxAriaDescription_accessor_storage=value}#searchboxLensSearchEnabled_accessor_storage=loadTimeData.getBoolean("searchboxLensSearch");get searchboxLensSearchEnabled(){return this.#searchboxLensSearchEnabled_accessor_storage}set searchboxLensSearchEnabled(value){this.#searchboxLensSearchEnabled_accessor_storage=value}#searchboxChromeRefreshTheming_accessor_storage=loadTimeData.getBoolean("searchboxCr23Theming");get searchboxChromeRefreshTheming(){return this.#searchboxChromeRefreshTheming_accessor_storage}set searchboxChromeRefreshTheming(value){this.#searchboxChromeRefreshTheming_accessor_storage=value}#searchboxSteadyStateShadow_accessor_storage=loadTimeData.getBoolean("searchboxCr23SteadyStateShadow");get searchboxSteadyStateShadow(){return this.#searchboxSteadyStateShadow_accessor_storage}set searchboxSteadyStateShadow(value){this.#searchboxSteadyStateShadow_accessor_storage=value}#realboxLayoutMode_accessor_storage="";get realboxLayoutMode(){return this.#realboxLayoutMode_accessor_storage}set realboxLayoutMode(value){this.#realboxLayoutMode_accessor_storage=value}#ntpRealboxNextEnabled_accessor_storage=false;get ntpRealboxNextEnabled(){return this.#ntpRealboxNextEnabled_accessor_storage}set ntpRealboxNextEnabled(value){this.#ntpRealboxNextEnabled_accessor_storage=value}#cyclingPlaceholders_accessor_storage=false;get cyclingPlaceholders(){return this.#cyclingPlaceholders_accessor_storage}set cyclingPlaceholders(value){this.#cyclingPlaceholders_accessor_storage=value}#composeboxEnabled_accessor_storage=false;get composeboxEnabled(){return this.#composeboxEnabled_accessor_storage}set composeboxEnabled(value){this.#composeboxEnabled_accessor_storage=value}#composeButtonEnabled_accessor_storage=false;get composeButtonEnabled(){return this.#composeButtonEnabled_accessor_storage}set composeButtonEnabled(value){this.#composeButtonEnabled_accessor_storage=value}#showThumbnail_accessor_storage=false;get showThumbnail(){return this.#showThumbnail_accessor_storage}set showThumbnail(value){this.#showThumbnail_accessor_storage=value}#placeholderText_accessor_storage="";get placeholderText(){return this.#placeholderText_accessor_storage}set placeholderText(value){this.#placeholderText_accessor_storage=value}#inputAriaLive__accessor_storage="";get inputAriaLive_(){return this.#inputAriaLive__accessor_storage}set inputAriaLive_(value){this.#inputAriaLive__accessor_storage=value}#inputFocused__accessor_storage=false;get inputFocused_(){return this.#inputFocused__accessor_storage}set inputFocused_(value){this.#inputFocused__accessor_storage=value}#isLensSearchbox__accessor_storage=loadTimeData.getBoolean("isLensSearchbox");get isLensSearchbox_(){return this.#isLensSearchbox__accessor_storage}set isLensSearchbox_(value){this.#isLensSearchbox__accessor_storage=value}#enableThumbnailSizingTweaks__accessor_storage=loadTimeData.getBoolean("enableThumbnailSizingTweaks");get enableThumbnailSizingTweaks_(){return this.#enableThumbnailSizingTweaks__accessor_storage}set enableThumbnailSizingTweaks_(value){this.#enableThumbnailSizingTweaks__accessor_storage=value}#isDeletingInput__accessor_storage=false;get isDeletingInput_(){return this.#isDeletingInput__accessor_storage}set isDeletingInput_(value){this.#isDeletingInput__accessor_storage=value}#lastIgnoredEnterEvent__accessor_storage=null;get lastIgnoredEnterEvent_(){return this.#lastIgnoredEnterEvent__accessor_storage}set lastIgnoredEnterEvent_(value){this.#lastIgnoredEnterEvent__accessor_storage=value}#lastInput__accessor_storage={text:"",inline:""};get lastInput_(){return this.#lastInput__accessor_storage}set lastInput_(value){this.#lastInput__accessor_storage=value}#lastQueriedInput__accessor_storage=null;get lastQueriedInput_(){return this.#lastQueriedInput__accessor_storage}set lastQueriedInput_(value){this.#lastQueriedInput__accessor_storage=value}#pastedInInput__accessor_storage=false;get pastedInInput_(){return this.#pastedInInput__accessor_storage}set pastedInInput_(value){this.#pastedInInput__accessor_storage=value}#searchboxIcon__accessor_storage=loadTimeData.getString("searchboxDefaultIcon");get searchboxIcon_(){return this.#searchboxIcon__accessor_storage}set searchboxIcon_(value){this.#searchboxIcon__accessor_storage=value}#searchboxVoiceSearchEnabled__accessor_storage=loadTimeData.getBoolean("searchboxVoiceSearch");get searchboxVoiceSearchEnabled_(){return this.#searchboxVoiceSearchEnabled__accessor_storage}set searchboxVoiceSearchEnabled_(value){this.#searchboxVoiceSearchEnabled__accessor_storage=value}#searchboxLensSearchEnabled__accessor_storage=loadTimeData.getBoolean("searchboxLensSearch");get searchboxLensSearchEnabled_(){return this.#searchboxLensSearchEnabled__accessor_storage}set searchboxLensSearchEnabled_(value){this.#searchboxLensSearchEnabled__accessor_storage=value}#result__accessor_storage=null;get result_(){return this.#result__accessor_storage}set result_(value){this.#result__accessor_storage=value}#selectedMatch__accessor_storage=null;get selectedMatch_(){return this.#selectedMatch__accessor_storage}set selectedMatch_(value){this.#selectedMatch__accessor_storage=value}#selectedMatchIndex__accessor_storage=-1;get selectedMatchIndex_(){return this.#selectedMatchIndex__accessor_storage}set selectedMatchIndex_(value){this.#selectedMatchIndex__accessor_storage=value}#thumbnailUrl__accessor_storage="";get thumbnailUrl_(){return this.#thumbnailUrl__accessor_storage}set thumbnailUrl_(value){this.#thumbnailUrl__accessor_storage=value}#isThumbnailDeletable__accessor_storage=false;get isThumbnailDeletable_(){return this.#isThumbnailDeletable__accessor_storage}set isThumbnailDeletable_(value){this.#isThumbnailDeletable__accessor_storage=value}#useWebkitSearchIcons__accessor_storage=false;get useWebkitSearchIcons_(){return this.#useWebkitSearchIcons__accessor_storage}set useWebkitSearchIcons_(value){this.#useWebkitSearchIcons__accessor_storage=value}#tabSuggestions__accessor_storage=[];get tabSuggestions_(){return this.#tabSuggestions__accessor_storage}set tabSuggestions_(value){this.#tabSuggestions__accessor_storage=value}pageHandler_;callbackRouter_;autocompleteResultChangedListenerId_=null;inputTextChangedListenerId_=null;thumbnailChangedListenerId_=null;onTabStripChangedListenerId_=null;placeholderCycler_=null;constructor(){performance.mark("realbox-creation-start");super();this.pageHandler_=SearchboxBrowserProxy.getInstance().handler;this.callbackRouter_=SearchboxBrowserProxy.getInstance().callbackRouter}async connectedCallback(){super.connectedCallback();this.autocompleteResultChangedListenerId_=this.callbackRouter_.autocompleteResultChanged.addListener(this.onAutocompleteResultChanged_.bind(this));this.inputTextChangedListenerId_=this.callbackRouter_.setInputText.addListener(this.onSetInputText_.bind(this));this.thumbnailChangedListenerId_=this.callbackRouter_.setThumbnail.addListener(this.onSetThumbnail_.bind(this));this.onTabStripChangedListenerId_=this.callbackRouter_.onTabStripChanged.addListener(this.refreshTabSuggestions_.bind(this));if(this.cyclingPlaceholders){const{config:config}=await this.pageHandler_.getPlaceholderConfig();const texts=config.texts.map((text=>decodeString16(text)));assert(texts[0]);this.placeholderText=texts[0];this.placeholderCycler_=new PlaceholderTextCycler(this.$.input,texts,Number(config.changeTextAnimationInterval.microseconds/1000n),Number(config.fadeTextAnimationDuration.microseconds/1000n));this.placeholderCycler_.start()}if(this.ntpRealboxNextEnabled){this.refreshTabSuggestions_()}}disconnectedCallback(){super.disconnectedCallback();assert(this.autocompleteResultChangedListenerId_);this.callbackRouter_.removeListener(this.autocompleteResultChangedListenerId_);assert(this.inputTextChangedListenerId_);this.callbackRouter_.removeListener(this.inputTextChangedListenerId_);assert(this.thumbnailChangedListenerId_);this.callbackRouter_.removeListener(this.thumbnailChangedListenerId_);assert(this.onTabStripChangedListenerId_);this.callbackRouter_.removeListener(this.onTabStripChangedListenerId_);this.placeholderCycler_?.stop()}firstUpdated(){performance.measure("realbox-creation","realbox-creation-start")}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("composeButtonEnabled")||changedProperties.has("searchboxChromeRefreshTheming")||changedProperties.has("colorSourceIsBaseline")){this.useWebkitSearchIcons_=this.composeButtonEnabled||this.searchboxChromeRefreshTheming&&!this.colorSourceIsBaseline}const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("result_")||changedPrivateProperties.has("selectedMatchIndex_")){this.selectedMatch_=this.computeSelectedMatch_()}if(changedPrivateProperties.has("selectedMatch_")){this.inputAriaLive_=this.computeInputAriaLive_()}if(changedPrivateProperties.has("thumbnailUrl_")){this.showThumbnail=!!this.thumbnailUrl_}if(this.ntpRealboxNextEnabled){if(changedPrivateProperties.has("dropdownIsVisible")){this.dispatchEvent(new CustomEvent("dropdown-visible-changed",{bubbles:true,composed:true,detail:{value:this.dropdownIsVisible}}))}if(changedPrivateProperties.has("inputFocused_")){this.fire("searchbox-input-focus-changed",{value:this.inputFocused_})}}}computeInputAriaLive_(){return this.selectedMatch_?"off":"polite"}getSuggestionsElement(){return this.$.matches}isInputEmpty(){return!this.$.input.value.trim()}queryAutocomplete(){if(this.dropdownIsVisible){return}this.queryAutocomplete_(this.$.input.value)}setInputText(text){this.onSetInputText_(text)}focusInput(){this.$.input.focus()}selectAll(){this.$.input.select()}async onAutocompleteResultChanged_(result){if(this.lastQueriedInput_===null||this.lastQueriedInput_.trimStart()!==decodeString16(result.input)){return}this.result_=result;const hasMatches=result?.matches?.length>0;const hasPrimaryMatches=result?.matches?.some((match=>{const sideType=result.suggestionGroupsMap[match.suggestionGroupId]?.sideType||SideType.kDefaultPrimary;return sideType===SideType.kDefaultPrimary}));this.dropdownIsVisible=hasPrimaryMatches;const firstMatch=hasMatches?this.result_.matches[0]:null;if(firstMatch&&firstMatch.allowedToBeDefaultMatch){this.$.matches.selectFirst();this.updateInput_({text:this.lastQueriedInput_,inline:decodeString16(firstMatch.inlineAutocompletion)||""});if(this.lastIgnoredEnterEvent_){this.navigateToMatch_(0,this.lastIgnoredEnterEvent_);this.lastIgnoredEnterEvent_=null}}else if(this.$.input.value.trim()&&hasMatches&&this.selectedMatchIndex_>=0&&this.selectedMatchIndex_<this.result_.matches.length){await this.$.matches.selectIndex(this.selectedMatchIndex_);this.updateInput_({text:decodeString16(this.selectedMatch_.fillIntoEdit),inline:"",moveCursorToEnd:true})}else{this.$.matches.unselect();this.updateInput_({inline:""})}}onSetInputText_(inputText){this.updateInput_({text:inputText,inline:""})}onSetThumbnail_(thumbnailUrl,isDeletable){this.thumbnailUrl_=thumbnailUrl;this.isThumbnailDeletable_=isDeletable}onInputCutCopy_(e){if(!this.$.input.value||this.$.input.selectionStart!==0||this.$.input.selectionEnd!==this.$.input.value.length||!this.result_||this.result_.matches.length===0){return}if(this.selectedMatch_&&!this.selectedMatch_.isSearchType){e.clipboardData.setData("text/plain",this.selectedMatch_.destinationUrl.url);e.preventDefault();if(e.type==="cut"){this.updateInput_({text:"",inline:""});this.clearAutocompleteMatches_()}}}onInputFocus_(){this.inputFocused_=true;this.pageHandler_.onFocusChanged(true);this.placeholderCycler_?.stop()}onInputInput_(e){const inputValue=this.$.input.value;const lastInputValue=this.lastInput_.text+this.lastInput_.inline;if(lastInputValue===inputValue){return}this.updateInput_({text:inputValue,inline:""});if(loadTimeData.getBoolean("reportMetrics")){const charTyped=!this.isDeletingInput_&&!!inputValue.trim();const metricsReporter=MetricsReporterImpl.getInstance();if(charTyped){if(!metricsReporter.hasLocalMark("CharTyped")){metricsReporter.mark("CharTyped")}}else{metricsReporter.clearMark("CharTyped")}}if(inputValue.trim()||this.isLensSearchbox_){this.queryAutocomplete_(inputValue,e.isComposing)}else{this.clearAutocompleteMatches_()}this.pastedInInput_=false}onInputKeydown_(e){if(!this.lastInput_.inline){return}const inputValue=this.$.input.value;const inputSelection=inputValue.substring(this.$.input.selectionStart,this.$.input.selectionEnd);const lastInputValue=this.lastInput_.text+this.lastInput_.inline;if(inputSelection===this.lastInput_.inline&&inputValue===lastInputValue&&this.lastInput_.inline[0].toLocaleLowerCase()===e.key.toLocaleLowerCase()){const text=this.lastInput_.text+e.key;assert(text);this.updateInput_({text:text,inline:this.lastInput_.inline.substr(1)});if(loadTimeData.getBoolean("reportMetrics")){const metricsReporter=MetricsReporterImpl.getInstance();if(!metricsReporter.hasLocalMark("CharTyped")){metricsReporter.mark("CharTyped")}}this.queryAutocomplete_(this.lastInput_.text);e.preventDefault()}}onInputKeyup_(e){if(e.key!=="Tab"||this.dropdownIsVisible){return}if(!this.$.input.value||this.showThumbnail){this.queryAutocomplete_(this.$.input.value)}}onInputMouseDown_(e){if(e.button!==0){return}if(this.dropdownIsVisible){return}this.queryAutocomplete_(this.$.input.value)}onInputPaste_(){this.pastedInInput_=true}onInputWrapperFocusout_(e){const newlyFocusedEl=e.relatedTarget;if(this.$.inputWrapper.contains(newlyFocusedEl)){return}if(this.isLensSearchbox_&&newlyFocusedEl?.tagName.toLowerCase()===LENS_GHOST_LOADER_TAG_NAME){return}this.inputFocused_=false;if(this.lastQueriedInput_===""){this.updateInput_({text:"",inline:""});this.clearAutocompleteMatches_()}else{this.dropdownIsVisible=false;this.pageHandler_.stopAutocomplete(false)}this.pageHandler_.onFocusChanged(false);this.placeholderCycler_?.start()}async onInputWrapperKeydown_(e){const KEYDOWN_HANDLED_KEYS=["ArrowDown","ArrowUp","Backspace","Delete","Enter","Escape","PageDown","PageUp","Tab"];if(!KEYDOWN_HANDLED_KEYS.includes(e.key)){return}if(e.defaultPrevented){return}if(this.showThumbnail){const thumbnail=this.shadowRoot.querySelector("cr-searchbox-thumbnail");if(thumbnail===this.shadowRoot.activeElement){if(e.key==="Backspace"||e.key==="Enter"){this.thumbnailUrl_="";this.$.input.focus();this.clearAutocompleteMatches_();this.pageHandler_.onThumbnailRemoved();const inputValue=this.$.input.value;this.queryAutocomplete_(inputValue);e.preventDefault()}else if(e.key==="Tab"&&!e.shiftKey){this.$.input.focus();e.preventDefault()}else if(this.dropdownIsVisible&&(e.key==="ArrowUp"||e.key==="ArrowDown")){this.$.input.focus()}}else if(this.isThumbnailDeletable_&&this.$.input.selectionStart===0&&this.$.input.selectionEnd===0&&this.$.input===this.shadowRoot.activeElement&&(e.key==="Backspace"||e.key==="Tab"&&e.shiftKey)){thumbnail?.focus();e.preventDefault()}}if(e.key==="Backspace"||e.key==="Tab"){return}if(!this.dropdownIsVisible){if(e.key==="ArrowUp"||e.key==="ArrowDown"){const inputValue=this.$.input.value;if(inputValue.trim()||!inputValue){this.queryAutocomplete_(inputValue)}e.preventDefault();return}}if(e.key==="Escape"){this.dispatchEvent(new CustomEvent("escape-searchbox",{bubbles:true,composed:true,detail:{event:e,emptyInput:!this.$.input.value}}))}if(!this.result_||this.result_.matches.length===0){return}if(e.key==="Delete"){if(e.shiftKey&&!e.altKey&&!e.ctrlKey&&!e.metaKey){if(this.selectedMatch_&&this.selectedMatch_.supportsDeletion){this.pageHandler_.deleteAutocompleteMatch(this.selectedMatchIndex_,this.selectedMatch_.destinationUrl);e.preventDefault()}}return}if(e.isComposing){return}if(e.key==="Enter"){const array=[this.$.matches,this.$.input];if(array.includes(e.target)){if(this.lastQueriedInput_!==null&&this.lastQueriedInput_.trimStart()===decodeString16(this.result_.input)){if(this.selectedMatch_){this.navigateToMatch_(this.selectedMatchIndex_,e)}}else{this.lastIgnoredEnterEvent_=e;e.preventDefault()}}return}if(hasKeyModifiers(e)){return}if(e.key==="Escape"&&this.selectedMatchIndex_<=0){this.updateInput_({text:"",inline:""});this.clearAutocompleteMatches_();e.preventDefault();return}e.preventDefault();if(e.key==="ArrowDown"){await this.$.matches.selectNext();this.pageHandler_.onNavigationLikely(this.selectedMatchIndex_,this.selectedMatch_.destinationUrl,NavigationPredictor.kUpOrDownArrowButton)}else if(e.key==="ArrowUp"){await this.$.matches.selectPrevious();this.pageHandler_.onNavigationLikely(this.selectedMatchIndex_,this.selectedMatch_.destinationUrl,NavigationPredictor.kUpOrDownArrowButton)}else if(e.key==="Escape"||e.key==="PageUp"){await this.$.matches.selectFirst()}else if(e.key==="PageDown"){await this.$.matches.selectLast()}if(this.shadowRoot.activeElement===this.$.matches){this.$.matches.focusSelected()}const newFill=decodeString16(this.selectedMatch_.fillIntoEdit);const newInline=this.selectedMatchIndex_===0&&this.selectedMatch_.allowedToBeDefaultMatch?decodeString16(this.selectedMatch_.inlineAutocompletion):"";const newFillEnd=newFill.length-newInline.length;const text=newFill.substr(0,newFillEnd);assert(text);this.updateInput_({text:text,inline:newInline,moveCursorToEnd:newInline.length===0})}async onMatchFocusin_(e){await this.$.matches.selectIndex(e.detail);this.updateInput_({text:decodeString16(this.selectedMatch_.fillIntoEdit),inline:"",moveCursorToEnd:true})}onMatchClick_(){this.clearAutocompleteMatches_()}onVoiceSearchClick_(){this.dispatchEvent(new Event("open-voice-search"))}onLensSearchClick_(){this.dropdownIsVisible=false;this.dispatchEvent(new Event("open-lens-search"))}addFileContext_(e){const composeboxFiles=[];for(const file of e.detail.files){const attachment={uuid:"fake-uuid",name:file.name,objectUrl:e.detail.isImage?URL.createObjectURL(file):null,type:file.type,status:FileUploadStatus.kNotUploaded,url:null,file:file,tabId:null};composeboxFiles.push(attachment)}this.openComposebox_(composeboxFiles)}addTabContext_(e){const attachment={uuid:"fake-uuid",name:e.detail.title,objectUrl:null,type:"tab",status:FileUploadStatus.kNotUploaded,url:e.detail.url,file:null,tabId:e.detail.id};this.openComposebox_([attachment])}async refreshTabSuggestions_(){const{tabs:tabs}=await this.pageHandler_.getRecentTabs();this.tabSuggestions_=[...tabs]}onFileValidationError_(e){this.$.errorScrim.setErrorMessage(e.detail.errorMessage)}async getTabPreview_(e){const{previewDataUrl:previewDataUrl}=await this.pageHandler_.getTabPreview(e.detail.tabId);e.detail.onPreviewFetched(previewDataUrl||"")}onComposeButtonClick_(e){if(!this.composeboxEnabled||this.$.input.value.trim()){const searchParams=new URLSearchParams;searchParams.append("sourceid","chrome");searchParams.append("udm","50");searchParams.append("aep",DESKTOP_CHROME_NTP_REALBOX_ENTRY_POINT_VALUE);if(this.$.input.value.trim()){searchParams.append("q",this.$.input.value.trim())}const queryUrl=new URL("/search",loadTimeData.getString("googleBaseUrl"));queryUrl.search=searchParams.toString();const href=queryUrl.href;if(e.detail.ctrlKey||e.detail.metaKey){window.open(href,"_blank")}else if(e.detail.shiftKey){window.open(href,"_blank","noopener")}else{window.open(href,"_self")}}else{this.openComposebox_()}chrome.metricsPrivate.recordBoolean("NewTabPage.ComposeEntrypoint.Click.UserTextPresent",!this.isInputEmpty())}setDeepSearchMode_(){this.openComposebox_([],ComposeboxMode.DEEP_SEARCH)}setCreateImageMode_(){this.openComposebox_([],ComposeboxMode.CREATE_IMAGE)}openComposebox_(files=[],mode=ComposeboxMode.DEFAULT){this.dispatchEvent(new CustomEvent("open-composebox",{detail:{searchboxText:this.$.input.value,contextFiles:files,mode:mode},bubbles:true,composed:true}));this.setInputText("")}hasThumbnail(){return!!this.thumbnailUrl_}onRemoveThumbnailClick_(){this.thumbnailUrl_="";this.$.input.focus();this.clearAutocompleteMatches_();this.pageHandler_.onThumbnailRemoved();const inputValue=this.$.input.value;this.queryAutocomplete_(inputValue)}computeSelectedMatch_(){if(!this.result_||!this.result_.matches){return null}return this.result_.matches[this.selectedMatchIndex_]||null}computePlaceholderText_(placeholderText){if(placeholderText){return placeholderText}return this.showThumbnail?this.i18n("searchBoxHintMultimodal"):this.i18n("searchBoxHint")}clearAutocompleteMatches_(){this.dropdownIsVisible=false;this.result_=null;this.$.matches.unselect();this.pageHandler_.stopAutocomplete(true);this.lastQueriedInput_=null}navigateToMatch_(matchIndex,e){assert(matchIndex>=0);const match=this.result_.matches[matchIndex];assert(match);this.pageHandler_.openAutocompleteMatch(matchIndex,match.destinationUrl,this.dropdownIsVisible,e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey);this.updateInput_({text:decodeString16(match.fillIntoEdit),inline:"",moveCursorToEnd:true});this.clearAutocompleteMatches_();e.preventDefault()}queryAutocomplete_(input,preventInlineAutocomplete=false){this.lastQueriedInput_=input;const caretNotAtEnd=this.$.input.selectionStart!==input.length;preventInlineAutocomplete=preventInlineAutocomplete||this.isDeletingInput_||this.pastedInInput_||caretNotAtEnd;this.pageHandler_.queryAutocomplete(mojoString16(input),preventInlineAutocomplete);this.dispatchEvent(new CustomEvent("query-autocomplete",{bubbles:true,composed:true,detail:{inputValue:input}}))}updateInput_(update){const newInput=Object.assign({},this.lastInput_,update);const newInputValue=newInput.text+newInput.inline;const lastInputValue=this.lastInput_.text+this.lastInput_.inline;const inlineDiffers=newInput.inline!==this.lastInput_.inline;const preserveSelection=!inlineDiffers&&!update.moveCursorToEnd;let needsSelectionUpdate=!preserveSelection;const oldSelectionStart=this.$.input.selectionStart;const oldSelectionEnd=this.$.input.selectionEnd;if(newInputValue!==this.$.input.value){this.$.input.value=newInputValue;needsSelectionUpdate=true}if(newInputValue.trim()&&needsSelectionUpdate){this.$.input.selectionStart=preserveSelection?oldSelectionStart:update.moveCursorToEnd?newInputValue.length:newInput.text.length;this.$.input.selectionEnd=preserveSelection?oldSelectionEnd:newInputValue.length}this.isDeletingInput_=lastInputValue.length>newInputValue.length&&lastInputValue.startsWith(newInputValue);this.lastInput_=newInput}getThumbnailTabindex_(){return this.isThumbnailDeletable_?"1":""}onSelectedMatchIndexChanged_(e){this.selectedMatchIndex_=e.detail.value}onHadSecondarySideChanged_(e){this.hadSecondarySide=e.detail.value}onHasSecondarySideChanged_(e){this.hasSecondarySide=e.detail.value}}customElements.define(SearchboxElement.is,SearchboxElement);