// ui/webui/resources/cr_components/history/history.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/cr_components/history/history.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/history/history.mojom-params-data.h"
#include "ui/webui/resources/cr_components/history/history.mojom-shared-message-ids.h"

#include "ui/webui/resources/cr_components/history/history.mojom-import-headers.h"
#include "ui/webui/resources/cr_components/history/history.mojom-test-utils.h"


namespace history::mojom {
QueryState::QueryState()
    : incremental(),
      querying(),
      search_term(),
      after() {}

QueryState::QueryState(
    bool incremental_in,
    bool querying_in,
    const std::string& search_term_in,
    const std::optional<std::string>& after_in)
    : incremental(std::move(incremental_in)),
      querying(std::move(querying_in)),
      search_term(std::move(search_term_in)),
      after(std::move(after_in)) {}

QueryState::~QueryState() = default;

void QueryState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "incremental"), this->incremental,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "querying"), this->querying,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "search_term"), this->search_term,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "after"), this->after,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool QueryState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HistoryQuery::HistoryQuery()
    : term(),
      finished() {}

HistoryQuery::HistoryQuery(
    const std::string& term_in,
    bool finished_in)
    : term(std::move(term_in)),
      finished(std::move(finished_in)) {}

HistoryQuery::~HistoryQuery() = default;
size_t HistoryQuery::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->term);
  seed = mojo::internal::Hash(seed, this->finished);
  return seed;
}

void HistoryQuery::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "term"), this->term,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "finished"), this->finished,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HistoryQuery::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DebugInfo::DebugInfo()
    : is_url_in_local_database(),
      visit_count(),
      typed_count() {}

DebugInfo::DebugInfo(
    bool is_url_in_local_database_in,
    uint32_t visit_count_in,
    uint32_t typed_count_in)
    : is_url_in_local_database(std::move(is_url_in_local_database_in)),
      visit_count(std::move(visit_count_in)),
      typed_count(std::move(typed_count_in)) {}

DebugInfo::~DebugInfo() = default;
size_t DebugInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->is_url_in_local_database);
  seed = mojo::internal::Hash(seed, this->visit_count);
  seed = mojo::internal::Hash(seed, this->typed_count);
  return seed;
}

void DebugInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_url_in_local_database"), this->is_url_in_local_database,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visit_count"), this->visit_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "typed_count"), this->typed_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DebugInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HistoryEntry::HistoryEntry()
    : url(),
      title(),
      domain(),
      fallback_favicon_text(),
      time(),
      all_timestamps(),
      date_short(),
      device_name(),
      device_type(),
      date_time_of_day(),
      date_relative_day(),
      selected(),
      readableTimestamp(),
      snippet(),
      starred(),
      host_filtering_behavior(),
      blocked_visit(),
      is_url_in_remote_user_data(),
      is_actor_visit(),
      remote_icon_url_for_uma(),
      debug() {}

HistoryEntry::HistoryEntry(
    const std::string& url_in,
    const std::string& title_in,
    const std::string& domain_in,
    const std::string& fallback_favicon_text_in,
    double time_in,
    std::vector<double> all_timestamps_in,
    const std::string& date_short_in,
    const std::string& device_name_in,
    const std::string& device_type_in,
    const std::string& date_time_of_day_in,
    const std::string& date_relative_day_in,
    bool selected_in,
    const std::string& readableTimestamp_in,
    const std::string& snippet_in,
    bool starred_in,
    FilteringBehavior host_filtering_behavior_in,
    bool blocked_visit_in,
    bool is_url_in_remote_user_data_in,
    bool is_actor_visit_in,
    const std::string& remote_icon_url_for_uma_in,
    DebugInfoPtr debug_in)
    : url(std::move(url_in)),
      title(std::move(title_in)),
      domain(std::move(domain_in)),
      fallback_favicon_text(std::move(fallback_favicon_text_in)),
      time(std::move(time_in)),
      all_timestamps(std::move(all_timestamps_in)),
      date_short(std::move(date_short_in)),
      device_name(std::move(device_name_in)),
      device_type(std::move(device_type_in)),
      date_time_of_day(std::move(date_time_of_day_in)),
      date_relative_day(std::move(date_relative_day_in)),
      selected(std::move(selected_in)),
      readableTimestamp(std::move(readableTimestamp_in)),
      snippet(std::move(snippet_in)),
      starred(std::move(starred_in)),
      host_filtering_behavior(std::move(host_filtering_behavior_in)),
      blocked_visit(std::move(blocked_visit_in)),
      is_url_in_remote_user_data(std::move(is_url_in_remote_user_data_in)),
      is_actor_visit(std::move(is_actor_visit_in)),
      remote_icon_url_for_uma(std::move(remote_icon_url_for_uma_in)),
      debug(std::move(debug_in)) {}

HistoryEntry::~HistoryEntry() = default;

void HistoryEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain"), this->domain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fallback_favicon_text"), this->fallback_favicon_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_timestamps"), this->all_timestamps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<double>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "date_short"), this->date_short,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_name"), this->device_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_type"), this->device_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "date_time_of_day"), this->date_time_of_day,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "date_relative_day"), this->date_relative_day,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected"), this->selected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "readableTimestamp"), this->readableTimestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "snippet"), this->snippet,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "starred"), this->starred,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_filtering_behavior"), this->host_filtering_behavior,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FilteringBehavior>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked_visit"), this->blocked_visit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_url_in_remote_user_data"), this->is_url_in_remote_user_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_actor_visit"), this->is_actor_visit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_icon_url_for_uma"), this->remote_icon_url_for_uma,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug"), this->debug,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DebugInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HistoryEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
QueryResult::QueryResult()
    : info(),
      value() {}

QueryResult::QueryResult(
    HistoryQueryPtr info_in,
    std::vector<HistoryEntryPtr> value_in)
    : info(std::move(info_in)),
      value(std::move(value_in)) {}

QueryResult::~QueryResult() = default;

void QueryResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HistoryQueryPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<HistoryEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool QueryResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RemovalItem::RemovalItem()
    : url(),
      timestamps() {}

RemovalItem::RemovalItem(
    const std::string& url_in,
    std::vector<double> timestamps_in)
    : url(std::move(url_in)),
      timestamps(std::move(timestamps_in)) {}

RemovalItem::~RemovalItem() = default;

void RemovalItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamps"), this->timestamps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<double>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RemovalItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AccountInfo::AccountInfo()
    : account_image_src(),
      name(),
      email() {}

AccountInfo::AccountInfo(
    const ::GURL& account_image_src_in,
    const std::string& name_in,
    const std::string& email_in)
    : account_image_src(std::move(account_image_src_in)),
      name(std::move(name_in)),
      email(std::move(email_in)) {}

AccountInfo::~AccountInfo() = default;

void AccountInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "account_image_src"), this->account_image_src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "email"), this->email,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AccountInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kSetPage: {
      return &PageHandler::SetPage_Sym::IPCStableHash;
    }
    case messages::PageHandler::kQueryHistory: {
      return &PageHandler::QueryHistory_Sym::IPCStableHash;
    }
    case messages::PageHandler::kQueryHistoryContinuation: {
      return &PageHandler::QueryHistoryContinuation_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRemoveVisits: {
      return &PageHandler::RemoveVisits_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenClearBrowsingDataDialog: {
      return &PageHandler::OpenClearBrowsingDataDialog_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRemoveBookmark: {
      return &PageHandler::RemoveBookmark_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetLastSelectedTab: {
      return &PageHandler::SetLastSelectedTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowSidePanelUI: {
      return &PageHandler::ShowSidePanelUI_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRequestAccountInfo: {
      return &PageHandler::RequestAccountInfo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kTurnOnHistorySync: {
      return &PageHandler::TurnOnHistorySync_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kSetPage:
            return "Receive history::mojom::PageHandler::SetPage";
      case messages::PageHandler::kQueryHistory:
            return "Receive history::mojom::PageHandler::QueryHistory";
      case messages::PageHandler::kQueryHistoryContinuation:
            return "Receive history::mojom::PageHandler::QueryHistoryContinuation";
      case messages::PageHandler::kRemoveVisits:
            return "Receive history::mojom::PageHandler::RemoveVisits";
      case messages::PageHandler::kOpenClearBrowsingDataDialog:
            return "Receive history::mojom::PageHandler::OpenClearBrowsingDataDialog";
      case messages::PageHandler::kRemoveBookmark:
            return "Receive history::mojom::PageHandler::RemoveBookmark";
      case messages::PageHandler::kSetLastSelectedTab:
            return "Receive history::mojom::PageHandler::SetLastSelectedTab";
      case messages::PageHandler::kShowSidePanelUI:
            return "Receive history::mojom::PageHandler::ShowSidePanelUI";
      case messages::PageHandler::kRequestAccountInfo:
            return "Receive history::mojom::PageHandler::RequestAccountInfo";
      case messages::PageHandler::kTurnOnHistorySync:
            return "Receive history::mojom::PageHandler::TurnOnHistorySync";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kSetPage:
            return "Receive reply history::mojom::PageHandler::SetPage";
      case messages::PageHandler::kQueryHistory:
            return "Receive reply history::mojom::PageHandler::QueryHistory";
      case messages::PageHandler::kQueryHistoryContinuation:
            return "Receive reply history::mojom::PageHandler::QueryHistoryContinuation";
      case messages::PageHandler::kRemoveVisits:
            return "Receive reply history::mojom::PageHandler::RemoveVisits";
      case messages::PageHandler::kOpenClearBrowsingDataDialog:
            return "Receive reply history::mojom::PageHandler::OpenClearBrowsingDataDialog";
      case messages::PageHandler::kRemoveBookmark:
            return "Receive reply history::mojom::PageHandler::RemoveBookmark";
      case messages::PageHandler::kSetLastSelectedTab:
            return "Receive reply history::mojom::PageHandler::SetLastSelectedTab";
      case messages::PageHandler::kShowSidePanelUI:
            return "Receive reply history::mojom::PageHandler::ShowSidePanelUI";
      case messages::PageHandler::kRequestAccountInfo:
            return "Receive reply history::mojom::PageHandler::RequestAccountInfo";
      case messages::PageHandler::kTurnOnHistorySync:
            return "Receive reply history::mojom::PageHandler::TurnOnHistorySync";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::SetPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1acdc1ac;  // IPCStableHash for history::mojom::PageHandler::SetPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::QueryHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x548dd394;  // IPCStableHash for history::mojom::PageHandler::QueryHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::QueryHistoryContinuation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x01d501bb;  // IPCStableHash for history::mojom::PageHandler::QueryHistoryContinuation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RemoveVisits_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa53a6324;  // IPCStableHash for history::mojom::PageHandler::RemoveVisits
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenClearBrowsingDataDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf066f622;  // IPCStableHash for history::mojom::PageHandler::OpenClearBrowsingDataDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RemoveBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7299eefd;  // IPCStableHash for history::mojom::PageHandler::RemoveBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetLastSelectedTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa838c162;  // IPCStableHash for history::mojom::PageHandler::SetLastSelectedTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowSidePanelUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91e74628;  // IPCStableHash for history::mojom::PageHandler::ShowSidePanelUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RequestAccountInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f791c93;  // IPCStableHash for history::mojom::PageHandler::RequestAccountInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::TurnOnHistorySync_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7dedaa31;  // IPCStableHash for history::mojom::PageHandler::TurnOnHistorySync
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_QueryHistory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_QueryHistory_ForwardToCallback(
      PageHandler::QueryHistoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_QueryHistory_ForwardToCallback(const PageHandler_QueryHistory_ForwardToCallback&) = delete;
  PageHandler_QueryHistory_ForwardToCallback& operator=(const PageHandler_QueryHistory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::QueryHistoryCallback callback_;
};

class PageHandler_QueryHistoryContinuation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_QueryHistoryContinuation_ForwardToCallback(
      PageHandler::QueryHistoryContinuationCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_QueryHistoryContinuation_ForwardToCallback(const PageHandler_QueryHistoryContinuation_ForwardToCallback&) = delete;
  PageHandler_QueryHistoryContinuation_ForwardToCallback& operator=(const PageHandler_QueryHistoryContinuation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::QueryHistoryContinuationCallback callback_;
};

class PageHandler_RemoveVisits_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_RemoveVisits_ForwardToCallback(
      PageHandler::RemoveVisitsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_RemoveVisits_ForwardToCallback(const PageHandler_RemoveVisits_ForwardToCallback&) = delete;
  PageHandler_RemoveVisits_ForwardToCallback& operator=(const PageHandler_RemoveVisits_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::RemoveVisitsCallback callback_;
};

class PageHandler_RequestAccountInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_RequestAccountInfo_ForwardToCallback(
      PageHandler::RequestAccountInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_RequestAccountInfo_ForwardToCallback(const PageHandler_RequestAccountInfo_ForwardToCallback&) = delete;
  PageHandler_RequestAccountInfo_ForwardToCallback& operator=(const PageHandler_RequestAccountInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::RequestAccountInfoCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::SetPage(
    ::mojo::PendingRemote<Page> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history::mojom::PageHandler::SetPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_SetPage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::history::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandler.SetPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::QueryHistory(
    const std::string& in_query, int32_t in_max_results, std::optional<double> in_begin_time, QueryHistoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history::mojom::PageHandler::QueryHistory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_results"), in_max_results,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("begin_time"), in_begin_time,
                        "<value of type std::optional<double>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kQueryHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_QueryHistory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in PageHandler.QueryHistory request");

  params->max_results = in_max_results;
  params->begin_time_$flag = in_begin_time.has_value();
  if (in_begin_time.has_value()) {
    params->begin_time_$value = in_begin_time.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("QueryHistory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_QueryHistory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::QueryHistoryContinuation(
    QueryHistoryContinuationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history::mojom::PageHandler::QueryHistoryContinuation");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kQueryHistoryContinuation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_QueryHistoryContinuation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("QueryHistoryContinuation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_QueryHistoryContinuation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::RemoveVisits(
    std::vector<RemovalItemPtr> in_items, RemoveVisitsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history::mojom::PageHandler::RemoveVisits", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("items"), in_items,
                        "<value of type std::vector<RemovalItemPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveVisits), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_RemoveVisits_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->items)::BaseType>
      items_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::history::mojom::RemovalItemDataView>>(
    in_items,
    items_fragment,
    &items_validate_params);

  params->items.Set(
      items_fragment.is_null() ? nullptr : items_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->items.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null items in PageHandler.RemoveVisits request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveVisits");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_RemoveVisits_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::OpenClearBrowsingDataDialog(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history::mojom::PageHandler::OpenClearBrowsingDataDialog");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenClearBrowsingDataDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_OpenClearBrowsingDataDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenClearBrowsingDataDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RemoveBookmark(
    const std::string& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history::mojom::PageHandler::RemoveBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_RemoveBookmark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.RemoveBookmark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetLastSelectedTab(
    int32_t in_last_tab) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history::mojom::PageHandler::SetLastSelectedTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_tab"), in_last_tab,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetLastSelectedTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_SetLastSelectedTab_Params_Data> params(
          message);
  params.Allocate();

  params->last_tab = in_last_tab;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetLastSelectedTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowSidePanelUI(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history::mojom::PageHandler::ShowSidePanelUI");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowSidePanelUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_ShowSidePanelUI_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowSidePanelUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RequestAccountInfo(
    RequestAccountInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history::mojom::PageHandler::RequestAccountInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRequestAccountInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_RequestAccountInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RequestAccountInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_RequestAccountInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::TurnOnHistorySync(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history::mojom::PageHandler::TurnOnHistorySync");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kTurnOnHistorySync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_TurnOnHistorySync_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("TurnOnHistorySync");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_QueryHistory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::QueryHistoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_QueryHistory_ProxyToResponder> proxy(
        new PageHandler_QueryHistory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_QueryHistory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_QueryHistory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_QueryHistory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::QueryHistoryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      QueryResultPtr in_results);
};

bool PageHandler_QueryHistory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_QueryHistory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_QueryHistory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  QueryResultPtr p_results{};
  PageHandler_QueryHistory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void PageHandler_QueryHistory_ProxyToResponder::Run(
    QueryResultPtr in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply history::mojom::PageHandler::QueryHistory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type QueryResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kQueryHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_QueryHistory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType> results_fragment(
          params.message());
  
  mojo::internal::Serialize<::history::mojom::QueryResultDataView>(
    in_results,
    results_fragment);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("QueryHistory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_QueryHistoryContinuation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::QueryHistoryContinuationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_QueryHistoryContinuation_ProxyToResponder> proxy(
        new PageHandler_QueryHistoryContinuation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_QueryHistoryContinuation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_QueryHistoryContinuation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_QueryHistoryContinuation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::QueryHistoryContinuationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      QueryResultPtr in_results);
};

bool PageHandler_QueryHistoryContinuation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_QueryHistoryContinuation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_QueryHistoryContinuation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  QueryResultPtr p_results{};
  PageHandler_QueryHistoryContinuation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void PageHandler_QueryHistoryContinuation_ProxyToResponder::Run(
    QueryResultPtr in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply history::mojom::PageHandler::QueryHistoryContinuation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type QueryResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kQueryHistoryContinuation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_QueryHistoryContinuation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType> results_fragment(
          params.message());
  
  mojo::internal::Serialize<::history::mojom::QueryResultDataView>(
    in_results,
    results_fragment);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("QueryHistoryContinuation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_RemoveVisits_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::RemoveVisitsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_RemoveVisits_ProxyToResponder> proxy(
        new PageHandler_RemoveVisits_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_RemoveVisits_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_RemoveVisits_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_RemoveVisits_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::RemoveVisitsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_didDelete);
};

bool PageHandler_RemoveVisits_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_RemoveVisits_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_RemoveVisits_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  bool p_didDelete{};
  PageHandler_RemoveVisits_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_didDelete = input_data_view.didDelete();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_didDelete));
  }
  return true;
}

void PageHandler_RemoveVisits_ProxyToResponder::Run(
    bool in_didDelete) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply history::mojom::PageHandler::RemoveVisits", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("didDelete"), in_didDelete,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveVisits), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_RemoveVisits_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->didDelete = in_didDelete;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveVisits");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_RequestAccountInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::RequestAccountInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_RequestAccountInfo_ProxyToResponder> proxy(
        new PageHandler_RequestAccountInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_RequestAccountInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_RequestAccountInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_RequestAccountInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::RequestAccountInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      AccountInfoPtr in_account_info);
};

bool PageHandler_RequestAccountInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_RequestAccountInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_RequestAccountInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.8
  bool success = true;
  AccountInfoPtr p_account_info{};
  PageHandler_RequestAccountInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAccountInfo(&p_account_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_account_info));
  }
  return true;
}

void PageHandler_RequestAccountInfo_ProxyToResponder::Run(
    AccountInfoPtr in_account_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply history::mojom::PageHandler::RequestAccountInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("account_info"), in_account_info,
                        "<value of type AccountInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRequestAccountInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::PageHandler_RequestAccountInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->account_info)::BaseType> account_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::history::mojom::AccountInfoDataView>(
    in_account_info,
    account_info_fragment);

  params->account_info.Set(
      account_info_fragment.is_null() ? nullptr : account_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->account_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null account_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RequestAccountInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kSetPage: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetPage_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      PageHandler_SetPage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPage(        
        std::move(p_page));
      return true;
    }
    case messages::PageHandler::kQueryHistory: {
      break;
    }
    case messages::PageHandler::kQueryHistoryContinuation: {
      break;
    }
    case messages::PageHandler::kRemoveVisits: {
      break;
    }
    case messages::PageHandler::kOpenClearBrowsingDataDialog: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenClearBrowsingDataDialog_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenClearBrowsingDataDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      PageHandler_OpenClearBrowsingDataDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenClearBrowsingDataDialog(        );
      return true;
    }
    case messages::PageHandler::kRemoveBookmark: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RemoveBookmark_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RemoveBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      std::string p_url{};
      PageHandler_RemoveBookmark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveBookmark(        
        std::move(p_url));
      return true;
    }
    case messages::PageHandler::kSetLastSelectedTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetLastSelectedTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetLastSelectedTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      int32_t p_last_tab{};
      PageHandler_SetLastSelectedTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_last_tab = input_data_view.last_tab();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLastSelectedTab(        
        std::move(p_last_tab));
      return true;
    }
    case messages::PageHandler::kShowSidePanelUI: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowSidePanelUI_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowSidePanelUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      PageHandler_ShowSidePanelUI_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSidePanelUI(        );
      return true;
    }
    case messages::PageHandler::kRequestAccountInfo: {
      break;
    }
    case messages::PageHandler::kTurnOnHistorySync: {
      DCHECK(message->is_serialized());
      internal::PageHandler_TurnOnHistorySync_Params_Data* params =
          reinterpret_cast<internal::PageHandler_TurnOnHistorySync_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      PageHandler_TurnOnHistorySync_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TurnOnHistorySync(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kSetPage: {
      break;
    }
    case messages::PageHandler::kQueryHistory: {
      internal::PageHandler_QueryHistory_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_QueryHistory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      std::string p_query{};
      int32_t p_max_results{};
      std::optional<double> p_begin_time{};
      PageHandler_QueryHistory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (success)
        p_max_results = input_data_view.max_results();
      if (success) {
        p_begin_time = input_data_view.begin_time();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_QueryHistory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryHistory(        
        std::move(p_query), 
        std::move(p_max_results), 
        std::move(p_begin_time), std::move(callback));
      return true;
    }
    case messages::PageHandler::kQueryHistoryContinuation: {
      internal::PageHandler_QueryHistoryContinuation_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_QueryHistoryContinuation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_QueryHistoryContinuation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_QueryHistoryContinuation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryHistoryContinuation(std::move(callback));
      return true;
    }
    case messages::PageHandler::kRemoveVisits: {
      internal::PageHandler_RemoveVisits_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_RemoveVisits_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      std::vector<RemovalItemPtr> p_items{};
      PageHandler_RemoveVisits_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadItems(&p_items))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_RemoveVisits_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveVisits(        
        std::move(p_items), std::move(callback));
      return true;
    }
    case messages::PageHandler::kOpenClearBrowsingDataDialog: {
      break;
    }
    case messages::PageHandler::kRemoveBookmark: {
      break;
    }
    case messages::PageHandler::kSetLastSelectedTab: {
      break;
    }
    case messages::PageHandler::kShowSidePanelUI: {
      break;
    }
    case messages::PageHandler::kRequestAccountInfo: {
      internal::PageHandler_RequestAccountInfo_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_RequestAccountInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      PageHandler_RequestAccountInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          PageHandler_RequestAccountInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestAccountInfo(std::move(callback));
      return true;
    }
    case messages::PageHandler::kTurnOnHistorySync: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_SetPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_QueryHistory_Params_Data::Validate,
     &internal::PageHandler_QueryHistory_ResponseParams_Data::Validate},
    { &internal::PageHandler_QueryHistoryContinuation_Params_Data::Validate,
     &internal::PageHandler_QueryHistoryContinuation_ResponseParams_Data::Validate},
    { &internal::PageHandler_RemoveVisits_Params_Data::Validate,
     &internal::PageHandler_RemoveVisits_ResponseParams_Data::Validate},
    { &internal::PageHandler_OpenClearBrowsingDataDialog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RemoveBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetLastSelectedTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowSidePanelUI_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RequestAccountInfo_Params_Data::Validate,
     &internal::PageHandler_RequestAccountInfo_ResponseParams_Data::Validate},
    { &internal::PageHandler_TurnOnHistorySync_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::history::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::history::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnHistoryDeleted: {
      return &Page::OnHistoryDeleted_Sym::IPCStableHash;
    }
    case messages::Page::kOnHasOtherFormsChanged: {
      return &Page::OnHasOtherFormsChanged_Sym::IPCStableHash;
    }
    case messages::Page::kSendAccountInfo: {
      return &Page::SendAccountInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnHistoryDeleted:
            return "Receive history::mojom::Page::OnHistoryDeleted";
      case messages::Page::kOnHasOtherFormsChanged:
            return "Receive history::mojom::Page::OnHasOtherFormsChanged";
      case messages::Page::kSendAccountInfo:
            return "Receive history::mojom::Page::SendAccountInfo";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnHistoryDeleted:
            return "Receive reply history::mojom::Page::OnHistoryDeleted";
      case messages::Page::kOnHasOtherFormsChanged:
            return "Receive reply history::mojom::Page::OnHasOtherFormsChanged";
      case messages::Page::kSendAccountInfo:
            return "Receive reply history::mojom::Page::SendAccountInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnHistoryDeleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f361260;  // IPCStableHash for history::mojom::Page::OnHistoryDeleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnHasOtherFormsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd75ca567;  // IPCStableHash for history::mojom::Page::OnHasOtherFormsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SendAccountInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd38b5d2;  // IPCStableHash for history::mojom::Page::SendAccountInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnHistoryDeleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send history::mojom::Page::OnHistoryDeleted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnHistoryDeleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::Page_OnHistoryDeleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnHistoryDeleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnHasOtherFormsChanged(
    bool in_has_other_forms) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history::mojom::Page::OnHasOtherFormsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_other_forms"), in_has_other_forms,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnHasOtherFormsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::Page_OnHasOtherFormsChanged_Params_Data> params(
          message);
  params.Allocate();

  params->has_other_forms = in_has_other_forms;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnHasOtherFormsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SendAccountInfo(
    AccountInfoPtr in_account_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send history::mojom::Page::SendAccountInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("account_info"), in_account_info,
                        "<value of type AccountInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSendAccountInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::history::mojom::internal::Page_SendAccountInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->account_info)::BaseType> account_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::history::mojom::AccountInfoDataView>(
    in_account_info,
    account_info_fragment);

  params->account_info.Set(
      account_info_fragment.is_null() ? nullptr : account_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->account_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null account_info in Page.SendAccountInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SendAccountInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnHistoryDeleted: {
      DCHECK(message->is_serialized());
      internal::Page_OnHistoryDeleted_Params_Data* params =
          reinterpret_cast<internal::Page_OnHistoryDeleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      Page_OnHistoryDeleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHistoryDeleted(        );
      return true;
    }
    case messages::Page::kOnHasOtherFormsChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnHasOtherFormsChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnHasOtherFormsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      bool p_has_other_forms{};
      Page_OnHasOtherFormsChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_other_forms = input_data_view.has_other_forms();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHasOtherFormsChanged(        
        std::move(p_has_other_forms));
      return true;
    }
    case messages::Page::kSendAccountInfo: {
      DCHECK(message->is_serialized());
      internal::Page_SendAccountInfo_Params_Data* params =
          reinterpret_cast<internal::Page_SendAccountInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      AccountInfoPtr p_account_info{};
      Page_SendAccountInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccountInfo(&p_account_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendAccountInfo(        
        std::move(p_account_info));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnHistoryDeleted: {
      break;
    }
    case messages::Page::kOnHasOtherFormsChanged: {
      break;
    }
    case messages::Page::kSendAccountInfo: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnHistoryDeleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnHasOtherFormsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SendAccountInfo_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::history::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // history::mojom


namespace mojo {


// static
bool StructTraits<::history::mojom::QueryState::DataView, ::history::mojom::QueryStatePtr>::Read(
    ::history::mojom::QueryState::DataView input,
    ::history::mojom::QueryStatePtr* output) {
  bool success = true;
  ::history::mojom::QueryStatePtr result(::history::mojom::QueryState::New());
  
      if (success)
        result->incremental = input.incremental();
      if (success)
        result->querying = input.querying();
      if (success && !input.ReadSearchTerm(&result->search_term))
        success = false;
      if (success && !input.ReadAfter(&result->after))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history::mojom::HistoryQuery::DataView, ::history::mojom::HistoryQueryPtr>::Read(
    ::history::mojom::HistoryQuery::DataView input,
    ::history::mojom::HistoryQueryPtr* output) {
  bool success = true;
  ::history::mojom::HistoryQueryPtr result(::history::mojom::HistoryQuery::New());
  
      if (success && !input.ReadTerm(&result->term))
        success = false;
      if (success)
        result->finished = input.finished();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history::mojom::DebugInfo::DataView, ::history::mojom::DebugInfoPtr>::Read(
    ::history::mojom::DebugInfo::DataView input,
    ::history::mojom::DebugInfoPtr* output) {
  bool success = true;
  ::history::mojom::DebugInfoPtr result(::history::mojom::DebugInfo::New());
  
      if (success)
        result->is_url_in_local_database = input.is_url_in_local_database();
      if (success)
        result->visit_count = input.visit_count();
      if (success)
        result->typed_count = input.typed_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history::mojom::HistoryEntry::DataView, ::history::mojom::HistoryEntryPtr>::Read(
    ::history::mojom::HistoryEntry::DataView input,
    ::history::mojom::HistoryEntryPtr* output) {
  bool success = true;
  ::history::mojom::HistoryEntryPtr result(::history::mojom::HistoryEntry::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
      if (success && !input.ReadFallbackFaviconText(&result->fallback_favicon_text))
        success = false;
      if (success)
        result->time = input.time();
      if (success && !input.ReadAllTimestamps(&result->all_timestamps))
        success = false;
      if (success && !input.ReadDateShort(&result->date_short))
        success = false;
      if (success && !input.ReadDeviceName(&result->device_name))
        success = false;
      if (success && !input.ReadDeviceType(&result->device_type))
        success = false;
      if (success && !input.ReadDateTimeOfDay(&result->date_time_of_day))
        success = false;
      if (success && !input.ReadDateRelativeDay(&result->date_relative_day))
        success = false;
      if (success)
        result->selected = input.selected();
      if (success && !input.ReadReadableTimestamp(&result->readableTimestamp))
        success = false;
      if (success && !input.ReadSnippet(&result->snippet))
        success = false;
      if (success)
        result->starred = input.starred();
      if (success && !input.ReadHostFilteringBehavior(&result->host_filtering_behavior))
        success = false;
      if (success)
        result->blocked_visit = input.blocked_visit();
      if (success)
        result->is_url_in_remote_user_data = input.is_url_in_remote_user_data();
      if (success)
        result->is_actor_visit = input.is_actor_visit();
      if (success && !input.ReadRemoteIconUrlForUma(&result->remote_icon_url_for_uma))
        success = false;
      if (success && !input.ReadDebug(&result->debug))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history::mojom::QueryResult::DataView, ::history::mojom::QueryResultPtr>::Read(
    ::history::mojom::QueryResult::DataView input,
    ::history::mojom::QueryResultPtr* output) {
  bool success = true;
  ::history::mojom::QueryResultPtr result(::history::mojom::QueryResult::New());
  
      if (success && !input.ReadInfo(&result->info))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history::mojom::RemovalItem::DataView, ::history::mojom::RemovalItemPtr>::Read(
    ::history::mojom::RemovalItem::DataView input,
    ::history::mojom::RemovalItemPtr* output) {
  bool success = true;
  ::history::mojom::RemovalItemPtr result(::history::mojom::RemovalItem::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTimestamps(&result->timestamps))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::history::mojom::AccountInfo::DataView, ::history::mojom::AccountInfoPtr>::Read(
    ::history::mojom::AccountInfo::DataView input,
    ::history::mojom::AccountInfoPtr* output) {
  bool success = true;
  ::history::mojom::AccountInfoPtr result(::history::mojom::AccountInfo::New());
  
      if (success && !input.ReadAccountImageSrc(&result->account_image_src))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadEmail(&result->email))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace history::mojom {


void PageHandlerInterceptorForTesting::SetPage(::mojo::PendingRemote<Page> page) {
  GetForwardingInterface()->SetPage(
    std::move(page)
    );
}
void PageHandlerInterceptorForTesting::QueryHistory(const std::string& query, int32_t max_results, std::optional<double> begin_time, QueryHistoryCallback callback) {
  GetForwardingInterface()->QueryHistory(
    std::move(query)
    , 
    std::move(max_results)
    , 
    std::move(begin_time)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::QueryHistoryContinuation(QueryHistoryContinuationCallback callback) {
  GetForwardingInterface()->QueryHistoryContinuation(std::move(callback));
}
void PageHandlerInterceptorForTesting::RemoveVisits(std::vector<RemovalItemPtr> items, RemoveVisitsCallback callback) {
  GetForwardingInterface()->RemoveVisits(
    std::move(items)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::OpenClearBrowsingDataDialog() {
  GetForwardingInterface()->OpenClearBrowsingDataDialog();
}
void PageHandlerInterceptorForTesting::RemoveBookmark(const std::string& url) {
  GetForwardingInterface()->RemoveBookmark(
    std::move(url)
    );
}
void PageHandlerInterceptorForTesting::SetLastSelectedTab(int32_t last_tab) {
  GetForwardingInterface()->SetLastSelectedTab(
    std::move(last_tab)
    );
}
void PageHandlerInterceptorForTesting::ShowSidePanelUI() {
  GetForwardingInterface()->ShowSidePanelUI();
}
void PageHandlerInterceptorForTesting::RequestAccountInfo(RequestAccountInfoCallback callback) {
  GetForwardingInterface()->RequestAccountInfo(std::move(callback));
}
void PageHandlerInterceptorForTesting::TurnOnHistorySync() {
  GetForwardingInterface()->TurnOnHistorySync();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::QueryHistory(
    const std::string& query, int32_t max_results, std::optional<double> begin_time, QueryResultPtr* out_results) {
  base::RunLoop loop;
  proxy_->QueryHistory(
      std::move(query),
      std::move(max_results),
      std::move(begin_time),
      base::BindOnce(
          [](base::RunLoop* loop,
             QueryResultPtr* out_results
,
             QueryResultPtr results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

QueryResultPtr PageHandlerAsyncWaiter::QueryHistory(
    const std::string& query, int32_t max_results, std::optional<double> begin_time) {
  QueryResultPtr async_wait_result;
  QueryHistory(std::move(query),std::move(max_results),std::move(begin_time),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::QueryHistoryContinuation(
    QueryResultPtr* out_results) {
  base::RunLoop loop;
  proxy_->QueryHistoryContinuation(
      base::BindOnce(
          [](base::RunLoop* loop,
             QueryResultPtr* out_results
,
             QueryResultPtr results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

QueryResultPtr PageHandlerAsyncWaiter::QueryHistoryContinuation(
    ) {
  QueryResultPtr async_wait_result;
  QueryHistoryContinuation(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::RemoveVisits(
    std::vector<RemovalItemPtr> items, bool* out_didDelete) {
  base::RunLoop loop;
  proxy_->RemoveVisits(
      std::move(items),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_didDelete
,
             bool didDelete) {*out_didDelete = std::move(didDelete);
            loop->Quit();
          },
          &loop,
          out_didDelete));
  loop.Run();
}

bool PageHandlerAsyncWaiter::RemoveVisits(
    std::vector<RemovalItemPtr> items) {
  bool async_wait_result;
  RemoveVisits(std::move(items),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::RequestAccountInfo(
    AccountInfoPtr* out_account_info) {
  base::RunLoop loop;
  proxy_->RequestAccountInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             AccountInfoPtr* out_account_info
,
             AccountInfoPtr account_info) {*out_account_info = std::move(account_info);
            loop->Quit();
          },
          &loop,
          out_account_info));
  loop.Run();
}

AccountInfoPtr PageHandlerAsyncWaiter::RequestAccountInfo(
    ) {
  AccountInfoPtr async_wait_result;
  RequestAccountInfo(&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::OnHistoryDeleted() {
  GetForwardingInterface()->OnHistoryDeleted();
}
void PageInterceptorForTesting::OnHasOtherFormsChanged(bool has_other_forms) {
  GetForwardingInterface()->OnHasOtherFormsChanged(
    std::move(has_other_forms)
    );
}
void PageInterceptorForTesting::SendAccountInfo(AccountInfoPtr account_info) {
  GetForwardingInterface()->SendAccountInfo(
    std::move(account_info)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // history::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif