// ui/webui/resources/cr_components/history/history.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_TEST_UTILS_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_TEST_UTILS_H_

#include "ui/webui/resources/cr_components/history/history.mojom.h"


namespace history::mojom {


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void SetPage(::mojo::PendingRemote<Page> page) override;
  void QueryHistory(const std::string& query, int32_t max_results, std::optional<double> begin_time, QueryHistoryCallback callback) override;
  void QueryHistoryContinuation(QueryHistoryContinuationCallback callback) override;
  void RemoveVisits(std::vector<RemovalItemPtr> items, RemoveVisitsCallback callback) override;
  void OpenClearBrowsingDataDialog() override;
  void RemoveBookmark(const std::string& url) override;
  void SetLastSelectedTab(int32_t last_tab) override;
  void ShowSidePanelUI() override;
  void RequestAccountInfo(RequestAccountInfoCallback callback) override;
  void TurnOnHistorySync() override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void QueryHistory(
      const std::string& query, int32_t max_results, std::optional<double> begin_time, QueryResultPtr* out_results);
  QueryResultPtr QueryHistory(const std::string& query, int32_t max_results, std::optional<double> begin_time);
  void QueryHistoryContinuation(
      QueryResultPtr* out_results);
  QueryResultPtr QueryHistoryContinuation();
  void RemoveVisits(
      std::vector<RemovalItemPtr> items, bool* out_didDelete);
  bool RemoveVisits(std::vector<RemovalItemPtr> items);
  void RequestAccountInfo(
      AccountInfoPtr* out_account_info);
  AccountInfoPtr RequestAccountInfo();

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void OnHistoryDeleted() override;
  void OnHasOtherFormsChanged(bool has_other_forms) override;
  void SendAccountInfo(AccountInfoPtr account_info) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // history::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_TEST_UTILS_H_