// ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MOJOM_DATA_VIEW_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/webui/resources/cr_components/help_bubble/help_bubble.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/webui/resources/js/tracked_element/tracked_element.mojom-shared.h"


namespace help_bubble::mojom {
class HelpBubbleButtonParamsDataView;

class ProgressDataView;

class HelpBubbleParamsDataView;



}  // help_bubble::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::help_bubble::mojom::HelpBubbleButtonParamsDataView> {
  using Data = ::help_bubble::mojom::internal::HelpBubbleButtonParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::help_bubble::mojom::ProgressDataView> {
  using Data = ::help_bubble::mojom::internal::Progress_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::help_bubble::mojom::HelpBubbleParamsDataView> {
  using Data = ::help_bubble::mojom::internal::HelpBubbleParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace help_bubble::mojom {


enum class HelpBubbleArrowPosition : int32_t {
  
  TOP_LEFT = 0,
  
  TOP_CENTER = 1,
  
  TOP_RIGHT = 2,
  
  BOTTOM_LEFT = 3,
  
  BOTTOM_CENTER = 4,
  
  BOTTOM_RIGHT = 5,
  
  LEFT_TOP = 6,
  
  LEFT_CENTER = 7,
  
  LEFT_BOTTOM = 8,
  
  RIGHT_TOP = 9,
  
  RIGHT_CENTER = 10,
  
  RIGHT_BOTTOM = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

 std::ostream& operator<<(std::ostream& os, HelpBubbleArrowPosition value);
inline bool IsKnownEnumValue(HelpBubbleArrowPosition value) {
  return internal::HelpBubbleArrowPosition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HelpBubbleClosedReason : int32_t {
  
  kPageChanged = 0,
  
  kDismissedByUser = 1,
  
  kTimedOut = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, HelpBubbleClosedReason value);
inline bool IsKnownEnumValue(HelpBubbleClosedReason value) {
  return internal::HelpBubbleClosedReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class HelpBubbleHandlerFactoryInterfaceBase {};

using HelpBubbleHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<HelpBubbleHandlerFactoryInterfaceBase>;
using HelpBubbleHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<HelpBubbleHandlerFactoryInterfaceBase>;
using HelpBubbleHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HelpBubbleHandlerFactoryInterfaceBase>;
using HelpBubbleHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HelpBubbleHandlerFactoryInterfaceBase>;
class HelpBubbleHandlerInterfaceBase {};

using HelpBubbleHandlerPtrDataView =
    mojo::InterfacePtrDataView<HelpBubbleHandlerInterfaceBase>;
using HelpBubbleHandlerRequestDataView =
    mojo::InterfaceRequestDataView<HelpBubbleHandlerInterfaceBase>;
using HelpBubbleHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HelpBubbleHandlerInterfaceBase>;
using HelpBubbleHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HelpBubbleHandlerInterfaceBase>;
class HelpBubbleClientInterfaceBase {};

using HelpBubbleClientPtrDataView =
    mojo::InterfacePtrDataView<HelpBubbleClientInterfaceBase>;
using HelpBubbleClientRequestDataView =
    mojo::InterfaceRequestDataView<HelpBubbleClientInterfaceBase>;
using HelpBubbleClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HelpBubbleClientInterfaceBase>;
using HelpBubbleClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HelpBubbleClientInterfaceBase>;


class HelpBubbleButtonParamsDataView {
 public:
  HelpBubbleButtonParamsDataView() = default;

  HelpBubbleButtonParamsDataView(
      internal::HelpBubbleButtonParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_default() const {
    return data_->is_default;
  }
 private:
  internal::HelpBubbleButtonParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProgressDataView {
 public:
  ProgressDataView() = default;

  ProgressDataView(
      internal::Progress_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t current() const {
    return data_->current;
  }
  uint8_t total() const {
    return data_->total;
  }
 private:
  internal::Progress_Data* data_ = nullptr;
};


class HelpBubbleParamsDataView {
 public:
  HelpBubbleParamsDataView() = default;

  HelpBubbleParamsDataView(
      internal::HelpBubbleParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNativeIdentifierDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNativeIdentifier(UserType* output) {
    
    auto* pointer = data_->native_identifier.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) const {
    auto data_value = data_->position;
    return mojo::internal::Deserialize<::help_bubble::mojom::HelpBubbleArrowPosition>(
        data_value, output);
  }
  HelpBubbleArrowPosition position() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::help_bubble::mojom::HelpBubbleArrowPosition>(data_->position));
  }
  inline void GetTitleTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitleText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `title_text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitleText` instead "
    "of `ReadTitleText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBodyTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBodyText(UserType* output) {
    
    auto* pointer = data_->body_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCloseButtonAltTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCloseButtonAltText(UserType* output) {
    
    auto* pointer = data_->close_button_alt_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBodyIconNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBodyIconName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `body_icon_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBodyIconName` instead "
    "of `ReadBodyIconName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->body_icon_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBodyIconAltTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBodyIconAltText(UserType* output) {
    
    auto* pointer = data_->body_icon_alt_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetProgressDataView(
      ProgressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProgress(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::help_bubble::mojom::ProgressDataView, UserType>(),
    "Attempting to read the optional `progress` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProgress` instead "
    "of `ReadProgress if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->progress.Get();
    return mojo::internal::Deserialize<::help_bubble::mojom::ProgressDataView>(
        pointer, output, message_);
  }
  inline void GetButtonsDataView(
      mojo::ArrayDataView<HelpBubbleButtonParamsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadButtons(UserType* output) {
    
    auto* pointer = data_->buttons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::help_bubble::mojom::HelpBubbleButtonParamsDataView>>(
        pointer, output, message_);
  }
  std::optional<bool> focus_on_show_hint() const {

    return data_->focus_on_show_hint_$flag
        ? std::make_optional(!!data_->focus_on_show_hint_$value)
        : std::nullopt;
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `timeout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimeout` instead "
    "of `ReadTimeout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::HelpBubbleParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // help_bubble::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MOJOM_DATA_VIEW_H_