// ui/gfx/mojom/transform.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_TRANSFORM_MOJOM_BLINK_H_
#define UI_GFX_MOJOM_TRANSFORM_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/transform.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/transform.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/transform.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "ui/gfx/mojom/transform_mojom_traits.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gfx::mojom::blink {








class  Transform {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Transform, T>::value>;
  using DataView = TransformDataView;
  using Data_ = internal::Transform_Data;

  template <typename... Args>
  static TransformPtr New(Args&&... args) {
    return TransformPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransformPtr From(const U& u) {
    return mojo::TypeConverter<TransformPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Transform>::Convert(*this);
  }


  Transform();

  explicit Transform(
      std::optional<::blink::Vector<float>> matrix);


  ~Transform();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransformPtr>
  TransformPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Transform::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Transform::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Transform::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Transform::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Transform::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Transform::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Transform_UnserializedMessageContext<
            UserType, Transform::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Transform::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Transform::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Transform_UnserializedMessageContext<
            UserType, Transform::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Transform::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::Vector<float>> matrix;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Transform::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Transform::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Transform::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Transform::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TransformPtr Transform::Clone() const {
  return New(
      mojo::Clone(matrix)
  );
}

template <typename T, Transform::EnableIfSame<T>*>
bool Transform::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->matrix, other_struct.matrix))
    return false;
  return true;
}

template <typename T, Transform::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.matrix < rhs.matrix)
    return true;
  if (rhs.matrix < lhs.matrix)
    return false;
  return false;
}


}  // gfx::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::Transform::DataView,
                                         ::gfx::mojom::blink::TransformPtr> {
  static bool IsNull(const ::gfx::mojom::blink::TransformPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::TransformPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::blink::Transform::matrix)& matrix(
      const ::gfx::mojom::blink::TransformPtr& input) {
    return input->matrix;
  }

  static bool Read(::gfx::mojom::blink::Transform::DataView input, ::gfx::mojom::blink::TransformPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_TRANSFORM_MOJOM_BLINK_H_