// ui/gfx/mojom/presentation_feedback.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_H_
#define UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/presentation_feedback.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/presentation_feedback.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/presentation_feedback.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/mojom/ca_layer_result.mojom.h"
#include <string>
#include <vector>




#include "ui/gfx/mojom/presentation_feedback_mojom_traits.h"




namespace gfx::mojom {








class  PresentationFeedback {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PresentationFeedback, T>::value>;
  using DataView = PresentationFeedbackDataView;
  using Data_ = internal::PresentationFeedback_Data;

  template <typename... Args>
  static PresentationFeedbackPtr New(Args&&... args) {
    return PresentationFeedbackPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PresentationFeedbackPtr From(const U& u) {
    return mojo::TypeConverter<PresentationFeedbackPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PresentationFeedback>::Convert(*this);
  }


  PresentationFeedback();

  PresentationFeedback(
      ::base::TimeTicks timestamp,
      ::base::TimeDelta interval,
      uint32_t flags,
      ::base::TimeTicks available_timestamp,
      ::base::TimeTicks ready_timestamp,
      ::base::TimeTicks latch_timestamp,
      ::base::TimeTicks writes_done_timestamp,
      ::gfx::CALayerResult ca_layer_error_code,
      std::optional<int64_t> display_trace_id);


  ~PresentationFeedback();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PresentationFeedbackPtr>
  PresentationFeedbackPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PresentationFeedback::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PresentationFeedback::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PresentationFeedback::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PresentationFeedback::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PresentationFeedback::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PresentationFeedback::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PresentationFeedback_UnserializedMessageContext<
            UserType, PresentationFeedback::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PresentationFeedback::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PresentationFeedback::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PresentationFeedback_UnserializedMessageContext<
            UserType, PresentationFeedback::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PresentationFeedback::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks timestamp;
  
  ::base::TimeDelta interval;
  
  uint32_t flags;
  
  ::base::TimeTicks available_timestamp;
  
  ::base::TimeTicks ready_timestamp;
  
  ::base::TimeTicks latch_timestamp;
  
  ::base::TimeTicks writes_done_timestamp;
  
  ::gfx::CALayerResult ca_layer_error_code;
  
  std::optional<int64_t> display_trace_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PresentationFeedback::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PresentationFeedback::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PresentationFeedback::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PresentationFeedback::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PresentationFeedbackPtr PresentationFeedback::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(interval),
      mojo::Clone(flags),
      mojo::Clone(available_timestamp),
      mojo::Clone(ready_timestamp),
      mojo::Clone(latch_timestamp),
      mojo::Clone(writes_done_timestamp),
      mojo::Clone(ca_layer_error_code),
      mojo::Clone(display_trace_id)
  );
}

template <typename T, PresentationFeedback::EnableIfSame<T>*>
bool PresentationFeedback::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->interval, other_struct.interval))
    return false;
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->available_timestamp, other_struct.available_timestamp))
    return false;
  if (!mojo::Equals(this->ready_timestamp, other_struct.ready_timestamp))
    return false;
  if (!mojo::Equals(this->latch_timestamp, other_struct.latch_timestamp))
    return false;
  if (!mojo::Equals(this->writes_done_timestamp, other_struct.writes_done_timestamp))
    return false;
  if (!mojo::Equals(this->ca_layer_error_code, other_struct.ca_layer_error_code))
    return false;
  if (!mojo::Equals(this->display_trace_id, other_struct.display_trace_id))
    return false;
  return true;
}

template <typename T, PresentationFeedback::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.interval < rhs.interval)
    return true;
  if (rhs.interval < lhs.interval)
    return false;
  if (lhs.flags < rhs.flags)
    return true;
  if (rhs.flags < lhs.flags)
    return false;
  if (lhs.available_timestamp < rhs.available_timestamp)
    return true;
  if (rhs.available_timestamp < lhs.available_timestamp)
    return false;
  if (lhs.ready_timestamp < rhs.ready_timestamp)
    return true;
  if (rhs.ready_timestamp < lhs.ready_timestamp)
    return false;
  if (lhs.latch_timestamp < rhs.latch_timestamp)
    return true;
  if (rhs.latch_timestamp < lhs.latch_timestamp)
    return false;
  if (lhs.writes_done_timestamp < rhs.writes_done_timestamp)
    return true;
  if (rhs.writes_done_timestamp < lhs.writes_done_timestamp)
    return false;
  if (lhs.ca_layer_error_code < rhs.ca_layer_error_code)
    return true;
  if (rhs.ca_layer_error_code < lhs.ca_layer_error_code)
    return false;
  if (lhs.display_trace_id < rhs.display_trace_id)
    return true;
  if (rhs.display_trace_id < lhs.display_trace_id)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::PresentationFeedback::DataView,
                                         ::gfx::mojom::PresentationFeedbackPtr> {
  static bool IsNull(const ::gfx::mojom::PresentationFeedbackPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::PresentationFeedbackPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::PresentationFeedback::timestamp)& timestamp(
      const ::gfx::mojom::PresentationFeedbackPtr& input) {
    return input->timestamp;
  }

  static const decltype(::gfx::mojom::PresentationFeedback::interval)& interval(
      const ::gfx::mojom::PresentationFeedbackPtr& input) {
    return input->interval;
  }

  static decltype(::gfx::mojom::PresentationFeedback::flags) flags(
      const ::gfx::mojom::PresentationFeedbackPtr& input) {
    return input->flags;
  }

  static const decltype(::gfx::mojom::PresentationFeedback::available_timestamp)& available_timestamp(
      const ::gfx::mojom::PresentationFeedbackPtr& input) {
    return input->available_timestamp;
  }

  static const decltype(::gfx::mojom::PresentationFeedback::ready_timestamp)& ready_timestamp(
      const ::gfx::mojom::PresentationFeedbackPtr& input) {
    return input->ready_timestamp;
  }

  static const decltype(::gfx::mojom::PresentationFeedback::latch_timestamp)& latch_timestamp(
      const ::gfx::mojom::PresentationFeedbackPtr& input) {
    return input->latch_timestamp;
  }

  static const decltype(::gfx::mojom::PresentationFeedback::writes_done_timestamp)& writes_done_timestamp(
      const ::gfx::mojom::PresentationFeedbackPtr& input) {
    return input->writes_done_timestamp;
  }

  static decltype(::gfx::mojom::PresentationFeedback::ca_layer_error_code) ca_layer_error_code(
      const ::gfx::mojom::PresentationFeedbackPtr& input) {
    return input->ca_layer_error_code;
  }

  static decltype(::gfx::mojom::PresentationFeedback::display_trace_id) display_trace_id(
      const ::gfx::mojom::PresentationFeedbackPtr& input) {
    return input->display_trace_id;
  }

  static bool Read(::gfx::mojom::PresentationFeedback::DataView input, ::gfx::mojom::PresentationFeedbackPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_PRESENTATION_FEEDBACK_MOJOM_H_