// ui/gfx/mojom/native_handle_types.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_BLINK_H_
#define UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/native_handle_types.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/native_handle_types.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "ui/gfx/mojom/native_handle_types_mojom_traits.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gfx::mojom::blink {






class  GpuMemoryBufferPlatformHandle {
 public:
  using DataView = GpuMemoryBufferPlatformHandleDataView;
  using Data_ = internal::GpuMemoryBufferPlatformHandle_Data;
  using Tag = Data_::GpuMemoryBufferPlatformHandle_Tag;

  template <typename... Args>
  static GpuMemoryBufferPlatformHandlePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |shared_memory_handle|.
  static GpuMemoryBufferPlatformHandlePtr NewSharedMemoryHandle(
      ::base::UnsafeSharedMemoryRegion value);
  // Construct an instance holding |io_surface_handle|.
  static GpuMemoryBufferPlatformHandlePtr NewIoSurfaceHandle(
      IOSurfaceHandlePtr value);

  template <typename U>
  static GpuMemoryBufferPlatformHandlePtr From(const U& u) {
    return mojo::TypeConverter<GpuMemoryBufferPlatformHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuMemoryBufferPlatformHandle>::Convert(*this);
  }
  ~GpuMemoryBufferPlatformHandle();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GpuMemoryBufferPlatformHandle(const GpuMemoryBufferPlatformHandle& other) = delete;
  GpuMemoryBufferPlatformHandle& operator=(const GpuMemoryBufferPlatformHandle& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GpuMemoryBufferPlatformHandlePtr>
  GpuMemoryBufferPlatformHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GpuMemoryBufferPlatformHandle>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GpuMemoryBufferPlatformHandle>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_shared_memory_handle() const { return tag_ == Tag::kSharedMemoryHandle; }
  const ::base::UnsafeSharedMemoryRegion& get_shared_memory_handle() const {
    CHECK(tag_ == Tag::kSharedMemoryHandle);
    return data_.shared_memory_handle;
  }
  ::base::UnsafeSharedMemoryRegion& get_shared_memory_handle() {
    CHECK(tag_ == Tag::kSharedMemoryHandle);
    return data_.shared_memory_handle;
  }
  void set_shared_memory_handle(::base::UnsafeSharedMemoryRegion shared_memory_handle);

  bool is_io_surface_handle() const { return tag_ == Tag::kIoSurfaceHandle; }
  const IOSurfaceHandlePtr& get_io_surface_handle() const {
    CHECK(tag_ == Tag::kIoSurfaceHandle);
    return data_.io_surface_handle;
  }
  IOSurfaceHandlePtr& get_io_surface_handle() {
    CHECK(tag_ == Tag::kIoSurfaceHandle);
    return data_.io_surface_handle;
  }
  void set_io_surface_handle(IOSurfaceHandlePtr io_surface_handle);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuMemoryBufferPlatformHandle::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GpuMemoryBufferPlatformHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemoryHandle)>,
        ::base::UnsafeSharedMemoryRegion value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kIoSurfaceHandle)>,
        IOSurfaceHandlePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::base::UnsafeSharedMemoryRegion shared_memory_handle;
    IOSurfaceHandlePtr io_surface_handle;
  };

  GpuMemoryBufferPlatformHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemoryHandle)>,
      ::base::UnsafeSharedMemoryRegion value);
  GpuMemoryBufferPlatformHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kIoSurfaceHandle)>,
      IOSurfaceHandlePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  IOSurfaceHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IOSurfaceHandle, T>::value>;
  using DataView = IOSurfaceHandleDataView;
  using Data_ = internal::IOSurfaceHandle_Data;

  template <typename... Args>
  static IOSurfaceHandlePtr New(Args&&... args) {
    return IOSurfaceHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IOSurfaceHandlePtr From(const U& u) {
    return mojo::TypeConverter<IOSurfaceHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IOSurfaceHandle>::Convert(*this);
  }


  IOSurfaceHandle();

  explicit IOSurfaceHandle(
      ::mojo::PlatformHandle mach_send_right);

IOSurfaceHandle(const IOSurfaceHandle&) = delete;
IOSurfaceHandle& operator=(const IOSurfaceHandle&) = delete;

  ~IOSurfaceHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IOSurfaceHandlePtr>
  IOSurfaceHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IOSurfaceHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IOSurfaceHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IOSurfaceHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IOSurfaceHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IOSurfaceHandle_UnserializedMessageContext<
            UserType, IOSurfaceHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IOSurfaceHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IOSurfaceHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IOSurfaceHandle_UnserializedMessageContext<
            UserType, IOSurfaceHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IOSurfaceHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PlatformHandle mach_send_right;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IOSurfaceHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IOSurfaceHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IOSurfaceHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IOSurfaceHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
GpuMemoryBufferPlatformHandlePtr GpuMemoryBufferPlatformHandle::Clone() const {
  switch (tag_) {
    case Tag::kSharedMemoryHandle:
      return NewSharedMemoryHandle(
          mojo::Clone(data_.shared_memory_handle));
    case Tag::kIoSurfaceHandle:
      return NewIoSurfaceHandle(
          mojo::Clone(data_.io_surface_handle));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GpuMemoryBufferPlatformHandle>::value>::type*>
bool GpuMemoryBufferPlatformHandle::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSharedMemoryHandle:
      return mojo::Equals(data_.shared_memory_handle, other.data_.shared_memory_handle);
    case Tag::kIoSurfaceHandle:
      return mojo::Equals(data_.io_surface_handle, other.data_.io_surface_handle);
  }

  return false;
}
template <typename StructPtrType>
IOSurfaceHandlePtr IOSurfaceHandle::Clone() const {
  return New(
      mojo::Clone(mach_send_right)
  );
}

template <typename T, IOSurfaceHandle::EnableIfSame<T>*>
bool IOSurfaceHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mach_send_right, other_struct.mach_send_right))
    return false;
  return true;
}

template <typename T, IOSurfaceHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mach_send_right < rhs.mach_send_right)
    return true;
  if (rhs.mach_send_right < lhs.mach_send_right)
    return false;
  return false;
}


}  // gfx::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::IOSurfaceHandle::DataView,
                                         ::gfx::mojom::blink::IOSurfaceHandlePtr> {
  static bool IsNull(const ::gfx::mojom::blink::IOSurfaceHandlePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::IOSurfaceHandlePtr* output) { output->reset(); }

  static  decltype(::gfx::mojom::blink::IOSurfaceHandle::mach_send_right)& mach_send_right(
       ::gfx::mojom::blink::IOSurfaceHandlePtr& input) {
    return input->mach_send_right;
  }

  static bool Read(::gfx::mojom::blink::IOSurfaceHandle::DataView input, ::gfx::mojom::blink::IOSurfaceHandlePtr* output);
};


template <>
struct  UnionTraits<::gfx::mojom::blink::GpuMemoryBufferPlatformHandle::DataView,
                                        ::gfx::mojom::blink::GpuMemoryBufferPlatformHandlePtr> {
  static bool IsNull(const ::gfx::mojom::blink::GpuMemoryBufferPlatformHandlePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::GpuMemoryBufferPlatformHandlePtr* output) { output->reset(); }

  static ::gfx::mojom::blink::GpuMemoryBufferPlatformHandle::Tag GetTag(const ::gfx::mojom::blink::GpuMemoryBufferPlatformHandlePtr& input) {
    return input->which();
  }

  static  ::base::UnsafeSharedMemoryRegion& shared_memory_handle( ::gfx::mojom::blink::GpuMemoryBufferPlatformHandlePtr& input) {
    return input->get_shared_memory_handle();
  }

  static  ::gfx::mojom::blink::IOSurfaceHandlePtr& io_surface_handle( ::gfx::mojom::blink::GpuMemoryBufferPlatformHandlePtr& input) {
    return input->get_io_surface_handle();
  }

  static bool Read(::gfx::mojom::blink::GpuMemoryBufferPlatformHandle::DataView input, ::gfx::mojom::blink::GpuMemoryBufferPlatformHandlePtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_BLINK_H_