// ui/gfx/mojom/linear_gradient.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_LINEAR_GRADIENT_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_MOJOM_LINEAR_GRADIENT_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/mojom/linear_gradient.mojom-shared-internal.h"

#include "ui/gfx/mojom/linear_gradient.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::StepDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::StepDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::Step_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->fraction = Traits::fraction(input);

      fragment->alpha = Traits::alpha(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::LinearGradientDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::LinearGradientDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::LinearGradient_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->angle = Traits::angle(input);

      fragment->step_count = Traits::step_count(input);

      decltype(Traits::steps(input)) in_steps = Traits::steps(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->steps)::BaseType>
          steps_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& steps_validate_params =
          mojo::internal::GetArrayValidator<8, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::StepDataView>, send_validation>(
        in_steps,
        steps_fragment,
        &steps_validate_params);

      fragment->steps.Set(
          steps_fragment.is_null() ? nullptr : steps_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->steps.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null steps in LinearGradient struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_MOJOM_LINEAR_GRADIENT_MOJOM_SEND_VALIDATION_H_