// ui/gfx/mojom/delegated_ink_point_renderer.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('gfx.mojom.DelegatedInkPoint');






goog.provide('gfx.mojom.DelegatedInkPointRenderer');
goog.provide('gfx.mojom.DelegatedInkPointRendererReceiver');
goog.provide('gfx.mojom.DelegatedInkPointRendererCallbackRouter');
goog.provide('gfx.mojom.DelegatedInkPointRendererInterface');
goog.provide('gfx.mojom.DelegatedInkPointRendererRemote');
goog.provide('gfx.mojom.DelegatedInkPointRendererPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
gfx.mojom.DelegatedInkPointRendererPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        gfx.mojom.DelegatedInkPointRenderer.$interfaceName,
        scope);
  }
};

/** @interface */
gfx.mojom.DelegatedInkPointRendererInterface = class {
  
  /**
   * @param { !gfx.mojom.DelegatedInkPoint } point
   */

  storeDelegatedInkPoint(point) {}
  
  /**
   */

  resetPrediction() {}
};

/**
 * @export
 * @implements { gfx.mojom.DelegatedInkPointRendererInterface }
 */
gfx.mojom.DelegatedInkPointRendererRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!gfx.mojom.DelegatedInkPointRendererPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          gfx.mojom.DelegatedInkPointRendererPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!gfx.mojom.DelegatedInkPointRendererPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gfx.mojom.DelegatedInkPoint } point
   */

  storeDelegatedInkPoint(
      point) {
    this.proxy.sendMessage(
        0,
        gfx.mojom.DelegatedInkPointRenderer_StoreDelegatedInkPoint_ParamsSpec.$,
        null,
        [
          point
        ],
        false);
  }

  
  /**
   */

  resetPrediction() {
    this.proxy.sendMessage(
        1,
        gfx.mojom.DelegatedInkPointRenderer_ResetPrediction_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DelegatedInkPointRenderer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
gfx.mojom.DelegatedInkPointRendererReceiver = class {
  /**
   * @param {!gfx.mojom.DelegatedInkPointRendererInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!gfx.mojom.DelegatedInkPointRendererRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        gfx.mojom.DelegatedInkPointRendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!gfx.mojom.DelegatedInkPointRendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        gfx.mojom.DelegatedInkPointRenderer_StoreDelegatedInkPoint_ParamsSpec.$,
        null,
        impl.storeDelegatedInkPoint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        gfx.mojom.DelegatedInkPointRenderer_ResetPrediction_ParamsSpec.$,
        null,
        impl.resetPrediction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
gfx.mojom.DelegatedInkPointRenderer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "gfx.mojom.DelegatedInkPointRenderer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!gfx.mojom.DelegatedInkPointRendererRemote}
   * @export
   */
  static getRemote() {
    let remote = new gfx.mojom.DelegatedInkPointRendererRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DelegatedInkPointRenderer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
gfx.mojom.DelegatedInkPointRendererCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      gfx.mojom.DelegatedInkPointRendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!gfx.mojom.DelegatedInkPointRendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.storeDelegatedInkPoint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        gfx.mojom.DelegatedInkPointRenderer_StoreDelegatedInkPoint_ParamsSpec.$,
        null,
        this.storeDelegatedInkPoint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetPrediction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        gfx.mojom.DelegatedInkPointRenderer_ResetPrediction_ParamsSpec.$,
        null,
        this.resetPrediction.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('gfx.mojom.DelegatedInkPointRenderer_StoreDelegatedInkPoint_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
gfx.mojom.DelegatedInkPointRenderer_StoreDelegatedInkPoint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('gfx.mojom.DelegatedInkPointRenderer_ResetPrediction_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
gfx.mojom.DelegatedInkPointRenderer_ResetPrediction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    gfx.mojom.DelegatedInkPointRenderer_StoreDelegatedInkPoint_ParamsSpec.$,
    'DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params',
    [
      mojo.internal.StructField(
        'point', 0,
        0,
        gfx.mojom.DelegatedInkPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('gfx.mojom.DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params');

/** @record */
gfx.mojom.DelegatedInkPointRenderer_StoreDelegatedInkPoint_Params = class {
  constructor() {
    /** @export { !gfx.mojom.DelegatedInkPoint } */
    this.point;
  }
};



mojo.internal.Struct(
    gfx.mojom.DelegatedInkPointRenderer_ResetPrediction_ParamsSpec.$,
    'DelegatedInkPointRenderer_ResetPrediction_Params',
    [
    ],
    [[0, 8],]);



goog.provide('gfx.mojom.DelegatedInkPointRenderer_ResetPrediction_Params');

/** @record */
gfx.mojom.DelegatedInkPointRenderer_ResetPrediction_Params = class {
  constructor() {
  }
};

