// ui/gfx/mojom/ca_layer_params.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/ca_layer_params.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/ca_layer_params.mojom-params-data.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/ca_layer_params.mojom-blink-import-headers.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace gfx::mojom::blink {
CALayerParams::CALayerParams()
    : is_empty(),
      content(),
      pixel_size(),
      scale_factor() {}

CALayerParams::CALayerParams(
    bool is_empty_in,
    CALayerContentPtr content_in,
    const ::gfx::Size& pixel_size_in,
    float scale_factor_in)
    : is_empty(std::move(is_empty_in)),
      content(std::move(content_in)),
      pixel_size(std::move(pixel_size_in)),
      scale_factor(std::move(scale_factor_in)) {}

CALayerParams::~CALayerParams() = default;

void CALayerParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_empty"), this->is_empty,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content"), this->content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CALayerContentPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_size"), this->pixel_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_factor"), this->scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CALayerParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CALayerContentPtr
CALayerContent::NewCaContextId(
    uint32_t value) {
  return CALayerContentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCaContextId)>,
      std::move(value));
}

CALayerContentPtr
CALayerContent::NewIoSurfaceMachPort(
    ::mojo::PlatformHandle value) {
  return CALayerContentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIoSurfaceMachPort)>,
      std::move(value));
}

CALayerContent::CALayerContent(
    std::in_place_index_t<static_cast<size_t>(Tag::kCaContextId)>,
    uint32_t value)
    : tag_(Tag::kCaContextId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCaContextId)>,
            std::move(value)) {}

CALayerContent::CALayerContent(
    std::in_place_index_t<static_cast<size_t>(Tag::kIoSurfaceMachPort)>,
    ::mojo::PlatformHandle value)
    : tag_(Tag::kIoSurfaceMachPort),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIoSurfaceMachPort)>,
            std::move(value)) {}
CALayerContent::~CALayerContent() {
  DestroyActive();
}

void CALayerContent::set_ca_context_id(uint32_t ca_context_id) {
  if (tag_ != Tag::kCaContextId) {
    DestroyActive();
    tag_ = Tag::kCaContextId;
  }
  data_.ca_context_id = ca_context_id;
}

void CALayerContent::set_io_surface_mach_port(::mojo::PlatformHandle io_surface_mach_port) {
  if (tag_ == Tag::kIoSurfaceMachPort) {
    data_.io_surface_mach_port = std::move(io_surface_mach_port);
  } else {
    DestroyActive();
    tag_ = Tag::kIoSurfaceMachPort;
    new (&data_.io_surface_mach_port) ::mojo::PlatformHandle(
        std::move(io_surface_mach_port));
  }
}


CALayerContent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCaContextId)>,
    uint32_t value)
    : ca_context_id(std::move(value)) {}

CALayerContent::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIoSurfaceMachPort)>,
    ::mojo::PlatformHandle value)
    : io_surface_mach_port(std::move(value)) {}

void CALayerContent::DestroyActive() {
  switch (tag_) {

    case Tag::kCaContextId:
      std::destroy_at(&data_.ca_context_id);
      break;
    case Tag::kIoSurfaceMachPort:
      std::destroy_at(&data_.io_surface_mach_port);
      break;
  }
}

bool CALayerContent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // gfx::mojom::blink


namespace mojo {


// static
bool StructTraits<::gfx::mojom::blink::CALayerParams::DataView, ::gfx::mojom::blink::CALayerParamsPtr>::Read(
    ::gfx::mojom::blink::CALayerParams::DataView input,
    ::gfx::mojom::blink::CALayerParamsPtr* output) {
  bool success = true;
  ::gfx::mojom::blink::CALayerParamsPtr result(::gfx::mojom::blink::CALayerParams::New());
  
      if (success)
        result->is_empty = input.is_empty();
      if (success && !input.ReadContent(&result->content))
        success = false;
      if (success && !input.ReadPixelSize(&result->pixel_size))
        success = false;
      if (success)
        result->scale_factor = input.scale_factor();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::gfx::mojom::blink::CALayerContent::DataView, ::gfx::mojom::blink::CALayerContentPtr>::Read(
    ::gfx::mojom::blink::CALayerContent::DataView input,
    ::gfx::mojom::blink::CALayerContentPtr* output) {
  using UnionType = ::gfx::mojom::blink::CALayerContent;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kCaContextId: {
      *output = UnionType::NewCaContextId(input.ca_context_id());
      break;
    }
    case Tag::kIoSurfaceMachPort: {
      *output = UnionType::NewIoSurfaceMachPort(
          input.TakeIoSurfaceMachPort());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gfx::mojom::blink {




}  // gfx::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif