// ui/gfx/mojom/buffer_types.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/buffer_types.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/buffer_types.mojom-params-data.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/buffer_types.mojom-blink-import-headers.h"
#include "ui/gfx/mojom/buffer_types.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace gfx::mojom::blink {
BufferUsageAndFormat::BufferUsageAndFormat()
    : usage(),
      format() {}

BufferUsageAndFormat::BufferUsageAndFormat(
    ::gfx::BufferUsage usage_in,
    ::gfx::BufferFormat format_in)
    : usage(std::move(usage_in)),
      format(std::move(format_in)) {}

BufferUsageAndFormat::~BufferUsageAndFormat() = default;

void BufferUsageAndFormat::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::BufferUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::BufferFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BufferUsageAndFormat::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuMemoryBufferId::GpuMemoryBufferId()
    : id() {}

GpuMemoryBufferId::GpuMemoryBufferId(
    int32_t id_in)
    : id(std::move(id_in)) {}

GpuMemoryBufferId::~GpuMemoryBufferId() = default;
size_t GpuMemoryBufferId::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->id);
  return seed;
}

void GpuMemoryBufferId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuMemoryBufferId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuMemoryBufferHandle::GpuMemoryBufferHandle()
    : offset(),
      stride(),
      platform_handle() {}

GpuMemoryBufferHandle::GpuMemoryBufferHandle(
    uint32_t offset_in,
    uint32_t stride_in,
    ::gfx::GpuMemoryBufferHandle platform_handle_in)
    : offset(std::move(offset_in)),
      stride(std::move(stride_in)),
      platform_handle(std::move(platform_handle_in)) {}

GpuMemoryBufferHandle::~GpuMemoryBufferHandle() = default;

void GpuMemoryBufferHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stride"), this->stride,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "platform_handle"), this->platform_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuMemoryBufferHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuMemoryBufferHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gfx::mojom::blink


namespace mojo {


// static
bool StructTraits<::gfx::mojom::blink::BufferUsageAndFormat::DataView, ::gfx::mojom::blink::BufferUsageAndFormatPtr>::Read(
    ::gfx::mojom::blink::BufferUsageAndFormat::DataView input,
    ::gfx::mojom::blink::BufferUsageAndFormatPtr* output) {
  bool success = true;
  ::gfx::mojom::blink::BufferUsageAndFormatPtr result(::gfx::mojom::blink::BufferUsageAndFormat::New());
  
      if (success && !input.ReadUsage(&result->usage))
        success = false;
      if (success && !input.ReadFormat(&result->format))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gfx::mojom::blink::GpuMemoryBufferId::DataView, ::gfx::mojom::blink::GpuMemoryBufferIdPtr>::Read(
    ::gfx::mojom::blink::GpuMemoryBufferId::DataView input,
    ::gfx::mojom::blink::GpuMemoryBufferIdPtr* output) {
  bool success = true;
  ::gfx::mojom::blink::GpuMemoryBufferIdPtr result(::gfx::mojom::blink::GpuMemoryBufferId::New());
  
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gfx::mojom::blink::GpuMemoryBufferHandle::DataView, ::gfx::mojom::blink::GpuMemoryBufferHandlePtr>::Read(
    ::gfx::mojom::blink::GpuMemoryBufferHandle::DataView input,
    ::gfx::mojom::blink::GpuMemoryBufferHandlePtr* output) {
  bool success = true;
  ::gfx::mojom::blink::GpuMemoryBufferHandlePtr result(::gfx::mojom::blink::GpuMemoryBufferHandle::New());
  
      if (success)
        result->offset = input.offset();
      if (success)
        result->stride = input.stride();
      if (success && !input.ReadPlatformHandle(&result->platform_handle))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gfx::mojom::blink {




}  // gfx::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif