// ui/gfx/image/mojom/image.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_IMAGE_MOJOM_IMAGE_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_IMAGE_MOJOM_IMAGE_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/image/mojom/image.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"

#include "ui/gfx/image/mojom/image.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::ImageSkiaRepDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::ImageSkiaRepDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::ImageSkiaRep_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::BitmapWithArbitraryBppDataView, send_validation>(
        in_bitmap,
        bitmap_fragment);

      fragment->bitmap.Set(
          bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bitmap.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bitmap in ImageSkiaRep struct");

      fragment->scale = Traits::scale(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::ImageSkiaDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::ImageSkiaDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::ImageSkia_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::image_reps(input)) in_image_reps = Traits::image_reps(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_reps)::BaseType>
          image_reps_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& image_reps_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::ImageSkiaRepDataView>, send_validation>(
        in_image_reps,
        image_reps_fragment,
        &image_reps_validate_params);

      fragment->image_reps.Set(
          image_reps_fragment.is_null() ? nullptr : image_reps_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_reps.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_reps in ImageSkia struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_IMAGE_MOJOM_IMAGE_MOJOM_SEND_VALIDATION_H_