// ui/display/mojom/display_color_management.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/display/mojom/display_color_management.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/display_color_management.mojom-params-data.h"
#include "ui/display/mojom/display_color_management.mojom-shared-message-ids.h"

#include "ui/display/mojom/display_color_management.mojom-blink-import-headers.h"
#include "ui/display/mojom/display_color_management.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace display::mojom::blink {
GammaCurve::GammaCurve()
    : lut() {}

GammaCurve::GammaCurve(
    ::blink::Vector<::display::mojom::blink::GammaRampRGBEntryPtr> lut_in)
    : lut(std::move(lut_in)) {}

GammaCurve::~GammaCurve() = default;

void GammaCurve::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lut"), this->lut,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::display::mojom::blink::GammaRampRGBEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GammaCurve::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ColorCalibration::ColorCalibration()
    : srgb_to_linear(),
      srgb_to_device_matrix(),
      linear_to_device() {}

ColorCalibration::ColorCalibration(
    GammaCurvePtr srgb_to_linear_in,
    const ::skcms_Matrix3x3& srgb_to_device_matrix_in,
    GammaCurvePtr linear_to_device_in)
    : srgb_to_linear(std::move(srgb_to_linear_in)),
      srgb_to_device_matrix(std::move(srgb_to_device_matrix_in)),
      linear_to_device(std::move(linear_to_device_in)) {}

ColorCalibration::~ColorCalibration() = default;

void ColorCalibration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "srgb_to_linear"), this->srgb_to_linear,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GammaCurvePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "srgb_to_device_matrix"), this->srgb_to_device_matrix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::skcms_Matrix3x3&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "linear_to_device"), this->linear_to_device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GammaCurvePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ColorCalibration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ColorTemperatureAdjustment::ColorTemperatureAdjustment()
    : srgb_matrix() {}

ColorTemperatureAdjustment::ColorTemperatureAdjustment(
    const ::skcms_Matrix3x3& srgb_matrix_in)
    : srgb_matrix(std::move(srgb_matrix_in)) {}

ColorTemperatureAdjustment::~ColorTemperatureAdjustment() = default;

void ColorTemperatureAdjustment::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "srgb_matrix"), this->srgb_matrix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::skcms_Matrix3x3&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ColorTemperatureAdjustment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GammaAdjustment::GammaAdjustment()
    : curve() {}

GammaAdjustment::GammaAdjustment(
    GammaCurvePtr curve_in)
    : curve(std::move(curve_in)) {}

GammaAdjustment::~GammaAdjustment() = default;

void GammaAdjustment::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "curve"), this->curve,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GammaCurvePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GammaAdjustment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // display::mojom::blink


namespace mojo {


// static
bool StructTraits<::display::mojom::blink::GammaCurve::DataView, ::display::mojom::blink::GammaCurvePtr>::Read(
    ::display::mojom::blink::GammaCurve::DataView input,
    ::display::mojom::blink::GammaCurvePtr* output) {
  bool success = true;
  ::display::mojom::blink::GammaCurvePtr result(::display::mojom::blink::GammaCurve::New());
  
      if (success && !input.ReadLut(&result->lut))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::display::mojom::blink::ColorCalibration::DataView, ::display::mojom::blink::ColorCalibrationPtr>::Read(
    ::display::mojom::blink::ColorCalibration::DataView input,
    ::display::mojom::blink::ColorCalibrationPtr* output) {
  bool success = true;
  ::display::mojom::blink::ColorCalibrationPtr result(::display::mojom::blink::ColorCalibration::New());
  
      if (success && !input.ReadSrgbToLinear(&result->srgb_to_linear))
        success = false;
      if (success && !input.ReadSrgbToDeviceMatrix(&result->srgb_to_device_matrix))
        success = false;
      if (success && !input.ReadLinearToDevice(&result->linear_to_device))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::display::mojom::blink::ColorTemperatureAdjustment::DataView, ::display::mojom::blink::ColorTemperatureAdjustmentPtr>::Read(
    ::display::mojom::blink::ColorTemperatureAdjustment::DataView input,
    ::display::mojom::blink::ColorTemperatureAdjustmentPtr* output) {
  bool success = true;
  ::display::mojom::blink::ColorTemperatureAdjustmentPtr result(::display::mojom::blink::ColorTemperatureAdjustment::New());
  
      if (success && !input.ReadSrgbMatrix(&result->srgb_matrix))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::display::mojom::blink::GammaAdjustment::DataView, ::display::mojom::blink::GammaAdjustmentPtr>::Read(
    ::display::mojom::blink::GammaAdjustment::DataView input,
    ::display::mojom::blink::GammaAdjustmentPtr* output) {
  bool success = true;
  ::display::mojom::blink::GammaAdjustmentPtr result(::display::mojom::blink::GammaAdjustment::New());
  
      if (success && !input.ReadCurve(&result->curve))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace display::mojom::blink {




}  // display::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif