// ui/base/mojom/window_open_disposition.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_MOJOM_WINDOW_OPEN_DISPOSITION_MOJOM_BLINK_H_
#define UI_BASE_MOJOM_WINDOW_OPEN_DISPOSITION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/mojom/window_open_disposition.mojom-features.h"  // IWYU pragma: export
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"  // IWYU pragma: export
#include "ui/base/mojom/window_open_disposition.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace ui::mojom::blink {








class BLINK_PLATFORM_EXPORT ClickModifiers {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClickModifiers, T>::value>;
  using DataView = ClickModifiersDataView;
  using Data_ = internal::ClickModifiers_Data;

  template <typename... Args>
  static ClickModifiersPtr New(Args&&... args) {
    return ClickModifiersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClickModifiersPtr From(const U& u) {
    return mojo::TypeConverter<ClickModifiersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClickModifiers>::Convert(*this);
  }


  ClickModifiers();

  ClickModifiers(
      bool middle_button,
      bool alt_key,
      bool ctrl_key,
      bool meta_key,
      bool shift_key);


  ~ClickModifiers();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClickModifiersPtr>
  ClickModifiersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClickModifiers::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClickModifiers::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClickModifiers::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClickModifiers::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClickModifiers::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClickModifiers::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClickModifiers_UnserializedMessageContext<
            UserType, ClickModifiers::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClickModifiers::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClickModifiers::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClickModifiers_UnserializedMessageContext<
            UserType, ClickModifiers::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClickModifiers::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool middle_button;
  
  bool alt_key;
  
  bool ctrl_key;
  
  bool meta_key;
  
  bool shift_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClickModifiers::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClickModifiers::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClickModifiers::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClickModifiers::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ClickModifiersPtr ClickModifiers::Clone() const {
  return New(
      mojo::Clone(middle_button),
      mojo::Clone(alt_key),
      mojo::Clone(ctrl_key),
      mojo::Clone(meta_key),
      mojo::Clone(shift_key)
  );
}

template <typename T, ClickModifiers::EnableIfSame<T>*>
bool ClickModifiers::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->middle_button, other_struct.middle_button))
    return false;
  if (!mojo::Equals(this->alt_key, other_struct.alt_key))
    return false;
  if (!mojo::Equals(this->ctrl_key, other_struct.ctrl_key))
    return false;
  if (!mojo::Equals(this->meta_key, other_struct.meta_key))
    return false;
  if (!mojo::Equals(this->shift_key, other_struct.shift_key))
    return false;
  return true;
}

template <typename T, ClickModifiers::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.middle_button < rhs.middle_button)
    return true;
  if (rhs.middle_button < lhs.middle_button)
    return false;
  if (lhs.alt_key < rhs.alt_key)
    return true;
  if (rhs.alt_key < lhs.alt_key)
    return false;
  if (lhs.ctrl_key < rhs.ctrl_key)
    return true;
  if (rhs.ctrl_key < lhs.ctrl_key)
    return false;
  if (lhs.meta_key < rhs.meta_key)
    return true;
  if (rhs.meta_key < lhs.meta_key)
    return false;
  if (lhs.shift_key < rhs.shift_key)
    return true;
  if (rhs.shift_key < lhs.shift_key)
    return false;
  return false;
}


}  // ui::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::ui::mojom::blink::ClickModifiers::DataView,
                                         ::ui::mojom::blink::ClickModifiersPtr> {
  static bool IsNull(const ::ui::mojom::blink::ClickModifiersPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::blink::ClickModifiersPtr* output) { output->reset(); }

  static decltype(::ui::mojom::blink::ClickModifiers::middle_button) middle_button(
      const ::ui::mojom::blink::ClickModifiersPtr& input) {
    return input->middle_button;
  }

  static decltype(::ui::mojom::blink::ClickModifiers::alt_key) alt_key(
      const ::ui::mojom::blink::ClickModifiersPtr& input) {
    return input->alt_key;
  }

  static decltype(::ui::mojom::blink::ClickModifiers::ctrl_key) ctrl_key(
      const ::ui::mojom::blink::ClickModifiersPtr& input) {
    return input->ctrl_key;
  }

  static decltype(::ui::mojom::blink::ClickModifiers::meta_key) meta_key(
      const ::ui::mojom::blink::ClickModifiersPtr& input) {
    return input->meta_key;
  }

  static decltype(::ui::mojom::blink::ClickModifiers::shift_key) shift_key(
      const ::ui::mojom::blink::ClickModifiersPtr& input) {
    return input->shift_key;
  }

  static bool Read(::ui::mojom::blink::ClickModifiers::DataView input, ::ui::mojom::blink::ClickModifiersPtr* output);
};

}  // namespace mojo

#endif  // UI_BASE_MOJOM_WINDOW_OPEN_DISPOSITION_MOJOM_BLINK_H_