// ui/base/cursor/mojom/cursor.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_CURSOR_MOJOM_CURSOR_MOJOM_SEND_VALIDATION_H_
#define UI_BASE_CURSOR_MOJOM_CURSOR_MOJOM_SEND_VALIDATION_H_

#include "ui/base/cursor/mojom/cursor.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/base/cursor/mojom/cursor_type.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "ui/base/cursor/mojom/cursor.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::CursorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::CursorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::Cursor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::ui::mojom::CursorType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::hotspot(input)) in_hotspot = Traits::hotspot(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hotspot)::BaseType> hotspot_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_hotspot,
        hotspot_fragment);

      fragment->hotspot.Set(
          hotspot_fragment.is_null() ? nullptr : hotspot_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hotspot.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hotspot in Cursor struct");

      decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::BitmapN32DataView, send_validation>(
        in_bitmap,
        bitmap_fragment);

      fragment->bitmap.Set(
          bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

      fragment->image_scale_factor = Traits::image_scale_factor(input);
  }
};

}  // namespace mojo::internal

#endif  // UI_BASE_CURSOR_MOJOM_CURSOR_MOJOM_SEND_VALIDATION_H_