// ui/base/accelerators/mojom/accelerator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/base/accelerators/mojom/accelerator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/accelerators/mojom/accelerator.mojom-params-data.h"
#include "ui/base/accelerators/mojom/accelerator.mojom-shared-message-ids.h"

#include "ui/base/accelerators/mojom/accelerator.mojom-import-headers.h"
#include "ui/base/accelerators/mojom/accelerator.mojom-test-utils.h"


namespace ui::mojom {
Accelerator::Accelerator()
    : key_code(),
      key_state(),
      modifiers(),
      time_stamp() {}

Accelerator::Accelerator(
    int32_t key_code_in,
    ::ui::Accelerator::KeyState key_state_in,
    int32_t modifiers_in,
    ::base::TimeTicks time_stamp_in)
    : key_code(std::move(key_code_in)),
      key_state(std::move(key_state_in)),
      modifiers(std::move(modifiers_in)),
      time_stamp(std::move(time_stamp_in)) {}

Accelerator::~Accelerator() = default;

void Accelerator::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_code"), this->key_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_state"), this->key_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::Accelerator::KeyState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_stamp"), this->time_stamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Accelerator::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ui::mojom


namespace mojo {


// static
bool StructTraits<::ui::mojom::Accelerator::DataView, ::ui::mojom::AcceleratorPtr>::Read(
    ::ui::mojom::Accelerator::DataView input,
    ::ui::mojom::AcceleratorPtr* output) {
  bool success = true;
  ::ui::mojom::AcceleratorPtr result(::ui::mojom::Accelerator::New());
  
      if (success)
        result->key_code = input.key_code();
      if (success && !input.ReadKeyState(&result->key_state))
        success = false;
      if (success)
        result->modifiers = input.modifiers();
      if (success && !input.ReadTimeStamp(&result->time_stamp))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ui::mojom {




}  // ui::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif