// ui/base/accelerators/mojom/accelerator.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_DATA_VIEW_H_
#define UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/base/accelerators/mojom/accelerator.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/events/mojom/keyboard_codes.mojom-shared.h"


namespace ui::mojom {
class AcceleratorDataView;



}  // ui::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::AcceleratorDataView> {
  using Data = ::ui::mojom::internal::Accelerator_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


enum class AcceleratorKeyState : int32_t {
  
  PRESSED = 0,
  
  RELEASED = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, AcceleratorKeyState value);
inline bool IsKnownEnumValue(AcceleratorKeyState value) {
  return internal::AcceleratorKeyState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AcceleratorDataView {
 public:
  AcceleratorDataView() = default;

  AcceleratorDataView(
      internal::Accelerator_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t key_code() const {
    return data_->key_code;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadKeyState(UserType* output) const {
    auto data_value = data_->key_state;
    return mojo::internal::Deserialize<::ui::mojom::AcceleratorKeyState>(
        data_value, output);
  }
  AcceleratorKeyState key_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::AcceleratorKeyState>(data_->key_state));
  }
  int32_t modifiers() const {
    return data_->modifiers;
  }
  inline void GetTimeStampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeStamp(UserType* output) {
    
    auto* pointer = data_->time_stamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::Accelerator_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ui::mojom

#endif  // UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_DATA_VIEW_H_