// ui/accessibility/mojom/ax_updates_and_events.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/accessibility/mojom/ax_updates_and_events.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');
  var ax_event$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_event.mojom', 'ax_event.mojom.js');
  }
  var ax_tree_id$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_id.mojom', 'ax_tree_id.mojom.js');
  }
  var ax_tree_update$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_update.mojom', 'ax_tree_update.mojom.js');
  }



  function AXUpdatesAndEvents(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXUpdatesAndEvents.prototype.initDefaults_ = function() {
    this.treeId = null;
    this.updates = null;
    this.events = null;
  };
  AXUpdatesAndEvents.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXUpdatesAndEvents.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXUpdatesAndEvents.treeId
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ax_tree_id$.AXTreeID, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXUpdatesAndEvents.updates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(ax_tree_update$.AXTreeUpdate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXUpdatesAndEvents.events
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(ax_event$.AXEvent), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AXUpdatesAndEvents.encodedSize = codec.kStructHeaderSize + 32;

  AXUpdatesAndEvents.decode = function(decoder) {
    var packed;
    var val = new AXUpdatesAndEvents();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.treeId =
        decoder.decodeStruct(ax_tree_id$.AXTreeID);
    val.updates =
        decoder.decodeArrayPointer(new codec.PointerTo(ax_tree_update$.AXTreeUpdate));
    val.events =
        decoder.decodeArrayPointer(new codec.PointerTo(ax_event$.AXEvent));
    return val;
  };

  AXUpdatesAndEvents.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXUpdatesAndEvents.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ax_tree_id$.AXTreeID, val.treeId);
    encoder.encodeArrayPointer(new codec.PointerTo(ax_tree_update$.AXTreeUpdate), val.updates);
    encoder.encodeArrayPointer(new codec.PointerTo(ax_event$.AXEvent), val.events);
  };
  exports.AXUpdatesAndEvents = AXUpdatesAndEvents;
})();