// ui/accessibility/mojom/ax_updates_and_events.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_H_
#define UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_updates_and_events.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_updates_and_events.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_updates_and_events.mojom-forward.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_event.mojom.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include <string>
#include <vector>




#include "ui/accessibility/mojom/ax_updates_and_events_mojom_traits.h"




namespace ax::mojom {








class  AXUpdatesAndEvents {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXUpdatesAndEvents, T>::value>;
  using DataView = AXUpdatesAndEventsDataView;
  using Data_ = internal::AXUpdatesAndEvents_Data;

  template <typename... Args>
  static AXUpdatesAndEventsPtr New(Args&&... args) {
    return AXUpdatesAndEventsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXUpdatesAndEventsPtr From(const U& u) {
    return mojo::TypeConverter<AXUpdatesAndEventsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXUpdatesAndEvents>::Convert(*this);
  }


  AXUpdatesAndEvents();

  AXUpdatesAndEvents(
      const ::ui::AXTreeID& tree_id,
      std::vector<::ui::AXTreeUpdate> updates,
      std::vector<::ui::AXEvent> events);


  ~AXUpdatesAndEvents();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXUpdatesAndEventsPtr>
  AXUpdatesAndEventsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXUpdatesAndEvents::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXUpdatesAndEvents::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXUpdatesAndEvents::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXUpdatesAndEvents_UnserializedMessageContext<
            UserType, AXUpdatesAndEvents::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXUpdatesAndEvents::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXUpdatesAndEvents::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXUpdatesAndEvents_UnserializedMessageContext<
            UserType, AXUpdatesAndEvents::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXUpdatesAndEvents::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ui::AXTreeID tree_id;
  
  std::vector<::ui::AXTreeUpdate> updates;
  
  std::vector<::ui::AXEvent> events;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AXUpdatesAndEventsPtr AXUpdatesAndEvents::Clone() const {
  return New(
      mojo::Clone(tree_id),
      mojo::Clone(updates),
      mojo::Clone(events)
  );
}

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>*>
bool AXUpdatesAndEvents::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tree_id, other_struct.tree_id))
    return false;
  if (!mojo::Equals(this->updates, other_struct.updates))
    return false;
  if (!mojo::Equals(this->events, other_struct.events))
    return false;
  return true;
}

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tree_id < rhs.tree_id)
    return true;
  if (rhs.tree_id < lhs.tree_id)
    return false;
  if (lhs.updates < rhs.updates)
    return true;
  if (rhs.updates < lhs.updates)
    return false;
  if (lhs.events < rhs.events)
    return true;
  if (rhs.events < lhs.events)
    return false;
  return false;
}


}  // ax::mojom

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::AXUpdatesAndEvents::DataView,
                                         ::ax::mojom::AXUpdatesAndEventsPtr> {
  static bool IsNull(const ::ax::mojom::AXUpdatesAndEventsPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::AXUpdatesAndEventsPtr* output) { output->reset(); }

  static const decltype(::ax::mojom::AXUpdatesAndEvents::tree_id)& tree_id(
      const ::ax::mojom::AXUpdatesAndEventsPtr& input) {
    return input->tree_id;
  }

  static const decltype(::ax::mojom::AXUpdatesAndEvents::updates)& updates(
      const ::ax::mojom::AXUpdatesAndEventsPtr& input) {
    return input->updates;
  }

  static const decltype(::ax::mojom::AXUpdatesAndEvents::events)& events(
      const ::ax::mojom::AXUpdatesAndEventsPtr& input) {
    return input->events;
  }

  static bool Read(::ax::mojom::AXUpdatesAndEvents::DataView input, ::ax::mojom::AXUpdatesAndEventsPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_H_