// ui/accessibility/mojom/ax_updates_and_events.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_BLINK_H_
#define UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_updates_and_events.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_updates_and_events.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_updates_and_events.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_event.mojom-blink.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-blink.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace ax::mojom::blink {








class  AXUpdatesAndEvents {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXUpdatesAndEvents, T>::value>;
  using DataView = AXUpdatesAndEventsDataView;
  using Data_ = internal::AXUpdatesAndEvents_Data;

  template <typename... Args>
  static AXUpdatesAndEventsPtr New(Args&&... args) {
    return AXUpdatesAndEventsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXUpdatesAndEventsPtr From(const U& u) {
    return mojo::TypeConverter<AXUpdatesAndEventsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXUpdatesAndEvents>::Convert(*this);
  }


  AXUpdatesAndEvents();

  AXUpdatesAndEvents(
      ::ax::mojom::blink::AXTreeIDPtr tree_id,
      ::blink::Vector<::ax::mojom::blink::AXTreeUpdatePtr> updates,
      ::blink::Vector<::ax::mojom::blink::AXEventPtr> events);

AXUpdatesAndEvents(const AXUpdatesAndEvents&) = delete;
AXUpdatesAndEvents& operator=(const AXUpdatesAndEvents&) = delete;

  ~AXUpdatesAndEvents();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXUpdatesAndEventsPtr>
  AXUpdatesAndEventsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXUpdatesAndEvents::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXUpdatesAndEvents::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXUpdatesAndEvents::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXUpdatesAndEvents_UnserializedMessageContext<
            UserType, AXUpdatesAndEvents::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXUpdatesAndEvents::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXUpdatesAndEvents::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXUpdatesAndEvents_UnserializedMessageContext<
            UserType, AXUpdatesAndEvents::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXUpdatesAndEvents::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ax::mojom::blink::AXTreeIDPtr tree_id;
  
  ::blink::Vector<::ax::mojom::blink::AXTreeUpdatePtr> updates;
  
  ::blink::Vector<::ax::mojom::blink::AXEventPtr> events;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AXUpdatesAndEventsPtr AXUpdatesAndEvents::Clone() const {
  return New(
      mojo::Clone(tree_id),
      mojo::Clone(updates),
      mojo::Clone(events)
  );
}

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>*>
bool AXUpdatesAndEvents::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tree_id, other_struct.tree_id))
    return false;
  if (!mojo::Equals(this->updates, other_struct.updates))
    return false;
  if (!mojo::Equals(this->events, other_struct.events))
    return false;
  return true;
}

template <typename T, AXUpdatesAndEvents::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tree_id < rhs.tree_id)
    return true;
  if (rhs.tree_id < lhs.tree_id)
    return false;
  if (lhs.updates < rhs.updates)
    return true;
  if (rhs.updates < lhs.updates)
    return false;
  if (lhs.events < rhs.events)
    return true;
  if (rhs.events < lhs.events)
    return false;
  return false;
}


}  // ax::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::blink::AXUpdatesAndEvents::DataView,
                                         ::ax::mojom::blink::AXUpdatesAndEventsPtr> {
  static bool IsNull(const ::ax::mojom::blink::AXUpdatesAndEventsPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::blink::AXUpdatesAndEventsPtr* output) { output->reset(); }

  static const decltype(::ax::mojom::blink::AXUpdatesAndEvents::tree_id)& tree_id(
      const ::ax::mojom::blink::AXUpdatesAndEventsPtr& input) {
    return input->tree_id;
  }

  static const decltype(::ax::mojom::blink::AXUpdatesAndEvents::updates)& updates(
      const ::ax::mojom::blink::AXUpdatesAndEventsPtr& input) {
    return input->updates;
  }

  static const decltype(::ax::mojom::blink::AXUpdatesAndEvents::events)& events(
      const ::ax::mojom::blink::AXUpdatesAndEventsPtr& input) {
    return input->events;
  }

  static bool Read(::ax::mojom::blink::AXUpdatesAndEvents::DataView input, ::ax::mojom::blink::AXUpdatesAndEventsPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_BLINK_H_