/**
 * Lighthouse v12.8.2 (Aug 28 2025)
 *
 * Automated auditing, performance metrics, and best practices for the web.
 *
 * @homepage https://github.com/GoogleChrome/lighthouse#readme
 * @author   Copyright 2025 Google LLC
 * @license  Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */
"use strict";(()=>{var SJ=Object.create;var Pd=Object.defineProperty;var CJ=Object.getOwnPropertyDescriptor;var IJ=Object.getOwnPropertyNames;var kJ=Object.getPrototypeOf,RJ=Object.prototype.hasOwnProperty;var i=(e,t)=>Pd(e,"name",{value:t,configurable:!0});var g=(e,t)=>()=>(e&&(t=e(e=0)),t);var je=(e,t)=>()=>(t||e((t={exports:{}}).exports,t),t.exports),C=(e,t)=>{for(var r in t)Pd(e,r,{get:t[r],enumerable:!0})},KM=(e,t,r,n)=>{if(t&&typeof t=="object"||typeof t=="function")for(let a of IJ(t))!RJ.call(e,a)&&a!==r&&Pd(e,a,{get:()=>t[a],enumerable:!(n=CJ(t,a))||n.enumerable});return e};var Kr=(e,t,r)=>(r=e!=null?SJ(kJ(e)):{},KM(t||!e||!e.__esModule?Pd(r,"default",{value:e,enumerable:!0}):r,e)),_J=e=>KM(Pd({},"__esModule",{value:!0}),e);function JM(){throw new Error("setTimeout has not been defined")}function XM(){throw new Error("clearTimeout has not been defined")}function ZM(e){if(ji===setTimeout)return setTimeout(e,0);if((ji===JM||!ji)&&setTimeout)return ji=setTimeout,setTimeout(e,0);try{return ji(e,0)}catch{try{return ji.call(null,e,0)}catch{return ji.call(this,e,0)}}}function AJ(e){if(qi===clearTimeout)return clearTimeout(e);if((qi===XM||!qi)&&clearTimeout)return qi=clearTimeout,clearTimeout(e);try{return qi(e)}catch{try{return qi.call(null,e)}catch{return qi.call(this,e)}}}function FJ(){!vu||!rc||(vu=!1,rc.length?Uo=rc.concat(Uo):ng=-1,Uo.length&&QM())}function QM(){if(!vu){var e=ZM(FJ);vu=!0;for(var t=Uo.length;t;){for(rc=Uo,Uo=[];++ng<t;)rc&&rc[ng].run();ng=-1,t=Uo.length}rc=null,vu=!1,AJ(e)}}function hn(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var r=1;r<arguments.length;r++)t[r-1]=arguments[r];Uo.push(new eO(e,t)),Uo.length===1&&!vu&&ZM(QM)}function eO(e,t){this.fun=e,this.array=t}function nc(){}
function KJ(e){throw new Error("process.binding is not supported")}function JJ(){return"/"}function XJ(e){throw new Error("process.chdir is not supported")}function ZJ(){return 0}function eX(e){var t=QJ.call(yu)*.001,r=Math.floor(t),n=Math.floor(t%1*1e9);return e&&(r=r-e[0],n=n-e[1],n<0&&(r--,n+=1e9)),[r,n]}function rX(){var e=new Date,t=e-tX;return t/1e3}var ji,qi,Uo,vu,rc,ng,MJ,OJ,NJ,LJ,PJ,BJ,UJ,jJ,qJ,zJ,HJ,GJ,WJ,VJ,$J,YJ,yu,QJ,tX,gn,zi=g(()=>{d();i(JM,"defaultSetTimout");i(XM,"defaultClearTimeout");ji=JM,qi=XM;typeof globalThis.setTimeout=="function"&&(ji=setTimeout);typeof globalThis.clearTimeout=="function"&&(qi=clearTimeout);i(ZM,"runTimeout");i(AJ,"runClearTimeout");Uo=[],vu=!1,ng=-1;i(FJ,"cleanUpNextTick");i(QM,"drainQueue");i(hn,"nextTick");i(eO,"Item");eO.prototype.run=function(){this.fun.apply(null,this.array)};MJ="browser",OJ="browser",NJ=!0,LJ={},PJ=[],BJ="",UJ={},jJ={},qJ={};i(nc,"noop");zJ=nc,HJ=nc,GJ=nc,WJ=nc,VJ=nc,$J=nc,YJ=nc;i(KJ,"binding");i(JJ,"cwd");i(XJ,"chdir");i(
ZJ,"umask");yu=globalThis.performance||{},QJ=yu.now||yu.mozNow||yu.msNow||yu.oNow||yu.webkitNow||function(){return new Date().getTime()};i(eX,"hrtime");tX=new Date;i(rX,"uptime");gn={nextTick:hn,title:MJ,browser:NJ,env:LJ,argv:PJ,version:BJ,versions:UJ,on:zJ,addListener:HJ,once:GJ,off:WJ,removeListener:VJ,removeAllListeners:$J,emit:YJ,binding:KJ,cwd:JJ,chdir:XJ,umask:ZJ,hrtime:eX,platform:OJ,release:jJ,config:qJ,uptime:rX}});var d=g(()=>{"use strict";zi();globalThis.process=gn});function aO(){Jb=!0;for(var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",t=0,r=e.length;t<r;++t)oo[t]=e[t],ha[e.charCodeAt(t)]=t;ha[45]=62,ha[95]=63}function aX(e){Jb||aO();var t,r,n,a,o,s,c=e.length;if(c%4>0)throw new Error("Invalid string. Length must be a multiple of 4");o=e[c-2]==="="?2:e[c-1]==="="?1:0,s=new nX(c*3/4-o),n=o>0?c-4:c;var u=0;for(t=0,r=0;t<n;t+=4,r+=3)a=ha[e.charCodeAt(t)]<<18|ha[e.charCodeAt(t+1)]<<12|ha[e.charCodeAt(t+2)]<<6|ha[e.charCodeAt(t+3)],s[u++]=a>>16&255,s[u++]=a>>8&255,s[u++]=a&255;return o===2?(a=ha[e.charCodeAt(t)]<<2|ha[e.charCodeAt(t+1)]>>4,s[u++]=a&255):o===1&&(a=ha[e.charCodeAt(t)]<<10|ha[e.charCodeAt(t+1)]<<4|ha[e.charCodeAt(t+2)]>>2,s[u++]=a>>8&255,s[u++]=a&255),s}function oX(e){return oo[e>>18&63]+oo[e>>12&63]+oo[e>>6&63]+oo[e&63]}function iX(e,t,r){for(var n,a=[],o=t;o<r;o+=3)n=(e[o]<<16)+(e[o+1]<<8)+e[o+2],a.push(oX(n));return a.join("")}function tO(e){Jb||aO();for(var t,r=e.length,n=r%3,a="",o=[],s=16383,c=0,u=r-n;c<u;c+=
s)o.push(iX(e,c,c+s>u?u:c+s));return n===1?(t=e[r-1],a+=oo[t>>2],a+=oo[t<<4&63],a+="=="):n===2&&(t=(e[r-2]<<8)+e[r-1],a+=oo[t>>10],a+=oo[t>>4&63],a+=oo[t<<2&63],a+="="),o.push(a),o.join("")}function ig(e,t,r,n,a){var o,s,c=a*8-n-1,u=(1<<c)-1,l=u>>1,m=-7,p=r?a-1:0,f=r?-1:1,h=e[t+p];for(p+=f,o=h&(1<<-m)-1,h>>=-m,m+=c;m>0;o=o*256+e[t+p],p+=f,m-=8);for(s=o&(1<<-m)-1,o>>=-m,m+=n;m>0;s=s*256+e[t+p],p+=f,m-=8);if(o===0)o=1-l;else{if(o===u)return s?NaN:(h?-1:1)*(1/0);s=s+Math.pow(2,n),o=o-l}return(h?-1:1)*s*Math.pow(2,o-n)}function oO(e,t,r,n,a,o){var s,c,u,l=o*8-a-1,m=(1<<l)-1,p=m>>1,f=a===23?Math.pow(2,-24)-Math.pow(2,-77):0,h=n?0:o-1,y=n?1:-1,v=t<0||t===0&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(c=isNaN(t)?1:0,s=m):(s=Math.floor(Math.log(t)/Math.LN2),t*(u=Math.pow(2,-s))<1&&(s--,u*=2),s+p>=1?t+=f/u:t+=f*Math.pow(2,1-p),t*u>=2&&(s++,u/=2),s+p>=m?(c=0,s=m):s+p>=1?(c=(t*u-1)*Math.pow(2,a),s=s+p):(c=t*Math.pow(2,p-1)*Math.pow(2,a),s=0));a>=8;e[r+h]=c&255,h+=y,c/=256,a-=8);for(s=s<<a|c,l+=
a;l>0;e[r+h]=s&255,h+=y,s/=256,l-=8);e[r+h-y]|=v*128}function ag(){return oe.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function jo(e,t){if(ag()<t)throw new RangeError("Invalid typed array length");return oe.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t),e.__proto__=oe.prototype):(e===null&&(e=new oe(t)),e.length=t),e}function oe(e,t,r){if(!oe.TYPED_ARRAY_SUPPORT&&!(this instanceof oe))return new oe(e,t,r);if(typeof e=="number"){if(typeof t=="string")throw new Error("If encoding is specified then the first argument must be a string");return Xb(this,e)}return sO(this,e,t,r)}function sO(e,t,r,n){if(typeof t=="number")throw new TypeError('"value" argument must not be a number');return typeof ArrayBuffer<"u"&&t instanceof ArrayBuffer?dX(e,t,r,n):typeof t=="string"?lX(e,t,r):mX(e,t)}function cO(e){if(typeof e!="number")throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function uX(e,t,r,n){return cO(t),t<=0?jo(e,t):r!==void 0?
typeof n=="string"?jo(e,t).fill(r,n):jo(e,t).fill(r):jo(e,t)}function Xb(e,t){if(cO(t),e=jo(e,t<0?0:Zb(t)|0),!oe.TYPED_ARRAY_SUPPORT)for(var r=0;r<t;++r)e[r]=0;return e}function lX(e,t,r){if((typeof r!="string"||r==="")&&(r="utf8"),!oe.isEncoding(r))throw new TypeError('"encoding" must be a valid string encoding');var n=uO(t,r)|0;e=jo(e,n);var a=e.write(t,r);return a!==n&&(e=e.slice(0,a)),e}function Kb(e,t){var r=t.length<0?0:Zb(t.length)|0;e=jo(e,r);for(var n=0;n<r;n+=1)e[n]=t[n]&255;return e}function dX(e,t,r,n){if(t.byteLength,r<0||t.byteLength<r)throw new RangeError("'offset' is out of bounds");if(t.byteLength<r+(n||0))throw new RangeError("'length' is out of bounds");return r===void 0&&n===void 0?t=new Uint8Array(t):n===void 0?t=new Uint8Array(t,r):t=new Uint8Array(t,r,n),oe.TYPED_ARRAY_SUPPORT?(e=t,e.__proto__=oe.prototype):e=Kb(e,t),e}function mX(e,t){if(io(t)){var r=Zb(t.length)|0;return e=jo(e,r),e.length===0||t.copy(e,0,0,r),e}if(t){if(typeof ArrayBuffer<"u"&&t.buffer instanceof
ArrayBuffer||"length"in t)return typeof t.length!="number"||AX(t.length)?jo(e,0):Kb(e,t);if(t.type==="Buffer"&&iO(t.data))return Kb(e,t.data)}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}function Zb(e){if(e>=ag())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+ag().toString(16)+" bytes");return e|0}function io(e){return!!(e!=null&&e._isBuffer)}function uO(e,t){if(io(e))return e.length;if(typeof ArrayBuffer<"u"&&typeof ArrayBuffer.isView=="function"&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;typeof e!="string"&&(e=""+e);var r=e.length;if(r===0)return 0;for(var n=!1;;)switch(t){case"ascii":case"latin1":case"binary":return r;case"utf8":case"utf-8":case void 0:return og(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return r*2;case"hex":return r>>>1;case"base64":return gO(e).length;default:if(n)return og(e).length;t=(""+t).toLowerCase(),n=!0}}function pX(e,t,r){
var n=!1;if((t===void 0||t<0)&&(t=0),t>this.length||((r===void 0||r>this.length)&&(r=this.length),r<=0)||(r>>>=0,t>>>=0,r<=t))return"";for(e||(e="utf8");;)switch(e){case"hex":return TX(this,t,r);case"utf8":case"utf-8":return mO(this,t,r);case"ascii":return EX(this,t,r);case"latin1":case"binary":return DX(this,t,r);case"base64":return bX(this,t,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return xX(this,t,r);default:if(n)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),n=!0}}function ac(e,t,r){var n=e[t];e[t]=e[r],e[r]=n}function lO(e,t,r,n,a){if(e.length===0)return-1;if(typeof r=="string"?(n=r,r=0):r>2147483647?r=2147483647:r<-2147483648&&(r=-2147483648),r=+r,isNaN(r)&&(r=a?0:e.length-1),r<0&&(r=e.length+r),r>=e.length){if(a)return-1;r=e.length-1}else if(r<0)if(a)r=0;else return-1;if(typeof t=="string"&&(t=oe.from(t,n)),io(t))return t.length===0?-1:rO(e,t,r,n,a);if(typeof t=="number")return t=t&255,oe.TYPED_ARRAY_SUPPORT&&typeof Uint8Array.prototype.indexOf==
"function"?a?Uint8Array.prototype.indexOf.call(e,t,r):Uint8Array.prototype.lastIndexOf.call(e,t,r):rO(e,[t],r,n,a);throw new TypeError("val must be string, number or Buffer")}function rO(e,t,r,n,a){var o=1,s=e.length,c=t.length;if(n!==void 0&&(n=String(n).toLowerCase(),n==="ucs2"||n==="ucs-2"||n==="utf16le"||n==="utf-16le")){if(e.length<2||t.length<2)return-1;o=2,s/=2,c/=2,r/=2}function u(h,y){return o===1?h[y]:h.readUInt16BE(y*o)}i(u,"read");var l;if(a){var m=-1;for(l=r;l<s;l++)if(u(e,l)===u(t,m===-1?0:l-m)){if(m===-1&&(m=l),l-m+1===c)return m*o}else m!==-1&&(l-=l-m),m=-1}else for(r+c>s&&(r=s-c),l=r;l>=0;l--){for(var p=!0,f=0;f<c;f++)if(u(e,l+f)!==u(t,f)){p=!1;break}if(p)return l}return-1}function fX(e,t,r,n){r=Number(r)||0;var a=e.length-r;n?(n=Number(n),n>a&&(n=a)):n=a;var o=t.length;if(o%2!==0)throw new TypeError("Invalid hex string");n>o/2&&(n=o/2);for(var s=0;s<n;++s){var c=parseInt(t.substr(s*2,2),16);if(isNaN(c))return s;e[r+s]=c}return s}function hX(e,t,r,n){return ug(og(t,e.length-
r),e,r,n)}function dO(e,t,r,n){return ug(RX(t),e,r,n)}function gX(e,t,r,n){return dO(e,t,r,n)}function yX(e,t,r,n){return ug(gO(t),e,r,n)}function vX(e,t,r,n){return ug(_X(t,e.length-r),e,r,n)}function bX(e,t,r){return t===0&&r===e.length?tO(e):tO(e.slice(t,r))}function mO(e,t,r){r=Math.min(e.length,r);for(var n=[],a=t;a<r;){var o=e[a],s=null,c=o>239?4:o>223?3:o>191?2:1;if(a+c<=r){var u,l,m,p;switch(c){case 1:o<128&&(s=o);break;case 2:u=e[a+1],(u&192)===128&&(p=(o&31)<<6|u&63,p>127&&(s=p));break;case 3:u=e[a+1],l=e[a+2],(u&192)===128&&(l&192)===128&&(p=(o&15)<<12|(u&63)<<6|l&63,p>2047&&(p<55296||p>57343)&&(s=p));break;case 4:u=e[a+1],l=e[a+2],m=e[a+3],(u&192)===128&&(l&192)===128&&(m&192)===128&&(p=(o&15)<<18|(u&63)<<12|(l&63)<<6|m&63,p>65535&&p<1114112&&(s=p))}}s===null?(s=65533,c=1):s>65535&&(s-=65536,n.push(s>>>10&1023|55296),s=56320|s&1023),n.push(s),a+=c}return wX(n)}function wX(e){var t=e.length;if(t<=nO)return String.fromCharCode.apply(String,e);for(var r="",n=0;n<t;)r+=String.fromCharCode.
apply(String,e.slice(n,n+=nO));return r}function EX(e,t,r){var n="";r=Math.min(e.length,r);for(var a=t;a<r;++a)n+=String.fromCharCode(e[a]&127);return n}function DX(e,t,r){var n="";r=Math.min(e.length,r);for(var a=t;a<r;++a)n+=String.fromCharCode(e[a]);return n}function TX(e,t,r){var n=e.length;(!t||t<0)&&(t=0),(!r||r<0||r>n)&&(r=n);for(var a="",o=t;o<r;++o)a+=kX(e[o]);return a}function xX(e,t,r){for(var n=e.slice(t,r),a="",o=0;o<n.length;o+=2)a+=String.fromCharCode(n[o]+n[o+1]*256);return a}function Jr(e,t,r){if(e%1!==0||e<0)throw new RangeError("offset is not uint");if(e+t>r)throw new RangeError("Trying to access beyond buffer length")}function Wn(e,t,r,n,a,o){if(!io(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>a||t<o)throw new RangeError('"value" argument is out of bounds');if(r+n>e.length)throw new RangeError("Index out of range")}function sg(e,t,r,n){t<0&&(t=65535+t+1);for(var a=0,o=Math.min(e.length-r,2);a<o;++a)e[r+a]=(t&255<<8*(n?a:1-a))>>>(n?a:1-a)*
8}function cg(e,t,r,n){t<0&&(t=4294967295+t+1);for(var a=0,o=Math.min(e.length-r,4);a<o;++a)e[r+a]=t>>>(n?a:3-a)*8&255}function pO(e,t,r,n,a,o){if(r+n>e.length)throw new RangeError("Index out of range");if(r<0)throw new RangeError("Index out of range")}function fO(e,t,r,n,a){return a||pO(e,t,r,4),oO(e,t,r,n,23,4),r+4}function hO(e,t,r,n,a){return a||pO(e,t,r,8),oO(e,t,r,n,52,8),r+8}function CX(e){if(e=IX(e).replace(SX,""),e.length<2)return"";for(;e.length%4!==0;)e=e+"=";return e}function IX(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}function kX(e){return e<16?"0"+e.toString(16):e.toString(16)}function og(e,t){t=t||1/0;for(var r,n=e.length,a=null,o=[],s=0;s<n;++s){if(r=e.charCodeAt(s),r>55295&&r<57344){if(!a){if(r>56319){(t-=3)>-1&&o.push(239,191,189);continue}else if(s+1===n){(t-=3)>-1&&o.push(239,191,189);continue}a=r;continue}if(r<56320){(t-=3)>-1&&o.push(239,191,189),a=r;continue}r=(a-55296<<10|r-56320)+65536}else a&&(t-=3)>-1&&o.push(239,191,189);if(a=null,r<128){if((t-=1)<
0)break;o.push(r)}else if(r<2048){if((t-=2)<0)break;o.push(r>>6|192,r&63|128)}else if(r<65536){if((t-=3)<0)break;o.push(r>>12|224,r>>6&63|128,r&63|128)}else if(r<1114112){if((t-=4)<0)break;o.push(r>>18|240,r>>12&63|128,r>>6&63|128,r&63|128)}else throw new Error("Invalid code point")}return o}function RX(e){for(var t=[],r=0;r<e.length;++r)t.push(e.charCodeAt(r)&255);return t}function _X(e,t){for(var r,n,a,o=[],s=0;s<e.length&&!((t-=2)<0);++s)r=e.charCodeAt(s),n=r>>8,a=r%256,o.push(a),o.push(n);return o}function gO(e){return aX(CX(e))}function ug(e,t,r,n){for(var a=0;a<n&&!(a+r>=t.length||a>=e.length);++a)t[a+r]=e[a];return a}function AX(e){return e!==e}function FX(e){return e!=null&&(!!e._isBuffer||yO(e)||MX(e))}function yO(e){return!!e.constructor&&typeof e.constructor.isBuffer=="function"&&e.constructor.isBuffer(e)}function MX(e){return typeof e.readFloatLE=="function"&&typeof e.slice=="function"&&yO(e.slice(0,0))}var oo,ha,nX,Jb,sX,iO,cX,Jxe,nO,SX,bu=g(()=>{d();oo=[],ha=[],nX=typeof Uint8Array<
"u"?Uint8Array:Array,Jb=!1;i(aO,"init");i(aX,"toByteArray");i(oX,"tripletToBase64");i(iX,"encodeChunk");i(tO,"fromByteArray");i(ig,"read");i(oO,"write");sX={}.toString,iO=Array.isArray||function(e){return sX.call(e)=="[object Array]"};cX=50;oe.TYPED_ARRAY_SUPPORT=globalThis.TYPED_ARRAY_SUPPORT!==void 0?globalThis.TYPED_ARRAY_SUPPORT:!0;Jxe=ag();i(ag,"kMaxLength");i(jo,"createBuffer");i(oe,"Buffer");oe.poolSize=8192;oe._augment=function(e){return e.__proto__=oe.prototype,e};i(sO,"from");oe.from=function(e,t,r){return sO(null,e,t,r)};oe.TYPED_ARRAY_SUPPORT&&(oe.prototype.__proto__=Uint8Array.prototype,oe.__proto__=Uint8Array,typeof Symbol<"u"&&Symbol.species&&oe[Symbol.species]);i(cO,"assertSize");i(uX,"alloc");oe.alloc=function(e,t,r){return uX(null,e,t,r)};i(Xb,"allocUnsafe");oe.allocUnsafe=function(e){return Xb(null,e)};oe.allocUnsafeSlow=function(e){return Xb(null,e)};i(lX,"fromString");i(Kb,"fromArrayLike");i(dX,"fromArrayBuffer");i(mX,"fromObject");i(Zb,"checked");oe.isBuffer=FX;i(
io,"internalIsBuffer");oe.compare=i(function(t,r){if(!io(t)||!io(r))throw new TypeError("Arguments must be Buffers");if(t===r)return 0;for(var n=t.length,a=r.length,o=0,s=Math.min(n,a);o<s;++o)if(t[o]!==r[o]){n=t[o],a=r[o];break}return n<a?-1:a<n?1:0},"compare");oe.isEncoding=i(function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},"isEncoding");oe.concat=i(function(t,r){if(!iO(t))throw new TypeError('"list" argument must be an Array of Buffers');if(t.length===0)return oe.alloc(0);var n;if(r===void 0)for(r=0,n=0;n<t.length;++n)r+=t[n].length;var a=oe.allocUnsafe(r),o=0;for(n=0;n<t.length;++n){var s=t[n];if(!io(s))throw new TypeError('"list" argument must be an Array of Buffers');s.copy(a,o),o+=s.length}return a},"concat");i(uO,"byteLength");oe.byteLength=uO;i(pX,"slowToString");oe.prototype._isBuffer=!0;i(ac,"swap");oe.prototype.swap16=
i(function(){var t=this.length;if(t%2!==0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var r=0;r<t;r+=2)ac(this,r,r+1);return this},"swap16");oe.prototype.swap32=i(function(){var t=this.length;if(t%4!==0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var r=0;r<t;r+=4)ac(this,r,r+3),ac(this,r+1,r+2);return this},"swap32");oe.prototype.swap64=i(function(){var t=this.length;if(t%8!==0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var r=0;r<t;r+=8)ac(this,r,r+7),ac(this,r+1,r+6),ac(this,r+2,r+5),ac(this,r+3,r+4);return this},"swap64");oe.prototype.toString=i(function(){var t=this.length|0;return t===0?"":arguments.length===0?mO(this,0,t):pX.apply(this,arguments)},"toString");oe.prototype.equals=i(function(t){if(!io(t))throw new TypeError("Argument must be a Buffer");return this===t?!0:oe.compare(this,t)===0},"equals");oe.prototype.inspect=i(function(){var t="",r=cX;return this.length>0&&(t=this.toString("hex",0,r).match(
/.{2}/g).join(" "),this.length>r&&(t+=" ... ")),"<Buffer "+t+">"},"inspect");oe.prototype.compare=i(function(t,r,n,a,o){if(!io(t))throw new TypeError("Argument must be a Buffer");if(r===void 0&&(r=0),n===void 0&&(n=t?t.length:0),a===void 0&&(a=0),o===void 0&&(o=this.length),r<0||n>t.length||a<0||o>this.length)throw new RangeError("out of range index");if(a>=o&&r>=n)return 0;if(a>=o)return-1;if(r>=n)return 1;if(r>>>=0,n>>>=0,a>>>=0,o>>>=0,this===t)return 0;for(var s=o-a,c=n-r,u=Math.min(s,c),l=this.slice(a,o),m=t.slice(r,n),p=0;p<u;++p)if(l[p]!==m[p]){s=l[p],c=m[p];break}return s<c?-1:c<s?1:0},"compare");i(lO,"bidirectionalIndexOf");i(rO,"arrayIndexOf");oe.prototype.includes=i(function(t,r,n){return this.indexOf(t,r,n)!==-1},"includes");oe.prototype.indexOf=i(function(t,r,n){return lO(this,t,r,n,!0)},"indexOf");oe.prototype.lastIndexOf=i(function(t,r,n){return lO(this,t,r,n,!1)},"lastIndexOf");i(fX,"hexWrite");i(hX,"utf8Write");i(dO,"asciiWrite");i(gX,"latin1Write");i(yX,"base64Write");
i(vX,"ucs2Write");oe.prototype.write=i(function(t,r,n,a){if(r===void 0)a="utf8",n=this.length,r=0;else if(n===void 0&&typeof r=="string")a=r,n=this.length,r=0;else if(isFinite(r))r=r|0,isFinite(n)?(n=n|0,a===void 0&&(a="utf8")):(a=n,n=void 0);else throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");var o=this.length-r;if((n===void 0||n>o)&&(n=o),t.length>0&&(n<0||r<0)||r>this.length)throw new RangeError("Attempt to write outside buffer bounds");a||(a="utf8");for(var s=!1;;)switch(a){case"hex":return fX(this,t,r,n);case"utf8":case"utf-8":return hX(this,t,r,n);case"ascii":return dO(this,t,r,n);case"latin1":case"binary":return gX(this,t,r,n);case"base64":return yX(this,t,r,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return vX(this,t,r,n);default:if(s)throw new TypeError("Unknown encoding: "+a);a=(""+a).toLowerCase(),s=!0}},"write");oe.prototype.toJSON=i(function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}},"t\
oJSON");i(bX,"base64Slice");i(mO,"utf8Slice");nO=4096;i(wX,"decodeCodePointsArray");i(EX,"asciiSlice");i(DX,"latin1Slice");i(TX,"hexSlice");i(xX,"utf16leSlice");oe.prototype.slice=i(function(t,r){var n=this.length;t=~~t,r=r===void 0?n:~~r,t<0?(t+=n,t<0&&(t=0)):t>n&&(t=n),r<0?(r+=n,r<0&&(r=0)):r>n&&(r=n),r<t&&(r=t);var a;if(oe.TYPED_ARRAY_SUPPORT)a=this.subarray(t,r),a.__proto__=oe.prototype;else{var o=r-t;a=new oe(o,void 0);for(var s=0;s<o;++s)a[s]=this[s+t]}return a},"slice");i(Jr,"checkOffset");oe.prototype.readUIntLE=i(function(t,r,n){t=t|0,r=r|0,n||Jr(t,r,this.length);for(var a=this[t],o=1,s=0;++s<r&&(o*=256);)a+=this[t+s]*o;return a},"readUIntLE");oe.prototype.readUIntBE=i(function(t,r,n){t=t|0,r=r|0,n||Jr(t,r,this.length);for(var a=this[t+--r],o=1;r>0&&(o*=256);)a+=this[t+--r]*o;return a},"readUIntBE");oe.prototype.readUInt8=i(function(t,r){return r||Jr(t,1,this.length),this[t]},"readUInt8");oe.prototype.readUInt16LE=i(function(t,r){return r||Jr(t,2,this.length),this[t]|this[t+1]<<
8},"readUInt16LE");oe.prototype.readUInt16BE=i(function(t,r){return r||Jr(t,2,this.length),this[t]<<8|this[t+1]},"readUInt16BE");oe.prototype.readUInt32LE=i(function(t,r){return r||Jr(t,4,this.length),(this[t]|this[t+1]<<8|this[t+2]<<16)+this[t+3]*16777216},"readUInt32LE");oe.prototype.readUInt32BE=i(function(t,r){return r||Jr(t,4,this.length),this[t]*16777216+(this[t+1]<<16|this[t+2]<<8|this[t+3])},"readUInt32BE");oe.prototype.readIntLE=i(function(t,r,n){t=t|0,r=r|0,n||Jr(t,r,this.length);for(var a=this[t],o=1,s=0;++s<r&&(o*=256);)a+=this[t+s]*o;return o*=128,a>=o&&(a-=Math.pow(2,8*r)),a},"readIntLE");oe.prototype.readIntBE=i(function(t,r,n){t=t|0,r=r|0,n||Jr(t,r,this.length);for(var a=r,o=1,s=this[t+--a];a>0&&(o*=256);)s+=this[t+--a]*o;return o*=128,s>=o&&(s-=Math.pow(2,8*r)),s},"readIntBE");oe.prototype.readInt8=i(function(t,r){return r||Jr(t,1,this.length),this[t]&128?(255-this[t]+1)*-1:this[t]},"readInt8");oe.prototype.readInt16LE=i(function(t,r){r||Jr(t,2,this.length);var n=this[t]|
this[t+1]<<8;return n&32768?n|4294901760:n},"readInt16LE");oe.prototype.readInt16BE=i(function(t,r){r||Jr(t,2,this.length);var n=this[t+1]|this[t]<<8;return n&32768?n|4294901760:n},"readInt16BE");oe.prototype.readInt32LE=i(function(t,r){return r||Jr(t,4,this.length),this[t]|this[t+1]<<8|this[t+2]<<16|this[t+3]<<24},"readInt32LE");oe.prototype.readInt32BE=i(function(t,r){return r||Jr(t,4,this.length),this[t]<<24|this[t+1]<<16|this[t+2]<<8|this[t+3]},"readInt32BE");oe.prototype.readFloatLE=i(function(t,r){return r||Jr(t,4,this.length),ig(this,t,!0,23,4)},"readFloatLE");oe.prototype.readFloatBE=i(function(t,r){return r||Jr(t,4,this.length),ig(this,t,!1,23,4)},"readFloatBE");oe.prototype.readDoubleLE=i(function(t,r){return r||Jr(t,8,this.length),ig(this,t,!0,52,8)},"readDoubleLE");oe.prototype.readDoubleBE=i(function(t,r){return r||Jr(t,8,this.length),ig(this,t,!1,52,8)},"readDoubleBE");i(Wn,"checkInt");oe.prototype.writeUIntLE=i(function(t,r,n,a){if(t=+t,r=r|0,n=n|0,!a){var o=Math.pow(2,8*
n)-1;Wn(this,t,r,n,o,0)}var s=1,c=0;for(this[r]=t&255;++c<n&&(s*=256);)this[r+c]=t/s&255;return r+n},"writeUIntLE");oe.prototype.writeUIntBE=i(function(t,r,n,a){if(t=+t,r=r|0,n=n|0,!a){var o=Math.pow(2,8*n)-1;Wn(this,t,r,n,o,0)}var s=n-1,c=1;for(this[r+s]=t&255;--s>=0&&(c*=256);)this[r+s]=t/c&255;return r+n},"writeUIntBE");oe.prototype.writeUInt8=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,1,255,0),oe.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),this[r]=t&255,r+1},"writeUInt8");i(sg,"objectWriteUInt16");oe.prototype.writeUInt16LE=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,2,65535,0),oe.TYPED_ARRAY_SUPPORT?(this[r]=t&255,this[r+1]=t>>>8):sg(this,t,r,!0),r+2},"writeUInt16LE");oe.prototype.writeUInt16BE=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,2,65535,0),oe.TYPED_ARRAY_SUPPORT?(this[r]=t>>>8,this[r+1]=t&255):sg(this,t,r,!1),r+2},"writeUInt16BE");i(cg,"objectWriteUInt32");oe.prototype.writeUInt32LE=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,4,4294967295,0),oe.TYPED_ARRAY_SUPPORT?
(this[r+3]=t>>>24,this[r+2]=t>>>16,this[r+1]=t>>>8,this[r]=t&255):cg(this,t,r,!0),r+4},"writeUInt32LE");oe.prototype.writeUInt32BE=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,4,4294967295,0),oe.TYPED_ARRAY_SUPPORT?(this[r]=t>>>24,this[r+1]=t>>>16,this[r+2]=t>>>8,this[r+3]=t&255):cg(this,t,r,!1),r+4},"writeUInt32BE");oe.prototype.writeIntLE=i(function(t,r,n,a){if(t=+t,r=r|0,!a){var o=Math.pow(2,8*n-1);Wn(this,t,r,n,o-1,-o)}var s=0,c=1,u=0;for(this[r]=t&255;++s<n&&(c*=256);)t<0&&u===0&&this[r+s-1]!==0&&(u=1),this[r+s]=(t/c>>0)-u&255;return r+n},"writeIntLE");oe.prototype.writeIntBE=i(function(t,r,n,a){if(t=+t,r=r|0,!a){var o=Math.pow(2,8*n-1);Wn(this,t,r,n,o-1,-o)}var s=n-1,c=1,u=0;for(this[r+s]=t&255;--s>=0&&(c*=256);)t<0&&u===0&&this[r+s+1]!==0&&(u=1),this[r+s]=(t/c>>0)-u&255;return r+n},"writeIntBE");oe.prototype.writeInt8=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,1,127,-128),oe.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),t<0&&(t=255+t+1),this[r]=t&255,r+1},"writeInt8");oe.
prototype.writeInt16LE=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,2,32767,-32768),oe.TYPED_ARRAY_SUPPORT?(this[r]=t&255,this[r+1]=t>>>8):sg(this,t,r,!0),r+2},"writeInt16LE");oe.prototype.writeInt16BE=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,2,32767,-32768),oe.TYPED_ARRAY_SUPPORT?(this[r]=t>>>8,this[r+1]=t&255):sg(this,t,r,!1),r+2},"writeInt16BE");oe.prototype.writeInt32LE=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,4,2147483647,-2147483648),oe.TYPED_ARRAY_SUPPORT?(this[r]=t&255,this[r+1]=t>>>8,this[r+2]=t>>>16,this[r+3]=t>>>24):cg(this,t,r,!0),r+4},"writeInt32LE");oe.prototype.writeInt32BE=i(function(t,r,n){return t=+t,r=r|0,n||Wn(this,t,r,4,2147483647,-2147483648),t<0&&(t=4294967295+t+1),oe.TYPED_ARRAY_SUPPORT?(this[r]=t>>>24,this[r+1]=t>>>16,this[r+2]=t>>>8,this[r+3]=t&255):cg(this,t,r,!1),r+4},"writeInt32BE");i(pO,"checkIEEE754");i(fO,"writeFloat");oe.prototype.writeFloatLE=i(function(t,r,n){return fO(this,t,r,!0,n)},"writeFloatLE");oe.prototype.writeFloatBE=
i(function(t,r,n){return fO(this,t,r,!1,n)},"writeFloatBE");i(hO,"writeDouble");oe.prototype.writeDoubleLE=i(function(t,r,n){return hO(this,t,r,!0,n)},"writeDoubleLE");oe.prototype.writeDoubleBE=i(function(t,r,n){return hO(this,t,r,!1,n)},"writeDoubleBE");oe.prototype.copy=i(function(t,r,n,a){if(n||(n=0),!a&&a!==0&&(a=this.length),r>=t.length&&(r=t.length),r||(r=0),a>0&&a<n&&(a=n),a===n||t.length===0||this.length===0)return 0;if(r<0)throw new RangeError("targetStart out of bounds");if(n<0||n>=this.length)throw new RangeError("sourceStart out of bounds");if(a<0)throw new RangeError("sourceEnd out of bounds");a>this.length&&(a=this.length),t.length-r<a-n&&(a=t.length-r+n);var o=a-n,s;if(this===t&&n<r&&r<a)for(s=o-1;s>=0;--s)t[s+r]=this[s+n];else if(o<1e3||!oe.TYPED_ARRAY_SUPPORT)for(s=0;s<o;++s)t[s+r]=this[s+n];else Uint8Array.prototype.set.call(t,this.subarray(n,n+o),r);return o},"copy");oe.prototype.fill=i(function(t,r,n,a){if(typeof t=="string"){if(typeof r=="string"?(a=r,r=0,n=this.length):
typeof n=="string"&&(a=n,n=this.length),t.length===1){var o=t.charCodeAt(0);o<256&&(t=o)}if(a!==void 0&&typeof a!="string")throw new TypeError("encoding must be a string");if(typeof a=="string"&&!oe.isEncoding(a))throw new TypeError("Unknown encoding: "+a)}else typeof t=="number"&&(t=t&255);if(r<0||this.length<r||this.length<n)throw new RangeError("Out of range index");if(n<=r)return this;r=r>>>0,n=n===void 0?this.length:n>>>0,t||(t=0);var s;if(typeof t=="number")for(s=r;s<n;++s)this[s]=t;else{var c=io(t)?t:og(new oe(t,a).toString()),u=c.length;for(s=0;s<n-r;++s)this[s+r]=c[s%u]}return this},"fill");SX=/[^+\/0-9A-Za-z-_]/g;i(CX,"base64clean");i(IX,"stringtrim");i(kX,"toHex");i(og,"utf8ToBytes");i(RX,"asciiToBytes");i(_X,"utf16leToBytes");i(gO,"base64ToBytes");i(ug,"blitBuffer");i(AX,"isnan");i(FX,"isBuffer");i(yO,"isFastBuffer");i(MX,"isSlowBuffer")});function Hi(){}function It(){It.init.call(this)}function vO(e){return e._maxListeners===void 0?It.defaultMaxListeners:e._maxListeners}function OX(e,t,r){if(t)e.call(r);else for(var n=e.length,a=Bd(e,n),o=0;o<n;++o)a[o].call(r)}function NX(e,t,r,n){if(t)e.call(r,n);else for(var a=e.length,o=Bd(e,a),s=0;s<a;++s)o[s].call(r,n)}function LX(e,t,r,n,a){if(t)e.call(r,n,a);else for(var o=e.length,s=Bd(e,o),c=0;c<o;++c)s[c].call(r,n,a)}function PX(e,t,r,n,a,o){if(t)e.call(r,n,a,o);else for(var s=e.length,c=Bd(e,s),u=0;u<s;++u)c[u].call(r,n,a,o)}function BX(e,t,r,n){if(t)e.apply(r,n);else for(var a=e.length,o=Bd(e,a),s=0;s<a;++s)o[s].apply(r,n)}function bO(e,t,r,n){var a,o,s;if(typeof r!="function")throw new TypeError('"listener" argument must be a function');if(o=e._events,o?(o.newListener&&(e.emit("newListener",t,r.listener?r.listener:r),o=e._events),s=o[t]):(o=e._events=new Hi,e._eventsCount=0),!s)s=o[t]=r,++e._eventsCount;else if(typeof s=="function"?s=o[t]=n?[r,s]:[s,r]:n?s.unshift(r):s.push(
r),!s.warned&&(a=vO(e),a&&a>0&&s.length>a)){s.warned=!0;var c=new Error("Possible EventEmitter memory leak detected. "+s.length+" "+t+" listeners added. Use emitter.setMaxListeners() to increase limit");c.name="MaxListenersExceededWarning",c.emitter=e,c.type=t,c.count=s.length,UX(c)}return e}function UX(e){typeof console.warn=="function"?console.warn(e):console.log(e)}function wO(e,t,r){var n=!1;function a(){e.removeListener(t,a),n||(n=!0,r.apply(e,arguments))}return i(a,"g"),a.listener=r,a}function EO(e){var t=this._events;if(t){var r=t[e];if(typeof r=="function")return 1;if(r)return r.length}return 0}function jX(e,t){for(var r=t,n=r+1,a=e.length;n<a;r+=1,n+=1)e[r]=e[n];e.pop()}function Bd(e,t){for(var r=new Array(t);t--;)r[t]=e[t];return r}function qX(e){for(var t=new Array(e.length),r=0;r<t.length;++r)t[r]=e[r].listener||e[r];return t}var Qb,ga,qo=g(()=>{"use strict";d();i(Hi,"EventHandlers");Hi.prototype=Object.create(null);i(It,"EventEmitter");ga=It;It.EventEmitter=It;It.usingDomains=
!1;It.prototype.domain=void 0;It.prototype._events=void 0;It.prototype._maxListeners=void 0;It.defaultMaxListeners=10;It.init=function(){this.domain=null,It.usingDomains&&Qb.active&&!(this instanceof Qb.Domain)&&(this.domain=Qb.active),(!this._events||this._events===Object.getPrototypeOf(this)._events)&&(this._events=new Hi,this._eventsCount=0),this._maxListeners=this._maxListeners||void 0};It.prototype.setMaxListeners=i(function(t){if(typeof t!="number"||t<0||isNaN(t))throw new TypeError('"n" argument must be a positive number');return this._maxListeners=t,this},"setMaxListeners");i(vO,"$getMaxListeners");It.prototype.getMaxListeners=i(function(){return vO(this)},"getMaxListeners");i(OX,"emitNone");i(NX,"emitOne");i(LX,"emitTwo");i(PX,"emitThree");i(BX,"emitMany");It.prototype.emit=i(function(t){var r,n,a,o,s,c,u,l=!1,m=t==="error";if(c=this._events,c)m=m&&c.error==null;else if(!m)return!1;if(u=this.domain,m){if(r=arguments[1],u)r||(r=new Error('Uncaught, unspecified "error" event')),
r.domainEmitter=this,r.domain=u,r.domainThrown=!1,u.emit("error",r);else{if(r instanceof Error)throw r;var p=new Error('Uncaught, unspecified "error" event. ('+r+")");throw p.context=r,p}return!1}if(n=c[t],!n)return!1;var f=typeof n=="function";switch(a=arguments.length,a){case 1:OX(n,f,this);break;case 2:NX(n,f,this,arguments[1]);break;case 3:LX(n,f,this,arguments[1],arguments[2]);break;case 4:PX(n,f,this,arguments[1],arguments[2],arguments[3]);break;default:for(o=new Array(a-1),s=1;s<a;s++)o[s-1]=arguments[s];BX(n,f,this,o)}return l&&u.exit(),!0},"emit");i(bO,"_addListener");i(UX,"emitWarning");It.prototype.addListener=i(function(t,r){return bO(this,t,r,!1)},"addListener");It.prototype.on=It.prototype.addListener;It.prototype.prependListener=i(function(t,r){return bO(this,t,r,!0)},"prependListener");i(wO,"_onceWrap");It.prototype.once=i(function(t,r){if(typeof r!="function")throw new TypeError('"listener" argument must be a function');return this.on(t,wO(this,t,r)),this},"once");It.prototype.
prependOnceListener=i(function(t,r){if(typeof r!="function")throw new TypeError('"listener" argument must be a function');return this.prependListener(t,wO(this,t,r)),this},"prependOnceListener");It.prototype.removeListener=i(function(t,r){var n,a,o,s,c;if(typeof r!="function")throw new TypeError('"listener" argument must be a function');if(a=this._events,!a)return this;if(n=a[t],!n)return this;if(n===r||n.listener&&n.listener===r)--this._eventsCount===0?this._events=new Hi:(delete a[t],a.removeListener&&this.emit("removeListener",t,n.listener||r));else if(typeof n!="function"){for(o=-1,s=n.length;s-- >0;)if(n[s]===r||n[s].listener&&n[s].listener===r){c=n[s].listener,o=s;break}if(o<0)return this;if(n.length===1){if(n[0]=void 0,--this._eventsCount===0)return this._events=new Hi,this;delete a[t]}else jX(n,o);a.removeListener&&this.emit("removeListener",t,c||r)}return this},"removeListener");It.prototype.off=function(e,t){return this.removeListener(e,t)};It.prototype.removeAllListeners=i(function(t){
var r,n;if(n=this._events,!n)return this;if(!n.removeListener)return arguments.length===0?(this._events=new Hi,this._eventsCount=0):n[t]&&(--this._eventsCount===0?this._events=new Hi:delete n[t]),this;if(arguments.length===0){for(var a=Object.keys(n),o=0,s;o<a.length;++o)s=a[o],s!=="removeListener"&&this.removeAllListeners(s);return this.removeAllListeners("removeListener"),this._events=new Hi,this._eventsCount=0,this}if(r=n[t],typeof r=="function")this.removeListener(t,r);else if(r)do this.removeListener(t,r[r.length-1]);while(r[0]);return this},"removeAllListeners");It.prototype.listeners=i(function(t){var r,n,a=this._events;return a?(r=a[t],r?typeof r=="function"?n=[r.listener||r]:n=qX(r):n=[]):n=[],n},"listeners");It.listenerCount=function(e,t){return typeof e.listenerCount=="function"?e.listenerCount(t):EO.call(e,t)};It.prototype.listenerCount=EO;i(EO,"listenerCount");It.prototype.eventNames=i(function(){return this._eventsCount>0?Reflect.ownKeys(this._events):[]},"eventNames");i(
jX,"spliceOne");i(Bd,"arrayClone");i(qX,"unwrapListeners")});var TO=je((nSe,DO)=>{d();var wu=1e3,Eu=wu*60,Du=Eu*60,oc=Du*24,zX=oc*7,HX=oc*365.25;DO.exports=function(e,t){t=t||{};var r=typeof e;if(r==="string"&&e.length>0)return GX(e);if(r==="number"&&isFinite(e))return t.long?VX(e):WX(e);throw new Error("val is not a non-empty string or a valid number. val="+JSON.stringify(e))};function GX(e){if(e=String(e),!(e.length>100)){var t=/^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(e);if(t){var r=parseFloat(t[1]),n=(t[2]||"ms").toLowerCase();switch(n){case"years":case"year":case"yrs":case"yr":case"y":return r*HX;case"weeks":case"week":case"w":return r*zX;case"days":case"day":case"d":return r*oc;case"hours":case"hour":case"hrs":case"hr":case"h":return r*Du;case"minutes":case"minute":case"mins":case"min":case"m":return r*Eu;case"seconds":case"second":case"secs":case"sec":case"s":return r*wu;case"milliseconds":case"millisecond":case"msecs":case"msec":case"ms":return r;default:
return}}}}i(GX,"parse");function WX(e){var t=Math.abs(e);return t>=oc?Math.round(e/oc)+"d":t>=Du?Math.round(e/Du)+"h":t>=Eu?Math.round(e/Eu)+"m":t>=wu?Math.round(e/wu)+"s":e+"ms"}i(WX,"fmtShort");function VX(e){var t=Math.abs(e);return t>=oc?lg(e,t,oc,"day"):t>=Du?lg(e,t,Du,"hour"):t>=Eu?lg(e,t,Eu,"minute"):t>=wu?lg(e,t,wu,"second"):e+" ms"}i(VX,"fmtLong");function lg(e,t,r,n){var a=t>=r*1.5;return Math.round(e/r)+" "+n+(a?"s":"")}i(lg,"plural")});var SO=je((iSe,xO)=>{d();function $X(e){r.debug=r,r.default=r,r.coerce=u,r.disable=o,r.enable=a,r.enabled=s,r.humanize=TO(),r.destroy=l,Object.keys(e).forEach(m=>{r[m]=e[m]}),r.names=[],r.skips=[],r.formatters={};function t(m){let p=0;for(let f=0;f<m.length;f++)p=(p<<5)-p+m.charCodeAt(f),p|=0;return r.colors[Math.abs(p)%r.colors.length]}i(t,"selectColor"),r.selectColor=t;function r(m){let p,f=null,h,y;function v(...E){if(!v.enabled)return;let T=v,x=Number(new Date),S=x-(p||x);T.diff=S,T.prev=p,T.curr=x,p=x,E[0]=r.coerce(E[0]),typeof E[0]!="string"&&E.unshift("%O");let I=0;E[0]=E[0].replace(/%([a-zA-Z%])/g,(W,H)=>{if(W==="%%")return"%";I++;let se=r.formatters[H];if(typeof se=="function"){let me=E[I];W=se.call(T,me),E.splice(I,1),I--}return W}),r.formatArgs.call(T,E),(T.log||r.log).apply(T,E)}return i(v,"debug"),v.namespace=m,v.useColors=r.useColors(),v.color=r.selectColor(m),v.extend=n,v.destroy=r.destroy,Object.defineProperty(v,"enabled",{enumerable:!0,configurable:!1,get:i(()=>f!==null?
f:(h!==r.namespaces&&(h=r.namespaces,y=r.enabled(m)),y),"get"),set:i(E=>{f=E},"set")}),typeof r.init=="function"&&r.init(v),v}i(r,"createDebug");function n(m,p){let f=r(this.namespace+(typeof p>"u"?":":p)+m);return f.log=this.log,f}i(n,"extend");function a(m){r.save(m),r.namespaces=m,r.names=[],r.skips=[];let p,f=(typeof m=="string"?m:"").split(/[\s,]+/),h=f.length;for(p=0;p<h;p++)f[p]&&(m=f[p].replace(/\*/g,".*?"),m[0]==="-"?r.skips.push(new RegExp("^"+m.slice(1)+"$")):r.names.push(new RegExp("^"+m+"$")))}i(a,"enable");function o(){let m=[...r.names.map(c),...r.skips.map(c).map(p=>"-"+p)].join(",");return r.enable(""),m}i(o,"disable");function s(m){if(m[m.length-1]==="*")return!0;let p,f;for(p=0,f=r.skips.length;p<f;p++)if(r.skips[p].test(m))return!1;for(p=0,f=r.names.length;p<f;p++)if(r.names[p].test(m))return!0;return!1}i(s,"enabled");function c(m){return m.toString().substring(2,m.toString().length-2).replace(/\.\*\?$/,"*")}i(c,"toNamespace");function u(m){return m instanceof Error?
m.stack||m.message:m}i(u,"coerce");function l(){console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.")}return i(l,"destroy"),r.enable(r.load()),r}i($X,"setup");xO.exports=$X});var CO=je((ia,dg)=>{d();ia.formatArgs=KX;ia.save=JX;ia.load=XX;ia.useColors=YX;ia.storage=ZX();ia.destroy=(()=>{let e=!1;return()=>{e||(e=!0,console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."))}})();ia.colors=["#0000CC","#0000FF","#0033CC","#0033FF","#0066CC","#0066FF","#0099CC","#0099FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#3300CC","#3300FF","#3333CC","#3333FF","#3366CC","#3366FF","#3399CC","#3399FF","#33CC00","#33CC33","#33CC66","#33CC99","#33CCCC","#33CCFF","#6600CC","#6600FF","#6633CC","#6633FF","#66CC00","#66CC33","#9900CC","#9900FF","#9933CC","#9933FF","#99CC00","#99CC33","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF","#CC6600","#CC6633","#CC9900","#CC9933","#CCCC00","#CCCC33","#FF0000","#FF0033","#FF0066","#FF0099","#FF00CC","#FF00FF","#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#\
FF33FF","#FF6600","#FF6633","#FF9900","#FF9933","#FFCC00","#FFCC33"];function YX(){return typeof window<"u"&&window.process&&(window.process.type==="renderer"||window.process.__nwjs)?!0:typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)?!1:typeof document<"u"&&document.documentElement&&document.documentElement.style&&document.documentElement.style.WebkitAppearance||typeof window<"u"&&window.console&&(window.console.firebug||window.console.exception&&window.console.table)||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)&&parseInt(RegExp.$1,10)>=31||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/)}i(YX,"useColors");function KX(e){if(e[0]=(this.useColors?"%c":"")+this.namespace+(this.useColors?" %c":" ")+e[0]+(this.useColors?"%c ":" ")+"+"+dg.exports.humanize(this.diff),!this.useColors)return;let t="color: "+this.color;e.splice(
1,0,t,"color: inherit");let r=0,n=0;e[0].replace(/%[a-zA-Z%]/g,a=>{a!=="%%"&&(r++,a==="%c"&&(n=r))}),e.splice(n,0,t)}i(KX,"formatArgs");ia.log=console.debug||console.log||(()=>{});function JX(e){try{e?ia.storage.setItem("debug",e):ia.storage.removeItem("debug")}catch{}}i(JX,"save");function XX(){let e;try{e=ia.storage.getItem("debug")}catch{}return!e&&typeof process<"u"&&"env"in process&&(e=process.env.DEBUG),e}i(XX,"load");function ZX(){try{return localStorage}catch{}}i(ZX,"localstorage");dg.exports=SO()(ia);var{formatters:QX}=dg.exports;QX.j=function(e){try{return JSON.stringify(e)}catch(t){return"[UnexpectedJSONParseError]: "+t.message}}});function mg(e){if(!e)throw new Error("name must be non-empty")}function eZ(e,t){for(var r=0,n=e.length,a;r<n;)a=r+n>>>1,e[a].startTime<t.startTime?r=a+1:n=a;e.splice(r,0,t)}var sn,IO,hg,gg,Ud,yg,pg,fg,kO=g(()=>{d();sn=typeof performance<"u"&&performance,IO=sn&&sn.now?function(){return sn.now()}:function(){return Date.now()};i(mg,"throwIfEmpty");i(eZ,"insertSorted");sn&&sn.mark&&sn.measure&&sn.getEntriesByName&&sn.getEntriesByType&&sn.clearMarks&&sn.clearMeasures?(hg=i(function(e){mg(e),sn.mark("start "+e)},"mark"),gg=i(function(e){mg(e),sn.mark("end "+e);var t=sn.measure(e,"start "+e,"end "+e);if(t)return t;var r=sn.getEntriesByName(e);return r[r.length-1]},"stop"),Ud=i(function(){return sn.getEntriesByType("measure")},"getEntries"),yg=i(function(){sn.clearMarks(),sn.clearMeasures()},"clear")):(pg={},fg=[],hg=i(function(e){mg(e);var t=IO();pg["$"+e]=t},"mark"),gg=i(function(e){mg(e);var t=IO(),r=pg["$"+e];if(!r)throw new Error("no known mark: "+e);var n={startTime:r,name:e,duration:t-r,
entryType:"measure"};return eZ(fg,n),n},"stop"),Ud=i(function(){return fg},"getEntries"),yg=i(function(){pg={},fg=[]},"clear"))});var Wi,Gi,Tu,xu,e0,RO,rZ,_O,Su,q,pt=g(()=>{d();zi();qo();Wi=Kr(CO());kO();Gi=gn.platform==="win32",Tu=gn.browser,xu={red:Tu?"crimson":1,yellow:Tu?"gold":3,cyan:Tu?"darkturquoise":6,green:Tu?"forestgreen":2,blue:Tu?"steelblue":4,magenta:Tu?"palevioletred":5};Wi.default.colors=[xu.cyan,xu.green,xu.blue,xu.magenta];e0=class extends It{static{i(this,"Emitter")}constructor(t){super(t)}issueStatus(t,r){(t==="status"||t==="statusEnd")&&this.emit(t,[t,...r])}issueWarning(t,r){this.emit("warning",[t,...r])}},RO={},rZ=25,Su=class e{static{i(this,"Log")}static _logToStdErr(t,r){e.loggerfn(t)(...r)}static loggerfn(t){t=`LH:${t}`;let r=RO[t];return r||(r=(0,Wi.default)(t),RO[t]=r,t.endsWith("error")?r.color=xu.red:t.endsWith("warn")&&(r.color=xu.yellow)),r}static setLevel(t){switch(_O=t,t){case"silent":Wi.default.enable("-LH:*");break;case"verbose":Wi.default.enable("LH:*");break;case"warn":Wi.default.enable("-LH:*, LH:*:warn, LH:*:error");break;case"error":Wi.default.enable("-LH:*, LH:*:error");break;default:
Wi.default.enable("LH:*, -LH:*:verbose")}}static formatProtocol(t,r,n){let a=!gn||gn.browser?1/0:gn.stdout.columns,o=r.method||"?????",s=a-o.length-t.length-rZ,c=r.params&&o!=="IO.read"?JSON.stringify(r.params).substr(0,s):"";e._logToStdErr(`${t}:${n||""}`,[o,c])}static isVerbose(){return _O==="verbose"}static time({msg:t,id:r,args:n=[]},a="log"){hg(r),e[a]("status",t,...n)}static timeEnd({msg:t,id:r,args:n=[]},a="verbose"){e[a]("statusEnd",t,...n),gg(r)}static log(t,...r){return e.events.issueStatus(t,r),e._logToStdErr(t,r)}static warn(t,...r){return e.events.issueWarning(t,r),e._logToStdErr(`${t}:warn`,r)}static error(t,...r){return e._logToStdErr(`${t}:error`,r)}static verbose(t,...r){return e.events.issueStatus(t,r),e._logToStdErr(`${t}:verbose`,r)}static greenify(t){return`${e.green}${t}${e.reset}`}static redify(t){return`${e.red}${t}${e.reset}`}static get green(){return"\x1B[32m"}static get red(){return"\x1B[31m"}static get yellow(){return"\x1B[33m"}static get purple(){return"\x1B[9\
5m"}static get reset(){return"\x1B[0m"}static get bold(){return"\x1B[1m"}static get dim(){return"\x1B[2m"}static get tick(){return Gi?"√":"✓"}static get cross(){return Gi?"×":"✘"}static get whiteSmallSquare(){return Gi?"·":"▫"}static get heavyHorizontal(){return Gi?"─":"━"}static get heavyVertical(){return Gi?"│ ":"┃ "}static get heavyUpAndRight(){return Gi?"└":"┗"}static get heavyVerticalAndRight(){return Gi?"├":"┣"}static get heavyDownAndHorizontal(){return Gi?"┬":"┳"}static get doubleLightHorizontal(){return"──"}};Su.events=new e0;Su.takeTimeEntries=()=>{let e=Ud();return yg(),e};Su.getTimeEntries=()=>Ud();q=Su});var yn=g(()=>{"use strict";d();});var t0,Se,At=g(()=>{"use strict";d();yn();t0=class{static{i(this,"BaseGatherer")}meta={supportedModes:[]};startInstrumentation(t){}startSensitiveInstrumentation(t){}stopSensitiveInstrumentation(t){}stopInstrumentation(t){}getArtifact(t){}},Se=t0});var nZ,aZ,oZ,iZ,sZ,cZ,cn,zo=g(()=>{"use strict";d();pt();nZ=/^(chrome|https?):/,aZ=16,oZ="RunTask",iZ="ThreadControllerImpl::RunTask",sZ="ThreadControllerImpl::DoWork",cZ="TaskQueueManager::ProcessTaskFromWorkQueue",cn=class e{static{i(this,"TraceProcessor")}static get TIMESPAN_MARKER_ID(){return"__lighthouseTimespanStart__"}static createNoNavstartError(){return new Error("No navigationStart event found")}static createNoResourceSendRequestError(){return new Error("No ResourceSendRequest event found")}static createNoTracingStartedError(){return new Error("No tracingStartedInBrowser event found")}static createNoFirstContentfulPaintError(){return new Error("No FirstContentfulPaint event found")}static createNoLighthouseMarkerError(){return new Error("No Lighthouse timespan marker event found")}static _isNavigationStartOfInterest(t){return t.name!=="navigationStart"?!1:t.args.data?.documentLoaderURL===void 0?!0:t.args.data?.documentLoaderURL?nZ.test(t.args.data.documentLoaderURL):!1}static _sortTimestampEventGroup(t,r,n,a){
let o=i(p=>r[p],"lookupArrayIndexByTsIndex"),s=i(p=>a[o(p)],"lookupEventByTsIndex"),c=[],u=[],l=[];for(let p of t){let f=o(p),h=s(p);h.ph==="E"?c.push(f):h.ph==="X"||h.ph==="B"?u.push(f):l.push(f)}let m=new Map;for(let p of u){let f=a[p];if(f.ph==="X")m.set(p,f.dur);else{let h=Number.MAX_SAFE_INTEGER,y=0,v=n+t.length;for(let E=v;E<r.length;E++){let T=s(E);if(T.name===f.name&&T.pid===f.pid&&T.tid===f.tid)if(T.ph==="E"&&y===0){h=T.ts-f.ts;break}else T.ph==="E"?y--:T.ph==="B"&&y++}m.set(p,h)}}return u.sort((p,f)=>(m.get(f)||0)-(m.get(p)||0)||p-f),l.sort((p,f)=>p-f),[...c,...u,...l]}static filteredTraceSort(t,r){let n=[];for(let o=0;o<t.length;o++)r(t[o])&&n.push(o);n.sort((o,s)=>t[o].ts-t[s].ts);for(let o=0;o<n.length-1;o++){let s=t[n[o]].ts,c=[o];for(let l=o+1;l<n.length&&t[n[l]].ts===s;l++)c.push(l);if(c.length===1)continue;let u=e._sortTimestampEventGroup(c,n,o,t);n.splice(o,u.length,...u),o+=c.length-1}let a=[];for(let o=0;o<n.length;o++)a.push(t[n[o]]);return a}static assertHasToplevelEvents(t){
if(!t.some(this.isScheduleableTask))throw new Error("Could not find any top level events")}static _riskPercentiles(t,r,n,a=0){let o=0;for(let f=0;f<t.length;f++)o+=t[f];o-=a;let s=r-o,c=0,u=s,l=[],m=-1,p=t.length+1;a>0&&p--;for(let f of n){let h=f*r;for(;u<h&&m<t.length-1;)s+=c,p-=c<0?-1:1,a>0&&a<t[m+1]?(c=-a,a=0):(m++,c=t[m]),u=s+Math.abs(c)*p;l.push({percentile:f,time:Math.max(0,(h-s)/p)+aZ})}return l}static getRiskToResponsiveness(t,r,n,a=[.5,.75,.9,.99,1]){let o=n-r;a.sort((c,u)=>c-u);let s=this.getMainThreadTopLevelEventDurations(t,r,n);return this._riskPercentiles(s.durations,o,a,s.clippedLength)}static getMainThreadTopLevelEventDurations(t,r=0,n=1/0){let a=[],o=0;for(let s of t){if(s.end<r||s.start>n)continue;let c=s.duration,u=s.start;u<r&&(u=r,c=s.end-r),s.end>n&&(o=c-(n-u)),a.push(c)}return a.sort((s,c)=>s-c),{durations:a,clippedLength:o}}static getMainThreadTopLevelEvents(t,r=0,n=1/0){let a=[],o;for(let s of t.mainThreadEvents){if(!this.isScheduleableTask(s)||!s.dur)continue;
let c=(s.ts-t.timeOriginEvt.ts)/1e3,u=(s.ts+s.dur-t.timeOriginEvt.ts)/1e3;c>n||u<r||(o&&c<o.end&&(o.end=c-.001),o={start:c,end:u,duration:s.dur/1e3},a.push(o))}return a}static findMainFrameIds(t){let r=t.find(s=>s.name==="TracingStartedInBrowser");if(r?.args.data?.frames){let s=r.args.data.frames.find(l=>!l.parent),c=s?.frame,u=s?.processId;if(u&&c)return{startingPid:u,frameId:c}}let n=t.find(s=>s.name==="TracingStartedInPage");if(n?.args?.data){let s=n.args.data.page;if(s)return{startingPid:n.pid,frameId:s}}let a=t.find(s=>this._isNavigationStartOfInterest(s)&&s.args.data?.isLoadingMainFrame),o=t.find(s=>s.name==="ResourceSendRequest");if(a?.args?.data&&o&&o.pid===a.pid&&o.tid===a.tid){let s=a.args.frame;if(s)return{startingPid:a.pid,frameId:s}}throw this.createNoTracingStartedError()}static findMainFramePidTids(t,r){let n=r.filter(s=>(s.name==="FrameCommittedInBrowser"||s.name==="ProcessReadyInBrowser")&&s.args?.data?.frame===t.frameId&&s?.args?.data?.processId),a=n.length?n.map(s=>s?.
args?.data?.processId):[t.startingPid],o=new Map;for(let s of new Set(a)){let c=r.filter(m=>m.cat==="__metadata"&&m.pid===s&&m.ph==="M"&&m.name==="thread_name"),u=c.find(m=>m.args.name==="CrRendererMain");u||(u=c.find(m=>m.args.name==="CrBrowserMain"));let l=u?.tid;if(!l)throw new Error("Unable to determine tid for renderer process");o.set(s,l)}return o}static isScheduleableTask(t){return t.name===oZ||t.name===iZ||t.name===sZ||t.name===cZ}static isLCPEvent(t){return t.name!=="largestContentfulPaint::Invalidate"&&t.name!=="largestContentfulPaint::Candidate"?!1:!!t.args?.frame}static isLCPCandidateEvent(t){return!!(t.name==="largestContentfulPaint::Candidate"&&t.args?.frame&&t.args.data&&t.args.data.size!==void 0)}static getFrameId(t){return t.args?.data?.frame||t.args.data?.frameID||t.args.frame}static computeValidLCPAllFrames(t,r){let n=t.filter(this.isLCPEvent).reverse(),a=new Map;for(let s of n){if(s.ts<=r.ts)break;let c=s.args.frame;a.has(c)||a.set(c,s)}let o;for(let s of a.values())
this.isLCPCandidateEvent(s)&&(!o||s.args.data.size>o.args.data.size)&&(o=s);return{lcp:o,invalidated:!!(!o&&a.size)}}static resolveRootFrames(t){let r=new Map;for(let a of t)a.parent&&r.set(a.id,a.parent);let n=new Map;for(let a of t){let o=a.id;for(;r.has(o);)o=r.get(o);if(o===void 0)throw new Error("Unexpected undefined frameId");n.set(a.id,o)}return n}static processTrace(t,r){let{timeOriginDeterminationMethod:n="auto"}=r||{},a=this.filteredTraceSort(t.traceEvents,I=>I.cat.includes("blink.user_timing")||I.cat.includes("loading")||I.cat.includes("devtools.timeline")||I.cat==="__metadata"),o=this.findMainFrameIds(a),s=this.findMainFramePidTids(o,a),c=e.filteredTraceSort(t.traceEvents,I=>s.has(I.pid)),u=new Map,l=a.find(I=>I.name==="TracingStartedInBrowser")?.args?.data?.frames;if(l)for(let I of l)u.set(I.frame,{id:I.frame,url:I.url,parent:I.parent});a.filter(I=>!!(I.name==="FrameCommittedInBrowser"&&I.args.data?.frame&&I.args.data.url!==void 0)).forEach(I=>{u.set(I.args.data.frame,{id:I.
args.data.frame,url:I.args.data.url,parent:I.args.data.parent})});let m=[...u.values()],p=this.resolveRootFrames(m),f=[...p.entries()].filter(([,I])=>I===o.frameId).map(([I])=>I);function h(I){return e.getFrameId(I)===o.frameId}i(h,"associatedToMainFrame");function y(I){let F=e.getFrameId(I);return F?f.includes(F):!1}i(y,"associatedToAllFrames");let v=a.filter(I=>h(I)),E=[];p.has(o.frameId)?E=a.filter(I=>y(I)):(q.warn("TraceProcessor","frameTreeEvents may be incomplete, make sure the trace has frame events"),p.set(o.frameId,o.frameId),E=v);let T=this.computeTimeOrigin({keyEvents:a,frameEvents:v,mainFrameInfo:o},n),x=c.filter(I=>I.tid===s.get(I.pid)),S=this.computeTraceEnd(t.traceEvents,T);return{frames:m,mainThreadEvents:x,frameEvents:v,frameTreeEvents:E,processEvents:c,mainFrameInfo:o,timeOriginEvt:T,timings:{timeOrigin:0,traceEnd:S.timing},timestamps:{timeOrigin:T.ts,traceEnd:S.timestamp},_keyEvents:a,_rendererPidToTid:s}}static processNavigation(t){let{frameEvents:r,frameTreeEvents:n,
timeOriginEvt:a,timings:o,timestamps:s}=t,c=this.computeNavigationTimingsForFrame(r,{timeOriginEvt:a}),u=n.find(f=>f.name==="firstContentfulPaint"&&f.ts>a.ts);if(!u)throw this.createNoFirstContentfulPaintError();let l=this.computeValidLCPAllFrames(n,a).lcp,m=i(f=>(f-a.ts)/1e3,"getTiming"),p=i(f=>f===void 0?void 0:m(f),"maybeGetTiming");return{timings:{timeOrigin:o.timeOrigin,firstPaint:c.timings.firstPaint,firstContentfulPaint:c.timings.firstContentfulPaint,firstContentfulPaintAllFrames:m(u.ts),largestContentfulPaint:c.timings.largestContentfulPaint,largestContentfulPaintAllFrames:p(l?.ts),load:c.timings.load,domContentLoaded:c.timings.domContentLoaded,traceEnd:o.traceEnd},timestamps:{timeOrigin:s.timeOrigin,firstPaint:c.timestamps.firstPaint,firstContentfulPaint:c.timestamps.firstContentfulPaint,firstContentfulPaintAllFrames:u.ts,largestContentfulPaint:c.timestamps.largestContentfulPaint,largestContentfulPaintAllFrames:l?.ts,load:c.timestamps.load,domContentLoaded:c.timestamps.domContentLoaded,
traceEnd:s.traceEnd},firstPaintEvt:c.firstPaintEvt,firstContentfulPaintEvt:c.firstContentfulPaintEvt,firstContentfulPaintAllFramesEvt:u,largestContentfulPaintEvt:c.largestContentfulPaintEvt,largestContentfulPaintAllFramesEvt:l,loadEvt:c.loadEvt,domContentLoadedEvt:c.domContentLoadedEvt,lcpInvalidated:c.lcpInvalidated}}static computeTraceEnd(t,r){let n=-1/0;for(let a of t)n=Math.max(a.ts+(a.dur||0),n);return{timestamp:n,timing:(n-r.ts)/1e3}}static computeTimeOrigin(t,r){let n=i(()=>t.frameEvents.filter(this._isNavigationStartOfInterest).pop(),"lastNavigationStart"),a=i(()=>t.keyEvents.find(s=>s.name==="clock_sync"&&s.args.sync_id===e.TIMESPAN_MARKER_ID),"lighthouseMarker");switch(r){case"firstResourceSendRequest":{let o=t.keyEvents.find(s=>s.name!=="ResourceSendRequest"?!1:(s.args.data||{}).frame===t.mainFrameInfo.frameId);if(!o)throw this.createNoResourceSendRequestError();return o}case"lastNavigationStart":{let o=n();if(!o)throw this.createNoNavstartError();return o}case"lighthouseMar\
ker":{let o=a();if(!o)throw this.createNoLighthouseMarkerError();return o}case"auto":{let o=a()||n();if(!o)throw this.createNoNavstartError();return o}}}static computeNavigationTimingsForFrame(t,r){let{timeOriginEvt:n}=r,a=t.find(y=>y.name==="firstPaint"&&y.ts>n.ts),o=t.find(y=>y.name==="firstContentfulPaint"&&y.ts>n.ts);if(!o)throw this.createNoFirstContentfulPaintError();let s=this.computeValidLCPAllFrames(t,n),c=t.find(y=>y.name==="loadEventEnd"&&y.ts>n.ts),u=t.find(y=>y.name==="domContentLoadedEventEnd"&&y.ts>n.ts),l=i(y=>y?.ts,"getTimestamp"),m={timeOrigin:n.ts,firstPaint:l(a),firstContentfulPaint:o.ts,largestContentfulPaint:l(s.lcp),load:l(c),domContentLoaded:l(u)},p=i(y=>(y-n.ts)/1e3,"getTiming"),f=i(y=>y===void 0?void 0:p(y),"maybeGetTiming");return{timings:{timeOrigin:0,firstPaint:f(m.firstPaint),firstContentfulPaint:p(m.firstContentfulPaint),largestContentfulPaint:f(m.largestContentfulPaint),load:f(m.load),domContentLoaded:f(m.domContentLoaded)},timestamps:m,timeOriginEvt:n,firstPaintEvt:a,
firstContentfulPaintEvt:o,largestContentfulPaintEvt:s.lcp,loadEvt:c,domContentLoadedEvt:u,lcpInvalidated:s.invalidated}}}});var AO={};C(AO,{default:()=>Ho});var r0,Ho,Cu=g(()=>{"use strict";d();At();zo();r0=class e extends Se{static{i(this,"Trace")}_trace={traceEvents:[]};static getDefaultTraceCategories(){return["-*","disabled-by-default-lighthouse","loading","v8","v8.execute","blink.user_timing","blink.console","devtools.timeline","disabled-by-default-devtools.timeline","disabled-by-default-devtools.screenshot","disabled-by-default-devtools.timeline.stack","disabled-by-default-devtools.timeline.frame","latencyInfo","disabled-by-default-devtools.target-rundown","disabled-by-default-devtools.v8-source-rundown-sources","disabled-by-default-devtools.v8-source-rundown"]}static async endTraceAndCollectEvents(t){let r=[],n=i(function(a){r.push(...a.value)},"dataListener");return t.on("Tracing.dataCollected",n),new Promise((a,o)=>{t.once("Tracing.tracingComplete",s=>{t.off("Tracing.dataCollected",n),a({traceEvents:r})}),t.sendCommand("Tracing.end").catch(o)})}static symbol=Symbol("Trace");meta={symbol:e.symbol,supportedModes:[
"timespan","navigation"]};async startSensitiveInstrumentation({driver:t,gatherMode:r,settings:n}){let a=e.getDefaultTraceCategories().concat(n.additionalTraceCategories||[]);await t.defaultSession.sendCommand("Page.enable"),await t.defaultSession.sendCommand("Tracing.start",{categories:a.join(","),options:"sampling-frequency=10000"}),r==="timespan"&&await t.defaultSession.sendCommand("Tracing.recordClockSyncMarker",{syncId:cn.TIMESPAN_MARKER_ID})}async stopSensitiveInstrumentation({driver:t}){this._trace=await e.endTraceAndCollectEvents(t.defaultSession)}getDebugData(){return this._trace}getArtifact(){return this._trace}},Ho=r0});var FO={};C(FO,{default:()=>ya});var ya,Go=g(()=>{d();ya={}});function MO(e,t){for(var r=0,n=e.length-1;n>=0;n--){var a=e[n];a==="."?e.splice(n,1):a===".."?(e.splice(n,1),r++):r&&(e.splice(n,1),r--)}if(t)for(;r--;r)e.unshift("..");return e}function n0(){for(var e="",t=!1,r=arguments.length-1;r>=-1&&!t;r--){var n=r>=0?arguments[r]:"/";if(typeof n!="string")throw new TypeError("Arguments to path.resolve must be strings");if(!n)continue;e=n+"/"+e,t=n.charAt(0)==="/"}return e=MO(o0(e.split("/"),function(a){return!!a}),!t).join("/"),(t?"/":"")+e||"."}function OO(e){var t=NO(e),r=yZ(e,-1)==="/";return e=MO(o0(e.split("/"),function(n){return!!n}),!t).join("/"),!e&&!t&&(e="."),e&&r&&(e+="/"),(t?"/":"")+e}function NO(e){return e.charAt(0)==="/"}function lZ(){var e=Array.prototype.slice.call(arguments,0);return OO(o0(e,function(t,r){if(typeof t!="string")throw new TypeError("Arguments to path.join must be strings");return t}).join("/"))}function dZ(e,t){e=n0(e).substr(1),t=n0(t).substr(1);function r(l){for(var m=0;m<l.length&&l[m]==="";m++);for(var p=l.length-
1;p>=0&&l[p]==="";p--);return m>p?[]:l.slice(m,p-m+1)}i(r,"trim");for(var n=r(e.split("/")),a=r(t.split("/")),o=Math.min(n.length,a.length),s=o,c=0;c<o;c++)if(n[c]!==a[c]){s=c;break}for(var u=[],c=s;c<n.length;c++)u.push("..");return u=u.concat(a.slice(s)),u.join("/")}function fZ(e){var t=a0(e),r=t[0],n=t[1];return!r&&!n?".":(n&&(n=n.substr(0,n.length-1)),r+n)}function hZ(e,t){var r=a0(e)[2];return t&&r.substr(-1*t.length)===t&&(r=r.substr(0,r.length-t.length)),r}function gZ(e){return a0(e)[3]}function o0(e,t){if(e.filter)return e.filter(t);for(var r=[],n=0;n<e.length;n++)t(e[n],n,e)&&r.push(e[n]);return r}var uZ,a0,mZ,pZ,fr,yZ,Vi=g(()=>{d();i(MO,"normalizeArray");uZ=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,a0=i(function(e){return uZ.exec(e).slice(1)},"splitPath");i(n0,"resolve");i(OO,"normalize");i(NO,"isAbsolute");i(lZ,"join");i(dZ,"relative");mZ="/",pZ=":";i(fZ,"dirname");i(hZ,"basename");i(gZ,"extname");fr={extname:gZ,basename:hZ,dirname:fZ,sep:mZ,delimiter:pZ,
relative:dZ,join:lZ,isAbsolute:NO,normalize:OO,resolve:n0};i(o0,"filter");yZ="ab".substr(-1)==="b"?function(e,t,r){return e.substr(t,r)}:function(e,t,r){return t<0&&(t=e.length+t),e.substr(t,r)}});var vZ,vg,i0=g(()=>{d();vZ=typeof globalThis=="object"&&globalThis&&globalThis.Object===Object&&globalThis,vg=vZ});var bZ,wZ,Xr,so=g(()=>{d();i0();bZ=typeof self=="object"&&self&&self.Object===Object&&self,wZ=vg||bZ||Function("return this")(),Xr=wZ});var EZ,Wo,bg=g(()=>{d();so();EZ=Xr.Symbol,Wo=EZ});function xZ(e){var t=DZ.call(e,jd),r=e[jd];try{e[jd]=void 0;var n=!0}catch{}var a=TZ.call(e);return n&&(t?e[jd]=r:delete e[jd]),a}var LO,DZ,TZ,jd,PO,BO=g(()=>{d();bg();LO=Object.prototype,DZ=LO.hasOwnProperty,TZ=LO.toString,jd=Wo?Wo.toStringTag:void 0;i(xZ,"getRawTag");PO=xZ});function IZ(e){return CZ.call(e)}var SZ,CZ,UO,jO=g(()=>{d();SZ=Object.prototype,CZ=SZ.toString;i(IZ,"objectToString");UO=IZ});function _Z(e){return e==null?e===void 0?RZ:kZ:qO&&qO in Object(e)?PO(e):UO(e)}var kZ,RZ,qO,Vo,qd=g(()=>{d();bg();BO();jO();kZ="[object Null]",RZ="[object Undefined]",qO=Wo?Wo.toStringTag:void 0;i(_Z,"baseGetTag");Vo=_Z});function AZ(e){return e!=null&&typeof e=="object"}var $o,zd=g(()=>{d();i(AZ,"isObjectLike");$o=AZ});var FZ,ic,wg=g(()=>{d();FZ=Array.isArray,ic=FZ});function MZ(e){var t=typeof e;return e!=null&&(t=="object"||t=="function")}var Eg,s0=g(()=>{d();i(MZ,"isObject");Eg=MZ});function BZ(e){if(!Eg(e))return!1;var t=Vo(e);return t==NZ||t==LZ||t==OZ||t==PZ}var OZ,NZ,LZ,PZ,Dg,c0=g(()=>{d();qd();s0();OZ="[object AsyncFunction]",NZ="[object Function]",LZ="[object GeneratorFunction]",PZ="[object Proxy]";i(BZ,"isFunction");Dg=BZ});var UZ,Tg,zO=g(()=>{d();so();UZ=Xr["__core-js_shared__"],Tg=UZ});function jZ(e){return!!HO&&HO in e}var HO,GO,WO=g(()=>{d();zO();HO=(function(){var e=/[^.]+$/.exec(Tg&&Tg.keys&&Tg.keys.IE_PROTO||"");return e?"Symbol(src)_1."+e:""})();i(jZ,"isMasked");GO=jZ});function HZ(e){if(e!=null){try{return zZ.call(e)}catch{}try{return e+""}catch{}}return""}var qZ,zZ,Yo,u0=g(()=>{d();qZ=Function.prototype,zZ=qZ.toString;i(HZ,"toSource");Yo=HZ});function XZ(e){if(!Eg(e)||GO(e))return!1;var t=Dg(e)?JZ:WZ;return t.test(Yo(e))}var GZ,WZ,VZ,$Z,YZ,KZ,JZ,VO,$O=g(()=>{d();c0();WO();s0();u0();GZ=/[\\^$.*+?()[\]{}|]/g,WZ=/^\[object .+?Constructor\]$/,VZ=Function.prototype,$Z=Object.prototype,YZ=VZ.toString,KZ=$Z.hasOwnProperty,JZ=RegExp("^"+YZ.call(KZ).replace(GZ,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");i(XZ,"baseIsNative");VO=XZ});function ZZ(e,t){return e?.[t]}var YO,KO=g(()=>{d();i(ZZ,"getValue");YO=ZZ});function QZ(e,t){var r=YO(e,t);return VO(r)?r:void 0}var va,sc=g(()=>{d();$O();KO();i(QZ,"getNative");va=QZ});var eQ,xg,JO=g(()=>{d();sc();so();eQ=va(Xr,"WeakMap"),xg=eQ});function nQ(e,t){var r=typeof e;return t=t??tQ,!!t&&(r=="number"||r!="symbol"&&rQ.test(e))&&e>-1&&e%1==0&&e<t}var tQ,rQ,XO,ZO=g(()=>{d();tQ=9007199254740991,rQ=/^(?:0|[1-9]\d*)$/;i(nQ,"isIndex");XO=nQ});function aQ(e,t){return e===t||e!==e&&t!==t}var Sg,l0=g(()=>{d();i(aQ,"eq");Sg=aQ});function iQ(e){return typeof e=="number"&&e>-1&&e%1==0&&e<=oQ}var oQ,Cg,d0=g(()=>{d();oQ=9007199254740991;i(iQ,"isLength");Cg=iQ});function sQ(e){return e!=null&&Cg(e.length)&&!Dg(e)}var QO,eN=g(()=>{d();c0();d0();i(sQ,"isArrayLike");QO=sQ});function uQ(e){var t=e&&e.constructor,r=typeof t=="function"&&t.prototype||cQ;return e===r}var cQ,tN,rN=g(()=>{d();cQ=Object.prototype;i(uQ,"isPrototype");tN=uQ});function lQ(e,t){for(var r=-1,n=Array(e);++r<e;)n[r]=t(r);return n}var nN,aN=g(()=>{d();i(lQ,"baseTimes");nN=lQ});function mQ(e){return $o(e)&&Vo(e)==dQ}var dQ,m0,oN=g(()=>{d();qd();zd();dQ="[object Arguments]";i(mQ,"baseIsArguments");m0=mQ});var iN,pQ,fQ,hQ,sN,cN=g(()=>{d();oN();zd();iN=Object.prototype,pQ=iN.hasOwnProperty,fQ=iN.propertyIsEnumerable,hQ=m0((function(){return arguments})())?m0:function(e){return $o(e)&&pQ.call(e,"callee")&&!fQ.call(e,"callee")},sN=hQ});function gQ(){return!1}var uN,lN=g(()=>{d();i(gQ,"stubFalse");uN=gQ});var pN,dN,yQ,mN,vQ,bQ,Hd,p0=g(()=>{d();so();lN();pN=typeof exports=="object"&&exports&&!exports.nodeType&&exports,dN=pN&&typeof module=="object"&&module&&!module.nodeType&&module,yQ=dN&&dN.exports===pN,mN=yQ?Xr.Buffer:void 0,vQ=mN?mN.isBuffer:void 0,bQ=vQ||uN,Hd=bQ});function GQ(e){return $o(e)&&Cg(e.length)&&!!ur[Vo(e)]}var wQ,EQ,DQ,TQ,xQ,SQ,CQ,IQ,kQ,RQ,_Q,AQ,FQ,MQ,OQ,NQ,LQ,PQ,BQ,UQ,jQ,qQ,zQ,HQ,ur,fN,hN=g(()=>{d();qd();d0();zd();wQ="[object Arguments]",EQ="[object Array]",DQ="[object Boolean]",TQ="[object Date]",xQ="[object Error]",SQ="[object Function]",CQ="[object Map]",IQ="[object Number]",kQ="[object Object]",RQ="[object RegExp]",_Q="[object Set]",AQ="[object String]",FQ="[object WeakMap]",MQ="[object ArrayBuffer]",OQ="[object DataView]",NQ="[object Float32Array]",LQ="[object Float64Array]",PQ="[object Int8Array]",BQ="[object Int16Array]",UQ="[object Int32Array]",jQ="[object Uint8Array]",qQ="[object Uint8ClampedArray]",zQ="[object Uint16Array]",HQ="[object Uint32Array]",ur={};ur[NQ]=ur[LQ]=ur[PQ]=ur[BQ]=ur[UQ]=ur[jQ]=ur[qQ]=ur[zQ]=ur[HQ]=!0;ur[wQ]=ur[EQ]=ur[MQ]=ur[DQ]=ur[OQ]=ur[TQ]=ur[xQ]=ur[SQ]=ur[CQ]=ur[IQ]=ur[kQ]=ur[RQ]=ur[_Q]=ur[AQ]=ur[FQ]=!1;i(GQ,"baseIsTypedArray");fN=GQ});function WQ(e){return function(t){return e(t)}}var gN,yN=g(()=>{d();i(WQ,"baseUnary");gN=WQ});var vN,Gd,VQ,f0,$Q,h0,bN=g(()=>{d();i0();vN=typeof exports=="object"&&exports&&!exports.nodeType&&exports,Gd=vN&&typeof module=="object"&&module&&!module.nodeType&&module,VQ=Gd&&Gd.exports===vN,f0=VQ&&vg.process,$Q=(function(){try{var e=Gd&&Gd.require&&Gd.require("util").types;return e||f0&&f0.binding&&f0.binding("util")}catch{}})(),h0=$Q});var wN,YQ,Ig,g0=g(()=>{d();hN();yN();bN();wN=h0&&h0.isTypedArray,YQ=wN?gN(wN):fN,Ig=YQ});function XQ(e,t){var r=ic(e),n=!r&&sN(e),a=!r&&!n&&Hd(e),o=!r&&!n&&!a&&Ig(e),s=r||n||a||o,c=s?nN(e.length,String):[],u=c.length;for(var l in e)(t||JQ.call(e,l))&&!(s&&(l=="length"||a&&(l=="offset"||l=="parent")||o&&(l=="buffer"||l=="byteLength"||l=="byteOffset")||XO(l,u)))&&c.push(l);return c}var KQ,JQ,EN,DN=g(()=>{d();aN();cN();wg();p0();ZO();g0();KQ=Object.prototype,JQ=KQ.hasOwnProperty;i(XQ,"arrayLikeKeys");EN=XQ});function ZQ(e,t){return function(r){return e(t(r))}}var TN,xN=g(()=>{d();i(ZQ,"overArg");TN=ZQ});var QQ,SN,CN=g(()=>{d();xN();QQ=TN(Object.keys,Object),SN=QQ});function ree(e){if(!tN(e))return SN(e);var t=[];for(var r in Object(e))tee.call(e,r)&&r!="constructor"&&t.push(r);return t}var eee,tee,IN,kN=g(()=>{d();rN();CN();eee=Object.prototype,tee=eee.hasOwnProperty;i(ree,"baseKeys");IN=ree});function nee(e){return QO(e)?EN(e):IN(e)}var RN,_N=g(()=>{d();DN();kN();eN();i(nee,"keys");RN=nee});var aee,Ko,Wd=g(()=>{d();sc();aee=va(Object,"create"),Ko=aee});function oee(){this.__data__=Ko?Ko(null):{},this.size=0}var AN,FN=g(()=>{d();Wd();i(oee,"hashClear");AN=oee});function iee(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t}var MN,ON=g(()=>{d();i(iee,"hashDelete");MN=iee});function lee(e){var t=this.__data__;if(Ko){var r=t[e];return r===see?void 0:r}return uee.call(t,e)?t[e]:void 0}var see,cee,uee,NN,LN=g(()=>{d();Wd();see="__lodash_hash_undefined__",cee=Object.prototype,uee=cee.hasOwnProperty;i(lee,"hashGet");NN=lee});function pee(e){var t=this.__data__;return Ko?t[e]!==void 0:mee.call(t,e)}var dee,mee,PN,BN=g(()=>{d();Wd();dee=Object.prototype,mee=dee.hasOwnProperty;i(pee,"hashHas");PN=pee});function hee(e,t){var r=this.__data__;return this.size+=this.has(e)?0:1,r[e]=Ko&&t===void 0?fee:t,this}var fee,UN,jN=g(()=>{d();Wd();fee="__lodash_hash_undefined__";i(hee,"hashSet");UN=hee});function Iu(e){var t=-1,r=e==null?0:e.length;for(this.clear();++t<r;){var n=e[t];this.set(n[0],n[1])}}var y0,qN=g(()=>{d();FN();ON();LN();BN();jN();i(Iu,"Hash");Iu.prototype.clear=AN;Iu.prototype.delete=MN;Iu.prototype.get=NN;Iu.prototype.has=PN;Iu.prototype.set=UN;y0=Iu});function gee(){this.__data__=[],this.size=0}var zN,HN=g(()=>{d();i(gee,"listCacheClear");zN=gee});function yee(e,t){for(var r=e.length;r--;)if(Sg(e[r][0],t))return r;return-1}var $i,Vd=g(()=>{d();l0();i(yee,"assocIndexOf");$i=yee});function wee(e){var t=this.__data__,r=$i(t,e);if(r<0)return!1;var n=t.length-1;return r==n?t.pop():bee.call(t,r,1),--this.size,!0}var vee,bee,GN,WN=g(()=>{d();Vd();vee=Array.prototype,bee=vee.splice;i(wee,"listCacheDelete");GN=wee});function Eee(e){var t=this.__data__,r=$i(t,e);return r<0?void 0:t[r][1]}var VN,$N=g(()=>{d();Vd();i(Eee,"listCacheGet");VN=Eee});function Dee(e){return $i(this.__data__,e)>-1}var YN,KN=g(()=>{d();Vd();i(Dee,"listCacheHas");YN=Dee});function Tee(e,t){var r=this.__data__,n=$i(r,e);return n<0?(++this.size,r.push([e,t])):r[n][1]=t,this}var JN,XN=g(()=>{d();Vd();i(Tee,"listCacheSet");JN=Tee});function ku(e){var t=-1,r=e==null?0:e.length;for(this.clear();++t<r;){var n=e[t];this.set(n[0],n[1])}}var Yi,$d=g(()=>{d();HN();WN();$N();KN();XN();i(ku,"ListCache");ku.prototype.clear=zN;ku.prototype.delete=GN;ku.prototype.get=VN;ku.prototype.has=YN;ku.prototype.set=JN;Yi=ku});var xee,Ki,kg=g(()=>{d();sc();so();xee=va(Xr,"Map"),Ki=xee});function See(){this.size=0,this.__data__={hash:new y0,map:new(Ki||Yi),string:new y0}}var ZN,QN=g(()=>{d();qN();$d();kg();i(See,"mapCacheClear");ZN=See});function Cee(e){var t=typeof e;return t=="string"||t=="number"||t=="symbol"||t=="boolean"?e!=="__proto__":e===null}var e3,t3=g(()=>{d();i(Cee,"isKeyable");e3=Cee});function Iee(e,t){var r=e.__data__;return e3(t)?r[typeof t=="string"?"string":"hash"]:r.map}var Ji,Yd=g(()=>{d();t3();i(Iee,"getMapData");Ji=Iee});function kee(e){var t=Ji(this,e).delete(e);return this.size-=t?1:0,t}var r3,n3=g(()=>{d();Yd();i(kee,"mapCacheDelete");r3=kee});function Ree(e){return Ji(this,e).get(e)}var a3,o3=g(()=>{d();Yd();i(Ree,"mapCacheGet");a3=Ree});function _ee(e){return Ji(this,e).has(e)}var i3,s3=g(()=>{d();Yd();i(_ee,"mapCacheHas");i3=_ee});function Aee(e,t){var r=Ji(this,e),n=r.size;return r.set(e,t),this.size+=r.size==n?0:1,this}var c3,u3=g(()=>{d();Yd();i(Aee,"mapCacheSet");c3=Aee});function Ru(e){var t=-1,r=e==null?0:e.length;for(this.clear();++t<r;){var n=e[t];this.set(n[0],n[1])}}var Rg,v0=g(()=>{d();QN();n3();o3();s3();u3();i(Ru,"MapCache");Ru.prototype.clear=ZN;Ru.prototype.delete=r3;Ru.prototype.get=a3;Ru.prototype.has=i3;Ru.prototype.set=c3;Rg=Ru});function Fee(e,t){for(var r=-1,n=t.length,a=e.length;++r<n;)e[a+r]=t[r];return e}var l3,d3=g(()=>{d();i(Fee,"arrayPush");l3=Fee});function Mee(){this.__data__=new Yi,this.size=0}var m3,p3=g(()=>{d();$d();i(Mee,"stackClear");m3=Mee});function Oee(e){var t=this.__data__,r=t.delete(e);return this.size=t.size,r}var f3,h3=g(()=>{d();i(Oee,"stackDelete");f3=Oee});function Nee(e){return this.__data__.get(e)}var g3,y3=g(()=>{d();i(Nee,"stackGet");g3=Nee});function Lee(e){return this.__data__.has(e)}var v3,b3=g(()=>{d();i(Lee,"stackHas");v3=Lee});function Bee(e,t){var r=this.__data__;if(r instanceof Yi){var n=r.__data__;if(!Ki||n.length<Pee-1)return n.push([e,t]),this.size=++r.size,this;r=this.__data__=new Rg(n)}return r.set(e,t),this.size=r.size,this}var Pee,w3,E3=g(()=>{d();$d();kg();v0();Pee=200;i(Bee,"stackSet");w3=Bee});function _u(e){var t=this.__data__=new Yi(e);this.size=t.size}var _g,D3=g(()=>{d();$d();p3();h3();y3();b3();E3();i(_u,"Stack");_u.prototype.clear=m3;_u.prototype.delete=f3;_u.prototype.get=g3;_u.prototype.has=v3;_u.prototype.set=w3;_g=_u});function Uee(e,t){for(var r=-1,n=e==null?0:e.length,a=0,o=[];++r<n;){var s=e[r];t(s,r,e)&&(o[a++]=s)}return o}var T3,x3=g(()=>{d();i(Uee,"arrayFilter");T3=Uee});function jee(){return[]}var S3,C3=g(()=>{d();i(jee,"stubArray");S3=jee});var qee,zee,I3,Hee,k3,R3=g(()=>{d();x3();C3();qee=Object.prototype,zee=qee.propertyIsEnumerable,I3=Object.getOwnPropertySymbols,Hee=I3?function(e){return e==null?[]:(e=Object(e),T3(I3(e),function(t){return zee.call(e,t)}))}:S3,k3=Hee});function Gee(e,t,r){var n=t(e);return ic(e)?n:l3(n,r(e))}var _3,A3=g(()=>{d();d3();wg();i(Gee,"baseGetAllKeys");_3=Gee});function Wee(e){return _3(e,RN,k3)}var b0,F3=g(()=>{d();A3();R3();_N();i(Wee,"getAllKeys");b0=Wee});var Vee,Ag,M3=g(()=>{d();sc();so();Vee=va(Xr,"DataView"),Ag=Vee});var $ee,Fg,O3=g(()=>{d();sc();so();$ee=va(Xr,"Promise"),Fg=$ee});var Yee,Mg,N3=g(()=>{d();sc();so();Yee=va(Xr,"Set"),Mg=Yee});var L3,Kee,P3,B3,U3,j3,Jee,Xee,Zee,Qee,ete,cc,w0,q3=g(()=>{d();M3();kg();O3();N3();JO();qd();u0();L3="[object Map]",Kee="[object Object]",P3="[object Promise]",B3="[object Set]",U3="[object WeakMap]",j3="[object DataView]",Jee=Yo(Ag),Xee=Yo(Ki),Zee=Yo(Fg),Qee=Yo(Mg),ete=Yo(xg),cc=Vo;(Ag&&cc(new Ag(new ArrayBuffer(1)))!=j3||Ki&&cc(new Ki)!=L3||Fg&&cc(Fg.resolve())!=P3||Mg&&cc(new Mg)!=B3||xg&&cc(new xg)!=U3)&&(cc=i(function(e){var t=Vo(e),r=t==Kee?e.constructor:void 0,n=r?Yo(r):"";if(n)switch(n){case Jee:return j3;case Xee:return L3;case Zee:return P3;case Qee:return B3;case ete:return U3}return t},"getTag"));w0=cc});var tte,E0,z3=g(()=>{d();so();tte=Xr.Uint8Array,E0=tte});function nte(e){return this.__data__.set(e,rte),this}var rte,H3,G3=g(()=>{d();rte="__lodash_hash_undefined__";i(nte,"setCacheAdd");H3=nte});function ate(e){return this.__data__.has(e)}var W3,V3=g(()=>{d();i(ate,"setCacheHas");W3=ate});function Og(e){var t=-1,r=e==null?0:e.length;for(this.__data__=new Rg;++t<r;)this.add(e[t])}var $3,Y3=g(()=>{d();v0();G3();V3();i(Og,"SetCache");Og.prototype.add=Og.prototype.push=H3;Og.prototype.has=W3;$3=Og});function ote(e,t){for(var r=-1,n=e==null?0:e.length;++r<n;)if(t(e[r],r,e))return!0;return!1}var K3,J3=g(()=>{d();i(ote,"arraySome");K3=ote});function ite(e,t){return e.has(t)}var X3,Z3=g(()=>{d();i(ite,"cacheHas");X3=ite});function ute(e,t,r,n,a,o){var s=r&ste,c=e.length,u=t.length;if(c!=u&&!(s&&u>c))return!1;var l=o.get(e),m=o.get(t);if(l&&m)return l==t&&m==e;var p=-1,f=!0,h=r&cte?new $3:void 0;for(o.set(e,t),o.set(t,e);++p<c;){var y=e[p],v=t[p];if(n)var E=s?n(v,y,p,t,e,o):n(y,v,p,e,t,o);if(E!==void 0){if(E)continue;f=!1;break}if(h){if(!K3(t,function(T,x){if(!X3(h,x)&&(y===T||a(y,T,r,n,o)))return h.push(x)})){f=!1;break}}else if(!(y===v||a(y,v,r,n,o))){f=!1;break}}return o.delete(e),o.delete(t),f}var ste,cte,Ng,D0=g(()=>{d();Y3();J3();Z3();ste=1,cte=2;i(ute,"equalArrays");Ng=ute});function lte(e){var t=-1,r=Array(e.size);return e.forEach(function(n,a){r[++t]=[a,n]}),r}var Q3,eL=g(()=>{d();i(lte,"mapToArray");Q3=lte});function dte(e){var t=-1,r=Array(e.size);return e.forEach(function(n){r[++t]=n}),r}var tL,rL=g(()=>{d();i(dte,"setToArray");tL=dte});function Ste(e,t,r,n,a,o,s){switch(r){case xte:if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case Tte:return!(e.byteLength!=t.byteLength||!o(new E0(e),new E0(t)));case fte:case hte:case vte:return Sg(+e,+t);case gte:return e.name==t.name&&e.message==t.message;case bte:case Ete:return e==t+"";case yte:var c=Q3;case wte:var u=n&mte;if(c||(c=tL),e.size!=t.size&&!u)return!1;var l=s.get(e);if(l)return l==t;n|=pte,s.set(e,t);var m=Ng(c(e),c(t),n,a,o,s);return s.delete(e),m;case Dte:if(T0)return T0.call(e)==T0.call(t)}return!1}var mte,pte,fte,hte,gte,yte,vte,bte,wte,Ete,Dte,Tte,xte,nL,T0,aL,oL=g(()=>{d();bg();z3();l0();D0();eL();rL();mte=1,pte=2,fte="[object Boolean]",hte="[object Date]",gte="[object Error]",yte="[object Map]",vte="[object Number]",bte="[object RegExp]",wte="[object Set]",Ete="[object String]",Dte="[object Symbol]",Tte="[object ArrayBuffer]",xte="[object DataView]",nL=Wo?Wo.prototype:void 0,T0=nL?nL.valueOf:void 0;i(Ste,"equalByTag");
aL=Ste});function Rte(e,t,r,n,a,o){var s=r&Cte,c=b0(e),u=c.length,l=b0(t),m=l.length;if(u!=m&&!s)return!1;for(var p=u;p--;){var f=c[p];if(!(s?f in t:kte.call(t,f)))return!1}var h=o.get(e),y=o.get(t);if(h&&y)return h==t&&y==e;var v=!0;o.set(e,t),o.set(t,e);for(var E=s;++p<u;){f=c[p];var T=e[f],x=t[f];if(n)var S=s?n(x,T,f,t,e,o):n(T,x,f,e,t,o);if(!(S===void 0?T===x||a(T,x,r,n,o):S)){v=!1;break}E||(E=f=="constructor")}if(v&&!E){var I=e.constructor,F=t.constructor;I!=F&&"constructor"in e&&"constructor"in t&&!(typeof I=="function"&&I instanceof I&&typeof F=="function"&&F instanceof F)&&(v=!1)}return o.delete(e),o.delete(t),v}var Cte,Ite,kte,iL,sL=g(()=>{d();F3();Cte=1,Ite=Object.prototype,kte=Ite.hasOwnProperty;i(Rte,"equalObjects");iL=Rte});function Fte(e,t,r,n,a,o){var s=ic(e),c=ic(t),u=s?uL:w0(e),l=c?uL:w0(t);u=u==cL?Lg:u,l=l==cL?Lg:l;var m=u==Lg,p=l==Lg,f=u==l;if(f&&Hd(e)){if(!Hd(t))return!1;s=!0,m=!1}if(f&&!m)return o||(o=new _g),s||Ig(e)?Ng(e,t,r,n,a,o):aL(e,t,u,r,n,a,o);if(!(r&_te)){var h=m&&lL.call(e,"__wrapped__"),y=p&&lL.call(t,"__wrapped__");if(h||y){var v=h?e.value():e,E=y?t.value():t;return o||(o=new _g),a(v,E,r,n,o)}}return f?(o||(o=new _g),iL(e,t,r,n,a,o)):!1}var _te,cL,uL,Lg,Ate,lL,dL,mL=g(()=>{d();D3();D0();oL();sL();q3();wg();p0();g0();_te=1,cL="[object Arguments]",uL="[object Array]",Lg="[object Object]",Ate=Object.prototype,lL=Ate.hasOwnProperty;i(Fte,"baseIsEqualDeep");dL=Fte});function pL(e,t,r,n,a){return e===t?!0:e==null||t==null||!$o(e)&&!$o(t)?e!==e&&t!==t:dL(e,t,r,n,pL,a)}var fL,hL=g(()=>{d();mL();zd();i(pL,"baseIsEqual");fL=pL});function Mte(e,t){return fL(e,t)}var co,gL=g(()=>{d();hL();i(Mte,"isEqual");co=Mte});var Kd=g(()=>{d();gL();});var Au,Pg=g(()=>{"use strict";d();zi();Au=!!gn.env.CI||gn.env.NODE_ENV==="test"});function Pte(e){let t=Math.sign(e);e=Math.abs(e);let r=.254829592,n=-.284496736,a=1.421413741,o=-1.453152027,s=1.061405429,u=1/(1+.3275911*e),l=u*(r+u*(n+u*(a+u*(o+u*s))));return t*(1-l*Math.exp(-e*e))}function yL({median:e,p10:t},r){if(e<=0)throw new Error("median must be greater than zero");if(t<=0)throw new Error("p10 must be greater than zero");if(t>=e)throw new Error("p10 must be less than the median");if(r<=0)return 1;let n=.9061938024368232,a=Math.max(Number.MIN_VALUE,r/e),o=Math.log(a),s=Math.max(Number.MIN_VALUE,t/e),c=-Math.log(s),u=o*n/c,l=(1-Pte(u))/2,m;return r<=t?m=Math.max(.9,Math.min(1,l)):r<=e?m=Math.max(Nte,Math.min(Ote,l)):m=Math.max(0,Math.min(Lte,l)),m}function vL(e,t,r,n,a){let o=(n-t)/(r-e);return t+(a-e)*o}var Ote,Nte,Lte,x0=g(()=>{"use strict";d();Ote=.8999999999999999,Nte=.5,Lte=.49999999999999994;i(Pte,"erf");i(yL,"getLogNormalScore");i(vL,"linearInterpolation")});var Jo,Ute,bL,jte,qte,Bt,uo=g(()=>{"use strict";d();x0();Jo="…",Ute=" ",bL=.9,jte={PASS:{label:"pass",minScore:bL},AVERAGE:{label:"average",minScore:.5},FAIL:{label:"fail"},ERROR:{label:"error"}},qte=["com","co","gov","edu","ac","org","go","gob","or","net","in","ne","nic","gouv","web","spb","blog","jus","kiev","mil","wi","qc","ca","bel","on"],Bt=class e{static{i(this,"Util")}static get RATINGS(){return jte}static get PASS_THRESHOLD(){return bL}static get MS_DISPLAY_VALUE(){return`%10d${Ute}ms`}static getFinalDisplayedUrl(t){if(t.finalDisplayedUrl)return t.finalDisplayedUrl;if(t.finalUrl)return t.finalUrl;throw new Error("Could not determine final displayed URL")}static getMainDocumentUrl(t){return t.mainDocumentUrl||t.finalUrl}static getFullPageScreenshot(t){return t.fullPageScreenshot?t.fullPageScreenshot:t.audits["full-page-screenshot"]?.details}static getEntityFromUrl(t,r){return r&&r.find(a=>a.origins.find(o=>t.startsWith(o)))||e.getPseudoRootDomain(t)}static splitMarkdownCodeSpans(t){
let r=[],n=t.split(/`(.*?)`/g);for(let a=0;a<n.length;a++){let o=n[a];if(!o)continue;let s=a%2!==0;r.push({isCode:s,text:o})}return r}static splitMarkdownLink(t){let r=[],n=t.split(/\[([^\]]+?)\]\((https?:\/\/.*?)\)/g);for(;n.length;){let[a,o,s]=n.splice(0,3);a&&r.push({isLink:!1,text:a}),o&&s&&r.push({isLink:!0,text:o,linkHref:s})}return r}static truncate(t,r,n="…"){if(t.length<=r)return t;let o=new Intl.Segmenter(void 0,{granularity:"grapheme"}).segment(t)[Symbol.iterator](),s=0;for(let c=0;c<=r-n.length;c++){let u=o.next();if(u.done)return t;s=u.value.index}for(let c=0;c<n.length;c++)if(o.next().done)return t;return t.slice(0,s)+n}static getURLDisplayName(t,r){r=r||{numPathParts:void 0,preserveQuery:void 0,preserveHost:void 0};let n=r.numPathParts!==void 0?r.numPathParts:2,a=r.preserveQuery!==void 0?r.preserveQuery:!0,o=r.preserveHost||!1,s;if(t.protocol==="about:"||t.protocol==="data:")s=t.href;else{s=t.pathname;let u=s.split("/").filter(l=>l.length);n&&u.length>n&&(s=Jo+u.slice(
-1*n).join("/")),o&&(s=`${t.host}/${s.replace(/^\//,"")}`),a&&(s=`${s}${t.search}`)}let c=64;if(t.protocol!=="data:"&&(s=s.slice(0,200),s=s.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${Jo}`),s=s.replace(/([a-zA-Z0-9-_]{9})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])[a-zA-Z0-9-_]{10,}/g,`$1${Jo}`),s=s.replace(/(\d{3})\d{6,}/g,`$1${Jo}`),s=s.replace(/\u2026+/g,Jo),s.length>c&&s.includes("?")&&(s=s.replace(/\?([^=]*)(=)?.*/,`?$1$2${Jo}`),s.length>c&&(s=s.replace(/\?.*/,`?${Jo}`)))),s.length>c){let u=s.lastIndexOf(".");u>=0?s=s.slice(0,c-1-(s.length-u))+`${Jo}${s.slice(u)}`:s=s.slice(0,c-1)+Jo}return s}static getChromeExtensionOrigin(t){let r=new URL(t);return r.protocol+"//"+r.host}static parseURL(t){let r=new URL(t);return{file:e.getURLDisplayName(r),hostname:r.hostname,origin:r.protocol==="chrome-extension:"?e.getChromeExtensionOrigin(t):r.origin}}static createOrReturnURL(t){return t instanceof URL?t:new URL(t)}static getPseudoTld(t){let r=t.split(".").slice(-2);return qte.includes(r[0])?`.${r.
join(".")}`:`.${r[r.length-1]}`}static getPseudoRootDomain(t){let r=e.createOrReturnURL(t).hostname,a=e.getPseudoTld(r).split(".");return r.split(".").slice(-a.length).join(".")}static filterRelevantLines(t,r,n){if(r.length===0)return t.slice(0,n*2+1);let a=3,o=new Set;return r=r.sort((s,c)=>(s.lineNumber||0)-(c.lineNumber||0)),r.forEach(({lineNumber:s})=>{let c=s-n,u=s+n;for(;c<1;)c++,u++;o.has(c-a-1)&&(c-=a);for(let l=c;l<=u;l++){let m=l;o.add(m)}}),t.filter(s=>o.has(s.lineNumber))}static computeLogNormalScore(t,r){let n=yL(t,r);return n>.9&&(n+=.05*(n-.9)),Math.floor(n*100)/100}}});var zte,Hte,Gte,w,ie=g(()=>{"use strict";d();yn();Pg();uo();zte="defaultPass",Hte={FCP:50,LCP:50,INP:50,TBT:50,CLS:.001},Gte=i(e=>Math.round(e*100)/100,"clampTo2Decimals"),w=class e{static{i(this,"Audit")}static get DEFAULT_PASS(){return zte}static get SCORING_MODES(){return{NUMERIC:"numeric",METRIC_SAVINGS:"metricSavings",BINARY:"binary",MANUAL:"manual",INFORMATIVE:"informative",NOT_APPLICABLE:"notApplicable",ERROR:"error"}}static get meta(){throw new Error("Audit meta information must be overridden.")}static get defaultOptions(){return{}}static audit(t,r){throw new Error("audit() method must be overridden")}static computeLogNormalScore(t,r){return Bt.computeLogNormalScore(t,r)}static assertHeadingKeysExist(t,r){if(r.length&&Au)for(let n of t){if(n.key===null)continue;let a=n.key;if(!r.some(o=>a in o))throw new Error(`"${n.key}" is missing from items`)}}static makeChecklistDetails(t){return{type:"checklist",items:t}}static makeTableDetails(t,r,n={}){let{wastedBytes:a,wastedMs:o,sortedBy:s,
skipSumming:c,isEntityGrouped:u}=n,l=a||o?{wastedBytes:a,wastedMs:o}:void 0;return r.length===0?{type:"table",headings:t,items:[],summary:l}:(e.assertHeadingKeysExist(t,r),{type:"table",headings:t,items:r,summary:l,sortedBy:s,skipSumming:c,isEntityGrouped:u})}static makeListDetails(t){return{type:"list",items:t}}static makeListDetailSectionItem(t,r,n){return{type:"list-section",title:r,description:n,value:t}}static makeSnippetDetails({content:t,title:r,lineMessages:n,generalMessages:a,node:o,maxLineLength:s=200,maxLinesAroundMessage:c=20}){let u=e._makeSnippetLinesArray(t,s);return{type:"snippet",lines:Bt.filterRelevantLines(u,n,c),title:r,lineMessages:n,generalMessages:a,lineCount:u.length,node:o}}static _makeSnippetLinesArray(t,r){return t.split(`
`).map((n,a)=>{let o=a+1,s={content:Bt.truncate(n,r),lineNumber:o};return n.length>r&&(s.truncated=!0),s})}static makeOpportunityDetails(t,r,n){e.assertHeadingKeysExist(t,r);let{overallSavingsMs:a,overallSavingsBytes:o,sortedBy:s,skipSumming:c,isEntityGrouped:u}=n;return{type:"opportunity",headings:r.length===0?[]:t,items:r,overallSavingsMs:a,overallSavingsBytes:o,sortedBy:s,skipSumming:c,isEntityGrouped:u}}static makeNodeItem(t){return{type:"node",lhId:t.lhId,path:t.devtoolsNodePath,selector:t.selector,boundingRect:t.boundingRect,snippet:t.snippet,nodeLabel:t.nodeLabel}}static _findOriginalLocation(t,r,n){let a=t?.map.findEntry(r,n);if(a)return{file:a.sourceURL||"",line:a.sourceLineNumber||0,column:a.sourceColumnNumber||0}}static makeSourceLocation(t,r,n,a){return{type:"source-location",url:t,urlProvider:"network",line:r,column:n,original:a&&this._findOriginalLocation(a,r,n)}}static makeSourceLocationFromConsoleMessage(t,r){if(!t.url)return;let n=t.lineNumber||0,a=t.columnNumber||0;return this.
makeSourceLocation(t.url,n,a,r)}static _normalizeAuditScore(t,r,n){if(r===e.SCORING_MODES.INFORMATIVE)return 1;if(r!==e.SCORING_MODES.BINARY&&r!==e.SCORING_MODES.NUMERIC&&r!==e.SCORING_MODES.METRIC_SAVINGS)return null;if(t===null||!Number.isFinite(t))throw new Error(`Invalid score for ${n}: ${t}`);if(t>1)throw new Error(`Audit score for ${n} is > 1`);if(t<0)throw new Error(`Audit score for ${n} is < 0`);return t=Gte(t),t}static _quantizeMetricSavings(t){if(!t)return;let r={...t};for(let n of Object.keys(t)){let a=t[n];if(a===void 0)continue;a=Math.max(a,0);let o=Hte[n];o!==void 0&&(a=Math.round(a/o)*o),r[n]=a}return r}static generateErrorAuditResult(t,r,n){return e.generateAuditResult(t,{score:null,errorMessage:r,errorStack:n})}static generateAuditResult(t,r){if(r.score===void 0)throw new Error("generateAuditResult requires a score");let n=t.meta.scoreDisplayMode||e.SCORING_MODES.BINARY,a=r.score;r.errorMessage!==void 0?n=e.SCORING_MODES.ERROR:r.notApplicable?n=e.SCORING_MODES.NOT_APPLICABLE:
r.scoreDisplayMode&&(n=r.scoreDisplayMode);let o=e._quantizeMetricSavings(r.metricSavings),s=Object.values(o||{}).some(l=>l);n===e.SCORING_MODES.METRIC_SAVINGS&&(a&&a>=Bt.PASS_THRESHOLD?a=1:s?a=0:a=.5),a=e._normalizeAuditScore(a,n,t.meta.id);let c=t.meta.title;t.meta.failureTitle&&a!==null&&a<Bt.PASS_THRESHOLD&&(c=t.meta.failureTitle);let u="numericUnit"in r?r:void 0;return{id:t.meta.id,title:c,description:t.meta.description,score:a,scoreDisplayMode:n,numericValue:u?.numericValue,numericUnit:u?.numericUnit,displayValue:r.displayValue,explanation:r.explanation,errorMessage:r.errorMessage,errorStack:r.errorStack,warnings:r.warnings,scoringOptions:r.scoringOptions,metricSavings:o,details:r.details,guidanceLevel:t.meta.guidanceLevel,replacesAudits:t.meta.replacesAudits}}static makeMetricComputationDataInput(t,r){let n=t.Trace??t.traces[e.DEFAULT_PASS],a=t.DevtoolsLog??t.devtoolsLogs[e.DEFAULT_PASS],o=t.GatherContext,{URL:s,SourceMaps:c}=t;return{trace:n,devtoolsLog:a,gatherContext:o,settings:r.
settings,URL:s,SourceMaps:c,simulator:null}}}});var Wte,Bg,wL=g(()=>{"use strict";d();ie();Wte=i(e=>Math.round(e*100)/100,"clampTo2Decimals"),Bg=class e{static{i(this,"ReportScoring")}static arithmeticMean(t){if(t=t.filter(n=>n.weight>0),t.some(n=>n.score===null))return null;let r=t.reduce((n,a)=>{let o=a.score,s=a.weight;return{weight:n.weight+s,sum:n.sum+o*s}},{weight:0,sum:0});return Wte(r.sum/r.weight||0)}static scoreAllCategories(t,r){let n={};for(let[a,o]of Object.entries(t)){let s=o.auditRefs.map(l=>{let m={...l},p=r[m.id];return(p.scoreDisplayMode===w.SCORING_MODES.NOT_APPLICABLE||p.scoreDisplayMode===w.SCORING_MODES.INFORMATIVE||p.scoreDisplayMode===w.SCORING_MODES.MANUAL)&&(m.weight=0),m}),c=s.map(l=>({score:r[l.id].score,weight:l.weight})),u=e.arithmeticMean(c);n[a]={...o,auditRefs:s,id:a,score:u}}return n}}});function Jd(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");S0(e,t);function r(){this.constructor=e}i(r,"__"),e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}function EL(e,t){var r={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.indexOf(n)<0&&(r[n]=e[n]);if(e!=null&&typeof Object.getOwnPropertySymbols=="function")for(var a=0,n=Object.getOwnPropertySymbols(e);a<n.length;a++)t.indexOf(n[a])<0&&Object.prototype.propertyIsEnumerable.call(e,n[a])&&(r[n[a]]=e[n[a]]);return r}function Ug(e,t,r){if(r||arguments.length===2)for(var n=0,a=t.length,o;n<a;n++)(o||!(n in t))&&(o||(o=Array.prototype.slice.call(t,0,n)),o[n]=t[n]);return e.concat(o||Array.prototype.slice.call(t))}var S0,qa,C0=g(()=>{d();S0=i(function(e,t){return S0=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,n){r.__proto__=n}||function(r,n){for(var a in n)Object.prototype.hasOwnProperty.call(n,a)&&(r[a]=
n[a])},S0(e,t)},"extendStatics");i(Jd,"__extends");qa=i(function(){return qa=Object.assign||i(function(t){for(var r,n=1,a=arguments.length;n<a;n++){r=arguments[n];for(var o in r)Object.prototype.hasOwnProperty.call(r,o)&&(t[o]=r[o])}return t},"__assign"),qa.apply(this,arguments)},"__assign");i(EL,"__rest");i(Ug,"__spreadArray")});var Fu,I0=g(()=>{d();Fu=i(function(){return Fu=Object.assign||i(function(t){for(var r,n=1,a=arguments.length;n<a;n++){r=arguments[n];for(var o in r)Object.prototype.hasOwnProperty.call(r,o)&&(t[o]=r[o])}return t},"__assign"),Fu.apply(this,arguments)},"__assign")});var kt,k0=g(()=>{d();(function(e){e[e.EXPECT_ARGUMENT_CLOSING_BRACE=1]="EXPECT_ARGUMENT_CLOSING_BRACE",e[e.EMPTY_ARGUMENT=2]="EMPTY_ARGUMENT",e[e.MALFORMED_ARGUMENT=3]="MALFORMED_ARGUMENT",e[e.EXPECT_ARGUMENT_TYPE=4]="EXPECT_ARGUMENT_TYPE",e[e.INVALID_ARGUMENT_TYPE=5]="INVALID_ARGUMENT_TYPE",e[e.EXPECT_ARGUMENT_STYLE=6]="EXPECT_ARGUMENT_STYLE",e[e.INVALID_NUMBER_SKELETON=7]="INVALID_NUMBER_SKELETON",e[e.INVALID_DATE_TIME_SKELETON=8]="INVALID_DATE_TIME_SKELETON",e[e.EXPECT_NUMBER_SKELETON=9]="EXPECT_NUMBER_SKELETON",e[e.EXPECT_DATE_TIME_SKELETON=10]="EXPECT_DATE_TIME_SKELETON",e[e.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE=11]="UNCLOSED_QUOTE_IN_ARGUMENT_STYLE",e[e.EXPECT_SELECT_ARGUMENT_OPTIONS=12]="EXPECT_SELECT_ARGUMENT_OPTIONS",e[e.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE=13]="EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE=14]="INVALID_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR=15]="EXPECT_SELECT_ARGUMENT_SELECTOR",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR=
16]="EXPECT_PLURAL_ARGUMENT_SELECTOR",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT=17]="EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT=18]="EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT",e[e.INVALID_PLURAL_ARGUMENT_SELECTOR=19]="INVALID_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_PLURAL_ARGUMENT_SELECTOR=20]="DUPLICATE_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_SELECT_ARGUMENT_SELECTOR=21]="DUPLICATE_SELECT_ARGUMENT_SELECTOR",e[e.MISSING_OTHER_CLAUSE=22]="MISSING_OTHER_CLAUSE",e[e.INVALID_TAG=23]="INVALID_TAG",e[e.INVALID_TAG_NAME=25]="INVALID_TAG_NAME",e[e.UNMATCHED_CLOSING_TAG=26]="UNMATCHED_CLOSING_TAG",e[e.UNCLOSED_TAG=27]="UNCLOSED_TAG"})(kt||(kt={}))});function R0(e){return e.type===lr.literal}function DL(e){return e.type===lr.argument}function jg(e){return e.type===lr.number}function qg(e){return e.type===lr.date}function zg(e){return e.type===lr.time}function Hg(e){return e.type===lr.select}function Gg(e){return e.type===lr.plural}function TL(e){return e.type===lr.pound}function Wg(e){return e.type===lr.tag}function Vg(e){return!!(e&&typeof e=="object"&&e.type===uc.number)}function Xd(e){return!!(e&&typeof e=="object"&&e.type===uc.dateTime)}var lr,uc,$g=g(()=>{d();(function(e){e[e.literal=0]="literal",e[e.argument=1]="argument",e[e.number=2]="number",e[e.date=3]="date",e[e.time=4]="time",e[e.select=5]="select",e[e.plural=6]="plural",e[e.pound=7]="pound",e[e.tag=8]="tag"})(lr||(lr={}));(function(e){e[e.number=0]="number",e[e.dateTime=1]="dateTime"})(uc||(uc={}));i(R0,"isLiteralElement");i(DL,"isArgumentElement");i(jg,"isNumberElement");i(qg,"isDateElement");i(zg,"isTimeElement");i(Hg,"isSelectElement");i(Gg,"isPluralElement");i(TL,"\
isPoundElement");i(Wg,"isTagElement");i(Vg,"isNumberSkeleton");i(Xd,"isDateTimeSkeleton")});var _0,xL=g(()=>{d();_0=/[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/});function SL(e){var t={};return e.replace(Vte,function(r){var n=r.length;switch(r[0]){case"G":t.era=n===4?"long":n===5?"narrow":"short";break;case"y":t.year=n===2?"2-digit":"numeric";break;case"Y":case"u":case"U":case"r":throw new RangeError("`Y/u/U/r` (year) patterns are not supported, use `y` instead");case"q":case"Q":throw new RangeError("`q/Q` (quarter) patterns are not supported");case"M":case"L":t.month=["numeric","2-digit","short","long","narrow"][n-1];break;case"w":case"W":throw new RangeError("`w/W` (week) patterns are not supported");case"d":t.day=["numeric","2-digit"][n-1];break;case"D":case"F":case"g":throw new RangeError("`D/F/g` (day) patterns are not supported, use `d` instead");case"E":t.weekday=n===4?"short":n===5?"narrow":"short";break;case"e":if(n<4)throw new RangeError("`e..eee` (weekday) patterns are not supported");t.weekday=["short","long","narrow","short"][n-4];break;case"c":if(n<4)throw new RangeError("`c..ccc` (weekday) patterns are not supported");t.weekday=["\
short","long","narrow","short"][n-4];break;case"a":t.hour12=!0;break;case"b":case"B":throw new RangeError("`b/B` (period) patterns are not supported, use `a` instead");case"h":t.hourCycle="h12",t.hour=["numeric","2-digit"][n-1];break;case"H":t.hourCycle="h23",t.hour=["numeric","2-digit"][n-1];break;case"K":t.hourCycle="h11",t.hour=["numeric","2-digit"][n-1];break;case"k":t.hourCycle="h24",t.hour=["numeric","2-digit"][n-1];break;case"j":case"J":case"C":throw new RangeError("`j/J/C` (hour) patterns are not supported, use `h/H/K/k` instead");case"m":t.minute=["numeric","2-digit"][n-1];break;case"s":t.second=["numeric","2-digit"][n-1];break;case"S":case"A":throw new RangeError("`S/A` (second) patterns are not supported, use `s` instead");case"z":t.timeZoneName=n<4?"short":"long";break;case"Z":case"O":case"v":case"V":case"X":case"x":throw new RangeError("`Z/O/v/V/X/x` (timeZone) patterns are not supported, use `z` instead")}return""}),t}var Vte,CL=g(()=>{d();Vte=/(?:[Eec]{1,6}|G{1,5}|[Qq]{1,5}|(?:[yYur]+|U{1,5})|[ML]{1,5}|d{1,2}|D{1,3}|F{1}|[abB]{1,5}|[hkHK]{1,2}|w{1,2}|W{1}|m{1,2}|s{1,2}|[zZOvVxX]{1,4})(?=([^']*'[^']*')*[^']*$)/g;
i(SL,"parseDateTimeSkeleton")});var yr,IL=g(()=>{d();yr=i(function(){return yr=Object.assign||i(function(t){for(var r,n=1,a=arguments.length;n<a;n++){r=arguments[n];for(var o in r)Object.prototype.hasOwnProperty.call(r,o)&&(t[o]=r[o])}return t},"__assign"),yr.apply(this,arguments)},"__assign")});var kL,RL=g(()=>{d();kL=/[\t-\r \x85\u200E\u200F\u2028\u2029]/i});function ML(e){if(e.length===0)throw new Error("Number skeleton cannot be empty");for(var t=e.split(kL).filter(function(f){return f.length>0}),r=[],n=0,a=t;n<a.length;n++){var o=a[n],s=o.split("/");if(s.length===0)throw new Error("Invalid number skeleton");for(var c=s[0],u=s.slice(1),l=0,m=u;l<m.length;l++){var p=m[l];if(p.length===0)throw new Error("Invalid number skeleton")}r.push({stem:c,options:u})}return r}function $te(e){return e.replace(/^(.*?)-/,"")}function AL(e){var t={};return e[e.length-1]==="r"?t.roundingPriority="morePrecision":e[e.length-1]==="s"&&(t.roundingPriority="lessPrecision"),e.replace(OL,function(r,n,a){return typeof a!="string"?(t.minimumSignificantDigits=n.length,t.maximumSignificantDigits=n.length):a==="+"?t.minimumSignificantDigits=n.length:n[0]==="#"?t.maximumSignificantDigits=n.length:(t.minimumSignificantDigits=n.length,t.maximumSignificantDigits=n.length+(typeof a=="string"?a.length:0)),""}),t}function LL(e){switch(e){case"sign-auto":return{signDisplay:"\
auto"};case"sign-accounting":case"()":return{currencySign:"accounting"};case"sign-always":case"+!":return{signDisplay:"always"};case"sign-accounting-always":case"()!":return{signDisplay:"always",currencySign:"accounting"};case"sign-except-zero":case"+?":return{signDisplay:"exceptZero"};case"sign-accounting-except-zero":case"()?":return{signDisplay:"exceptZero",currencySign:"accounting"};case"sign-never":case"+_":return{signDisplay:"never"}}}function Kte(e){var t;if(e[0]==="E"&&e[1]==="E"?(t={notation:"engineering"},e=e.slice(2)):e[0]==="E"&&(t={notation:"scientific"},e=e.slice(1)),t){var r=e.slice(0,2);if(r==="+!"?(t.signDisplay="always",e=e.slice(2)):r==="+?"&&(t.signDisplay="exceptZero",e=e.slice(2)),!NL.test(e))throw new Error("Malformed concise eng/scientific notation");t.minimumIntegerDigits=e.length}return t}function FL(e){var t={},r=LL(e);return r||t}function PL(e){for(var t={},r=0,n=e;r<n.length;r++){var a=n[r];switch(a.stem){case"percent":case"%":t.style="percent";continue;case"\
%x100":t.style="percent",t.scale=100;continue;case"currency":t.style="currency",t.currency=a.options[0];continue;case"group-off":case",_":t.useGrouping=!1;continue;case"precision-integer":case".":t.maximumFractionDigits=0;continue;case"measure-unit":case"unit":t.style="unit",t.unit=$te(a.options[0]);continue;case"compact-short":case"K":t.notation="compact",t.compactDisplay="short";continue;case"compact-long":case"KK":t.notation="compact",t.compactDisplay="long";continue;case"scientific":t=yr(yr(yr({},t),{notation:"scientific"}),a.options.reduce(function(u,l){return yr(yr({},u),FL(l))},{}));continue;case"engineering":t=yr(yr(yr({},t),{notation:"engineering"}),a.options.reduce(function(u,l){return yr(yr({},u),FL(l))},{}));continue;case"notation-simple":t.notation="standard";continue;case"unit-width-narrow":t.currencyDisplay="narrowSymbol",t.unitDisplay="narrow";continue;case"unit-width-short":t.currencyDisplay="code",t.unitDisplay="short";continue;case"unit-width-full-name":t.currencyDisplay=
"name",t.unitDisplay="long";continue;case"unit-width-iso-code":t.currencyDisplay="symbol";continue;case"scale":t.scale=parseFloat(a.options[0]);continue;case"integer-width":if(a.options.length>1)throw new RangeError("integer-width stems only accept a single optional option");a.options[0].replace(Yte,function(u,l,m,p,f,h){if(l)t.minimumIntegerDigits=m.length;else{if(p&&f)throw new Error("We currently do not support maximum integer digits");if(h)throw new Error("We currently do not support exact integer digits")}return""});continue}if(NL.test(a.stem)){t.minimumIntegerDigits=a.stem.length;continue}if(_L.test(a.stem)){if(a.options.length>1)throw new RangeError("Fraction-precision stems only accept a single optional option");a.stem.replace(_L,function(u,l,m,p,f,h){return m==="*"?t.minimumFractionDigits=l.length:p&&p[0]==="#"?t.maximumFractionDigits=p.length:f&&h?(t.minimumFractionDigits=f.length,t.maximumFractionDigits=f.length+h.length):(t.minimumFractionDigits=l.length,t.maximumFractionDigits=
l.length),""});var o=a.options[0];o==="w"?t=yr(yr({},t),{trailingZeroDisplay:"stripIfInteger"}):o&&(t=yr(yr({},t),AL(o)));continue}if(OL.test(a.stem)){t=yr(yr({},t),AL(a.stem));continue}var s=LL(a.stem);s&&(t=yr(yr({},t),s));var c=Kte(a.stem);c&&(t=yr(yr({},t),c))}return t}var _L,OL,Yte,NL,BL=g(()=>{d();IL();RL();i(ML,"parseNumberSkeletonFromString");i($te,"icuUnitToEcma");_L=/^\.(?:(0+)(\*)?|(#+)|(0+)(#+))$/g,OL=/^(@+)?(\+|#+)?[rs]?$/g,Yte=/(\*)(0+)|(#+)(0+)|(0+)/g,NL=/^(0+)$/;i(AL,"parseSignificantPrecision");i(LL,"parseSign");i(Kte,"parseConciseScientificAndEngineeringStem");i(FL,"parseNotationOptions");i(PL,"parseNumberSkeleton")});var UL=g(()=>{d();CL();BL()});var Zd,jL=g(()=>{d();Zd={"001":["H","h"],AC:["H","h","hb","hB"],AD:["H","hB"],AE:["h","hB","hb","H"],AF:["H","hb","hB","h"],AG:["h","hb","H","hB"],AI:["H","h","hb","hB"],AL:["h","H","hB"],AM:["H","hB"],AO:["H","hB"],AR:["H","h","hB","hb"],AS:["h","H"],AT:["H","hB"],AU:["h","hb","H","hB"],AW:["H","hB"],AX:["H"],AZ:["H","hB","h"],BA:["H","hB","h"],BB:["h","hb","H","hB"],BD:["h","hB","H"],BE:["H","hB"],BF:["H","hB"],BG:["H","hB","h"],BH:["h","hB","hb","H"],BJ:["H","hB"],BL:["H","hB"],BM:["h","hb","H","hB"],BN:["hb","hB","h","H"],BO:["H","hB","h","hb"],BQ:["H"],BR:["H","hB"],BS:["h","hb","H","hB"],BT:["h","H"],BW:["H","h","hb","hB"],BZ:["H","h","hb","hB"],CA:["h","hb","H","hB"],CC:["H","h","hb","hB"],CD:["hB","H"],CF:["H","h","hB"],CG:["H","hB"],CH:["H","hB","h"],CI:["H","hB"],CK:["H","h","hb","hB"],CL:["H","h","hB","hb"],CM:["H","h","hB"],CN:["H","hB","hb","h"],CO:["h","H","hB","hb"],CP:["H"],CR:["H","h","hB","hb"],CU:["H","h","hB","hb"],CV:["H","hB"],CX:["H","h","hb","hB"],CY:["h","H","h\
b","hB"],CZ:["H"],DE:["H","hB"],DG:["H","h","hb","hB"],DJ:["h","H"],DK:["H"],DM:["h","hb","H","hB"],DO:["h","H","hB","hb"],DZ:["h","hB","hb","H"],EA:["H","h","hB","hb"],EC:["H","hB","h","hb"],EE:["H","hB"],EG:["h","hB","hb","H"],EH:["h","hB","hb","H"],ER:["h","H"],ES:["H","hB","h","hb"],ET:["hB","hb","h","H"],FI:["H"],FJ:["h","hb","H","hB"],FK:["H","h","hb","hB"],FM:["h","hb","H","hB"],FR:["H","hB"],GA:["H","hB"],GB:["H","h","hb","hB"],GD:["h","hb","H","hB"],GE:["H","hB","h"],GF:["H","hB"],GG:["H","h","hb","hB"],GH:["h","H"],GI:["H","h","hb","hB"],GM:["h","hb","H","hB"],GN:["H","hB"],GP:["H","hB"],GQ:["H","hB","h","hb"],GR:["h","H","hb","hB"],GT:["H","h","hB","hb"],GU:["h","hb","H","hB"],GW:["H","hB"],GY:["h","hb","H","hB"],HK:["h","hB","hb","H"],HN:["H","h","hB","hb"],HR:["H","hB"],IC:["H","h","hB","hb"],ID:["H"],IE:["H","h","hb","hB"],IL:["H","hB"],IM:["H","h","hb","hB"],IN:["h","H"],IO:["H","h","hb","hB"],IQ:["h","hB","hb","H"],IR:["hB","H"],IS:["H"],IT:["H","hB"],JE:["H","h","hb","\
hB"],JM:["h","hb","H","hB"],JO:["h","hB","hb","H"],JP:["H","h","K"],KE:["hB","hb","H","h"],KG:["H","h","hB","hb"],KH:["hB","h","H","hb"],KI:["h","hb","H","hB"],KM:["H","h","hB","hb"],KN:["h","hb","H","hB"],KP:["h","H","hB","hb"],KR:["h","H","hB","hb"],KW:["h","hB","hb","H"],KY:["h","hb","H","hB"],KZ:["H","hB"],LA:["H","hb","hB","h"],LB:["h","hB","hb","H"],LC:["h","hb","H","hB"],LI:["H","hB","h"],LK:["H","h","hB","hb"],LR:["h","hb","H","hB"],LS:["h","H"],LT:["H","h","hb","hB"],LU:["H","h","hB"],LV:["H","hB","hb","h"],LY:["h","hB","hb","H"],MA:["H","h","hB","hb"],MC:["H","hB"],MD:["H","hB"],ME:["H","hB","h"],MF:["H","hB"],MH:["h","hb","H","hB"],MK:["H","h","hb","hB"],ML:["H"],MM:["hB","hb","H","h"],MN:["H","h","hb","hB"],MO:["h","hB","hb","H"],MP:["h","hb","H","hB"],MQ:["H","hB"],MR:["h","hB","hb","H"],MS:["H","h","hb","hB"],MW:["h","hb","H","hB"],MX:["H","h","hB","hb"],MY:["hb","hB","h","H"],MZ:["H","hB"],NA:["h","H","hB","hb"],NC:["H","hB"],NE:["H"],NF:["H","h","hb","hB"],NG:["H","h","\
hb","hB"],NI:["H","h","hB","hb"],NL:["H","hB"],NP:["H","h","hB"],NR:["H","h","hb","hB"],NU:["H","h","hb","hB"],NZ:["h","hb","H","hB"],OM:["h","hB","hb","H"],PA:["h","H","hB","hb"],PE:["H","hB","h","hb"],PF:["H","h","hB"],PG:["h","H"],PH:["h","hB","hb","H"],PK:["h","hB","H"],PM:["H","hB"],PN:["H","h","hb","hB"],PR:["h","H","hB","hb"],PS:["h","hB","hb","H"],PT:["H","hB"],PW:["h","H"],PY:["H","h","hB","hb"],QA:["h","hB","hb","H"],RE:["H","hB"],RO:["H","hB"],RS:["H","hB","h"],RU:["H"],SA:["h","hB","hb","H"],SB:["h","hb","H","hB"],SC:["H","h","hB"],SD:["h","hB","hb","H"],SE:["H"],SG:["h","hb","H","hB"],SH:["H","h","hb","hB"],SI:["H","hB"],SJ:["H"],SK:["H"],SL:["h","hb","H","hB"],SM:["H","h","hB"],SN:["H","h","hB"],SO:["h","H"],SR:["H","hB"],SS:["h","hb","H","hB"],ST:["H","hB"],SV:["H","h","hB","hb"],SX:["H","h","hb","hB"],SY:["h","hB","hb","H"],SZ:["h","hb","H","hB"],TA:["H","h","hb","hB"],TC:["h","hb","H","hB"],TD:["h","H","hB"],TF:["H","h","hB"],TG:["H","hB"],TL:["H","hB","hb","h"],TN:["h",
"hB","hb","H"],TO:["h","H"],TR:["H","hB"],TT:["h","hb","H","hB"],TW:["hB","hb","h","H"],TZ:["hB","hb","H","h"],UA:["H","hB","h"],UG:["hB","hb","H","h"],UM:["h","hb","H","hB"],US:["h","hb","H","hB"],UY:["H","h","hB","hb"],UZ:["H","hB","h"],VA:["H","h","hB"],VC:["h","hb","H","hB"],VE:["h","H","hB","hb"],VG:["h","hb","H","hB"],VI:["h","hb","H","hB"],VU:["h","H"],WF:["H","hB"],WS:["h","H"],XK:["H","hB","h"],YE:["h","hB","hb","H"],YT:["H","hB"],ZA:["H","h","hb","hB"],ZM:["h","hb","H","hB"],"af-ZA":["H","h","hB","hb"],"ar-001":["h","hB","hb","H"],"ca-ES":["H","h","hB"],"en-001":["h","hb","H","hB"],"es-BO":["H","h","hB","hb"],"es-BR":["H","h","hB","hb"],"es-EC":["H","h","hB","hb"],"es-ES":["H","h","hB","hb"],"es-GQ":["H","h","hB","hb"],"es-PE":["H","h","hB","hb"],"fr-CA":["H","h","hB"],"gl-ES":["H","h","hB"],"gu-IN":["hB","hb","h","H"],"hi-IN":["hB","h","H"],"it-CH":["H","h","hB"],"it-IT":["H","h","hB"],"kn-IN":["hB","h","H"],"ml-IN":["hB","h","H"],"mr-IN":["hB","hb","h","H"],"pa-IN":["hB","h\
b","h","H"],"ta-IN":["hB","h","hb","H"],"te-IN":["hB","h","H"],"zu-ZA":["H","hB","hb","h"]}});function qL(e,t){for(var r="",n=0;n<e.length;n++){var a=e.charAt(n);if(a==="j"){for(var o=0;n+1<e.length&&e.charAt(n+1)===a;)o++,n++;var s=1+(o&1),c=o<2?1:3+(o>>1),u="a",l=Jte(t);for((l=="H"||l=="k")&&(c=0);c-- >0;)r+=u;for(;s-- >0;)r=l+r}else a==="J"?r+="H":r+=a}return r}function Jte(e){var t=e.hourCycle;if(t===void 0&&e.hourCycles&&e.hourCycles.length&&(t=e.hourCycles[0]),t)switch(t){case"h24":return"k";case"h23":return"H";case"h12":return"h";case"h11":return"K";default:throw new Error("Invalid hourCycle")}var r=e.language,n;r!=="root"&&(n=e.maximize().region);var a=Zd[n||""]||Zd[r||""]||Zd["".concat(r,"-001")]||Zd["001"];return a[0]}var zL=g(()=>{d();jL();i(qL,"getBestPattern");i(Jte,"getDefaultHourSymbolFromLocale")});function Mt(e,t){return{start:e,end:t}}function $L(e,t){return new RegExp(e,t)}function L0(e){return e>=97&&e<=122||e>=65&&e<=90}function ure(e){return L0(e)||e===47}function lre(e){return e===45||e===46||e>=48&&e<=57||e===95||e>=97&&e<=122||e>=65&&e<=90||e==183||e>=192&&e<=214||e>=216&&e<=246||e>=248&&e<=893||e>=895&&e<=8191||e>=8204&&e<=8205||e>=8255&&e<=8256||e>=8304&&e<=8591||e>=11264&&e<=12271||e>=12289&&e<=55295||e>=63744&&e<=64975||e>=65008&&e<=65533||e>=65536&&e<=983039}function KL(e){return e>=9&&e<=13||e===32||e===133||e>=8206&&e<=8207||e===8232||e===8233}function dre(e){return e>=33&&e<=35||e===36||e>=37&&e<=39||e===40||e===41||e===42||e===43||e===44||e===45||e>=46&&e<=47||e>=58&&e<=59||e>=60&&e<=62||e>=63&&e<=64||e===91||e===92||e===93||e===94||e===96||e===123||e===124||e===125||e===126||e===161||e>=162&&e<=165||e===166||e===167||e===169||e===171||e===172||e===174||e===176||e===177||e===182||e===187||e===191||e===215||e===247||e>=8208&&e<=8213||e>=8214&&e<=8215||e===8216||e===
8217||e===8218||e>=8219&&e<=8220||e===8221||e===8222||e===8223||e>=8224&&e<=8231||e>=8240&&e<=8248||e===8249||e===8250||e>=8251&&e<=8254||e>=8257&&e<=8259||e===8260||e===8261||e===8262||e>=8263&&e<=8273||e===8274||e===8275||e>=8277&&e<=8286||e>=8592&&e<=8596||e>=8597&&e<=8601||e>=8602&&e<=8603||e>=8604&&e<=8607||e===8608||e>=8609&&e<=8610||e===8611||e>=8612&&e<=8613||e===8614||e>=8615&&e<=8621||e===8622||e>=8623&&e<=8653||e>=8654&&e<=8655||e>=8656&&e<=8657||e===8658||e===8659||e===8660||e>=8661&&e<=8691||e>=8692&&e<=8959||e>=8960&&e<=8967||e===8968||e===8969||e===8970||e===8971||e>=8972&&e<=8991||e>=8992&&e<=8993||e>=8994&&e<=9e3||e===9001||e===9002||e>=9003&&e<=9083||e===9084||e>=9085&&e<=9114||e>=9115&&e<=9139||e>=9140&&e<=9179||e>=9180&&e<=9185||e>=9186&&e<=9254||e>=9255&&e<=9279||e>=9280&&e<=9290||e>=9291&&e<=9311||e>=9472&&e<=9654||e===9655||e>=9656&&e<=9664||e===9665||e>=9666&&e<=9719||e>=9720&&e<=9727||e>=9728&&e<=9838||e===9839||e>=9840&&e<=10087||e===10088||e===10089||e===10090||
e===10091||e===10092||e===10093||e===10094||e===10095||e===10096||e===10097||e===10098||e===10099||e===10100||e===10101||e>=10132&&e<=10175||e>=10176&&e<=10180||e===10181||e===10182||e>=10183&&e<=10213||e===10214||e===10215||e===10216||e===10217||e===10218||e===10219||e===10220||e===10221||e===10222||e===10223||e>=10224&&e<=10239||e>=10240&&e<=10495||e>=10496&&e<=10626||e===10627||e===10628||e===10629||e===10630||e===10631||e===10632||e===10633||e===10634||e===10635||e===10636||e===10637||e===10638||e===10639||e===10640||e===10641||e===10642||e===10643||e===10644||e===10645||e===10646||e===10647||e===10648||e>=10649&&e<=10711||e===10712||e===10713||e===10714||e===10715||e>=10716&&e<=10747||e===10748||e===10749||e>=10750&&e<=11007||e>=11008&&e<=11055||e>=11056&&e<=11076||e>=11077&&e<=11078||e>=11079&&e<=11084||e>=11085&&e<=11123||e>=11124&&e<=11125||e>=11126&&e<=11157||e===11158||e>=11159&&e<=11263||e>=11776&&e<=11777||e===11778||e===11779||e===11780||e===11781||e>=11782&&e<=11784||e===
11785||e===11786||e===11787||e===11788||e===11789||e>=11790&&e<=11798||e===11799||e>=11800&&e<=11801||e===11802||e===11803||e===11804||e===11805||e>=11806&&e<=11807||e===11808||e===11809||e===11810||e===11811||e===11812||e===11813||e===11814||e===11815||e===11816||e===11817||e>=11818&&e<=11822||e===11823||e>=11824&&e<=11833||e>=11834&&e<=11835||e>=11836&&e<=11839||e===11840||e===11841||e===11842||e>=11843&&e<=11855||e>=11856&&e<=11857||e===11858||e>=11859&&e<=11903||e>=12289&&e<=12291||e===12296||e===12297||e===12298||e===12299||e===12300||e===12301||e===12302||e===12303||e===12304||e===12305||e>=12306&&e<=12307||e===12308||e===12309||e===12310||e===12311||e===12312||e===12313||e===12314||e===12315||e===12316||e===12317||e>=12318&&e<=12319||e===12320||e===12336||e===64830||e===64831||e>=65093&&e<=65094}var A0,Xte,Zte,Qte,ere,tre,rre,nre,are,ore,ire,M0,HL,GL,O0,WL,VL,sre,cre,N0,F0,YL,JL=g(()=>{d();I0();k0();$g();xL();UL();zL();Xte=new RegExp("^".concat(_0.source,"*")),Zte=new RegExp("".
concat(_0.source,"*$"));i(Mt,"createLocation");Qte=!!String.prototype.startsWith&&"_a".startsWith("a",1),ere=!!String.fromCodePoint,tre=!!Object.fromEntries,rre=!!String.prototype.codePointAt,nre=!!String.prototype.trimStart,are=!!String.prototype.trimEnd,ore=!!Number.isSafeInteger,ire=ore?Number.isSafeInteger:function(e){return typeof e=="number"&&isFinite(e)&&Math.floor(e)===e&&Math.abs(e)<=9007199254740991},M0=!0;try{HL=$L("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),M0=((A0=HL.exec("a"))===null||A0===void 0?void 0:A0[0])==="a"}catch{M0=!1}GL=i(Qte?function(t,r,n){return t.startsWith(r,n)}:function(t,r,n){return t.slice(n,n+r.length)===r},"startsWith"),O0=ere?String.fromCodePoint:i(function(){for(var t=[],r=0;r<arguments.length;r++)t[r]=arguments[r];for(var n="",a=t.length,o=0,s;a>o;){if(s=t[o++],s>1114111)throw RangeError(s+" is not a valid code point");n+=s<65536?String.fromCharCode(s):String.fromCharCode(((s-=65536)>>10)+55296,s%1024+56320)}return n},"fromCodePoint"),WL=tre?
Object.fromEntries:i(function(t){for(var r={},n=0,a=t;n<a.length;n++){var o=a[n],s=o[0],c=o[1];r[s]=c}return r},"fromEntries"),VL=i(rre?function(t,r){return t.codePointAt(r)}:function(t,r){var n=t.length;if(!(r<0||r>=n)){var a=t.charCodeAt(r),o;return a<55296||a>56319||r+1===n||(o=t.charCodeAt(r+1))<56320||o>57343?a:(a-55296<<10)+(o-56320)+65536}},"codePointAt"),sre=i(nre?function(t){return t.trimStart()}:function(t){return t.replace(Xte,"")},"trimStart"),cre=i(are?function(t){return t.trimEnd()}:function(t){return t.replace(Zte,"")},"trimEnd");i($L,"RE");M0?(F0=$L("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),N0=i(function(t,r){var n;F0.lastIndex=r;var a=F0.exec(t);return(n=a[1])!==null&&n!==void 0?n:""},"matchIdentifierAtIndex")):N0=i(function(t,r){for(var n=[];;){var a=VL(t,r);if(a===void 0||KL(a)||dre(a))break;n.push(a),r+=a>=65536?2:1}return O0.apply(void 0,n)},"matchIdentifierAtIndex");YL=(function(){function e(t,r){r===void 0&&(r={}),this.message=t,this.position={offset:0,line:1,
column:1},this.ignoreTag=!!r.ignoreTag,this.locale=r.locale,this.requiresOtherClause=!!r.requiresOtherClause,this.shouldParseSkeletons=!!r.shouldParseSkeletons}return i(e,"Parser"),e.prototype.parse=function(){if(this.offset()!==0)throw Error("parser can only be used once");return this.parseMessage(0,"",!1)},e.prototype.parseMessage=function(t,r,n){for(var a=[];!this.isEOF();){var o=this.char();if(o===123){var s=this.parseArgument(t,n);if(s.err)return s;a.push(s.val)}else{if(o===125&&t>0)break;if(o===35&&(r==="plural"||r==="selectordinal")){var c=this.clonePosition();this.bump(),a.push({type:lr.pound,location:Mt(c,this.clonePosition())})}else if(o===60&&!this.ignoreTag&&this.peek()===47){if(n)break;return this.error(kt.UNMATCHED_CLOSING_TAG,Mt(this.clonePosition(),this.clonePosition()))}else if(o===60&&!this.ignoreTag&&L0(this.peek()||0)){var s=this.parseTag(t,r);if(s.err)return s;a.push(s.val)}else{var s=this.parseLiteral(t,r);if(s.err)return s;a.push(s.val)}}}return{val:a,err:null}},
e.prototype.parseTag=function(t,r){var n=this.clonePosition();this.bump();var a=this.parseTagName();if(this.bumpSpace(),this.bumpIf("/>"))return{val:{type:lr.literal,value:"<".concat(a,"/>"),location:Mt(n,this.clonePosition())},err:null};if(this.bumpIf(">")){var o=this.parseMessage(t+1,r,!0);if(o.err)return o;var s=o.val,c=this.clonePosition();if(this.bumpIf("</")){if(this.isEOF()||!L0(this.char()))return this.error(kt.INVALID_TAG,Mt(c,this.clonePosition()));var u=this.clonePosition(),l=this.parseTagName();return a!==l?this.error(kt.UNMATCHED_CLOSING_TAG,Mt(u,this.clonePosition())):(this.bumpSpace(),this.bumpIf(">")?{val:{type:lr.tag,value:a,children:s,location:Mt(n,this.clonePosition())},err:null}:this.error(kt.INVALID_TAG,Mt(c,this.clonePosition())))}else return this.error(kt.UNCLOSED_TAG,Mt(n,this.clonePosition()))}else return this.error(kt.INVALID_TAG,Mt(n,this.clonePosition()))},e.prototype.parseTagName=function(){var t=this.offset();for(this.bump();!this.isEOF()&&lre(this.char());)
this.bump();return this.message.slice(t,this.offset())},e.prototype.parseLiteral=function(t,r){for(var n=this.clonePosition(),a="";;){var o=this.tryParseQuote(r);if(o){a+=o;continue}var s=this.tryParseUnquoted(t,r);if(s){a+=s;continue}var c=this.tryParseLeftAngleBracket();if(c){a+=c;continue}break}var u=Mt(n,this.clonePosition());return{val:{type:lr.literal,value:a,location:u},err:null}},e.prototype.tryParseLeftAngleBracket=function(){return!this.isEOF()&&this.char()===60&&(this.ignoreTag||!ure(this.peek()||0))?(this.bump(),"<"):null},e.prototype.tryParseQuote=function(t){if(this.isEOF()||this.char()!==39)return null;switch(this.peek()){case 39:return this.bump(),this.bump(),"'";case 123:case 60:case 62:case 125:break;case 35:if(t==="plural"||t==="selectordinal")break;return null;default:return null}this.bump();var r=[this.char()];for(this.bump();!this.isEOF();){var n=this.char();if(n===39)if(this.peek()===39)r.push(39),this.bump();else{this.bump();break}else r.push(n);this.bump()}return O0.
apply(void 0,r)},e.prototype.tryParseUnquoted=function(t,r){if(this.isEOF())return null;var n=this.char();return n===60||n===123||n===35&&(r==="plural"||r==="selectordinal")||n===125&&t>0?null:(this.bump(),O0(n))},e.prototype.parseArgument=function(t,r){var n=this.clonePosition();if(this.bump(),this.bumpSpace(),this.isEOF())return this.error(kt.EXPECT_ARGUMENT_CLOSING_BRACE,Mt(n,this.clonePosition()));if(this.char()===125)return this.bump(),this.error(kt.EMPTY_ARGUMENT,Mt(n,this.clonePosition()));var a=this.parseIdentifierIfPossible().value;if(!a)return this.error(kt.MALFORMED_ARGUMENT,Mt(n,this.clonePosition()));if(this.bumpSpace(),this.isEOF())return this.error(kt.EXPECT_ARGUMENT_CLOSING_BRACE,Mt(n,this.clonePosition()));switch(this.char()){case 125:return this.bump(),{val:{type:lr.argument,value:a,location:Mt(n,this.clonePosition())},err:null};case 44:return this.bump(),this.bumpSpace(),this.isEOF()?this.error(kt.EXPECT_ARGUMENT_CLOSING_BRACE,Mt(n,this.clonePosition())):this.parseArgumentOptions(
t,r,a,n);default:return this.error(kt.MALFORMED_ARGUMENT,Mt(n,this.clonePosition()))}},e.prototype.parseIdentifierIfPossible=function(){var t=this.clonePosition(),r=this.offset(),n=N0(this.message,r),a=r+n.length;this.bumpTo(a);var o=this.clonePosition(),s=Mt(t,o);return{value:n,location:s}},e.prototype.parseArgumentOptions=function(t,r,n,a){var o,s=this.clonePosition(),c=this.parseIdentifierIfPossible().value,u=this.clonePosition();switch(c){case"":return this.error(kt.EXPECT_ARGUMENT_TYPE,Mt(s,u));case"number":case"date":case"time":{this.bumpSpace();var l=null;if(this.bumpIf(",")){this.bumpSpace();var m=this.clonePosition(),p=this.parseSimpleArgStyleIfPossible();if(p.err)return p;var f=cre(p.val);if(f.length===0)return this.error(kt.EXPECT_ARGUMENT_STYLE,Mt(this.clonePosition(),this.clonePosition()));var h=Mt(m,this.clonePosition());l={style:f,styleLocation:h}}var y=this.tryParseArgumentClose(a);if(y.err)return y;var v=Mt(a,this.clonePosition());if(l&&GL(l?.style,"::",0)){var E=sre(l.
style.slice(2));if(c==="number"){var p=this.parseNumberSkeletonFromString(E,l.styleLocation);return p.err?p:{val:{type:lr.number,value:n,location:v,style:p.val},err:null}}else{if(E.length===0)return this.error(kt.EXPECT_DATE_TIME_SKELETON,v);var T=E;this.locale&&(T=qL(E,this.locale));var f={type:uc.dateTime,pattern:T,location:l.styleLocation,parsedOptions:this.shouldParseSkeletons?SL(T):{}},x=c==="date"?lr.date:lr.time;return{val:{type:x,value:n,location:v,style:f},err:null}}}return{val:{type:c==="number"?lr.number:c==="date"?lr.date:lr.time,value:n,location:v,style:(o=l?.style)!==null&&o!==void 0?o:null},err:null}}case"plural":case"selectordinal":case"select":{var S=this.clonePosition();if(this.bumpSpace(),!this.bumpIf(","))return this.error(kt.EXPECT_SELECT_ARGUMENT_OPTIONS,Mt(S,Fu({},S)));this.bumpSpace();var I=this.parseIdentifierIfPossible(),F=0;if(c!=="select"&&I.value==="offset"){if(!this.bumpIf(":"))return this.error(kt.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,Mt(this.clonePosition(),
this.clonePosition()));this.bumpSpace();var p=this.tryParseDecimalInteger(kt.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,kt.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE);if(p.err)return p;this.bumpSpace(),I=this.parseIdentifierIfPossible(),F=p.val}var W=this.tryParsePluralOrSelectOptions(t,c,r,I);if(W.err)return W;var y=this.tryParseArgumentClose(a);if(y.err)return y;var H=Mt(a,this.clonePosition());return c==="select"?{val:{type:lr.select,value:n,options:WL(W.val),location:H},err:null}:{val:{type:lr.plural,value:n,options:WL(W.val),offset:F,pluralType:c==="plural"?"cardinal":"ordinal",location:H},err:null}}default:return this.error(kt.INVALID_ARGUMENT_TYPE,Mt(s,u))}},e.prototype.tryParseArgumentClose=function(t){return this.isEOF()||this.char()!==125?this.error(kt.EXPECT_ARGUMENT_CLOSING_BRACE,Mt(t,this.clonePosition())):(this.bump(),{val:!0,err:null})},e.prototype.parseSimpleArgStyleIfPossible=function(){for(var t=0,r=this.clonePosition();!this.isEOF();){var n=this.char();switch(n){case 39:{this.bump();
var a=this.clonePosition();if(!this.bumpUntil("'"))return this.error(kt.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE,Mt(a,this.clonePosition()));this.bump();break}case 123:{t+=1,this.bump();break}case 125:{if(t>0)t-=1;else return{val:this.message.slice(r.offset,this.offset()),err:null};break}default:this.bump();break}}return{val:this.message.slice(r.offset,this.offset()),err:null}},e.prototype.parseNumberSkeletonFromString=function(t,r){var n=[];try{n=ML(t)}catch{return this.error(kt.INVALID_NUMBER_SKELETON,r)}return{val:{type:uc.number,tokens:n,location:r,parsedOptions:this.shouldParseSkeletons?PL(n):{}},err:null}},e.prototype.tryParsePluralOrSelectOptions=function(t,r,n,a){for(var o,s=!1,c=[],u=new Set,l=a.value,m=a.location;;){if(l.length===0){var p=this.clonePosition();if(r!=="select"&&this.bumpIf("=")){var f=this.tryParseDecimalInteger(kt.EXPECT_PLURAL_ARGUMENT_SELECTOR,kt.INVALID_PLURAL_ARGUMENT_SELECTOR);if(f.err)return f;m=Mt(p,this.clonePosition()),l=this.message.slice(p.offset,this.offset())}else
break}if(u.has(l))return this.error(r==="select"?kt.DUPLICATE_SELECT_ARGUMENT_SELECTOR:kt.DUPLICATE_PLURAL_ARGUMENT_SELECTOR,m);l==="other"&&(s=!0),this.bumpSpace();var h=this.clonePosition();if(!this.bumpIf("{"))return this.error(r==="select"?kt.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT:kt.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT,Mt(this.clonePosition(),this.clonePosition()));var y=this.parseMessage(t+1,r,n);if(y.err)return y;var v=this.tryParseArgumentClose(h);if(v.err)return v;c.push([l,{value:y.val,location:Mt(h,this.clonePosition())}]),u.add(l),this.bumpSpace(),o=this.parseIdentifierIfPossible(),l=o.value,m=o.location}return c.length===0?this.error(r==="select"?kt.EXPECT_SELECT_ARGUMENT_SELECTOR:kt.EXPECT_PLURAL_ARGUMENT_SELECTOR,Mt(this.clonePosition(),this.clonePosition())):this.requiresOtherClause&&!s?this.error(kt.MISSING_OTHER_CLAUSE,Mt(this.clonePosition(),this.clonePosition())):{val:c,err:null}},e.prototype.tryParseDecimalInteger=function(t,r){var n=1,a=this.clonePosition();
this.bumpIf("+")||this.bumpIf("-")&&(n=-1);for(var o=!1,s=0;!this.isEOF();){var c=this.char();if(c>=48&&c<=57)o=!0,s=s*10+(c-48),this.bump();else break}var u=Mt(a,this.clonePosition());return o?(s*=n,ire(s)?{val:s,err:null}:this.error(r,u)):this.error(t,u)},e.prototype.offset=function(){return this.position.offset},e.prototype.isEOF=function(){return this.offset()===this.message.length},e.prototype.clonePosition=function(){return{offset:this.position.offset,line:this.position.line,column:this.position.column}},e.prototype.char=function(){var t=this.position.offset;if(t>=this.message.length)throw Error("out of bound");var r=VL(this.message,t);if(r===void 0)throw Error("Offset ".concat(t," is at invalid UTF-16 code unit boundary"));return r},e.prototype.error=function(t,r){return{val:null,err:{kind:t,message:this.message,location:r}}},e.prototype.bump=function(){if(!this.isEOF()){var t=this.char();t===10?(this.position.line+=1,this.position.column=1,this.position.offset+=1):(this.position.
column+=1,this.position.offset+=t<65536?1:2)}},e.prototype.bumpIf=function(t){if(GL(this.message,t,this.offset())){for(var r=0;r<t.length;r++)this.bump();return!0}return!1},e.prototype.bumpUntil=function(t){var r=this.offset(),n=this.message.indexOf(t,r);return n>=0?(this.bumpTo(n),!0):(this.bumpTo(this.message.length),!1)},e.prototype.bumpTo=function(t){if(this.offset()>t)throw Error("targetOffset ".concat(t," must be greater than or equal to the current offset ").concat(this.offset()));for(t=Math.min(t,this.message.length);;){var r=this.offset();if(r===t)break;if(r>t)throw Error("targetOffset ".concat(t," is at invalid UTF-16 code unit boundary"));if(this.bump(),this.isEOF())break}},e.prototype.bumpSpace=function(){for(;!this.isEOF()&&KL(this.char());)this.bump()},e.prototype.peek=function(){if(this.isEOF())return null;var t=this.char(),r=this.offset(),n=this.message.charCodeAt(r+(t>=65536?2:1));return n??null},e})();i(L0,"_isAlpha");i(ure,"_isAlphaOrSlash");i(lre,"_isPotentialElemen\
tNameChar");i(KL,"_isWhiteSpace");i(dre,"_isPatternSyntax")});function P0(e){e.forEach(function(t){if(delete t.location,Hg(t)||Gg(t))for(var r in t.options)delete t.options[r].location,P0(t.options[r].value);else jg(t)&&Vg(t.style)||(qg(t)||zg(t))&&Xd(t.style)?delete t.style.location:Wg(t)&&P0(t.children)})}function XL(e,t){t===void 0&&(t={}),t=Fu({shouldParseSkeletons:!0,requiresOtherClause:!0},t);var r=new YL(e,t).parse();if(r.err){var n=SyntaxError(kt[r.err.kind]);throw n.location=r.err.location,n.originalMessage=r.err.message,n}return t?.captureLocation||P0(r.val),r.val}var B0=g(()=>{d();I0();k0();JL();$g();$g();i(P0,"pruneLocation");i(XL,"parse")});function Yg(e,t){var r=t&&t.cache?t.cache:yre,n=t&&t.serializer?t.serializer:gre,a=t&&t.strategy?t.strategy:pre;return a(e,{cache:r,serializer:n})}function mre(e){return e==null||typeof e=="number"||typeof e=="boolean"}function ZL(e,t,r,n){var a=mre(n)?n:r(n),o=t.get(a);return typeof o>"u"&&(o=e.call(this,n),t.set(a,o)),o}function QL(e,t,r){var n=Array.prototype.slice.call(arguments,3),a=r(n),o=t.get(a);return typeof o>"u"&&(o=e.apply(this,n),t.set(a,o)),o}function U0(e,t,r,n,a){return r.bind(t,e,n,a)}function pre(e,t){var r=e.length===1?ZL:QL;return U0(e,this,r,t.cache.create(),t.serializer)}function fre(e,t){return U0(e,this,QL,t.cache.create(),t.serializer)}function hre(e,t){return U0(e,this,ZL,t.cache.create(),t.serializer)}function j0(){this.cache=Object.create(null)}var gre,yre,Kg,eP=g(()=>{d();i(Yg,"memoize");i(mre,"isPrimitive");i(ZL,"monadic");i(QL,"variadic");i(U0,"assemble");i(pre,"strategyDefault");i(fre,"strategyVariadic");i(hre,"strategyMonadic");gre=i(function(){return JSON.
stringify(arguments)},"serializerDefault");i(j0,"ObjectWithoutPrototypeCache");j0.prototype.get=function(e){return this.cache[e]};j0.prototype.set=function(e,t){this.cache[e]=t};yre={create:i(function(){return new j0},"create")},Kg={variadic:fre,monadic:hre}});var lc,Qd,q0,tP,rP,z0=g(()=>{d();C0();(function(e){e.MISSING_VALUE="MISSING_VALUE",e.INVALID_VALUE="INVALID_VALUE",e.MISSING_INTL_API="MISSING_INTL_API"})(lc||(lc={}));Qd=(function(e){Jd(t,e);function t(r,n,a){var o=e.call(this,r)||this;return o.code=n,o.originalMessage=a,o}return i(t,"FormatError"),t.prototype.toString=function(){return"[formatjs Error: ".concat(this.code,"] ").concat(this.message)},t})(Error),q0=(function(e){Jd(t,e);function t(r,n,a,o){return e.call(this,'Invalid values for "'.concat(r,'": "').concat(n,'". Options are "').concat(Object.keys(a).join('", "'),'"'),lc.INVALID_VALUE,o)||this}return i(t,"InvalidValueError"),t})(Qd),tP=(function(e){Jd(t,e);function t(r,n,a){return e.call(this,'Value for "'.concat(r,'" must be of type ').concat(n),lc.INVALID_VALUE,a)||this}return i(t,"InvalidValueTypeError"),t})(Qd),rP=(function(e){Jd(t,e);function t(r,n){return e.call(this,'The intl string context variable "'.concat(r,'" was not provided to the string "').concat(n,'"'),lc.MISSING_VALUE,
n)||this}return i(t,"MissingValueError"),t})(Qd)});function vre(e){return e.length<2?e:e.reduce(function(t,r){var n=t[t.length-1];return!n||n.type!==vn.literal||r.type!==vn.literal?t.push(r):n.value+=r.value,t},[])}function bre(e){return typeof e=="function"}function em(e,t,r,n,a,o,s){if(e.length===1&&R0(e[0]))return[{type:vn.literal,value:e[0].value}];for(var c=[],u=0,l=e;u<l.length;u++){var m=l[u];if(R0(m)){c.push({type:vn.literal,value:m.value});continue}if(TL(m)){typeof o=="number"&&c.push({type:vn.literal,value:r.getNumberFormat(t).format(o)});continue}var p=m.value;if(!(a&&p in a))throw new rP(p,s);var f=a[p];if(DL(m)){(!f||typeof f=="string"||typeof f=="number")&&(f=typeof f=="string"||typeof f=="number"?String(f):""),c.push({type:typeof f=="string"?vn.literal:vn.object,value:f});continue}if(qg(m)){var h=typeof m.style=="string"?n.date[m.style]:Xd(m.style)?m.style.parsedOptions:void 0;c.push({type:vn.literal,value:r.getDateTimeFormat(t,h).format(f)});continue}if(zg(m)){var h=typeof m.style=="string"?n.time[m.style]:Xd(m.style)?m.
style.parsedOptions:n.time.medium;c.push({type:vn.literal,value:r.getDateTimeFormat(t,h).format(f)});continue}if(jg(m)){var h=typeof m.style=="string"?n.number[m.style]:Vg(m.style)?m.style.parsedOptions:void 0;h&&h.scale&&(f=f*(h.scale||1)),c.push({type:vn.literal,value:r.getNumberFormat(t,h).format(f)});continue}if(Wg(m)){var y=m.children,v=m.value,E=a[v];if(!bre(E))throw new tP(v,"function",s);var T=em(y,t,r,n,a,o),x=E(T.map(function(F){return F.value}));Array.isArray(x)||(x=[x]),c.push.apply(c,x.map(function(F){return{type:typeof F=="string"?vn.literal:vn.object,value:F}}))}if(Hg(m)){var S=m.options[f]||m.options.other;if(!S)throw new q0(m.value,f,Object.keys(m.options),s);c.push.apply(c,em(S.value,t,r,n,a));continue}if(Gg(m)){var S=m.options["=".concat(f)];if(!S){if(!Intl.PluralRules)throw new Qd(`Intl.PluralRules is not available in this environment.
Try polyfilling it using "@formatjs/intl-pluralrules"
`,lc.MISSING_INTL_API,s);var I=r.getPluralRules(t,{type:m.pluralType}).select(f-(m.offset||0));S=m.options[I]||m.options.other}if(!S)throw new q0(m.value,f,Object.keys(m.options),s);c.push.apply(c,em(S.value,t,r,n,a,f-(m.offset||0)));continue}}return vre(c)}var vn,H0=g(()=>{d();B0();z0();(function(e){e[e.literal=0]="literal",e[e.object=1]="object"})(vn||(vn={}));i(vre,"mergeLiteral");i(bre,"isFormatXMLElementFn");i(em,"formatToParts")});function wre(e,t){return t?qa(qa(qa({},e||{}),t||{}),Object.keys(e).reduce(function(r,n){return r[n]=qa(qa({},e[n]),t[n]||{}),r},{})):e}function Ere(e,t){return t?Object.keys(e).reduce(function(r,n){return r[n]=wre(e[n],t[n]),r},qa({},e)):e}function G0(e){return{create:i(function(){return{get:i(function(t){return e[t]},"get"),set:i(function(t,r){e[t]=r},"set")}},"create")}}function Dre(e){return e===void 0&&(e={number:{},dateTime:{},pluralRules:{}}),{getNumberFormat:Yg(function(){for(var t,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];return new((t=Intl.NumberFormat).bind.apply(t,Ug([void 0],r,!1)))},{cache:G0(e.number),strategy:Kg.variadic}),getDateTimeFormat:Yg(function(){for(var t,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];return new((t=Intl.DateTimeFormat).bind.apply(t,Ug([void 0],r,!1)))},{cache:G0(e.dateTime),strategy:Kg.variadic}),getPluralRules:Yg(function(){for(var t,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];return new((t=Intl.PluralRules).bind.apply(t,Ug([void 0],
r,!1)))},{cache:G0(e.pluralRules),strategy:Kg.variadic})}}var nP,W0=g(()=>{d();C0();B0();eP();H0();i(wre,"mergeConfig");i(Ere,"mergeConfigs");i(G0,"createFastMemoizeCache");i(Dre,"createDefaultFormatters");nP=(function(){function e(t,r,n,a){r===void 0&&(r=e.defaultLocale);var o=this;if(this.formatterCache={number:{},dateTime:{},pluralRules:{}},this.format=function(l){var m=o.formatToParts(l);if(m.length===1)return m[0].value;var p=m.reduce(function(f,h){return!f.length||h.type!==vn.literal||typeof f[f.length-1]!="string"?f.push(h.value):f[f.length-1]+=h.value,f},[]);return p.length<=1?p[0]||"":p},this.formatToParts=function(l){return em(o.ast,o.locales,o.formatters,o.formats,l,void 0,o.message)},this.resolvedOptions=function(){var l;return{locale:((l=o.resolvedLocale)===null||l===void 0?void 0:l.toString())||Intl.NumberFormat.supportedLocalesOf(o.locales)[0]}},this.getAst=function(){return o.ast},this.locales=r,this.resolvedLocale=e.resolveLocale(r),typeof t=="string"){if(this.message=
t,!e.__parse)throw new TypeError("IntlMessageFormat.__parse must be set to process `message` of type `string`");var s=a||{},c=s.formatters,u=EL(s,["formatters"]);this.ast=e.__parse(t,qa(qa({},u),{locale:this.resolvedLocale}))}else this.ast=t;if(!Array.isArray(this.ast))throw new TypeError("A message must be provided as a String or AST.");this.formats=Ere(e.formats,n),this.formatters=a&&a.formatters||Dre(this.formatterCache)}return i(e,"IntlMessageFormat"),Object.defineProperty(e,"defaultLocale",{get:i(function(){return e.memoizedDefaultLocale||(e.memoizedDefaultLocale=new Intl.NumberFormat().resolvedOptions().locale),e.memoizedDefaultLocale},"get"),enumerable:!1,configurable:!0}),e.memoizedDefaultLocale=null,e.resolveLocale=function(t){if(!(typeof Intl.Locale>"u")){var r=Intl.NumberFormat.supportedLocalesOf(t);return r.length>0?new Intl.Locale(r[0]):new Intl.Locale(typeof t=="string"?t:t[0])}},e.__parse=XL,e.formats={number:{integer:{maximumFractionDigits:0},currency:{style:"currency"},
percent:{style:"percent"}},date:{short:{month:"numeric",day:"numeric",year:"2-digit"},medium:{month:"short",day:"numeric",year:"numeric"},long:{month:"long",day:"numeric",year:"numeric"},full:{weekday:"long",month:"long",day:"numeric",year:"numeric"}},time:{short:{hour:"numeric",minute:"numeric"},medium:{hour:"numeric",minute:"numeric",second:"numeric"},long:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"},full:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"}}},e})()});var V0,aP=g(()=>{d();W0();H0();W0();z0();V0=nP});var dc,Mu=g(()=>{d();dc=i(()=>({resolve(){throw new Error("createRequire.resolve is not supported in bundled Lighthouse")}}),"createRequire")});var Tre,xre,mc,tm=g(()=>{d();Tre=globalThis.URL,xre=i(e=>e,"fileURLToPath"),mc={URL:Tre,fileURLToPath:xre}});function oP(e){return mc.fileURLToPath(e.url)}var pc=g(()=>{"use strict";d();Mu();tm();Vi();i(oP,"getModulePath")});function $0(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function iP(e){return typeof e=="object"&&e!==null}var sP=g(()=>{"use strict";d();i($0,"isObjectOfUnknownValues");i(iP,"isObjectOrArrayOfUnknownValues")});var cP,uP=g(()=>{d();cP={}});function dP(e,t=new Map){for(let r of e)if(!(r.type===Jg.literal||r.type===Jg.pound)&&(t.set(r.value,r),r.type===Jg.plural))for(let n of Object.values(r.options))dP(n.value,t);return t}function Ire(e,t={},r){let n=dP(e.getAst()),a={};for(let[o,s]of n){if(!(o in t))throw new Error(`ICU Message "${r}" contains a value reference ("${o}") that wasn't provided`);let c=t[o];if(s.type!==Jg.number){a[o]=c;continue}if(typeof c!="number")throw new Error(`ICU Message "${r}" contains a numeric reference ("${o}") but provided value was not a number`);s.style==="milliseconds"?a[o]=Math.round(c/10)*10:s.style==="seconds"&&o==="timeInMs"?a[o]=Math.round(c/100)/10:s.style==="bytes"?a[o]=c/1024:a[o]=c}for(let o of Object.keys(t))if(!(o in a)){if(o==="errorCode"){a.errorCode=t.errorCode;continue}throw new Error(`Provided value "${o}" does not match any placeholder in ICU message "${r}"`)}return a}function kre(e){return e.replace(/'/g,"''").replace(/\\{/g,"'{").replace(/\\}/g,"'}")}function K0(e,t,r){e=kre(
e);let n=r==="en-XA"||r==="en-XL"?"de-DE":r,a=V0.IntlMessageFormat||V0,o=new a(e,n,Cre,{ignoreTag:!0}),s=Ire(o,t,e),c=o.format(s);if(typeof c!="string")throw new Error("unexpected formatted result");return c}function Rre(e,t){let n=pP(t)[e.i18nId];return n?K0(n.message,e.values,t):e.formattedDefault}function mP(e){let t=pP(e),r=Object.keys(t).filter(a=>a.startsWith("report/renderer/report-utils.js")),n={};for(let a of r){let{filename:o,key:s}=Are(a);if(!o.endsWith("report-utils.js"))throw new Error(`Unexpected message: ${a}`);n[s]=t[a].message}return n}function Nu(e){if(!$0(e))return!1;let{i18nId:t,values:r,formattedDefault:n}=e;if(typeof t!="string"||typeof n!="string")return!1;if(r!==void 0){if(!$0(r))return!1;for(let a of Object.values(r))if(typeof a!="string"&&typeof a!="number")return!1}return lP.test(t)}function fc(e,t){if(Nu(e))return Rre(e,t);if(typeof e=="string")return e;throw new Error("Attempted to format invalid icuMessage type")}function _re(e){let t="";for(let r of e)if(/^[a-z]+$/i.
test(r))t.length&&(t+="."),t+=r;else{if(/]|"|'|\s/.test(r))throw new Error(`Cannot handle "${r}" in i18n`);t+=`[${r}]`}return t}function J0(e,t){function r(a,o,s=[]){if(iP(a))for(let[c,u]of Object.entries(a)){let l=s.concat([c]);if(Nu(u)){let m=fc(u,t),p=o[u.i18nId]||[],f=_re(l);p.push(u.values?{values:u.values,path:f}:f),a[c]=m,o[u.i18nId]=p}else r(u,o,l)}}i(r,"replaceInObject");let n={};return r(e,n),n}function pP(e){let t=Y0[e];if(!t){if(e===Ou)return{};throw new Error(`Unsupported locale '${e}'`)}return t}function fP(){return Sre}function hP(){return[...new Set([...Object.keys(Y0),Ou])].sort()}function gP(e,t){Y0[e]=t}function Are(e){if(!lP.test(e))throw Error(`"${e}" does not appear to be a valid ICU message id`);let[t,r]=e.split(" | ");return{filename:t,key:r}}var Jg,Y0,Ou,Sre,lP,Cre,Xo=g(()=>{"use strict";d();Go();aP();pc();sP();uP();Jg={literal:0,argument:1,number:2,date:3,time:4,select:5,plural:6,pound:7,tag:8},Y0=cP,Ou="en-US",Sre=["ar-XB.json","ar.json","bg.json","ca.json","\
cs.json","da.json","de.json","el.json","en-GB.json","en-US.ctc.json","en-US.json","en-XA.json","en-XL.ctc.json","en-XL.json","es-419.json","es.json","fi.json","fil.json","fr.json","he.json","hi.json","hr.json","hu.json","id.json","it.json","ja.json","ko.json","lt.json","lv.json","nl.json","no.json","pl.json","pt-PT.json","pt.json","ro.json","ru.json","sk.json","sl.json","sr-Latn.json","sr.json","sv.json","ta.json","te.json","th.json","tr.json","uk.json","vi.json","zh-HK.json","zh-TW.json","zh.json"].filter(e=>e.endsWith(".json")&&!e.endsWith(".ctc.json")).map(e=>e.replace(".json","")).sort(),lP=/ | [^\s]+$/,Cre={number:{bytes:{maximumFractionDigits:0},milliseconds:{maximumFractionDigits:0},seconds:{minimumFractionDigits:1,maximumFractionDigits:1},extendedPercent:{maximumFractionDigits:2,style:"percent"}}};i(dP,"collectAllCustomElementsFromICU");i(Ire,"_preformatValues");i(kre,"escapeIcuMessage");i(K0,"formatMessage");i(Rre,"_localizeIcuMessage");i(mP,"getRendererFormattedStrings");i(Nu,
"isIcuMessage");i(fc,"getFormatted");i(_re,"_formatPathAsString");i(J0,"replaceIcuMessages");i(pP,"_getLocaleMessages");i(fP,"getCanonicalLocales");i(hP,"getAvailableLocales");i(gP,"registerLocaleData");i(Are,"getIcuMessageIdParts")});var vP=je((aOe,yP)=>{d();var Fre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><path fill="%230379c4" fill-rule="evenodd" d="m171.887 116.28-53.696 89.36h-9.728l9.617-58.227-30.2.047a4.852 4.852 0 0 1-4.855-4.855c0-1.152 1.07-3.102 1.07-3.102l53.52-89.254 9.9.043-9.86 58.317 30.413-.043a4.852 4.852 0 0 1 4.855 4.855c0 1.088-.427 2.044-1.033 2.854l.004.004zM128 0C57.306 0 0 57.3 0 128s57.306 128 128 128 128-57.306 128-128S198.7 0 128 0z"/></svg>',Mre={"modern-image-formats":"Consider displaying all [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) components in WebP formats while specifying an appropriate fallback for other browsers. [Learn more](https://amp.dev/documentation/components/amp-img/#example:-specifying-a-fallback-image).","offscreen-images":"Ensure that you are using [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) for images to automatically lazy-load. [Learn more](https://amp.de\
v/documentation/guides-and-tutorials/develop/media_iframes_3p/?format=websites#images).","render-blocking-resources":"Use tools such as [AMP Optimizer](https://github.com/ampproject/amp-toolbox/tree/master/packages/optimizer) to [server-side render AMP layouts](https://amp.dev/documentation/guides-and-tutorials/optimize-and-measure/server-side-rendering/).","unminified-css":"Refer to the [AMP documentation](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/style_pages/) to ensure all styles are supported.","efficient-animated-content":"For animated content, use [`amp-anim`](https://amp.dev/documentation/components/amp-anim/) to minimize CPU usage when the content is offscreen.","uses-responsive-images":"The [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) component supports the [`srcset`](https://web.dev/use-srcset-to-automatically-choose-the-right-image/) attribute to specify which image assets to use based on the screen size. [L\
earn more](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/art_direction/)."};yP.exports={id:"amp",title:"AMP",icon:Fre,UIStrings:Mre}});var wP=je((iOe,bP)=>{d();var Ore='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 250 250"><path fill="%23dd0031" d="M125 30 31.9 63.2l14.2 123.1L125 230l78.9-43.7 14.2-123.1z"/><path fill="%23c3002f" d="M125 30v22.2-.1V230l78.9-43.7 14.2-123.1L125 30z"/><path fill="%23fff" d="M125 52.1 66.8 182.6h21.7l11.7-29.2h49.4l11.7 29.2H183L125 52.1zm17 83.3h-34l17-40.9 17 40.9z"/></svg>',Nre={"total-byte-weight":"Apply [route-level code splitting](https://web.dev/route-level-code-splitting-in-angular/) to minimize the size of your JavaScript bundles. Also, consider precaching assets with the [Angular service worker](https://web.dev/precaching-with-the-angular-service-worker/).","unminified-warning":"If you are using Angular CLI, ensure that builds are generated in production mode. [Learn more](https://angular.io/guide/deployment#enable-runtime-production-mode).","unused-javascript":"If you are using Angular CLI, include source maps in your production build to inspect you\
r bundles. [Learn more](https://angular.io/guide/deployment#inspect-the-bundles).","uses-responsive-images":"Consider using the `BreakpointObserver` utility in the Component Dev Kit (CDK) to manage image breakpoints. [Learn more](https://material.angular.io/cdk/layout/overview).","uses-rel-preload":"Preload routes ahead of time to speed up navigation. [Learn more](https://web.dev/route-preloading-in-angular/).","dom-size":"Consider virtual scrolling with the Component Dev Kit (CDK) if very large lists are being rendered. [Learn more](https://web.dev/virtualize-lists-with-angular-cdk/)."};bP.exports={id:"angular",title:"Angular",icon:Ore,UIStrings:Nre}});var DP=je((cOe,EP)=>{d();var Lre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 186.525 243.713"><path fill="%23009cde" d="M131.64 51.91C114.491 34.769 98.13 18.429 93.26 0c-4.87 18.429-21.234 34.769-38.38 51.91C29.16 77.613 0 106.743 0 150.434a93.263 93.263 0 1 0 186.525 0c0-43.688-29.158-72.821-54.885-98.524m-92 120.256c-5.719-.194-26.824-36.571 12.329-75.303l25.909 28.3a2.215 2.215 0 0 1-.173 3.306c-6.183 6.34-32.534 32.765-35.81 41.902-.675 1.886-1.663 1.815-2.256 1.795m53.624 47.943a32.075 32.075 0 0 1-32.076-32.075 33.423 33.423 0 0 1 7.995-21.187c5.784-7.072 24.077-26.963 24.077-26.963s18.012 20.183 24.033 26.896a31.368 31.368 0 0 1 8.046 21.254 32.076 32.076 0 0 1-32.075 32.075m61.392-52.015c-.691 1.512-2.26 4.036-4.376 4.113-3.773.138-4.176-1.796-6.965-5.923-6.122-9.06-59.551-64.9-69.545-75.699-8.79-9.498-1.238-16.195 2.266-19.704 4.395-4.403 17.224-17.225 17.224-17.225s38.255 36.296 54.19 61.096 10.444 46.26 7.206 53.342"/></svg>',Pre={"unused-css-ru\
les":"Consider removing unused CSS rules and only attach the needed `Drupal` libraries to the relevant page or component in a page. See the [`Drupal` documentation](https://www.drupal.org/docs/develop/theming-drupal/adding-assets-css-js-to-a-drupal-theme-via-librariesyml#define) for details. To identify attached libraries that are adding extraneous CSS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the stylesheet when CSS aggregation is disabled in your `Drupal` site. Look out for themes/modules that have many stylesheets in the list which have a lot of red in code coverage. A theme/module should only attach a stylesheet library if it is actually used on the page.","modern-image-formats":"Consider configuring [WebP image formats with a Convert image style](https://www.drupal.org/docs/core-modules-and-themes/core-modules/image-module/working-with-images#styles) on your si\
te.","offscreen-images":"Consider configuring lazy load images in `Drupal`. The field formatters for images support `lazy` or `eager`.","total-byte-weight":"Consider using [Responsive Image Styles](https://www.drupal.org/documentation/modules/responsive_image) to reduce the size of images loaded on your page. If you are using `Views` to show multiple content items on a page, consider implementing pagination to limit the number of content items shown on a given page.","render-blocking-resources":"Consider using [a module](https://www.drupal.org/project/critical_css) to inline critical CSS and JavaScript, and use the defer attribute for non-critical CSS or JavaScript.","unminified-css":'Ensure you have enabled "Aggregate CSS files" in the "Administration » Configuration » Development" page.',"unminified-javascript":'Ensure you have enabled "Aggregate JavaScript files" in the "Administration » Configuration » Development" page.',"efficient-animated-content":"Consider uploading your `G\
IF` to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider removing unused JavaScript assets and only attach the needed `Drupal` libraries to the relevant page or component in a page. See the [Drupal documentation](https://www.drupal.org/docs/develop/theming-drupal/adding-assets-css-js-to-a-drupal-theme-via-librariesyml#define) for details. To identify attached libraries that are adding extraneous JavaScript, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the script when JavaScript aggregation is disabled in your `Drupal` site. Look out for themes/modules that have many scripts in the list which have a lot of red in code coverage. A theme/module should only attach a script library if it is actually used on the page.","uses-long-cache-ttl":'Set the "Browser and proxy cache maximum age" in the "Administration » Configuration » D\
evelopment" page. Read about [`Drupal` cache and optimizing for performance](https://www.drupal.org/docs/8/api/cache-api/cache-api).',"uses-optimized-images":"Consider using [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=im_vid_3%3A123&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=image&solrsort=iss_project_release_usage+desc&op=Search) that automatically optimizes and reduces the size of images uploaded through the site while retaining quality. Also, ensure you are using the native [Responsive Image Styles](https://www.drupal.org/documentation/modules/responsive_image) provided from `Drupal` for all images rendered on the site.","uses-text-compression":"Text-based resources should be served with compression (gzip, deflate or brotli) to minimize total network bytes. Consider using a CDN that natively supports this, or configure the web server to perform this operation. [Learn more](https://developers.google.com/web/tools\
/lighthouse/audits/text-compression).","uses-responsive-images":"Ensure that you are using the native [Responsive Image Styles](https://www.drupal.org/documentation/modules/responsive_image) provided from `Drupal`. Use the Responsive Image Styles when rendering image fields through view modes, views, or images uploaded through the WYSIWYG editor.","prioritize-lcp-image":"If the LCP element is dynamically added to the page, you should optimize the image in order to improve LCP. [Learn more](https://www.smashingmagazine.com/2023/08/methods-improving-drupal-largest-contentful-paint-core-web-vital/).","server-response-time":"Offload traffic with one or more `Drupal` caching modules such as `Internal Page Cache`, `Internal Dynamic Page Cache`, and `BigPipe`. Couple these with a CDN to further improve response time. Your hosting servers should make use of PHP OPcache. Consider using memory-caching such as Redis or Memcached to reduce database query times. Lastly use performant themes, module\
s, and faster servers to lower server response time.",redirects:"Redirects introduce additional delays before the page can be loaded. If the [Redirect](https://www.drupal.org/project/redirect) module is installed, review if unnecessary redirects can be removed. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/redirects).","uses-rel-preconnect":"`Preconnect` or `dns-prefetch` resource hints can be added by installing and configuring [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=Preconnect&solrsort=score+desc&op=Search) that provides facilities for user agent resource hints."};EP.exports={id:"drupal",title:"Drupal",icon:Lre,UIStrings:Pre}});var xP=je((lOe,TP)=>{d();var Bre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 82 82"><path fill="%235FA624" fill-rule="evenodd" d="M81.37 48.117C85.301 25.821 70.413 4.56 48.117.63 25.821-3.3 4.56 11.586.63 33.883-3.3 56.178 11.586 77.44 33.883 81.37 56.18 85.301 77.44 70.412 81.37 48.117Zm-8.935-14.17c2.77 12.357-1.942 25.721-12.96 33.436-14.57 10.203-34.656 6.662-44.859-7.909a32.434 32.434 0 0 1-2.869-4.98l28.7-20.097a6.53 6.53 0 1 0-3.744-5.347L9.564 48.054c-2.768-12.359 1.943-25.724 12.96-33.439 14.572-10.203 34.656-6.662 44.86 7.91a32.349 32.349 0 0 1 2.868 4.98L41.554 47.6a6.53 6.53 0 1 0 3.746 5.35l27.136-19.003Z"/></svg>',Ure={"unused-css-rules":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Remove Unused CSS` to help with this issue. It will identify the CSS classes that are actually used on each page of your site, and remove any others to keep the file size small.","modern-image-formats":"Use [Ezoic Leap](https://pubdash.ezoic.com/s\
peed) and enable `Next-Gen Formats` to convert images to WebP.","offscreen-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Lazy Load Images` to defer loading off-screen images until they are needed.","render-blocking-resources":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Critical CSS` and `Script Delay` to defer non-critical JS/CSS.","unminified-css":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify CSS` to automatically minify your CSS to reduce network payload sizes.","unminified-javascript":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify Javascript` to automatically minify your JS to reduce network payload sizes.","uses-long-cache-ttl":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Efficient Static Cache Policy` to set recommended values in the caching header for static assests.","uses-optimized-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Next-Gen Formats` t\
o convert images to WebP.","uses-responsive-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Resize Images` to resize images to a device appropriate size, reducing network payload sizes.","server-response-time":"Use [Ezoic Cloud Caching](https://pubdash.ezoic.com/speed/caching) to cache your content across our world wide network, improving time to first byte.","uses-rel-preconnect":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Pre-Connect Origins` to automatically add `preconnect` resource hints to establish early connections to important third-party origins.","uses-rel-preload":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Preload Fonts` and `Preload Background Images` to add `preload` links to prioritize fetching resources that are currently requested later in page load.","font-display":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Optimize Fonts` to automatically leverage the `font-display` CSS feature to ensur\
e text is user-visible while webfonts are loading."};TP.exports={id:"ezoic",title:"Ezoic",icon:Bre,UIStrings:Ure}});var CP=je((mOe,SP)=>{d();var jre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="%23639"/><path fill="%23fff" d="M6.2 21.8C4.1 19.7 3 16.9 3 14.2L13.9 25c-2.8-.1-5.6-1.1-7.7-3.2zm10.2 2.9L3.3 11.6C4.4 6.7 8.8 3 14 3c3.7 0 6.9 1.8 8.9 4.5l-1.5 1.3C19.7 6.5 17 5 14 5c-3.9 0-7.2 2.5-8.5 6L17 22.5c2.9-1 5.1-3.5 5.8-6.5H18v-2h7c0 5.2-3.7 9.6-8.6 10.7z"/></svg>',qre={"unused-css-rules":"Use the `PurgeCSS` `Gatsby` plugin to remove unused rules from stylesheets. [Learn more](https://purgecss.com/plugins/gatsby.html).","modern-image-formats":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically optimize image format. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","offscreen-images":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-p\
lugin-image).","render-blocking-resources":"Use the `Gatsby Script API` to defer loading of non-critical third-party scripts. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-script/).","unused-javascript":"Use `Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://www.gatsbyjs.com/plugins/gatsby-plugin-webpack-bundle-analyser-v2/)","uses-long-cache-ttl":"Configure caching for immutable assets. [Learn more](https://www.gatsbyjs.com/docs/how-to/previews-deploys-hosting/caching/).","uses-optimized-images":"Use the `gatsby-plugin-image` component instead of `<img>` to adjust image quality. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","uses-responsive-images":"Use the `gatsby-plugin-image` component to set appropriate `sizes`. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","prioritize-lcp-image":"Use the `gatsby-plugin-image` component\
 and set the `loading` prop to `eager`. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-plugin-image#shared-props)."};SP.exports={id:"gatsby",title:"Gatsby",icon:jre,UIStrings:qre}});var kP=je((fOe,IP)=>{"use strict";d();var zre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid" viewBox="0 0 256 258"><path fill="%23F9AE41" d="M255.7 35.6a33.7 33.7 0 0 0-67-4.8l-.4-.2c-27.6-12.4-50.8 9.6-50.8 9.6l-61.4 61.7 24.3 23.4 49.4-48.6c23-23 35.6-7.4 35.6-7.4 17.4 14.6.6 32 .6 32l24.9 24c20.3-22 21.5-41.1 15.3-56.3a33.7 33.7 0 0 0 29.5-33.4"/><path fill="%23EE4035" d="m226.5 190.5.2-.3c12.4-27.6-9.6-50.8-9.6-50.8L155.4 78l-23.3 24.3 48.5 49.4c23 23 7.5 35.6 7.5 35.6-14.7 17.4-32 .6-32 .6l-24 24.9c21.9 20.3 41 21.5 56.2 15.3a33.7 33.7 0 1 0 38.2-37.6"/><path fill="%234F91CD" d="m156 133-49.5 48.6c-23 23-35.6 7.4-35.6 7.4-17.4-14.6-.6-32-.6-32l-24.9-24c-20.3 22-21.4 41.1-15.3 56.3a33.7 33.7 0 1 0 37.6 38.2l.3.2c27.6 12.4 50.8-9.6 50.8-9.6l61.4-61.7-24.3-23.4"/><path fill="%237AC043" d="M75.7 106.6c-23-23-7.4-35.6-7.4-35.6 14.6-17.4 32-.6 32-.6l24-24.9c-22-20.3-41-21.5-56.3-15.3a33.7 33.7 0 1 0-38.2 37.6l-.2.3C17.2 95.7 39.2 119 39.2 119l\
61.7 61.4 23.4-24.3-48.6-49.4"/></svg>',Hre={"unused-css-rules":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused CSS in your page. To identify extensions that are adding extraneous CSS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using a [plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=webp) or service that will automatically convert your uploaded images to the optimal formats.","offscreen-images":"Install a [lazy-load Joomla plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=lazy%20loading) that prov\
ides the ability to defer any offscreen images, or switch to a template that provides that functionality. Starting with Joomla 4.0, all new images will [automatically](https://github.com/joomla/joomla-cms/pull/30748) get the `loading` attribute from the core.","total-byte-weight":"Consider showing excerpts in your article categories (e.g. via the read more link), reducing the number of articles shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of Joomla plugins that can help you [inline critical assets](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) or [defer less important resources](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance). Beware that optimizations provided by these plugins may break features of your templates or plugins, so you will need to test these thoroughly.","unminified-css":"A number of [Joomla exte\
nsions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your css styles. There are also templates that provide this functionality.","unminified-javascript":"A number of [Joomla extensions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your scripts. There are also templates that provide this functionality.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the \
extension responsible from the URL of the script. Look out for extensions that have many scripts in the list which have a lot of red in code coverage. An extension should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in Joomla](https://docs.joomla.org/Cache).","uses-optimized-images":"Consider using an [image optimization plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression by enabling Gzip Page Compression in Joomla (System > Global configuration > Server).","uses-responsive-images":"Consider using a [responsive images plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=responsive%20images) to use responsive images in your content.","server-response-time":"Templates, extensions, and server specifications all contribute to server response time. Consider findi\
ng a more optimized template, carefully selecting an optimization extension, and/or upgrading your server."};IP.exports={id:"joomla",title:"Joomla",icon:zre,UIStrings:Hre}});var _P=je((gOe,RP)=>{d();var Gre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="%23f26322" viewBox="0 0 1000 1000"><path d="M916.9 267.4v465.3l-111.3 67.4V331.4l-1.5-.9-303.9-189-304.6 189.2-1.2.8V799L83.1 732.6V267.4l.7-.4L500.3 10l416 257 .6.4zM560.7 468.5v383.3L500.3 890l-61-38.2V306.7l-136 84.3v476.6l197 122.5 196.4-122.5V391l-136-84.3v161.8z"/></svg>',Wre={"modern-image-formats":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=webp) for a variety of third-party extensions to leverage newer image formats.","offscreen-images":"Consider modifying your product and catalog templates to make use of the web platform's [lazy loading](https://web.dev/native-lazy-loading) feature.","disable-bundling":"Disable Magento's built-in [JavaScript bundling and minification](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html), and consider using [baler](https://github.com/magento/baler/) instead.",
"unminified-css":`Enable the "Minify CSS Files" option in your store's Developer settings. [Learn more](https://devdocs.magento.com/guides/v2.3/performance-best-practices/configuration.html?itm_source=devdocs&itm_medium=search_page&itm_campaign=federated_search&itm_term=minify%20css%20files).`,"unminified-javascript":"Use [Terser](https://www.npmjs.com/package/terser) to minify all JavaScript assets from static content deployment, and disable the built-in minification feature.","unused-javascript":"Disable Magento's built-in [JavaScript bundling](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html).","uses-optimized-images":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=optimize%20image) for a variety of third party extensions to optimize images.","server-response-time":"Use Magento's [Varnish integration](https://devdocs.magento.com/guides/v2.3/config-guide/varnish/config-varnish.html).","uses-rel-pr\
econnect":"Preconnect or dns-prefetch resource hints can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","uses-rel-preload":"`<link rel=preload>` tags can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","critical-request-chains":"If you are not bundling your JavaScript assets, consider using [baler](https://github.com/magento/baler).","font-display":"Specify `@font-display` when [defining custom fonts](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/css-topics/using-fonts.html)."};RP.exports={id:"magento",title:"Magento",icon:Gre,UIStrings:Wre}});var FP=je((vOe,AP)=>{d();var Vre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 207 124"><path fill="%23000" d="M48.942 32.632h38.96v3.082h-35.39v23.193H85.79v3.082H52.513v25.464h35.794v3.081H48.942V32.632Zm42.45 0h4.139l18.343 25.464 18.749-25.464L158.124.287l-41.896 60.485 21.59 29.762h-4.302l-19.642-27.086L94.15 90.534h-4.22l21.751-29.762-20.29-28.14Zm47.967 3.082v-3.082h44.397v3.082h-20.453v54.82h-3.571v-54.82h-20.373ZM.203 32.632h4.464l61.557 91.671-25.439-33.769L3.936 37.011l-.162 53.523H.203zm183.194 53.891c.738 0 1.276-.563 1.276-1.29 0-.727-.538-1.29-1.276-1.29-.73 0-1.277.563-1.277 1.29 0 .727.547 1.29 1.277 1.29Zm3.509-3.393c0 2.146 1.555 3.549 3.822 3.549 2.414 0 3.874-1.446 3.874-3.956v-8.837h-1.946v8.828c0 1.394-.704 2.138-1.946 2.138-1.112 0-1.867-.692-1.893-1.722h-1.911Zm10.24-.113c.14 2.233 2.007 3.662 4.787 3.662 2.97 0 4.83-1.498 4.83-3.887 0-1.878-1.06-2.917-3.632-3.514l-1.38-.338c-1.634-.38-2.294-.891-2.294-1.783 0-1.125 1.025-1.86 2.563-1\
.86 1.459 0 2.466.718 2.649 1.869h1.893c-.113-2.103-1.971-3.583-4.516-3.583-2.737 0-4.56 1.48-4.56 3.704 0 1.835 1.033 2.926 3.3 3.454l1.616.39c1.659.389 2.388.96 2.388 1.912 0 1.108-1.146 1.913-2.71 1.913-1.676 0-2.84-.753-3.005-1.939h-1.928Z"/></svg>',$re={"unused-css-rules":"Consider setting up `PurgeCSS` in `Next.js` configuration to remove unused rules from stylesheets. [Learn more](https://purgecss.com/guides/next.html).","modern-image-formats":"Use the `next/image` component instead of `<img>` to automatically optimize image format. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","offscreen-images":"Use the `next/image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","render-blocking-resources":"Use the `next/script` component to defer loading of non-critical third-party scripts. [Learn more](https://nextjs.org/docs/basic-features/script).","unused-javascript":"Use\
 `Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://github.com/vercel/next.js/tree/canary/packages/next-bundle-analyzer)","uses-long-cache-ttl":"Configure caching for immutable assets and `Server-side Rendered` (SSR) pages. [Learn more](https://nextjs.org/docs/going-to-production#caching).","uses-optimized-images":"Use the `next/image` component instead of `<img>` to adjust image quality. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","uses-text-compression":"Enable compression on your Next.js server. [Learn more](https://nextjs.org/docs/api-reference/next.config.js/compression).","uses-responsive-images":"Use the `next/image` component to set the appropriate `sizes`. [Learn more](https://nextjs.org/docs/api-reference/next/image#sizes).","user-timings":"Consider using `Next.js Analytics` to measure your app's real-world performance. [Learn more](https://nextjs.org/docs/advanced-features/measuring-performance).","prioritize-lcp-im\
age":'Use the `next/image` component and set "priority" to true to preload LCP image. [Learn more](https://nextjs.org/docs/api-reference/next/image#priority).',"unsized-images":"Use the `next/image` component to make sure images are always sized appropriately. [Learn more](https://nextjs.org/docs/api-reference/next/image#width)."};AP.exports={id:"next.js",title:"Next.js",icon:Vre,UIStrings:$re}});var OP=je((wOe,MP)=>{d();var Yre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="142" height="54"><g fill="none" fill-rule="evenodd"><g fill="%231B004E"><path d="M19.486 53.24h-3.891L4.682 39.247v13.936H0V32.946h5.444l9.475 12.398V32.946h4.567zM21.346 32.94h4.647v3.57h-4.647v-3.57Zm0 5.477h4.647V53.18h-4.647V38.417ZM40.569 53.183H36c-3.408 0-4.991-1.625-4.991-4.697v-6.22h-3.777V38.42h3.777v-5.474h4.598v5.474h4.958v3.846h-4.958v4.588c0 1.597.477 2.252 2.197 2.252h2.764v4.077ZM46.688 53.183h-4.57V38.42h4.57v2.308c.31-.686 1.351-2.336 4.425-2.336h3.13v4.56h-4.004c-2.593 0-3.55.967-3.55 3.019v7.212ZM70.612 45.802c0 4.56-3.409 7.75-8.01 7.75s-8.006-3.19-8.006-7.75c0-4.56 3.408-7.755 8.006-7.755 4.598 0 8.01 3.195 8.01 7.755Zm-4.599 0c0-2.14-1.35-3.733-3.408-3.733-2.057 0-3.44 1.594-3.44 3.733 0 2.139 1.41 3.733 3.44 3.733 2.03 0 3.408-1.598 3.408-3.733ZM72.47 32.946h11.7c4.543 0 7.192 2.28 7.192 6.526 0 4.247-2.649 6.577-7.191 6.577h-6.935v7.125h-4.765V32.946Zm4.766 4.218\
v4.676h6.485c1.832 0 2.736-.883 2.736-2.34 0-1.565-.904-2.336-2.736-2.336h-6.485ZM102.662 51.016c-.254.485-1.636 2.48-4.71 2.48-3.665 0-6.627-2.906-6.627-7.694 0-4.789 2.962-7.667 6.656-7.667 2.962 0 4.372 1.851 4.626 2.336v-2.05h4.567v14.762h-4.512v-2.167Zm-3.327-8.932c-2.03 0-3.384 1.594-3.384 3.733 0 2.14 1.354 3.733 3.384 3.733s3.327-1.597 3.327-3.733-1.298-3.733-3.327-3.733ZM119.184 43.578a2.98 2.98 0 0 0-2.749-1.494c-1.918 0-3.13 1.594-3.13 3.733 0 2.14 1.24 3.758 3.158 3.758 1.807 0 2.625-1.168 2.764-1.51h4.4c-.143 2.052-2.116 5.5-7.275 5.5-4.286 0-7.641-3.078-7.641-7.75 0-4.673 3.328-7.755 7.585-7.755 5.159 0 7.105 3.392 7.33 5.53l-4.442-.012ZM129.712 46.6v6.577h-4.567V32.194h4.567v11.998l5.838-5.784h5.751l-6.994 6.811 7.362 7.952h-5.921z"/></g><g fill="%2325F5CE"><path d="M49.159 4.65c12.832 0 23.235 10.41 23.235 23.251h4.648C77.042 12.491 64.558 0 49.159 0c-15.4 0-27.883 12.492-27.883 27.901h4.647c0-12.841 10.403-23.25 23.236-23.25Z"/><path d="M44.852 25.793a3.632 3.632 0 0 1\
 2.6-5.097L63.8 16.951 50.426 27.09a3.626 3.626 0 0 1-5.574-1.296Z"/></g></g></svg>',Kre={"unused-css-rules":"Enable [`Reduce Unused CSS`](https://support.nitropack.io/hc/en-us/articles/360020418457-Reduce-Unused-CSS) to remove CSS rules that are not applicable to this page.","modern-image-formats":"Use [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/16547237162513) to automatically convert your images to WebP.","offscreen-images":"Defer offscreen images by enabling [`Automatic Image Lazy Loading`](https://support.nitropack.io/hc/en-us/articles/12457493524369-NitroPack-Lazy-Loading-Feature-for-Images).","render-blocking-resources":"Enable [`Remove render-blocking resources`](https://support.nitropack.io/hc/en-us/articles/13820893500049-How-to-Deal-with-Render-Blocking-Resources-in-NitroPack) in NitroPack for faster initial load times.","unminified-css":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in you\
r Caching settings to reduce the size of your CSS, HTML, and JavaScript files for faster load times.","unminified-javascript":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in your Caching settings to reduce the size of your JS, HTML, and CSS files for faster load times.","unused-javascript":"Configure [`Delayed Scripts`](https://support.nitropack.io/hc/en-us/articles/1500002600942-Delayed-Scripts) in NitroPack to delay loading of scripts until they are needed.","uses-long-cache-ttl":"Go to the [`Improve Server Response Time`](https://support.nitropack.io/hc/en-us/articles/1500002321821-Improve-Server-Response-Time) feature in the `Caching` menu and adjust your page cache expiration time to improve loading times and user experience.","uses-optimized-images":"Automatically compress, optimize, and convert your images into WebP by enabling the [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/14177271695121-Ho\
w-to-serve-images-in-next-gen-formats-using-NitroPack) setting.","uses-text-compression":"Use [`Gzip compression`](https://support.nitropack.io/hc/en-us/articles/13229297479313-Enabling-GZIP-compression) in NitroPack to reduce the size of the files that are sent to the browser.","uses-responsive-images":"Enable [`Adaptive Image Sizing`](https://support.nitropack.io/hc/en-us/articles/10123833029905-How-to-Enable-Adaptive-Image-Sizing-For-Your-Site) to preemptively optimize your images and make them match the dimensions of the containers they’re displayed in across all devices.","dom-size":"Contact your account manager to enable [`HTML Lazy Load`](https://support.nitropack.io/hc/en-us/articles/17144942904337). Configuring it will prioritize and optimize your page rendering performance.","font-display":"Use the [`Override Font Rendering Behavior`](https://support.nitropack.io/hc/en-us/articles/16547358865041) option in NitroPack to set a desired value for the CSS font-display rule."};MP.
exports={id:"nitropack",title:"NitroPack",icon:Yre,UIStrings:Kre}});var LP=je((DOe,NP)=>{d();var Jre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 512 512"><path fill="%2300DC82" d="M281.44 397.667h156.88c5.006 0 9.798-1.759 14.133-4.244.336-2.481 8.805-5.596 11.307-9.894 2.502-4.297 4.242-9.173 4.24-14.134-.002-4.962-1.734-9.836-4.24-14.131l-106-182.321c-2.502-4.297-5.559-7.413-9.893-9.894-4.335-2.48-10.542-4.24-15.547-4.24-5.005 0-9.799 1.76-14.133 4.24-4.335 2.481-7.392 5.597-9.894 9.894l-26.853 46.64-53.707-90.457c-2.504-4.296-5.557-8.823-9.893-11.303-4.336-2.481-9.127-2.827-14.133-2.827-5.006 0-9.798.346-14.134 2.827-4.335 2.48-8.802 7.007-11.306 11.303L46.827 355.268c-2.506 4.295-2.8259.169-2.827 14.131-.002 4.961.325 9.836 2.827 14.134 2.502 4.297 6.97 7.413 11.306 9.894 4.336 2.481 9.127 4.24 14.134 4.24H171.2c39.201 0 67.734-17.585 87.627-50.88L306.88 263.4l25.44-43.813 77.733 132.853H306.88l-25.44 45.227ZM169.787 352.44h-69.254l103.174-178.08L256 263.4l-34.639 60.384c-13.21 21.603-28.272 28.656-51.574 28\
.656Z"/></svg>',Xre={"modern-image-formats":'Use the `nuxt/image` component and set `format="webp"`. [Learn more](https://image.nuxt.com/usage/nuxt-img#format).',"offscreen-images":'Use the `nuxt/image` component and set `loading="lazy"` for offscreen images. [Learn more](https://image.nuxt.com/usage/nuxt-img#loading).',"uses-optimized-images":"Use the `nuxt/image` component and set the appropriate `quality`. [Learn more](https://image.nuxt.com/usage/nuxt-img#quality).","uses-responsive-images":"Use the `nuxt/image` component and set the appropriate `sizes`. [Learn more](https://image.nuxt.com/usage/nuxt-img#sizes).","prioritize-lcp-image":"Use the `nuxt/image` component and specify `preload` for LCP image. [Learn more](https://image.nuxt.com/usage/nuxt-img#preload).","unsized-images":"Use the `nuxt/image` component and specify explicit `width` and `height`. [Learn more](https://image.nuxt.com/usage/nuxt-img#width-height)."};NP.exports={id:"nuxt",title:"Nuxt",icon:Jre,UIStrings:Xre}});var BP=je((xOe,PP)=>{d();var Zre='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 310 310"><path fill="none" d="M-1-1h802v602H-1z"/><path fill="%23de6c26" d="M135 6.9c-14.2 4.4-34.9 21.8-49.9 42C55.8 88.5 39.6 135.8 41.4 177c.8 20.2 4.9 35.5 14.4 54.5 13.6 27.4 40.8 55.1 65.5 66.9 14.1 6.7 13.4 6.9 14.1-2.8.3-4.4 1-32.4 1.6-62.1 2.7-137.3 4.4-176 8.2-191.3.6-2.3 1.4-4.2 1.9-4.2 1.2 0 3.6 9.1 4.9 18.3.5 4.3 1 17.7 1 29.8 0 12 .3 21.9.7 21.9.3 0 5.7-5 11.9-11 6.9-6.8 12-11 13.3-11 1.8 0 1.9.3 1 2.7-1.2 3.1-7.9 13.2-19.1 28.5L153 128l.1 31.2c.1 17.2.4 37.4.8 44.9l.6 13.7 11-12.6c14-16 35.1-37.1 39.5-39.6l3.3-1.9-.6 3.2c-2 9.8-9.5 20.7-37.4 54.3L154 240.8v31.1c0 18.3.4 31.1.9 31.1 2.8 0 19.3-6.4 26.8-10.5 13.8-7.3 23.8-15 38.3-29.5 15.7-15.7 24.4-27.4 33.4-45.2 20.5-40 21-80.3 1.6-119-17.8-35.6-54.6-72.1-87.8-86.9-11.7-5.3-24.6-7.3-32.2-5z"/></svg>',Qre={"unused-css-rules":"Consider reviewing the [plugins](https://octobercms.com/plugins) loading unused CSS on the we\
bsite. To identify plugins that add unnecessary CSS, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the stylesheet URL. Look for plugins with many stylesheets with lots of red in code coverage. A plugin should only add a stylesheet if it is actually used on the web page.","modern-image-formats":"Consider using a [plugin](https://octobercms.com/plugins?search=image) or service that will automatically convert the uploaded images to the optimal formats. [WebP lossless images](https://developers.google.com/speed/webp) are 26% smaller in size compared to PNGs and 25-34% smaller than comparable JPEG images at the equivalent SSIM quality index. Another next-gen image format to consider is [AVIF](https://jakearchibald.com/2020/avif-has-landed/).","offscreen-images":"Consider installing an [image lazy loading plugin](https://octobercms.com/plugins?search=lazy) that provides the\
 ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://octobercms.com/plugins?search=Accelerated+Mobile+Pages).","total-byte-weight":"Consider showing excerpts in the post lists (e.g. using a `show more` button), reducing the number of posts shown on a given web page, breaking long posts into multiple web pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are many plugins that help [inline critical assets](https://octobercms.com/plugins?search=css). These plugins may break other plugins, so you should test thoroughly.","unminified-css":"There are many [plugins](https://octobercms.com/plugins?search=css) that can speed up a website by concatenating, minifying and compressing the styles. Using a build process to do this minification up-front can speed up development.","unminified-javascript":"There are many [plugins](https://octobercms.com/plugins?search=javascript) that \
can speed up a website by concatenating, minifying and compressing the scripts. Using a build process to do this minification up-front can speed up development.","efficient-animated-content":"[Replace animated GIFs with video](https://web.dev/replace-gifs-with-videos/) for faster web page loads and consider using modern file formats such as [WebM](https://web.dev/replace-gifs-with-videos/#create-webm-videos) or [AV1](https://developers.google.com/web/updates/2018/09/chrome-70-media-updates#av1-decoder) to improve compression efficiency by greater than 30% over the current state-of-the-art video codec, VP9.","unused-javascript":"Consider reviewing the [plugins](https://octobercms.com/plugins?search=javascript) that load unused JavaScript in the web page. To identify plugins that add unnecessary JavaScript, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the URL of the sc\
ript. Look for plugins with many scripts with lots of red in code coverage. A plugin should only add a script if it is actually used on the web page.","uses-long-cache-ttl":"Read about [preventing unnecessary network requests with the HTTP Cache](https://web.dev/http-cache/#caching-checklist). There are many [plugins](https://octobercms.com/plugins?search=Caching) that can be used to speed up caching.","uses-optimized-images":"Consider using an [image optimization plugin](https://octobercms.com/plugins?search=image) to compresses images while retaining the quality.","uses-text-compression":"Enable text compression in the web server configuration.","uses-responsive-images":"Upload images directly in the media manager to ensure the required image sizes are available. Consider using the [resize filter](https://octobercms.com/docs/markup/filter-resize) or an [image resizing plugin](https://octobercms.com/plugins?search=image) to ensure the optimal image sizes are used.","server-response-ti\
me":"Themes, plugins and server specifications all contribute to the server response time. Consider finding a more optimized theme, carefully selecting an optimization plugin and/or upgrade the server. October CMS also allows developers to use [`Queues`](https://octobercms.com/docs/services/queues) to defer the processing of a time consuming task, such as sending an e-mail. This drastically speeds up web requests."};PP.exports={id:"octobercms",title:"October CMS",icon:Zre,UIStrings:Qre}});var jP=je((COe,UP)=>{d();var ene='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3"><g fill="%2361DAFB"><path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6\
-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 2\
7.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/><circle cx="420.9" cy="296.5" r="45.7"/><path d="M520.5 78.1z"/></g></svg>',tne={"unminified-css":"If your build system minifies CSS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unmin\
ified-javascript":"If your build system minifies JS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unused-javascript":"If you are not server-side rendering, [split your JavaScript bundles](https://web.dev/code-splitting-suspense/) with `React.lazy()`. Otherwise, code-split using a third-party library such as [loadable-components](https://www.smooth-code.com/open-source/loadable-components/docs/getting-started/).","server-response-time":"If you are server-side rendering any React components, consider using `renderToPipeableStream()` or `renderToStaticNodeStream()` to allow the client to receive and hydrate different parts of the markup instead of all at once. [Learn more](https://reactjs.org/docs/react-dom-server.html#renderToPipeableStream).",redirects:"If you are using React Router, min\
imize usage of the `<Redirect>` component for [route navigations](https://reacttraining.com/react-router/web/api/Redirect).","user-timings":"Use the React DevTools Profiler, which makes use of the Profiler API, to measure the rendering performance of your components. [Learn more.](https://reactjs.org/blog/2018/09/10/introducing-the-react-profiler.html)","dom-size":'Consider using a "windowing" library like `react-window` to minimize the number of DOM nodes created if you are rendering many repeated elements on the page. [Learn more](https://web.dev/virtualize-long-lists-react-window/). Also, minimize unnecessary re-renders using [`shouldComponentUpdate`](https://reactjs.org/docs/optimizing-performance.html#shouldcomponentupdate-in-action), [`PureComponent`](https://reactjs.org/docs/react-api.html#reactpurecomponent), or [`React.memo`](https://reactjs.org/docs/react-api.html#reactmemo) and [skip effects](https://reactjs.org/docs/hooks-effect.html#tip-optimizing-performance-by-skipping-e\
ffects) only until certain dependencies have changed if you are using the `Effect` hook to improve runtime performance.'};UP.exports={id:"react",title:"React",icon:ene,UIStrings:tne}});var zP=je((kOe,qP)=>{d();var rne='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 71 28"><path fill-rule="evenodd" d="M0 .032s2.796-.356 4.66 1.31C5.81 2.37 6.145 4.008 6.145 4.008L9.952 18.96l3.165-12.239c.309-1.301.864-2.909 1.743-3.997 1.121-1.385 3.398-1.472 3.641-1.472.242 0 2.519.087 3.639 1.472.88 1.088 1.435 2.696 1.744 3.997l3.165 12.239 3.806-14.953s.336-1.638 1.486-2.666C34.205-.324 37 .032 37 .032l-7.289 27.945s-2.404.176-3.607-.446c-1.58-.816-2.332-1.447-3.289-5.249l-.099-.395c-.349-1.399-.883-3.59-1.424-5.813l-.162-.667-.162-.664c-.779-3.198-1.497-6.143-1.612-6.517-.108-.351-.236-1.187-.855-1.187-.607 0-.746.837-.857 1.187-.13.412-.99 3.955-1.856 7.514l-.162.667c-.512 2.107-1.01 4.151-1.341 5.48l-.1.395c-.956 3.802-1.708 4.433-3.288 5.249-1.204.622-3.608.446-3.608.446zM43.998 5v.995L44 5.994v16.628c-.014 3.413-.373 4.17-1.933 4.956-1.213.61-3.067.379-3.067.379V9.332c0-.935.315-1.548 1.477-2.098.693-.329 1.34-.58 2.012-.953C43.54 5.703 43.998 5 43.9\
98 5zM46 .125s3.877-.673 5.797 1.107c1.228 1.14 2.602 3.19 2.602 3.19l3.38 4.965c.164.258.378.54.72.54.343 0 .558-.282.722-.54l3.38-4.965s1.374-2.05 2.602-3.19C67.123-.548 71 .125 71 .125l-9.186 13.923 9.161 13.881-.032.004c-.38.045-4.036.423-5.855-1.266-1.229-1.138-2.487-2.992-2.487-2.992l-3.38-4.964c-.164-.26-.379-.54-.721-.54-.343 0-.557.28-.721.54l-3.38 4.964s-1.19 1.854-2.418 2.992c-1.92 1.783-5.957 1.262-5.957 1.262l9.161-13.88zM43.96 0H44c0 1.91-.186 3.042-1.387 3.923-.384.28-1.048.71-1.826.992C39.719 5.304 39 6 39 6c0-3.476.53-4.734 1.95-5.48.865-.452 2.272-.514 2.82-.52z"></path></svg>',nne={"modern-image-formats":"Upload images using `Wix Media Manager` to ensure they are automatically served as WebP. Find [more ways to optimize](https://support.wix.com/en/article/site-performance-optimizing-your-media) your site's media.","render-blocking-resources":"When [adding third-party code](https://support.wix.com/en/article/site-performance-using-third-party-code-on-your-site) in the\
 `Custom Code` tab of your site's dashboard, make sure it's deferred or loaded at the end of the code body. Where possible, use Wix’s [integrations](https://support.wix.com/en/article/about-marketing-integrations) to embed marketing tools on your site. ","efficient-animated-content":"Place videos inside `VideoBoxes`, customize them using `Video Masks` or add `Transparent Videos`. [Learn more](https://support.wix.com/en/article/wix-video-about-wix-video).","unused-javascript":"Review any third-party code you've added to your site in the `Custom Code` tab of your site's dashboard and only keep the services that are necessary to your site. [Find out more](https://support.wix.com/en/article/site-performance-removing-unused-javascript).","server-response-time":"Wix utilizes CDNs and caching to serve responses as fast as possible for most visitors. Consider [manually enabling caching](https://support.wix.com/en/article/site-performance-caching-pages-to-optimize-loading-speed) for your site\
, especially if using `Velo`."};qP.exports={id:"wix",title:"Wix",icon:rne,UIStrings:nne}});var GP=je((_Oe,HP)=>{d();var ane='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.5 122.5"><g fill="%232f3439"><path d="M8.7 61.3c0 20.8 12.1 38.7 29.6 47.3l-25-68.7c-3 6.5-4.6 13.7-4.6 21.4zm88-2.7c0-6.5-2.3-11-4.3-14.5-2.7-4.3-5.2-8-5.2-12.3 0-4.8 3.7-9.3 8.9-9.3h.7a52.4 52.4 0 0 0-79.4 9.9h3.3c5.5 0 14-.6 14-.6 2.9-.2 3.2 4 .4 4.3 0 0-2.9.4-6 .5l19.1 57L59.7 59l-8.2-22.5c-2.8-.1-5.5-.5-5.5-.5-2.8-.1-2.5-4.5.3-4.3 0 0 8.7.7 13.9.7 5.5 0 14-.7 14-.7 2.8-.2 3.2 4 .3 4.3 0 0-2.8.4-6 .5l19 56.5 5.2-17.5c2.3-7.3 4-12.5 4-17z"/><path d="m62.2 65.9-15.8 45.8a52.6 52.6 0 0 0 32.3-.9l-.4-.7zM107.4 36a49.6 49.6 0 0 1-3.6 24.2l-16.1 46.5A52.5 52.5 0 0 0 107.4 36z"/><path d="M61.3 0a61.3 61.3 0 1 0 .1 122.7A61.3 61.3 0 0 0 61.3 0zm0 119.7a58.5 58.5 0 1 1 .1-117 58.5 58.5 0 0 1-.1 117z"/></g></svg>',one={"unused-css-rules":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused CSS in your page. To identify plu\
gins that are adding extraneous CSS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using the [Performance Lab](https://wordpress.org/plugins/performance-lab/) plugin to automatically convert your uploaded JPEG images into WebP, wherever supported.","offscreen-images":"Install a [lazy-load WordPress plugin](https://wordpress.org/plugins/search/lazy+load/) that provides the ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://wordpress.org/plugins/amp/).","total-byte-weight":"Consider showing excerpts in your post lists (e.g. via the more tag), reducing the numb\
er of posts shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of WordPress plugins that can help you [inline critical assets](https://wordpress.org/plugins/search/critical+css/) or [defer less important resources](https://wordpress.org/plugins/search/defer+css+javascript/). Beware that optimizations provided by these plugins may break features of your theme or plugins, so you will likely need to make code changes.","unminified-css":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+css/) can speed up your site by concatenating, minifying, and compressing your styles. You may also want to use a build process to do this minification up-front if possible.","unminified-javascript":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+javascript/) can speed up your site by concatenating, minifying, and compressing your scripts. You may\
 also want to use a build process to do this minification up front if possible.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the script. Look out for plugins that have many scripts in the list which have a lot of red in code coverage. A plugin should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in WordPress](https://wordpress.org/support/article/optimization/#browser-caching).","uses-optimized-images":"Consider using an [image optimization WordPress plugin](https://wordp\
ress.org/plugins/search/optimize+images/) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression in your web server configuration.","uses-responsive-images":"Upload images directly through the [media library](https://wordpress.org/support/article/media-library-screen/) to ensure that the required image sizes are available, and then insert them from the media library or use the image widget to ensure the optimal image sizes are used (including those for the responsive breakpoints). Avoid using `Full Size` images unless the dimensions are adequate for their usage. [Learn More](https://wordpress.org/support/article/inserting-images-into-posts-and-pages/).","server-response-time":"Choose a lightweight theme (ideally a block theme) and implement full-page caching or a static site solution. Disable unnecessary plugins to minimize server overhead. Consider upgrading your hosting to managed or dedicated service."};HP.exports={id:"wordpres\
s",title:"WordPress",icon:ane,UIStrings:one}});var VP=je((FOe,WP)=>{d();var ine='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 294 524"><defs><linearGradient id="a" x1="36.742%" x2="37.116%" y1="100.518%" y2="-.001%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="b" x1="28.046%" x2="28.421%" y1="100.518%" y2="-.003%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="c" x1="38.215%" x2="38.589%" y1="100.518%" y2="0%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient></defs><g fill="none" fill-rule="evenodd"><path fill="url(%23a)" d="M218.617 270.615c-9.752 0-18.896-5.689-23.366-14.63l-7.72-17.27h-76.6l-7.722 17.27c-4.47 8.941-13.613 14.63-23.366 14.63H75.78l32.712 249.30\
6c1.625 4.671 4.673 4.671 6.502 0l32.51-79.648 28.242 79.442c1.625 4.676 4.673 4.676 6.501 0L220.04 270.82l-1.423-.204Z" transform="translate(-1.58 -.2)"/><path fill="url(%23b)" d="M184.47 231.784h-70.3l-10.77 24.179c-3.657 7.314-10.768 12.597-18.489 14.02L109.7 423.791c1.625 2.844 4.673 2.844 6.501 0l31.697-48.155 29.055 47.951c1.829 2.845 4.673 2.845 6.502 0l28.039-154.012c-6.908-2.032-13.004-6.908-16.255-13.613l-10.768-24.18Z" transform="translate(-1.58 -.2)"/><path fill="url(%23c)" d="m195.259 255.988-46.123-103.014-45.92 103.014c-1.625 3.048-3.656 5.69-6.095 7.925l19.1 102.2c1.015 1.423 3.657 1.83 5.485 0l25.601-33.931 25.602 33.728c1.625 2.032 4.47 1.626 5.485 0l21.131-103.42c-1.625-2.032-3.047-4.064-4.266-6.502Z" transform="translate(-1.58 -.2)"/><path fill="%23F56F46" d="M.439 12.559c-1.422-4.877 1.422-8.33 6.299-8.33H47.17c2.845 0 5.486 2.437 6.299 4.876l29.665 116.83h1.422l53.437-121.3c1.016-2.032 3.048-3.86 5.892-3.86h6.299c3.047 0 5.08 1.625 5.892 3.86l53.437 121.3h1.423L24\
0.6 9.105c.61-2.439 3.454-4.877 6.299-4.877h40.433c4.877 0 7.518 3.454 6.299 8.33l-65.221 231.63c-.61 2.845-3.454 4.876-6.298 4.876h-5.487c-2.438 0-4.876-1.625-5.892-3.86l-63.19-141.009h-1.015L83.744 245.203c-1.016 2.032-3.454 3.86-5.892 3.86h-5.486c-2.845 0-5.486-2.031-6.299-4.876L.44 12.559Z"/></g></svg>',sne={"unused-css-rules":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket' to fix this issue. It reduces page size by removing all CSS and stylesheets that are not used while keeping only the used CSS for each page.","modern-image-formats":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' to convert your images to WebP.","unused-javascript":"Enable [Delay JavaScript execution](https://docs.wp-rocket.me/article/1349-delay-javascript-execution) in 'WP Rocket' to fix this problem. It will improve the loading of your page by delaying the execution of scripts until user interaction. If your site has iframes, you can use WP \
Rocket's [LazyLoad for iframes and videos](https://docs.wp-rocket.me/article/1674-lazyload-for-iframes-and-videos) and [Replace YouTube iframe with preview image](https://docs.wp-rocket.me/article/1488-replace-youtube-iframe-with-preview-image) as well.","render-blocking-resources":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) and [Load JavaScript deferred](https://docs.wp-rocket.me/article/1265-load-javascript-deferred) in 'WP Rocket' to address this recommendation. These features will respectively optimize the CSS and JavaScript files so that they don't block the rendering of your page.","unminified-css":"Enable [Minify CSS files](https://docs.wp-rocket.me/article/1350-css-minify-combine) in 'WP Rocket' to fix this issue. Any spaces and comments in your site's CSS files will be removed to make the file size smaller and faster to download.","unminified-javascript":"Enable [Minify JavaScript files](https://docs.wp-rocket.me/article/1351-javascrip\
t-minify-combine) in 'WP Rocket' to fix this issue. Empty spaces and comments will be removed from JavaScript files to make their size smaller and faster to download.","uses-optimized-images":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' and run Bulk Optimization to compress your images.","uses-rel-preconnect":`Use [Prefetch DNS Requests](https://docs.wp-rocket.me/article/1302-prefetch-dns-requests) in 'WP Rocket' to add "dns-prefetch" and speed up the connection with external domains. Also, 'WP Rocket' automatically adds "preconnect" to [Google Fonts domain](https://docs.wp-rocket.me/article/1312-optimize-google-fonts) and any CNAME(S) added via the [Enable CDN](https://docs.wp-rocket.me/article/42-using-wp-rocket-with-a-cdn) feature.`,"uses-rel-preload":"To fix this issue for fonts, enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket'. Your site's critical fonts will be preloaded with priority.","offscreen-images":"Ena\
ble [LazyLoad](https://docs.wp-rocket.me/article/1141-lazyload-for-images) in WP Rocket to fix this recommendation. This feature delays the loading of the images until the visitor scrolls down the page and actually needs to see them."};WP.exports={id:"wp-rocket",title:"WP Rocket",icon:ine,UIStrings:sne}});var YP=je((OOe,$P)=>{d();var cne=[vP(),wP(),DP(),xP(),CP(),kP(),_P(),FP(),OP(),LP(),BP(),jP(),zP(),GP(),VP()];$P.exports=cne});var JP=je((LOe,KP)=>{d();KP.exports=i(function(t,r){if(typeof t=="string"&&r[t])return t;for(var n=[].concat(t||[]),a=0,o=n.length;a<o;++a)for(var s=n[a].split("-");s.length;){var c=s.join("-");if(r[c])return c;s.pop()}},"lookupClosestLocale")});var Xg,une,XP,rm=g(()=>{"use strict";d();Go();Vi();pc();Xg=fr.dirname(""),une=JSON.parse(`{
  "name": "lighthouse",
  "type": "module",
  "version": "12.8.2",
  "description": "Automated auditing, performance metrics, and best practices for the web.",
  "main": "./core/index.js",
  "bin": {
    "lighthouse": "./cli/index.js",
    "chrome-debug": "./core/scripts/manual-chrome-launcher.js",
    "smokehouse": "./cli/test/smokehouse/frontends/smokehouse-bin.js"
  },
  "engines": {
    "node": ">=18.16"
  },
  "scripts": {
    "prepack": "yarn build-report --standalone --flow --esm && yarn build-types",
    "postpack": "yarn clean-types",
    "build-all": "yarn build-report && yarn build-cdt-strings && yarn build-devtools && concurrently 'yarn build-extension' 'yarn build-lr' 'yarn build-viewer' 'yarn build-treemap' 'yarn build-smokehouse-bundle' 'yarn build-legacy-javascript' && yarn build-pack",
    "build-cdt-lib": "node ./build/build-cdt-lib.js",
    "build-cdt-strings": "node ./build/build-cdt-strings.js",
    "build-extension": "yarn build-extension-chrome && yarn build-extension-firefox",
    "build-extension-chrome": "node ./build/build-extension.js chrome",
    "build-extension-firefox": "node ./build/build-extension.js firefox",
    "build-devtools": "yarn reset-link && node ./build/build-bundle.js clients/devtools/devtools-entry.js dist/lighthouse-dt-bundle.js && node ./build/build-dt-report-resources.js",
    "build-legacy-javascript": "node ./build/build-legacy-javascript.js",
    "build-smokehouse-bundle": "node ./build/build-smokehouse-bundle.js",
    "build-lr": "yarn reset-link && node --max-old-space-size=4096 ./build/build-lightrider-bundles.js",
    "build-pack": "bash build/build-pack.sh",
    "build-report": "node build/build-report-components.js && node build/build-report.js",
    "build-sample-reports": "yarn build-report && node build/build-sample-reports.js",
    "build-treemap": "node ./build/build-treemap.js",
    "build-viewer": "node ./build/build-viewer.js",
    "build-types": "yarn type-check && rsync -a .tmp/tsbuildinfo/ ./ --include='*.d.ts' --include='*.d.cts' --exclude='*.map' --exclude='*.tsbuildinfo'",
    "reset-link": "(yarn unlink || true) && yarn link && yarn link lighthouse",
    "c8": "bash core/scripts/c8.sh",
    "clean": "rm -r dist proto/scripts/*.json proto/scripts/*_pb2.* proto/scripts/*_pb.* proto/scripts/__pycache__ proto/scripts/*.pyc *.report.html *.report.dom.html *.report.json *.devtoolslog.json *.trace.json shared/localization/locales/*.ctc.json || true",
    "clean-types": "git clean -xfq '*.d.ts' '*.d.cts' -e 'node_modules/' -e 'dist/' -e '.tmp/' -e '**/types/'",
    "lint": "[ \\"$CI\\" = true ] && eslint --quiet -f codeframe . || eslint .",
    "smoke": "node -r source-map-support/register cli/test/smokehouse/frontends/smokehouse-bin.js",
    "debug": "node --inspect-brk ./cli/index.js",
    "start": "yarn build-report --standalone && node ./cli/index.js",
    "mocha": "node --loader=testdouble core/test/scripts/run-mocha-tests.js",
    "test": "yarn diff:sample-json && yarn lint --quiet && yarn unit && yarn type-check",
    "test-bundle": "yarn smoke --runner bundle",
    "test-clients": "yarn mocha --testMatch clients/**/*-test.js && yarn mocha --testMatch clients/**/*-test-pptr.js",
    "test-viewer": "yarn unit-viewer && yarn mocha --testMatch viewer/**/*-test-pptr.js --timeout 35000",
    "test-treemap": "yarn unit-treemap && yarn mocha --testMatch treemap/**/*-test-pptr.js --timeout 35000",
    "test-lantern": "bash core/scripts/test-lantern.sh",
    "test-legacy-javascript": "bash core/scripts/test-legacy-javascript.sh",
    "test-docs": "yarn --cwd docs/recipes/ test",
    "test-proto": "yarn compile-proto && yarn build-proto-roundtrip",
    "unit-core": "yarn mocha core",
    "unit-cli": "yarn mocha --testMatch cli/**/*-test.js",
    "unit-lantern-trace": "INTERNAL_LANTERN_USE_TRACE=1 yarn mocha core/test/computed/metrics core/test/audits",
    "unit-report": "yarn mocha --testMatch report/**/*-test.js",
    "unit-treemap": "yarn mocha --testMatch treemap/**/*-test.js",
    "unit-viewer": "yarn mocha --testMatch viewer/**/*-test.js",
    "unit-flow": "bash flow-report/test/run-flow-report-tests.sh",
    "unit": "yarn unit-flow && yarn mocha && yarn unit-lantern-trace",
    "unit:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit",
    "unit-lantern-trace:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit-lantern-trace",
    "core-unit": "yarn unit-core",
    "cli-unit": "yarn unit-cli",
    "viewer-unit": "yarn unit-viewer",
    "watch": "yarn unit-core --watch",
    "unit:cicoverage": "yarn c8 --all yarn unit:ci && yarn c8 --all yarn unit-lantern-trace:ci",
    "coverage": "yarn unit:cicoverage && c8 report --reporter html",
    "coverage:smoke": "yarn c8 yarn smoke -j=1 && c8 report --reporter html",
    "devtools": "bash core/scripts/roll-to-devtools.sh",
    "chrome": "node core/scripts/manual-chrome-launcher.js",
    "fast": "node ./cli/index.js --preset=desktop --throttlingMethod=provided",
    "deploy-treemap": "yarn build-treemap --deploy",
    "deploy-viewer": "yarn build-viewer --deploy",
    "vercel-build": "yarn build-sample-reports && yarn build-viewer && yarn build-treemap",
    "dogfood-lhci": "./core/scripts/dogfood-lhci.sh",
    "timing-trace": "node core/scripts/generate-timing-trace.js",
    "changelog": "conventional-changelog --config ./build/changelog-generator/index.cjs --infile changelog.md --same-file",
    "type-check": "tsc --build ./tsconfig-all.json",
    "i18n:checks": "./core/scripts/i18n/assert-strings-collected.sh",
    "i18n:collect-strings": "node core/scripts/i18n/collect-strings.js",
    "update:lantern-baseline": "node core/scripts/lantern/update-baseline-lantern-values.js",
    "update:sample-artifacts": "node core/scripts/update-report-fixtures.js",
    "update:sample-json": "yarn i18n:collect-strings && node ./cli -A=./core/test/results/artifacts --config-path=./core/test/results/sample-config.js --output=json --output-path=./core/test/results/sample_v2.json && node core/scripts/cleanup-LHR-for-diff.js ./core/test/results/sample_v2.json --only-remove-timing && node ./core/scripts/update-flow-fixtures.js",
    "update:flow-sample-json": "yarn i18n:collect-strings && node ./core/scripts/update-flow-fixtures.js",
    "test-devtools": "bash core/test/devtools-tests/test-locally.sh",
    "open-devtools": "bash core/scripts/open-devtools.sh",
    "run-devtools": "node core/scripts/pptr-run-devtools.js",
    "diff:sample-json": "yarn i18n:checks && bash core/scripts/assert-golden-lhr-unchanged.sh",
    "diff:flow-sample-json": "yarn i18n:collect-strings && bash core/scripts/assert-baseline-flow-result-unchanged.sh",
    "computeBenchmarkIndex": "./core/scripts/benchmark.js",
    "save-latest-run": "./core/scripts/save-latest-run.sh",
    "compile-proto": "protoc --python_out=./ ./proto/lighthouse-result.proto && mv ./proto/*_pb2.py ./proto/scripts || (echo \\"❌ Install protobuf = 3.20.x to compile the proto file.\\" && false)",
    "build-proto-roundtrip": "mkdir -p .tmp && python3 proto/scripts/json_roundtrip_via_proto.py",
    "static-server": "node cli/test/fixtures/static-server.js",
    "serve-dist": "cd dist && python3 -m http.server 7878",
    "serve-gh-pages": "cd dist/gh-pages && python3 -m http.server 7333",
    "serve-treemap": "yarn serve-gh-pages",
    "serve-viewer": "yarn serve-gh-pages",
    "flow-report": "yarn build-report --flow && node ./core/scripts/build-test-flow-report.js",
    "generate-insight-audits": "node core/scripts/generate-insight-audits.js"
  },
  "devDependencies": {
    "@build-tracker/cli": "^1.0.0-beta.15",
    "@esbuild-kit/esm-loader": "^2.1.1",
    "@esbuild-plugins/node-modules-polyfill": "^0.1.4",
    "@eslint/compat": "^1.3.0",
    "@eslint/eslintrc": "^3.3.1",
    "@eslint/js": "^9.28.0",
    "@formatjs/icu-messageformat-parser": "^2.6.2",
    "@jest/fake-timers": "^29.7.0",
    "@testing-library/preact": "^3.1.1",
    "@testing-library/preact-hooks": "^1.1.0",
    "@types/archiver": "^2.1.2",
    "@types/chrome": "^0.0.154",
    "@types/configstore": "^6.0.2",
    "@types/cpy": "^5.1.0",
    "@types/debug": "^4.1.7",
    "@types/eslint": "^9.6.1",
    "@types/estree": "^0.0.50",
    "@types/gh-pages": "^2.0.0",
    "@types/google.analytics": "0.0.39",
    "@types/gtag.js": "0.0.20",
    "@types/jpeg-js": "^0.3.7",
    "@types/jsdom": "^16.2.13",
    "@types/lodash-es": "^4.17.12",
    "@types/mocha": "^9.0.0",
    "@types/node": "*",
    "@types/pako": "^1.0.1",
    "@types/resize-observer-browser": "^0.1.1",
    "@types/resolve": "^1.20.2",
    "@types/semver": "^5.5.0",
    "@types/ws": "^7.0.0",
    "@types/yargs": "^17.0.8",
    "@types/yargs-parser": "^20.2.1",
    "@typescript-eslint/eslint-plugin": "^8.34.0",
    "@typescript-eslint/parser": "^8.34.0",
    "acorn": "^8.5.0",
    "angular": "^1.7.4",
    "archiver": "^7.0.1",
    "builtin-modules": "^3.3.0",
    "c8": "^7.11.3",
    "chalk": "^2.4.1",
    "chrome-devtools-frontend": "1.0.1506453",
    "colors": "^1.4.0",
    "concurrently": "^9.2.1",
    "conventional-changelog-cli": "^2.1.1",
    "core-js-compat": "^3.44.0",
    "cpy": "^8.1.2",
    "csv-validator": "^0.0.3",
    "es-main": "^1.2.0",
    "esbuild": "0.25.9",
    "eslint": "^9.28.0",
    "eslint-config-google": "^0.14.0",
    "eslint-formatter-codeframe": "^7.32.1",
    "eslint-plugin-import": "^2.25.3",
    "eslint-plugin-local-rules": "1.1.0",
    "expect": "^28.1.0",
    "firebase": "^9.0.2",
    "gh-pages": "^2.0.1",
    "glob": "^7.1.3",
    "globals": "^15.14.0",
    "idb-keyval": "2.2.0",
    "jest-mock": "^29.7.0",
    "jest-snapshot": "^29.7.0",
    "jsdom": "^12.2.0",
    "lighthouse-plugin-soft-navigation": "^1.1.0",
    "magic-string": "^0.25.7",
    "mime-types": "^2.1.30",
    "mocha": "^10.0.0",
    "pako": "^2.1.0",
    "preact": "^10.7.2",
    "pretty-json-stringify": "^0.0.2",
    "puppeteer": "^24.17.1",
    "resolve": "^1.22.10",
    "rollup-plugin-polyfill-node": "^0.12.0",
    "source-map-support": "^0.5.21",
    "terser": "^5.18.2",
    "testdouble": "^3.18.0",
    "typed-query-selector": "^2.12.0",
    "typescript": "5.8.2",
    "wait-for-expect": "^3.0.2",
    "webtreemap-cdt": "^3.2.1"
  },
  "dependencies": {
    "@paulirish/trace_engine": "0.0.59",
    "@sentry/node": "^9.28.1",
    "axe-core": "^4.10.3",
    "chrome-launcher": "^1.2.0",
    "configstore": "^7.0.0",
    "csp_evaluator": "1.1.5",
    "devtools-protocol": "0.0.1507524",
    "enquirer": "^2.3.6",
    "http-link-header": "^1.1.1",
    "intl-messageformat": "^10.5.3",
    "jpeg-js": "^0.4.4",
    "js-library-detector": "^6.7.0",
    "lighthouse-logger": "^2.0.2",
    "lighthouse-stack-packs": "1.12.2",
    "lodash-es": "^4.17.21",
    "lookup-closest-locale": "6.2.0",
    "metaviewport-parser": "0.3.0",
    "open": "^8.4.0",
    "parse-cache-control": "1.0.1",
    "puppeteer-core": "^24.17.1",
    "robots-parser": "^3.0.1",
    "speedline-core": "^1.4.3",
    "third-party-web": "^0.27.0",
    "tldts-icann": "^7.0.12",
    "ws": "^7.0.0",
    "yargs": "^17.3.1",
    "yargs-parser": "^21.0.0"
  },
  "resolutions": {
    "puppeteer/**/devtools-protocol": "0.0.1507524",
    "puppeteer-core/**/devtools-protocol": "0.0.1507524"
  },
  "repository": "GoogleChrome/lighthouse",
  "keywords": [
    "google",
    "chrome",
    "devtools"
  ],
  "author": "Google LLC",
  "license": "Apache-2.0",
  "bugs": {
    "url": "https://github.com/GoogleChrome/lighthouse/issues"
  },
  "homepage": "https://github.com/GoogleChrome/lighthouse#readme",
  "packageManager": "yarn@1.22.22+sha512.a6b2f7906b721bba3d67d4aff083df04dad64c399707841b7acf00f6b133b7ac24255f2652fa22ae3534329dc6180534e98d17432037ff6fd140556e2bb3137e"
}
`),XP=une.version});function Zg(e,t){if(typeof Intl!="object")throw new Error("Lighthouse must be run in Node with `Intl` support. See https://nodejs.org/api/intl.html for help");let r=Intl.getCanonicalLocales(e),n=Intl.NumberFormat.supportedLocalesOf(r),a=t||hP(),o=Object.fromEntries(a.map(c=>[c,{}])),s=(0,ZP.default)(n,o);return s||(Intl.NumberFormat.supportedLocalesOf("es").length===0&&q.warn("i18n","Requested locale not available in this version of node. The `full-icu` npm module can provide additional locales. For help, see https://github.com/GoogleChrome/lighthouse/blob/main/readme.md#how-do-i-get-localized-lighthouse-results-via-the-cli"),q.warn("i18n",`locale(s) '${e}' not available. Falling back to default '${Ou}'`)),s||Ou}function D(e,t={}){e.startsWith("file://")&&(e=mc.fileURLToPath(e)),fr.isAbsolute(e)&&(e=fr.relative(Xg,e));let r={...R,...t};return i((a,o)=>{let s=Object.keys(r).find(m=>r[m]===a);if(!s)throw new Error(`Could not locate: ${a}`);return{i18nId:`${(s in t?e:fr.relative(Xg,oP({url:"\
core/lib/i18n/i18n.js"}))).replace(/\\/g,"/")} | ${s}`,values:o,formattedDefault:K0(a,o,Ou)}},"getIcuMessageFn")}function lo(e){return typeof e=="string"||Nu(e)}var ZP,R,L=g(()=>{"use strict";d();Vi();tm();ZP=Kr(JP(),1);pt();Xo();rm();Xo();pc();R={ms:"{timeInMs, number, milliseconds} ms",seconds:"{timeInMs, number, seconds} s",displayValueByteSavings:"Est savings of {wastedBytes, number, bytes} KiB",displayValueMsSavings:"Est savings of {wastedMs, number, milliseconds} ms",displayValueElementsFound:"{nodeCount, plural, =1 {1 element found} other {# elements found}}",columnURL:"URL",columnSize:"Size",columnResourceSize:"Resource Size",columnTransferSize:"Transfer Size",columnCacheTTL:"Cache TTL",columnWastedBytes:"Est Savings",columnWastedMs:"Est Savings",columnBlockingTime:"Main-Thread Blocking Time",columnTimeSpent:"Time Spent",columnLocation:"Location",columnResourceType:"Resource Type",columnRequests:"Requests",columnName:"Name",columnSource:"Source",columnElement:"Element",columnStartTime:"\
Start Time",columnDuration:"Duration",columnFailingElem:"Failing Elements",columnDescription:"Description",total:"Total",totalResourceType:"Total",documentResourceType:"Document",scriptResourceType:"Script",stylesheetResourceType:"Stylesheet",imageResourceType:"Image",mediaResourceType:"Media",fontResourceType:"Font",otherResourceType:"Other",thirdPartyResourceType:"Third-party",otherResourcesLabel:"Other resources",firstContentfulPaintMetric:"First Contentful Paint",interactiveMetric:"Time to Interactive",firstMeaningfulPaintMetric:"First Meaningful Paint",totalBlockingTimeMetric:"Total Blocking Time",maxPotentialFIDMetric:"Max Potential First Input Delay",speedIndexMetric:"Speed Index",largestContentfulPaintMetric:"Largest Contentful Paint",cumulativeLayoutShiftMetric:"Cumulative Layout Shift",interactionToNextPaint:"Interaction to Next Paint",itemSeverityLow:"Low",itemSeverityMedium:"Medium",itemSeverityHigh:"High"};i(Zg,"lookupLocale");i(D,"createIcuMessageFn");i(lo,"isStringOrIcuM\
essage")});function e5(e){if(!e)return[];let t=[];for(let r of e){let n=Z0.find(u=>u.requiredStacks.includes(`${r.detector}:${r.id}`));if(!n)continue;let a=QP.default.find(u=>u.id===n.packId);if(!a){q.warn("StackPacks",`'${n.packId}' stack pack was matched but is not found in stack-packs lib`);continue}let o=D(`node_modules/lighthouse-stack-packs/packs/${a.id}.js`,a.UIStrings),s={},c=a.UIStrings;for(let u in c)c[u]&&(s[u]=o(c[u]));t.push({id:a.id,title:a.title,iconDataURL:a.icon,descriptions:s})}return t.sort((r,n)=>{let a=Z0.findIndex(s=>s.packId===r.id),o=Z0.findIndex(s=>s.packId===n.id);return a-o})}var QP,Z0,t5=g(()=>{"use strict";d();pt();QP=Kr(YP(),1);L();Z0=[{packId:"gatsby",requiredStacks:["js:gatsby"]},{packId:"wordpress",requiredStacks:["js:wordpress"]},{packId:"wix",requiredStacks:["js:wix"]},{packId:"wp-rocket",requiredStacks:["js:wp-rocket"]},{packId:"ezoic",requiredStacks:["js:ezoic"]},{packId:"drupal",requiredStacks:["js:drupal"]},{packId:"nitropack",requiredStacks:["js:nitropack"]},
{packId:"amp",requiredStacks:["js:amp"]},{packId:"magento",requiredStacks:["js:magento"]},{packId:"octobercms",requiredStacks:["js:octobercms"]},{packId:"joomla",requiredStacks:["js:joomla"]},{packId:"next.js",requiredStacks:["js:next"]},{packId:"nuxt",requiredStacks:["js:nuxt"]},{packId:"angular",requiredStacks:["js:angular"]},{packId:"react",requiredStacks:["js:react"]}];i(e5,"getStackPacks")});var Q0,Sr,r5=g(()=>{d();typeof Object.create=="function"?Q0=i(function(t,r){t.super_=r,t.prototype=Object.create(r.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}})},"inherits"):Q0=i(function(t,r){t.super_=r;var n=i(function(){},"TempCtor");n.prototype=r.prototype,t.prototype=new n,t.prototype.constructor=t},"inherits");Sr=Q0});function pne(e){if(!cw(e)){for(var t=[],r=0;r<arguments.length;r++)t.push(Zi(arguments[r]));return t.join(" ")}for(var r=1,n=arguments,a=n.length,o=String(e).replace(mne,function(c){if(c==="%%")return"%";if(r>=a)return c;switch(c){case"%s":return String(n[r++]);case"%d":return Number(n[r++]);case"%j":try{return JSON.stringify(n[r++])}catch{return"[Circular]"}default:return c}}),s=n[r];r<a;s=n[++r])sw(s)||!nm(s)?o+=" "+s:o+=" "+Zi(s);return o}function iw(e,t){if(Xi(globalThis.process))return function(){return iw(e,t).apply(this,arguments)};if(gn.noDeprecation===!0)return e;var r=!1;function n(){if(!r){if(gn.throwDeprecation)throw new Error(t);gn.traceDeprecation?console.trace(t):console.error(t),r=!0}return e.apply(this,arguments)}return i(n,"deprecated"),n}function a5(e){if(Xi(ew)&&(ew=gn.env.NODE_DEBUG||""),e=e.toUpperCase(),!Qg[e])if(new RegExp("\\b"+e+"\\b","i").test(ew)){var t=0;Qg[e]=function(){var r=pne.apply(null,arguments);console.error("%s %d: %s",e,t,r)}}else Qg[e]=function(){};
return Qg[e]}function Zi(e,t){var r={seen:[],stylize:hne};return arguments.length>=3&&(r.depth=arguments[2]),arguments.length>=4&&(r.colors=arguments[3]),o5(t)?r.showHidden=t:t&&Dne(r,t),Xi(r.showHidden)&&(r.showHidden=!1),Xi(r.depth)&&(r.depth=2),Xi(r.colors)&&(r.colors=!1),Xi(r.customInspect)&&(r.customInspect=!0),r.colors&&(r.stylize=fne),e1(r,e,r.depth)}function fne(e,t){var r=Zi.styles[t];return r?"\x1B["+Zi.colors[r][0]+"m"+e+"\x1B["+Zi.colors[r][1]+"m":e}function hne(e,t){return e}function gne(e){var t={};return e.forEach(function(r,n){t[r]=!0}),t}function e1(e,t,r){if(e.customInspect&&t&&aw(t.inspect)&&t.inspect!==Zi&&!(t.constructor&&t.constructor.prototype===t)){var n=t.inspect(r,e);return cw(n)||(n=e1(e,n,r)),n}var a=yne(e,t);if(a)return a;var o=Object.keys(t),s=gne(o);if(e.showHidden&&(o=Object.getOwnPropertyNames(t)),nw(t)&&(o.indexOf("message")>=0||o.indexOf("description")>=0))return tw(t);if(o.length===0){if(aw(t)){var c=t.name?": "+t.name:"";return e.stylize("[Function"+
c+"]","special")}if(rw(t))return e.stylize(RegExp.prototype.toString.call(t),"regexp");if(n5(t))return e.stylize(Date.prototype.toString.call(t),"date");if(nw(t))return tw(t)}var u="",l=!1,m=["{","}"];if(wne(t)&&(l=!0,m=["[","]"]),aw(t)){var p=t.name?": "+t.name:"";u=" [Function"+p+"]"}if(rw(t)&&(u=" "+RegExp.prototype.toString.call(t)),n5(t)&&(u=" "+Date.prototype.toUTCString.call(t)),nw(t)&&(u=" "+tw(t)),o.length===0&&(!l||t.length==0))return m[0]+u+m[1];if(r<0)return rw(t)?e.stylize(RegExp.prototype.toString.call(t),"regexp"):e.stylize("[Object]","special");e.seen.push(t);var f;return l?f=vne(e,t,r,s,o):f=o.map(function(h){return ow(e,t,r,s,h,l)}),e.seen.pop(),bne(f,u,m)}function yne(e,t){if(Xi(t))return e.stylize("undefined","undefined");if(cw(t)){var r="'"+JSON.stringify(t).replace(/^"|"$/g,"").replace(/'/g,"\\'").replace(/\\"/g,'"')+"'";return e.stylize(r,"string")}if(Ene(t))return e.stylize(""+t,"number");if(o5(t))return e.stylize(""+t,"boolean");if(sw(t))return e.stylize("null",
"null")}function tw(e){return"["+Error.prototype.toString.call(e)+"]"}function vne(e,t,r,n,a){for(var o=[],s=0,c=t.length;s<c;++s)i5(t,String(s))?o.push(ow(e,t,r,n,String(s),!0)):o.push("");return a.forEach(function(u){u.match(/^\d+$/)||o.push(ow(e,t,r,n,u,!0))}),o}function ow(e,t,r,n,a,o){var s,c,u;if(u=Object.getOwnPropertyDescriptor(t,a)||{value:t[a]},u.get?u.set?c=e.stylize("[Getter/Setter]","special"):c=e.stylize("[Getter]","special"):u.set&&(c=e.stylize("[Setter]","special")),i5(n,a)||(s="["+a+"]"),c||(e.seen.indexOf(u.value)<0?(sw(r)?c=e1(e,u.value,null):c=e1(e,u.value,r-1),c.indexOf(`
`)>-1&&(o?c=c.split(`
`).map(function(l){return"  "+l}).join(`
`).substr(2):c=`
`+c.split(`
`).map(function(l){return"   "+l}).join(`
`))):c=e.stylize("[Circular]","special")),Xi(s)){if(o&&a.match(/^\d+$/))return c;s=JSON.stringify(""+a),s.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)?(s=s.substr(1,s.length-2),s=e.stylize(s,"name")):(s=s.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'"),s=e.stylize(s,"string"))}return s+": "+c}function bne(e,t,r){var n=0,a=e.reduce(function(o,s){return n++,s.indexOf(`
`)>=0&&n++,o+s.replace(/\u001b\[\d\d?m/g,"").length+1},0);return a>60?r[0]+(t===""?"":t+`
 `)+" "+e.join(`,
  `)+" "+r[1]:r[0]+t+" "+e.join(", ")+" "+r[1]}function wne(e){return Array.isArray(e)}function o5(e){return typeof e=="boolean"}function sw(e){return e===null}function Ene(e){return typeof e=="number"}function cw(e){return typeof e=="string"}function Xi(e){return e===void 0}function rw(e){return nm(e)&&uw(e)==="[object RegExp]"}function nm(e){return typeof e=="object"&&e!==null}function n5(e){return nm(e)&&uw(e)==="[object Date]"}function nw(e){return nm(e)&&(uw(e)==="[object Error]"||e instanceof Error)}function aw(e){return typeof e=="function"}function uw(e){return Object.prototype.toString.call(e)}function Dne(e,t){if(!t||!nm(t))return e;for(var r=Object.keys(t),n=r.length;n--;)e[r[n]]=t[r[n]];return e}function i5(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function Tne(e){if(typeof e!="function")throw new TypeError('The "original" argument must be of type Function');if(hc&&e[hc]){var t=e[hc];if(typeof t!="function")throw new TypeError('The "util.promisify.custom" argume\
nt must be of type Function');return Object.defineProperty(t,hc,{value:t,enumerable:!1,writable:!1,configurable:!0}),t}function t(){for(var r,n,a=new Promise(function(c,u){r=c,n=u}),o=[],s=0;s<arguments.length;s++)o.push(arguments[s]);o.push(function(c,u){c?n(c):r(u)});try{e.apply(this,o)}catch(c){n(c)}return a}return i(t,"fn"),Object.setPrototypeOf(t,Object.getPrototypeOf(e)),hc&&Object.defineProperty(t,hc,{value:t,enumerable:!1,writable:!1,configurable:!0}),Object.defineProperties(t,dne(e))}var dne,mne,Qg,ew,hc,Qi=g(()=>{d();zi();r5();dne=Object.getOwnPropertyDescriptors||i(function(t){for(var r=Object.keys(t),n={},a=0;a<r.length;a++)n[r[a]]=Object.getOwnPropertyDescriptor(t,r[a]);return n},"getOwnPropertyDescriptors"),mne=/%[sdj%]/g;i(pne,"format");i(iw,"deprecate");Qg={};i(a5,"debuglog");i(Zi,"inspect");Zi.colors={bold:[1,22],italic:[3,23],underline:[4,24],inverse:[7,27],white:[37,39],grey:[90,39],black:[30,39],blue:[34,39],cyan:[36,39],green:[32,39],magenta:[35,39],red:[31,39],yellow:[
33,39]};Zi.styles={special:"cyan",number:"yellow",boolean:"yellow",undefined:"grey",null:"bold",string:"green",date:"magenta",regexp:"red"};i(fne,"stylizeWithColor");i(hne,"stylizeNoColor");i(gne,"arrayToHash");i(e1,"formatValue");i(yne,"formatPrimitive");i(tw,"formatError");i(vne,"formatArray");i(ow,"formatProperty");i(bne,"reduceToSingleString");i(wne,"isArray");i(o5,"isBoolean");i(sw,"isNull");i(Ene,"isNumber");i(cw,"isString");i(Xi,"isUndefined");i(rw,"isRegExp");i(nm,"isObject");i(n5,"isDate");i(nw,"isError");i(aw,"isFunction");i(uw,"objectToString");i(Dne,"_extend");i(i5,"hasOwnProperty");hc=typeof Symbol<"u"?Symbol("util.promisify.custom"):void 0;i(Tne,"promisify");Tne.custom=hc});function gc(){this.head=null,this.tail=null,this.length=0}var s5,c5=g(()=>{d();bu();s5=gc;i(gc,"BufferList");gc.prototype.push=function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length};gc.prototype.unshift=function(e){var t={data:e,next:this.head};this.length===0&&(this.tail=t),this.head=t,++this.length};gc.prototype.shift=function(){if(this.length!==0){var e=this.head.data;return this.length===1?this.head=this.tail=null:this.head=this.head.next,--this.length,e}};gc.prototype.clear=function(){this.head=this.tail=null,this.length=0};gc.prototype.join=function(e){if(this.length===0)return"";for(var t=this.head,r=""+t.data;t=t.next;)r+=e+t.data;return r};gc.prototype.concat=function(e){if(this.length===0)return oe.alloc(0);if(this.length===1)return this.head.data;for(var t=oe.allocUnsafe(e>>>0),r=this.head,n=0;r;)r.data.copy(t,n),n+=r.data.length,r=r.next;return t}});function Sne(e){if(e&&!xne(e))throw new Error("Unknown encoding: "+e)}function Lu(e){switch(this.encoding=(e||"utf8").toLowerCase().replace(/[-_]/,""),Sne(e),this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2,this.detectIncompleteChar=Ine;break;case"base64":this.surrogateSize=3,this.detectIncompleteChar=kne;break;default:this.write=Cne;return}this.charBuffer=new oe(6),this.charReceived=0,this.charLength=0}function Cne(e){return e.toString(this.encoding)}function Ine(e){this.charReceived=e.length%2,this.charLength=this.charReceived?2:0}function kne(e){this.charReceived=e.length%3,this.charLength=this.charReceived?3:0}var xne,u5=g(()=>{d();bu();xne=oe.isEncoding||function(e){switch(e&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};i(Sne,"assertEncoding");i(Lu,"StringDecoder");Lu.prototype.write=function(e){for(var t="";this.
charLength;){var r=e.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:e.length;if(e.copy(this.charBuffer,this.charReceived,0,r),this.charReceived+=r,this.charReceived<this.charLength)return"";e=e.slice(r,e.length),t=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var a=t.charCodeAt(t.length-1);if(a>=55296&&a<=56319){this.charLength+=this.surrogateSize,t="";continue}if(this.charReceived=this.charLength=0,e.length===0)return t;break}this.detectIncompleteChar(e);var n=e.length;this.charLength&&(e.copy(this.charBuffer,0,e.length-this.charReceived,n),n-=this.charReceived),t+=e.toString(this.encoding,0,n);var n=t.length-1,a=t.charCodeAt(n);if(a>=55296&&a<=56319){var o=this.surrogateSize;return this.charLength+=o,this.charReceived+=o,this.charBuffer.copy(this.charBuffer,o,0,o),e.copy(this.charBuffer,0,0,o),t.substring(0,n)}return t};Lu.prototype.detectIncompleteChar=function(e){for(var t=e.length>=3?3:e.length;t>0;t--){var r=e[e.length-t];if(t==1&&r>>
5==6){this.charLength=2;break}if(t<=2&&r>>4==14){this.charLength=3;break}if(t<=3&&r>>3==30){this.charLength=4;break}}this.charReceived=t};Lu.prototype.end=function(e){var t="";if(e&&e.length&&(t=this.write(e)),this.charReceived){var r=this.charReceived,n=this.charBuffer,a=this.encoding;t+=n.slice(0,r).toString(a)}return t};i(Cne,"passThroughWrite");i(Ine,"utf16DetectIncompleteChar");i(kne,"base64DetectIncompleteChar")});function Rne(e,t,r){if(typeof e.prependListener=="function")return e.prependListener(t,r);!e._events||!e._events[t]?e.on(t,r):Array.isArray(e._events[t])?e._events[t].unshift(r):e._events[t]=[r,e._events[t]]}function _ne(e,t){return e.listeners(t).length}function p5(e,t){e=e||{},this.objectMode=!!e.objectMode,t instanceof bn&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var r=e.highWaterMark,n=this.objectMode?16:16*1024;this.highWaterMark=r||r===0?r:n,this.highWaterMark=~~this.highWaterMark,this.buffer=new s5,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(this.decoder=new Lu(e.encoding),this.encoding=e.encoding)}function hr(e){if(!(this instanceof hr))return new hr(
e);this._readableState=new p5(e,this),this.readable=!0,e&&typeof e.read=="function"&&(this._read=e.read),ga.call(this)}function f5(e,t,r,n,a){var o=Mne(t,r);if(o)e.emit("error",o);else if(r===null)t.reading=!1,One(e,t);else if(t.objectMode||r&&r.length>0)if(t.ended&&!a){var s=new Error("stream.push() after EOF");e.emit("error",s)}else if(t.endEmitted&&a){var c=new Error("stream.unshift() after end event");e.emit("error",c)}else{var u;t.decoder&&!a&&!n&&(r=t.decoder.write(r),u=!t.objectMode&&r.length===0),a||(t.reading=!1),u||(t.flowing&&t.length===0&&!t.sync?(e.emit("data",r),e.read(0)):(t.length+=t.objectMode?1:r.length,a?t.buffer.unshift(r):t.buffer.push(r),t.needReadable&&t1(e))),Nne(e,t)}else a||(t.reading=!1);return Ane(t)}function Ane(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||e.length===0)}function Fne(e){return e>=l5?e=l5:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}function d5(e,t){return e<=0||t.length===0&&t.ended?0:t.objectMode?1:e!==e?t.flowing&&
t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=Fne(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function Mne(e,t){var r=null;return!Buffer.isBuffer(t)&&typeof t!="string"&&t!==null&&t!==void 0&&!e.objectMode&&(r=new TypeError("Invalid non-string/buffer chunk")),r}function One(e,t){if(!t.ended){if(t.decoder){var r=t.decoder.end();r&&r.length&&(t.buffer.push(r),t.length+=t.objectMode?1:r.length)}t.ended=!0,t1(e)}}function t1(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(Zt("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?hn(m5,e):m5(e))}function m5(e){Zt("emit readable"),e.emit("readable"),dw(e)}function Nne(e,t){t.readingMore||(t.readingMore=!0,hn(Lne,e,t))}function Lne(e,t){for(var r=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(Zt("maybeReadMore read 0"),e.read(0),r!==t.length);)r=t.length;t.readingMore=!1}function Pne(e){return function(){var t=e._readableState;Zt("pipeOnDrain",t.awaitDrain),
t.awaitDrain&&t.awaitDrain--,t.awaitDrain===0&&e.listeners("data").length&&(t.flowing=!0,dw(e))}}function Bne(e){Zt("readable nexttick read 0"),e.read(0)}function Une(e,t){t.resumeScheduled||(t.resumeScheduled=!0,hn(jne,e,t))}function jne(e,t){t.reading||(Zt("resume read 0"),e.read(0)),t.resumeScheduled=!1,t.awaitDrain=0,e.emit("resume"),dw(e),t.flowing&&!t.reading&&e.read(0)}function dw(e){var t=e._readableState;for(Zt("flow",t.flowing);t.flowing&&e.read()!==null;);}function h5(e,t){if(t.length===0)return null;var r;return t.objectMode?r=t.buffer.shift():!e||e>=t.length?(t.decoder?r=t.buffer.join(""):t.buffer.length===1?r=t.buffer.head.data:r=t.buffer.concat(t.length),t.buffer.clear()):r=qne(e,t.buffer,t.decoder),r}function qne(e,t,r){var n;return e<t.head.data.length?(n=t.head.data.slice(0,e),t.head.data=t.head.data.slice(e)):e===t.head.data.length?n=t.shift():n=r?zne(e,t):Hne(e,t),n}function zne(e,t){var r=t.head,n=1,a=r.data;for(e-=a.length;r=r.next;){var o=r.data,s=e>o.length?o.length:
e;if(s===o.length?a+=o:a+=o.slice(0,e),e-=s,e===0){s===o.length?(++n,r.next?t.head=r.next:t.head=t.tail=null):(t.head=r,r.data=o.slice(s));break}++n}return t.length-=n,a}function Hne(e,t){var r=Buffer.allocUnsafe(e),n=t.head,a=1;for(n.data.copy(r),e-=n.data.length;n=n.next;){var o=n.data,s=e>o.length?o.length:e;if(o.copy(r,r.length-e,0,s),e-=s,e===0){s===o.length?(++a,n.next?t.head=n.next:t.head=t.tail=null):(t.head=n,n.data=o.slice(s));break}++a}return t.length-=a,r}function lw(e){var t=e._readableState;if(t.length>0)throw new Error('"endReadable()" called on non-empty stream');t.endEmitted||(t.ended=!0,hn(Gne,t,e))}function Gne(e,t){!e.endEmitted&&e.length===0&&(e.endEmitted=!0,t.readable=!1,t.emit("end"))}function Wne(e,t){for(var r=0,n=e.length;r<n;r++)t(e[r],r)}function g5(e,t){for(var r=0,n=e.length;r<n;r++)if(e[r]===t)return r;return-1}var Zt,l5,mw=g(()=>{"use strict";d();qo();Qi();c5();u5();am();zi();hr.ReadableState=p5;Zt=a5("stream");Sr(hr,ga);i(Rne,"prependListener");i(_ne,"\
listenerCount");i(p5,"ReadableState");i(hr,"Readable");hr.prototype.push=function(e,t){var r=this._readableState;return!r.objectMode&&typeof e=="string"&&(t=t||r.defaultEncoding,t!==r.encoding&&(e=Buffer.from(e,t),t="")),f5(this,r,e,t,!1)};hr.prototype.unshift=function(e){var t=this._readableState;return f5(this,t,e,"",!0)};hr.prototype.isPaused=function(){return this._readableState.flowing===!1};i(f5,"readableAddChunk");i(Ane,"needMoreData");hr.prototype.setEncoding=function(e){return this._readableState.decoder=new Lu(e),this._readableState.encoding=e,this};l5=8388608;i(Fne,"computeNewHighWaterMark");i(d5,"howMuchToRead");hr.prototype.read=function(e){Zt("read",e),e=parseInt(e,10);var t=this._readableState,r=e;if(e!==0&&(t.emittedReadable=!1),e===0&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return Zt("read: emitReadable",t.length,t.ended),t.length===0&&t.ended?lw(this):t1(this),null;if(e=d5(e,t),e===0&&t.ended)return t.length===0&&lw(this),null;var n=t.needReadable;Zt("nee\
d readable",n),(t.length===0||t.length-e<t.highWaterMark)&&(n=!0,Zt("length less than watermark",n)),t.ended||t.reading?(n=!1,Zt("reading or ended",n)):n&&(Zt("do read"),t.reading=!0,t.sync=!0,t.length===0&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=d5(r,t)));var a;return e>0?a=h5(e,t):a=null,a===null?(t.needReadable=!0,e=0):t.length-=e,t.length===0&&(t.ended||(t.needReadable=!0),r!==e&&t.ended&&lw(this)),a!==null&&this.emit("data",a),a};i(Mne,"chunkInvalid");i(One,"onEofChunk");i(t1,"emitReadable");i(m5,"emitReadable_");i(Nne,"maybeReadMore");i(Lne,"maybeReadMore_");hr.prototype._read=function(e){this.emit("error",new Error("not implemented"))};hr.prototype.pipe=function(e,t){var r=this,n=this._readableState;switch(n.pipesCount){case 0:n.pipes=e;break;case 1:n.pipes=[n.pipes,e];break;default:n.pipes.push(e);break}n.pipesCount+=1,Zt("pipe count=%d opts=%j",n.pipesCount,t);var a=!t||t.end!==!1,o=a?c:m;n.endEmitted?hn(o):r.once("end",o),e.on("unpipe",s);function s(T){
Zt("onunpipe"),T===r&&m()}i(s,"onunpipe");function c(){Zt("onend"),e.end()}i(c,"onend");var u=Pne(r);e.on("drain",u);var l=!1;function m(){Zt("cleanup"),e.removeListener("close",y),e.removeListener("finish",v),e.removeListener("drain",u),e.removeListener("error",h),e.removeListener("unpipe",s),r.removeListener("end",c),r.removeListener("end",m),r.removeListener("data",f),l=!0,n.awaitDrain&&(!e._writableState||e._writableState.needDrain)&&u()}i(m,"cleanup");var p=!1;r.on("data",f);function f(T){Zt("ondata"),p=!1;var x=e.write(T);x===!1&&!p&&((n.pipesCount===1&&n.pipes===e||n.pipesCount>1&&g5(n.pipes,e)!==-1)&&!l&&(Zt("false write response, pause",r._readableState.awaitDrain),r._readableState.awaitDrain++,p=!0),r.pause())}i(f,"ondata");function h(T){Zt("onerror",T),E(),e.removeListener("error",h),_ne(e,"error")===0&&e.emit("error",T)}i(h,"onerror"),Rne(e,"error",h);function y(){e.removeListener("finish",v),E()}i(y,"onclose"),e.once("close",y);function v(){Zt("onfinish"),e.removeListener(
"close",y),E()}i(v,"onfinish"),e.once("finish",v);function E(){Zt("unpipe"),r.unpipe(e)}return i(E,"unpipe"),e.emit("pipe",r),n.flowing||(Zt("pipe resume"),r.resume()),e};i(Pne,"pipeOnDrain");hr.prototype.unpipe=function(e){var t=this._readableState;if(t.pipesCount===0)return this;if(t.pipesCount===1)return e&&e!==t.pipes?this:(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var r=t.pipes,n=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var a=0;a<n;a++)r[a].emit("unpipe",this);return this}var o=g5(t.pipes,e);return o===-1?this:(t.pipes.splice(o,1),t.pipesCount-=1,t.pipesCount===1&&(t.pipes=t.pipes[0]),e.emit("unpipe",this),this)};hr.prototype.on=function(e,t){var r=ga.prototype.on.call(this,e,t);if(e==="data")this._readableState.flowing!==!1&&this.resume();else if(e==="readable"){var n=this._readableState;!n.endEmitted&&!n.readableListening&&(n.readableListening=n.needReadable=!0,n.emittedReadable=!1,n.reading?n.length&&t1(this,n):
hn(Bne,this))}return r};hr.prototype.addListener=hr.prototype.on;i(Bne,"nReadingNextTick");hr.prototype.resume=function(){var e=this._readableState;return e.flowing||(Zt("resume"),e.flowing=!0,Une(this,e)),this};i(Une,"resume");i(jne,"resume_");hr.prototype.pause=function(){return Zt("call pause flowing=%j",this._readableState.flowing),this._readableState.flowing!==!1&&(Zt("pause"),this._readableState.flowing=!1,this.emit("pause")),this};i(dw,"flow");hr.prototype.wrap=function(e){var t=this._readableState,r=!1,n=this;e.on("end",function(){if(Zt("wrapped end"),t.decoder&&!t.ended){var s=t.decoder.end();s&&s.length&&n.push(s)}n.push(null)}),e.on("data",function(s){if(Zt("wrapped data"),t.decoder&&(s=t.decoder.write(s)),!(t.objectMode&&s==null)&&!(!t.objectMode&&(!s||!s.length))){var c=n.push(s);c||(r=!0,e.pause())}});for(var a in e)this[a]===void 0&&typeof e[a]=="function"&&(this[a]=(function(s){return function(){return e[s].apply(e,arguments)}})(a));var o=["error","close","destroy","pau\
se","resume"];return Wne(o,function(s){e.on(s,n.emit.bind(n,s))}),n._read=function(s){Zt("wrapped _read",s),r&&(r=!1,e.resume())},n};hr._fromList=h5;i(h5,"fromList");i(qne,"fromListPartial");i(zne,"copyFromBufferString");i(Hne,"copyFromBuffer");i(lw,"endReadable");i(Gne,"endReadableNT");i(Wne,"forEach");i(g5,"indexOf")});function Vne(){}function $ne(e,t,r){this.chunk=e,this.encoding=t,this.callback=r,this.next=null}function fw(e,t){Object.defineProperty(this,"buffer",{get:iw(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.")}),e=e||{},this.objectMode=!!e.objectMode,t instanceof bn&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var r=e.highWaterMark,n=this.objectMode?16:16*1024;this.highWaterMark=r||r===0?r:n,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var a=e.decodeStrings===!1;this.decodeStrings=!a,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(o){eae(t,o)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new D5(this)}
function Zr(e){if(!(this instanceof Zr)&&!(this instanceof bn))return new Zr(e);this._writableState=new fw(e,this),this.writable=!0,e&&(typeof e.write=="function"&&(this._write=e.write),typeof e.writev=="function"&&(this._writev=e.writev)),It.call(this)}function Yne(e,t){var r=new Error("write after end");e.emit("error",r),hn(t,r)}function Kne(e,t,r,n){var a=!0,o=!1;return r===null?o=new TypeError("May not write null values to stream"):!oe.isBuffer(r)&&typeof r!="string"&&r!==void 0&&!t.objectMode&&(o=new TypeError("Invalid non-string/buffer chunk")),o&&(e.emit("error",o),hn(n,o),a=!1),a}function Jne(e,t,r){return!e.objectMode&&e.decodeStrings!==!1&&typeof t=="string"&&(t=oe.from(t,r)),t}function Xne(e,t,r,n,a){r=Jne(t,r,n),oe.isBuffer(r)&&(n="buffer");var o=t.objectMode?1:r.length;t.length+=o;var s=t.length<t.highWaterMark;if(s||(t.needDrain=!0),t.writing||t.corked){var c=t.lastBufferedRequest;t.lastBufferedRequest=new $ne(r,n,a),c?c.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,
t.bufferedRequestCount+=1}else pw(e,t,!1,o,r,n,a);return s}function pw(e,t,r,n,a,o,s){t.writelen=n,t.writecb=s,t.writing=!0,t.sync=!0,r?e._writev(a,t.onwrite):e._write(a,o,t.onwrite),t.sync=!1}function Zne(e,t,r,n,a){--t.pendingcb,r?hn(a,n):a(n),e._writableState.errorEmitted=!0,e.emit("error",n)}function Qne(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}function eae(e,t){var r=e._writableState,n=r.sync,a=r.writecb;if(Qne(r),t)Zne(e,r,n,t,a);else{var o=w5(r);!o&&!r.corked&&!r.bufferProcessing&&r.bufferedRequest&&b5(e,r),n?hn(y5,e,r,o,a):y5(e,r,o,a)}}function y5(e,t,r,n){r||tae(e,t),t.pendingcb--,n(),E5(e,t)}function tae(e,t){t.length===0&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}function b5(e,t){t.bufferProcessing=!0;var r=t.bufferedRequest;if(e._writev&&r&&r.next){var n=t.bufferedRequestCount,a=new Array(n),o=t.corkedRequestsFree;o.entry=r;for(var s=0;r;)a[s]=r,r=r.next,s+=1;pw(e,t,!0,t.length,a,"",o.finish),t.pendingcb++,t.lastBufferedRequest=null,o.next?(t.corkedRequestsFree=
o.next,o.next=null):t.corkedRequestsFree=new D5(t)}else{for(;r;){var c=r.chunk,u=r.encoding,l=r.callback,m=t.objectMode?1:c.length;if(pw(e,t,!1,m,c,u,l),r=r.next,t.writing)break}r===null&&(t.lastBufferedRequest=null)}t.bufferedRequestCount=0,t.bufferedRequest=r,t.bufferProcessing=!1}function w5(e){return e.ending&&e.length===0&&e.bufferedRequest===null&&!e.finished&&!e.writing}function v5(e,t){t.prefinished||(t.prefinished=!0,e.emit("prefinish"))}function E5(e,t){var r=w5(t);return r&&(t.pendingcb===0?(v5(e,t),t.finished=!0,e.emit("finish")):v5(e,t)),r}function rae(e,t,r){t.ending=!0,E5(e,t),r&&(t.finished?hn(r):e.once("finish",r)),t.ended=!0,e.writable=!1}function D5(e){var t=this;this.next=null,this.entry=null,this.finish=function(r){var n=t.entry;for(t.entry=null;n;){var a=n.callback;e.pendingcb--,a(r),n=n.next}e.corkedRequestsFree?e.corkedRequestsFree.next=t:e.corkedRequestsFree=t}}var hw=g(()=>{d();Qi();bu();qo();am();zi();Zr.WritableState=fw;Sr(Zr,It);i(Vne,"nop");i($ne,"WriteReq");
i(fw,"WritableState");fw.prototype.getBuffer=i(function(){for(var t=this.bufferedRequest,r=[];t;)r.push(t),t=t.next;return r},"writableStateGetBuffer");i(Zr,"Writable");Zr.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"))};i(Yne,"writeAfterEnd");i(Kne,"validChunk");Zr.prototype.write=function(e,t,r){var n=this._writableState,a=!1;return typeof t=="function"&&(r=t,t=null),oe.isBuffer(e)?t="buffer":t||(t=n.defaultEncoding),typeof r!="function"&&(r=Vne),n.ended?Yne(this,r):Kne(this,n,e,r)&&(n.pendingcb++,a=Xne(this,n,e,t,r)),a};Zr.prototype.cork=function(){var e=this._writableState;e.corked++};Zr.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,!e.writing&&!e.corked&&!e.finished&&!e.bufferProcessing&&e.bufferedRequest&&b5(this,e))};Zr.prototype.setDefaultEncoding=i(function(t){if(typeof t=="string"&&(t=t.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((t+"").toLowerCase())>
-1))throw new TypeError("Unknown encoding: "+t);return this._writableState.defaultEncoding=t,this},"setDefaultEncoding");i(Jne,"decodeChunk");i(Xne,"writeOrBuffer");i(pw,"doWrite");i(Zne,"onwriteError");i(Qne,"onwriteStateUpdate");i(eae,"onwrite");i(y5,"afterWrite");i(tae,"onwriteDrain");i(b5,"clearBuffer");Zr.prototype._write=function(e,t,r){r(new Error("not implemented"))};Zr.prototype._writev=null;Zr.prototype.end=function(e,t,r){var n=this._writableState;typeof e=="function"?(r=e,e=null,t=null):typeof t=="function"&&(r=t,t=null),e!=null&&this.write(e,t),n.corked&&(n.corked=1,this.uncork()),!n.ending&&!n.finished&&rae(this,n,r)};i(w5,"needFinish");i(v5,"prefinish");i(E5,"finishMaybe");i(rae,"endWritable");i(D5,"CorkedRequest")});function bn(e){if(!(this instanceof bn))return new bn(e);hr.call(this,e),Zr.call(this,e),e&&e.readable===!1&&(this.readable=!1),e&&e.writable===!1&&(this.writable=!1),this.allowHalfOpen=!0,e&&e.allowHalfOpen===!1&&(this.allowHalfOpen=!1),this.once("end",nae)}function nae(){this.allowHalfOpen||this._writableState.ended||hn(aae,this)}function aae(e){e.end()}var T5,n1,r1,am=g(()=>{d();Qi();zi();mw();hw();Sr(bn,hr);T5=Object.keys(Zr.prototype);for(r1=0;r1<T5.length;r1++)n1=T5[r1],bn.prototype[n1]||(bn.prototype[n1]=Zr.prototype[n1]);i(bn,"Duplex");i(nae,"onend");i(aae,"onEndNT")});function oae(e){this.afterTransform=function(t,r){return iae(e,t,r)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null,this.writeencoding=null}function iae(e,t,r){var n=e._transformState;n.transforming=!1;var a=n.writecb;if(!a)return e.emit("error",new Error("no writecb in Transform class"));n.writechunk=null,n.writecb=null,r!=null&&e.push(r),a(t);var o=e._readableState;o.reading=!1,(o.needReadable||o.length<o.highWaterMark)&&e._read(o.highWaterMark)}function An(e){if(!(this instanceof An))return new An(e);bn.call(this,e),this._transformState=new oae(this);var t=this;this._readableState.needReadable=!0,this._readableState.sync=!1,e&&(typeof e.transform=="function"&&(this._transform=e.transform),typeof e.flush=="function"&&(this._flush=e.flush)),this.once("prefinish",function(){typeof this._flush=="function"?this._flush(function(r){x5(t,r)}):x5(t)})}function x5(e,t){if(t)return e.emit("error",t);var r=e._writableState,n=e._transformState;if(r.length)throw new Error(
"Calling transform done when ws.length != 0");if(n.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}var gw=g(()=>{d();am();Qi();Sr(An,bn);i(oae,"TransformState");i(iae,"afterTransform");i(An,"Transform");An.prototype.push=function(e,t){return this._transformState.needTransform=!1,bn.prototype.push.call(this,e,t)};An.prototype._transform=function(e,t,r){throw new Error("Not implemented")};An.prototype._write=function(e,t,r){var n=this._transformState;if(n.writecb=r,n.writechunk=e,n.writeencoding=t,!n.transforming){var a=this._readableState;(n.needTransform||a.needReadable||a.length<a.highWaterMark)&&this._read(a.highWaterMark)}};An.prototype._read=function(e){var t=this._transformState;t.writechunk!==null&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0};i(x5,"done")});function Pu(e){if(!(this instanceof Pu))return new Pu(e);An.call(this,e)}var S5=g(()=>{d();gw();Qi();Sr(Pu,An);i(Pu,"PassThrough");Pu.prototype._transform=function(e,t,r){r(null,e)}});function mo(){ga.call(this)}var yw,vw=g(()=>{d();qo();Qi();am();mw();hw();gw();S5();Sr(mo,ga);mo.Readable=hr;mo.Writable=Zr;mo.Duplex=bn;mo.Transform=An;mo.PassThrough=Pu;mo.Stream=mo;yw=mo;i(mo,"Stream");mo.prototype.pipe=function(e,t){var r=this;function n(m){e.writable&&e.write(m)===!1&&r.pause&&r.pause()}i(n,"ondata"),r.on("data",n);function a(){r.readable&&r.resume&&r.resume()}i(a,"ondrain"),e.on("drain",a),!e._isStdio&&(!t||t.end!==!1)&&(r.on("end",s),r.on("close",c));var o=!1;function s(){o||(o=!0,e.end())}i(s,"onend");function c(){o||(o=!0,typeof e.destroy=="function"&&e.destroy())}i(c,"onclose");function u(m){if(l(),ga.listenerCount(this,"error")===0)throw m}i(u,"onerror"),r.on("error",u),e.on("error",u);function l(){r.removeListener("data",n),e.removeListener("drain",a),r.removeListener("end",s),r.removeListener("close",c),r.removeListener("error",u),e.removeListener("error",u),r.removeListener("end",l),r.removeListener("close",l),e.removeListener("close",l)}return i(l,"clean\
up"),r.on("end",l),r.on("close",l),e.on("close",l),e.emit("pipe",r),e}});var a1,bw=g(()=>{d();a1={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}});function sae(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}var C5,I5=g(()=>{d();i(sae,"ZStream");C5=sae});function Bu(e,t,r,n,a){if(t.subarray&&e.subarray){e.set(t.subarray(r,r+n),a);return}for(var o=0;o<n;o++)e[a+o]=t[r+o]}var ww,Zo,Ew=g(()=>{"use strict";d();i(Bu,"arraySet");ww=Uint8Array,Zo=Uint16Array});function ju(e){for(var t=e.length;--t>=0;)e[t]=0}function Tw(e,t,r,n,a){this.static_tree=e,this.extra_bits=t,this.extra_base=r,this.elems=n,this.max_length=a,this.has_stree=e&&e.length}function xw(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t}function G5(e){return e<256?sm[e]:sm[256+(e>>>7)]}function um(e,t){e.pending_buf[e.pending++]=t&255,e.pending_buf[e.pending++]=t>>>8&255}function Vn(e,t,r){e.bi_valid>Dw-r?(e.bi_buf|=t<<e.bi_valid&65535,um(e,e.bi_buf),e.bi_buf=t>>Dw-e.bi_valid,e.bi_valid+=r-Dw):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=r)}function po(e,t,r){Vn(e,r[t*2],r[t*2+1])}function W5(e,t){var r=0;do r|=e&1,e>>>=1,r<<=1;while(--t>0);return r>>>1}function yae(e){e.bi_valid===16?(um(e,e.bi_buf),e.bi_buf=0,e.bi_valid=0):e.bi_valid>=8&&(e.pending_buf[e.pending++]=e.bi_buf&255,e.bi_buf>>=8,e.bi_valid-=8)}function vae(e,t){var r=t.dyn_tree,n=t.max_code,a=t.stat_desc.static_tree,o=t.stat_desc.has_stree,s=t.stat_desc.extra_bits,c=t.stat_desc.extra_base,u=t.stat_desc.max_length,
l,m,p,f,h,y,v=0;for(f=0;f<=yc;f++)e.bl_count[f]=0;for(r[e.heap[e.heap_max]*2+1]=0,l=e.heap_max+1;l<L5;l++)m=e.heap[l],f=r[r[m*2+1]*2+1]+1,f>u&&(f=u,v++),r[m*2+1]=f,!(m>n)&&(e.bl_count[f]++,h=0,m>=c&&(h=s[m-c]),y=r[m*2],e.opt_len+=y*(f+h),o&&(e.static_len+=y*(a[m*2+1]+h)));if(v!==0){do{for(f=u-1;e.bl_count[f]===0;)f--;e.bl_count[f]--,e.bl_count[f+1]+=2,e.bl_count[u]--,v-=2}while(v>0);for(f=u;f!==0;f--)for(m=e.bl_count[f];m!==0;)p=e.heap[--l],!(p>n)&&(r[p*2+1]!==f&&(e.opt_len+=(f-r[p*2+1])*r[p*2],r[p*2+1]=f),m--)}}function V5(e,t,r){var n=new Array(yc+1),a=0,o,s;for(o=1;o<=yc;o++)n[o]=a=a+r[o-1]<<1;for(s=0;s<=t;s++){var c=e[s*2+1];c!==0&&(e[s*2]=W5(n[c]++,c))}}function bae(){var e,t,r,n,a,o=new Array(yc+1);for(r=0,n=0;n<kw-1;n++)for(Aw[n]=r,e=0;e<1<<Cw[n];e++)cm[r++]=n;for(cm[r-1]=n,a=0,n=0;n<16;n++)for(i1[n]=a,e=0;e<1<<o1[n];e++)sm[a++]=n;for(a>>=7;n<Uu;n++)for(i1[n]=a<<7,e=0;e<1<<o1[n]-7;e++)sm[256+a++]=n;for(t=0;t<=yc;t++)o[t]=0;for(e=0;e<=143;)Qo[e*2+1]=8,e++,o[8]++;for(;e<=255;)Qo[e*
2+1]=9,e++,o[9]++;for(;e<=279;)Qo[e*2+1]=7,e++,o[7]++;for(;e<=287;)Qo[e*2+1]=8,e++,o[8]++;for(V5(Qo,im+1,o),e=0;e<Uu;e++)om[e*2+1]=5,om[e*2]=W5(e,5);q5=new Tw(Qo,Cw,lm+1,im,yc),z5=new Tw(om,o1,0,Uu,yc),H5=new Tw(new Array(0),hae,0,Rw,fae)}function $5(e){var t;for(t=0;t<im;t++)e.dyn_ltree[t*2]=0;for(t=0;t<Uu;t++)e.dyn_dtree[t*2]=0;for(t=0;t<Rw;t++)e.bl_tree[t*2]=0;e.dyn_ltree[_w*2]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0}function Y5(e){e.bi_valid>8?um(e,e.bi_buf):e.bi_valid>0&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0}function wae(e,t,r,n){Y5(e),n&&(um(e,r),um(e,~r)),Bu(e.pending_buf,e.window,t,r,e.pending),e.pending+=r}function _5(e,t,r,n){var a=t*2,o=r*2;return e[a]<e[o]||e[a]===e[o]&&n[t]<=n[r]}function Sw(e,t,r){for(var n=e.heap[r],a=r<<1;a<=e.heap_len&&(a<e.heap_len&&_5(t,e.heap[a+1],e.heap[a],e.depth)&&a++,!_5(t,n,e.heap[a],e.depth));)e.heap[r]=e.heap[a],r=a,a<<=1;e.heap[r]=n}function A5(e,t,r){var n,a,o=0,s,c;if(e.last_lit!==0)do n=e.pending_buf[e.d_buf+
o*2]<<8|e.pending_buf[e.d_buf+o*2+1],a=e.pending_buf[e.l_buf+o],o++,n===0?po(e,a,t):(s=cm[a],po(e,s+lm+1,t),c=Cw[s],c!==0&&(a-=Aw[s],Vn(e,a,c)),n--,s=G5(n),po(e,s,r),c=o1[s],c!==0&&(n-=i1[s],Vn(e,n,c)));while(o<e.last_lit);po(e,_w,t)}function Iw(e,t){var r=t.dyn_tree,n=t.stat_desc.static_tree,a=t.stat_desc.has_stree,o=t.stat_desc.elems,s,c,u=-1,l;for(e.heap_len=0,e.heap_max=L5,s=0;s<o;s++)r[s*2]!==0?(e.heap[++e.heap_len]=u=s,e.depth[s]=0):r[s*2+1]=0;for(;e.heap_len<2;)l=e.heap[++e.heap_len]=u<2?++u:0,r[l*2]=1,e.depth[l]=0,e.opt_len--,a&&(e.static_len-=n[l*2+1]);for(t.max_code=u,s=e.heap_len>>1;s>=1;s--)Sw(e,r,s);l=o;do s=e.heap[1],e.heap[1]=e.heap[e.heap_len--],Sw(e,r,1),c=e.heap[1],e.heap[--e.heap_max]=s,e.heap[--e.heap_max]=c,r[l*2]=r[s*2]+r[c*2],e.depth[l]=(e.depth[s]>=e.depth[c]?e.depth[s]:e.depth[c])+1,r[s*2+1]=r[c*2+1]=l,e.heap[1]=l++,Sw(e,r,1);while(e.heap_len>=2);e.heap[--e.heap_max]=e.heap[1],vae(e,t),V5(r,u,e.bl_count)}function F5(e,t,r){var n,a=-1,o,s=t[1],c=0,u=7,l=4;for(s===
0&&(u=138,l=3),t[(r+1)*2+1]=65535,n=0;n<=r;n++)o=s,s=t[(n+1)*2+1],!(++c<u&&o===s)&&(c<l?e.bl_tree[o*2]+=c:o!==0?(o!==a&&e.bl_tree[o*2]++,e.bl_tree[P5*2]++):c<=10?e.bl_tree[B5*2]++:e.bl_tree[U5*2]++,c=0,a=o,s===0?(u=138,l=3):o===s?(u=6,l=3):(u=7,l=4))}function M5(e,t,r){var n,a=-1,o,s=t[1],c=0,u=7,l=4;for(s===0&&(u=138,l=3),n=0;n<=r;n++)if(o=s,s=t[(n+1)*2+1],!(++c<u&&o===s)){if(c<l)do po(e,o,e.bl_tree);while(--c!==0);else o!==0?(o!==a&&(po(e,o,e.bl_tree),c--),po(e,P5,e.bl_tree),Vn(e,c-3,2)):c<=10?(po(e,B5,e.bl_tree),Vn(e,c-3,3)):(po(e,U5,e.bl_tree),Vn(e,c-11,7));c=0,a=o,s===0?(u=138,l=3):o===s?(u=6,l=3):(u=7,l=4)}}function Eae(e){var t;for(F5(e,e.dyn_ltree,e.l_desc.max_code),F5(e,e.dyn_dtree,e.d_desc.max_code),Iw(e,e.bl_desc),t=Rw-1;t>=3&&e.bl_tree[j5[t]*2+1]===0;t--);return e.opt_len+=3*(t+1)+5+5+4,t}function Dae(e,t,r,n){var a;for(Vn(e,t-257,5),Vn(e,r-1,5),Vn(e,n-4,4),a=0;a<n;a++)Vn(e,e.bl_tree[j5[a]*2+1],3);M5(e,e.dyn_ltree,t-1),M5(e,e.dyn_dtree,r-1)}function Tae(e){var t=4093624447,
r;for(r=0;r<=31;r++,t>>>=1)if(t&1&&e.dyn_ltree[r*2]!==0)return k5;if(e.dyn_ltree[18]!==0||e.dyn_ltree[20]!==0||e.dyn_ltree[26]!==0)return R5;for(r=32;r<lm;r++)if(e.dyn_ltree[r*2]!==0)return R5;return k5}function K5(e){O5||(bae(),O5=!0),e.l_desc=new xw(e.dyn_ltree,q5),e.d_desc=new xw(e.dyn_dtree,z5),e.bl_desc=new xw(e.bl_tree,H5),e.bi_buf=0,e.bi_valid=0,$5(e)}function Fw(e,t,r,n){Vn(e,(lae<<1)+(n?1:0),3),wae(e,t,r,!0)}function J5(e){Vn(e,N5<<1,3),po(e,_w,Qo),yae(e)}function X5(e,t,r,n){var a,o,s=0;e.level>0?(e.strm.data_type===uae&&(e.strm.data_type=Tae(e)),Iw(e,e.l_desc),Iw(e,e.d_desc),s=Eae(e),a=e.opt_len+3+7>>>3,o=e.static_len+3+7>>>3,o<=a&&(a=o)):a=o=r+5,r+4<=a&&t!==-1?Fw(e,t,r,n):e.strategy===cae||o===a?(Vn(e,(N5<<1)+(n?1:0),3),A5(e,Qo,om)):(Vn(e,(dae<<1)+(n?1:0),3),Dae(e,e.l_desc.max_code+1,e.d_desc.max_code+1,s+1),A5(e,e.dyn_ltree,e.dyn_dtree)),$5(e),n&&Y5(e)}function ei(e,t,r){return e.pending_buf[e.d_buf+e.last_lit*2]=t>>>8&255,e.pending_buf[e.d_buf+e.last_lit*2+1]=t&255,e.pending_buf[e.
l_buf+e.last_lit]=r&255,e.last_lit++,t===0?e.dyn_ltree[r*2]++:(e.matches++,t--,e.dyn_ltree[(cm[r]+lm+1)*2]++,e.dyn_dtree[G5(t)*2]++),e.last_lit===e.lit_bufsize-1}var cae,k5,R5,uae,lae,N5,dae,mae,pae,kw,lm,im,Uu,Rw,L5,yc,Dw,fae,_w,P5,B5,U5,Cw,o1,hae,j5,gae,Qo,om,sm,cm,Aw,i1,q5,z5,H5,O5,Z5=g(()=>{"use strict";d();Ew();cae=4,k5=0,R5=1,uae=2;i(ju,"zero");lae=0,N5=1,dae=2,mae=3,pae=258,kw=29,lm=256,im=lm+1+kw,Uu=30,Rw=19,L5=2*im+1,yc=15,Dw=16,fae=7,_w=256,P5=16,B5=17,U5=18,Cw=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],o1=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],hae=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],j5=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],gae=512,Qo=new Array((im+2)*2);ju(Qo);om=new Array(Uu*2);ju(om);sm=new Array(gae);ju(sm);cm=new Array(pae-mae+1);ju(cm);Aw=new Array(kw);ju(Aw);i1=new Array(Uu);ju(i1);i(Tw,"StaticTreeDesc");i(xw,"TreeDesc");i(G5,"d_code");i(um,"put_short");i(Vn,"send_bits");i(po,"send_code");i(W5,"bi_reverse");
i(yae,"bi_flush");i(vae,"gen_bitlen");i(V5,"gen_codes");i(bae,"tr_static_init");i($5,"init_block");i(Y5,"bi_windup");i(wae,"copy_block");i(_5,"smaller");i(Sw,"pqdownheap");i(A5,"compress_block");i(Iw,"build_tree");i(F5,"scan_tree");i(M5,"send_tree");i(Eae,"build_bl_tree");i(Dae,"send_all_trees");i(Tae,"detect_data_type");O5=!1;i(K5,"_tr_init");i(Fw,"_tr_stored_block");i(J5,"_tr_align");i(X5,"_tr_flush_block");i(ei,"_tr_tally")});function xae(e,t,r,n){for(var a=e&65535|0,o=e>>>16&65535|0,s=0;r!==0;){s=r>2e3?2e3:r,r-=s;do a=a+t[n++]|0,o=o+a|0;while(--s);a%=65521,o%=65521}return a|o<<16|0}var Q5,e8=g(()=>{d();i(xae,"adler32");Q5=xae});function Sae(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=e&1?3988292384^e>>>1:e>>>1;t[r]=e}return t}function Iae(e,t,r,n){var a=Cae,o=n+r;e^=-1;for(var s=n;s<o;s++)e=e>>>8^a[(e^t[s])&255];return e^-1}var Cae,ti,t8=g(()=>{d();i(Sae,"makeTable");Cae=Sae();i(Iae,"crc32");ti=Iae});function ns(e,t){return e.msg=a1[t],t}function a8(e){return(e<<1)-(e>4?9:0)}function vc(e){for(var t=e.length;--t>=0;)e[t]=0}function es(e){var t=e.state,r=t.pending;r>e.avail_out&&(r=e.avail_out),r!==0&&(Bu(e.output,t.pending_buf,t.pending_out,r,e.next_out),e.next_out+=r,t.pending_out+=r,e.total_out+=r,e.avail_out-=r,t.pending-=r,t.pending===0&&(t.pending_out=0))}function un(e,t){X5(e,e.block_start>=0?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,es(e.strm)}function zt(e,t){e.pending_buf[e.pending++]=t}function dm(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=t&255}function Wae(e,t,r,n){var a=e.avail_in;return a>n&&(a=n),a===0?0:(e.avail_in-=a,Bu(t,e.input,e.next_in,a,r),e.state.wrap===1?e.adler=Q5(e.adler,t,a,r):e.state.wrap===2&&(e.adler=ti(e.adler,t,a,r)),e.next_in+=a,e.total_in+=a,a)}function o8(e,t){var r=e.max_chain_length,n=e.strstart,a,o,s=e.prev_length,c=e.nice_match,u=e.strstart>e.w_size-za?e.strstart-(e.w_size-za):0,l=e.window,
m=e.w_mask,p=e.prev,f=e.strstart+rs,h=l[n+s-1],y=l[n+s];e.prev_length>=e.good_match&&(r>>=2),c>e.lookahead&&(c=e.lookahead);do if(a=t,!(l[a+s]!==y||l[a+s-1]!==h||l[a]!==l[n]||l[++a]!==l[n+1])){n+=2,a++;do;while(l[++n]===l[++a]&&l[++n]===l[++a]&&l[++n]===l[++a]&&l[++n]===l[++a]&&l[++n]===l[++a]&&l[++n]===l[++a]&&l[++n]===l[++a]&&l[++n]===l[++a]&&n<f);if(o=rs-(f-n),n=f-rs,o>s){if(e.match_start=t,s=o,o>=c)break;h=l[n+s-1],y=l[n+s]}}while((t=p[t&m])>u&&--r!==0);return s<=e.lookahead?s:e.lookahead}function fm(e){var t=e.w_size,r,n,a,o,s;do{if(o=e.window_size-e.lookahead-e.strstart,e.strstart>=t+(t-za)){Bu(e.window,e.window,t,t,0),e.match_start-=t,e.strstart-=t,e.block_start-=t,n=e.hash_size,r=n;do a=e.head[--r],e.head[r]=a>=t?a-t:0;while(--n);n=t,r=n;do a=e.prev[--r],e.prev[r]=a>=t?a-t:0;while(--n);o+=t}if(e.strm.avail_in===0)break;if(n=Wae(e.strm,e.window,e.strstart+e.lookahead,o),e.lookahead+=n,e.lookahead+e.insert>=$t)for(s=e.strstart-e.insert,e.ins_h=e.window[s],e.ins_h=(e.ins_h<<e.hash_shift^
e.window[s+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[s+$t-1])&e.hash_mask,e.prev[s&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=s,s++,e.insert--,!(e.lookahead+e.insert<$t)););}while(e.lookahead<za&&e.strm.avail_in!==0)}function Vae(e,t){var r=65535;for(r>e.pending_buf_size-5&&(r=e.pending_buf_size-5);;){if(e.lookahead<=1){if(fm(e),e.lookahead===0&&t===Ec)return zr;if(e.lookahead===0)break}e.strstart+=e.lookahead,e.lookahead=0;var n=e.block_start+r;if((e.strstart===0||e.strstart>=n)&&(e.lookahead=e.strstart-n,e.strstart=n,un(e,!1),e.strm.avail_out===0)||e.strstart-e.block_start>=e.w_size-za&&(un(e,!1),e.strm.avail_out===0))return zr}return e.insert=0,t===as?(un(e,!0),e.strm.avail_out===0?wc:Hu):(e.strstart>e.block_start&&(un(e,!1),e.strm.avail_out===0),zr)}function Ow(e,t){for(var r,n;;){if(e.lookahead<za){if(fm(e),e.lookahead<za&&t===Ec)return zr;if(e.lookahead===0)break}if(r=0,e.lookahead>=$t&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+$t-1])&e.hash_mask,
r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),r!==0&&e.strstart-r<=e.w_size-za&&(e.match_length=o8(e,r)),e.match_length>=$t)if(n=ei(e,e.strstart-e.match_start,e.match_length-$t),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=$t){e.match_length--;do e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+$t-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart;while(--e.match_length!==0);e.strstart++}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else n=ei(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(n&&(un(e,!1),e.strm.avail_out===0))return zr}return e.insert=e.strstart<$t-1?e.strstart:$t-1,t===as?(un(e,!0),e.strm.avail_out===0?wc:Hu):e.last_lit&&(un(e,!1),e.strm.avail_out===0)?zr:pm}function qu(e,t){for(var r,n,a;;){if(e.lookahead<za){if(fm(e),e.lookahead<za&&t===Ec)return zr;if(e.
lookahead===0)break}if(r=0,e.lookahead>=$t&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+$t-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=$t-1,r!==0&&e.prev_length<e.max_lazy_match&&e.strstart-r<=e.w_size-za&&(e.match_length=o8(e,r),e.match_length<=5&&(e.strategy===Fae||e.match_length===$t&&e.strstart-e.match_start>4096)&&(e.match_length=$t-1)),e.prev_length>=$t&&e.match_length<=e.prev_length){a=e.strstart+e.lookahead-$t,n=ei(e,e.strstart-1-e.prev_match,e.prev_length-$t),e.lookahead-=e.prev_length-1,e.prev_length-=2;do++e.strstart<=a&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+$t-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart);while(--e.prev_length!==0);if(e.match_available=0,e.match_length=$t-1,e.strstart++,n&&(un(e,!1),e.strm.avail_out===0))return zr}else if(e.match_available){if(n=ei(e,0,e.window[e.strstart-1]),n&&
un(e,!1),e.strstart++,e.lookahead--,e.strm.avail_out===0)return zr}else e.match_available=1,e.strstart++,e.lookahead--}return e.match_available&&(n=ei(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<$t-1?e.strstart:$t-1,t===as?(un(e,!0),e.strm.avail_out===0?wc:Hu):e.last_lit&&(un(e,!1),e.strm.avail_out===0)?zr:pm}function $ae(e,t){for(var r,n,a,o,s=e.window;;){if(e.lookahead<=rs){if(fm(e),e.lookahead<=rs&&t===Ec)return zr;if(e.lookahead===0)break}if(e.match_length=0,e.lookahead>=$t&&e.strstart>0&&(a=e.strstart-1,n=s[a],n===s[++a]&&n===s[++a]&&n===s[++a])){o=e.strstart+rs;do;while(n===s[++a]&&n===s[++a]&&n===s[++a]&&n===s[++a]&&n===s[++a]&&n===s[++a]&&n===s[++a]&&n===s[++a]&&a<o);e.match_length=rs-(o-a),e.match_length>e.lookahead&&(e.match_length=e.lookahead)}if(e.match_length>=$t?(r=ei(e,1,e.match_length-$t),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(r=ei(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),r&&(un(e,!1),e.strm.avail_out===
0))return zr}return e.insert=0,t===as?(un(e,!0),e.strm.avail_out===0?wc:Hu):e.last_lit&&(un(e,!1),e.strm.avail_out===0)?zr:pm}function Yae(e,t){for(var r;;){if(e.lookahead===0&&(fm(e),e.lookahead===0)){if(t===Ec)return zr;break}if(e.match_length=0,r=ei(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,r&&(un(e,!1),e.strm.avail_out===0))return zr}return e.insert=0,t===as?(un(e,!0),e.strm.avail_out===0?wc:Hu):e.last_lit&&(un(e,!1),e.strm.avail_out===0)?zr:pm}function fo(e,t,r,n,a){this.good_length=e,this.max_lazy=t,this.nice_length=r,this.max_chain=n,this.func=a}function Kae(e){e.window_size=2*e.w_size,vc(e.head),e.max_lazy_match=zu[e.level].max_lazy,e.good_match=zu[e.level].good_length,e.nice_match=zu[e.level].nice_length,e.max_chain_length=zu[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=$t-1,e.match_available=0,e.ins_h=0}function Jae(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=
0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=Pw,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new Zo(qae*2),this.dyn_dtree=new Zo((2*Uae+1)*2),this.bl_tree=new Zo((2*jae+1)*2),vc(this.dyn_ltree),vc(this.dyn_dtree),vc(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new Zo(zae+1),this.heap=new Zo(2*Nw+1),vc(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new Zo(2*Nw+1),vc(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,
this.insert=0,this.bi_buf=0,this.bi_valid=0}function Xae(e){var t;return!e||!e.state?ns(e,os):(e.total_in=e.total_out=0,e.data_type=Nae,t=e.state,t.pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?Bw:bc,e.adler=t.wrap===2?0:1,t.last_flush=Ec,K5(t),ts)}function Uw(e){var t=Xae(e);return t===ts&&Kae(e.state),t}function i8(e,t,r,n,a,o){if(!e)return os;var s=1;if(t===Aae&&(t=6),n<0?(s=0,n=-n):n>15&&(s=2,n-=16),a<1||a>Lae||r!==Pw||n<8||n>15||t<0||t>9||o<0||o>Oae)return ns(e,os);n===8&&(n=9);var c=new Jae;return e.state=c,c.strm=e,c.wrap=s,c.gzhead=null,c.w_bits=n,c.w_size=1<<c.w_bits,c.w_mask=c.w_size-1,c.hash_bits=a+7,c.hash_size=1<<c.hash_bits,c.hash_mask=c.hash_size-1,c.hash_shift=~~((c.hash_bits+$t-1)/$t),c.window=new ww(c.w_size*2),c.head=new Zo(c.hash_size),c.prev=new Zo(c.w_size),c.lit_bufsize=1<<a+6,c.pending_buf_size=c.lit_bufsize*4,c.pending_buf=new ww(c.pending_buf_size),c.d_buf=1*c.lit_bufsize,c.l_buf=3*c.lit_bufsize,c.level=t,c.strategy=o,c.method=r,Uw(e)}function s8(e,t){
var r,n,a,o;if(!e||!e.state||t>r8||t<0)return e?ns(e,os):os;if(n=e.state,!e.output||!e.input&&e.avail_in!==0||n.status===mm&&t!==as)return ns(e,e.avail_out===0?Mw:os);if(n.strm=e,r=n.last_flush,n.last_flush=t,n.status===Bw)if(n.wrap===2)e.adler=0,zt(n,31),zt(n,139),zt(n,8),n.gzhead?(zt(n,(n.gzhead.text?1:0)+(n.gzhead.hcrc?2:0)+(n.gzhead.extra?4:0)+(n.gzhead.name?8:0)+(n.gzhead.comment?16:0)),zt(n,n.gzhead.time&255),zt(n,n.gzhead.time>>8&255),zt(n,n.gzhead.time>>16&255),zt(n,n.gzhead.time>>24&255),zt(n,n.level===9?2:n.strategy>=s1||n.level<2?4:0),zt(n,n.gzhead.os&255),n.gzhead.extra&&n.gzhead.extra.length&&(zt(n,n.gzhead.extra.length&255),zt(n,n.gzhead.extra.length>>8&255)),n.gzhead.hcrc&&(e.adler=ti(e.adler,n.pending_buf,n.pending,0)),n.gzindex=0,n.status=Lw):(zt(n,0),zt(n,0),zt(n,0),zt(n,0),zt(n,0),zt(n,n.level===9?2:n.strategy>=s1||n.level<2?4:0),zt(n,Gae),n.status=bc);else{var s=Pw+(n.w_bits-8<<4)<<8,c=-1;n.strategy>=s1||n.level<2?c=0:n.level<6?c=1:n.level===6?c=2:c=3,s|=c<<6,n.strstart!==
0&&(s|=Hae),s+=31-s%31,n.status=bc,dm(n,s),n.strstart!==0&&(dm(n,e.adler>>>16),dm(n,e.adler&65535)),e.adler=1}if(n.status===Lw)if(n.gzhead.extra){for(a=n.pending;n.gzindex<(n.gzhead.extra.length&65535)&&!(n.pending===n.pending_buf_size&&(n.gzhead.hcrc&&n.pending>a&&(e.adler=ti(e.adler,n.pending_buf,n.pending-a,a)),es(e),a=n.pending,n.pending===n.pending_buf_size));)zt(n,n.gzhead.extra[n.gzindex]&255),n.gzindex++;n.gzhead.hcrc&&n.pending>a&&(e.adler=ti(e.adler,n.pending_buf,n.pending-a,a)),n.gzindex===n.gzhead.extra.length&&(n.gzindex=0,n.status=c1)}else n.status=c1;if(n.status===c1)if(n.gzhead.name){a=n.pending;do{if(n.pending===n.pending_buf_size&&(n.gzhead.hcrc&&n.pending>a&&(e.adler=ti(e.adler,n.pending_buf,n.pending-a,a)),es(e),a=n.pending,n.pending===n.pending_buf_size)){o=1;break}n.gzindex<n.gzhead.name.length?o=n.gzhead.name.charCodeAt(n.gzindex++)&255:o=0,zt(n,o)}while(o!==0);n.gzhead.hcrc&&n.pending>a&&(e.adler=ti(e.adler,n.pending_buf,n.pending-a,a)),o===0&&(n.gzindex=0,n.status=
u1)}else n.status=u1;if(n.status===u1)if(n.gzhead.comment){a=n.pending;do{if(n.pending===n.pending_buf_size&&(n.gzhead.hcrc&&n.pending>a&&(e.adler=ti(e.adler,n.pending_buf,n.pending-a,a)),es(e),a=n.pending,n.pending===n.pending_buf_size)){o=1;break}n.gzindex<n.gzhead.comment.length?o=n.gzhead.comment.charCodeAt(n.gzindex++)&255:o=0,zt(n,o)}while(o!==0);n.gzhead.hcrc&&n.pending>a&&(e.adler=ti(e.adler,n.pending_buf,n.pending-a,a)),o===0&&(n.status=l1)}else n.status=l1;if(n.status===l1&&(n.gzhead.hcrc?(n.pending+2>n.pending_buf_size&&es(e),n.pending+2<=n.pending_buf_size&&(zt(n,e.adler&255),zt(n,e.adler>>8&255),e.adler=0,n.status=bc)):n.status=bc),n.pending!==0){if(es(e),e.avail_out===0)return n.last_flush=-1,ts}else if(e.avail_in===0&&a8(t)<=a8(r)&&t!==as)return ns(e,Mw);if(n.status===mm&&e.avail_in!==0)return ns(e,Mw);if(e.avail_in!==0||n.lookahead!==0||t!==Ec&&n.status!==mm){var u=n.strategy===s1?Yae(n,t):n.strategy===Mae?$ae(n,t):zu[n.level].func(n,t);if((u===wc||u===Hu)&&(n.status=mm),
u===zr||u===wc)return e.avail_out===0&&(n.last_flush=-1),ts;if(u===pm&&(t===kae?J5(n):t!==r8&&(Fw(n,0,0,!1),t===Rae&&(vc(n.head),n.lookahead===0&&(n.strstart=0,n.block_start=0,n.insert=0))),es(e),e.avail_out===0))return n.last_flush=-1,ts}return t!==as?ts:n.wrap<=0?n8:(n.wrap===2?(zt(n,e.adler&255),zt(n,e.adler>>8&255),zt(n,e.adler>>16&255),zt(n,e.adler>>24&255),zt(n,e.total_in&255),zt(n,e.total_in>>8&255),zt(n,e.total_in>>16&255),zt(n,e.total_in>>24&255)):(dm(n,e.adler>>>16),dm(n,e.adler&65535)),es(e),n.wrap>0&&(n.wrap=-n.wrap),n.pending!==0?ts:n8)}function c8(e){var t;return!e||!e.state?os:(t=e.state.status,t!==Bw&&t!==Lw&&t!==c1&&t!==u1&&t!==l1&&t!==bc&&t!==mm?ns(e,os):(e.state=null,t===bc?ns(e,_ae):ts))}var Ec,kae,Rae,as,r8,ts,n8,os,_ae,Mw,Aae,Fae,s1,Mae,Oae,Nae,Pw,Lae,Pae,Bae,Nw,Uae,jae,qae,zae,$t,rs,za,Hae,Bw,Lw,c1,u1,l1,bc,mm,zr,pm,wc,Hu,Gae,zu,u8=g(()=>{d();Ew();Z5();e8();t8();bw();Ec=0,kae=1,Rae=3,as=4,r8=5,ts=0,n8=1,os=-2,_ae=-3,Mw=-5,Aae=-1,Fae=1,s1=2,Mae=3,Oae=4,Nae=2,Pw=8,
Lae=9,Pae=29,Bae=256,Nw=Bae+1+Pae,Uae=30,jae=19,qae=2*Nw+1,zae=15,$t=3,rs=258,za=rs+$t+1,Hae=32,Bw=42,Lw=69,c1=73,u1=91,l1=103,bc=113,mm=666,zr=1,pm=2,wc=3,Hu=4,Gae=3;i(ns,"err");i(a8,"rank");i(vc,"zero");i(es,"flush_pending");i(un,"flush_block_only");i(zt,"put_byte");i(dm,"putShortMSB");i(Wae,"read_buf");i(o8,"longest_match");i(fm,"fill_window");i(Vae,"deflate_stored");i(Ow,"deflate_fast");i(qu,"deflate_slow");i($ae,"deflate_rle");i(Yae,"deflate_huff");i(fo,"Config");zu=[new fo(0,0,0,0,Vae),new fo(4,4,8,4,Ow),new fo(4,5,16,8,Ow),new fo(4,6,32,32,Ow),new fo(4,4,16,16,qu),new fo(8,16,32,32,qu),new fo(8,16,128,128,qu),new fo(8,32,128,256,qu),new fo(32,128,258,1024,qu),new fo(32,258,258,4096,qu)];i(Kae,"lm_init");i(Jae,"DeflateState");i(Xae,"deflateResetKeep");i(Uw,"deflateReset");i(i8,"deflateInit2");i(s8,"deflate");i(c8,"deflateEnd")});var l8=g(()=>{d()});var h1={};C(h1,{DEFLATE:()=>Wu,DEFLATERAW:()=>Gu,GUNZIP:()=>m1,GZIP:()=>hm,INFLATE:()=>p1,INFLATERAW:()=>gm,NONE:()=>jw,UNZIP:()=>ym,Z_BEST_COMPRESSION:()=>ioe,Z_BEST_SPEED:()=>ooe,Z_BINARY:()=>poe,Z_BLOCK:()=>g8,Z_BUF_ERROR:()=>noe,Z_DATA_ERROR:()=>roe,Z_DEFAULT_COMPRESSION:()=>soe,Z_DEFAULT_STRATEGY:()=>moe,Z_DEFLATED:()=>v8,Z_ERRNO:()=>eoe,Z_FILTERED:()=>coe,Z_FINISH:()=>h8,Z_FIXED:()=>doe,Z_FULL_FLUSH:()=>f8,Z_HUFFMAN_ONLY:()=>uoe,Z_NEED_DICT:()=>Qae,Z_NO_COMPRESSION:()=>aoe,Z_NO_FLUSH:()=>d8,Z_OK:()=>f1,Z_PARTIAL_FLUSH:()=>m8,Z_RLE:()=>loe,Z_STREAM_END:()=>y8,Z_STREAM_ERROR:()=>toe,Z_SYNC_FLUSH:()=>p8,Z_TEXT:()=>foe,Z_TREES:()=>Zae,Z_UNKNOWN:()=>hoe,Zlib:()=>ho});function ho(e){if(e<Wu||e>ym)throw new TypeError("Bad argument");this.mode=e,this.init_done=!1,this.write_in_progress=!1,this.pending_close=!1,this.windowBits=0,this.level=0,this.memLevel=0,this.strategy=0,this.dictionary=null}function goe(e,t){for(var r=0;r<e.length;r++)this[t+r]=e[r]}var jw,Wu,p1,hm,m1,Gu,gm,ym,d8,m8,p8,
f8,h8,g8,Zae,f1,y8,Qae,eoe,toe,roe,noe,aoe,ooe,ioe,soe,coe,uoe,loe,doe,moe,poe,foe,hoe,v8,d1,b8=g(()=>{d();bw();I5();u8();l8();jw=0,Wu=1,p1=2,hm=3,m1=4,Gu=5,gm=6,ym=7,d8=0,m8=1,p8=2,f8=3,h8=4,g8=5,Zae=6,f1=0,y8=1,Qae=2,eoe=-1,toe=-2,roe=-3,noe=-5,aoe=0,ooe=1,ioe=9,soe=-1,coe=1,uoe=2,loe=3,doe=4,moe=0,poe=0,foe=1,hoe=2,v8=8;i(ho,"Zlib");ho.prototype.init=function(e,t,r,n,a){this.windowBits=e,this.level=t,this.memLevel=r,this.strategy=n,(this.mode===hm||this.mode===m1)&&(this.windowBits+=16),this.mode===ym&&(this.windowBits+=32),(this.mode===Gu||this.mode===gm)&&(this.windowBits=-this.windowBits),this.strm=new C5;var o;switch(this.mode){case Wu:case hm:case Gu:o=i8(this.strm,this.level,v8,this.windowBits,this.memLevel,this.strategy);break;case p1:case m1:case gm:case ym:o=(this.strm,this.windowBits,void 0);break;default:throw new Error("Unknown mode "+this.mode)}if(o!==f1){this._error(o);return}this.write_in_progress=!1,this.init_done=!0};ho.prototype.params=function(){throw new Error("d\
eflateParams Not supported")};ho.prototype._writeCheck=function(){if(!this.init_done)throw new Error("write before init");if(this.mode===jw)throw new Error("already finalized");if(this.write_in_progress)throw new Error("write already in progress");if(this.pending_close)throw new Error("close is pending")};ho.prototype.write=function(e,t,r,n,a,o,s){this._writeCheck(),this.write_in_progress=!0;var c=this;return process.nextTick(function(){c.write_in_progress=!1;var u=c._write(e,t,r,n,a,o,s);c.callback(u[0],u[1]),c.pending_close&&c.close()}),this};i(goe,"bufferSet");ho.prototype.writeSync=function(e,t,r,n,a,o,s){return this._writeCheck(),this._write(e,t,r,n,a,o,s)};ho.prototype._write=function(e,t,r,n,a,o,s){if(this.write_in_progress=!0,e!==d8&&e!==m8&&e!==p8&&e!==f8&&e!==h8&&e!==g8)throw new Error("Invalid flush value");t==null&&(t=new Buffer(0),n=0,r=0),a._set?a.set=a._set:a.set=goe;var c=this.strm;c.avail_in=n,c.input=t,c.next_in=r,c.avail_out=s,c.output=a,c.next_out=o;var u;switch(this.
mode){case Wu:case hm:case Gu:u=s8(c,e);break;case ym:case p1:case m1:case gm:u=void 0;break;default:throw new Error("Unknown mode "+this.mode)}return u!==y8&&u!==f1&&this._error(u),this.write_in_progress=!1,[c.avail_in,c.avail_out]};ho.prototype.close=function(){if(this.write_in_progress){this.pending_close=!0;return}this.pending_close=!1,this.mode===Wu||this.mode===hm||this.mode===Gu?c8(this.strm):(this.strm,void 0),this.mode=jw};ho.prototype.reset=function(){switch(this.mode){case Wu:case Gu:d1=Uw(this.strm);break;case p1:case gm:d1=(this.strm,void 0);break}d1!==f1&&this._error(d1)};ho.prototype._error=function(e){this.onerror(a1[e]+": "+this.strm.msg,e),this.write_in_progress=!1,this.pending_close&&this.close()}});function yoe(e,t){if(!e)throw new Error(t)}function w8(e){return new vm(e)}function E8(e,t,r){return typeof t=="function"&&(r=t,t={}),voe(new vm(t),e,r)}function D8(e,t){return boe(new g1(t),e)}function voe(e,t,r){var n=[],a=0;e.on("error",s),e.on("end",c),e.end(t),o();function o(){for(var u;(u=e.read())!==null;)n.push(u),a+=u.length;e.once("readable",o)}i(o,"flow");function s(u){e.removeListener("end",c),e.removeListener("readable",o),r(u)}i(s,"onError");function c(){var u=Buffer.concat(n,a);n=[],r(null,u),e.close()}i(c,"onEnd")}function boe(e,t){if(typeof t=="string"&&(t=new Buffer(t)),!Buffer.isBuffer(t))throw new TypeError("Not a string or buffer");var r=Te.Z_FINISH;return e._processChunk(t,r)}function zw(e){if(!(this instanceof zw))return new zw(e);Cr.call(this,e,Te.DEFLATE)}function Hw(e){if(!(this instanceof Hw))return new Hw(e);Cr.call(this,e,Te.INFLATE)}function vm(e){if(!(this instanceof vm))return new vm(e);Cr.call(this,e,Te.GZIP)}function g1(e){if(!(this instanceof g1))return new g1(
e);Cr.call(this,e,Te.GUNZIP)}function Gw(e){if(!(this instanceof Gw))return new Gw(e);Cr.call(this,e,Te.DEFLATERAW)}function Ww(e){if(!(this instanceof Ww))return new Ww(e);Cr.call(this,e,Te.INFLATERAW)}function Vw(e){if(!(this instanceof Vw))return new Vw(e);Cr.call(this,e,Te.UNZIP)}function Cr(e,t){if(this._opts=e=e||{},this._chunkSize=e.chunkSize||Te.Z_DEFAULT_CHUNK,An.call(this,e),e.flush&&e.flush!==Te.Z_NO_FLUSH&&e.flush!==Te.Z_PARTIAL_FLUSH&&e.flush!==Te.Z_SYNC_FLUSH&&e.flush!==Te.Z_FULL_FLUSH&&e.flush!==Te.Z_FINISH&&e.flush!==Te.Z_BLOCK)throw new Error("Invalid flush flag: "+e.flush);if(this._flushFlag=e.flush||Te.Z_NO_FLUSH,e.chunkSize&&(e.chunkSize<Te.Z_MIN_CHUNK||e.chunkSize>Te.Z_MAX_CHUNK))throw new Error("Invalid chunk size: "+e.chunkSize);if(e.windowBits&&(e.windowBits<Te.Z_MIN_WINDOWBITS||e.windowBits>Te.Z_MAX_WINDOWBITS))throw new Error("Invalid windowBits: "+e.windowBits);if(e.level&&(e.level<Te.Z_MIN_LEVEL||e.level>Te.Z_MAX_LEVEL))throw new Error("Invalid compression l\
evel: "+e.level);if(e.memLevel&&(e.memLevel<Te.Z_MIN_MEMLEVEL||e.memLevel>Te.Z_MAX_MEMLEVEL))throw new Error("Invalid memLevel: "+e.memLevel);if(e.strategy&&e.strategy!=Te.Z_FILTERED&&e.strategy!=Te.Z_HUFFMAN_ONLY&&e.strategy!=Te.Z_RLE&&e.strategy!=Te.Z_FIXED&&e.strategy!=Te.Z_DEFAULT_STRATEGY)throw new Error("Invalid strategy: "+e.strategy);if(e.dictionary&&!Buffer.isBuffer(e.dictionary))throw new Error("Invalid dictionary: it should be a Buffer instance");this._binding=new Te.Zlib(t);var r=this;this._hadError=!1,this._binding.onerror=function(o,s){r._binding=null,r._hadError=!0;var c=new Error(o);c.errno=s,c.code=Te.codes[s],r.emit("error",c)};var n=Te.Z_DEFAULT_COMPRESSION;typeof e.level=="number"&&(n=e.level);var a=Te.Z_DEFAULT_STRATEGY;typeof e.strategy=="number"&&(a=e.strategy),this._binding.init(e.windowBits||Te.Z_DEFAULT_WINDOWBITS,n,e.memLevel||Te.Z_DEFAULT_MEMLEVEL,a,e.dictionary),this._buffer=new Buffer(this._chunkSize),this._offset=0,this._closed=!1,this._level=n,this._strategy=
a,this.once("end",this.close)}var Te,qw,$w=g(()=>{d();vw();b8();Qi();i(yoe,"assert");Te={};Object.keys(h1).forEach(function(e){Te[e]=h1[e]});Te.Z_MIN_WINDOWBITS=8;Te.Z_MAX_WINDOWBITS=15;Te.Z_DEFAULT_WINDOWBITS=15;Te.Z_MIN_CHUNK=64;Te.Z_MAX_CHUNK=1/0;Te.Z_DEFAULT_CHUNK=16*1024;Te.Z_MIN_MEMLEVEL=1;Te.Z_MAX_MEMLEVEL=9;Te.Z_DEFAULT_MEMLEVEL=8;Te.Z_MIN_LEVEL=-1;Te.Z_MAX_LEVEL=9;Te.Z_DEFAULT_LEVEL=Te.Z_DEFAULT_COMPRESSION;qw={Z_OK:Te.Z_OK,Z_STREAM_END:Te.Z_STREAM_END,Z_NEED_DICT:Te.Z_NEED_DICT,Z_ERRNO:Te.Z_ERRNO,Z_STREAM_ERROR:Te.Z_STREAM_ERROR,Z_DATA_ERROR:Te.Z_DATA_ERROR,Z_MEM_ERROR:Te.Z_MEM_ERROR,Z_BUF_ERROR:Te.Z_BUF_ERROR,Z_VERSION_ERROR:Te.Z_VERSION_ERROR};Object.keys(qw).forEach(function(e){qw[qw[e]]=e});i(w8,"createGzip");i(E8,"gzip");i(D8,"gunzipSync");i(voe,"zlibBuffer");i(boe,"zlibBufferSync");i(zw,"Deflate");i(Hw,"Inflate");i(vm,"Gzip");i(g1,"Gunzip");i(Gw,"DeflateRaw");i(Ww,"InflateRaw");i(Vw,"Unzip");i(Cr,"Zlib");Sr(Cr,An);Cr.prototype.params=function(e,t,r){if(e<Te.Z_MIN_LEVEL||
e>Te.Z_MAX_LEVEL)throw new RangeError("Invalid compression level: "+e);if(t!=Te.Z_FILTERED&&t!=Te.Z_HUFFMAN_ONLY&&t!=Te.Z_RLE&&t!=Te.Z_FIXED&&t!=Te.Z_DEFAULT_STRATEGY)throw new TypeError("Invalid strategy: "+t);if(this._level!==e||this._strategy!==t){var n=this;this.flush(Te.Z_SYNC_FLUSH,function(){n._binding.params(e,t),n._hadError||(n._level=e,n._strategy=t,r&&r())})}else process.nextTick(r)};Cr.prototype.reset=function(){return this._binding.reset()};Cr.prototype._flush=function(e){this._transform(new Buffer(0),"",e)};Cr.prototype.flush=function(e,t){var r=this._writableState;if((typeof e=="function"||e===void 0&&!t)&&(t=e,e=Te.Z_FULL_FLUSH),r.ended)t&&process.nextTick(t);else if(r.ending)t&&this.once("end",t);else if(r.needDrain){var n=this;this.once("drain",function(){n.flush(t)})}else this._flushFlag=e,this.write(new Buffer(0),"",t)};Cr.prototype.close=function(e){if(e&&process.nextTick(e),!this._closed){this._closed=!0,this._binding.close();var t=this;process.nextTick(function(){
t.emit("close")})}};Cr.prototype._transform=function(e,t,r){var n,a=this._writableState,o=a.ending||a.ended,s=o&&(!e||a.length===e.length);if(!e===null&&!Buffer.isBuffer(e))return r(new Error("invalid input"));s?n=Te.Z_FINISH:(n=this._flushFlag,e.length>=a.length&&(this._flushFlag=this._opts.flush||Te.Z_NO_FLUSH)),this._processChunk(e,n,r)};Cr.prototype._processChunk=function(e,t,r){var n=e&&e.length,a=this._chunkSize-this._offset,o=0,s=this,c=typeof r=="function";if(!c){var u=[],l=0,m;this.on("error",function(v){m=v});do var p=this._binding.writeSync(t,e,o,n,this._buffer,this._offset,a);while(!this._hadError&&y(p[0],p[1]));if(this._hadError)throw m;var f=Buffer.concat(u,l);return this.close(),f}var h=this._binding.write(t,e,o,n,this._buffer,this._offset,a);h.buffer=e,h.callback=y;function y(v,E){if(!s._hadError){var T=a-E;if(yoe(T>=0,"have should not go down"),T>0){var x=s._buffer.slice(s._offset,s._offset+T);s._offset+=T,c?s.push(x):(u.push(x),l+=x.length)}if((E===0||s._offset>=s._chunkSize)&&
(a=s._chunkSize,s._offset=0,s._buffer=new Buffer(s._chunkSize)),E===0){if(o+=n-v,n=v,!c)return!0;var S=s._binding.write(t,e,o,n,s._buffer,s._offset,s._chunkSize);S.callback=y,S.buffer=e;return}if(!c)return!1;r()}}i(y,"callback")};Sr(zw,Cr);Sr(Hw,Cr);Sr(vm,Cr);Sr(g1,Cr);Sr(Gw,Cr);Sr(Ww,Cr);Sr(Vw,Cr)});var ve,Yw=g(()=>{d();ve=class extends Error{static{i(this,"LanternError")}}});var y1,T8,woe,Eoe,ri,x8=g(()=>{d();Yw();y1=class{static{i(this,"UrlUtils")}static rewriteChromeInternalUrl(t){return t?.startsWith("chrome://")?(t.endsWith("/")&&(t=t.replace(/\/$/,"")),t.replace(/^chrome:\/\/chrome\//,"chrome://")):t}static equalWithExcludedFragments(t,r){[t,r]=[t,r].map(this.rewriteChromeInternalUrl);try{let n=new URL(t);n.hash="";let a=new URL(r);return a.hash="",n.href===a.href}catch{return!1}}},T8=14*1024,woe=.4,Eoe={Document:.9,XHR:.9,Fetch:.9},ri=class e{static{i(this,"NetworkAnalyzer")}static get summary(){return"__SUMMARY__"}static groupByOrigin(t){let r=new Map;return t.forEach(n=>{let a=n.parsedURL.securityOrigin,o=r.get(a)||[];o.push(n),r.set(a,o)}),r}static getSummary(t){t.sort((n,a)=>n-a);let r;if(t.length===0)r=t[0];else if(t.length%2===0){let n=t[Math.floor((t.length-1)/2)],a=t[Math.floor((t.length-1)/2)+1];r=(n+a)/2}else r=t[Math.floor((t.length-1)/2)];return{min:t[0],max:t[t.length-1],avg:t.reduce((n,a)=>n+a,0)/t.length,median:r}}static summarize(t){let r=new Map,
n=[];for(let[a,o]of t)r.set(a,e.getSummary(o)),n.push(...o);return r.set(e.summary,e.getSummary(n)),r}static estimateValueByOrigin(t,r){let n=e.estimateIfConnectionWasReused(t),a=e.groupByOrigin(t),o=new Map;for(let[s,c]of a.entries()){let u=[];for(let l of c){let m=l.timing;if(!m)continue;let p=r({request:l,timing:m,connectionReused:n.get(l.requestId)});typeof p<"u"&&(u=u.concat(p))}u.length&&o.set(s,u)}return o}static estimateRTTViaConnectionTiming(t){let{timing:r,connectionReused:n,request:a}=t;if(n)return;let{connectStart:o,sslStart:s,sslEnd:c,connectEnd:u}=r;if(u>=0&&o>=0&&a.protocol.startsWith("h3"))return u-o;if(s>=0&&c>=0&&s!==o)return[u-s,s-o];if(o>=0&&u>=0)return u-o}static estimateRTTViaDownloadTiming(t){let{timing:r,connectionReused:n,request:a}=t;if(n||a.transferSize<=T8||!Number.isFinite(r.receiveHeadersEnd)||r.receiveHeadersEnd<0)return;let s=a.networkEndTime-a.networkRequestTime-r.receiveHeadersEnd,c=Math.log2(a.transferSize/T8);if(!(c>5))return s/c}static estimateRTTViaSendStartTiming(t){
let{timing:r,connectionReused:n,request:a}=t;if(n||!Number.isFinite(r.sendStart)||r.sendStart<0)return;let o=1;return a.protocol.startsWith("h3")||(o+=1),a.parsedURL.scheme==="https"&&(o+=1),r.sendStart/o}static estimateRTTViaHeadersEndTiming(t){let{timing:r,connectionReused:n,request:a}=t;if(!Number.isFinite(r.receiveHeadersEnd)||r.receiveHeadersEnd<0||!a.resourceType)return;let o=Eoe[a.resourceType]||woe,s=r.receiveHeadersEnd*o,c=1;return n||(c+=1,a.protocol.startsWith("h3")||(c+=1),a.parsedURL.scheme==="https"&&(c+=1)),Math.max((r.receiveHeadersEnd-s)/c,3)}static estimateResponseTimeByOrigin(t,r){return e.estimateValueByOrigin(t,({request:n,timing:a})=>{if(n.serverResponseTime!==void 0)return n.serverResponseTime;if(!Number.isFinite(a.receiveHeadersEnd)||a.receiveHeadersEnd<0||!Number.isFinite(a.sendEnd)||a.sendEnd<0)return;let o=a.receiveHeadersEnd-a.sendEnd,s=n.parsedURL.securityOrigin,c=r.get(s)||r.get(e.summary)||0;return Math.max(o-c,0)})}static canTrustConnectionInformation(t){
let r=new Map;for(let n of t){let a=r.get(n.connectionId)||!n.connectionReused;r.set(n.connectionId,a)}return r.size<=1?!1:Array.from(r.values()).every(n=>n)}static estimateIfConnectionWasReused(t,r){let{forceCoarseEstimates:n=!1}=r||{};if(!n&&e.canTrustConnectionInformation(t))return new Map(t.map(s=>[s.requestId,!!s.connectionReused]));let a=new Map,o=e.groupByOrigin(t);for(let s of o.values()){let c=s.map(l=>l.networkEndTime).reduce((l,m)=>Math.min(l,m),1/0);for(let l of s)a.set(l.requestId,l.networkRequestTime>=c||l.protocol==="h2");let u=s.reduce((l,m)=>l.networkRequestTime>m.networkRequestTime?m:l);a.set(u.requestId,!1)}return a}static estimateRTTByOrigin(t,r){let{forceCoarseEstimates:n=!1,coarseEstimateMultiplier:a=.3,useDownloadEstimates:o=!0,useSendStartEstimates:s=!0,useHeadersEndEstimates:c=!0}=r||{},u=e.estimateIfConnectionWasReused(t),l=e.groupByOrigin(t),m=new Map;for(let[p,f]of l.entries()){let y=function(v,E=1){for(let T of f){let x=T.timing;if(!x||!T.transferSize)continue;
let S=v({request:T,timing:x,connectionReused:u.get(T.requestId)});S!==void 0&&(Array.isArray(S)?h.push(...S.map(I=>I*E)):h.push(S*E))}};i(y,"collectEstimates");let h=[];n||y(this.estimateRTTViaConnectionTiming),h.length||(o&&y(this.estimateRTTViaDownloadTiming,a),s&&y(this.estimateRTTViaSendStartTiming,a),c&&y(this.estimateRTTViaHeadersEndTiming,a)),h.length&&m.set(p,h)}if(!m.size)throw new ve("No timing information available");return e.summarize(m)}static estimateServerResponseTimeByOrigin(t,r){let n=r?.rttByOrigin;if(!n){n=new Map;let o=e.estimateRTTByOrigin(t,r);for(let[s,c]of o.entries())n.set(s,c.min)}let a=e.estimateResponseTimeByOrigin(t,n);return e.summarize(a)}static estimateThroughput(t){let r=0,n=t.reduce((c,u)=>(u.parsedURL?.scheme==="data"||u.failed||!u.finished||u.statusCode>300||!u.transferSize||(r+=u.transferSize,c.push({time:u.responseHeadersEndTime/1e3,isStart:!0}),c.push({time:u.networkEndTime/1e3,isStart:!1})),c),[]).sort((c,u)=>c.time-u.time);if(!n.length)return null;
let a=0,o=0,s=0;return n.forEach(c=>{c.isStart?(a===0&&(o=c.time),a++):(a--,a===0&&(s+=c.time-o))}),r*8/s}static computeRTTAndServerResponseTime(t){let r=new Map;for(let[c,u]of e.estimateRTTByOrigin(t).entries())r.set(c,u.min);let n=Math.min(...Array.from(r.values())),a=e.estimateServerResponseTimeByOrigin(t,{rttByOrigin:r}),o=new Map,s=new Map;for(let[c,u]of a.entries()){let l=r.get(c)||n;o.set(c,l-n),s.set(c,u.median)}return{rtt:n,additionalRttByOrigin:o,serverResponseTimeByOrigin:s}}static analyze(t){let r=e.estimateThroughput(t);return r===null?null:{throughput:r,...e.computeRTTAndServerResponseTime(t)}}static findResourceForUrl(t,r){return t.find(n=>r.startsWith(n.url)&&y1.equalWithExcludedFragments(n.url,r))}static findLastDocumentForUrl(t,r){let n=t.filter(a=>a.resourceType==="Document"&&!a.failed&&r.startsWith(a.url)&&y1.equalWithExcludedFragments(a.url,r));return n[n.length-1]}static resolveRedirects(t){for(;t.redirectDestination;)t=t.redirectDestination;return t}}});var Ht={};C(Ht,{LanternError:()=>ve,NetworkAnalyzer:()=>ri});var sa=g(()=>{d();Yw();x8()});var Ft,v1=g(()=>{d();sa();Ft=class e{static{i(this,"BaseNode")}static types={NETWORK:"network",CPU:"cpu"};_id;_isMainDocument;dependents;dependencies;constructor(t){this._id=t,this._isMainDocument=!1,this.dependents=[],this.dependencies=[]}get id(){return this._id}get type(){throw new ve("Unimplemented")}get startTime(){throw new ve("Unimplemented")}get endTime(){throw new ve("Unimplemented")}setIsMainDocument(t){this._isMainDocument=t}isMainDocument(){return this._isMainDocument}getDependents(){return this.dependents.slice()}getNumberOfDependents(){return this.dependents.length}getDependencies(){return this.dependencies.slice()}getNumberOfDependencies(){return this.dependencies.length}getRootNode(){let t=this;for(;t.dependencies.length;)t=t.dependencies[0];return t}addDependent(t){t.addDependency(this)}addDependency(t){if(t===this)throw new ve("Cannot add dependency on itself");this.dependencies.includes(t)||(t.dependents.push(this),this.dependencies.push(t))}removeDependent(t){t.removeDependency(
this)}removeDependency(t){if(!this.dependencies.includes(t))return;let r=t.dependents.indexOf(this);t.dependents.splice(r,1),this.dependencies.splice(this.dependencies.indexOf(t),1)}removeAllDependencies(){for(let t of this.dependencies.slice())this.removeDependency(t)}isDependentOn(t){let r=!1;return this.traverse(n=>{r||(r=n===t)},n=>r?[]:n.getDependencies()),r}cloneWithoutRelationships(){let t=new e(this.id);return t.setIsMainDocument(this._isMainDocument),t}cloneWithRelationships(t){let r=this.getRootNode(),n=new Map;r.traverse(o=>{if(!n.has(o.id)){if(t===void 0){n.set(o.id,o.cloneWithoutRelationships());return}t(o)&&o.traverse(s=>n.set(s.id,s.cloneWithoutRelationships()),s=>s.dependencies.filter(c=>!n.has(c.id)))}}),r.traverse(o=>{let s=n.get(o.id);if(s)for(let c of o.dependencies){let u=n.get(c.id);if(!u)throw new ve("Dependency somehow not cloned");s.addDependency(u)}});let a=n.get(this.id);if(!a)throw new ve("Cloned graph missing node");return a}traverse(t,r){for(let{node:n,traversalPath:a}of this.
traverseGenerator(r))t(n,a)}*traverseGenerator(t){t||(t=i(a=>a.getDependents(),"getNextNodes"));let r=[[this]],n=new Set([this.id]);for(;r.length;){let a=r.shift(),o=a[0];yield{node:o,traversalPath:a};for(let s of t(o))n.has(s.id)||(n.add(s.id),r.push([s,...a]))}}static findCycle(t,r="both"){if(r==="both")return e.findCycle(t,"dependents")||e.findCycle(t,"dependencies");let n=new Set,a=[],o=[t],s=new Map([[t,0]]);for(;o.length;){let c=o.pop();if(a.includes(c))return a;if(n.has(c))continue;for(;a.length>s.get(c);)a.pop();n.add(c),a.push(c);let u=r==="dependents"?c.dependents:c.dependencies;for(let l of u)o.includes(l)||(o.push(l),s.set(l,a.length))}return null}canDependOn(t){return t.startTime<=this.startTime}}});var bm,Kw=g(()=>{d();v1();bm=class e extends Ft{static{i(this,"CPUNode")}_event;_childEvents;correctedEndTs;constructor(t,r=[],n){let a=`${t.tid}.${t.ts}`;super(a),this._event=t,this._childEvents=r,this.correctedEndTs=n}get type(){return Ft.types.CPU}get startTime(){return this._event.ts}get endTime(){return this.correctedEndTs?this.correctedEndTs:this._event.ts+this._event.dur}get duration(){return this.endTime-this.startTime}get event(){return this._event}get childEvents(){return this._childEvents}didPerformLayout(){return this._childEvents.some(t=>t.name==="Layout")}getEvaluateScriptURLs(){let t=new Set;for(let r of this._childEvents)r.name==="EvaluateScript"&&r.args.data?.url&&t.add(r.args.data.url);return t}cloneWithoutRelationships(){return new e(this._event,this._childEvents,this.correctedEndTs)}}});function S8(e){let t=e.includes(":")?e.slice(0,e.indexOf(":")):e;return Doe.includes(t)}var Doe,Dc,Jw=g(()=>{d();v1();Doe=["blob","data","intent","file","filesystem","chrome-extension"];i(S8,"isNonNetworkProtocol");Dc=class e extends Ft{static{i(this,"NetworkNode")}_request;constructor(t){super(t.requestId),this._request=t}get type(){return Ft.types.NETWORK}get startTime(){return this._request.rendererStartTime*1e3}get endTime(){return this._request.networkEndTime*1e3}get rawRequest(){return this._request.rawRequest}get request(){return this._request}get initiatorType(){return this._request.initiator.type}get fromDiskCache(){return!!this._request.fromDiskCache}get isNonNetworkProtocol(){return S8(this.request.protocol)||S8(this.request.parsedURL.scheme)}get isConnectionless(){return this.fromDiskCache||this.isNonNetworkProtocol}hasRenderBlockingPriority(){let t=this._request.priority,r=this._request.resourceType==="Script",n=this._request.resourceType==="Document";return t==="VeryHigh"||
t==="High"&&r||t==="High"&&n}cloneWithoutRelationships(){let t=new e(this._request);return t.setIsMainDocument(this._isMainDocument),t}}});var Toe,xoe,Soe,Coe,Ioe,koe,Xw,C8=g(()=>{d();sa();Kw();Jw();Toe="RunTask",xoe="ThreadControllerImpl::RunTask",Soe="ThreadControllerImpl::DoWork",Coe="TaskQueueManager::ProcessTaskFromWorkQueue",Ioe=10,koe=/^video/,Xw=class e{static{i(this,"PageDependencyGraph")}static getNetworkInitiators(t){if(!t.initiator)return[];if(t.initiator.url)return[t.initiator.url];if(t.initiator.type==="script"){let r=new Set,n=t.initiator.stack;for(;n;){let a=n.callFrames||[];for(let o of a)o.url&&r.add(o.url);n=n.parent}return Array.from(r)}return[]}static getNetworkNodeOutput(t){let r=[],n=new Map,a=new Map,o=new Map;return t.forEach(s=>{if(koe.test(s.mimeType)||s.fromWorker)return;for(;n.has(s.requestId);)s.requestId+=":duplicate";let c=new Dc(s);r.push(c);let u=a.get(s.url)||[];if(u.push(c),n.set(s.requestId,c),a.set(s.url,u),s.frameId&&s.resourceType==="Document"&&s.documentURL===s.url){let l=o.has(s.frameId)?null:c;o.set(s.frameId,l)}}),{nodes:r,idToNodeMap:n,urlToNodeMap:a,frameIdToNodeMap:o}}static isScheduleableTask(t){
return t.name===Toe||t.name===xoe||t.name===Soe||t.name===Coe}static assertHasToplevelEvents(t){if(!t.some(this.isScheduleableTask))throw new ve("Could not find any top level events")}static getCPUNodes(t){let r=[],n=0;for(e.assertHasToplevelEvents(t);n<t.length;){let a=t[n];if(n++,!e.isScheduleableTask(a)||!a.dur)continue;let o,s=[];for(let c=a.ts+a.dur;n<t.length&&t[n].ts<c;n++){let u=t[n];if(e.isScheduleableTask(u)&&u.dur){o=u.ts-1;break}s.push(u)}r.push(new bm(a,s,o))}return r}static linkNetworkNodes(t,r){r.nodes.forEach(n=>{let a=n.request.initiatorRequest||t.request,o=r.idToNodeMap.get(a.requestId)||t,s=!o.isDependentOn(n)&&n.canDependOn(o),c=e.getNetworkInitiators(n.request);if(c.length?c.forEach(l=>{let m=r.urlToNodeMap.get(l)||[];m.length===1&&m[0].startTime<=n.startTime&&!m[0].isDependentOn(n)?n.addDependency(m[0]):s&&o.addDependent(n)}):s&&o.addDependent(n),n!==t&&n.getDependencies().length===0&&n.canDependOn(t)&&n.addDependency(t),!n.request.redirects)return;let u=[...n.request.
redirects,n.request];for(let l=1;l<u.length;l++){let m=r.idToNodeMap.get(u[l-1].requestId),p=r.idToNodeMap.get(u[l].requestId);p&&m&&p.addDependency(m)}})}static linkCPUNodes(t,r,n){let a=new Set(["XHR","Fetch","Script"]);function o(h,y){let v=r.idToNodeMap.get(y);if(!v||v.startTime<=h.startTime)return;let{request:E}=v,T=E.resourceType||E.redirectDestination?.resourceType;a.has(T)&&h.addDependent(v)}i(o,"addDependentNetworkRequest");function s(h,y){if(!y)return;let v=r.frameIdToNodeMap.get(y);v&&(v.startTime>=h.startTime||h.addDependency(v))}i(s,"addDependencyOnFrame");function c(h,y){if(!y)return;let v=-100*1e3,E=r.urlToNodeMap.get(y)||[],T=null,x=1/0;for(let S of E){if(h.startTime<=S.startTime)return;let I=h.startTime-S.endTime;I>=v&&I<x&&(T=S,x=I)}T&&h.addDependency(T)}i(c,"addDependencyOnUrl");let u=new Map;for(let h of n){for(let y of h.childEvents){if(!y.args.data)continue;let v=y.args.data.url,E=(y.args.data.stackTrace||[]).map(T=>T.url).filter(Boolean);switch(y.name){case"Timer\
Install":u.set(y.args.data.timerId,h),E.forEach(T=>c(h,T));break;case"TimerFire":{let T=u.get(y.args.data.timerId);if(!T||T.endTime>h.startTime)break;T.addDependent(h);break}case"InvalidateLayout":case"ScheduleStyleRecalculation":s(h,y.args.data.frame),E.forEach(T=>c(h,T));break;case"EvaluateScript":s(h,y.args.data.frame),c(h,v),E.forEach(T=>c(h,T));break;case"XHRReadyStateChange":if(y.args.data.readyState!==4)break;c(h,v),E.forEach(T=>c(h,T));break;case"FunctionCall":case"v8.compile":s(h,y.args.data.frame),c(h,v);break;case"ParseAuthorStyleSheet":s(h,y.args.data.frame),c(h,y.args.data.styleSheetUrl);break;case"ResourceSendRequest":s(h,y.args.data.frame),o(h,y.args.data.requestId),E.forEach(T=>c(h,T));break}}h.getNumberOfDependencies()===0&&h.canDependOn(t)&&h.addDependency(t)}let l=Ioe*1e3,m=!1,p=!1,f=!1;for(let h of n){let y=!1;!m&&h.childEvents.some(v=>v.name==="Layout")&&(y=m=!0),!p&&h.childEvents.some(v=>v.name==="Paint")&&(y=p=!0),!f&&h.childEvents.some(v=>v.name==="ParseHTML")&&
(y=f=!0),!(y||h.duration>=l)&&(h.getNumberOfDependencies()===1||h.getNumberOfDependents()<=1)&&e.pruneNode(h)}}static pruneNode(t){let r=t.getDependencies(),n=t.getDependents();for(let a of r){t.removeDependency(a);for(let o of n)a.addDependent(o)}for(let a of n)t.removeDependent(a)}static debugNormalizeRequests(t){for(let a of t)a.rendererStartTime=Math.round(a.rendererStartTime*1e3)/1e3,a.networkRequestTime=Math.round(a.networkRequestTime*1e3)/1e3,a.responseHeadersEndTime=Math.round(a.responseHeadersEndTime*1e3)/1e3,a.networkEndTime=Math.round(a.networkEndTime*1e3)/1e3;for(let a of t)delete a.rawRequest,a.initiatorRequest&&(a.initiatorRequest={id:a.initiatorRequest.requestId}),a.redirectDestination&&(a.redirectDestination={id:a.redirectDestination.requestId}),a.redirectSource&&(a.redirectSource={id:a.redirectSource.requestId}),a.redirects&&(a.redirects=a.redirects.map(o=>o.requestId));let n=t.map(a=>({requestId:a.requestId,connectionId:a.connectionId,connectionReused:a.connectionReused,
url:a.url,protocol:a.protocol,parsedURL:a.parsedURL,documentURL:a.documentURL,rendererStartTime:a.rendererStartTime,networkRequestTime:a.networkRequestTime,responseHeadersEndTime:a.responseHeadersEndTime,networkEndTime:a.networkEndTime,transferSize:a.transferSize,resourceSize:a.resourceSize,fromDiskCache:a.fromDiskCache,fromMemoryCache:a.fromMemoryCache,finished:a.finished,statusCode:a.statusCode,redirectSource:a.redirectSource,redirectDestination:a.redirectDestination,redirects:a.redirects,failed:a.failed,initiator:a.initiator,timing:a.timing?{requestTime:a.timing.requestTime,proxyStart:a.timing.proxyStart,proxyEnd:a.timing.proxyEnd,dnsStart:a.timing.dnsStart,dnsEnd:a.timing.dnsEnd,connectStart:a.timing.connectStart,connectEnd:a.timing.connectEnd,sslStart:a.timing.sslStart,sslEnd:a.timing.sslEnd,workerStart:a.timing.workerStart,workerReady:a.timing.workerReady,workerFetchStart:a.timing.workerFetchStart,workerRespondWithSettled:a.timing.workerRespondWithSettled,sendStart:a.timing.sendStart,
sendEnd:a.timing.sendEnd,pushStart:a.timing.pushStart,pushEnd:a.timing.pushEnd,receiveHeadersStart:a.timing.receiveHeadersStart,receiveHeadersEnd:a.timing.receiveHeadersEnd}:a.timing,resourceType:a.resourceType,mimeType:a.mimeType,priority:a.priority,initiatorRequest:a.initiatorRequest,frameId:a.frameId,fromWorker:a.fromWorker,isLinkPreload:a.isLinkPreload,serverResponseTime:a.serverResponseTime})).filter(a=>!a.fromWorker);console.log(n)}static createGraph(t,r,n){let a=e.getNetworkNodeOutput(r),o=e.getCPUNodes(t),{requestedUrl:s,mainDocumentUrl:c}=n;if(!s)throw new ve("requestedUrl is required to get the root request");if(!c)throw new ve("mainDocumentUrl is required to get the main resource");let u=ri.findResourceForUrl(r,s);if(!u)throw new ve("rootRequest not found");let l=a.idToNodeMap.get(u.requestId);if(!l)throw new ve("rootNode not found");let m=ri.findLastDocumentForUrl(r,c);if(!m)throw new ve("mainDocumentRequest not found");let p=a.idToNodeMap.get(m.requestId);if(!p)throw new ve(
"mainDocumentNode not found");if(e.linkNetworkNodes(l,a),e.linkCPUNodes(l,a,o),p.setIsMainDocument(!0),Dc.findCycle(l))throw new ve("Invalid dependency graph created, cycle detected");return l}static printGraph(t,r=80){function n(p,f,h=" "){return p+h.repeat(Math.max(f-p.length,0))}i(n,"padRight");let a=[];t.traverse(p=>a.push(p)),a.sort((p,f)=>p.startTime-f.startTime);let o=new Map;t.traverse(p=>{let f=65+o.size,h;f>90?h=`Z${f-90}`:h=String.fromCharCode(f),o.set(p,h)});let s=a[0].startTime,l=(a.reduce((p,f)=>Math.max(p,f.endTime),0)-s)/r;a.forEach(p=>{let f=Math.round((p.startTime-s)/l),h=Math.ceil((p.endTime-p.startTime)/l),y=n("",f)+n("",h,"="),v=p.request?p.request.url:p.type;console.log(n(y,r),`| ${v.slice(0,50)}`)}),console.log(),a.forEach(p=>{let f=p.request?p.request.url:p.type;console.log(o.get(p),f.slice(0,r-5));for(let h of p.dependents){let y=h.request?h.request.url:h.type;console.log("  ->",o.get(h),y.slice(0,r-10))}console.log()});let m=Dc.findCycle(t);if(console.log("Cyc\
le?",m?"yes":"no"),m){let p=[...m];p.push(p[0]),console.log(p.map(f=>o.get(f)).join(" -> "))}}}});var Lr={};C(Lr,{BaseNode:()=>Ft,CPUNode:()=>bm,NetworkNode:()=>Dc,PageDependencyGraph:()=>Xw});var go=g(()=>{d();v1();Kw();Jw();C8()});var wn,is=g(()=>{d();sa();go();wn=class{static{i(this,"Metric")}static getScriptUrls(t,r){let n=new Set;return t.traverse(a=>{a.type===Ft.types.NETWORK&&a.request.resourceType==="Script"&&r?.(a)&&n.add(a.request.url)}),n}static get coefficients(){throw new ve("coefficients unimplemented!")}static getScaledCoefficients(t){return this.coefficients}static getOptimisticGraph(t,r){throw new ve("Optimistic graph unimplemented!")}static getPessimisticGraph(t,r){throw new ve("Pessmistic graph unimplemented!")}static getEstimateFromSimulation(t,r){return t}static compute(t,r){let{simulator:n,graph:a,processedNavigation:o}=t,s=this.name.replace("Lantern",""),c=this.getOptimisticGraph(a,o),u=this.getPessimisticGraph(a,o),l={label:`optimistic${s}`},m=n.simulate(c,l);l={label:`pessimistic${s}`};let p=n.simulate(u,l),f=this.getEstimateFromSimulation(m,{...r,optimistic:!0}),h=this.getEstimateFromSimulation(p,{...r,optimistic:!1}),y=this.getScaledCoefficients(n.rtt),v=y.intercept>0?Math.min(1,f.timeInMs/
1e3):1;return{timing:y.intercept*v+y.optimistic*f.timeInMs+y.pessimistic*h.timeInMs,optimisticEstimate:f,pessimisticEstimate:h,optimisticGraph:c,pessimisticGraph:u}}}});var Vu,Zw=g(()=>{d();go();is();Vu=class extends wn{static{i(this,"FirstContentfulPaint")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getRenderBlockingNodeData(t,{cutoffTimestamp:r,treatNodeAsRenderBlocking:n,additionalCpuNodesToTreatAsRenderBlocking:a}){let o=new Map,s=[];t.traverse(h=>{if(h.type===Ft.types.CPU){h.startTime<=r&&s.push(h);let y=h.getEvaluateScriptURLs();for(let v of y){let E=o.get(v)||h;o.set(v,h.startTime<E.startTime?h:E)}}}),s.sort((h,y)=>h.startTime-y.startTime);let c=wn.getScriptUrls(t,h=>h.endTime<=r&&n(h)),u=new Set,l=new Set;for(let h of c){let y=o.get(h);if(y){if(s.includes(y)){l.add(y.id);continue}u.add(h)}}let m=s.find(h=>h.didPerformLayout());m&&l.add(m.id);let p=s.find(h=>h.childEvents.some(y=>y.name==="Paint"));p&&l.add(p.id);let f=s.find(h=>h.childEvents.some(y=>y.name==="ParseHTML"));return f&&l.add(f.id),a&&s.filter(a).forEach(h=>l.add(h.id)),{definitelyNotRenderBlockingScriptUrls:u,renderBlockingCpuNodeIds:l}}static getFirstPaintBasedGraph(t,{
cutoffTimestamp:r,treatNodeAsRenderBlocking:n,additionalCpuNodesToTreatAsRenderBlocking:a}){let o=this.getRenderBlockingNodeData(t,{cutoffTimestamp:r,treatNodeAsRenderBlocking:n,additionalCpuNodesToTreatAsRenderBlocking:a}),{definitelyNotRenderBlockingScriptUrls:s,renderBlockingCpuNodeIds:c}=o;return t.cloneWithRelationships(u=>{if(u.type===Ft.types.NETWORK){if((u.endTime>r||u.startTime>r)&&!u.isMainDocument())return!1;let m=u.request.url;return s.has(m)?!1:n(u)}return c.has(u.id)})}static getOptimisticGraph(t,r){return this.getFirstPaintBasedGraph(t,{cutoffTimestamp:r.timestamps.firstContentfulPaint,treatNodeAsRenderBlocking:i(n=>n.hasRenderBlockingPriority()&&n.initiatorType!=="script","treatNodeAsRenderBlocking")})}static getPessimisticGraph(t,r){return this.getFirstPaintBasedGraph(t,{cutoffTimestamp:r.timestamps.firstContentfulPaint,treatNodeAsRenderBlocking:i(n=>n.hasRenderBlockingPriority(),"treatNodeAsRenderBlocking")})}}});var Roe,Qw,I8=g(()=>{d();sa();go();is();Roe=20,Qw=class e extends wn{static{i(this,"Interactive")}static get coefficients(){return{intercept:0,optimistic:.45,pessimistic:.55}}static getOptimisticGraph(t){let r=Roe*1e3;return t.cloneWithRelationships(n=>{if(n.type===Ft.types.CPU)return n.duration>r;let a=n.request.resourceType==="Image",o=n.request.resourceType==="Script";return!a&&(o||n.request.priority==="High"||n.request.priority==="VeryHigh")})}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,r){if(!r.lcpResult)throw new ve("missing lcpResult");let n=e.getLastLongTaskEndTime(t.nodeTimings),a=r.optimistic?r.lcpResult.optimisticEstimate.timeInMs:r.lcpResult.pessimisticEstimate.timeInMs;return{timeInMs:Math.max(a,n),nodeTimings:t.nodeTimings}}static compute(t,r){let n=r?.lcpResult;if(!n)throw new ve("LCP is required to calculate the Interactive metric");let a=super.compute(t,r);return a.timing=Math.max(a.timing,n.timing),a}static getLastLongTaskEndTime(t,r=50){
return Array.from(t.entries()).filter(([n,a])=>n.type!==Ft.types.CPU?!1:a.duration>r).map(([n,a])=>a.endTime).reduce((n,a)=>Math.max(n||0,a||0),0)}}});var eE,k8=g(()=>{d();sa();Zw();is();eE=class e extends wn{static{i(this,"LargestContentfulPaint")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static isNotLowPriorityImageNode(t){if(t.type!=="network")return!0;let r=t.request.resourceType==="Image",n=t.request.priority==="Low"||t.request.priority==="VeryLow";return!r||!n}static getOptimisticGraph(t,r){let n=r.timestamps.largestContentfulPaint;if(!n)throw new ve("NO_LCP");return Vu.getFirstPaintBasedGraph(t,{cutoffTimestamp:n,treatNodeAsRenderBlocking:e.isNotLowPriorityImageNode})}static getPessimisticGraph(t,r){let n=r.timestamps.largestContentfulPaint;if(!n)throw new ve("NO_LCP");return Vu.getFirstPaintBasedGraph(t,{cutoffTimestamp:n,treatNodeAsRenderBlocking:i(a=>!0,"treatNodeAsRenderBlocking"),additionalCpuNodesToTreatAsRenderBlocking:i(a=>a.didPerformLayout(),"additionalCpuNodesToTreatAsRenderBlocking")})}static getEstimateFromSimulation(t){let r=Array.from(t.nodeTimings.entries()).filter(n=>e.isNotLowPriorityImageNode(
n[0])).map(n=>n[1].endTime);return{timeInMs:Math.max(...r),nodeTimings:t.nodeTimings}}static compute(t,r){let n=r?.fcpResult;if(!n)throw new ve("FCP is required to calculate the LCP metric");let a=super.compute(t,r);return a.timing=Math.max(a.timing,n.timing),a}}});var tE,R8=g(()=>{d();sa();go();is();tE=class e extends wn{static{i(this,"MaxPotentialFID")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,r){if(!r.fcpResult)throw new ve("missing fcpResult");let n=r.optimistic?r.fcpResult.pessimisticEstimate.timeInMs:r.fcpResult.optimisticEstimate.timeInMs,a=e.getTimingsAfterFCP(t.nodeTimings,n);return{timeInMs:Math.max(...a.map(o=>o.duration),16),nodeTimings:t.nodeTimings}}static compute(t,r){if(!r?.fcpResult)throw new ve("FCP is required to calculate the Max Potential FID metric");return super.compute(t,r)}static getTimingsAfterFCP(t,r){return Array.from(t.entries()).filter(([n,a])=>n.type===Ft.types.CPU&&a.endTime>r).map(([n,a])=>a)}}});var _oe,rE,_8=g(()=>{d();sa();go();is();_oe=150,rE=class e extends wn{static{i(this,"SpeedIndex")}static get coefficients(){return{intercept:0,optimistic:1.4,pessimistic:.4}}static getScaledCoefficients(t){let r=this.coefficients,n=_oe-30,a=Math.max((t-30)/n,0);return{intercept:r.intercept*a,optimistic:.5+(r.optimistic-.5)*a,pessimistic:.5+(r.pessimistic-.5)*a}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,r){if(!r.fcpResult)throw new ve("missing fcpResult");if(r.observedSpeedIndex===void 0)throw new ve("missing observedSpeedIndex");let n=r.fcpResult.pessimisticEstimate.timeInMs;return{timeInMs:r.optimistic?r.observedSpeedIndex:e.computeLayoutBasedSpeedIndex(t.nodeTimings,n),nodeTimings:t.nodeTimings}}static compute(t,r){let n=r?.fcpResult;if(!n)throw new ve("FCP is required to calculate the SpeedIndex metric");let a=super.compute(t,r);return a.timing=Math.max(a.timing,n.timing),a}static computeLayoutBasedSpeedIndex(t,r){
let n=[];for(let[s,c]of t.entries())if(s.type===Ft.types.CPU&&s.childEvents.some(u=>u.name==="Layout")){let u=Math.max(Math.log2(c.endTime-c.startTime),0);n.push({time:c.endTime,weight:u})}let a=n.map(s=>s.weight*Math.max(s.time,r)).reduce((s,c)=>s+c,0),o=n.map(s=>s.weight).reduce((s,c)=>s+c,0);return o?a/o:r}}});var oE={};C(oE,{BLOCKING_TIME_THRESHOLD:()=>nE,calculateSumOfBlockingTime:()=>aE,calculateTbtImpactForEvent:()=>A8});function A8(e,t,r,n){let a=50;if(n&&(a*=e.duration/n.duration),e.duration<a||e.end<t||e.start>r)return 0;let o=Math.max(e.start,t),c=Math.min(e.end,r)-o;return c<a?0:c-a}function aE(e,t,r){if(r<=t)return 0;let n=0;for(let a of e)n+=A8(a,t,r);return n}var nE,iE=g(()=>{d();nE=50;i(A8,"calculateTbtImpactForEvent");i(aE,"calculateSumOfBlockingTime")});var sE,F8=g(()=>{d();sa();go();is();iE();sE=class e extends wn{static{i(this,"TotalBlockingTime")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,r){if(!r.fcpResult)throw new ve("missing fcpResult");if(!r.interactiveResult)throw new ve("missing interactiveResult");let n=r.optimistic?r.fcpResult.pessimisticEstimate.timeInMs:r.fcpResult.optimisticEstimate.timeInMs,a=r.optimistic?r.interactiveResult.optimisticEstimate.timeInMs:r.interactiveResult.pessimisticEstimate.timeInMs,o=50,s=e.getTopLevelEvents(t.nodeTimings,o);return{timeInMs:aE(s,n,a),nodeTimings:t.nodeTimings}}static compute(t,r){if(!r?.fcpResult)throw new ve("FCP is required to calculate the TBT metric");if(!r?.fcpResult)throw new ve("Interactive is required to calculate the TBT metric");return super.compute(t,r)}static getTopLevelEvents(t,r){let n=[];for(let[a,o]of t.entries())a.type===Ft.types.
CPU&&(o.duration<r||n.push({start:o.startTime,end:o.endTime,duration:o.duration}));return n}}});var vr={};C(vr,{FirstContentfulPaint:()=>Vu,Interactive:()=>Qw,LargestContentfulPaint:()=>eE,MaxPotentialFID:()=>tE,Metric:()=>wn,SpeedIndex:()=>rE,TBTUtils:()=>oE,TotalBlockingTime:()=>sE});var M8=g(()=>{d();Zw();I8();k8();R8();is();_8();F8();iE()});var Tc,b1=g(()=>{d();Tc=class e{static{i(this,"TCPConnection")}warmed;ssl;h2;rtt;throughput;serverLatency;_congestionWindow;h2OverflowBytesDownloaded;constructor(t,r,n=0,a=!0,o=!1){this.warmed=!1,this.ssl=a,this.h2=o,this.rtt=t,this.throughput=r,this.serverLatency=n,this._congestionWindow=10,this.h2OverflowBytesDownloaded=0}static maximumSaturatedConnections(t,r){let s=1e3/t*1460*8;return Math.floor(r/s)}computeMaximumCongestionWindowInSegments(){let t=this.throughput/8,r=this.rtt/1e3,n=t*r;return Math.floor(n/1460)}setThroughput(t){this.throughput=t}setCongestionWindow(t){this._congestionWindow=t}setWarmed(t){this.warmed=t}isH2(){return this.h2}get congestionWindow(){return this._congestionWindow}setH2OverflowBytesDownloaded(t){this.h2&&(this.h2OverflowBytesDownloaded=t)}clone(){return Object.assign(new e(this.rtt,this.throughput),this)}simulateDownloadUntil(t,r){let{timeAlreadyElapsed:n=0,maximumTimeToElapse:a=1/0,dnsResolutionTime:o=0}=r||{};this.warmed&&this.h2&&(t-=this.h2OverflowBytesDownloaded);
let s=this.rtt,c=s/2,u=this.computeMaximumCongestionWindowInSegments(),l=c;this.warmed||(l=o+c+c+c+(this.ssl?s:0));let m=Math.ceil(l/s),p=l+this.serverLatency+c;this.warmed&&this.h2&&(p=0);let f=Math.max(p-n,0),h=a-f,y=Math.min(this._congestionWindow,u),v=0;f>0?v=y*1460:m=0;let E=0,T=t-v;for(;T>0&&E<=h;){m++,E+=s,y=Math.max(Math.min(u,y*2),1);let W=y*1460;v+=W,T-=W}let x=f+E,S=this.h2?Math.max(v-t,0):0,I=Math.max(Math.min(v,t),0),F;return this.warmed?this.h2?F={timeToFirstByte:p}:F={connectionTime:l,timeToFirstByte:p}:F={dnsResolutionTime:o,connectionTime:l-o,sslTime:this.ssl?s:void 0,timeToFirstByte:p},{roundTrips:m,timeElapsed:x,bytesDownloaded:I,extraBytesDownloaded:S,congestionWindow:y,connectionTiming:F}}}});var Aoe,Foe,Moe,wm,cE=g(()=>{d();sa();b1();Aoe=30,Foe=["https","wss"],Moe=6,wm=class{static{i(this,"ConnectionPool")}options;records;connectionsByOrigin;connectionsByRequest;_connectionsInUse;connectionReusedByRequestId;constructor(t,r){this.options=r,this.records=t,this.connectionsByOrigin=new Map,this.connectionsByRequest=new Map,this._connectionsInUse=new Set,this.connectionReusedByRequestId=ri.estimateIfConnectionWasReused(t,{forceCoarseEstimates:!0}),this.initializeConnections()}connectionsInUse(){return Array.from(this._connectionsInUse)}initializeConnections(){let t=this.connectionReusedByRequestId,r=this.options.additionalRttByOrigin,n=this.options.serverResponseTimeByOrigin,a=ri.groupByOrigin(this.records);for(let[o,s]of a.entries()){let c=[],u=r.get(o)||0,l=n.get(o)||Aoe;for(let p of s){if(t.get(p.requestId))continue;let f=Foe.includes(p.parsedURL.scheme),h=p.protocol==="h2",y=new Tc(this.options.rtt+u,this.options.throughput,l,f,h);c.push(y)}if(!c.length)throw new ve(`Could \
not find a connection for origin: ${o}`);let m=c[0].isH2()?1:Moe;for(;c.length<m;)c.push(c[0].clone());this.connectionsByOrigin.set(o,c)}}findAvailableConnectionWithLargestCongestionWindow(t){let r=null;for(let n=0;n<t.length;n++){let a=t[n];if(this._connectionsInUse.has(a))continue;let o=r?.congestionWindow||-1/0;a.congestionWindow>o&&(r=a)}return r}acquire(t){if(this.connectionsByRequest.has(t))throw new ve("Record already has a connection");let r=t.parsedURL.securityOrigin,n=this.connectionsByOrigin.get(r)||[],a=this.findAvailableConnectionWithLargestCongestionWindow(n);return a?(this._connectionsInUse.add(a),this.connectionsByRequest.set(t,a),a):null}acquireActiveConnectionFromRequest(t){let r=this.connectionsByRequest.get(t);if(!r)throw new ve("Could not find an active connection for request");return r}release(t){let r=this.connectionsByRequest.get(t);this.connectionsByRequest.delete(t),r&&this._connectionsInUse.delete(r)}}});var Ooe,Em,uE=g(()=>{d();Ooe={DEVTOOLS_RTT_ADJUSTMENT_FACTOR:3.75,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR:.9,mobileSlow4G:{rttMs:150,throughputKbps:1638.4,requestLatencyMs:562.5,downloadThroughputKbps:1474.5600000000002,uploadThroughputKbps:675,cpuSlowdownMultiplier:4},mobileRegular3G:{rttMs:300,throughputKbps:700,requestLatencyMs:1125,downloadThroughputKbps:630,uploadThroughputKbps:630,cpuSlowdownMultiplier:4},desktopDense4G:{rttMs:40,throughputKbps:10240,cpuSlowdownMultiplier:1,requestLatencyMs:0,downloadThroughputKbps:0,uploadThroughputKbps:0}},Em={throttling:Ooe}});var $u,lE=g(()=>{d();$u=class e{static{i(this,"DNSCache")}static rttMultiplier=2;rtt;resolvedDomainNames;constructor({rtt:t}){this.rtt=t,this.resolvedDomainNames=new Map}getTimeUntilResolution(t,r){let{requestedAt:n=0,shouldUpdateCache:a=!1}=r||{},o=t.parsedURL.host,s=this.resolvedDomainNames.get(o),c=this.rtt*e.rttMultiplier;if(s){let l=Math.max(s.resolvedAt-n,0);c=Math.min(l,c)}let u=n+c;return a&&this.updateCacheResolvedAtIfNeeded(t,u),c}updateCacheResolvedAtIfNeeded(t,r){let n=t.parsedURL.host,a=this.resolvedDomainNames.get(n)||{resolvedAt:r};a.resolvedAt=Math.min(a.resolvedAt,r),this.resolvedDomainNames.set(n,a)}setResolvedAt(t,r){this.resolvedDomainNames.set(t,{resolvedAt:r})}}});var Yu,dE=g(()=>{d();sa();go();Yu=class{static{i(this,"SimulatorTimingMap")}nodeTimings;constructor(){this.nodeTimings=new Map}getNodes(){return Array.from(this.nodeTimings.keys())}setReadyToStart(t,r){this.nodeTimings.set(t,r)}setInProgress(t,r){let n={...this.getQueued(t),startTime:r.startTime,timeElapsed:0};this.nodeTimings.set(t,t.type===Ft.types.NETWORK?{...n,timeElapsedOvershoot:0,bytesDownloaded:0}:n)}setCompleted(t,r){let n={...this.getInProgress(t),endTime:r.endTime,connectionTiming:r.connectionTiming};this.nodeTimings.set(t,n)}setCpu(t,r){let n={...this.getCpuStarted(t),timeElapsed:r.timeElapsed};this.nodeTimings.set(t,n)}setCpuEstimated(t,r){let n={...this.getCpuStarted(t),estimatedTimeElapsed:r.estimatedTimeElapsed};this.nodeTimings.set(t,n)}setNetwork(t,r){let n={...this.getNetworkStarted(t),timeElapsed:r.timeElapsed,timeElapsedOvershoot:r.timeElapsedOvershoot,bytesDownloaded:r.bytesDownloaded};this.nodeTimings.set(t,n)}setNetworkEstimated(t,r){let n={...this.getNetworkStarted(
t),estimatedTimeElapsed:r.estimatedTimeElapsed};this.nodeTimings.set(t,n)}getQueued(t){let r=this.nodeTimings.get(t);if(!r)throw new ve(`Node ${t.id} not yet queued`);return r}getCpuStarted(t){let r=this.nodeTimings.get(t);if(!r)throw new ve(`Node ${t.id} not yet queued`);if(!("startTime"in r))throw new ve(`Node ${t.id} not yet started`);if("bytesDownloaded"in r)throw new ve(`Node ${t.id} timing not valid`);return r}getNetworkStarted(t){let r=this.nodeTimings.get(t);if(!r)throw new ve(`Node ${t.id} not yet queued`);if(!("startTime"in r))throw new ve(`Node ${t.id} not yet started`);if(!("bytesDownloaded"in r))throw new ve(`Node ${t.id} timing not valid`);return r}getInProgress(t){let r=this.nodeTimings.get(t);if(!r)throw new ve(`Node ${t.id} not yet queued`);if(!("startTime"in r))throw new ve(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in r))throw new ve(`Node ${t.id} not yet in progress`);return r}getCompleted(t){let r=this.nodeTimings.get(t);if(!r)throw new ve(`Node ${t.
id} not yet queued`);if(!("startTime"in r))throw new ve(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in r))throw new ve(`Node ${t.id} not yet in progress`);if(!("endTime"in r))throw new ve(`Node ${t.id} not yet completed`);return r}}});var mE,Noe,Loe,Poe,ba,Boe,O8,pE,N8=g(()=>{d();sa();go();cE();uE();lE();dE();b1();mE=Em.throttling.mobileSlow4G,Noe=10,Loe=.5,Poe=1e4,ba={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3},Boe={VeryHigh:0,High:.25,Medium:.5,Low:1,VeryLow:2},O8=new Map,pE=class e{static{i(this,"Simulator")}static createSimulator(t){let{throttlingMethod:r,throttling:n,precomputedLanternData:a,networkAnalysis:o}=t,s={additionalRttByOrigin:o.additionalRttByOrigin,serverResponseTimeByOrigin:o.serverResponseTimeByOrigin,observedThroughput:o.throughput};switch(a&&(s.additionalRttByOrigin=new Map(Object.entries(a.additionalRttByOrigin)),s.serverResponseTimeByOrigin=new Map(Object.entries(a.serverResponseTimeByOrigin))),r){case"provided":s.rtt=o.rtt,s.throughput=o.throughput,s.cpuSlowdownMultiplier=1,s.layoutTaskMultiplier=1;break;case"devtools":n&&(s.rtt=n.requestLatencyMs/Em.throttling.DEVTOOLS_RTT_ADJUSTMENT_FACTOR,s.throughput=n.downloadThroughputKbps*1024/Em.throttling.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR),
s.cpuSlowdownMultiplier=1,s.layoutTaskMultiplier=1;break;case"simulate":n&&(s.rtt=n.rttMs,s.throughput=n.throughputKbps*1024,s.cpuSlowdownMultiplier=n.cpuSlowdownMultiplier);break;default:break}return new e(s)}options;_rtt;throughput;maximumConcurrentRequests;cpuSlowdownMultiplier;layoutTaskMultiplier;cachedNodeListByStartPosition;nodeTimings;numberInProgressByType;nodes;dns;connectionPool;constructor(t){if(this.options=Object.assign({rtt:mE.rttMs,throughput:mE.throughputKbps*1024,maximumConcurrentRequests:Noe,cpuSlowdownMultiplier:mE.cpuSlowdownMultiplier,layoutTaskMultiplier:Loe,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map},t),this._rtt=this.options.rtt,this.throughput=this.options.throughput,this.maximumConcurrentRequests=Math.max(Math.min(Tc.maximumSaturatedConnections(this._rtt,this.throughput),this.options.maximumConcurrentRequests),1),this.cpuSlowdownMultiplier=this.options.cpuSlowdownMultiplier,this.layoutTaskMultiplier=this.cpuSlowdownMultiplier*this.options.
layoutTaskMultiplier,this.cachedNodeListByStartPosition=[],this.nodeTimings=new Yu,this.numberInProgressByType=new Map,this.nodes={},this.dns=new $u({rtt:this._rtt}),this.connectionPool=null,!Number.isFinite(this._rtt))throw new ve(`Invalid rtt ${this._rtt}`);if(!Number.isFinite(this.throughput))throw new ve(`Invalid throughput ${this.throughput}`)}get rtt(){return this._rtt}initializeConnectionPool(t){let r=[];t.getRootNode().traverse(n=>{n.type===Ft.types.NETWORK&&r.push(n.request)}),this.connectionPool=new wm(r,this.options)}initializeAuxiliaryData(){this.nodeTimings=new Yu,this.numberInProgressByType=new Map,this.nodes={},this.cachedNodeListByStartPosition=[];for(let t of Object.values(ba))this.nodes[t]=new Set}numberInProgress(t){return this.numberInProgressByType.get(t)||0}markNodeAsReadyToStart(t,r){let n=e.computeNodeStartPosition(t),a=this.cachedNodeListByStartPosition.findIndex(s=>e.computeNodeStartPosition(s)>n),o=a===-1?this.cachedNodeListByStartPosition.length:a;this.cachedNodeListByStartPosition.
splice(o,0,t),this.nodes[ba.ReadyToStart].add(t),this.nodes[ba.NotReadyToStart].delete(t),this.nodeTimings.setReadyToStart(t,{queuedTime:r})}markNodeAsInProgress(t,r){let n=this.cachedNodeListByStartPosition.indexOf(t);this.cachedNodeListByStartPosition.splice(n,1),this.nodes[ba.InProgress].add(t),this.nodes[ba.ReadyToStart].delete(t),this.numberInProgressByType.set(t.type,this.numberInProgress(t.type)+1),this.nodeTimings.setInProgress(t,{startTime:r})}markNodeAsComplete(t,r,n){this.nodes[ba.Complete].add(t),this.nodes[ba.InProgress].delete(t),this.numberInProgressByType.set(t.type,this.numberInProgress(t.type)-1),this.nodeTimings.setCompleted(t,{endTime:r,connectionTiming:n});for(let a of t.getDependents())a.getDependencies().some(s=>!this.nodes[ba.Complete].has(s))||this.markNodeAsReadyToStart(a,r)}acquireConnection(t){return this.connectionPool.acquire(t)}getNodesSortedByStartPosition(){return Array.from(this.cachedNodeListByStartPosition)}startNodeIfPossible(t,r){if(t.type===Ft.types.
CPU){this.numberInProgress(t.type)===0&&this.markNodeAsInProgress(t,r);return}if(t.type!==Ft.types.NETWORK)throw new ve("Unsupported");!t.isConnectionless&&(this.numberInProgress(t.type)>=this.maximumConcurrentRequests||!this.acquireConnection(t.request))||this.markNodeAsInProgress(t,r)}updateNetworkCapacity(){let t=this.numberInProgress(Ft.types.NETWORK);if(t!==0)for(let r of this.connectionPool.connectionsInUse())r.setThroughput(this.throughput/t)}estimateTimeRemaining(t){if(t.type===Ft.types.CPU)return this.estimateCPUTimeRemaining(t);if(t.type===Ft.types.NETWORK)return this.estimateNetworkTimeRemaining(t);throw new ve("Unsupported")}estimateCPUTimeRemaining(t){let r=this.nodeTimings.getCpuStarted(t),n=t.didPerformLayout()?this.layoutTaskMultiplier:this.cpuSlowdownMultiplier,o=Math.min(Math.round(t.duration/1e3*n),Poe)-r.timeElapsed;return this.nodeTimings.setCpuEstimated(t,{estimatedTimeElapsed:o}),o}estimateNetworkTimeRemaining(t){let r=t.request,n=this.nodeTimings.getNetworkStarted(
t),a=0;if(t.fromDiskCache)a=8+20*((r.resourceSize||0)/1024/1024)-n.timeElapsed;else if(t.isNonNetworkProtocol)a=2+10*((r.resourceSize||0)/1024/1024)-n.timeElapsed;else{let s=this.connectionPool.acquireActiveConnectionFromRequest(r),c=this.dns.getTimeUntilResolution(r,{requestedAt:n.startTime,shouldUpdateCache:!0}),u=n.timeElapsed;a=s.simulateDownloadUntil(r.transferSize-n.bytesDownloaded,{timeAlreadyElapsed:u,dnsResolutionTime:c,maximumTimeToElapse:1/0}).timeElapsed}let o=a+n.timeElapsedOvershoot;return this.nodeTimings.setNetworkEstimated(t,{estimatedTimeElapsed:o}),o}findNextNodeCompletionTime(){let t=1/0;for(let r of this.nodes[ba.InProgress])t=Math.min(t,this.estimateTimeRemaining(r));return t}updateProgressMadeInTimePeriod(t,r,n){let a=this.nodeTimings.getInProgress(t),o=a.estimatedTimeElapsed===r;if(t.type===Ft.types.CPU||t.isConnectionless){o?this.markNodeAsComplete(t,n):a.timeElapsed+=r;return}if(t.type!==Ft.types.NETWORK)throw new ve("Unsupported");if(!("bytesDownloaded"in a))
throw new ve("Invalid timing data");let s=t.request,c=this.connectionPool.acquireActiveConnectionFromRequest(s),u=this.dns.getTimeUntilResolution(s,{requestedAt:a.startTime,shouldUpdateCache:!0}),l=c.simulateDownloadUntil(s.transferSize-a.bytesDownloaded,{dnsResolutionTime:u,timeAlreadyElapsed:a.timeElapsed,maximumTimeToElapse:r-a.timeElapsedOvershoot});c.setCongestionWindow(l.congestionWindow),c.setH2OverflowBytesDownloaded(l.extraBytesDownloaded),o?(c.setWarmed(!0),this.connectionPool.release(s),this.markNodeAsComplete(t,n,l.connectionTiming)):(a.timeElapsed+=l.timeElapsed,a.timeElapsedOvershoot+=l.timeElapsed-r,a.bytesDownloaded+=l.bytesDownloaded)}computeFinalNodeTimings(){let t=this.nodeTimings.getNodes().map(n=>[n,this.nodeTimings.getCompleted(n)]);t.sort((n,a)=>n[1].startTime-a[1].startTime);let r=t.map(([n,a])=>[n,{startTime:a.startTime,endTime:a.endTime,duration:a.endTime-a.startTime}]);return{nodeTimings:new Map(r),completeNodeTimings:new Map(t)}}getOptions(){return this.options}simulate(t,r){
if(Ft.findCycle(t))throw new ve("Cannot simulate graph with cycle");r=Object.assign({label:void 0},r),this.dns=new $u({rtt:this._rtt}),this.initializeConnectionPool(t),this.initializeAuxiliaryData();let n=this.nodes[ba.NotReadyToStart],a=this.nodes[ba.ReadyToStart],o=this.nodes[ba.InProgress],s=t.getRootNode();s.traverse(p=>n.add(p));let c=0,u=0;for(this.markNodeAsReadyToStart(s,c);a.size||o.size;){for(let f of this.getNodesSortedByStartPosition())this.startNodeIfPossible(f,c);if(!o.size)throw new ve("Failed to start a node");this.updateNetworkCapacity();let p=this.findNextNodeCompletionTime();if(c+=p,!Number.isFinite(p)||u>1e5)throw new ve("Simulation failed, depth exceeded");u++;for(let f of o)this.updateProgressMadeInTimePeriod(f,p,c)}let{nodeTimings:l,completeNodeTimings:m}=this.computeFinalNodeTimings();return O8.set(r.label||"unlabeled",m),{timeInMs:c,nodeTimings:l}}computeWastedMsFromWastedBytes(t){let{throughput:r,observedThroughput:n}=this.options,a=r===0?n:r;if(a===0)return 0;
let s=t*8/a*1e3;return Math.round(s/10)*10}static get allNodeTimings(){return O8}static computeNodeStartPosition(t){return t.type==="cpu"?t.startTime:t.startTime+(Boe[t.request.priority]*1e3*1e3||0)}}});var ni={};C(ni,{ConnectionPool:()=>wm,Constants:()=>Em,DNSCache:()=>$u,Simulator:()=>pE,SimulatorTimingMap:()=>Yu,TCPConnection:()=>Tc});var L8=g(()=>{d();cE();uE();lE();dE();N8();b1()});var Uoe,P8=g(()=>{d();Uoe={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch",FedCM:"FedCM"}});var Dm={};C(Dm,{NetworkRequestTypes:()=>Uoe});var B8=g(()=>{d();P8()});var Tm=g(()=>{d();sa();go();M8();L8();B8()});var G8=je((XPe,H8)=>{d();var U8=/:\/\/(\S*?)(:\d+)?(\/|$)/,j8=/([a-z0-9.-]+\.[a-z0-9]+|localhost)/i,joe=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,qoe=/[^.]+\.([^.]+|(gov|com|co|ne)\.\w{2})$/i;function q8(e){return typeof e!="string"||e.length>1e4||e.startsWith("data:")?null:U8.test(e)?e.match(U8)[1]:j8.test(e)?e.match(j8)[0]:null}i(q8,"getDomainFromOriginOrURL");function hE(e){let t=q8(e);if(!t)return null;if(joe.test(t))return t;let r=t.match(qoe);return r&&r[0]||t}i(hE,"getRootDomain");function zoe(e,t){return e.length<=t.length?e:e.split(".").slice(1).join(".")}i(zoe,"sliceSubdomainFromDomain");function z8(e,t,r,n){let a=q8(n),o=hE(a);if(!(!a||!o)){if(e.has(a))return e.get(a);for(let s=a;s.length>o.length;s=zoe(s,o))if(t.has(s))return t.get(s);if(r.has(o))return r.get(o)}}i(z8,"getEntityInDataset");function Hoe(e,t,r,n){let a=z8(e,t,r,n),o=a&&a.products;if(o&&typeof n=="string"){for(let s of o)for(let c of s.urlPatterns)if(c instanceof RegExp&&c.test(n)||typeof c=="string"&&n.includes(
c))return s}}i(Hoe,"getProductInDataset");function Goe(e){return e.map(t=>{let r={company:t.name,categories:[t.category],...t},n=(t.products||[]).map(a=>({company:r.company,category:r.category,categories:[r.category],facades:[],...a,urlPatterns:(a.urlPatterns||[]).map(o=>o.startsWith("REGEXP:")?new RegExp(o.slice(7)):o)}));return r.products=n,r})}i(Goe,"cloneEntities");function Woe(e){let t=Goe(e),r=new Map,n=new Map,a=new Map;for(let c of t){c.totalExecutionTime=Number(c.totalExecutionTime)||0,c.totalOccurrences=Number(c.totalOccurrences)||0,c.averageExecutionTime=c.totalExecutionTime/c.totalOccurrences;for(let u of c.domains){if(r.has(u)){let m=r.get(u);throw new Error(`Duplicate domain ${u} (${c.name} and ${m.name})`)}r.set(u,c);let l=hE(u);if(u.startsWith("*.")){let m=u.slice(2);m===l?n.set(l,c):a.set(m,c)}}}for(let[c,u]of n.entries())u||n.delete(c);let o=z8.bind(null,r,a,n),s=Hoe.bind(null,r,a,n);return{getEntity:o,getProduct:s,getRootDomain:hE,entities:t}}i(Woe,"createAPIFromData\
set");H8.exports={createAPIFromDataset:Woe}});var W8=je((e5e,Voe)=>{Voe.exports=[{name:"Google/Doubleclick Ads",company:"Google",homepage:"https://marketingplatform.google.com/about/enterprise/",category:"ad",domains:["adservice.google.com","adservice.google.com.au","adservice.google.com.sg","adservice.google.com.br","adservice.google.com.ua","adservice.google.co.uk","adservice.google.co.jp","adservice.google.co.in","adservice.google.co.kr","adservice.google.co.id","adservice.google.co.nz","adservice.google.ie","adservice.google.se","adservice.google.de","adservice.google.ca","adservice.google.be","adservice.google.es","adservice.google.ch","adservice.google.fr","adservice.google.nl","*.googleadservices.com","*.googlesyndication.com","*.googletagservices.com","*.2mdn.net","*.doubleclick.net"],examples:["pagead2.googlesyndication.com","tpc.googlesyndication.com","ade.googlesyndication.com","googleads.g.doubleclick.net","googleads4.g.doubleclick.net","securepubads.g.doubleclick.net","pubads.g.doubleclick.net","static.doubleclick.net",
"cm.g.doubleclick.net","bid.g.doubleclick.net","s0.2mdn.net","stats.g.doubleclick.net","survey.g.doubleclick.net","fls.doubleclick.net","ad.doubleclick.net","www.googleadservices.com","https://www.googletagservices.com/tag/js/gpt.js"],totalExecutionTime:3224311743,totalOccurrences:1232210},{name:"Facebook",homepage:"https://www.facebook.com",category:"social",domains:["*.facebook.com","*.atlassbx.com","*.fbsbx.com","fbcdn-photos-e-a.akamaihd.net","*.facebook.net","*.fbcdn.net"],examples:["www.facebook.com","connect.facebook.net","staticxx.facebook.com","static.xx.fbcdn.net","m.facebook.com","an.facebook.com","platform-lookaside.fbsbx.com"],products:[{name:"Facebook Messenger Customer Chat",urlPatterns:["REGEXP:connect\\.facebook\\.net\\/.*\\/sdk\\/xfbml\\.customerchat\\.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}],totalExecutionTime:1097107210,totalOccurrences:3157799},{name:"Instagram",homepage:"https://www.instagram.com",
category:"social",domains:["*.cdninstagram.com","*.instagram.com"],examples:["scontent.cdninstagram.com"],totalExecutionTime:31988464,totalOccurrences:20376},{name:"Google CDN",company:"Google",homepage:"https://developers.google.com/speed/libraries/",category:"cdn",domains:["ajax.googleapis.com","commondatastorage.googleapis.com","www.gstatic.com","ssl.gstatic.com"],totalExecutionTime:4805631169,totalOccurrences:3192326},{name:"Google Maps",company:"Google",homepage:"https://www.google.com/maps",category:"utility",domains:["maps.google.com","maps-api-ssl.google.com","maps.googleapis.com","mts.googleapis.com","mt.googleapis.com","mt0.googleapis.com","mt1.googleapis.com","mt2.googleapis.com","mt3.googleapis.com","khm0.googleapis.com","khm1.googleapis.com","khms.googleapis.com","khms1.googleapis.com","khms2.googleapis.com","maps.gstatic.com"],totalExecutionTime:904392768,totalOccurrences:1195850},{name:"Other Google APIs/SDKs",company:"Google",homepage:"https://developers.google.com/apis\
-explorer/#p/",category:"utility",domains:["accounts.google.com","apis.google.com","calendar.google.com","clients2.google.com","cse.google.com","news.google.com","pay.google.com","payments.google.com","play.google.com","smartlock.google.com","www.google.com","www.google.de","www.google.co.jp","www.google.com.au","www.google.co.uk","www.google.ie","www.google.com.sg","www.google.co.in","www.google.com.br","www.google.ca","www.google.co.kr","www.google.co.nz","www.google.co.id","www.google.fr","www.google.be","www.google.com.ua","www.google.nl","www.google.ru","www.google.se","www.googleapis.com","imasdk.googleapis.com","storage.googleapis.com","translate.googleapis.com","translate.google.com","translate-pa.googleapis.com","lh3.googleusercontent.com","jnn-pa.googleapis.com","csi.gstatic.com"],totalExecutionTime:1158368443,totalOccurrences:2638940},{name:"Firebase",homepage:"https://developers.google.com/apis-explorer/#p/",category:"utility",domains:["firebasestorage.googleapis.com","fire\
store.googleapis.com","firebaseinstallations.googleapis.com","firebase.googleapis.com","firebaseremoteconfig.googleapis.com"],totalExecutionTime:201194,totalOccurrences:493},{name:"Google Analytics",company:"Google",homepage:"https://marketingplatform.google.com/about/analytics/",category:"analytics",domains:["*.google-analytics.com","*.urchin.com","analytics.google.com"],examples:["www.google-analytics.com","ssl.google-analytics.com","analytics.google.com/g/collect"],totalExecutionTime:495649535,totalOccurrences:4231882},{name:"Google Optimize",company:"Google",homepage:"https://marketingplatform.google.com/about/optimize/",category:"analytics",domains:["www.googleoptimize.com"],examples:["https://www.googleoptimize.com/optimize.js?id="],totalExecutionTime:9330261,totalOccurrences:38797},{name:"Google AMP",company:"Google",homepage:"https://github.com/google/amp-client-id-library",category:"analytics",domains:["ampcid.google.com"]},{name:"Google Tag Manager",company:"Google",homepage:"\
https://marketingplatform.google.com/about/tag-manager/",category:"tag-manager",domains:["*.googletagmanager.com"],examples:["www.googletagmanager.com"],totalExecutionTime:6770912735,totalOccurrences:8124119},{name:"Google Fonts",company:"Google",homepage:"https://fonts.google.com/",category:"cdn",domains:["fonts.googleapis.com","fonts.gstatic.com"],totalExecutionTime:53081,totalOccurrences:220864},{name:"Adobe TypeKit",company:"Adobe",homepage:"https://fonts.adobe.com/",category:"cdn",domains:["*.typekit.com","*.typekit.net"],examples:["use.typekit.net","p.typekit.net"],totalExecutionTime:78981507,totalOccurrences:119621},{name:"YouTube",homepage:"https://youtube.com",category:"video",domains:["*.youtube.com","*.ggpht.com","*.youtube-nocookie.com","*.ytimg.com"],examples:["www.youtube.com","s.ytimg.com","yt3.ggpht.com","img.youtube.com","fcmatch.youtube.com"],products:[{name:"YouTube Embedded Player",urlPatterns:["youtube.com/embed/"],facades:[{name:"Lite YouTube",repo:"https://github\
.com/paulirish/lite-youtube-embed"},{name:"Ngx Lite Video",repo:"https://github.com/karim-mamdouh/ngx-lite-video"}]}],totalExecutionTime:6277579675,totalOccurrences:977311},{name:"Twitter",homepage:"https://twitter.com",category:"social",domains:["*.vine.co","*.twimg.com","*.twitpic.com","platform.twitter.com","syndication.twitter.com"],examples:["cdn.syndication.twimg.com","abs.twimg.com","pbs.twimg.com"],totalExecutionTime:804233203,totalOccurrences:319957},{name:"AddThis",homepage:"https://www.addthis.com/",category:"social",domains:["*.addthis.com","*.addthiscdn.com","*.addthisedge.com"],examples:["s7.addthis.com","r.dlx.addthis.com","su.addthis.com","x.dlx.addthis.com"],totalExecutionTime:23,totalOccurrences:42},{name:"AddToAny",homepage:"https://www.addtoany.com/",category:"social",domains:["*.addtoany.com"],examples:["static.addtoany.com"],totalExecutionTime:10606113,totalOccurrences:66065},{name:"Akamai",homepage:"https://www.akamai.com/",category:"cdn",domains:["23.62.3.183","\
*.akamaitechnologies.com","*.akamaitechnologies.fr","*.akamai.net","*.akamaiedge.net","*.akamaihd.net","*.akamaized.net","*.edgefcs.net","*.edgekey.net","edgesuite.net","*.srip.net"],totalExecutionTime:4795669,totalOccurrences:9820},{name:"Blogger",homepage:"https://www.blogger.com/",category:"hosting",domains:["*.blogblog.com","*.blogger.com","*.blogspot.com","images-blogger-opensocial.googleusercontent.com"],examples:["1.bp.blogspot.com","www.blogger.com"],totalExecutionTime:58390438,totalOccurrences:213326},{name:"Gravatar",homepage:"https://en.gravatar.com/",category:"social",domains:["*.gravatar.com"],examples:["secure.gravatar.com","www.gravatar.com"],totalExecutionTime:9235,totalOccurrences:43},{name:"Yandex Metrica",company:"Yandex",homepage:"https://metrica.yandex.com/about?",category:"analytics",domains:["mc.yandex.ru","mc.yandex.com","d31j93rd8oukbv.cloudfront.net"],totalExecutionTime:1438544698,totalOccurrences:602136},{name:"Hotjar",homepage:"https://www.hotjar.com/",category:"\
analytics",domains:["*.hotjar.com","*.hotjar.io"],examples:["script.hotjar.com","static.hotjar.com","in.hotjar.com","vc.hotjar.io","vars.hotjar.com"],totalExecutionTime:241418055,totalOccurrences:333356},{name:"Baidu Analytics",homepage:"https://tongji.baidu.com/web/welcome/login",category:"analytics",domains:["hm.baidu.com","hmcdn.baidu.com"],examples:["hm.baidu.com","hmcdn.baidu.com"],totalExecutionTime:7739347,totalOccurrences:32612},{name:"Insider",homepage:"",category:"analytics",domains:["*.useinsider.com"],examples:["hit.api.useinsider.com"],totalExecutionTime:2214966,totalOccurrences:1861},{name:"Adobe Experience Cloud",company:"Adobe",homepage:"",category:"analytics",domains:["*.2o7.net","du8783wkf05yr.cloudfront.net","*.hitbox.com","*.imageg.net","*.nedstat.com","*.omtrdc.net"],examples:["audiag.112.2o7.net","du8783wkf05yr.cloudfront.net/NS_mbox.js"],totalExecutionTime:2369,totalOccurrences:38},{name:"Adobe Tag Manager",company:"Adobe",homepage:"https://www.adobe.com/experien\
ce-platform/",category:"tag-manager",domains:["*.adobedtm.com","*.demdex.net","*.everesttech.net","sstats.adobe.com","hbrt.adobe.com"],examples:["assets.adobedtm.com","sync-tm.everesttech.net","cm.everesttech.net"],totalExecutionTime:34937564,totalOccurrences:200160},{name:"jQuery CDN",homepage:"https://code.jquery.com/",category:"cdn",domains:["*.jquery.com"],examples:["code.jquery.com"],totalExecutionTime:302334055,totalOccurrences:724477},{name:"Cloudflare CDN",homepage:"https://cdnjs.com/",category:"cdn",domains:["cdnjs.cloudflare.com","amp.cloudflare.com"],totalExecutionTime:337711119,totalOccurrences:666628},{name:"Cloudflare",homepage:"https://www.cloudflare.com/website-optimization/",category:"utility",domains:["ajax.cloudflare.com","*.nel.cloudflare.com","static.cloudflareinsights.com"],totalExecutionTime:58723052,totalOccurrences:467719},{name:"WordPress",company:"Automattic",homepage:"https://wp.com/",category:"hosting",domains:["*.wordpress.com","s0.wp.com","s2.wp.com","*.w\
.org","c0.wp.com","s1.wp.com","i0.wp.com","i1.wp.com","i2.wp.com","widgets.wp.com"],examples:["s.w.org"],totalExecutionTime:220910650,totalOccurrences:308694},{name:"WordPress Site Stats",company:"Automattic",homepage:"https://wp.com/",category:"analytics",domains:["pixel.wp.com","stats.wp.com"],totalExecutionTime:8573549,totalOccurrences:128931},{name:"Hatena Blog",homepage:"https://hatenablog.com/",category:"hosting",domains:["*.st-hatena.com","*.hatena.ne.jp"],examples:["cdn.blog.st-hatena.com","cdn.pool.st-hatena.com","cdn7.www.st-hatena.com","s.hatena.ne.jp","b.st-hatena.com"],totalExecutionTime:106337940,totalOccurrences:43183},{name:"Shopify",homepage:"https://www.shopify.com/",category:"hosting",domains:["*.shopify.com","*.shopifyapps.com","*.shopifycdn.com","*.shopifysvc.com"],examples:["cdn.shopify.com","productreviews.shopifycdn.com","monorail-edge.shopifysvc.com"],totalExecutionTime:287428893,totalOccurrences:338668},{name:"Dealer",homepage:"https://www.dealer.com/",category:"\
hosting",domains:["*.dealer.com"],examples:["static.dealer.com"],totalExecutionTime:871324,totalOccurrences:2620},{name:"PIXNET",homepage:"https://www.pixnet.net/",category:"social",domains:["*.pixfs.net","*.pixnet.net"],examples:["front.pixfs.net","falcon-asset.pixfs.net","pixgame-asset.pixfs.net"],totalExecutionTime:18541448,totalOccurrences:13718},{name:"Moat",homepage:"https://moat.com/",category:"ad",domains:["*.moatads.com","*.moatpixel.com"],examples:["z.moatads.com","px.moatads.com","geo.moatads.com","sejs.moatads.com","mb.moatads.com","v4.moatads.com"]},{name:"33 Across",homepage:"https://33across.com/",category:"ad",domains:["*.33across.com"],examples:["sic.33across.com","cdn-sic.33across.com"],totalExecutionTime:10002146,totalOccurrences:192648},{name:"OpenX",homepage:"https://www.openx.com/",category:"ad",domains:["*.deliverimp.com","*.openxadexchange.com","*.servedbyopenx.com","*.jump-time.net","*.openx.net","*.openxcdn.net"],examples:["uk-ads.openx.net","us-ads.openx.net",
"33across-d.openx.net","rtb.openx.net","us-u.openx.net","eu-u.openx.net","u.openx.net"],totalExecutionTime:6274934,totalOccurrences:76561},{name:"Amazon Ads",homepage:"https://ad.amazon.com/",category:"ad",domains:["*.amazon-adsystem.com"],examples:["s.amazon-adsystem.com","c.amazon-adsystem.com","aax.amazon-adsystem.com","z-na.amazon-adsystem.com","fls-na.amazon-adsystem.com","aax-us-east.amazon-adsystem.com","ir-na.amazon-adsystem.com"],totalExecutionTime:98703856,totalOccurrences:240331},{name:"Rubicon Project",homepage:"https://rubiconproject.com/",category:"ad",domains:["*.rubiconproject.com","*.chango.com","*.fimserve.com"],examples:["pixel.rubiconproject.com","fastlane.rubiconproject.com","secure-assets.rubiconproject.com","eus.rubiconproject.com","pixel-us-east.rubiconproject.com","token.rubiconproject.com","ads.rubiconproject.com"],totalExecutionTime:287111007,totalOccurrences:270271},{name:"The Trade Desk",homepage:"https://www.thetradedesk.com/",category:"ad",domains:["*.ads\
rvr.org","d1eoo1tco6rr5e.cloudfront.net"],examples:["js.adsrvr.org","match.adsrvr.org","insight.adsrvr.org","usw-lax.adsrvr.org","data.adsrvr.org","snap.adsrvr.org"],totalExecutionTime:2197325,totalOccurrences:25346},{name:"Bidswitch",homepage:"https://www.bidswitch.com/",category:"ad",domains:["*.bidswitch.net"],examples:["x.bidswitch.net"],totalExecutionTime:25660,totalOccurrences:68217},{name:"LiveRamp IdentityLink",homepage:"https://liveramp.com/discover-identitylink/",category:"analytics",domains:["*.circulate.com","*.rlcdn.com"],examples:["idsync.rlcdn.com","id.rlcdn.com","api.rlcdn.com","cdn.rlcdn.com"],totalExecutionTime:141414,totalOccurrences:1461},{name:"Drawbridge",homepage:"https://www.drawbridge.com/",category:"ad",domains:["*.adsymptotic.com"]},{name:"AOL / Oath / Verizon Media",homepage:"https://www.oath.com/",category:"ad",domains:["*.advertising.com","*.aol.com","*.aolcdn.com","*.blogsmithmedia.com","*.oath.com","*.aol.net","*.tacoda.net","*.aol.co.uk"],examples:["pix\
el.advertising.com","dtm.advertising.com","tag.sp.advertising.com","service.sp.advertising.com","adtech.advertising.com","adaptv.advertising.com","mighty.aol.net","consent.cmp.oath.com"],totalExecutionTime:165968,totalOccurrences:278},{name:"Xaxis",homepage:"https://www.xaxis.com/",category:"ad",domains:["*.247realmedia.com","*.mookie1.com","*.gmads.net"],examples:["t.mookie1.com","odr.mookie1.com"],totalExecutionTime:28343,totalOccurrences:209},{name:"Freshdesk",company:"Freshworks",homepage:"https://freshdesk.com/",category:"customer-success",domains:["d36mpcpuzc4ztk.cloudfront.net"],totalExecutionTime:64296,totalOccurrences:225},{name:"Help Scout",homepage:"https://www.helpscout.net/",category:"customer-success",domains:["djtflbt20bdde.cloudfront.net","*.helpscout.net"],examples:["beacon-v2.helpscout.net"],products:[{name:"Help Scout Beacon",urlPatterns:["beacon-v2.helpscout.net"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}],
totalExecutionTime:2186050,totalOccurrences:4906},{name:"Alexa",homepage:"https://www.alexa.com/",category:"analytics",domains:["*.alexametrics.com","d31qbv1cthcecs.cloudfront.net"],examples:["certify.alexametrics.com"]},{name:"OneSignal",homepage:"https://onesignal.com/",category:"utility",domains:["*.onesignal.com"],examples:["cdn.onesignal.com","https://onesignal.com/api/v1/sync/"],totalExecutionTime:17761218,totalOccurrences:68282},{name:"Lucky Orange",homepage:"https://www.luckyorange.com/",category:"analytics",domains:["*.luckyorange.com","d10lpsik1i8c69.cloudfront.net","*.luckyorange.net"],totalExecutionTime:12779009,totalOccurrences:16442},{name:"Crazy Egg",homepage:"https://www.crazyegg.com/",category:"analytics",domains:["*.cetrk.com","*.crazyegg.com","dnn506yrbagrg.cloudfront.net"],totalExecutionTime:27593244,totalOccurrences:43822},{name:"Hello Bar",homepage:"https://www.hellobar.com/",category:"marketing",domains:["*.hellobar.com"],totalExecutionTime:1533955,totalOccurrences:4502},
{name:"Yandex Ads",company:"Yandex",homepage:"https://yandex.com/adv/",category:"ad",domains:["an.yandex.ru"],totalExecutionTime:5171537,totalOccurrences:8488},{name:"Salesforce",homepage:"https://www.salesforce.com/products/marketing-cloud/",category:"analytics",domains:["*.krxd.net"],examples:["cdn.krxd.net","beacon.krxd.net","consumer.krxd.net","usermatch.krxd.net"]},{name:"Salesforce Commerce Cloud",homepage:"https://www.salesforce.com/products/commerce-cloud/overview/",category:"hosting",domains:["*.cquotient.com","*.demandware.net","demandware.edgesuite.net"],totalExecutionTime:2045309,totalOccurrences:4127},{name:"Optimizely",homepage:"https://www.optimizely.com/",category:"analytics",domains:["*.optimizely.com"],examples:["cdn.optimizely.com","cdn-pci.optimizely.com","logx.optimizely.com","cdn3.optimizely.com"],totalExecutionTime:12599739,totalOccurrences:15998},{name:"LiveChat",homepage:"https://www.livechat.com/",category:"customer-success",domains:["*.livechatinc.com","*.liv\
echat.com","*.livechat-static.com"],examples:["cdn.livechatinc.com","secure.livechatinc.com"],totalExecutionTime:49171416,totalOccurrences:39034},{name:"VK",homepage:"https://vk.com/",category:"social",domains:["*.vk.com"],totalExecutionTime:91334176,totalOccurrences:22377},{name:"Tumblr",homepage:"https://tumblr.com/",category:"social",domains:["*.tumblr.com"],examples:["assets.tumblr.com","static.tumblr.com"],totalExecutionTime:45570825,totalOccurrences:18114},{name:"Wistia",homepage:"https://wistia.com/",category:"video",domains:["*.wistia.com","embedwistia-a.akamaihd.net","*.wistia.net"],examples:["fast.wistia.com","fast.wistia.net","distillery.wistia.com","pipedream.wistia.com"],totalExecutionTime:115722112,totalOccurrences:27059},{name:"Brightcove",homepage:"https://www.brightcove.com/en/",category:"video",domains:["*.brightcove.com","*.brightcove.net","*.zencdn.net"],examples:["vjs.zencdn.net","players.brightcove.net"],totalExecutionTime:15099708,totalOccurrences:13745},{name:"J\
SDelivr CDN",homepage:"https://www.jsdelivr.com/",category:"cdn",domains:["*.jsdelivr.net"],examples:["cdn.jsdelivr.net"],totalExecutionTime:260364458,totalOccurrences:399959},{name:"Sumo",homepage:"https://sumo.com/",category:"marketing",domains:["*.sumo.com","*.sumome.com","sumo.b-cdn.net"],examples:["sumo.b-cdn.net","load.sumo.com","load.sumome.com"],totalExecutionTime:16489977,totalOccurrences:10901},{name:"Vimeo",homepage:"https://vimeo.com/",category:"video",domains:["*.vimeo.com","*.vimeocdn.com"],examples:["f.vimeocdn.com","player.vimeo.com","i.vimeocdn.com"],products:[{name:"Vimeo Embedded Player",urlPatterns:["player.vimeo.com/video/"],facades:[{name:"Lite Vimeo",repo:"https://github.com/slightlyoff/lite-vimeo"},{name:"Lite Vimeo Embed",repo:"https://github.com/luwes/lite-vimeo-embed"},{name:"Ngx Lite Video",repo:"https://github.com/karim-mamdouh/ngx-lite-video"}]}],totalExecutionTime:263943622,totalOccurrences:120397},{name:"Disqus",homepage:"https://disqus.com/",category:"s\
ocial",domains:["*.disqus.com","*.disquscdn.com"],examples:["c.disquscdn.com"],totalExecutionTime:3697272,totalOccurrences:1775},{name:"Yandex APIs",company:"Yandex",homepage:"https://yandex.ru/",category:"utility",domains:["api-maps.yandex.ru","money.yandex.ru"],totalExecutionTime:40765111,totalOccurrences:51601},{name:"Yandex CDN",company:"Yandex",homepage:"https://yandex.ru/",category:"cdn",domains:["*.yandex.st","*.yastatic.net"],examples:["https://yastatic.net/share2/share.js","https://yastatic.net/jquery/2.1.4/jquery.min.js"]},{name:"Integral Ad Science",homepage:"https://integralads.com/uk/",category:"ad",domains:["*.adsafeprotected.com","*.iasds01.com"],examples:["pixel.adsafeprotected.com","static.adsafeprotected.com","fw.adsafeprotected.com","cdn.adsafeprotected.com","dt.adsafeprotected.com"],totalExecutionTime:88554254,totalOccurrences:21660},{name:"Tealium",homepage:"https://tealium.com/",category:"tag-manager",domains:["*.aniview.com","*.delvenetworks.com","*.limelight.com",
"*.tiqcdn.com","*.llnwd.net","*.tealiumiq.com"],examples:["tags.tiqcdn.com","tealium.hs.llnwd.net","link.videoplatform.limelight.com","datacloud.tealiumiq.com"],totalExecutionTime:20176561,totalOccurrences:75434},{name:"Pubmatic",homepage:"https://pubmatic.com/",category:"ad",domains:["*.pubmatic.com"],examples:["image6.pubmatic.com","ads.pubmatic.com","image2.pubmatic.com","simage2.pubmatic.com","image4.pubmatic.com","simage4.pubmatic.com","image5.pubmatic.com","hbopenbid.pubmatic.com"],totalExecutionTime:417694368,totalOccurrences:279418},{name:"Olark",homepage:"https://www.olark.com/",category:"customer-success",domains:["*.olark.com"],examples:["static.olark.com"],totalExecutionTime:9840846,totalOccurrences:6534},{name:"Tawk.to",homepage:"https://www.tawk.to/",category:"customer-success",domains:["*.tawk.to"],examples:["embed.tawk.to"],totalExecutionTime:43074965,totalOccurrences:111088},{name:"OptinMonster",homepage:"https://optinmonster.com/",category:"marketing",domains:["*.opmn\
str.com","*.optmnstr.com","*.optmstr.com"],examples:["a.optmstr.com","api.opmnstr.com","a.optmnstr.com"],totalExecutionTime:1035991,totalOccurrences:2346},{name:"ZenDesk",homepage:"https://zendesk.com/",category:"customer-success",domains:["*.zdassets.com","*.zendesk.com","*.zopim.com"],examples:["assets.zendesk.com","static.zdassets.com","v2.zopim.com"],totalExecutionTime:106701440,totalOccurrences:72537},{name:"Pusher",homepage:"https://pusher.com/",category:"utility",domains:["*.pusher.com","*.pusherapp.com"],examples:["stats.pusher.com"],totalExecutionTime:152727,totalOccurrences:1698},{name:"Drift",homepage:"https://www.drift.com/",category:"marketing",domains:["*.drift.com","*.driftt.com"],examples:["js.driftt.com","api.drift.com"],products:[{name:"Drift Live Chat",urlPatterns:["REGEXP:js\\.driftt\\.com\\/include\\/.*\\/.*\\.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}],totalExecutionTime:30179596,totalOccurrences:5515},
{name:"Sentry",homepage:"https://sentry.io/",category:"utility",domains:["*.getsentry.com","*.ravenjs.com","*.sentry-cdn.com","*.sentry.io"],examples:["cdn.ravenjs.com","browser.sentry-cdn.com"],totalExecutionTime:47937360,totalOccurrences:85598},{name:"Amazon Web Services",homepage:"https://aws.amazon.com/s3/",category:"other",domains:["*.amazon.com","*.amazonaws.com","*.amazonwebapps.com","*.amazonwebservices.com","*.elasticbeanstalk.com","*.images-amazon.com","*.amazon.co.uk"],examples:["s3.amazonaws.com","us-east-1.amazonaws.com","api-cdn.amazon.com","ecx.images-amazon.com","ws.amazon.co.uk"],totalExecutionTime:51892201,totalOccurrences:119152},{name:"Amazon Pay",homepage:"https://pay.amazon.com",category:"utility",domains:["payments.amazon.com","*.payments-amazon.com"],totalExecutionTime:1234650,totalOccurrences:6833},{name:"Media.net",homepage:"https://www.media.net/",category:"ad",domains:["*.media.net","*.mnet-ad.net"],examples:["contextual.media.net","cdnwest-xch.media.net","h\
bx.media.net","cs.media.net","hblg.media.net"],totalExecutionTime:24973689,totalOccurrences:97679},{name:"Yahoo!",homepage:"https://www.yahoo.com/",category:"ad",domains:["*.bluelithium.com","*.hostingprod.com","*.lexity.com","*.yahoo.com","*.yahooapis.com","*.yimg.com","*.zenfs.com","*.yahoo.net"],examples:["ads.yahoo.com","analytics.yahoo.com","geo.yahoo.com","udc.yahoo.com","ganon.yahoo.com","ads.yap.yahoo.com"],totalExecutionTime:2617276,totalOccurrences:24800},{name:"Adroll",homepage:"https://www.adroll.com/",category:"ad",domains:["*.adroll.com"],examples:["d.adroll.com","s.adroll.com"],totalExecutionTime:11884188,totalOccurrences:30782},{name:"Twitch",homepage:"https://twitch.tv/",category:"video",domains:["*.twitch.tv"],examples:["player.twitch.tv"],totalExecutionTime:18452667,totalOccurrences:1255},{name:"Taboola",homepage:"https://www.taboola.com/",category:"ad",domains:["*.taboola.com","*.taboolasyndication.com"],examples:["cdn.taboola.com","trc.taboola.com","vidstat.taboola\
.com","images.taboola.com"],totalExecutionTime:32631891,totalOccurrences:49191},{name:"Sizmek",homepage:"https://www.sizmek.com/",category:"ad",domains:["*.serving-sys.com","*.peer39.net"],examples:["secure-ds.serving-sys.com","ds.serving-sys.com","bs.serving-sys.com"],totalExecutionTime:6679849,totalOccurrences:4307},{name:"Scorecard Research",homepage:"https://www.scorecardresearch.com/",category:"ad",domains:["*.scorecardresearch.com"],examples:["sb.scorecardresearch.com","sa.scorecardresearch.com","b.scorecardresearch.com"],totalExecutionTime:4399371,totalOccurrences:54577},{name:"Criteo",homepage:"https://www.criteo.com/",category:"ad",domains:["*.criteo.com","*.emailretargeting.com","*.criteo.net"],examples:["static.criteo.net","bidder.criteo.com","dis.criteo.com","gum.criteo.com","sslwidget.criteo.com","dis.us.criteo.com"],totalExecutionTime:25625451,totalOccurrences:213880},{name:"Segment",homepage:"https://segment.com/",category:"analytics",domains:["*.segment.com","*.segment.\
io"],examples:["cdn.segment.com","api.segment.io"],totalExecutionTime:11055141,totalOccurrences:27036},{name:"ShareThis",homepage:"https://www.sharethis.com/",category:"social",domains:["*.sharethis.com"],examples:["w.sharethis.com","ws.sharethis.com","t.sharethis.com"],totalExecutionTime:30807804,totalOccurrences:88829},{name:"Distil Networks",homepage:"https://www.distilnetworks.com/",category:"utility",domains:["*.areyouahuman.com"],examples:["n-cdn.areyouahuman.com"]},{name:"Connexity",homepage:"https://connexity.com/",category:"analytics",domains:["*.connexity.net"]},{name:"Popads",homepage:"https://www.popads.net/",category:"ad",domains:["*.popads.net"],examples:["serve.popads.net","c1.popads.net"],totalExecutionTime:756593,totalOccurrences:427},{name:"CreateJS CDN",homepage:"https://code.createjs.com/",category:"cdn",domains:["*.createjs.com"],examples:["code.createjs.com"],totalExecutionTime:13654049,totalOccurrences:3880},{name:"Squarespace",homepage:"https://www.squarespace.c\
om/",category:"hosting",domains:["*.squarespace.com"],examples:["static.squarespace.com","static1.squarespace.com"],totalExecutionTime:1106480464,totalOccurrences:243154},{name:"Media Math",homepage:"https://www.mediamath.com/",category:"ad",domains:["*.mathads.com","*.mathtag.com"],examples:["mathid.mathtag.com","sync.mathtag.com","pixel.mathtag.com"],totalExecutionTime:20783,totalOccurrences:305},{name:"Mixpanel",homepage:"https://mixpanel.com/",category:"analytics",domains:["*.mixpanel.com","*.mxpnl.com"],examples:["cdn.mxpnl.com"],totalExecutionTime:3250547,totalOccurrences:18817},{name:"FontAwesome CDN",homepage:"https://fontawesome.com/",category:"cdn",domains:["*.fontawesome.com"],examples:["use.fontawesome.com"],totalExecutionTime:73007333,totalOccurrences:291586},{name:"Hubspot",homepage:"https://hubspot.com/",category:"marketing",domains:["*.hs-scripts.com","*.hubspot.com","*.leadin.com","*.hs-analytics.net","*.hscollectedforms.net","*.hscta.net","*.hsforms.net","*.hsleadflow\
s.net","*.hsstatic.net","*.hubspot.net","*.hsforms.com","*.hs-banner.com","*.hs-embed-reporting.com","*.hs-growth-metrics.com","*.hs-data.com","*.hsadspixel.net","*.hubapi.com"],examples:["forms.hubspot.com","js.hsforms.net","js.hs-analytics.net","js.leadin.com"],totalExecutionTime:92224372,totalOccurrences:154415},{name:"Mailchimp",homepage:"https://mailchimp.com/",category:"marketing",domains:["*.chimpstatic.com","*.list-manage.com","*.mailchimp.com"],examples:["downloads.mailchimp.com"],totalExecutionTime:21592375,totalOccurrences:45506},{name:"MGID",homepage:"https://www.mgid.com/",category:"ad",domains:["*.mgid.com","*.dt07.net"],examples:["servicer.mgid.com"],totalExecutionTime:22074076,totalOccurrences:10437},{name:"Stripe",homepage:"https://stripe.com",category:"utility",domains:["*.stripe.com","*.stripecdn.com","*.stripe.network"],examples:["m.stripe.network","js.stripe.com"],totalExecutionTime:166354648,totalOccurrences:136440},{name:"PayPal",homepage:"https://paypal.com",category:"\
utility",domains:["*.paypal.com","*.paypalobjects.com"],examples:["www.paypalobjects.com"],totalExecutionTime:64408205,totalOccurrences:62800},{name:"Market GID",homepage:"https://www.marketgid.com/",category:"ad",domains:["*.marketgid.com"],examples:["jsc.marketgid.com"]},{name:"Pinterest",homepage:"https://pinterest.com/",category:"social",domains:["*.pinimg.com","*.pinterest.com"],examples:["assets.pinterest.com","ct.pinterest.com","log.pinterest.com"],totalExecutionTime:17602311,totalOccurrences:131448},{name:"New Relic",homepage:"https://newrelic.com/",category:"utility",domains:["*.newrelic.com","*.nr-data.net"],examples:["js-agent.newrelic.com","bam.nr-data.net"],totalExecutionTime:64592740,totalOccurrences:227672},{name:"AppDynamics",homepage:"https://www.appdynamics.com/",category:"utility",domains:["*.appdynamics.com","*.eum-appdynamics.com","d3tjaysgumg9lf.cloudfront.net"],examples:["cdn.appdynamics.com"],totalExecutionTime:2509158,totalOccurrences:2920},{name:"Parking Crew",
homepage:"https://parkingcrew.net/",category:"other",domains:["d1lxhc4jvstzrp.cloudfront.net","*.parkingcrew.net"],totalExecutionTime:9,totalOccurrences:1},{name:"WordAds",company:"Automattic",homepage:"https://wordads.co/",category:"ad",domains:["*.pubmine.com"],examples:["s.pubmine.com"],totalExecutionTime:74286347,totalOccurrences:100449},{name:"AppNexus",homepage:"https://www.appnexus.com/",category:"ad",domains:["*.adnxs.com","*.ctasnet.com","*.adrdgt.com"],examples:["acdn.adnxs.com","secure.adnxs.com","ib.adnxs.com","sharethrough.adnxs.com","cdn.adnxs.com","vcdn.adnxs.com"],totalExecutionTime:5948505,totalOccurrences:234133},{name:"Histats",homepage:"https://www.histats.com/",category:"analytics",domains:["*.histats.com"],examples:["s10.histats.com"],totalExecutionTime:5601,totalOccurrences:92},{name:"DoubleVerify",homepage:"https://www.doubleverify.com/",category:"ad",domains:["*.doubleverify.com","*.dvtps.com","*.iqfp1.com"],examples:["cdn.doubleverify.com","cdn3.doubleverify.c\
om","tps.doubleverify.com","tps712.doubleverify.com","tps714.doubleverify.com","tps706.doubleverify.com","tps700.doubleverify.com","tps707.doubleverify.com","rtb2.doubleverify.com","rtb0.doubleverify.com","rtbcdn.doubleverify.com","tps11020.doubleverify.com","tm.iqfp1.com"],totalExecutionTime:46891028,totalOccurrences:19453},{name:"Mediavine",homepage:"https://www.mediavine.com/",category:"ad",domains:["*.mediavine.com"],examples:["scripts.mediavine.com","video.mediavine.com"],totalExecutionTime:59009373,totalOccurrences:12963},{name:"Wix",homepage:"https://www.wix.com/",category:"hosting",domains:["*.parastorage.com","*.wix.com","*.wixstatic.com","*.wixapps.net"],examples:["static.parastorage.com","static.wixstatic.com","www.wix.com","instagram.codev.wixapps.net"],totalExecutionTime:2112268981,totalOccurrences:458273},{name:"Webflow",homepage:"https://webflow.com/",category:"hosting",domains:["*.uploads-ssl.webflow.com","*.assets-global.website-files.com","*.assets.website-files.com"],
examples:["uploads-ssl.webflow.com","assets-global.website-files.com","assets.website-files.com"]},{name:"Weebly",homepage:"https://www.weebly.com/",category:"hosting",domains:["*.editmysite.com"],totalExecutionTime:413019e3,totalOccurrences:67864},{name:"LinkedIn",homepage:"https://www.linkedin.com/",category:"social",domains:["*.bizographics.com","platform.linkedin.com","*.slideshare.com","*.slidesharecdn.com","*.oribi.io"],totalExecutionTime:5776577,totalOccurrences:16507},{name:"LinkedIn Ads",category:"ad",domains:["*.licdn.com","*.ads.linkedin.com","ads.linkedin.com","www.linkedin.com"],examples:["snap.licdn.com"],totalExecutionTime:22805542,totalOccurrences:199088},{name:"Vox Media",homepage:"https://www.voxmedia.com/",category:"content",domains:["*.vox-cdn.com","*.voxmedia.com"],examples:["cdn.vox-cdn.com"],totalExecutionTime:910366,totalOccurrences:320},{name:"Hotmart",homepage:"https://www.hotmart.com/",category:"content",domains:["*.hotmart.com"],examples:["launchermodule.hot\
mart.com"],totalExecutionTime:15363016,totalOccurrences:4554},{name:"SoundCloud",homepage:"https://www.soundcloud.com/",category:"content",domains:["*.sndcdn.com","*.soundcloud.com","*.stratus.sc"],examples:["widget.sndcdn.com"],totalExecutionTime:15888610,totalOccurrences:5859},{name:"Spotify",homepage:"https://www.spotify.com/",category:"content",domains:["*.scdn.co","*.spotify.com"],examples:["open.spotify.com","open.scdn.co","i.scdn.co"],totalExecutionTime:99924,totalOccurrences:10992},{name:"AMP",homepage:"https://amp.dev/",category:"content",domains:["*.ampproject.org"],examples:["cdn.ampproject.org"],totalExecutionTime:79590738,totalOccurrences:66265},{name:"Beeketing",homepage:"https://beeketing.com/",category:"marketing",domains:["*.beeketing.com"],examples:["sdk-cdn.beeketing.com","sdk.beeketing.com"],totalExecutionTime:2163106,totalOccurrences:1971},{name:"Albacross",homepage:"https://albacross.com/",category:"marketing",domains:["*.albacross.com"],examples:["serve.albacross\
.com"],totalExecutionTime:100459,totalOccurrences:1503},{name:"TrafficJunky",homepage:"https://www.trafficjunky.com/",category:"ad",domains:["*.contentabc.com","*.trafficjunky.net"],examples:["ads2.contentabc.com","hw-cdn.contentabc.com","media.trafficjunky.net","ads.trafficjunky.net","hw-cdn.trafficjunky.net"],totalExecutionTime:2936,totalOccurrences:62},{name:"Bootstrap CDN",homepage:"https://www.bootstrapcdn.com/",category:"cdn",domains:["*.bootstrapcdn.com"],examples:["maxcdn.bootstrapcdn.com","stackpath.bootstrapcdn.com"],totalExecutionTime:2075388,totalOccurrences:38731},{name:"Shareaholic",homepage:"https://www.shareaholic.com/",category:"social",domains:["*.shareaholic.com","dsms0mj1bbhn4.cloudfront.net"],totalExecutionTime:122180,totalOccurrences:1429},{name:"Snowplow",homepage:"https://snowplowanalytics.com/",category:"analytics",domains:["d32hwlnfiv2gyn.cloudfront.net"],totalExecutionTime:7099041,totalOccurrences:58566},{name:"RD Station",homepage:"https://www.rdstation.com/\
en/",category:"marketing",domains:["d335luupugsy2.cloudfront.net"],totalExecutionTime:7693701,totalOccurrences:21846},{name:"Jivochat",homepage:"https://www.jivochat.com/",category:"customer-success",domains:["*.jivosite.com"],examples:["cdn-ca.jivosite.com","code.jivosite.com"],totalExecutionTime:36663932,totalOccurrences:57540},{name:"Listrak",homepage:"https://www.listrak.com/",category:"marketing",domains:["*.listrak.com","*.listrakbi.com"],examples:["cdn.listrakbi.com","s1.listrakbi.com"],totalExecutionTime:458776,totalOccurrences:1045},{name:"Ontame",homepage:"https://www.ontame.io",category:"analytics",domains:["*.ontame.io"],examples:["cdn.ontame.io","collector.ontame.io"],totalExecutionTime:23620,totalOccurrences:101},{name:"Ipify",homepage:"https://www.ipify.org",category:"utility",domains:["*.ipify.org"],examples:["api.ipify.org","geo.ipify.org"],totalExecutionTime:365905,totalOccurrences:2753},{name:"Ensighten",homepage:"https://www.ensighten.com/",category:"tag-manager",domains:[
"*.ensighten.com"],examples:["nexus.ensighten.com"],totalExecutionTime:1774287,totalOccurrences:3199},{name:"EpiServer",homepage:"https://www.episerver.com",category:"content",domains:["*.episerver.net"],examples:["dl.episerver.net"],totalExecutionTime:9010,totalOccurrences:80},{name:"mPulse",homepage:"https://developer.akamai.com/akamai-mpulse",category:"analytics",domains:["*.akstat.io","*.go-mpulse.net","*.mpulse.net","*.mpstat.us"],examples:["c.go-mpulse.net","0211c83c.akstat.io"],totalExecutionTime:3089821,totalOccurrences:30624},{name:"Pingdom RUM",homepage:"https://www.pingdom.com/product/performance-monitoring/",category:"analytics",domains:["*.pingdom.net"],examples:["rum-static.pingdom.net","rum-collector-2.pingdom.net"],totalExecutionTime:106679,totalOccurrences:1825},{name:"SpeedCurve RUM",company:"SpeedCurve",homepage:"https://www.speedcurve.com/features/performance-monitoring/",category:"analytics",domains:["*.speedcurve.com"],examples:["cdn.speedcurve.com","lux.speedcurv\
e.com"],totalExecutionTime:323903,totalOccurrences:5358},{name:"Radar",company:"Cedexis",homepage:"https://www.cedexis.com/radar/",category:"analytics",domains:["*.cedexis-test.com","*.cedexis.com","*.cmdolb.com","cedexis.leasewebcdn.com","*.cedexis-radar.net","*.cedexis.net","cedexis-test01.insnw.net","cedexisakamaitest.azureedge.net","cedexispub.cdnetworks.net","cs600.wac.alphacdn.net","cs600.wpc.edgecastdns.net","global2.cmdolb.com","img-cedexis.mncdn.com","a-cedexis.msedge.net","zn3vgszfh.fastestcdn.net"],examples:["radar.cedexis.com","rpt.cedexis.com","2-01-49cd-0002.cdx.cedexis.net","bench.cedexis-test.com"],totalExecutionTime:290925,totalOccurrences:1133},{name:"Byside",homepage:"https://byside.com",category:"analytics",domains:["*.byside.com"],examples:["byce2.byside.com","wce2.byside.com"],totalExecutionTime:45270,totalOccurrences:87},{name:"VWO",homepage:"https://vwo.com",category:"analytics",domains:["*.vwo.com","*.visualwebsiteoptimizer.com","d5phz18u4wuww.cloudfront.net","\
*.wingify.com"],examples:["dev.visualwebsiteoptimizer.com"],totalExecutionTime:6485310,totalOccurrences:7903},{name:"Bing Ads",homepage:"https://bingads.microsoft.com",category:"ad",domains:["*.bing.com","*.microsoft.com","*.msn.com","*.s-msft.com","*.s-msn.com","*.msads.net","*.msecnd.net"],examples:["bat.bing.com","c.bing.com","bat.r.msn.com","ajax.microsoft.com"],totalExecutionTime:14227177,totalOccurrences:117720},{name:"GoSquared",homepage:"https://www.gosquared.com",category:"analytics",domains:["*.gosquared.com","d1l6p2sc9645hc.cloudfront.net"],examples:["data.gosquared.com","data2.gosquared.com"],totalExecutionTime:56152,totalOccurrences:613},{name:"Usabilla",homepage:"https://usabilla.com",category:"analytics",domains:["*.usabilla.com","d6tizftlrpuof.cloudfront.net"],examples:["w.usabilla.com"],totalExecutionTime:240166,totalOccurrences:1354},{name:"Fastly Insights",homepage:"https://insights.fastlylabs.com",category:"analytics",domains:["*.fastly-insights.com"],examples:["www\
.fastly-insights.com"],totalExecutionTime:541189,totalOccurrences:4449},{name:"Visual IQ",homepage:"https://www.visualiq.com",category:"analytics",domains:["*.myvisualiq.net"],examples:["t.myvisualiq.net"]},{name:"Snapchat",homepage:"https://www.snapchat.com",category:"analytics",domains:["*.snapchat.com","*.sc-static.net"],examples:["tr.snapchat.com"],totalExecutionTime:177890,totalOccurrences:1978},{name:"Atlas Solutions",homepage:"https://atlassolutions.com",category:"analytics",domains:["*.atdmt.com"],examples:["ad.atdmt.com","cx.atdmt.com"]},{name:"Quantcast",homepage:"https://www.quantcast.com",category:"analytics",domains:["*.brtstats.com","*.quantcount.com","*.quantserve.com","*.semantictec.com","*.ntv.io"],examples:["pixel.quantserve.com","secure.quantserve.com","cms.quantserve.com","rules.quantcount.com"],totalExecutionTime:12419392,totalOccurrences:77646},{name:"Spiceworks",homepage:"https://www.spiceworks.com",category:"analytics",domains:["*.spiceworks.com"],examples:["px.\
spiceworks.com"]},{name:"Marketo",homepage:"https://www.marketo.com",category:"analytics",domains:["*.marketo.com","*.mktoresp.com","*.marketo.net"],examples:["munchkin.marketo.net"],totalExecutionTime:724464,totalOccurrences:1798},{name:"Intercom",homepage:"https://www.intercom.com",category:"customer-success",domains:["*.intercomcdn.com","*.intercom.io"],examples:["js.intercomcdn.com","api-iam.intercom.io","widget.intercom.io","nexus-websocket-a.intercom.io"],products:[{name:"Intercom Widget",urlPatterns:["widget.intercom.io","js.intercomcdn.com/shim.latest.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"},{name:"Intercom Facade",repo:"https://github.com/danielbachhuber/intercom-facade/"}]}],totalExecutionTime:44601345,totalOccurrences:35197},{name:"Unpkg",homepage:"https://unpkg.com",category:"cdn",domains:["*.unpkg.com","*.npmcdn.com"],totalExecutionTime:74666,totalOccurrences:227},{name:"ReadSpeaker",homepage:"https://www.rea\
dspeaker.com",category:"other",domains:["*.readspeaker.com"],examples:["sf1-eu.readspeaker.com"],totalExecutionTime:727525,totalOccurrences:6265},{name:"Browsealoud",homepage:"https://www.texthelp.com/en-gb/products/browsealoud/",category:"other",domains:["*.browsealoud.com","*.texthelp.com"],examples:["www.browsealoud.com"],totalExecutionTime:665425,totalOccurrences:1951},{name:"15gifts",category:"customer-success",domains:["*.15gifts.com","*.primefuse.com"],examples:["www.primefuse.com"]},{name:"1xRUN",category:"utility",domains:["*.1xrun.com"]},{name:"2AdPro Media Solutions",category:"ad",domains:["*.2adpro.com"]},{name:"301 Digital Media",category:"content",domains:["*.301ads.com","*.301network.com"]},{name:"360 picnic platform",company:"MediaV",category:"ad",domains:["*.mediav.com"],totalExecutionTime:4893,totalOccurrences:78},{name:"365 Media Group",category:"content",domains:["*.365dm.com"]},{name:"365 Tech Services",category:"hosting",domains:["*.365webservices.co.uk"]},{name:"\
3D Issue",category:"utility",domains:["*.3dissue.com","*.pressjack.com"],totalExecutionTime:53823,totalOccurrences:30},{name:"47Line Technologies",category:"other",domains:["*.pejs.net"]},{name:"4finance",category:"utility",domains:["*.4finance.com"]},{name:"5miles",category:"content",domains:["*.5milesapp.com"]},{name:"77Tool",company:"77Agency",category:"analytics",domains:["*.77tracking.com"]},{name:"9xb",category:"ad",domains:["*.9xb.com"]},{name:"@UK",category:"hosting",domains:["*.uk-plc.net"]},{name:"A Perfect Pocket",category:"hosting",domains:["*.aperfectpocketdata.com"]},{name:"A-FIS PTE",category:"analytics",domains:["*.websta.me"]},{name:"AB Tasty",homepage:"https://www.abtasty.com/",category:"analytics",domains:["*.abtasty.com","d1447tq2m68ekg.cloudfront.net"],examples:["try.abtasty.com"],totalExecutionTime:1720461,totalOccurrences:3363},{name:"ABA RESEARCH",category:"analytics",domains:["*.abaresearch.uk","qmodal.azurewebsites.net"]},{name:"ADMIZED",category:"ad",domains:[
"*.admized.com"]},{name:"ADNOLOGIES",category:"ad",domains:["*.heias.com"]},{name:"ADventori",category:"ad",domains:["*.adventori.com"],totalExecutionTime:5790,totalOccurrences:21},{name:"AI Media Group",category:"ad",domains:["*.aimediagroup.com"]},{name:"AIR.TV",category:"ad",domains:["*.air.tv"]},{name:"AKQA",category:"ad",domains:["*.srtk.net"]},{name:"AOL ad",company:"AOL",category:"ad",domains:["*.atwola.com"]},{name:"AOL On",company:"AOL",category:"content",domains:["*.5min.com"]},{name:"AOL Sponsored Listiings",company:"AOL",category:"ad",domains:["*.adsonar.com"]},{name:"APSIS Lead",company:"APSIS International AB",category:"ad",domains:["*.prospecteye.com"]},{name:"APSIS Profile Cloud",company:"APSIS",category:"analytics",domains:["*.innomdc.com"]},{name:"APSIS Forms",company:"APSIS",category:"other",domains:["*.apsisforms.com"],examples:["forms.apsisforms.com"]},{name:"ARENA",company:"Altitude",category:"ad",domains:["*.altitude-arena.com"],totalExecutionTime:1,totalOccurrences:1},
{name:"ARM",category:"analytics",domains:["*.tag4arm.com"],totalExecutionTime:5847,totalOccurrences:83},{name:"ASAPP",category:"other",domains:["*.asapp.com"],totalExecutionTime:37052,totalOccurrences:31},{name:"ASP",category:"hosting",domains:["*.goshowoff.com"]},{name:"AT Internet",category:"analytics",domains:["*.ati-host.net"]},{name:"ATTRAQT",category:"utility",domains:["*.attraqt.com","*.locayta.com"]},{name:"AVANSER",category:"analytics",domains:["*.avanser.com.au"]},{name:"AVG",company:"AVG Technologies",category:"utility",domains:["*.avg.com"],examples:["omni.avg.com"]},{name:"AWeber",category:"ad",domains:["*.aweber.com"],totalExecutionTime:40945,totalOccurrences:280},{name:"AXS",category:"content",domains:["*.axs.com"],totalExecutionTime:49218,totalOccurrences:8},{name:"Accentuate",company:"Accentuate Digital",category:"utility",homepage:"https://www.accentuate.io/",domains:["*.accentuate.io"],examples:["cdn.accentuate.io","original.accentuate.io"],totalExecutionTime:1772,totalOccurrences:17},
{name:"Accenture",category:"analytics",domains:["*.tmvtp.com"]},{name:"Accord Holdings",category:"ad",domains:["*.agcdn.com"]},{name:"Accordant Media",category:"ad",domains:["*.a3cloud.net"],examples:["segment.a3cloud.net"]},{name:"Account Kit",category:"other",domains:["*.accountkit.com"]},{name:"Accuen Media (Omnicom Media Group)",category:"content",domains:["*.p-td.com"]},{name:"Accuweather",category:"content",domains:["*.accuweather.com"],totalExecutionTime:291762,totalOccurrences:1477},{name:"Acquisio",category:"ad",domains:["*.acq.io"],totalExecutionTime:1692,totalOccurrences:32},{name:"Act-On Software",category:"marketing",domains:["*.actonsoftware.com"],totalExecutionTime:98,totalOccurrences:2},{name:"ActBlue",category:"other",domains:["*.actblue.com"],totalExecutionTime:62800,totalOccurrences:73},{name:"Active Agent",category:"ad",domains:["*.active-agent.com"]},{name:"ActiveCampaign",category:"ad",domains:["*.trackcmp.net","app-us1.com","*.app-us1.com"],examples:["trackcmp.ne\
t","prism.app-us1.com","diffuser-cdn.app-us1.com"],totalExecutionTime:1605217,totalOccurrences:19100},{name:"AcuityAds",category:"ad",domains:["*.acuityplatform.com"],totalExecutionTime:2492,totalOccurrences:693},{name:"Acxiom",category:"ad",domains:["*.acxiom-online.com","*.acxiomapac.com","*.delivery.net"]},{name:"Ad4Screen",category:"ad",domains:["*.a4.tl"]},{name:"Ad6Media",category:"ad",domains:["*.ad6media.fr"],totalExecutionTime:821770,totalOccurrences:654},{name:"AdCurve",category:"ad",domains:["*.shop2market.com"]},{name:"AdEasy",category:"ad",domains:["*.adeasy.ru"]},{name:"AdExtent",category:"ad",domains:["*.adextent.com"]},{name:"AdForge Edge",company:"AdForge",category:"ad",domains:["*.adforgeinc.com"]},{name:"AdGear",company:"Samsung Electronics",category:"ad",domains:["*.adgear.com","*.adgrx.com"],totalExecutionTime:19948,totalOccurrences:42920},{name:"AdInMedia",category:"ad",domains:["*.fastapi.net"]},{name:"AdJug",category:"ad",domains:["*.adjug.com"],examples:["track\
ing.adjug.com","uk.view.adjug.com"]},{name:"AdMatic",category:"ad",domains:["*.admatic.com.tr"],totalExecutionTime:1274496,totalOccurrences:467},{name:"AdMedia",category:"ad",domains:["*.admedia.com"],examples:["pixel.admedia.com"],totalExecutionTime:2027,totalOccurrences:7},{name:"AdRecover",category:"ad",domains:["*.adrecover.com"],totalExecutionTime:5117,totalOccurrences:46},{name:"AdRiver",category:"ad",domains:["*.adriver.ru"],totalExecutionTime:1374767,totalOccurrences:4740},{name:"AdSniper",category:"ad",domains:["*.adsniper.ru","*.sniperlog.ru"],totalExecutionTime:2366,totalOccurrences:22},{name:"AdSpeed",category:"ad",domains:["*.adspeed.net"],totalExecutionTime:4642,totalOccurrences:16},{name:"AdSpruce",category:"ad",domains:["*.adspruce.com"]},{name:"AdSupply",category:"ad",domains:["*.doublepimp.com"],totalExecutionTime:1436,totalOccurrences:13},{name:"AdTheorent",category:"ad",domains:["*.adentifi.com"],totalExecutionTime:108,totalOccurrences:1},{name:"AdThink AudienceInsi\
ghts",company:"AdThink Media",category:"analytics",domains:["*.audienceinsights.net"]},{name:"AdTrue",company:"FPT AdTrue",category:"ad",domains:["*.adtrue.com"]},{name:"AdYapper",category:"ad",domains:["*.adyapper.com"]},{name:"Adacado",category:"ad",domains:["*.adacado.com"],totalExecutionTime:1777,totalOccurrences:18},{name:"Adap.tv",category:"ad",domains:["*.adap.tv"]},{name:"Adapt Services",category:"hosting",domains:["*.adcmps.com"]},{name:"Adaptive Web",category:"hosting",domains:["*.adaptive.co.uk"]},{name:"Adara Media",category:"ad",domains:["*.yieldoptimizer.com"],totalExecutionTime:1324,totalOccurrences:23},{name:"Adblade",category:"ad",domains:["*.adblade.com"],totalExecutionTime:704,totalOccurrences:7},{name:"Adbrain",category:"ad",domains:["*.adbrn.com"]},{name:"AddEvent",category:"utility",domains:["*.addevent.com"],examples:["www.addevent.com"],totalExecutionTime:73230,totalOccurrences:203},{name:"AddShoppers",category:"social",domains:["*.addshoppers.com","d3rr3d0n31t4\
8m.cloudfront.net","*.shop.pe"],totalExecutionTime:31574,totalOccurrences:451},{name:"AddThisEvent",category:"hosting",domains:["*.addthisevent.com"]},{name:"Addoox MetaNetwork",company:"Addoox",category:"ad",domains:["*.metanetwork.net"]},{name:"Addvantage Media",category:"ad",domains:["*.addvantagemedia.com","*.simplytechnology.net"]},{name:"AD EBis",category:"analytics",homepage:"https://www.ebis.ne.jp/",domains:["*.ebis.ne.jp"],examples:["taj1.ebis.ne.jp"],totalExecutionTime:55086,totalOccurrences:608},{name:"Adecs",category:"customer-success",domains:["*.adecs.co.uk"],examples:["www.adecs.co.uk"]},{name:"Adelphic",category:"ad",domains:["*.ipredictive.com"],totalExecutionTime:8196,totalOccurrences:112},{name:"Adestra",category:"ad",domains:["*.adestra.com","*.msgfocus.com"]},{name:"Adform",category:"ad",domains:["*.adform.net","*.adformdsp.net"],totalExecutionTime:1798751,totalOccurrences:140125},{name:"Adkontekst",category:"ad",domains:["*.adkontekst.pl"]},{name:"Adlead",category:"\
ad",domains:["*.webelapp.com"]},{name:"Adledge",category:"utility",domains:["*.adledge.com"]},{name:"Adloox",category:"ad",domains:["*.adlooxtracking.com"],totalExecutionTime:103507,totalOccurrences:112},{name:"Adlux",category:"ad",domains:["*.adlux.com"]},{name:"Admedo",category:"ad",domains:["*.a8723.com","*.adizio.com","*.admedo.com"],examples:["pool.a8723.com"],totalExecutionTime:9586,totalOccurrences:695},{name:"Admeta",company:"Wideorbit",category:"ad",domains:["*.atemda.com"]},{name:"Admetrics",company:"Next Tuesday",category:"analytics",domains:["*.nt.vc"],examples:["metrics.nt.vc"]},{name:"Admiral",category:"ad",domains:["*.unknowntray.com"]},{name:"Admitad",category:"ad",domains:["*.lenmit.com"],totalExecutionTime:2335,totalOccurrences:31},{name:"Admixer for Publishers",company:"Admixer",category:"ad",domains:["*.admixer.net"],totalExecutionTime:1542643,totalOccurrences:878},{name:"Adnium",category:"ad",domains:["*.adnium.com"]},{name:"Adnostic",company:"Dennis Publishing",category:"\
ad",domains:["*.adnostic.co.uk"]},{name:"Adobe Marketing Cloud",company:"Adobe Systems",category:"ad",domains:["*.adobetag.com"]},{name:"Adobe Scene7",company:"Adobe Systems",category:"content",domains:["wwwimages.adobe.com","*.scene7.com","*.everestads.net","*.everestjs.net"],totalExecutionTime:808424,totalOccurrences:702},{name:"Adobe Systems",category:"content",domains:["adobe.com","www.adobe.com"],totalExecutionTime:38836,totalOccurrences:179},{name:"Adobe Business Catalyst",homepage:"https://www.businesscatalyst.com/",category:"hosting",domains:["*.businesscatalyst.com"]},{name:"Adocean",company:"Gemius",category:"ad",domains:["*.adocean.pl"],totalExecutionTime:1658274,totalOccurrences:2151},{name:"Adometry",company:"Google",category:"ad",domains:["*.dmtry.com"]},{name:"Adomik",category:"analytics",domains:["*.adomik.com"]},{name:"Adotmob",category:"ad",domains:["*.adotmob.com"]},{name:"Adrian Quevedo",category:"hosting",domains:["*.adrianquevedo.com"]},{name:"Adroit Digital Solut\
ions",category:"ad",domains:["*.imiclk.com","*.abmr.net"]},{name:"AdsNative",category:"ad",domains:["*.adsnative.com"]},{name:"AdsWizz",category:"ad",domains:["*.adswizz.com"],totalExecutionTime:479514,totalOccurrences:1901},{name:"Adscale",category:"ad",domains:["*.adscale.de"],totalExecutionTime:106237,totalOccurrences:960},{name:"Adschoom",company:"JSWeb Production",category:"ad",domains:["*.adschoom.com"],totalExecutionTime:491,totalOccurrences:2},{name:"Adscience",category:"ad",domains:["*.adscience.nl"]},{name:"Adsiduous",category:"ad",domains:["*.adsiduous.com"]},{name:"Adsty",category:"ad",domains:["*.adx1.com"],totalExecutionTime:698,totalOccurrences:5},{name:"Adtech (AOL)",category:"ad",domains:["*.adtechus.com"],totalExecutionTime:176,totalOccurrences:2},{name:"Adtegrity",category:"ad",domains:["*.adtpix.com"],totalExecutionTime:1735,totalOccurrences:20},{name:"Adthink",company:"Adthink Media",category:"ad",domains:["*.adxcore.com","*.dcoengine.com"],examples:["d.adxcore.com"]},
{name:"AdultWebmasterEmpire.Com",category:"ad",domains:["*.awempire.com"],totalExecutionTime:65091,totalOccurrences:38},{name:"Adunity",category:"ad",domains:["*.adunity.com"]},{name:"Advance Magazine Group",category:"content",domains:["*.condenastdigital.com","*.condenet.com","*.condenast.co.uk"],totalExecutionTime:2531,totalOccurrences:8},{name:"Adverline Board",company:"Adverline",category:"ad",domains:["*.adverline.com","*.adnext.fr"]},{name:"AdvertServe",category:"ad",domains:["*.advertserve.com"],totalExecutionTime:112685,totalOccurrences:437},{name:"Advolution",category:"utility",domains:["*.advolution.de"]},{name:"Adwise",category:"ad",domains:["*.adwise.bg"],totalExecutionTime:144,totalOccurrences:2},{name:"Adyen",category:"utility",domains:["*.adyen.com"],totalExecutionTime:6335144,totalOccurrences:2363},{name:"Adyoulike",category:"ad",domains:["*.adyoulike.com","*.omnitagjs.com","*.adyoulike.net"],totalExecutionTime:147862,totalOccurrences:53190},{name:"Adzerk",category:"ad",
domains:["*.adzerk.net"],totalExecutionTime:35184,totalOccurrences:117},{name:"Adzip",company:"Adbox Digital",category:"ad",domains:["*.adzip.co"]},{name:"AerServ",category:"ad",domains:["*.aerserv.com"]},{name:"Affectv",category:"ad",domains:["*.affectv.com","*.affec.tv"],totalExecutionTime:1187,totalOccurrences:12},{name:"Affiliate Window",company:"Digital Window",category:"ad",domains:["*.dwin1.com"],totalExecutionTime:561168,totalOccurrences:5414},{name:"Affiliatly",category:"ad",domains:["*.affiliatly.com"],examples:["www.affiliatly.com"],totalExecutionTime:32020,totalOccurrences:132},{name:"Affino",category:"ad",domains:["affino.com"]},{name:"Affirm",category:"utility",domains:["*.affirm.com"],totalExecutionTime:3997184,totalOccurrences:6665},{name:"Afterpay",company:"Block",category:"utility",homepage:"https://www.afterpay.com/",domains:["*.afterpay.com"],examples:["static-us.afterpay.com"],totalExecutionTime:1270109,totalOccurrences:8269},{name:"Agenda Media",category:"ad",domains:[
"*.agendamedia.co.uk"]},{name:"Aggregate Knowledge",company:"Neustar",category:"ad",domains:["*.agkn.com"],totalExecutionTime:14828,totalOccurrences:344},{name:"AgilOne",category:"marketing",domains:["*.agilone.com"],totalExecutionTime:4190,totalOccurrences:53},{name:"Agility",category:"hosting",domains:["*.agilitycms.com"],totalExecutionTime:3079,totalOccurrences:4},{name:"Ahalogy",category:"social",domains:["*.ahalogy.com"]},{name:"Aheadworks",category:"utility",domains:["*.aheadworks.com"]},{name:"AirPR",category:"analytics",domains:["*.airpr.com"],totalExecutionTime:416,totalOccurrences:5},{name:"Aira",category:"ad",domains:["*.aira.net"],examples:["www.aira.net"]},{name:"Airport Parking and Hotels",category:"content",domains:["*.aph.com"],totalExecutionTime:277,totalOccurrences:3},{name:"Akanoo",category:"analytics",domains:["*.akanoo.com"]},{name:"Alchemy",company:"AndBeyond.Media",category:"ad",domains:["*.andbeyond.media"],totalExecutionTime:456340,totalOccurrences:164},{name:"\
AlephD",company:"AOL",category:"ad",domains:["*.alephd.com"]},{name:"AliveChat",company:"AYU Technology Solutions",category:"customer-success",domains:["*.websitealive.com","*.websitealive7.com"]},{name:"All Access",category:"other",domains:["*.allaccess.com.ph"]},{name:"Alliance for Audited Media",category:"ad",domains:["*.aamsitecertifier.com"]},{name:"Allyde",category:"marketing",domains:["*.mautic.com"]},{name:"AlphaSSL",category:"utility",domains:["*.alphassl.com"],totalExecutionTime:1146,totalOccurrences:10},{name:"Altitude",category:"ad",domains:["*.altitudeplatform.com"]},{name:"Altocloud",category:"analytics",domains:["*.altocloud.com"]},{name:"Amadeus",category:"content",domains:["*.e-travel.com"]},{name:"Amazon CloudFront",company:"Amazon",category:"utility",domains:["cloudfront.net"]},{name:"Ambassador",category:"ad",domains:["*.getambassador.com"],totalExecutionTime:21042,totalOccurrences:89},{name:"Ambient",company:"Ericcson",category:"other",domains:["*.adnetwork.vn","*.\
ambientplatform.vn"]},{name:"Amelia Communication",category:"hosting",domains:["*.sara.media"]},{name:"Amobee",category:"marketing",domains:["*.amgdgt.com","*.kontera.com"]},{name:"Amplience",category:"marketing",domains:["*.10cms.com","*.amplience.com","*.amplience.net","*.bigcontent.io","*.adis.ws"],totalExecutionTime:4093,totalOccurrences:17},{name:"Amplitude Mobile Analytics",company:"Amplitude",category:"analytics",domains:["*.amplitude.com","d24n15hnbwhuhn.cloudfront.net"],totalExecutionTime:8703641,totalOccurrences:46524},{name:"Anametrix",company:"Ensighten",category:"analytics",domains:["*.anametrix.com"]},{name:"Ancora Platform",company:"Ancora Media Solutions",category:"ad",domains:["*.ancoraplatform.com"]},{name:"Anedot",category:"other",domains:["*.anedot.com"],totalExecutionTime:84655,totalOccurrences:21},{name:"AnimateJS",category:"utility",domains:["*.animatedjs.com"]},{name:"AnswerDash",category:"customer-success",domains:["*.answerdash.com"],examples:["p1.answerdash.c\
om"]},{name:"Answers",category:"analytics",domains:["*.answcdn.com","*.answers.com","*.dsply.com"]},{name:"Apester",category:"analytics",domains:["*.apester.com","*.qmerce.com"],totalExecutionTime:25294,totalOccurrences:166},{name:"Apligraf SmartWeb",company:"Apligraf",category:"utility",domains:["*.apligraf.com.br"]},{name:"Appier",category:"ad",domains:["*.appier.net"],totalExecutionTime:124524,totalOccurrences:826},{name:"Appsolute",category:"utility",homepage:"https://appsolute.us/",domains:["dropahint.love"],examples:["dropahint.love"],totalExecutionTime:16362,totalOccurrences:144},{name:"Apptus eSales",company:"Apptus",category:"analytics",domains:["*.apptus.com"]},{name:"Arbor",company:"LiveRamp",category:"other",domains:["*.pippio.com"]},{name:"Ardent Creative",category:"hosting",domains:["*.ardentcreative.co.uk"]},{name:"Arnold Clark Automobiles",category:"content",domains:["*.arnoldclark.com"]},{name:"Atom Content Marketing",category:"content",domains:["*.atomvault.net"],examples:[
"danu.atomvault.net"]},{name:"Atom Data",category:"other",domains:["*.atomdata.io"]},{name:"Attribution",category:"ad",domains:["*.attributionapp.com"],totalExecutionTime:44124,totalOccurrences:124},{name:"Audience 360",company:"Datapoint Media",category:"ad",domains:["*.dpmsrv.com"],totalExecutionTime:578723,totalOccurrences:371},{name:"Audience Science",category:"ad",domains:["*.revsci.net"]},{name:"AudienceSearch",company:"Intimate Merger",category:"ad",domains:["*.im-apps.net"],totalExecutionTime:9114981,totalOccurrences:46726},{name:"Auditorius",category:"ad",domains:["*.audtd.com"]},{name:"Augur",category:"analytics",domains:["*.augur.io"]},{name:"Auto Link Maker",company:"Apple",category:"ad",domains:["*.apple.com"],examples:["autolinkmaker.itunes.apple.com"],totalExecutionTime:657122,totalOccurrences:2479},{name:"Autopilot",category:"ad",domains:["*.autopilothq.com"],totalExecutionTime:15490,totalOccurrences:74},{name:"Avail",company:"RichRelevance",category:"ad",domains:["*.av\
ail.net"]},{name:"AvantLink",category:"ad",domains:["*.avmws.com"],totalExecutionTime:417,totalOccurrences:8},{name:"Avco Systems",category:"utility",domains:["*.avcosystems.com"]},{name:"Avid Media",category:"customer-success",domains:["*.adspdbl.com","*.metadsp.co.uk"],totalExecutionTime:58,totalOccurrences:1},{name:"Avocet Systems",category:"ad",domains:["*.avocet.io","ads.avct.cloud"]},{name:"Avora",category:"analytics",domains:["*.truedash.com"],examples:["truetag.truedash.com"]},{name:"Azure Traffic Manager",company:"Microsoft",category:"other",domains:["*.gateway.net","*.trafficmanager.net"],examples:["analytics.gateway.net"],totalExecutionTime:51660,totalOccurrences:148},{name:"Azure Web Services",company:"Microsoft",category:"cdn",domains:["*.azurewebsites.net","*.azureedge.net","*.msedge.net","*.windows.net"],totalExecutionTime:35665078,totalOccurrences:51378},{name:"BAM",category:"analytics",domains:["*.bam-x.com"]},{name:"Baifendian Technology",category:"marketing",domains:[
"*.baifendian.com"]},{name:"Bankrate",category:"utility",domains:["*.bankrate.com"]},{name:"BannerFlow",company:"Nordic Factory Solutions",category:"ad",domains:["*.bannerflow.com"],totalExecutionTime:50455,totalOccurrences:42},{name:"Barclaycard SmartPay",company:"Barclaycard",category:"utility",domains:["*.barclaycardsmartpay.com"]},{name:"Barilliance",category:"analytics",domains:["*.barilliance.net","dn3y71tq7jf07.cloudfront.net"],totalExecutionTime:7250,totalOccurrences:26},{name:"Barnebys",category:"other",domains:["*.barnebys.com"],totalExecutionTime:59682,totalOccurrences:57},{name:"Basis",company:"Basis Technologies",category:"ad",homepage:"https://basis.net/",domains:["*.basis.net"],examples:["cdn01.basis.net"],totalExecutionTime:215661,totalOccurrences:2623},{name:"Batch Media",category:"ad",domains:["*.t4ft.de"]},{name:"Bauer Consumer Media",category:"content",domains:["*.bauercdn.com","*.greatmagazines.co.uk"],examples:["www.greatmagazines.co.uk"]},{name:"Baynote",category:"\
analytics",domains:["*.baynote.net"]},{name:"Bazaarvoice",category:"analytics",domains:["*.bazaarvoice.com","*.feedmagnet.com"],totalExecutionTime:1664795,totalOccurrences:3375},{name:"Beachfront Media",category:"ad",domains:["*.bfmio.com"],totalExecutionTime:7782,totalOccurrences:771},{name:"BeamPulse",category:"analytics",domains:["*.beampulse.com"]},{name:"Beeswax",category:"ad",domains:["*.bidr.io"],totalExecutionTime:5298,totalOccurrences:12735},{name:"Beetailer",category:"social",domains:["*.beetailer.com"],examples:["www.beetailer.com"]},{name:"Best Of Media S.A.",category:"content",domains:["*.servebom.com"],totalExecutionTime:29,totalOccurrences:67},{name:"Bet365",category:"ad",domains:["*.bet365affiliates.com"]},{name:"Betfair",category:"other",domains:["*.cdnbf.net"]},{name:"Betgenius",company:"Genius Sports",category:"content",domains:["*.connextra.com"],totalExecutionTime:84739,totalOccurrences:287},{name:"Better Banners",category:"ad",domains:["*.betterbannerscloud.com"]},
{name:"Better Business Bureau",category:"analytics",domains:["*.bbb.org"],totalExecutionTime:10819,totalOccurrences:78},{name:"Between Digital",category:"ad",domains:["*.betweendigital.com"],totalExecutionTime:88306,totalOccurrences:787},{name:"BidTheatre",category:"ad",domains:["*.bidtheatre.com"],totalExecutionTime:23106,totalOccurrences:252},{name:"Bidtellect",category:"ad",domains:["*.bttrack.com"],totalExecutionTime:2834,totalOccurrences:19},{name:"Bigcommerce",category:"marketing",domains:["*.bigcommerce.com"],totalExecutionTime:45747978,totalOccurrences:19595},{name:"BitGravity",company:"Tata Communications",category:"content",domains:["*.bitgravity.com"]},{name:"Bitly",category:"utility",domains:["*.bitly.com","*.lemde.fr","*.bit.ly"],totalExecutionTime:2977,totalOccurrences:8},{name:"Bizible",category:"ad",domains:["*.bizible.com","*.bizibly.com"],totalExecutionTime:435247,totalOccurrences:1186},{name:"Bizrate",category:"analytics",domains:["*.bizrate.com"],totalExecutionTime:11197,
totalOccurrences:57},{name:"BlastCasta",category:"social",domains:["*.poweringnews.com"],examples:["www.poweringnews.com"]},{name:"Blindado",category:"utility",domains:["*.siteblindado.com"],totalExecutionTime:41,totalOccurrences:1},{name:"Blis",category:"ad",domains:["*.blismedia.com"]},{name:"Blogg.se",category:"hosting",domains:["*.cdnme.se","*.publishme.se"]},{name:"BloomReach",category:"ad",domains:["*.brcdn.com","*.brsrvr.com","*.brsvr.com"],totalExecutionTime:2695,totalOccurrences:47},{name:"Bloomberg",category:"content",domains:["*.gotraffic.net"]},{name:"Shop Logic",company:"BloomReach",category:"marketing",domains:["*.goshoplogic.com"]},{name:"Blue State Digital",category:"ad",domains:["*.bsd.net"]},{name:"Blue Triangle Technologies",category:"analytics",domains:["*.btttag.com"],totalExecutionTime:102966,totalOccurrences:182},{name:"BlueCava",category:"ad",domains:["*.bluecava.com"],totalExecutionTime:466075,totalOccurrences:5165},{name:"BlueKai",company:"Oracle",category:"ad",
domains:["*.bkrtx.com","*.bluekai.com"],totalExecutionTime:4,totalOccurrences:6},{name:"Bluecore",category:"analytics",domains:["*.bluecore.com"],examples:["www.bluecore.com"],totalExecutionTime:83612,totalOccurrences:225},{name:"Bluegg",category:"hosting",domains:["d1va5oqn59yrvt.cloudfront.net"]},{name:"Bold Commerce",category:"utility",domains:["*.shappify-cdn.com","*.shappify.com","*.boldapps.net"],totalExecutionTime:5072681,totalOccurrences:9886},{name:"BoldChat",company:"LogMeIn",category:"customer-success",domains:["*.boldchat.com"]},{name:"Bombora",category:"ad",domains:["*.mlno6.com"]},{name:"Bonnier",category:"content",domains:["*.bonniercorp.com"]},{name:"Bookatable",category:"content",domains:["*.bookatable.com","*.livebookings.com"]},{name:"Booking.com",category:"content",domains:["*.bstatic.com"],totalExecutionTime:1652677,totalOccurrences:2448},{name:"Boomtrain",category:"ad",domains:["*.boomtrain.com","*.boomtrain.net"],totalExecutionTime:360072,totalOccurrences:2169},{
name:"BoostSuite",category:"ad",domains:["*.poweredbyeden.com"]},{name:"Boostable",category:"ad",domains:["*.boostable.com"]},{name:"Bootstrap Chinese network",category:"cdn",domains:["*.bootcss.com"],totalExecutionTime:427117,totalOccurrences:881},{name:"Booxscale",category:"ad",domains:["*.booxscale.com"]},{name:"Borderfree",company:"pitney bowes",category:"utility",domains:["*.borderfree.com","*.fiftyone.com"]},{name:"BowNow",category:"analytics",homepage:"https://bow-now.jp/",domains:["*.bownow.jp"],examples:["contents.bownow.jp"],totalExecutionTime:1298132,totalOccurrences:2410},{name:"Box",category:"hosting",domains:["*.box.com"],totalExecutionTime:15191,totalOccurrences:223},{name:"Boxever",category:"analytics",domains:["*.boxever.com"]},{name:"Braintree Payments",company:"Paypal",category:"utility",domains:["*.braintreegateway.com"],totalExecutionTime:171291,totalOccurrences:1141},{name:"Branch Metrics",category:"ad",domains:["*.branch.io","*.app.link"],totalExecutionTime:441792,
totalOccurrences:8288},{name:"Brand Finance",category:"other",domains:["*.brandirectory.com"]},{name:"Brand View",category:"analytics",domains:["*.brandview.com"]},{name:"Brandscreen",category:"ad",domains:["*.rtbidder.net"],examples:["match.rtbidder.net"]},{name:"BridgeTrack",company:"Sapient",category:"ad",domains:["*.bridgetrack.com"]},{name:"BrightRoll",company:"Yahoo!",category:"ad",domains:["*.btrll.com"]},{name:"BrightTag / Signal",company:"Signal",homepage:"https://www.signal.co",category:"tag-manager",domains:["*.btstatic.com","*.thebrighttag.com"]},{name:"Brightcove ZenCoder",company:"Brightcove",category:"other",domains:["*.zencoder.net"]},{name:"Bronto Software",category:"marketing",domains:["*.bm23.com","*.bronto.com","*.brontops.com"]},{name:"Browser-Update.org",category:"other",domains:["*.browser-update.org"]},{name:"Buffer",category:"social",domains:["*.bufferapp.com"],totalExecutionTime:535,totalOccurrences:7},{name:"Bugsnag",category:"utility",domains:["*.bugsnag.com",
"d2wy8f7a9ursnm.cloudfront.net"],examples:["notify.bugsnag.com"],totalExecutionTime:6197502,totalOccurrences:15069},{name:"Burst Media",category:"ad",domains:["*.burstnet.com","*.1rx.io"],examples:["usermatch.burstnet.com"],totalExecutionTime:1618,totalOccurrences:52},{name:"Burt",category:"analytics",domains:["*.richmetrics.com","*.burt.io"]},{name:"Business Message",category:"ad",domains:["*.message-business.com"],totalExecutionTime:7310,totalOccurrences:21},{name:"Business Week",company:"Bloomberg",category:"social",domains:["*.bwbx.io"],totalExecutionTime:67737,totalOccurrences:9},{name:"Buto",company:"Big Button",category:"ad",domains:["*.buto.tv"]},{name:"Button",category:"ad",domains:["*.btncdn.com"]},{name:"BuySellAds",category:"ad",domains:["*.buysellads.com","*.buysellads.net"],totalExecutionTime:179225,totalOccurrences:170},{name:"BuySight (AOL)",category:"ad",domains:["*.pulsemgr.com"]},{name:"Buyapowa",category:"ad",domains:["*.co-buying.com"],totalExecutionTime:3038,totalOccurrences:37},
{name:"BuzzFeed",category:"social",domains:["*.buzzfed.com","*.buzzfeed.com"],totalExecutionTime:14608,totalOccurrences:2},{name:"C1X",category:"ad",domains:["*.c1exchange.com"]},{name:"C3 Metrics",category:"analytics",domains:["*.c3tag.com"],totalExecutionTime:18122,totalOccurrences:153},{name:"CANDDi",company:"Campaign and Digital Intelligence",category:"ad",domains:["*.canddi.com"],totalExecutionTime:84756,totalOccurrences:150},{name:"CCM benchmark Group",category:"social",domains:["*.ccm2.net"]},{name:"CD Networks",category:"utility",domains:["*.gccdn.net"]},{name:"CDN Planet",category:"analytics",domains:["*.cdnplanet.com"]},{name:"InAuth",category:"utility",homepage:"https://www.inauth.com/",domains:["*.cdn-net.com"],examples:["uk.cdn-net.com"],totalExecutionTime:306346,totalOccurrences:298},{name:"CJ Affiliate",company:"Conversant",category:"ad",domains:["*.cj.com","*.dpbolvw.net"],totalExecutionTime:7725,totalOccurrences:17},{name:"CJ Affiliate by Conversant",company:"Conversan\
t",category:"ad",domains:["*.ftjcfx.com"],totalExecutionTime:8,totalOccurrences:4},{name:"CNBC",category:"content",domains:["*.cnbc.com"],totalExecutionTime:11468,totalOccurrences:12},{name:"CNET Content Solutions",company:"CBS Interactive",category:"content",domains:["*.cnetcontent.com"],examples:["cdn.cnetcontent.com","ws.cnetcontent.com"]},{name:"CPEx",category:"content",domains:["*.cpex.cz"],totalExecutionTime:763356,totalOccurrences:1104},{name:"CPXi",category:"ad",domains:["*.cpxinteractive.com"]},{name:"CUBED Attribution",company:"CUBED",category:"ad",domains:["*.withcubed.com"],examples:["data.withcubed.com"]},{name:"Cachefly",category:"utility",domains:["*.cachefly.net"],totalExecutionTime:128046,totalOccurrences:258},{name:"Calendly",category:"other",domains:["*.calendly.com"],totalExecutionTime:8622733,totalOccurrences:4604},{name:"CallRail",category:"analytics",domains:["*.callrail.com"],totalExecutionTime:8080185,totalOccurrences:29537},{name:"CallTrackingMetrics",category:"\
analytics",domains:["*.tctm.co"],totalExecutionTime:1981698,totalOccurrences:7503},{name:"Canned Banners",category:"ad",domains:["*.cannedbanners.com"]},{name:"Canopy Labs",category:"analytics",domains:["*.canopylabs.com"]},{name:"Capita",category:"utility",domains:["*.crcom.co.uk"],examples:["emmsrep.crcom.co.uk"]},{name:"Captify Media",category:"ad",domains:["*.cpx.to"],totalExecutionTime:1519,totalOccurrences:31},{name:"Captiify",category:"ad",domains:["*.captifymedia.com"]},{name:"Captivate Ai",category:"ad",domains:["*.captivate.ai"]},{name:"Captora",category:"marketing",domains:["*.captora.com"]},{name:"Carcloud",category:"other",domains:["*.carcloud.co.uk"]},{name:"Cardlytics",category:"ad",domains:["*.cardlytics.com"]},{name:"Cardosa Enterprises",category:"analytics",domains:["*.y-track.com"],totalExecutionTime:778,totalOccurrences:17},{name:"Caspian Media",category:"ad",domains:["*.caspianmedia.com"]},{name:"Cast",category:"utility",domains:["*.cast.rocks"]},{name:"Catch",category:"\
other",domains:["*.getcatch.com"],examples:["app.getcatch.com","assets.getcatch.com","js.getcatch.com"],totalExecutionTime:18282,totalOccurrences:40},{name:"Cavisson",category:"analytics",domains:["*.cavisson.com"]},{name:"Cedato",category:"ad",domains:["*.algovid.com","*.vdoserv.com"]},{name:"Celebrus Technologies",category:"analytics",domains:["*.celebrus.com"]},{name:"Celtra",category:"ad",domains:["*.celtra.com"],totalExecutionTime:369517,totalOccurrences:427},{name:"Centro",category:"ad",domains:["*.brand-server.com"]},{name:"Ceros",category:"other",domains:["ceros.com","view.ceros.com"],totalExecutionTime:64139,totalOccurrences:149},{name:"Ceros Analytics",company:"Ceros",category:"analytics",domains:["api.ceros.com"]},{name:"Certona",category:"analytics",domains:["*.certona.net"],totalExecutionTime:376,totalOccurrences:4},{name:"Certum",category:"utility",domains:["*.ocsp-certum.com","*.certum.pl"],totalExecutionTime:8544,totalOccurrences:3},{name:"Cgrdirect",category:"other",domains:[
"*.cgrdirect.co.uk"]},{name:"Channel 5 Media",category:"ad",domains:["*.five.tv"]},{name:"Channel.me",category:"customer-success",domains:["*.channel.me"]},{name:"ChannelAdvisor",category:"ad",domains:["*.channeladvisor.com","*.searchmarketing.com"],totalExecutionTime:3385,totalOccurrences:25},{name:"ChannelApe",company:"ChannelApe",category:"other",homepage:"https://www.channelape.com/",domains:["*.channelape.com"],examples:["callbacks.channelape.com"]},{name:"Chargeads Oscar",company:"Chargeads",category:"ad",domains:["*.chargeads.com"]},{name:"Charities Aid Foundation",category:"utility",domains:["*.cafonline.org"],totalExecutionTime:4368,totalOccurrences:7},{name:"Chartbeat",category:"analytics",domains:["*.chartbeat.com","*.chartbeat.net"],totalExecutionTime:1270560,totalOccurrences:6246},{name:"Cheapflights Media",company:"Momondo",category:"content",domains:["*.momondo.net"]},{name:"CheckM8",category:"ad",domains:["*.checkm8.com"]},{name:"CheckRate",company:"FreeStart",category:"\
utility",domains:["*.checkrate.co.uk"]},{name:"Checkfront",category:"other",domains:["*.checkfront.com","dcg3jth5savst.cloudfront.net"],totalExecutionTime:279282,totalOccurrences:152},{name:"CheetahMail",company:"Experian",category:"ad",domains:["*.chtah.com"]},{name:"Chitika",category:"ad",domains:["*.chitika.net"]},{name:"ChoiceStream",category:"ad",domains:["*.choicestream.com"]},{name:"Cint",category:"social",domains:["*.cint.com"],totalExecutionTime:111659,totalOccurrences:33},{name:"Civic",category:"hosting",domains:["*.civiccomputing.com"],totalExecutionTime:2815742,totalOccurrences:7253},{name:"ClearRise",category:"customer-success",domains:["*.clearrise.com"]},{name:"Clearstream",category:"ad",domains:["*.clrstm.com"]},{name:"Clerk.io ApS",category:"analytics",domains:["*.clerk.io"],totalExecutionTime:1196778,totalOccurrences:1915},{name:"CleverDATA",category:"ad",domains:["*.1dmp.io"]},{name:"CleverTap",category:"analytics",domains:["d2r1yp2w7bby2u.cloudfront.net"],totalExecutionTime:163519,
totalOccurrences:1321},{name:"Click Density",category:"analytics",domains:["*.clickdensity.com"]},{name:"Click4Assistance",category:"customer-success",domains:["*.click4assistance.co.uk"],totalExecutionTime:22710,totalOccurrences:178},{name:"ClickDesk",category:"customer-success",domains:["*.clickdesk.com","d1gwclp1pmzk26.cloudfront.net"],totalExecutionTime:74975,totalOccurrences:595},{name:"ClickDimensions",category:"ad",domains:["*.clickdimensions.com"],totalExecutionTime:125295,totalOccurrences:262},{name:"Clickadu (Winner Solutions)",category:"ad",domains:["*.clickadu.com"],totalExecutionTime:10740,totalOccurrences:4},{name:"Clickagy Audience Lab",company:"Clickagy",category:"ad",domains:["*.clickagy.com"],examples:["aorta.clickagy.com"],totalExecutionTime:44558,totalOccurrences:667},{name:"Clickio",category:"ad",domains:[]},{name:"Clicktale",category:"analytics",domains:["*.cdngc.net","*.clicktale.net"],examples:["clicktalecdn.sslcs.cdngc.net"],totalExecutionTime:288716,totalOccurrences:256},
{name:"Clicktripz",category:"content",domains:["*.clicktripz.com"],examples:["static.clicktripz.com","www.clicktripz.com"],totalExecutionTime:502041,totalOccurrences:354},{name:"Clik.com Websites",category:"content",domains:["*.clikpic.com"]},{name:"Cloud Technologies",category:"ad",domains:["*.behavioralengine.com","*.behavioralmailing.com"]},{name:"Cloud-A",category:"other",domains:["*.bulkstorage.ca"]},{name:"Cloud.typography",company:"Hoefler &amp; Co",category:"cdn",domains:["*.typography.com"],totalExecutionTime:3308,totalOccurrences:364},{name:"CloudSponge",category:"ad",domains:["*.cloudsponge.com"]},{name:"CloudVPS",category:"other",domains:["*.adoftheyear.com","*.objectstore.eu"]},{name:"Cloudinary",category:"content",domains:["*.cloudinary.com"],totalExecutionTime:1188126,totalOccurrences:2129},{name:"Cloudqp",company:"Cloudwp",category:"other",domains:["*.cloudwp.io"]},{name:"Cludo",category:"utility",domains:["*.cludo.com"],totalExecutionTime:25376,totalOccurrences:249},{name:"\
Cognesia",category:"marketing",domains:["*.intelli-direct.com"]},{name:"CogoCast",company:"Cogo Labs",category:"ad",domains:["*.cogocast.net"]},{name:"Colbenson",category:"utility",domains:["*.colbenson.com"]},{name:"Collective",category:"ad",domains:["*.collective-media.net"]},{name:"Com Laude",category:"other",domains:["*.gdimg.net"]},{name:"Comm100",category:"customer-success",domains:["*.comm100.com"],totalExecutionTime:469389,totalOccurrences:1045},{name:"CommerceHub",category:"marketing",domains:["*.mercent.com"]},{name:"Commission Factory",category:"ad",domains:["*.cfjump.com"],totalExecutionTime:961,totalOccurrences:12},{name:"Communicator",category:"ad",domains:["*.communicatorcorp.com","*.communicatoremail.com"]},{name:"Comodo",category:"utility",domains:["*.comodo.com","*.trust-provider.com","*.trustlogo.com","*.usertrust.com","*.comodo.net"],examples:["ocsp.trust-provider.com"],totalExecutionTime:41752,totalOccurrences:34},{name:"Comodo Certificate Authority",company:"Comod\
o",category:"utility",domains:["crt.comodoca.com","*.comodoca4.com","ocsp.comodoca.com","ocsp.usertrust.com","crt.usertrust.com"],examples:["ocsp.comodoca4.com"]},{name:"Compete",company:"Millwood Brown Digital",category:"analytics",domains:["*.c-col.com","*.compete.com"]},{name:"Compuware",category:"analytics",domains:["*.axf8.net"]},{name:"Conductrics",category:"analytics",domains:["*.conductrics.com"],examples:["cdn-v3.conductrics.com"],totalExecutionTime:12705,totalOccurrences:61},{name:"Confirmit",category:"analytics",domains:["*.confirmit.com"],totalExecutionTime:32100,totalOccurrences:195},{name:"Connatix",category:"ad",domains:["*.connatix.com"],totalExecutionTime:6751327,totalOccurrences:1195},{name:"Connect Events",category:"hosting",domains:["*.connectevents.com.au"]},{name:"Constant Contact",category:"ad",domains:["*.ctctcdn.com"],totalExecutionTime:604932,totalOccurrences:17528},{name:"Constructor.io",category:"utility",domains:["*.cnstrc.com"]},{name:"Contabo",category:"h\
osting",domains:["185.2.100.179"]},{name:"Content Media Corporation",category:"content",domains:["*.contentmedia.eu"]},{name:"ContentSquare",category:"analytics",domains:["d1m6l9dfulcyw7.cloudfront.net","*.content-square.net","*.contentsquare.net"],totalExecutionTime:3626830,totalOccurrences:2948},{name:"ContextWeb",category:"ad",domains:["*.contextweb.com"],totalExecutionTime:32437,totalOccurrences:1909},{name:"Continental Exchange Solutions",category:"utility",domains:["*.hifx.com"]},{name:"Converge-Digital",category:"ad",domains:["*.converge-digital.com"],examples:["ads.converge-digital.com"]},{name:"Conversant",category:"analytics",domains:["*.dotomi.com","*.dtmpub.com","*.emjcd.com","mediaplex.com","*.tqlkg.com","*.fastclick.net"],examples:["www.tqlkg.com"],totalExecutionTime:6531550,totalOccurrences:54802},{name:"Conversant Ad Server",company:"Conversant",category:"ad",domains:["adfarm.mediaplex.com","*.mediaplex.com"]},{name:"Conversant Tag Manager",company:"Conversant",category:"\
tag-manager",domains:["*.mplxtms.com"],totalExecutionTime:14146,totalOccurrences:58},{name:"Conversio",category:"ad",domains:["*.conversio.com"]},{name:"Conversion Labs",category:"ad",domains:["*.net.pl"],examples:["conversionlabs.net.pl"],totalExecutionTime:3243395,totalOccurrences:1898},{name:"Conversion Logic",category:"ad",domains:["*.conversionlogic.net"]},{name:"Convert Insights",category:"analytics",domains:["*.convertexperiments.com"],totalExecutionTime:2575826,totalOccurrences:4385},{name:"ConvertMedia",category:"ad",domains:["*.admailtiser.com","*.basebanner.com","*.cmbestsrv.com","*.vidfuture.com","*.zorosrv.com"],examples:["www.cmbestsrv.com"]},{name:"Convertro",category:"ad",domains:["*.convertro.com"]},{name:"Conviva",category:"content",domains:["*.conviva.com"],totalExecutionTime:2955,totalOccurrences:2},{name:"Cookie Reports",category:"utility",domains:["*.cookiereports.com"],totalExecutionTime:280810,totalOccurrences:671},{name:"Cookie-Script.com",category:"utility",domains:[
"*.cookie-script.com"],totalExecutionTime:15051619,totalOccurrences:58095},{name:"CookieQ",company:"Baycloud Systems",category:"utility",domains:["*.cookieq.com"]},{name:"CoolaData",category:"analytics",domains:["*.cooladata.com"],totalExecutionTime:1165,totalOccurrences:15},{name:"CopperEgg",category:"analytics",domains:["*.copperegg.com","d2vig74li2resi.cloudfront.net"]},{name:"Council ad Network",category:"ad",domains:["*.counciladvertising.net"],totalExecutionTime:18621,totalOccurrences:94},{name:"Covert Pics",category:"content",domains:["*.covet.pics"],totalExecutionTime:4496,totalOccurrences:55},{name:"Cox Digital Solutions",category:"ad",domains:["*.afy11.net"]},{name:"Creafi Online Media",category:"ad",domains:["*.creafi-online-media.com"]},{name:"Creators",category:"content",domains:["*.creators.co"]},{name:"Crimson Hexagon Analytics",company:"Crimson Hexagon",category:"analytics",domains:["*.hexagon-analytics.com"]},{name:"Crimtan",category:"ad",domains:["*.ctnsnet.com"],totalExecutionTime:59150,
totalOccurrences:74818},{name:"Cross Pixel Media",category:"ad",domains:["*.crsspxl.com"],totalExecutionTime:493,totalOccurrences:8},{name:"Crosswise",category:"ad",domains:["*.univide.com"],examples:["p.univide.com"]},{name:"Crowd Control",company:"Lotame",category:"ad",domains:["*.crwdcntrl.net"],totalExecutionTime:16298725,totalOccurrences:101196},{name:"Crowd Ignite",category:"ad",domains:["*.crowdignite.com"]},{name:"CrowdTwist",category:"ad",domains:["*.crowdtwist.com"]},{name:"Crowdskout",category:"ad",domains:["*.crowdskout.com"]},{name:"Crowdynews",category:"social",domains:["*.breakingburner.com"]},{name:"Curalate",category:"marketing",domains:["*.curalate.com","d116tqlcqfmz3v.cloudfront.net"],totalExecutionTime:628884,totalOccurrences:683},{name:"Customer Acquisition Cloud",company:"[24]7",category:"ad",domains:["*.campanja.com"]},{name:"Customer.io",category:"ad",domains:["*.customer.io"],totalExecutionTime:210609,totalOccurrences:1268},{name:"Custora",category:"analytics",
domains:["*.custora.com"]},{name:"Cxense",category:"ad",domains:["*.cxense.com","*.cxpublic.com","*.emediate.dk","*.emediate.eu"],totalExecutionTime:2218364,totalOccurrences:3708},{name:"CyberKnight",company:"Namogoo",category:"utility",domains:["*.namogoo.com"]},{name:"CyberSource (Visa)",category:"utility",domains:["*.authorize.net"],totalExecutionTime:339030,totalOccurrences:2682},{name:"Cybernet Quest",category:"analytics",domains:["*.cqcounter.com"]},{name:"D.A. Consortium",category:"ad",domains:["*.eff1.net"]},{name:"D4t4 Solutions",category:"analytics",domains:["*.u5e.com"]},{name:"DCSL Software",category:"hosting",domains:["*.dcslsoftware.com"]},{name:"DMG Media",category:"content",domains:["*.mol.im","*.and.co.uk","*.anm.co.uk","*.dailymail.co.uk"],totalExecutionTime:37855,totalOccurrences:15},{name:"DTSCOUT",category:"ad",domains:["*.dtscout.com"],totalExecutionTime:645362,totalOccurrences:8311},{name:"Dailykarma",category:"utility",homepage:"https://www.dailykarma.com/",domains:[
"*.dailykarma.io"],examples:["assets.dailykarma.io"],totalExecutionTime:122378,totalOccurrences:477},{name:"Dailymotion",category:"content",domains:["*.dailymotion.com","*.dmxleo.com","*.dm.gg","*.pxlad.io","*.dmcdn.net","*.sublimevideo.net"],examples:["ad.pxlad.io","www.dailymotion.com"],totalExecutionTime:56076026,totalOccurrences:5142},{name:"Dash Hudson",company:"Dash Hudson",category:"content",domains:["*.dashhudson.com"],examples:["cdn.dashhudson.com"],totalExecutionTime:154963,totalOccurrences:91},{name:"Datacamp",category:"utility",domains:["*.cdn77.org"],totalExecutionTime:3303608,totalOccurrences:1181},{name:"Datalicious",category:"tag-manager",domains:["*.supert.ag","*.optimahub.com"]},{name:"Datalogix",category:"ad",domains:["*.nexac.com"]},{name:"Datawrapper",category:"utility",domains:["*.datawrapper.de","*.dwcdn.net"],examples:["www.datawrapper.de"],totalExecutionTime:951486,totalOccurrences:249},{name:"Dataxu",category:"marketing",domains:["*.w55c.net"],totalExecutionTime:10,
totalOccurrences:5},{name:"DatoCMS",homepage:"https://www.datocms.com/",category:"content",domains:["*.datocms-assets.com"],examples:["www.datocms-assets.com"]},{name:"Datonics",category:"ad",domains:["*.pro-market.net"],examples:["pbid.pro-market.net"],totalExecutionTime:16955,totalOccurrences:254},{name:"Dealtime",category:"content",domains:["*.dealtime.com"]},{name:"Debenhams Geo Location",company:"Debenhams",category:"utility",domains:["176.74.183.134"]},{name:"Decibel Insight",category:"analytics",domains:["*.decibelinsight.net"],totalExecutionTime:995190,totalOccurrences:691},{name:"Deep Forest Media",company:"Rakuten",category:"ad",domains:["*.dpclk.com"]},{name:"DeepIntent",category:"ad",domains:["*.deepintent.com"],totalExecutionTime:3875,totalOccurrences:206},{name:"Delicious Media",category:"social",domains:["*.delicious.com"]},{name:"Delineo",category:"ad",domains:["*.delineo.com"],examples:["www.delineo.com"]},{name:"Delta Projects AB",category:"ad",domains:["*.de17a.com"],
totalExecutionTime:90548,totalOccurrences:382},{name:"Demand Media",category:"content",domains:["*.dmtracker.com"]},{name:"DemandBase",category:"marketing",domains:["*.demandbase.com"],totalExecutionTime:393206,totalOccurrences:2552},{name:"DemandJump",category:"analytics",domains:["*.demandjump.com"]},{name:"Dennis Publishing",category:"content",domains:["*.alphr.com"]},{name:"Devatics",category:"analytics",domains:["*.devatics.com","*.devatics.io"]},{name:"Developer Media",category:"ad",domains:["*.developermedia.com"],totalExecutionTime:4416,totalOccurrences:17},{name:"DialogTech",category:"ad",domains:["*.dialogtech.com"]},{name:"DialogTech SourceTrak",company:"DialogTech",category:"ad",domains:["d31y97ze264gaa.cloudfront.net"]},{name:"DigiCert",category:"utility",domains:["*.digicert.com"],examples:["ocsp.digicert.com"],totalExecutionTime:26560,totalOccurrences:83},{name:"Digioh",category:"ad",domains:["*.lightboxcdn.com"],totalExecutionTime:1347082,totalOccurrences:1303},{name:"D\
igital Look",category:"content",domains:["*.digitallook.com"]},{name:"Digital Media Exchange",company:"NDN",category:"content",domains:["*.newsinc.com"]},{name:"Digital Millennium Copyright Act Services",category:"utility",domains:["*.dmca.com"],totalExecutionTime:8820,totalOccurrences:70},{name:"Digital Ocean",category:"other",domains:["95.85.62.56"]},{name:"Digital Remedy",category:"ad",domains:["*.consumedmedia.com"]},{name:"Digital Window",category:"ad",domains:["*.awin1.com","*.zenaps.com"],totalExecutionTime:195,totalOccurrences:4},{name:"DigitalScirocco",category:"analytics",domains:["*.digitalscirocco.net"]},{name:"Digitial Point",category:"utility",domains:["*.dpstatic.com"]},{name:"Diligent (Adnetik)",category:"ad",domains:["*.wtp101.com"]},{name:"Directed Edge",category:"social",domains:["*.directededge.com"],examples:["shopify.directededge.com"],totalExecutionTime:8371,totalOccurrences:81},{name:"Distribute Travel",category:"ad",domains:["*.dtrck.net"]},{name:"District M",category:"\
ad",domains:["*.districtm.io"]},{name:"DistroScale",category:"ad",domains:["*.jsrdn.com"],totalExecutionTime:186009,totalOccurrences:198},{name:"Divido",category:"utility",domains:["*.divido.com"]},{name:"Dow Jones",category:"content",domains:["*.dowjones.com","*.dowjoneson.com"]},{name:"Drifty Co",category:"utility",domains:["*.onicframework.com"]},{name:"Drip",company:"The Numa Group",category:"ad",domains:["*.getdrip.com"],totalExecutionTime:120918,totalOccurrences:1350},{name:"Dropbox",category:"utility",domains:["*.dropboxusercontent.com"],totalExecutionTime:142552,totalOccurrences:145},{name:"Dyn Real User Monitoring",company:"Dyn",category:"analytics",domains:["*.jisusaiche.biz","*.dynapis.com","*.jisusaiche.com","*.dynapis.info"],examples:["beacon.rum.dynapis.com"]},{name:"DynAdmic",category:"ad",domains:["*.dyntrk.com"]},{name:"Dynamic Converter",category:"utility",domains:["*.dynamicconverter.com"],totalExecutionTime:58723,totalOccurrences:96},{name:"Dynamic Dummy Image Gener\
ator",company:"Open Source",category:"utility",domains:["*.dummyimage.com"]},{name:"Dynamic Logic",category:"ad",domains:["*.dl-rms.com","*.questionmarket.com"]},{name:"Dynamic Yield",category:"customer-success",domains:["*.dynamicyield.com"],totalExecutionTime:3580074,totalOccurrences:1843},{name:"Dynatrace",category:"analytics",domains:["*.ruxit.com","js-cdn.dynatrace.com"],totalExecutionTime:4106731,totalOccurrences:3221},{name:"ec-concier",homepage:"https://ec-concier.com/",category:"marketing",domains:["*.ec-concier.com"],examples:["s.ec-concier.com","gsync.ec-concier.com"]},{name:"ECT News Network",category:"content",domains:["*.ectnews.com"]},{name:"ELITechGroup",category:"analytics",domains:["*.elitechnology.com"]},{name:"EMAP",category:"content",domains:["*.emap.com"]},{name:"EMedia Solutions",category:"ad",domains:["*.e-shots.eu"],examples:["www.e-shots.eu"]},{name:"EQ works",category:"ad",domains:["*.eqads.com"]},{name:"ESV Digital",category:"analytics",domains:["*.esearchvi\
sion.com"]},{name:"Ebiquity",category:"analytics",domains:["*.ebiquitymedia.com"]},{name:"Eco Rebates",category:"ad",domains:["*.ecorebates.com"]},{name:"Ecwid",category:"hosting",domains:["*.ecwid.com","*.shopsettings.com","d3fi9i0jj23cau.cloudfront.net","d3j0zfs7paavns.cloudfront.net"],totalExecutionTime:3757012,totalOccurrences:4362},{name:"Edge Web Fonts",company:"Adobe Systems",category:"cdn",domains:["*.edgefonts.net"],examples:["use.edgefonts.net"]},{name:"Edition Digital",category:"ad",domains:["*.editiondigital.com"]},{name:"Edot Web Technologies",category:"hosting",domains:["*.edot.co.za"]},{name:"Effective Measure",category:"ad",domains:["*.effectivemeasure.net"],totalExecutionTime:17,totalOccurrences:1},{name:"Effiliation sa",category:"ad",domains:["*.effiliation.com"],totalExecutionTime:108,totalOccurrences:3},{name:"Ekm Systems",category:"analytics",domains:["*.ekmsecure.com","*.ekmpinpoint.co.uk"],examples:["globalstats.ekmsecure.com"],totalExecutionTime:67875,totalOccurrences:789},
{name:"Elastera",category:"hosting",domains:["*.elastera.net"]},{name:"Elastic Ad",category:"ad",domains:["*.elasticad.net"],totalExecutionTime:30225,totalOccurrences:137},{name:"Elastic Load Balancing",company:"Amazon Web Services",category:"hosting",domains:["*.105app.com"],examples:["rhpury.105app.com","rhxtd.105app.com"]},{name:"Elecard StreamEye",company:"Elecard",category:"other",domains:["*.streameye.net"]},{name:"Elevate",company:"Elevate Technology Solutions",category:"utility",domains:["*.elevaate.technology"]},{name:"Elicit",category:"utility",domains:["*.elicitapp.com"]},{name:"Elogia",category:"ad",domains:["*.elogia.net"]},{name:"Email Attitude",company:"1000mercis",category:"ad",domains:["*.email-attitude.com"]},{name:"EmailCenter",category:"ad",domains:["*.emailcenteruk.com"]},{name:"Embedly",category:"content",domains:["*.embedly.com","*.embed.ly"],totalExecutionTime:5014487,totalOccurrences:10836},{name:"EmpathyBroker Site Search",company:"EmpathyBroker",category:"uti\
lity",domains:["*.empathybroker.com"]},{name:"Enfusen",category:"analytics",domains:["*.enfusen.com"]},{name:"Engadget",company:"Engadget (AOL)",category:"content",domains:["*.gdgt.com"],examples:["media.gdgt.com"]},{name:"Engagio",category:"marketing",domains:["*.engagio.com"]},{name:"Ensighten Manage",company:"Ensighten",category:"tag-manager",domains:["*.levexis.com"]},{name:"EntityLink",category:"other",domains:["*.entitytag.co.uk"]},{name:"Entrust Datacard",category:"utility",domains:["*.entrust.com","*.entrust.net"],examples:["ocsp.entrust.com","ocsp.entrust.net"],totalExecutionTime:14041,totalOccurrences:3},{name:"Equiniti",category:"utility",domains:["*.equiniti.com"]},{name:"Errorception",category:"utility",domains:["*.errorception.com"]},{name:"Esri ArcGIS",company:"Esri",category:"utility",domains:["*.arcgis.com","*.arcgisonline.com"],totalExecutionTime:21967746,totalOccurrences:3432},{name:"Ethnio",category:"analytics",domains:["*.ethn.io"]},{name:"Eulerian Technologies",category:"\
ad",domains:["*.eolcdn.com"]},{name:"Euroland",category:"utility",domains:["*.euroland.com"],totalExecutionTime:1,totalOccurrences:3},{name:"European Interactive Digital ad Alli",category:"utility",domains:["*.edaa.eu"]},{name:"Eventbrite",category:"hosting",domains:["*.evbuc.com","*.eventbrite.co.uk"],totalExecutionTime:4667,totalOccurrences:33},{name:"Everflow",category:"analytics",domains:["*.tp88trk.com"],examples:["www.tp88trk.com"],totalExecutionTime:110842,totalOccurrences:185},{name:"Evergage",category:"analytics",domains:["*.evergage.com","*.evgnet.com"],examples:["cdn.evgnet.com"],totalExecutionTime:1095634,totalOccurrences:2491},{name:"Everquote",category:"content",domains:["*.evq1.com"]},{name:"Everyday Health",category:"ad",domains:["*.agoramedia.com"]},{name:"Evidon",category:"analytics",domains:["*.evidon.com"],totalExecutionTime:1260409,totalOccurrences:2482},{name:"Evolve Media",category:"content",domains:["*.evolvemediallc.com"]},{name:"Exactag",category:"ad",domains:[
"*.exactag.com"],totalExecutionTime:662,totalOccurrences:6},{name:"ExoClick",category:"ad",domains:["*.exoclick.com"],totalExecutionTime:69348,totalOccurrences:568},{name:"Expedia",category:"content",domains:["*.travel-assets.com","*.trvl-media.com","*.trvl-px.com","*.uciservice.com"],examples:["www.trvl-px.com","www.uciservice.com"],totalExecutionTime:15443,totalOccurrences:15},{name:"Expedia Australia",company:"Expedia",category:"content",domains:["*.expedia.com.au"],examples:["www.expedia.com.au"]},{name:"Expedia Canada",company:"Expedia",category:"content",domains:["*.expedia.ca"],examples:["www.expedia.ca"]},{name:"Expedia France",company:"Expedia",category:"content",domains:["*.expedia.fr"],examples:["www.expedia.fr"]},{name:"Expedia Germany",company:"Expedia",category:"content",domains:["*.expedia.de"],examples:["www.expedia.de"]},{name:"Expedia Italy",company:"Expedia",category:"content",domains:["*.expedia.it"],examples:["www.expedia.it"]},{name:"Expedia Japan",company:"Expedi\
a",category:"content",domains:["*.expedia.co.jp"],examples:["www.expedia.co.jp"]},{name:"Expedia USA",company:"Expedia",category:"content",domains:["*.expedia.com"],examples:["www.expedia.com"],totalExecutionTime:40062,totalOccurrences:19},{name:"Expedia United Kingdom",company:"Expedia",category:"content",domains:["*.expedia.co.uk"],examples:["www.expedia.co.uk"]},{name:"Experian",category:"utility",domains:["*.audienceiq.com","*.experian.com","*.experianmarketingservices.digital"]},{name:"Experian Cross-Channel Marketing Platform",company:"Experian",category:"marketing",domains:["*.eccmp.com","*.ccmp.eu"],totalExecutionTime:1268,totalOccurrences:24},{name:"Exponea",category:"analytics",domains:["*.exponea.com"],totalExecutionTime:154832,totalOccurrences:1303},{name:"Exponential Interactive",category:"ad",domains:["*.exponential.com"],totalExecutionTime:5179,totalOccurrences:120},{name:"Extensis WebInk",category:"cdn",domains:["*.webink.com"]},{name:"Extole",category:"ad",domains:["*.\
extole.com","*.extole.io"],examples:["origin.extole.io"],totalExecutionTime:21067,totalOccurrences:44},{name:"Ey-Seren",category:"analytics",domains:["*.webabacus.com"]},{name:"EyeView",category:"ad",domains:["*.eyeviewads.com"]},{name:"Eyeota",category:"ad",domains:["*.eyeota.net"],totalExecutionTime:152570,totalOccurrences:1827},{name:"Ezakus Pretargeting",company:"Ezakus",category:"ad",domains:["*.ezakus.net"]},{name:"Ezoic",category:"analytics",domains:["*.ezoic.net"],totalExecutionTime:93024,totalOccurrences:173},{name:"FLXone",company:"Teradata",category:"ad",domains:["*.pangolin.blue","*.flx1.com","d2hlpp31teaww3.cloudfront.net","*.flxpxl.com"],totalExecutionTime:25037,totalOccurrences:67},{name:"Fairfax Media",category:"content",domains:["ads.fairfax.com.au","resources.fairfax.com.au"]},{name:"Fairfax Media Analtics",company:"Fairfax Media",category:"analytics",domains:["analytics.fairfax.com.au"]},{name:"Falk Technologies",category:"ad",domains:["*.angsrvr.com"]},{name:"Fanpla\
yr",category:"analytics",domains:["*.fanplayr.com","d38nbbai6u794i.cloudfront.net"],totalExecutionTime:69669,totalOccurrences:154},{name:"Fast Thinking",company:"NE Marketing",category:"marketing",domains:["*.fast-thinking.co.uk"]},{name:"Fastest Forward",category:"analytics",domains:["*.gaug.es"],totalExecutionTime:13583,totalOccurrences:261},{name:"Fastly",category:"utility",domains:["*.fastly.net"],totalExecutionTime:21362072,totalOccurrences:9582},{name:"Feedbackify",company:"InsideMetrics",category:"analytics",domains:["*.feedbackify.com"],totalExecutionTime:42808,totalOccurrences:173},{name:"Feefo.com",company:"Feefo",category:"analytics",domains:["*.feefo.com"],totalExecutionTime:1362284,totalOccurrences:2025},{name:"Fidelity Media",category:"ad",domains:["*.fidelity-media.com"],examples:["x.fidelity-media.com"]},{name:"Filestack",category:"content",domains:["*.filepicker.io"],examples:["api.filepicker.io","dialog.filepicker.io","www.filepicker.io"],totalExecutionTime:27297,totalOccurrences:200},
{name:"Finsbury Media",category:"ad",domains:["*.finsburymedia.com"],totalExecutionTime:3470,totalOccurrences:12},{name:"Firepush",category:"utility",domains:["*.firepush.io"]},{name:"FirstImpression",category:"ad",domains:["*.firstimpression.io"],totalExecutionTime:141056,totalOccurrences:107},{name:"Fit Analytics",category:"other",domains:["*.fitanalytics.com"],examples:["integrations.fitanalytics.com","widget.fitanalytics.com","metrics.fitanalytics.com"]},{name:"Fits Me",category:"analytics",domains:["*.fits.me"]},{name:"Fivetran",category:"analytics",domains:["*.fivetran.com"],totalExecutionTime:2922,totalOccurrences:3},{name:"FlexShopper",category:"utility",domains:["*.flexshopper.com"]},{name:"Flickr",category:"content",domains:["*.flickr.com","*.staticflickr.com"],totalExecutionTime:262262,totalOccurrences:524},{name:"Flipboard",category:"social",domains:["*.flipboard.com"],totalExecutionTime:50049,totalOccurrences:41},{name:"Flipdesk",category:"customer-success",homepage:"https\
://flipdesk.jp/",domains:["*.flipdesk.jp"],examples:["api.flipdesk.jp"],totalExecutionTime:322297,totalOccurrences:411},{name:"Flipp",category:"analytics",domains:["*.wishabi.com","d2e0sxz09bo7k2.cloudfront.net","*.wishabi.net"]},{name:"Flite",category:"ad",domains:["*.flite.com"]},{name:"Flixmedia",category:"analytics",domains:["*.flix360.com","*.flixcar.com","*.flixfacts.com","*.flixsyndication.net","*.flixfacts.co.uk"],totalExecutionTime:32827,totalOccurrences:19},{name:"Flockler",category:"ad",domains:["*.flockler.com"],totalExecutionTime:504051,totalOccurrences:1297},{name:"Flowplayer",category:"content",domains:["*.flowplayer.org"],totalExecutionTime:218859,totalOccurrences:862},{name:"Flowzymes Ky",category:"cdn",domains:["*.jquerytools.org"]},{name:"Fomo",category:"ad",domains:["*.notifyapp.io"]},{name:"Fonecall",category:"analytics",domains:["*.web-call-analytics.com"]},{name:"Fontdeck",category:"cdn",domains:["*.fontdeck.com"]},{name:"Foodity Technologies",category:"ad",domains:[
"*.foodity.com"]},{name:"Force24",category:"ad",domains:["*.force24.co.uk"],totalExecutionTime:10225,totalOccurrences:112},{name:"ForeSee",company:"Answers",category:"analytics",domains:["*.4seeresults.com","*.answerscloud.com","*.foresee.com","*.foreseeresults.com"],totalExecutionTime:179704,totalOccurrences:266},{name:"Forensiq",category:"utility",domains:["*.fqtag.com"],totalExecutionTime:21937,totalOccurrences:171},{name:"Fort Awesome",category:"cdn",domains:["*.fortawesome.com"],totalExecutionTime:652365,totalOccurrences:3635},{name:"Forter",category:"utility",domains:["*.forter.com"],totalExecutionTime:6578955,totalOccurrences:6930},{name:"Forward Internet Group",category:"hosting",domains:["*.f3d.io"]},{name:"Forward3D",category:"ad",domains:["*.forward3d.com"]},{name:"Fospha",category:"analytics",domains:["*.fospha.com"],examples:["router.fospha.com"]},{name:"Foursixty",category:"customer-success",domains:["*.foursixty.com"]},{name:"FoxyCart",category:"utility",domains:["*.foxy\
cart.com"],totalExecutionTime:361777,totalOccurrences:669},{name:"Fraudlogix",category:"utility",domains:["*.yabidos.com"],totalExecutionTime:47637,totalOccurrences:357},{name:"FreakOut",category:"ad",domains:["*.fout.jp"],totalExecutionTime:114328,totalOccurrences:2036},{name:"Freespee",category:"customer-success",domains:["*.freespee.com"],examples:["analytics.freespee.com"],totalExecutionTime:67626,totalOccurrences:484},{name:"Freetobook",category:"content",domains:["*.freetobook.com"],examples:["www.freetobook.com"],totalExecutionTime:297146,totalOccurrences:649},{name:"Fresh 8 Gaming",category:"ad",domains:["*.fresh8.co"],totalExecutionTime:319849,totalOccurrences:76},{name:"Fresh Relevance",category:"analytics",domains:["*.freshrelevance.com","*.cloudfront.ne","d1y9qtn9cuc3xw.cloudfront.net","d81mfvml8p5ml.cloudfront.net","dkpklk99llpj0.cloudfront.net"],examples:["d1y9qtn9cuc3xw.cloudfront.ne"],totalExecutionTime:91181,totalOccurrences:300},{name:"Friendbuy",category:"ad",domains:[
"*.friendbuy.com","djnf6e5yyirys.cloudfront.net"],totalExecutionTime:17783,totalOccurrences:150},{name:"Frienefit",category:"ad",domains:["*.frienefit.com"]},{name:"FuelX",category:"ad",domains:["*.fuelx.com"]},{name:"Full Circle Studies",category:"analytics",domains:["*.securestudies.com"]},{name:"FullStory",category:"analytics",domains:["*.fullstory.com"],examples:["rs.fullstory.com"],totalExecutionTime:11575233,totalOccurrences:14687},{name:"Fyber",category:"ad",domains:["*.fyber.com"]},{name:"G-Forces Web Management",category:"hosting",domains:["*.gforcesinternal.co.uk"]},{name:"G4 Native",company:"Gravity4",category:"ad",domains:["*.triggit.com"]},{name:"GET ME IN!  (TicketMaster)",category:"content",domains:["*.getmein.com"]},{name:"GIPHY",category:"content",domains:["*.giphy.com"],totalExecutionTime:4831,totalOccurrences:6},{name:"GainCloud",company:"GainCloud Systems",category:"other",domains:["*.egaincloud.net"]},{name:"Gath Adams",category:"content",domains:["*.iwantthatfligh\
t.com.au"]},{name:"Gecko Tribe",category:"social",domains:["*.geckotribe.com"]},{name:"Gemius",category:"ad",domains:["*.gemius.pl"],totalExecutionTime:2964756,totalOccurrences:15596},{name:"Genesis Media",category:"ad",domains:["*.bzgint.com","*.genesismedia.com","*.genesismediaus.com"]},{name:"Genie Ventures",category:"ad",domains:["*.genieventures.co.uk"]},{name:"Geniee",category:"ad",domains:["*.href.asia","*.genieessp.jp","*.genieesspv.jp","*.gssprt.jp"],examples:["cs.gssprt.jp"],totalExecutionTime:16956055,totalOccurrences:16354},{name:"Geniuslink",category:"analytics",domains:["*.geni.us"],totalExecutionTime:897,totalOccurrences:3},{name:"GeoRiot",category:"other",domains:["*.georiot.com"]},{name:"GeoTrust",category:"utility",domains:["*.geotrust.com"],totalExecutionTime:3300,totalOccurrences:2},{name:"Geoplugin",category:"utility",domains:["*.geoplugin.com","*.geoplugin.net"],totalExecutionTime:119,totalOccurrences:3},{name:"Georeferencer",company:"Klokan Technologies",category:"\
utility",domains:["*.georeferencer.com"]},{name:"GetIntent RTBSuite",company:"GetIntent",category:"ad",domains:["*.adhigh.net"],totalExecutionTime:2768,totalOccurrences:356},{name:"GetResponse",category:"ad",domains:["*.getresponse.com"],totalExecutionTime:209076,totalOccurrences:1019},{name:"GetSiteControl",company:"GetWebCraft",category:"utility",domains:["*.getsitecontrol.com"],totalExecutionTime:1739288,totalOccurrences:3146},{name:"GetSocial",category:"social",domains:["*.getsocial.io"],totalExecutionTime:1204,totalOccurrences:11},{name:"Getty Images",category:"content",domains:["*.gettyimages.com","*.gettyimages.co.uk"],examples:["www.gettyimages.com"],totalExecutionTime:17939,totalOccurrences:65},{name:"Gfycat",company:"Gycat",category:"utility",domains:["*.gfycat.com"]},{name:"Ghostery Enterprise",company:"Ghostery",category:"marketing",domains:["*.betrad.com"],totalExecutionTime:1129,totalOccurrences:26},{name:"Giant Media",category:"ad",domains:["*.videostat.com"]},{name:"Gig\
ya",category:"analytics",domains:["*.gigya.com"],totalExecutionTime:2692493,totalOccurrences:1995},{name:"GitHub",category:"utility",domains:["*.github.com","*.githubusercontent.com","*.github.io","*.rawgit.com"],examples:["raw.githubusercontent.com","cdn.rawgit.com"],totalExecutionTime:7126491,totalOccurrences:14675},{name:"Gladly",company:"Gladly",homepage:"https://www.gladly.com/",category:"customer-success",domains:["*.gladly.com"],examples:["cdn.gladly.com"],totalExecutionTime:240417,totalOccurrences:381},{name:"Glassdoor",category:"content",domains:["*.glassdoor.com"],totalExecutionTime:68877,totalOccurrences:19},{name:"Gleam",category:"marketing",domains:["*.gleam.io"],totalExecutionTime:43249,totalOccurrences:221},{name:"Global Digital Markets",category:"ad",domains:["*.gdmdigital.com"]},{name:"Global-e",category:"hosting",domains:["*.global-e.com"],totalExecutionTime:706185,totalOccurrences:1314},{name:"GlobalSign",category:"utility",domains:["*.globalsign.com","*.globalsign.n\
et"],totalExecutionTime:11228,totalOccurrences:48},{name:"GlobalWebIndex",category:"analytics",domains:["*.globalwebindex.net"]},{name:"Globase International",category:"ad",domains:["*.globase.com"]},{name:"GoDataFeed",category:"other",domains:["*.godatafeed.com"]},{name:"Google APIs",company:"Google",category:"utility",domains:["googleapis.com"]},{name:"Google Ad Block Detection",company:"Google",category:"ad",domains:["*.0emn.com","*.0fmm.com"]},{name:"Google Analytics Experiments",company:"Google",category:"analytics",domains:["*.gexperiments1.com"]},{name:"Google DoubleClick Ad Exchange",company:"Google",category:"ad",domains:["*.admeld.com"]},{name:"Google IPV6 Metrics",company:"Google",category:"analytics",domains:["*.ipv6test.net"]},{name:"Google Plus",company:"Google",category:"social",domains:["plus.google.com"],totalExecutionTime:49945,totalOccurrences:442},{name:"Google Trusted Stores",company:"Google",category:"utility",domains:["*.googlecommerce.com"],totalExecutionTime:218,
totalOccurrences:5},{name:"Google Video",company:"Google",category:"content",domains:["*.googlevideo.com"],totalExecutionTime:4,totalOccurrences:3},{name:"Google reCAPTCHA",company:"Google",category:"utility",domains:["*.recaptcha.net"],examples:["api.recaptcha.net"],totalExecutionTime:8694396,totalOccurrences:25662},{name:"GovMetric",company:"ROL Solutions",category:"analytics",domains:["*.govmetric.com"],totalExecutionTime:233,totalOccurrences:6},{name:"Granify",category:"analytics",domains:["*.granify.com"],totalExecutionTime:19211,totalOccurrences:24},{name:"Grapeshot",category:"ad",domains:["*.gscontxt.net","*.grapeshot.co.uk"],totalExecutionTime:4945,totalOccurrences:4},{name:"Gravity (AOL)",category:"analytics",domains:["*.grvcdn.com"]},{name:"Groovy Gecko",category:"content",domains:["*.ggwebcast.com","*.groovygecko.net"]},{name:"GroupM",category:"ad",domains:["*.qservz.com"]},{name:"Guardian Media",category:"ad",domains:["*.theguardian.com","*.guardian.co.uk"],examples:["oas.t\
heguardian.com"]},{name:"GumGum",category:"ad",domains:["*.gumgum.com"],totalExecutionTime:3440651,totalOccurrences:167535},{name:"Gumtree",category:"content",domains:["*.gumtree.com"]},{name:"H264 Codec",company:"Cisco",category:"other",domains:["*.openh264.org"]},{name:"HERE",category:"analytics",domains:["*.medio.com"]},{name:"HP Optimost",company:"Hewlett-Packard Development Company",category:"marketing",domains:["*.hp.com","d2uncb19xzxhzx.cloudfront.net"],examples:["by.marketinghub.hp.com","marketinghub.hp.com"],totalExecutionTime:420577,totalOccurrences:100},{name:"Has Offers",company:"TUNE",category:"ad",domains:["*.go2cloud.org"],totalExecutionTime:0,totalOccurrences:3},{name:"Hawk Search",category:"utility",domains:["*.hawksearch.com"],totalExecutionTime:15097,totalOccurrences:132},{name:"Haymarket Media Group",category:"content",domains:["*.brandrepublic.com","*.hbpl.co.uk"]},{name:"Heap",category:"analytics",domains:["*.heapanalytics.com"],totalExecutionTime:5187800,totalOccurrences:12078},
{name:"Hearst Communications",category:"content",domains:["*.h-cdn.co","*.hearstdigital.com","*.hearstlabs.com","*.hearst.io","*.cdnds.net"]},{name:"Heatmap",category:"analytics",domains:["*.heatmap.it"],totalExecutionTime:7337,totalOccurrences:141},{name:"Heroku",category:"other",domains:["*.herokuapp.com"],totalExecutionTime:12602535,totalOccurrences:14119},{name:"Hexton",category:"utility",domains:["*.hextom.com"],totalExecutionTime:10806589,totalOccurrences:24738},{name:"Hibernia Networks",category:"utility",domains:["*.hiberniacdn.com"]},{name:"High Impact Media",category:"ad",domains:["*.reactx.com"]},{name:"Highcharts",category:"utility",domains:["*.highcharts.com"],totalExecutionTime:746540,totalOccurrences:3181},{name:"Highwinds",category:"utility",domains:["*.hwcdn.net"]},{name:"HitsLink",category:"analytics",domains:["*.hitslink.com"],totalExecutionTime:1452,totalOccurrences:29},{name:"Hola Networks",category:"other",domains:["*.h-cdn.com"],totalExecutionTime:83024,totalOccurrences:42},
{name:"Hootsuite",category:"analytics",domains:["*.hootsuite.com"]},{name:"HotUKDeals",category:"analytics",domains:["*.hotukdeals.com"]},{name:"HotWords",company:"Media Response Group",category:"ad",domains:["*.hotwords.com.br"]},{name:"HotelsCombined",category:"content",domains:["*.datahc.com"],totalExecutionTime:81,totalOccurrences:2},{name:"Hoverr",category:"ad",domains:["*.hoverr.media"]},{name:"Hull.js",category:"utility",domains:["*.hull.io","*.hullapp.io"]},{name:"Hupso Website Analyzer",company:"Hupso",category:"analytics",domains:["*.hupso.com"],totalExecutionTime:20892,totalOccurrences:248},{name:"I-Behavior",company:"WPP",category:"ad",domains:["*.ib-ibi.com"],totalExecutionTime:23,totalOccurrences:35},{name:"i-mobile",company:"i-mobile",category:"ad",domains:["*.i-mobile.co.jp"],examples:["ssp-sync.i-mobile.co.jp"],totalExecutionTime:3701005,totalOccurrences:16595},{name:"IBM Digital Analytics",company:"IBM",category:"analytics",domains:["*.cmcore.com","coremetrics.com","d\
ata.coremetrics.com","data.de.coremetrics.com","libs.de.coremetrics.com","tmscdn.de.coremetrics.com","iocdn.coremetrics.com","libs.coremetrics.com","tmscdn.coremetrics.com","*.s81c.com","*.unica.com","*.coremetrics.eu"],examples:["data.coremetrics.eu"],totalExecutionTime:126790,totalOccurrences:169},{name:"IBM Digital Data Exchange",company:"IBM",category:"tag-manager",domains:["tagmanager.coremetrics.com"]},{name:"IBM Tealeaf",company:"IBM",category:"analytics",domains:["*.ibmcloud.com"],examples:["uscollector.tealeaf.ibmcloud.com"]},{name:"IBM Acoustic Campaign",company:"IBM",category:"analytics",domains:["www.sc.pages01.net","www.sc.pages02.net","www.sc.pages03.net","www.sc.pages04.net","www.sc.pages05.net","www.sc.pages06.net","www.sc.pages07.net","www.sc.pages08.net","www.sc.pages09.net","www.sc.pagesA.net"],examples:["https://www.sc.pages01.net/lp/static/js/iMAWebCookie.js"],totalExecutionTime:51361,totalOccurrences:417},{name:"ICF Technology",category:"content",domains:["*.camad\
s.net"]},{name:"IFDNRG",category:"hosting",domains:["*.ifdnrg.com"]},{name:"IMRG",category:"analytics",domains:["*.peermap.com","*.imrg.org"],examples:["benchmarking.imrg.org"]},{name:"IPONWEB",category:"ad",domains:["*.company-target.com","*.liadm.com","*.iponweb.net","*.p161.net"],examples:["pool.udsp.iponweb.net"],totalExecutionTime:8924906,totalOccurrences:39154},{name:"IQ Mobile",category:"utility",domains:["*.iqm.cc"]},{name:"IS Group",category:"hosting",domains:["*.creative-serving.com"],totalExecutionTime:2127,totalOccurrences:29},{name:"IT Dienstleistungen Tim Prinzkosky",category:"utility",domains:["*.flaticons.net"]},{name:"IXI Digital",company:"Equifax",category:"ad",domains:["*.ixiaa.com"]},{name:"IcoMoon",category:"cdn",domains:["d19ayerf5ehaab.cloudfront.net","d1azc1qln24ryf.cloudfront.net"],totalExecutionTime:54286,totalOccurrences:180},{name:"IdenTrust",category:"utility",domains:["*.identrust.com"],totalExecutionTime:2334,totalOccurrences:1},{name:"Ido",category:"cust\
omer-success",domains:["*.idio.co"],totalExecutionTime:2222,totalOccurrences:12},{name:"Ignition One",category:"marketing",domains:["*.searchignite.com"]},{name:"ImageShack",category:"content",domains:["*.yfrog.com"]},{name:"Imagen Studio",category:"utility",domains:["*.telephonesky.com"]},{name:"Imagini Holdings",category:"ad",domains:["*.vdna-assets.com"]},{name:"Img Safe",category:"content",domains:["*.imgsafe.org"]},{name:"Imgur",category:"utility",domains:["*.imgur.com"],totalExecutionTime:3538,totalOccurrences:30},{name:"Impact Radius",category:"ad",domains:["*.impactradius-event.com","*.impactradius-go.com","*.7eer.net","d3cxv97fi8q177.cloudfront.net","*.evyy.net","*.ojrq.net","utt.impactcdn.com","*.sjv.io"],examples:["a.impactradius-go.com","microsoft-uk.evyy.net"],totalExecutionTime:612310,totalOccurrences:4274},{name:"Improve Digital",category:"ad",domains:["*.360yield.com"],totalExecutionTime:28784,totalOccurrences:732},{name:"Improvely",category:"analytics",domains:["*.iljm\
p.com"],totalExecutionTime:129,totalOccurrences:3},{name:"InMobi",category:"ad",domains:["*.inmobi.com"],totalExecutionTime:24607375,totalOccurrences:126087},{name:"InSkin Media",category:"ad",domains:["*.inskinad.com","*.inskinmedia.com"]},{name:"Inbenta",category:"customer-success",domains:["*.inbenta.com"],totalExecutionTime:3923,totalOccurrences:7},{name:"Incisive Media",category:"content",domains:["*.incisivemedia.com"]},{name:"Indeed",category:"content",domains:["*.indeed.com"],totalExecutionTime:81347,totalOccurrences:55},{name:"Index Exchange",company:"WPP",category:"ad",domains:["*.casalemedia.com","*.indexww.com"],totalExecutionTime:892351,totalOccurrences:32324},{name:"Indoona",category:"other",domains:["*.indoona.com"]},{name:"Infectious Media",category:"ad",domains:["*.impdesk.com","*.impressiondesk.com","*.inmz.net"]},{name:"Inference Mobile",category:"ad",domains:["*.inferencemobile.com"]},{name:"Infinity Tracking",category:"analytics",domains:["*.infinity-tracking.net"],
totalExecutionTime:24308,totalOccurrences:250},{name:"Infoline",category:"analytics",domains:["*.ioam.de"],totalExecutionTime:8983,totalOccurrences:95},{name:"Infolinks",category:"ad",domains:["*.infolinks.com"],totalExecutionTime:7995389,totalOccurrences:5950},{name:"Infopark",category:"hosting",domains:["*.scrvt.com"]},{name:"Infusionsoft",category:"ad",domains:["*.infusionsoft.com"],totalExecutionTime:345182,totalOccurrences:723},{name:"Ink",category:"ad",domains:["*.inktad.com"]},{name:"Inktel Contact Center Solutions",company:"Inktel",category:"customer-success",domains:["*.inktel.com"]},{name:"Inneractive",category:"ad",domains:["*.inner-active.mobi"]},{name:"Innovid",category:"ad",homepage:"https://www.innovid.com/",domains:["*.innovid.com"],examples:["ag.innovid.com","rtr.innovid.com"],totalExecutionTime:115267,totalOccurrences:1363},{name:"Insight Express",category:"analytics",domains:["*.insightexpressai.com"],totalExecutionTime:1,totalOccurrences:2},{name:"Insipio",category:"\
other",domains:["*.insipio.com"]},{name:"Inspectlet",category:"analytics",domains:["*.inspectlet.com"],totalExecutionTime:7622183,totalOccurrences:5346},{name:"Instansive",category:"utility",domains:["*.instansive.com"]},{name:"Instart",homepage:"https://www.instart.com/",category:"utility",domains:["*.insnw.net"]},{name:"Instembedder",category:"content",domains:["*.instaembedder.com"]},{name:"Instinctive",category:"ad",domains:["*.instinctiveads.com"]},{name:"Intelligent Reach",category:"ad",domains:["*.ist-track.com"]},{name:"Intent HQ",category:"analytics",domains:["*.intenthq.com"]},{name:"Intent IQ",category:"ad",domains:["*.intentiq.com"],totalExecutionTime:48447,totalOccurrences:1146},{name:"Intercept Interactive",category:"ad",domains:["*.undertone.com"],totalExecutionTime:2293921,totalOccurrences:21012},{name:"Interest Graph",company:"AOL",category:"ad",domains:["*.gravity.com"]},{name:"Internet Brands",category:"content",domains:["*.ibpxl.com"]},{name:"Interpublic Group",category:"\
ad",domains:["*.mbww.com"]},{name:"Interstate",category:"analytics",domains:["*.interstateanalytics.com"]},{name:"Interview",category:"analytics",domains:["*.efm.me"]},{name:"Intilery",category:"customer-success",domains:["*.intilery-analytics.com"]},{name:"Investis",category:"utility",domains:["*.investis.com"],totalExecutionTime:244162,totalOccurrences:282},{name:"Investis Flife",category:"hosting",domains:["*.quartalflife.com"]},{name:"Invodo",category:"ad",domains:["*.invodo.com"],examples:["e.invodo.com"]},{name:"iSite",category:"analytics",domains:["*.isitetv.com"],examples:["static.isitetv.com","events.isitetv.com"]},{name:"Issue",category:"content",domains:["*.issue.by"]},{name:"J.D. Williams & Co",category:"content",domains:["*.drct2u.com"]},{name:"Janrain",category:"analytics",domains:["*.janrain.com","*.janrainbackplane.com","*.rpxnow.com","d3hmp0045zy3cs.cloudfront.net"],totalExecutionTime:4006,totalOccurrences:21},{name:"Jellyfish",category:"ad",domains:["*.jellyfish.net"]},
{name:"JetStream",category:"content",domains:["*.xlcdn.com"]},{name:"JingDong",category:"content",domains:["*.3.com","*.jd.com"],totalExecutionTime:119043,totalOccurrences:84},{name:"Jivox",category:"ad",domains:["*.jivox.com"],totalExecutionTime:31166,totalOccurrences:65},{name:"Jobvite",category:"content",domains:["*.jobvite.com"],totalExecutionTime:6667,totalOccurrences:4},{name:"Johnston Press",category:"content",domains:["*.johnstonpress.co.uk","*.jpress.co.uk"]},{name:"Join the Dots (Research)",category:"social",domains:["*.jtdiscuss.com"]},{name:"JotForm",category:"utility",domains:["*.jotformpro.com"]},{name:"JuicyAds",category:"ad",domains:["*.juicyads.com"],totalExecutionTime:543292,totalOccurrences:2092},{name:"JustPremium",category:"ad",domains:["*.net.net"],examples:["d2nvliyzbo36lk.cloudfrontd2nvliyzbo36lk.cloudfront.net.net"]},{name:"JustPremium Ads",company:"JustPremium",category:"ad",domains:["*.justpremium.com"],totalExecutionTime:1061,totalOccurrences:35},{name:"Just\
Uno",category:"ad",domains:["*.justuno.com","d2j3qa5nc37287.cloudfront.net"],totalExecutionTime:773949,totalOccurrences:1448},{name:"KINX (Korea Internet Neutral eXchange)",category:"other",domains:["*.kinxcdn.com"],totalExecutionTime:1433,totalOccurrences:4},{name:"KISSmetrics",category:"analytics",domains:["*.kissmetrics.com","doug1izaerwt3.cloudfront.net","dsyszv14g9ymi.cloudfront.net"],totalExecutionTime:3896,totalOccurrences:46},{name:"Kaizen Platform",category:"analytics",domains:["*.kaizenplatform.net"],examples:["cdn.kaizenplatform.net","log-v4.kaizenplatform.net"],totalExecutionTime:85284,totalOccurrences:183},{name:"Kakao",category:"social",domains:["*.daum.net","*.daumcdn.net"],totalExecutionTime:38351047,totalOccurrences:62730},{name:"Kaltura Video Platform",company:"Kaltura",category:"content",domains:["*.kaltura.com"],examples:["cdnsecakmi.kaltura.com"],totalExecutionTime:2164237,totalOccurrences:1017},{name:"Kameleoon",homepage:"https://www.kameleoon.com/",category:"anal\
ytics",domains:["*.kameleoon.com","*.kameleoon.eu","*.kameleoon.io"],examples:["data.kameleoon.io","kdm3fpv6il.kameleoon.eu"],totalExecutionTime:2217218,totalOccurrences:2337},{name:"Kampyle",category:"analytics",domains:["*.kampyle.com"],totalExecutionTime:413304,totalOccurrences:702},{name:"Kantar",category:"analytics",domains:["*.sesamestats.com"]},{name:"Kargo",category:"marketing",domains:["*.kargo.com"],totalExecutionTime:48285,totalOccurrences:1135},{name:"KARTE",company:"Plaid",homepage:"https://karte.io/",category:"marketing",domains:["*.karte.io"],examples:["static.karte.io","t.karte.io"],totalExecutionTime:1712123,totalOccurrences:1729},{name:"Kauli",category:"ad",domains:["*.kau.li"]},{name:"Keen",company:"Keen",homepage:"https://keen.io/",category:"analytics",domains:["*.keen.io","d26b395fwzu5fz.cloudfront.net"],totalExecutionTime:24210,totalOccurrences:416},{name:"Kelkoo",category:"hosting",domains:["*.kelkoo.com"]},{name:"Kenshoo",category:"marketing",domains:["*.xg4ken.\
com"],totalExecutionTime:710,totalOccurrences:18},{name:"Key CDN",category:"utility",domains:["*.kxcdn.com"],totalExecutionTime:4814875,totalOccurrences:10025},{name:"Keynote",company:"Dynatrace",category:"analytics",domains:["*.keynote.com"]},{name:"Keywee",category:"ad",domains:["*.keywee.co"],totalExecutionTime:44984,totalOccurrences:259},{name:"Kiosked",category:"ad",domains:["*.kiosked.com"],totalExecutionTime:343355,totalOccurrences:173},{name:"Klarna",category:"utility",domains:["*.klarna.com"],totalExecutionTime:1374032,totalOccurrences:10759},{name:"Klaviyo",category:"ad",domains:["*.klaviyo.com"],totalExecutionTime:113130218,totalOccurrences:161289},{name:"Klevu Search",company:"Klevu",category:"utility",domains:["*.klevu.com"],totalExecutionTime:1124647,totalOccurrences:1463},{name:"Klick2Contact",category:"customer-success",domains:["*.klick2contact.com"]},{name:"Knight Lab",company:"Northwestern University",category:"utility",domains:["*.knightlab.com"],totalExecutionTime:350550,
totalOccurrences:448},{name:"Kodajo",category:"other",domains:["*.kodajo.com"]},{name:"Komoona",category:"ad",domains:["*.komoona.com"]},{name:"Korrelate",company:"JD Power",category:"analytics",domains:["*.korrelate.net"]},{name:"LKQD",category:"ad",domains:["*.lkqd.net"]},{name:"Layer0",category:"cdn",domains:["*.layer0.co"],examples:["rum.layer0.co"]},{name:"Layershift",category:"hosting",domains:["109.109.138.174"]},{name:"Lead Forensics",category:"ad",domains:["*.200summit.com","*.baw5tracker.com","*.business-path-55.com","*.bux1le001.com","*.central-core-7.com","*.direct-azr-78.com","*.explore-123.com","*.forensics1000.com","*.gldsta-02-or.com","*.green-bloc9.com","*.lansrv040.com","*.lead-123.com","*.leadforensics.com","*.mavic852.com","*.mon-com-net.com","*.peak-ip-54.com","*.snta0034.com","*.svr-prc-01.com","*.syntace-094.com","*.tghbn12.com","*.trail-web.com","*.web-01-gbl.com","*.web-cntr-07.com","*.trackdiscovery.net"],examples:["www.baw5tracker.com","www.lansrv040.com","ww\
w.mon-com-net.com","www.peak-ip-54.com","www.tghbn12.com","www.web-01-gbl.com"],totalExecutionTime:45938,totalOccurrences:307},{name:"Lead Intelligence",company:"Magnetise Solutions",category:"ad",domains:["*.leadintelligence.co.uk"]},{name:"LeadLander",category:"analytics",domains:["*.formalyzer.com","*.trackalyzer.com"]},{name:"Leaflet",category:"utility",domains:["*.leafletjs.com"],totalExecutionTime:3668,totalOccurrences:69},{name:"LeasdBoxer",company:"LeadBoxer",category:"ad",domains:["*.leadboxer.com"],totalExecutionTime:15328,totalOccurrences:118},{name:"LeaseWeb",homepage:"https://www.leaseweb.com/",category:"cdn",domains:["*.lswcdn.net","*.leasewebcdn.com"]},{name:"Leboncoin",category:"content",domains:["*.leboncoin.fr"]},{name:"Lengow",category:"hosting",domains:["*.lengow.com"]},{name:"Lessbuttons",category:"social",domains:["*.lessbuttons.com"]},{name:"Letter Press",category:"ad",domains:["*.getletterpress.com"]},{name:"Level 3 Communications",category:"utility",domains:["f\
ootprint.net"]},{name:"Level3",category:"other",domains:["secure.footprint.net"]},{name:"Lifestreet Media",category:"social",domains:["*.lfstmedia.com"]},{name:"LiftSuggest",category:"analytics",domains:["d2blwevgjs7yom.cloudfront.net"]},{name:"Ligatus",category:"ad",domains:["*.ligadx.com"]},{name:"LightStep",category:"analytics",domains:["*.lightstep.com"]},{name:"LightWidget",category:"utility",domains:["*.lightwidget.com"],totalExecutionTime:1825559,totalOccurrences:9383},{name:"Likelihood",company:"LIkeihood",category:"hosting",domains:["*.likelihood.com"],examples:["client.likelihood.com"]},{name:"LikeShop",company:"Dash Hudson",category:"content",domains:["likeshop.me"],examples:["likeshop.me"]},{name:"LINE Corporation",category:"ad",domains:["*.line-scdn.net","*.line.me"],examples:["d.line-scdn.net","tr.line.me"],totalExecutionTime:3858282,totalOccurrences:26881},{name:"Linkcious",category:"analytics",domains:["*.linkcious.com"]},{name:"Linking Mobile",category:"ad",domains:["*\
.linkingmobile.com"]},{name:"LittleData",category:"analytics",homepage:"https://www.littledata.io/",domains:["*.littledata.io"],examples:["transactions.littledata.io"],totalExecutionTime:832,totalOccurrences:1},{name:"LiveBurst",category:"ad",domains:["*.liveburst.com"]},{name:"LiveClicker",category:"ad",domains:["*.liveclicker.net"]},{name:"LiveHelpNow",category:"customer-success",domains:["*.livehelpnow.net"],totalExecutionTime:284671,totalOccurrences:819},{name:"LiveInternet",category:"analytics",domains:["*.yadro.ru"]},{name:"LiveJournal",category:"social",domains:["*.livejournal.com","*.livejournal.net"],totalExecutionTime:63532309,totalOccurrences:9109},{name:"LivePerson",category:"customer-success",homepage:"https://www.liveperson.com/",domains:["*.liveperson.com","*.look.io","*.liveperson.net","*.lpsnmedia.net"],totalExecutionTime:1930619,totalOccurrences:2544},{name:"LiveRail",company:"Facebook",category:"ad",domains:["*.liverail.com","*.lrcdn.net"],examples:["scontent.lrcdn.n\
et"]},{name:"LiveTex",category:"customer-success",domains:["*.livetex.ru"],totalExecutionTime:476954,totalOccurrences:1911},{name:"Livefyre",category:"content",domains:["*.fyre.co","*.livefyre.com"]},{name:"Living Map Company",category:"utility",domains:["*.livingmap.com"]},{name:"Local World",category:"content",domains:["*.thelocalpeople.co.uk"]},{name:"LockerDome",category:"analytics",domains:["*.lockerdome.com"],totalExecutionTime:244,totalOccurrences:3},{name:"Logentries",company:"Rapid",category:"utility",domains:["*.logentries.com"],examples:["js.logentries.com"]},{name:"Logicalis",category:"analytics",domains:["*.trovus.co.uk"]},{name:"LoginRadius",company:"LoginRadius",homepage:"https://www.loginradius.com/",category:"ad",domains:["*.loginradius.com","*.lrcontent.com"],examples:["config.lrcontent.com"],totalExecutionTime:15746,totalOccurrences:131},{name:"LongTail Ad Solutions",category:"ad",domains:["*.jwpcdn.com","*.jwplatform.com","*.jwplayer.com","*.jwpltx.com","*.jwpsrv.co\
m","*.longtailvideo.com"],totalExecutionTime:4531393,totalOccurrences:5572},{name:"Loop Commerce",category:"other",domains:["*.loopassets.net"]},{name:"Loop11",category:"analytics",domains:["*.loop11.com"],totalExecutionTime:22278,totalOccurrences:28},{name:"LoopMe",category:"ad",domains:["*.loopme.biz","*.loopme.com","*.vntsm.com","*.loopme.me"],totalExecutionTime:2112781,totalOccurrences:11752},{name:"Looper",category:"content",domains:["*.looper.com"]},{name:"Loyalty Point",category:"ad",domains:["*.loyaltypoint.pl"]},{name:"LoyaltyLion",category:"ad",domains:["*.loyaltylion.com","*.loyaltylion.net","dg1f2pfrgjxdq.cloudfront.net"],totalExecutionTime:2971522,totalOccurrences:4114},{name:"Luma Tag",category:"analytics",domains:["*.lumatag.co.uk"]},{name:"Lumesse",category:"content",domains:["*.recruitmentplatform.com"]},{name:"Luminate",category:"ad",domains:["*.luminate.com"]},{name:"Lynchpin Analytics",category:"analytics",domains:["*.lypn.net"]},{name:"Lyris",category:"ad",domains:[
"*.clicktracks.com"]},{name:"Lytics",category:"ad",domains:["*.lytics.io"],totalExecutionTime:272463,totalOccurrences:857},{name:"MEC WebTrack",company:"MEC",category:"ad",domains:["*.e-webtrack.net"]},{name:"MECLABS Institute",category:"analytics",domains:["*.meclabs.com","*.meclabsdata.com"]},{name:"MLveda",category:"utility",domains:["*.mlveda.com"],examples:["www.mlveda.com"],totalExecutionTime:109345,totalOccurrences:229},{name:"Macromill",company:"Macromill",category:"analytics",homepage:"https://group.macromill.com/",domains:["*.macromill.com"],examples:["img.macromill.com/js/us000131vfg/4000000570-56/lognos.js"],totalExecutionTime:5731,totalOccurrences:9},{name:"Macropod BugHerd",company:"Macropod",category:"utility",domains:["*.bugherd.com"],examples:["www.bugherd.com"],totalExecutionTime:512091,totalOccurrences:3523},{name:"Madison Logic",category:"marketing",domains:["*.ml314.com"],totalExecutionTime:101,totalOccurrences:3},{name:"Madmetrics",company:"Keyade",category:"analy\
tics",domains:["*.keyade.com"]},{name:"Magnetic",category:"ad",domains:["*.domdex.com","d3ezl4ajpp2zy8.cloudfront.net"]},{name:"Magnetic Platform",company:"Magnetic",category:"ad",domains:["*.magnetic.is"]},{name:"MailMunch",category:"ad",domains:["*.mailmunch.co"],totalExecutionTime:1414543,totalOccurrences:19969},{name:"MailPlus",category:"ad",domains:["*.mailplus.nl"],totalExecutionTime:83524,totalOccurrences:304},{name:"Mapbox",category:"utility",domains:["*.mapbox.com"],totalExecutionTime:13815633,totalOccurrences:19555},{name:"Maptive",category:"utility",domains:["*.maptive.com"]},{name:"Marcaria.com",category:"other",domains:["*.gooo.al"]},{name:"Marchex",category:"analytics",domains:["*.voicestar.com","*.marchex.io"],totalExecutionTime:1378181,totalOccurrences:7390},{name:"Mark and Mini",category:"ad",domains:["*.markandmini.com"],examples:["www.markandmini.com"]},{name:"Marker",category:"utility",domains:["*.marker.io"],examples:["edge.marker.io"],totalExecutionTime:2331726,totalOccurrences:1722},
{name:"Marketing Dashboards",company:"GroupM",category:"analytics",domains:["*.m-decision.com"]},{name:"Marketizator",category:"analytics",domains:["*.marketizator.com"]},{name:"Marketplace Web Service",company:"Amazon",category:"other",domains:["*.ssl-images-amazon.com"],totalExecutionTime:234709,totalOccurrences:451},{name:"Mashable",category:"social",domains:["*.mshcdn.com"]},{name:"MatchWork",category:"utility",domains:["*.matchwork.com"]},{name:"MathJax",category:"utility",domains:["*.mathjax.org"],totalExecutionTime:84751,totalOccurrences:743},{name:"Mather Economics",category:"analytics",domains:["*.matheranalytics.com"],totalExecutionTime:262501,totalOccurrences:507},{name:"MaxCDN Enterprise",company:"MaxCDN",category:"utility",domains:["*.netdna-cdn.com","*.netdna-ssl.com"]},{name:"MaxMind",category:"utility",domains:["*.maxmind.com"],totalExecutionTime:855332,totalOccurrences:831},{name:"MaxPoint Interactive",category:"ad",domains:["*.mxptint.net"],totalExecutionTime:20140,totalOccurrences:23834},
{name:"Maxsi",category:"analytics",domains:["*.evisitanalyst.com"]},{name:"Maxymiser",category:"analytics",domains:["*.maxymiser.net, maxymiser.hs.llnwd.net"]},{name:"McAffee",category:"utility",domains:["*.mcafeesecure.com","*.scanalert.com"]},{name:"Measured",category:"analytics",domains:["*.measured.com"],examples:["tag.measured.com"],homepage:"https://www.measured.com/"},{name:"Media IQ",category:"analytics",domains:["*.mediaiqdigital.com"]},{name:"Media Management Technologies",category:"ad",domains:["*.speedshiftmedia.com"],totalExecutionTime:27147,totalOccurrences:161},{name:"Media Temple",category:"hosting",domains:["*.goodlayers2.com"]},{name:"Mediabong",category:"ad",domains:["*.mediabong.net"]},{name:"Mediahawk",category:"analytics",domains:["*.mediahawk.co.uk"],totalExecutionTime:51393,totalOccurrences:239},{name:"Mediahub",category:"ad",domains:["*.hubverifyandoptimize.com","*.projectwatchtower.com"]},{name:"Mediasyndicator",category:"ad",domains:["*.creativesyndicator.com"]},
{name:"Medium",category:"content",domains:["*.medium.com"],totalExecutionTime:216923262,totalOccurrences:17027},{name:"Meetrics",category:"ad",domains:["*.de.com","*.meetrics.net","*.mxcdn.net"],examples:["research.de.com"],totalExecutionTime:102809,totalOccurrences:63},{name:"Mega",company:"Mega Information Technology",category:"other",domains:["*.mgcdn.com"]},{name:"Melt",category:"ad",domains:["*.meltdsp.com","*.mesp.com"]},{name:"Meltwater Group",category:"customer-success",domains:["*.meltwaternews.com"]},{name:"Meme",category:"ad",domains:["*.viewwonder.com"]},{name:"MentAd",category:"ad",domains:["*.mentad.com"]},{name:"Mention Me",category:"ad",domains:["*.mention-me.com"],examples:["tag.mention-me.com"],totalExecutionTime:15233,totalOccurrences:44},{name:"Merchant Equipment Store",category:"utility",domains:["*.merchantequip.com"],totalExecutionTime:268,totalOccurrences:1},{name:"Merchenta",category:"customer-success",domains:["*.merchenta.com"]},{name:"Merkle Digital Data Exc\
hange",company:"Merkle",category:"ad",domains:["*.brilig.com"]},{name:"Merkle Paid Search",company:"Merkle",category:"ad",domains:["*.rkdms.com"],totalExecutionTime:69291,totalOccurrences:407},{name:"Met Office",category:"content",domains:["*.metoffice.gov.uk"],totalExecutionTime:15029,totalOccurrences:19},{name:"Meta Broadcast",category:"social",domains:["*.metabroadcast.com"],examples:["voila.metabroadcast.com"]},{name:"Michael Associates",category:"ad",domains:["*.checktestsite.com"],examples:["www.checktestsite.com"]},{name:"Michelin",category:"content",domains:["*.viamichelin.com"],totalExecutionTime:8087,totalOccurrences:7},{name:"Microad",category:"ad",domains:["*.microad.jp"],totalExecutionTime:14626755,totalOccurrences:23909},{name:"Microsoft Certificate Services",company:"Microsoft",category:"utility",domains:["*.msocsp.com"]},{name:"Microsoft Hosted Libs",company:"Microsoft",category:"cdn",domains:["*.aspnetcdn.com"],examples:["ajax.aspnetcdn.com"],totalExecutionTime:4562478,
totalOccurrences:20042},{name:"Microsoft XBox Live",company:"Microsoft",category:"marketing",domains:["*.xboxlive.com"]},{name:"Mightypop",category:"ad",domains:["*.mightypop.ca"]},{name:"Mika Tuupola",category:"utility",domains:["*.appelsiini.net"]},{name:"Millennial Media",category:"ad",domains:["*.jumptap.com"]},{name:"Mirror Image Internet",category:"utility",domains:["*.miisolutions.net"]},{name:"Mobify",category:"utility",domains:["*.mobify.com","*.mobify.net"]},{name:"Mobile Nations",category:"social",domains:["*.mobilenations.com"]},{name:"Mobivate",category:"ad",domains:["*.mobivatebulksms.com"]},{name:"Momondo",category:"content",domains:["*.momondo.dk"]},{name:"Momondo Group",category:"content",domains:["*.momondogrouo.com","*.momondogroup.com"]},{name:"Monarch Ads",category:"ad",domains:["*.monarchads.com"]},{name:"Monetate",category:"analytics",domains:["*.monetate.net"],totalExecutionTime:260345,totalOccurrences:599},{name:"MonetizeMore",category:"ad",domains:["*.m2.ai"],
totalExecutionTime:8896,totalOccurrences:47},{name:"Monitor",company:"Econda",category:"analytics",domains:["*.econda-monitor.de"],examples:["www.econda-monitor.de"]},{name:"Monkey Frog Media",category:"content",domains:["*.monkeyfrogmedia.com"]},{name:"Monotype",category:"cdn",domains:["*.fonts.com","*.fonts.net"],totalExecutionTime:729465,totalOccurrences:3185},{name:"Moore-Wilson",category:"ad",domains:["*.mwdev.co.uk"]},{name:"Moovweb",category:"utility",domains:["*.moovweb.net"]},{name:"Mopinion",category:"analytics",domains:["*.mopinion.com"],totalExecutionTime:171681,totalOccurrences:177},{name:"MotionPoint",category:"other",domains:["*.convertlanguage.com"],totalExecutionTime:1843,totalOccurrences:35},{name:"Mouse3K",category:"analytics",domains:["*.mouse3k.com"]},{name:"MouseStats",category:"analytics",domains:["*.mousestats.com"]},{name:"Mouseflow",homepage:"https://mouseflow.com/",category:"analytics",domains:["*.mouseflow.com"],totalExecutionTime:331345,totalOccurrences:6786},
{name:"Movable Ink",category:"analytics",domains:["*.micpn.com"],totalExecutionTime:439979,totalOccurrences:4949},{name:"MovingIMAGE24",category:"content",domains:["*.edge-cdn.net"]},{name:"Moxielinks",category:"ad",domains:["*.moxielinks.com"]},{name:"Moz Recommended Companies",company:"Moz",category:"analytics",domains:["d2eeipcrcdle6.cloudfront.net"]},{name:"Mozilla",category:"utility",domains:["*.mozilla.org"],examples:["aus5.mozilla.org"],totalExecutionTime:21085,totalOccurrences:32},{name:"Multiview",category:"content",domains:["*.multiview.com","*.track-mv.com"],totalExecutionTime:8831,totalOccurrences:58},{name:"Mux",category:"analytics",domains:["*.litix.io"],totalExecutionTime:91580,totalOccurrences:249},{name:"MyAds",company:"MyBuys",category:"analytics",domains:["*.veruta.com"]},{name:"MyBuys",category:"analytics",domains:["*.mybuys.com"]},{name:"MyFonts",category:"cdn",domains:["*.myfonts.net"],totalExecutionTime:78,totalOccurrences:4},{name:"MyRegistry",category:"other",domains:[
"*.myregistry.com"],totalExecutionTime:164086,totalOccurrences:621},{name:"MySpace",company:"Specific Media",category:"social",domains:["*.myspace.com"]},{name:"Mynewsdesk",category:"utility",domains:["*.mynewsdesk.com"],totalExecutionTime:564,totalOccurrences:31},{name:"NAVIS",category:"content",domains:["*.navistechnologies.info"]},{name:"NCC Group Real User Monitoring",company:"NCC Group",category:"analytics",domains:["*.nccgroup-webperf.com"],examples:["beacon-rumlive.rum.nccgroup-webperf.com","config-rumlive.rum.nccgroup-webperf.com","script-rumlive.rum.nccgroup-webperf.com"]},{name:"NEORY Marketing Cloud",company:"NEORY",category:"marketing",domains:["*.ad-srv.net"],totalExecutionTime:10976,totalOccurrences:240},{name:"Nanigans",category:"ad",domains:["*.nanigans.com"]},{name:"Nano Interactive",category:"ad",domains:["*.audiencemanager.de"],totalExecutionTime:780,totalOccurrences:10},{name:"Nanorep",company:"Nanorep Technologies",category:"customer-success",domains:["*.nanorep.co\
m"]},{name:"Narrative",category:"ad",domains:["*.narrative.io"],totalExecutionTime:1228,totalOccurrences:2},{name:"Native Ads",category:"ad",domains:["*.nativeads.com"]},{name:"Nativo",category:"ad",domains:["*.postrelease.com"],totalExecutionTime:28260,totalOccurrences:35852},{name:"Navegg",category:"ad",domains:["*.navdmp.com"],totalExecutionTime:51915,totalOccurrences:805},{name:"NaviStone",category:"ad",domains:["*.murdoog.com"]},{name:"Naytev",category:"analytics",domains:["*.naytev.com"]},{name:"Needle",category:"analytics",domains:["*.needle.com"]},{name:"Neiman Marcus",category:"content",domains:["*.ctscdn.com"]},{name:"Nend",category:"ad",domains:["*.nend.net"]},{name:"Neodata",category:"ad",domains:["*.neodatagroup.com"],totalExecutionTime:12827,totalOccurrences:86},{name:"Net Applications",category:"analytics",domains:["*.hitsprocessor.com"]},{name:"Net Reviews",category:"analytics",domains:["*.avis-verifies.com"],examples:["www.avis-verifies.com"],totalExecutionTime:1143140,
totalOccurrences:2442},{name:"NetAffiliation",company:"Kwanco",category:"ad",domains:["*.metaffiliation.com"],totalExecutionTime:18519,totalOccurrences:127},{name:"NetDirector",company:"G-Forces Web Management",category:"other",domains:["*.netdirector.co.uk"],totalExecutionTime:3931,totalOccurrences:1},{name:"NetFlix",category:"content",domains:["*.nflxext.com","*.nflximg.net"],totalExecutionTime:4364,totalOccurrences:5},{name:"Nielsen NetRatings SiteCensus",company:"The Nielsen Company",homepage:"http://www.nielsen-online.com/intlpage.html",category:"analytics",domains:["*.imrworldwide.com"],totalExecutionTime:6840006,totalOccurrences:19525},{name:"NetSeer",category:"ad",domains:["*.netseer.com","*.ns-cdn.com"]},{name:"NetShelter",company:"Ziff Davis Tech",category:"ad",domains:["*.netshelter.net"]},{name:"Netmining",company:"Ignition One",category:"ad",domains:["*.netmng.com"],totalExecutionTime:7746,totalOccurrences:92},{name:"Netop",category:"customer-success",domains:["*.netop.com"]},
{name:"Network Solutions",category:"utility",domains:["*.netsolssl.com","*.networksolutions.com"],examples:["ocsp.netsolssl.com"],totalExecutionTime:2415,totalOccurrences:2},{name:"Neustar AdAdvisor",company:"Neustar",category:"ad",domains:["*.adadvisor.net"]},{name:"New Approach Media",category:"ad",domains:["*.newapproachmedia.co.uk"]},{name:"NewShareCounts",category:"social",domains:["*.newsharecounts.com"]},{name:"News",category:"social",domains:["*.news.com.au","*.newsanalytics.com.au","*.newsapi.com.au","*.newscdn.com.au","*.newsdata.com.au","*.newsdiscover.com.au","*.news-static.com"],totalExecutionTime:69261,totalOccurrences:46},{name:"Newsquest",category:"content",domains:["*.newsquestdigital.co.uk"]},{name:"Newzulu",category:"content",domains:["*.filemobile.com","*.projects.fm"]},{name:"Nexcess.Net",category:"hosting",domains:["*.nexcesscdn.net"]},{name:"Nexstar Media Group",category:"ad",domains:["*.yashi.com"]},{name:"NextPerf",company:"Rakuten Marketing",category:"ad",domains:[
"*.nxtck.com"]},{name:"Nine.com.au",company:"Nine Digital",category:"content",domains:["*.9msn.com.au"]},{name:"NitroSell",category:"hosting",domains:["*.nitrosell.com"]},{name:"Nochex",category:"utility",domains:["*.nochex.com"]},{name:"Northern &amp; Shell Media Group",category:"content",domains:["*.northernandshell.co.uk"]},{name:"Nosto",category:"analytics",domains:["*.nosto.com"],totalExecutionTime:703736,totalOccurrences:1189},{name:"Now Interact",category:"analytics",domains:["*.nowinteract.com"]},{name:"Numberly",company:"1000mercis",category:"ad",domains:["*.mmtro.com","*.nzaza.com"],totalExecutionTime:1827,totalOccurrences:19},{name:"NyaConcepts",category:"analytics",domains:["*.xclusive.ly"]},{name:"O2",category:"other",domains:["*.o2.co.uk"],examples:["servedby.o2.co.uk"]},{name:"GoDaddy",homepage:"https://www.godaddy.com/",category:"utility",domains:["*.godaddy.com","*.wsimg.com"],examples:["ocsp.godaddy.com","seal.godaddy.com"],totalExecutionTime:94698135,totalOccurrences:110342},
{name:"ObjectPlanet",category:"analytics",domains:["*.easypolls.net"],totalExecutionTime:28470,totalOccurrences:70},{name:"OhMyAd",category:"ad",domains:["*.ohmyad.co"],examples:["pr.ohmyad.co"]},{name:"Okas Concepts",category:"utility",domains:["*.okasconcepts.com"],totalExecutionTime:1483515,totalOccurrences:661},{name:"Okta",category:"analytics",domains:["*.okta.com"],totalExecutionTime:1464920,totalOccurrences:3542},{name:"Olapic",category:"content",domains:["*.photorank.me"],totalExecutionTime:115,totalOccurrences:2},{name:"Ometria",category:"analytics",domains:["*.ometria.com"],totalExecutionTime:16630,totalOccurrences:204},{name:"Omniconvert",category:"analytics",domains:["*.omniconvert.com","d2tgfbvjf3q6hn.cloudfront.net","d3vbj265bmdenw.cloudfront.net"],totalExecutionTime:85855,totalOccurrences:381},{name:"Omniroot",company:"Verizon",category:"utility",domains:["*.omniroot.com"],examples:["ocsp.omniroot.com","vassg142.ocsp.omniroot.com"]},{name:"OnAudience",company:"Cloud Tech\
nologies",category:"ad",domains:["*.onaudience.com"]},{name:"OnScroll",category:"ad",domains:["*.onscroll.com"]},{name:"OnState",category:"ad",domains:["*.onstate.co.uk"]},{name:"OnYourMap",category:"utility",domains:["*.onyourmap.com"]},{name:"One by AOL",company:"AOL",category:"ad",domains:["*.adtechjp.com","*.adtech.de"],totalExecutionTime:1140,totalOccurrences:17},{name:"One by AOL:Mobile",company:"AOL",category:"ad",domains:["*.nexage.com"],examples:["ads.nexage.com","hb.nexage.com"]},{name:"OneAll",category:"analytics",domains:["*.oneall.com"],totalExecutionTime:104501,totalOccurrences:623},{name:"OneSoon",category:"analytics",domains:["*.adalyser.com"],totalExecutionTime:33037,totalOccurrences:437},{name:"OneTag",category:"ad",domains:["*.onetag-sys.com"]},{name:"Onet",category:"ad",domains:["*.onet.pl"],totalExecutionTime:531334,totalOccurrences:760},{name:"Online Rewards",company:"Mastercard",category:"ad",domains:["*.loyaltygateway.com"]},{name:"Online republic",category:"con\
tent",domains:["*.imallcdn.net"],totalExecutionTime:67122,totalOccurrences:58},{name:"Ooyala",category:"ad",domains:["*.ooyala.com"]},{name:"OpenTable",company:"Priceline Group",category:"content",domains:["*.opentable.com","*.opentable.co.uk","*.toptable.co.uk"],examples:["www.toptable.co.uk"],totalExecutionTime:412090,totalOccurrences:4314},{name:"OpenX Ad Exchange",company:"OpenX Technologies",category:"ad",domains:["*.liftdna.com"]},{name:"Opinion Stage",category:"analytics",domains:["*.opinionstage.com"],examples:["www.opinionstage.com"],totalExecutionTime:113206,totalOccurrences:145},{name:"OpinionBar",category:"analytics",domains:["*.opinionbar.com"]},{name:"Opta",company:"Perform Group",category:"content",domains:["*.opta.net"],totalExecutionTime:302785,totalOccurrences:272},{name:"OptiMonk",category:"ad",domains:["*.optimonk.com"],totalExecutionTime:10318415,totalOccurrences:10615},{name:"Optilead",category:"analytics",domains:["*.dyn-img.com","*.leadcall.co.uk","*.optilead.co\
.uk"]},{name:"Optimatic",category:"ad",domains:["*.optimatic.com"],examples:["synch.optimatic.com"]},{name:"Optimise Media Group",category:"utility",domains:["*.omguk.com"],totalExecutionTime:6691,totalOccurrences:41},{name:"Optimost",company:"OpenText",category:"ad",domains:["*.optimost.com"]},{name:"Optimove",company:"Mobius Solutions",category:"analytics",domains:["*.optimove.net"],totalExecutionTime:22679,totalOccurrences:293},{name:"Optorb",category:"ad",domains:["*.optorb.com"]},{name:"Oracle",category:"marketing",domains:["*.custhelp.com","*.eloqua.com","*.en25.com","*.estara.com","*.instantservice.com"],totalExecutionTime:684920,totalOccurrences:569},{name:"Oracle Recommendations On Demand",company:"Oracle",category:"analytics",domains:["*.atgsvcs.com"],totalExecutionTime:8696,totalOccurrences:96},{name:"Oracle Responsys",company:"Oracle",category:"marketing",domains:["*.adrsp.net","*.responsys.net"]},{name:"Order Security-VOID",company:"Order Security",category:"analytics",domains:[
"*.order-security.com"]},{name:"Oriel",category:"ad",domains:["*.oriel.io"]},{name:"Outbrain",homepage:"https://www.outbrain.com/",category:"ad",domains:["*.outbrain.com","*.outbrainimg.com","*.visualrevenue.com"],totalExecutionTime:3373858,totalOccurrences:13287},{name:"OverStream",company:"Coull",category:"ad",domains:["*.coull.com"],examples:["ex1.coull.com"]},{name:"Overdrive",category:"content",domains:["*.contentreserve.com"]},{name:"Overstock",category:"utility",domains:["*.ostkcdn.com"]},{name:"OwnerIQ",category:"ad",domains:["*.owneriq.net"],totalExecutionTime:305561,totalOccurrences:2173},{name:"OzCart",category:"utility",domains:["*.ozcart.com.au"]},{name:"Ozone Media",category:"ad",domains:["*.adadyn.com"]},{name:"Loqate",company:"Loqate",category:"other",domains:["*.pcapredict.com","*.postcodeanywhere.co.uk"],totalExecutionTime:136866,totalOccurrences:777},{name:"PEER 1 Hosting",category:"hosting",domains:["*.peer1.com"]},{name:"PERFORM",category:"content",domains:["*.perf\
ormgroup.com"]},{name:"PICnet",category:"hosting",domains:["*.nonprofitsoapbox.com"]},{name:"Pacnet",company:"Telstra",category:"other",domains:["*.cdndelivery.net"],examples:["682968324.r.cdndelivery.net"]},{name:"Pagefair",category:"ad",domains:["*.pagefair.com","*.pagefair.net"]},{name:"Pagely",category:"other",domains:["*.optnmstr.com"],totalExecutionTime:99314,totalOccurrences:487},{name:"Pagesuite",category:"ad",domains:["*.pagesuite-professional.co.uk"],totalExecutionTime:12,totalOccurrences:1},{name:"Pardot",category:"marketing",domains:["*.pardot.com"],totalExecutionTime:73880,totalOccurrences:550},{name:"Parse.ly",category:"analytics",domains:["*.parsely.com","d1z2jf7jlzjs58.cloudfront.net"],totalExecutionTime:1122662,totalOccurrences:5204},{name:"Pay per Click",company:"Eysys",category:"ad",domains:["*.eysys.com"],examples:["pla27.eysys.com"]},{name:"PayPal Ads",category:"ad",domains:["*.where.com"]},{name:"Peaks & Pies",category:"analytics",domains:["*.bunchbox.co"]},{name:"\
PebblePost",category:"ad",domains:["*.pbbl.co"],totalExecutionTime:147945,totalOccurrences:725},{name:"Peerius",category:"analytics",domains:["*.peerius.com"]},{name:"Peermap",company:"IMRG",category:"analytics",domains:["peermapcontent.affino.com"]},{name:"Penske Media",category:"content",domains:["*.pmc.com"]},{name:"Penton",category:"utility",domains:["*.pisces-penton.com"]},{name:"Pepper",category:"ad",domains:["*.peppercorp.com"]},{name:"Perfect Audience",company:"Marin Software",category:"ad",domains:["*.prfct.co","*.marinsm.com","*.perfectaudience.com"],totalExecutionTime:405,totalOccurrences:7},{name:"Perfect Market",category:"ad",domains:["*.perfectmarket.com"]},{name:"Perfect Privacy",category:"other",domains:["*.suitesmart.com"]},{name:"Perform Group",category:"content",domains:["*.performfeeds.com","*.premiumtv.co.uk"]},{name:"Performio",category:"ad",domains:["*.performax.cz"],examples:["ut.performax.cz"],totalExecutionTime:117591,totalOccurrences:337},{name:"PerimeterX Bo\
t Defender",company:"PerimeterX",category:"utility",domains:["*.perimeterx.net","*.pxi.pub"],totalExecutionTime:172605,totalOccurrences:68},{name:"Periscope",category:"content",domains:["*.periscope.tv"]},{name:"Permutive",category:"ad",domains:["*.permutive.com","d3alqb8vzo7fun.cloudfront.net"],totalExecutionTime:1406714,totalOccurrences:1124},{name:"Petametrics",category:"analytics",domains:["*.petametrics.com"]},{name:"PhotoBucket",category:"content",domains:["*.photobucket.com"],totalExecutionTime:2383529,totalOccurrences:338},{name:"Picreel",category:"analytics",domains:["*.pcrl.co","*.picreel.com"],totalExecutionTime:45437,totalOccurrences:300},{name:"Pictela (AOL)",category:"analytics",domains:["*.pictela.net"]},{name:"PistonHeads",category:"social",domains:["*.pistonheads.com"]},{name:"Piwik",category:"analytics",domains:["*.drtvtracker.com","*.piwikpro.com","*.raac33.net"],totalExecutionTime:2813,totalOccurrences:32},{name:"Pixalate",category:"utility",domains:["*.adrta.com"],
totalExecutionTime:4187,totalOccurrences:13},{name:"Pixlee",category:"social",domains:["*.pixlee.com"],totalExecutionTime:137281,totalOccurrences:341},{name:"Placed",category:"analytics",domains:["*.placed.com"],totalExecutionTime:691,totalOccurrences:1},{name:"Planning-inc",category:"analytics",domains:["*.planning-inc.co.uk"]},{name:"PlayAd Media Group",category:"ad",domains:["*.youplay.se"]},{name:"Playbuzz",category:"hosting",domains:["*.playbuzz.com"],totalExecutionTime:58184,totalOccurrences:89},{name:"Pleenq",category:"ad",domains:["*.pleenq.com"]},{name:"Plentific",category:"content",domains:["*.plentific.com"]},{name:"PluginDetect",category:"other",domains:["dtlilztwypawv.cloudfront.net"]},{name:"Po.st",company:"RadiumOne",category:"utility",domains:["*.po.st"],totalExecutionTime:178,totalOccurrences:3},{name:"Pointpin",category:"utility",domains:["*.pointp.in"]},{name:"Pointroll (Garnett)",category:"ad",domains:["*.pointroll.com"]},{name:"Polar",homepage:"https://polar.me/",category:"\
ad",domains:["*.polarmobile.ca","*.mediaeverywhere.com","*.mediavoice.com","*.plrsrvcs.com","*.polarcdn-engine.com","*.polarcdn-meraxes.com","*.polarcdn-pentos.com","*.polarcdn-static.com","*.polarcdn-terrax.com","*.polarcdn.com","*.polarmobile.com","*.poweredbypolar.com","*.mediaconductor.me","*.polaracademy.me"],totalExecutionTime:66280,totalOccurrences:223},{name:"PollDaddy (Automattic)",category:"ad",domains:["static.polldaddy.com","*.poll.fm"],totalExecutionTime:4752,totalOccurrences:37},{name:"Polldaddy",company:"Automattic",category:"analytics",domains:["polldaddy.com","*.polldaddy.com"],totalExecutionTime:294207,totalOccurrences:2715},{name:"Polyfill service",company:"Polyfill.io",category:"other",domains:["*.polyfill.io"]},{name:"MegaPopAds",category:"ad",domains:["*.megapopads.com"]},{name:"Populis",category:"ad",domains:["*.populisengage.com"]},{name:"Postimage.org",category:"content",domains:["*.postimg.org"]},{name:"PowerFront",category:"hosting",domains:["*.inside-graph.c\
om"],totalExecutionTime:220331,totalOccurrences:370},{name:"PowerReviews",category:"analytics",domains:["*.powerreviews.com"],totalExecutionTime:1208993,totalOccurrences:1324},{name:"Powerlinks.com",category:"ad",domains:["*.powerlinks.com"]},{name:"Press+",category:"ad",domains:["*.pipol.com","*.ppjol.com","*.ppjol.net"]},{name:"PressArea",category:"utility",domains:["*.pressarea.com"],examples:["www.pressarea.com"]},{name:"Pretio Interactive",category:"ad",domains:["*.pretio.in"]},{name:"Prezi",category:"utility",domains:["*.prezi.com"],totalExecutionTime:72394,totalOccurrences:79},{name:"PriceGrabber",category:"content",domains:["*.pgcdn.com","*.pricegrabber.com"]},{name:"PriceRunner",category:"content",domains:["*.pricerunner.com"],totalExecutionTime:200,totalOccurrences:6},{name:"PrintFriendly",category:"utility",domains:["*.printfriendly.com"],totalExecutionTime:39464,totalOccurrences:381},{name:"Privy",category:"ad",domains:["*.privy.com","*.privymktg.com"],totalExecutionTime:14992809,
totalOccurrences:18961},{name:"Proclivity Media",category:"analytics",domains:["*.pswec.com"]},{name:"Profitshare",category:"ad",domains:["*.profitshare.ro"],totalExecutionTime:60087,totalOccurrences:194},{name:"Programattik",category:"ad",domains:["*.programattik.com"],totalExecutionTime:95,totalOccurrences:9},{name:"Proper Media",category:"content",domains:["*.proper.io"],totalExecutionTime:253672,totalOccurrences:109},{name:"Property Week",category:"content",domains:["*.propertyweek.com"],examples:["www.propertyweek.com"]},{name:"Provide Support",category:"customer-success",domains:["*.providesupport.com"],totalExecutionTime:79281,totalOccurrences:989},{name:"Proweb Uk",category:"hosting",domains:["*.proweb.net"]},{name:"Proximic (ComScore)",category:"ad",domains:["*.proximic.com"]},{name:"Psyma",category:"ad",domains:["*.psyma.com"],totalExecutionTime:2496,totalOccurrences:5},{name:"PubFactory",company:"Safari Books Online",category:"content",domains:["*.pubfactory.com"]},{name:"Pu\
bNation",category:"ad",domains:["*.pubnation.com"],totalExecutionTime:625439,totalOccurrences:132},{name:"Publicidad.net",category:"ad",domains:["*.publicidad.tv"]},{name:"PublishThis",company:"Ultra Unlimited",category:"ad",domains:["*.publishthis.com"]},{name:"Pulse Insights",category:"analytics",domains:["*.pulseinsights.com"],totalExecutionTime:5757,totalOccurrences:53},{name:"Pulsepoint",category:"marketing",domains:["*.displaymarketplace.com"]},{name:"Purch",category:"ad",domains:["*.bestofmedia.com","*.purch.com"],examples:["ramp.purch.com"]},{name:"Pure Chat",category:"customer-success",domains:["*.purechat.com"],totalExecutionTime:1129392,totalOccurrences:3105},{name:"PushCrew",category:"ad",domains:["*.pushcrew.com"],totalExecutionTime:170011,totalOccurrences:823},{name:"Q1Media",category:"ad",domains:["*.q1media.com","*.q1mediahydraplatform.com"]},{name:"Qbase Software Development",category:"hosting",domains:["*.smartwebportal.co.uk"]},{name:"Qeryz",category:"analytics",domains:[
"*.qeryz.com"]},{name:"Qode Interactive",category:"hosting",domains:["*.qodeinteractive.com"],totalExecutionTime:2503828,totalOccurrences:147},{name:"Qrius",category:"social",domains:["*.qrius.me"]},{name:"Qualaroo",category:"analytics",domains:["*.qualaroo.com"],totalExecutionTime:54960,totalOccurrences:347},{name:"Qualtrics",category:"analytics",domains:["*.qualtrics.com"],totalExecutionTime:4907219,totalOccurrences:7134},{name:"Qubit",company:"Qubit",category:"analytics",domains:["*.qubit.com","*.qutics.com","d3c3cq33003psk.cloudfront.net","*.goqubit.com","*.qubitproducts.com"],totalExecutionTime:50060,totalOccurrences:43},{name:"Qubit Deliver",company:"Qubit",category:"analytics",domains:["d1m54pdnjzjnhe.cloudfront.net","d22rutvoghj3db.cloudfront.net","dd6zx4ibq538k.cloudfront.net"]},{name:"QuestionPro",category:"analytics",domains:["*.questionpro.com"],totalExecutionTime:60868,totalOccurrences:152},{name:"Queue-it",category:"other",domains:["*.queue-it.net"],totalExecutionTime:60031,
totalOccurrences:143},{name:"QuinStreet",category:"ad",domains:["*.Quinstreet.com","*.b2btechleadform.com","*.qnsr.com","*.qsstats.com"],examples:["www.qsstats.com"]},{name:"QuoVadis",category:"utility",domains:["*.quovadisglobal.com"]},{name:"Qzzr",category:"analytics",domains:["*.movementventures.com","*.qzzr.com"],examples:["www.qzzr.com"]},{name:"RapidAPI",category:"utility",domains:["*.rapidapi.com"],examples:["telize-v1.p.rapidapi.com"],totalExecutionTime:4218,totalOccurrences:2},{name:"RCS Media Group",category:"ad",domains:["*.rcsadv.it"]},{name:"REVIVVE",category:"ad",domains:["*.revivve.com"]},{name:"RSSinclude",category:"social",domains:["*.rssinclude.com"]},{name:"RTB House AdPilot",company:"RTB House",category:"ad",domains:["*.erne.co","*.creativecdn.com"],totalExecutionTime:1677125,totalOccurrences:13287},{name:"RTB Media",category:"ad",domains:["*.rtb-media.me"]},{name:"RUN",category:"ad",domains:["*.runadtag.com","*.rundsp.com"]},{name:"Rackspace",category:"hosting",domains:[
"*.rackcdn.com","*.rackspacecloud.com","*.raxcdn.com","*.websitetestlink.com"],totalExecutionTime:3573460,totalOccurrences:2624},{name:"RadiumOne",category:"ad",domains:["*.gwallet.com","*.r1-cdn.net"]},{name:"Rakuten DC Storm",company:"Rakuten",category:"analytics",domains:["*.dc-storm.com","*.h4k5.com","*.stormiq.com"]},{name:"Rakuten LinkShare",company:"Rakuten",category:"ad",domains:["*.linksynergy.com"],totalExecutionTime:23285,totalOccurrences:151},{name:"Rakuten Marketing",company:"Rakuten",category:"ad",domains:["*.rakuten-static.com","*.rmtag.com","tag.rmp.rakuten.com"],totalExecutionTime:462276,totalOccurrences:3399},{name:"Rakuten MediaForge",company:"Rakuten",category:"ad",domains:["*.mediaforge.com"],totalExecutionTime:1650,totalOccurrences:20},{name:"Rambler",company:"Rambler & Co",category:"utility",domains:["*.rambler.ru"],totalExecutionTime:54521084,totalOccurrences:15831},{name:"Ranker",category:"content",domains:["*.ranker.com","*.rnkr-static.com"]},{name:"Ravelin",category:"\
utility",domains:["*.ravelin.com"]},{name:"Raygun",category:"utility",domains:["*.raygun.io","*.rapidzebra.io"],totalExecutionTime:245714,totalOccurrences:2539},{name:"ReCollect",category:"utility",domains:["*.recollect.net"],totalExecutionTime:229879,totalOccurrences:135},{name:"ReSRC",category:"utility",domains:["*.resrc.it"]},{name:"ReTargeter",category:"ad",domains:["*.retargeter.com"]},{name:"Reach Group",category:"ad",domains:["*.redintelligence.net"],totalExecutionTime:1449,totalOccurrences:199},{name:"ReachDynamics",category:"ad",domains:["*.rdcdn.com"]},{name:"ReachForce",category:"ad",domains:["*.reachforce.com"]},{name:"ReachLocal",category:"ad",domains:["*.rtrk.co.nz"],examples:["rtsys.rtrk.co.nz"]},{name:"ReachMee",category:"content",domains:["*.reachmee.com"],totalExecutionTime:133135,totalOccurrences:40},{name:"Reactful",category:"analytics",domains:["*.reactful.com"],totalExecutionTime:12497,totalOccurrences:42},{name:"Realtime",company:"internet business technologies",
category:"utility",domains:["*.realtime.co"]},{name:"Realtime Media (Brian Communications)",category:"ad",domains:["*.rtm.com"]},{name:"Realtime Targeting",category:"ad",domains:["*.idtargeting.com"]},{name:"Realytics",category:"analytics",domains:["dcniko1cv0rz.cloudfront.net","*.realytics.net"],totalExecutionTime:38343,totalOccurrences:276},{name:"RebelMouse",category:"ad",domains:["*.rebelmouse.com","*.rbl.ms"],examples:["www.rebelmouse.com"],totalExecutionTime:3876,totalOccurrences:22},{name:"Receiptful",category:"utility",domains:["*.receiptful.com"],totalExecutionTime:58254,totalOccurrences:361},{name:"Recite Me",category:"other",domains:["*.reciteme.com"],totalExecutionTime:22320,totalOccurrences:142},{name:"RecoBell",category:"analytics",domains:["*.recobell.io"]},{name:"Recommend",category:"analytics",domains:["*.recommend.pro"]},{name:"Red Eye International",category:"ad",domains:["*.pajmc.com"]},{name:"Redfish Group",category:"ad",domains:["*.wmps.com"]},{name:"Reevoo",category:"\
analytics",domains:["*.reevoo.com"],totalExecutionTime:87323,totalOccurrences:133},{name:"Refersion",category:"ad",domains:["*.refersion.com"],totalExecutionTime:564360,totalOccurrences:2170},{name:"Refined Ads",category:"ad",domains:["*.refinedads.com"]},{name:"Reflektion",category:"analytics",domains:["*.reflektion.com","d26opx5dl8t69i.cloudfront.net"]},{name:"Reflow",company:"Scenestealer",category:"ad",domains:["*.reflow.tv"]},{name:"Reklama",category:"ad",domains:["*.o2.pl","*.wp.pl"],examples:["dot.wp.pl","px.o2.pl","px.wp.pl"],totalExecutionTime:846563,totalOccurrences:1054},{name:"Relevad ReleStar",company:"Relevad",category:"ad",domains:["*.relestar.com"]},{name:"Remarketing Pixel",company:"Adsterra Network",category:"ad",domains:["*.datadbs.com","*.remarketingpixel.com"]},{name:"Remintrex",company:"SmartUp Venture",category:"ad",domains:["*.remintrex.com"]},{name:"Republer",category:"ad",domains:["*.republer.com"],examples:["sync.republer.com"]},{name:"Research Now",category:"\
analytics",domains:["*.researchgnow.com","*.researchnow.com"],examples:["tag.researchgnow.com"]},{name:"Research Online",company:"Skills Development Scotland",category:"content",domains:["*.researchonline.org.uk"],examples:["www.researchonline.org.uk"]},{name:"Resonance Insights",category:"analytics",domains:["*.res-x.com"],totalExecutionTime:2277,totalOccurrences:20},{name:"Resonate Networks",category:"analytics",domains:["*.reson8.com"],totalExecutionTime:1739,totalOccurrences:1},{name:"Response Team",category:"ad",domains:["*.i-transactads.com"]},{name:"ResponseTap",category:"analytics",domains:["*.adinsight.com","*.responsetap.com"],totalExecutionTime:84074,totalOccurrences:274},{name:"ResponsiveVoice",category:"other",domains:["*.responsivevoice.org"],totalExecutionTime:851397,totalOccurrences:6863},{name:"Retention Science",category:"ad",domains:["*.retentionscience.com","d1stxfv94hrhia.cloudfront.net"],totalExecutionTime:17276,totalOccurrences:209},{name:"Revcontent",category:"c\
ontent",domains:["*.revcontent.com"],totalExecutionTime:1153469,totalOccurrences:1251},{name:"Revee",category:"ad",domains:["*.revee.com"]},{name:"Revenue Conduit",category:"utility",domains:["*.revenueconduit.com"]},{name:"RevenueMantra",category:"ad",domains:["*.revenuemantra.com"]},{name:"Reviews.co.uk",category:"analytics",domains:["*.reviews.co.uk"],totalExecutionTime:425151,totalOccurrences:1883},{name:"Reviews.io",category:"analytics",domains:["*.reviews.io"],totalExecutionTime:1713955,totalOccurrences:4516},{name:"Revolver Maps",category:"analytics",domains:["*.revolvermaps.com"],totalExecutionTime:2132297,totalOccurrences:2305},{name:"Revv",category:"utility",domains:["*.revv.co"],totalExecutionTime:26667,totalOccurrences:11},{name:"RichRelevance",category:"analytics",domains:["*.richrelevance.com"],totalExecutionTime:3496,totalOccurrences:19},{name:"RightNow Service Cloud",company:"Oracle",category:"customer-success",domains:["*.rightnowtech.com","*.rnengage.com"],totalExecutionTime:8970,
totalOccurrences:122},{name:"Rightster",category:"ad",domains:["*.ads-creativesyndicator.com"]},{name:"Riskified",category:"utility",domains:["*.riskified.com"],totalExecutionTime:373865,totalOccurrences:1643},{name:"Rockerbox",category:"analytics",homepage:"https://www.rockerbox.com/",domains:["getrockerbox.com"],examples:["getrockerbox.com"],totalExecutionTime:19742,totalOccurrences:162},{name:"Rocket Fuel",category:"ad",domains:["*.rfihub.com","*.ru4.com","*.rfihub.net","*.ad1x.com"],totalExecutionTime:356189,totalOccurrences:3247},{name:"Rollbar",category:"utility",domains:["*.rollbar.com","d37gvrvc0wt4s1.cloudfront.net"],examples:["api.rollbar.com"],totalExecutionTime:190180,totalOccurrences:2349},{name:"RomanCart",category:"utility",domains:["*.romancart.com"],totalExecutionTime:510,totalOccurrences:5},{name:"Rondavu",category:"ad",domains:["*.rondavu.com"]},{name:"Roomkey",category:"content",domains:["*.roomkey.com"],examples:["www.roomkey.com"]},{name:"Roost",category:"utility",
domains:["*.goroost.com"]},{name:"Roxot",category:"ad",domains:["*.rxthdr.com"]},{name:"Roxr Software",category:"analytics",domains:["*.getclicky.com"],totalExecutionTime:851573,totalOccurrences:12877},{name:"Rtoaster",company:"Brainpad",homepage:"https://www.brainpad.co.jp/rtoaster/",category:"marketing",domains:["*.rtoaster.jp"],examples:["rt.rtoaster.jp"],totalExecutionTime:15065,totalOccurrences:91},{name:"Rubikloud.com",category:"analytics",domains:["*.rubikloud.com"]},{name:"Ruler Analytics",company:"Ruler",category:"analytics",domains:["*.nyltx.com","*.ruleranalytics.com"],examples:["www.ruleranalytics.com"],totalExecutionTime:41074,totalOccurrences:436},{name:"Runner",company:"Rambler & Co",category:"content",domains:["*.begun.ru"],totalExecutionTime:26,totalOccurrences:1},{name:"S4M",category:"ad",domains:["*.sam4m.com"]},{name:"SAP Hybris Marketing Convert",company:"SAP",category:"ad",domains:["*.seewhy.com"]},{name:"SAS Institute",category:"ad",domains:["*.aimatch.com","*.sa\
s.com"],totalExecutionTime:59419,totalOccurrences:29},{name:"SATORI",homepage:"https://satori.marketing/",category:"marketing",domains:["satori.segs.jp"],examples:["satori.segs.jp/s.js"],totalExecutionTime:62202,totalOccurrences:816},{name:"SC ShopMania Net SRL",category:"content",domains:["*.shopmania.com"]},{name:"SDL Media Manager",company:"SDL",category:"other",domains:["*.sdlmedia.com"]},{name:"SFR",category:"other",domains:["*.sfr.fr"],examples:["elr.sfr.fr"],totalExecutionTime:22751,totalOccurrences:22},{name:"SLI Systems",category:"utility",domains:["*.resultslist.com","*.resultspage.com","*.sli-spark.com"],totalExecutionTime:2909,totalOccurrences:33},{name:"SMARTASSISTANT",company:"Smart Information Systems",category:"customer-success",domains:["*.smartassistant.com"]},{name:"SMARTSTREAM.TV",category:"ad",domains:["*.smartstream.tv"]},{name:"SPX",company:"Smaato",category:"ad",domains:["*.smaato.net"],totalExecutionTime:519,totalOccurrences:13},{name:"Sabio",category:"customer\
-success",domains:["*.sabio.co.uk"],examples:["www.sabio.co.uk"]},{name:"Sailthru",category:"analytics",domains:["*.sail-horizon.com","*.sail-personalize.com","*.sail-track.com"],totalExecutionTime:59245,totalOccurrences:678},{name:"Sailthru Sightlines",company:"Sailthru",category:"marketing",domains:["*.sailthru.com"],totalExecutionTime:6772,totalOccurrences:18},{name:"Sajari Pty",category:"utility",domains:["*.sajari.com"],totalExecutionTime:70019,totalOccurrences:197},{name:"SaleCycle",category:"ad",domains:["*.salecycle.com","d16fk4ms6rqz1v.cloudfront.net","d22j4fzzszoii2.cloudfront.net","d30ke5tqu2tkyx.cloudfront.net","dn1i8v75r669j.cloudfront.net"],totalExecutionTime:146399,totalOccurrences:641},{name:"Salesforce Live Agent",company:"Salesforce.com",category:"customer-success",domains:["*.salesforceliveagent.com"],totalExecutionTime:100033,totalOccurrences:675},{name:"Salesforce.com",category:"ad",domains:["*.force.com","*.salesforce.com"],examples:["secure.force.com"],totalExecutionTime:1614051,
totalOccurrences:4970},{name:"Samba TV",company:"Samba",category:"content",domains:["*.samba.tv"],totalExecutionTime:1690,totalOccurrences:7},{name:"Samplicio.us",category:"analytics",domains:["*.samplicio.us"],totalExecutionTime:1727,totalOccurrences:5},{name:"Say Media",category:"ad",domains:["*.saymedia.com"]},{name:"Scenario",category:"analytics",domains:["*.getscenario.com"]},{name:"Schuh (image shard)",company:"Schuh",category:"other",domains:["d2ob0iztsaxy5v.cloudfront.net"]},{name:"Science Rockstars",category:"analytics",domains:["*.persuasionapi.com"]},{name:"ScientiaMobile",category:"analytics",domains:["*.wurflcloud.com","*.wurfl.io"],totalExecutionTime:627,totalOccurrences:3},{name:"Scoota",category:"ad",domains:["*.rockabox.co","*.scoota.co","d31i2625d5nv27.cloudfront.net","dyjnzf8evxrp2.cloudfront.net"]},{name:"ScribbleLive",category:"ad",domains:["*.scribblelive.com"]},{name:"SearchForce",category:"ad",domains:["*.searchforce.net"],totalExecutionTime:118,totalOccurrences:3},
{name:"SearchSpring",category:"utility",domains:["*.searchspring.net"],totalExecutionTime:1175588,totalOccurrences:309},{name:"Searchanise",category:"analytics",domains:["*.searchanise.com"],examples:["www.searchanise.com"],totalExecutionTime:63519,totalOccurrences:420},{name:"Sears Holdings",category:"content",domains:["*.shld.net"]},{name:"Secomapp",category:"utility",domains:["*.secomapp.com"],totalExecutionTime:2151952,totalOccurrences:2137},{name:"SecuredVisit",company:"4Cite Marketing",category:"ad",domains:["*.securedvisit.com"],totalExecutionTime:41054,totalOccurrences:369},{name:"SecurityMetrics",category:"utility",domains:["*.securitymetrics.com"],totalExecutionTime:8413,totalOccurrences:2},{name:"Segmento",category:"ad",domains:["*.rutarget.ru"],totalExecutionTime:17111,totalOccurrences:226},{name:"Segmint",category:"analytics",domains:["*.segmint.net"],totalExecutionTime:14122,totalOccurrences:109},{name:"Sekindo",category:"content",domains:["*.sekindo.com"],totalExecutionTime:376,
totalOccurrences:4},{name:"Seldon",category:"analytics",domains:["*.rummblelabs.com"]},{name:"SelectMedia International",category:"content",domains:["*.selectmedia.asia"],totalExecutionTime:186574,totalOccurrences:68},{name:"Selligent",category:"ad",domains:["*.emsecure.net","*.slgnt.eu","targetemsecure.blob.core.windows.net"],totalExecutionTime:163886,totalOccurrences:506},{name:"Sellpoints",category:"analytics",domains:["*.sellpoints.com"]},{name:"Semantics3",category:"analytics",domains:["*.hits.io"]},{name:"Semasio",category:"analytics",domains:["*.semasio.net"]},{name:"Semcasting Site Visitor Attribution",company:"Semcasting",category:"ad",domains:["*.smartzonessva.com"]},{name:"Sentifi",category:"social",domains:["*.sentifi.com"]},{name:"ServMetric",category:"analytics",domains:["*.servmetric.com"]},{name:"ServiceSource International",category:"marketing",domains:["*.scoutanalytics.net"],examples:["scout.scoutanalytics.net"]},{name:"ServiceTick",category:"analytics",domains:["*.s\
ervicetick.com"]},{name:"Servo",company:"Xervo",category:"hosting",domains:["*.onmodulus.net"]},{name:"SessionCam",company:"ServiceTick",category:"analytics",domains:["*.sessioncam.com","d2oh4tlt9mrke9.cloudfront.net"]},{name:"Seznam",category:"utility",domains:["*.imedia.cz"],totalExecutionTime:1323711,totalOccurrences:6863},{name:"Sharethrough",category:"ad",domains:["*.sharethrough.com"],totalExecutionTime:46730,totalOccurrences:833},{name:"SharpSpring",category:"marketing",domains:["*.sharpspring.com","*.marketingautomation.services"],totalExecutionTime:632191,totalOccurrences:2080},{name:"ShopRunner",category:"content",domains:["*.shoprunner.com","*.s-9.us"],totalExecutionTime:35573,totalOccurrences:32},{name:"ShopStorm",category:"utility",domains:["*.shopstorm.com"]},{name:"Shopatron",category:"hosting",domains:["*.shopatron.com"]},{name:"Shopgate",category:"utility",domains:["*.shopgate.com"],totalExecutionTime:15293,totalOccurrences:25},{name:"ShopiMind",company:"ShopIMind",category:"\
ad",domains:["*.shopimind.com"]},{name:"Shopkeeper Tools",category:"utility",domains:["*.shopkeepertools.com"],totalExecutionTime:500,totalOccurrences:6},{name:"Sidecar",category:"other",domains:["*.getsidecar.com","d3v27wwd40f0xu.cloudfront.net"]},{name:"Sidereel",category:"analytics",domains:["*.sidereel.com"]},{name:"Sift Science",category:"utility",domains:["*.siftscience.com"],totalExecutionTime:90167,totalOccurrences:355},{name:"Signal",category:"tag-manager",domains:["*.sitetagger.co.uk"]},{name:"Signyfyd",category:"utility",domains:["*.signifyd.com"],totalExecutionTime:4752892,totalOccurrences:2608},{name:"Silktide",category:"hosting",domains:["*.silktide.com"],totalExecutionTime:132707,totalOccurrences:390},{name:"Silverpop",company:"IBM",category:"ad",domains:["*.mkt912.com","*.mkt922.com","*.mkt932.com","*.mkt941.com","*.mkt51.net","*.mkt61.net","*.pages01.net","*.pages02.net","*.pages03.net","*.pages04.net","*.pages05.net"],totalExecutionTime:4144,totalOccurrences:58},{name:"\
Simplaex",category:"marketing",domains:["*.simplaex.net"]},{name:"SimpleReach",category:"analytics",domains:["*.simplereach.com","d8rk54i4mohrb.cloudfront.net"]},{name:"Simplestream",category:"content",domains:["*.simplestream.com"],examples:["player.simplestream.com"]},{name:"Simpli.fi",category:"ad",domains:["*.simpli.fi"],totalExecutionTime:974218,totalOccurrences:16378},{name:"Simplicity Marketing",category:"ad",domains:["*.flashtalking.com"],totalExecutionTime:579126,totalOccurrences:2927},{name:"SinnerSchrader Deutschland",category:"ad",domains:["*.s2Betrieb.de"]},{name:"Sirv",category:"other",domains:["*.sirv.com"],totalExecutionTime:604262,totalOccurrences:1034},{name:"Site Meter",category:"analytics",domains:["*.sitemeter.com"]},{name:"Site24x7 Real User Monitoring",company:"Site24x7",category:"analytics",domains:["*.site24x7rum.com"],totalExecutionTime:124283,totalOccurrences:1007},{name:"SiteGainer",category:"analytics",domains:["*.sitegainer.com","d191y0yd6d0jy4.cloudfront.\
net"]},{name:"SiteScout",company:"Centro",category:"ad",domains:["*.pixel.ad","*.sitescout.com"],totalExecutionTime:256082,totalOccurrences:3401},{name:"Siteimprove",category:"utility",domains:["*.siteimprove.com","*.siteimproveanalytics.com"],totalExecutionTime:28494,totalOccurrences:361},{name:"Six Degrees Group",category:"hosting",domains:["*.fstech.co.uk"]},{name:"Skimbit",category:"ad",domains:["*.redirectingat.com","*.skimresources.com","*.skimresources.net"],totalExecutionTime:32940093,totalOccurrences:86270},{name:"Skimlinks",category:"ad",domains:["*.skimlinks.com"]},{name:"SkyGlue Technology",category:"analytics",domains:["*.skyglue.com"],totalExecutionTime:2567,totalOccurrences:24},{name:"SkyScanner",category:"content",domains:["*.skyscanner.net"],examples:["api.skyscanner.net"],totalExecutionTime:98147,totalOccurrences:370},{name:"Skybet",company:"Bonne Terre t/a Sky Vegas (Sky)",category:"other",domains:["*.skybet.com"]},{name:"Skype",category:"other",domains:["*.skype.com"],
totalExecutionTime:121901,totalOccurrences:625},{name:"Slate Group",category:"content",domains:["*.cdnslate.com"]},{name:"SlimCut Media Outstream",company:"SlimCut Media",category:"ad",domains:["*.freeskreen.com"]},{name:"Smart Insight Tracking",company:"Emarsys",category:"analytics",domains:["*.scarabresearch.com"],totalExecutionTime:361811,totalOccurrences:1779},{name:"Smart AdServer",category:"ad",domains:["*.01net.com","*.sascdn.com","*.sasqos.com","*.smartadserver.com"],examples:["securite.01net.com"],totalExecutionTime:22356737,totalOccurrences:107812},{name:"SmartFocus",category:"analytics",domains:["*.emv2.com","*.emv3.com","*.predictiveintent.com","*.smartfocus.com","*.themessagecloud.com"]},{name:"Smarter Click",category:"ad",domains:["*.smct.co","*.smarterclick.co.uk"],totalExecutionTime:761,totalOccurrences:11},{name:"SmarterHQ",category:"analytics",domains:["*.smarterhq.io","d1n00d49gkbray.cloudfront.net","*.smarterremarketer.net"],totalExecutionTime:2636,totalOccurrences:28},
{name:"Smarttools",category:"customer-success",domains:["*.smartertrack.com"]},{name:"Smartzer",category:"ad",domains:["*.smartzer.com"]},{name:"Snack Media",category:"content",domains:["*.snack-media.com"],totalExecutionTime:575613,totalOccurrences:423},{name:"Snacktools",category:"ad",domains:["*.bannersnack.com"],totalExecutionTime:162327,totalOccurrences:303},{name:"SnapEngage",category:"customer-success",domains:["*.snapengage.com"],totalExecutionTime:147012,totalOccurrences:1038},{name:"SnapWidget",category:"content",domains:["*.snapwidget.com"]},{name:"Soasta",category:"analytics",domains:["*.lognormal.net"]},{name:"SociableLabs",category:"ad",domains:["*.sociablelabs.net","*.sociablelabs.com"]},{name:"Social Annex",category:"customer-success",domains:["*.socialannex.com"]},{name:"SocialShopWave",category:"social",domains:["*.socialshopwave.com"],totalExecutionTime:4962079,totalOccurrences:3720},{name:"Socialphotos",category:"social",domains:["*.slpht.com"],totalExecutionTime:12590,
totalOccurrences:120},{name:"Sociomantic Labs",company:"DunnHumby",category:"ad",domains:["*.sociomantic.com"]},{name:"SodaHead",category:"analytics",domains:["*.sodahead.com"],examples:["pollware-cdn.sodahead.com"]},{name:"Softwebzone",category:"hosting",domains:["*.softwebzone.com"],examples:["www.softwebzone.com"]},{name:"Sojern",category:"marketing",domains:["*.sojern.com"],totalExecutionTime:2086952,totalOccurrences:4422},{name:"Sokrati",category:"marketing",domains:["*.sokrati.com"]},{name:"Sonobi",category:"ad",domains:["*.sonobi.com"],totalExecutionTime:4682222,totalOccurrences:81682},{name:"Sooqr Search",company:"Sooqr",category:"utility",domains:["*.sooqr.com"],totalExecutionTime:176199,totalOccurrences:396},{name:"Sophus3",category:"analytics",domains:["*.s3ae.com","*.sophus3.com"],totalExecutionTime:5605,totalOccurrences:11},{name:"Sorenson Media",category:"content",domains:["*.sorensonmedia.com"]},{name:"Sortable",category:"ad",domains:["*.deployads.com"]},{name:"Sotic",category:"\
hosting",domains:["*.sotic.net","*.soticservers.net"]},{name:"Soundest",category:"ad",domains:["*.soundestlink.com","*.soundest.net"],totalExecutionTime:835,totalOccurrences:102},{name:"Sourcepoint",category:"ad",domains:["*.decenthat.com","*.fallingfalcon.com","*.summerhamster.com","d2lv4zbk7v5f93.cloudfront.net","d3qxwzhswv93jk.cloudfront.net"],examples:["www.decenthat.com","www.fallingfalcon.com","www.summerhamster.com"]},{name:"SourceKnowledge",homepage:"https://www.sourceknowledge.com",category:"ad",domains:["*.provenpixel.com"],totalExecutionTime:505,totalOccurrences:8},{name:"SpaceNet",category:"hosting",domains:["*.nmm.de"]},{name:"Sparkflow",company:"Intercept Interactive",category:"ad",domains:["*.sparkflow.net"]},{name:"Specific Media",category:"ad",domains:["*.specificmedia.com","*.adviva.net","*.specificclick.net"]},{name:"Spicy",company:"Data-Centric Alliance",category:"ad",domains:["*.sspicy.ru"]},{name:"Spoke",category:"customer-success",domains:["*.121d8.com"]},{name:"\
Spongecell",category:"ad",domains:["*.spongecell.com"]},{name:"Spot.IM",category:"social",domains:["*.spot.im","*.spotim.market"],totalExecutionTime:192547,totalOccurrences:342},{name:"SpotXchange",category:"ad",domains:["*.spotxcdn.com","*.spotxchange.com","*.spotx.tv"]},{name:"SpringServer",category:"ad",domains:["*.springserve.com"],totalExecutionTime:1192823,totalOccurrences:1432},{name:"Spylight",category:"other",domains:["*.spylight.com"]},{name:"SreamAMG",company:"StreamAMG",category:"other",domains:["*.streamamg.com"],totalExecutionTime:85506,totalOccurrences:62},{name:"StackAdapt",category:"ad",domains:["*.stackadapt.com"],totalExecutionTime:1338506,totalOccurrences:14912},{name:"StackExchange",category:"social",domains:["*.sstatic.net"],totalExecutionTime:187262,totalOccurrences:217},{name:"Stackla PTY",category:"social",domains:["*.stackla.com"],totalExecutionTime:271026,totalOccurrences:175},{name:"Stailamedia",category:"ad",domains:["*.stailamedia.com"]},{name:"Stamped.io",
category:"analytics",domains:["*.stamped.io"],totalExecutionTime:1665115,totalOccurrences:12460},{name:"Starfield Services Root Certificate Authority",company:"Starfield Technologies",category:"utility",domains:["*.starfieldtech.com","ss2.us","*.ss2.us"],examples:["ocsp.starfieldtech.com"],totalExecutionTime:18156,totalOccurrences:39},{name:"Starfield Technologies",category:"utility",domains:["*.websiteprotection.com"],examples:["seals.websiteprotection.com"]},{name:"StatCounter",category:"analytics",domains:["*.statcounter.com"],totalExecutionTime:5427381,totalOccurrences:50769},{name:"Statful",category:"analytics",domains:["*.statful.com"]},{name:"Steelhouse",category:"ad",domains:["*.steelhousemedia.com"],totalExecutionTime:66172,totalOccurrences:452},{name:"Steepto",category:"ad",domains:["*.steepto.com"],totalExecutionTime:170,totalOccurrences:1},{name:"StellaService",category:"analytics",domains:["*.stellaservice.com"]},{name:"StickyADS.tv",category:"ad",domains:["*.stickyadstv.c\
om"],totalExecutionTime:2198555,totalOccurrences:1462},{name:"STINGRAY",company:"FlexOne",category:"ad",domains:["*.impact-ad.jp"],examples:["y.one.impact-ad.jp"],totalExecutionTime:1261721,totalOccurrences:9742},{name:"Storify",company:"Adobe Systems",category:"social",domains:["*.storify.com"]},{name:"Storm Tag Manager",company:"Rakuten",category:"tag-manager",domains:["*.stormcontainertag.com"]},{name:"Storygize",category:"ad",domains:["*.storygize.net"],examples:["www.storygize.net"],totalExecutionTime:60468,totalOccurrences:154},{name:"Strands",category:"utility",domains:["*.strands.com"]},{name:"StreamRail",category:"ad",domains:["*.streamrail.com","*.streamrail.net"]},{name:"StrikeAd",category:"ad",domains:["*.strikead.com"]},{name:"Struq",company:"Quantcast",category:"ad",domains:["*.struq.com"]},{name:"StrÃ¶er Digital Media",category:"ad",domains:["*.stroeerdigitalmedia.de"]},{name:"StumbleUpon",category:"content",domains:["*.stumble-upon.com","*.stumbleupon.com"],totalExecutionTime:18653,
totalOccurrences:17},{name:"Sub2 Technologies",category:"analytics",domains:["*.sub2tech.com"],totalExecutionTime:6667,totalOccurrences:31},{name:"SublimeSkinz",category:"ad",domains:["*.ayads.co"],totalExecutionTime:339456,totalOccurrences:772},{name:"Sumo Logic",category:"utility",domains:["*.sumologic.com"],totalExecutionTime:19322,totalOccurrences:9},{name:"Sunday Times Driving",category:"content",domains:["*.driving.co.uk"]},{name:"SundaySky",category:"ad",domains:["*.sundaysky.com","dds6m601du5ji.cloudfront.net"],totalExecutionTime:7435,totalOccurrences:10},{name:"Sunrise Integration",category:"utility",domains:["*.sunriseintegration.com"]},{name:"Supertool Network Technology",category:"analytics",domains:["*.miaozhen.com"],totalExecutionTime:6166,totalOccurrences:49},{name:"Survata",category:"analytics",domains:["*.survata.com"]},{name:"SurveyGizmo",category:"analytics",domains:["*.surveygizmo.eu"],examples:["www.surveygizmo.eu"]},{name:"SurveyMonkey",category:"analytics",domains:[
"*.surveymonkey.com"],totalExecutionTime:28632,totalOccurrences:250},{name:"Survicate",category:"analytics",domains:["*.survicate.com"],totalExecutionTime:933283,totalOccurrences:3008},{name:"Sweet Tooth",category:"ad",domains:["*.sweettooth.io"],totalExecutionTime:2673,totalOccurrences:41},{name:"Swiftype",category:"utility",domains:["*.swiftype.com","*.swiftypecdn.com"],totalExecutionTime:383638,totalOccurrences:982},{name:"Switch Concepts",category:"ad",domains:["*.switchadhub.com"]},{name:"SwitchAds",company:"Switch Concepts",category:"ad",domains:["*.switchads.com"]},{name:"Swogo",category:"analytics",domains:["*.xsellapp.com"]},{name:"Swoop",category:"ad",domains:["*.swoop.com"],totalExecutionTime:13511,totalOccurrences:75},{name:"Symantec",category:"utility",domains:["*.norton.com","*.symantec.com","*.symcb.com","*.symcd.com"],examples:["extended-validation-ssl.websecurity.symantec.com"],totalExecutionTime:184600,totalOccurrences:363},{name:"Syncapse",category:"social",domains:[
"*.clickable.net"]},{name:"Synergetic",category:"ad",domains:["*.synergetic.ag"]},{name:"Synthetix",category:"customer-success",domains:["*.syn-finity.com","*.synthetix-ec1.com","*.synthetix.com"],examples:["www.synthetix-ec1.com"],totalExecutionTime:6284,totalOccurrences:27},{name:"Syte",category:"other",domains:["*.syteapi.com"],examples:["cdn.syteapi.com"],totalExecutionTime:109749,totalOccurrences:106},{name:"TINT",category:"content",domains:["*.71n7.com","d33w9bm0n1egwm.cloudfront.net","d36hc0p18k1aoc.cloudfront.net","d3l7tj34e9fc43.cloudfront.net"],examples:["www.71n7.com"]},{name:"TNS (Kantar Group)",category:"analytics",domains:["*.tns-counter.ru"]},{name:"TRUSTe",category:"utility",domains:["*.truste.com"],totalExecutionTime:123425,totalOccurrences:613},{name:"TV Genius",company:"Ericcson Media Services",category:"content",domains:["*.tvgenius.net"]},{name:"TVSquared",category:"ad",domains:["*.tvsquared.com"],totalExecutionTime:548667,totalOccurrences:4082},{name:"TVTY",category:"\
ad",domains:["*.distribeo.com","*.ogigl.com"]},{name:"Tactics bvba",category:"hosting",domains:["*.influid.co"]},{name:"Tag Inspector",company:"InfoTrust",category:"analytics",domains:["d22xmn10vbouk4.cloudfront.net"],totalExecutionTime:51386,totalOccurrences:171},{name:"TagCommander",category:"tag-manager",domains:["*.commander1.com","*.tagcommander.com"],totalExecutionTime:448164,totalOccurrences:1509},{name:"Tagboard",category:"social",domains:["*.tagboard.com"],totalExecutionTime:106499,totalOccurrences:49},{name:"Taggstar",company:"Taggstar UK",category:"ad",domains:["*.taggstar.com"],totalExecutionTime:16168,totalOccurrences:68},{name:"Tail Target",company:"Tail",category:"ad",domains:["*.tailtarget.com"],totalExecutionTime:176612,totalOccurrences:873},{name:"Tailored",category:"other",domains:["d24qm7bu56swjs.cloudfront.net","dw3vahmen1rfy.cloudfront.net","*.tailored.to"]},{name:"Taleo Enterprise Cloud Service",company:"Oracle",category:"content",domains:["*.taleo.net"],totalExecutionTime:4178,
totalOccurrences:68},{name:"Talkable",category:"ad",domains:["*.talkable.com","d2jjzw81hqbuqv.cloudfront.net"],examples:["www.talkable.com"],totalExecutionTime:154019,totalOccurrences:601},{name:"TapSense",category:"ad",domains:["*.tapsense.com"]},{name:"Tapad",category:"ad",domains:["*.tapad.com"],totalExecutionTime:976,totalOccurrences:54},{name:"Teads",category:"ad",domains:["*.teads.tv"],totalExecutionTime:2295585,totalOccurrences:7565},{name:"Team Internet Tonic",company:"Team Internet",category:"ad",domains:["*.dntrax.com"]},{name:"TechTarget",category:"content",domains:["*.techtarget.com","*.ttgtmedia.com"],totalExecutionTime:11857,totalOccurrences:24},{name:"Technorati",company:"Synacor",category:"ad",domains:["*.technoratimedia.com"],totalExecutionTime:5382653,totalOccurrences:27186},{name:"Teedhaze",category:"content",domains:["*.fuel451.com"]},{name:"Tell Apart",category:"analytics",domains:["*.tellapart.com","*.tellaparts.com"]},{name:"Tencent",category:"content",domains:["\
*.qq.com","*.ywxi.net"],totalExecutionTime:2265040,totalOccurrences:8726},{name:"Thanx Media",category:"utility",domains:["*.hawksearch.info"]},{name:"Thawte",category:"utility",domains:["*.thawte.com"],examples:["ocsp.thawte.com","seal.thawte.com"],totalExecutionTime:307,totalOccurrences:1},{name:"Thesis",category:"analytics",homepage:"https://www.thesistesting.com/",domains:["*.ttsep.com"],examples:["thix.ttsep.com"]},{name:"The AA",category:"ad",domains:["*.adstheaa.com"]},{name:"The ADEX",category:"ad",domains:["*.theadex.com"],totalExecutionTime:13554,totalOccurrences:129},{name:"The Best Day",category:"social",domains:["*.thebestday.com"]},{name:"The Filter",company:"Exabre",category:"analytics",domains:["*.thefilter.com"]},{name:"The Guardian",category:"analytics",domains:["*.ophan.co.uk"]},{name:"The Hut Group",category:"content",domains:["*.thcdn.com"],totalExecutionTime:497181,totalOccurrences:281},{name:"The Numa Group",category:"other",domains:["*.hittail.com"]},{name:"The \
Publisher Desk",category:"ad",domains:["*.206ads.com","*.publisherdesk.com"]},{name:"The Sydney Morning Herald",company:"Fairfax Media",category:"content",domains:["*.smh.com.au"]},{name:"The Wall Street Jounal",category:"content",domains:["*.wsj.net"],totalExecutionTime:3036,totalOccurrences:5},{name:"The Wall Street Journal",category:"content",domains:["*.marketwatch.com"]},{name:"TheFind",category:"content",domains:["*.thefind.com"]},{name:"Thinglink",category:"utility",domains:["*.thinglink.com"],totalExecutionTime:2987,totalOccurrences:53},{name:"Thirdpresence",category:"ad",domains:["*.thirdpresence.com"]},{name:"ThreatMetrix",category:"utility",domains:["*.online-metrix.net"],totalExecutionTime:1901757,totalOccurrences:3530},{name:"Throtle",homepage:"https://throtle.io/",category:"analytics",domains:["*.thrtle.com","*.v12group.com"]},{name:"TicketMaster",category:"content",domains:["*.t-x.io","*.tmcs.net"]},{name:"TikTok",company:"ByteDance Ltd",homepage:"https://www.tiktok.com/\
en/",category:"social",domains:["*.tiktok.com","*.ipstatp.com"],examples:["analytics.tiktok.com","https://s0.ipstatp.com/ad/business/track-log.js"],totalExecutionTime:111182189,totalOccurrences:256224},{name:"Tidio Live Chat",company:"Tidio",homepage:"https://www.tidiochat.com/en/",category:"customer-success",domains:["*.tidiochat.com"],totalExecutionTime:26584634,totalOccurrences:24598},{name:"Tiledesk Live Chat",company:"Tiledesk SRL",homepage:"https://www.tiledesk.com/",category:"customer-success",domains:["*.tiledesk.com"],examples:["widget.tiledesk.com"],totalExecutionTime:253744,totalOccurrences:103},{name:"Time",category:"content",domains:["*.timeinc.net"]},{name:"Time2Perf",category:"ad",domains:["*.time2perf.com"]},{name:"TinyURL",category:"utility",domains:["*.tinyurl.com"]},{name:"Tivo",category:"analytics",domains:["*.rovicorp.com"]},{name:"Tom&Co",category:"hosting",domains:["*.tomandco.uk"]},{name:"Toms Native Ads",company:"Purch",category:"ad",domains:["*.natoms.com"]},{
name:"ToneMedia",category:"ad",domains:["*.clickfuse.com"]},{name:"Tonic",company:"Team Internet",category:"ad",domains:["*.dntx.com"]},{name:"Touch Commerce",category:"customer-success",domains:["*.inq.com","*.touchcommerce.com"],totalExecutionTime:12673,totalOccurrences:74},{name:"ToutApp",category:"ad",domains:["*.toutapp.com"]},{name:"TraceView",company:"Solarwinds",category:"analytics",domains:["*.tracelytics.com","d2gfdmu30u15x7.cloudfront.net"]},{name:"TrackJS",category:"analytics",domains:["*.trackjs.com","d2zah9y47r7bi2.cloudfront.net"],examples:["usage.trackjs.com"],totalExecutionTime:2112335,totalOccurrences:2268},{name:"Tradedoubler",category:"ad",domains:["*.pvnsolutions.com","*.tradedoubler.com"],totalExecutionTime:31870,totalOccurrences:165},{name:"Tradelab",category:"ad",domains:["*.tradelab.fr"],totalExecutionTime:5013,totalOccurrences:44},{name:"TrafficFactory",category:"ad",domains:["*.trafficfactory.biz"]},{name:"TrafficHunt",category:"ad",domains:["*.traffichunt.co\
m"]},{name:"TrafficStars",category:"ad",domains:["*.trafficstars.com","*.tsyndicate.com"],totalExecutionTime:3435101,totalOccurrences:7430},{name:"Transifex",category:"utility",domains:["*.transifex.com"],totalExecutionTime:193259,totalOccurrences:546},{name:"Travelex",category:"utility",domains:["*.travelex.net","*.travelex.co.uk"],examples:["api.travelex.net","travelmoney.travelex.co.uk"]},{name:"Travelocity Canada",company:"Travelocity",category:"content",domains:["*.travelocity.ca"],examples:["www.travelocity.ca"]},{name:"Travelocity USA",company:"Travelocity",category:"content",domains:["*.travelocity.com"],examples:["www.travelocity.com"]},{name:"Travelzoo",category:"content",domains:["*.travelzoo.com"]},{name:"Treasure Data",category:"analytics",domains:["*.treasuredata.com"],totalExecutionTime:1404314,totalOccurrences:14403},{name:"Tremor Video",category:"ad",domains:["*.tremorhub.com","*.videohub.tv"]},{name:"Trialfire",category:"analytics",domains:["*.trialfire.com"],totalExecutionTime:44579,
totalOccurrences:198},{name:"Tribal Fusion",company:"Exponential Interactive",category:"ad",domains:["*.tribalfusion.com"],totalExecutionTime:96569,totalOccurrences:158016},{name:"Triblio",category:"marketing",domains:["*.tribl.io"]},{name:"Triggered Messaging",company:"Fresh Relevance",category:"ad",domains:["*.triggeredmessaging.com"]},{name:"Trinity Mirror",category:"content",domains:["*.mirror.co.uk"],totalExecutionTime:13841,totalOccurrences:41},{name:"Trinity Mirror Digital Media",category:"social",domains:["*.tm-aws.com","*.icnetwork.co.uk"]},{name:"TripAdvisor",category:"content",domains:["*.jscache.com","*.tacdn.com","*.tamgrt.com","*.tripadvisor.com","*.viator.com","*.tripadvisor.co.uk"],examples:["www.jscache.com","www.tamgrt.com"],totalExecutionTime:749303,totalOccurrences:2354},{name:"TripleLift",category:"ad",domains:["*.3lift.com"],totalExecutionTime:8396,totalOccurrences:4812},{name:"Tru Optik",category:"ad",domains:["*.truoptik.com"]},{name:"TruConversion",category:"an\
alytics",domains:["*.truconversion.com"],totalExecutionTime:487670,totalOccurrences:1008},{name:"Trueffect",category:"marketing",domains:["*.adlegend.com"]},{name:"Truefit",category:"analytics",domains:["*.truefitcorp.com"],examples:["cdn.truefitcorp.com","fitrec.truefitcorp.com","sch-cdn.truefitcorp.com"],totalExecutionTime:4647,totalOccurrences:20},{name:"Trust Guard",category:"utility",domains:["*.trust-guard.com"],totalExecutionTime:3346,totalOccurrences:35},{name:"Trust Pilot",category:"analytics",domains:["*.trustpilot.com"],totalExecutionTime:14795265,totalOccurrences:54942},{name:"Amazon Trust Services",company:"Amazon",category:"utility",domains:["*.amazontrust.com","o.ss2.us"],examples:["ocsp.rootca1.amazontrust.com"],totalExecutionTime:107,totalOccurrences:1},{name:"Google Trust Services",company:"Google",category:"utility",domains:["*.pki.goog"],examples:["ocsp.pki.goog"],totalExecutionTime:18,totalOccurrences:1},{name:"Let's Encrypt",homepage:"https://letsencrypt.org/",category:"\
utility",domains:["*.letsencrypt.org"],examples:["ocsp.int-x3.letsencrypt.org"],totalExecutionTime:76,totalOccurrences:3},{name:"TrustX",category:"ad",domains:["*.trustx.org"]},{name:"Trusted Shops",category:"utility",domains:["*.trustedshops.com"],totalExecutionTime:7373870,totalOccurrences:17267},{name:"Trustev",company:"TransUnion",category:"utility",domains:["*.trustev.com"],totalExecutionTime:3272,totalOccurrences:22},{name:"Trustwave",category:"utility",domains:["*.trustwave.com"],totalExecutionTime:4600,totalOccurrences:7},{name:"Tryzens TradeState",company:"Tryzens",category:"analytics",domains:["*.tryzens-analytics.com"],totalExecutionTime:969,totalOccurrences:9},{name:"TubeMogul",category:"ad",domains:["*.tubemogul.com"],totalExecutionTime:24151,totalOccurrences:51},{name:"Turn",category:"ad",domains:["*.turn.com"],totalExecutionTime:4802,totalOccurrences:72},{name:"Tutorialize",category:"customer-success",domains:["*.tutorialize.me"]},{name:"Twenga",category:"content",domains:[
"*.twenga.fr","*.c4tw.net","*.twenga.co.uk"],examples:["tracker.twenga.co.uk"]},{name:"Twitframe",company:"Superblock",category:"utility",domains:["*.twitframe.com"]},{name:"Twitter Online Conversion Tracking",company:"Twitter",category:"ad",domains:["*.ads-twitter.com","analytics.twitter.com"],examples:["static.ads-twitter.com"],totalExecutionTime:6170585,totalOccurrences:73452},{name:"Twitter Short URL",company:"Twitter",category:"social",domains:["*.t.co"]},{name:"Twyn Group",category:"ad",domains:["*.twyn.com"]},{name:"Tynt",company:"33 Across",category:"ad",domains:["*.tynt.com"],totalExecutionTime:41643525,totalOccurrences:212415},{name:"Typepad",category:"hosting",domains:["*.typepad.com"],totalExecutionTime:834082,totalOccurrences:813},{name:"TyrbooBytes",category:"utility",domains:["*.turbobytes.net"]},{name:"UPS i-parcel",company:"UPS",category:"other",domains:["*.i-parcel.com"]},{name:"US Media Consulting",category:"ad",domains:["*.mediade.sk"]},{name:"Ubertags",category:"ta\
g-manager",domains:["*.ubertags.com"]},{name:"Umbel",category:"analytics",domains:["*.umbel.com"]},{name:"Unanimis",company:"Switch",category:"ad",domains:["*.unanimis.co.uk"]},{name:"Unbounce",category:"ad",domains:["*.ubembed.com","*.unbounce.com","d2xxq4ijfwetlm.cloudfront.net","d9hhrg4mnvzow.cloudfront.net"],totalExecutionTime:2902422,totalOccurrences:8808},{name:"Underdog Media",category:"ad",domains:["*.underdog.media","*.udmserve.net"],totalExecutionTime:524141,totalOccurrences:289},{name:"Understand Digital",category:"ad",domains:["*.redirecting2.net"]},{name:"Undertone",company:"Perion",category:"ad",domains:["*.legolas-media.com"],examples:["rt.legolas-media.com"]},{name:"Unidays",category:"ad",domains:["*.myunidays.com","*.unidays.world"]},{name:"Uniqodo",category:"ad",domains:["*.uniqodo.com"]},{name:"Unite",category:"ad",domains:["*.uadx.com"]},{name:"United Card Services",category:"utility",domains:["*.ucs.su"]},{name:"United Internet",category:"hosting",domains:["*.uicdn\
.com"],totalExecutionTime:14225,totalOccurrences:75},{name:"United Internet Media",category:"ad",domains:["*.ui-portal.de"],totalExecutionTime:20307,totalOccurrences:59},{name:"United Internet Media AG",category:"hosting",domains:["*.tifbs.net","*.uicdn.net","*.uimserv.net"],totalExecutionTime:1737,totalOccurrences:48},{name:"Unknown",category:"other",domains:[]},{name:"Unruly Media",category:"ad",domains:["*.unrulymedia.com"],totalExecutionTime:679,totalOccurrences:1789},{name:"UpBuild",category:"ad",domains:["*.upbuild.io"],examples:["www.upbuild.io"]},{name:"UpSellit",category:"analytics",domains:["*.upsellit.com"],examples:["www.upsellit.com"],totalExecutionTime:289920,totalOccurrences:1013},{name:"Upland Software",category:"hosting",domains:["*.clickability.com"]},{name:"Airship",category:"marketing",domains:["*.urbanairship.com","*.aswpsdkus.com"],totalExecutionTime:4666,totalOccurrences:37},{name:"UsabilityTools",category:"analytics",domains:["*.usabilitytools.com"]},{name:"Usab\
lenet.net",category:"utility",domains:["*.usablenet.net"]},{name:"Use It Better",category:"analytics",domains:["*.useitbetter.com"]},{name:"User Replay",category:"analytics",domains:["*.userreplay.net"]},{name:"UserReport",category:"analytics",domains:["*.userreport.com"],totalExecutionTime:133479,totalOccurrences:476},{name:"Userneeds",category:"analytics",domains:["*.userneeds.dk"]},{name:"Userzoom",category:"analytics",domains:["*.userzoom.com"],totalExecutionTime:5093,totalOccurrences:4},{name:"V12 Retail Finance",category:"utility",domains:["*.v12finance.com"]},{name:"Vacaciones eDreams",category:"content",domains:["*.odistatic.net"]},{name:"Varick Media Management",category:"ad",domains:["*.vmmpxl.com"]},{name:"Vdopia Chocolate",company:"Vdopia",category:"ad",domains:["*.vdopia.com"]},{name:"Ve",company:"Ve",homepage:"https://www.ve.com/",category:"marketing",domains:["*.veinteractive.com","*.ve.com"]},{name:"Ve Interactive",company:"Ve",category:"ad",domains:["*.vepxl1.net","*.a\
dgenie.co.uk"]},{name:"Vee24",category:"customer-success",domains:["*.vee24.com"],totalExecutionTime:20941,totalOccurrences:38},{name:"Veeseo",category:"content",domains:["*.veeseo.com"]},{name:"Venatus Media",category:"marketing",domains:["*.alcvid.com","*.venatusmedia.com"]},{name:"Veoxa",category:"ad",domains:["*.veoxa.com"]},{name:"Vergic AB",category:"customer-success",domains:["*.psplugin.com"],totalExecutionTime:48232,totalOccurrences:71},{name:"Vergic Engage Platform",company:"Vergic",category:"customer-success",domains:["*.vergic.com"],totalExecutionTime:41524,totalOccurrences:57},{name:"Verisign (Symantec)",category:"utility",domains:["*.verisign.com"]},{name:"Verizon",category:"utility",domains:["*.public-trust.com"],examples:["www.public-trust.com"]},{name:"Verizon Digital Media CDN",homepage:"https://www.verizondigitalmedia.com/",category:"cdn",domains:["*.edgecastcdn.net","*.edgecastdns.net"],totalExecutionTime:98698,totalOccurrences:108},{name:"Verizon Uplynk",company:"V\
erizon",category:"content",domains:["*.uplynk.com"],totalExecutionTime:572,totalOccurrences:4},{name:"Vero",company:"Semblance",category:"ad",domains:["*.getvero.com","d3qxef4rp70elm.cloudfront.net"],totalExecutionTime:613,totalOccurrences:10},{name:"VertaMedia",category:"ad",domains:["*.vertamedia.com"]},{name:"Vertical Mass",category:"ad",domains:["*.vmweb.net"]},{name:"Vestorly",category:"ad",domains:["*.oodalab.com"]},{name:"Vextras",category:"other",domains:["*.vextras.com"],totalExecutionTime:4484,totalOccurrences:42},{name:"Viacom",category:"content",domains:["*.mtvnservices.com"],totalExecutionTime:15501,totalOccurrences:44},{name:"Vibrant Media",category:"ad",domains:["*.intellitxt.com","*.picadmedia.com"]},{name:"VidPulse",category:"analytics",domains:["*.vidpulse.com"]},{name:"Video Media Groep",category:"ad",domains:["*.vmg.host","*.inpagevideo.nl"]},{name:"VideoHub",company:"Tremor Video",category:"ad",domains:["*.scanscout.com"],examples:["dt.scanscout.com"]},{name:"Video\
logy",category:"ad",domains:["*.tidaltv.com"]},{name:"Vidible",category:"ad",domains:["*.vidible.tv"]},{name:"VigLink",category:"ad",domains:["*.viglink.com"],totalExecutionTime:3670311,totalOccurrences:6219},{name:"Vindico",company:"Viant",category:"ad",domains:["*.vindicosuite.com"]},{name:"Viocorp International",category:"content",domains:["*.vioapi.com"]},{name:"ViralNinjas",category:"ad",domains:["*.viralninjas.com"]},{name:"Virool",category:"ad",domains:["*.virool.com"]},{name:"Virtual Earth",company:"Microsoft",category:"utility",domains:["*.virtualearth.net"],totalExecutionTime:54315,totalOccurrences:312},{name:"Visely",company:"Visely",category:"other",homepage:"https://visely.io/",domains:["*.visely.io"]},{name:"VisScore",category:"analytics",domains:["*.visscore.com","d2hkbi3gan6yg6.cloudfront.net"]},{name:"Visible Measures",category:"ad",domains:["*.visiblemeasures.com"],totalExecutionTime:11,totalOccurrences:13},{name:"Visual Studio",company:"Microsoft",category:"utility",
domains:["*.visualstudio.com"],totalExecutionTime:3464,totalOccurrences:3},{name:"VisualDNA",category:"ad",domains:["*.visualdna.com"]},{name:"VisualVisitor",category:"ad",domains:["*.id-visitors.com"],examples:["frontend.id-visitors.com"],totalExecutionTime:871,totalOccurrences:14},{name:"Vivocha S.p.A",category:"customer-success",domains:["*.vivocha.com"],totalExecutionTime:65471,totalOccurrences:38},{name:"Vizu (Nielsen)",category:"analytics",domains:["*.vizu.com"]},{name:"Vizury",category:"ad",domains:["*.vizury.com"],totalExecutionTime:1296,totalOccurrences:20},{name:"VoiceFive",category:"analytics",domains:["*.voicefive.com"]},{name:"Volvelle",company:"Optomaton",category:"ad",domains:["*.volvelle.tech"]},{name:"VouchedFor",category:"analytics",domains:["*.vouchedfor.co.uk"],totalExecutionTime:30557,totalOccurrences:18},{name:"WARPCACHE",category:"utility",domains:["*.warpcache.net"]},{name:"WISHLIST",company:"Shopapps",category:"social",domains:["*.shopapps.in"]},{name:"WP Engin\
e",category:"hosting",domains:["*.wpengine.com"],totalExecutionTime:651034,totalOccurrences:341},{name:"WalkMe",category:"customer-success",domains:["*.walkme.com"],totalExecutionTime:636459,totalOccurrences:495},{name:"Watching That",category:"other",domains:["*.watchingthat.com"]},{name:"Wayfair",category:"analytics",domains:["*.wayfair.com"],examples:["t.wayfair.com"]},{name:"Web CEO",category:"other",domains:["*.websiteceo.com"],examples:["www.websiteceo.com"]},{name:"Web Dissector",company:"Beijing Gridsum Technologies",category:"analytics",domains:["*.gridsumdissector.com","*.webdissector.com"],examples:["www.webdissector.com"]},{name:"Web Forensics",category:"analytics",domains:["*.webforensics.co.uk"]},{name:"Web Security and Performance",company:"NCC Group",category:"utility",domains:["*.nccgroup.trust"]},{name:"WebEngage",category:"customer-success",domains:["*.webengage.co","*.webengage.com","d23nd6ymopvz52.cloudfront.net","d3701cc9l7v9a6.cloudfront.net"],totalExecutionTime:789975,
totalOccurrences:2283},{name:"WebInsight",company:"dotMailer",category:"analytics",domains:["*.trackedlink.net","*.trackedweb.net"],totalExecutionTime:21241,totalOccurrences:277},{name:"WebPageOne Solutions",category:"other",domains:["*.webpageone.com"]},{name:"WebSpectator",category:"ad",domains:["*.webspectator.com"]},{name:"WebTuna",company:"Application Performance",category:"analytics",domains:["*.webtuna.com"]},{name:"WebVideoCore",company:"StreamingVideoProvider",category:"content",domains:["*.webvideocore.net"],totalExecutionTime:74152,totalOccurrences:38},{name:"WebWombat",category:"utility",domains:["*.ic.com.au"]},{name:"Webcollage",category:"customer-success",domains:["*.webcollage.net"]},{name:"Webcore",category:"ad",domains:["*.onefeed.co.uk"]},{name:"Webkul",company:"Webkul Software",category:"utility",domains:["*.webkul.com"],totalExecutionTime:172788,totalOccurrences:490},{name:"Webmarked",category:"utility",domains:["*.webmarked.net"],totalExecutionTime:72467,totalOccurrences:1077},
{name:"Weborama",category:"ad",domains:["*.weborama.com","*.weborama.fr"],totalExecutionTime:45883,totalOccurrences:372},{name:"WebpageFX",category:"ad",domains:["*.leadmanagerfx.com"],totalExecutionTime:241118,totalOccurrences:946},{name:"Webphone",company:"IP WEB SERVICES",category:"customer-success",domains:["*.webphone.net"],totalExecutionTime:4605,totalOccurrences:20},{name:"Webselect selectcommerce",company:"Webselect Internet",category:"hosting",domains:["*.webselect.net"]},{name:"Webthinking",category:"hosting",domains:["*.webthinking.co.uk"]},{name:"Webtrekk",category:"analytics",domains:["*.wbtrk.net","*.webtrekk-asia.net","*.webtrekk.net","*.wt-eu02.net","*.wt-safetag.com"],totalExecutionTime:85572,totalOccurrences:428},{name:"Webtrends",category:"analytics",domains:["*.webtrends.com","*.webtrendslive.com","d1q62gfb8siqnm.cloudfront.net"],totalExecutionTime:1437,totalOccurrences:6},{name:"Webtype",category:"cdn",domains:["*.webtype.com"],totalExecutionTime:0,totalOccurrences:1},
{name:"White Ops",category:"utility",domains:["*.acexedge.com","*.tagsrvcs.com"]},{name:"Whitespace",category:"ad",domains:["*.whitespacers.com"]},{name:"WhosOn Live Chat Software",category:"customer-success",domains:["*.whoson.com"],totalExecutionTime:20753,totalOccurrences:112},{name:"Wibbitz",category:"other",domains:["*.wibbitz.com"]},{name:"Wide Area Communications",category:"hosting",domains:["*.widearea.co.uk"]},{name:"WideOrbit",category:"marketing",domains:["*.admaym.com"]},{name:"William Reed",category:"content",domains:["*.wrbm.com"],totalExecutionTime:50,totalOccurrences:1},{name:"WillyFogg.com",category:"content",domains:["*.willyfogg.com"]},{name:"Windows",company:"Microsoft",category:"utility",domains:["*.windowsupdate.com"],examples:["ctldl.windowsupdate.com"]},{name:"WisePops",category:"utility",domains:["*.wisepops.com"],totalExecutionTime:2631328,totalOccurrences:1950},{name:"Wishlist King",company:"Appmate",category:"other",homepage:"https://appmate.io/",domains:["*\
.appmate.io"],examples:["api.appmate.io"],totalExecutionTime:130543,totalOccurrences:235},{name:"Wishpond Technologies",category:"marketing",domains:["*.wishpond.com","*.wishpond.net"],totalExecutionTime:771888,totalOccurrences:1691},{name:"WizRocket Technologies",category:"analytics",domains:["*.wzrkt.com"],totalExecutionTime:138,totalOccurrences:2},{name:"Woopra",category:"analytics",domains:["*.woopra.com"],totalExecutionTime:120767,totalOccurrences:1366},{name:"Woosmap",category:"utility",domains:["*.woosmap.com"],totalExecutionTime:58710,totalOccurrences:139},{name:"WorkCast",category:"hosting",domains:["*.workcast.net"]},{name:"World News Media",category:"content",domains:["*.wnmedia.co.uk"]},{name:"Worldpay",category:"utility",domains:["*.worldpay.com"],totalExecutionTime:25852,totalOccurrences:18},{name:"Wow Analytics",category:"analytics",domains:["*.wowanalytics.co.uk"],totalExecutionTime:11162,totalOccurrences:73},{name:"Wowcher",category:"ad",domains:["*.wowcher.co.uk"]},{name:"\
Wufoo",category:"utility",domains:["*.wufoo.com"],totalExecutionTime:381206,totalOccurrences:1507},{name:"Wunderkind",category:"marketing",homepage:"https://www.wunderkind.co/",domains:["*.bounceexchange.com","*.bouncex.net","*.wknd.ai","*.cdnbasket.net","*.cdnwidget.com"],examples:["events.bouncex.net","tag.wknd.ai","data.cdnbasket.net","pix.cdnwidget.com"],totalExecutionTime:2016506,totalOccurrences:1278},{name:"Wyng",category:"ad",domains:["*.offerpop.com"]},{name:"XMLSHOP",category:"hosting",domains:["*.xmlshop.biz"]},{name:"XiTi",company:"AT Internet",category:"analytics",domains:["*.xiti.com","*.aticdn.net"],homepage:"https://www.atinternet.com/en/",examples:["tag.aticdn.net/123456789/smarttag.js"],totalExecutionTime:918257,totalOccurrences:8483},{name:"YUDU",category:"content",domains:["*.yudu.com"]},{name:"Yahoo! Ad Exchange",company:"Yahoo!",category:"ad",domains:["*.yieldmanager.com","*.browsiprod.com"],examples:["yield-manager.browsiprod.com"],totalExecutionTime:12720569,totalOccurrences:4994},
{name:"Yahoo! JAPAN Ads",company:"Yahoo! JAPAN",category:"ad",homepage:"https://marketing.yahoo.co.jp/service/yahooads/",domains:["yads.c.yimg.jp","s.yimg.jp","b92.yahoo.co.jp"],examples:["yads.c.yimg.jp/js/yads-async.js","s.yimg.jp/images/listing/tool/yads/ydn/creative/video/ytop_video_timeline_sp.min.js","b92.yahoo.co.jp/js/s_retargeting.js"],totalExecutionTime:6236624,totalOccurrences:37464},{name:"Yahoo! Tag Manager",company:"Yahoo! JAPAN",category:"tag-manager",homepage:"https://marketing.yahoo.co.jp/service/tagmanager/",domains:["*.yjtag.jp"],examples:["s.yjtag.jp/tag.js"]},{name:"Yahoo! Small Business",company:"Yahoo!",category:"hosting",domains:["*.aabacosmallbusiness.com"]},{name:"Yellow Robot",category:"ad",domains:["*.backinstock.org"],totalExecutionTime:15268,totalOccurrences:508},{name:"YieldPartners",category:"ad",domains:["*.yieldpartners.com"]},{name:"Yieldbot",category:"ad",domains:["*.yldbt.com"]},{name:"Yieldify",category:"ad",domains:["*.yieldify.com","*.yieldifylab\
s.com","d33wq5gej88ld6.cloudfront.net","dwmvwp56lzq5t.cloudfront.net"],examples:["geo.yieldifylabs.com"],totalExecutionTime:513761,totalOccurrences:168},{name:"Yieldlab",category:"ad",domains:["*.yieldlab.net"],totalExecutionTime:54,totalOccurrences:8},{name:"Yieldmo",category:"ad",domains:["*.yieldmo.com"],totalExecutionTime:51128,totalOccurrences:2375},{name:"Yieldr",category:"ad",domains:["*.254a.com"]},{name:"Yo",category:"utility",domains:["*.yopify.com"]},{name:"YoYo",category:"utility",domains:["*.goadservices.com"]},{name:"Yotpo",homepage:"https://www.yotpo.com/",category:"marketing",domains:["*.yotpo.com","*.swellrewards.com"],totalExecutionTime:16919447,totalOccurrences:26094},{name:"Yottaa",category:"hosting",domains:["*.yottaa.com","*.yottaa.net"],totalExecutionTime:798791,totalOccurrences:753},{name:"YourAmigo",category:"utility",domains:["*.youramigo.com"]},{name:"YuMe",category:"ad",domains:["*.yume.com","*.yumenetworks.com"],examples:["cks.yumenetworks.com"]},{name:"Yum\
mley",category:"other",domains:["*.yummly.com"],totalExecutionTime:14163,totalOccurrences:6},{name:"ZEDO",category:"ad",domains:["*.zedo.com"]},{name:"Zafu",category:"analytics",domains:["*.zafu.com"]},{name:"Zaius",category:"ad",domains:["*.zaius.com"]},{name:"Zamplus ad",category:"ad",domains:["*.zampda.net"]},{name:"Zanox",category:"ad",domains:["*.zanox.com","*.zanox.ws"]},{name:"Zapper",category:"utility",domains:["*.zapper.com"]},{name:"Zarget",category:"analytics",domains:["*.zarget.com"]},{name:"Zemanta",category:"ad",domains:["*.zemanta.com"],totalExecutionTime:2735,totalOccurrences:28},{name:"Zen Internet",category:"other",domains:["*.zyen.com"]},{name:"Zenovia Digital Exchange",category:"ad",domains:["*.rhythmxchange.com","*.zenoviaexchange.com"]},{name:"ZergNet",category:"content",domains:["*.zergnet.com"],totalExecutionTime:186,totalOccurrences:4},{name:"Zerogrey",category:"hosting",domains:["*.zerogrey.com"]},{name:"Ziff Davis Tech",category:"ad",domains:["*.adziff.com","\
*.zdbb.net"],totalExecutionTime:30706,totalOccurrences:93},{name:"Zmags",category:"marketing",domains:["*.zmags.com"],totalExecutionTime:262514,totalOccurrences:119},{name:"Zolando",category:"content",domains:["*.ztat.net"],totalExecutionTime:229623,totalOccurrences:48},{name:"Zoover",category:"analytics",domains:["*.zoover.nl","*.zoover.co.uk"],totalExecutionTime:9173,totalOccurrences:2},{name:"Zopim",category:"customer-success",domains:["*.zopim.io"]},{name:"[24]7",category:"customer-success",domains:["*.247-inc.net","*.247inc.net","d1af033869koo7.cloudfront.net"],totalExecutionTime:24965,totalOccurrences:20},{name:"adKernel",category:"ad",domains:["*.adkernel.com"],totalExecutionTime:19140,totalOccurrences:9621},{name:"adMarketplace",company:"AMPexchange",category:"ad",domains:["*.ampxchange.com","*.admarketplace.net"]},{name:"addtocalendar",category:"utility",domains:["*.addtocalendar.com"]},{name:"adnanny",category:"ad",domains:["*.adserver01.de"],totalExecutionTime:2,totalOccurrences:6},
{name:"affilinet",category:"ad",domains:["*.reussissonsensemble.fr","*.successfultogether.co.uk"]},{name:"audioBoom",category:"social",domains:["*.audioboom.com","*.audioboo.fm"],totalExecutionTime:136729,totalOccurrences:57},{name:"bPay by Barclaycard",company:"Barclays Bank",category:"utility",domains:["*.bpay.co.uk"]},{name:"bRealTime",category:"ad",domains:["*.brealtime.com"],totalExecutionTime:4479,totalOccurrences:76},{name:"bd4travel",category:"analytics",domains:["*.bd4travel.com"]},{name:"bizinformation-VOID",company:"bizinformation",category:"analytics",domains:["*.bizinformation.org"]},{name:"carrot",category:"social",domains:["*.sharebutton.co"]},{name:"cloudIQ",category:"analytics",domains:["*.cloud-iq.com"]},{name:"comScore",category:"analytics",domains:["*.adxpose.com","*.comscore.com","*.sitestat.com","*.zqtk.net"],totalExecutionTime:4938,totalOccurrences:3},{name:"content.ad",category:"ad",domains:["*.content.ad"]},{name:"d3 Media",company:"d3 Technologies",category:"o\
ther",domains:["*.d3sv.net"]},{name:"dexiMEDIA",category:"ad",domains:["*.deximedia.com"]},{name:"dianomi",category:"ad",domains:["*.dianomi.com","*.dianomioffers.co.uk"],totalExecutionTime:52461,totalOccurrences:86},{name:"donReach",category:"social",domains:["*.donreach.com"]},{name:"dotMailer",category:"ad",domains:["*.dmtrk.com","*.dotmailer.com","*.emlfiles.com"]},{name:"dotMailer Surveys",company:"dotMailer",category:"analytics",domains:["*.dotmailer-surveys.com"]},{name:"dstillery",category:"ad",domains:["*.dstillery.com","*.media6degrees.com"],totalExecutionTime:1160,totalOccurrences:12},{name:"eBay",category:"ad",domains:["*.ebay.com","*.ebayimg.com","*.fetchback.com"],totalExecutionTime:600826,totalOccurrences:1026},{name:"eBay Enterprise",category:"hosting",domains:["*.csdata1.com","*.gsipartners.com"]},{name:"eBuzzing",company:"Teads Managed Services",category:"ad",domains:["*.ebz.io"]},{name:"eDigital Research",category:"customer-success",domains:["*.edigitalresearch.com",
"*.edigitalsurvey.com","*.edrcdn.com","*.ecustomeropinions.com"]},{name:"eGain",category:"analytics",domains:["*.analytics-egain.com","*.egain.com"],totalExecutionTime:8418,totalOccurrences:74},{name:"eHost",category:"hosting",domains:["*.ehosts.net"]},{name:"eKomi",category:"analytics",domains:["*.ekomi.com","*.ekomi.de"],totalExecutionTime:51192,totalOccurrences:17},{name:"eWAY",company:"Web Active Pty",category:"utility",domains:["*.eway.com.au"],examples:["www.eway.com.au"],totalExecutionTime:11094,totalOccurrences:1},{name:"eXTReMe digital",category:"analytics",domains:["*.extreme-dm.com"],totalExecutionTime:3491,totalOccurrences:78},{name:"eXelate",category:"ad",domains:["*.exelator.com"],totalExecutionTime:17905,totalOccurrences:246},{name:"ecommercefeed.net",category:"marketing",domains:["*.ecommercefeed.net"]},{name:"engage:BDR",category:"ad",domains:["*.bnmla.com","*.ebdr3.com"]},{name:"epago",category:"ad",domains:["*.adaos-ads.net"]},{name:"epoq internet services",category:"\
analytics",domains:["*.epoq.de"],totalExecutionTime:84260,totalOccurrences:122},{name:"etouches",category:"hosting",domains:["*.etouches.com"],examples:["www.etouches.com"]},{name:"etracker",category:"analytics",domains:["*.etracker.com","*.etracker.de"],examples:["www.etracker.com"],totalExecutionTime:2076262,totalOccurrences:5626},{name:"everestads.com",category:"content",domains:["*.verestads.net"]},{name:"exebid.DCA",company:"Data-Centric Alliance",category:"ad",domains:["*.exe.bid"]},{name:"eyeReturn Marketing",category:"marketing",domains:["*.eyereturn.com"]},{name:"feedoptimise",category:"hosting",domains:["*.feedoptimise.com","d1w78njrm56n7g.cloudfront.net"],totalExecutionTime:126,totalOccurrences:2},{name:"fifty-five",category:"ad",domains:["*.55labs.com"]},{name:"fluct",category:"ad",domains:["*.adingo.jp"],totalExecutionTime:5114249,totalOccurrences:12890},{name:"freegeoip.net",company:"(community-funded)",category:"utility",domains:["*.freegeoip.net"]},{name:"freewheel.tv",
category:"content",domains:["*.fwmrm.net"],totalExecutionTime:3847,totalOccurrences:42},{name:"gnatta",category:"customer-success",domains:["*.gnatta.com"]},{name:"home.pl",category:"hosting",domains:["*.nscontext.eu"]},{name:"hyfn",category:"ad",domains:["*.hyfn.com"]},{name:"iAdvize SAS",category:"customer-success",domains:["*.iadvize.com"],totalExecutionTime:286995,totalOccurrences:844},{name:"iBillboard",category:"ad",domains:["*.ibillboard.com"],totalExecutionTime:303,totalOccurrences:2},{name:"iCrossing",category:"ad",domains:["*.ic-live.com"]},{name:"iFactory",company:"RDW Group",category:"hosting",domains:["*.ifactory.com"]},{name:"iGoDigital",category:"analytics",domains:["*.igodigital.com"],totalExecutionTime:1800,totalOccurrences:21},{name:"iJento",company:"Fopsha",category:"ad",domains:["*.ijento.com"]},{name:"iPage",category:"hosting",domains:["*.ipage.com"],examples:["www.ipage.com"],totalExecutionTime:490,totalOccurrences:6},{name:"iPerceptions",category:"customer-succes\
s",domains:["*.iperceptions.com"],totalExecutionTime:626044,totalOccurrences:4662},{name:"iTunes",company:"Apple",category:"content",domains:["*.mzstatic.com"]},{name:"imgix",company:"Zebrafish Labs",category:"utility",domains:["*.imgix.net"],totalExecutionTime:40073,totalOccurrences:98},{name:"infogr.am",category:"utility",domains:["*.infogr.am","*.jifo.co"],totalExecutionTime:2008949,totalOccurrences:233},{name:"iotec",category:"analytics",domains:["*.dsp.io"]},{name:"iovation",category:"utility",domains:["*.iesnare.com"],totalExecutionTime:270232,totalOccurrences:2159},{name:"ipinfo.io",category:"utility",domains:["*.ipinfo.io"]},{name:"issuu",category:"content",domains:["*.issuu.com","*.isu.pub"],totalExecutionTime:5607951,totalOccurrences:2714},{name:"iubenda",category:"utility",domains:["*.iubenda.com"],examples:["www.iubenda.com"],totalExecutionTime:69911073,totalOccurrences:97074},{name:"j2 Cloud Services",category:"ad",domains:["*.campaigner.com"],totalExecutionTime:12708,totalOccurrences:28},
{name:"jsonip.com",category:"analytics",domains:["*.jsonip.com"]},{name:"linkpulse",category:"analytics",domains:["*.lp4.io"]},{name:"loGo_net",category:"analytics",domains:["*.logo-net.co.uk"]},{name:"mainADV",category:"ad",domains:["*.httptrack.com","*.solocpm.com"]},{name:"mbr targeting",category:"ad",domains:["*.m6r.eu"],totalExecutionTime:17,totalOccurrences:1},{name:"media.ventive",category:"ad",domains:["*.contentspread.net"]},{name:"metrigo",category:"ad",domains:["*.metrigo.com"]},{name:"minicabit.com",category:"content",domains:["*.minicabit.com"]},{name:"mobiManage",category:"hosting",domains:["*.mobimanage.com"]},{name:"moving-pictures",category:"other",domains:["*.moving-pictures.biz","*.v6-moving-pictures.com","*.vtstat.com","*.moving-pictures.de"]},{name:"my6sense",category:"ad",domains:["*.mynativeplatform.com"]},{name:"myThings",category:"ad",domains:["*.mythings.com","*.mythingsmedia.net"]},{name:"mymovies",category:"content",domains:["*.mymovies.net"]},{name:"nRelate\
-VOID",company:"nRelate",category:"content",domains:["*.nrelate.com"]},{name:"nToklo",category:"analytics",domains:["*.ntoklo.com"]},{name:"neXeps",category:"ad",domains:["*.nexeps.com"]},{name:"ninemsn Pty.",category:"utility",domains:["*.ninemsn.com.au"]},{name:"nugg.ad",category:"ad",domains:["*.nuggad.net"]},{name:"numero interactive",company:"numero",category:"ad",domains:["*.numerointeractive.com"]},{name:"optMD",company:"Optimax Media Delivery",category:"ad",domains:["*.optmd.com"]},{name:"otracking.com",category:"analytics",domains:["*.otracking.com"]},{name:"paysafecard",company:"Paysafe Group",category:"utility",domains:["*.paysafecard.com"]},{name:"piano",category:"ad",domains:["*.npttech.com","*.tinypass.com"],examples:["www.npttech.com"],totalExecutionTime:1016108,totalOccurrences:1146},{name:"piclike",category:"ad",domains:["*.piclike.us"]},{name:"placehold.it",category:"utility",domains:["*.placehold.it"]},{name:"plista",category:"ad",domains:["*.plista.com"]},{name:"pre\
bid.org",category:"utility",domains:["*.prebid.org"],totalExecutionTime:462,totalOccurrences:1},{name:"reEmbed",category:"other",domains:["*.reembed.com"]},{name:"reddit",category:"social",domains:["*.reddit.com","*.redditstatic.com"],examples:["www.redditstatic.com"],totalExecutionTime:4113522,totalOccurrences:18483},{name:"rewardStyle.com",category:"ad",domains:["*.rewardstyle.com"],totalExecutionTime:280999,totalOccurrences:1491},{name:"rss2json",category:"utility",domains:["*.rss2json.com"],totalExecutionTime:1380,totalOccurrences:18},{name:"sage Pay",company:"Sage Pay Europe",category:"utility",domains:["*.sagepay.com"],totalExecutionTime:4481,totalOccurrences:40},{name:"section.io",category:"utility",domains:["*.squixa.net"],examples:["beacon.squixa.net","s.squixa.net"]},{name:"smartclip",category:"ad",domains:["*.smartclip.net"],totalExecutionTime:41051,totalOccurrences:21},{name:"sovrn",category:"ad",domains:["*.lijit.com"],totalExecutionTime:2389059,totalOccurrences:27306},{name:"\
stackpile.io",company:"StackPile",category:"tag-manager",domains:["*.stackpile.io"]},{name:"template-help.com",category:"hosting",domains:["*.template-help.com"],totalExecutionTime:16016,totalOccurrences:13},{name:"test",company:"test only",category:"other",domains:["*.testtesttest.com"]},{name:"trueAnthem",category:"social",domains:["*.tru.am"]},{name:"tweetmeme-VOID",company:"tweetmeme",category:"analytics",domains:["*.tweetmeme.com"]},{name:"uLogin",category:"other",domains:["*.ulogin.ru"]},{name:"uLogix",category:"ad",domains:["*.ulogix.ru"]},{name:"ucfunnel ucX",company:"ucfunnel",category:"ad",domains:["*.aralego.com"],totalExecutionTime:1469345,totalOccurrences:7945},{name:"up-value",category:"ad",domains:["*.up-value.de"]},{name:"wywy",category:"ad",domains:["*.wywy.com","*.wywyuserservice.com"]},{name:"CDK Dealer Management",company:"CDK Global",homepage:"https://www.cdkglobal.com/us",category:"hosting",domains:["*.assets-cdk.com"],examples:["media-cf.assets-cdk.com"],totalExecutionTime:1052,
totalOccurrences:4},{name:"fam",company:"Fing Co Ltd.",homepage:"http://admin.fam-ad.com/report/",category:"ad",domains:["*.fam-ad.com"],examples:["img.fam-ad.com"],totalExecutionTime:1816,totalOccurrences:10},{name:"zypmedia",category:"ad",domains:["*.extend.tv"]},{name:"codigo",homepage:"https://www.codigo.se",category:"analytics",domains:["*.codigo.se"],examples:["analytics.codigo.se"],totalExecutionTime:469,totalOccurrences:10},{name:"Playground",homepage:"https://playground.xyz",category:"ad",domains:["*.playground.xyz"],examples:["ads.playground.xyz"],totalExecutionTime:2767,totalOccurrences:26},{name:"RAM",homepage:"https://www2.rampanel.com/",category:"analytics",domains:["*.rampanel.com"],examples:["inviso.rampanel.com"],totalExecutionTime:15413,totalOccurrences:1},{name:"Adition",homepage:"https://www.adition.com",category:"ad",domains:["*.adition.com"],examples:["dsp.adfarm1.adition.com"],totalExecutionTime:74399,totalOccurrences:491},{name:"Widespace",homepage:"https://www.\
widespace.com",category:"ad",domains:["*.widespace.com"],examples:["sync.widespace.com"]},{name:"Colpirio",homepage:"https://www.widespace.com",category:"analytics",domains:["*.colpirio.com"],examples:["proxy-tracker.colpirio.com"]},{name:"Brandmetrics",homepage:"https://www.brandmetrics.com",category:"analytics",domains:["*.brandmetrics.com"],examples:["collector.brandmetrics.com","cdn.brandmetrics.com"],totalExecutionTime:3689914,totalOccurrences:30850},{name:"EasyAd",homepage:"https://web.easy-ads.com/",category:"ad",domains:["*.easy-ads.com"],examples:["ads.easy-ads.com"]},{name:"Glimr",homepage:"https://glimr.io/",category:"analytics",domains:["*.glimr.io"],examples:["pixel.glimr.io"]},{name:"Webtreck",homepage:"https://www.webtrekk.com/en/home/",category:"analytics",domains:["*.wcfbc.net"],examples:["fbc.wcfbc.net"]},{name:"DigiTrust",homepage:"http://www.digitru.st/",category:"analytics",domains:["*.digitru.st"],examples:["cdn.digitru.st"]},{name:"Kantar Sifo",homepage:"https://\
www.kantarsifo.se",category:"analytics",domains:["*.research-int.se"],examples:["trafficgateway.research-int.se"],totalExecutionTime:375,totalOccurrences:1},{name:"Concert",homepage:"https://concert.io/",category:"ad",domains:["*.concert.io"],examples:["cdn.concert.io"],totalExecutionTime:317481,totalOccurrences:336},{name:"Emerse",homepage:"https://www.emerse.com/",category:"ad",domains:["*.emerse.com"],examples:["tracking.emerse.com"],totalExecutionTime:2872,totalOccurrences:13},{name:"Iterate",homepage:"https://iteratehq.com/",category:"analytics",domains:["*.iteratehq.com"],totalExecutionTime:8751,totalOccurrences:72},{name:"Cookiebot",homepage:"https://www.cookiebot.com/",category:"utility",domains:["*.cookiebot.com"],examples:["consent.cookiebot.com"],totalExecutionTime:64865019,totalOccurrences:187732},{name:"Netlify",homepage:"https://www.netlify.com/",category:"utility",domains:["*.netlify.com","*.netlifyusercontent.com"],examples:["cloud.netlifyusercontent.com"],totalExecutionTime:299527,
totalOccurrences:1323},{name:"Scroll",homepage:"https://scroll.com/",category:"utility",domains:["*.scroll.com"],examples:["static.scroll.com","connect.scroll.com"]},{name:"Consumable",homepage:"https://consumable.com/",category:"ad",domains:["*.serverbid.com"],totalExecutionTime:15203,totalOccurrences:266},{name:"DMD Marketing",homepage:"https://www.dmdconnects.com/",category:"ad",domains:["*.medtargetsystem.com"],totalExecutionTime:257224,totalOccurrences:846},{name:"Catchpoint",homepage:"https://www.catchpoint.com/",category:"analytics",domains:["*.3gl.net","*.3genlabs.net"],totalExecutionTime:14822,totalOccurrences:160},{name:"Terminus",homepage:"https://terminus.com/",category:"ad",domains:["*.terminus.services"],totalExecutionTime:28077,totalOccurrences:207},{name:"Acceptable Ads",homepage:"https://acceptableads.com/",category:"ad",domains:["*.aaxads.com","*.aaxdetect.com"],totalExecutionTime:2200,totalOccurrences:34},{name:"ClearBrain",homepage:"https://www.clearbrain.com/",category:"\
analytics",domains:["*.clearbrain.com"],examples:["api.clearbrain.com"]},{name:"Optanon",homepage:"https://www.cookielaw.org/",category:"consent-provider",domains:["*.onetrust.com","*.cookielaw.org"],examples:["cdn.cookielaw.org","geolocation.onetrust.com"],totalExecutionTime:55293468,totalOccurrences:113700},{name:"TrustArc",homepage:"https://www.trustarc.com/",category:"utility",domains:["*.trustarc.com"],examples:["choices.trustarc.com","consent.trustarc.com"],totalExecutionTime:2429376,totalOccurrences:5941},{name:"iSpot.tv",homepage:"https://www.ispot.tv/",category:"ad",domains:["*.ispot.tv"],examples:["pt.ispot.tv"],totalExecutionTime:2947,totalOccurrences:10},{name:"RevJet",homepage:"https://www.revjet.com/",category:"ad",domains:["*.revjet.com"],examples:["pix.revjet.com","ads.revjet.com"],totalExecutionTime:54608,totalOccurrences:36},{name:"atlasRTX",homepage:"https://www.atlasrtx.com/",category:"customer-success",domains:["*.atlasrtx.com"],examples:["app.atlasrtx.com","cdn.at\
lasrtx.com","dev.atlasrtx.com"],totalExecutionTime:52386,totalOccurrences:46},{name:"ContactAtOnce",homepage:"https://www.contactatonce.com/",category:"customer-success",domains:["*.contactatonce.com"],examples:["tag.contactatonce.com","agentpresence.contactatonce.com"]},{name:"Algolia",homepage:"https://www.algolia.com/",category:"utility",domains:["*.algolianet.com","*.algolia.net","*.algolia.io"],totalExecutionTime:5603,totalOccurrences:20},{name:"EMX Digital",homepage:"https://emxdigital.com",category:"ad",domains:["*.emxdgt.com"],totalExecutionTime:9160,totalOccurrences:166},{name:"Moxie",homepage:"https://www.gomoxie.com/",category:"utility",domains:["*.gomoxie.solutions"],totalExecutionTime:24183,totalOccurrences:28},{name:"Scripps Network Digital",homepage:"https://www.scrippsnetworksdigital.com/",category:"ad",domains:["*.snidigital.com"]},{name:"TurnTo",homepage:"https://www.turntonetworks.com/",category:"utility",domains:["*.turnto.com"],totalExecutionTime:4666,totalOccurrences:32},
{name:"Quantum Metric",homepage:"https://www.quantummetric.com/",category:"analytics",domains:["*.quantummetric.com"],totalExecutionTime:1699724,totalOccurrences:1140},{name:"Carbon Ads",homepage:"https://www.carbonads.net/",category:"ad",domains:["*.carbonads.net","*.carbonads.com"],totalExecutionTime:12059,totalOccurrences:224},{name:"Ably",homepage:"https://www.ably.io/",category:"utility",domains:["*.ably.io"],totalExecutionTime:17031,totalOccurrences:125},{name:"Sectigo",homepage:"https://sectigo.com/",category:"utility",domains:["*.sectigo.com"],totalExecutionTime:4576,totalOccurrences:3},{name:"Specless",homepage:"https://gospecless.com/",category:"ad",domains:["*.specless.tech"]},{name:"Loggly",homepage:"https://www.loggly.com/",category:"analytics",domains:["*.loggly.com","d9jmv9u00p0mv.cloudfront.net"],examples:["logs-01.loggly.com"],totalExecutionTime:943,totalOccurrences:5},{name:"Intent Media",homepage:"https://intent.com/",category:"ad",domains:["*.intentmedia.net"]},{name:"\
Supership",homepage:"https://supership.jp/",category:"ad",domains:["*.socdm.com"],totalExecutionTime:10809246,totalOccurrences:17934},{name:"F@N Communications",homepage:"https://www.fancs.com/",category:"ad",domains:["*.ladsp.com"],examples:["px.ladsp.com"],totalExecutionTime:258835,totalOccurrences:1768},{name:"Vidyard",homepage:"https://www.vidyard.com/",category:"utility",domains:["*.vidyard.com"],totalExecutionTime:1165600,totalOccurrences:1097},{name:"RapidSSL",homepage:"https://www.rapidssl.com/",category:"utility",domains:["*.rapidssl.com"],totalExecutionTime:845,totalOccurrences:2},{name:"Coherent Path",homepage:"https://coherentpath.com/",category:"utility",domains:["*.coherentpath.com"]},{name:"Attentive",homepage:"https://attentivemobile.com/",category:"ad",domains:["*.attn.tv","*.attentivemobile.com"],totalExecutionTime:5554871,totalOccurrences:9099},{name:"emetriq",homepage:"https://www.emetriq.com/",category:"ad",domains:["*.emetriq.de","*.xplosion.de"],totalExecutionTime:1917,
totalOccurrences:24},{name:"Bonzai",homepage:"https://www.bonzai.co/",category:"ad",domains:["*.bonzai.co"]},{name:"Freshchat",homepage:"https://www.freshworks.com/live-chat-software/",category:"customer-success",domains:["*.freshchat.com","*.freshworksapi.com"],products:[{name:"Freshdesk Messaging",urlPatterns:["wchat.freshchat.com"],facades:[{name:"Freshdesk Messaging (formerly Freshchat) Facade",repo:"https://github.com/coliff/freshdesk-messaging-facade/"}]}],totalExecutionTime:23350324,totalOccurrences:7081},{name:"Contentful",homepage:"https://www.contentful.com/",category:"utility",domains:["*.contentful.com"],examples:["cdn.contentful.com"],totalExecutionTime:4826,totalOccurrences:2},{name:"PureCars",homepage:"https://www.purecars.com/",category:"marketing",domains:["*.purecars.com"],examples:["cdn.purecars.com"],totalExecutionTime:969442,totalOccurrences:1292},{name:"Tray Commerce",homepage:"https://www.tray.com.br/",category:"marketing",domains:["*.tcdn.com.br"],examples:["ima\
ges.tcdn.com.br"],totalExecutionTime:68362173,totalOccurrences:14071},{name:"AdScore",homepage:"https://www.adscore.com/",category:"ad",domains:["*.adsco.re"],examples:["c.adsco.re"],totalExecutionTime:2812771,totalOccurrences:4394},{name:"WebsiteBuilder.com",homepage:"https://www.websitebuilder.com",category:"hosting",domains:["*.mywebsitebuilder.com"],totalExecutionTime:19568135,totalOccurrences:4688},{name:"mParticle",homepage:"https://www.mparticle.com/",category:"utility",domains:["*.mparticle.com"],examples:["jssdks.mparticle.com","identity.mparticle.com"],totalExecutionTime:403503,totalOccurrences:1029},{name:"Ada",homepage:"https://www.ada.support/",category:"customer-success",domains:["*.ada.support"],examples:["static.ada.support"],totalExecutionTime:695777,totalOccurrences:985},{name:"Quora Ads",homepage:"https://www.quora.com/business/",category:"ad",domains:["*.quora.com"],examples:["q.quora.com"],totalExecutionTime:1338719,totalOccurrences:10614},{name:"Auth0",homepage:"h\
ttps://auth0.com/",category:"utility",domains:["*.auth0.com"],examples:["cdn.auth0.com"],totalExecutionTime:245638,totalOccurrences:816},{name:"Bridgewell DSP",homepage:"https://www.bridgewell.com/",category:"ad",domains:["*.scupio.com"],examples:["img.scupio.com"],totalExecutionTime:63728,totalOccurrences:354},{name:"Wicked Reports",homepage:"https://www.wickedreports.com/",category:"marketing",domains:["*.wickedreports.com"],examples:["widget.wickedreports.com"],totalExecutionTime:148754,totalOccurrences:483},{name:"Jaywing",homepage:"https://jaywing.com/",category:"marketing",domains:["*.jaywing.com"],examples:["amazon.almanac.jaywing.com"]},{name:"Holimetrix",homepage:"https://u360.d-bi.fr/",category:"marketing",domains:["*.d-bi.fr"],examples:["u360.d-bi.fr"]},{name:"iZooto",homepage:"https://www.izooto.com",category:"marketing",domains:["*.izooto.com"],examples:["cdn.izooto.com"],totalExecutionTime:1111125,totalOccurrences:2022},{name:"Ordergroove",homepage:"https://www.ordergroov\
e.com/",category:"marketing",domains:["*.ordergroove.com"],examples:["static.ordergroove.com"],totalExecutionTime:99990,totalOccurrences:274},{name:"PageSense",homepage:"https://www.zoho.com/pagesense/",category:"analytics",domains:["*.pagesense.io"],examples:["cdn.pagesense.io"],totalExecutionTime:1996537,totalOccurrences:6219},{name:"Vizzit",homepage:"https://www.vizzit.se",category:"analytics",domains:["*.vizzit.se"],examples:["www.vizzit.se","tag.vizzit.se"],totalExecutionTime:739,totalOccurrences:7},{name:"Click Guardian",homepage:"https://www.clickguardian.co.uk/",category:"ad",domains:["*.clickguardian.app","*.clickguardian.co.uk"],examples:["v2.clickguardian.app","protection.clickguardian.co.uk"],totalExecutionTime:202620,totalOccurrences:1101},{name:"Smartsupp",company:"Smartsupp.com",homepage:"https://www.smartsupp.com",category:"customer-success",domains:["*.smartsuppchat.com","*.smartsupp.com","smartsupp-widget-161959.c.cdn77.org","*.smartsuppcdn.com"],examples:["widget-v1.\
smartsuppcdn.com"],totalExecutionTime:9998165,totalOccurrences:21505},{name:"Smartlook",company:"Smartsupp.com",homepage:"https://www.smartlook.com/",category:"analytics",domains:["*.smartlook.com"],totalExecutionTime:1386251,totalOccurrences:16221},{name:"Luigis Box",company:"Luigis Box",homepage:"https://www.luigisbox.com/",category:"utility",domains:["*.luigisbox.com"],totalExecutionTime:2975273,totalOccurrences:2356},{name:"Targito",company:"VIVmail.cz",homepage:"https://www.targito.com",category:"marketing",domains:["*.targito.com"],totalExecutionTime:3145,totalOccurrences:29},{name:"Foxentry",company:"AVANTRO",homepage:"https://foxentry.cz/",category:"utility",domains:["*.foxentry.cz"],totalExecutionTime:758854,totalOccurrences:2313},{name:"Pendo",homepage:"https://www.pendo.io",category:"analytics",domains:["*.pendo.io"],examples:["app.pendo.io"],totalExecutionTime:4935190,totalOccurrences:12203},{name:"Braze",homepage:"https://www.braze.com",category:"analytics",domains:["*.app\
boycdn.com"],examples:["js.appboycdn.com"],totalExecutionTime:399216,totalOccurrences:2014},{name:"Usersnap",homepage:"https://usersnap.com",category:"customer-success",domains:["*.usersnap.com"],examples:["api.usersnap.com","cdn.usersnap.com"],totalExecutionTime:334324,totalOccurrences:437},{name:"Rewardful",homepage:"https://www.getrewardful.com",category:"analytics",domains:["*.wdfl.co"],examples:["r.wdfl.co"],totalExecutionTime:9094,totalOccurrences:161},{name:"Launch Darkly",homepage:"https://launchdarkly.com",category:"utility",domains:["*.launchdarkly.com"],examples:["app.launchdarkly.com","events.launchdarkly.com"],totalExecutionTime:10547,totalOccurrences:6},{name:"Statuspage",company:"Atlassian",homepage:"https://www.statuspage.io",category:"utility",domains:["*.statuspage.io"],examples:["1k6wzpspjf99.statuspage.io"],totalExecutionTime:43124,totalOccurrences:1212},{name:"HyperInzerce",homepage:"https://hyperinzerce.cz",category:"ad",domains:["*.hyperinzerce.cz"],examples:["mo\
torky.hyperinzerce.cz"],totalExecutionTime:1035,totalOccurrences:39},{name:"POWr",homepage:"https://www.powr.io",category:"utility",domains:["*.powr.io"],examples:["www.powr.io"],totalExecutionTime:191534674,totalOccurrences:39716},{name:"Coral",company:"Coral",homepage:"https://coralproject.net",category:"content",domains:["*.coral.coralproject.net"],examples:["company.coral.coralproject.net"],totalExecutionTime:61135,totalOccurrences:250},{name:"Bolt",homepage:"https://www.bolt.com/",category:"utility",domains:["*.bolt.com"],examples:["connect.bolt.com"],totalExecutionTime:513689,totalOccurrences:217},{name:"Judge.me",homepage:"https://judge.me/",category:"marketing",domains:["*.judge.me"],examples:["cdn.judge.me"],totalExecutionTime:31886982,totalOccurrences:27483},{name:"Tilda",homepage:"https://tilda.cc/",category:"hosting",domains:["*.tildacdn.com"],examples:["stat.tildacdn.com","static.tildacdn.com","upwidget.tildacdn.com"],totalExecutionTime:94734169,totalOccurrences:70321},{name:"\
SalesLoft",homepage:"https://salesloft.com/",category:"marketing",domains:["*.salesloft.com"],examples:["scout-cdn.salesloft.com"],totalExecutionTime:42987,totalOccurrences:705},{name:"Accessibe Accessibility Overlay",company:"Accessibe",homepage:"https://accessibe.com/",category:"utility",domains:["*.accessibe.com","*.acsbapp.com","*.acsbap.com"],examples:["accessibe.com","acsbapp.com"],totalExecutionTime:285765,totalOccurrences:808},{name:"Builder",homepage:"https://www.builder.io/",category:"hosting",domains:["*.builder.io"],examples:["cdn.builder.io"],totalExecutionTime:412358,totalOccurrences:261},{name:"Pepperjam",homepage:"https://www.pepperjam.com/",category:"marketing",domains:["*.pepperjam.com","*.affiliatetechnology.com"],examples:["container.pepperjam.com"],totalExecutionTime:2308,totalOccurrences:35},{name:"Reach",homepage:"https://withreach.com/",category:"utility",domains:["*.gointerpay.net"],examples:["checkout.gointerpay.net"]},{name:"Chameleon",homepage:"https://www.t\
rychameleon.com/",category:"marketing",domains:["*.trychameleon.com"],examples:["fast.trychameleon.com"],totalExecutionTime:24218,totalOccurrences:8},{name:"Matomo",company:"InnoCraft",homepage:"https://matomo.org/",category:"analytics",domains:["*.matomo.cloud"],totalExecutionTime:3115176,totalOccurrences:14345},{name:"Segmanta",homepage:"https://segmanta.com/",category:"marketing",domains:["*.segmanta.com"],examples:["clientName.segmanta.com"]},{name:"Podsights",homepage:"https://podsights.com/",category:"marketing",domains:["*.pdst.fm","us-central1-adaptive-growth.cloudfunctions.net"],examples:["cdn.pdst.fm","sink.pdst.fm"],totalExecutionTime:71990,totalOccurrences:1140},{name:"Chatwoot",homepage:"https://www.chatwoot.com/",category:"customer-success",domains:["*.chatwoot.com"],examples:["cdn.chatwoot.com","app.chatwoot.com"],totalExecutionTime:31973,totalOccurrences:444},{name:"Crisp",homepage:"https://crisp.chat/",category:"customer-success",domains:["*.crisp.chat"],examples:["cli\
ent.crisp.chat","client.relay.crisp.chat"],totalExecutionTime:33757,totalOccurrences:1052},{name:"Admiral CMP",homepage:"https://www.getadmiral.com",category:"consent-provider",domains:["admiral.mgr.consensu.org","*.admiral.mgr.consensu.org"]},{name:"Adnuntius CMP",homepage:"https://adnuntius.com",category:"consent-provider",domains:["adnuntiusconsent.mgr.consensu.org","*.adnuntiusconsent.mgr.consensu.org"]},{name:"Clickio CMP",homepage:"https://clickio.com",category:"consent-provider",domains:["clickio.mgr.consensu.org","*.clickio.mgr.consensu.org"]},{name:"AppConsent CMP",homepage:"https://appconsent.io/en",category:"consent-provider",domains:["appconsent.mgr.consensu.org","*.appconsent.mgr.consensu.org"]},{name:"DMG Media CMP",homepage:"https://www.dmgmedia.co.uk",category:"consent-provider",domains:["dmgmedia.mgr.consensu.org","*.dmgmedia.mgr.consensu.org"]},{name:"Axel Springer CMP",homepage:"https://www.axelspringer.com",category:"consent-provider",domains:["axelspringer.mgr.cons\
ensu.org","*.axelspringer.mgr.consensu.org"]},{name:"Bedrock CMP",homepage:"https://www.bedrockstreaming.com",category:"consent-provider",domains:["bedrock.mgr.consensu.org","*.bedrock.mgr.consensu.org"]},{name:"BMIND CMP",homepage:"https://www.bmind.es",category:"consent-provider",domains:["bmind.mgr.consensu.org","*.bmind.mgr.consensu.org"]},{name:"Borlabs CMP",homepage:"https://borlabs.io",category:"consent-provider",domains:["borlabs.mgr.consensu.org","*.borlabs.mgr.consensu.org"]},{name:"Civic CMP",homepage:"https://www.civicuk.com",category:"consent-provider",domains:["cookiecontrol.mgr.consensu.org","*.cookiecontrol.mgr.consensu.org"]},{name:"Commanders Act CMP",homepage:"https://www.commandersact.com",category:"consent-provider",domains:["commandersact.mgr.consensu.org","*.commandersact.mgr.consensu.org"]},{name:"Complianz CMP",homepage:"https://complianz.io/",category:"consent-provider",domains:["complianz.mgr.consensu.org","*.complianz.mgr.consensu.org"]},{name:"Consent Desk \
CMP",homepage:"https://www.consentdesk.com/",category:"consent-provider",domains:["consentdesk.mgr.consensu.org","*.consentdesk.mgr.consensu.org"]},{name:"Consent Manager CMP",homepage:"https://consentmanager.net",category:"consent-provider",domains:["consentmanager.mgr.consensu.org","*.consentmanager.mgr.consensu.org"]},{name:"Conversant CMP",homepage:"https://www.conversantmedia.eu/",category:"consent-provider",domains:["conversant.mgr.consensu.org","*.conversant.mgr.consensu.org"]},{name:"Cookie Information CMP",homepage:"https://www.cookieinformation.com/",category:"consent-provider",domains:["cookieinformation.mgr.consensu.org","*.cookieinformation.mgr.consensu.org"]},{name:"Cookiebot CMP",homepage:"https://www.cookiebot.com",category:"consent-provider",domains:["cookiebot.mgr.consensu.org","*.cookiebot.mgr.consensu.org"]},{name:"Truendo CMP",homepage:"https://truendo.com/",category:"consent-provider",domains:["truendo.mgr.consensu.org","*.truendo.mgr.consensu.org"]},{name:"Dentsu\
 CMP",homepage:"https://www.dentsuaegisnetwork.de/",category:"consent-provider",domains:["dan.mgr.consensu.org","*.dan.mgr.consensu.org"]},{name:"Didomi CMP",homepage:"https://www.didomi.io/en/",category:"consent-provider",domains:["didomi.mgr.consensu.org","*.didomi.mgr.consensu.org"]},{name:"Ensighten CMP",homepage:"https://www.ensighten.com/",category:"consent-provider",domains:["ensighten.mgr.consensu.org","*.ensighten.mgr.consensu.org"]},{name:"Evidon CMP",homepage:"https://evidon.com",category:"consent-provider",domains:["evidon.mgr.consensu.org","*.evidon.mgr.consensu.org"]},{name:"Ezoic CMP",homepage:"https://www.ezoic.com/",category:"consent-provider",domains:["ezoic.mgr.consensu.org","*.ezoic.mgr.consensu.org"]},{name:"Gemius CMP",homepage:"https://www.gemius.com",category:"consent-provider",domains:["gemius.mgr.consensu.org","*.gemius.mgr.consensu.org"]},{name:"NitroPay CMP",homepage:"https://nitropay.com/",category:"consent-provider",domains:["nitropay.mgr.consensu.org","*.\
nitropay.mgr.consensu.org"]},{name:"Google FundingChoices",homepage:"https://fundingchoices.google.com/start/",category:"consent-provider",domains:["fundingchoices.mgr.consensu.org","*.fundingchoices.mgr.consensu.org","fundingchoicesmessages.google.com","*.fundingchoicesmessages.google.com"],totalExecutionTime:257806056,totalOccurrences:400016},{name:"Gravito CMP",homepage:"https://www.gravito.net/",category:"consent-provider",domains:["gravito.mgr.consensu.org","*.gravito.mgr.consensu.org"]},{name:"ID Ward CMP",homepage:"https://id-ward.com/enterprise",category:"consent-provider",domains:["idward.mgr.consensu.org","*.idward.mgr.consensu.org"]},{name:"iubenda CMP",homepage:"https://www.iubenda.com",category:"consent-provider",domains:["iubenda.mgr.consensu.org","*.iubenda.mgr.consensu.org"]},{name:"Jump CMP",homepage:"https://jumpgroup.it/",category:"consent-provider",domains:["avacy.mgr.consensu.org","*.avacy.mgr.consensu.org"]},{name:"LiveRamp CMP",homepage:"https://liveramp.com/",category:"\
consent-provider",domains:["faktor.mgr.consensu.org","*.faktor.mgr.consensu.org"]},{name:"Madvertise CMP",homepage:"https://madvertise.com/en/",category:"consent-provider",domains:["madvertise.mgr.consensu.org","*.madvertise.mgr.consensu.org"]},{name:"Mairdumont Netletic CMP",homepage:"https://www.mairdumont-netletix.com/",category:"consent-provider",domains:["mdnxmp.mgr.consensu.org","*.mdnxmp.mgr.consensu.org"]},{name:"Marfeel CMP",homepage:"https://www.marfeel.com/",category:"consent-provider",domains:["marfeel.mgr.consensu.org","*.marfeel.mgr.consensu.org"]},{name:"Mediavine CMP",homepage:"https://www.mediavine.com/",category:"consent-provider",domains:["mediavine.mgr.consensu.org","*.mediavine.mgr.consensu.org"]},{name:"ConsentServe CMP",homepage:"https://www.consentserve.com/",category:"consent-provider",domains:["consentserve.mgr.consensu.org","*.consentserve.mgr.consensu.org"]},{name:"Next14 CMP",homepage:"https://www.next14.com/",category:"consent-provider",domains:["next14.mg\
r.consensu.org","*.next14.mgr.consensu.org"]},{name:"AdRoll CMP",homepage:"https://www.adroll.com/",category:"consent-provider",domains:["adroll.mgr.consensu.org","*.adroll.mgr.consensu.org"]},{name:"Ogury CMP",homepage:"https://www.ogury.com/",category:"consent-provider",domains:["ogury.mgr.consensu.org","*.ogury.mgr.consensu.org"]},{name:"OneTag CMP",homepage:"https://onetag.net",category:"consent-provider",domains:["onetag.mgr.consensu.org","*.onetag.mgr.consensu.org"]},{name:"OneTrust CMP",homepage:"https://onetrust.com",category:"consent-provider",domains:["onetrust.mgr.consensu.org","*.onetrust.mgr.consensu.org"]},{name:"optAd360 CMP",homepage:"https://www.optad360.com/",category:"consent-provider",domains:["optad360.mgr.consensu.org","*.optad360.mgr.consensu.org"]},{name:"Osano CMP",homepage:"https://www.osano.com",category:"consent-provider",domains:["osano.mgr.consensu.org","*.osano.mgr.consensu.org"]},{name:"Playwire CMP",homepage:"https://www.playwire.com",category:"consent-\
provider",domains:["playwire.mgr.consensu.org","*.playwire.mgr.consensu.org"]},{name:"Pulselive CMP",homepage:"https://www.pulselive.com",category:"consent-provider",domains:["pulselive.mgr.consensu.org","*.pulselive.mgr.consensu.org"]},{name:"Quantcast Choice",homepage:"https://quantcast.com",category:"consent-provider",domains:["quantcast.mgr.consensu.org","*.quantcast.mgr.consensu.org"]},{name:"RCS Pubblicita CMP",homepage:"http://www.rcspubblicita.it/site/home.html",category:"consent-provider",domains:["rcsmediagroup.mgr.consensu.org","*.rcsmediagroup.mgr.consensu.org"]},{name:"Rich Audience CMP",homepage:"https://richaudience.com",category:"consent-provider",domains:["richaudience.mgr.consensu.org","*.richaudience.mgr.consensu.org"]},{name:"Ringier Axel Springer CMP",homepage:"https://www.ringieraxelspringer.pl/en/home/",category:"consent-provider",domains:["rasp.mgr.consensu.org","*.rasp.mgr.consensu.org"]},{name:"Secure Privacy CMP",homepage:"https://secureprivacy.ai/",category:"\
consent-provider",domains:["secureprivacy.mgr.consensu.org","*.secureprivacy.mgr.consensu.org"]},{name:"Securiti CMP",homepage:"https://securiti.ai/",category:"consent-provider",domains:["securiti.mgr.consensu.org","*.securiti.mgr.consensu.org"]},{name:"Seznam.cz CMP",homepage:"https://www.seznam.cz/",category:"consent-provider",domains:["seznam.mgr.consensu.org","*.seznam.mgr.consensu.org"]},{name:"ShareThis CMP",homepage:"https://sharethis.com",category:"consent-provider",domains:["sharethis.mgr.consensu.org","*.sharethis.mgr.consensu.org"]},{name:"ShinyStat CMP",homepage:"https://www.shinystat.com",category:"consent-provider",domains:["shinystat.mgr.consensu.org","*.shinystat.mgr.consensu.org"]},{name:"Sibbo CMP",homepage:"https://sibboventures.com/en/",category:"consent-provider",domains:["sibboventures.mgr.consensu.org","*.sibboventures.mgr.consensu.org"]},{name:"Singlespot CMP",homepage:"https://www.singlespot.com/en",category:"consent-provider",domains:["singlespot.mgr.consensu.\
org","*.singlespot.mgr.consensu.org"]},{name:"Sirdata CMP",homepage:"https://www.sirdata.com",category:"consent-provider",domains:["sddan.mgr.consensu.org","*.sddan.mgr.consensu.org"]},{name:"Snigel CMP",homepage:"https://snigel.com",category:"consent-provider",domains:["snigelweb.mgr.consensu.org","*.snigelweb.mgr.consensu.org"]},{name:"Sourcepoint CMP",homepage:"https://sourcepoint.com",category:"consent-provider",domains:["sourcepoint.mgr.consensu.org","*.sourcepoint.mgr.consensu.org"]},{name:"Pubtech CMP",homepage:"https://www.pubtech.ai/",category:"consent-provider",domains:["pubtech.mgr.consensu.org","*.pubtech.mgr.consensu.org"]},{name:"AdMetrics Pro CMP",homepage:"https://admetricspro.com",category:"consent-provider",domains:["cmp.mgr.consensu.org","*.cmp.mgr.consensu.org"]},{name:"Traffective CMP",homepage:"https://traffective.com",category:"consent-provider",domains:["traffective.mgr.consensu.org","*.traffective.mgr.consensu.org"]},{name:"UniConsent CMP",homepage:"https://www\
.uniconsent.com",category:"consent-provider",domains:["uniconsent.mgr.consensu.org","*.uniconsent.mgr.consensu.org","cmp.uniconsent.com","*.uniconsent.com"],totalExecutionTime:829870,totalOccurrences:1336},{name:"TrustArc CMP",homepage:"https://trustarc.com/",category:"consent-provider",domains:["trustarc.mgr.consensu.org","*.trustarc.mgr.consensu.org"]},{name:"Usercentrics CMP",homepage:"https://usercentrics.com",category:"consent-provider",domains:["usercentrics.mgr.consensu.org","*.usercentrics.mgr.consensu.org","*.usercentrics.eu","*.services.usercentrics.eu"],totalExecutionTime:53008518,totalOccurrences:49602},{name:"WebAds CMP",homepage:"https://www.webads.nl/",category:"consent-provider",domains:["webads.mgr.consensu.org","*.webads.mgr.consensu.org"]},{name:"Trustcommander",company:"Commandersact",homepage:"https://www.commandersact.com",category:"consent-provider",domains:["*.trustcommander.net"],examples:["cdn.trustcommander.net","privacy.trustcommander.net"],totalExecutionTime:324770,
totalOccurrences:1713},{name:"Hubvisor",homepage:"https://www.hubvisor.io",category:"ad",domains:["*.hubvisor.io"],examples:["cdn.hubvisor.io","stream.hubvisor.io"],totalExecutionTime:404737,totalOccurrences:492},{name:"Castle",homepage:"https://castle.io",category:"utility",domains:["*.castle.io","d2t77mnxyo7adj.cloudfront.net"],examples:["t.castle.io"]},{name:"Wigzo",homepage:"https://www.wigzo.com/",category:"marketing",domains:["*.wigzo.com","*.wigzopush.com"],examples:["app.wigzo.com","tracker.wigzopush.com"],totalExecutionTime:215280,totalOccurrences:762},{name:"Convertful",homepage:"https://convertful.com/",category:"marketing",domains:["*.convertful.com"],examples:["app.convertful.com"],totalExecutionTime:215317,totalOccurrences:1534},{name:"OpenLink",company:"MediaWallah",homepage:"https://www.mediawallah.com/",category:"ad",domains:["*.mediawallahscript.com"],examples:["partner.mediawallahscript.com"]},{name:"TPMN",company:"TPMN",homepage:"http://tpmn.io/",category:"ad",domains:[
"*.tpmn.co.kr"],examples:["ad.tpmn.co.kr"],totalExecutionTime:354,totalOccurrences:10},{name:"HERO",company:"Klarna",homepage:"https://www.usehero.com/",category:"customer-success",domains:["*.usehero.com"],examples:["api.usehero.com","cdn.usehero.com"],totalExecutionTime:32092,totalOccurrences:42},{name:"Zync",company:"Zeta Global",homepage:"https://zetaglobal.com/",category:"marketing",domains:["*.rezync.com"],examples:["live.rezync.com"],totalExecutionTime:25978,totalOccurrences:246},{name:"AdFuel Video",company:"AdFuel",homepage:"https://goadfuel.com/",category:"ad",domains:["*.videoplayerhub.com"],examples:["customer.videoplayerhub.com"],totalExecutionTime:82951,totalOccurrences:1407},{name:"Prefix Box AI Search",company:"Prefix Box",homepage:"https://www.prefixbox.com/",category:"utility",domains:["*.prefixbox.com"],examples:["cdn.prefixbox.com"],totalExecutionTime:51608,totalOccurrences:58},{name:"SpeedSize Service Worker",company:"SpeedSize",homepage:"https://speedsize.com/",category:"\
utility",domains:["di6367dava8ow.cloudfront.net","d2d22nphq0yz8t.cloudfront.net"],examples:["di6367dava8ow.cloudfront.net"]},{name:"Vonage Video API",company:"Vonage",homepage:"https://www.vonage.com/communications-apis/video/",category:"video",domains:["*.opentok.com"],examples:["static.opentok.com"],totalExecutionTime:220760,totalOccurrences:304},{name:"Checkout.com",company:"Checkout.com",homepage:"https://www.checkout.com",category:"utility",domains:["*.checkout.com"],examples:["cdn.checkout.com"],totalExecutionTime:184372,totalOccurrences:1367},{name:"Noibu",company:"Noibu",homepage:"https://www.noibu.com",category:"utility",domains:["*.noibu.com"],examples:["input.noibu.com"],totalExecutionTime:1453903,totalOccurrences:613},{name:"Clarity",company:"Microsoft",homepage:"https://clarity.microsoft.com/",category:"utility",domains:["*.clarity.ms"],examples:["c.clarity.ms"],totalExecutionTime:208824616,totalOccurrences:456309},{name:"goinstore",company:"Emplifi",homepage:"https://goin\
store.com/",category:"customer-success",domains:["*.goinstore.com"],examples:["gis.goinstore.com"]},{name:"SegmentStream",company:"SegmentStream",homepage:"https://segmentstream.com/",category:"marketing",domains:["*.segmentstream.com"],examples:["track.segmentstream.com"],totalExecutionTime:8628,totalOccurrences:13},{name:"Amazon Associates",company:"Amazon",homepage:"https://affiliate-program.amazon.co.uk/",category:"marketing",domains:["*.associates-amazon.com"],examples:["assoc-na.associates-amazon.com"],totalExecutionTime:50,totalOccurrences:1},{name:"DotMetrics",company:"Ipsos",homepage:"https://www.dotmetrics.net/",category:"analytics",domains:["*.dotmetrics.net"],examples:["uk-script.dotmetrics.net"],totalExecutionTime:159255,totalOccurrences:817},{name:"Truffle Bid",company:"Truffle",homepage:"https://truffle.bid/",category:"ad",domains:["*.truffle.bid"],examples:["matching.truffle.bid"],totalExecutionTime:24026,totalOccurrences:39},{name:"Hybrid",company:"Hybrid",homepage:"ht\
tps://hybrid.ai/",category:"ad",domains:["*.hybrid.ai"],examples:["dm-eu.hybrid.ai"],totalExecutionTime:219740,totalOccurrences:2326},{name:"AdMan Media",company:"AdMan",homepage:"https://admanmedia.com/",category:"video",domains:["*.admanmedia.com"],examples:["cs.admanmedia.com"],totalExecutionTime:1924,totalOccurrences:202},{name:"ID5 Identity Cloud",company:"ID5",homepage:"https://id5.io/",category:"ad",domains:["id5-sync.com","*.id5-sync.com"],examples:["id5-sync.com"],totalExecutionTime:26134069,totalOccurrences:119336},{name:"Audience Rate",company:"Audience Rate Limited",homepage:"https://www.audiencerate.com/",category:"ad",domains:["*.audrte.com"],examples:["a.audrte.com"]},{name:"Seedtag",company:"Seedtag Advertising",homepage:"https://www.seedtag.com/",category:"ad",domains:["*.seedtag.com"],examples:["s.seedtag.com"],totalExecutionTime:3342567,totalOccurrences:1503},{name:"IVI",company:"IVI Technologies",homepage:"http://ivitechnologies.com/",category:"ad",domains:["*.ivitr\
ack.com"],examples:["matching.ivitrack.com"],totalExecutionTime:3746,totalOccurrences:34},{name:"Sportradar",company:"Sportradar",homepage:"https://www.sportradar.com/",category:"ad",domains:["*.sportradarserving.com"],examples:["a.sportradarserving.com"],totalExecutionTime:520,totalOccurrences:11},{name:"ZEOTAP",company:"ZEOTAP",homepage:"https://zeotap.com/",category:"ad",domains:["*.zeotap.com"],examples:["spl.zeotap.com"],totalExecutionTime:14368,totalOccurrences:96},{name:"Web Content Assessor",company:"TMT Digital",homepage:"https://mediatrust.com/",category:"ad",domains:["*.webcontentassessor.com"],examples:["scripts.webcontentassessor.com"],totalExecutionTime:314249,totalOccurrences:633},{name:"Genie",company:"Media Force",homepage:"https://hellogenie.com/",category:"ad",domains:["*.mfadsrvr.com"],examples:["rtb.mfadsrvr.com"],totalExecutionTime:37,totalOccurrences:2},{name:"mediarithmics",company:"mediarithmics",homepage:"https://www.mediarithmics.com/",category:"ad",domains:[
"*.mediarithmics.com"],examples:["cookie-matching.mediarithmics.com"],totalExecutionTime:25799,totalOccurrences:144},{name:"Ozone Project",company:"The Ozone Project",homepage:"https://www.ozoneproject.com/",category:"ad",domains:["*.the-ozone-project.com"],examples:["elb.the-ozone-project.com"],totalExecutionTime:152768,totalOccurrences:910},{name:"FiftyAurora",company:"Fifty",homepage:"https://fifty.io/",category:"ad",domains:["*.fiftyt.com"],examples:["visitor.fiftyt.com"]},{name:"smadex",company:"entravision",homepage:"https://smadex.com/",category:"ad",domains:["*.smadex.com"],examples:["cm.smadex.com"],totalExecutionTime:5,totalOccurrences:1},{name:"AWX",company:"Trinity Mirror",category:"ad",domains:["*.tm-awx.com"],examples:["felix.data.tm-awx.com"],totalExecutionTime:68744,totalOccurrences:54},{name:"XPO",company:"Knorex",category:"ad",homepage:"https://www.knorex.com/",domains:["*.brand-display.com"],examples:["dmp.brand-display.com"],totalExecutionTime:388629,totalOccurrences:477},
{name:"Viafoura",company:"Viafoura",category:"ad",homepage:"https://viafoura.com/",domains:["*.viafoura.co","*.viafoura.net"],examples:["api.viafoura.co","cdn.viafoura.net"],totalExecutionTime:307404,totalOccurrences:446},{name:"Adnami",company:"Adnami",category:"ad",homepage:"https://www.adnami.io/",domains:["*.adnami.io"],examples:["macro.adnami.io"],totalExecutionTime:272668,totalOccurrences:1639},{name:"LiveRamp Privacy Manager",company:"LiveRamp",category:"ad",homepage:"https://liveramp.com/privacy-legal-compliance/",domains:["*.privacymanager.io"],examples:["geo.privacymanager.io"],totalExecutionTime:6546055,totalOccurrences:22295},{name:"Onfocus",company:"Onfocus SAS",category:"ad",domains:["*.4dex.io"],examples:["script.4dex.io"],totalExecutionTime:4240761,totalOccurrences:8836},{name:"viewTag",company:"Advanced Store",category:"ad",domains:["*.ad4m.at"],examples:["ad4m.at","as.ad4m.at"],totalExecutionTime:458,totalOccurrences:21},{name:"MRP Prelytics",company:"Market Resource \
Partners",category:"ad",homepage:"https://www.mrpfd.com/",domains:["*.mrpdata.net"],examples:["j.mrpdata.net"]},{name:"iPROM",company:"iPROM",category:"ad",homepage:"https://iprom.eu/",domains:["*.iprom.net"],examples:["core.iprom.net"],totalExecutionTime:114801,totalOccurrences:72099},{name:"Plausible",company:"Plausible",homepage:"https://plausible.io/",category:"analytics",domains:["*.plausible.io"]},{name:"Micro Analytics",company:"Micro Analytics",homepage:"https://microanalytics.io/",category:"analytics",domains:["padmin.microanalytics.io","www.microanalytics.io","dev.microanalytics.io","status.microanalytics.io"]},{name:"Scale8",company:"Scale8",homepage:"https://scale8.com/",category:"analytics",domains:["www.scale8.com","api-dev.scale8.com","cdn.scale8.com","ui.scale8.com"]},{name:"Cabin",company:"Cabin",homepage:"https://withcabin.com/",category:"analytics",domains:["*.withcabin.com"],totalExecutionTime:3843,totalOccurrences:100},{name:"Appcues",company:"Appcues",homepage:"ht\
tps://www.appcues.com/",category:"analytics",domains:["*.appcues.com"],totalExecutionTime:2154145,totalOccurrences:2831},{name:"Fathom Analytics",company:"Fathom",homepage:"https://usefathom.com/",category:"analytics",domains:["*.usefathom.com"],totalExecutionTime:145389,totalOccurrences:1141},{name:"Clearbit",company:"Clearbit",homepage:"https://clearbit.com/",category:"analytics",domains:["*.clearbitjs.com","*.clearbitscripts.com","*.clearbit.com"],totalExecutionTime:967253,totalOccurrences:4171},{name:"G2",company:"G2",homepage:"https://www.g2.com/",category:"utility",domains:["*.g2.com","*.g2crowd.com"],totalExecutionTime:195752,totalOccurrences:406},{name:"Navu",company:"Navu",homepage:"https://navu.co/",category:"ad",domains:["*.navu.co"]},{name:"InZynk",company:"InZynk",homepage:"https://inzynk.com/",category:"ad",domains:["*.inzynk.com","*.inzynk.io"],totalExecutionTime:541,totalOccurrences:8},{name:"Integrate",company:"Integrate",homepage:"https://www.integrate.com/",category:"\
ad",domains:["*.integrate.com","*.listenloop.com"],totalExecutionTime:14260,totalOccurrences:39},{name:"Ad Lightning",company:"Boltive",homepage:"https://www.adlightning.com/",category:"ad",domains:["*.adlightning.com"],totalExecutionTime:6879067,totalOccurrences:3795},{name:"GeoEdge",company:"GeoEdge",homepage:"https://www.geoedge.com/",category:"ad",domains:["*.geoedge.com","*.geoedge.be"],totalExecutionTime:1039615,totalOccurrences:1796},{name:"Doofinder",company:"Doofinder",homepage:"https://www.doofinder.com/",category:"utility",domains:["cdn.doofinder.com"],totalExecutionTime:1750777,totalOccurrences:12550},{name:"Revlifter",company:"Revlifter",homepage:"https://www.revlifter.com/",category:"utility",domains:["assets.revlifter.com"]},{name:"Didomi",company:"Didomi",homepage:"https://www.didomi.io/",category:"consent-provider",domains:["sdk.privacy-center.org","api.privacy-center.org"],totalExecutionTime:85132161,totalOccurrences:84206},{name:"Pubperf Analytics",company:"Pubperf",
homepage:"https://www.pubperf.com/",category:"analytics",domains:["*.pubperf.com"],totalExecutionTime:51392,totalOccurrences:400}]});var $8=je((t5e,V8)=>{d();var{createAPIFromDataset:$oe}=G8(),Yoe=W8();V8.exports=$oe(Yoe)});var Ku,gE=g(()=>{d();Ku=Kr($8(),1)});var yo={};C(yo,{configToCacheKey:()=>Joe,defaults:()=>Koe});function Joe(e){return JSON.stringify(e)}var Koe,K8=g(()=>{d();Koe=i(()=>({includeRuntimeCallStats:!1,showAllEvents:!1,debugMode:!1,maxInvalidationEventsPerEvent:20,enableAnimationsFrameHandler:!1}),"defaults");i(Joe,"configToCacheKey")});var ca={};C(ca,{extensionPalette:()=>Xoe,isConsoleTimestampPayloadTrackEntry:()=>Z8,isExtensionPayloadMarker:()=>J8,isExtensionPayloadTrackEntry:()=>X8,isSyntheticExtensionEntry:()=>Qoe,isValidExtensionPayload:()=>Zoe});function J8(e){return e.dataType==="marker"}function X8(e){let t="track"in e&&!!e.track;return(e.dataType==="track-entry"||e.dataType===void 0)&&t}function Z8(e){return e.url!==void 0&&e.description!==void 0}function Zoe(e){return J8(e)||X8(e)||Z8(e)}function Qoe(e){return e.cat==="devtools.extension"}var Xoe,Q8=g(()=>{d();Xoe=["primary","primary-light","primary-dark","secondary","secondary-light","secondary-dark","tertiary","tertiary-light","tertiary-dark","error","warning"];i(J8,"isExtensionPayloadMarker");i(X8,"isExtensionPayloadTrackEntry");i(Z8,"isConsoleTimestampPayloadTrackEntry");i(Zoe,"isValidExtensionPayload");i(Qoe,"isSyntheticExtensionEntry")});var xm={};C(xm,{DataOrigin:()=>yE,EntriesLinkState:()=>vE,EventKeyType:()=>xc,isEntriesLinkAnnotation:()=>rie,isEntryLabelAnnotation:()=>tie,isTimeRangeAnnotation:()=>eie,traceEventKeyToValues:()=>nie});function eie(e){return e.type==="TIME_RANGE"}function tie(e){return e.type==="ENTRY_LABEL"}function rie(e){return e.type==="ENTRIES_LINK"}function nie(e){let t=e.split("-"),r=t[0];switch(r){case xc.PROFILE_CALL:if(t.length!==5||!t.every((n,a)=>a===0||typeof n=="number"||!isNaN(parseInt(n,10))))throw new Error(`Invalid ProfileCallKey: ${e}`);return{type:t[0],processID:parseInt(t[1],10),threadID:parseInt(t[2],10),sampleIndex:parseInt(t[3],10),protocol:parseInt(t[4],10)};case xc.RAW_EVENT:if(t.length!==2||!(typeof t[1]=="number"||!isNaN(parseInt(t[1],10))))throw new Error(`Invalid RawEvent Key: ${e}`);return{type:t[0],rawIndex:parseInt(t[1],10)};case xc.SYNTHETIC_EVENT:if(t.length!==2||!(typeof t[1]=="number"||!isNaN(parseInt(t[1],10))))throw new Error(`Invalid SyntheticEvent Key: ${e}`);return{
type:t[0],rawIndex:parseInt(t[1],10)};case xc.LEGACY_TIMELINE_FRAME:{if(t.length!==2||Number.isNaN(parseInt(t[1],10)))throw new Error(`Invalid LegacyTimelineFrame Key: ${e}`);return{type:r,rawIndex:parseInt(t[1],10)}}default:throw new Error(`Unknown trace event key: ${e}`)}}var yE,vE,xc,e6=g(()=>{d();(function(e){e.CPU_PROFILE="CPUProfile",e.TRACE_EVENTS="TraceEvents"})(yE||(yE={}));(function(e){e.CREATION_NOT_STARTED="creation_not_started",e.PENDING_TO_EVENT="pending_to_event",e.CONNECTED="connected"})(vE||(vE={}));(function(e){e.RAW_EVENT="r",e.SYNTHETIC_EVENT="s",e.PROFILE_CALL="p",e.LEGACY_TIMELINE_FRAME="l"})(xc||(xc={}));i(eie,"isTimeRangeAnnotation");i(tie,"isEntryLabelAnnotation");i(rie,"isEntriesLinkAnnotation");i(nie,"traceEventKeyToValues")});var t6=g(()=>{d()});var O={};C(O,{Micro:()=>aie,Milli:()=>oie,Seconds:()=>iie});function aie(e){return e}function oie(e){return e}function iie(e){return e}var r6=g(()=>{d();i(aie,"Micro");i(oie,"Milli");i(iie,"Seconds")});var b={};C(b,{AuctionWorkletType:()=>wE,CallFrameID:()=>Qie,Categories:()=>xce,InvalidationEventType:()=>TE,LayoutInvalidationReason:()=>EE,MarkerName:()=>hie,NO_NAVIGATION:()=>SE,Name:()=>le,Phase:()=>Ut,ProcessID:()=>tse,ProfileID:()=>Zie,SampleIndex:()=>ese,Scope:()=>bE,SelectorTimingsKey:()=>Ir,StyleRecalcInvalidationReason:()=>DE,ThreadID:()=>rse,WorkerId:()=>nse,eventIsPageLoadEvent:()=>vie,isAbortPostTaskCallback:()=>wce,isActivateLayerTree:()=>qie,isAnimation:()=>vse,isAnimationFrameAsyncEnd:()=>Iie,isAnimationFrameAsyncStart:()=>Cie,isAnimationFramePresentation:()=>kie,isAnyScriptCatchupEvent:()=>_ce,isAuctionWorkletDoneWithProcess:()=>die,isAuctionWorkletRunningInProcess:()=>lie,isBegin:()=>ase,isBeginCommitCompositorFrame:()=>wie,isBeginFrame:()=>Mie,isBeginMainThreadFrame:()=>Lie,isBeginRemoteFontLoad:()=>Gse,isCommit:()=>Bie,isCommitLoad:()=>yse,isComplete:()=>c6,isCompositeLayers:()=>jie,isConsoleRunTask:()=>T6,isConsoleTime:()=>Yse,isConsoleTimeStamp:()=>Kse,isDOMStats:()=>mse,
isDebuggerAsyncTaskRun:()=>Xie,isDebuggerAsyncTaskScheduled:()=>Jie,isDecodeImage:()=>Wie,isDecodeLazyPixelRef:()=>Gie,isDidCommitSameDocumentNavigation:()=>Use,isDispatch:()=>ise,isDisplayListItemListSnapshot:()=>ice,isDomLoading:()=>Hse,isDrawFrame:()=>Fie,isDrawLazyPixelRef:()=>Hie,isDroppedFrame:()=>Oie,isEnd:()=>ose,isEventTiming:()=>CE,isEventTimingEnd:()=>Tse,isEventTimingStart:()=>xse,isFireAnimationFrame:()=>cce,isFireIdleCallback:()=>cse,isFirstContentfulPaint:()=>d6,isFirstPaint:()=>f6,isFlowPhase:()=>sie,isFlowPhaseEvent:()=>Dce,isFrameCommittedInBrowser:()=>gse,isFunctionCall:()=>yce,isGPUTask:()=>Sse,isHandlePostMessage:()=>lse,isInstant:()=>u6,isInteractiveTime:()=>g6,isInvalidateLayout:()=>Kie,isInvalidationTracking:()=>zie,isJSInvocationEvent:()=>Ece,isLargestContentfulPaintCandidate:()=>m6,isLargestImagePaintCandidate:()=>Ese,isLargestTextPaintCandidate:()=>Dse,isLayerTreeHostImplSnapshot:()=>sce,isLayout:()=>Yie,isLayoutImageUnsized:()=>Sie,isLayoutInvalidationTracking:()=>l6,
isLayoutShift:()=>wse,isLegacyScreenshot:()=>mie,isLegacySyntheticScreenshot:()=>pie,isLegacyTimelineFrame:()=>Sce,isLinkPreconnect:()=>Die,isMainFrameViewport:()=>jse,isMarkDOMContent:()=>h6,isMarkLoad:()=>p6,isMarkerEvent:()=>gie,isNavigationStart:()=>v6,isNeedsBeginFrameChanged:()=>Pie,isNestableAsyncPhase:()=>n6,isNetworkTrackEntry:()=>Pse,isPaint:()=>tce,isPaintImage:()=>rce,isParseAuthorStyleSheetEvent:()=>Tce,isParseHTML:()=>Xse,isParseMetaViewport:()=>Eie,isPerformanceMark:()=>$se,isPerformanceMeasure:()=>b6,isPerformanceMeasureBegin:()=>Vse,isPhaseAsync:()=>xE,isPipelineReporter:()=>Rie,isPrePaint:()=>Bse,isProcessName:()=>fse,isProfile:()=>Cse,isProfileCall:()=>ece,isProfileChunk:()=>kse,isRasterTask:()=>Uie,isReceivedDataEvent:()=>Lse,isRemoteFontLoaded:()=>Wse,isRenderFrameImplCreateChildFrame:()=>xie,isRendererEvent:()=>sse,isRequestIdleCallback:()=>dce,isRequestMainThreadFrame:()=>Nie,isResourceChangePriority:()=>Rse,isResourceFinish:()=>Mse,isResourceMarkAsCached:()=>Fse,
isResourceReceiveResponse:()=>Ase,isResourceReceivedData:()=>Nse,isResourceSendRequest:()=>_se,isResourceWillSendRequest:()=>Ose,isRunPostTaskCallback:()=>bce,isRunTask:()=>uie,isSchedulePostMessage:()=>use,isSchedulePostTaskCallback:()=>vce,isScheduleStyleInvalidationTracking:()=>o6,isScheduleStyleRecalculation:()=>Tie,isScreenshot:()=>fie,isScrollLayer:()=>nce,isSelectorStats:()=>Vie,isSetLayerId:()=>ace,isStyleInvalidatorInvalidationTracking:()=>s6,isStyleRecalcInvalidationTracking:()=>i6,isSyntheticAnimation:()=>bse,isSyntheticBased:()=>_ie,isSyntheticConsoleTiming:()=>zse,isSyntheticCpuProfile:()=>Ise,isSyntheticInteraction:()=>Aie,isSyntheticLayoutShift:()=>Zse,isSyntheticLayoutShiftCluster:()=>Qse,isSyntheticNetworkRequest:()=>y6,isSyntheticUserTiming:()=>qse,isSyntheticWebSocketConnection:()=>IE,isTargetRundownEvent:()=>Cce,isThreadName:()=>pse,isTimerFire:()=>lce,isTimerInstall:()=>uce,isTracingSessionIdForWorker:()=>bie,isTracingStartedInBrowser:()=>hse,isUpdateCounters:()=>dse,
isUpdateLayer:()=>oce,isUpdateLayoutTree:()=>$ie,isUserTiming:()=>kE,isUserTimingMeasure:()=>Jse,isV8Compile:()=>gce,isV8SourceRundownEvent:()=>Ice,isV8SourceRundownSourcesLargeScriptCatchupEvent:()=>Rce,isV8SourceRundownSourcesScriptCatchupEvent:()=>kce,isWebSocketCreate:()=>w6,isWebSocketDestroy:()=>fce,isWebSocketEvent:()=>hce,isWebSocketInfo:()=>E6,isWebSocketReceiveHandshakeResponse:()=>pce,isWebSocketSendHandshakeRequest:()=>mce,isWebSocketTraceEvent:()=>RE,isWebSocketTransfer:()=>D6,objectIsCallFrame:()=>cie});function n6(e){return e===Ut.ASYNC_NESTABLE_START||e===Ut.ASYNC_NESTABLE_END||e===Ut.ASYNC_NESTABLE_INSTANT}function xE(e){return n6(e)||e===Ut.ASYNC_BEGIN||e===Ut.ASYNC_STEP_INTO||e===Ut.ASYNC_END||e===Ut.ASYNC_STEP_PAST}function sie(e){return e===Ut.FLOW_START||e===Ut.FLOW_STEP||e===Ut.FLOW_END}function cie(e){return"functionName"in e&&typeof e.functionName=="string"&&"scriptId"in e&&(typeof e.scriptId=="string"||typeof e.scriptId=="number")&&"columnNumber"in e&&typeof e.
columnNumber=="number"&&"lineNumber"in e&&typeof e.lineNumber=="number"&&"url"in e&&typeof e.url=="string"}function uie(e){return e.name===le.RUN_TASK}function lie(e){return e.name==="AuctionWorkletRunningInProcess"}function die(e){return e.name==="AuctionWorkletDoneWithProcess"}function mie(e){return e.name===le.SCREENSHOT&&"id"in e}function pie(e){return e.name===le.SCREENSHOT&&"dataUri"in(e.args??{})}function fie(e){return e.name===le.SCREENSHOT&&"source_id"in(e.args??{})}function gie(e){return e.ph===Ut.INSTANT||e.ph===Ut.MARK?a6.some(t=>t(e)):!1}function vie(e){return e.ph===Ut.INSTANT||e.ph===Ut.MARK?yie.some(t=>t(e)):!1}function bie(e){return e.name==="TracingSessionIdForWorker"}function o6(e){return e.name===le.SCHEDULE_STYLE_INVALIDATION_TRACKING}function i6(e){return e.name===le.STYLE_RECALC_INVALIDATION_TRACKING}function s6(e){return e.name===le.STYLE_INVALIDATOR_INVALIDATION_TRACKING}function wie(e){return e.name===le.BEGIN_COMMIT_COMPOSITOR_FRAME}function Eie(e){return e.name===
le.PARSE_META_VIEWPORT}function Die(e){return e.name===le.LINK_PRECONNECT}function Tie(e){return e.name===le.SCHEDULE_STYLE_RECALCULATION}function xie(e){return e.name===le.RENDER_FRAME_IMPL_CREATE_CHILD_FRAME}function Sie(e){return e.name===le.LAYOUT_IMAGE_UNSIZED}function Cie(e){return e.name===le.ANIMATION_FRAME&&e.ph===Ut.ASYNC_NESTABLE_START}function Iie(e){return e.name===le.ANIMATION_FRAME&&e.ph===Ut.ASYNC_NESTABLE_END}function kie(e){return e.name===le.ANIMATION_FRAME_PRESENTATION}function Rie(e){return e.name===le.PIPELINE_REPORTER}function _ie(e){return"rawSourceEvent"in e}function Aie(e){return!!("interactionId"in e&&e.args?.data&&"beginEvent"in e.args.data&&"endEvent"in e.args.data)}function Fie(e){return e.name===le.DRAW_FRAME&&e.ph===Ut.INSTANT}function Mie(e){return!!(e.name===le.BEGIN_FRAME&&e.args&&"frameSeqId"in e.args)}function Oie(e){return!!(e.name===le.DROPPED_FRAME&&e.args&&"frameSeqId"in e.args)}function Nie(e){return e.name===le.REQUEST_MAIN_THREAD_FRAME}function Lie(e){
return e.name===le.BEGIN_MAIN_THREAD_FRAME}function Pie(e){return e.name===le.NEEDS_BEGIN_FRAME_CHANGED}function Bie(e){return!!(e.name===le.COMMIT&&e.args&&"frameSeqId"in e.args)}function Uie(e){return e.name===le.RASTER_TASK}function jie(e){return e.name===le.COMPOSITE_LAYERS}function qie(e){return e.name===le.ACTIVATE_LAYER_TREE}function zie(e){return o6(e)||i6(e)||s6(e)||l6(e)}function Hie(e){return e.name===le.DRAW_LAZY_PIXEL_REF}function Gie(e){return e.name===le.DECODE_LAZY_PIXEL_REF}function Wie(e){return e.name===le.DECODE_IMAGE}function Vie(e){return e.name===le.SELECTOR_STATS}function $ie(e){return e.name===le.UPDATE_LAYOUT_TREE}function Yie(e){return e.name===le.LAYOUT&&!!(e.args&&"beginData"in e.args)}function Kie(e){return e.name===le.INVALIDATE_LAYOUT}function Jie(e){return e.name===le.DEBUGGER_ASYNC_TASK_SCHEDULED}function Xie(e){return e.name===le.DEBUGGER_ASYNC_TASK_RUN}function Zie(e){return e}function Qie(e){return e}function ese(e){return e}function tse(e){return e}
function rse(e){return e}function nse(e){return e}function c6(e){return e.ph===Ut.COMPLETE}function ase(e){return e.ph===Ut.BEGIN}function ose(e){return e.ph===Ut.END}function ise(e){return e.name==="EventDispatch"}function u6(e){return e.ph===Ut.INSTANT}function sse(e){return u6(e)||c6(e)}function cse(e){return e.name==="FireIdleCallback"}function use(e){return e.name===le.SCHEDULE_POST_MESSAGE}function lse(e){return e.name===le.HANDLE_POST_MESSAGE}function dse(e){return e.name==="UpdateCounters"}function mse(e){return e.name==="DOMStats"}function pse(e){return e.name===le.THREAD_NAME}function fse(e){return e.name==="process_name"}function hse(e){return e.name===le.TRACING_STARTED_IN_BROWSER}function gse(e){return e.name==="FrameCommittedInBrowser"}function yse(e){return e.name==="CommitLoad"}function vse(e){return e.name==="Animation"&&e.cat.includes("devtools.timeline")}function bse(e){if(e.name!=="Animation"||!e.cat.includes("devtools.timeline"))return!1;let t=e.args?.data;return t?
"beginEvent"in t&&"endEvent"in t:!1}function wse(e){return e.name===le.LAYOUT_SHIFT}function l6(e){return e.name===le.LAYOUT_INVALIDATION_TRACKING}function d6(e){return e.name==="firstContentfulPaint"}function m6(e){return e.name===le.MARK_LCP_CANDIDATE}function Ese(e){return e.name==="LargestImagePaint::Candidate"}function Dse(e){return e.name==="LargestTextPaint::Candidate"}function p6(e){return e.name==="MarkLoad"}function f6(e){return e.name==="firstPaint"}function h6(e){return e.name==="MarkDOMContent"}function g6(e){return e.name==="InteractiveTime"}function CE(e){return e.name===le.EVENT_TIMING}function Tse(e){return CE(e)&&e.ph===Ut.ASYNC_NESTABLE_END}function xse(e){return CE(e)&&e.ph===Ut.ASYNC_NESTABLE_START}function Sse(e){return e.name==="GPUTask"}function Cse(e){return e.name===le.PROFILE}function Ise(e){return e.name===le.CPU_PROFILE}function kse(e){return e.name===le.PROFILE_CHUNK}function Rse(e){return e.name==="ResourceChangePriority"}function _se(e){return e.name==="\
ResourceSendRequest"}function Ase(e){return e.name==="ResourceReceiveResponse"}function Fse(e){return e.name==="ResourceMarkAsCached"}function Mse(e){return e.name==="ResourceFinish"}function Ose(e){return e.name==="ResourceWillSendRequest"}function Nse(e){return e.name==="ResourceReceivedData"}function Lse(e){return e.name==="ResourceReceivedData"||e.name==="ResourceFinish"||e.name==="ResourceReceiveResponse"}function y6(e){return e.name===le.SYNTHETIC_NETWORK_REQUEST}function IE(e){return e.name==="SyntheticWebSocketConnection"}function Pse(e){return y6(e)||IE(e)||RE(e)}function Bse(e){return e.name==="PrePaint"}function v6(e){return e.name==="navigationStart"&&e.args?.data?.documentLoaderURL!==""}function Use(e){return e.name==="RenderFrameHostImpl::DidCommitSameDocumentNavigation"}function jse(e){return e.name==="PaintTimingVisualizer::Viewport"}function qse(e){if(e.cat!=="blink.user_timing")return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function zse(e){if(e.
cat!=="blink.console")return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function kE(e){return e.cat==="blink.user_timing"}function Hse(e){return e.name===le.DOM_LOADING}function Gse(e){return e.name===le.BEGIN_REMOTE_FONT_LOAD}function Wse(e){return e.name===le.REMOTE_FONT_LOADED}function b6(e){return kE(e)&&xE(e.ph)}function Vse(e){return b6(e)&&e.ph===Ut.ASYNC_NESTABLE_START}function $se(e){return kE(e)&&(e.ph===Ut.MARK||e.ph===Ut.INSTANT)}function Yse(e){return e.cat==="blink.console"&&xE(e.ph)}function Kse(e){return e.ph===Ut.INSTANT&&e.name===le.TIME_STAMP}function Jse(e){return e.name===le.USER_TIMING_MEASURE}function Xse(e){return e.name==="ParseHTML"}function Zse(e){return e.name===le.SYNTHETIC_LAYOUT_SHIFT}function Qse(e){return e.name===le.SYNTHETIC_LAYOUT_SHIFT_CLUSTER}function ece(e){return"callFrame"in e}function tce(e){return e.name===le.PAINT}function rce(e){return e.name===le.PAINT_IMAGE}function nce(e){return e.name===le.SCROLL_LAYER}function ace(e){
return e.name===le.SET_LAYER_TREE_ID}function oce(e){return e.name===le.UPDATE_LAYER}function ice(e){return e.name===le.DISPLAY_ITEM_LIST_SNAPSHOT}function sce(e){return e.name===le.LAYER_TREE_HOST_IMPL_SNAPSHOT}function cce(e){return e.name===le.FIRE_ANIMATION_FRAME}function uce(e){return e.name===le.TIMER_INSTALL}function lce(e){return e.name===le.TIMER_FIRE}function dce(e){return e.name===le.REQUEST_IDLE_CALLBACK}function w6(e){return e.name===le.WEB_SOCKET_CREATE}function E6(e){return e.name===le.WEB_SOCKET_SEND_HANDSHAKE_REQUEST||e.name===le.WEB_SOCKET_RECEIVE_HANDSHAKE_REQUEST||e.name===le.WEB_SOCKET_DESTROY}function D6(e){return e.name===le.WEB_SOCKET_SEND||e.name===le.WEB_SOCKET_RECEIVE}function mce(e){return e.name===le.WEB_SOCKET_SEND_HANDSHAKE_REQUEST}function pce(e){return e.name===le.WEB_SOCKET_RECEIVE_HANDSHAKE_REQUEST}function fce(e){return e.name===le.WEB_SOCKET_DESTROY}function RE(e){return w6(e)||E6(e)||D6(e)}function hce(e){return RE(e)||IE(e)}function gce(e){return e.
name===le.COMPILE}function yce(e){return e.name===le.FUNCTION_CALL}function vce(e){return e.name===le.SCHEDULE_POST_TASK_CALLBACK}function bce(e){return e.name===le.RUN_POST_TASK_CALLBACK}function wce(e){return e.name===le.ABORT_POST_TASK_CALLBACK}function Ece(e){switch(e.name){case le.RUN_MICROTASKS:case le.FUNCTION_CALL:case le.EVALUATE_SCRIPT:case le.EVALUATE_MODULE:case le.EVENT_DISPATCH:case le.V8_EXECUTE:case le.V8_CONSOLE_RUN_TASK:return!0}return!!(e.name.startsWith("v8")||e.name.startsWith("V8")||T6(e))}function T6(e){return e.name===le.V8_CONSOLE_RUN_TASK}function Dce(e){return e.ph===Ut.FLOW_START||e.ph===Ut.FLOW_STEP||e.ph===Ut.FLOW_END}function Tce(e){return e.name===le.PARSE_AUTHOR_STYLE_SHEET}function Sce(e){return"idle"in e&&typeof e.idle=="boolean"}function Cce(e){return e.cat==="disabled-by-default-devtools.target-rundown"&&e.name==="ScriptCompiled"}function Ice(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown"&&e.name==="ScriptCatchup"}function kce(e){
return e.cat==="disabled-by-default-devtools.v8-source-rundown-sources"&&e.name==="ScriptCatchup"}function Rce(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown-sources"&&e.name==="LargeScriptCatchup"}function _ce(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown-sources"}var Ut,bE,wE,a6,hie,yie,SE,EE,DE,TE,Ir,le,xce,w1=g(()=>{d();(function(e){e.BEGIN="B",e.END="E",e.COMPLETE="X",e.INSTANT="I",e.COUNTER="C",e.ASYNC_NESTABLE_START="b",e.ASYNC_NESTABLE_INSTANT="n",e.ASYNC_NESTABLE_END="e",e.ASYNC_STEP_INTO="T",e.ASYNC_BEGIN="S",e.ASYNC_END="F",e.ASYNC_STEP_PAST="p",e.FLOW_START="s",e.FLOW_STEP="t",e.FLOW_END="f",e.SAMPLE="P",e.OBJECT_CREATED="N",e.OBJECT_SNAPSHOT="O",e.OBJECT_DESTROYED="D",e.METADATA="M",e.MEMORY_DUMP_GLOBAL="V",e.MEMORY_DUMP_PROCESS="v",e.MARK="R",e.CLOCK_SYNC="c"})(Ut||(Ut={}));i(n6,"isNestableAsyncPhase");i(xE,"isPhaseAsync");i(sie,"isFlowPhase");(function(e){e.THREAD="t",e.PROCESS="p",e.GLOBAL="g"})(bE||(bE={}));i(cie,"objectIsCallFram\
e");i(uie,"isRunTask");(function(e){e.BIDDER="bidder",e.SELLER="seller",e.UNKNOWN="unknown"})(wE||(wE={}));i(lie,"isAuctionWorkletRunningInProcess");i(die,"isAuctionWorkletDoneWithProcess");i(mie,"isLegacyScreenshot");i(pie,"isLegacySyntheticScreenshot");i(fie,"isScreenshot");a6=[h6,p6,f6,d6,m6,v6],hie=["MarkDOMContent","MarkLoad","firstPaint","firstContentfulPaint","largestContentfulPaint::Candidate"];i(gie,"isMarkerEvent");yie=[...a6,g6];i(vie,"eventIsPageLoadEvent");i(bie,"isTracingSessionIdForWorker");SE="NO_NAVIGATION";(function(e){e.SIZE_CHANGED="Size changed",e.ATTRIBUTE="Attribute",e.ADDED_TO_LAYOUT="Added to layout",e.SCROLLBAR_CHANGED="Scrollbar changed",e.REMOVED_FROM_LAYOUT="Removed from layout",e.STYLE_CHANGED="Style changed",e.FONTS_CHANGED="Fonts changed",e.UNKNOWN="Unknown"})(EE||(EE={}));i(o6,"isScheduleStyleInvalidationTracking");(function(e){e.ANIMATION="Animation",e.RELATED_STYLE_RULE="Related style rule"})(DE||(DE={}));i(i6,"isStyleRecalcInvalidationTracking");i(s6,
"isStyleInvalidatorInvalidationTracking");i(wie,"isBeginCommitCompositorFrame");i(Eie,"isParseMetaViewport");i(Die,"isLinkPreconnect");i(Tie,"isScheduleStyleRecalculation");i(xie,"isRenderFrameImplCreateChildFrame");i(Sie,"isLayoutImageUnsized");i(Cie,"isAnimationFrameAsyncStart");i(Iie,"isAnimationFrameAsyncEnd");i(kie,"isAnimationFramePresentation");i(Rie,"isPipelineReporter");i(_ie,"isSyntheticBased");i(Aie,"isSyntheticInteraction");i(Fie,"isDrawFrame");i(Mie,"isBeginFrame");i(Oie,"isDroppedFrame");i(Nie,"isRequestMainThreadFrame");i(Lie,"isBeginMainThreadFrame");i(Pie,"isNeedsBeginFrameChanged");i(Bie,"isCommit");i(Uie,"isRasterTask");i(jie,"isCompositeLayers");i(qie,"isActivateLayerTree");i(zie,"isInvalidationTracking");i(Hie,"isDrawLazyPixelRef");i(Gie,"isDecodeLazyPixelRef");i(Wie,"isDecodeImage");(function(e){e.StyleInvalidatorInvalidationTracking="StyleInvalidatorInvalidationTracking",e.StyleRecalcInvalidationTracking="StyleRecalcInvalidationTracking"})(TE||(TE={}));(function(e){
e.Elapsed="elapsed (us)",e.RejectPercentage="reject_percentage",e.FastRejectCount="fast_reject_count",e.MatchAttempts="match_attempts",e.MatchCount="match_count",e.Selector="selector",e.StyleSheetId="style_sheet_id",e.InvalidationCount="invalidation_count"})(Ir||(Ir={}));i(Vie,"isSelectorStats");i($ie,"isUpdateLayoutTree");i(Yie,"isLayout");i(Kie,"isInvalidateLayout");i(Jie,"isDebuggerAsyncTaskScheduled");i(Xie,"isDebuggerAsyncTaskRun");i(Zie,"ProfileID");i(Qie,"CallFrameID");i(ese,"SampleIndex");i(tse,"ProcessID");i(rse,"ThreadID");i(nse,"WorkerId");i(c6,"isComplete");i(ase,"isBegin");i(ose,"isEnd");i(ise,"isDispatch");i(u6,"isInstant");i(sse,"isRendererEvent");i(cse,"isFireIdleCallback");i(use,"isSchedulePostMessage");i(lse,"isHandlePostMessage");i(dse,"isUpdateCounters");i(mse,"isDOMStats");i(pse,"isThreadName");i(fse,"isProcessName");i(hse,"isTracingStartedInBrowser");i(gse,"isFrameCommittedInBrowser");i(yse,"isCommitLoad");i(vse,"isAnimation");i(bse,"isSyntheticAnimation");i(wse,"\
isLayoutShift");i(l6,"isLayoutInvalidationTracking");i(d6,"isFirstContentfulPaint");i(m6,"isLargestContentfulPaintCandidate");i(Ese,"isLargestImagePaintCandidate");i(Dse,"isLargestTextPaintCandidate");i(p6,"isMarkLoad");i(f6,"isFirstPaint");i(h6,"isMarkDOMContent");i(g6,"isInteractiveTime");i(CE,"isEventTiming");i(Tse,"isEventTimingEnd");i(xse,"isEventTimingStart");i(Sse,"isGPUTask");i(Cse,"isProfile");i(Ise,"isSyntheticCpuProfile");i(kse,"isProfileChunk");i(Rse,"isResourceChangePriority");i(_se,"isResourceSendRequest");i(Ase,"isResourceReceiveResponse");i(Fse,"isResourceMarkAsCached");i(Mse,"isResourceFinish");i(Ose,"isResourceWillSendRequest");i(Nse,"isResourceReceivedData");i(Lse,"isReceivedDataEvent");i(y6,"isSyntheticNetworkRequest");i(IE,"isSyntheticWebSocketConnection");i(Pse,"isNetworkTrackEntry");i(Bse,"isPrePaint");i(v6,"isNavigationStart");i(Use,"isDidCommitSameDocumentNavigation");i(jse,"isMainFrameViewport");i(qse,"isSyntheticUserTiming");i(zse,"isSyntheticConsoleTiming");
i(kE,"isUserTiming");i(Hse,"isDomLoading");i(Gse,"isBeginRemoteFontLoad");i(Wse,"isRemoteFontLoaded");i(b6,"isPerformanceMeasure");i(Vse,"isPerformanceMeasureBegin");i($se,"isPerformanceMark");i(Yse,"isConsoleTime");i(Kse,"isConsoleTimeStamp");i(Jse,"isUserTimingMeasure");i(Xse,"isParseHTML");i(Zse,"isSyntheticLayoutShift");i(Qse,"isSyntheticLayoutShiftCluster");i(ece,"isProfileCall");i(tce,"isPaint");i(rce,"isPaintImage");i(nce,"isScrollLayer");i(ace,"isSetLayerId");i(oce,"isUpdateLayer");i(ice,"isDisplayListItemListSnapshot");i(sce,"isLayerTreeHostImplSnapshot");i(cce,"isFireAnimationFrame");i(uce,"isTimerInstall");i(lce,"isTimerFire");i(dce,"isRequestIdleCallback");i(w6,"isWebSocketCreate");i(E6,"isWebSocketInfo");i(D6,"isWebSocketTransfer");i(mce,"isWebSocketSendHandshakeRequest");i(pce,"isWebSocketReceiveHandshakeResponse");i(fce,"isWebSocketDestroy");i(RE,"isWebSocketTraceEvent");i(hce,"isWebSocketEvent");i(gce,"isV8Compile");i(yce,"isFunctionCall");i(vce,"isSchedulePostTaskCallb\
ack");i(bce,"isRunPostTaskCallback");i(wce,"isAbortPostTaskCallback");i(Ece,"isJSInvocationEvent");i(T6,"isConsoleRunTask");i(Dce,"isFlowPhaseEvent");i(Tce,"isParseAuthorStyleSheetEvent");(function(e){e.THREAD_NAME="thread_name",e.PROGRAM="Program",e.RUN_TASK="RunTask",e.ASYNC_TASK="AsyncTask",e.RUN_MICROTASKS="RunMicrotasks",e.XHR_LOAD="XHRLoad",e.XHR_READY_STATE_CHANGED="XHRReadyStateChange",e.PARSE_HTML="ParseHTML",e.PARSE_CSS="ParseAuthorStyleSheet",e.COMPILE_CODE="V8.CompileCode",e.COMPILE_MODULE="V8.CompileModule",e.COMPILE="v8.compile",e.COMPILE_SCRIPT="V8.CompileScript",e.OPTIMIZE="V8.OptimizeCode",e.WASM_STREAM_FROM_RESPONSE_CALLBACK="v8.wasm.streamFromResponseCallback",e.WASM_COMPILED_MODULE="v8.wasm.compiledModule",e.WASM_CACHED_MODULE="v8.wasm.cachedModule",e.WASM_MODULE_CACHE_HIT="v8.wasm.moduleCacheHit",e.WASM_MODULE_CACHE_INVALID="v8.wasm.moduleCacheInvalid",e.PROFILE_CALL="ProfileCall",e.EVALUATE_SCRIPT="EvaluateScript",e.FUNCTION_CALL="FunctionCall",e.EVENT_DISPATCH="E\
ventDispatch",e.EVALUATE_MODULE="v8.evaluateModule",e.REQUEST_MAIN_THREAD_FRAME="RequestMainThreadFrame",e.REQUEST_ANIMATION_FRAME="RequestAnimationFrame",e.CANCEL_ANIMATION_FRAME="CancelAnimationFrame",e.FIRE_ANIMATION_FRAME="FireAnimationFrame",e.REQUEST_IDLE_CALLBACK="RequestIdleCallback",e.CANCEL_IDLE_CALLBACK="CancelIdleCallback",e.FIRE_IDLE_CALLBACK="FireIdleCallback",e.TIMER_INSTALL="TimerInstall",e.TIMER_REMOVE="TimerRemove",e.TIMER_FIRE="TimerFire",e.WEB_SOCKET_CREATE="WebSocketCreate",e.WEB_SOCKET_SEND_HANDSHAKE="WebSocketSendHandshakeRequest",e.WEB_SOCKET_RECEIVE_HANDSHAKE="WebSocketReceiveHandshakeResponse",e.WEB_SOCKET_DESTROY="WebSocketDestroy",e.WEB_SOCKET_SEND="WebSocketSend",e.WEB_SOCKET_RECEIVE="WebSocketReceive",e.CRYPTO_DO_ENCRYPT="DoEncrypt",e.CRYPTO_DO_ENCRYPT_REPLY="DoEncryptReply",e.CRYPTO_DO_DECRYPT="DoDecrypt",e.CRYPTO_DO_DECRYPT_REPLY="DoDecryptReply",e.CRYPTO_DO_DIGEST="DoDigest",e.CRYPTO_DO_DIGEST_REPLY="DoDigestReply",e.CRYPTO_DO_SIGN="DoSign",e.CRYPTO_DO_SIGN_REPLY=
"DoSignReply",e.CRYPTO_DO_VERIFY="DoVerify",e.CRYPTO_DO_VERIFY_REPLY="DoVerifyReply",e.V8_EXECUTE="V8.Execute",e.V8_CONSOLE_RUN_TASK="V8Console::runTask",e.SCHEDULE_POST_TASK_CALLBACK="SchedulePostTaskCallback",e.RUN_POST_TASK_CALLBACK="RunPostTaskCallback",e.ABORT_POST_TASK_CALLBACK="AbortPostTaskCallback",e.DEBUGGER_ASYNC_TASK_RUN="v8::Debugger::AsyncTaskRun",e.DEBUGGER_ASYNC_TASK_SCHEDULED="v8::Debugger::AsyncTaskScheduled",e.GC="GCEvent",e.DOMGC="BlinkGC.AtomicPhase",e.MAJOR_GC="MajorGC",e.MINOR_GC="MinorGC",e.GC_COLLECT_GARBARGE="BlinkGC.AtomicPhase",e.CPPGC_SWEEP="CppGC.IncrementalSweep",e.SCHEDULE_STYLE_RECALCULATION="ScheduleStyleRecalculation",e.LAYOUT="Layout",e.UPDATE_LAYOUT_TREE="UpdateLayoutTree",e.INVALIDATE_LAYOUT="InvalidateLayout",e.LAYOUT_INVALIDATION_TRACKING="LayoutInvalidationTracking",e.COMPUTE_INTERSECTION="ComputeIntersections",e.HIT_TEST="HitTest",e.PRE_PAINT="PrePaint",e.LAYERIZE="Layerize",e.LAYOUT_SHIFT="LayoutShift",e.SYNTHETIC_LAYOUT_SHIFT="SyntheticLayout\
Shift",e.SYNTHETIC_LAYOUT_SHIFT_CLUSTER="SyntheticLayoutShiftCluster",e.UPDATE_LAYER_TREE="UpdateLayerTree",e.SCHEDULE_STYLE_INVALIDATION_TRACKING="ScheduleStyleInvalidationTracking",e.STYLE_RECALC_INVALIDATION_TRACKING="StyleRecalcInvalidationTracking",e.STYLE_INVALIDATOR_INVALIDATION_TRACKING="StyleInvalidatorInvalidationTracking",e.SELECTOR_STATS="SelectorStats",e.BEGIN_COMMIT_COMPOSITOR_FRAME="BeginCommitCompositorFrame",e.PARSE_META_VIEWPORT="ParseMetaViewport",e.SCROLL_LAYER="ScrollLayer",e.UPDATE_LAYER="UpdateLayer",e.PAINT_SETUP="PaintSetup",e.PAINT="Paint",e.PAINT_IMAGE="PaintImage",e.COMMIT="Commit",e.COMPOSITE_LAYERS="CompositeLayers",e.RASTER_TASK="RasterTask",e.IMAGE_DECODE_TASK="ImageDecodeTask",e.IMAGE_UPLOAD_TASK="ImageUploadTask",e.DECODE_IMAGE="Decode Image",e.DRAW_LAZY_PIXEL_REF="Draw LazyPixelRef",e.DECODE_LAZY_PIXEL_REF="Decode LazyPixelRef",e.GPU_TASK="GPUTask",e.RASTERIZE="Rasterize",e.EVENT_TIMING="EventTiming",e.OPTIMIZE_CODE="V8.OptimizeCode",e.CACHE_SCRIPT="v\
8.produceCache",e.CACHE_MODULE="v8.produceModuleCache",e.V8_SAMPLE="V8Sample",e.JIT_CODE_ADDED="JitCodeAdded",e.JIT_CODE_MOVED="JitCodeMoved",e.STREAMING_COMPILE_SCRIPT="v8.parseOnBackground",e.STREAMING_COMPILE_SCRIPT_WAITING="v8.parseOnBackgroundWaiting",e.STREAMING_COMPILE_SCRIPT_PARSING="v8.parseOnBackgroundParsing",e.BACKGROUND_DESERIALIZE="v8.deserializeOnBackground",e.FINALIZE_DESERIALIZATION="V8.FinalizeDeserialization",e.COMMIT_LOAD="CommitLoad",e.MARK_LOAD="MarkLoad",e.MARK_DOM_CONTENT="MarkDOMContent",e.MARK_FIRST_PAINT="firstPaint",e.MARK_FCP="firstContentfulPaint",e.MARK_LCP_CANDIDATE="largestContentfulPaint::Candidate",e.MARK_LCP_INVALIDATE="largestContentfulPaint::Invalidate",e.NAVIGATION_START="navigationStart",e.CONSOLE_TIME="ConsoleTime",e.USER_TIMING="UserTiming",e.INTERACTIVE_TIME="InteractiveTime",e.TIME_STAMP="TimeStamp",e.BEGIN_FRAME="BeginFrame",e.NEEDS_BEGIN_FRAME_CHANGED="NeedsBeginFrameChanged",e.BEGIN_MAIN_THREAD_FRAME="BeginMainThreadFrame",e.ACTIVATE_LAYER_TREE=
"ActivateLayerTree",e.DRAW_FRAME="DrawFrame",e.DROPPED_FRAME="DroppedFrame",e.FRAME_STARTED_LOADING="FrameStartedLoading",e.PIPELINE_REPORTER="PipelineReporter",e.SCREENSHOT="Screenshot",e.RESOURCE_WILL_SEND_REQUEST="ResourceWillSendRequest",e.RESOURCE_SEND_REQUEST="ResourceSendRequest",e.RESOURCE_RECEIVE_RESPONSE="ResourceReceiveResponse",e.RESOURCE_RECEIVE_DATA="ResourceReceivedData",e.RESOURCE_FINISH="ResourceFinish",e.RESOURCE_MARK_AS_CACHED="ResourceMarkAsCached",e.WEB_SOCKET_SEND_HANDSHAKE_REQUEST="WebSocketSendHandshakeRequest",e.WEB_SOCKET_RECEIVE_HANDSHAKE_REQUEST="WebSocketReceiveHandshakeResponse",e.CPU_PROFILE="CpuProfile",e.PROFILE="Profile",e.START_PROFILING="CpuProfiler::StartProfiling",e.PROFILE_CHUNK="ProfileChunk",e.UPDATE_COUNTERS="UpdateCounters",e.JS_SAMPLE="JSSample",e.ANIMATION="Animation",e.PARSE_AUTHOR_STYLE_SHEET="ParseAuthorStyleSheet",e.EMBEDDER_CALLBACK="EmbedderCallback",e.SET_LAYER_TREE_ID="SetLayerTreeId",e.TRACING_STARTED_IN_PAGE="TracingStartedInPage",
e.TRACING_STARTED_IN_BROWSER="TracingStartedInBrowser",e.TRACING_SESSION_ID_FOR_WORKER="TracingSessionIdForWorker",e.LAZY_PIXEL_REF="LazyPixelRef",e.LAYER_TREE_HOST_IMPL_SNAPSHOT="cc::LayerTreeHostImpl",e.PICTURE_SNAPSHOT="cc::Picture",e.DISPLAY_ITEM_LIST_SNAPSHOT="cc::DisplayItemList",e.INPUT_LATENCY_MOUSE_MOVE="InputLatency::MouseMove",e.INPUT_LATENCY_MOUSE_WHEEL="InputLatency::MouseWheel",e.IMPL_SIDE_FLING="InputHandlerProxy::HandleGestureFling::started",e.SCHEDULE_POST_MESSAGE="SchedulePostMessage",e.HANDLE_POST_MESSAGE="HandlePostMessage",e.RENDER_FRAME_IMPL_CREATE_CHILD_FRAME="RenderFrameImpl::createChildFrame",e.LAYOUT_IMAGE_UNSIZED="LayoutImageUnsized",e.DOM_LOADING="domLoading",e.BEGIN_REMOTE_FONT_LOAD="BeginRemoteFontLoad",e.REMOTE_FONT_LOADED="RemoteFontLoaded",e.ANIMATION_FRAME="AnimationFrame",e.ANIMATION_FRAME_PRESENTATION="AnimationFrame::Presentation",e.SYNTHETIC_NETWORK_REQUEST="SyntheticNetworkRequest",e.USER_TIMING_MEASURE="UserTiming::Measure",e.LINK_PRECONNECT="Lin\
kPreconnect"})(le||(le={}));xce={Console:"blink.console",UserTiming:"blink.user_timing",Loading:"loading"};i(Sce,"isLegacyTimelineFrame");i(Cce,"isTargetRundownEvent");i(Ice,"isV8SourceRundownEvent");i(kce,"isV8SourceRundownSourcesScriptCatchupEvent");i(Rce,"isV8SourceRundownSourcesLargeScriptCatchupEvent");i(_ce,"isAnyScriptCatchupEvent")});var Le=g(()=>{d();K8();Q8();e6();t6();r6();w1()});var Ha={};C(Ha,{addEventToEntityMapping:()=>AE,addNetworkRequestToEntityMapping:()=>FE,getEntityForEvent:()=>_E,getEntityForUrl:()=>x6,getNonResolvedURL:()=>E1,makeUpEntity:()=>S6});function _E(e,t){let r=E1(e);if(r)return x6(r,t)}function x6(e,t){let r=t.entityByUrlCache.get(e);if(r)return r;let n=Ku.default.getEntity(e)??S6(t.createdEntityCache,e);return n&&t.entityByUrlCache.set(e,n),n}function E1(e,t){if(b.isProfileCall(e))return e.callFrame.url;if(b.isSyntheticNetworkRequest(e))return e.args.data.url;if(b.isParseAuthorStyleSheetEvent(e)&&e.args)return e.args.data.stylesheetUrl;if(e.args?.data?.stackTrace&&e.args.data.stackTrace.length>0)return e.args.data.stackTrace[0].url;if(b.isParseHTML(e))return e.args.beginData.url;if(t){if(b.isDecodeImage(e)){let n=t.ImagePainting.paintImageForEvent.get(e);return n?E1(n,t):null}if(b.isDrawLazyPixelRef(e)&&e.args?.LazyPixelRef){let n=t.ImagePainting.paintImageByDrawLazyPixelRef.get(e.args.LazyPixelRef);return n?E1(n,t):null}}if(e.args?.data?.
url)return e.args.data.url;let r=e.args?.data?.requestId;if(t&&r){let n=t.NetworkRequests.byId.get(r)?.args.data.url;if(n)return n}return null}function S6(e,t){if(t.startsWith("chrome-extension:"))return Fce(e,t);if(!t.startsWith("http"))return;let r=Ku.default.getRootDomain(t);if(!r)return;if(e.has(r))return e.get(r);let n={name:r,company:r,category:"",categories:[],domains:[r],averageExecutionTime:0,totalExecutionTime:0,totalOccurrences:0,isUnrecognized:!0};return e.set(r,n),n}function Ace(e){return e.protocol+"//"+e.host}function Fce(e,t,r){let n=new URL(t),a=Ace(n),o=new URL(a).host,s=r||o,c=e.get(a);if(c)return c;let u={name:s,company:s,category:"Chrome Extension",homepage:"https://chromewebstore.google.com/detail/"+o,categories:[],domains:[a],averageExecutionTime:0,totalExecutionTime:0,totalOccurrences:0};return e.set(a,u),u}function AE(e,t){if(t.entityByEvent.has(e))return;let r=_E(e,t);if(!r)return;let n=t.eventsByEntity.get(r);n?n.push(e):t.eventsByEntity.set(r,[e]),t.entityByEvent.
set(e,r)}function FE(e,t,r){let n=_E(e,t);if(!n)return;let a=[e,...Object.values(r).flat()],o=t.eventsByEntity.get(n);o?o.push(...a):t.eventsByEntity.set(n,a);for(let s of a)t.entityByEvent.set(s,n)}var D1=g(()=>{d();gE();Le();i(_E,"getEntityForEvent");i(x6,"getEntityForUrl");i(E1,"getNonResolvedURL");i(S6,"makeUpEntity");i(Ace,"getChromeExtensionOrigin");i(Fce,"makeUpChromeExtensionEntity");i(AE,"addEventToEntityMapping");i(FE,"addNetworkRequestToEntityMapping")});var Hr={};C(Hr,{DEFAULT_COMPARATOR:()=>Uce,arrayDoesNotContainNullOrUndefined:()=>Hce,binaryIndexOf:()=>Lce,intersectOrdered:()=>Pce,lowerBound:()=>I6,mergeOrdered:()=>Bce,nearestIndexFromBeginning:()=>qce,nearestIndexFromEnd:()=>zce,removeElement:()=>Mce,sortRange:()=>Nce,upperBound:()=>jce});function ME(e,t,r){let n=e[t];e[t]=e[r],e[r]=n}function Oce(e,t,r,n,a){let o=e[a];ME(e,n,a);let s=r;for(let c=r;c<n;++c)t(e[c],o)<0&&(ME(e,s,c),++s);return ME(e,n,s),s}function OE(e,t,r,n,a,o){if(n<=r)return;let s=Math.floor(Math.random()*(n-r))+r,c=Oce(e,t,r,n,s);a<c&&OE(e,t,r,c-1,a,o),c<o&&OE(e,t,c+1,n,a,o)}function Nce(e,t,r,n,a,o){return r===0&&n===e.length-1&&a===0&&o>=n?e.sort(t):OE(e,t,r,n,a,o),e}function C6(e,t,r,n){let a=[],o=0,s=0;for(;o<e.length&&s<t.length;){let c=r(e[o],t[s]);(n||!c)&&a.push(c<=0?e[o]:t[s]),c<=0&&o++,c>=0&&s++}if(n){for(;o<e.length;)a.push(e[o++]);for(;s<t.length;)a.push(t[s++])}return a}function I6(e,t,r,n,a){let o=n||0,s=a!==void 0?a:e.length;for(;o<s;){let c=o+s>>
1;r(t,e[c])>0?o=c+1:s=c}return s}function jce(e,t,r,n,a){let o=n||0,s=a!==void 0?a:e.length;for(;o<s;){let c=o+s>>1;r(t,e[c])>=0?o=c+1:s=c}return s}function k6(e,t,r){let n=r==="END";if(e.length===0)return null;let a=0,o=e.length-1,s=0,c=!1,u=!1,l=0;do l=a+(o-a)/2,s=n?Math.ceil(l):Math.floor(l),c=t(e[s]),u=c===n,u?a=Math.min(o,s+(a===s?1:0)):o=Math.max(a,s+(o===s?-1:0));while(o!==a);return t(e[a])?a:null}function qce(e,t){return k6(e,t,"BEGINNING")}function zce(e,t){return k6(e,t,"END")}function Hce(e){return!e.includes(null)&&!e.includes(void 0)}var Mce,Lce,Pce,Bce,Uce,R6=g(()=>{d();Mce=i((e,t,r)=>{let n=e.indexOf(t);if(n===-1)return!1;if(r)return e.splice(n,1),!0;for(let a=n+1,o=e.length;a<o;++a)e[a]!==t&&(e[n++]=e[a]);return e.length=n,!0},"removeElement");i(ME,"swap");i(Oce,"partition");i(OE,"quickSortRange");i(Nce,"sortRange");Lce=i((e,t,r)=>{let n=I6(e,t,r);return n<e.length&&r(t,e[n])===0?n:-1},"binaryIndexOf");i(C6,"mergeOrIntersect");Pce=i((e,t,r)=>C6(e,t,r,!1),"intersectOrder\
ed"),Bce=i((e,t,r)=>C6(e,t,r,!0),"mergeOrdered"),Uce=i((e,t)=>e<t?-1:e>t?1:0,"DEFAULT_COMPARATOR");i(I6,"lowerBound");i(jce,"upperBound");i(k6,"nearestIndex");i(qce,"nearestIndexFromBeginning");i(zce,"nearestIndexFromEnd");i(Hce,"arrayDoesNotContainNullOrUndefined")});var _6=g(()=>{d()});var A6=g(()=>{d()});var F6=g(()=>{d()});var M6=g(()=>{d()});var O6=g(()=>{d()});var N6=g(()=>{d()});var Ne={};C(Ne,{Multimap:()=>T1,getWithDefault:()=>Kce,inverse:()=>Yce});function Kce(e,t,r){let n=e.get(t);return n==null&&(n=r(t),e.set(t,n)),n}var Yce,T1,L6=g(()=>{d();Yce=i(function(e){let t=new T1;for(let[r,n]of e.entries())t.set(n,r);return t},"inverse"),T1=class{static{i(this,"Multimap")}map=new Map;set(t,r){let n=this.map.get(t);n||(n=new Set,this.map.set(t,n)),n.add(r)}get(t){return this.map.get(t)||new Set}has(t){return this.map.has(t)}hasValue(t,r){let n=this.map.get(t);return n?n.has(r):!1}get size(){return this.map.size}delete(t,r){let n=this.get(t);if(!n)return!1;let a=n.delete(r);return n.size||this.map.delete(t),a}deleteAll(t){this.map.delete(t)}keysArray(){return[...this.map.keys()]}keys(){return this.map.keys()}valuesArray(){let t=[];for(let r of this.map.values())t.push(...r.values());return t}clear(){this.map.clear()}};i(Kce,"getWithDefault")});var P6=g(()=>{d()});var vo={};C(vo,{aspectRatio:()=>rue,clamp:()=>Xce,floor:()=>eue,greatestCommonDivisor:()=>B6,mod:()=>Zce,toFixedIfFloating:()=>Qce,withThousandsSeparator:()=>nue});var Xce,Zce,Qce,eue,B6,tue,rue,nue,U6=g(()=>{d();Xce=i((e,t,r)=>{let n=e;return e<t?n=t:e>r&&(n=r),n},"clamp"),Zce=i((e,t)=>(e%t+t)%t,"mod"),Qce=i(e=>{if(!e||Number.isNaN(Number(e)))return e;let t=Number(e);return t%1?t.toFixed(3):String(t)},"toFixedIfFloating"),eue=i((e,t=0)=>{if(t>0&&t<1)return t=1/t,Math.floor(e/t)*t;let r=Math.pow(10,t);return Math.floor(e*r)/r},"floor"),B6=i((e,t)=>{for(e=Math.round(e),t=Math.round(t);t!==0;){let r=t;t=e%t,e=r}return e},"greatestCommonDivisor"),tue=new Map([["8∶5","16∶10"]]),rue=i((e,t)=>{let r=B6(e,t);r!==0&&(e/=r,t/=r);let n=`${e}∶${t}`;return tue.get(n)||n},"aspectRatio"),nue=i(function(e){let t=String(e),r=/(\d+)(\d{3})/;for(;t.match(r);)t=t.replace(r,"$1 $2");return t},"withThousandsSeparator")});var j6=g(()=>{d()});var q6=g(()=>{d()});var z6=g(()=>{d()});var x1={};C(x1,{assertNever:()=>Ju,assertNotNullOrUndefined:()=>H6,assertUnhandled:()=>G6});function H6(e,t){if(e==null)throw new Error(`Expected given value to not be null/undefined but it was: ${e}${t?`
${t}`:""}`)}function Ju(e,t){throw new Error(t)}function G6(e){return e}var NE=g(()=>{d();i(H6,"assertNotNullOrUndefined");i(Ju,"assertNever");i(G6,"assertUnhandled")});var W6=g(()=>{d()});var V6=g(()=>{d()});var rr=g(()=>{d();R6();_6();A6();F6();M6();O6();N6();L6();P6();U6();j6();q6();z6();NE();W6();V6();NE()});var kr={};C(kr,{SyntheticEventsManager:()=>Sm});var S1,Sm,LE=g(()=>{d();S1=null,Sm=class e{static{i(this,"SyntheticEventsManager")}#e=[];#t=[];static activate(t){S1=t}static createAndActivate(t){let r=new e(t);return e.activate(r),r}static getActiveManager(){if(!S1)throw new Error("Attempted to get a SyntheticEventsManager without initializing");return S1}static reset(){S1=null}static registerSyntheticEvent(t){try{return e.getActiveManager().#o(t)}catch{return t}}constructor(t){this.#t=t}#o(t){let r=this.#t.indexOf(t.rawSourceEvent);if(r<0)throw new Error("Attempted to register a synthetic event paired to an unknown raw event.");let n=t;return this.#e[r]=n,n}syntheticEventForRawEventIndex(t){let r=this.#e.at(t);if(!r)throw new Error(`Attempted to get a synthetic event from an unknown raw event index: ${t}`);return r}getSyntheticTraces(){return this.#e}getRawTraceEvents(){return this.#t}}});var ae={};C(ae,{boundsIncludeTimeRange:()=>vue,combineTraceWindowsMicro:()=>BE,eventIsInBounds:()=>UE,eventTimingsMicroSeconds:()=>Im,eventTimingsMilliSeconds:()=>pue,expandWindowByPercentOrToOneMillisecond:()=>mue,microToMilli:()=>Sc,microToSeconds:()=>lue,milliToMicro:()=>ss,secondsToMicro:()=>uue,secondsToMilli:()=>$6,timeStampForEventAdjustedByClosestNavigation:()=>due,timestampIsInBounds:()=>bue,traceWindowFromEvent:()=>Cm,traceWindowFromMicroSeconds:()=>PE,traceWindowFromMilliSeconds:()=>gue,traceWindowFromOverlay:()=>yue,traceWindowMicroSecondsToMilliSeconds:()=>hue,traceWindowMilliSeconds:()=>fue,windowFitsInsideBounds:()=>wue,windowsEqual:()=>Eue});function due(e,t,r,n){let a=e.ts-t.min;if(e.args?.data?.navigationId){let o=r.get(e.args.data.navigationId);o&&(a=e.ts-o.ts)}else if(e.args?.data?.frame){let o=jE(e,e.args.data.frame,n);o&&(a=e.ts-o.ts)}return O.Micro(a)}function mue(e,t,r){let n=e.min-e.range*(r/100)/2,a=e.max+e.range*(r/100)/2;if(a-n<1e3){let s=(e.min+e.max)/2;n=s-
500,a=s+500}return n=Math.max(n,t.min),a=Math.min(a,t.max),{min:O.Micro(n),max:O.Micro(a),range:O.Micro(a-n)}}function Im(e){return{startTime:e.ts,endTime:e.ts+(e.dur??0),duration:e.dur||0}}function pue(e){return{startTime:e.ts/1e3,endTime:(e.ts+(e.dur??0))/1e3,duration:(e.dur||0)/1e3}}function fue(e){return{min:Sc(e.min),max:Sc(e.max),range:Sc(e.range)}}function hue(e){return{min:Sc(e.min),max:Sc(e.max),range:Sc(e.range)}}function gue(e,t){return{min:ss(e),max:ss(t),range:O.Micro(ss(t)-ss(e))}}function PE(e,t){return{min:e,max:t,range:t-e}}function Cm(e){return{min:e.ts,max:e.ts+(e.dur??0),range:e.dur??0}}function yue(e){switch(e.type){case"ENTRY_LABEL":case"ENTRY_OUTLINE":case"ENTRY_SELECTED":return Cm(e.entry);case"TIMESPAN_BREAKDOWN":{let t=e.sections.map(r=>r.bounds);return e.entry&&t.push(Cm(e.entry)),BE(t)}case"CANDY_STRIPED_TIME_RANGE":case"TIME_RANGE":return structuredClone(e.bounds);case"ENTRIES_LINK":{let t=Cm(e.entryFrom);if(!e.entryTo)return t;let r=Cm(e.entryTo);return BE(
[t,r])}case"TIMESTAMP_MARKER":return PE(e.timestamp,e.timestamp);case"TIMINGS_MARKER":return PE(e.adjustedTimestamp,e.adjustedTimestamp);case"BOTTOM_INFO_BAR":return null;default:x1.assertNever(e,`Unexpected overlay ${e}`)}}function BE(e){if(!e.length)return null;let t=structuredClone(e[0]);for(let r of e.slice(1))t.min=Math.min(t.min,r.min),t.max=Math.max(t.max,r.max);return t.range=t.max-t.min,t}function vue(e){let{min:t,max:r}=e.bounds,{min:n,max:a}=e.timeRange;return t<=a&&r>=n}function UE(e,t){let r=e.ts;return r<=t.max&&t.min<=r+(e.dur??0)}function bue(e,t){return t>=e.min&&t<=e.max}function wue(e){return e.window.min>=e.bounds.min&&e.window.max<=e.bounds.max}function Eue(e,t){return e.min===t.min&&e.max===t.max}var ss,$6,uue,Sc,lue,km=g(()=>{d();rr();Le();Rm();ss=i(e=>O.Micro(e*1e3),"milliToMicro"),$6=i(e=>O.Milli(e*1e3),"secondsToMilli"),uue=i(e=>ss($6(e)),"secondsToMicro"),Sc=i(e=>O.Milli(e/1e3),"microToMilli"),lue=i(e=>O.Seconds(e/1e3/1e3),"microToSeconds");i(due,"timeStampFo\
rEventAdjustedByClosestNavigation");i(mue,"expandWindowByPercentOrToOneMillisecond");i(Im,"eventTimingsMicroSeconds");i(pue,"eventTimingsMilliSeconds");i(fue,"traceWindowMilliSeconds");i(hue,"traceWindowMicroSecondsToMilliSeconds");i(gue,"traceWindowFromMilliSeconds");i(PE,"traceWindowFromMicroSeconds");i(Cm,"traceWindowFromEvent");i(yue,"traceWindowFromOverlay");i(BE,"combineTraceWindowsMicro");i(vue,"boundsIncludeTimeRange");i(UE,"eventIsInBounds");i(bue,"timestampIsInBounds");i(wue,"windowFitsInsideBounds");i(Eue,"windowsEqual")});var Me={};C(Me,{VISIBLE_TRACE_EVENT_TYPES:()=>que,activeURLForFrameAtTime:()=>Sue,addEventToProcessThread:()=>Tue,compareBeginAndEnd:()=>K6,createMatchedSortedSyntheticEvents:()=>Cue,createSortedSyntheticEvents:()=>Z6,eventContainsTimestamp:()=>jue,eventHasCategory:()=>Bue,eventTimeComparator:()=>HE,extractId:()=>J6,extractOriginFromTrace:()=>Due,extractSampleTraceId:()=>C1,findNextEventAfterTimestamp:()=>Oue,findPreviousEventBeforeTimestamp:()=>Nue,findUpdateLayoutTreeEvents:()=>Mue,forEachEvent:()=>Lue,frameIDForEvent:()=>_ue,getNavigationForTraceEvent:()=>jE,getZeroIndexedLineAndColumnForEvent:()=>Iue,getZeroIndexedStackTraceInEventPayload:()=>kue,isExtensionUrl:()=>Fue,isMatchingCallFrame:()=>Uue,isTopLevelEvent:()=>Q6,makeProfileCall:()=>Am,makeZeroBasedCallFrame:()=>zE,matchEvents:()=>X6,mergeEventsInOrder:()=>GE,parseDevtoolsDetails:()=>xue,sortTraceEventsInPlace:()=>_m,stackTraceInEvent:()=>Y6});function Y6(e){if(e.args?.data?.stackTrace)return e.args.data.stackTrace;if(e.args?.
stackTrace)return e.args.stackTrace;if(b.isUpdateLayoutTree(e))return e.args.beginData?.stackTrace||null;if(b.isLayout(e))return e.args.beginData.stackTrace??null;if(b.isFunctionCall(e)){let t=e.args.data;if(!t)return null;let{columnNumber:r,lineNumber:n,url:a,scriptId:o,functionName:s}=t;return n===void 0||s===void 0||r===void 0||o===void 0||a===void 0?null:[{columnNumber:r,lineNumber:n,url:a,scriptId:o,functionName:s}]}if(b.isProfileCall(e)){let t=e.callFrame;if(!t)return null;let{columnNumber:r,lineNumber:n,url:a,scriptId:o,functionName:s}=t;return n===void 0||s===void 0||r===void 0||o===void 0||a===void 0?null:[{columnNumber:r,lineNumber:n,url:a,scriptId:o,functionName:s}]}return null}function Due(e){let t=new URL(e);return t?t.host.startsWith("www.")?t.host.slice(4):t.host:null}function Tue(e,t){let{tid:r,pid:n}=e,a=t.get(n);a||(a=new Map);let o=a.get(r);o||(o=[]),o.push(e),a.set(e.tid,o),t.set(e.pid,a)}function K6(e,t,r,n){return e<t?-1:e>t?1:r>n?-1:r<n?1:0}function HE(e,t){let r=e.
ts,n=t.ts,a=e.dur??0,o=t.dur??0,s=r+a,c=n+o,u=K6(r,n,s,c);return u||(b.isProfileCall(e)&&!b.isProfileCall(t)?-1:b.isProfileCall(t)&&!b.isProfileCall(e)?1:0)}function _m(e){e.sort(HE)}function GE(e,t){let r=[],n=0,a=0;for(;n<e.length&&a<t.length;){let o=e[n],s=t[a],c=HE(o,s);c<=0&&(r.push(o),n++),c===1&&(r.push(s),a++)}for(;n<e.length;)r.push(e[n++]);for(;a<t.length;)r.push(t[a++]);return r}function xue(e,t){try{let r=JSON.parse(e);return!(t in r)||!ca.isValidExtensionPayload(r[t])?null:r[t]}catch{return null}}function jE(e,t,r){let n=r.get(t);if(!n||t==="")return null;let a=Hr.nearestIndexFromEnd(n,o=>o.ts<=e.ts);return a===null?null:n[a]}function J6(e){return e.id??e.id2?.global??e.id2?.local}function Sue(e,t,r){let n=r.get(e);if(!n)return null;for(let a of n.values())for(let o of a)if(!(o.window.min>t||o.window.max<t))return o.frame.url;return null}function Am(e,t,r,n,a,o){return{cat:"",name:"ProfileCall",nodeId:e.id,args:{},ph:b.Phase.COMPLETE,pid:a,tid:o,ts:n,dur:O.Micro(0),callFrame:e.
callFrame,sampleIndex:r,profileId:t}}function X6(e){let t=new Map;for(let r of e){let n=qE(r);if(n===void 0)continue;let a=Ne.getWithDefault(t,n,()=>({begin:null,end:null,instant:[]})),o=r.ph===b.Phase.ASYNC_NESTABLE_START,s=r.ph===b.Phase.ASYNC_NESTABLE_END,c=r.ph===b.Phase.ASYNC_NESTABLE_INSTANT;o?a.begin=r:s?a.end=r:c&&(a.instant||(a.instant=[]),a.instant.push(r))}return t}function qE(e){let t=J6(e);return t&&`${e.cat}:${t}:${e.name}`}function Z6(e,t){let r=[];for(let[n,a]of e.entries()){let l=function(f){let h=f.instantEvents?f.instantEvents.some(v=>n===qE(v)):!1,y=f.endEvent?n===qE(f.endEvent):!1;return!!n&&(h||y)};i(l,"eventsArePairable");let o=a.begin,s=a.end,c=a.instant;if(!o||!(s||c))continue;let u={beginEvent:o,endEvent:s,instantEvents:c};if(!l(u))continue;let m=s||o,p=Sm.registerSyntheticEvent({rawSourceEvent:u.beginEvent,cat:m.cat,ph:m.ph,pid:m.pid,tid:m.tid,id:n,name:o.name,dur:O.Micro(m.ts-o.ts),ts:o.ts,args:{data:u}});p.dur<0||(t?.(p),r.push(p))}return r.sort((n,a)=>n.ts-
a.ts)}function Cue(e,t){let r=X6(e);return Z6(r,t)}function Iue(e){let t=Rue(e),{lineNumber:r,columnNumber:n}=t;switch(e.name){case b.Name.FUNCTION_CALL:case b.Name.EVALUATE_SCRIPT:case b.Name.COMPILE:case b.Name.CACHE_SCRIPT:return{lineNumber:typeof r=="number"?r-1:void 0,columnNumber:typeof n=="number"?n-1:void 0};case b.Name.PROFILE_CALL:{let a=e.callFrame;return{lineNumber:typeof r=="number"?a.lineNumber-1:void 0,columnNumber:typeof n=="number"?a.columnNumber-1:void 0}}default:return t}}function kue(e){let t=Y6(e);return t?t.map(r=>{switch(e.name){case b.Name.SCHEDULE_STYLE_RECALCULATION:case b.Name.INVALIDATE_LAYOUT:case b.Name.FUNCTION_CALL:case b.Name.LAYOUT:case b.Name.UPDATE_LAYOUT_TREE:return zE(r);default:if(b.isUserTiming(e)||ca.isSyntheticExtensionEntry(e))return zE(r)}return r}):null}function zE(e){let t={...e};return t.lineNumber=e.lineNumber&&e.lineNumber-1,t.columnNumber=e.columnNumber&&e.columnNumber-1,t}function Rue(e){if(!e.args?.data)return{lineNumber:void 0,columnNumber:void 0};
let t,r;return"lineNumber"in e.args.data&&typeof e.args.data.lineNumber=="number"&&(t=e.args.data.lineNumber),"columnNumber"in e.args.data&&typeof e.args.data.columnNumber=="number"&&(r=e.args.data.columnNumber),{lineNumber:t,columnNumber:r}}function _ue(e){return e.args&&"beginData"in e.args&&typeof e.args.beginData=="object"&&e.args.beginData!==null&&"frame"in e.args.beginData&&typeof e.args.beginData.frame=="string"?e.args.beginData.frame:e.args?.data?.frame?e.args.data.frame:null}function Q6(e){return e.cat.includes(Aue)&&e.name===b.Name.RUN_TASK}function Fue(e){return e.startsWith("extensions:")||e.startsWith("chrome-extension:")}function e4(e,t){let r=Hr.upperBound(e,t,(n,a)=>n-a.ts)-1;for(;r>0&&!Q6(e[r]);)r--;return Math.max(r,0)}function Mue(e,t,r){let n=[],a=e4(e,t);for(let o=a;o<e.length;o++){let s=e[o];b.isUpdateLayoutTree(s)&&(s.ts>=(r||1/0)||n.push(s))}return n}function Oue(e,t){let r=Hr.nearestIndexFromBeginning(e,n=>t<n.ts);return r===null?null:e[r]}function Nue(e,t){let r=Hr.
nearestIndexFromEnd(e,n=>n.ts<t);return r===null?null:e[r]}function Lue(e,t){let r=t.startTime??O.Micro(0),n=t.endTime||O.Micro(1/0),a=t.ignoreAsyncEvents!==!1,o=[],s=e4(e,r);for(let c=s;c<e.length;c++){let u=e[c],l=Im(u);if(l.endTime<r)continue;if(l.startTime>n)break;if(a&&b.isPhaseAsync(u.ph)||b.isFlowPhase(u.ph))continue;let p=o.at(-1),f=p?Im(p).endTime:null;for(;p&&f&&f<=l.startTime;)o.pop(),t.onEndEvent(p),p=o.at(-1),f=p?Im(p).endTime:null;t.eventFilter&&!t.eventFilter(u)||(l.duration?(t.onStartEvent(u),o.push(u)):t.onInstantEvent&&t.onInstantEvent(u))}for(;o.length;){let c=o.pop();c&&t.onEndEvent(c)}}function Bue(e,t){let r=Pue.get(e.cat);return r||(r=new Set(e.cat.split(",")||[])),r.has(t)}function Uue(e,t){return e.columnNumber===t.columnNumber&&e.lineNumber===t.lineNumber&&String(e.scriptId)===t.scriptId&&e.url===t.url&&e.functionName===t.functionName}function jue(e,t){return e.ts<=t&&e.ts+(e.dur||0)>=t}function C1(e){return e.args?"beginData"in e.args?e.args.beginData.sampleTraceId??
null:e.args?.sampleTraceId??e.args?.data?.sampleTraceId??null:null}var Aue,Pue,que,Rm=g(()=>{d();rr();Le();LE();km();i(Y6,"stackTraceInEvent");i(Due,"extractOriginFromTrace");i(Tue,"addEventToProcessThread");i(K6,"compareBeginAndEnd");i(HE,"eventTimeComparator");i(_m,"sortTraceEventsInPlace");i(GE,"mergeEventsInOrder");i(xue,"parseDevtoolsDetails");i(jE,"getNavigationForTraceEvent");i(J6,"extractId");i(Sue,"activeURLForFrameAtTime");i(Am,"makeProfileCall");i(X6,"matchEvents");i(qE,"getSyntheticId");i(Z6,"createSortedSyntheticEvents");i(Cue,"createMatchedSortedSyntheticEvents");i(Iue,"getZeroIndexedLineAndColumnForEvent");i(kue,"getZeroIndexedStackTraceInEventPayload");i(zE,"makeZeroBasedCallFrame");i(Rue,"getRawLineAndColumnNumbersForEvent");i(_ue,"frameIDForEvent");Aue="disabled-by-default-devtools.timeline";i(Q6,"isTopLevelEvent");i(Fue,"isExtensionUrl");i(e4,"topLevelEventIndexEndingAfter");i(Mue,"findUpdateLayoutTreeEvents");i(Oue,"findNextEventAfterTimestamp");i(Nue,"findPreviousE\
ventBeforeTimestamp");i(Lue,"forEachEvent");Pue=new Map;i(Bue,"eventHasCategory");i(Uue,"isMatchingCallFrame");i(jue,"eventContainsTimestamp");i(C1,"extractSampleTraceId");que=new Set([b.Name.ABORT_POST_TASK_CALLBACK,b.Name.ANIMATION,b.Name.ASYNC_TASK,b.Name.BACKGROUND_DESERIALIZE,b.Name.CACHE_MODULE,b.Name.CACHE_SCRIPT,b.Name.CANCEL_ANIMATION_FRAME,b.Name.CANCEL_IDLE_CALLBACK,b.Name.COMMIT,b.Name.COMPILE_CODE,b.Name.COMPILE_MODULE,b.Name.COMPILE,b.Name.COMPOSITE_LAYERS,b.Name.COMPUTE_INTERSECTION,b.Name.CONSOLE_TIME,b.Name.CPPGC_SWEEP,b.Name.CRYPTO_DO_DECRYPT_REPLY,b.Name.CRYPTO_DO_DECRYPT,b.Name.CRYPTO_DO_DIGEST_REPLY,b.Name.CRYPTO_DO_DIGEST,b.Name.CRYPTO_DO_ENCRYPT_REPLY,b.Name.CRYPTO_DO_ENCRYPT,b.Name.CRYPTO_DO_SIGN_REPLY,b.Name.CRYPTO_DO_SIGN,b.Name.CRYPTO_DO_VERIFY_REPLY,b.Name.CRYPTO_DO_VERIFY,b.Name.DECODE_IMAGE,b.Name.EMBEDDER_CALLBACK,b.Name.EVALUATE_MODULE,b.Name.EVALUATE_SCRIPT,b.Name.EVENT_DISPATCH,b.Name.EVENT_TIMING,b.Name.FINALIZE_DESERIALIZATION,b.Name.FIRE_ANIMATION_FRAME,
b.Name.FIRE_IDLE_CALLBACK,b.Name.FUNCTION_CALL,b.Name.GC_COLLECT_GARBARGE,b.Name.GC,b.Name.GPU_TASK,b.Name.HANDLE_POST_MESSAGE,b.Name.HIT_TEST,b.Name.JS_SAMPLE,b.Name.LAYERIZE,b.Name.LAYOUT,b.Name.MAJOR_GC,b.Name.MINOR_GC,b.Name.OPTIMIZE_CODE,b.Name.PAINT_SETUP,b.Name.PAINT,b.Name.PARSE_AUTHOR_STYLE_SHEET,b.Name.PARSE_HTML,b.Name.PRE_PAINT,b.Name.PROFILE_CALL,b.Name.PROGRAM,b.Name.RASTER_TASK,b.Name.REQUEST_ANIMATION_FRAME,b.Name.REQUEST_IDLE_CALLBACK,b.Name.RESOURCE_FINISH,b.Name.RESOURCE_RECEIVE_DATA,b.Name.RESOURCE_RECEIVE_RESPONSE,b.Name.RESOURCE_SEND_REQUEST,b.Name.RESOURCE_WILL_SEND_REQUEST,b.Name.RUN_MICROTASKS,b.Name.RUN_POST_TASK_CALLBACK,b.Name.RUN_TASK,b.Name.SCHEDULE_POST_MESSAGE,b.Name.SCHEDULE_POST_TASK_CALLBACK,b.Name.SCHEDULE_STYLE_RECALCULATION,b.Name.SCROLL_LAYER,b.Name.START_PROFILING,b.Name.STREAMING_COMPILE_SCRIPT_PARSING,b.Name.STREAMING_COMPILE_SCRIPT_WAITING,b.Name.STREAMING_COMPILE_SCRIPT,b.Name.SYNTHETIC_LAYOUT_SHIFT_CLUSTER,b.Name.SYNTHETIC_LAYOUT_SHIFT,b.Name.
TIME_STAMP,b.Name.TIMER_FIRE,b.Name.TIMER_INSTALL,b.Name.TIMER_REMOVE,b.Name.UPDATE_LAYER_TREE,b.Name.UPDATE_LAYOUT_TREE,b.Name.USER_TIMING,b.Name.V8_CONSOLE_RUN_TASK,b.Name.WASM_CACHED_MODULE,b.Name.WASM_COMPILED_MODULE,b.Name.WASM_MODULE_CACHE_HIT,b.Name.WASM_MODULE_CACHE_INVALID,b.Name.WASM_STREAM_FROM_RESPONSE_CALLBACK,b.Name.WEB_SOCKET_CREATE,b.Name.WEB_SOCKET_DESTROY,b.Name.WEB_SOCKET_RECEIVE_HANDSHAKE_REQUEST,b.Name.WEB_SOCKET_RECEIVE,b.Name.WEB_SOCKET_SEND_HANDSHAKE_REQUEST,b.Name.WEB_SOCKET_SEND,b.Name.XHR_LOAD,b.Name.XHR_READY_STATE_CHANGED])});var ai={};C(ai,{canBuildTreesFromEvents:()=>YE,makeEmptyTraceEntryNode:()=>n4,makeEmptyTraceEntryTree:()=>r4,makeTraceEntryNodeId:()=>t4,treify:()=>VE,walkEntireTree:()=>Hue,walkTreeFromEntry:()=>zue});function VE(e,t){let r=new Map,n=[];WE=-1;let a=r4();for(let o=0;o<e.length;o++){let s=e[o];if(t&&!t.filter.has(s.name))continue;let c=s.dur||0,u=t4(),l=n4(s,u);if(n.length===0){a.roots.add(l),l.selfTime=O.Micro(c),n.push(l),a.maxDepth=Math.max(a.maxDepth,n.length),r.set(s,l);continue}let m=n.at(-1);if(m===void 0)throw new Error("Impossible: no parent node found in the stack");let p=m.entry,f=s.ts,h=p.ts,y=p.dur||0,v=f+c,E=h+y;if(f<h)throw new Error("Impossible: current event starts before the parent event");if(f>=E){n.pop(),o--,WE--;continue}v>E||(l.depth=n.length,l.parent=m,m.children.push(l),l.selfTime=O.Micro(c),m.selfTime!==void 0&&(m.selfTime=O.Micro(m.selfTime-(s.dur||0))),n.push(l),a.maxDepth=Math.max(a.maxDepth,n.length),r.set(s,l))}return{tree:a,entryToNode:r}}function zue(e,t,r,n){
let a=e.get(t);a&&$E(e,a,r,n)}function Hue(e,t,r,n,a,o){for(let s of t.roots)$E(e,s,r,n,a,o)}function $E(e,t,r,n,a,o){if(!(a&&!Gue(t,a))&&!(typeof o<"u"&&O.Micro(t.entry.ts+O.Micro(t.entry.dur??0))<o)){r(t.entry);for(let s of t.children)$E(e,s,r,n,a,o);n(t.entry)}}function Gue(e,t){return UE(e.entry,t)}function YE(e){let t=[];for(let r of e){let n=r.ts,a=r.ts+(r.dur??0),o=t.at(-1);if(o===void 0){t.push(r);continue}let s=o.ts+(o.dur??0);for(;t.length&&n>=s&&(t.pop(),o=t.at(-1),o!==void 0);)s=o.ts+(o.dur??0);if(t.length&&a>s)return!1;t.push(r)}return!0}var WE,t4,r4,n4,KE=g(()=>{d();Le();km();WE=0,t4=i(()=>++WE,"makeTraceEntryNodeId"),r4=i(()=>({roots:new Set,maxDepth:0}),"makeEmptyTraceEntryTree"),n4=i((e,t)=>({entry:e,id:t,parent:null,children:[],depth:0}),"makeEmptyTraceEntryNode");i(VE,"treify");i(zue,"walkTreeFromEntry");i(Hue,"walkEntireTree");i($E,"walkTreeByNode");i(Gue,"treeNodeIsInWindow");i(YE,"canBuildTreesFromEvents")});var Fm={};C(Fm,{buildTrackDataFromExtensionEntries:()=>Wue});function Wue(e,t,r){let n=new Map;for(let a of e){let o=a.args.trackGroup||`track-name-${a.args.track}`,s=Ne.getWithDefault(n,o,()=>({name:a.args.trackGroup||a.args.track,isTrackGroup:!!a.args.trackGroup,entriesByTrack:{[a.args.track]:[]}}));s.entriesByTrack[a.args.track]||(s.entriesByTrack[a.args.track]=[]),s.entriesByTrack[a.args.track].push(a)}for(let a of n.values()){for(let o of Object.values(a.entriesByTrack))if(_m(o),YE(o))for(let[s,c]of VE(o).entryToNode)r.set(s,c);t.push(a)}return{extensionTrackData:t,entryToNode:r}}var a4=g(()=>{d();rr();Rm();KE();i(Wue,"buildTrackDataFromExtensionEntries")});var En={};C(En,{CACHEABLE_STATUS_CODES:()=>Jue,NON_NETWORK_SCHEMES:()=>Zue,STATIC_RESOURCE_TYPES:()=>Xue,isSyntheticNetworkRequestEventRenderBlocking:()=>$ue,isSyntheticNetworkRequestHighPriority:()=>Kue,isSyntheticNetworkRequestLocalhost:()=>tle,parseCacheControl:()=>Que});function $ue(e){return!Vue.has(e.args.data.renderBlocking)}function Kue(e){return Yue.has(e.args.data.priority)}function Que(e){if(!e)return null;let t=e.split(",").map(n=>n.trim()),r={};for(let n of t){let[a,o]=n.split("=").map(s=>s.trim());switch(a){case"max-age":{let s=parseInt(o,10);isNaN(s)||(r["max-age"]=s);break}case"no-cache":r["no-cache"]=!0;break;case"no-store":r["no-store"]=!0;break;case"must-revalidate":r["must-revalidate"]=!0;break;case"private":r.private=!0;break;default:break}}return r}function tle(e){try{let t=new URL(e.args.data.url).hostname;return ele.includes(t)||t.endsWith(".localhost")}catch{return!1}}var Vue,Yue,Jue,Xue,Zue,ele,o4=g(()=>{d();Vue=new Set(["non_blocking","dynamically_injected_no\
n_blocking","potentially_blocking"]);i($ue,"isSyntheticNetworkRequestEventRenderBlocking");Yue=new Set(["VeryHigh","High","Medium"]);i(Kue,"isSyntheticNetworkRequestHighPriority");Jue=new Set([200,203,206]),Xue=new Set(["Font","Image","Media","Script","Stylesheet"]),Zue=["blob","data","intent","file","filesystem","chrome-extension"];i(Que,"parseCacheControl");ele=["localhost","127.0.0.1"];i(tle,"isSyntheticNetworkRequestLocalhost")});var Mm={};C(Mm,{SamplesIntegrator:()=>cs});var cs,JE=g(()=>{d();Le();km();Rm();cs=class e{static{i(this,"SamplesIntegrator")}#e=[];#t=[];#o;#r;#a=[];#c=!1;#n;#i=new Map;#u;#s;jsSampleEvents=[];constructor(t,r,n,a,o){this.#n=t,this.#r=a,this.#o=n,this.#u=o||yo.defaults(),this.#s=r}buildProfileCalls(t){let r=GE(t,this.callsFromProfileSamples()),n=[];for(let a=0;a<r.length;a++){let o=r[a];if(o.ph===b.Phase.INSTANT&&!C1(o))continue;if(n.length===0){if(b.isProfileCall(o)){this.#p(o);continue}n.push(o),this.#l(o);continue}let s=n.at(-1);if(s===void 0)continue;let c=o.ts,u=s.ts,l=s.dur||0,m=u+l;if(c>=m){this.#d(s),n.pop(),a--;continue}if(b.isProfileCall(o)){this.#p(o,s);continue}this.#l(o),n.push(o)}for(;n.length;){let a=n.pop();a&&this.#d(a)}return _m(this.jsSampleEvents),this.#e}#l(t){(t.name===b.Name.RUN_MICROTASKS||t.name===b.Name.RUN_TASK)&&(this.#a=[],this.#g(0,t.ts),this.#c=!1),this.#c&&(this.#g(this.#a.pop()||0,t.ts),this.#c=!1),this.#h(t),this.#a.push(this.#t.length)}#p(t,r){if(r&&b.
isJSInvocationEvent(r)||this.#c)this.#h(t);else if(b.isProfileCall(t)&&this.#t.length===0){this.#c=!0;let n=this.#t.length;this.#h(t),this.#a.push(n)}}#d(t){let r=O.Micro(t.ts+(t.dur??0));this.#g(this.#a.pop()||0,r)}callsFromProfileSamples(){let t=this.#n.samples,r=this.#n.timestamps;if(!t)return[];let n=[],a;for(let o=0;o<t.length;o++){let s=this.#n.nodeByIndex(o),c=ss(O.Milli(r[o]));if(!s)continue;let u=Am(s,this.#s,o,c,this.#o,this.#r);if(n.push(u),this.#u.debugMode){let l=this.#n.traceIds?.[o];this.jsSampleEvents.push(this.#y(u,c,l))}if(s.id===this.#n.gcNode?.id&&a){this.#i.set(u,a);continue}a=s}return n}#m(t,r){let n=this.#n.nodeById(t.nodeId),a=n?.id===this.#n.gcNode?.id;if(a&&(n=this.#i.get(t)||null),!n)return[];let o=new Array(n.depth+1+Number(a)),s=o.length-1;for(a&&(o[s--]=t);n;)o[s--]=Am(n,t.profileId,t.sampleIndex,r??t.ts,this.#o,this.#r),n=n.parent;return o}#f(t,r){let n=this.#n.traceIds?.[t],a=n&&this.#n.nodeById(n),o=a&&Am(a,this.#s,-1,r,this.#o,this.#r);return o?(this.#u.
debugMode&&this.jsSampleEvents.push(this.#y(o,r,t)),this.#m(o)):null}#h(t){let r=this.#t;b.isProfileCall(t)&&(r=this.#m(t));let n=C1(t),a=n&&this.#f(n,t.ts);a&&(r=a),e.filterStackFrames(r,this.#u);let o=t.ts+(t.dur||0),s=Math.min(r.length,this.#t.length),c;for(c=this.#a.at(-1)||0;c<s;++c){let u=r[c].callFrame,l=this.#t[c].callFrame;if(!e.framesAreEqual(u,l))break;this.#t[c].dur=O.Micro(Math.max(this.#t[c].dur||0,o-this.#t[c].ts))}for(this.#g(c,t.ts);c<r.length;++c){let u=r[c];u.nodeId===this.#n.programNode?.id||u.nodeId===this.#n.root?.id||u.nodeId===this.#n.idleNode?.id||u.nodeId===this.#n.gcNode?.id||(this.#t.push(u),this.#e.push(u))}}#g(t,r){if(this.#a.length){let n=this.#a.at(-1);n&&t<n&&(console.error(`Child stack is shallower (${t}) than the parent stack (${n}) at ${r}`),t=n)}this.#t.length<t&&(console.error(`Trying to truncate higher than the current stack size at ${r}`),t=this.#t.length);for(let n=0;n<this.#t.length;++n)this.#t[n].dur=O.Micro(Math.max(r-this.#t[n].ts,0));this.#t.
length=t}#y(t,r,n){return{name:b.Name.JS_SAMPLE,cat:"devtools.timeline",args:{data:{traceId:n,stackTrace:this.#m(t).map(o=>o.callFrame)}},ph:b.Phase.INSTANT,ts:r,dur:O.Micro(0),pid:this.#o,tid:this.#r}}static framesAreEqual(t,r){return t.scriptId===r.scriptId&&t.functionName===r.functionName&&t.lineNumber===r.lineNumber}static showNativeName(t,r){return r&&!!e.nativeGroup(t)}static nativeGroup(t){return t.startsWith("Parse")?e.NativeGroups.PARSE:t.startsWith("Compile")||t.startsWith("Recompile")?e.NativeGroups.COMPILE:null}static isNativeRuntimeFrame(t){return t.url==="native V8Runtime"}static filterStackFrames(t,r){if(r.showAllEvents)return;let a=null,o=0;for(let s=0;s<t.length;++s){let c=t[s].callFrame,u=e.isNativeRuntimeFrame(c);if(u&&!e.showNativeName(c.functionName,r.includeRuntimeCallStats))continue;let l=u?e.nativeGroup(c.functionName):null;a&&a===l||(a=l,t[o++]=t[s])}t.length=o}static createFakeTraceFromCpuProfile(t,r){return t?{traceEvents:[{cat:"disabled-by-default-devtools.t\
imeline",name:b.Name.CPU_PROFILE,ph:b.Phase.COMPLETE,pid:b.ProcessID(1),tid:r,ts:O.Micro(t.startTime),dur:O.Micro(t.endTime-t.startTime),args:{data:{cpuProfile:t}},id:"0x1"}],metadata:{dataOrigin:xm.DataOrigin.CPU_PROFILE}}:{traceEvents:[],metadata:{}}}static extractCpuProfileFromFakeTrace(t){let n=t.find(a=>b.isSyntheticCpuProfile(a))?.args.data.cpuProfile;if(!n)throw new Error("Missing cpuProfile data");return n}};(function(e){let t;(function(r){r.COMPILE="Compile",r.PARSE="Parse"})(t=e.NativeGroups||(e.NativeGroups={}))})(cs||(cs={}))});var Xe={};C(Xe,{Extensions:()=>Fm,Network:()=>En,SamplesIntegrator:()=>Mm,SyntheticEvents:()=>kr,Timing:()=>ae,Trace:()=>Me,TreeHelpers:()=>ai});var ot=g(()=>{d();a4();o4();JE();LE();km();Rm();KE()});var tD={};C(tD,{data:()=>ile,deps:()=>sle,finalize:()=>ole,handleEvent:()=>ale,handleUserConfig:()=>nle,reset:()=>rle});function i4(e){return`${e.pid}-${e.tid}`}function rle(){I1.clear(),k1.clear(),ZE.length=0,QE.clear(),XE.clear(),eD=!1}function nle(e){eD=e.enableAnimationsFrameHandler}function ale(e){if(eD)if(b.isAnimationFrameAsyncStart(e)){let t=i4(e),r=I1.get(t)??[];r.push(e),I1.set(t,r)}else if(b.isAnimationFrameAsyncEnd(e)){let t=i4(e),r=k1.get(t)??[];r.push(e),k1.set(t,r)}else b.isAnimationFramePresentation(e)&&e.args?.id&&XE.set(e.args.id,e)}async function ole(){for(let[e,t]of I1.entries()){let r=k1.get(e);if(r){Me.sortTraceEventsInPlace(t),Me.sortTraceEventsInPlace(r);for(let n=0;n<t.length;n++){let a=r.at(n);if(!a)break;let o=t[n],s=kr.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:o,...o,dur:O.Micro(a.ts-o.ts),args:{data:{beginEvent:o,endEvent:a}}});ZE.push(s);let c=o.args?.id;if(c){let u=XE.get(c);u&&QE.set(s,u)}}}}}function ile(){return{animationFrames:ZE,presentationForFrame:QE}}
function sle(){return["Meta"]}var I1,k1,XE,ZE,QE,eD,s4=g(()=>{d();ot();Le();i(i4,"threadKey");I1=new Map,k1=new Map,XE=new Map,ZE=[],QE=new Map;i(rle,"reset");eD=!1;i(nle,"handleUserConfig");i(ale,"handleEvent");i(ole,"finalize");i(ile,"data");i(sle,"deps")});var aD={};C(aD,{data:()=>dle,finalize:()=>lle,handleEvent:()=>ule,reset:()=>cle});function cle(){rD.length=0,nD.length=0}function ule(e){if(b.isAnimation(e)){rD.push(e);return}}async function lle(){let e=Me.createMatchedSortedSyntheticEvents(rD);nD.push(...e)}function dle(){return{animations:nD}}var rD,nD,c4=g(()=>{d();ot();Le();rD=[],nD=[];i(cle,"reset");i(ule,"handleEvent");i(lle,"finalize");i(dle,"data")});var dD={};C(dD,{data:()=>Nm,finalize:()=>yle,handleEvent:()=>ple,reset:()=>mle});function mle(){lD=[],cD.length=0,uD.length=0,Om.clear(),iD.clear(),sD.clear()}function ple(e){if(b.isFlowPhaseEvent(e)){cD.push(e);return}uD.push(e)}function fle(e){let t=iD.get(e.ts)?.get(e.pid)?.get(e.tid)?.get(e.cat);if(!t)return;let{flows:r,bindingParsed:n}=t;if(!n){for(let a of r)Ne.getWithDefault(sD,a,()=>new Map).set(e.ts,e);t.bindingParsed=!0}}function hle(e){let t=gle(e);switch(e.ph){case b.Phase.FLOW_START:{let r={flowId:e.id,times:new Map([[e.ts,void 0]])};Om.set(t,e.id),oD(e,r.flowId);return}case b.Phase.FLOW_STEP:{let r=Om.get(t);if(r===void 0)return;oD(e,r);return}case b.Phase.FLOW_END:{let r=Om.get(t);if(r===void 0)return;oD(e,r),Om.delete(t)}}}function oD(e,t){let r=Ne.getWithDefault(iD,e.ts,()=>new Map),n=Ne.getWithDefault(r,e.pid,()=>new Map),a=Ne.getWithDefault(n,e.tid,()=>new Map);Ne.getWithDefault(a,e.cat,()=>({flows:new Set,bindingParsed:!1})).flows.add(t)}function gle(e){return`${e.cat}${u4}${e.
name}${u4}${e.id}`}async function yle(){cD.forEach(hle),uD.forEach(fle),lD=[...sD.values()].map(e=>[...e.values()]).map(e=>e.filter(t=>t!==void 0)).filter(e=>e.length>1)}function Nm(){return{flows:lD}}var Om,iD,sD,cD,uD,lD,u4,R1=g(()=>{d();rr();Le();Om=new Map,iD=new Map,sD=new Map,cD=[],uD=[],lD=[],u4="-$-";i(mle,"reset");i(ple,"handleEvent");i(fle,"processNonFlowEvent");i(hle,"processFlowEvent");i(oD,"addFlowIdToEventBinding");i(gle,"flowGroupTokenForFlowPhaseEvent");i(yle,"finalize");i(Nm,"data")});var yD={};C(yD,{data:()=>Lm,finalize:()=>Ele,handleEvent:()=>ble,reset:()=>vle});function vle(){mD.clear(),pD.clear(),fD.clear(),hD.clear(),gD.clear()}function ble(e){if(b.isAuctionWorkletRunningInProcess(e)){mD.set(e.args.data.pid,e);return}if(b.isAuctionWorkletDoneWithProcess(e)){pD.set(e.args.data.pid,e);return}if(b.isThreadName(e)){if(e.args.name==="auction_worklet.CrUtilityMain"){hD.set(e.pid,e);return}e.args.name==="AuctionV8HelperThread"&&gD.set(e.pid,e)}}function wle(e){switch(e){case"seller":return b.AuctionWorkletType.SELLER;case"bidder":return b.AuctionWorkletType.BIDDER;default:return b.AuctionWorkletType.UNKNOWN}}function l4(e){return kr.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:e,name:"SyntheticAuctionWorklet",s:b.Scope.THREAD,cat:e.cat,tid:e.tid,ts:e.ts,ph:b.Phase.INSTANT,pid:e.args.data.pid,host:e.args.data.host,target:e.args.data.target,type:wle(e.args.data.type)})}async function Ele(){for(let[e,t]of hD){let r=gD.get(e);if(!r)continue;let n=mD.get(e),
a=pD.get(e),o=null;n?(o={...l4(n),args:{data:{runningInProcessEvent:n,utilityThread:t,v8HelperThread:r}}},a&&(o.args.data.doneWithProcessEvent=a)):a&&(o={...l4(a),args:{data:{doneWithProcessEvent:a,utilityThread:t,v8HelperThread:r}}},n&&(o.args.data.runningInProcessEvent=n)),o!==null&&fD.set(e,o)}}function Lm(){return{worklets:new Map(fD)}}var mD,pD,fD,hD,gD,_1=g(()=>{d();ot();Le();mD=new Map,pD=new Map,fD=new Map,hD=new Map,gD=new Map;i(vle,"reset");i(ble,"handleEvent");i(wle,"workletType");i(l4,"makeSyntheticEventBase");i(Ele,"finalize");i(Lm,"data")});var SD={};C(SD,{data:()=>Yt,finalize:()=>Cle,handleEvent:()=>Sle,reset:()=>xle});function xle(){Zu.clear(),Xu.clear(),Um.clear(),TD.clear(),qm.length=0,wD=b.ProcessID(-1),ED=b.ThreadID(-1),DD=b.ProcessID(-1),A1=b.ThreadID(-1),F1=null,M1.clear(),xD.clear(),jm.clear(),bD.clear(),Fn.min=O.Micro(Number.POSITIVE_INFINITY),Fn.max=O.Micro(Number.NEGATIVE_INFINITY),Fn.range=O.Micro(Number.POSITIVE_INFINITY),O1=O.Micro(-1),N1=!0}function vD(e,t){Ne.getWithDefault(bD,t.processId,()=>new Map).set(t.frame,t);let n=Ne.getWithDefault(jm,t.frame,()=>new Map),a=Ne.getWithDefault(n,t.processId,()=>[]),o=a.at(-1);o&&o.frame.url===t.url||a.push({frame:t,window:{min:e.ts,max:O.Micro(0),range:O.Micro(0)}})}function Sle(e){if(N1&&Tle.has(e.name)&&(N1=!1),b.isProcessName(e)&&TD.set(e.pid,e),e.ts!==0&&!e.name.endsWith("::UMA")&&Dle.has(e.ph)){Fn.min=O.Micro(Math.min(e.ts,Fn.min));let t=e.dur??O.Micro(0);Fn.max=O.Micro(Math.max(e.ts+t,Fn.max))}if(b.isProcessName(e)&&(e.args.name==="Browser"||e.args.name==="Hea\
dlessBrowser")){wD=e.pid;return}if(b.isProcessName(e)&&(e.args.name==="Gpu"||e.args.name==="GPU Process")){DD=e.pid;return}if(b.isThreadName(e)&&e.args.name==="CrGpuMain"){A1=e.tid;return}if(b.isThreadName(e)&&e.args.name==="CrBrowserMain"&&(ED=e.tid),b.isMainFrameViewport(e)&&F1===null){let t=e.args.data.viewport_rect,r=t[0],n=t[1],a=t[2],o=t[5];F1={x:r,y:n,width:a,height:o},d4=e.args.data.dpr}if(b.isTracingStartedInBrowser(e)){if(O1=e.ts,!e.args.data)throw new Error("No frames found in trace data");for(let t of e.args.data.frames??[]){vD(e,t),t.parent||M1.add(t.processId);let r="isInPrimaryMainFrame"in t,n="isOutermostMainFrame"in t;r&&n?t.isInPrimaryMainFrame&&t.isOutermostMainFrame&&(Pm=t.frame,Bm=t.url):n?t.isOutermostMainFrame&&(Pm=t.frame,Bm=t.url):!t.parent&&t.url&&(Pm=t.frame,Bm=t.url)}return}if(b.isFrameCommittedInBrowser(e)){let t=e.args.data;if(!t||(vD(e,t),t.parent))return;M1.add(t.processId);return}if(b.isCommitLoad(e)){let t=e.args.data;if(!t)return;let{frame:r,name:n,url:a}=t;
vD(e,{processId:e.pid,frame:r,name:n,url:a});return}if(b.isThreadName(e)){Ne.getWithDefault(xD,e.pid,()=>new Map).set(e.tid,e);return}if(b.isNavigationStart(e)&&e.args.data){let t=e.args.data.navigationId;if(Xu.has(t))return;Xu.set(t,e),Um.set(t,e.args.data.documentLoaderURL);let r=e.args.frame,n=Zu.get(r)||[];n.push(e),Zu.set(r,n),r===Pm&&qm.push(e);return}if(b.isResourceSendRequest(e)){if(e.args.data.resourceType!=="Document")return;let t=e.args.data.requestId;if(!Xu.get(t))return;Um.set(t,e.args.data.url);return}if(b.isDidCommitSameDocumentNavigation(e)){if(e.args.render_frame_host.frame_type!=="PRIMARY_MAIN_FRAME")return;let r=qm.at(-1)?.args.data?.navigationId??"";Um.set(r,e.args.url);return}}async function Cle(){O1>=0&&(Fn.min=O1),Fn.range=O.Micro(Fn.max-Fn.min);for(let[,r]of jm){let n=[...r.values()].flat().sort((a,o)=>a.window.min-o.window.min);for(let a=0;a<n.length;a++){let o=n[a],s=n[a+1];s?(o.window.max=O.Micro(s.window.min-1),o.window.range=O.Micro(o.window.max-o.window.min)):
(o.window.max=O.Micro(Fn.max),o.window.range=O.Micro(Fn.max-o.window.min))}}for(let[r,n]of Zu)if(!jm.has(r)){Zu.delete(r);for(let a of n)a.args.data&&Xu.delete(a.args.data.navigationId)}let e=qm.at(0),t=ae.secondsToMicro(O.Seconds(.5));if(e){let r=e.ts-Fn.min<t;e.args.data?.isOutermostMainFrame&&e.args.data?.documentLoaderURL&&r&&(Bm=e.args.data.documentLoaderURL)}}function Yt(){return{traceBounds:{...Fn},browserProcessId:wD,browserThreadId:ED,processNames:TD,gpuProcessId:DD,gpuThreadId:A1===b.ThreadID(-1)?void 0:A1,viewportRect:F1||void 0,devicePixelRatio:d4??void 0,mainFrameId:Pm,mainFrameURL:Bm,navigationsByFrameId:Zu,navigationsByNavigationId:Xu,finalDisplayUrlByNavigationId:Um,threadsInProcess:xD,rendererProcessesByFrame:jm,topLevelRendererIds:M1,frameByProcessId:bD,mainFrameNavigations:qm,traceIsGeneric:N1}}var jm,Pm,Bm,bD,wD,ED,DD,A1,F1,d4,TD,M1,Fn,Zu,Xu,Um,qm,xD,O1,Dle,N1,Tle,ua=g(()=>{d();rr();ot();Le();jm=new Map,Pm="",Bm="",bD=new Map,wD=b.ProcessID(-1),ED=b.ThreadID(-1),DD=
b.ProcessID(-1),A1=b.ThreadID(-1),F1=null,d4=null,TD=new Map,M1=new Set,Fn={min:O.Micro(Number.POSITIVE_INFINITY),max:O.Micro(Number.NEGATIVE_INFINITY),range:O.Micro(Number.POSITIVE_INFINITY)},Zu=new Map,Xu=new Map,Um=new Map,qm=[],xD=new Map,O1=O.Micro(-1),Dle=new Set([b.Phase.BEGIN,b.Phase.END,b.Phase.COMPLETE,b.Phase.INSTANT]),N1=!0,Tle=new Set([b.Name.TRACING_STARTED_IN_PAGE,b.Name.TRACING_SESSION_ID_FOR_WORKER,b.Name.TRACING_STARTED_IN_BROWSER,b.Name.CPU_PROFILE]);i(xle,"reset");i(vD,"updateRendererProcessByFrame");i(Sle,"handleEvent");i(Cle,"finalize");i(Yt,"data")});var RD={};C(RD,{data:()=>kc,deps:()=>Ale,finalize:()=>_le,handleEvent:()=>Rle,reset:()=>kle});function Cc(e,t,r){zm.has(e)||zm.set(e,{});let n=zm.get(e);if(!n)throw new Error(`Unable to locate trace events for request ID ${e}`);if(Array.isArray(n[t])){let a=n[t],o=r;a.push(...o)}else n[t]=r}function Ile(e){for(let t of e)if(t&&t>0)return t;return 0}function kle(){ID.clear(),zm.clear(),B1.length=0,P1.clear(),kD.clear(),Ic.clear(),oi.eventsByEntity.clear(),oi.entityByEvent.clear(),oi.createdEntityCache.clear(),oi.entityByUrlCache.clear(),CD.length=0}function Rle(e){if(b.isResourceChangePriority(e)){Cc(e.args.data.requestId,"changePriority",e);return}if(b.isResourceWillSendRequest(e)){Cc(e.args.data.requestId,"willSendRequests",[e]);return}if(b.isResourceSendRequest(e)){Cc(e.args.data.requestId,"sendRequests",[e]);return}if(b.isResourceReceiveResponse(e)){Cc(e.args.data.requestId,"receiveResponse",e);return}if(b.isResourceReceivedData(e)){Cc(e.args.data.requestId,"receivedData",[e]);return}
if(b.isResourceFinish(e)){Cc(e.args.data.requestId,"resourceFinish",e);return}if(b.isResourceMarkAsCached(e)){Cc(e.args.data.requestId,"resourceMarkAsCached",e);return}if(b.isWebSocketCreate(e)||b.isWebSocketInfo(e)||b.isWebSocketTransfer(e)){let t=e.args.data.identifier;Ic.has(t)||(e.args.data.frame?Ic.set(t,{frame:e.args.data.frame,webSocketIdentifier:t,events:[],syntheticConnection:null}):e.args.data.workerId&&Ic.set(t,{workerId:e.args.data.workerId,webSocketIdentifier:t,events:[],syntheticConnection:null})),Ic.get(t)?.events.push(e)}if(b.isLinkPreconnect(e)){CD.push(e);return}}async function _le(){let{rendererProcessesByFrame:e}=Yt();for(let[t,r]of zm.entries()){if(!r.sendRequests)continue;let n=[];for(let Ae=0;Ae<r.sendRequests.length-1;Ae++){let Fe=r.sendRequests[Ae],Qe=r.sendRequests[Ae+1],ye=Fe.ts,pe=O.Micro(Qe.ts-Fe.ts);if(r.willSendRequests?.[Ae]&&r.willSendRequests[Ae+1]){let Nt=r.willSendRequests[Ae],ze=r.willSendRequests[Ae+1];ye=Nt.ts,pe=O.Micro(ze.ts-Nt.ts)}n.push({url:Fe.
args.data.url,priority:Fe.args.data.priority,requestMethod:Fe.args.data.requestMethod,ts:ye,dur:pe})}let a=r.sendRequests[0],o=r.sendRequests[r.sendRequests.length-1];if(o.args.data.url.startsWith("data:"))continue;let s=globalThis.isLightrider;if(s&&r.resourceFinish&&r.receiveResponse?.args.data.headers){let Ae=r.receiveResponse.args.data.headers.find(Fe=>Fe.name==="X-TotalFetchedSize");if(Ae){let Fe=parseFloat(Ae.value);isNaN(Fe)||(r.resourceFinish.args.data.encodedDataLength=Fe)}}let c=r.resourceFinish?.args.data.encodedDataLength!==0,u=!!r.receiveResponse&&r.receiveResponse.args.data.fromCache&&!r.receiveResponse.args.data.fromServiceWorker&&!c,l=r.resourceMarkAsCached!==void 0,m=l?void 0:r.receiveResponse?.args.data.timing;if(s&&r.receiveResponse?.args.data.headers){m={requestTime:ae.microToSeconds(r.sendRequests.at(0)?.ts??0),connectEnd:0,connectStart:0,dnsEnd:0,dnsStart:0,proxyEnd:0,proxyStart:0,pushEnd:0,pushStart:0,receiveHeadersEnd:0,receiveHeadersStart:0,sendEnd:0,sendStart:0,
sslEnd:0,sslStart:0,workerReady:0,workerStart:0,...m};let Ae=r.receiveResponse.args.data.headers.find(Qe=>Qe.name==="X-TCPMs"),Fe=Ae?Math.max(0,parseInt(Ae.value,10)):0;r.receiveResponse.args.data.protocol.startsWith("h3")?(m.connectStart=0,m.connectEnd=Fe):(m.connectStart=0,m.sslStart=Fe/2,m.connectEnd=Fe,m.sslEnd=Fe)}if(!["blob:","file:","filesystem:","http:","https:"].some(Ae=>a.args.data.url.startsWith(Ae)))continue;let f=o.args.data.priority,h=f;r.changePriority&&(h=r.changePriority.args.data.priority);let y=r.willSendRequests?.length?O.Micro(r.willSendRequests[0].ts):O.Micro(a.ts),v=r.willSendRequests?.length?O.Micro(r.willSendRequests[r.willSendRequests.length-1].ts):O.Micro(o.ts),E=r.resourceFinish?r.resourceFinish.ts:v,T=r.resourceFinish?.args.data.finishTime?O.Micro(r.resourceFinish.args.data.finishTime*L1):O.Micro(E),x=O.Micro(m?(T||v)-v:0),S=O.Micro(E-(T||E)),I=O.Micro(v-y),F=m?m.requestTime*L1-v:0,W=O.Micro(vo.clamp(F,0,Number.MAX_VALUE)),H=m?O.Micro(Ile([m.dnsStart*Ga,m.connectStart*
Ga,m.sendStart*Ga,r.receiveResponse?r.receiveResponse.ts-v:null])):r.receiveResponse?O.Micro(r.receiveResponse.ts-y):O.Micro(0),se=m?O.Micro(m.requestTime*L1+m.sendStart*Ga):y,me=m?O.Micro((m.receiveHeadersEnd-m.sendEnd)*Ga):O.Micro(0),Ee=m?O.Micro(m.requestTime*L1+m.receiveHeadersEnd*Ga):y,Pe=m?O.Micro((T||Ee)-Ee):r.receiveResponse?O.Micro(E-r.receiveResponse.ts):O.Micro(0),De=O.Micro(x+S),we=m?O.Micro((m.dnsEnd-m.dnsStart)*Ga):O.Micro(0),xt=m?O.Micro((m.sslEnd-m.sslStart)*Ga):O.Micro(0),Oe=m?O.Micro((m.proxyEnd-m.proxyStart)*Ga):O.Micro(0),He=m?O.Micro((m.sendEnd-m.sendStart)*Ga):O.Micro(0),qt=m?O.Micro((m.connectEnd-m.connectStart)*Ga):O.Micro(0),{frame:yt,url:Ze,renderBlocking:Qt}=o.args.data,{encodedDataLength:St,decodedBodyLength:vt}=r.resourceFinish?r.resourceFinish.args.data:{encodedDataLength:0,decodedBodyLength:0},Q=new URL(Ze).protocol==="https:",xe=Me.activeURLForFrameAtTime(yt,o.ts,e)||"",Je=kr.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:o,args:{data:{syntheticData:{
dnsLookup:we,download:Pe,downloadStart:Ee,finishTime:T,initialConnection:qt,isDiskCached:u,isHttps:Q,isMemoryCached:l,isPushedResource:c,networkDuration:x,processingDuration:S,proxyNegotiation:Oe,queueing:W,redirectionDuration:I,requestSent:He,sendStartTime:se,ssl:xt,stalled:H,totalTime:De,waiting:me},decodedBodyLength:vt,encodedDataLength:St,frame:yt,fromServiceWorker:r.receiveResponse?.args.data.fromServiceWorker,isLinkPreload:o.args.data.isLinkPreload||!1,mimeType:r.receiveResponse?.args.data.mimeType??"",priority:h,initialPriority:f,protocol:r.receiveResponse?.args.data.protocol??"unknown",redirects:n,renderBlocking:Qt??"non_blocking",requestId:t,requestingFrameUrl:xe,requestMethod:o.args.data.requestMethod,resourceType:o.args.data.resourceType??"Other",statusCode:r.receiveResponse?.args.data.statusCode??0,responseHeaders:r.receiveResponse?.args.data.headers??null,fetchPriorityHint:o.args.data.fetchPriorityHint??"auto",initiator:o.args.data.initiator,stackTrace:o.args.data.stackTrace,
timing:m,url:Ze,failed:r.resourceFinish?.args.data.didFail??!1,finished:!!r.resourceFinish,hasResponse:!!r.receiveResponse,connectionId:r.receiveResponse?.args.data.connectionId,connectionReused:r.receiveResponse?.args.data.connectionReused}},cat:"loading",name:b.Name.SYNTHETIC_NETWORK_REQUEST,ph:b.Phase.COMPLETE,dur:O.Micro(E-y),tdur:O.Micro(E-y),ts:O.Micro(y),tts:O.Micro(y),pid:o.pid,tid:o.tid});B1.push(Je),ID.set(Je.args.data.requestId,Je),FE(Je,oi,r);let _t=Je.args.data.initiator?.url||Me.getZeroIndexedStackTraceInEventPayload(Je)?.at(0)?.url;if(_t){let Ae=P1.get(_t)??[];Ae.push(Je),P1.set(_t,Ae)}}for(let t of B1){let r=P1.get(t.args.data.url);if(r)for(let n of r)kD.set(n,t)}Fle()}function kc(){return{byId:ID,byTime:B1,eventToInitiator:kD,webSocket:[...Ic.values()],entityMappings:{entityByEvent:new Map(oi.entityByEvent),eventsByEntity:new Map(oi.eventsByEntity),createdEntityCache:new Map(oi.createdEntityCache),entityByUrlCache:new Map(oi.entityByUrlCache)},linkPreconnectEvents:CD}}
function Ale(){return["Meta"]}function Fle(){Ic.forEach(e=>{let t=null,r=null;for(let n of e.events)b.isWebSocketCreate(n)&&(t=n),b.isWebSocketDestroy(n)&&(r=n);e.syntheticConnection=Mle(t,r,e.events[0])})}function Mle(e,t,r){let{traceBounds:n}=Yt(),a=e?e.ts:n.min,s=(t?t.ts:n.max)-a,c=e||t||r;return{name:"SyntheticWebSocketConnection",cat:c.cat,ph:b.Phase.COMPLETE,ts:a,dur:s,pid:c.pid,tid:c.tid,s:c.s,rawSourceEvent:c,_tag:"SyntheticEntryTag",args:{data:{identifier:c.args.data.identifier,priority:"Low",url:c.args.data.url||""}}}}var Ga,L1,Ic,CD,zm,ID,B1,P1,kD,oi,Hm=g(()=>{d();rr();ot();Le();D1();ua();Ga=1e3,L1=1e6,Ic=new Map,CD=[],zm=new Map,ID=new Map,B1=[],P1=new Map,kD=new Map,oi={eventsByEntity:new Map,entityByEvent:new Map,createdEntityCache:new Map,entityByUrlCache:new Map};i(Cc,"storeTraceEventWithRequestId");i(Ile,"firstPositiveValueInList");i(kle,"reset");i(Rle,"handleEvent");i(_le,"finalize");i(kc,"data");i(Ale,"deps");i(Fle,"finalizeWebSocketData");i(Mle,"createSyntheticWebSo\
cketConnection")});var U1,j1,_D=g(()=>{d();U1=class{static{i(this,"ProfileNode")}callFrame;callUID;self;total;id;parent;children;functionName;depth;deoptReason;constructor(t){this.callFrame=t,this.callUID=`${t.functionName}@${t.scriptId}:${t.lineNumber}:${t.columnNumber}`,this.self=0,this.total=0,this.id=0,this.functionName=t.functionName,this.parent=null,this.children=[]}get scriptId(){return String(this.callFrame.scriptId)}get url(){return this.callFrame.url}get lineNumber(){return this.callFrame.lineNumber}get columnNumber(){return this.callFrame.columnNumber}setFunctionName(t){t!==null&&(this.functionName=t)}},j1=class{static{i(this,"ProfileTreeModel")}root;total;maxDepth;initialize(t){this.root=t,this.assignDepthsAndParents(),this.total=this.calculateTotals(this.root)}assignDepthsAndParents(){let t=this.root;t.depth=-1,t.parent=null,this.maxDepth=0;let r=[t];for(;r.length;){let n=r.pop(),a=n.depth+1;a>this.maxDepth&&(this.maxDepth=a);let o=n.children;for(let s of o)s.depth=a,s.parent=n,r.push(s)}}calculateTotals(t){
let r=[t],n=[];for(;r.length;){let a=r.pop();a.total=a.self,n.push(a),r.push(...a.children)}for(;n.length>1;){let a=n.pop();a.parent&&(a.parent.total+=a.total)}return t.total}}});var q1={};C(q1,{CPUProfileDataModel:()=>AD,CPUProfileNode:()=>Gm});var Gm,AD,m4=g(()=>{d();rr();_D();Gm=class extends U1{static{i(this,"CPUProfileNode")}id;self;positionTicks;deoptReason;constructor(t,r){let n=t.callFrame||{functionName:t.functionName,scriptId:t.scriptId,url:t.url,lineNumber:t.lineNumber-1,columnNumber:t.columnNumber-1};super(n),this.id=t.id,this.self=(t.hitCount||0)*r,this.positionTicks=t.positionTicks,this.deoptReason=t.deoptReason&&t.deoptReason!=="no reason"?t.deoptReason:null}},AD=class extends j1{static{i(this,"CPUProfileDataModel")}profileStartTime;profileEndTime;timestamps;samples;traceIds;lines;totalHitCount;profileHead;#e;gcNode;programNode;idleNode;#t;#o;constructor(t){super(),!!t.head?(this.profileStartTime=t.startTime*1e3,this.profileEndTime=t.endTime*1e3,this.timestamps=t.timestamps,this.compatibilityConversionHeadToNodes(t)):(this.profileStartTime=t.startTime/1e3,this.profileEndTime=t.endTime/1e3,this.timestamps=this.convertTimeDeltas(t)),this.traceIds=t.
traceIds,this.samples=t.samples,this.lines=t.lines,this.totalHitCount=0,this.profileHead=this.translateProfileTree(t.nodes),this.initialize(this.profileHead),this.extractMetaNodes(),this.samples?.length&&(this.sortSamples(),this.normalizeTimestamps(),this.fixMissingSamples())}compatibilityConversionHeadToNodes(t){if(!t.head||t.nodes)return;let r=[];n(t.head),t.nodes=r,delete t.head;function n(a){return r.push(a),a.children=a.children.map(n),a.id}i(n,"convertNodesTree")}convertTimeDeltas(t){if(!t.timeDeltas)return[];let r=t.startTime,n=new Array(t.timeDeltas.length);for(let a=0;a<t.timeDeltas.length;++a)r+=t.timeDeltas[a],n[a]=r;return n}translateProfileTree(t){function r(p){if(!p[0].children){p[0].children=[];for(let f=1;f<p.length;++f){let h=p[f],y=a.get(h.parent);y&&(y.children?y.children.push(h.id):y.children=[h.id])}}}i(r,"buildChildrenFromParents");function n(p,f){if(typeof p[0].hitCount!="number"){if(!f)throw new Error("Error: Neither hitCount nor samples are present in profile.");
for(let h=0;h<p.length;++h)p[h].hitCount=0;for(let h=0;h<f.length;++h){let y=a.get(f[h]);y?.hitCount!==void 0&&y.hitCount++}}}i(n,"buildHitCountFromSamples");let a=new Map;for(let p=0;p<t.length;++p){let f=t[p];a.set(f.id,f)}n(t,this.samples),r(t),this.totalHitCount=t.reduce((p,f)=>p+(f.hitCount||0),0);let o=(this.profileEndTime-this.profileStartTime)/this.totalHitCount,s=t[0],c=new Map([[s.id,s.id]]);this.#e=new Map;let u=new Gm(s,o);if(this.#e.set(s.id,u),!s.children)throw new Error("Missing children for root");let l=s.children.map(()=>u),m=s.children.map(p=>a.get(p));for(;m.length;){let p=l.pop(),f=m.pop();if(!f||!p)continue;f.children||(f.children=[]);let h=new Gm(f,o);p.children.push(h),p=h,c.set(f.id,p.id),l.push.apply(l,f.children.map(()=>p)),m.push.apply(m,f.children.map(y=>a.get(y))),this.#e.set(f.id,h)}return this.samples&&(this.samples=this.samples.map(p=>c.get(p))),u}sortSamples(){if(!this.timestamps||!this.samples)return;let t=this.timestamps,r=this.samples,n=t.map((a,o)=>o);
n.sort((a,o)=>t[a]-t[o]),this.timestamps=[],this.samples=[];for(let a=0;a<n.length;a++){let o=n[a];this.timestamps.push(t[o]),this.samples.push(r[o])}}normalizeTimestamps(){if(!this.samples)return;let t=this.timestamps;if(!t){let r=this.profileStartTime,n=(this.profileEndTime-r)/this.samples.length;t=new Array(this.samples.length+1);for(let a=0;a<t.length;++a)t[a]=r+a*n;this.timestamps=t;return}for(let r=0;r<t.length;++r)t[r]/=1e3;if(this.samples.length===t.length){let r=t.at(-1)||0,n=(r-t[0])/(t.length-1);this.timestamps.push(r+n)}this.profileStartTime=t.at(0)||this.profileStartTime,this.profileEndTime=t.at(-1)||this.profileEndTime}extractMetaNodes(){let t=this.profileHead.children;for(let r=0;r<t.length&&!(this.gcNode&&this.programNode&&this.idleNode);r++){let n=t[r];n.functionName==="(garbage collector)"?this.gcNode=n:n.functionName==="(program)"?this.programNode=n:n.functionName==="(idle)"&&(this.idleNode=n)}}fixMissingSamples(){let t=this.samples;if(!t)return;let r=t.length;if(!this.
programNode||r<3)return;let n=this.#e,a=this.programNode.id,o=this.gcNode?this.gcNode.id:-1,s=this.idleNode?this.idleNode.id:-1,c=t[0],u=t[1];for(let p=1;p<r-1;p++){let f=t[p+1],h=n.get(c),y=n.get(f);if(c===void 0||f===void 0||!h||!y){console.error(`Unexpectedly found undefined nodes: ${c} ${f}`);continue}u===a&&!m(c)&&!m(f)&&l(h)===l(y)&&(t[p]=c),c=u,u=f}function l(p){for(;p.parent?.parent;)p=p.parent;return p}i(l,"bottomNode");function m(p){return p===a||p===o||p===s}i(m,"isSystemNode")}forEachFrame(t,r,n,a){if(!this.profileHead||!this.samples)return;n=n||0,a=a||1/0;let o=this.samples,s=this.timestamps,c=this.#e,u=this.gcNode,l=o.length,m=Hr.lowerBound(s,n,Hr.DEFAULT_COMPARATOR),p=0,f=[],h=this.profileHead.id,y,v=null,E=this.maxDepth+3;this.#t||(this.#t=new Array(E));let T=this.#t;this.#o||(this.#o=new Array(E));let x=this.#o,S,I;for(I=m;I<l&&(y=s[I],!(y>=a));I++){let F=o[I];if(F===h)continue;S=c.get(F);let W=c.get(h)||null;if(W){if(u&&S===u){v=W,t(v.depth+1,u,I,y),T[++p]=y,x[p]=0,h=
F;continue}if(u&&W===u&&v){let H=T[p],se=y-H;x[p-1]+=se,r(v.depth+1,u,I,H,se,se-x[p]),--p,W=v,h=W.id,v=null}for(;S&&S.depth>W.depth;)f.push(S),S=S.parent;for(;W&&W!==S;){let H=T[p],se=y-H;x[p-1]+=se,r(W.depth,W,I,H,se,se-x[p]),--p,S&&S.depth===W.depth&&(f.push(S),S=S.parent),W=W.parent}for(;f.length;){let H=f.pop();if(!H)break;S=H,t(H.depth,H,I,y),T[++p]=y,x[p]=0}h=F}}if(y=s[I]||this.profileEndTime,S&&v&&c.get(h)===u){let F=T[p],W=y-F;x[p-1]+=W,r(v.depth+1,S,I,F,W,W-x[p]),--p,h=v.id}for(let F=c.get(h);F?.parent;F=F.parent){let W=T[p],H=y-W;x[p-1]+=H,r(F.depth,F,I,W,H,H-x[p]),--p}}nodeByIndex(t){return this.samples&&this.#e.get(this.samples[t])||null}nodeById(t){return this.#e.get(t)||null}nodes(){return this.#e?[...this.#e.values()]:null}}});var p4=g(()=>{d();m4();_D()});var LD={};C(LD,{data:()=>ND,finalize:()=>jle,getProfileCallFunctionName:()=>qle,handleEvent:()=>Ule,reset:()=>Ble});function Ple(e){for(let[t,r]of OD)for(let[n,a]of r){let p=function(){c.forEachFrame(f,h);function f(y,v,E,T){if(o===void 0)return;let x=ae.milliToMicro(O.Milli(T)),S=v.id,I=Me.makeProfileCall(v,n,E,x,t,o);l.profileCalls.push(I),s.push(l.profileCalls.length-1);let F=ai.makeEmptyTraceEntryNode(I,S);Wm.set(I,F),F.depth=y,s.length===1&&l.profileTree?.roots.add(F)}i(f,"openFrameCallback");function h(y,v,E,T,x,S){let I=s.pop(),F=I!==void 0&&l.profileCalls[I];if(!F)return;let{callFrame:W,ts:H,pid:se,tid:me}=F,Ee=Wm.get(F);if(W===void 0||H===void 0||se===void 0||n===void 0||me===void 0||Ee===void 0)return;let Pe=ae.milliToMicro(O.Milli(x)),De=ae.milliToMicro(O.Milli(S));F.dur=Pe,Ee.selfTime=De;let we=s.at(-1),xt=we!==void 0&&l.profileCalls.at(we),Oe=xt&&Wm.get(xt);Oe&&(Ee.parent=Oe,Oe.children.push(Ee))}i(h,"closeFrameCallback")};i(p,"buildProfileCallsForCPUProfile");let o=a.threadId;
if(!a.rawProfile.nodes.length||o===void 0)continue;let s=[],c=new q1.CPUProfileDataModel(a.rawProfile),u=ai.makeEmptyTraceEntryTree();u.maxDepth=c.maxDepth;let l={rawProfile:a.rawProfile,parsedProfile:c,profileCalls:[],profileTree:u,profileId:n};Ne.getWithDefault(MD,t,()=>new Map).set(o,l),e.isCPUProfile&&p()}}function Ble(){Lle.clear(),OD.clear(),MD.clear(),Wm.clear()}function Ule(e){if(b.isSyntheticCpuProfile(e)){let t=FD(e.pid,e.id);t.rawProfile=e.args.data.cpuProfile,t.threadId=e.tid;return}if(b.isProfile(e)){let t=FD(e.pid,e.id);t.rawProfile.startTime=e.ts,t.threadId=e.tid;return}if(b.isProfileChunk(e)){let r=FD(e.pid,e.id).rawProfile,n=e.args?.data?.cpuProfile||{samples:[]},a=n?.samples||[],o=e.args?.data?.cpuProfile?.trace_ids;for(let u of n?.nodes||[]){let l=typeof u.callFrame.lineNumber>"u"?-1:u.callFrame.lineNumber,m=typeof u.callFrame.columnNumber>"u"?-1:u.callFrame.columnNumber,p=String(u.callFrame.scriptId),f=u.callFrame.url||"",h={...u,callFrame:{...u.callFrame,url:f,lineNumber:l,
columnNumber:m,scriptId:p}};r.nodes.push(h)}let s=e.args.data?.timeDeltas||[],c=e.args.data?.lines||Array(a.length).fill(0);if(r.samples?.push(...a),r.timeDeltas?.push(...s),r.lines?.push(...c),o){r.traceIds??={};for(let u in o)r.traceIds[u]=o[u]}if(r.samples&&r.timeDeltas&&r.samples.length!==r.timeDeltas.length){console.error("Failed to parse CPU profile.");return}if(!r.endTime&&r.timeDeltas){let u=r.timeDeltas;r.endTime=u.reduce((l,m)=>l+m,r.startTime)}return}}async function jle(e={}){Ple(e)}function ND(){return{profilesInProcess:MD,entryToNode:Wm}}function FD(e,t){let r=Ne.getWithDefault(OD,e,()=>new Map);return Ne.getWithDefault(r,t,()=>({rawProfile:{startTime:0,endTime:0,nodes:[],samples:[],timeDeltas:[],lines:[]},profileId:t}))}function qle(e,t){let n=e.profilesInProcess.get(t.pid)?.get(t.tid)?.parsedProfile.nodeById(t.nodeId);return n?.functionName?n.functionName:t.callFrame.functionName}var Lle,MD,Wm,OD,PD=g(()=>{d();rr();p4();ot();Le();Lle=new Map,MD=new Map,Wm=new Map,OD=new Map;
i(Ple,"parseCPUProfileData");i(Ble,"reset");i(Ule,"handleEvent");i(jle,"finalize");i(ND,"data");i(FD,"getOrCreatePreProcessedData");i(qle,"getProfileCallFunctionName")});var qD={};C(qD,{assignIsMainFrame:()=>y4,assignMeta:()=>h4,assignOrigin:()=>g4,assignThreadName:()=>v4,buildHierarchy:()=>E4,data:()=>$m,deps:()=>Kle,finalize:()=>$le,handleEvent:()=>Vle,handleUserConfig:()=>Gle,makeCompleteEvent:()=>D4,reset:()=>Wle,sanitizeProcesses:()=>b4,sanitizeThreads:()=>w4});function Gle(e){f4=e}function Wle(){bo.clear(),jD.clear(),wo.eventsByEntity.clear(),wo.entityByEvent.clear(),wo.createdEntityCache.clear(),wo.entityByUrlCache.clear(),BD.length=0,UD.length=0}function Vle(e){if(b.isThreadName(e)&&e.args.name?.startsWith("CompositorTileWorker")&&UD.push({pid:e.pid,tid:e.tid}),b.isBegin(e)||b.isEnd(e)){let t=Qu(bo,e.pid),r=Vm(t,e.tid),n=D4(e);if(!n)return;r.entries.push(n);return}if(b.isInstant(e)||b.isComplete(e)){let t=Qu(bo,e.pid);Vm(t,e.tid).entries.push(e)}if(b.isLayout(e)){let t=Qu(bo,e.pid);Vm(t,e.tid).layoutEvents.push(e)}if(b.isUpdateLayoutTree(e)){let t=Qu(bo,e.pid);Vm(t,e.tid).updateLayoutTreeEvents.push(e)}}async function $le(){let{mainFrameId:e,rendererProcessesByFrame:t,
threadsInProcess:r}=Yt();wo=kc().entityMappings,h4(bo,e,t,r),b4(bo),E4(bo),w4(bo)}function $m(){return{processes:bo,compositorTileWorkers:Yle(),entryToNode:jD,entityMappings:{entityByEvent:new Map(wo.entityByEvent),eventsByEntity:new Map(wo.eventsByEntity),createdEntityCache:new Map(wo.createdEntityCache),entityByUrlCache:new Map(wo.entityByUrlCache)}}}function Yle(){let e=new Map;for(let t of UD){let r=e.get(t.pid)||[];r.push(t.tid),e.set(t.pid,r)}return e}function h4(e,t,r,n){g4(e,r),y4(e,t,r),v4(e,n)}function g4(e,t){for(let r of t.values())for(let[n,a]of r)for(let o of a.flat()){let s=Qu(e,n);if(s.url===null||s.url==="about:blank")try{new URL(o.frame.url),s.url=o.frame.url}catch{s.url=null}}}function y4(e,t,r){for(let[n,a]of r)for(let[o]of a){let s=Qu(e,o);n===t&&(s.isOnMainFrame=!0)}}function v4(e,t){for(let[r,n]of e)for(let[a,o]of t.get(r)??[]){let s=Vm(n,a);s.name=o?.args.name??`${a}`}}function b4(e){let t=Lm().worklets;if(!Yt().traceIsGeneric){for(let[n,a]of e)if(a.url===null){
let o=t.get(n);o?a.url=o.host:e.delete(n);continue}}}function w4(e){for(let[,t]of e)for(let[r,n]of t.threads)n.tree?.roots.size||t.threads.delete(r)}function E4(e,t){let r=ND();for(let[n,a]of e)for(let[o,s]of a.threads){if(!s.entries.length){s.tree=ai.makeEmptyTraceEntryTree();continue}Me.sortTraceEventsInPlace(s.entries);let c=r.profilesInProcess.get(n)?.get(o);if(c){let l=c.parsedProfile,m=l&&new Mm.SamplesIntegrator(l,c.profileId,n,o,f4),p=m?.buildProfileCalls(s.entries);if(m&&p){s.entries=Me.mergeEventsInOrder(s.entries,p),s.profileCalls=p;let f=m.jsSampleEvents;f.length&&(s.entries=Me.mergeEventsInOrder(s.entries,f))}}let u=ai.treify(s.entries,t);s.tree=u.tree;for(let[l,m]of u.entryToNode)jD.set(l,m),AE(l,wo)}}function D4(e){if(b.isEnd(e)){let r=BD.pop();return r?r.name!==e.name||r.cat!==e.cat?(console.error("Begin/End events mismatch at "+r.ts+" ("+r.name+") vs. "+e.ts+" ("+e.name+")"),null):(r.dur=O.Micro(e.ts-r.ts),null):null}let t={...e,ph:b.Phase.COMPLETE,dur:O.Micro(0)};return BD.
push(t),t}function Kle(){return["Meta","Samples","AuctionWorklets","NetworkRequests"]}var bo,wo,UD,jD,BD,f4,zle,Hle,Qu,Vm,z1=g(()=>{d();rr();ot();Le();_1();D1();ua();Hm();PD();bo=new Map,wo={eventsByEntity:new Map,entityByEvent:new Map,createdEntityCache:new Map,entityByUrlCache:new Map},UD=Array(),jD=new Map,BD=[],f4=yo.defaults(),zle=i(()=>({url:null,isOnMainFrame:!1,threads:new Map}),"makeRendererProcess"),Hle=i(()=>({name:null,entries:[],profileCalls:[],layoutEvents:[],updateLayoutTreeEvents:[]}),"makeRendererThread"),Qu=i((e,t)=>Ne.getWithDefault(e,t,zle),"getOrCreateRendererProcess"),Vm=i((e,t)=>Ne.getWithDefault(e.threads,t,Hle),"getOrCreateRendererThread");i(Gle,"handleUserConfig");i(Wle,"reset");i(Vle,"handleEvent");i($le,"finalize");i($m,"data");i(Yle,"gatherCompositorThreads");i(h4,"assignMeta");i(g4,"assignOrigin");i(y4,"assignIsMainFrame");i(v4,"assignThreadName");i(b4,"sanitizeProcesses");i(w4,"sanitizeThreads");i(E4,"buildHierarchy");i(D4,"makeCompleteEvent");i(Kle,"deps")});var $D={};C($D,{data:()=>VD,deps:()=>rde,finalize:()=>Zle,handleEvent:()=>Xle,reset:()=>Jle});function Jle(){HD.clear(),GD.clear(),zD.clear(),WD.clear()}function Xle(e){}async function Zle(){let{flows:e}=Nm(),{entryToNode:t}=$m();for(let r of e){let n=r.at(0);if(!n||(b.isDebuggerAsyncTaskRun(n)&&(n=zD.get(n)),!n||!b.isDebuggerAsyncTaskScheduled(n)))continue;let a=n.args.taskName,o=r.at(1);if(!o||!b.isDebuggerAsyncTaskRun(o))continue;zD.set(o,n);let s=Qle(n,t),c=ede(o,t);if(WD.set(c||o,{taskName:a,scheduler:s||n}),!s||!c)continue;Ne.getWithDefault(HD,s,()=>[]).push(c);let l=tde(o,t);for(let m of l)GD.set(m,{taskName:a,scheduler:s})}}function Qle(e,t){let r=t.get(e)?.parent;for(;r;){if(b.isProfileCall(r.entry)||T4(r.entry))return r.entry;r=r.parent}return null}function T4(e){let t=b.isConsoleRunTask(e),r=e.name.startsWith("v8")||e.name.startsWith("V8");return b.isJSInvocationEvent(e)&&(t||!r)}function ede(e,t){return x4(e,t,T4,b.isDebuggerAsyncTaskRun).at(0)}function tde(e,t){return x4(e,
t,b.isProfileCall,b.isDebuggerAsyncTaskRun)}function x4(e,t,r,n){let a=t.get(e);if(!a)return[];let o=[[...a.children]],s=[];for(let c=0;c<o.length;c++){let u=o[c];for(let l=0;l<u.length;l++){let m=u[l];r(m.entry)?s.push(m.entry):n(m.entry)||o.push([...m.children])}}return s}function VD(){return{schedulerToRunEntryPoints:HD,asyncCallToScheduler:GD,runEntryPointToScheduler:WD}}function rde(){return["Renderer","Flows"]}var HD,zD,GD,WD,YD=g(()=>{d();rr();Le();R1();z1();HD=new Map,zD=new Map,GD=new Map,WD=new Map;i(Jle,"reset");i(Xle,"handleEvent");i(Zle,"finalize");i(Qle,"findNearestJSAncestor");i(T4,"acceptJSInvocationsPredicate");i(ede,"findFirstJsInvocationForAsyncTaskRun");i(tde,"findFirstJSCallsForAsyncTaskRun");i(x4,"findFirstDescendantsOfType");i(VD,"data");i(rde,"deps")});var JD={};C(JD,{data:()=>ide,finalize:()=>ode,handleEvent:()=>ade,reset:()=>nde});function nde(){KD.clear()}function ade(e){if(!b.isDOMStats(e))return;Ne.getWithDefault(KD,e.args.data.frame,()=>[]).push(e)}async function ode(){}function ide(){return{domStatsByFrameId:KD}}var KD,S4=g(()=>{d();rr();Le();KD=new Map;i(nde,"reset");i(ade,"handleEvent");i(ode,"finalize");i(ide,"data")});var rT={};C(rT,{data:()=>Ym,finalize:()=>mde,handleEvent:()=>dde,reset:()=>sde,userTimingComparator:()=>XD});function sde(){Rc.length=0,QD.length=0,eT.length=0,tT.length=0,el.length=0,ZD.clear()}function C4(e){if("dur"in e)return{start:e.ts,end:O.Micro(e.ts+(e.dur??0))};if(b.isConsoleTimeStamp(e)){let{start:t,end:r}=e.args.data||{};if(typeof t=="number"&&typeof r=="number")return{start:O.Micro(t),end:O.Micro(r)}}return{start:e.ts,end:e.ts}}function I4(e){if(e.cat==="blink.user_timing"){let t=e.args.data.beginEvent.args?.detail;if(t){let r=Me.parseDevtoolsDetails(t,"devtools");if(r&&"track"in r)return r.track}}else if(b.isConsoleTimeStamp(e)){let t=e.args.data?.track;return typeof t=="string"?t:void 0}}function XD(e,t,r){let{start:n,end:a}=C4(e),{start:o,end:s}=C4(t),c=Me.compareBeginAndEnd(n,o,a,s);if(c)return c;let u=I4(e),l=I4(t);if(u!==l)return 0;let m=r.indexOf(e);return r.indexOf(t)-m}function dde(e){if(!lde.includes(e.name)){if(b.isUserTimingMeasure(e)&&ZD.set(e.args.traceId,e),b.
isPerformanceMeasure(e)){QD.push(e);return}b.isPerformanceMark(e)&&eT.push(e),b.isConsoleTime(e)&&tT.push(e),b.isConsoleTimeStamp(e)&&el.push(e)}}async function mde(){let e=[...QD,...tT];Rc=Me.createMatchedSortedSyntheticEvents(e),Rc=Rc.sort((t,r)=>XD(t,r,[...Rc])),el=el.sort((t,r)=>XD(t,r,[...el]))}function Ym(){return{performanceMeasures:Rc.filter(e=>e.cat==="blink.user_timing"),consoleTimings:Rc.filter(e=>e.cat==="blink.console"),performanceMarks:[...eT],timestampEvents:[...el],measureTraceByTraceId:new Map(ZD)}}var Rc,ZD,QD,eT,tT,el,cde,ude,lde,nT=g(()=>{d();ot();Le();Rc=[],ZD=new Map,QD=[],eT=[],tT=[],el=[];i(sde,"reset");cde=["workerStart","redirectStart","redirectEnd","fetchStart","domainLookupStart","domainLookupEnd","connectStart","connectEnd","secureConnectionStart","requestStart","responseStart","responseEnd"],ude=["navigationStart","unloadEventStart","unloadEventEnd","redirectStart","redirectEnd","fetchStart","commitNavigationEnd","domainLookupStart","domainLookupEnd","conn\
ectStart","connectEnd","secureConnectionStart","requestStart","responseStart","responseEnd","domLoading","domInteractive","domContentLoadedEventStart","domContentLoadedEventEnd","domComplete","loadEventStart","loadEventEnd"],lde=[...cde,...ude];i(C4,"getEventTimings");i(I4,"getEventTrack");i(XD,"userTimingComparator");i(dde,"handleEvent");i(mde,"finalize");i(Ym,"data")});var cT={};C(cT,{data:()=>vde,deps:()=>bde,extensionDataInConsoleTimeStamp:()=>A4,extensionDataInPerformanceTiming:()=>_4,extractConsoleAPIExtensionEntries:()=>k4,extractPerformanceAPIExtensionEntries:()=>R4,finalize:()=>hde,handleEvent:()=>pde,reset:()=>fde});function pde(e){}function fde(){Km.length=0,sT.length=0,aT.length=0,oT.length=0,iT.clear(),H1.clear()}async function hde(){gde()}function gde(){let e=Ym().performanceMeasures,t=Ym().performanceMarks,r=Me.mergeEventsInOrder(e,t);R4(r),k4(),Me.sortTraceEventsInPlace(Km),Fm.buildTrackDataFromExtensionEntries(Km,aT,iT)}function k4(){let e=Ym().timestampEvents;for(let t of e){if(!t.args.data)continue;let r=String(t.args.data.name??t.args.data.message);H1.set(r,t);let n=A4(t),a=t.args.data.start,o=t.args.data.end;if(!n&&!a&&!o)continue;let s=typeof a=="number"?O.Micro(a):H1.get(String(a))?.ts,c=typeof o=="number"?O.Micro(o):H1.get(String(o))?.ts;if(c!==void 0&&s===void 0)continue;let u=s??t.ts,l=c??t.ts;if(n){let f={...t,name:r,cat:"dev\
tools.extension",args:n,rawSourceEvent:t,dur:O.Micro(l-u),ts:u,ph:b.Phase.COMPLETE},h=kr.SyntheticEventsManager.registerSyntheticEvent(f);Km.push(h);continue}let m={...t,name:r,cat:"disabled-by-default-v8.inspector",ph:b.Phase.COMPLETE,ts:u,dur:O.Micro(l-u),rawSourceEvent:t},p=kr.SyntheticEventsManager.registerSyntheticEvent(m);sT.push(p)}}function R4(e){for(let t of e){let r=_4(t);if(!r)continue;let n={name:t.name,ph:ca.isExtensionPayloadMarker(r)?b.Phase.INSTANT:b.Phase.COMPLETE,pid:t.pid,tid:t.tid,ts:t.ts,dur:t.dur,cat:"devtools.extension",args:r,rawSourceEvent:b.isSyntheticUserTiming(t)?t.rawSourceEvent:t};if(ca.isExtensionPayloadMarker(r)){let a=kr.SyntheticEventsManager.registerSyntheticEvent(n);oT.push(a);continue}if(ca.isExtensionPayloadTrackEntry(n.args)){let a=kr.SyntheticEventsManager.registerSyntheticEvent(n);Km.push(a);continue}}}function yde(e){return!e.args.data||!("devtools"in e.args.data)?null:Me.parseDevtoolsDetails(`{"additionalContext": ${e.args.data.devtools} }`,"a\
dditionalContext")}function _4(e){let t=b.isPerformanceMark(e)?e.args.data?.detail:e.args.data.beginEvent.args.detail;return t?Me.parseDevtoolsDetails(t,"devtools"):null}function A4(e){if(!e.args.data)return null;let t=e.args.data.track;if(t===""||t===void 0)return null;let r,n=yde(e);return n&&(r=n),{color:String(e.args.data.color),track:String(t),dataType:"track-entry",trackGroup:e.args.data.trackGroup!==void 0?String(e.args.data.trackGroup):void 0,additionalContext:r}}function vde(){return{entryToNode:iT,extensionTrackData:aT,extensionMarkers:oT,syntheticConsoleEntriesForTimingsTrack:sT}}function bde(){return["UserTimings"]}var Km,aT,oT,iT,H1,sT,F4=g(()=>{d();ot();Le();nT();Km=[],aT=[],oT=[],iT=new Map,H1=new Map,sT=[];i(pde,"handleEvent");i(fde,"reset");i(hde,"finalize");i(gde,"createExtensionFlameChartEntries");i(k4,"extractConsoleAPIExtensionEntries");i(R4,"extractPerformanceAPIExtensionEntries");i(yde,"extensionPayloadForConsoleApi");i(_4,"extensionDataInPerformanceTiming");i(A4,
"extensionDataInConsoleTimeStamp");i(vde,"data");i(bde,"deps")});var hT={};C(hT,{data:()=>fT,deps:()=>Tde,finalize:()=>Dde,handleEvent:()=>Ede,reset:()=>wde});function wde(){dT.length=0,mT.length=0,pT.clear(),uT={},lT=null,G1.length=0,W1.length=0}function Ede(e){(b.isPaint(e)||b.isDisplayListItemListSnapshot(e)||b.isUpdateLayer(e)||b.isSetLayerId(e))&&W1.push(e)}async function Dde(){let e=Yt();Me.sortTraceEventsInPlace(W1);for(let t of W1)if(b.isSetLayerId(t)){if(e.mainFrameId!==t.args.data.frame)continue;lT=t.args.data.layerTreeId}else if(b.isUpdateLayer(t))G1.push(t);else if(b.isPaint(t)){if(!t.args.data.layerId)continue;dT.push(t),uT[t.args.data.layerId]=t;continue}else if(b.isDisplayListItemListSnapshot(t)){let r=null;for(let a=G1.length-1;a>-1;a--){let o=G1[a];if(o.pid===t.pid&&o.tid===t.tid){r=o;break}}if(!r||r.args.layerTreeId!==lT)continue;let n=uT[r.args.layerId];if(!n)continue;mT.push(t),pT.set(n,t)}}function fT(){return{paints:dT,snapshots:mT,paintsToSnapshots:pT}}function Tde(){return["Meta"]}var dT,mT,pT,uT,lT,G1,W1,gT=g(()=>{d();ot();Le();
ua();dT=[],mT=[],pT=new Map,uT={},lT=null,G1=[],W1=[];i(wde,"reset");i(Ede,"handleEvent");i(Dde,"finalize");i(fT,"data");i(Tde,"deps")});var _c={};C(_c,{ThreadType:()=>wa,threadsInRenderer:()=>V1,threadsInTrace:()=>Sde});function xde(e,t,r){let n=wa.OTHER;return t.name==="CrRendererMain"?n=wa.MAIN_THREAD:t.name==="DedicatedWorker thread"?n=wa.WORKER:t.name?.startsWith("CompositorTileWorker")?n=wa.RASTERIZER:r.worklets.has(e)?n=wa.AUCTION_WORKLET:t.name?.startsWith("ThreadPool")&&(n=wa.THREAD_POOL),n}function V1(e,t){let r=[];if(e.processes.size)for(let[n,a]of e.processes)for(let[o,s]of a.threads){if(!s.tree)continue;let c=xde(n,s,t);r.push({name:s.name,pid:n,tid:o,processIsOnMainFrame:a.isOnMainFrame,entries:s.entries,tree:s.tree,type:c,entryToNode:e.entryToNode})}return r}function Sde(e){let t=yT.get(e);if(t)return t;let r=V1(e.Renderer,e.AuctionWorklets);if(r.length)return yT.set(e,r),r;let n=[];if(e.Samples.profilesInProcess.size)for(let[a,o]of e.Samples.profilesInProcess)for(let[s,c]of o)c.profileTree&&n.push({pid:a,tid:s,name:null,entries:c.profileCalls,processIsOnMainFrame:!1,tree:c.profileTree,type:wa.CPU_PROFILE,
entryToNode:e.Samples.entryToNode});return yT.set(e,n),n}var wa,yT,vT=g(()=>{d();(function(e){e.MAIN_THREAD="MAIN_THREAD",e.WORKER="WORKER",e.RASTERIZER="RASTERIZER",e.AUCTION_WORKLET="AUCTION_WORKLET",e.OTHER="OTHER",e.CPU_PROFILE="CPU_PROFILE",e.THREAD_POOL="THREAD_POOL"})(wa||(wa={}));i(xde,"getThreadTypeForRendererThread");i(V1,"threadsInRenderer");yT=new WeakMap;i(Sde,"threadsInTrace")});var ET={};C(ET,{LayerPaintEvent:()=>K1,PendingFrame:()=>J1,TimelineFrameBeginFrameQueue:()=>X1,TimelineFrameModel:()=>Y1,data:()=>Rde,deps:()=>_de,finalize:()=>kde,framesWithinWindow:()=>Ade,handleEvent:()=>Ide,reset:()=>Cde});function M4(e){return b.isSetLayerId(e)||b.isBeginFrame(e)||b.isDroppedFrame(e)||b.isRequestMainThreadFrame(e)||b.isBeginMainThreadFrame(e)||b.isNeedsBeginFrameChanged(e)||b.isCommit(e)||b.isCompositeLayers(e)||b.isActivateLayerTree(e)||b.isDrawFrame(e)}function O4(e){return e.name===b.Name.RUN_TASK&&e.cat.includes("disabled-by-default-devtools.timeline")}function Cde(){tl=null,$1.length=0}function Ide(e){(M4(e)||b.isLayerTreeHostImplSnapshot(e)||O4(e)||N4.has(e.name)||b.isPaint(e))&&$1.push(e)}async function kde(){Me.sortTraceEventsInPlace($1),tl=new Y1($1,$m(),Lm(),Yt(),fT())}function Rde(){return{frames:tl?Array.from(tl.frames()):[],framesById:tl?{...tl.framesById()}:{}}}function _de(){return["Meta","Renderer","AuctionWorklets","LayerTree"]}function Ade(e,t,r){
let n=Hr.lowerBound(e,t||0,(o,s)=>o-s.endTime),a=Hr.lowerBound(e,r||1/0,(o,s)=>o-s.startTime);return e.slice(n,a)}var tl,$1,N4,Y1,bT,K1,J1,wT,X1,L4=g(()=>{d();rr();ot();Le();_1();gT();ua();z1();vT();tl=null,$1=[];i(M4,"isFrameEvent");i(O4,"entryIsTopLevel");N4=new Set([b.Name.SCHEDULE_STYLE_RECALCULATION,b.Name.INVALIDATE_LAYOUT,b.Name.BEGIN_MAIN_THREAD_FRAME,b.Name.SCROLL_LAYER]);i(Cde,"reset");i(Ide,"handleEvent");i(kde,"finalize");i(Rde,"data");i(_de,"deps");Y1=class{static{i(this,"TimelineFrameModel")}#e=[];#t={};#o=new X1;#r=null;#a=!1;#c=!1;#n=null;#i=null;#u=null;#s=null;#l=null;#p=null;#d=null;#m=null;#f=null;#h;constructor(t,r,n,a,o){let c=V1(r,n).filter(u=>u.type===wa.MAIN_THREAD&&u.processIsOnMainFrame).map(u=>({tid:u.tid,pid:u.pid,startTime:u.entries[0].ts}));this.#h=o,this.#I(t,c,a.mainFrameId)}framesById(){return this.#t}frames(){return this.#e}#g(t,r){this.#r||this.#v(t,r),this.#s=t,this.#o.addFrameIfNotExists(r,t,!1,!1)}#y(t,r,n){this.#r||this.#v(t,r),this.#o.addFrameIfNotExists(
r,t,!0,n),this.#o.setDropped(r,!0),this.#o.setPartial(r,n)}#w(t,r){if(!this.#r){this.#v(t,r);return}if(this.#a||!this.#c){this.#l&&((this.#i?this.#i.triggerTime:this.#s||this.#l)>this.#r.startTime&&(this.#r.idle=!0,this.#s=null),this.#l=null);let n=this.#o.processPendingBeginFramesOnDrawFrame(r);for(let a of n){let o=this.#r.idle;this.#v(a.startTime,r),o&&this.#i&&this.#b(),a.isDropped&&(this.#r.dropped=!0),a.isPartial&&(this.#r.isPartial=!0)}}this.#a=!1}#E(){this.#r&&this.#i&&!this.#l&&this.#b()}#D(){this.#r&&(this.#c=!0)}#T(){this.#u&&(this.#i=this.#u,this.#u=null,this.#c=!1,this.#a=!0)}#x(t){this.#n=t}#S(t,r){r&&(this.#l=t)}#v(t,r){this.#r&&this.#C(this.#r,t),this.#r=new bT(r,t,O.Micro(t-Yt().traceBounds.min))}#C(t,r){t.setLayerTree(this.#n),t.setEndTime(r),this.#n&&(this.#n.paints=t.paints);let n=this.#e[this.#e.length-1];this.#e.length&&n&&(t.startTime!==n.endTime||t.startTime>t.endTime)&&console.assert(!1,`Inconsistent frame time for frame ${this.#e.length} (${t.startTime} - ${t.
endTime})`);let a=this.#e.push(t);t.setIndex(a-1),typeof t.mainFrameId=="number"&&(this.#t[t.mainFrameId]=t)}#b(){!this.#i||!this.#r||(this.#r.paints=this.#i.paints,this.#r.mainFrameId=this.#i.mainFrameId,this.#i=null)}#I(t,r,n){let a=0;this.#f=r.length&&r[0].tid||null,this.#m=r.length&&r[0].pid||null;for(let o=0;o<t.length;++o){for(;a+1<r.length&&r[a+1].startTime<=t[o].ts;)this.#f=r[++a].tid,this.#m=r[a].pid;this.#k(t[o],n)}this.#f=null,this.#m=null}#k(t,r){b.isSetLayerId(t)&&t.args.data.frame===r?this.#d=t.args.data.layerTreeId:b.isLayerTreeHostImplSnapshot(t)&&Number(t.id)===this.#d?this.#x({entry:t,paints:[]}):(M4(t)&&this.#R(t),t.tid===this.#f&&t.pid===this.#m&&this.#_(t))}#R(t){t.args.layerTreeId===this.#d&&(b.isBeginFrame(t)?this.#g(t.ts,t.args.frameSeqId):b.isDrawFrame(t)?this.#w(t.ts,t.args.frameSeqId):b.isActivateLayerTree(t)?this.#E():b.isRequestMainThreadFrame(t)?this.#D():b.isNeedsBeginFrameChanged(t)?this.#S(t.ts,t.args.data&&!!t.args.data.needsBeginFrame):b.isDroppedFrame(
t)&&this.#y(t.ts,t.args.frameSeqId,!!t.args.hasPartialUpdate))}#_(t){if(O4(t)&&(this.#p=t.ts),!this.#u&&N4.has(t.name)&&(this.#u=new J1(this.#p||t.ts)),!!this.#u){if(b.isBeginMainThreadFrame(t)&&t.args.data.frameId&&(this.#u.mainFrameId=t.args.data.frameId),b.isPaint(t)){let r=this.#h.paintsToSnapshots.get(t);r&&this.#u.paints.push(new K1(t,r))}(b.isCompositeLayers(t)||b.isCommit(t))&&t.args.layerTreeId===this.#d&&this.#T()}}},bT=class{static{i(this,"TimelineFrame")}cat="devtools.legacy_frame";name="frame";ph=b.Phase.COMPLETE;ts;pid=b.ProcessID(-1);tid=b.ThreadID(-1);index=-1;startTime;startTimeOffset;endTime;duration;idle;dropped;isPartial;layerTree;paints;mainFrameId;seqId;constructor(t,r,n){this.seqId=t,this.startTime=r,this.ts=r,this.startTimeOffset=n,this.endTime=this.startTime,this.duration=O.Micro(0),this.idle=!1,this.dropped=!1,this.isPartial=!1,this.layerTree=null,this.paints=[],this.mainFrameId=void 0}setIndex(t){this.index=t}setEndTime(t){this.endTime=t,this.duration=O.Micro(
this.endTime-this.startTime)}setLayerTree(t){this.layerTree=t}get dur(){return this.duration}},K1=class{static{i(this,"LayerPaintEvent")}#e;#t;constructor(t,r){this.#e=t,this.#t=r}layerId(){return this.#e.args.data.layerId}event(){return this.#e}picture(){let t=this.#t.args.snapshot.params?.layer_rect,r=this.#t.args.snapshot.skp64;return t&&r?{rect:t,serializedPicture:r}:null}},J1=class{static{i(this,"PendingFrame")}paints;mainFrameId;triggerTime;constructor(t){this.paints=[],this.mainFrameId=void 0,this.triggerTime=t}},wT=class{static{i(this,"BeginFrameInfo")}seqId;startTime;isDropped;isPartial;constructor(t,r,n,a){this.seqId=t,this.startTime=r,this.isDropped=n,this.isPartial=a}},X1=class{static{i(this,"TimelineFrameBeginFrameQueue")}queueFrames=[];mapFrames={};addFrameIfNotExists(t,r,n,a){t in this.mapFrames||(this.mapFrames[t]=new wT(t,r,n,a),this.queueFrames.push(t))}setDropped(t,r){t in this.mapFrames&&(this.mapFrames[t].isDropped=r)}setPartial(t,r){t in this.mapFrames&&(this.mapFrames[t].
isPartial=r)}processPendingBeginFramesOnDrawFrame(t){let r=[];if(t in this.mapFrames){for(;this.queueFrames[0]!==t;){let n=this.queueFrames[0];this.mapFrames[n].isDropped&&r.push(this.mapFrames[n]),delete this.mapFrames[n],this.queueFrames.shift()}r.push(this.mapFrames[t]),delete this.mapFrames[t],this.queueFrames.shift()}return r}};i(Ade,"framesWithinWindow")});var xT={};C(xT,{data:()=>Nde,deps:()=>Lde,finalize:()=>Ode,handleEvent:()=>Mde,reset:()=>Fde});function Fde(){DT.clear(),TT=[]}function Mde(e){b.isGPUTask(e)&&Me.addEventToProcessThread(e,DT)}async function Ode(){let{gpuProcessId:e,gpuThreadId:t}=Yt(),r=DT.get(e);r&&t&&(TT=r.get(t)||[])}function Nde(){return{mainGPUThreadTasks:TT}}function Lde(){return["Meta"]}var DT,TT,P4=g(()=>{d();ot();Le();ua();DT=new Map,TT=[];i(Fde,"reset");i(Mde,"handleEvent");i(Ode,"finalize");i(Nde,"data");i(Lde,"deps")});var kT={};C(kT,{data:()=>jde,finalize:()=>Ude,handleEvent:()=>Bde,reset:()=>Pde});function Pde(){rl.clear(),Z1.clear(),Q1.clear(),ey.clear(),ST.clear(),CT.clear(),IT=!1}function Bde(e){if(b.isPaintImage(e)){let t=rl.get(e.pid)||new Map,r=t.get(e.tid)||[];r.push(e),t.set(e.tid,r),rl.set(e.pid,t),e.args.data.url&&Ne.getWithDefault(ST,e.args.data.url,()=>[]).push(e);return}if(b.isDecodeLazyPixelRef(e)&&typeof e.args?.LazyPixelRef<"u"){let t=Z1.get(e.pid)||new Map,r=t.get(e.tid)||[];r.push(e),t.set(e.tid,r),Z1.set(e.pid,t)}if(b.isDrawLazyPixelRef(e)&&typeof e.args?.LazyPixelRef<"u"){let t=rl.get(e.pid)?.get(e.tid)?.at(-1);if(!t)return;Q1.set(e.args.LazyPixelRef,t);return}if(b.isDecodeImage(e)){let t=rl.get(e.pid)?.get(e.tid)?.at(-1);if(t){ey.set(e,t);return}let r=Z1.get(e.pid)?.get(e.tid)?.at(-1);if(typeof r?.args?.LazyPixelRef>"u")return;let n=Q1.get(r.args.LazyPixelRef);if(!n)return;ey.set(e,n)}}async function Ude(e){if(!e.metadata?.hostDPR)return;let{devicePixelRatio:t}=Yt();if(t){for(let r of rl.
values())for(let n of r.values())for(let a of n){let o=a.args.data.width/e.metadata.hostDPR,s=a.args.data.height/e.metadata.hostDPR,c=o*t,u=s*t;CT.set(a,{width:c,height:u})}IT=!0}}function jde(){return{paintImageByDrawLazyPixelRef:Q1,paintImageForEvent:ey,paintImageEventForUrl:ST,paintEventToCorrectedDisplaySize:CT,didCorrectForHostDpr:IT}}var rl,Z1,Q1,ey,ST,CT,IT,B4=g(()=>{d();rr();Le();ua();rl=new Map,Z1=new Map,Q1=new Map,ey=new Map,ST=new Map,CT=new Map,IT=!1;i(Pde,"reset");i(Bde,"handleEvent");i(Ude,"finalize");i(jde,"data")});var NT={};C(NT,{data:()=>$de,deps:()=>Yde,finalize:()=>Vde,handleEvent:()=>Hde,reset:()=>zde});function zde(){RT.clear(),Jm.clear(),_T.clear(),AT.clear(),ry.clear(),ty.clear(),qde.clear(),FT.clear(),MT.clear(),OT.clear()}function us(e){ry.set(e.event,e.initiator);let t=ty.get(e.initiator)||[];t.push(e.event),ty.set(e.initiator,t)}function Hde(e){if(b.isScheduleStyleRecalculation(e))RT.set(e.args.data.frame,e);else if(b.isUpdateLayoutTree(e)){if(e.args.beginData){_T.set(e.args.beginData.frame,e);let t=RT.get(e.args.beginData.frame);t&&us({event:e,initiator:t})}}else if(b.isInvalidateLayout(e)){let t=e;if(!Jm.has(e.args.data.frame)){let r=_T.get(e.args.data.frame);if(r){let{endTime:n}=ae.eventTimingsMicroSeconds(r),a=ry.get(r);a&&n&&n>e.ts&&(t=a)}}Jm.set(e.args.data.frame,t)}else if(b.isLayout(e)){let t=Jm.get(e.args.beginData.frame);t&&us({event:e,initiator:t}),Jm.delete(e.args.beginData.frame)}else if(b.isTimerInstall(e))AT.set(e.args.data.timerId,e);else if(b.isTimerFire(e)){let t=AT.
get(e.args.data.timerId);t&&us({event:e,initiator:t})}else if(b.isRequestIdleCallback(e))FT.set(e.args.data.id,e);else if(b.isFireIdleCallback(e)){let t=FT.get(e.args.data.id);t&&us({event:e,initiator:t})}else if(b.isWebSocketCreate(e))MT.set(e.args.data.identifier,e);else if(b.isWebSocketInfo(e)||b.isWebSocketTransfer(e)){let t=MT.get(e.args.data.identifier);t&&us({event:e,initiator:t})}else if(b.isSchedulePostTaskCallback(e))OT.set(e.args.data.taskId,e);else if(b.isRunPostTaskCallback(e)||b.isAbortPostTaskCallback(e)){let t=OT.get(e.args.data.taskId);t&&us({event:e,initiator:t})}}function Gde(){let e=Nm().flows;for(let t=0;t<e.length;t++){let r=e[t];for(let n=0;n<r.length-1;n++)us({event:r[n+1],initiator:r[n]})}}function Wde(){let e=VD().schedulerToRunEntryPoints.entries();for(let[t,r]of e)for(let n of r)us({event:n,initiator:t})}async function Vde(){Gde(),Wde()}function $de(){return{eventToInitiator:ry,initiatorToEvents:ty}}function Yde(){return["Flows","AsyncJSCalls"]}var RT,Jm,_T,
ry,ty,qde,AT,FT,MT,OT,U4=g(()=>{d();ot();Le();YD();R1();RT=new Map,Jm=new Map,_T=new Map,ry=new Map,ty=new Map,qde=new Map,AT=new Map,FT=new Map,MT=new Map,OT=new Map;i(zde,"reset");i(us,"storeInitiator");i(Hde,"handleEvent");i(Gde,"createRelationshipsFromFlows");i(Wde,"createRelationshipsFromAsyncJSCalls");i(Vde,"finalize");i($de,"data");i(Yde,"deps")});var PT={};C(PT,{data:()=>Qde,finalize:()=>Zde,handleEvent:()=>Xde,handleUserConfig:()=>Jde,reset:()=>Kde});function Kde(){ay.clear(),oy.clear(),Eo=null,Xm.length=0,ny=!1,Zm=null}function Jde(e){Zm=e.maxInvalidationEventsPerEvent}function LT(e,t){let r=ay.get(e)||[];r.push(t),Zm!==null&&r.length>Zm&&r.shift(),ay.set(e,r);let n=oy.get(e)??0;oy.set(e,n+1)}function Xde(e){if(Zm!==0){if(b.isUpdateLayoutTree(e)){Eo=e;for(let t of Xm){if(b.isLayoutInvalidationTracking(t))continue;let r=Eo.args.beginData?.frame;r&&t.args.data.frame===r&&LT(e,t)}return}if(b.isInvalidationTracking(e)){if(ny&&(Xm.length=0,Eo=null,ny=!1),Eo&&(b.isScheduleStyleInvalidationTracking(e)||b.isStyleRecalcInvalidationTracking(e)||b.isStyleInvalidatorInvalidationTracking(e))){let t=Eo.ts+(Eo.dur||0);e.ts>=Eo.ts&&e.ts<=t&&Eo.args.beginData?.frame===e.args.data.frame&&LT(Eo,e)}Xm.push(e);return}if(b.isPaint(e)){ny=!0;return}if(b.isLayout(e)){let t=e.args.beginData.frame;for(let r of Xm)b.isLayoutInvalidationTracking(r)&&r.args.
data.frame===t&&LT(e,r)}}}async function Zde(){}function Qde(){return{invalidationsForEvent:ay,invalidationCountForEvent:oy}}var ay,oy,Eo,ny,Xm,Zm,j4=g(()=>{d();Le();ay=new Map,oy=new Map,Eo=null,ny=!1,Xm=[];i(Kde,"reset");Zm=null;i(Jde,"handleUserConfig");i(LT,"addInvalidationToEvent");i(Xde,"handleEvent");i(Zde,"finalize");i(Qde,"data")});var jT={};C(jT,{MetricName:()=>Mn,ScoreClassification:()=>ir,data:()=>UT,deps:()=>ime,finalize:()=>ome,getFrameIdForPageLoadEvent:()=>sy,handleEvent:()=>tme,metricIsLCP:()=>sme,reset:()=>eme,scoreClassificationForDOMContentLoaded:()=>G4,scoreClassificationForFirstContentfulPaint:()=>q4,scoreClassificationForLargestContentfulPaint:()=>H4,scoreClassificationForTimeToInteractive:()=>z4,scoreClassificationForTotalBlockingTime:()=>W4});function eme(){ep.clear(),Qm=[],BT=[],iy.clear()}function tme(e){b.eventIsPageLoadEvent(e)&&Qm.push(e)}function rme(e,t){let r=e.args.data?.navigationId;if(!r)throw new Error("Navigation event unexpectedly had no navigation ID.");let n=sy(t),{rendererProcessesByFrame:a}=Yt(),o=a.get(n);if(!(!o||!o.get(t.pid))&&!b.isNavigationStart(t)){if(b.isFirstContentfulPaint(t)){let c=O.Micro(t.ts-e.ts),u=q4(c),l={event:t,metricName:Mn.FCP,classification:u,navigation:e,timing:c};ls(n,r,l);return}if(b.isFirstPaint(t)){let c=O.Micro(t.ts-e.ts),u=ir.UNCLASSIFIED,l={event:t,metricName:Mn.
FP,classification:u,navigation:e,timing:c};ls(n,r,l);return}if(b.isMarkDOMContent(t)){let c=O.Micro(t.ts-e.ts),u={event:t,metricName:Mn.DCL,classification:G4(c),navigation:e,timing:c};ls(n,r,u);return}if(b.isInteractiveTime(t)){let c=O.Micro(t.ts-e.ts),u={event:t,metricName:Mn.TTI,classification:z4(c),navigation:e,timing:c};ls(n,r,u);let l=ae.milliToMicro(O.Milli(t.args.args.total_blocking_time_ms)),m={event:t,metricName:Mn.TBT,classification:W4(l),navigation:e,timing:l};ls(n,r,m);return}if(b.isMarkLoad(t)){let c=O.Micro(t.ts-e.ts),u={event:t,metricName:Mn.L,classification:ir.UNCLASSIFIED,navigation:e,timing:c};ls(n,r,u);return}if(b.isLargestContentfulPaintCandidate(t)){let c=t.args.data?.candidateIndex;if(!c)throw new Error("Largest Contentful Paint unexpectedly had no candidateIndex.");let u=O.Micro(t.ts-e.ts),l={event:t,metricName:Mn.LCP,classification:H4(u),navigation:e,timing:u},m=Ne.getWithDefault(ep,n,()=>new Map),f=Ne.getWithDefault(m,r,()=>new Map).get(Mn.LCP);if(f===void 0){iy.
add(l.event),ls(n,r,l);return}let h=f.event;if(!b.isLargestContentfulPaintCandidate(h))return;let y=h.args.data?.candidateIndex;if(!y)return;y<c&&(iy.delete(h),iy.add(l.event),ls(n,r,l));return}if(!b.isLayoutShift(t))return Ju(t,`Unexpected event type: ${t}`)}}function ls(e,t,r){let n=Ne.getWithDefault(ep,e,()=>new Map),a=Ne.getWithDefault(n,t,()=>new Map);a.delete(r.metricName),a.set(r.metricName,r)}function sy(e){if(b.isFirstContentfulPaint(e)||b.isInteractiveTime(e)||b.isLargestContentfulPaintCandidate(e)||b.isNavigationStart(e)||b.isLayoutShift(e)||b.isFirstPaint(e))return e.args.frame;if(b.isMarkDOMContent(e)||b.isMarkLoad(e)){let t=e.args.data?.frame;if(!t)throw new Error("MarkDOMContent unexpectedly had no frame ID.");return t}Ju(e,`Unexpected event type: ${e}`)}function nme(e){if(b.isFirstContentfulPaint(e)||b.isLargestContentfulPaintCandidate(e)||b.isFirstPaint(e)){let t=e.args.data?.navigationId;if(!t)throw new Error("Trace event unexpectedly had no navigation ID.");let{navigationsByNavigationId:r}=Yt(),
n=r.get(t);return n||null}if(b.isMarkDOMContent(e)||b.isInteractiveTime(e)||b.isLayoutShift(e)||b.isMarkLoad(e)){let t=sy(e),{navigationsByFrameId:r}=Yt();return Me.getNavigationForTraceEvent(e,t,r)}return b.isNavigationStart(e)?null:Ju(e,`Unexpected event type: ${e}`)}function q4(e){let t=ae.secondsToMicro(O.Seconds(1.8)),r=ae.secondsToMicro(O.Seconds(3)),n=ir.BAD;return e<=r&&(n=ir.OK),e<=t&&(n=ir.GOOD),n}function z4(e){let t=ae.secondsToMicro(O.Seconds(3.8)),r=ae.secondsToMicro(O.Seconds(7.3)),n=ir.BAD;return e<=r&&(n=ir.OK),e<=t&&(n=ir.GOOD),n}function H4(e){let t=ae.secondsToMicro(O.Seconds(2.5)),r=ae.secondsToMicro(O.Seconds(4)),n=ir.BAD;return e<=r&&(n=ir.OK),e<=t&&(n=ir.GOOD),n}function G4(e){return ir.UNCLASSIFIED}function W4(e){let t=ae.milliToMicro(O.Milli(200)),r=ae.milliToMicro(O.Milli(600)),n=ir.BAD;return e<=r&&(n=ir.OK),e<=t&&(n=ir.GOOD),n}function ame(){let e=[],r=[...ep.values()].flatMap(n=>[...n.values()]);for(let n=0;n<r.length;n++){let o=r[n].get(Mn.LCP);o?.event&&
e.push(o.event)}return e}async function ome(){Qm.sort((a,o)=>a.ts-o.ts);for(let a of Qm){let o=nme(a);o&&rme(o,a)}let e=ame(),t=Yt().mainFrameId,r=Qm.filter(a=>!b.isLargestContentfulPaintCandidate(a));BT=[...e,...r].filter(b.isMarkerEvent).filter(a=>sy(a)===t).sort((a,o)=>a.ts-o.ts)}function UT(){return{metricScoresByFrameId:ep,allMarkerEvents:BT}}function ime(){return["Meta"]}function sme(e){return e.metricName===Mn.LCP}var ep,BT,Qm,iy,ir,Mn,tp=g(()=>{d();rr();ot();Le();ua();ep=new Map,BT=[];i(eme,"reset");Qm=[],iy=new Set;i(tme,"handleEvent");i(rme,"storePageLoadMetricAgainstNavigationId");i(ls,"storeMetricScore");i(sy,"getFrameIdForPageLoadEvent");i(nme,"getNavigationForPageLoadEvent");i(q4,"scoreClassificationForFirstContentfulPaint");i(z4,"scoreClassificationForTimeToInteractive");i(H4,"scoreClassificationForLargestContentfulPaint");i(G4,"scoreClassificationForDOMContentLoaded");i(W4,"scoreClassificationForTotalBlockingTime");i(ame,"gatherFinalLCPEvents");i(ome,"finalize");i(UT,"d\
ata");i(ime,"deps");(function(e){e.GOOD="good",e.OK="ok",e.BAD="bad",e.UNCLASSIFIED="unclassified"})(ir||(ir={}));(function(e){e.FCP="FCP",e.FP="FP",e.L="L",e.LCP="LCP",e.DCL="DCL",e.TTI="TTI",e.TBT="TBT",e.CLS="CLS",e.NAV="Nav"})(Mn||(Mn={}));i(sme,"metricIsLCP")});var zT={};C(zT,{data:()=>dme,deps:()=>mme,finalize:()=>lme,handleEvent:()=>ume,reset:()=>cme});function cme(){qT.clear()}function ume(e){if(!b.isLargestImagePaintCandidate(e)||!e.args.data)return;Ne.getWithDefault(qT,e.pid,()=>new Map).set(e.args.data.DOMNodeId,e)}async function lme(){let e=kc().byTime,{traceBounds:t,navigationsByNavigationId:r}=Yt(),n=UT().metricScoresByFrameId;for(let[a,o]of r){let c=n.get(o.args.frame)?.get(a)?.get(Mn.LCP)?.event;if(!c||!b.isLargestContentfulPaintCandidate(c))continue;let u=c.args.data?.nodeId;if(!u)continue;let l=qT.get(c.pid)?.get(u),m=l?.args.data?.imageUrl;if(!m)continue;let p=o?.ts??t.min,f=l.ts,h;for(let y of e)if(!(y.ts<p)){if(y.ts>=f)break;if(y.args.data.url===m||y.args.data.redirects.some(v=>v.url===m)){h=y;break}}h&&V4.set(a,h)}}function dme(){return{lcpRequestByNavigationId:V4}}function mme(){return["Meta","NetworkRequests","PageLoadMetrics"]}var qT,V4,$4=g(()=>{d();rr();Le();ua();Hm();tp();qT=new Map,V4=new Map;i(cme,"reset");i(ume,"hand\
leEvent");i(lme,"finalize");i(dme,"data");i(mme,"deps")});var GT={};C(GT,{data:()=>gme,finalize:()=>hme,handleEvent:()=>fme,reset:()=>pme});function pme(){HT.clear()}function fme(e){b.isLargestTextPaintCandidate(e)&&e.args.data&&HT.set(e.args.data.DOMNodeId,e)}async function hme(){}function gme(){return HT}var HT,Y4=g(()=>{d();Le();HT=new Map;i(pme,"reset");i(fme,"handleEvent");i(hme,"finalize");i(gme,"data")});var YT={};C(YT,{data:()=>$T,deps:()=>Eme,finalize:()=>bme,handleEvent:()=>vme,reset:()=>yme,screenshotImageDataUri:()=>wme});function yme(){WT.length=0,VT.length=0,uy.length=0,cy.length=0,K4={}}function vme(e){b.isLegacyScreenshot(e)?VT.push(e):b.isScreenshot(e)?cy.push(e):b.isPipelineReporter(e)&&WT.push(e)}async function bme(){let e=Me.createMatchedSortedSyntheticEvents(WT);K4=Object.fromEntries(e.map(t=>{let r=t.args.data.beginEvent.args,a=("frame_reporter"in r?r.frame_reporter:r.chrome_frame_reporter).frame_sequence,o=O.Micro(t.ts+t.dur);return[a,o]}));for(let t of VT){let{cat:r,name:n,ph:a,pid:o,tid:s}=t,c=kr.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:t,cat:r,name:n,ph:a,pid:o,tid:s,ts:t.ts,args:{dataUri:`data:image/jpg;base64,${t.args.snapshot}`}});uy.push(c)}}function wme(e){return b.isLegacySyntheticScreenshot(e)?e.args.dataUri:`data:image/jpg;base64,${e.args.snapshot}`}function $T(){return{legacySyntheticScreenshots:uy.length?uy:null,screenshots:cy.length?cy:
null}}function Eme(){return["Meta"]}var WT,VT,cy,uy,K4,KT=g(()=>{d();ot();Le();WT=[],VT=[],cy=[],uy=[],K4={};i(yme,"reset");i(vme,"handleEvent");i(bme,"finalize");i(wme,"screenshotImageDataUri");i($T,"data");i(Eme,"deps")});var ZT={};C(ZT,{LayoutShiftsThreshold:()=>ii,MAX_CLUSTER_DURATION:()=>dy,MAX_SHIFT_TIME_DELTA:()=>rp,data:()=>Rme,deps:()=>_me,finalize:()=>Ime,handleEvent:()=>Tme,reset:()=>Dme,scoreClassificationForLayoutShift:()=>Ame});function Dme(){ds.length=0,ap.length=0,py.length=0,J4.length=0,yy.length=0,vy.length=0,fy.length=0,gy.length=0,hy.length=0,np.length=0,nl.clear(),$n.length=0,my=0,al.length=0,JT=-1,XT.clear()}function Tme(e){if(b.isLayoutShift(e)&&!e.args.data?.had_recent_input){ds.push(e);return}if(b.isLayoutInvalidationTracking(e)){ap.push(e);return}if(b.isScheduleStyleInvalidationTracking(e)&&py.push(e),b.isStyleRecalcInvalidationTracking(e)&&J4.push(e),b.isPrePaint(e)){yy.push(e);return}if(b.isRenderFrameImplCreateChildFrame(e)&&fy.push(e),b.isDomLoading(e)&&hy.push(e),b.isLayoutImageUnsized(e)&&gy.push(e),b.isBeginRemoteFontLoad(e)&&np.push({display:e.args.display,url:e.args.url,beginRemoteFontLoadEvent:e}),b.isRemoteFontLoaded(e))for(let t of np)t.url===e.args.url&&(t.name=e.args.
name);b.isPaintImage(e)&&vy.push(e)}function ly(e){return{min:e,max:e,range:O.Micro(0)}}function Ea(e,t){e.max=t,e.range=O.Micro(e.max-e.min)}function xme(e){let t=$T();if(t.screenshots){let r=Me.findPreviousEventBeforeTimestamp(t.screenshots,e),n=r?t.screenshots[t.screenshots.indexOf(r)+1]:null;return{before:r,after:n}}if(t.legacySyntheticScreenshots){let r=Me.findPreviousEventBeforeTimestamp(t.legacySyntheticScreenshots,e),n=r?t.legacySyntheticScreenshots[t.legacySyntheticScreenshots.indexOf(r)+1]:null;return{before:r,after:n}}return{before:null,after:null}}function Sme(){let{traceBounds:e}=Yt();al.push({ts:e.min,score:0});for(let t of $n){let r=0;t.events[0].args.data&&al.push({ts:t.clusterWindow.min,score:t.events[0].args.data.weighted_score_delta});for(let n=0;n<t.events.length;n++){let a=t.events[n];a.args.data&&(r+=a.args.data.weighted_score_delta,al.push({ts:a.ts,score:r}))}al.push({ts:t.clusterWindow.max,score:0})}}function Cme(){nl.clear();for(let e of ds)if(e.args.data?.impacted_nodes)
for(let t of e.args.data.impacted_nodes)nl.add(t.node_id);for(let e of ap)e.args.data?.nodeId&&nl.add(e.args.data.nodeId);for(let e of py)e.args.data?.nodeId&&nl.add(e.args.data.nodeId)}async function Ime(){ds.sort((e,t)=>e.ts-t.ts),yy.sort((e,t)=>e.ts-t.ts),ap.sort((e,t)=>e.ts-t.ts),fy.sort((e,t)=>e.ts-t.ts),hy.sort((e,t)=>e.ts-t.ts),gy.sort((e,t)=>e.ts-t.ts),np.sort((e,t)=>e.beginRemoteFontLoadEvent.ts-t.beginRemoteFontLoadEvent.ts),vy.sort((e,t)=>e.ts-t.ts),await kme(),Sme(),Cme()}async function kme(){let{navigationsByFrameId:e,mainFrameId:t,traceBounds:r}=Yt(),n=e.get(t)||[];if(ds.length===0)return;let a=ds[0].ts,o=ds[0].ts,s=null;for(let c of ds){let u=c.ts-a>dy,l=c.ts-o>rp,m=Hr.nearestIndexFromEnd(n,v=>v.ts<c.ts),p=s!==m&&m!==null;if(u||l||p||!$n.length){let v=c.ts,E=u?a+dy:1/0,T=l?o+rp:1/0,x=p?n[m].ts:1/0,S=Math.min(E,T,x);if($n.length>0){let F=$n[$n.length-1];Ea(F.clusterWindow,O.Micro(S))}let I=m===null?b.NO_NAVIGATION:n[m].args.data?.navigationId;$n.push(kr.SyntheticEventsManager.
registerSyntheticEvent({name:"SyntheticLayoutShiftCluster",rawSourceEvent:c,events:[],clusterWindow:ly(v),clusterCumulativeScore:0,scoreWindows:{good:ly(v)},navigationId:I,ts:c.ts,pid:c.pid,tid:c.tid,ph:b.Phase.COMPLETE,cat:"",dur:O.Micro(-1)})),a=v}let f=$n[$n.length-1],h=m!==null?O.Micro(c.ts-n[m].ts):void 0;if(f.clusterCumulativeScore+=c.args.data?c.args.data.weighted_score_delta:0,!c.args.data)continue;let y=kr.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:c,...c,name:b.Name.SYNTHETIC_LAYOUT_SHIFT,args:{frame:c.args.frame,data:{...c.args.data,rawEvent:c,navigationId:f.navigationId??void 0}},parsedData:{timeFromNavigation:h,screenshots:xme(c.ts),cumulativeWeightedScoreInWindow:f.clusterCumulativeScore,sessionWindowData:{cumulativeWindowScore:0,id:$n.length}}});f.events.push(y),Ea(f.clusterWindow,c.ts),o=c.ts,s=m}for(let c of $n){let u=0,l=-1;if(c===$n[$n.length-1]){let h=dy+c.clusterWindow.min,y=c.clusterWindow.max+rp,v=Hr.nearestIndexFromBeginning(n,x=>x.ts>c.clusterWindow.
max),E=v?n[v].ts:1/0,T=Math.min(h,y,r.max,E);Ea(c.clusterWindow,O.Micro(T))}let m=0,p=null;for(let h of c.events){u+=h.args.data?h.args.data.weighted_score_delta:0,l=h.parsedData.sessionWindowData.id;let y=h.ts;h.parsedData.sessionWindowData.cumulativeWindowScore=c.clusterCumulativeScore,u<ii.NEEDS_IMPROVEMENT?Ea(c.scoreWindows.good,y):u>=ii.NEEDS_IMPROVEMENT&&u<ii.BAD?(c.scoreWindows.needsImprovement||(Ea(c.scoreWindows.good,O.Micro(y-1)),c.scoreWindows.needsImprovement=ly(y)),Ea(c.scoreWindows.needsImprovement,y)):u>=ii.BAD&&(c.scoreWindows.bad||(c.scoreWindows.needsImprovement?Ea(c.scoreWindows.needsImprovement,O.Micro(y-1)):Ea(c.scoreWindows.good,O.Micro(y-1)),c.scoreWindows.bad=ly(h.ts)),Ea(c.scoreWindows.bad,y)),c.scoreWindows.bad?Ea(c.scoreWindows.bad,c.clusterWindow.max):c.scoreWindows.needsImprovement?Ea(c.scoreWindows.needsImprovement,c.clusterWindow.max):Ea(c.scoreWindows.good,c.clusterWindow.max);let v=h.args.data?.weighted_score_delta;v!==void 0&&v>m&&(m=v,p=h)}p&&(c.worstShiftEvent=
p,c.rawSourceEvent=p),c.ts=c.events[0].ts;let f=ae.eventTimingsMicroSeconds(c.events[c.events.length-1]);c.dur=O.Micro(f.endTime-c.events[0].ts+rp),u>my&&(JT=l,my=u),c.navigationId&&Ne.getWithDefault(XT,c.navigationId,()=>[]).push(c)}}function Rme(){return{clusters:$n,sessionMaxScore:my,clsWindowID:JT,prePaintEvents:yy,layoutInvalidationEvents:ap,scheduleStyleInvalidationEvents:py,styleRecalcInvalidationEvents:[],renderFrameImplCreateChildFrameEvents:fy,domLoadingEvents:hy,layoutImageUnsizedEvents:gy,remoteFonts:np,scoreRecords:al,backendNodeIds:[...nl],clustersByNavigationId:new Map(XT),paintImageEvents:vy}}function _me(){return["Screenshots","Meta"]}function Ame(e){let t=ir.GOOD;return e>=ii.NEEDS_IMPROVEMENT&&(t=ir.OK),e>=ii.BAD&&(t=ir.BAD),t}var dy,rp,ds,ap,py,J4,fy,hy,gy,np,nl,yy,vy,my,JT,$n,XT,al,ii,X4=g(()=>{d();rr();ot();Le();ua();tp();KT();dy=ae.milliToMicro(O.Milli(5e3)),rp=ae.milliToMicro(O.Milli(1e3)),ds=[],ap=[],py=[],J4=[],fy=[],hy=[],gy=[],np=[],nl=new Set,yy=[],vy=[],my=
0,JT=-1,$n=[],XT=new Map,al=[];i(Dme,"reset");i(Tme,"handleEvent");i(ly,"traceWindowFromTime");i(Ea,"updateTraceWindowMax");i(xme,"findScreenshots");i(Sme,"buildScoreRecords");i(Cme,"collectNodes");i(Ime,"finalize");i(kme,"buildLayoutShiftsClusters");i(Rme,"data");i(_me,"deps");i(Ame,"scoreClassificationForLayoutShift");(function(e){e[e.GOOD=0]="GOOD",e[e.NEEDS_IMPROVEMENT=.1]="NEEDS_IMPROVEMENT",e[e.BAD=.25]="BAD"})(ii||(ii={}))});var QT={};C(QT,{data:()=>Nme,finalize:()=>Ome,handleEvent:()=>Mme,reset:()=>Fme});function Fme(){by.clear()}function Mme(e){if(b.isUpdateCounters(e)){let t=Ne.getWithDefault(by,e.pid,()=>[]);t.push(e),by.set(e.pid,t)}}async function Ome(){}function Nme(){return{updateCountersByProcess:by}}var by,Z4=g(()=>{d();rr();Le();by=new Map;i(Fme,"reset");i(Mme,"handleEvent");i(Ome,"finalize");i(Nme,"data")});var ex={};C(ex,{data:()=>Ume,finalize:()=>Bme,handleEvent:()=>Pme,reset:()=>Lme});function Lme(){op.clear()}function Pme(e){if(b.isTracingStartedInBrowser(e)){for(let t of e.args.data?.frames??[])op.set(t.frame,t);return}if(b.isCommitLoad(e)){let t=e.args.data;if(!t)return;let r=op.get(t.frame);if(!r)return;op.set(t.frame,{...r,url:t.url||r.url,name:t.name||t.name})}}async function Bme(){}function Ume(){return{frames:op}}var op,Q4=g(()=>{d();Le();op=new Map;i(Lme,"reset");i(Pme,"handleEvent");i(Bme,"finalize");i(Ume,"data")});var tx={};C(tx,{data:()=>Jme,deps:()=>jme,finalize:()=>Kme,getScriptGeneratedSizes:()=>$me,handleEvent:()=>zme,reset:()=>qme});function eB(e,t){if(t.startsWith("data:")||t.startsWith("blob:")||t.startsWith("javascript:")||t.startsWith("mailto:"))return t;try{return new URL(t,e).href}catch{}return null}function jme(){return["Meta","NetworkRequests"]}function qme(){ip.clear()}function zme(e){let t=i((r,n)=>{let a=String(n),o=`${r}.${a}`;return Ne.getWithDefault(ip,o,()=>({isolate:r,scriptId:a,frame:"",ts:0}))},"getOrMakeScript");if(b.isTargetRundownEvent(e)&&e.args.data){let{isolate:r,scriptId:n,frame:a}=e.args.data,o=t(r,n);o.frame=a,o.ts=e.ts;return}if(b.isV8SourceRundownEvent(e)){let{isolate:r,scriptId:n,url:a,sourceUrl:o,sourceMapUrl:s,sourceMapUrlElided:c}=e.args.data,u=t(r,n);u.url=a,o&&(u.sourceUrl=o),c?u.sourceMapUrlElided=!0:s&&(u.sourceMapUrl=s);return}if(b.isV8SourceRundownSourcesScriptCatchupEvent(e)){let{isolate:r,scriptId:n,sourceText:a}=e.args.data,o=t(r,n);o.content=a;return}
if(b.isV8SourceRundownSourcesLargeScriptCatchupEvent(e)){let{isolate:r,scriptId:n,sourceText:a}=e.args.data,o=t(r,n);o.content=(o.content??"")+a;return}}function Hme(e,t){for(let r of e.frameByProcessId?.values()){let n=r.get(t);if(n)return n}return null}function Gme(e,t){return t.url?e.find(r=>r.args.data.url===t.url)??null:null}function Wme(e){let t=new Map,r=e.mappings();for(let n=0;n<r.length-1;n++){let a=r[n],o=r[n+1];a.lineNumber===o.lineNumber&&t.set(a,o.columnNumber)}return t}function Vme(e){if(!e.sourceMap)throw new Error("expected source map");let t=e.sourceMap,r=e.content??"",n=r.length,a=r.split(`
`),o={},s=n,c=s,u=Wme(e.sourceMap);for(let l of t.mappings()){let m=l.sourceURL,p=l.lineNumber,f=l.columnNumber,h=u.get(l);if(!m)continue;let y=a[p];if(y==null)return{errorMessage:`${t.url()} mapping for line out of bounds: ${p+1}`};if(f>y.length)return{errorMessage:`${t.url()} mapping for column out of bounds: ${p+1}:${f}`};let v=0;if(h!==void 0){if(h>y.length)return{errorMessage:`${t.url()} mapping for last column out of bounds: ${p+1}:${h}`};v=h-f}else v=y.length-f+1;o[m]=(o[m]||0)+v,c-=v}return{files:o,unmappedBytes:c,totalBytes:s}}function $me(e){return e.sourceMap&&!e.sizes&&(e.sizes=Vme(e)),e.sizes??null}function Yme(e,t){if(t.isFreshRecording||!t.metadata?.sourceMaps)return;if(e.sourceMapUrlElided){if(!e.url)return;let n=t.metadata.sourceMaps.find(a=>a.url===e.url);return n?n.sourceMap:void 0}if(!e.sourceMapUrl)return;if(!e.sourceMapUrl.startsWith("data:")){let n=t.metadata.sourceMaps.find(a=>a.sourceMapUrl===e.sourceMapUrl);if(n)return n.sourceMap}}async function Kme(e){let t=Yt(),
r=[...kc().byId.values()],n=new Set;for(let o of t.frameByProcessId.values())for(let s of o.values())n.add(s.url);for(let o of ip.values())o.request=Gme(r,o)??void 0,o.inline=!!o.url&&n.has(o.url);if(!e.resolveSourceMap)return;let a=[];for(let o of ip.values()){if(!o.frame||!o.url||!o.sourceMapUrl&&!o.sourceMapUrlElided)continue;let s=Hme(t,o.frame)?.url;if(!s)continue;let c=o.url;o.sourceUrl&&(c=eB(s,o.sourceUrl)??o.sourceUrl);let u;if(o.sourceMapUrl){if(u=eB(c,o.sourceMapUrl),!u)continue;o.sourceMapUrl=u}let l={scriptId:o.scriptId,scriptUrl:o.url,sourceUrl:c,sourceMapUrl:u??"",frame:o.frame,cachedRawSourceMap:Yme(o,e)},m=e.resolveSourceMap(l).then(p=>{p&&(o.sourceMap=p)});a.push(m.catch(p=>{console.error("Uncaught error when resolving source map",l,p)}))}await Promise.all(a)}function Jme(){return{scripts:[...ip.values()]}}var ip,tB=g(()=>{d();rr();Le();ua();Hm();i(eB,"completeURL");ip=new Map;i(jme,"deps");i(qme,"reset");i(zme,"handleEvent");i(Hme,"findFrame");i(Gme,"findNetworkReque\
st");i(Wme,"computeMappingEndColumns");i(Vme,"computeGeneratedFileSizes");i($me,"getScriptGeneratedSizes");i(Yme,"findCachedRawSourceMap");i(Kme,"finalize");i(Jme,"data")});var ax={};C(ax,{data:()=>epe,finalize:()=>Qme,handleEvent:()=>Zme,reset:()=>Xme});function Xme(){ol=null,il=null,rx.clear(),nx.length=0}function Zme(e){if(b.isStyleRecalcInvalidationTracking(e)&&e.args.data.subtree&&e.args.data.reason===b.StyleRecalcInvalidationReason.RELATED_STYLE_RULE&&il&&e.args.data.nodeId===il.backendNodeId){il.subtree=!0;return}if(b.isSelectorStats(e)&&ol&&e.args.selector_stats){rx.set(ol,{timings:e.args.selector_stats.selector_timings});return}if(b.isStyleInvalidatorInvalidationTracking(e)){let t=new Array;e.args.data.selectors?.forEach(r=>{t.push({selector:r.selector,styleSheetId:r.style_sheet_id})}),t.length>0&&(il={frame:e.args.data.frame,backendNodeId:e.args.data.nodeId,type:b.InvalidationEventType.StyleInvalidatorInvalidationTracking,selectorList:t,ts:e.ts,tts:e.tts,subtree:!1,lastUpdateLayoutTreeEventTs:ol?ol.ts:O.Micro(0)},nx.push(il))}if(b.isUpdateLayoutTree(e)){ol=e;return}}async function Qme(){}function epe(){return{dataForUpdateLayoutEvent:rx,invalidatedNodeList:nx}}
var ol,il,rx,nx,rB=g(()=>{d();Le();ol=null,il=null,rx=new Map,nx=new Array;i(Xme,"reset");i(Zme,"handleEvent");i(Qme,"finalize");i(epe,"data")});var px={};C(px,{LONG_INTERACTION_THRESHOLD:()=>ux,categoryOfInteraction:()=>nB,data:()=>mx,deps:()=>cpe,finalize:()=>spe,handleEvent:()=>ape,removeNestedInteractions:()=>aB,reset:()=>npe,scoreClassificationForInteractionToNextPaint:()=>upe});function npe(){ix.length=0,sx.length=0,cx.length=0,cp.length=0,dx.length=0,lx.clear(),wy.length=0,sp=null}function ape(e){if(b.isBeginCommitCompositorFrame(e)){sx.push(e);return}if(b.isParseMetaViewport(e)){cx.push(e);return}if(!b.isEventTiming(e)||(b.isEventTimingEnd(e)&&lx.set(e.id,e),ix.push(e),!e.args.data||!b.isEventTimingStart(e)))return;let{duration:t,interactionId:r}=e.args.data;t<1||r===void 0||r===0||dx.push(e)}function nB(e){return ope.has(e.type)?"POINTER":ipe.has(e.type)?"KEYBOARD":"OTHER"}function aB(e){let t={POINTER:new Map,KEYBOARD:new Map,OTHER:new Map};function r(a){let o=nB(a),s=t[o],c=O.Micro(a.ts+a.dur),u=s.get(c);if(!u){s.set(c,a);return}if(a.ts<u.ts)s.set(c,a);else if(a.ts===u.ts&&a.interactionId===u.interactionId){let l=u.processingEnd-
u.processingStart;a.processingEnd-a.processingStart>l&&s.set(c,a)}a.processingStart<u.processingStart&&(u.processingStart=a.processingStart,ox(u)),a.processingEnd>u.processingEnd&&(u.processingEnd=a.processingEnd,ox(u))}i(r,"storeEventIfEarliestForCategoryAndEndTime");for(let a of e)r(a);let n=Object.values(t).flatMap(a=>Array.from(a.values()));return n.sort((a,o)=>a.ts-o.ts),n}function ox(e){let t=e.args.data.beginEvent,r=e.args.data.endEvent;e.inputDelay=O.Micro(e.processingStart-t.ts),e.mainThreadHandling=O.Micro(e.processingEnd-e.processingStart),e.presentationDelay=O.Micro(r.ts-e.processingEnd)}async function spe(){let{navigationsByFrameId:e}=Yt();for(let t of dx){let r=lx.get(t.id);if(!r)continue;let{type:n,interactionId:a,timeStamp:o,processingStart:s,processingEnd:c}=t.args.data;if(!n||!a||!o||!s||!c)continue;let u=O.Micro(ae.milliToMicro(s)-ae.milliToMicro(o)+t.ts),l=O.Micro(ae.milliToMicro(c)-ae.milliToMicro(o)+t.ts),m=t.args.frame??t.args.data.frame??"",f=Me.getNavigationForTraceEvent(
t,m,e)?.args.data?.navigationId,h=kr.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:t,cat:t.cat,name:t.name,pid:t.pid,tid:t.tid,ph:t.ph,processingStart:u,processingEnd:l,inputDelay:O.Micro(-1),mainThreadHandling:O.Micro(-1),presentationDelay:O.Micro(-1),args:{data:{beginEvent:t,endEvent:r,frame:m,navigationId:f}},ts:t.ts,dur:O.Micro(r.ts-t.ts),type:t.args.data.type,interactionId:t.args.data.interactionId});ox(h),cp.push(h)}wy.push(...aB(cp));for(let t of wy)(!sp||sp.dur<t.dur)&&(sp=t)}function mx(){return{allEvents:ix,beginCommitCompositorFrameEvents:sx,parseMetaViewportEvents:cx,interactionEvents:cp,interactionEventsWithNoNesting:wy,longestInteractionEvent:sp,interactionsOverThreshold:new Set(cp.filter(e=>e.dur>ux))}}function cpe(){return["Meta"]}function upe(e){return e<=tpe?ir.GOOD:e<=rpe?ir.OK:ir.BAD}var ix,sx,cx,ux,tpe,rpe,sp,cp,wy,lx,dx,ope,ipe,fx=g(()=>{d();ot();Le();ua();tp();ix=[],sx=[],cx=[],ux=ae.milliToMicro(O.Milli(200)),tpe=ux,rpe=ae.milliToMicro(O.Milli(500)),
sp=null,cp=[],wy=[],lx=new Map,dx=[];i(npe,"reset");i(ape,"handleEvent");ope=new Set(["pointerdown","touchstart","pointerup","touchend","mousedown","mouseup","click"]),ipe=new Set(["keydown","keypress","keyup"]);i(nB,"categoryOfInteraction");i(aB,"removeNestedInteractions");i(ox,"writeSyntheticTimespans");i(spe,"finalize");i(mx,"data");i(cpe,"deps");i(upe,"scoreClassificationForInteractionToNextPaint")});var vx={};C(vx,{data:()=>yx,finalize:()=>mpe,handleEvent:()=>dpe,reset:()=>lpe});function lpe(){Ey.length=0,hx.clear(),gx.clear()}function dpe(e){b.isTracingSessionIdForWorker(e)&&Ey.push(e)}async function mpe(){for(let e of Ey)e.args.data&&(hx.set(e.args.data.workerThreadId,e.args.data.workerId),gx.set(e.args.data.workerId,e.args.data.url))}function yx(){return{workerSessionIdEvents:Ey,workerIdByThread:hx,workerURLById:gx}}var Ey,hx,gx,bx=g(()=>{d();Le();Ey=[],hx=new Map,gx=new Map;i(lpe,"reset");i(dpe,"handleEvent");i(mpe,"finalize");i(yx,"data")});var Dx={};C(Dx,{FORCED_REFLOW_THRESHOLD:()=>iB,LONG_MAIN_THREAD_TASK_THRESHOLD:()=>sB,data:()=>vpe,deps:()=>gpe,finalize:()=>ype,handleEvent:()=>fpe,reset:()=>ppe});function ppe(){Dy.clear(),Ty.clear(),wx.length=0,Ex.length=0,up.length=0,xy.length=0}function Sy(e,t){let r=Ne.getWithDefault(Dy,e,()=>[]);r.push(t),Dy.set(e,r);let n=Ne.getWithDefault(Ty,t,()=>[]);n.push(e),Ty.set(t,n)}function fpe(e){if(hpe(e),e.name===b.Name.RUN_TASK){let{duration:t}=ae.eventTimingsMicroSeconds(e);t>sB&&xy.push(e);return}if(b.isFireIdleCallback(e)){let{duration:t}=ae.eventTimingsMilliSeconds(e);t>e.args.data.allottedMilliseconds&&Sy(e,"IDLE_CALLBACK_OVER_TIME");return}}function hpe(e){if(oB(e,wx),oB(e,Ex,b.isJSInvocationEvent(e)),Ex.length&&(e.name===b.Name.LAYOUT||e.name===b.Name.UPDATE_LAYOUT_TREE)){up.push(e);return}wx.length===1&&(up.reduce((r,n)=>r+(n.dur||0),0)>=iB&&up.forEach(r=>Sy(r,"FORCED_REFLOW")),up.length=0)}function oB(e,t,r=!0){let n=t.at(-1);for(;n&&e.ts>n.ts+(n.dur||0);)t.pop(),n=t.at(-1);
r&&t.push(e)}function gpe(){return["UserInteractions","Workers"]}async function ype(){let e=mx().interactionsOverThreshold;for(let t of e)Sy(t,"LONG_INTERACTION");for(let t of xy)t.tid,!yx().workerIdByThread.has(t.tid)&&Sy(t,"LONG_TASK");xy.length=0}function vpe(){return{perEvent:Dy,perWarning:Ty}}var Dy,Ty,wx,Ex,up,xy,iB,sB,cB=g(()=>{d();rr();ot();Le();fx();bx();Dy=new Map,Ty=new Map,wx=[],Ex=[],up=[],xy=[],iB=ae.milliToMicro(O.Milli(30)),sB=ae.milliToMicro(O.Milli(50));i(ppe,"reset");i(Sy,"storeWarning");i(fpe,"handleEvent");i(hpe,"processForcedReflowWarning");i(oB,"accomodateEventInStack");i(gpe,"deps");i(ype,"finalize");i(vpe,"data")});var gr={};C(gr,{AnimationFrames:()=>tD,Animations:()=>aD,AsyncJSCalls:()=>$D,AuctionWorklets:()=>yD,DOMStats:()=>JD,ExtensionTraceData:()=>cT,Flows:()=>dD,Frames:()=>ET,GPU:()=>xT,ImagePainting:()=>kT,Initiators:()=>NT,Invalidations:()=>PT,LargestImagePaint:()=>zT,LargestTextPaint:()=>GT,LayerTree:()=>hT,LayoutShifts:()=>ZT,Memory:()=>QT,Meta:()=>SD,NetworkRequests:()=>RD,PageFrames:()=>ex,PageLoadMetrics:()=>jT,Renderer:()=>qD,Samples:()=>LD,Screenshots:()=>YT,Scripts:()=>tx,SelectorStats:()=>ax,UserInteractions:()=>px,UserTimings:()=>rT,Warnings:()=>Dx,Workers:()=>vx});var uB=g(()=>{d();s4();c4();YD();_1();S4();F4();R1();L4();P4();B4();U4();j4();$4();Y4();gT();X4();Z4();ua();Hm();Q4();tp();z1();PD();KT();tB();rB();fx();nT();cB();bx()});var lB={};var dB=g(()=>{d()});var ln={};C(ln,{Helpers:()=>Ha,ModelHandlers:()=>gr,Threads:()=>_c,Types:()=>lB});var On=g(()=>{d();D1();uB();vT();dB()});var Cy={};C(Cy,{computeScriptDuplication:()=>Tpe,getNodeModuleName:()=>hB,normalizeDuplication:()=>Tx,normalizeSource:()=>fB});function fB(e){e=e.replace(/\?$/,"");let t=e.lastIndexOf("node_modules");return t!==-1&&(e=e.substring(t)),e}function Epe(e){return!!(e.includes("webpack/bootstrap")||e.includes("(webpack)/buildin")||e.includes("external "))}function Tx(e){for(let[t,r]of e){if(r.duplicates.sort((n,a)=>a.attributedSize-n.attributedSize),r.duplicates.length>1){let n=r.duplicates[0].attributedSize;r.duplicates=r.duplicates.filter(a=>a.attributedSize/n>=wpe)}if(r.duplicates=r.duplicates.filter(n=>n.attributedSize>=bpe),r.duplicates.length<=1){e.delete(t);continue}r.estimatedDuplicateBytes=r.duplicates.slice(1).reduce((n,a)=>n+a.attributedSize,0)}}function mB(e,t,r=0){let n=e.indexOf(t,r);return n===-1?e.length:n}function hB(e){let t=e.split("node_modules/");e=t[t.length-1];let r=mB(e,"/");return e[0]==="@"?e.slice(0,mB(e,"/",r+1)):e.slice(0,r)}function Dpe(e){let t=new Map;for(let[
r,n]of e){if(!r.includes("node_modules")){t.set(r,n);continue}let a="node_modules/"+hB(r),o=t.get(a)??{duplicates:[],estimatedDuplicateBytes:0};t.set(a,o);for(let{script:s,attributedSize:c}of n.duplicates){let u=o.duplicates.find(l=>l.script===s);u||(u={script:s,attributedSize:0},o.duplicates.push(u)),u.attributedSize+=c}}return t}function pB(e){return new Map([...e].sort((t,r)=>r[1].estimatedDuplicateBytes-t[1].estimatedDuplicateBytes))}function Tpe(e,t){let r=new Map;for(let o of e.scripts){if(!o.content||!o.sourceMap)continue;let s=gr.Scripts.getScriptGeneratedSizes(o);if(!s)continue;if("errorMessage"in s){console.error(s.errorMessage);continue}let c=[];r.set(o,c);let u=o.sourceMap.sourceURLs();for(let l=0;l<u.length;l++){if(Epe(u[l]))continue;let m=s.files[u[l]];c.push({source:fB(u[l]),resourceSize:m})}}let n=new Map;for(let[o,s]of r)for(let c of s){let u=n.get(c.source);u||(u={estimatedDuplicateBytes:0,duplicates:[]},n.set(c.source,u));let l=o.request?t.get(o.request?.args.data.requestId)??
1:1,m=Math.round(c.resourceSize*l);u.duplicates.push({script:o,attributedSize:m})}let a=Dpe(n);return Tx(n),Tx(a),{duplication:pB(n),duplicationGroupedByNodeModules:pB(a)}}var bpe,wpe,gB=g(()=>{d();On();bpe=1024*.5,wpe=.1;i(fB,"normalizeSource");i(Epe,"shouldIgnoreSource");i(Tx,"normalizeDuplication");i(mB,"indexOfOrLength");i(hB,"getNodeModuleName");i(Dpe,"groupByNodeModules");i(pB,"sorted");i(Tpe,"computeScriptDuplication")});var Iy={};C(Iy,{clearCacheForTrace:()=>xpe,get:()=>Sx,stackTraceForEventInTrace:()=>sl});function xpe(e){sl.delete(e)}function Sx(e,t){let r=sl.get(t);r||(r=new Map,sl.set(t,r));let n=r.get(e);if(n)return n;let a=null;if(ca.isSyntheticExtensionEntry(e))a=Cpe(e,t);else if(b.isPerformanceMeasureBegin(e))a=vB(e,t);else{a=Spe(e,t);let o=Ipe(e).filter(s=>!xx(s));if(!a.callFrames.length)a.callFrames=o;else for(let s=0;s<o.length&&s<a.callFrames.length;s++)a.callFrames[s]=o[s]}return a&&r.set(e,a),a}function Spe(e,t){let r=t.Renderer.entryToNode.size>0?t.Renderer.entryToNode:t.Samples.entryToNode,n={callFrames:[]},a=n,o,s=r.get(e),c=sl.get(t)||new Map;for(sl.set(t,c);s;){if(!b.isProfileCall(s.entry)){let p=t.AsyncJSCalls.runEntryPointToScheduler.get(s.entry);if(!p){s=s.parent;continue}let f=p&&r.get(p.scheduler);f&&(a=yB(a,p.taskName),s=f);continue}o=s.entry;let u=c.get(s.entry);if(u){a.callFrames.push(...u.callFrames.filter(p=>!xx(p))),a.parent=u.parent,a.description=a.description||u.description;
break}xx(o.callFrame)||a.callFrames.push(o.callFrame);let l=t.AsyncJSCalls.asyncCallToScheduler.get(o),m=l&&r.get(l.scheduler);if(m){a=yB(a,l.taskName),s=m;continue}s=s.parent}return n}function yB(e,t){let r={callFrames:[]};return e.parent=r,r.description=t,r}function Cpe(e,t){let r=e.rawSourceEvent;return b.isPerformanceMeasureBegin(r)?vB(r,t):r?Sx(r,t):null}function vB(e,t){let r=e;return e.args.traceId===void 0||(r=t.UserTimings.measureTraceByTraceId.get(e.args.traceId),!r)?null:Sx(r,t)}function xx({columnNumber:e,lineNumber:t,url:r,scriptId:n}){return t===-1&&e===-1&&r===""&&n==="0"}function Ipe(e){let t=Me.getZeroIndexedStackTraceInEventPayload(e)||[],r=[];for(let n of t)r.push({...n,scriptId:String(n.scriptId)});return r}var sl,bB=g(()=>{d();ot();Le();sl=new Map;i(xpe,"clearCacheForTrace");i(Sx,"get");i(Spe,"getForEvent");i(yB,"addAsyncParentToStack");i(Cpe,"getForExtensionEntry");i(vB,"getForPerformanceMeasure");i(xx,"isNativeJSFunction");i(Ipe,"getTraceEventPayloadStackAsProtoc\
olCallFrame")});var ky,Ry,_y,Cx=g(()=>{d();Le();ky=class{static{i(this,"TraceFilter")}},Ry=class e extends ky{static{i(this,"VisibleEventsFilter")}visibleTypes;constructor(t){super(),this.visibleTypes=new Set(t)}accept(t){return ca.isSyntheticExtensionEntry(t)?!0:this.visibleTypes.has(e.eventType(t))}static eventType(t){return t.cat.includes("blink.console")?b.Name.CONSOLE_TIME:t.cat.includes("blink.user_timing")?b.Name.USER_TIMING:t.name}},_y=class extends ky{static{i(this,"ExclusiveNameFilter")}#e;constructor(t){super(),this.#e=new Set(t)}accept(t){return!this.#e.has(t.name)}}});function Ay(e){if(b.isProfileCall(e)){let t=cs.isNativeRuntimeFrame(e.callFrame)?cs.nativeGroup(e.callFrame.functionName):e.callFrame.functionName,r=e.callFrame.scriptId||e.callFrame.url||"";return`f:${t}@${r}`}return b.isConsoleTimeStamp(e)&&e.args.data?`${e.name}:${e.args.data.name}`:b.isSyntheticNetworkRequest(e)||b.isReceivedDataEvent(e)?`req:${e.args.data.requestId}`:e.name}var lp,Fy,Ix,My,kx=g(()=>{d();ot();JE();Le();lp=class{static{i(this,"Node")}totalTime;selfTime;transferSize;id;event;events;parent;groupId;isGroupNodeInternal;depth;constructor(t,r){this.totalTime=0,this.selfTime=0,this.transferSize=0,this.id=t,this.event=r,this.events=[r],this.groupId="",this.isGroupNodeInternal=!1,this.depth=0}isGroupNode(){return this.isGroupNodeInternal}hasChildren(){throw new Error("Not implemented")}setHasChildren(t){throw new Error("Not implemented")}children(){throw new Error("Not implemented")}searchTree(t,r){r=r||[],this.event&&t(this.event)&&r.push(this);for(let n of this.children().
values())n.searchTree(t,r);return r}},Fy=class extends lp{static{i(this,"BottomUpRootNode")}childrenInternal;textFilter;filter;startTime;endTime;totalTime;eventGroupIdCallback;calculateTransferSize;forceGroupIdCallback;constructor(t,{textFilter:r,filters:n,startTime:a,endTime:o,eventGroupIdCallback:s,calculateTransferSize:c,forceGroupIdCallback:u}){super("",t[0]),this.childrenInternal=null,this.events=t,this.textFilter=r,this.filter=l=>n.every(m=>m.accept(l)),this.startTime=a,this.endTime=o,this.eventGroupIdCallback=s,this.totalTime=o-a,this.calculateTransferSize=c,this.forceGroupIdCallback=u}hasChildren(){return!0}filterChildren(t){for(let[r,n]of t)n.event&&n.depth<=1&&!this.textFilter.accept(n.event)&&t.delete(r);return t}children(){return this.childrenInternal||(this.childrenInternal=this.filterChildren(this.grouppedTopNodes())),this.childrenInternal}ungroupedTopNodes(){let t=this,r=this.startTime,n=this.endTime,a=new Map,o=[n-r],s=[],c=new Map,u=this.eventGroupIdCallback,l=this.forceGroupIdCallback,
m=i(h=>{if(b.isReceivedDataEvent(h)){let y=Ay(h);this.forceGroupIdCallback&&this.eventGroupIdCallback&&(y=`${y}-${this.eventGroupIdCallback(h)}`);let v=a.get(y);v?v.events.push(h):(v=new My(t,y,h,!1,t),a.set(y,v)),h.name==="ResourceReceivedData"?v.transferSize+=h.args.data.encodedDataLength:h.args.data.encodedDataLength>0&&(v.transferSize=h.args.data.encodedDataLength)}},"sumTransferSizeOfInstantEvent");Me.forEachEvent(this.events,{onStartEvent:p,onEndEvent:f,onInstantEvent:this.calculateTransferSize?m:void 0,startTime:ae.milliToMicro(this.startTime),endTime:ae.milliToMicro(this.endTime),eventFilter:this.filter,ignoreAsyncEvents:!1});function p(h){let{startTime:y,endTime:v}=ae.eventTimingsMilliSeconds(h),T=(v!==void 0?Math.min(v,n):n)-Math.max(y,r);o[o.length-1]-=T,o.push(T);let x=Ay(h);l&&u&&(x=`${x}-${u(h)}`);let S=!c.has(x);S&&c.set(x,T),s.push(S)}i(p,"onStartEvent");function f(h){let y=Ay(h);l&&u&&(y=`${y}-${u(h)}`);let v=a.get(y);v?v.events.push(h):(v=new My(t,y,h,!1,t),a.set(y,v)),
v.selfTime+=o.pop()||0,s.pop()&&(v.totalTime+=c.get(y)||0,c.delete(y)),s.length&&v.setHasChildren(!0)}i(f,"onEndEvent"),this.selfTime=o.pop()||0;for(let h of a)h[1].selfTime<=0&&(!this.calculateTransferSize||h[1].transferSize<=0)&&a.delete(h[0]);return a}grouppedTopNodes(){let t=this.ungroupedTopNodes();if(!this.eventGroupIdCallback)return t;let r=new Map;for(let n of t.values()){let a=this.eventGroupIdCallback(n.event),o=r.get(a);if(!o)o=new Ix(a,this,n.events),r.set(a,o);else for(let s of n.events)o.events.push(s);o.addChild(n,n.selfTime,n.selfTime,n.transferSize)}return r}},Ix=class extends lp{static{i(this,"GroupNode")}childrenInternal;isGroupNodeInternal;events;constructor(t,r,n){super(t,n[0]),this.events=n,this.childrenInternal=new Map,this.parent=r,this.isGroupNodeInternal=!0}addChild(t,r,n,a){this.childrenInternal.set(t.id,t),this.selfTime+=r,this.totalTime+=n,this.transferSize+=a,t.parent=this}hasChildren(){return!0}children(){return this.childrenInternal}},My=class e extends lp{static{
i(this,"BottomUpNode")}parent;root;depth;cachedChildren;hasChildrenInternal;constructor(t,r,n,a,o){super(r,n),this.parent=o,this.root=t,this.depth=(o.depth||0)+1,this.cachedChildren=null,this.hasChildrenInternal=a}hasChildren(){return this.hasChildrenInternal}setHasChildren(t){this.hasChildrenInternal=t}children(){if(this.cachedChildren)return this.cachedChildren;let t=[0],r=[],n=[],a=new Map,o=this.root.startTime,s=this.root.endTime,c=o,u=this;Me.forEachEvent(this.root.events,{onStartEvent:l,onEndEvent:m,startTime:ae.milliToMicro(o),endTime:ae.milliToMicro(s),eventFilter:this.root.filter,ignoreAsyncEvents:!1});function l(p){let{startTime:f,endTime:h}=ae.eventTimingsMilliSeconds(p),v=(h!==void 0?Math.min(h,s):s)-Math.max(f,o);v<0&&console.assert(!1,"Negative duration of an event"),t[t.length-1]-=v,t.push(v);let E=Ay(p);r.push(E),n.push(p)}i(l,"onStartEvent");function m(p){let{startTime:f,endTime:h}=ae.eventTimingsMilliSeconds(p),y=t.pop(),v=r.pop();n.pop();let E;for(E=u;E.depth>1;E=E.parent)
if(E.id!==r[r.length+1-E.depth])return;if(E.id!==v||r.length<u.depth)return;let T=r[r.length-u.depth];if(E=a.get(T),E)E.events.push(p);else{let I=n[n.length-u.depth],F=n.length>u.depth;E=new e(u.root,T,I,F,u),a.set(T,E)}let x=h!==void 0?Math.min(h,s):s,S=x-Math.max(f,c);E.selfTime+=y||0,E.totalTime+=S,c=x}return i(m,"onEndEvent"),this.cachedChildren=this.root.filterChildren(a),this.cachedChildren}searchTree(t,r){return r=r||[],this.event&&t(this.event)&&r.push(this),r}};i(Ay,"generateEventID")});var Oy={};C(Oy,{summarizeByThirdParty:()=>kpe,summarizeByURL:()=>Rx});function DB(e){let t=e.Renderer.processes.values().find(r=>{let n=r.url??"";return r.isOnMainFrame&&!n.startsWith("about:")&&!n.startsWith("chrome:")})?.threads.values().find(r=>r.name==="CrRendererMain");return t?t.entries:[]}function kpe(e,t){let r=DB(e).sort(Me.eventTimeComparator),a=TB(r,t,i(s=>e.Renderer.entityMappings.entityByEvent.get(s)?.name??"","groupingFunction"));return Rpe(a,e)}function Rx(e,t){let r=DB(e).sort(Me.eventTimeComparator),a=TB(r,t,i(s=>Ha.getNonResolvedURL(s,e)??"","groupingFunction"));return _pe(a,e)}function Rpe(e,t){let r=[],n=[...e.children().values()].flat();for(let a of n){if(a.id==="")continue;let o=t.Renderer.entityMappings.entityByEvent.get(a.event);if(!o)continue;let s={transferSize:a.transferSize,mainThreadTime:O.Milli(a.selfTime),entity:o,relatedEvents:t.Renderer.entityMappings.eventsByEntity.get(o)??[]};r.push(s)}return r}function _pe(e,t){let r=[],n=t.NetworkRequests.byTime,a=[
...e.children().values()].flat();for(let o of a){if(o.id===""||typeof o.id!="string")continue;let s=t.Renderer.entityMappings.entityByEvent.get(o.event);if(!s)continue;let c=o.id,l={request:n.find(m=>m.args.data.url===c),url:c,entity:s,transferSize:o.transferSize,mainThreadTime:O.Milli(o.selfTime)};r.push(l)}return r}function TB(e,t,r){let n=Me.VISIBLE_TRACE_EVENT_TYPES.values().toArray(),a=new Ry(n.concat([b.Name.SYNTHETIC_NETWORK_REQUEST])),o=ae.microToMilli(t.min),s=ae.microToMilli(t.max);return new Fy(e,{textFilter:new _y([]),filters:[a],startTime:o,endTime:s,eventGroupIdCallback:r,calculateTransferSize:!0,forceGroupIdCallback:!0})}var _x=g(()=>{d();On();ot();Le();Cx();kx();i(DB,"collectMainThreadActivity");i(kpe,"summarizeByThirdParty");i(Rx,"summarizeByURL");i(Rpe,"summarizeBottomUpByEntity");i(_pe,"summarizeBottomUpByURL");i(TB,"getBottomUpTree")});var dp=g(()=>{d();gB();bB();_x();Cx();kx();(()=>{var e=Object.getOwnPropertyNames,t=i((ne,_)=>i(function(){return _||(0,ne[e(ne)[0]])((_={exports:{}}).exports,_),_.exports},"__require"),"__commonJS"),r=t({"node_modules/object-keys/isArguments.js"(ne,_){"use strict";var k=Object.prototype.toString;_.exports=i(function(M){var U=k.call(M),N=U==="[object Arguments]";return N||(N=U!=="[object Array]"&&M!==null&&typeof M=="object"&&typeof M.length=="number"&&M.length>=0&&k.call(M.callee)==="[object Function]"),N},"isArguments")}}),n=t({"node_modules/object-keys/implementation.js"(ne,_){"use strict";var k;Object.keys||(A=Object.prototype.hasOwnProperty,M=Object.prototype.toString,U=r(),N=Object.prototype.propertyIsEnumerable,z=!N.call({toString:null},"toString"),B=N.call(function(){},"prototype"),j=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],$=i(function(te){var de=te.constructor;return de&&de.prototype===te},"equalsConstructor\
Prototype"),V={$applicationCache:!0,$console:!0,$external:!0,$frame:!0,$frameElement:!0,$frames:!0,$innerHeight:!0,$innerWidth:!0,$onmozfullscreenchange:!0,$onmozfullscreenerror:!0,$outerHeight:!0,$outerWidth:!0,$pageXOffset:!0,$pageYOffset:!0,$parent:!0,$scrollLeft:!0,$scrollTop:!0,$scrollX:!0,$scrollY:!0,$self:!0,$webkitIndexedDB:!0,$webkitStorageInfo:!0,$window:!0},K=(function(){if(typeof window>"u")return!1;for(var te in window)try{if(!V["$"+te]&&A.call(window,te)&&window[te]!==null&&typeof window[te]=="object")try{$(window[te])}catch{return!0}}catch{return!0}return!1})(),re=i(function(te){if(typeof window>"u"||!K)return $(te);try{return $(te)}catch{return!1}},"equalsConstructorPrototypeIfNotBuggy"),k=i(function(de){var Ie=de!==null&&typeof de=="object",mt=M.call(de)==="[object Function]",er=U(de),Pt=Ie&&M.call(de)==="[object String]",bt=[];if(!Ie&&!mt&&!er)throw new TypeError("Object.keys called on a non-object");var $e=B&&mt;if(Pt&&de.length>0&&!A.call(de,0))for(var Jt=0;Jt<de.length;++Jt)
bt.push(String(Jt));if(er&&de.length>0)for(var Tr=0;Tr<de.length;++Tr)bt.push(String(Tr));else for(var Fr in de)!($e&&Fr==="prototype")&&A.call(de,Fr)&&bt.push(String(Fr));if(z)for(var Xt=re(de),mr=0;mr<j.length;++mr)!(Xt&&j[mr]==="constructor")&&A.call(de,j[mr])&&bt.push(j[mr]);return bt},"keys"));var A,M,U,N,z,B,j,$,V,K,re;_.exports=k}}),a=t({"node_modules/object-keys/index.js"(ne,_){"use strict";var k=Array.prototype.slice,A=r(),M=Object.keys,U=M?i(function(B){return M(B)},"keys"):n(),N=Object.keys;U.shim=i(function(){if(Object.keys){var B=(function(){var j=Object.keys(arguments);return j&&j.length===arguments.length})(1,2);B||(Object.keys=i(function($){return A($)?N(k.call($)):N($)},"keys"))}else Object.keys=U;return Object.keys||U},"shimObjectKeys"),_.exports=U}}),o=t({"node_modules/es-define-property/index.js"(ne,_){"use strict";var k=Object.defineProperty||!1;if(k)try{k({},"a",{value:1})}catch{k=!1}_.exports=k}}),s=t({"node_modules/es-errors/syntax.js"(ne,_){"use strict";_.exports=
SyntaxError}}),c=t({"node_modules/es-errors/type.js"(ne,_){"use strict";_.exports=TypeError}}),u=t({"node_modules/gopd/gOPD.js"(ne,_){"use strict";_.exports=Object.getOwnPropertyDescriptor}}),l=t({"node_modules/gopd/index.js"(ne,_){"use strict";var k=u();if(k)try{k([],"length")}catch{k=null}_.exports=k}}),m=t({"node_modules/define-data-property/index.js"(ne,_){"use strict";var k=o(),A=s(),M=c(),U=l();_.exports=i(function(z,B,j){if(!z||typeof z!="object"&&typeof z!="function")throw new M("`obj` must be an object or a function`");if(typeof B!="string"&&typeof B!="symbol")throw new M("`property` must be a string or a symbol`");if(arguments.length>3&&typeof arguments[3]!="boolean"&&arguments[3]!==null)throw new M("`nonEnumerable`, if provided, must be a boolean or null");if(arguments.length>4&&typeof arguments[4]!="boolean"&&arguments[4]!==null)throw new M("`nonWritable`, if provided, must be a boolean or null");if(arguments.length>5&&typeof arguments[5]!="boolean"&&arguments[5]!==null)throw new M(
"`nonConfigurable`, if provided, must be a boolean or null");if(arguments.length>6&&typeof arguments[6]!="boolean")throw new M("`loose`, if provided, must be a boolean");var $=arguments.length>3?arguments[3]:null,V=arguments.length>4?arguments[4]:null,K=arguments.length>5?arguments[5]:null,re=arguments.length>6?arguments[6]:!1,te=!!U&&U(z,B);if(k)k(z,B,{configurable:K===null&&te?te.configurable:!K,enumerable:$===null&&te?te.enumerable:!$,value:j,writable:V===null&&te?te.writable:!V});else if(re||!$&&!V&&!K)z[B]=j;else throw new A("This environment does not support defining a property as non-configurable, non-writable, or non-enumerable.")},"defineDataProperty")}}),p=t({"node_modules/has-property-descriptors/index.js"(ne,_){"use strict";var k=o(),A=i(function(){return!!k},"hasPropertyDescriptors2");A.hasArrayLengthDefineBug=i(function(){if(!k)return null;try{return k([],"length",{value:1}).length!==1}catch{return!0}},"hasArrayLengthDefineBug"),_.exports=A}}),f=t({"node_modules/define-pr\
operties/index.js"(ne,_){"use strict";var k=a(),A=typeof Symbol=="function"&&typeof Symbol("foo")=="symbol",M=Object.prototype.toString,U=Array.prototype.concat,N=m(),z=i(function(V){return typeof V=="function"&&M.call(V)==="[object Function]"},"isFunction"),B=p()(),j=i(function(V,K,re,te){if(K in V){if(te===!0){if(V[K]===re)return}else if(!z(te)||!te())return}B?N(V,K,re,!0):N(V,K,re)},"defineProperty"),$=i(function(V,K){var re=arguments.length>2?arguments[2]:{},te=k(K);A&&(te=U.call(te,Object.getOwnPropertySymbols(K)));for(var de=0;de<te.length;de+=1)j(V,te[de],K[te[de]],re[te[de]])},"defineProperties");$.supportsDescriptors=!!B,_.exports=$}}),h=t({"node_modules/es-object-atoms/index.js"(ne,_){"use strict";_.exports=Object}}),y=t({"node_modules/es-errors/index.js"(ne,_){"use strict";_.exports=Error}}),v=t({"node_modules/es-errors/eval.js"(ne,_){"use strict";_.exports=EvalError}}),E=t({"node_modules/es-errors/range.js"(ne,_){"use strict";_.exports=RangeError}}),T=t({"node_modules/es-er\
rors/ref.js"(ne,_){"use strict";_.exports=ReferenceError}}),x=t({"node_modules/es-errors/uri.js"(ne,_){"use strict";_.exports=URIError}}),S=t({"node_modules/math-intrinsics/abs.js"(ne,_){"use strict";_.exports=Math.abs}}),I=t({"node_modules/math-intrinsics/floor.js"(ne,_){"use strict";_.exports=Math.floor}}),F=t({"node_modules/math-intrinsics/max.js"(ne,_){"use strict";_.exports=Math.max}}),W=t({"node_modules/math-intrinsics/min.js"(ne,_){"use strict";_.exports=Math.min}}),H=t({"node_modules/math-intrinsics/pow.js"(ne,_){"use strict";_.exports=Math.pow}}),se=t({"node_modules/math-intrinsics/round.js"(ne,_){"use strict";_.exports=Math.round}}),me=t({"node_modules/math-intrinsics/isNaN.js"(ne,_){"use strict";_.exports=Number.isNaN||i(function(A){return A!==A},"isNaN2")}}),Ee=t({"node_modules/math-intrinsics/sign.js"(ne,_){"use strict";var k=me();_.exports=i(function(M){return k(M)||M===0?M:M<0?-1:1},"sign")}}),Pe=t({"node_modules/has-symbols/shams.js"(ne,_){"use strict";_.exports=i(function(){
if(typeof Symbol!="function"||typeof Object.getOwnPropertySymbols!="function")return!1;if(typeof Symbol.iterator=="symbol")return!0;var A={},M=Symbol("test"),U=Object(M);if(typeof M=="string"||Object.prototype.toString.call(M)!=="[object Symbol]"||Object.prototype.toString.call(U)!=="[object Symbol]")return!1;var N=42;A[M]=N;for(var z in A)return!1;if(typeof Object.keys=="function"&&Object.keys(A).length!==0||typeof Object.getOwnPropertyNames=="function"&&Object.getOwnPropertyNames(A).length!==0)return!1;var B=Object.getOwnPropertySymbols(A);if(B.length!==1||B[0]!==M||!Object.prototype.propertyIsEnumerable.call(A,M))return!1;if(typeof Object.getOwnPropertyDescriptor=="function"){var j=Object.getOwnPropertyDescriptor(A,M);if(j.value!==N||j.enumerable!==!0)return!1}return!0},"hasSymbols")}}),De=t({"node_modules/has-symbols/index.js"(ne,_){"use strict";var k=typeof Symbol<"u"&&Symbol,A=Pe();_.exports=i(function(){return typeof k!="function"||typeof Symbol!="function"||typeof k("foo")!="sy\
mbol"||typeof Symbol("bar")!="symbol"?!1:A()},"hasNativeSymbols")}}),we=t({"node_modules/get-proto/Reflect.getPrototypeOf.js"(ne,_){"use strict";_.exports=typeof Reflect<"u"&&Reflect.getPrototypeOf||null}}),xt=t({"node_modules/get-proto/Object.getPrototypeOf.js"(ne,_){"use strict";var k=h();_.exports=k.getPrototypeOf||null}}),Oe=t({"node_modules/function-bind/implementation.js"(ne,_){"use strict";var k="Function.prototype.bind called on incompatible ",A=Object.prototype.toString,M=Math.max,U="[object Function]",N=i(function($,V){for(var K=[],re=0;re<$.length;re+=1)K[re]=$[re];for(var te=0;te<V.length;te+=1)K[te+$.length]=V[te];return K},"concatty2"),z=i(function($,V){for(var K=[],re=V||0,te=0;re<$.length;re+=1,te+=1)K[te]=$[re];return K},"slicy2"),B=i(function(j,$){for(var V="",K=0;K<j.length;K+=1)V+=j[K],K+1<j.length&&(V+=$);return V},"joiny");_.exports=i(function($){var V=this;if(typeof V!="function"||A.apply(V)!==U)throw new TypeError(k+V);for(var K=z(arguments,1),re,te=i(function(){
if(this instanceof re){var Pt=V.apply(this,N(K,arguments));return Object(Pt)===Pt?Pt:this}return V.apply($,N(K,arguments))},"binder"),de=M(0,V.length-K.length),Ie=[],mt=0;mt<de;mt++)Ie[mt]="$"+mt;if(re=Function("binder","return function ("+B(Ie,",")+"){ return binder.apply(this,arguments); }")(te),V.prototype){var er=i(function(){},"Empty2");er.prototype=V.prototype,re.prototype=new er,er.prototype=null}return re},"bind")}}),He=t({"node_modules/function-bind/index.js"(ne,_){"use strict";var k=Oe();_.exports=Function.prototype.bind||k}}),qt=t({"node_modules/call-bind-apply-helpers/functionCall.js"(ne,_){"use strict";_.exports=Function.prototype.call}}),yt=t({"node_modules/call-bind-apply-helpers/functionApply.js"(ne,_){"use strict";_.exports=Function.prototype.apply}}),Ze=t({"node_modules/call-bind-apply-helpers/reflectApply.js"(ne,_){"use strict";_.exports=typeof Reflect<"u"&&Reflect&&Reflect.apply}}),Qt=t({"node_modules/call-bind-apply-helpers/actualApply.js"(ne,_){"use strict";var k=He(),
A=yt(),M=qt(),U=Ze();_.exports=U||k.call(M,A)}}),St=t({"node_modules/call-bind-apply-helpers/index.js"(ne,_){"use strict";var k=He(),A=c(),M=qt(),U=Qt();_.exports=i(function(z){if(z.length<1||typeof z[0]!="function")throw new A("a function is required");return U(k,M,z)},"callBindBasic")}}),vt=t({"node_modules/dunder-proto/get.js"(ne,_){"use strict";var k=St(),A=l(),M;try{M=[].__proto__===Array.prototype}catch(B){if(!B||typeof B!="object"||!("code"in B)||B.code!=="ERR_PROTO_ACCESS")throw B}var U=!!M&&A&&A(Object.prototype,"__proto__"),N=Object,z=N.getPrototypeOf;_.exports=U&&typeof U.get=="function"?k([U.get]):typeof z=="function"?i((function(j){return z(j==null?j:N(j))}),"getDunder"):!1}}),nt=t({"node_modules/get-proto/index.js"(ne,_){"use strict";var k=we(),A=xt(),M=vt();_.exports=k?i(function(N){return k(N)},"getProto"):A?i(function(N){if(!N||typeof N!="object"&&typeof N!="function")throw new TypeError("getProto: not an object");return A(N)},"getProto"):M?i(function(N){return M(N)},"\
getProto"):null}}),Q=t({"node_modules/hasown/index.js"(ne,_){"use strict";var k=Function.prototype.call,A=Object.prototype.hasOwnProperty,M=He();_.exports=M.call(k,A)}}),xe=t({"node_modules/get-intrinsic/index.js"(ne,_){"use strict";var k,A=h(),M=y(),U=v(),N=E(),z=T(),B=s(),j=c(),$=x(),V=S(),K=I(),re=F(),te=W(),de=H(),Ie=se(),mt=Ee(),er=Function,Pt=i(function(na){try{return er('"use strict"; return ('+na+").constructor;")()}catch{}},"getEvalledConstructor"),bt=l(),$e=o(),Jt=i(function(){throw new j},"throwTypeError"),Tr=bt?(function(){try{return arguments.callee,Jt}catch{try{return bt(arguments,"callee").get}catch{return Jt}}})():Jt,Fr=De()(),Xt=nt(),mr=xt(),_d=we(),Fi=yt(),ra=qt(),ao={},Ad=typeof Uint8Array>"u"||!Xt?k:Xt(Uint8Array),Hn={__proto__:null,"%AggregateError%":typeof AggregateError>"u"?k:AggregateError,"%Array%":Array,"%ArrayBuffer%":typeof ArrayBuffer>"u"?k:ArrayBuffer,"%ArrayIteratorPrototype%":Fr&&Xt?Xt([][Symbol.iterator]()):k,"%AsyncFromSyncIteratorPrototype%":k,"%Async\
Function%":ao,"%AsyncGenerator%":ao,"%AsyncGeneratorFunction%":ao,"%AsyncIteratorPrototype%":ao,"%Atomics%":typeof Atomics>"u"?k:Atomics,"%BigInt%":typeof BigInt>"u"?k:BigInt,"%BigInt64Array%":typeof BigInt64Array>"u"?k:BigInt64Array,"%BigUint64Array%":typeof BigUint64Array>"u"?k:BigUint64Array,"%Boolean%":Boolean,"%DataView%":typeof DataView>"u"?k:DataView,"%Date%":Date,"%decodeURI%":decodeURI,"%decodeURIComponent%":decodeURIComponent,"%encodeURI%":encodeURI,"%encodeURIComponent%":encodeURIComponent,"%Error%":M,"%eval%":eval,"%EvalError%":U,"%Float16Array%":typeof Float16Array>"u"?k:Float16Array,"%Float32Array%":typeof Float32Array>"u"?k:Float32Array,"%Float64Array%":typeof Float64Array>"u"?k:Float64Array,"%FinalizationRegistry%":typeof FinalizationRegistry>"u"?k:FinalizationRegistry,"%Function%":er,"%GeneratorFunction%":ao,"%Int8Array%":typeof Int8Array>"u"?k:Int8Array,"%Int16Array%":typeof Int16Array>"u"?k:Int16Array,"%Int32Array%":typeof Int32Array>"u"?k:Int32Array,"%isFinite%":isFinite,
"%isNaN%":isNaN,"%IteratorPrototype%":Fr&&Xt?Xt(Xt([][Symbol.iterator]())):k,"%JSON%":typeof JSON=="object"?JSON:k,"%Map%":typeof Map>"u"?k:Map,"%MapIteratorPrototype%":typeof Map>"u"||!Fr||!Xt?k:Xt(new Map()[Symbol.iterator]()),"%Math%":Math,"%Number%":Number,"%Object%":A,"%Object.getOwnPropertyDescriptor%":bt,"%parseFloat%":parseFloat,"%parseInt%":parseInt,"%Promise%":typeof Promise>"u"?k:Promise,"%Proxy%":typeof Proxy>"u"?k:Proxy,"%RangeError%":N,"%ReferenceError%":z,"%Reflect%":typeof Reflect>"u"?k:Reflect,"%RegExp%":RegExp,"%Set%":typeof Set>"u"?k:Set,"%SetIteratorPrototype%":typeof Set>"u"||!Fr||!Xt?k:Xt(new Set()[Symbol.iterator]()),"%SharedArrayBuffer%":typeof SharedArrayBuffer>"u"?k:SharedArrayBuffer,"%String%":String,"%StringIteratorPrototype%":Fr&&Xt?Xt(""[Symbol.iterator]()):k,"%Symbol%":Fr?Symbol:k,"%SyntaxError%":B,"%ThrowTypeError%":Tr,"%TypedArray%":Ad,"%TypeError%":j,"%Uint8Array%":typeof Uint8Array>"u"?k:Uint8Array,"%Uint8ClampedArray%":typeof Uint8ClampedArray>"u"?k:
Uint8ClampedArray,"%Uint16Array%":typeof Uint16Array>"u"?k:Uint16Array,"%Uint32Array%":typeof Uint32Array>"u"?k:Uint32Array,"%URIError%":$,"%WeakMap%":typeof WeakMap>"u"?k:WeakMap,"%WeakRef%":typeof WeakRef>"u"?k:WeakRef,"%WeakSet%":typeof WeakSet>"u"?k:WeakSet,"%Function.prototype.call%":ra,"%Function.prototype.apply%":Fi,"%Object.defineProperty%":$e,"%Object.getPrototypeOf%":mr,"%Math.abs%":V,"%Math.floor%":K,"%Math.max%":re,"%Math.min%":te,"%Math.pow%":de,"%Math.round%":Ie,"%Math.sign%":mt,"%Reflect.getPrototypeOf%":_d};if(Xt)try{null.error}catch(na){Mi=Xt(Xt(na)),Hn["%Error.prototype%"]=Mi}var Mi,Jh=i(function na(pr){var Yr;if(pr==="%AsyncFunction%")Yr=Pt("async function () {}");else if(pr==="%GeneratorFunction%")Yr=Pt("function* () {}");else if(pr==="%AsyncGeneratorFunction%")Yr=Pt("async function* () {}");else if(pr==="%AsyncGenerator%"){var xr=na("%AsyncGeneratorFunction%");xr&&(Yr=xr.prototype)}else if(pr==="%AsyncIteratorPrototype%"){var on=na("%AsyncGenerator%");on&&Xt&&(Yr=Xt(
on.prototype))}return Hn[pr]=Yr,Yr},"doEval2"),Fd={__proto__:null,"%ArrayBufferPrototype%":["ArrayBuffer","prototype"],"%ArrayPrototype%":["Array","prototype"],"%ArrayProto_entries%":["Array","prototype","entries"],"%ArrayProto_forEach%":["Array","prototype","forEach"],"%ArrayProto_keys%":["Array","prototype","keys"],"%ArrayProto_values%":["Array","prototype","values"],"%AsyncFunctionPrototype%":["AsyncFunction","prototype"],"%AsyncGenerator%":["AsyncGeneratorFunction","prototype"],"%AsyncGeneratorPrototype%":["AsyncGeneratorFunction","prototype","prototype"],"%BooleanPrototype%":["Boolean","prototype"],"%DataViewPrototype%":["DataView","prototype"],"%DatePrototype%":["Date","prototype"],"%ErrorPrototype%":["Error","prototype"],"%EvalErrorPrototype%":["EvalError","prototype"],"%Float32ArrayPrototype%":["Float32Array","prototype"],"%Float64ArrayPrototype%":["Float64Array","prototype"],"%FunctionPrototype%":["Function","prototype"],"%Generator%":["GeneratorFunction","prototype"],"%Genera\
torPrototype%":["GeneratorFunction","prototype","prototype"],"%Int8ArrayPrototype%":["Int8Array","prototype"],"%Int16ArrayPrototype%":["Int16Array","prototype"],"%Int32ArrayPrototype%":["Int32Array","prototype"],"%JSONParse%":["JSON","parse"],"%JSONStringify%":["JSON","stringify"],"%MapPrototype%":["Map","prototype"],"%NumberPrototype%":["Number","prototype"],"%ObjectPrototype%":["Object","prototype"],"%ObjProto_toString%":["Object","prototype","toString"],"%ObjProto_valueOf%":["Object","prototype","valueOf"],"%PromisePrototype%":["Promise","prototype"],"%PromiseProto_then%":["Promise","prototype","then"],"%Promise_all%":["Promise","all"],"%Promise_reject%":["Promise","reject"],"%Promise_resolve%":["Promise","resolve"],"%RangeErrorPrototype%":["RangeError","prototype"],"%ReferenceErrorPrototype%":["ReferenceError","prototype"],"%RegExpPrototype%":["RegExp","prototype"],"%SetPrototype%":["Set","prototype"],"%SharedArrayBufferPrototype%":["SharedArrayBuffer","prototype"],"%StringPrototyp\
e%":["String","prototype"],"%SymbolPrototype%":["Symbol","prototype"],"%SyntaxErrorPrototype%":["SyntaxError","prototype"],"%TypedArrayPrototype%":["TypedArray","prototype"],"%TypeErrorPrototype%":["TypeError","prototype"],"%Uint8ArrayPrototype%":["Uint8Array","prototype"],"%Uint8ClampedArrayPrototype%":["Uint8ClampedArray","prototype"],"%Uint16ArrayPrototype%":["Uint16Array","prototype"],"%Uint32ArrayPrototype%":["Uint32Array","prototype"],"%URIErrorPrototype%":["URIError","prototype"],"%WeakMapPrototype%":["WeakMap","prototype"],"%WeakSetPrototype%":["WeakSet","prototype"]},Oi=He(),Ni=Q(),Xh=Oi.call(ra,Array.prototype.concat),Zh=Oi.call(Fi,Array.prototype.splice),Md=Oi.call(ra,String.prototype.replace),lu=Oi.call(ra,String.prototype.slice),Qh=Oi.call(ra,RegExp.prototype.exec),Bb=/[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g,Bo=/\\(\\)?/g,Od=i(function(pr){var Yr=lu(pr,0,1),xr=lu(pr,-1);if(Yr==="%"&&xr!=="%")throw new B("invalid i\
ntrinsic syntax, expected closing `%`");if(xr==="%"&&Yr!=="%")throw new B("invalid intrinsic syntax, expected opening `%`");var on=[];return Md(pr,Bb,function(aa,Li,fn,Gn){on[on.length]=fn?Md(Gn,Bo,"$1"):Li||aa}),on},"stringToPath2"),Ub=i(function(pr,Yr){var xr=pr,on;if(Ni(Fd,xr)&&(on=Fd[xr],xr="%"+on[0]+"%"),Ni(Hn,xr)){var aa=Hn[xr];if(aa===ao&&(aa=Jh(xr)),typeof aa>"u"&&!Yr)throw new j("intrinsic "+pr+" exists, but is not available. Please file an issue!");return{alias:on,name:xr,value:aa}}throw new B("intrinsic "+pr+" does not exist!")},"getBaseIntrinsic2");_.exports=i(function(pr,Yr){if(typeof pr!="string"||pr.length===0)throw new j("intrinsic name must be a non-empty string");if(arguments.length>1&&typeof Yr!="boolean")throw new j('"allowMissing" argument must be a boolean');if(Qh(/^%?[^%]*%?$/,pr)===null)throw new B("`%` may not be present anywhere but at the beginning and end of the intrinsic name");var xr=Od(pr),on=xr.length>0?xr[0]:"",aa=Ub("%"+on+"%",Yr),Li=aa.name,fn=aa.value,
Gn=!1,fa=aa.alias;fa&&(on=fa[0],Zh(xr,Xh([0,1],fa)));for(var du=1,Pi=!0;du<xr.length;du+=1){var Ua=xr[du],mu=lu(Ua,0,1),pu=lu(Ua,-1);if((mu==='"'||mu==="'"||mu==="`"||pu==='"'||pu==="'"||pu==="`")&&mu!==pu)throw new B("property names with quotes must have matching quotes");if((Ua==="constructor"||!Pi)&&(Gn=!0),on+="."+Ua,Li="%"+on+"%",Ni(Hn,Li))fn=Hn[Li];else if(fn!=null){if(!(Ua in fn)){if(!Yr)throw new j("base intrinsic for "+pr+" exists, but the property is not available.");return}if(bt&&du+1>=xr.length){var fu=bt(fn,Ua);Pi=!!fu,Pi&&"get"in fu&&!("originalValue"in fu.get)?fn=fu.get:fn=fn[Ua]}else Pi=Ni(fn,Ua),fn=fn[Ua];Pi&&!Gn&&(Hn[Li]=fn)}}return fn},"GetIntrinsic")}}),Je=t({"node_modules/call-bound/index.js"(ne,_){"use strict";var k=xe(),A=St(),M=A([k("%String.prototype.indexOf%")]);_.exports=i(function(N,z){var B=k(N,!!z);return typeof B=="function"&&M(N,".prototype.")>-1?A([B]):B},"callBoundIntrinsic")}}),_t=t({"node_modules/es-abstract/helpers/IsArray.js"(ne,_){"use strict";var k=xe(),
A=k("%Array%"),M=!A.isArray&&Je()("Object.prototype.toString");_.exports=A.isArray||i(function(N){return M(N)==="[object Array]"},"IsArray")}}),Ae=t({"node_modules/es-abstract/2024/IsArray.js"(ne,_){"use strict";_.exports=_t()}}),Fe=t({"node_modules/es-abstract/2024/Call.js"(ne,_){"use strict";var k=xe(),A=Je(),M=c(),U=Ae(),N=k("%Reflect.apply%",!0)||A("Function.prototype.apply");_.exports=i(function(B,j){var $=arguments.length>2?arguments[2]:[];if(!U($))throw new M("Assertion failed: optional `argumentsList`, if provided, must be a List");return N(B,j,$)},"Call")}}),Qe=t({"(disabled):node_modules/object-inspect/util.inspect"(){}}),ye=t({"node_modules/object-inspect/index.js"(ne,_){var k=typeof Map=="function"&&Map.prototype,A=Object.getOwnPropertyDescriptor&&k?Object.getOwnPropertyDescriptor(Map.prototype,"size"):null,M=k&&A&&typeof A.get=="function"?A.get:null,U=k&&Map.prototype.forEach,N=typeof Set=="function"&&Set.prototype,z=Object.getOwnPropertyDescriptor&&N?Object.getOwnPropertyDescriptor(
Set.prototype,"size"):null,B=N&&z&&typeof z.get=="function"?z.get:null,j=N&&Set.prototype.forEach,$=typeof WeakMap=="function"&&WeakMap.prototype,V=$?WeakMap.prototype.has:null,K=typeof WeakSet=="function"&&WeakSet.prototype,re=K?WeakSet.prototype.has:null,te=typeof WeakRef=="function"&&WeakRef.prototype,de=te?WeakRef.prototype.deref:null,Ie=Boolean.prototype.valueOf,mt=Object.prototype.toString,er=Function.prototype.toString,Pt=String.prototype.match,bt=String.prototype.slice,$e=String.prototype.replace,Jt=String.prototype.toUpperCase,Tr=String.prototype.toLowerCase,Fr=RegExp.prototype.test,Xt=Array.prototype.concat,mr=Array.prototype.join,_d=Array.prototype.slice,Fi=Math.floor,ra=typeof BigInt=="function"?BigInt.prototype.valueOf:null,ao=Object.getOwnPropertySymbols,Ad=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?Symbol.prototype.toString:null,Hn=typeof Symbol=="function"&&typeof Symbol.iterator=="object",Mi=typeof Symbol=="function"&&Symbol.toStringTag&&(typeof Symbol.
toStringTag===Hn||!0)?Symbol.toStringTag:null,Jh=Object.prototype.propertyIsEnumerable,Fd=(typeof Reflect=="function"?Reflect.getPrototypeOf:Object.getPrototypeOf)||([].__proto__===Array.prototype?function(G){return G.__proto__}:null);function Oi(G,Y){if(G===1/0||G===-1/0||G!==G||G&&G>-1e3&&G<1e3||Fr.call(/e/,Y))return Y;var Wt=/[0-9](?=(?:[0-9]{3})+(?![0-9]))/g;if(typeof G=="number"){var ar=G<0?-Fi(-G):Fi(G);if(ar!==G){var cr=String(ar),wt=bt.call(Y,cr.length+1);return $e.call(cr,Wt,"$&_")+"."+$e.call($e.call(wt,/([0-9]{3})/g,"$&_"),/_$/,"")}}return $e.call(Y,Wt,"$&_")}i(Oi,"addNumericSeparator");var Ni=Qe(),Xh=Ni.custom,Zh=aa(Xh)?Xh:null,Md={__proto__:null,double:'"',single:"'"},lu={__proto__:null,double:/(["\\])/g,single:/(['\\])/g};_.exports=i(function G(Y,Wt,ar,cr){var wt=Wt||{};if(Gn(wt,"quoteStyle")&&!Gn(Md,wt.quoteStyle))throw new TypeError('option "quoteStyle" must be "single" or "double"');if(Gn(wt,"maxStringLength")&&(typeof wt.maxStringLength=="number"?wt.maxStringLength<0&&
wt.maxStringLength!==1/0:wt.maxStringLength!==null))throw new TypeError('option "maxStringLength", if provided, must be a positive integer, Infinity, or `null`');var Bi=Gn(wt,"customInspect")?wt.customInspect:!0;if(typeof Bi!="boolean"&&Bi!=="symbol")throw new TypeError("option \"customInspect\", if provided, must be `true`, `false`, or `'symbol'`");if(Gn(wt,"indent")&&wt.indent!==null&&wt.indent!=="	"&&!(parseInt(wt.indent,10)===wt.indent&&wt.indent>0))throw new TypeError('option "indent" must be "\\t", an integer > 0, or `null`');if(Gn(wt,"numericSeparator")&&typeof wt.numericSeparator!="boolean")throw new TypeError('option "numericSeparator", if provided, must be `true` or `false`');var tc=wt.numericSeparator;if(typeof Y>"u")return"undefined";if(Y===null)return"null";if(typeof Y=="boolean")return Y?"true":"false";if(typeof Y=="string")return UM(Y,wt);if(typeof Y=="number"){if(Y===0)return 1/0/Y>0?"0":"-0";var oa=String(Y);return tc?Oi(Y,oa):oa}if(typeof Y=="bigint"){var Ui=String(Y)+
"n";return tc?Oi(Y,Ui):Ui}var zb=typeof wt.depth>"u"?5:wt.depth;if(typeof ar>"u"&&(ar=0),ar>=zb&&zb>0&&typeof Y=="object")return Od(Y)?"[Array]":"[Object]";var hu=DJ(wt,ar);if(typeof cr>"u")cr=[];else if(Pi(cr,Y)>=0)return"[Circular]";function ja(gu,rg,xJ){if(rg&&(cr=_d.call(cr),cr.push(rg)),xJ){var YM={depth:wt.depth};return Gn(wt,"quoteStyle")&&(YM.quoteStyle=wt.quoteStyle),G(gu,YM,ar+1,cr)}return G(gu,wt,ar+1,cr)}if(i(ja,"inspect"),typeof Y=="function"&&!na(Y)){var qM=du(Y),zM=eg(Y,ja);return"[Function"+(qM?": "+qM:" (anonymous)")+"]"+(zM.length>0?" { "+mr.call(zM,", ")+" }":"")}if(aa(Y)){var HM=Hn?$e.call(String(Y),/^(Symbol\(.*\))_[^)]*$/,"$1"):Ad.call(Y);return typeof Y=="object"&&!Hn?Nd(HM):HM}if(bJ(Y)){for(var Ld="<"+Tr.call(String(Y.nodeName)),Hb=Y.attributes||[],tg=0;tg<Hb.length;tg++)Ld+=" "+Hb[tg].name+"="+Qh(Bb(Hb[tg].value),"double",wt);return Ld+=">",Y.childNodes&&Y.childNodes.length&&(Ld+="..."),Ld+="</"+Tr.call(String(Y.nodeName))+">",Ld}if(Od(Y)){if(Y.length===0)return"\
[]";var Gb=eg(Y,ja);return hu&&!EJ(Gb)?"["+qb(Gb,hu)+"]":"[ "+mr.call(Gb,", ")+" ]"}if(pr(Y)){var Wb=eg(Y,ja);return!("cause"in Error.prototype)&&"cause"in Y&&!Jh.call(Y,"cause")?"{ ["+String(Y)+"] "+mr.call(Xt.call("[cause]: "+ja(Y.cause),Wb),", ")+" }":Wb.length===0?"["+String(Y)+"]":"{ ["+String(Y)+"] "+mr.call(Wb,", ")+" }"}if(typeof Y=="object"&&Bi){if(Zh&&typeof Y[Zh]=="function"&&Ni)return Ni(Y,{depth:zb-ar});if(Bi!=="symbol"&&typeof Y.inspect=="function")return Y.inspect()}if(Ua(Y)){var GM=[];return U&&U.call(Y,function(gu,rg){GM.push(ja(rg,Y,!0)+" => "+ja(gu,Y))}),jM("Map",M.call(Y),GM,hu)}if(fu(Y)){var WM=[];return j&&j.call(Y,function(gu){WM.push(ja(gu,Y))}),jM("Set",B.call(Y),WM,hu)}if(mu(Y))return jb("WeakMap");if(vJ(Y))return jb("WeakSet");if(pu(Y))return jb("WeakRef");if(xr(Y))return Nd(ja(Number(Y)));if(Li(Y))return Nd(ja(ra.call(Y)));if(on(Y))return Nd(Ie.call(Y));if(Yr(Y))return Nd(ja(String(Y)));if(typeof window<"u"&&Y===window)return"{ [object Window] }";if(typeof globalThis<
"u"&&Y===globalThis||typeof globalThis<"u"&&Y===globalThis)return"{ [object globalThis] }";if(!Ub(Y)&&!na(Y)){var Vb=eg(Y,ja),VM=Fd?Fd(Y)===Object.prototype:Y instanceof Object||Y.constructor===Object,$b=Y instanceof Object?"":"null prototype",$M=!VM&&Mi&&Object(Y)===Y&&Mi in Y?bt.call(fa(Y),8,-1):$b?"Object":"",TJ=VM||typeof Y.constructor!="function"?"":Y.constructor.name?Y.constructor.name+" ":"",Yb=TJ+($M||$b?"["+mr.call(Xt.call([],$M||[],$b||[]),": ")+"] ":"");return Vb.length===0?Yb+"{}":hu?Yb+"{"+qb(Vb,hu)+"}":Yb+"{ "+mr.call(Vb,", ")+" }"}return String(Y)},"inspect_");function Qh(G,Y,Wt){var ar=Wt.quoteStyle||Y,cr=Md[ar];return cr+G+cr}i(Qh,"wrapQuotes");function Bb(G){return $e.call(String(G),/"/g,"&quot;")}i(Bb,"quote");function Bo(G){return!Mi||!(typeof G=="object"&&(Mi in G||typeof G[Mi]<"u"))}i(Bo,"canTrustToString");function Od(G){return fa(G)==="[object Array]"&&Bo(G)}i(Od,"isArray");function Ub(G){return fa(G)==="[object Date]"&&Bo(G)}i(Ub,"isDate");function na(G){return fa(
G)==="[object RegExp]"&&Bo(G)}i(na,"isRegExp");function pr(G){return fa(G)==="[object Error]"&&Bo(G)}i(pr,"isError");function Yr(G){return fa(G)==="[object String]"&&Bo(G)}i(Yr,"isString");function xr(G){return fa(G)==="[object Number]"&&Bo(G)}i(xr,"isNumber");function on(G){return fa(G)==="[object Boolean]"&&Bo(G)}i(on,"isBoolean");function aa(G){if(Hn)return G&&typeof G=="object"&&G instanceof Symbol;if(typeof G=="symbol")return!0;if(!G||typeof G!="object"||!Ad)return!1;try{return Ad.call(G),!0}catch{}return!1}i(aa,"isSymbol");function Li(G){if(!G||typeof G!="object"||!ra)return!1;try{return ra.call(G),!0}catch{}return!1}i(Li,"isBigInt");var fn=Object.prototype.hasOwnProperty||function(G){return G in this};function Gn(G,Y){return fn.call(G,Y)}i(Gn,"has");function fa(G){return mt.call(G)}i(fa,"toStr");function du(G){if(G.name)return G.name;var Y=Pt.call(er.call(G),/^function\s*([\w$]+)/);return Y?Y[1]:null}i(du,"nameOf");function Pi(G,Y){if(G.indexOf)return G.indexOf(Y);for(var Wt=0,ar=G.
length;Wt<ar;Wt++)if(G[Wt]===Y)return Wt;return-1}i(Pi,"indexOf");function Ua(G){if(!M||!G||typeof G!="object")return!1;try{M.call(G);try{B.call(G)}catch{return!0}return G instanceof Map}catch{}return!1}i(Ua,"isMap");function mu(G){if(!V||!G||typeof G!="object")return!1;try{V.call(G,V);try{re.call(G,re)}catch{return!0}return G instanceof WeakMap}catch{}return!1}i(mu,"isWeakMap");function pu(G){if(!de||!G||typeof G!="object")return!1;try{return de.call(G),!0}catch{}return!1}i(pu,"isWeakRef");function fu(G){if(!B||!G||typeof G!="object")return!1;try{B.call(G);try{M.call(G)}catch{return!0}return G instanceof Set}catch{}return!1}i(fu,"isSet");function vJ(G){if(!re||!G||typeof G!="object")return!1;try{re.call(G,re);try{V.call(G,V)}catch{return!0}return G instanceof WeakSet}catch{}return!1}i(vJ,"isWeakSet");function bJ(G){return!G||typeof G!="object"?!1:typeof HTMLElement<"u"&&G instanceof HTMLElement?!0:typeof G.nodeName=="string"&&typeof G.getAttribute=="function"}i(bJ,"isElement");function UM(G,Y){
if(G.length>Y.maxStringLength){var Wt=G.length-Y.maxStringLength,ar="... "+Wt+" more character"+(Wt>1?"s":"");return UM(bt.call(G,0,Y.maxStringLength),Y)+ar}var cr=lu[Y.quoteStyle||"single"];cr.lastIndex=0;var wt=$e.call($e.call(G,cr,"\\$1"),/[\x00-\x1f]/g,wJ);return Qh(wt,"single",Y)}i(UM,"inspectString");function wJ(G){var Y=G.charCodeAt(0),Wt={8:"b",9:"t",10:"n",12:"f",13:"r"}[Y];return Wt?"\\"+Wt:"\\x"+(Y<16?"0":"")+Jt.call(Y.toString(16))}i(wJ,"lowbyte");function Nd(G){return"Object("+G+")"}i(Nd,"markBoxed");function jb(G){return G+" { ? }"}i(jb,"weakCollectionOf");function jM(G,Y,Wt,ar){var cr=ar?qb(Wt,ar):mr.call(Wt,", ");return G+" ("+Y+") {"+cr+"}"}i(jM,"collectionOf");function EJ(G){for(var Y=0;Y<G.length;Y++)if(Pi(G[Y],`
`)>=0)return!1;return!0}i(EJ,"singleLineValues");function DJ(G,Y){var Wt;if(G.indent==="	")Wt="	";else if(typeof G.indent=="number"&&G.indent>0)Wt=mr.call(Array(G.indent+1)," ");else return null;return{base:Wt,prev:mr.call(Array(Y+1),Wt)}}i(DJ,"getIndent");function qb(G,Y){if(G.length===0)return"";var Wt=`
`+Y.prev+Y.base;return Wt+mr.call(G,","+Wt)+`
`+Y.prev}i(qb,"indentedJoin");function eg(G,Y){var Wt=Od(G),ar=[];if(Wt){ar.length=G.length;for(var cr=0;cr<G.length;cr++)ar[cr]=Gn(G,cr)?Y(G[cr],G):""}var wt=typeof ao=="function"?ao(G):[],Bi;if(Hn){Bi={};for(var tc=0;tc<wt.length;tc++)Bi["$"+wt[tc]]=wt[tc]}for(var oa in G)Gn(G,oa)&&(Wt&&String(Number(oa))===oa&&oa<G.length||Hn&&Bi["$"+oa]instanceof Symbol||(Fr.call(/[^\w$]/,oa)?ar.push(Y(oa,G)+": "+Y(G[oa],G)):ar.push(oa+": "+Y(G[oa],G))));if(typeof ao=="function")for(var Ui=0;Ui<wt.length;Ui++)Jh.call(G,wt[Ui])&&ar.push("["+Y(wt[Ui])+"]: "+Y(G[wt[Ui]],G));return ar}i(eg,"arrObjKeys")}}),pe=t({"node_modules/es-abstract/helpers/isObject.js"(ne,_){"use strict";_.exports=i(function(A){return!!A&&(typeof A=="function"||typeof A=="object")},"isObject")}}),Nt=t({"node_modules/es-abstract/helpers/isPropertyKey.js"(ne,_){"use strict";_.exports=i(function(A){return typeof A=="string"||typeof A=="symbol"},"isPropertyKey")}}),ze=t({"node_modules/es-abstract/2024/Get.js"(ne,_){"use strict";var k=c(),
A=ye(),M=pe(),U=Nt();_.exports=i(function(z,B){if(!M(z))throw new k("Assertion failed: Type(O) is not Object");if(!U(B))throw new k("Assertion failed: P is not a Property Key, got "+A(B));return z[B]},"Get")}}),gt=t({"node_modules/es-abstract/5/Type.js"(ne,_){"use strict";var k=pe();_.exports=i(function(M){if(M===null)return"Null";if(typeof M>"u")return"Undefined";if(k(M))return"Object";if(typeof M=="number")return"Number";if(typeof M=="boolean")return"Boolean";if(typeof M=="string")return"String"},"Type")}}),Ar=t({"node_modules/es-abstract/2024/Type.js"(ne,_){"use strict";var k=gt();_.exports=i(function(M){return typeof M=="symbol"?"Symbol":typeof M=="bigint"?"BigInt":k(M)},"Type")}}),$r=t({"node_modules/es-iterator-helpers/aos/GetIteratorDirect.js"(ne,_){"use strict";var k=c(),A=ze(),M=Ar();_.exports=i(function(N){if(M(N)!=="Object")throw new k("Assertion failed: `obj` must be an Object");var z=A(N,"next"),B={"[[Iterator]]":N,"[[NextMethod]]":z,"[[Done]]":!1};return B},"GetIteratorDi\
rect")}}),ee=t({"node_modules/is-callable/index.js"(ne,_){"use strict";var k=Function.prototype.toString,A=typeof Reflect=="object"&&Reflect!==null&&Reflect.apply,M,U;if(typeof A=="function"&&typeof Object.defineProperty=="function")try{M=Object.defineProperty({},"length",{get:i(function(){throw U},"get")}),U={},A(function(){throw 42},null,M)}catch(bt){bt!==U&&(A=null)}else A=null;var N=/^\s*class\b/,z=i(function($e){try{var Jt=k.call($e);return N.test(Jt)}catch{return!1}},"isES6ClassFunction"),B=i(function($e){try{return z($e)?!1:(k.call($e),!0)}catch{return!1}},"tryFunctionToStr"),j=Object.prototype.toString,$="[object Object]",V="[object Function]",K="[object GeneratorFunction]",re="[object HTMLAllCollection]",te="[object HTML document.all class]",de="[object HTMLCollection]",Ie=typeof Symbol=="function"&&!!Symbol.toStringTag,mt=!(0 in[,]),er=i(function(){return!1},"isDocumentDotAll");typeof document=="object"&&(Pt=document.all,j.call(Pt)===j.call(document.all)&&(er=i(function($e){if((mt||
!$e)&&(typeof $e>"u"||typeof $e=="object"))try{var Jt=j.call($e);return(Jt===re||Jt===te||Jt===de||Jt===$)&&$e("")==null}catch{}return!1},"isDocumentDotAll")));var Pt;_.exports=i(A?function($e){if(er($e))return!0;if(!$e||typeof $e!="function"&&typeof $e!="object")return!1;try{A($e,null,M)}catch(Jt){if(Jt!==U)return!1}return!z($e)&&B($e)}:function($e){if(er($e))return!0;if(!$e||typeof $e!="function"&&typeof $e!="object")return!1;if(Ie)return B($e);if(z($e))return!1;var Jt=j.call($e);return Jt!==V&&Jt!==K&&!/^\[object HTML/.test(Jt)?!1:B($e)},"isCallable")}}),_e=t({"node_modules/es-abstract/2024/IsCallable.js"(ne,_){"use strict";_.exports=ee()}}),Ge=t({"node_modules/side-channel-list/index.js"(ne,_){"use strict";var k=ye(),A=c(),M=i(function(j,$,V){for(var K=j,re;(re=K.next)!=null;K=re)if(re.key===$)return K.next=re.next,V||(re.next=j.next,j.next=re),re},"listGetNode"),U=i(function(j,$){if(j){var V=M(j,$);return V&&V.value}},"listGet"),N=i(function(j,$,V){var K=M(j,$);K?K.value=V:j.next=
{key:$,next:j.next,value:V}},"listSet"),z=i(function(j,$){return j?!!M(j,$):!1},"listHas"),B=i(function(j,$){if(j)return M(j,$,!0)},"listDelete");_.exports=i(function(){var $,V={assert:i(function(K){if(!V.has(K))throw new A("Side channel does not contain "+k(K))},"assert"),delete:i(function(K){var re=$&&$.next,te=B($,K);return te&&re&&re===te&&($=void 0),!!te},"delete"),get:i(function(K){return U($,K)},"get"),has:i(function(K){return z($,K)},"has"),set:i(function(K,re){$||($={next:void 0}),N($,K,re)},"set")};return V},"getSideChannelList")}}),Be=t({"node_modules/side-channel-map/index.js"(ne,_){"use strict";var k=xe(),A=Je(),M=ye(),U=c(),N=k("%Map%",!0),z=A("Map.prototype.get",!0),B=A("Map.prototype.set",!0),j=A("Map.prototype.has",!0),$=A("Map.prototype.delete",!0),V=A("Map.prototype.size",!0);_.exports=!!N&&i(function(){var re,te={assert:i(function(de){if(!te.has(de))throw new U("Side channel does not contain "+M(de))},"assert"),delete:i(function(de){if(re){var Ie=$(re,de);return V(re)===
0&&(re=void 0),Ie}return!1},"delete"),get:i(function(de){if(re)return z(re,de)},"get"),has:i(function(de){return re?j(re,de):!1},"has"),set:i(function(de,Ie){re||(re=new N),B(re,de,Ie)},"set")};return te},"getSideChannelMap")}}),at=t({"node_modules/side-channel-weakmap/index.js"(ne,_){"use strict";var k=xe(),A=Je(),M=ye(),U=Be(),N=c(),z=k("%WeakMap%",!0),B=A("WeakMap.prototype.get",!0),j=A("WeakMap.prototype.set",!0),$=A("WeakMap.prototype.has",!0),V=A("WeakMap.prototype.delete",!0);_.exports=z?i((function(){var re,te,de={assert:i(function(Ie){if(!de.has(Ie))throw new N("Side channel does not contain "+M(Ie))},"assert"),delete:i(function(Ie){if(z&&Ie&&(typeof Ie=="object"||typeof Ie=="function")){if(re)return V(re,Ie)}else if(U&&te)return te.delete(Ie);return!1},"delete"),get:i(function(Ie){return z&&Ie&&(typeof Ie=="object"||typeof Ie=="function")&&re?B(re,Ie):te&&te.get(Ie)},"get"),has:i(function(Ie){return z&&Ie&&(typeof Ie=="object"||typeof Ie=="function")&&re?$(re,Ie):!!te&&te.has(
Ie)},"has"),set:i(function(Ie,mt){z&&Ie&&(typeof Ie=="object"||typeof Ie=="function")?(re||(re=new z),j(re,Ie,mt)):U&&(te||(te=U()),te.set(Ie,mt))},"set")};return de}),"getSideChannelWeakMap"):U}}),ct=t({"node_modules/side-channel/index.js"(ne,_){"use strict";var k=c(),A=ye(),M=Ge(),U=Be(),N=at(),z=N||U||M;_.exports=i(function(){var j,$={assert:i(function(V){if(!$.has(V))throw new k("Side channel does not contain "+A(V))},"assert"),delete:i(function(V){return!!j&&j.delete(V)},"delete"),get:i(function(V){return j&&j.get(V)},"get"),has:i(function(V){return!!j&&j.has(V)},"has"),set:i(function(V,K){j||(j=z()),j.set(V,K)},"set")};return $},"getSideChannel")}}),et=t({"node_modules/internal-slot/index.js"(ne,_){"use strict";var k=Q(),A=ct()(),M=c(),U={assert:i(function(N,z){if(!N||typeof N!="object"&&typeof N!="function")throw new M("`O` is not an object");if(typeof z!="string")throw new M("`slot` must be a string");if(A.assert(N),!U.has(N,z))throw new M("`"+z+"` is not present on `O`")},"ass\
ert"),get:i(function(N,z){if(!N||typeof N!="object"&&typeof N!="function")throw new M("`O` is not an object");if(typeof z!="string")throw new M("`slot` must be a string");var B=A.get(N);return B&&B["$"+z]},"get"),has:i(function(N,z){if(!N||typeof N!="object"&&typeof N!="function")throw new M("`O` is not an object");if(typeof z!="string")throw new M("`slot` must be a string");var B=A.get(N);return!!B&&k(B,"$"+z)},"has"),set:i(function(N,z,B){if(!N||typeof N!="object"&&typeof N!="function")throw new M("`O` is not an object");if(typeof z!="string")throw new M("`slot` must be a string");var j=A.get(N);j||(j={},A.set(N,j)),j["$"+z]=B},"set")};Object.freeze&&Object.freeze(U),_.exports=U}}),ut=t({"node_modules/es-abstract/2024/CompletionRecord.js"(ne,_){"use strict";var k=s(),A=et(),M=i(function U(N,z){if(!(this instanceof U))return new U(N,z);if(N!=="normal"&&N!=="break"&&N!=="continue"&&N!=="return"&&N!=="throw")throw new k('Assertion failed: `type` must be one of "normal", "break", "contin\
ue", "return", or "throw"');A.set(this,"[[Type]]",N),A.set(this,"[[Value]]",z)},"CompletionRecord2");M.prototype.type=i(function(){return A.get(this,"[[Type]]")},"Type"),M.prototype.value=i(function(){return A.get(this,"[[Value]]")},"Value"),M.prototype["?"]=i(function(){var N=A.get(this,"[[Type]]"),z=A.get(this,"[[Value]]");if(N==="throw")throw z;return z},"ReturnIfAbrupt"),M.prototype["!"]=i(function(){var N=A.get(this,"[[Type]]");if(N!=="normal")throw new k('Assertion failed: Completion Record is not of type "normal"');return A.get(this,"[[Value]]")},"assert"),_.exports=M}}),sr=t({"node_modules/es-abstract/2024/GetV.js"(ne,_){"use strict";var k=c(),A=ye(),M=Nt();_.exports=i(function(N,z){if(!M(z))throw new k("Assertion failed: P is not a Property Key, got "+A(z));return N[z]},"GetV")}}),Kt=t({"node_modules/es-abstract/2024/GetMethod.js"(ne,_){"use strict";var k=c(),A=sr(),M=_e(),U=Nt(),N=ye();_.exports=i(function(B,j){if(!U(j))throw new k("Assertion failed: P is not a Property Key");
var $=A(B,j);if($!=null){if(!M($))throw new k(N(j)+" is not a function: "+N($));return $}},"GetMethod")}}),ue=t({"node_modules/es-abstract/helpers/records/iterator-record.js"(ne,_){"use strict";var k=Q();_.exports=i(function(M){return!!M&&typeof M=="object"&&k(M,"[[Iterator]]")&&k(M,"[[NextMethod]]")&&k(M,"[[Done]]")&&typeof M["[[Done]]"]=="boolean"},"isIteratorRecord")}}),Ce=t({"node_modules/es-abstract/2024/IteratorClose.js"(ne,_){"use strict";var k=c(),A=Fe(),M=ut(),U=Kt(),N=_e(),z=pe(),B=ue();_.exports=i(function($,V){if(!B($))throw new k("Assertion failed: `iteratorRecord` must be an Iterator Record");if(!z($["[[Iterator]]"]))throw new k("Assertion failed: iteratorRecord.[[Iterator]] must be an Object");if(!N(V)&&!(V instanceof M))throw new k("Assertion failed: completion is not a thunk representing a Completion Record, nor a Completion Record instance");var K=V instanceof M?function(){return V["?"]()}:V,re=$["[[Iterator]]"],te;try{te=U(re,"return")}catch(mt){throw K(),K=null,mt}if(typeof te>
"u")return K();var de;try{de=A(te,re,[])}catch(mt){throw K(),K=null,mt}var Ie=K();if(K=null,!z(de))throw new k("iterator .return must return an object");return Ie},"IteratorClose")}}),Ye=t({"node_modules/es-abstract/2024/ToBoolean.js"(ne,_){"use strict";_.exports=i(function(A){return!!A},"ToBoolean")}}),nr=t({"node_modules/es-abstract/2024/IteratorComplete.js"(ne,_){"use strict";var k=c(),A=ze(),M=Ye(),U=pe();_.exports=i(function(z){if(!U(z))throw new k("Assertion failed: Type(iterResult) is not Object");return M(A(z,"done"))},"IteratorComplete")}}),lt=t({"node_modules/es-abstract/2024/IteratorNext.js"(ne,_){"use strict";var k=c(),A=Fe(),M=pe(),U=ue();_.exports=i(function(z){if(!U(z))throw new k("Assertion failed: `iteratorRecord` must be an Iterator Record");var B;if(arguments.length<2?B=A(z["[[NextMethod]]"],z["[[Iterator]]"]):B=A(z["[[NextMethod]]"],z["[[Iterator]]"],[arguments[1]]),!M(B))throw new k("iterator next must return an object");return B},"IteratorNext")}}),dt=t({"node_mod\
ules/es-abstract/2024/IteratorStepValue.js"(ne,_){"use strict";var k=c(),A=ze(),M=nr(),U=lt(),N=ue();_.exports=i(function(B){if(!N(B))throw new k("Assertion failed: `iteratorRecord` must be an Iterator Record");var j;try{j=U(B)}catch(K){throw B["[[Done]]"]=!0,K}var $;try{$=M(j)}catch(K){throw B["[[Done]]"]=!0,K}if($)return B["[[Done]]"]=!0,"DONE";var V;try{V=A(j,"value")}catch(K){throw B["[[Done]]"]=!0,K}return V},"IteratorStepValue")}}),Gt=t({"node_modules/es-abstract/2024/NormalCompletion.js"(ne,_){"use strict";var k=ut();_.exports=i(function(M){return new k("normal",M)},"NormalCompletion")}}),qe=t({"node_modules/es-abstract/2024/ThrowCompletion.js"(ne,_){"use strict";var k=ut();_.exports=i(function(M){return new k("throw",M)},"ThrowCompletion")}}),Lt=t({"node_modules/es-iterator-helpers/Iterator.prototype.find/implementation.js"(ne,_){"use strict";var k=c(),A=Fe(),M=$r(),U=_e(),N=Ce(),z=dt(),B=Gt(),j=qe(),$=Ye(),V=Ar();_.exports=i(function K(re){if(this instanceof K)throw new k("`fi\
nd` is not a constructor");var te=this;if(V(te)!=="Object")throw new k("`this` value must be an Object");if(!U(re))throw new k("`predicate` must be a function");for(var de=M(te),Ie=0;;){var mt=z(de);if(de["[[Done]]"])return;var er;try{er=A(re,void 0,[mt,Ie])}catch(Pt){N(de,j(Pt))}finally{Ie+=1}if($(er))return N(de,B(mt))}},"find")}}),qr=t({"node_modules/es-iterator-helpers/Iterator.prototype.find/polyfill.js"(ne,_){"use strict";var k=Lt();_.exports=i(function(){return typeof Iterator=="function"&&typeof Iterator.prototype.find=="function"?Iterator.prototype.find:k},"getPolyfill")}}),tr=t({"node_modules/functions-have-names/index.js"(ne,_){"use strict";var k=i(function(){return typeof i(function(){},"f").name=="string"},"functionsHaveNames2"),A=Object.getOwnPropertyDescriptor;if(A)try{A([],"length")}catch{A=null}k.functionsHaveConfigurableNames=i(function(){if(!k()||!A)return!1;var N=A(function(){},"name");return!!N&&!!N.configurable},"functionsHaveConfigurableNames");var M=Function.prototype.
bind;k.boundFunctionsHaveNames=i(function(){return k()&&typeof M=="function"&&i(function(){},"f").bind().name!==""},"boundFunctionsHaveNames"),_.exports=k}}),qn=t({"node_modules/set-function-name/index.js"(ne,_){"use strict";var k=m(),A=p()(),M=tr().functionsHaveConfigurableNames(),U=c();_.exports=i(function(z,B){if(typeof z!="function")throw new U("`fn` is not a function");var j=arguments.length>2&&!!arguments[2];return(!j||M)&&(A?k(z,"name",B,!0,!0):k(z,"name",B)),z},"setFunctionName")}}),pa=t({"node_modules/iterator.prototype/index.js"(ne,_){"use strict";var k=xe(),A=nt(),M=De(),U=qn(),N=m(),z=h(),B=k("%ArrayIteratorPrototype%",!0),j=B&&A(B),$=j!==z.prototype&&j||{};M()&&(Symbol.iterator in $||(V=U(i(function(){return this},"SymbolIterator"),"[Symbol.iterator]",!0),N($,Symbol.iterator,V,!0)));var V;_.exports=$}}),zn=t({"node_modules/es-iterator-helpers/Iterator.prototype/implementation.js"(ne,_){"use strict";_.exports=pa()}}),_i=t({"node_modules/es-iterator-helpers/Iterator.prototyp\
e.find/shim.js"(ne,_){"use strict";var k=f(),A=qr(),M=zn();_.exports=i(function(){var N=A();return k(M,{find:N},{find:i(function(){return M.find!==N},"find")}),N},"shimIteratorPrototypeFind")}}),Ba=t({"node_modules/es-abstract/2024/CreateIterResultObject.js"(ne,_){"use strict";var k=c();_.exports=i(function(M,U){if(typeof U!="boolean")throw new k("Assertion failed: Type(done) is not Boolean");return{value:M,done:U}},"CreateIterResultObject")}}),Ys=t({"node_modules/es-iterator-helpers/aos/GeneratorStart.js"(ne,_){"use strict";var k=c(),A=Ba(),M=_e(),U=Ar(),N=et();_.exports=i(function(B,j){if(N.assert(B,"[[GeneratorState]]"),N.assert(B,"[[GeneratorContext]]"),N.assert(B,"[[GeneratorBrand]]"),N.assert(B,"[[Sentinel]]"),N.assert(B,"[[CloseIfAbrupt]]"),!M(j)||j.length!==0)throw new k("`closure` must be a function that takes no arguments");var $=N.get(j,"[[Sentinel]]");if(U($)!=="Object")throw new k("`closure.[[Sentinel]]` must be an object");N.set(B,"[[GeneratorContext]]",function(){try{var V=j();
return V===$?(N.set(B,"[[GeneratorState]]","completed"),N.set(B,"[[GeneratorContext]]",null),A(void 0,!0)):(N.set(B,"[[GeneratorState]]","suspendedYield"),A(V,!1))}catch(K){throw N.set(B,"[[GeneratorState]]","completed"),N.set(B,"[[GeneratorContext]]",null),K}}),N.set(B,"[[GeneratorState]]","suspendedStart")},"GeneratorStart")}}),Ks=t({"node_modules/es-abstract/helpers/forEach.js"(ne,_){"use strict";_.exports=i(function(A,M){for(var U=0;U<A.length;U+=1)M(A[U],U,A)},"forEach")}}),Js=t({"node_modules/has-proto/index.js"(ne,_){"use strict";var k={__proto__:null,foo:{}},A={__proto__:k}.foo===k.foo&&!(k instanceof Object);_.exports=i(function(){return A},"hasProto")}}),Xs=t({"node_modules/es-abstract/2024/OrdinaryObjectCreate.js"(ne,_){"use strict";var k=xe(),A=k("%Object.create%",!0),M=c(),U=s(),N=Ae(),z=Ks(),B=pe(),j=et(),$=Js()();_.exports=i(function(K){if(K!==null&&!B(K))throw new M("Assertion failed: `proto` must be null or an object");var re=arguments.length<2?[]:arguments[1];if(!N(re))
throw new M("Assertion failed: `additionalInternalSlotsList` must be an Array");var te;if(A)te=A(K);else if($)te={__proto__:K};else{if(K===null)throw new U("native Object.create support is required to create null objects");var de=i(function(){},"T2");de.prototype=K,te=new de}return re.length>0&&z(re,function(Ie){j.set(te,Ie,void 0)}),te},"OrdinaryObjectCreate")}}),Ai=t({"node_modules/es-abstract/helpers/every.js"(ne,_){"use strict";_.exports=i(function(A,M){for(var U=0;U<A.length;U+=1)if(!M(A[U],U,A))return!1;return!0},"every")}}),Zs=t({"node_modules/set-function-length/index.js"(ne,_){"use strict";var k=xe(),A=m(),M=p()(),U=l(),N=c(),z=k("%Math.floor%");_.exports=i(function(j,$){if(typeof j!="function")throw new N("`fn` is not a function");if(typeof $!="number"||$<0||$>4294967295||z($)!==$)throw new N("`length` must be a positive 32-bit integer");var V=arguments.length>2&&!!arguments[2],K=!0,re=!0;if("length"in j&&U){var te=U(j,"length");te&&!te.configurable&&(K=!1),te&&!te.writable&&
(re=!1)}return(K||re||!V)&&(M?A(j,"length",$,!0,!0):A(j,"length",$)),j},"setFunctionLength")}}),Qs=t({"node_modules/call-bind-apply-helpers/applyBind.js"(ne,_){"use strict";var k=He(),A=yt(),M=Qt();_.exports=i(function(){return M(k,A,arguments)},"applyBind")}}),zh=t({"node_modules/call-bind/index.js"(ne,_){"use strict";var k=Zs(),A=o(),M=St(),U=Qs();_.exports=i(function(z){var B=M(arguments),j=z.length-(arguments.length-1);return k(B,1+(j>0?j:0),!0)},"callBind"),A?A(_.exports,"apply",{value:U}):_.exports.apply=U}}),Td=t({"node_modules/isarray/index.js"(ne,_){var k={}.toString;_.exports=Array.isArray||function(A){return k.call(A)=="[object Array]"}}}),Hh=t({"node_modules/safe-array-concat/index.js"(ne,_){"use strict";var k=xe(),A=k("%Array.prototype.concat%"),M=zh(),U=Je(),N=U("Array.prototype.slice"),z=Pe()(),B=z&&Symbol.isConcatSpreadable,j=[],$=B?M.apply(A,j):null,V=B?Td():null;_.exports=B?i(function(re){for(var te=0;te<arguments.length;te+=1){var de=arguments[te];if(de&&typeof de=="\
object"&&typeof de[B]=="boolean"){j[B]||(j[B]=!0);var Ie=V(de)?N(de):[de];Ie[B]=!0,arguments[te]=Ie}}return $(arguments)},"safeArrayConcat"):M(A,j)}}),xd=t({"node_modules/es-iterator-helpers/aos/CreateIteratorFromClosure.js"(ne,_){"use strict";var k=c(),A=Ys(),M=Ae(),U=_e(),N=Xs(),z=Ai(),B=et(),j=Hh(),$=i(function(K){return typeof K=="string"},"isString2");_.exports=i(function(K,re,te){if(!U(K))throw new k("`closure` must be a function");if(typeof re!="string")throw new k("`generatorBrand` must be a string");var de=arguments.length>3?arguments[3]:[];if(arguments.length>3&&(!M(de)||!z(de,$)))throw new k("`extraSlots` must be a List of String internal slot names");var Ie=j(de,["[[GeneratorContext]]","[[GeneratorBrand]]","[[GeneratorState]]"]),mt=N(te,Ie);return B.set(mt,"[[GeneratorBrand]]",re),B.assert(K,"[[Sentinel]]"),B.set(mt,"[[Sentinel]]",B.get(K,"[[Sentinel]]")),B.assert(K,"[[CloseIfAbrupt]]"),B.set(mt,"[[CloseIfAbrupt]]",B.get(K,"[[CloseIfAbrupt]]")),A(mt,K),mt},"CreateIteratorFr\
omClosure")}}),Sd=t({"node_modules/es-abstract/helpers/isLeadingSurrogate.js"(ne,_){"use strict";_.exports=i(function(A){return typeof A=="number"&&A>=55296&&A<=56319},"isLeadingSurrogate")}}),Cd=t({"node_modules/es-abstract/helpers/isTrailingSurrogate.js"(ne,_){"use strict";_.exports=i(function(A){return typeof A=="number"&&A>=56320&&A<=57343},"isTrailingSurrogate")}}),Gh=t({"node_modules/es-abstract/2024/UTF16SurrogatePairToCodePoint.js"(ne,_){"use strict";var k=xe(),A=c(),M=k("%String.fromCharCode%"),U=Sd(),N=Cd();_.exports=i(function(B,j){if(!U(B)||!N(j))throw new A("Assertion failed: `lead` must be a leading surrogate char code, and `trail` must be a trailing surrogate char code");return M(B)+M(j)},"UTF16SurrogatePairToCodePoint")}}),Pb=t({"node_modules/es-abstract/2024/CodePointAt.js"(ne,_){"use strict";var k=c(),A=Je(),M=Sd(),U=Cd(),N=Gh(),z=A("String.prototype.charAt"),B=A("String.prototype.charCodeAt");_.exports=i(function($,V){if(typeof $!="string")throw new k("Assertion fail\
ed: `string` must be a String");var K=$.length;if(V<0||V>=K)throw new k("Assertion failed: `position` must be >= 0, and < the length of `string`");var re=B($,V),te=z($,V),de=M(re),Ie=U(re);if(!de&&!Ie)return{"[[CodePoint]]":te,"[[CodeUnitCount]]":1,"[[IsUnpairedSurrogate]]":!1};if(Ie||V+1===K)return{"[[CodePoint]]":te,"[[CodeUnitCount]]":1,"[[IsUnpairedSurrogate]]":!0};var mt=B($,V+1);return U(mt)?{"[[CodePoint]]":N(re,mt),"[[CodeUnitCount]]":2,"[[IsUnpairedSurrogate]]":!1}:{"[[CodePoint]]":te,"[[CodeUnitCount]]":1,"[[IsUnpairedSurrogate]]":!0}},"CodePointAt")}}),ec=t({"node_modules/math-intrinsics/isFinite.js"(ne,_){"use strict";var k=me();_.exports=i(function(M){return(typeof M=="number"||typeof M=="bigint")&&!k(M)&&M!==1/0&&M!==-1/0},"isFinite2")}}),Id=t({"node_modules/math-intrinsics/isInteger.js"(ne,_){"use strict";var k=S(),A=I(),M=me(),U=ec();_.exports=i(function(z){if(typeof z!="number"||M(z)||!U(z))return!1;var B=k(z);return A(B)===B},"isInteger")}}),su=t({"node_modules/math-i\
ntrinsics/constants/maxSafeInteger.js"(ne,_){"use strict";_.exports=Number.MAX_SAFE_INTEGER||9007199254740991}}),cu=t({"node_modules/es-abstract/2024/AdvanceStringIndex.js"(ne,_){"use strict";var k=Pb(),A=c(),M=Id(),U=su();_.exports=i(function(z,B,j){if(typeof z!="string")throw new A("Assertion failed: `S` must be a String");if(!M(B)||B<0||B>U)throw new A("Assertion failed: `length` must be an integer >= 0 and <= 2**53");if(typeof j!="boolean")throw new A("Assertion failed: `unicode` must be a Boolean");if(!j)return B+1;var $=z.length;if(B+1>=$)return B+1;var V=k(z,B);return B+V["[[CodeUnitCount]]"]},"AdvanceStringIndex")}}),kd=t({"node_modules/has-tostringtag/shams.js"(ne,_){"use strict";var k=Pe();_.exports=i(function(){return k()&&!!Symbol.toStringTag},"hasToStringTagShams")}}),Wh=t({"node_modules/is-string/index.js"(ne,_){"use strict";var k=Je(),A=k("String.prototype.valueOf"),M=i(function(j){try{return A(j),!0}catch{return!1}},"tryStringObject2"),U=k("Object.prototype.toString"),N="\
[object String]",z=kd()();_.exports=i(function(j){return typeof j=="string"?!0:!j||typeof j!="object"?!1:z?M(j):U(j)===N},"isString")}}),Vh=t({"node_modules/es-abstract/helpers/getIteratorMethod.js"(ne,_){"use strict";var k=De()(),A=xe(),M=Je(),U=Wh(),N=A("%Symbol.iterator%",!0),z=M("String.prototype.slice"),B=A("%String%");_.exports=i(function($,V){var K;return k?K=$.GetMethod(V,N):$.IsArray(V)?K=i(function(){var re=-1,te=this;return{next:i(function(){return re+=1,{done:re>=te.length,value:te[re]}},"next")}},"usingIterator"):U(V)&&(K=i(function(){var re=0;return{next:i(function(){var te=$.AdvanceStringIndex(B(V),re,!0),de=z(V,re,te);return re=te,{done:te>V.length,value:de}},"next")}},"usingIterator")),K},"getIteratorMethod")}}),$h=t({"node_modules/es-iterator-helpers/aos/GetIteratorFlattenable.js"(ne,_){"use strict";var k=c(),A=cu(),M=Fe(),U=$r(),N=Kt(),z=Ae(),B=Ar(),j=Vh();_.exports=i(function(V,K){if(K!=="REJECT-STRINGS"&&K!=="ITERATE-STRINGS")throw new k('Assertion failed: `stringH\
andling` must be "REJECT-STRINGS" or "ITERATE-STRINGS"');if(B(V)!=="Object"&&(K==="REJECT-STRINGS"||typeof V!="string"))throw new k("obj must be an Object");var re=void 0;re=j({AdvanceStringIndex:A,GetMethod:N,IsArray:z},V);var te;if(typeof re>"u"?te=V:te=M(re,V),B(te)!=="Object")throw new k("iterator must be an Object");return U(te)},"GetIteratorFlattenable")}}),Yh=t({"node_modules/es-set-tostringtag/index.js"(ne,_){"use strict";var k=xe(),A=k("%Object.defineProperty%",!0),M=kd()(),U=Q(),N=c(),z=M?Symbol.toStringTag:null;_.exports=i(function(j,$){var V=arguments.length>2&&!!arguments[2]&&arguments[2].force,K=arguments.length>2&&!!arguments[2]&&arguments[2].nonConfigurable;if(typeof V<"u"&&typeof V!="boolean"||typeof K<"u"&&typeof K!="boolean")throw new N("if provided, the `overrideIfSet` and `nonConfigurable` options must be booleans");z&&(V||!U(j,z))&&(A?A(j,z,{configurable:!K,enumerable:!1,value:$,writable:!1}):j[z]=$)},"setToStringTag")}}),Rd=t({"node_modules/es-iterator-helpers/ao\
s/GeneratorValidate.js"(ne,_){"use strict";var k=c(),A=et();_.exports=i(function(U,N){A.assert(U,"[[GeneratorState]]"),A.assert(U,"[[GeneratorBrand]]");var z=A.get(U,"[[GeneratorBrand]]");if(z!==N)throw new k("Assertion failed: generator brand is unexpected: "+z);A.assert(U,"[[GeneratorContext]]");var B=A.get(U,"[[GeneratorState]]");if(B==="executing")throw new k("generator is executing");return B},"GeneratorValidate")}}),Kh=t({"node_modules/es-iterator-helpers/aos/GeneratorResume.js"(ne,_){"use strict";var k=c(),A=Ba(),M=Rd(),U=et();_.exports=i(function(z,B,j){var $=M(z,j);if($==="completed")return A(void 0,!0);if($!=="suspendedStart"&&$!=="suspendedYield")throw new k("Assertion failed: generator state is unexpected: "+$);var V=U.get(z,"[[GeneratorContext]]");U.set(z,"[[GeneratorState]]","executing");var K=V(B);return K},"GeneratorResume")}}),uu=t({"node_modules/es-iterator-helpers/aos/GeneratorResumeAbrupt.js"(ne,_){"use strict";var k=c(),A=ut(),M=Ba(),U=Rd(),N=Gt(),z=et();_.exports=
i(function(j,$,V){if(!($ instanceof A))throw new k("Assertion failed: abruptCompletion must be a Completion Record");var K=U(j,V);K==="suspendedStart"&&(z.set(j,"[[GeneratorState]]","completed"),z.set(j,"[[GeneratorContext]]",null),K="completed");var re=$.value();if(K==="completed")return M(re,!0);if(K!=="suspendedYield")throw new k("Assertion failed: generator state is unexpected: "+K);if($.type()==="return")return M(z.get(j,"[[CloseIfAbrupt]]")(N($.value())),!0);var te=z.get(j,"[[GeneratorContext]]");z.set(j,"[[GeneratorState]]","executing");var de=te(re);return de},"GeneratorResumeAbrupt")}}),aJ=t({"node_modules/es-iterator-helpers/aos/IteratorCloseAll.js"(ne,_){"use strict";var k=c(),A=ut(),M=Ce(),U=qe(),N=_t(),z=Ai(),B=ue();_.exports=i(function($,V){if(!N($)||!z($,B))throw new k("Assertion failed: `iters` must be a List of IteratorRecords");if(!(V instanceof A))throw new k("Assertion failed: `completion` must be a Completion Record");for(var K=$.length-1;K>=0;K-=1)try{M($[K],V)}catch(re){
V=U(re)}return V["?"]()},"IteratorCloseAll")}}),oJ=t({"node_modules/es-iterator-helpers/aos/ReturnCompletion.js"(ne,_){"use strict";var k=ut();_.exports=i(function(M){return new k("return",M)},"ReturnCompletion")}}),BM=t({"node_modules/es-iterator-helpers/IteratorHelperPrototype/index.js"(ne,_){"use strict";var k=Yh(),A=Js()(),M=zn(),U=et(),N=Ba(),z=Kh(),B=uu(),j=aJ(),$=oJ(),V,K={return:i(function(){var te=this;if(U.assert(te,"[[UnderlyingIterators]]"),U.assert(te,"[[GeneratorState]]"),U.get(te,"[[GeneratorState]]")==="suspendedStart")return U.set(te,"[[GeneratorState]]","completed"),j(U.get(te,"[[UnderlyingIterators]]"),$(void 0)),N(void 0,!0);var de=$(void 0);return B(te,de,"Iterator Helper")},"return")};A?(V={__proto__:M,next:i(function(){return z(this,void 0,"Iterator Helper")},"next"),return:K.return},k(V,"Iterator Helper")):(re=i(function(){},"IteratorHelper2"),re.prototype=M,V=new re,delete V.constructor,V.next=i(function(){return z(this,void 0,"Iterator Helper")},"next"),V.return=
K.return);var re;_.exports=V}}),iJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.flatMap/implementation.js"(ne,_){"use strict";var k=c(),A=Fe(),M=ut(),U=xd(),N=$r(),z=$h(),B=_e(),j=Ce(),$=dt(),V=qe(),K=Ar(),re=BM(),te=et();_.exports=i(function de(Ie){if(this instanceof de)throw new k("`flatMap` is not a constructor");var mt=this;if(K(mt)!=="Object")throw new k("`this` value must be an Object");if(!B(Ie))throw new k("`mapper` must be a function");var er=N(mt),Pt={sentinel:!0},bt=Pt,$e=i(function(mr){if(!(mr instanceof M))throw new k("`abruptCompletion` must be a Completion Record");try{bt!==Pt&&j(bt,mr)}finally{bt=Pt,j(er,mr)}},"closeIfAbrupt"),Jt=0,Tr=!1,Fr=i(function(){if(bt===Pt){var mr=$(er);if(er["[[Done]]"])return Tr=!1,bt=Pt,Pt}if(bt===Pt){Tr=!0;try{var _d=A(Ie,void 0,[mr,Jt]);bt=z(_d,"REJECT-STRINGS")}catch(ra){Tr=!1,bt=Pt,$e(V(ra))}finally{Jt+=1}}if(Tr){var Fi;try{Fi=$(bt)}catch(ra){Tr=!1,bt=Pt,$e(V(ra))}return bt["[[Done]]"]?(Tr=!1,bt=Pt,Fr()):Fi}return Pt},"closure");
te.set(Fr,"[[Sentinel]]",Pt),te.set(Fr,"[[CloseIfAbrupt]]",$e);var Xt=U(Fr,"Iterator Helper",re,["[[UnderlyingIterators]]"]);return te.set(Xt,"[[UnderlyingIterators]]",[er]),Xt},"flatMap")}}),sJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.flatMap/polyfill.js"(ne,_){"use strict";var k=iJ();_.exports=i(function(){if(typeof Iterator=="function"&&typeof Iterator.prototype.flatMap=="function")try{Iterator.prototype.flatMap.call({next:null},function(){}).next()}catch{return Iterator.prototype.flatMap}return k},"getPolyfill")}}),cJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.flatMap/shim.js"(ne,_){"use strict";var k=f(),A=sJ(),M=zn();_.exports=i(function(){var N=A();return k(M,{flatMap:N},{flatMap:i(function(){return M.flatMap!==N},"flatMap")}),N},"shimIteratorPrototypeFlatMap")}}),uJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.map/implementation.js"(ne,_){"use strict";var k=c(),A=Fe(),M=ut(),U=xd(),N=$r(),z=_e(),B=Ce(),j=dt(),$=qe(),V=Ar(),K=BM(),re=et();_.
exports=i(function te(de){if(this instanceof te)throw new k("`map` is not a constructor");var Ie=this;if(V(Ie)!=="Object")throw new k("`this` value must be an Object");if(!z(de))throw new k("`mapper` must be a function");var mt=N(Ie),er=i(function(Tr){if(!(Tr instanceof M))throw new k("`abruptCompletion` must be a Completion Record");B(mt,Tr)},"closeIfAbrupt"),Pt={},bt=0,$e=i(function(){var Tr=j(mt);if(mt["[[Done]]"])return Pt;var Fr;try{return Fr=A(de,void 0,[Tr,bt]),Fr}catch(Xt){throw er($(Xt)),Xt}finally{bt+=1}},"closure");re.set($e,"[[Sentinel]]",Pt),re.set($e,"[[CloseIfAbrupt]]",er);var Jt=U($e,"Iterator Helper",K,["[[UnderlyingIterators]]"]);return re.set(Jt,"[[UnderlyingIterators]]",[mt]),Jt},"map")}}),lJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.map/polyfill.js"(ne,_){"use strict";var k=uJ();_.exports=i(function(){if(typeof Iterator=="function"&&typeof Iterator.prototype.map=="function")try{Iterator.prototype.map.call({next:null},function(){}).next()}catch{return Iterator.
prototype.map}return k},"getPolyfill")}}),dJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.map/shim.js"(ne,_){"use strict";var k=f(),A=lJ(),M=zn();_.exports=i(function(){var N=A();return k(M,{map:N},{map:i(function(){return M.map!==N},"map")}),N},"shimIteratorPrototypeMap")}}),mJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.reduce/implementation.js"(ne,_){"use strict";var k=c(),A=Fe(),M=$r(),U=_e(),N=Ce(),z=dt(),B=qe(),j=Ar();_.exports=i(function $(V){if(this instanceof $)throw new k("`reduce` is not a constructor");var K=this;if(j(K)!=="Object")throw new k("`this` value must be an Object");if(!U(V))throw new k("`reducer` must be a function");var re=M(K),te,de;if(arguments.length<2){if(te=z(re),re["[[Done]]"])throw new k("Reduce of empty iterator with no initial value");de=1}else te=arguments[1],de=0;for(;;){var Ie=z(re);if(re["[[Done]]"])return te;try{var mt=A(V,void 0,[te,Ie,de]);te=mt}catch(er){N(re,B(er))}de+=1}},"reduce")}}),pJ=t({"node_modules/es-iterator-hel\
pers/Iterator.prototype.reduce/polyfill.js"(ne,_){"use strict";var k=mJ();_.exports=i(function(){return typeof Iterator=="function"&&typeof Iterator.prototype.reduce=="function"?Iterator.prototype.reduce:k},"getPolyfill")}}),fJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.reduce/shim.js"(ne,_){"use strict";var k=f(),A=pJ(),M=zn();_.exports=i(function(){var N=A();return k(M,{reduce:N},{reduce:i(function(){return M.reduce!==N},"reduce")}),N},"shimIteratorPrototypeReduce")}}),hJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.toArray/implementation.js"(ne,_){"use strict";var k=c(),A=$r(),M=dt(),U=Ar();_.exports=i(function N(){if(this instanceof N)throw new k("`toArray` is not a constructor");var z=this;if(U(z)!=="Object")throw new k("`this` value must be an Object");for(var B=A(z),j=[];;){var $=M(B);if(B["[[Done]]"])return j;j[j.length]=$}},"toArray")}}),gJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.toArray/polyfill.js"(ne,_){"use strict";var k=hJ();_.exports=
i(function(){return typeof Iterator=="function"&&typeof Iterator.prototype.toArray=="function"?Iterator.prototype.toArray:k},"getPolyfill")}}),yJ=t({"node_modules/es-iterator-helpers/Iterator.prototype.toArray/shim.js"(ne,_){"use strict";var k=f(),A=gJ(),M=zn();_.exports=i(function(){var N=A();return k(M,{toArray:N},{toArray:i(function(){return M.toArray!==N},"toArray")}),N},"shimIteratorPrototypeToArray")}});_i()(),cJ()(),dJ()(),fJ()(),yJ()()})()});var Fx={};C(Fx,{getLogNormalScore:()=>mp,linearInterpolation:()=>Ax});function Ope(e){let t=Math.sign(e);e=Math.abs(e);let r=.254829592,n=-.284496736,a=1.421413741,o=-1.453152027,s=1.061405429,u=1/(1+.3275911*e),l=u*(r+u*(n+u*(a+u*(o+u*s))));return t*(1-l*Math.exp(-e*e))}function mp({median:e,p10:t},r){if(e<=0)throw new Error("median must be greater than zero");if(t<=0)throw new Error("p10 must be greater than zero");if(t>=e)throw new Error("p10 must be less than the median");if(r<=0)return 1;let n=.9061938024368232,a=Math.max(Number.MIN_VALUE,r/e),o=Math.log(a),s=Math.max(Number.MIN_VALUE,t/e),c=-Math.log(s),u=o*n/c,l=(1-Ope(u))/2,m;return r<=t?m=Math.max(.9,Math.min(1,l)):r<=e?m=Math.max(Fpe,Math.min(Ape,l)):m=Math.max(0,Math.min(Mpe,l)),m}function Ax(e,t,r,n,a){let o=(n-t)/(r-e);return t+(a-e)*o}var Ape,Fpe,Mpe,Ly=g(()=>{d();Ape=.8999999999999999,Fpe=.5,Mpe=.49999999999999994;i(Ope,"erf");i(mp,"getLogNormalScore");i(Ax,"linearInterpolation")});var Mx={};C(Mx,{InsightCategory:()=>Et,InsightKeys:()=>Ke,InsightWarning:()=>Nn});var Nn,Et,Ke,Mr=g(()=>{d();(function(e){e.NO_FP="NO_FP",e.NO_LCP="NO_LCP",e.NO_DOCUMENT_REQUEST="NO_DOCUMENT_REQUEST",e.NO_LAYOUT="NO_LAYOUT"})(Nn||(Nn={}));(function(e){e.ALL="All",e.INP="INP",e.LCP="LCP",e.CLS="CLS"})(Et||(Et={}));(function(e){e.LCP_BREAKDOWN="LCPBreakdown",e.INP_BREAKDOWN="INPBreakdown",e.CLS_CULPRITS="CLSCulprits",e.THIRD_PARTIES="ThirdParties",e.DOCUMENT_LATENCY="DocumentLatency",e.DOM_SIZE="DOMSize",e.DUPLICATE_JAVASCRIPT="DuplicatedJavaScript",e.FONT_DISPLAY="FontDisplay",e.FORCED_REFLOW="ForcedReflow",e.IMAGE_DELIVERY="ImageDelivery",e.LCP_DISCOVERY="LCPDiscovery",e.LEGACY_JAVASCRIPT="LegacyJavaScript",e.NETWORK_DEPENDENCY_TREE="NetworkDependencyTree",e.RENDER_BLOCKING="RenderBlocking",e.SLOW_CSS_SELECTOR="SlowCSSSelector",e.VIEWPORT="Viewport",e.MODERN_HTTP="ModernHTTP"})(Ke||(Ke={}))});var Yn={};C(Yn,{calculateDocFirstByteTs:()=>fp,calculateMetricWeightsForSorting:()=>Upe,estimateCompressedContentSize:()=>MB,estimateCompressionRatioForScript:()=>pp,evaluateCLSMetricScore:()=>kB,evaluateINPMetricScore:()=>IB,evaluateLCPMetricScore:()=>CB,getCLS:()=>Ppe,getFieldMetricsForInsightSet:()=>_B,getINP:()=>Lpe,getInsight:()=>Py,getLCP:()=>Npe,isRequestCompressed:()=>By,isRequestServedFromBrowserCache:()=>AB,metricSavingsForWastedBytes:()=>si});function Py(e,t){let r=t.model[e];return r instanceof Error?null:r}function Npe(e){let t=Py(Ke.LCP_BREAKDOWN,e);return!t||!t.lcpMs||!t.lcpEvent?null:{value:ae.milliToMicro(t.lcpMs),event:t.lcpEvent}}function Lpe(e){let t=Py(Ke.INP_BREAKDOWN,e);return t?.longestInteractionEvent?.dur?{value:t.longestInteractionEvent.dur,event:t.longestInteractionEvent}:null}function Ppe(e){let t=Py(Ke.CLS_CULPRITS,e);if(!t)return{value:0,worstClusterEvent:null};let r=0,n;for(let a of t.clusters)a.clusterCumulativeScore>r&&(r=a.clusterCumulativeScore,n=a);
return{value:r,worstClusterEvent:n??null}}function CB(e){return mp({p10:2500,median:4e3},e)}function IB(e){return mp({p10:200,median:500},e)}function kB(e){return mp({p10:.1,median:.25},e)}function Bpe(e,t,r,n=null){return e.find(a=>{let o=n?a[`${n.pageScope}-${n.deviceScope}`]?.record.key:(a["url-ALL"]||a["origin-ALL"])?.record.key;return o?.url&&o.url===t||o?.origin&&o.origin===r})}function RB(e,t,r=null){let n=[];r?n.push(r):(n.push({pageScope:"url",deviceScope:"ALL"}),n.push({pageScope:"origin",deviceScope:"ALL"}));for(let a of n){let o=`${a.pageScope}-${a.deviceScope}`,s=e[o]?.record.metrics[t]?.percentiles?.p75;if(typeof s=="string"&&(s=Number(s)),typeof s=="number"&&Number.isFinite(s))return{value:s,pageScope:a.pageScope}}return null}function Ac(e,t,r=null){let n=RB(e,t,r);if(n){let a=n.value;return{value:ae.milliToMicro(a),pageScope:n.pageScope}}return null}function _B(e,t,r=null){let n=t?.cruxFieldData;if(!n)return null;let a=Bpe(n,e.url.href,e.url.origin,r);return a?{fcp:Ac(a,
"first_contentful_paint",r),lcp:Ac(a,"largest_contentful_paint",r),inp:Ac(a,"interaction_to_next_paint",r),cls:RB(a,"cumulative_layout_shift",r),lcpBreakdown:{ttfb:Ac(a,"largest_contentful_paint_image_time_to_first_byte",r),loadDelay:Ac(a,"largest_contentful_paint_image_resource_load_delay",r),loadDuration:Ac(a,"largest_contentful_paint_image_resource_load_duration",r),renderDelay:Ac(a,"largest_contentful_paint_image_element_render_delay",r)}}:null}function Upe(e,t){let r={lcp:.3333333333333333,inp:.3333333333333333,cls:.3333333333333333};if(!t?.cruxFieldData)return r;let a=_B(e,t);if(!a)return r;let o=a.lcp?.value??null,s=a.inp?.value??null,c=a.cls?.value??null,u=o!==null?CB(ae.microToMilli(o)):0,l=s!==null?IB(ae.microToMilli(s)):0,m=c!==null?kB(c):0,p=1-u,f=1-l,h=1-m,y=p+f+h;return y&&(r.lcp=p/y,r.inp=f/y,r.cls=h/y),r}function SB(e,t,r){let n=t.simulate(r),a=new Map;r.traverse(c=>{if(c.type!=="network")return;let u=e.get(c.request.requestId);if(!u)return;let l=c.request.transferSize;
a.set(c.request.requestId,l),c.request.transferSize=Math.max(l-u,0)});let o=t.simulate(r);r.traverse(c=>{if(c.type!=="network")return;let u=a.get(c.request.requestId);u!==void 0&&(c.request.transferSize=u)});let s=n.timeInMs-o.timeInMs;return s=Math.round(s/xB)*xB,O.Milli(s)}function si(e,t){if(!t.navigation||!t.lantern)return;if(!e.size)return{FCP:O.Milli(0),LCP:O.Milli(0)};let r=t.lantern.simulator,n=t.lantern.metrics.firstContentfulPaint.optimisticGraph,a=t.lantern.metrics.largestContentfulPaint.optimisticGraph;return{FCP:SB(e,r,n),LCP:SB(e,r,a)}}function By(e){if(!e.args.data.responseHeaders)return!1;let t=[/^content-encoding$/i,/^x-content-encoding-over-network$/i,/^x-original-content-encoding$/i],r=["gzip","br","deflate","zstd"];return e.args.data.responseHeaders.some(n=>t.some(a=>n.name.match(a))&&r.includes(n.value))}function AB(e){if(!e.args.data.responseHeaders||e.args.data.failed)return!1;if(e.args.data.statusCode===304)return!0;let{transferSize:t,resourceSize:r}=FB(e);return(r?
t/r:0)<.01}function FB(e){let t=e.args.data.decodedBodyLength,r=e.args.data.encodedDataLength;return{resourceSize:t,transferSize:r}}function MB(e,t,r){if(!e||AB(e))switch(r){case"Stylesheet":return Math.round(t*.2);case"Script":case"Document":return Math.round(t*.33);default:return Math.round(t*.5)}let{transferSize:n,resourceSize:a}=FB(e),o=n;if(By(e)||(o=a),e.args.data.resourceType===r)return o;let s=Number.isFinite(a)&&a>0?o/a:1;return Math.round(t*s)}function pp(e){if(!e.request)return 1;let t=e.request,r=t.args.data.decodedBodyLength??e.content?.length??0,n=MB(t,r,"Script");return r===0||n===0?1:n/r}function fp(e){if(e.args.data.protocol==="file")return e.ts;let t=e.args.data.timing;return t?O.Micro(ae.secondsToMicro(t.requestTime)+ae.milliToMicro(t.receiveHeadersStart??t.receiveHeadersEnd)):null}var xB,ci=g(()=>{d();ot();Le();Ly();Mr();xB=50;i(Py,"getInsight");i(Npe,"getLCP");i(Lpe,"getINP");i(Ppe,"getCLS");i(CB,"evaluateLCPMetricScore");i(IB,"evaluateINPMetricScore");i(kB,"evalua\
teCLSMetricScore");i(Bpe,"getPageResult");i(RB,"getMetricResult");i(Ac,"getMetricTimingResult");i(_B,"getFieldMetricsForInsightSet");i(Upe,"calculateMetricWeightsForSorting");i(SB,"estimateSavingsWithGraphs");i(si,"metricSavingsForWastedBytes");i(By,"isRequestCompressed");i(AB,"isRequestServedFromBrowserCache");i(FB,"getRequestSizes");i(MB,"estimateCompressedContentSize");i(pp,"estimateCompressionRatioForScript");i(fp,"calculateDocFirstByteTs")});var Nx={};C(Nx,{UIStrings:()=>Wa,cachingDisabled:()=>PB,computeCacheLifetimeInSeconds:()=>NB,createOverlayForRequest:()=>BB,createOverlays:()=>Gpe,generateInsight:()=>Hpe,getCombinedHeaders:()=>LB,i18nString:()=>Ox,isCacheable:()=>OB});function qpe(e){return{insightKey:"Cache",strings:Wa,title:Ox(Wa.title),description:Ox(Wa.description),category:Et.ALL,state:e.requests.length>0?"fail":"pass",...e}}function OB(e){return En.NON_NETWORK_SCHEMES.includes(e.args.data.protocol)?!1:!!(En.CACHEABLE_STATUS_CODES.has(e.args.data.statusCode)&&En.STATIC_RESOURCE_TYPES.has(e.args.data.resourceType||"Other"))}function NB(e,t){if(t?.["max-age"]!==void 0)return t["max-age"];let r=e.find(n=>n.name==="expires")?.value??null;if(r){let n=new Date(r).getTime();return n?Math.ceil((n-Date.now())/1e3):0}return null}function zpe(e){let t=[0,.2,1,3,8,12,24,48,72,168,8760,1/0],r=e/3600,n=t.findIndex(u=>u>=r);if(n===t.length-1)return 1;if(n===0)return 0;let a=t[n],o=t[n-1],s=n/10,c=(n-1)/10;return Ax(o,c,a,s,r)}function LB(e){
let t=new Map;for(let r of e){let n=r.name.toLowerCase();t.get(n)?t.set(n,`${t.get(n)}, ${r.value}`):t.set(n,r.value)}return t}function PB(e,t){let r=e?.get("cache-control")??null,n=e?.get("pragma")??null;return!!(!r&&n?.includes("no-cache")||t&&(t["must-revalidate"]||t["no-cache"]||t["no-store"]||t.private))}function Hpe(e,t){let r=i(c=>ae.eventIsInBounds(c,t.bounds),"isWithinContext"),n=e.NetworkRequests.byTime.filter(r),a=[],o=0,s=new Map;for(let c of n){if(!c.args.data.responseHeaders||!OB(c))continue;let u=LB(c.args.data.responseHeaders),l=u.get("cache-control")??null,m=En.parseCacheControl(l);if(PB(u,m))continue;let p=NB(c.args.data.responseHeaders,m);if(p!==null&&(!Number.isFinite(p)||p<=0)||(p=p||0,p/86400>=30))continue;let h=zpe(p);if(h>jpe)continue;let y=c.args.data.encodedDataLength||0,v=(1-h)*y;s.set(c.args.data.requestId,v),o+=v,a.push({request:c,ttl:p,wastedBytes:v})}return a.sort((c,u)=>u.request.args.data.decodedBodyLength-c.request.args.data.decodedBodyLength||c.ttl-u.
ttl),qpe({relatedEvents:a.map(c=>c.request),requests:a,metricSavings:si(s,t),wastedBytes:o})}function BB(e){return{type:"ENTRY_OUTLINE",entry:e,outlineReason:"ERROR"}}function Gpe(e){return e.requests.map(t=>BB(t.request))}var Wa,Ox,jpe,Lx=g(()=>{d();ot();ci();Ly();Mr();Wa={title:"Use efficient cache lifetimes",description:"A long cache lifetime can speed up repeat visits to your page. [Learn more](https://web.dev/uses-long-cache-ttl/).",requestColumn:"Request",cacheTTL:"Cache TTL",noRequestsToCache:"No requests with inefficient cache policies",others:"{PH1} others"},Ox=i((e,t)=>({i18nId:e,values:t}),"i18nString"),jpe=.925;i(qpe,"finalize");i(OB,"isCacheable");i(NB,"computeCacheLifetimeInSeconds");i(zpe,"getCacheHitProbability");i(LB,"getCombinedHeaders");i(PB,"cachingDisabled");i(Hpe,"generateInsight");i(BB,"createOverlayForRequest");i(Gpe,"createOverlays")});var Px={};C(Px,{AnimationFailureReasons:()=>Or,LayoutShiftType:()=>Fc,UIStrings:()=>dn,createOverlays:()=>rfe,generateInsight:()=>tfe,getNonCompositedFailure:()=>jB,i18nString:()=>ms,isCLSCulprits:()=>Xpe});function UB(e,t){let r=e.dur?e.ts+e.dur:e.ts;return r<t.ts&&r>=t.ts-Vpe}function jB(e){let t=[],r=e.args.data.beginEvent,n=e.args.data.instantEvents||[];for(let a of n){let o=a.args.data.compositeFailed,s=a.args.data.unsupportedProperties;if(!o)continue;let c=Wpe.filter(l=>o&l.flag).map(l=>l.failure),u={name:r.args.data.displayName,failureReasons:c,unsupportedProperties:s,animation:e};t.push(u)}return t}function $pe(e,t,r,n){let a=[];for(let o of e){let s=jB(o);if(!s)continue;a.push(...s);let c=Uy(t,o);if(!c||!UB(o,c))continue;let u=r.get(c);if(u)for(let l of u){let m=n.get(l);if(!m)throw new Error("Unaccounted shift");m.nonCompositedAnimations.push(...s)}}return a}function Ype(e,t){let r=new Map;for(let n of t){let a=Hr.nearestIndexFromBeginning(e,o=>o.ts>=n.ts);if(a!==null)for(let o=a;o<
e.length;o++){let s=e[o];if(s.ts>=n.ts&&s.ts<=n.ts+n.dur&&Ne.getWithDefault(r,n,()=>[]).push(s),s.ts>n.ts+n.dur)break}}return r}function Uy(e,t){let r=Hr.nearestIndexFromBeginning(e,n=>n.ts>t.ts+(t.dur||0));if(r!==null)return e[r]}function Kpe(e,t,r,n,a,o){for(let s of t){let c=Uy(r,s);if(!c)continue;let u=n.get(c);if(u)for(let l of u){let m=a.get(l);if(!m)throw new Error("Unaccounted shift");let p=o.find(f=>{let h=O.Micro(s.ts+(s.dur??0));return f.ts>=s.ts&&f.ts<=h});if(p?.args.frame){let f=p.args.frame,h,y=e.Meta.rendererProcessesByFrame.get(f);y&&y.size>0&&(h=[...y.values()][0]?.[0].frame.url),m.iframes.push({frame:f,url:h})}}}return a}function Jpe(e,t,r,n){return r.forEach((a,o)=>{let s=Uy(t,o);if(!s)return;let c=e.find(u=>u.args.data.nodeId===s.args.data.nodeId);if(c)for(let u of a){let l=n.get(u);if(!l)throw new Error("Unaccounted shift");l.unsizedImages.push({backendNodeId:c.args.data.nodeId,paintImageEvent:s})}}),n}function Xpe(e){return e.insightKey===Ke.CLS_CULPRITS}function Zpe(e,t,r,n){
let a=e.filter(o=>o.args.data.resourceType==="Font"&&o.args.data.mimeType.startsWith("font"));for(let o of a){let s=Uy(t,o);if(!s||!UB(o,s))continue;let c=r.get(s);if(c)for(let u of c){let l=n.get(u);if(!l)throw new Error("Unaccounted shift");l.webFonts.push(o)}}return n}function Qpe(e,t){let n=[],a=e.events;for(let o of a){let s=t.get(o);if(!s)continue;let c=s.webFonts,u=s.iframes,l=s.nonCompositedAnimations,m=s.unsizedImages;for(let p=0;p<c.length&&n.length<3;p++)n.push({type:Fc.WEB_FONT,description:ms(dn.webFont)});for(let p=0;p<u.length&&n.length<3;p++)n.push({type:Fc.IFRAMES,description:ms(dn.injectedIframe)});for(let p=0;p<l.length&&n.length<3;p++)n.push({type:Fc.ANIMATIONS,description:ms(dn.animation)});for(let p=0;p<m.length&&n.length<3;p++)n.push({type:Fc.UNSIZED_IMAGE,description:ms(dn.unsizedImage),url:m[p].paintImageEvent.args.data.url||"",backendNodeId:m[p].backendNodeId,frame:m[p].paintImageEvent.args.data.frame||""});if(n.length>=3)break}return n.slice(0,3)}function efe(e){
let t="pass";return e.worstCluster&&(gr.LayoutShifts.scoreClassificationForLayoutShift(e.worstCluster.clusterCumulativeScore)===gr.PageLoadMetrics.ScoreClassification.GOOD?t="informative":t="fail"),{insightKey:Ke.CLS_CULPRITS,strings:dn,title:ms(dn.title),description:ms(dn.description),category:Et.CLS,state:t,...e}}function tfe(e,t){let r=i(I=>ae.eventIsInBounds(I,t.bounds),"isWithinContext"),n=e.Animations.animations.filter(r),a=e.LayoutShifts.renderFrameImplCreateChildFrameEvents.filter(r),o=e.NetworkRequests.byTime.filter(r),s=e.LayoutShifts.domLoadingEvents.filter(r),c=e.LayoutShifts.layoutImageUnsizedEvents.filter(r),u=t.navigation?t.navigationId:b.NO_NAVIGATION,l=e.LayoutShifts.clustersByNavigationId.get(u)??[],p=[...l].sort((I,F)=>F.clusterCumulativeScore-I.clusterCumulativeScore).at(0),f=l.flatMap(I=>I.events),h=e.LayoutShifts.prePaintEvents.filter(r),y=e.LayoutShifts.paintImageEvents.filter(r),v=new Map,E=Ype(f,h);for(let I of f)v.set(I,{iframes:[],webFonts:[],nonCompositedAnimations:[],
unsizedImages:[]});Kpe(e,a,h,E,v,s),Zpe(o,h,E,v),Jpe(c,y,E,v);let T=$pe(n,h,E,v),x=[...f];p&&x.push(p);let S=new Map;for(let I of l)S.set(I,Qpe(I,v));return efe({relatedEvents:x,animationFailures:T,shifts:v,clusters:l,worstCluster:p,topCulpritsByCluster:S})}function rfe(e){let r=(e.clusters.toSorted((o,s)=>s.clusterCumulativeScore-o.clusterCumulativeScore)??[])[0];if(!r)return[];let n=O.Micro(r.dur??0),a=O.Micro(r.ts+n);return[{type:"TIMESPAN_BREAKDOWN",sections:[{bounds:{min:r.ts,range:n,max:a},label:ms(dn.worstLayoutShiftCluster),showDuration:!1}],entry:r.events[0],renderLocation:"ABOVE_EVENT"}]}var dn,ms,Or,Fc,Wpe,Vpe,Bx=g(()=>{d();rr();On();ot();Le();Mr();dn={title:"Layout shift culprits",description:"Layout shifts occur when elements move absent any user interaction. [Investigate the causes of layout shifts](https://web.dev/articles/optimize-cls), such as elements being added, removed, or their fonts changing as the page loads.",worstLayoutShiftCluster:"Worst layout shift cluster",
worstCluster:"Worst cluster",layoutShiftCluster:"Layout shift cluster @ {PH1}",topCulprits:"Top layout shift culprits",injectedIframe:"Injected iframe",webFont:"Web font",animation:"Animation",unsizedImage:"Unsized image element",noLayoutShifts:"No layout shifts",noCulprits:"Could not detect any layout shift culprits"},ms=i((e,t)=>({i18nId:e,values:t}),"i18nString");(function(e){e.ACCELERATED_ANIMATIONS_DISABLED="ACCELERATED_ANIMATIONS_DISABLED",e.EFFECT_SUPPRESSED_BY_DEVTOOLS="EFFECT_SUPPRESSED_BY_DEVTOOLS",e.INVALID_ANIMATION_OR_EFFECT="INVALID_ANIMATION_OR_EFFECT",e.EFFECT_HAS_UNSUPPORTED_TIMING_PARAMS="EFFECT_HAS_UNSUPPORTED_TIMING_PARAMS",e.EFFECT_HAS_NON_REPLACE_COMPOSITE_MODE="EFFECT_HAS_NON_REPLACE_COMPOSITE_MODE",e.TARGET_HAS_INVALID_COMPOSITING_STATE="TARGET_HAS_INVALID_COMPOSITING_STATE",e.TARGET_HAS_INCOMPATIBLE_ANIMATIONS="TARGET_HAS_INCOMPATIBLE_ANIMATIONS",e.TARGET_HAS_CSS_OFFSET="TARGET_HAS_CSS_OFFSET",e.ANIMATION_AFFECTS_NON_CSS_PROPERTIES="ANIMATION_AFFECTS_NON_CSS_PR\
OPERTIES",e.TRANSFORM_RELATED_PROPERTY_CANNOT_BE_ACCELERATED_ON_TARGET="TRANSFORM_RELATED_PROPERTY_CANNOT_BE_ACCELERATED_ON_TARGET",e.TRANSFROM_BOX_SIZE_DEPENDENT="TRANSFROM_BOX_SIZE_DEPENDENT",e.FILTER_RELATED_PROPERTY_MAY_MOVE_PIXELS="FILTER_RELATED_PROPERTY_MAY_MOVE_PIXELS",e.UNSUPPORTED_CSS_PROPERTY="UNSUPPORTED_CSS_PROPERTY",e.MIXED_KEYFRAME_VALUE_TYPES="MIXED_KEYFRAME_VALUE_TYPES",e.TIMELINE_SOURCE_HAS_INVALID_COMPOSITING_STATE="TIMELINE_SOURCE_HAS_INVALID_COMPOSITING_STATE",e.ANIMATION_HAS_NO_VISIBLE_CHANGE="ANIMATION_HAS_NO_VISIBLE_CHANGE",e.AFFECTS_IMPORTANT_PROPERTY="AFFECTS_IMPORTANT_PROPERTY",e.SVG_TARGET_HAS_INDEPENDENT_TRANSFORM_PROPERTY="SVG_TARGET_HAS_INDEPENDENT_TRANSFORM_PROPERTY"})(Or||(Or={}));(function(e){e[e.WEB_FONT=0]="WEB_FONT",e[e.IFRAMES=1]="IFRAMES",e[e.ANIMATIONS=2]="ANIMATIONS",e[e.UNSIZED_IMAGE=3]="UNSIZED_IMAGE"})(Fc||(Fc={}));Wpe=[{flag:1,failure:Or.ACCELERATED_ANIMATIONS_DISABLED},{flag:2,failure:Or.EFFECT_SUPPRESSED_BY_DEVTOOLS},{flag:4,failure:Or.INVALID_ANIMATION_OR_EFFECT},
{flag:8,failure:Or.EFFECT_HAS_UNSUPPORTED_TIMING_PARAMS},{flag:16,failure:Or.EFFECT_HAS_NON_REPLACE_COMPOSITE_MODE},{flag:32,failure:Or.TARGET_HAS_INVALID_COMPOSITING_STATE},{flag:64,failure:Or.TARGET_HAS_INCOMPATIBLE_ANIMATIONS},{flag:128,failure:Or.TARGET_HAS_CSS_OFFSET},{flag:512,failure:Or.ANIMATION_AFFECTS_NON_CSS_PROPERTIES},{flag:1024,failure:Or.TRANSFORM_RELATED_PROPERTY_CANNOT_BE_ACCELERATED_ON_TARGET},{flag:2048,failure:Or.TRANSFROM_BOX_SIZE_DEPENDENT},{flag:4096,failure:Or.FILTER_RELATED_PROPERTY_MAY_MOVE_PIXELS},{flag:8192,failure:Or.UNSUPPORTED_CSS_PROPERTY},{flag:32768,failure:Or.MIXED_KEYFRAME_VALUE_TYPES},{flag:65536,failure:Or.TIMELINE_SOURCE_HAS_INVALID_COMPOSITING_STATE},{flag:1<<17,failure:Or.ANIMATION_HAS_NO_VISIBLE_CHANGE},{flag:1<<18,failure:Or.AFFECTS_IMPORTANT_PROPERTY},{flag:1<<19,failure:Or.SVG_TARGET_HAS_INDEPENDENT_TRANSFORM_PROPERTY}],Vpe=ae.secondsToMicro(O.Seconds(.5));i(UB,"isInRootCauseWindow");i(jB,"getNonCompositedFailure");i($pe,"getNonCompositedFai\
lureRootCauses");i(Ype,"getShiftsByPrePaintEvents");i(Uy,"getNextEvent");i(Kpe,"getIframeRootCauses");i(Jpe,"getUnsizedImageRootCauses");i(Xpe,"isCLSCulprits");i(Zpe,"getFontRootCauses");i(Qpe,"getTopCulprits");i(efe,"finalize");i(tfe,"generateInsight");i(rfe,"createOverlays")});var jx={};C(jx,{UIStrings:()=>Qr,createOverlays:()=>ufe,generateInsight:()=>cfe,i18nString:()=>Da,isDocumentLatency:()=>ofe});function ofe(e){return e.insightKey==="DocumentLatency"}function ife(e,t){let r=t.navigation&&t.lantern?.requests.find(o=>o.rawRequest===e);if(r?.serverResponseTime!==void 0)return r.serverResponseTime;if(!e.args.data.timing)return null;let a=ae.microToMilli(e.args.data.syntheticData.waiting);return Math.round(a)}function sfe(e){if(By(e))return 0;let r=e.args.data.decodedBodyLength,n=0;switch(e.args.data.mimeType){case"text/css":n=Math.round(r*.8);break;case"text/html":case"text/javascript":n=Math.round(r*.67);break;case"text/plain":case"text/xml":case"text/x-component":case"application/javascript":case"application/json":case"application/manifest+json":case"application/vnd.api+json":case"application/xml":case"application/xhtml+xml":case"application/rss+xml":case"application/atom+xml":case"application/vnd.ms-fontobject":case"application/x-font-ttf":case"applicati\
on/x-font-opentype":case"application/x-font-truetype":case"image/svg+xml":case"image/x-icon":case"image/vnd.microsoft.icon":case"font/ttf":case"font/eot":case"font/otf":case"font/opentype":n=Math.round(r*.5);break;default:}return n<afe?0:n}function Ux(e){let t=!1;return e.data&&(t=!e.data.checklist.usesCompression.value||!e.data.checklist.serverResponseIsFast.value||!e.data.checklist.noRedirects.value),{insightKey:Ke.DOCUMENT_LATENCY,strings:Qr,title:Da(Qr.title),description:Da(Qr.description),category:Et.ALL,state:t?"fail":"pass",...e}}function cfe(e,t){if(!t.navigation)return Ux({});let r=e.NetworkRequests.byId.get(t.navigationId);if(!r)return Ux({warnings:[Nn.NO_DOCUMENT_REQUEST]});let n=ife(r,t);if(n===null)throw new Error("missing document request timing");let a=n>qB,o=0;n>qB&&(o=Math.max(n-nfe,0));let s=Math.round(r.args.data.syntheticData.redirectionDuration/1e3);o+=s;let c={FCP:o,LCP:o},u=sfe(r),l=s===0,m=!a,p=u===0;return Ux({relatedEvents:[r],data:{serverResponseTime:n,redirectDuration:O.
Milli(s),uncompressedResponseBytes:u,documentRequest:r,checklist:{noRedirects:{label:l?Da(Qr.passingRedirects):Da(Qr.failedRedirects,{PH1:r.args.data.redirects.length,PH2:(f=>({__i18nMillis:f}))(s)}),value:l},serverResponseIsFast:{label:m?Da(Qr.passingServerResponseTime,{PH1:(f=>({__i18nMillis:f}))(n)}):Da(Qr.failedServerResponseTime,{PH1:(f=>({__i18nMillis:f}))(n)}),value:m},usesCompression:{label:Da(p?Qr.passingTextCompression:Qr.failedTextCompression),value:p}}},metricSavings:c,wastedBytes:u})}function ufe(e){if(!e.data?.documentRequest)return[];let t=[],r=e.data.documentRequest,n=ae.milliToMicro(e.data.redirectDuration),a=[];if(e.data.redirectDuration){let o=ae.traceWindowFromMicroSeconds(r.ts,r.ts+n);a.push({bounds:o,label:Da(Qr.redirectsLabel),showDuration:!0}),t.push({type:"CANDY_STRIPED_TIME_RANGE",bounds:o,entry:r})}if(!e.data.checklist.serverResponseIsFast.value){let o=ae.milliToMicro(e.data.serverResponseTime),s=r.args.data.timing?.sendEnd??O.Milli(0),c=ae.milliToMicro(s),u=ae.
traceWindowFromMicroSeconds(c,c+o);a.push({bounds:u,label:Da(Qr.serverResponseTimeLabel),showDuration:!0})}if(e.data.uncompressedResponseBytes){let o=ae.traceWindowFromMicroSeconds(r.args.data.syntheticData.downloadStart,r.args.data.syntheticData.downloadStart+r.args.data.syntheticData.download);a.push({bounds:o,label:Da(Qr.uncompressedDownload),showDuration:!0}),t.push({type:"CANDY_STRIPED_TIME_RANGE",bounds:o,entry:r})}return a.length&&t.push({type:"TIMESPAN_BREAKDOWN",sections:a,entry:e.data.documentRequest,renderLocation:"BELOW_EVENT"}),t.push({type:"ENTRY_SELECTED",entry:e.data.documentRequest}),t}var Qr,Da,qB,nfe,afe,qx=g(()=>{d();ot();Le();ci();Mr();Qr={title:"Document request latency",description:"Your first network request is the most important.  Reduce its latency by avoiding redirects, ensuring a fast server response, and enabling text compression.",passingRedirects:"Avoids redirects",failedRedirects:"Had redirects ({PH1} redirects, +{PH2})",passingServerResponseTime:"Server\
 responds quickly (observed {PH1})",failedServerResponseTime:"Server responded slowly (observed {PH1})",passingTextCompression:"Applies text compression",failedTextCompression:"No compression applied",redirectsLabel:"Redirects",serverResponseTimeLabel:"Server response time",uncompressedDownload:"Uncompressed download"},Da=i((e,t)=>({i18nId:e,values:t}),"i18nString"),qB=600,nfe=100,afe=1400;i(ofe,"isDocumentLatency");i(ife,"getServerResponseTime");i(sfe,"getCompressionSavings");i(Ux,"finalize");i(cfe,"generateInsight");i(ufe,"createOverlays")});var zx={};C(zx,{UIStrings:()=>mn,createOverlays:()=>ffe,generateInsight:()=>pfe,i18nString:()=>hp});function mfe(e){let t=[...e.largeLayoutUpdates,...e.largeStyleRecalcs];return{insightKey:Ke.DOM_SIZE,strings:mn,title:hp(mn.title),description:hp(mn.description),category:Et.INP,state:t.length>0?"informative":"pass",...e,relatedEvents:t}}function pfe(e,t){let r=i(m=>ae.eventIsInBounds(m,t.bounds),"isWithinContext"),n=t.navigation?.tid,a=[],o=[],s=_c.threadsInRenderer(e.Renderer,e.AuctionWorklets);for(let m of s){if(m.type!==_c.ThreadType.MAIN_THREAD)continue;if(n===void 0){if(!m.processIsOnMainFrame)continue}else if(m.tid!==n)continue;let p=e.Renderer.processes.get(m.pid)?.threads.get(m.tid);if(!p)continue;let{entries:f,layoutEvents:h,updateLayoutTreeEvents:y}=p;if(!f.length)continue;let v=f[0],E=f[f.length-1],T=ae.traceWindowFromMicroSeconds(v.ts,O.Micro(E.ts+(E.dur??0)));if(ae.boundsIncludeTimeRange({timeRange:T,bounds:t.bounds})){for(let x of h){if(x.dur<zB||!r(x))continue;let{dirtyObjects:S}=x.
args.beginData;S>lfe&&a.push(x)}for(let x of y){if(x.dur<zB||!r(x))continue;let{elementCount:S}=x.args;S>dfe&&o.push(x)}}}let c=[...a.map(m=>{let p=m.dur/1e3,f=m.args.beginData.dirtyObjects;return{label:hp(mn.largeLayout,{PH1:f}),duration:p,size:f,event:m}}),...o.map(m=>{let p=m.dur/1e3,f=m.args.elementCount;return{label:hp(mn.largeStyleRecalc,{PH1:f}),duration:p,size:f,event:m}})].sort((m,p)=>p.duration-m.duration).slice(0,5),u=e.DOMStats.domStatsByFrameId.get(t.frameId)?.filter(r)??[],l;for(let m of u){let p=t.navigation?.pid;p&&m.pid!==p||(!l||m.args.data.totalElements>l.args.data.totalElements)&&(l=m)}return mfe({largeLayoutUpdates:a,largeStyleRecalcs:o,largeUpdates:c,maxDOMStats:l})}function ffe(e){return[...e.largeStyleRecalcs,...e.largeLayoutUpdates].map(r=>({type:"ENTRY_OUTLINE",entry:r,outlineReason:"ERROR"}))}var mn,hp,zB,lfe,dfe,Hx=g(()=>{d();On();ot();Le();Mr();mn={title:"Optimize DOM size",description:"A large DOM can increase the duration of style calculations and layout \
reflows, impacting page responsiveness. A large DOM will also increase memory usage. [Learn how to avoid an excessive DOM size](https://developer.chrome.com/docs/lighthouse/performance/dom-size/).",statistic:"Statistic",value:"Value",element:"Element",totalElements:"Total elements",maxDOMDepth:"DOM depth",maxChildren:"Most children",topUpdatesDescription:"These are the largest layout and style recalculation events. Their performance impact may be reduced by making the DOM simpler.",duration:"Duration",largeLayout:"Layout ({PH1} objects)",largeStyleRecalc:"Style recalculation ({PH1} elements)"},hp=i((e,t)=>({i18nId:e,values:t}),"i18nString"),zB=ae.milliToMicro(O.Milli(40)),lfe=100,dfe=300;i(mfe,"finalize");i(pfe,"generateInsight");i(ffe,"createOverlays")});var Wx={};C(Wx,{UIStrings:()=>Do,createOverlays:()=>vfe,generateInsight:()=>yfe,i18nString:()=>Gx,isDuplicatedJavaScript:()=>gfe});function hfe(e){let t=e.scriptsWithDuplication.map(r=>r.request).filter(r=>!!r);return{insightKey:Ke.DUPLICATE_JAVASCRIPT,strings:Do,title:Gx(Do.title),description:Gx(Do.description),category:Et.LCP,state:e.duplication.values().next().value?"fail":"pass",relatedEvents:[...new Set(t)],...e}}function gfe(e){return e.insightKey===Ke.DUPLICATE_JAVASCRIPT}function yfe(e,t){let r=e.Scripts.scripts.filter(u=>u.frame!==t.frameId||u.url?.startsWith("chrome-extension://")?!1:ae.timestampIsInBounds(t.bounds,u.ts)),n=new Map;for(let u of r)u.request&&n.set(u.request.args.data.requestId,pp(u));let{duplication:a,duplicationGroupedByNodeModules:o}=Cy.computeScriptDuplication({scripts:r},n),s=[...a.values().flatMap(u=>u.duplicates.map(l=>l.script))],c=new Map;for(let{duplicates:u}of a.values())for(let l=1;l<u.length;l++){let m=u[l];if(!m.script.request)continue;let p=m.attributedSize,
f=m.script.request.args.data.requestId;c.set(f,(c.get(f)||0)+p)}return hfe({duplication:a,duplicationGroupedByNodeModules:o,scriptsWithDuplication:[...new Set(s)],scripts:r,mainDocumentUrl:t.navigation?.args.data?.url??e.Meta.mainFrameURL,metricSavings:si(c,t),wastedBytes:c.values().reduce((u,l)=>u+l,0)})}function vfe(e){return e.scriptsWithDuplication.map(t=>t.request).filter(t=>!!t).map(t=>({type:"ENTRY_OUTLINE",entry:t,outlineReason:"ERROR"}))}var Do,Gx,Vx=g(()=>{d();dp();ot();ci();Mr();Do={title:"Duplicated JavaScript",description:"Remove large, duplicate JavaScript modules from bundles to reduce unnecessary bytes consumed by network activity.",columnSource:"Source",columnDuplicatedBytes:"Duplicated bytes"},Gx=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(hfe,"finalize");i(gfe,"isDuplicatedJavaScript");i(yfe,"generateInsight");i(vfe,"createOverlays")});var Yx={};C(Yx,{UIStrings:()=>ui,createOverlays:()=>Efe,generateInsight:()=>wfe,i18nString:()=>$x});function bfe(e){return{insightKey:Ke.FONT_DISPLAY,strings:ui,title:$x(ui.title),description:$x(ui.description),category:Et.INP,state:e.fonts.find(t=>t.wastedTime>0)?"fail":"pass",...e}}function wfe(e,t){let r=[];for(let a of e.LayoutShifts.remoteFonts){let o=a.beginRemoteFontLoadEvent;if(!ae.eventIsInBounds(o,t.bounds))continue;let s=`${o.pid}.${o.args.id}`,c=e.NetworkRequests.byId.get(s);if(!c||!/^(block|fallback|auto)$/.test(a.display))continue;let u=O.Micro(c.args.data.syntheticData.finishTime-c.args.data.syntheticData.sendStartTime),l=vo.floor(ae.microToMilli(u),1/5);l!==0&&(l=Math.min(l,3e3),r.push({name:a.name,request:c,display:a.display,wastedTime:l}))}r.sort((a,o)=>o.wastedTime-a.wastedTime);let n=Math.max(...r.map(a=>a.wastedTime));return bfe({relatedEvents:r.map(a=>a.request),fonts:r,metricSavings:{FCP:n}})}function Efe(e){return e.fonts.map(t=>({type:"ENTRY_OUTLINE",entry:t.request,
outlineReason:t.wastedTime?"ERROR":"INFO"}))}var ui,$x,Kx=g(()=>{d();rr();ot();Le();Mr();ui={title:"Font display",description:"Consider setting [`font-display`](https://developer.chrome.com/blog/font-display) to `swap` or `optional` to ensure text is consistently visible. `swap` can be further optimized to mitigate layout shifts with [font metric overrides](https://developer.chrome.com/blog/font-fallbacks).",fontColumn:"Font",wastedTimeColumn:"Wasted time"},$x=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(bfe,"finalize");i(wfe,"generateInsight");i(Efe,"createOverlays")});var Zx={};C(Zx,{UIStrings:()=>la,createOverlayForEvents:()=>Xx,createOverlays:()=>Cfe,generateInsight:()=>Sfe,i18nString:()=>Jx});function HB(e){return e.scriptId+":"+e.lineNumber+":"+e.columnNumber}function Dfe(e,t){let r=t.Renderer.entryToNode,n=new Map;if(e.length===0)return;for(let o of e){let s=r.get(o);if(!s)continue;let c=s.parent,u,l;for(;c;){let f=c.entry;if(b.isProfileCall(f))u=f.callFrame,l=f;else{b.isFunctionCall(f)&&f.args.data&&b.objectIsCallFrame(f.args.data)&&(u=f.args.data,l=f);break}c=c.parent}if(!u||!l)continue;let m=HB(u),p=Ne.getWithDefault(n,m,()=>({topLevelFunctionCall:u,totalReflowTime:0,topLevelFunctionCallEvents:[]}));p.totalReflowTime+=o.dur??0,p.topLevelFunctionCallEvents.push(l)}let a;return n.forEach(o=>{(!a||o.totalReflowTime>a.totalReflowTime)&&(a=o)}),a}function Tfe(e){return{insightKey:Ke.FORCED_REFLOW,strings:la,title:Jx(la.title),description:Jx(la.description),category:Et.ALL,state:e.aggregatedBottomUpData.length!==0?"fail":"pass",...e}}function xfe(e,t){
let r=Iy.get(e,t),n=Me.getZeroIndexedStackTraceInEventPayload(e);return r?.callFrames[0]??n?.[0]??null}function Sfe(e,t){let r=i(s=>Me.frameIDForEvent(s)!==t.frameId?!1:ae.eventIsInBounds(s,t.bounds),"isWithinContext"),n=new Map,a=e.Warnings.perWarning.get("FORCED_REFLOW")?.filter(r)??[];for(let s of a){let c=xfe(s,e),u=c?HB(c):"UNATTRIBUTED",l=Ne.getWithDefault(n,u,()=>({bottomUpData:c,totalTime:0,relatedEvents:[]}));l.totalTime+=s.dur??0,l.relatedEvents.push(s)}let o=Dfe(a,e);return Tfe({relatedEvents:a,topLevelFunctionCallData:o,aggregatedBottomUpData:[...n.values()]})}function Cfe(e){if(!e.topLevelFunctionCallData)return[];let t=[...e.aggregatedBottomUpData.values().flatMap(r=>r.relatedEvents)];return[...Xx(e.topLevelFunctionCallData.topLevelFunctionCallEvents,"INFO"),...Xx(t)]}function Xx(e,t="ERROR"){return e.map(r=>({type:"ENTRY_OUTLINE",entry:r,outlineReason:t}))}var la,Jx,Qx=g(()=>{d();rr();dp();ot();Le();Mr();la={title:"Forced reflow",description:"A forced reflow occurs when \
JavaScript queries geometric properties (such as `offsetWidth`) after styles have been invalidated by a change to the DOM state. This can result in poor performance. Learn more about [forced reflows](https://developers.google.com/web/fundamentals/performance/rendering/avoid-large-complex-layouts-and-layout-thrashing#avoid-forced-synchronous-layouts) and possible mitigations.",relatedStackTrace:"Stack trace",topTimeConsumingFunctionCall:"Top function call",totalReflowTime:"Total reflow time",unattributed:"[unattributed]",anonymous:"(anonymous)"},Jx=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(HB,"getCallFrameId");i(Dfe,"getLargestTopLevelFunctionData");i(Tfe,"finalize");i(xfe,"getBottomCallFrameForEvent");i(Sfe,"generateInsight");i(Cfe,"createOverlays");i(Xx,"createOverlayForEvents")});var qy={};C(qy,{ImageOptimizationType:()=>Va,UIStrings:()=>Kn,createOverlayForRequest:()=>$B,createOverlays:()=>Ofe,generateInsight:()=>Mfe,getOptimizationMessage:()=>jy,getOptimizationMessageWithBytes:()=>WB,i18nString:()=>ps,isImageDelivery:()=>_fe});function _fe(e){return e.insightKey==="ImageDelivery"}function jy(e){switch(e.type){case Va.ADJUST_COMPRESSION:return ps(Kn.useCompression);case Va.MODERN_FORMAT_OR_COMPRESSION:return ps(Kn.useModernFormat);case Va.VIDEO_FORMAT:return ps(Kn.useVideoFormat);case Va.RESPONSIVE_SIZE:return ps(Kn.useResponsiveSize,{PH1:`${e.fileDimensions.width}x${e.fileDimensions.height}`,PH2:`${e.displayDimensions.width}x${e.displayDimensions.height}`})}}function WB(e){let t=(n=>({__i18nBytes:n}))(e.byteSavings),r=jy(e);return ps(Kn.estimatedSavings,{PH1:r,PH2:t})}function Afe(e){return{insightKey:Ke.IMAGE_DELIVERY,strings:Kn,title:ps(Kn.title),description:ps(Kn.description),category:Et.LCP,state:e.optimizableImages.length>0?"fail":"pass",...e,relatedEvents:new Map(
e.optimizableImages.map(t=>[t.request,t.optimizations.map(WB)]))}}function Ffe(e){return Math.round(29.1*Math.log10(e.args.data.decodedBodyLength)-100.7)/100}function VB(e,t){return e.ImagePainting.paintEventToCorrectedDisplaySize.get(t)??{width:t.args.data.width,height:t.args.data.height}}function eS(e,t){let{width:r,height:n}=VB(e,t);return{filePixels:t.args.data.srcWidth*t.args.data.srcHeight,displayedPixels:r*n}}function Mfe(e,t){let r=i(s=>ae.eventIsInBounds(s,t.bounds),"isWithinContext"),n=e.NetworkRequests.byTime.filter(r),a=[];for(let s of n){if(s.args.data.resourceType!=="Image"||s.args.data.mimeType==="image/svg+xml")continue;let c=s.args.data.redirects[0]?.url??s.args.data.url,u=e.ImagePainting.paintImageEventForUrl.get(c)?.filter(r);if(!u?.length)continue;let l=u.reduce((x,S)=>{let I=eS(e,x).displayedPixels,F=eS(e,S).displayedPixels;return I>F?x:S}),{filePixels:m,displayedPixels:p}=eS(e,l),f=Math.min(s.args.data.decodedBodyLength,s.args.data.encodedDataLength),h=f/m,y=[];if(s.
args.data.mimeType==="image/gif"){if(f>Ife){let x=Ffe(s),S=Math.round(f*x);y.push({type:Va.VIDEO_FORMAT,byteSavings:S})}}else if(h>GB){let x=Math.round(GB*m),S=f-x;s.args.data.mimeType!=="image/webp"&&s.args.data.mimeType!=="image/avif"?y.push({type:Va.MODERN_FORMAT_OR_COMPRESSION,byteSavings:S}):y.push({type:Va.ADJUST_COMPRESSION,byteSavings:S})}let v=Math.max(0,...y.map(x=>x.byteSavings)),E=v,T=1-p/m;if(T>0&&!l.args.data.isCSS){let x=Math.round(T*f);if(!(l.args.data.isPicture||l.args.data.srcsetAttribute)||x>Rfe){E+=Math.round(T*(f-v));let{width:I,height:F}=VB(e,l);y.push({type:Va.RESPONSIVE_SIZE,byteSavings:x,fileDimensions:{width:Math.round(l.args.data.srcWidth),height:Math.round(l.args.data.srcHeight)},displayDimensions:{width:Math.round(I),height:Math.round(F)}})}}y=y.filter(x=>x.byteSavings>kfe),y.length>0&&a.push({request:s,largestImagePaint:l,optimizations:y,byteSavings:E})}let o=new Map;for(let s of a)o.set(s.request.args.data.requestId,s.byteSavings);return a.sort((s,c)=>c.byteSavings!==
s.byteSavings?c.byteSavings-s.byteSavings:c.request.args.data.decodedBodyLength-s.request.args.data.decodedBodyLength),Afe({optimizableImages:a,metricSavings:si(o,t),wastedBytes:a.reduce((s,c)=>s+c.byteSavings,0)})}function $B(e){return{type:"ENTRY_OUTLINE",entry:e,outlineReason:"ERROR"}}function Ofe(e){return e.optimizableImages.map(t=>$B(t.request))}var Kn,ps,GB,Ife,kfe,Rfe,Va,zy=g(()=>{d();ot();ci();Mr();Kn={title:"Improve image delivery",description:"Reducing the download time of images can improve the perceived load time of the page and LCP. [Learn more about optimizing image size](https://developer.chrome.com/docs/lighthouse/performance/uses-optimized-images/)",useCompression:"Increasing the image compression factor could improve this image's download size.",useModernFormat:"Using a modern image format (WebP, AVIF) or increasing the image compression could improve this image's download size.",useVideoFormat:"Using video formats instead of GIFs can improve the download size of ani\
mated content.",useResponsiveSize:"This image file is larger than it needs to be ({PH1}) for its displayed dimensions ({PH2}). Use responsive images to reduce the image download size.",optimizeFile:"Optimize file size",others:"{PH1} others",noOptimizableImages:"No optimizable images",estimatedSavings:"{PH1} (Est {PH2})"},ps=i((e,t)=>({i18nId:e,values:t}),"i18nString"),GB=2/12,Ife=100*1024,kfe=4096,Rfe=12288;(function(e){e.ADJUST_COMPRESSION="ADJUST_COMPRESSION",e.MODERN_FORMAT_OR_COMPRESSION="MODERN_FORMAT_OR_COMPRESSION",e.VIDEO_FORMAT="VIDEO_FORMAT",e.RESPONSIVE_SIZE="RESPONSIVE_SIZE"})(Va||(Va={}));i(_fe,"isImageDelivery");i(jy,"getOptimizationMessage");i(WB,"getOptimizationMessageWithBytes");i(Afe,"finalize");i(Ffe,"estimateGIFPercentSavings");i(VB,"getDisplayedSize");i(eS,"getPixelCounts");i(Mfe,"generateInsight");i($B,"createOverlayForRequest");i(Ofe,"createOverlays")});var tS={};C(tS,{UIStrings:()=>Dn,createOverlays:()=>Pfe,createOverlaysForSubpart:()=>KB,generateInsight:()=>Lfe,i18nString:()=>cl,isINPBreakdown:()=>Nfe});function Nfe(e){return e.insightKey===Ke.INP_BREAKDOWN}function YB(e){return{insightKey:Ke.INP_BREAKDOWN,strings:Dn,title:cl(Dn.title),description:cl(Dn.description),category:Et.INP,state:e.longestInteractionEvent?"informative":"pass",...e}}function Lfe(e,t){let r=e.UserInteractions.interactionEventsWithNoNesting.filter(s=>ae.eventIsInBounds(s,t.bounds));if(!r.length)return YB({});let n=new Map;for(let s of r){let c=s.interactionId,u=n.get(c);(!u||s.dur>u.dur)&&n.set(c,s)}let a=[...n.values()];a.sort((s,c)=>c.dur-s.dur);let o=Math.min(9,Math.floor(a.length/50));return YB({relatedEvents:[a[0]],longestInteractionEvent:a[0],highPercentileInteractionEvent:a[o]})}function KB(e,t=-1){let r=ae.traceWindowFromMicroSeconds(e.ts,e.ts+e.inputDelay),n=ae.traceWindowFromMicroSeconds(r.max,r.max+e.mainThreadHandling),a=ae.traceWindowFromMicroSeconds(
n.max,n.max+e.presentationDelay),o=[{bounds:r,label:cl(Dn.inputDelay),showDuration:!0},{bounds:n,label:cl(Dn.processingDuration),showDuration:!0},{bounds:a,label:cl(Dn.presentationDelay),showDuration:!0}];return t!==-1&&(o=[o[t]]),[{type:"TIMESPAN_BREAKDOWN",sections:o,renderLocation:"BELOW_EVENT",entry:e}]}function Pfe(e){let t=e.longestInteractionEvent;return t?KB(t):[]}var Dn,cl,rS=g(()=>{d();ot();Mr();Dn={description:"Start investigating with the longest subpart. [Delays can be minimized](https://web.dev/articles/optimize-inp#optimize_interactions). To reduce processing duration, [optimize the main-thread costs](https://web.dev/articles/optimize-long-tasks), often JS.",title:"INP breakdown",subpart:"Subpart",duration:"Duration",inputDelay:"Input delay",processingDuration:"Processing duration",presentationDelay:"Presentation delay",noInteractions:"No interactions detected"},cl=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Nfe,"isINPBreakdown");i(YB,"finalize");i(Lfe,"generateInsigh\
t");i(KB,"createOverlaysForSubpart");i(Pfe,"createOverlays")});var nS={};C(nS,{UIStrings:()=>Gr,createOverlays:()=>qfe,generateInsight:()=>jfe,i18nString:()=>fs,isLCPBreakdown:()=>Bfe});function Bfe(e){return e.insightKey==="LCPBreakdown"}function JB(...e){return e.some(t=>Number.isNaN(t))}function Ufe(e,t,r,n){let a=fp(t);if(a===null)return null;let o=ae.traceWindowFromMicroSeconds(e.ts,a);o.label=fs(Gr.timeToFirstByte);let s=ae.traceWindowFromMicroSeconds(o.max,r.ts);if(s.label=fs(Gr.elementRenderDelay),!n)return JB(o.range,s.range)?null:{ttfb:o,renderDelay:s};let c=n.ts,u=n.args.data.syntheticData.finishTime,l=ae.traceWindowFromMicroSeconds(o.max,c),m=ae.traceWindowFromMicroSeconds(c,u);return s=ae.traceWindowFromMicroSeconds(u,r.ts),l.label=fs(Gr.resourceLoadDelay),m.label=fs(Gr.resourceLoadDuration),s.label=fs(Gr.elementRenderDelay),JB(o.range,l.range,m.range,s.range)?null:{ttfb:o,loadDelay:l,loadDuration:m,renderDelay:s}}function Hy(e){let t=[];return e.lcpEvent&&t.push(e.lcpEvent),e.lcpRequest&&t.push(e.lcpRequest),{insightKey:Ke.LCP_BREAKDOWN,
strings:Gr,title:fs(Gr.title),description:fs(Gr.description),category:Et.LCP,state:e.lcpEvent||e.lcpRequest?"informative":"pass",...e,relatedEvents:t}}function jfe(e,t){if(!t.navigation)return Hy({});let r=e.NetworkRequests,n=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId);if(!n)throw new Error("no frame metrics");let a=n.get(t.navigationId);if(!a)throw new Error("no navigation metrics");let o=a.get(gr.PageLoadMetrics.MetricName.LCP),s=o?.event;if(!s||!b.isLargestContentfulPaintCandidate(s))return Hy({warnings:[Nn.NO_LCP]});let c=ae.microToMilli(o.timing),u=o.event?.ts?ae.microToMilli(o.event?.ts):void 0,l=e.LargestImagePaint.lcpRequestByNavigationId.get(t.navigationId),m=r.byId.get(t.navigationId);return Hy(m?{lcpMs:c,lcpTs:u,lcpEvent:s,lcpRequest:l,subparts:Ufe(t.navigation,m,s,l)??void 0}:{lcpMs:c,lcpTs:u,lcpEvent:s,lcpRequest:l,warnings:[Nn.NO_DOCUMENT_REQUEST]})}function qfe(e){if(!e.subparts||!e.lcpTs)return[];let t=[{type:"TIMESPAN_BREAKDOWN",sections:Object.values(e.subparts).
map(r=>({bounds:r,label:r.label,showDuration:!0}))}];return e.lcpRequest&&t.push({type:"ENTRY_OUTLINE",entry:e.lcpRequest,outlineReason:"INFO"}),t}var Gr,fs,aS=g(()=>{d();On();ot();Le();ci();Mr();Gr={title:"LCP breakdown",description:"Each [subpart has specific improvement strategies](https://web.dev/articles/optimize-lcp#lcp-breakdown). Ideally, most of the LCP time should be spent on loading the resources, not within delays.",timeToFirstByte:"Time to first byte",resourceLoadDelay:"Resource load delay",resourceLoadDuration:"Resource load duration",elementRenderDelay:"Element render delay",subpart:"Subpart",duration:"Duration",fieldDuration:"Field p75",noLcp:"No LCP detected"},fs=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Bfe,"isLCPBreakdown");i(JB,"anyValuesNaN");i(Ufe,"determineSubparts");i(Hy,"finalize");i(jfe,"generateInsight");i(qfe,"createOverlays")});var oS={};C(oS,{UIStrings:()=>da,createOverlays:()=>Gfe,generateInsight:()=>Hfe,getImageData:()=>XB,i18nString:()=>Mc,isLCPDiscovery:()=>zfe});function zfe(e){return e.insightKey==="LCPDiscovery"}function gp(e){let t=e.lcpEvent&&e.lcpRequest?[e.lcpEvent,e.lcpRequest]:[];return{insightKey:Ke.LCP_DISCOVERY,strings:da,title:Mc(da.title),description:Mc(da.description),category:Et.LCP,state:e.lcpRequest&&e.checklist&&(!e.checklist.eagerlyLoaded.value||!e.checklist.requestDiscoverable.value||!e.checklist.priorityHinted.value)?"fail":"pass",...e,relatedEvents:t}}function Hfe(e,t){if(!t.navigation)return gp({});let r=e.NetworkRequests,n=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId);if(!n)throw new Error("no frame metrics");let a=n.get(t.navigationId);if(!a)throw new Error("no navigation metrics");let s=a.get(gr.PageLoadMetrics.MetricName.LCP)?.event;if(!s||!b.isLargestContentfulPaintCandidate(s))return gp({warnings:[Nn.NO_LCP]});let c=r.byId.get(t.navigationId);if(!c)return gp({warnings:[
Nn.NO_DOCUMENT_REQUEST]});let u=e.LargestImagePaint.lcpRequestByNavigationId.get(t.navigationId);if(!u)return gp({lcpEvent:s});let l=u.args.data.initiator?.url,m=u?.args.data.initiator?.type==="parser"&&c.args.data.url===l,p=u?.args.data.isLinkPreload||m,f=s.args.data?.loadingAttr,h=u?.args.data.fetchPriorityHint,y=fp(c),v=h==="high";return gp({lcpEvent:s,lcpRequest:u,earliestDiscoveryTimeTs:y?O.Micro(y):void 0,checklist:{priorityHinted:{label:Mc(v?da.fetchPriorityApplied:da.fetchPriorityShouldBeApplied),value:v},requestDiscoverable:{label:Mc(da.requestDiscoverable),value:p},eagerlyLoaded:{label:Mc(da.lazyLoadNotApplied),value:f!=="lazy"}}})}function XB(e){if(!e.lcpRequest||!e.checklist)return null;let t=!e.checklist.priorityHinted.value,r=!e.checklist.requestDiscoverable.value,n=!e.checklist.eagerlyLoaded.value;if(!(t!==void 0&&r!==void 0&&n!==void 0))return null;let o={checklist:e.checklist,request:e.lcpRequest,discoveryDelay:null,estimatedSavings:e.metricSavings?.LCP??null};if(e.earliestDiscoveryTimeTs&&
e.lcpRequest){let s=e.lcpRequest.ts-e.earliestDiscoveryTimeTs;o.discoveryDelay=O.Micro(s)}return o}function Gfe(e){let t=XB(e);if(!t?.discoveryDelay)return[];let r=ae.traceWindowFromMicroSeconds(O.Micro(t.request.ts-t.discoveryDelay),t.request.ts);return[{type:"ENTRY_OUTLINE",entry:t.request,outlineReason:"ERROR"},{type:"CANDY_STRIPED_TIME_RANGE",bounds:r,entry:t.request},{type:"TIMESPAN_BREAKDOWN",sections:[{bounds:r,label:`${t.discoveryDelay} microseconds`,showDuration:!1}],entry:t.request,renderLocation:"ABOVE_EVENT"}]}var da,Mc,iS=g(()=>{d();On();ot();Le();ci();Mr();da={title:"LCP request discovery",description:"Optimize LCP by making the LCP image [discoverable](https://web.dev/articles/optimize-lcp#1_eliminate_resource_load_delay) from the HTML immediately, and [avoiding lazy-loading](https://web.dev/articles/lcp-lazy-loading)",lcpLoadDelay:"LCP image loaded {PH1} after earliest start point.",fetchPriorityApplied:"fetchpriority=high applied",fetchPriorityShouldBeApplied:"fetchpri\
ority=high should be applied",requestDiscoverable:"Request is discoverable in initial document",lazyLoadNotApplied:"lazy load not applied",noLcp:"No LCP detected",noLcpResource:"No LCP resource detected because the LCP is not an image"},Mc=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(zfe,"isLCPDiscovery");i(gp,"finalize");i(Hfe,"generateInsight");i(XB,"getImageData");i(Gfe,"createOverlays")});var Gy={};C(Gy,{detectLegacyJavaScript:()=>Zfe,getCoreJsPolyfillData:()=>QB,getTransformPatterns:()=>cS});function Yfe(e,t,r){let n=i(o=>`['"]${o}['"]`,"qt"),a="";if(e?a+=`${e}\\.${t}\\s?=[^=]`:a+=`(?:window\\.|[\\s;]+)${t}\\s?=[^=]`,e&&(a+=`|${e}\\[${n(t)}\\]\\s?=[^=]`),a+=`|defineProperty\\(${e||"window"},\\s?${n(t)}`,e&&(a+=`|\\(${e},\\s*{${t}:.*},\\s*{${t}`),e){let o=e.replace(".prototype","");a+=`|{target:${n(o)}[^;]*},{${t}:`}return a+=`|${r.replaceAll(".","\\.")}(?:\\.js)?"`,a}function QB(){return ZB.filter(e=>e.corejs).map(e=>({name:e.name,coreJs3Module:e.modules[0]}))}function Kfe(){let e=[];for(let{name:t,coreJs3Module:r}of QB()){let n=t.split("."),a=n.length>1?n.slice(0,n.length-1).join("."):null,o=n[n.length-1];e.push({name:t,expression:Yfe(a,o,r)})}return e}function cS(){let e=i((t,r)=>typeof r=="string"?t.split(r).length-1:(t.match(r)??[]).length,"count");return[{name:"@babel/plugin-transform-classes",expression:"Cannot call a class as a function",estimateBytes:i(t=>1e3+(e(
t,"_classCallCheck")-1)*17,"estimateBytes")},{name:"@babel/plugin-transform-regenerator",expression:"Generator is already running|regeneratorRuntime",estimateBytes:i(t=>e(t,/regeneratorRuntime\(?\)?\.a?wrap/g)*80,"estimateBytes")},{name:"@babel/plugin-transform-spread",expression:"Invalid attempt to spread non-iterable instance",estimateBytes:i(t=>1169+e(t,/\.apply\(void 0,\s?_toConsumableArray/g)*20,"estimateBytes")}]}function Jfe(e,t){let r=t.filter(u=>!u.name.startsWith("@")),n=t.filter(u=>u.name.startsWith("@")),a=0,o=new Set;for(let u of r){let l=sS.dependencies[u.name];if(l)for(let m of l)o.add(m)}a+=[...o].reduce((u,l)=>u+sS.moduleSizes[l],0),a=Math.min(a,sS.maxSize);let s=0;for(let u of n){let l=cS().find(m=>m.name===u.name);!l||!l.estimateBytes||!e||(s+=l.estimateBytes(e))}return a+s}function Zfe(e,t){if(!e)return{matches:[],estimatedByteSavings:0};let r=Xfe.match(e);if(t)for(let{name:n,modules:a}of ZB){if(r.some(c=>c.name===n))continue;let o=t.sourceURLs().find(c=>a.some(u=>c.
endsWith(`/${u}.js`)||c.includes(`node_modules/${u}/`)));if(!o)continue;let s=t.mappings().find(c=>c.sourceURL===o);s?r.push({name:n,line:s.lineNumber,column:s.columnNumber}):r.push({name:n,line:0,column:0})}return r=r.sort((n,a)=>n.name>a.name?1:n.name===a.name?0:-1),{matches:r,estimatedByteSavings:Jfe(e,r)}}var Wfe,Vfe,ZB,sS,$fe,Xfe,e7=g(()=>{d();Wfe=[{name:"focus-visible",modules:["focus-visible"]},{name:"Error.prototype.cause",modules:["es.error.cause"]},{name:"Array.prototype.at",modules:["es.array.at","esnext.array.at"],corejs:!0},{name:"Array.prototype.concat",modules:["es.array.concat"],corejs:!0},{name:"Array.prototype.copyWithin",modules:["es.array.copy-within"],corejs:!0},{name:"Array.prototype.every",modules:["es.array.every"],corejs:!0},{name:"Array.prototype.fill",modules:["es.array.fill"],corejs:!0},{name:"Array.prototype.filter",modules:["es.array.filter"],corejs:!0},{name:"Array.prototype.find",modules:["es.array.find"],corejs:!0},{name:"Array.prototype.findIndex",modules:[
"es.array.find-index"],corejs:!0},{name:"Array.prototype.findLast",modules:["es.array.find-last","esnext.array.find-last"],corejs:!0},{name:"Array.prototype.findLastIndex",modules:["es.array.find-last-index","esnext.array.find-last-index"],corejs:!0},{name:"Array.prototype.flat",modules:["es.array.flat"],corejs:!0},{name:"Array.prototype.flatMap",modules:["es.array.flat-map"],corejs:!0},{name:"Array.prototype.forEach",modules:["es.array.for-each"],corejs:!0},{name:"Array.from",modules:["es.array.from"],corejs:!0},{name:"Array.prototype.includes",modules:["es.array.includes"],corejs:!0},{name:"Array.prototype.indexOf",modules:["es.array.index-of"],corejs:!0},{name:"Array.isArray",modules:["es.array.is-array"],corejs:!0},{name:"Array.prototype.join",modules:["es.array.join"],corejs:!0},{name:"Array.prototype.map",modules:["es.array.map"],corejs:!0},{name:"Array.of",modules:["es.array.of"],corejs:!0},{name:"Array.prototype.slice",modules:["es.array.slice"],corejs:!0},{name:"Array.prototyp\
e.some",modules:["es.array.some"],corejs:!0},{name:"Array.prototype.sort",modules:["es.array.sort"],corejs:!0},{name:"Array.prototype.unshift",modules:["es.array.unshift"],corejs:!0},{name:"Math.acosh",modules:["es.math.acosh"],corejs:!0},{name:"Math.asinh",modules:["es.math.asinh"],corejs:!0},{name:"Math.atanh",modules:["es.math.atanh"],corejs:!0},{name:"Math.cbrt",modules:["es.math.cbrt"],corejs:!0},{name:"Math.clz32",modules:["es.math.clz32"],corejs:!0},{name:"Math.cosh",modules:["es.math.cosh"],corejs:!0},{name:"Math.expm1",modules:["es.math.expm1"],corejs:!0},{name:"Math.fround",modules:["es.math.fround"],corejs:!0},{name:"Math.hypot",modules:["es.math.hypot"],corejs:!0},{name:"Math.imul",modules:["es.math.imul"],corejs:!0},{name:"Math.log10",modules:["es.math.log10"],corejs:!0},{name:"Math.log1p",modules:["es.math.log1p"],corejs:!0},{name:"Math.log2",modules:["es.math.log2"],corejs:!0},{name:"Math.sign",modules:["es.math.sign"],corejs:!0},{name:"Math.sinh",modules:["es.math.sinh"],
corejs:!0},{name:"Math.tanh",modules:["es.math.tanh"],corejs:!0},{name:"Math.trunc",modules:["es.math.trunc"],corejs:!0},{name:"Object.assign",modules:["es.object.assign"],corejs:!0},{name:"Object.create",modules:["es.object.create"],corejs:!0},{name:"Object.entries",modules:["es.object.entries"],corejs:!0},{name:"Object.freeze",modules:["es.object.freeze"],corejs:!0},{name:"Object.fromEntries",modules:["es.object.from-entries"],corejs:!0},{name:"Object.getOwnPropertyDescriptor",modules:["es.object.get-own-property-descriptor"],corejs:!0},{name:"Object.getOwnPropertyDescriptors",modules:["es.object.get-own-property-descriptors"],corejs:!0},{name:"Object.getPrototypeOf",modules:["es.object.get-prototype-of"],corejs:!0},{name:"Object.hasOwn",modules:["es.object.has-own","esnext.object.has-own"],corejs:!0},{name:"Object.is",modules:["es.object.is"],corejs:!0},{name:"Object.isExtensible",modules:["es.object.is-extensible"],corejs:!0},{name:"Object.isFrozen",modules:["es.object.is-frozen"],
corejs:!0},{name:"Object.isSealed",modules:["es.object.is-sealed"],corejs:!0},{name:"Object.keys",modules:["es.object.keys"],corejs:!0},{name:"Object.preventExtensions",modules:["es.object.prevent-extensions"],corejs:!0},{name:"Object.seal",modules:["es.object.seal"],corejs:!0},{name:"Object.setPrototypeOf",modules:["es.object.set-prototype-of"],corejs:!0},{name:"Object.values",modules:["es.object.values"],corejs:!0},{name:"Promise.any",modules:["es.promise.any","esnext.promise.any"],corejs:!0},{name:"Reflect.apply",modules:["es.reflect.apply"],corejs:!0},{name:"Reflect.construct",modules:["es.reflect.construct"],corejs:!0},{name:"Reflect.deleteProperty",modules:["es.reflect.delete-property"],corejs:!0},{name:"Reflect.get",modules:["es.reflect.get"],corejs:!0},{name:"Reflect.getOwnPropertyDescriptor",modules:["es.reflect.get-own-property-descriptor"],corejs:!0},{name:"Reflect.getPrototypeOf",modules:["es.reflect.get-prototype-of"],corejs:!0},{name:"Reflect.has",modules:["es.reflect.has"],
corejs:!0},{name:"Reflect.isExtensible",modules:["es.reflect.is-extensible"],corejs:!0},{name:"Reflect.ownKeys",modules:["es.reflect.own-keys"],corejs:!0},{name:"Reflect.preventExtensions",modules:["es.reflect.prevent-extensions"],corejs:!0},{name:"Reflect.setPrototypeOf",modules:["es.reflect.set-prototype-of"],corejs:!0},{name:"String.prototype.codePointAt",modules:["es.string.code-point-at"],corejs:!0},{name:"String.prototype.endsWith",modules:["es.string.ends-with"],corejs:!0},{name:"String.fromCodePoint",modules:["es.string.from-code-point"],corejs:!0},{name:"String.prototype.includes",modules:["es.string.includes"],corejs:!0},{name:"String.prototype.matchAll",modules:["es.string.match-all","esnext.string.match-all"],corejs:!0},{name:"String.raw",modules:["es.string.raw"],corejs:!0},{name:"String.prototype.repeat",modules:["es.string.repeat"],corejs:!0},{name:"String.prototype.replaceAll",modules:["es.string.replace-all","esnext.string.replace-all"],corejs:!0},{name:"String.prototy\
pe.startsWith",modules:["es.string.starts-with"],corejs:!0},{name:"String.prototype.substr",modules:["es.string.substr"],corejs:!0},{name:"String.prototype.trim",modules:["es.string.trim"],corejs:!0},{name:"String.prototype.trimEnd",modules:["es.string.trim-end"],corejs:!0},{name:"String.prototype.trimStart",modules:["es.string.trim-start"],corejs:!0},{name:"String.prototype.link",modules:["es.string.link"],corejs:!0},{name:"Promise.allSettled",modules:["esnext.promise.all-settled"],corejs:!0}],Vfe={moduleSizes:[26070,498,282,294,281,467,161,236,229,765,546,339,1608,723,729,1545,438,214,657,111,759,537,209,281,685,217,757,631,293,182,475,79,407,140,366,792,269,222,158,280,188,137,158,105,189,543,160,742,1436,88,904,146,314,375,183,1083,195,503,269,208,334,350,460,568,229,1155,334,266,30,120,309,370,358,1952,1638,304,153,274,1288,192,543,74,144,137,33,336,457,2122,535,711,1323,117,1961,244,557,318,119,124,108,144,96,133,441,210,1627,1956,693,1426,863,637,301,51,708,583,119,600,221,370,728,
1085,552,629,125,1746,97,441,543,2756,371,447,548,243,266,217,99,440,183,546,137,464,207,983,503,237,382,249,675,402,254,223,164,214,191,831,218,202,232,124,249,160,251,217,717,78,561,1627,256,386,225,432,499,394,364,445,634,667,177,346,470,663,142,588,414,617,1559,380,2520,1040,417,289,238,220,214,303,163,141,510,397,137,137,133,133,390,266,137,183,215,191,485,328,575,799,533,148,215,589,589,130,362,562,471,179,186,1266,1456,521,1536,427,444,406,912,150,283,144,485,470,205,1268,796,658,306,3751,814,146,2328,1226,922,237,206,198,250,283,60,3e3],dependencies:{"Array.prototype.at":[0,5,69,105,106,116,164],"Array.prototype.concat":[0,16,21,22,26,34,40,76,78,155,165],"Array.prototype.copyWithin":[0,5,9,37,69,105,106,116,166],"Array.prototype.every":[0,15,17,21,22,26,53,59,76,78,155,167],"Array.prototype.fill":[0,5,10,69,105,106,116,168],"Array.prototype.filter":[0,15,16,21,22,26,53,59,76,78,155,169],"Array.prototype.find":[0,5,15,21,22,26,53,59,69,76,78,105,106,116,155,173],"Array.prototyp\
e.findIndex":[0,5,15,21,22,26,53,59,69,76,78,105,106,116,155,170],"Array.prototype.findLast":[0,5,14,53,59,69,105,106,116,172],"Array.prototype.findLastIndex":[0,5,14,53,59,69,105,106,116,171],"Array.prototype.flat":[0,21,22,26,40,50,53,59,76,78,155,175],"Array.prototype.flatMap":[0,21,22,26,40,50,53,59,76,78,155,174],"Array.prototype.forEach":[0,11,15,17,21,22,26,53,59,76,78,155,176],"Array.from":[0,12,23,24,26,34,53,59,62,63,75,78,88,155,177],"Array.prototype.includes":[0,5,69,105,106,116,178],"Array.prototype.indexOf":[0,17,59,179],"Array.isArray":[0,76,180],"Array.prototype.join":[0,17,181],"Array.prototype.map":[0,15,16,21,22,26,53,59,76,78,155,182],"Array.of":[0,26,34,78,155,183],"Array.prototype.slice":[0,16,19,26,34,76,78,155,184],"Array.prototype.some":[0,15,17,21,22,26,53,59,76,78,155,185],"Array.prototype.sort":[0,17,19,20,26,37,42,43,46,155,156,186],"Array.prototype.unshift":[0,18,37,40,76,187],"Math.acosh":[0,97,188],"Math.asinh":[0,189],"Math.atanh":[0,190],"Math.cbrt":[0,
100,191],"Math.clz32":[0,192],"Math.cosh":[0,93,193],"Math.expm1":[0,93,194],"Math.fround":[0,94,95,99,100,195],"Math.hypot":[0,196],"Math.imul":[0,197],"Math.log10":[0,96,198],"Math.log1p":[0,97,199],"Math.log2":[0,98,200],"Math.sign":[0,100,201],"Math.sinh":[0,93,202],"Math.tanh":[0,93,203],"Math.trunc":[0,204],"Object.assign":[0,104,116,205],"Object.create":[0,69,105,106,116,206],"Object.entries":[0,29,112,116,119,207],"Object.freeze":[0,8,19,51,73,109,113,208],"Object.fromEntries":[0,26,34,53,59,62,63,75,87,88,155,209],"Object.getOwnPropertyDescriptor":[0,210],"Object.getOwnPropertyDescriptors":[0,34,211],"Object.getPrototypeOf":[0,29,112,212],"Object.hasOwn":[0,213],"Object.is":[0,134,217],"Object.isExtensible":[0,8,113,214],"Object.isFrozen":[0,8,215],"Object.isSealed":[0,8,216],"Object.keys":[0,116,218],"Object.preventExtensions":[0,8,19,51,73,109,113,219],"Object.seal":[0,8,19,51,73,109,113,220],"Object.setPrototypeOf":[0,4,58,83,118,221],"Object.values":[0,29,112,116,119,222],
"Promise.any":[0,24,26,47,53,59,62,63,75,87,88,102,122,123,124,125,155,224],"Reflect.apply":[0,52,225],"Reflect.construct":[0,3,19,26,52,55,69,78,105,106,116,155,226],"Reflect.deleteProperty":[0,227],"Reflect.get":[0,29,79,112,230],"Reflect.getOwnPropertyDescriptor":[0,228],"Reflect.getPrototypeOf":[0,29,112,229],"Reflect.has":[0,231],"Reflect.isExtensible":[0,8,113,232],"Reflect.ownKeys":[0,233],"Reflect.preventExtensions":[0,51,234],"Reflect.setPrototypeOf":[0,4,58,83,118,235],"String.prototype.codePointAt":[0,26,141,155,156,236],"String.prototype.endsWith":[0,26,28,59,85,103,155,156,237],"String.fromCodePoint":[0,238],"String.prototype.includes":[0,26,28,85,103,155,156,239],"String.prototype.matchAll":[0,3,6,26,29,31,59,69,78,85,89,90,105,106,112,116,126,127,128,129,130,131,132,135,139,141,155,156,241],"String.raw":[0,26,155,156,242],"String.prototype.repeat":[0,26,142,155,156,243],"String.prototype.replaceAll":[0,26,65,85,128,129,155,156,244],"String.prototype.startsWith":[0,26,28,
59,85,103,155,156,245],"String.prototype.substr":[0,26,155,156,246],"String.prototype.trim":[0,26,144,146,155,156,163,251],"String.prototype.trimEnd":[0,26,143,144,146,155,156,163,247,249],"String.prototype.trimStart":[0,26,144,145,146,155,156,163,248,250],"String.prototype.link":[0,26,30,140,155,156,240],"Promise.allSettled":[0,24,26,47,53,59,62,63,75,87,88,102,122,123,124,125,155,223,252],"focus-visible":[253]},maxSize:155835},ZB=Wfe,sS=Vfe,$fe=class{static{i(this,"CodePatternMatcher")}constructor(e){this.patterns=e}match(e){if(!this.re){let s=this.patterns.map(c=>`(${c.expression})`).join("|");this.re=new RegExp(`(^\r
|\r|
)|${s}`,"g")}this.re.lastIndex=0;let t=new Set,r=[],n,a=0,o=0;for(;(n=this.re.exec(e))!==null;){let s=n.slice(1),[c,...u]=s;if(c){a++,o=n.index+1;continue}let l=this.patterns[u.findIndex(Boolean)];t.has(l)||(t.add(l),r.push({name:l.name,line:a,column:n.index-o}))}return r}};i(Yfe,"buildPolyfillExpression");i(QB,"getCoreJsPolyfillData");i(Kfe,"getPolyfillPatterns");i(cS,"getTransformPatterns");i(Jfe,"estimateWastedBytes");Xfe=new $fe([...Kfe(),...cS()]);i(Zfe,"detectLegacyJavaScript");});var t7=g(()=>{d();e7()});var lS={};C(lS,{UIStrings:()=>To,createOverlays:()=>ahe,generateInsight:()=>nhe,i18nString:()=>uS,isLegacyJavaScript:()=>rhe});function the(e){let t=[...e.legacyJavaScriptResults.keys()].map(r=>r.request).filter(r=>!!r);return{insightKey:Ke.LEGACY_JAVASCRIPT,strings:To,title:uS(To.title),description:uS(To.description),category:Et.ALL,state:t.length?"fail":"pass",relatedEvents:[...new Set(t)],...e}}function rhe(e){return e.insightKey===Ke.LEGACY_JAVASCRIPT}function nhe(e,t){let r=e.Scripts.scripts.filter(s=>s.frame!==t.frameId||s.url?.startsWith("chrome-extension://")?!1:ae.timestampIsInBounds(t.bounds,s.ts)),n=new Map,a=new Map;for(let s of r){if(!s.content||s.content.length<r7)continue;let c=ehe(s.content,s.sourceMap);if(c.estimatedByteSavings<r7)continue;let u=pp(s),l=Math.round(c.estimatedByteSavings*u);if(c.estimatedByteSavings=l,n.set(s,c),s.request){let m=s.request.args.data.requestId;a.set(m,l)}}let o=new Map([...n].sort((s,c)=>c[1].estimatedByteSavings-s[1].estimatedByteSavings));
return the({legacyJavaScriptResults:o,metricSavings:si(a,t),wastedBytes:a.values().reduce((s,c)=>s+c,0)})}function ahe(e){return[...e.legacyJavaScriptResults.keys()].map(t=>t.request).filter(t=>!!t).map(t=>({type:"ENTRY_OUTLINE",entry:t,outlineReason:"ERROR"}))}var ehe,To,uS,r7,dS=g(()=>{d();t7();ot();ci();Mr();({detectLegacyJavaScript:ehe}=Gy),To={title:"Legacy JavaScript",description:"Polyfills and transforms enable older browsers to use new JavaScript features. However, many aren't necessary for modern browsers. Consider modifying your JavaScript build process to not transpile [Baseline](https://web.dev/articles/baseline-and-polyfills) features, unless you know you must support older browsers. [Learn why most sites can deploy ES6+ code without transpiling](https://philipwalton.com/articles/the-state-of-es5-on-the-web/)",columnScript:"Script",columnWastedBytes:"Wasted bytes"},uS=i((e,t)=>({i18nId:e,values:t}),"i18nString"),r7=5e3;i(the,"finalize");i(rhe,"isLegacyJavaScript");i(nhe,"g\
enerateInsight");i(ahe,"createOverlays")});var pS={};C(pS,{UIStrings:()=>xo,createOverlayForRequest:()=>o7,createOverlays:()=>lhe,determineHttp1Requests:()=>a7,generateInsight:()=>uhe,i18nString:()=>mS,isModernHTTP:()=>ohe});function ohe(e){return e.insightKey===Ke.MODERN_HTTP}function ihe(e,t,r){if(!En.STATIC_RESOURCE_TYPES.has(e.args.data.resourceType))return!1;if(e.args.data.decodedBodyLength<100){let n=t.entityByEvent.get(e);if(n){if(r?.name===n.name)return!0;if(!n.isUnrecognized)return!1}}return!0}function a7(e,t,r){let n=[],a=new Map;for(let s of e){let c=new URL(s.args.data.url);if(!ihe(s,t,r)||En.isSyntheticNetworkRequestLocalhost(s))continue;Ne.getWithDefault(a,c.origin,()=>[]).push(s)}let o=new Set;for(let s of e){if(o.has(s.args.data.url)||s.args.data.fromServiceWorker||!/HTTP\/[01][.\d]?/i.test(s.args.data.protocol))continue;let u=new URL(s.args.data.url);(a.get(u.origin)||[]).length<6||(o.add(s.args.data.url),n.push(s))}return n}function n7(e,t,r){let n=r.simulate(t),a=new Map;t.traverse(c=>{c.type==="network"&&e.has(
c.request.url)&&(a.set(c.request.requestId,c.request.protocol),c.request.protocol="h2")});let o=r.simulate(t);t.traverse(c=>{if(c.type!=="network")return;let u=a.get(c.request.requestId);u!==void 0&&(c.request.protocol=u)});let s=n.timeInMs-o.timeInMs;return vo.floor(s,1/10)}function she(e,t){if(!t.navigation||!t.lantern)return;let r=new Set(e.map(o=>o.args.data.url)),n=t.lantern.metrics.firstContentfulPaint.optimisticGraph,a=t.lantern.metrics.largestContentfulPaint.optimisticGraph;return{FCP:n7(r,n,t.lantern.simulator),LCP:n7(r,a,t.lantern.simulator)}}function che(e){return{insightKey:Ke.MODERN_HTTP,strings:xo,title:mS(xo.title),description:mS(xo.description),category:Et.LCP,state:e.http1Requests.length>0?"fail":"pass",...e,relatedEvents:e.http1Requests}}function uhe(e,t){let r=i(u=>ae.eventIsInBounds(u,t.bounds),"isWithinContext"),n=e.NetworkRequests.byTime.filter(r),a=e.NetworkRequests.entityMappings,o=t.navigation?.args.data?.documentLoaderURL??e.Meta.mainFrameURL,s=Ha.getEntityForUrl(
o,a),c=a7(n,a,s??null);return che({http1Requests:c,metricSavings:she(c,t)})}function o7(e){return{type:"ENTRY_OUTLINE",entry:e,outlineReason:"ERROR"}}function lhe(e){return e.http1Requests.map(t=>o7(t))??[]}var xo,mS,fS=g(()=>{d();rr();On();ot();Mr();xo={title:"Modern HTTP",description:"HTTP/2 and HTTP/3 offer many benefits over HTTP/1.1, such as multiplexing. [Learn more about using modern HTTP](https://developer.chrome.com/docs/lighthouse/best-practices/uses-http2/).",request:"Request",protocol:"Protocol",noOldProtocolRequests:"No requests used HTTP/1.1, or its current use of HTTP/1.1 does not present a significant optimization opportunity. HTTP/1.1 requests are only flagged if six or more static assets originate from the same origin, and they are not served from a local development environment or a third-party source."},mS=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(ohe,"isModernHTTP");i(ihe,"isMultiplexableStaticAsset");i(a7,"determineHttp1Requests");i(n7,"computeWasteWithGraph");
i(she,"computeMetricSavings");i(che,"finalize");i(uhe,"generateInsight");i(o7,"createOverlayForRequest");i(lhe,"createOverlays")});var yS={};C(yS,{ParsedURL:()=>yp,TOO_MANY_PRECONNECTS_THRESHOLD:()=>Vy,UIStrings:()=>br,createOverlays:()=>Ehe,generateInsight:()=>whe,generatePreconnectCandidates:()=>d7,generatePreconnectedOrigins:()=>l7,handleLinkResponseHeader:()=>u7,i18nString:()=>Wy,normalizePath:()=>gS,schemeIs:()=>Dhe});function i7(e){return{insightKey:Ke.NETWORK_DEPENDENCY_TREE,strings:br,title:Wy(br.title),description:Wy(br.description),category:Et.LCP,state:e.fail?"fail":"pass",...e}}function s7(e,t){if(e.args.data.requestId===t.navigationId)return!0;if(e.args.data.isLinkPreload)return!1;let r=e.args.data.resourceType==="Document"&&e.args.data.frame!==t.frameId;if(dhe.has(e.args.data.resourceType)||r||e.args.data.mimeType.startsWith("image/")||!(e.args.data.initiator?.url||Me.getZeroIndexedStackTraceInEventPayload(e)?.at(0)?.url))return!1;let a=En.isSyntheticNetworkRequestEventRenderBlocking(e);return En.isSyntheticNetworkRequestHighPriority(e)||a}function hS(e){if(e.children.length===0)return e;let t=e.children[0];
for(let r of e.children){let n=hS(r);n.timeFromInitialRequest>t.timeFromInitialRequest&&(t=n)}return t}function c7(e){for(let t of e)t.children.length>0&&(t.children.sort((r,n)=>{let a=hS(r);return hS(n).timeFromInitialRequest-a.timeFromInitialRequest}),c7(t.children))}function fhe(e){let t=[],r=new Map,n=O.Micro(0),a=!1,o=[];function s(l){if(l.length===0)return;l.length>=2&&(a=!0);let m=l[0],p=l[l.length-1],f=O.Micro(p.ts+p.dur-m.ts);f>n&&(n=f,o=l);let h=t;for(let y=0;y<l.length;++y){let v=l[y],E=h.find(T=>T.request===v);if(!E){let T=O.Micro(v.ts+v.dur-m.ts);E={request:v,timeFromInitialRequest:T,children:[],relatedRequests:new Set},h.push(E)}l.forEach(T=>E?.relatedRequests.add(T)),r.set(v,y<2?[]:[Wy(br.warningDescription)]),h=E.children}}i(s,"addChain");let c=new Set;function u(l){return l.getDependents().filter(m=>m.getDependencies().every(p=>c.has(p)))}if(i(u,"getNextNodes"),e.lantern?.graph.traverse((l,m)=>{if(c.add(l),l.type!=="network"||!s7(l.rawRequest,e))return;let f=m.filter(h=>h.
type==="network").reverse().map(h=>h.rawRequest);f.some(h=>!s7(h,e))||l.isNonNetworkProtocol||s(f)},u),o.length>0){let l=t;for(let m of o){let p=l.find(f=>f.request===m);p?(p.isLongest=!0,l=p.children):console.error("Some request in the longest chain is not found")}}return c7(t),{rootNodes:t,maxTime:n,fail:a,relatedEvents:r}}function ul(e){return new yp(e).securityOrigin()}function hhe(e){if(!e)return null;let t=e.indexOf("<"),r=e.indexOf(">");if(t!==0||r===-1||r<=t)return null;let n=e.substring(t+1,r).trim();if(!n)return null;let a=e.substring(r+1).trim();if(a){let o=a.split(";");for(let s of o){let c=s.trim();if(!c)continue;let u=c.indexOf("=");if(u===-1)continue;let l=c.substring(0,u).trim().toLowerCase(),m=c.substring(u+1).trim();if(m.startsWith('"')&&m.endsWith('"')&&(m=m.substring(1,m.length-1)),l==="rel"&&m==="preconnect")return{url:n,headerText:e}}}return null}function u7(e){if(!e)return[];let t=[];for(let r=0;r<e.length;){let n=e.indexOf(">",r);if(n===-1)break;let a=e.indexOf(
",",n),o=a!==-1?a:e.length,s=e.substring(r,o);if(o+1<=r){console.warn("unexpected infinite loop, bailing");break}r=o+1;let c=hhe(s.trim());c&&t.push(c)}return t}function l7(e,t,r,n){let a=[];for(let s of e.NetworkRequests.linkPreconnectEvents)a.push({node_id:s.args.data.node_id,frame:s.args.data.frame,url:s.args.data.url,unused:!r.some(c=>ul(s.args.data.url)===ul(c.args.data.url)),crossorigin:n.some(c=>c.origin===ul(s.args.data.url)),source:"DOM"});let o=e.NetworkRequests.byId.get(t.navigationId);return o?.args.data.responseHeaders?.forEach(s=>{s.name.toLowerCase()==="link"&&u7(s.value)?.forEach(u=>a.push({url:u.url,headerText:u.headerText,request:o,unused:!r.some(l=>ul(u.url)===ul(l.args.data.url)),crossorigin:n.some(l=>l.origin===ul(u.url)),source:"ResponseHeader"}))}),a}function ghe(e){return!!e.args.data.timing&&e.args.data.timing.connectEnd>=0&&e.args.data.timing.connectStart>=0}function yhe(e){let{timing:t}=e.args.data;return t?t.dnsStart===-1&&t.dnsEnd===-1&&t.connectStart===-1&&
t.connectEnd===-1||t.dnsEnd-t.dnsStart===0&&t.connectEnd-t.connectStart===0:!1}function vhe(e,t){let r=Math.max(0,e.args.data.syntheticData.sendStartTime-t.args.data.syntheticData.finishTime);return ae.microToMilli(r)<mhe}function bhe(e,t,r,n){let a=new Map;return r.forEach(o=>{if(!ghe(o)||e.NetworkRequests.eventToInitiator.get(o)===t)return;let s=new URL(o.args.data.url);if(s.origin==="null")return;let c=new URL(t.args.data.url).origin;if(s.origin===c||!n.has(o.args.data.url)||yhe(o)||!vhe(o,t))return;Ne.getWithDefault(a,s.origin,()=>[]).push(o)}),a}function d7(e,t,r){if(!t.lantern)return[];let n=e.NetworkRequests.byId.get(t.navigationId);if(!n)return[];let{rtt:a,additionalRttByOrigin:o}=t.lantern.simulator.getOptions(),s=t.lantern.metrics.largestContentfulPaint.pessimisticGraph,c=t.lantern.metrics.firstContentfulPaint.pessimisticGraph,u=new Set;s.traverse(y=>{y.type==="network"&&u.add(y.request.url)});let l=new Set;c.traverse(y=>{y.type==="network"&&l.add(y.request.url)});let m=bhe(e,
n,r,u),p=O.Milli(0),f=O.Milli(0),h=[];return m.forEach(y=>{let v=y[0];if(!v.args.data.timing)return;let E=new yp(v.args.data.url),T=E.securityOrigin(),x=o.get(T)??0,S=O.Milli(a+x);E.scheme==="https"&&(S=O.Milli(S*2));let I=O.Micro(v.args.data.syntheticData.sendStartTime-n.args.data.syntheticData.finishTime+ae.milliToMicro(v.args.data.timing.dnsStart)),F=Math.min(S,ae.microToMilli(I));F<phe||(p=Math.max(F,p),l.has(v.args.data.url)&&(f=Math.max(F,f)),h.push({origin:T,wastedMs:F}))}),h=h.sort((y,v)=>v.wastedMs-y.wastedMs),h.slice(0,Vy)}function whe(e,t){if(!t.navigation)return i7({rootNodes:[],maxTime:0,fail:!1,preconnectedOrigins:[],preconnectCandidates:[]});let{rootNodes:r,maxTime:n,fail:a,relatedEvents:o}=fhe(t),s=i(m=>ae.eventIsInBounds(m,t.bounds),"isWithinContext"),c=e.NetworkRequests.byTime.filter(s),u=d7(e,t,c),l=l7(e,t,c,u);return i7({rootNodes:r,maxTime:n,fail:a,relatedEvents:o,preconnectedOrigins:l,preconnectCandidates:u})}function Ehe(e){function t(n,a){n.forEach(o=>{a.push({type:"\
ENTRY_OUTLINE",entry:o.request,outlineReason:"ERROR"}),t(o.children,a)})}i(t,"walk");let r=[];return t(e.rootNodes,r),r}function gS(e){if(e.indexOf("..")===-1&&e.indexOf(".")===-1)return e;let t=(e[0]==="/"?e.substring(1):e).split("/"),r=[];for(let a of t)a!=="."&&(a===".."?r.pop():r.push(a));let n=r.join("/");return e[0]==="/"&&n&&(n="/"+n),n[n.length-1]!=="/"&&(e[e.length-1]==="/"||t[t.length-1]==="."||t[t.length-1]==="..")&&(n=n+"/"),n}function Dhe(e,t){try{return new URL(e).protocol===t}catch{return!1}}var br,Wy,dhe,mhe,phe,Vy,yp,vS=g(()=>{d();rr();ot();Le();Mr();br={title:"Network dependency tree",description:"[Avoid chaining critical requests](https://developer.chrome.com/docs/lighthouse/performance/critical-request-chains) by reducing the length of chains, reducing the download size of resources, or deferring the download of unnecessary resources to improve page load.",warningDescription:"Avoid chaining critical requests by reducing the length of chains, reducing the download si\
ze of resources, or deferring the download of unnecessary resources to improve page load.",noNetworkDependencyTree:"No rendering tasks impacted by network dependencies",maxCriticalPathLatency:"Max critical path latency:",columnRequest:"Request",columnTime:"Time",preconnectOriginsTableTitle:"Preconnected origins",preconnectOriginsTableDescription:"[preconnect](https://developer.chrome.com/docs/lighthouse/performance/uses-rel-preconnect/) hints help the browser establish a connection earlier in the page load, saving time when the first request for that origin is made. The following are the origins that the page preconnected to.",noPreconnectOrigins:"no origins were preconnected",tooManyPreconnectLinksWarning:"More than 4 `preconnect` connections were found. These should be used sparingly and only to the most important origins.",unusedWarning:"Unused preconnect. Only use `preconnect` for origins that the page is likely to request.",crossoriginWarning:"Unused preconnect. Check that the `cr\
ossorigin` attribute is used properly.",columnSource:"Source",noPreconnectCandidates:"No additional origins are good candidates for preconnecting",estSavingTableTitle:"Preconnect candidates",estSavingTableDescription:"Add [preconnect](https://developer.chrome.com/docs/lighthouse/performance/uses-rel-preconnect/) hints to your most important origins, but try to use no more than 4.",columnOrigin:"Origin",columnWastedMs:"Est LCP savings"},Wy=i((e,t)=>({i18nId:e,values:t}),"i18nString"),dhe=new Set(["Image","XHR","Fetch","EventSource"]),mhe=O.Milli(15e3),phe=O.Milli(50),Vy=4;i(i7,"finalize");i(s7,"isCritical");i(hS,"findMaxLeafNode");i(c7,"sortRecursively");i(fhe,"generateNetworkDependencyTree");i(ul,"getSecurityOrigin");i(hhe,"handleLinkResponseHeaderPart");i(u7,"handleLinkResponseHeader");i(l7,"generatePreconnectedOrigins");i(ghe,"hasValidTiming");i(yhe,"hasAlreadyConnectedToOrigin");i(vhe,"socketStartTimeIsBelowThreshold");i(bhe,"candidateRequestsByOrigin");i(d7,"generatePreconnectCandi\
dates");i(whe,"generateInsight");i(Ehe,"createOverlays");i(gS,"normalizePath");i(Dhe,"schemeIs");yp=class e{static{i(this,"ParsedURL")}isValid;url;scheme;user;host;port;path;queryParams;fragment;folderPathComponents;lastPathComponent;blobInnerScheme;constructor(t){this.isValid=!1,this.url=t,this.scheme="",this.user="",this.host="",this.port="",this.path="",this.queryParams="",this.fragment="",this.folderPathComponents="",this.lastPathComponent="";let r=this.url.startsWith("blob:"),a=(r?t.substring(5):t).match(e.urlRegex());if(a)this.isValid=!0,r?(this.blobInnerScheme=a[2].toLowerCase(),this.scheme="blob"):this.scheme=a[2].toLowerCase(),this.user=a[3]??"",this.host=a[4]??"",this.port=a[5]??"",this.path=a[6]??"/",this.queryParams=a[7]??"",this.fragment=a[8]??"";else{if(this.url.startsWith("data:")){this.scheme="data";return}if(this.url.startsWith("blob:")){this.scheme="blob";return}if(this.url==="about:blank"){this.scheme="about";return}this.path=this.url}let o=this.path.lastIndexOf("/",
this.path.length-2);o!==-1?this.lastPathComponent=this.path.substring(o+1):this.lastPathComponent=this.path;let s=this.path.lastIndexOf("/");s!==-1&&(this.folderPathComponents=this.path.substring(0,s))}static fromString(t){let r=new e(t.toString());return r.isValid?r:null}static preEncodeSpecialCharactersInPath(t){for(let r of["%",";","#","?"," "])t=t.replaceAll(r,encodeURIComponent(r));return t}static rawPathToEncodedPathString(t){let r=e.preEncodeSpecialCharactersInPath(t);return t.startsWith("/")?new URL(r,"file:///").pathname:new URL("/"+r,"file:///").pathname.substr(1)}static encodedFromParentPathAndName(t,r){return e.concatenate(t,"/",e.preEncodeSpecialCharactersInPath(r))}static urlFromParentUrlAndName(t,r){return e.concatenate(t,"/",e.preEncodeSpecialCharactersInPath(r))}static encodedPathToRawPathString(t){return decodeURIComponent(t)}static rawPathToUrlString(t){let r=e.preEncodeSpecialCharactersInPath(t.replace(/\\/g,"/"));return r=r.replace(/\\/g,"/"),r.startsWith("file://")||
(r.startsWith("/")?r="file://"+r:r="file:///"+r),new URL(r).toString()}static relativePathToUrlString(t,r){let n=e.preEncodeSpecialCharactersInPath(t.replace(/\\/g,"/"));return new URL(n,r).toString()}static urlToRawPathString(t,r){console.assert(t.startsWith("file://"),"This must be a file URL.");let n=decodeURIComponent(t);return r?n.substr(8).replace(/\//g,"\\"):n.substr(7)}static sliceUrlToEncodedPathString(t,r){return t.substring(r)}static substr(t,r,n){return t.substr(r,n)}static substring(t,r,n){return t.substring(r,n)}static prepend(t,r){return t+r}static concatenate(t,...r){return t.concat(...r)}static trim(t){return t.trim()}static slice(t,r,n){return t.slice(r,n)}static join(t,r){return t.join(r)}static split(t,r,n){return t.split(r,n)}static toLowerCase(t){return t.toLowerCase()}static isValidUrlString(t){return new e(t).isValid}static urlWithoutHash(t){let r=t.indexOf("#");return r!==-1?t.substr(0,r):t}static urlRegex(){if(e.urlRegexInstance)return e.urlRegexInstance;let t=/([A-Za-z][A-Za-z0-9+.-]*):\/\//,
r=/(?:([A-Za-z0-9\-._~%!$&'()*+,;=:]*)@)?/,n=/((?:\[::\d?\])|(?:[^\s\/:]*))/,a=/(?::([\d]+))?/,o=/(\/[^#?]*)?/,s=/(?:\?([^#]*))?/,c=/(?:#(.*))?/;return e.urlRegexInstance=new RegExp("^("+t.source+r.source+n.source+a.source+")"+o.source+s.source+c.source+"$"),e.urlRegexInstance}static extractPath(t){let r=this.fromString(t);return r?r.path:""}static extractOrigin(t){let r=this.fromString(t);return r?r.securityOrigin():""}static extractExtension(t){t=e.urlWithoutHash(t);let r=t.indexOf("?");r!==-1&&(t=t.substr(0,r));let n=t.lastIndexOf("/");n!==-1&&(t=t.substr(n+1));let a=t.lastIndexOf(".");if(a!==-1){t=t.substr(a+1);let o=t.indexOf("%");return o!==-1?t.substr(0,o):t}return""}static extractName(t){let r=t.lastIndexOf("/"),n=r!==-1?t.substr(r+1):t;return r=n.indexOf("?"),r<0?n:n.substr(0,r)}static completeURL(t,r){if(r.startsWith("data:")||r.startsWith("blob:")||r.startsWith("javascript:")||r.startsWith("mailto:"))return r;let n=r.trim(),a=this.fromString(n);if(a?.scheme){let f=a.securityOrigin(),
h=gS(a.path),y=a.queryParams&&`?${a.queryParams}`,v=a.fragment&&`#${a.fragment}`;return f+h+y+v}let o=this.fromString(t);if(!o)return null;if(o.isDataURL())return r;if(r.length>1&&r.charAt(0)==="/"&&r.charAt(1)==="/")return o.scheme+":"+r;let s=o.securityOrigin(),c=o.path,u=o.queryParams?"?"+o.queryParams:"";if(!r.length)return s+c+u;if(r.charAt(0)==="#")return s+c+u+r;if(r.charAt(0)==="?")return s+c+r;let l=r.match(/^[^#?]*/);if(!l||!r.length)throw new Error("Invalid href");let m=l[0],p=r.substring(m.length);return m.charAt(0)!=="/"&&(m=o.folderPathComponents+"/"+m),s+gS(m)+p}static splitLineAndColumn(t){let r=t.match(e.urlRegex()),n="",a=t;r&&(n=r[1],a=t.substring(r[1].length));let s=/(?::(\d+))?(?::(\d+))?$/.exec(a),c,u;if(console.assert(!!s),!s)return{url:t,lineNumber:0,columnNumber:0};typeof s[1]=="string"&&(c=parseInt(s[1],10),c=isNaN(c)?void 0:c-1),typeof s[2]=="string"&&(u=parseInt(s[2],10),u=isNaN(u)?void 0:u-1);let l=n+a.substring(0,a.length-s[0].length);if(s[1]===void 0&&s[2]===
void 0){let p=/wasm-function\[\d+\]:0x([a-z0-9]+)$/g.exec(a);p&&typeof p[1]=="string"&&(l=e.removeWasmFunctionInfoFromURL(l),u=parseInt(p[1],16),u=isNaN(u)?void 0:u)}return{url:l,lineNumber:c,columnNumber:u}}static removeWasmFunctionInfoFromURL(t){let r=/:wasm-function\[\d+\]/,n=t.search(r);return n===-1?t:e.substring(t,0,n)}static beginsWithWindowsDriveLetter(t){return/^[A-Za-z]:/.test(t)}static beginsWithScheme(t){return/^[A-Za-z][A-Za-z0-9+.-]*:/.test(t)}static isRelativeURL(t){return!this.beginsWithScheme(t)||this.beginsWithWindowsDriveLetter(t)}isAboutBlank(){return this.url==="about:blank"}isDataURL(){return this.scheme==="data"}extractDataUrlMimeType(){let t=/^data:((?<type>\w+)\/(?<subtype>\w+))?(;base64)?,/,r=this.url.match(t);return{type:r?.groups?.type,subtype:r?.groups?.subtype}}isBlobURL(){return this.url.startsWith("blob:")}lastPathComponentWithFragment(){return this.lastPathComponent+(this.fragment?"#"+this.fragment:"")}domain(){return this.isDataURL()?"data:":this.host+
(this.port?":"+this.port:"")}securityOrigin(){return this.isDataURL()?"data:":(this.isBlobURL()?this.blobInnerScheme:this.scheme)+"://"+this.domain()}urlWithoutScheme(){return this.scheme&&this.url.startsWith(this.scheme+"://")?this.url.substring(this.scheme.length+3):this.url}static urlRegexInstance=null}});var ES={};C(ES,{UIStrings:()=>li,createOverlayForRequest:()=>m7,createOverlays:()=>_he,generateInsight:()=>Rhe,i18nString:()=>wS,isRenderBlocking:()=>The});function The(e){return e.insightKey==="RenderBlocking"}function She(e){let t=new Map;for(let[r,n]of e)r.type==="network"&&t.set(r.request.requestId,{node:r,nodeTiming:n});return t}function Che(e,t){let r=t.simulator,n=t.metrics.firstContentfulPaint.optimisticGraph,{nodeTimings:a}=t.simulator.simulate(n),o=new Map(a),s=0,c=n.cloneWithRelationships(f=>!e.has(f.id));if(c.type!=="network")throw new Error("minimalFCPGraph not a NetworkNode");let u=Math.max(...Array.from(Array.from(o).map(f=>f[1].endTime))),l=c.request.transferSize,m=l||0;c.request.transferSize=m+s;let p=r.simulate(c).timeInMs;return c.request.transferSize=l,Math.round(Math.max(u-p,0))}function Ihe(e,t){return e.LargestImagePaint.lcpRequestByNavigationId.has(t.navigationId)}function khe(e,t,r){if(!t.lantern)return;let n=She(t.lantern.metrics.firstContentfulPaint.optimisticEstimate.
nodeTimings),a={FCP:0,LCP:0},o=new Map,s=new Set;for(let c of r){let u=n.get(c.args.data.requestId);if(!u)continue;let{node:l,nodeTiming:m}=u;l.traverse(f=>s.add(f.id));let p=Math.round(m.duration);p<xhe||o.set(l.id,p)}return o.size&&(a.FCP=Che(s,t.lantern),Ihe(e,t)||(a.LCP=a.FCP)),{metricSavings:a,requestIdToWastedMs:o}}function bS(e){return{insightKey:Ke.RENDER_BLOCKING,strings:li,title:wS(li.title),description:wS(li.description),category:Et.LCP,state:e.renderBlockingRequests.length>0?"fail":"pass",...e}}function Rhe(e,t){if(!t.navigation)return bS({renderBlockingRequests:[]});let r=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId)?.get(t.navigationId)?.get(gr.PageLoadMetrics.MetricName.FP)?.event?.ts;if(!r)return bS({renderBlockingRequests:[],warnings:[Nn.NO_FP]});let n=[];for(let o of e.NetworkRequests.byTime){if(o.args.data.frame!==t.frameId||!En.isSyntheticNetworkRequestEventRenderBlocking(o)||o.args.data.syntheticData.finishTime>r)continue;if(o.args.data.renderBlocking==="i\
n_body_parser_blocking"){let c=o.args.data.priority,l=o.args.data.resourceType==="Script"&&c==="High";if(c!=="VeryHigh"&&!l)continue}Me.getNavigationForTraceEvent(o,t.frameId,e.Meta.navigationsByFrameId)===t.navigation&&n.push(o)}let a=khe(e,t,n);return n=n.sort((o,s)=>s.dur-o.dur),bS({relatedEvents:n,renderBlockingRequests:n,...a})}function m7(e){return{type:"ENTRY_OUTLINE",entry:e,outlineReason:"ERROR"}}function _he(e){return e.renderBlockingRequests.map(t=>m7(t))}var li,wS,xhe,DS=g(()=>{d();On();ot();Mr();li={title:"Render blocking requests",description:"Requests are blocking the page's initial render, which may delay LCP. [Deferring or inlining](https://web.dev/learn/performance/understanding-the-critical-path#render-blocking_resources) can move these network requests out of the critical path.",renderBlockingRequest:"Request",duration:"Duration",noRenderBlocking:"No render blocking requests for this navigation"},wS=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(The,"isRenderBlockin\
g");xhe=50;i(She,"getNodesAndTimingByRequestId");i(Che,"estimateSavingsWithGraphs");i(Ihe,"hasImageLCP");i(khe,"computeSavings");i(bS,"finalize");i(Rhe,"generateInsight");i(m7,"createOverlayForRequest");i(_he,"createOverlays")});var xS={};C(xS,{UIStrings:()=>di,createOverlays:()=>Nhe,generateInsight:()=>Ohe,i18nString:()=>TS});function Fhe(e,t){let r=new Map;for(let[n,a]of e.dataForUpdateLayoutEvent)if(n.args.beginData?.frame===t.frameId&&ae.eventIsInBounds(n,t.bounds))for(let o of a.timings){let s=o[Ir.Selector]+"_"+o[Ir.StyleSheetId],c=r.get(s);c!==void 0?(c[Ir.Elapsed]+=o[Ir.Elapsed],c[Ir.FastRejectCount]+=o[Ir.FastRejectCount],c[Ir.MatchAttempts]+=o[Ir.MatchAttempts],c[Ir.MatchCount]+=o[Ir.MatchCount]):r.set(s,{...o})}return[...r.values()]}function Mhe(e){return{insightKey:Ke.SLOW_CSS_SELECTOR,strings:di,title:TS(di.title),description:TS(di.description),category:Et.ALL,state:e.topSelectorElapsedMs&&e.topSelectorMatchAttempts?"informative":"pass",...e}}function Ohe(e,t){let r=e.SelectorStats;if(!r)throw new Error("no selector stats data");let n=Fhe(r,t),a=0,o=0,s=0;n.map(l=>{a+=l[Ir.Elapsed],o+=l[Ir.MatchAttempts],s+=l[Ir.MatchCount]});let c=null,u=null;return n.length>0&&(c=n.reduce((l,m)=>l[Ir.Elapsed]>m[Ir.
Elapsed]?l:m),c&&c[Ir.Elapsed]<Ahe&&(c=null),u=n.reduce((l,m)=>l[Ir.MatchAttempts]>m[Ir.MatchAttempts]?l:m)),Mhe({relatedEvents:[],totalElapsedMs:O.Milli(a/1e3),totalMatchAttempts:o,totalMatchCount:s,topSelectorElapsedMs:c,topSelectorMatchAttempts:u})}function Nhe(e){return[]}var di,TS,Ahe,SS=g(()=>{d();ot();w1();Le();Mr();di={title:"CSS Selector costs",description:"If Recalculate Style costs remain high, selector optimization can reduce them. [Optimize the selectors](https://developer.chrome.com/docs/devtools/performance/selector-stats) with both high elapsed time and high slow-path %. Simpler selectors, fewer selectors, a smaller DOM, and a shallower DOM will all reduce matching costs.",matchAttempts:"Match attempts",matchCount:"Match count",elapsed:"Elapsed time",topSelectors:"Top selectors",total:"Total",enableSelectorData:"No CSS selector data was found. CSS selector stats need to be enabled in the performance panel settings.",topSelectorElapsedTime:"Top selector elaspsed time",topSelectorMatchAttempt:"\
Top selector match attempt"},TS=i((e,t)=>({i18nId:e,values:t}),"i18nString"),Ahe=500;i(Fhe,"aggregateSelectorStats");i(Mhe,"finalize");i(Ohe,"generateInsight");i(Nhe,"createOverlays")});var IS={};C(IS,{UIStrings:()=>Ta,createOverlays:()=>Uhe,createOverlaysForSummary:()=>p7,generateInsight:()=>Bhe,i18nString:()=>CS});function Lhe(e,t){let r=[];for(let n of e)n.entity!==t&&r.push(...n.relatedEvents);return r}function Phe(e){return{insightKey:Ke.THIRD_PARTIES,strings:Ta,title:CS(Ta.title),description:CS(Ta.description),category:Et.ALL,state:e.entitySummaries.find(t=>t.entity!==e.firstPartyEntity)?"informative":"pass",...e}}function Bhe(e,t){let r=Oy.summarizeByThirdParty(e,t.bounds),n=t.navigation?.args.data?.documentLoaderURL??e.Meta.mainFrameURL,a=Ku.default.getEntity(n)||Ha.makeUpEntity(e.Renderer.entityMappings.createdEntityCache,n);return Phe({relatedEvents:Lhe(r,a),firstPartyEntity:a,entitySummaries:r})}function p7(e){let t=[];for(let r of e.relatedEvents){if(r.dur===void 0||r.dur<1e3)continue;let n={type:"ENTRY_OUTLINE",entry:r,outlineReason:"INFO"};t.push(n)}return t}function Uhe(e){let t=[],r=e.entitySummaries??[];for(let n of r){if(n.entity===e.firstPartyEntity)
continue;let a=p7(n);t.push(...a)}return t}var Ta,CS,kS=g(()=>{d();gE();dp();On();Mr();Ta={title:"3rd parties",description:"3rd party code can significantly impact load performance. [Reduce and defer loading of 3rd party code](https://web.dev/articles/optimizing-content-efficiency-loading-third-party-javascript/) to prioritize your page's content.",columnThirdParty:"3rd party",columnTransferSize:"Transfer size",columnMainThreadTime:"Main thread time",noThirdParties:"No third parties found"},CS=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Lhe,"getRelatedEvents");i(Phe,"finalize");i(Bhe,"generateInsight");i(p7,"createOverlaysForSummary");i(Uhe,"createOverlays")});var _S={};C(_S,{UIStrings:()=>So,createOverlays:()=>qhe,generateInsight:()=>jhe,i18nString:()=>$y});function RS(e){return{insightKey:Ke.VIEWPORT,strings:So,title:$y(So.title),description:$y(So.description),category:Et.INP,state:e.mobileOptimized===!1?"fail":"pass",...e}}function jhe(e,t){let r=e.UserInteractions.parseMetaViewportEvents.find(a=>a.args.data.frame!==t.frameId?!1:ae.eventIsInBounds(a,t.bounds)),n=e.UserInteractions.beginCommitCompositorFrameEvents.filter(a=>a.args.frame!==t.frameId||r&&a.ts<r.ts?!1:ae.eventIsInBounds(a,t.bounds));if(!n.length)return RS({mobileOptimized:null,warnings:[Nn.NO_LAYOUT]});for(let a of n)if(!a.args.is_mobile_optimized){let o=[...e.UserInteractions.interactionsOverThreshold.values()].filter(u=>gr.UserInteractions.categoryOfInteraction(u)==="POINTER"&&u.inputDelay>=5e4),s=Math.max(0,...o.map(u=>u.inputDelay))/1e3,c=vo.clamp(s,0,300);return RS({mobileOptimized:!1,viewportEvent:r,longPointerInteractions:o,metricSavings:{INP:c}})}return RS({mobileOptimized:!0,
viewportEvent:r})}function qhe(e){return e.longPointerInteractions?e.longPointerInteractions.map(t=>{let r=Math.min(t.inputDelay,3e5),n=ae.traceWindowFromMicroSeconds(O.Micro(t.ts),O.Micro(t.ts+r));return{type:"TIMESPAN_BREAKDOWN",entry:t,sections:[{bounds:n,label:$y(So.mobileTapDelayLabel),showDuration:!0}],renderLocation:"ABOVE_EVENT"}}):[]}var So,$y,AS=g(()=>{d();rr();On();ot();Le();Mr();So={title:"Optimize viewport for mobile",description:"Tap interactions may be [delayed by up to 300 ms](https://developer.chrome.com/blog/300ms-tap-delay-gone-away/) if the viewport is not optimized for mobile.",mobileTapDelayLabel:"Mobile tap delay"},$y=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(RS,"finalize");i(jhe,"generateInsight");i(qhe,"createOverlays")});var vp={};C(vp,{CLSCulprits:()=>Px,Cache:()=>Nx,DOMSize:()=>zx,DocumentLatency:()=>jx,DuplicatedJavaScript:()=>Wx,FontDisplay:()=>Yx,ForcedReflow:()=>Zx,INPBreakdown:()=>tS,ImageDelivery:()=>qy,LCPBreakdown:()=>nS,LCPDiscovery:()=>oS,LegacyJavaScript:()=>lS,ModernHTTP:()=>pS,NetworkDependencyTree:()=>yS,RenderBlocking:()=>ES,SlowCSSSelector:()=>xS,ThirdParties:()=>IS,Viewport:()=>_S});var f7=g(()=>{d();Lx();Bx();qx();Hx();Vx();Kx();Qx();zy();rS();aS();iS();dS();fS();vS();DS();SS();kS();AS()});var bp={};C(bp,{Common:()=>Yn,Models:()=>vp,Statistics:()=>Fx,Types:()=>Mx});var FS=g(()=>{d();ci();f7();Ly();Mr()});var mi={};C(mi,{createGraph:()=>NS,createNetworkRequests:()=>OS,createProcessedNavigation:()=>MS});function MS(e,t,r){let n=e.PageLoadMetrics.metricScoresByFrameId.get(t);if(!n)throw new Ht.LanternError("missing metric scores for frame");let a=n.get(r);if(!a)throw new Ht.LanternError("missing metric scores for specified navigation");let o=i(c=>{let u=a.get(c);if(u?.event)return u.event.ts},"getTimestampOrUndefined");return{timestamps:{firstContentfulPaint:i(c=>{let u=a.get(c);if(!u?.event)throw new Ht.LanternError(`missing metric: ${c}`);return u.event.ts},"getTimestamp")(gr.PageLoadMetrics.MetricName.FCP),largestContentfulPaint:o(gr.PageLoadMetrics.MetricName.LCP)}}}function h7(e){return typeof e=="string"&&(e=new URL(e)),{scheme:e.protocol.split(":")[0],host:e.hostname,securityOrigin:e.origin}}function zhe(e){let t=new Map,r=["ServiceWorker thread","DedicatedWorker thread"];for(let n of e.traceEvents){if(n.name!=="thread_name"||!n.args.name||!r.includes(n.args.name))continue;let a=t.
get(n.pid);a?a.push(n.tid):t.set(n.pid,[n.tid])}return t}function Hhe(e,t,r){if(r.args.data.hasResponse&&r.args.data.connectionId===void 0)throw new Ht.LanternError("Trace is too old");let n;try{n=new URL(r.args.data.url)}catch{return}let a=r.args.data.timing?{workerFetchStart:-1,workerRespondWithSettled:-1,receiveHeadersStart:-1,...r.args.data.timing}:void 0,o=a?a.requestTime*1e3:r.args.data.syntheticData.downloadStart/1e3,s=!1;t.get(r.pid)?.includes(r.tid)&&(s=!0),e.Workers.workerIdByThread.has(r.tid)&&(s=!0);let u=r.args.data.initiator??{type:"other"};if(r.args.data.stackTrace){let p=r.args.data.stackTrace.map(f=>({scriptId:String(f.scriptId),url:f.url,lineNumber:f.lineNumber-1,columnNumber:f.columnNumber-1,functionName:f.functionName}));u.stack={callFrames:p}}let l=r.args.data.resourceType;r.args.data.initiator?.fetchType==="xmlhttprequest"?l="XHR":r.args.data.initiator?.fetchType==="fetch"&&(l="Fetch");let m=r.args.data.decodedBodyLength??0;if(n.protocol==="data:"&&m===0){let p=n.
pathname.indexOf(",");n.pathname.substring(0,p).includes(";base64")?m=atob(n.pathname.substring(p+1)).length:m=n.pathname.length-p-1}return{rawRequest:r,requestId:r.args.data.requestId,connectionId:r.args.data.connectionId??0,connectionReused:r.args.data.connectionReused??!1,url:r.args.data.url,protocol:r.args.data.protocol,parsedURL:h7(n),documentURL:r.args.data.requestingFrameUrl,rendererStartTime:r.ts/1e3,networkRequestTime:o,responseHeadersEndTime:r.args.data.syntheticData.downloadStart/1e3,networkEndTime:r.args.data.syntheticData.finishTime/1e3,transferSize:r.args.data.encodedDataLength,resourceSize:m,fromDiskCache:r.args.data.syntheticData.isDiskCached,fromMemoryCache:r.args.data.syntheticData.isMemoryCached,isLinkPreload:r.args.data.isLinkPreload,finished:r.args.data.finished,failed:r.args.data.failed,statusCode:r.args.data.statusCode,initiator:u,timing:a,resourceType:l,mimeType:r.args.data.mimeType,priority:r.args.data.priority,frameId:r.args.data.frame,fromWorker:s,redirects:void 0,
redirectSource:void 0,redirectDestination:void 0,initiatorRequest:void 0}}function Ghe(e,t){if(e.redirectSource)return e.redirectSource;let r=Lr.PageDependencyGraph.getNetworkInitiators(e)[0],n=t.get(r)||[];if(n=n.filter(a=>a.responseHeadersEndTime<=e.rendererStartTime&&a.finished&&!a.failed),n.length>1){let a=n.filter(o=>o.resourceType!==Dm.NetworkRequestTypes.Other);a.length&&(n=a)}if(n.length>1){let a=n.filter(o=>o.frameId===e.frameId);a.length&&(n=a)}if(n.length>1&&e.initiator.type==="parser"){let a=n.filter(o=>o.resourceType===Dm.NetworkRequestTypes.Document);a.length&&(n=a)}if(n.length>1){let a=n.filter(o=>o.isLinkPreload);if(a.length){let o=n.filter(c=>!c.isLinkPreload),s=o.every(c=>c.fromDiskCache||c.fromMemoryCache);o.length&&s&&(n=a)}}return n.length===1?n[0]:null}function Whe(e){let t=new Map;for(let r of e){let n=t.get(r.url)||[];n.push(r),t.set(r.url,n)}for(let r of e){let n=Ghe(r,t);n&&(r.initiatorRequest=n)}}function OS(e,t,r=0,n=Number.POSITIVE_INFINITY){let a=zhe(e),o=[];
for(let c of t.NetworkRequests.byTime)if(c.ts>=r&&c.ts<n){let u=Hhe(t,a,c);u&&o.push(u)}let s=[];for(let c of[...o]){if(!c.rawRequest)continue;let u=c.rawRequest.args.data.redirects;if(!u.length){s.push(c);continue}let l=[];for(let m of u){let p=structuredClone(c);p.networkRequestTime=m.ts/1e3,p.rendererStartTime=p.networkRequestTime,p.networkEndTime=(m.ts+m.dur)/1e3,p.responseHeadersEndTime=p.networkEndTime,p.timing={requestTime:p.networkRequestTime/1e3,receiveHeadersStart:p.responseHeadersEndTime,receiveHeadersEnd:p.responseHeadersEndTime,proxyStart:-1,proxyEnd:-1,dnsStart:-1,dnsEnd:-1,connectStart:-1,connectEnd:-1,sslStart:-1,sslEnd:-1,sendStart:-1,sendEnd:-1,workerStart:-1,workerReady:-1,workerFetchStart:-1,workerRespondWithSettled:-1,pushStart:-1,pushEnd:-1},p.url=m.url,p.parsedURL=h7(m.url),p.statusCode=302,p.resourceType=void 0,p.transferSize=400,l.push(p),s.push(p)}l.push(c),s.push(c);for(let m=0;m<l.length;m++){let p=l[m];m>0&&(p.redirectSource=l[m-1],p.redirects=l.slice(0,m)),
m!==l.length-1&&(p.redirectDestination=l[m+1])}for(let m=1;m<l.length;m++)l[m].requestId=`${l[m-1].requestId}:redirect`}return Whe(s),s}function Vhe(e,t){let r=t.Meta,n=r.mainFrameNavigations.length?new Set(r.mainFrameNavigations.map(o=>o.pid)):r.topLevelRendererIds,a=new Map;for(let o of n){let s=r.threadsInProcess.get(o)??[],c=!1;for(let[u,l]of s)if(l.args.name==="CrRendererMain"){a.set(o,u),c=!0;break}if(!c){for(let[u,l]of s)if(l.args.name==="CrBrowserMain"){a.set(o,u),c=!0;break}}}return e.traceEvents.filter(o=>a.get(o.pid)===o.tid)}function NS(e,t,r,n){let a=Vhe(t,r);if(!n){n={requestedUrl:e[0].url,mainDocumentUrl:""};let o=e[0];for(;o.redirectDestination;)o=o.redirectDestination;n.mainDocumentUrl=o.url}return Lr.PageDependencyGraph.createGraph(a,e,n)}var LS=g(()=>{d();On();Tm();i(MS,"createProcessedNavigation");i(h7,"createParsedUrl");i(zhe,"findWorkerThreads");i(Hhe,"createLanternRequest");i(Ghe,"chooseInitiatorRequest");i(Whe,"linkInitiators");i(OS,"createNetworkRequests");i(Vhe,
"collectMainThreadEvents");i(NS,"createGraph")});var Ky={};C(Ky,{TraceParseProgressEvent:()=>Oc,TraceProcessor:()=>Yy,sortHandlers:()=>y7});function g7(e,t){return t===.8?e*(.8-.2)+.2:e*t}function y7(e){let t=new Map,r=new Set,n=i(a=>{if(t.has(a))return;if(r.has(a)){let c="";for(let u of r)(c||u===a)&&(c+=`${u}->`);throw c+=a,new Error(`Found dependency cycle in trace event handlers: ${c}`)}r.add(a);let o=e[a];if(!o)return;let s=o.deps?.();s&&s.forEach(n),t.set(a,o)},"visitHandler");for(let a of Object.keys(e))n(a);return t}var Oc,Yy,PS=g(()=>{d();On();ot();FS();Tm();LS();Le();Oc=class e extends Event{static{i(this,"TraceParseProgressEvent")}data;static eventName="traceparseprogress";constructor(t,r={bubbles:!0}){super(e.eventName,r),this.data=t}};i(g7,"calculateProgress");Yy=class e extends EventTarget{static{i(this,"TraceProcessor")}#e;#t="IDLE";#o=yo.defaults();#r=null;#a=null;static createWithAllHandlers(){return new e(gr,yo.defaults())}static getInsightRunners(){return{...vp}}constructor(t,r){super(),this.#n(t),this.#e={Meta:gr.
Meta,...t},r&&(this.#o=r),this.#c()}#c(){for(let t of Object.values(this.#e))"handleUserConfig"in t&&t.handleUserConfig&&t.handleUserConfig(this.#o)}#n(t){if(Object.keys(t).length===Object.keys(gr).length)return;let r=new Set;for(let[a,o]of Object.entries(t)){r.add(a);let s="deps"in o?o.deps():[];for(let c of s)r.add(c)}let n=new Set(Object.keys(t));r.delete("Meta");for(let a of r)if(!n.has(a))throw new Error(`Required handler ${a} not provided.`)}reset(){if(this.#t==="PARSING")throw new Error("Trace processor can't reset while parsing.");let t=Object.values(this.#e);for(let r of t)r.reset();this.#r=null,this.#a=null,this.#t="IDLE"}async parse(t,r){if(this.#t!=="IDLE")throw new Error(`Trace processor can't start parsing when not idle. Current state: ${this.#t}`);r.logger?.start("total");try{this.#t="PARSING",r.logger?.start("parse"),await this.#i(t,r),r.logger?.end("parse"),this.#r&&!r.isCPUProfile&&(r.logger?.start("insights"),this.#l(this.#r,t,r),r.logger?.end("insights")),this.#t="F\
INISHED_PARSING"}catch(n){throw this.#t="ERRORED_WHILE_PARSING",n}finally{r.logger?.end("total")}}async#i(t,r){let a=[...y7(this.#e).entries()];for(let[,u]of a)u.reset();r.logger?.start("parse:handleEvent");for(let u=0;u<t.length;++u){if(u%5e4===0&&u){let m=g7(u/t.length,.2);this.dispatchEvent(new Oc({percent:m})),await new Promise(p=>setTimeout(p,0))}let l=t[u];for(let m=0;m<a.length;++m){let[,p]=a[m];p.handleEvent(l)}}r.logger?.end("parse:handleEvent");let o={...r,allTraceEvents:t};for(let u=0;u<a.length;u++){let[l,m]=a[u];m.finalize&&(r.logger?.start(`parse:${l}:finalize`),await new Promise(f=>setTimeout(f,0)),await m.finalize(o),r.logger?.end(`parse:${l}:finalize`));let p=g7(u/a.length,.8);this.dispatchEvent(new Oc({percent:p}))}let s=i((u,l=!0)=>{if(u instanceof Map)return new Map(u);if(u instanceof Set)return new Set(u);if(Array.isArray(u))return[...u];if(typeof u=="object"&&u&&l){let m={};for(let[p,f]of Object.entries(u))m[p]=s(f,!1);return m}return u},"shallowClone");r.logger?.
start("parse:clone");let c={};for(let[u,l]of Object.entries(this.#e)){let m=s(l.data());Object.assign(c,{[u]:m})}r.logger?.end("parse:clone"),this.dispatchEvent(new Oc({percent:1})),this.#r=c}get parsedTrace(){return this.#t!=="FINISHED_PARSING"?null:this.#r}get insights(){return this.#t!=="FINISHED_PARSING"?null:this.#a}#u(t,r,n,a,o){if(!t.NetworkRequests||!t.Workers||!t.PageLoadMetrics)return;if(!t.NetworkRequests.byTime.length)throw new Ht.LanternError("No network requests found in trace");let s=t.Meta.navigationsByFrameId.get(n),c=s?.findIndex(se=>se.args.data?.navigationId===a);if(!s||c===void 0||c===-1)throw new Ht.LanternError("Could not find navigation start");let u=s[c].ts,l=c+1<s.length?s[c+1].ts:Number.POSITIVE_INFINITY,p={traceEvents:r.filter(se=>se.ts>=u&&se.ts<l)},f=OS(p,t,u,l),h=NS(f,p,t),y=MS(t,n,a),v=Ht.NetworkAnalyzer.analyze(f);if(!v)return;let E={networkAnalysis:v,throttlingMethod:"provided",...o.lanternSettings},T=ni.Simulator.createSimulator(E),x={graph:h,simulator:T,
processedNavigation:y},S=vr.FirstContentfulPaint.compute(x),I=vr.LargestContentfulPaint.compute(x,{fcpResult:S}),F=vr.Interactive.compute(x,{lcpResult:I}),W=vr.TotalBlockingTime.compute(x,{fcpResult:S,interactiveResult:F});return{requests:f,graph:h,simulator:T,metrics:{firstContentfulPaint:S,interactive:F,largestContentfulPaint:I,totalBlockingTime:W}}}sortInsightSet(t,r){let n={INPBreakdown:null,LCPBreakdown:null,LCPDiscovery:null,CLSCulprits:null,RenderBlocking:null,NetworkDependencyTree:null,ImageDelivery:null,DocumentLatency:null,FontDisplay:null,Viewport:null,DOMSize:null,ThirdParties:null,DuplicatedJavaScript:null,SlowCSSSelector:null,ForcedReflow:null,Cache:null,ModernHTTP:null,LegacyJavaScript:null},a=Yn.calculateMetricWeightsForSorting(t,r),o=Yn.getLCP(t)?.value,s=o?ae.microToMilli(o):O.Milli(0),c=Yn.getCLS(t).value,u=Yn.getINP(t)?.value,l=u?ae.microToMilli(u):O.Milli(200),m=s!==void 0?Yn.evaluateLCPMetricScore(s):void 0,p=Yn.evaluateINPMetricScore(l),f=Yn.evaluateCLSMetricScore(
c),h=new Map;for(let[T,x]of Object.entries(t.model)){let S=x.metricSavings?.LCP??0,I=x.metricSavings?.INP??0,F=x.metricSavings?.CLS??0,W=s!==void 0?Math.max(0,s-S):void 0,H=Math.max(0,l-I),se=Math.max(0,c-F),me=0;a.lcp&&S&&m!==void 0&&W!==void 0&&(me+=a.lcp*(Yn.evaluateLCPMetricScore(W)-m)),a.inp&&I&&p!==void 0&&(me+=a.inp*(Yn.evaluateINPMetricScore(H)-p)),a.cls&&F&&f!==void 0&&(me+=a.cls*(Yn.evaluateCLSMetricScore(se)-f)),h.set(T,me)}let y=Object.keys(n),v=Object.keys(t.model);v.sort((T,x)=>{let S=y.indexOf(T),I=y.indexOf(x);return S>=0&&I>=0?S-I:S>=0?-1:I>=0?1:0}),v.sort((T,x)=>(h.get(x)??0)-(h.get(T)??0));let E={};for(let T of v){let x=t.model[T];E[T]=x}t.model=E}#s(t,r,n){let a,o,s;r.navigation?(a=r.navigationId,o=t.Meta.finalDisplayUrlByNavigationId.get(r.navigationId)??t.Meta.mainFrameURL,s=r.navigation):(a=b.NO_NAVIGATION,o=t.Meta.finalDisplayUrlByNavigationId.get("")??t.Meta.mainFrameURL);let c={};for(let[T,x]of Object.entries(e.getInsightRunners())){let S;try{n.logger?.start(`\
insights:${T}`),S=x.generateInsight(t,r),S.frameId=r.frameId;let I=r.navigation?.args.data?.navigationId;I&&(S.navigationId=I),S.createOverlays=()=>x.createOverlays(S)}catch(I){S=I}finally{n.logger?.end(`insights:${T}`)}Object.assign(c,{[T]:S})}let u=a===b.NO_NAVIGATION,l=ae.milliToMicro(O.Milli(5e3)),m=Object.values(c).filter(T=>!(T instanceof Error)).every(T=>T.state==="pass"),p=!c.LCPBreakdown.lcpEvent,f=!c.INPBreakdown.longestInteractionEvent,h=c.CLSCulprits.shifts?.size===0;if(u&&r.bounds.range<l&&m&&p&&f&&h)return;let v;try{v=new URL(o)}catch{return}let E={id:a,url:v,navigation:s,frameId:r.frameId,bounds:r.bounds,model:c};this.#a||(this.#a=new Map),this.#a.set(E.id,E),this.sortInsightSet(E,n.metadata??null)}#l(t,r,n){this.#a=new Map;let a=t.Meta.mainFrameNavigations.filter(o=>o.args.frame&&o.args.data?.navigationId);this.#p(t,a,n);for(let[o,s]of a.entries()){let c=s.ts,u=o+1<a.length?a[o+1].ts:t.Meta.traceBounds.max,l=ae.traceWindowFromMicroSeconds(c,u);this.#d(s,l,t,r,n)}}#p(t,r,n){
let o={bounds:r.length>0?ae.traceWindowFromMicroSeconds(t.Meta.traceBounds.min,r[0].ts):t.Meta.traceBounds,frameId:t.Meta.mainFrameId};this.#s(t,o,n)}#d(t,r,n,a,o){let s=t.args.frame,c=t.args.data?.navigationId,u;try{o.logger?.start("insights:createLanternContext"),u=this.#u(n,a,s,c,o)}catch(m){let p=["mainDocumentRequest not found","missing metric scores for main frame","missing metric: FCP","missing metric: LCP","No network requests found in trace","Trace is too old"];m instanceof Ht.LanternError&&p.some(f=>m.message===f)||console.error(m)}finally{o.logger?.end("insights:createLanternContext")}let l={bounds:r,frameId:s,navigation:t,navigationId:c,lantern:u};this.#s(n,l,o)}};i(y7,"sortHandlers")});var v7=g(()=>{d();rr();On();ot();PS();Le()});var BS=g(()=>{d();dp();On();ot();FS();Tm();LS();v7();PS();Le()});var wr=g(()=>{"use strict";d();Tm();BS();});var b7=g(()=>{"use strict";d();});var w7=g(()=>{"use strict";d();pt();zo();});var Jy,E7=g(()=>{"use strict";d();Kd();Jy=class e{static{i(this,"ArbitraryEqualityMap")}constructor(){this._equalsFn=e.deepEquals,this._entries=[]}setEqualityFn(t){this._equalsFn=t}has(t){return this._findIndexOf(t)!==-1}get(t){return this._entries[this._findIndexOf(t)]?.value}set(t,r){let n=this._findIndexOf(t);n===-1&&(n=this._entries.length),this._entries[n]={key:t,value:r}}_findIndexOf(t){for(let r=0;r<this._entries.length;r++)if(this._equalsFn(t,this._entries[r].key))return r;return-1}static deepEquals(t,r){return co(t,r)}}});function fe(e,t){return Object.assign(e,{request:i((n,a)=>{let o=e.name;for(let f of t||[])if(n&&typeof n=="object"&&n[f]===void 0){let h=new Error(`missing required key "${String(f)}" for computed artifact ${e.name}`);if(Au)throw h;q.error(`lh:computed:${o}`,h)}let s=t?Object.fromEntries(t.map(f=>[f,n[f]])):n,c=a.computedCache,u=c.get(o)||new Jy;c.set(o,u);let l=u.get(s);if(l)return l;let m={msg:`Computing artifact: ${o}`,id:`lh:computed:${o}`};q.time(m,"verbose");let p=e.compute_(s,a);return u.set(s,p),p.then(()=>q.timeEnd(m)).catch(()=>q.timeEnd(m)),p},"request")})}var tt=g(()=>{"use strict";d();pt();E7();Pg();i(fe,"makeComputedArtifact")});function Khe(e,t){return e.endsWith(t)?e.length===t.length||e[e.length-t.length-1]===".":!1}function Jhe(e,t){let r=e.length-t.length-2,n=e.lastIndexOf(".",r);return n===-1?e:e.slice(n+1)}function US(e,t,r){if(r.validHosts!==null){let a=r.validHosts;for(let o of a)if(Khe(t,o))return o}let n=0;if(t.startsWith("."))for(;n<t.length&&t[n]===".";)n+=1;return e.length===t.length-n?null:Jhe(t,e)}var D7=g(()=>{d();i(Khe,"shareSameDomainSuffix");i(Jhe,"extractDomainWithSuffix");i(US,"getDomain")});function jS(e,t){return e.slice(0,-t.length-1)}var T7=g(()=>{d();i(jS,"getDomainWithoutSuffix")});function Xy(e,t){let r=0,n=e.length,a=!1;if(!t){if(e.startsWith("data:"))return null;for(;r<e.length&&e.charCodeAt(r)<=32;)r+=1;for(;n>r+1&&e.charCodeAt(n-1)<=32;)n-=1;if(e.charCodeAt(r)===47&&e.charCodeAt(r+1)===47)r+=2;else{let l=e.indexOf(":/",r);if(l!==-1){let m=l-r,p=e.charCodeAt(r),f=e.charCodeAt(r+1),h=e.charCodeAt(r+2),y=e.charCodeAt(r+3),v=e.charCodeAt(r+4);if(!(m===5&&p===104&&f===116&&h===116&&y===112&&v===115)){if(!(m===4&&p===104&&f===116&&h===116&&y===112)){if(!(m===3&&p===119&&f===115&&h===115)){if(!(m===2&&p===119&&f===115))for(let E=r;E<l;E+=1){let T=e.charCodeAt(E)|32;if(!(T>=97&&T<=122||T>=48&&T<=57||T===46||T===45||T===43))return null}}}}for(r=l+2;e.charCodeAt(r)===47;)r+=1}}let s=-1,c=-1,u=-1;for(let l=r;l<n;l+=1){let m=e.charCodeAt(l);if(m===35||m===47||m===63){n=l;break}else m===64?s=l:m===93?c=l:m===58?u=l:m>=65&&m<=90&&(a=!0)}if(s!==-1&&s>r&&s<n&&(r=s+1),e.charCodeAt(r)===91)return c!==-1?e.slice(r+1,c).toLowerCase():null;u!==-1&&u>r&&u<n&&(n=u)}for(;n>r+1&&e.charCodeAt(
n-1)===46;)n-=1;let o=r!==0||n!==e.length?e.slice(r,n):e;return a?o.toLowerCase():o}var x7=g(()=>{d();i(Xy,"extractHostname")});function Xhe(e){if(e.length<7||e.length>15)return!1;let t=0;for(let r=0;r<e.length;r+=1){let n=e.charCodeAt(r);if(n===46)t+=1;else if(n<48||n>57)return!1}return t===3&&e.charCodeAt(0)!==46&&e.charCodeAt(e.length-1)!==46}function Zhe(e){if(e.length<3)return!1;let t=e.startsWith("[")?1:0,r=e.length;if(e[r-1]==="]"&&(r-=1),r-t>39)return!1;let n=!1;for(;t<r;t+=1){let a=e.charCodeAt(t);if(a===58)n=!0;else if(!(a>=48&&a<=57||a>=97&&a<=102||a>=65&&a<=90))return!1}return n}function qS(e){return Zhe(e)||Xhe(e)}var S7=g(()=>{d();i(Xhe,"isProbablyIpv4");i(Zhe,"isProbablyIpv6");i(qS,"isIp")});function C7(e){return e>=97&&e<=122||e>=48&&e<=57||e>127}function Zy(e){if(e.length>255||e.length===0||!C7(e.charCodeAt(0))&&e.charCodeAt(0)!==46&&e.charCodeAt(0)!==95)return!1;let t=-1,r=-1,n=e.length;for(let a=0;a<n;a+=1){let o=e.charCodeAt(a);if(o===46){if(a-t>64||r===46||r===45||r===95)return!1;t=a}else if(!(C7(o)||o===45||o===95))return!1;r=o}return n-t-1<=63&&r!==45}var I7=g(()=>{d();i(C7,"isValidAscii");i(Zy,"default")});function k7({allowIcannDomains:e=!0,allowPrivateDomains:t=!1,detectIp:r=!0,extractHostname:n=!0,mixedInputs:a=!0,validHosts:o=null,validateHostname:s=!0}){return{allowIcannDomains:e,allowPrivateDomains:t,detectIp:r,extractHostname:n,mixedInputs:a,validHosts:o,validateHostname:s}}function zS(e){return e===void 0?Qhe:k7(e)}var Qhe,HS=g(()=>{d();i(k7,"setDefaultsImpl");Qhe=k7({});i(zS,"setDefaults")});function GS(e,t){return t.length===e.length?"":e.slice(0,-t.length-1)}var R7=g(()=>{d();i(GS,"getSubdomain")});function WS(){return{domain:null,domainWithoutSuffix:null,hostname:null,isIcann:null,isIp:null,isPrivate:null,publicSuffix:null,subdomain:null}}function VS(e){e.domain=null,e.domainWithoutSuffix=null,e.hostname=null,e.isIcann=null,e.isIp=null,e.isPrivate=null,e.publicSuffix=null,e.subdomain=null}function $S(e,t,r,n,a){let o=zS(n);return typeof e!="string"||(o.extractHostname?o.mixedInputs?a.hostname=Xy(e,Zy(e)):a.hostname=Xy(e,!1):a.hostname=e,o.detectIp&&a.hostname!==null&&(a.isIp=qS(a.hostname),a.isIp))?a:o.validateHostname&&o.extractHostname&&a.hostname!==null&&!Zy(a.hostname)?(a.hostname=null,a):(t===0||a.hostname===null||(r(a.hostname,o,a),t===2||a.publicSuffix===null)||(a.domain=US(a.publicSuffix,a.hostname,o),t===3||a.domain===null)||(a.subdomain=GS(a.hostname,a.domain),t===4)||(a.domainWithoutSuffix=jS(a.domain,a.publicSuffix)),a)}var _7=g(()=>{d();D7();T7();x7();S7();I7();HS();R7();i(WS,"getEmptyResult");i(VS,"resetResult");i($S,"parseImpl")});function Qy(e,t,r){if(!t.allowPrivateDomains&&e.length>3){let n=e.length-1,a=e.charCodeAt(n),o=e.charCodeAt(n-1),s=e.charCodeAt(n-2),c=e.charCodeAt(n-3);if(a===109&&o===111&&s===99&&c===46)return r.isIcann=!0,r.isPrivate=!1,r.publicSuffix="com",!0;if(a===103&&o===114&&s===111&&c===46)return r.isIcann=!0,r.isPrivate=!1,r.publicSuffix="org",!0;if(a===117&&o===100&&s===101&&c===46)return r.isIcann=!0,r.isPrivate=!1,r.publicSuffix="edu",!0;if(a===118&&o===111&&s===103&&c===46)return r.isIcann=!0,r.isPrivate=!1,r.publicSuffix="gov",!0;if(a===116&&o===101&&s===110&&c===46)return r.isIcann=!0,r.isPrivate=!1,r.publicSuffix="net",!0;if(a===101&&o===100&&s===46)return r.isIcann=!0,r.isPrivate=!1,r.publicSuffix="de",!0}return!1}var A7=g(()=>{d();i(Qy,"default")});var YS=g(()=>{d();_7();A7();HS()});var F7,M7,O7=g(()=>{d();F7=(function(){let e=[1,{}],t=[0,{city:e}];return[0,{ck:[0,{www:e}],jp:[0,{kawasaki:t,kitakyushu:t,kobe:t,nagoya:t,sapporo:t,sendai:t,yokohama:t}]}]})(),M7=(function(){let e=[1,{}],t=[1,{com:e,edu:e,gov:e,mil:e,net:e,org:e}],r=[1,{com:e,edu:e,gov:e,net:e,org:e}],n=[1,{gov:e}],a=[0,{"*":e}],o=[1,{co:e,com:e,edu:e,gov:e,net:e,org:e}],s=[1,{com:e,edu:e,net:e,org:e}],c=[1,{co:e,net:e,org:e}],u=[1,{co:e,com:e,edu:e,gov:e,mil:e,net:e,nom:e,org:e}],l=[1,{biz:e,com:e,edu:e,gov:e,info:e,net:e,org:e}],m=[1,{gs:e}],p=[0,{nes:e}],f=[1,{k12:e,cc:e,lib:e}],h=[1,{cc:e}],y=[1,{cc:e,lib:e}];return[0,{ac:t,ad:e,ae:[1,{ac:e,co:e,gov:e,mil:e,net:e,org:e,sch:e}],aero:[1,{airline:e,airport:e,"accident-investigation":e,"accident-prevention":e,aerobatic:e,aeroclub:e,aerodrome:e,agents:e,"air-surveillance":e,"air-traffic-control":e,aircraft:e,airtraffic:e,ambulance:e,association:e,author:e,ballooning:e,broker:e,caa:e,cargo:e,catering:e,certification:e,championship:e,charter:e,civilaviation:e,
club:e,conference:e,consultant:e,consulting:e,control:e,council:e,crew:e,design:e,dgca:e,educator:e,emergency:e,engine:e,engineer:e,entertainment:e,equipment:e,exchange:e,express:e,federation:e,flight:e,freight:e,fuel:e,gliding:e,government:e,groundhandling:e,group:e,hanggliding:e,homebuilt:e,insurance:e,journal:e,journalist:e,leasing:e,logistics:e,magazine:e,maintenance:e,marketplace:e,media:e,microlight:e,modelling:e,navigation:e,parachuting:e,paragliding:e,"passenger-association":e,pilot:e,press:e,production:e,recreation:e,repbody:e,res:e,research:e,rotorcraft:e,safety:e,scientist:e,services:e,show:e,skydiving:e,software:e,student:e,taxi:e,trader:e,trading:e,trainer:e,union:e,workinggroup:e,works:e}],af:r,ag:[1,{co:e,com:e,net:e,nom:e,org:e}],ai:[1,{com:e,net:e,off:e,org:e}],al:t,am:[1,{co:e,com:e,commune:e,net:e,org:e}],ao:[1,{co:e,ed:e,edu:e,gov:e,gv:e,it:e,og:e,org:e,pb:e}],aq:e,ar:[1,{bet:e,com:e,coop:e,edu:e,gob:e,gov:e,int:e,mil:e,musica:e,mutual:e,net:e,org:e,seg:e,senasa:e,tur:e}],
arpa:[1,{e164:e,home:e,"in-addr":e,ip6:e,iris:e,uri:e,urn:e}],as:n,asia:e,at:[1,{ac:[1,{sth:e}],co:e,gv:e,or:e}],au:[1,{asn:e,com:e,edu:[1,{act:e,catholic:e,nsw:[1,{schools:e}],nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],gov:[1,{qld:e,sa:e,tas:e,vic:e,wa:e}],id:e,net:e,org:e,conf:e,oz:e,act:e,nsw:e,nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],aw:[1,{com:e}],ax:e,az:[1,{biz:e,co:e,com:e,edu:e,gov:e,info:e,int:e,mil:e,name:e,net:e,org:e,pp:e,pro:e}],ba:t,bb:[1,{biz:e,co:e,com:e,edu:e,gov:e,info:e,net:e,org:e,store:e,tv:e}],bd:a,be:[1,{ac:e}],bf:n,bg:[1,{0:e,1:e,2:e,3:e,4:e,5:e,6:e,7:e,8:e,9:e,a:e,b:e,c:e,d:e,e,f:e,g:e,h:e,i:e,j:e,k:e,l:e,m:e,n:e,o:e,p:e,q:e,r:e,s:e,t:e,u:e,v:e,w:e,x:e,y:e,z:e}],bh:r,bi:[1,{co:e,com:e,edu:e,or:e,org:e}],biz:e,bj:[1,{africa:e,agro:e,architectes:e,assur:e,avocats:e,co:e,com:e,eco:e,econo:e,edu:e,info:e,loisirs:e,money:e,net:e,org:e,ote:e,restaurant:e,resto:e,tourism:e,univ:e}],bm:r,bn:r,bo:[1,{com:e,edu:e,gob:e,int:e,mil:e,net:e,org:e,tv:e,web:e,academia:e,agro:e,arte:e,blog:e,
bolivia:e,ciencia:e,cooperativa:e,democracia:e,deporte:e,ecologia:e,economia:e,empresa:e,indigena:e,industria:e,info:e,medicina:e,movimiento:e,musica:e,natural:e,nombre:e,noticias:e,patria:e,plurinacional:e,politica:e,profesional:e,pueblo:e,revista:e,salud:e,tecnologia:e,tksat:e,transporte:e,wiki:e}],br:[1,{"9guacu":e,abc:e,adm:e,adv:e,agr:e,aju:e,am:e,anani:e,aparecida:e,app:e,arq:e,art:e,ato:e,b:e,barueri:e,belem:e,bet:e,bhz:e,bib:e,bio:e,blog:e,bmd:e,boavista:e,bsb:e,campinagrande:e,campinas:e,caxias:e,cim:e,cng:e,cnt:e,com:e,contagem:e,coop:e,coz:e,cri:e,cuiaba:e,curitiba:e,def:e,des:e,det:e,dev:e,ecn:e,eco:e,edu:e,emp:e,enf:e,eng:e,esp:e,etc:e,eti:e,far:e,feira:e,flog:e,floripa:e,fm:e,fnd:e,fortal:e,fot:e,foz:e,fst:e,g12:e,geo:e,ggf:e,goiania:e,gov:[1,{ac:e,al:e,am:e,ap:e,ba:e,ce:e,df:e,es:e,go:e,ma:e,mg:e,ms:e,mt:e,pa:e,pb:e,pe:e,pi:e,pr:e,rj:e,rn:e,ro:e,rr:e,rs:e,sc:e,se:e,sp:e,to:e}],gru:e,imb:e,ind:e,inf:e,jab:e,jampa:e,jdf:e,joinville:e,jor:e,jus:e,leg:e,leilao:e,lel:e,log:e,
londrina:e,macapa:e,maceio:e,manaus:e,maringa:e,mat:e,med:e,mil:e,morena:e,mp:e,mus:e,natal:e,net:e,niteroi:e,nom:a,not:e,ntr:e,odo:e,ong:e,org:e,osasco:e,palmas:e,poa:e,ppg:e,pro:e,psc:e,psi:e,pvh:e,qsl:e,radio:e,rec:e,recife:e,rep:e,ribeirao:e,rio:e,riobranco:e,riopreto:e,salvador:e,sampa:e,santamaria:e,santoandre:e,saobernardo:e,saogonca:e,seg:e,sjc:e,slg:e,slz:e,sorocaba:e,srv:e,taxi:e,tc:e,tec:e,teo:e,the:e,tmp:e,trd:e,tur:e,tv:e,udi:e,vet:e,vix:e,vlog:e,wiki:e,zlg:e}],bs:r,bt:r,bv:e,bw:[1,{ac:e,co:e,gov:e,net:e,org:e}],by:[1,{gov:e,mil:e,com:e,of:e}],bz:o,ca:[1,{ab:e,bc:e,mb:e,nb:e,nf:e,nl:e,ns:e,nt:e,nu:e,on:e,pe:e,qc:e,sk:e,yk:e,gc:e}],cat:e,cc:e,cd:n,cf:e,cg:e,ch:e,ci:[1,{ac:e,"xn--aroport-bya":e,aéroport:e,asso:e,co:e,com:e,ed:e,edu:e,go:e,gouv:e,int:e,net:e,or:e,org:e}],ck:a,cl:[1,{co:e,gob:e,gov:e,mil:e}],cm:[1,{co:e,com:e,gov:e,net:e}],cn:[1,{ac:e,com:e,edu:e,gov:e,mil:e,net:e,org:e,"xn--55qx5d":e,公司:e,"xn--od0alg":e,網絡:e,"xn--io0a7i":e,网络:e,ah:e,bj:e,cq:e,fj:e,
gd:e,gs:e,gx:e,gz:e,ha:e,hb:e,he:e,hi:e,hk:e,hl:e,hn:e,jl:e,js:e,jx:e,ln:e,mo:e,nm:e,nx:e,qh:e,sc:e,sd:e,sh:e,sn:e,sx:e,tj:e,tw:e,xj:e,xz:e,yn:e,zj:e}],co:[1,{com:e,edu:e,gov:e,mil:e,net:e,nom:e,org:e}],com:e,coop:e,cr:[1,{ac:e,co:e,ed:e,fi:e,go:e,or:e,sa:e}],cu:[1,{com:e,edu:e,gob:e,inf:e,nat:e,net:e,org:e}],cv:[1,{com:e,edu:e,id:e,int:e,net:e,nome:e,org:e,publ:e}],cw:s,cx:n,cy:[1,{ac:e,biz:e,com:e,ekloges:e,gov:e,ltd:e,mil:e,net:e,org:e,press:e,pro:e,tm:e}],cz:n,de:e,dj:e,dk:e,dm:o,do:[1,{art:e,com:e,edu:e,gob:e,gov:e,mil:e,net:e,org:e,sld:e,web:e}],dz:[1,{art:e,asso:e,com:e,edu:e,gov:e,net:e,org:e,pol:e,soc:e,tm:e}],ec:[1,{abg:e,adm:e,agron:e,arqt:e,art:e,bar:e,chef:e,com:e,cont:e,cpa:e,cue:e,dent:e,dgn:e,disco:e,doc:e,edu:e,eng:e,esm:e,fin:e,fot:e,gal:e,gob:e,gov:e,gye:e,ibr:e,info:e,k12:e,lat:e,loj:e,med:e,mil:e,mktg:e,mon:e,net:e,ntr:e,odont:e,org:e,pro:e,prof:e,psic:e,psiq:e,pub:e,rio:e,rrpp:e,sal:e,tech:e,tul:e,tur:e,uio:e,vet:e,xxx:e}],edu:e,ee:[1,{aip:e,com:e,edu:e,fie:e,gov:e,
lib:e,med:e,org:e,pri:e,riik:e}],eg:[1,{ac:e,com:e,edu:e,eun:e,gov:e,info:e,me:e,mil:e,name:e,net:e,org:e,sci:e,sport:e,tv:e}],er:a,es:[1,{com:e,edu:e,gob:e,nom:e,org:e}],et:[1,{biz:e,com:e,edu:e,gov:e,info:e,name:e,net:e,org:e}],eu:e,fi:[1,{aland:e}],fj:[1,{ac:e,biz:e,com:e,gov:e,info:e,mil:e,name:e,net:e,org:e,pro:e}],fk:a,fm:s,fo:e,fr:[1,{asso:e,com:e,gouv:e,nom:e,prd:e,tm:e,avoues:e,cci:e,greta:e,"huissier-justice":e}],ga:e,gb:e,gd:[1,{edu:e,gov:e}],ge:[1,{com:e,edu:e,gov:e,net:e,org:e,pvt:e,school:e}],gf:e,gg:c,gh:[1,{biz:e,com:e,edu:e,gov:e,mil:e,net:e,org:e}],gi:[1,{com:e,edu:e,gov:e,ltd:e,mod:e,org:e}],gl:[1,{co:e,com:e,edu:e,net:e,org:e}],gm:e,gn:[1,{ac:e,com:e,edu:e,gov:e,net:e,org:e}],gov:e,gp:[1,{asso:e,com:e,edu:e,mobi:e,net:e,org:e}],gq:e,gr:r,gs:e,gt:[1,{com:e,edu:e,gob:e,ind:e,mil:e,net:e,org:e}],gu:[1,{com:e,edu:e,gov:e,guam:e,info:e,net:e,org:e,web:e}],gw:e,gy:o,hk:[1,{com:e,edu:e,gov:e,idv:e,net:e,org:e,"xn--ciqpn":e,个人:e,"xn--gmqw5a":e,個人:e,"xn--55qx5d":e,公司:e,
"xn--mxtq1m":e,政府:e,"xn--lcvr32d":e,敎育:e,"xn--wcvs22d":e,教育:e,"xn--gmq050i":e,箇人:e,"xn--uc0atv":e,組織:e,"xn--uc0ay4a":e,組织:e,"xn--od0alg":e,網絡:e,"xn--zf0avx":e,網络:e,"xn--mk0axi":e,组織:e,"xn--tn0ag":e,组织:e,"xn--od0aq3b":e,网絡:e,"xn--io0a7i":e,网络:e}],hm:e,hn:[1,{com:e,edu:e,gob:e,mil:e,net:e,org:e}],hr:[1,{com:e,from:e,iz:e,name:e}],ht:[1,{adult:e,art:e,asso:e,com:e,coop:e,edu:e,firm:e,gouv:e,info:e,med:e,net:e,org:e,perso:e,pol:e,pro:e,rel:e,shop:e}],hu:[1,{2e3:e,agrar:e,bolt:e,casino:e,city:e,co:e,erotica:e,erotika:e,film:e,forum:e,games:e,hotel:e,info:e,ingatlan:e,jogasz:e,konyvelo:e,lakas:e,media:e,news:e,org:e,priv:e,reklam:e,sex:e,shop:e,sport:e,suli:e,szex:e,tm:e,tozsde:e,utazas:e,video:e}],id:[1,{ac:e,biz:e,co:e,desa:e,go:e,kop:e,mil:e,my:e,net:e,or:e,ponpes:e,sch:e,web:e}],ie:n,il:[1,{ac:e,co:e,gov:e,idf:e,k12:e,muni:e,net:e,org:e}],"xn--4dbrk0ce":[1,{"xn--4dbgdty6c":e,"xn--5dbhl8d":e,"xn--8dbq2a":e,"xn--hebda8b":e}],ישראל:[1,{אקדמיה:e,
ישוב:e,צהל:e,ממשל:e}],im:[1,{ac:e,co:[1,{ltd:e,plc:e}],com:e,net:e,org:e,tt:e,tv:e}],in:[1,{"5g":e,"6g":e,ac:e,ai:e,am:e,bihar:e,biz:e,business:e,ca:e,cn:e,co:e,com:e,coop:e,cs:e,delhi:e,dr:e,edu:e,er:e,firm:e,gen:e,gov:e,gujarat:e,ind:e,info:e,int:e,internet:e,io:e,me:e,mil:e,net:e,nic:e,org:e,pg:e,post:e,pro:e,res:e,travel:e,tv:e,uk:e,up:e,us:e}],info:e,int:[1,{eu:e}],io:u,iq:t,ir:[1,{ac:e,co:e,gov:e,id:e,net:e,org:e,sch:e,"xn--mgba3a4f16a":e,ایران:e,"xn--mgba3a4fra":e,ايران:e}],is:e,it:[1,{edu:e,gov:e,abr:e,abruzzo:e,"aosta-valley":e,aostavalley:e,bas:e,basilicata:e,cal:e,calabria:e,cam:e,campania:e,"emilia-romagna":e,emiliaromagna:e,emr:e,"friuli-v-giulia":e,"friuli-ve-giulia":e,"friuli-vegiulia":e,"friuli-venezia-giulia":e,"friuli-veneziagiulia":e,"friuli-vgiulia":e,"friuliv-giulia":e,"friulive-giulia":e,friulivegiulia:e,"friulivenezia-giulia":e,friuliveneziagiulia:e,friulivgiulia:e,fvg:e,laz:e,lazio:e,lig:e,liguria:e,lom:e,lombardia:e,lombardy:e,lucania:e,mar:e,
marche:e,mol:e,molise:e,piedmont:e,piemonte:e,pmn:e,pug:e,puglia:e,sar:e,sardegna:e,sardinia:e,sic:e,sicilia:e,sicily:e,taa:e,tos:e,toscana:e,"trentin-sud-tirol":e,"xn--trentin-sd-tirol-rzb":e,"trentin-süd-tirol":e,"trentin-sudtirol":e,"xn--trentin-sdtirol-7vb":e,"trentin-südtirol":e,"trentin-sued-tirol":e,"trentin-suedtirol":e,trentino:e,"trentino-a-adige":e,"trentino-aadige":e,"trentino-alto-adige":e,"trentino-altoadige":e,"trentino-s-tirol":e,"trentino-stirol":e,"trentino-sud-tirol":e,"xn--trentino-sd-tirol-c3b":e,"trentino-süd-tirol":e,"trentino-sudtirol":e,"xn--trentino-sdtirol-szb":e,"trentino-südtirol":e,"trentino-sued-tirol":e,"trentino-suedtirol":e,"trentinoa-adige":e,trentinoaadige:e,"trentinoalto-adige":e,trentinoaltoadige:e,"trentinos-tirol":e,trentinostirol:e,"trentinosud-tirol":e,"xn--trentinosd-tirol-rzb":e,"trentinosüd-tirol":e,trentinosudtirol:e,"xn--trentinosdtirol-7vb":e,trentinosüdtirol:e,"trentinosued-tirol":e,trentinosuedtirol:e,"trentinsud-tirol":e,"xn--tre\
ntinsd-tirol-6vb":e,"trentinsüd-tirol":e,trentinsudtirol:e,"xn--trentinsdtirol-nsb":e,trentinsüdtirol:e,"trentinsued-tirol":e,trentinsuedtirol:e,tuscany:e,umb:e,umbria:e,"val-d-aosta":e,"val-daosta":e,"vald-aosta":e,valdaosta:e,"valle-aosta":e,"valle-d-aosta":e,"valle-daosta":e,valleaosta:e,"valled-aosta":e,valledaosta:e,"vallee-aoste":e,"xn--valle-aoste-ebb":e,"vallée-aoste":e,"vallee-d-aoste":e,"xn--valle-d-aoste-ehb":e,"vallée-d-aoste":e,valleeaoste:e,"xn--valleaoste-e7a":e,valléeaoste:e,valleedaoste:e,"xn--valledaoste-ebb":e,valléedaoste:e,vao:e,vda:e,ven:e,veneto:e,ag:e,agrigento:e,al:e,alessandria:e,"alto-adige":e,altoadige:e,an:e,ancona:e,"andria-barletta-trani":e,"andria-trani-barletta":e,andriabarlettatrani:e,andriatranibarletta:e,ao:e,aosta:e,aoste:e,ap:e,aq:e,aquila:e,ar:e,arezzo:e,"ascoli-piceno":e,ascolipiceno:e,asti:e,at:e,av:e,avellino:e,ba:e,balsan:e,"balsan-sudtirol":e,"xn--balsan-sdtirol-nsb":e,"balsan-südtirol":e,"balsan-suedtirol":e,bari:e,"barletta-trani-and\
ria":e,barlettatraniandria:e,belluno:e,benevento:e,bergamo:e,bg:e,bi:e,biella:e,bl:e,bn:e,bo:e,bologna:e,bolzano:e,"bolzano-altoadige":e,bozen:e,"bozen-sudtirol":e,"xn--bozen-sdtirol-2ob":e,"bozen-südtirol":e,"bozen-suedtirol":e,br:e,brescia:e,brindisi:e,bs:e,bt:e,bulsan:e,"bulsan-sudtirol":e,"xn--bulsan-sdtirol-nsb":e,"bulsan-südtirol":e,"bulsan-suedtirol":e,bz:e,ca:e,cagliari:e,caltanissetta:e,"campidano-medio":e,campidanomedio:e,campobasso:e,"carbonia-iglesias":e,carboniaiglesias:e,"carrara-massa":e,carraramassa:e,caserta:e,catania:e,catanzaro:e,cb:e,ce:e,"cesena-forli":e,"xn--cesena-forl-mcb":e,"cesena-forlì":e,cesenaforli:e,"xn--cesenaforl-i8a":e,cesenaforlì:e,ch:e,chieti:e,ci:e,cl:e,cn:e,co:e,como:e,cosenza:e,cr:e,cremona:e,crotone:e,cs:e,ct:e,cuneo:e,cz:e,"dell-ogliastra":e,dellogliastra:e,en:e,enna:e,fc:e,fe:e,fermo:e,ferrara:e,fg:e,fi:e,firenze:e,florence:e,fm:e,foggia:e,"forli-cesena":e,"xn--forl-cesena-fcb":e,"forlì-cesena":e,forlicesena:e,"xn--forlcesena-c8a":e,forlìcesena:e,
fr:e,frosinone:e,ge:e,genoa:e,genova:e,go:e,gorizia:e,gr:e,grosseto:e,"iglesias-carbonia":e,iglesiascarbonia:e,im:e,imperia:e,is:e,isernia:e,kr:e,"la-spezia":e,laquila:e,laspezia:e,latina:e,lc:e,le:e,lecce:e,lecco:e,li:e,livorno:e,lo:e,lodi:e,lt:e,lu:e,lucca:e,macerata:e,mantova:e,"massa-carrara":e,massacarrara:e,matera:e,mb:e,mc:e,me:e,"medio-campidano":e,mediocampidano:e,messina:e,mi:e,milan:e,milano:e,mn:e,mo:e,modena:e,monza:e,"monza-brianza":e,"monza-e-della-brianza":e,monzabrianza:e,monzaebrianza:e,monzaedellabrianza:e,ms:e,mt:e,na:e,naples:e,napoli:e,no:e,novara:e,nu:e,nuoro:e,og:e,ogliastra:e,"olbia-tempio":e,olbiatempio:e,or:e,oristano:e,ot:e,pa:e,padova:e,padua:e,palermo:e,parma:e,pavia:e,pc:e,pd:e,pe:e,perugia:e,"pesaro-urbino":e,pesarourbino:e,pescara:e,pg:e,pi:e,piacenza:e,pisa:e,pistoia:e,pn:e,po:e,pordenone:e,potenza:e,pr:e,prato:e,pt:e,pu:e,pv:e,pz:e,ra:e,ragusa:e,ravenna:e,rc:e,re:e,"reggio-calabria":e,"reggio-emilia":e,reggiocalabria:e,reggioemilia:e,rg:e,ri:e,rieti:e,
rimini:e,rm:e,rn:e,ro:e,roma:e,rome:e,rovigo:e,sa:e,salerno:e,sassari:e,savona:e,si:e,siena:e,siracusa:e,so:e,sondrio:e,sp:e,sr:e,ss:e,"xn--sdtirol-n2a":e,südtirol:e,suedtirol:e,sv:e,ta:e,taranto:e,te:e,"tempio-olbia":e,tempioolbia:e,teramo:e,terni:e,tn:e,to:e,torino:e,tp:e,tr:e,"trani-andria-barletta":e,"trani-barletta-andria":e,traniandriabarletta:e,tranibarlettaandria:e,trapani:e,trento:e,treviso:e,trieste:e,ts:e,turin:e,tv:e,ud:e,udine:e,"urbino-pesaro":e,urbinopesaro:e,va:e,varese:e,vb:e,vc:e,ve:e,venezia:e,venice:e,verbania:e,vercelli:e,verona:e,vi:e,"vibo-valentia":e,vibovalentia:e,vicenza:e,viterbo:e,vr:e,vs:e,vt:e,vv:e}],je:c,jm:a,jo:[1,{agri:e,ai:e,com:e,edu:e,eng:e,fm:e,gov:e,mil:e,net:e,org:e,per:e,phd:e,sch:e,tv:e}],jobs:e,jp:[1,{ac:e,ad:e,co:e,ed:e,go:e,gr:e,lg:e,ne:e,or:e,aichi:[1,{aisai:e,ama:e,anjo:e,asuke:e,chiryu:e,chita:e,fuso:e,gamagori:e,handa:e,hazu:e,hekinan:e,higashiura:e,ichinomiya:e,inazawa:e,inuyama:e,isshiki:e,iwakura:e,kanie:e,kariya:e,kasugai:e,kira:e,kiyosu:e,
komaki:e,konan:e,kota:e,mihama:e,miyoshi:e,nishio:e,nisshin:e,obu:e,oguchi:e,oharu:e,okazaki:e,owariasahi:e,seto:e,shikatsu:e,shinshiro:e,shitara:e,tahara:e,takahama:e,tobishima:e,toei:e,togo:e,tokai:e,tokoname:e,toyoake:e,toyohashi:e,toyokawa:e,toyone:e,toyota:e,tsushima:e,yatomi:e}],akita:[1,{akita:e,daisen:e,fujisato:e,gojome:e,hachirogata:e,happou:e,higashinaruse:e,honjo:e,honjyo:e,ikawa:e,kamikoani:e,kamioka:e,katagami:e,kazuno:e,kitaakita:e,kosaka:e,kyowa:e,misato:e,mitane:e,moriyoshi:e,nikaho:e,noshiro:e,odate:e,oga:e,ogata:e,semboku:e,yokote:e,yurihonjo:e}],aomori:[1,{aomori:e,gonohe:e,hachinohe:e,hashikami:e,hiranai:e,hirosaki:e,itayanagi:e,kuroishi:e,misawa:e,mutsu:e,nakadomari:e,noheji:e,oirase:e,owani:e,rokunohe:e,sannohe:e,shichinohe:e,shingo:e,takko:e,towada:e,tsugaru:e,tsuruta:e}],chiba:[1,{abiko:e,asahi:e,chonan:e,chosei:e,choshi:e,chuo:e,funabashi:e,futtsu:e,hanamigawa:e,ichihara:e,ichikawa:e,ichinomiya:e,inzai:e,isumi:e,kamagaya:e,kamogawa:e,kashiwa:e,katori:e,katsuura:e,
kimitsu:e,kisarazu:e,kozaki:e,kujukuri:e,kyonan:e,matsudo:e,midori:e,mihama:e,minamiboso:e,mobara:e,mutsuzawa:e,nagara:e,nagareyama:e,narashino:e,narita:e,noda:e,oamishirasato:e,omigawa:e,onjuku:e,otaki:e,sakae:e,sakura:e,shimofusa:e,shirako:e,shiroi:e,shisui:e,sodegaura:e,sosa:e,tako:e,tateyama:e,togane:e,tohnosho:e,tomisato:e,urayasu:e,yachimata:e,yachiyo:e,yokaichiba:e,yokoshibahikari:e,yotsukaido:e}],ehime:[1,{ainan:e,honai:e,ikata:e,imabari:e,iyo:e,kamijima:e,kihoku:e,kumakogen:e,masaki:e,matsuno:e,matsuyama:e,namikata:e,niihama:e,ozu:e,saijo:e,seiyo:e,shikokuchuo:e,tobe:e,toon:e,uchiko:e,uwajima:e,yawatahama:e}],fukui:[1,{echizen:e,eiheiji:e,fukui:e,ikeda:e,katsuyama:e,mihama:e,minamiechizen:e,obama:e,ohi:e,ono:e,sabae:e,sakai:e,takahama:e,tsuruga:e,wakasa:e}],fukuoka:[1,{ashiya:e,buzen:e,chikugo:e,chikuho:e,chikujo:e,chikushino:e,chikuzen:e,chuo:e,dazaifu:e,fukuchi:e,hakata:e,higashi:e,hirokawa:e,hisayama:e,iizuka:e,inatsuki:e,kaho:e,kasuga:e,kasuya:e,kawara:e,keisen:e,koga:e,kurate:e,
kurogi:e,kurume:e,minami:e,miyako:e,miyama:e,miyawaka:e,mizumaki:e,munakata:e,nakagawa:e,nakama:e,nishi:e,nogata:e,ogori:e,okagaki:e,okawa:e,oki:e,omuta:e,onga:e,onojo:e,oto:e,saigawa:e,sasaguri:e,shingu:e,shinyoshitomi:e,shonai:e,soeda:e,sue:e,tachiarai:e,tagawa:e,takata:e,toho:e,toyotsu:e,tsuiki:e,ukiha:e,umi:e,usui:e,yamada:e,yame:e,yanagawa:e,yukuhashi:e}],fukushima:[1,{aizubange:e,aizumisato:e,aizuwakamatsu:e,asakawa:e,bandai:e,date:e,fukushima:e,furudono:e,futaba:e,hanawa:e,higashi:e,hirata:e,hirono:e,iitate:e,inawashiro:e,ishikawa:e,iwaki:e,izumizaki:e,kagamiishi:e,kaneyama:e,kawamata:e,kitakata:e,kitashiobara:e,koori:e,koriyama:e,kunimi:e,miharu:e,mishima:e,namie:e,nango:e,nishiaizu:e,nishigo:e,okuma:e,omotego:e,ono:e,otama:e,samegawa:e,shimogo:e,shirakawa:e,showa:e,soma:e,sukagawa:e,taishin:e,tamakawa:e,tanagura:e,tenei:e,yabuki:e,yamato:e,yamatsuri:e,yanaizu:e,yugawa:e}],gifu:[1,{anpachi:e,ena:e,gifu:e,ginan:e,godo:e,gujo:e,hashima:e,hichiso:e,hida:e,higashishirakawa:e,ibigawa:e,
ikeda:e,kakamigahara:e,kani:e,kasahara:e,kasamatsu:e,kawaue:e,kitagata:e,mino:e,minokamo:e,mitake:e,mizunami:e,motosu:e,nakatsugawa:e,ogaki:e,sakahogi:e,seki:e,sekigahara:e,shirakawa:e,tajimi:e,takayama:e,tarui:e,toki:e,tomika:e,wanouchi:e,yamagata:e,yaotsu:e,yoro:e}],gunma:[1,{annaka:e,chiyoda:e,fujioka:e,higashiagatsuma:e,isesaki:e,itakura:e,kanna:e,kanra:e,katashina:e,kawaba:e,kiryu:e,kusatsu:e,maebashi:e,meiwa:e,midori:e,minakami:e,naganohara:e,nakanojo:e,nanmoku:e,numata:e,oizumi:e,ora:e,ota:e,shibukawa:e,shimonita:e,shinto:e,showa:e,takasaki:e,takayama:e,tamamura:e,tatebayashi:e,tomioka:e,tsukiyono:e,tsumagoi:e,ueno:e,yoshioka:e}],hiroshima:[1,{asaminami:e,daiwa:e,etajima:e,fuchu:e,fukuyama:e,hatsukaichi:e,higashihiroshima:e,hongo:e,jinsekikogen:e,kaita:e,kui:e,kumano:e,kure:e,mihara:e,miyoshi:e,naka:e,onomichi:e,osakikamijima:e,otake:e,saka:e,sera:e,seranishi:e,shinichi:e,shobara:e,takehara:e}],hokkaido:[1,{abashiri:e,abira:e,aibetsu:e,akabira:e,akkeshi:e,asahikawa:e,ashibetsu:e,
ashoro:e,assabu:e,atsuma:e,bibai:e,biei:e,bifuka:e,bihoro:e,biratori:e,chippubetsu:e,chitose:e,date:e,ebetsu:e,embetsu:e,eniwa:e,erimo:e,esan:e,esashi:e,fukagawa:e,fukushima:e,furano:e,furubira:e,haboro:e,hakodate:e,hamatonbetsu:e,hidaka:e,higashikagura:e,higashikawa:e,hiroo:e,hokuryu:e,hokuto:e,honbetsu:e,horokanai:e,horonobe:e,ikeda:e,imakane:e,ishikari:e,iwamizawa:e,iwanai:e,kamifurano:e,kamikawa:e,kamishihoro:e,kamisunagawa:e,kamoenai:e,kayabe:e,kembuchi:e,kikonai:e,kimobetsu:e,kitahiroshima:e,kitami:e,kiyosato:e,koshimizu:e,kunneppu:e,kuriyama:e,kuromatsunai:e,kushiro:e,kutchan:e,kyowa:e,mashike:e,matsumae:e,mikasa:e,minamifurano:e,mombetsu:e,moseushi:e,mukawa:e,muroran:e,naie:e,nakagawa:e,nakasatsunai:e,nakatombetsu:e,nanae:e,nanporo:e,nayoro:e,nemuro:e,niikappu:e,niki:e,nishiokoppe:e,noboribetsu:e,numata:e,obihiro:e,obira:e,oketo:e,okoppe:e,otaru:e,otobe:e,otofuke:e,otoineppu:e,oumu:e,ozora:e,pippu:e,rankoshi:e,rebun:e,rikubetsu:e,rishiri:e,rishirifuji:e,saroma:e,sarufutsu:e,shakotan:e,
shari:e,shibecha:e,shibetsu:e,shikabe:e,shikaoi:e,shimamaki:e,shimizu:e,shimokawa:e,shinshinotsu:e,shintoku:e,shiranuka:e,shiraoi:e,shiriuchi:e,sobetsu:e,sunagawa:e,taiki:e,takasu:e,takikawa:e,takinoue:e,teshikaga:e,tobetsu:e,tohma:e,tomakomai:e,tomari:e,toya:e,toyako:e,toyotomi:e,toyoura:e,tsubetsu:e,tsukigata:e,urakawa:e,urausu:e,uryu:e,utashinai:e,wakkanai:e,wassamu:e,yakumo:e,yoichi:e}],hyogo:[1,{aioi:e,akashi:e,ako:e,amagasaki:e,aogaki:e,asago:e,ashiya:e,awaji:e,fukusaki:e,goshiki:e,harima:e,himeji:e,ichikawa:e,inagawa:e,itami:e,kakogawa:e,kamigori:e,kamikawa:e,kasai:e,kasuga:e,kawanishi:e,miki:e,minamiawaji:e,nishinomiya:e,nishiwaki:e,ono:e,sanda:e,sannan:e,sasayama:e,sayo:e,shingu:e,shinonsen:e,shiso:e,sumoto:e,taishi:e,taka:e,takarazuka:e,takasago:e,takino:e,tamba:e,tatsuno:e,toyooka:e,yabu:e,yashiro:e,yoka:e,yokawa:e}],ibaraki:[1,{ami:e,asahi:e,bando:e,chikusei:e,daigo:e,fujishiro:e,hitachi:e,hitachinaka:e,hitachiomiya:e,hitachiota:e,ibaraki:e,ina:e,inashiki:e,itako:e,iwama:e,
joso:e,kamisu:e,kasama:e,kashima:e,kasumigaura:e,koga:e,miho:e,mito:e,moriya:e,naka:e,namegata:e,oarai:e,ogawa:e,omitama:e,ryugasaki:e,sakai:e,sakuragawa:e,shimodate:e,shimotsuma:e,shirosato:e,sowa:e,suifu:e,takahagi:e,tamatsukuri:e,tokai:e,tomobe:e,tone:e,toride:e,tsuchiura:e,tsukuba:e,uchihara:e,ushiku:e,yachiyo:e,yamagata:e,yawara:e,yuki:e}],ishikawa:[1,{anamizu:e,hakui:e,hakusan:e,kaga:e,kahoku:e,kanazawa:e,kawakita:e,komatsu:e,nakanoto:e,nanao:e,nomi:e,nonoichi:e,noto:e,shika:e,suzu:e,tsubata:e,tsurugi:e,uchinada:e,wajima:e}],iwate:[1,{fudai:e,fujisawa:e,hanamaki:e,hiraizumi:e,hirono:e,ichinohe:e,ichinoseki:e,iwaizumi:e,iwate:e,joboji:e,kamaishi:e,kanegasaki:e,karumai:e,kawai:e,kitakami:e,kuji:e,kunohe:e,kuzumaki:e,miyako:e,mizusawa:e,morioka:e,ninohe:e,noda:e,ofunato:e,oshu:e,otsuchi:e,rikuzentakata:e,shiwa:e,shizukuishi:e,sumita:e,tanohata:e,tono:e,yahaba:e,yamada:e}],kagawa:[1,{ayagawa:e,higashikagawa:e,kanonji:e,kotohira:e,manno:e,marugame:e,mitoyo:e,naoshima:e,sanuki:e,tadotsu:e,
takamatsu:e,tonosho:e,uchinomi:e,utazu:e,zentsuji:e}],kagoshima:[1,{akune:e,amami:e,hioki:e,isa:e,isen:e,izumi:e,kagoshima:e,kanoya:e,kawanabe:e,kinko:e,kouyama:e,makurazaki:e,matsumoto:e,minamitane:e,nakatane:e,nishinoomote:e,satsumasendai:e,soo:e,tarumizu:e,yusui:e}],kanagawa:[1,{aikawa:e,atsugi:e,ayase:e,chigasaki:e,ebina:e,fujisawa:e,hadano:e,hakone:e,hiratsuka:e,isehara:e,kaisei:e,kamakura:e,kiyokawa:e,matsuda:e,minamiashigara:e,miura:e,nakai:e,ninomiya:e,odawara:e,oi:e,oiso:e,sagamihara:e,samukawa:e,tsukui:e,yamakita:e,yamato:e,yokosuka:e,yugawara:e,zama:e,zushi:e}],kochi:[1,{aki:e,geisei:e,hidaka:e,higashitsuno:e,ino:e,kagami:e,kami:e,kitagawa:e,kochi:e,mihara:e,motoyama:e,muroto:e,nahari:e,nakamura:e,nankoku:e,nishitosa:e,niyodogawa:e,ochi:e,okawa:e,otoyo:e,otsuki:e,sakawa:e,sukumo:e,susaki:e,tosa:e,tosashimizu:e,toyo:e,tsuno:e,umaji:e,yasuda:e,yusuhara:e}],kumamoto:[1,{amakusa:e,arao:e,aso:e,choyo:e,gyokuto:e,kamiamakusa:e,kikuchi:e,kumamoto:e,mashiki:e,mifune:e,minamata:e,minamioguni:e,
nagasu:e,nishihara:e,oguni:e,ozu:e,sumoto:e,takamori:e,uki:e,uto:e,yamaga:e,yamato:e,yatsushiro:e}],kyoto:[1,{ayabe:e,fukuchiyama:e,higashiyama:e,ide:e,ine:e,joyo:e,kameoka:e,kamo:e,kita:e,kizu:e,kumiyama:e,kyotamba:e,kyotanabe:e,kyotango:e,maizuru:e,minami:e,minamiyamashiro:e,miyazu:e,muko:e,nagaokakyo:e,nakagyo:e,nantan:e,oyamazaki:e,sakyo:e,seika:e,tanabe:e,uji:e,ujitawara:e,wazuka:e,yamashina:e,yawata:e}],mie:[1,{asahi:e,inabe:e,ise:e,kameyama:e,kawagoe:e,kiho:e,kisosaki:e,kiwa:e,komono:e,kumano:e,kuwana:e,matsusaka:e,meiwa:e,mihama:e,minamiise:e,misugi:e,miyama:e,nabari:e,shima:e,suzuka:e,tado:e,taiki:e,taki:e,tamaki:e,toba:e,tsu:e,udono:e,ureshino:e,watarai:e,yokkaichi:e}],miyagi:[1,{furukawa:e,higashimatsushima:e,ishinomaki:e,iwanuma:e,kakuda:e,kami:e,kawasaki:e,marumori:e,matsushima:e,minamisanriku:e,misato:e,murata:e,natori:e,ogawara:e,ohira:e,onagawa:e,osaki:e,rifu:e,semine:e,shibata:e,shichikashuku:e,shikama:e,shiogama:e,shiroishi:e,tagajo:e,taiwa:e,tome:e,tomiya:e,wakuya:e,
watari:e,yamamoto:e,zao:e}],miyazaki:[1,{aya:e,ebino:e,gokase:e,hyuga:e,kadogawa:e,kawaminami:e,kijo:e,kitagawa:e,kitakata:e,kitaura:e,kobayashi:e,kunitomi:e,kushima:e,mimata:e,miyakonojo:e,miyazaki:e,morotsuka:e,nichinan:e,nishimera:e,nobeoka:e,saito:e,shiiba:e,shintomi:e,takaharu:e,takanabe:e,takazaki:e,tsuno:e}],nagano:[1,{achi:e,agematsu:e,anan:e,aoki:e,asahi:e,azumino:e,chikuhoku:e,chikuma:e,chino:e,fujimi:e,hakuba:e,hara:e,hiraya:e,iida:e,iijima:e,iiyama:e,iizuna:e,ikeda:e,ikusaka:e,ina:e,karuizawa:e,kawakami:e,kiso:e,kisofukushima:e,kitaaiki:e,komagane:e,komoro:e,matsukawa:e,matsumoto:e,miasa:e,minamiaiki:e,minamimaki:e,minamiminowa:e,minowa:e,miyada:e,miyota:e,mochizuki:e,nagano:e,nagawa:e,nagiso:e,nakagawa:e,nakano:e,nozawaonsen:e,obuse:e,ogawa:e,okaya:e,omachi:e,omi:e,ookuwa:e,ooshika:e,otaki:e,otari:e,sakae:e,sakaki:e,saku:e,sakuho:e,shimosuwa:e,shinanomachi:e,shiojiri:e,suwa:e,suzaka:e,takagi:e,takamori:e,takayama:e,tateshina:e,tatsuno:e,togakushi:e,togura:e,tomi:e,ueda:e,wada:e,
yamagata:e,yamanouchi:e,yasaka:e,yasuoka:e}],nagasaki:[1,{chijiwa:e,futsu:e,goto:e,hasami:e,hirado:e,iki:e,isahaya:e,kawatana:e,kuchinotsu:e,matsuura:e,nagasaki:e,obama:e,omura:e,oseto:e,saikai:e,sasebo:e,seihi:e,shimabara:e,shinkamigoto:e,togitsu:e,tsushima:e,unzen:e}],nara:[1,{ando:e,gose:e,heguri:e,higashiyoshino:e,ikaruga:e,ikoma:e,kamikitayama:e,kanmaki:e,kashiba:e,kashihara:e,katsuragi:e,kawai:e,kawakami:e,kawanishi:e,koryo:e,kurotaki:e,mitsue:e,miyake:e,nara:e,nosegawa:e,oji:e,ouda:e,oyodo:e,sakurai:e,sango:e,shimoichi:e,shimokitayama:e,shinjo:e,soni:e,takatori:e,tawaramoto:e,tenkawa:e,tenri:e,uda:e,yamatokoriyama:e,yamatotakada:e,yamazoe:e,yoshino:e}],niigata:[1,{aga:e,agano:e,gosen:e,itoigawa:e,izumozaki:e,joetsu:e,kamo:e,kariwa:e,kashiwazaki:e,minamiuonuma:e,mitsuke:e,muika:e,murakami:e,myoko:e,nagaoka:e,niigata:e,ojiya:e,omi:e,sado:e,sanjo:e,seiro:e,seirou:e,sekikawa:e,shibata:e,tagami:e,tainai:e,tochio:e,tokamachi:e,tsubame:e,tsunan:e,uonuma:e,yahiko:e,yoita:e,yuzawa:e}],oita:[
1,{beppu:e,bungoono:e,bungotakada:e,hasama:e,hiji:e,himeshima:e,hita:e,kamitsue:e,kokonoe:e,kuju:e,kunisaki:e,kusu:e,oita:e,saiki:e,taketa:e,tsukumi:e,usa:e,usuki:e,yufu:e}],okayama:[1,{akaiwa:e,asakuchi:e,bizen:e,hayashima:e,ibara:e,kagamino:e,kasaoka:e,kibichuo:e,kumenan:e,kurashiki:e,maniwa:e,misaki:e,nagi:e,niimi:e,nishiawakura:e,okayama:e,satosho:e,setouchi:e,shinjo:e,shoo:e,soja:e,takahashi:e,tamano:e,tsuyama:e,wake:e,yakage:e}],okinawa:[1,{aguni:e,ginowan:e,ginoza:e,gushikami:e,haebaru:e,higashi:e,hirara:e,iheya:e,ishigaki:e,ishikawa:e,itoman:e,izena:e,kadena:e,kin:e,kitadaito:e,kitanakagusuku:e,kumejima:e,kunigami:e,minamidaito:e,motobu:e,nago:e,naha:e,nakagusuku:e,nakijin:e,nanjo:e,nishihara:e,ogimi:e,okinawa:e,onna:e,shimoji:e,taketomi:e,tarama:e,tokashiki:e,tomigusuku:e,tonaki:e,urasoe:e,uruma:e,yaese:e,yomitan:e,yonabaru:e,yonaguni:e,zamami:e}],osaka:[1,{abeno:e,chihayaakasaka:e,chuo:e,daito:e,fujiidera:e,habikino:e,hannan:e,higashiosaka:e,higashisumiyoshi:e,higashiyodogawa:e,
hirakata:e,ibaraki:e,ikeda:e,izumi:e,izumiotsu:e,izumisano:e,kadoma:e,kaizuka:e,kanan:e,kashiwara:e,katano:e,kawachinagano:e,kishiwada:e,kita:e,kumatori:e,matsubara:e,minato:e,minoh:e,misaki:e,moriguchi:e,neyagawa:e,nishi:e,nose:e,osakasayama:e,sakai:e,sayama:e,sennan:e,settsu:e,shijonawate:e,shimamoto:e,suita:e,tadaoka:e,taishi:e,tajiri:e,takaishi:e,takatsuki:e,tondabayashi:e,toyonaka:e,toyono:e,yao:e}],saga:[1,{ariake:e,arita:e,fukudomi:e,genkai:e,hamatama:e,hizen:e,imari:e,kamimine:e,kanzaki:e,karatsu:e,kashima:e,kitagata:e,kitahata:e,kiyama:e,kouhoku:e,kyuragi:e,nishiarita:e,ogi:e,omachi:e,ouchi:e,saga:e,shiroishi:e,taku:e,tara:e,tosu:e,yoshinogari:e}],saitama:[1,{arakawa:e,asaka:e,chichibu:e,fujimi:e,fujimino:e,fukaya:e,hanno:e,hanyu:e,hasuda:e,hatogaya:e,hatoyama:e,hidaka:e,higashichichibu:e,higashimatsuyama:e,honjo:e,ina:e,iruma:e,iwatsuki:e,kamiizumi:e,kamikawa:e,kamisato:e,kasukabe:e,kawagoe:e,kawaguchi:e,kawajima:e,kazo:e,kitamoto:e,koshigaya:e,kounosu:e,kuki:e,kumagaya:e,matsubushi:e,
minano:e,misato:e,miyashiro:e,miyoshi:e,moroyama:e,nagatoro:e,namegawa:e,niiza:e,ogano:e,ogawa:e,ogose:e,okegawa:e,omiya:e,otaki:e,ranzan:e,ryokami:e,saitama:e,sakado:e,satte:e,sayama:e,shiki:e,shiraoka:e,soka:e,sugito:e,toda:e,tokigawa:e,tokorozawa:e,tsurugashima:e,urawa:e,warabi:e,yashio:e,yokoze:e,yono:e,yorii:e,yoshida:e,yoshikawa:e,yoshimi:e}],shiga:[1,{aisho:e,gamo:e,higashiomi:e,hikone:e,koka:e,konan:e,kosei:e,koto:e,kusatsu:e,maibara:e,moriyama:e,nagahama:e,nishiazai:e,notogawa:e,omihachiman:e,otsu:e,ritto:e,ryuoh:e,takashima:e,takatsuki:e,torahime:e,toyosato:e,yasu:e}],shimane:[1,{akagi:e,ama:e,gotsu:e,hamada:e,higashiizumo:e,hikawa:e,hikimi:e,izumo:e,kakinoki:e,masuda:e,matsue:e,misato:e,nishinoshima:e,ohda:e,okinoshima:e,okuizumo:e,shimane:e,tamayu:e,tsuwano:e,unnan:e,yakumo:e,yasugi:e,yatsuka:e}],shizuoka:[1,{arai:e,atami:e,fuji:e,fujieda:e,fujikawa:e,fujinomiya:e,fukuroi:e,gotemba:e,haibara:e,hamamatsu:e,higashiizu:e,ito:e,iwata:e,izu:e,izunokuni:e,kakegawa:e,kannami:e,kawanehon:e,
kawazu:e,kikugawa:e,kosai:e,makinohara:e,matsuzaki:e,minamiizu:e,mishima:e,morimachi:e,nishiizu:e,numazu:e,omaezaki:e,shimada:e,shimizu:e,shimoda:e,shizuoka:e,susono:e,yaizu:e,yoshida:e}],tochigi:[1,{ashikaga:e,bato:e,haga:e,ichikai:e,iwafune:e,kaminokawa:e,kanuma:e,karasuyama:e,kuroiso:e,mashiko:e,mibu:e,moka:e,motegi:e,nasu:e,nasushiobara:e,nikko:e,nishikata:e,nogi:e,ohira:e,ohtawara:e,oyama:e,sakura:e,sano:e,shimotsuke:e,shioya:e,takanezawa:e,tochigi:e,tsuga:e,ujiie:e,utsunomiya:e,yaita:e}],tokushima:[1,{aizumi:e,anan:e,ichiba:e,itano:e,kainan:e,komatsushima:e,matsushige:e,mima:e,minami:e,miyoshi:e,mugi:e,nakagawa:e,naruto:e,sanagochi:e,shishikui:e,tokushima:e,wajiki:e}],tokyo:[1,{adachi:e,akiruno:e,akishima:e,aogashima:e,arakawa:e,bunkyo:e,chiyoda:e,chofu:e,chuo:e,edogawa:e,fuchu:e,fussa:e,hachijo:e,hachioji:e,hamura:e,higashikurume:e,higashimurayama:e,higashiyamato:e,hino:e,hinode:e,hinohara:e,inagi:e,itabashi:e,katsushika:e,kita:e,kiyose:e,kodaira:e,koganei:e,kokubunji:e,komae:e,
koto:e,kouzushima:e,kunitachi:e,machida:e,meguro:e,minato:e,mitaka:e,mizuho:e,musashimurayama:e,musashino:e,nakano:e,nerima:e,ogasawara:e,okutama:e,ome:e,oshima:e,ota:e,setagaya:e,shibuya:e,shinagawa:e,shinjuku:e,suginami:e,sumida:e,tachikawa:e,taito:e,tama:e,toshima:e}],tottori:[1,{chizu:e,hino:e,kawahara:e,koge:e,kotoura:e,misasa:e,nanbu:e,nichinan:e,sakaiminato:e,tottori:e,wakasa:e,yazu:e,yonago:e}],toyama:[1,{asahi:e,fuchu:e,fukumitsu:e,funahashi:e,himi:e,imizu:e,inami:e,johana:e,kamiichi:e,kurobe:e,nakaniikawa:e,namerikawa:e,nanto:e,nyuzen:e,oyabe:e,taira:e,takaoka:e,tateyama:e,toga:e,tonami:e,toyama:e,unazuki:e,uozu:e,yamada:e}],wakayama:[1,{arida:e,aridagawa:e,gobo:e,hashimoto:e,hidaka:e,hirogawa:e,inami:e,iwade:e,kainan:e,kamitonda:e,katsuragi:e,kimino:e,kinokawa:e,kitayama:e,koya:e,koza:e,kozagawa:e,kudoyama:e,kushimoto:e,mihama:e,misato:e,nachikatsuura:e,shingu:e,shirahama:e,taiji:e,tanabe:e,wakayama:e,yuasa:e,yura:e}],yamagata:[1,{asahi:e,funagata:e,higashine:e,iide:e,kahoku:e,
kaminoyama:e,kaneyama:e,kawanishi:e,mamurogawa:e,mikawa:e,murayama:e,nagai:e,nakayama:e,nanyo:e,nishikawa:e,obanazawa:e,oe:e,oguni:e,ohkura:e,oishida:e,sagae:e,sakata:e,sakegawa:e,shinjo:e,shirataka:e,shonai:e,takahata:e,tendo:e,tozawa:e,tsuruoka:e,yamagata:e,yamanobe:e,yonezawa:e,yuza:e}],yamaguchi:[1,{abu:e,hagi:e,hikari:e,hofu:e,iwakuni:e,kudamatsu:e,mitou:e,nagato:e,oshima:e,shimonoseki:e,shunan:e,tabuse:e,tokuyama:e,toyota:e,ube:e,yuu:e}],yamanashi:[1,{chuo:e,doshi:e,fuefuki:e,fujikawa:e,fujikawaguchiko:e,fujiyoshida:e,hayakawa:e,hokuto:e,ichikawamisato:e,kai:e,kofu:e,koshu:e,kosuge:e,"minami-alps":e,minobu:e,nakamichi:e,nanbu:e,narusawa:e,nirasaki:e,nishikatsura:e,oshino:e,otsuki:e,showa:e,tabayama:e,tsuru:e,uenohara:e,yamanakako:e,yamanashi:e}],"xn--ehqz56n":e,三重:e,"xn--1lqs03n":e,京都:e,"xn--qqqt11m":e,佐賀:e,"xn--f6qx53a":e,兵庫:e,"xn--djrs72d6uy":e,北海道:e,"xn--mkru45i":e,千葉:e,"xn--0trq7p7nn":e,和歌山:e,"xn--5js045d":e,埼玉:e,"xn--kbrq7o":e,大分:e,"xn\
--pssu33l":e,大阪:e,"xn--ntsq17g":e,奈良:e,"xn--uisz3g":e,宮城:e,"xn--6btw5a":e,宮崎:e,"xn--1ctwo":e,富山:e,"xn--6orx2r":e,山口:e,"xn--rht61e":e,山形:e,"xn--rht27z":e,山梨:e,"xn--nit225k":e,岐阜:e,"xn--rht3d":e,岡山:e,"xn--djty4k":e,岩手:e,"xn--klty5x":e,島根:e,"xn--kltx9a":e,広島:e,"xn--kltp7d":e,徳島:e,"xn--c3s14m":e,愛媛:e,"xn--vgu402c":e,愛知:e,"xn--efvn9s":e,新潟:e,"xn--1lqs71d":e,東京:e,"xn--4pvxs":e,栃木:e,"xn--uuwu58a":e,沖縄:e,"xn--zbx025d":e,滋賀:e,"xn--8pvr4u":e,熊本:e,"xn--5rtp49c":e,石川:e,"xn--ntso0iqx3a":e,神奈川:e,"xn--elqq16h":e,福井:e,"xn--4it168d":e,福岡:e,"xn--klt787d":e,福島:e,"xn--rny31h":e,秋田:e,"xn--7t0a264c":e,群馬:e,"xn--uist22h":e,茨城:e,"xn--8ltr62k":e,長崎:e,"xn--2m4a15e":e,長野:e,"xn--32vp30h":e,青森:e,"xn--4it797k":e,静岡:e,"xn--5rtq34k":e,香川:e,"xn--k7yn95e":e,高知:e,"xn--tor131o":e,鳥取:e,"xn--d5qv7z876c":e,鹿児島:e,kawasaki:a,kitakyushu:a,kobe:a,nagoya:a,sapporo:a,sendai:a,
yokohama:a}],ke:[1,{ac:e,co:e,go:e,info:e,me:e,mobi:e,ne:e,or:e,sc:e}],kg:t,kh:a,ki:l,km:[1,{ass:e,com:e,edu:e,gov:e,mil:e,nom:e,org:e,prd:e,tm:e,asso:e,coop:e,gouv:e,medecin:e,notaires:e,pharmaciens:e,presse:e,veterinaire:e}],kn:[1,{edu:e,gov:e,net:e,org:e}],kp:[1,{com:e,edu:e,gov:e,org:e,rep:e,tra:e}],kr:[1,{ac:e,ai:e,co:e,es:e,go:e,hs:e,io:e,it:e,kg:e,me:e,mil:e,ms:e,ne:e,or:e,pe:e,re:e,sc:e,busan:e,chungbuk:e,chungnam:e,daegu:e,daejeon:e,gangwon:e,gwangju:e,gyeongbuk:e,gyeonggi:e,gyeongnam:e,incheon:e,jeju:e,jeonbuk:e,jeonnam:e,seoul:e,ulsan:e}],kw:[1,{com:e,edu:e,emb:e,gov:e,ind:e,net:e,org:e}],ky:s,kz:t,la:[1,{com:e,edu:e,gov:e,info:e,int:e,net:e,org:e,per:e}],lb:r,lc:o,li:e,lk:[1,{ac:e,assn:e,com:e,edu:e,gov:e,grp:e,hotel:e,int:e,ltd:e,net:e,ngo:e,org:e,sch:e,soc:e,web:e}],lr:r,ls:[1,{ac:e,biz:e,co:e,edu:e,gov:e,info:e,net:e,org:e,sc:e}],lt:n,lu:e,lv:[1,{asn:e,com:e,conf:e,edu:e,gov:e,id:e,mil:e,net:e,org:e}],ly:[1,{com:e,edu:e,gov:e,id:e,med:e,net:e,org:e,plc:e,sch:e}],ma:[1,{ac:e,
co:e,gov:e,net:e,org:e,press:e}],mc:[1,{asso:e,tm:e}],md:e,me:[1,{ac:e,co:e,edu:e,gov:e,its:e,net:e,org:e,priv:e}],mg:[1,{co:e,com:e,edu:e,gov:e,mil:e,nom:e,org:e,prd:e}],mh:e,mil:e,mk:[1,{com:e,edu:e,gov:e,inf:e,name:e,net:e,org:e}],ml:[1,{ac:e,art:e,asso:e,com:e,edu:e,gouv:e,gov:e,info:e,inst:e,net:e,org:e,pr:e,presse:e}],mm:a,mn:[1,{edu:e,gov:e,org:e}],mo:r,mobi:e,mp:e,mq:e,mr:n,ms:r,mt:s,mu:[1,{ac:e,co:e,com:e,gov:e,net:e,or:e,org:e}],museum:e,mv:[1,{aero:e,biz:e,com:e,coop:e,edu:e,gov:e,info:e,int:e,mil:e,museum:e,name:e,net:e,org:e,pro:e}],mw:[1,{ac:e,biz:e,co:e,com:e,coop:e,edu:e,gov:e,int:e,net:e,org:e}],mx:[1,{com:e,edu:e,gob:e,net:e,org:e}],my:[1,{biz:e,com:e,edu:e,gov:e,mil:e,name:e,net:e,org:e}],mz:[1,{ac:e,adv:e,co:e,edu:e,gov:e,mil:e,net:e,org:e}],na:[1,{alt:e,co:e,com:e,gov:e,net:e,org:e}],name:e,nc:[1,{asso:e,nom:e}],ne:e,net:e,nf:[1,{arts:e,com:e,firm:e,info:e,net:e,other:e,per:e,rec:e,store:e,web:e}],ng:[1,{com:e,edu:e,gov:e,i:e,mil:e,mobi:e,name:e,net:e,org:e,sch:e}],
ni:[1,{ac:e,biz:e,co:e,com:e,edu:e,gob:e,in:e,info:e,int:e,mil:e,net:e,nom:e,org:e,web:e}],nl:e,no:[1,{fhs:e,folkebibl:e,fylkesbibl:e,idrett:e,museum:e,priv:e,vgs:e,dep:e,herad:e,kommune:e,mil:e,stat:e,aa:m,ah:m,bu:m,fm:m,hl:m,hm:m,"jan-mayen":m,mr:m,nl:m,nt:m,of:m,ol:m,oslo:m,rl:m,sf:m,st:m,svalbard:m,tm:m,tr:m,va:m,vf:m,akrehamn:e,"xn--krehamn-dxa":e,åkrehamn:e,algard:e,"xn--lgrd-poac":e,ålgård:e,arna:e,bronnoysund:e,"xn--brnnysund-m8ac":e,brønnøysund:e,brumunddal:e,bryne:e,drobak:e,"xn--drbak-wua":e,drøbak:e,egersund:e,fetsund:e,floro:e,"xn--flor-jra":e,florø:e,fredrikstad:e,hokksund:e,honefoss:e,"xn--hnefoss-q1a":e,hønefoss:e,jessheim:e,jorpeland:e,"xn--jrpeland-54a":e,jørpeland:e,kirkenes:e,kopervik:e,krokstadelva:e,langevag:e,"xn--langevg-jxa":e,langevåg:e,leirvik:e,mjondalen:e,"xn--mjndalen-64a":e,mjøndalen:e,"mo-i-rana":e,mosjoen:e,"xn--mosjen-eya":e,mosjøen:e,nesoddtangen:e,orkanger:e,osoyro:e,"xn--osyro-wua":e,osøyro:e,raholt:e,"xn--rholt-mra":e,råholt:e,sandnessjoen:e,
"xn--sandnessjen-ogb":e,sandnessjøen:e,skedsmokorset:e,slattum:e,spjelkavik:e,stathelle:e,stavern:e,stjordalshalsen:e,"xn--stjrdalshalsen-sqb":e,stjørdalshalsen:e,tananger:e,tranby:e,vossevangen:e,aarborte:e,aejrie:e,afjord:e,"xn--fjord-lra":e,åfjord:e,agdenes:e,akershus:p,aknoluokta:e,"xn--koluokta-7ya57h":e,ákŋoluokta:e,al:e,"xn--l-1fa":e,ål:e,alaheadju:e,"xn--laheadju-7ya":e,álaheadju:e,alesund:e,"xn--lesund-hua":e,ålesund:e,alstahaug:e,alta:e,"xn--lt-liac":e,áltá:e,alvdal:e,amli:e,"xn--mli-tla":e,åmli:e,amot:e,"xn--mot-tla":e,åmot:e,andasuolo:e,andebu:e,andoy:e,"xn--andy-ira":e,andøy:e,ardal:e,"xn--rdal-poa":e,årdal:e,aremark:e,arendal:e,"xn--s-1fa":e,ås:e,aseral:e,"xn--seral-lra":e,åseral:e,asker:e,askim:e,askoy:e,"xn--asky-ira":e,askøy:e,askvoll:e,asnes:e,"xn--snes-poa":e,åsnes:e,audnedaln:e,aukra:e,aure:e,aurland:e,"aurskog-holand":e,"xn--aurskog-hland-jnb":e,"aurskog-høland":e,austevoll:e,austrheim:e,averoy:e,"xn--avery-yua":e,averøy:e,badaddja:e,"xn--bdddj-\
mrabd":e,bådåddjå:e,"xn--brum-voa":e,bærum:e,bahcavuotna:e,"xn--bhcavuotna-s4a":e,báhcavuotna:e,bahccavuotna:e,"xn--bhccavuotna-k7a":e,báhccavuotna:e,baidar:e,"xn--bidr-5nac":e,báidár:e,bajddar:e,"xn--bjddar-pta":e,bájddar:e,balat:e,"xn--blt-elab":e,bálát:e,balestrand:e,ballangen:e,balsfjord:e,bamble:e,bardu:e,barum:e,batsfjord:e,"xn--btsfjord-9za":e,båtsfjord:e,bearalvahki:e,"xn--bearalvhki-y4a":e,bearalváhki:e,beardu:e,beiarn:e,berg:e,bergen:e,berlevag:e,"xn--berlevg-jxa":e,berlevåg:e,bievat:e,"xn--bievt-0qa":e,bievát:e,bindal:e,birkenes:e,bjarkoy:e,"xn--bjarky-fya":e,bjarkøy:e,bjerkreim:e,bjugn:e,bodo:e,"xn--bod-2na":e,bodø:e,bokn:e,bomlo:e,"xn--bmlo-gra":e,bømlo:e,bremanger:e,bronnoy:e,"xn--brnny-wuac":e,brønnøy:e,budejju:e,buskerud:p,bygland:e,bykle:e,cahcesuolo:e,"xn--hcesuolo-7ya35b":e,čáhcesuolo:e,davvenjarga:e,"xn--davvenjrga-y4a":e,davvenjárga:e,davvesiida:e,deatnu:e,dielddanuorri:e,divtasvuodna:e,divttasvuotna:e,donna:e,"xn--dnna-gra":e,dønna:e,dovre:e,
drammen:e,drangedal:e,dyroy:e,"xn--dyry-ira":e,dyrøy:e,eid:e,eidfjord:e,eidsberg:e,eidskog:e,eidsvoll:e,eigersund:e,elverum:e,enebakk:e,engerdal:e,etne:e,etnedal:e,evenassi:e,"xn--eveni-0qa01ga":e,evenášši:e,evenes:e,"evje-og-hornnes":e,farsund:e,fauske:e,fedje:e,fet:e,finnoy:e,"xn--finny-yua":e,finnøy:e,fitjar:e,fjaler:e,fjell:e,fla:e,"xn--fl-zia":e,flå:e,flakstad:e,flatanger:e,flekkefjord:e,flesberg:e,flora:e,folldal:e,forde:e,"xn--frde-gra":e,førde:e,forsand:e,fosnes:e,"xn--frna-woa":e,fræna:e,frana:e,frei:e,frogn:e,froland:e,frosta:e,froya:e,"xn--frya-hra":e,frøya:e,fuoisku:e,fuossko:e,fusa:e,fyresdal:e,gaivuotna:e,"xn--givuotna-8ya":e,gáivuotna:e,galsa:e,"xn--gls-elac":e,gálsá:e,gamvik:e,gangaviika:e,"xn--ggaviika-8ya47h":e,gáŋgaviika:e,gaular:e,gausdal:e,giehtavuoatna:e,gildeskal:e,"xn--gildeskl-g0a":e,gildeskål:e,giske:e,gjemnes:e,gjerdrum:e,gjerstad:e,gjesdal:e,gjovik:e,"xn--gjvik-wua":e,gjøvik:e,gloppen:e,gol:e,gran:e,grane:e,granvin:e,gratangen:e,grimstad:e,grong:e,
grue:e,gulen:e,guovdageaidnu:e,ha:e,"xn--h-2fa":e,hå:e,habmer:e,"xn--hbmer-xqa":e,hábmer:e,hadsel:e,"xn--hgebostad-g3a":e,hægebostad:e,hagebostad:e,halden:e,halsa:e,hamar:e,hamaroy:e,hammarfeasta:e,"xn--hmmrfeasta-s4ac":e,hámmárfeasta:e,hammerfest:e,hapmir:e,"xn--hpmir-xqa":e,hápmir:e,haram:e,hareid:e,harstad:e,hasvik:e,hattfjelldal:e,haugesund:e,hedmark:[0,{os:e,valer:e,"xn--vler-qoa":e,våler:e}],hemne:e,hemnes:e,hemsedal:e,hitra:e,hjartdal:e,hjelmeland:e,hobol:e,"xn--hobl-ira":e,hobøl:e,hof:e,hol:e,hole:e,holmestrand:e,holtalen:e,"xn--holtlen-hxa":e,holtålen:e,hordaland:[0,{os:e}],hornindal:e,horten:e,hoyanger:e,"xn--hyanger-q1a":e,høyanger:e,hoylandet:e,"xn--hylandet-54a":e,høylandet:e,hurdal:e,hurum:e,hvaler:e,hyllestad:e,ibestad:e,inderoy:e,"xn--indery-fya":e,inderøy:e,iveland:e,ivgu:e,jevnaker:e,jolster:e,"xn--jlster-bya":e,jølster:e,jondal:e,kafjord:e,"xn--kfjord-iua":e,kåfjord:e,karasjohka:e,"xn--krjohka-hwab49j":e,kárášjohka:e,karasjok:e,karlsoy:e,karmoy:e,"xn\
--karmy-yua":e,karmøy:e,kautokeino:e,klabu:e,"xn--klbu-woa":e,klæbu:e,klepp:e,kongsberg:e,kongsvinger:e,kraanghke:e,"xn--kranghke-b0a":e,kråanghke:e,kragero:e,"xn--krager-gya":e,kragerø:e,kristiansand:e,kristiansund:e,krodsherad:e,"xn--krdsherad-m8a":e,krødsherad:e,"xn--kvfjord-nxa":e,kvæfjord:e,"xn--kvnangen-k0a":e,kvænangen:e,kvafjord:e,kvalsund:e,kvam:e,kvanangen:e,kvinesdal:e,kvinnherad:e,kviteseid:e,kvitsoy:e,"xn--kvitsy-fya":e,kvitsøy:e,laakesvuemie:e,"xn--lrdal-sra":e,lærdal:e,lahppi:e,"xn--lhppi-xqa":e,láhppi:e,lardal:e,larvik:e,lavagis:e,lavangen:e,leangaviika:e,"xn--leagaviika-52b":e,leaŋgaviika:e,lebesby:e,leikanger:e,leirfjord:e,leka:e,leksvik:e,lenvik:e,lerdal:e,lesja:e,levanger:e,lier:e,lierne:e,lillehammer:e,lillesand:e,lindas:e,"xn--linds-pra":e,lindås:e,lindesnes:e,loabat:e,"xn--loabt-0qa":e,loabát:e,lodingen:e,"xn--ldingen-q1a":e,lødingen:e,lom:e,loppa:e,lorenskog:e,"xn--lrenskog-54a":e,lørenskog:e,loten:e,"xn--lten-gra":e,løten:e,lund:e,lunner:e,luroy:e,
"xn--lury-ira":e,lurøy:e,luster:e,lyngdal:e,lyngen:e,malatvuopmi:e,"xn--mlatvuopmi-s4a":e,málatvuopmi:e,malselv:e,"xn--mlselv-iua":e,målselv:e,malvik:e,mandal:e,marker:e,marnardal:e,masfjorden:e,masoy:e,"xn--msy-ula0h":e,måsøy:e,"matta-varjjat":e,"xn--mtta-vrjjat-k7af":e,"mátta-várjjat":e,meland:e,meldal:e,melhus:e,meloy:e,"xn--mely-ira":e,meløy:e,meraker:e,"xn--merker-kua":e,meråker:e,midsund:e,"midtre-gauldal":e,moareke:e,"xn--moreke-jua":e,moåreke:e,modalen:e,modum:e,molde:e,"more-og-romsdal":[0,{heroy:e,sande:e}],"xn--mre-og-romsdal-qqb":[0,{"xn--hery-ira":e,sande:e}],"møre-og-romsdal":[0,{herøy:e,sande:e}],moskenes:e,moss:e,mosvik:e,muosat:e,"xn--muost-0qa":e,muosát:e,naamesjevuemie:e,"xn--nmesjevuemie-tcba":e,nååmesjevuemie:e,"xn--nry-yla5g":e,nærøy:e,namdalseid:e,namsos:e,namsskogan:e,nannestad:e,naroy:e,narviika:e,narvik:e,naustdal:e,navuotna:e,"xn--nvuotna-hwa":e,návuotna:e,"nedre-eiker":e,nesna:e,nesodden:e,nesseby:e,nesset:e,nissedal:e,nittedal:e,"nord-aurd\
al":e,"nord-fron":e,"nord-odal":e,norddal:e,nordkapp:e,nordland:[0,{bo:e,"xn--b-5ga":e,bø:e,heroy:e,"xn--hery-ira":e,herøy:e}],"nordre-land":e,nordreisa:e,"nore-og-uvdal":e,notodden:e,notteroy:e,"xn--nttery-byae":e,nøtterøy:e,odda:e,oksnes:e,"xn--ksnes-uua":e,øksnes:e,omasvuotna:e,oppdal:e,oppegard:e,"xn--oppegrd-ixa":e,oppegård:e,orkdal:e,orland:e,"xn--rland-uua":e,ørland:e,orskog:e,"xn--rskog-uua":e,ørskog:e,orsta:e,"xn--rsta-fra":e,ørsta:e,osen:e,osteroy:e,"xn--ostery-fya":e,osterøy:e,ostfold:[0,{valer:e}],"xn--stfold-9xa":[0,{"xn--vler-qoa":e}],østfold:[0,{våler:e}],"ostre-toten":e,"xn--stre-toten-zcb":e,"østre-toten":e,overhalla:e,"ovre-eiker":e,"xn--vre-eiker-k8a":e,"øvre-eiker":e,oyer:e,"xn--yer-zna":e,øyer:e,oygarden:e,"xn--ygarden-p1a":e,øygarden:e,"oystre-slidre":e,"xn--ystre-slidre-ujb":e,"øystre-slidre":e,porsanger:e,porsangu:e,"xn--porsgu-sta26f":e,porsáŋgu:e,porsgrunn:e,rade:e,"xn--rde-ula":e,råde:e,radoy:e,"xn--rady-ira":e,radøy:e,"xn--rlingen-mxa":e,
rælingen:e,rahkkeravju:e,"xn--rhkkervju-01af":e,ráhkkerávju:e,raisa:e,"xn--risa-5na":e,ráisa:e,rakkestad:e,ralingen:e,rana:e,randaberg:e,rauma:e,rendalen:e,rennebu:e,rennesoy:e,"xn--rennesy-v1a":e,rennesøy:e,rindal:e,ringebu:e,ringerike:e,ringsaker:e,risor:e,"xn--risr-ira":e,risør:e,rissa:e,roan:e,rodoy:e,"xn--rdy-0nab":e,rødøy:e,rollag:e,romsa:e,romskog:e,"xn--rmskog-bya":e,rømskog:e,roros:e,"xn--rros-gra":e,røros:e,rost:e,"xn--rst-0na":e,røst:e,royken:e,"xn--ryken-vua":e,røyken:e,royrvik:e,"xn--ryrvik-bya":e,røyrvik:e,ruovat:e,rygge:e,salangen:e,salat:e,"xn--slat-5na":e,sálat:e,"xn--slt-elab":e,sálát:e,saltdal:e,samnanger:e,sandefjord:e,sandnes:e,sandoy:e,"xn--sandy-yua":e,sandøy:e,sarpsborg:e,sauda:e,sauherad:e,sel:e,selbu:e,selje:e,seljord:e,siellak:e,sigdal:e,siljan:e,sirdal:e,skanit:e,"xn--sknit-yqa":e,skánit:e,skanland:e,"xn--sknland-fxa":e,skånland:e,skaun:e,skedsmo:e,ski:e,skien:e,skierva:e,"xn--skierv-uta":e,skiervá:e,skiptvet:e,skjak:e,"xn--skjk-soa":e,skjåk:e,
skjervoy:e,"xn--skjervy-v1a":e,skjervøy:e,skodje:e,smola:e,"xn--smla-hra":e,smøla:e,snaase:e,"xn--snase-nra":e,snåase:e,snasa:e,"xn--snsa-roa":e,snåsa:e,snillfjord:e,snoasa:e,sogndal:e,sogne:e,"xn--sgne-gra":e,søgne:e,sokndal:e,sola:e,solund:e,somna:e,"xn--smna-gra":e,sømna:e,"sondre-land":e,"xn--sndre-land-0cb":e,"søndre-land":e,songdalen:e,"sor-aurdal":e,"xn--sr-aurdal-l8a":e,"sør-aurdal":e,"sor-fron":e,"xn--sr-fron-q1a":e,"sør-fron":e,"sor-odal":e,"xn--sr-odal-q1a":e,"sør-odal":e,"sor-varanger":e,"xn--sr-varanger-ggb":e,"sør-varanger":e,sorfold:e,"xn--srfold-bya":e,sørfold:e,sorreisa:e,"xn--srreisa-q1a":e,sørreisa:e,sortland:e,sorum:e,"xn--srum-gra":e,sørum:e,spydeberg:e,stange:e,stavanger:e,steigen:e,steinkjer:e,stjordal:e,"xn--stjrdal-s1a":e,stjørdal:e,stokke:e,"stor-elvdal":e,stord:e,stordal:e,storfjord:e,strand:e,stranda:e,stryn:e,sula:e,suldal:e,sund:e,sunndal:e,surnadal:e,sveio:e,svelvik:e,sykkylven:e,tana:e,telemark:[0,{bo:e,"xn--b-5ga":e,bø:e}],time:e,tingvoll:e,
tinn:e,tjeldsund:e,tjome:e,"xn--tjme-hra":e,tjøme:e,tokke:e,tolga:e,tonsberg:e,"xn--tnsberg-q1a":e,tønsberg:e,torsken:e,"xn--trna-woa":e,træna:e,trana:e,tranoy:e,"xn--trany-yua":e,tranøy:e,troandin:e,trogstad:e,"xn--trgstad-r1a":e,trøgstad:e,tromsa:e,tromso:e,"xn--troms-zua":e,tromsø:e,trondheim:e,trysil:e,tvedestrand:e,tydal:e,tynset:e,tysfjord:e,tysnes:e,"xn--tysvr-vra":e,tysvær:e,tysvar:e,ullensaker:e,ullensvang:e,ulvik:e,unjarga:e,"xn--unjrga-rta":e,unjárga:e,utsira:e,vaapste:e,vadso:e,"xn--vads-jra":e,vadsø:e,"xn--vry-yla5g":e,værøy:e,vaga:e,"xn--vg-yiab":e,vågå:e,vagan:e,"xn--vgan-qoa":e,vågan:e,vagsoy:e,"xn--vgsy-qoa0j":e,vågsøy:e,vaksdal:e,valle:e,vang:e,vanylven:e,vardo:e,"xn--vard-jra":e,vardø:e,varggat:e,"xn--vrggt-xqad":e,várggát:e,varoy:e,vefsn:e,vega:e,vegarshei:e,"xn--vegrshei-c0a":e,vegårshei:e,vennesla:e,verdal:e,verran:e,vestby:e,vestfold:[0,{sande:e}],vestnes:e,"vestre-slidre":e,"vestre-toten":e,vestvagoy:e,"xn--vestvgy-ixa6o":e,vestvågøy:e,vevelstad:e,
vik:e,vikna:e,vindafjord:e,voagat:e,volda:e,voss:e}],np:a,nr:l,nu:e,nz:[1,{ac:e,co:e,cri:e,geek:e,gen:e,govt:e,health:e,iwi:e,kiwi:e,maori:e,"xn--mori-qsa":e,māori:e,mil:e,net:e,org:e,parliament:e,school:e}],om:[1,{co:e,com:e,edu:e,gov:e,med:e,museum:e,net:e,org:e,pro:e}],onion:e,org:e,pa:[1,{abo:e,ac:e,com:e,edu:e,gob:e,ing:e,med:e,net:e,nom:e,org:e,sld:e}],pe:[1,{com:e,edu:e,gob:e,mil:e,net:e,nom:e,org:e}],pf:[1,{com:e,edu:e,org:e}],pg:a,ph:[1,{com:e,edu:e,gov:e,i:e,mil:e,net:e,ngo:e,org:e}],pk:[1,{ac:e,biz:e,com:e,edu:e,fam:e,gkp:e,gob:e,gog:e,gok:e,gop:e,gos:e,gov:e,net:e,org:e,web:e}],pl:[1,{com:e,net:e,org:e,agro:e,aid:e,atm:e,auto:e,biz:e,edu:e,gmina:e,gsm:e,info:e,mail:e,media:e,miasta:e,mil:e,nieruchomosci:e,nom:e,pc:e,powiat:e,priv:e,realestate:e,rel:e,sex:e,shop:e,sklep:e,sos:e,szkola:e,targi:e,tm:e,tourism:e,travel:e,turystyka:e,gov:[1,{ap:e,griw:e,ic:e,is:e,kmpsp:e,konsulat:e,kppsp:e,kwp:e,kwpsp:e,mup:e,mw:e,oia:e,oirm:e,oke:e,oow:e,oschr:e,oum:e,pa:e,pinb:e,piw:e,po:e,pr:e,
psp:e,psse:e,pup:e,rzgw:e,sa:e,sdn:e,sko:e,so:e,sr:e,starostwo:e,ug:e,ugim:e,um:e,umig:e,upow:e,uppo:e,us:e,uw:e,uzs:e,wif:e,wiih:e,winb:e,wios:e,witd:e,wiw:e,wkz:e,wsa:e,wskr:e,wsse:e,wuoz:e,wzmiuw:e,zp:e,zpisdn:e}],augustow:e,"babia-gora":e,bedzin:e,beskidy:e,bialowieza:e,bialystok:e,bielawa:e,bieszczady:e,boleslawiec:e,bydgoszcz:e,bytom:e,cieszyn:e,czeladz:e,czest:e,dlugoleka:e,elblag:e,elk:e,glogow:e,gniezno:e,gorlice:e,grajewo:e,ilawa:e,jaworzno:e,"jelenia-gora":e,jgora:e,kalisz:e,karpacz:e,kartuzy:e,kaszuby:e,katowice:e,"kazimierz-dolny":e,kepno:e,ketrzyn:e,klodzko:e,kobierzyce:e,kolobrzeg:e,konin:e,konskowola:e,kutno:e,lapy:e,lebork:e,legnica:e,lezajsk:e,limanowa:e,lomza:e,lowicz:e,lubin:e,lukow:e,malbork:e,malopolska:e,mazowsze:e,mazury:e,mielec:e,mielno:e,mragowo:e,naklo:e,nowaruda:e,nysa:e,olawa:e,olecko:e,olkusz:e,olsztyn:e,opoczno:e,opole:e,ostroda:e,ostroleka:e,ostrowiec:e,ostrowwlkp:e,pila:e,pisz:e,podhale:e,podlasie:e,polkowice:e,pomorskie:e,pomorze:e,prochowice:e,pruszkow:e,
przeworsk:e,pulawy:e,radom:e,"rawa-maz":e,rybnik:e,rzeszow:e,sanok:e,sejny:e,skoczow:e,slask:e,slupsk:e,sosnowiec:e,"stalowa-wola":e,starachowice:e,stargard:e,suwalki:e,swidnica:e,swiebodzin:e,swinoujscie:e,szczecin:e,szczytno:e,tarnobrzeg:e,tgory:e,turek:e,tychy:e,ustka:e,walbrzych:e,warmia:e,warszawa:e,waw:e,wegrow:e,wielun:e,wlocl:e,wloclawek:e,wodzislaw:e,wolomin:e,wroclaw:e,zachpomor:e,zagan:e,zarow:e,zgora:e,zgorzelec:e}],pm:e,pn:[1,{co:e,edu:e,gov:e,net:e,org:e}],post:e,pr:[1,{biz:e,com:e,edu:e,gov:e,info:e,isla:e,name:e,net:e,org:e,pro:e,ac:e,est:e,prof:e}],pro:[1,{aaa:e,aca:e,acct:e,avocat:e,bar:e,cpa:e,eng:e,jur:e,law:e,med:e,recht:e}],ps:[1,{com:e,edu:e,gov:e,net:e,org:e,plo:e,sec:e}],pt:[1,{com:e,edu:e,gov:e,int:e,net:e,nome:e,org:e,publ:e}],pw:n,py:[1,{com:e,coop:e,edu:e,gov:e,mil:e,net:e,org:e}],qa:[1,{com:e,edu:e,gov:e,mil:e,name:e,net:e,org:e,sch:e}],re:[1,{asso:e,com:e}],ro:[1,{arts:e,com:e,firm:e,info:e,nom:e,nt:e,org:e,rec:e,store:e,tm:e,www:e}],rs:[1,{ac:e,co:e,edu:e,
gov:e,in:e,org:e}],ru:e,rw:[1,{ac:e,co:e,coop:e,gov:e,mil:e,net:e,org:e}],sa:[1,{com:e,edu:e,gov:e,med:e,net:e,org:e,pub:e,sch:e}],sb:r,sc:r,sd:[1,{com:e,edu:e,gov:e,info:e,med:e,net:e,org:e,tv:e}],se:[1,{a:e,ac:e,b:e,bd:e,brand:e,c:e,d:e,e,f:e,fh:e,fhsk:e,fhv:e,g:e,h:e,i:e,k:e,komforb:e,kommunalforbund:e,komvux:e,l:e,lanbib:e,m:e,n:e,naturbruksgymn:e,o:e,org:e,p:e,parti:e,pp:e,press:e,r:e,s:e,t:e,tm:e,u:e,w:e,x:e,y:e,z:e}],sg:r,sh:[1,{com:e,gov:e,mil:e,net:e,org:e}],si:e,sj:e,sk:e,sl:r,sm:e,sn:[1,{art:e,com:e,edu:e,gouv:e,org:e,perso:e,univ:e}],so:[1,{com:e,edu:e,gov:e,me:e,net:e,org:e}],sr:e,ss:[1,{biz:e,co:e,com:e,edu:e,gov:e,me:e,net:e,org:e,sch:e}],st:[1,{co:e,com:e,consulado:e,edu:e,embaixada:e,mil:e,net:e,org:e,principe:e,saotome:e,store:e}],su:e,sv:[1,{com:e,edu:e,gob:e,org:e,red:e}],sx:n,sy:t,sz:[1,{ac:e,co:e,org:e}],tc:e,td:e,tel:e,tf:e,tg:e,th:[1,{ac:e,co:e,go:e,in:e,mi:e,net:e,or:e}],tj:[1,{ac:e,biz:e,co:e,com:e,edu:e,go:e,gov:e,int:e,mil:e,name:e,net:e,nic:e,org:e,test:e,web:e}],
tk:e,tl:n,tm:u,tn:[1,{com:e,ens:e,fin:e,gov:e,ind:e,info:e,intl:e,mincom:e,nat:e,net:e,org:e,perso:e,tourism:e}],to:t,tr:[1,{av:e,bbs:e,bel:e,biz:e,com:e,dr:e,edu:e,gen:e,gov:e,info:e,k12:e,kep:e,mil:e,name:e,net:e,org:e,pol:e,tel:e,tsk:e,tv:e,web:e,nc:n}],tt:[1,{biz:e,co:e,com:e,edu:e,gov:e,info:e,mil:e,name:e,net:e,org:e,pro:e}],tv:e,tw:[1,{club:e,com:e,ebiz:e,edu:e,game:e,gov:e,idv:e,mil:e,net:e,org:e}],tz:[1,{ac:e,co:e,go:e,hotel:e,info:e,me:e,mil:e,mobi:e,ne:e,or:e,sc:e,tv:e}],ua:[1,{com:e,edu:e,gov:e,in:e,net:e,org:e,cherkassy:e,cherkasy:e,chernigov:e,chernihiv:e,chernivtsi:e,chernovtsy:e,ck:e,cn:e,cr:e,crimea:e,cv:e,dn:e,dnepropetrovsk:e,dnipropetrovsk:e,donetsk:e,dp:e,if:e,"ivano-frankivsk":e,kh:e,kharkiv:e,kharkov:e,kherson:e,khmelnitskiy:e,khmelnytskyi:e,kiev:e,kirovograd:e,km:e,kr:e,kropyvnytskyi:e,krym:e,ks:e,kv:e,kyiv:e,lg:e,lt:e,lugansk:e,luhansk:e,lutsk:e,lv:e,lviv:e,mk:e,mykolaiv:e,nikolaev:e,od:e,odesa:e,odessa:e,pl:e,poltava:e,rivne:e,rovno:e,rv:e,sb:e,sebastopol:e,sevastopol:e,
sm:e,sumy:e,te:e,ternopil:e,uz:e,uzhgorod:e,uzhhorod:e,vinnica:e,vinnytsia:e,vn:e,volyn:e,yalta:e,zakarpattia:e,zaporizhzhe:e,zaporizhzhia:e,zhitomir:e,zhytomyr:e,zp:e,zt:e}],ug:[1,{ac:e,co:e,com:e,edu:e,go:e,gov:e,mil:e,ne:e,or:e,org:e,sc:e,us:e}],uk:[1,{ac:e,co:e,gov:e,ltd:e,me:e,net:e,nhs:e,org:e,plc:e,police:e,sch:a}],us:[1,{dni:e,isa:e,nsn:e,ak:f,al:f,ar:f,as:f,az:f,ca:f,co:f,ct:f,dc:f,de:h,fl:f,ga:f,gu:f,hi:y,ia:f,id:f,il:f,in:f,ks:f,ky:f,la:f,ma:[1,{k12:[1,{chtr:e,paroch:e,pvt:e}],cc:e,lib:e}],md:f,me:f,mi:[1,{k12:e,cc:e,lib:e,"ann-arbor":e,cog:e,dst:e,eaton:e,gen:e,mus:e,tec:e,washtenaw:e}],mn:f,mo:f,ms:f,mt:f,nc:f,nd:y,ne:f,nh:f,nj:f,nm:f,nv:f,ny:f,oh:f,ok:f,or:f,pa:f,pr:f,ri:y,sc:f,sd:y,tn:f,tx:f,ut:f,va:f,vi:f,vt:f,wa:f,wi:f,wv:h,wy:f}],uy:[1,{com:e,edu:e,gub:e,mil:e,net:e,org:e}],uz:[1,{co:e,com:e,net:e,org:e}],va:e,vc:t,ve:[1,{arts:e,bib:e,co:e,com:e,e12:e,edu:e,emprende:e,firm:e,gob:e,gov:e,info:e,int:e,mil:e,net:e,nom:e,org:e,rar:e,rec:e,store:e,tec:e,web:e}],vg:[1,{edu:e}],
vi:[1,{co:e,com:e,k12:e,net:e,org:e}],vn:[1,{ac:e,ai:e,biz:e,com:e,edu:e,gov:e,health:e,id:e,info:e,int:e,io:e,name:e,net:e,org:e,pro:e,angiang:e,bacgiang:e,backan:e,baclieu:e,bacninh:e,"baria-vungtau":e,bentre:e,binhdinh:e,binhduong:e,binhphuoc:e,binhthuan:e,camau:e,cantho:e,caobang:e,daklak:e,daknong:e,danang:e,dienbien:e,dongnai:e,dongthap:e,gialai:e,hagiang:e,haiduong:e,haiphong:e,hanam:e,hanoi:e,hatinh:e,haugiang:e,hoabinh:e,hungyen:e,khanhhoa:e,kiengiang:e,kontum:e,laichau:e,lamdong:e,langson:e,laocai:e,longan:e,namdinh:e,nghean:e,ninhbinh:e,ninhthuan:e,phutho:e,phuyen:e,quangbinh:e,quangnam:e,quangngai:e,quangninh:e,quangtri:e,soctrang:e,sonla:e,tayninh:e,thaibinh:e,thainguyen:e,thanhhoa:e,thanhphohochiminh:e,thuathienhue:e,tiengiang:e,travinh:e,tuyenquang:e,vinhlong:e,vinhphuc:e,yenbai:e}],vu:s,wf:e,ws:r,yt:e,"xn--mgbaam7a8h":e,امارات:e,"xn--y9a3aq":e,հայ:e,"xn--54b7fta0cc":e,বাংলা:e,"xn--90ae":e,бг:e,"xn--mgbcpq6gpa1a":e,البحرين:e,"xn--90ais":e,бел:e,
"xn--fiqs8s":e,中国:e,"xn--fiqz9s":e,中國:e,"xn--lgbbat1ad8j":e,الجزائر:e,"xn--wgbh1c":e,مصر:e,"xn--e1a4c":e,ею:e,"xn--qxa6a":e,ευ:e,"xn--mgbah1a3hjkrd":e,موريتانيا:e,"xn--node":e,გე:e,"xn--qxam":e,ελ:e,"xn--j6w193g":[1,{"xn--gmqw5a":e,"xn--55qx5d":e,"xn--mxtq1m":e,"xn--wcvs22d":e,"xn--uc0atv":e,"xn--od0alg":e}],香港:[1,{個人:e,公司:e,政府:e,教育:e,組織:e,網絡:e}],"xn--2scrj9c":e,ಭಾರತ:e,"xn--3hcrj9c":e,ଭାରତ:e,"xn--45br5cyl":e,ভাৰত:e,"xn--h2breg3eve":e,भारतम्:e,"xn--h2brj9c8c":e,भारोत:e,"xn--mgbgu82a":e,ڀارت:e,"xn--rvc1e0am3e":e,ഭാരതം:e,"xn--h2brj9c":e,भारत:e,"xn--mgbbh1a":e,بارت:e,"xn--mgbbh1a71e":e,بھارت:e,"xn--fpcrj9c3d":e,భారత్:e,"xn--gecrj9c":e,ભારત:e,"xn--s9brj9c":e,ਭਾਰਤ:e,"xn--45brj9c":e,ভারত:e,"xn--xkc2dl3a5ee0h":e,இந்தியா:e,"xn--mgba3a4f16a":e,ایران:e,"xn--mgba3a4fra":e,ايران:e,"xn--mgbtx2b":e,عراق:e,
"xn--mgbayh7gpa":e,الاردن:e,"xn--3e0b707e":e,한국:e,"xn--80ao21a":e,қаз:e,"xn--q7ce6a":e,ລາວ:e,"xn--fzc2c9e2c":e,ලංකා:e,"xn--xkc2al3hye2a":e,இலங்கை:e,"xn--mgbc0a9azcg":e,المغرب:e,"xn--d1alf":e,мкд:e,"xn--l1acc":e,мон:e,"xn--mix891f":e,澳門:e,"xn--mix082f":e,澳门:e,"xn--mgbx4cd0ab":e,مليسيا:e,"xn--mgb9awbf":e,عمان:e,"xn--mgbai9azgqp6j":e,پاکستان:e,"xn--mgbai9a5eva00b":e,پاكستان:e,"xn--ygbi2ammx":e,فلسطين:e,"xn--90a3ac":[1,{"xn--80au":e,"xn--90azh":e,"xn--d1at":e,"xn--c1avg":e,"xn--o1ac":e,"xn--o1ach":e}],срб:[1,{ак:e,обр:e,од:e,орг:e,пр:e,упр:e}],"xn--p1ai":e,рф:e,"xn--wgbl6a":e,قطر:e,"xn--mgberp4a5d4ar":e,السعودية:e,"xn--mgberp4a5d4a87g":e,السعودیة:e,"xn--mgbqly7c0a67fbc":e,السعودیۃ:e,"xn--mgbqly7cvafr":e,السعوديه:e,"xn--mgbpl2fh":e,سودان:e,"xn--yfro4i67o":e,新加坡:e,"xn--clchc0ea0b2g2a9gcd":e,சிங்கப்பூர்:e,"xn--ogbpf8fl":e,
سورية:e,"xn--mgbtf8fl":e,سوريا:e,"xn--o3cw4h":[1,{"xn--o3cyx2a":e,"xn--12co0c3b4eva":e,"xn--m3ch0j3a":e,"xn--h3cuzk1di":e,"xn--12c1fe0br":e,"xn--12cfi8ixb8l":e}],ไทย:[1,{ทหาร:e,ธุรกิจ:e,เน็ต:e,รัฐบาล:e,ศึกษา:e,องค์กร:e}],"xn--pgbs0dh":e,تونس:e,"xn--kpry57d":e,台灣:e,"xn--kprw13d":e,台湾:e,"xn--nnx388a":e,臺灣:e,"xn--j1amh":e,укр:e,"xn--mgb2ddes":e,اليمن:e,xxx:e,ye:t,za:[0,{ac:e,agric:e,alt:e,co:e,edu:e,gov:e,grondar:e,law:e,mil:e,net:e,ngo:e,nic:e,nis:e,nom:e,org:e,school:e,tm:e,web:e}],zm:[1,{ac:e,biz:e,co:e,com:e,edu:e,gov:e,info:e,mil:e,net:e,org:e,sch:e}],zw:[1,{ac:e,co:e,gov:e,mil:e,org:e}],aaa:e,aarp:e,abb:e,abbott:e,abbvie:e,abc:e,able:e,abogado:e,abudhabi:e,academy:e,accenture:e,accountant:e,accountants:e,aco:e,actor:e,ads:e,adult:e,aeg:e,aetna:e,afl:e,africa:e,agakhan:e,agency:e,aig:e,airbus:e,airforce:e,airtel:e,akdn:e,alibaba:e,alipay:e,allfinanz:e,allstate:e,ally:e,alsace:e,alstom:e,
amazon:e,americanexpress:e,americanfamily:e,amex:e,amfam:e,amica:e,amsterdam:e,analytics:e,android:e,anquan:e,anz:e,aol:e,apartments:e,app:e,apple:e,aquarelle:e,arab:e,aramco:e,archi:e,army:e,art:e,arte:e,asda:e,associates:e,athleta:e,attorney:e,auction:e,audi:e,audible:e,audio:e,auspost:e,author:e,auto:e,autos:e,aws:e,axa:e,azure:e,baby:e,baidu:e,banamex:e,band:e,bank:e,bar:e,barcelona:e,barclaycard:e,barclays:e,barefoot:e,bargains:e,baseball:e,basketball:e,bauhaus:e,bayern:e,bbc:e,bbt:e,bbva:e,bcg:e,bcn:e,beats:e,beauty:e,beer:e,berlin:e,best:e,bestbuy:e,bet:e,bharti:e,bible:e,bid:e,bike:e,bing:e,bingo:e,bio:e,black:e,blackfriday:e,blockbuster:e,blog:e,bloomberg:e,blue:e,bms:e,bmw:e,bnpparibas:e,boats:e,boehringer:e,bofa:e,bom:e,bond:e,boo:e,book:e,booking:e,bosch:e,bostik:e,boston:e,bot:e,boutique:e,box:e,bradesco:e,bridgestone:e,broadway:e,broker:e,brother:e,brussels:e,build:e,builders:e,business:e,buy:e,buzz:e,bzh:e,cab:e,cafe:e,cal:e,call:e,calvinklein:e,cam:e,camera:e,camp:e,canon:e,
capetown:e,capital:e,capitalone:e,car:e,caravan:e,cards:e,care:e,career:e,careers:e,cars:e,casa:e,case:e,cash:e,casino:e,catering:e,catholic:e,cba:e,cbn:e,cbre:e,center:e,ceo:e,cern:e,cfa:e,cfd:e,chanel:e,channel:e,charity:e,chase:e,chat:e,cheap:e,chintai:e,christmas:e,chrome:e,church:e,cipriani:e,circle:e,cisco:e,citadel:e,citi:e,citic:e,city:e,claims:e,cleaning:e,click:e,clinic:e,clinique:e,clothing:e,cloud:e,club:e,clubmed:e,coach:e,codes:e,coffee:e,college:e,cologne:e,commbank:e,community:e,company:e,compare:e,computer:e,comsec:e,condos:e,construction:e,consulting:e,contact:e,contractors:e,cooking:e,cool:e,corsica:e,country:e,coupon:e,coupons:e,courses:e,cpa:e,credit:e,creditcard:e,creditunion:e,cricket:e,crown:e,crs:e,cruise:e,cruises:e,cuisinella:e,cymru:e,cyou:e,dad:e,dance:e,data:e,date:e,dating:e,datsun:e,day:e,dclk:e,dds:e,deal:e,dealer:e,deals:e,degree:e,delivery:e,dell:e,deloitte:e,delta:e,democrat:e,dental:e,dentist:e,desi:e,design:e,dev:e,dhl:e,diamonds:e,diet:e,digital:e,
direct:e,directory:e,discount:e,discover:e,dish:e,diy:e,dnp:e,docs:e,doctor:e,dog:e,domains:e,dot:e,download:e,drive:e,dtv:e,dubai:e,dunlop:e,dupont:e,durban:e,dvag:e,dvr:e,earth:e,eat:e,eco:e,edeka:e,education:e,email:e,emerck:e,energy:e,engineer:e,engineering:e,enterprises:e,epson:e,equipment:e,ericsson:e,erni:e,esq:e,estate:e,eurovision:e,eus:e,events:e,exchange:e,expert:e,exposed:e,express:e,extraspace:e,fage:e,fail:e,fairwinds:e,faith:e,family:e,fan:e,fans:e,farm:e,farmers:e,fashion:e,fast:e,fedex:e,feedback:e,ferrari:e,ferrero:e,fidelity:e,fido:e,film:e,final:e,finance:e,financial:e,fire:e,firestone:e,firmdale:e,fish:e,fishing:e,fit:e,fitness:e,flickr:e,flights:e,flir:e,florist:e,flowers:e,fly:e,foo:e,food:e,football:e,ford:e,forex:e,forsale:e,forum:e,foundation:e,fox:e,free:e,fresenius:e,frl:e,frogans:e,frontier:e,ftr:e,fujitsu:e,fun:e,fund:e,furniture:e,futbol:e,fyi:e,gal:e,gallery:e,gallo:e,gallup:e,game:e,games:e,gap:e,garden:e,gay:e,gbiz:e,gdn:e,gea:e,gent:e,genting:e,george:e,
ggee:e,gift:e,gifts:e,gives:e,giving:e,glass:e,gle:e,global:e,globo:e,gmail:e,gmbh:e,gmo:e,gmx:e,godaddy:e,gold:e,goldpoint:e,golf:e,goo:e,goodyear:e,goog:e,google:e,gop:e,got:e,grainger:e,graphics:e,gratis:e,green:e,gripe:e,grocery:e,group:e,gucci:e,guge:e,guide:e,guitars:e,guru:e,hair:e,hamburg:e,hangout:e,haus:e,hbo:e,hdfc:e,hdfcbank:e,health:e,healthcare:e,help:e,helsinki:e,here:e,hermes:e,hiphop:e,hisamitsu:e,hitachi:e,hiv:e,hkt:e,hockey:e,holdings:e,holiday:e,homedepot:e,homegoods:e,homes:e,homesense:e,honda:e,horse:e,hospital:e,host:e,hosting:e,hot:e,hotel:e,hotels:e,hotmail:e,house:e,how:e,hsbc:e,hughes:e,hyatt:e,hyundai:e,ibm:e,icbc:e,ice:e,icu:e,ieee:e,ifm:e,ikano:e,imamat:e,imdb:e,immo:e,immobilien:e,inc:e,industries:e,infiniti:e,ing:e,ink:e,institute:e,insurance:e,insure:e,international:e,intuit:e,investments:e,ipiranga:e,irish:e,ismaili:e,ist:e,istanbul:e,itau:e,itv:e,jaguar:e,java:e,jcb:e,jeep:e,jetzt:e,jewelry:e,jio:e,jll:e,jmp:e,jnj:e,joburg:e,jot:e,joy:e,jpmorgan:e,jprs:e,
juegos:e,juniper:e,kaufen:e,kddi:e,kerryhotels:e,kerryproperties:e,kfh:e,kia:e,kids:e,kim:e,kindle:e,kitchen:e,kiwi:e,koeln:e,komatsu:e,kosher:e,kpmg:e,kpn:e,krd:e,kred:e,kuokgroup:e,kyoto:e,lacaixa:e,lamborghini:e,lamer:e,land:e,landrover:e,lanxess:e,lasalle:e,lat:e,latino:e,latrobe:e,law:e,lawyer:e,lds:e,lease:e,leclerc:e,lefrak:e,legal:e,lego:e,lexus:e,lgbt:e,lidl:e,life:e,lifeinsurance:e,lifestyle:e,lighting:e,like:e,lilly:e,limited:e,limo:e,lincoln:e,link:e,live:e,living:e,llc:e,llp:e,loan:e,loans:e,locker:e,locus:e,lol:e,london:e,lotte:e,lotto:e,love:e,lpl:e,lplfinancial:e,ltd:e,ltda:e,lundbeck:e,luxe:e,luxury:e,madrid:e,maif:e,maison:e,makeup:e,man:e,management:e,mango:e,map:e,market:e,marketing:e,markets:e,marriott:e,marshalls:e,mattel:e,mba:e,mckinsey:e,med:e,media:e,meet:e,melbourne:e,meme:e,memorial:e,men:e,menu:e,merck:e,merckmsd:e,miami:e,microsoft:e,mini:e,mint:e,mit:e,mitsubishi:e,mlb:e,mls:e,mma:e,mobile:e,moda:e,moe:e,moi:e,mom:e,monash:e,money:e,monster:e,mormon:e,mortgage:e,
moscow:e,moto:e,motorcycles:e,mov:e,movie:e,msd:e,mtn:e,mtr:e,music:e,nab:e,nagoya:e,navy:e,nba:e,nec:e,netbank:e,netflix:e,network:e,neustar:e,new:e,news:e,next:e,nextdirect:e,nexus:e,nfl:e,ngo:e,nhk:e,nico:e,nike:e,nikon:e,ninja:e,nissan:e,nissay:e,nokia:e,norton:e,now:e,nowruz:e,nowtv:e,nra:e,nrw:e,ntt:e,nyc:e,obi:e,observer:e,office:e,okinawa:e,olayan:e,olayangroup:e,ollo:e,omega:e,one:e,ong:e,onl:e,online:e,ooo:e,open:e,oracle:e,orange:e,organic:e,origins:e,osaka:e,otsuka:e,ott:e,ovh:e,page:e,panasonic:e,paris:e,pars:e,partners:e,parts:e,party:e,pay:e,pccw:e,pet:e,pfizer:e,pharmacy:e,phd:e,philips:e,phone:e,photo:e,photography:e,photos:e,physio:e,pics:e,pictet:e,pictures:e,pid:e,pin:e,ping:e,pink:e,pioneer:e,pizza:e,place:e,play:e,playstation:e,plumbing:e,plus:e,pnc:e,pohl:e,poker:e,politie:e,porn:e,praxi:e,press:e,prime:e,prod:e,productions:e,prof:e,progressive:e,promo:e,properties:e,property:e,protection:e,pru:e,prudential:e,pub:e,pwc:e,qpon:e,quebec:e,quest:e,racing:e,radio:e,read:e,
realestate:e,realtor:e,realty:e,recipes:e,red:e,redstone:e,redumbrella:e,rehab:e,reise:e,reisen:e,reit:e,reliance:e,ren:e,rent:e,rentals:e,repair:e,report:e,republican:e,rest:e,restaurant:e,review:e,reviews:e,rexroth:e,rich:e,richardli:e,ricoh:e,ril:e,rio:e,rip:e,rocks:e,rodeo:e,rogers:e,room:e,rsvp:e,rugby:e,ruhr:e,run:e,rwe:e,ryukyu:e,saarland:e,safe:e,safety:e,sakura:e,sale:e,salon:e,samsclub:e,samsung:e,sandvik:e,sandvikcoromant:e,sanofi:e,sap:e,sarl:e,sas:e,save:e,saxo:e,sbi:e,sbs:e,scb:e,schaeffler:e,schmidt:e,scholarships:e,school:e,schule:e,schwarz:e,science:e,scot:e,search:e,seat:e,secure:e,security:e,seek:e,select:e,sener:e,services:e,seven:e,sew:e,sex:e,sexy:e,sfr:e,shangrila:e,sharp:e,shell:e,shia:e,shiksha:e,shoes:e,shop:e,shopping:e,shouji:e,show:e,silk:e,sina:e,singles:e,site:e,ski:e,skin:e,sky:e,skype:e,sling:e,smart:e,smile:e,sncf:e,soccer:e,social:e,softbank:e,software:e,sohu:e,solar:e,solutions:e,song:e,sony:e,soy:e,spa:e,space:e,sport:e,spot:e,srl:e,stada:e,staples:e,
star:e,statebank:e,statefarm:e,stc:e,stcgroup:e,stockholm:e,storage:e,store:e,stream:e,studio:e,study:e,style:e,sucks:e,supplies:e,supply:e,support:e,surf:e,surgery:e,suzuki:e,swatch:e,swiss:e,sydney:e,systems:e,tab:e,taipei:e,talk:e,taobao:e,target:e,tatamotors:e,tatar:e,tattoo:e,tax:e,taxi:e,tci:e,tdk:e,team:e,tech:e,technology:e,temasek:e,tennis:e,teva:e,thd:e,theater:e,theatre:e,tiaa:e,tickets:e,tienda:e,tips:e,tires:e,tirol:e,tjmaxx:e,tjx:e,tkmaxx:e,tmall:e,today:e,tokyo:e,tools:e,top:e,toray:e,toshiba:e,total:e,tours:e,town:e,toyota:e,toys:e,trade:e,trading:e,training:e,travel:e,travelers:e,travelersinsurance:e,trust:e,trv:e,tube:e,tui:e,tunes:e,tushu:e,tvs:e,ubank:e,ubs:e,unicom:e,university:e,uno:e,uol:e,ups:e,vacations:e,vana:e,vanguard:e,vegas:e,ventures:e,verisign:e,versicherung:e,vet:e,viajes:e,video:e,vig:e,viking:e,villas:e,vin:e,vip:e,virgin:e,visa:e,vision:e,viva:e,vivo:e,vlaanderen:e,vodka:e,volvo:e,vote:e,voting:e,voto:e,voyage:e,wales:e,walmart:e,walter:e,wang:e,wanggou:e,
watch:e,watches:e,weather:e,weatherchannel:e,webcam:e,weber:e,website:e,wed:e,wedding:e,weibo:e,weir:e,whoswho:e,wien:e,wiki:e,williamhill:e,win:e,windows:e,wine:e,winners:e,wme:e,wolterskluwer:e,woodside:e,work:e,works:e,world:e,wow:e,wtc:e,wtf:e,xbox:e,xerox:e,xihuan:e,xin:e,"xn--11b4c3d":e,कॉम:e,"xn--1ck2e1b":e,セール:e,"xn--1qqw23a":e,佛山:e,"xn--30rr7y":e,慈善:e,"xn--3bst00m":e,集团:e,"xn--3ds443g":e,在线:e,"xn--3pxu8k":e,点看:e,"xn--42c2d9a":e,คอม:e,"xn--45q11c":e,八卦:e,"xn--4gbrim":e,موقع:e,"xn--55qw42g":e,公益:e,"xn--55qx5d":e,公司:e,"xn--5su34j936bgsg":e,香格里拉:e,"xn--5tzm5g":e,网站:e,"xn--6frz82g":e,移动:e,"xn--6qq986b3xl":e,我爱你:e,"xn--80adxhks":e,москва:e,"xn--80aqecdr1a":e,католик:e,"xn--80asehdb":e,онлайн:e,"xn--80aswg":e,сайт:e,"xn--8y0a063a":e,联通:e,"xn--9dbq2a":e,קום:e,"xn--9et52u":e,时尚:e,"xn--9krt00a":e,微博:e,"xn--b4w605ferd":e,淡马锡:e,"xn--bck1b9a5dre4c":e,ファッション:e,
"xn--c1avg":e,орг:e,"xn--c2br7g":e,नेट:e,"xn--cck2b3b":e,ストア:e,"xn--cckwcxetd":e,アマゾン:e,"xn--cg4bki":e,삼성:e,"xn--czr694b":e,商标:e,"xn--czrs0t":e,商店:e,"xn--czru2d":e,商城:e,"xn--d1acj3b":e,дети:e,"xn--eckvdtc9d":e,ポイント:e,"xn--efvy88h":e,新闻:e,"xn--fct429k":e,家電:e,"xn--fhbei":e,كوم:e,"xn--fiq228c5hs":e,中文网:e,"xn--fiq64b":e,中信:e,"xn--fjq720a":e,娱乐:e,"xn--flw351e":e,谷歌:e,"xn--fzys8d69uvgm":e,電訊盈科:e,"xn--g2xx48c":e,购物:e,"xn--gckr3f0f":e,クラウド:e,"xn--gk3at1e":e,通販:e,"xn--hxt814e":e,网店:e,"xn--i1b6b1a6a2e":e,संगठन:e,"xn--imr513n":e,餐厅:e,"xn--io0a7i":e,网络:e,"xn--j1aef":e,ком:e,"xn--jlq480n2rg":e,亚马逊:e,"xn--jvr189m":e,食品:e,"xn--kcrx77d1x4a":e,飞利浦:e,"xn--kput3i":e,手机:e,"xn--mgba3a3ejt":e,ارامكو:e,"xn--mgba7c0bbn0a":e,العليان:e,"xn--mgbab2bd":e,بازار:e,"xn--mgbca7dzdo":e,ابوظبي:e,"xn--mgbi4ecexp":e,كاثوليك:e,"xn--mgbt3dhd":e,
همراه:e,"xn--mk1bu44c":e,닷컴:e,"xn--mxtq1m":e,政府:e,"xn--ngbc5azd":e,شبكة:e,"xn--ngbe9e0a":e,بيتك:e,"xn--ngbrx":e,عرب:e,"xn--nqv7f":e,机构:e,"xn--nqv7fs00ema":e,组织机构:e,"xn--nyqy26a":e,健康:e,"xn--otu796d":e,招聘:e,"xn--p1acf":e,рус:e,"xn--pssy2u":e,大拿:e,"xn--q9jyb4c":e,みんな:e,"xn--qcka1pmc":e,グーグル:e,"xn--rhqv96g":e,世界:e,"xn--rovu88b":e,書籍:e,"xn--ses554g":e,网址:e,"xn--t60b56a":e,닷넷:e,"xn--tckwe":e,コム:e,"xn--tiq49xqyj":e,天主教:e,"xn--unup4y":e,游戏:e,"xn--vermgensberater-ctb":e,vermögensberater:e,"xn--vermgensberatung-pwb":e,vermögensberatung:e,"xn--vhquv":e,企业:e,"xn--vuq861b":e,信息:e,"xn--w4r85el8fhu5dnra":e,嘉里大酒店:e,"xn--w4rs40l":e,嘉里:e,"xn--xhq521b":e,广东:e,"xn--zfr164b":e,政务:e,xyz:e,yachts:e,yahoo:e,yamaxun:e,yandex:e,yodobashi:e,yoga:e,yokohama:e,you:e,youtube:e,yun:e,zappos:e,zara:e,zero:e,zip:e,zone:e,zuerich:e}]})()});function N7(e,t,r){let n=null,a=t;for(;a!==void 0&&(a[0]===1&&(n={index:r+1}),r!==-1);){let o=a[1];a=Object.prototype.hasOwnProperty.call(o,e[r])?o[e[r]]:o["*"],r-=1}return n}function KS(e,t,r){var n;if(Qy(e,t,r))return;let a=e.split("."),o=N7(a,F7,a.length-1);if(o!==null){r.publicSuffix=a.slice(o.index+1).join(".");return}let s=N7(a,M7,a.length-1);if(s!==null){r.publicSuffix=a.slice(s.index).join(".");return}r.publicSuffix=(n=a[a.length-1])!==null&&n!==void 0?n:null}var L7=g(()=>{d();YS();O7();i(N7,"lookupInTrie");i(KS,"suffixLookup")});function B7(e,t={}){return VS(P7),$S(e,3,KS,t,P7).domain}var P7,U7=g(()=>{d();YS();L7();P7=WS();i(B7,"getDomain")});var jt,ege,j7,q7,ce,tge,Pr=g(()=>{"use strict";d();L();jt={didntCollectScreenshots:"Chrome didn't collect any screenshots during the page load. Please make sure there is content visible on the page, and then try re-running Lighthouse. ({errorCode})",badTraceRecording:"Something went wrong with recording the trace over your page load. Please run Lighthouse again. ({errorCode})",noFcp:"The page did not paint any content. Please ensure you keep the browser window in the foreground during the load and try again. ({errorCode})",noLcp:"The page did not display content that qualifies as a Largest Contentful Paint (LCP). Ensure the page has a valid LCP element and then try again. ({errorCode})",pageLoadTookTooLong:"Your page took too long to load. Please follow the opportunities in the report to reduce your page load time, and then try re-running Lighthouse. ({errorCode})",pageLoadFailed:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL a\
nd that the server is properly responding to all requests.",pageLoadFailedWithStatusCode:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Status code: {statusCode})",pageLoadFailedWithDetails:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Details: {errorDetails})",pageLoadFailedInsecure:"The URL you have provided does not have a valid security certificate. {securityMessages}",pageLoadFailedInterstitial:"Chrome prevented page load with an interstitial. Make sure you are testing the correct URL and that the server is properly responding to all requests.",internalChromeError:"An internal Chrome error occurred. Please restart Chrome and try re-running Lighthouse.",requestContentTimeout:"Fetching resource content has exceeded the allotted time",notHtml:"The\
 page provided is not HTML (served as MIME type {mimeType}).",urlInvalid:"The URL you have provided appears to be invalid.",protocolTimeout:"Waiting for DevTools protocol response has exceeded the allotted time. (Method: {protocolMethod})",dnsFailure:"DNS servers could not resolve the provided domain.",pageLoadFailedHung:"Lighthouse was unable to reliably load the URL you requested because the page stopped responding.",criTimeout:"Timeout waiting for initial Debugger Protocol connection.",missingRequiredArtifact:"Required {artifactName} gatherer did not run.",erroredRequiredArtifact:"Required {artifactName} gatherer encountered an error: {errorMessage}",oldChromeDoesNotSupportFeature:"This version of Chrome is too old to support '{featureName}'. Use a newer version to see full results.",targetCrashed:"Browser tab has unexpectedly crashed."},ege=D("core/lib/lh-error.js",jt),j7="__LighthouseErrorSentinel",q7="__ErrorSentinel",ce=class e extends Error{static{i(this,"LighthouseError")}constructor(t,r,n){
super(t.code,n),this.name="LighthouseError",this.code=t.code,this.friendlyMessage=ege(t.message,{errorCode:this.code,...r}),this.lhrRuntimeError=!!t.lhrRuntimeError,r&&Object.assign(this,r),Error.captureStackTrace(this,e)}static fromProtocolMessage(t,r){let n=Object.values(e.errors).filter(s=>s.pattern).find(s=>s.pattern&&s.pattern.test(r.message));if(n)return new e(n);let a=`(${t}): ${r.message}`;r.data&&(a+=` (${r.data})`);let o=new Error(`Protocol error ${a}`);return Object.assign(o,{protocolMethod:t,protocolError:r.message})}static stringifyReplacer(t){if(t instanceof e){let{name:r,code:n,message:a,friendlyMessage:o,lhrRuntimeError:s,stack:c,cause:u,...l}=t;return{sentinel:j7,code:n,stack:c,cause:u,properties:l}}if(t instanceof Error){let{message:r,stack:n,cause:a}=t,o=t.code;return{sentinel:q7,message:r,code:o,stack:n,cause:a}}throw new Error("Invalid value for LighthouseError stringification")}static parseReviver(t,r){if(typeof r=="object"&&r!==null){if(r.sentinel===j7){let{code:n,
stack:a,cause:o,properties:s}=r,c=e.errors[n],u=new e(c,s,{cause:o});return u.stack=a,u}if(r.sentinel===q7){let{message:n,code:a,stack:o,cause:s}=r,c=s?{cause:s}:void 0,u=new Error(n,c);return Object.assign(u,{code:a,stack:o}),u}}return r}},tge={NO_SPEEDLINE_FRAMES:{code:"NO_SPEEDLINE_FRAMES",message:jt.didntCollectScreenshots,lhrRuntimeError:!0},SPEEDINDEX_OF_ZERO:{code:"SPEEDINDEX_OF_ZERO",message:jt.didntCollectScreenshots,lhrRuntimeError:!0},NO_SCREENSHOTS:{code:"NO_SCREENSHOTS",message:jt.didntCollectScreenshots,lhrRuntimeError:!0},INVALID_SPEEDLINE:{code:"INVALID_SPEEDLINE",message:jt.didntCollectScreenshots,lhrRuntimeError:!0},NO_TRACING_STARTED:{code:"NO_TRACING_STARTED",message:jt.badTraceRecording,lhrRuntimeError:!0},NO_RESOURCE_REQUEST:{code:"NO_RESOURCE_REQUEST",message:jt.badTraceRecording,lhrRuntimeError:!0},NO_NAVSTART:{code:"NO_NAVSTART",message:jt.badTraceRecording,lhrRuntimeError:!0},NO_FCP:{code:"NO_FCP",message:jt.noFcp,lhrRuntimeError:!0},NO_DCL:{code:"NO_DCL",message:jt.
badTraceRecording,lhrRuntimeError:!0},NO_FMP:{code:"NO_FMP",message:jt.badTraceRecording},NO_LCP:{code:"NO_LCP",message:jt.noLcp},NO_LCP_ALL_FRAMES:{code:"NO_LCP_ALL_FRAMES",message:jt.noLcp},UNSUPPORTED_OLD_CHROME:{code:"UNSUPPORTED_OLD_CHROME",message:jt.oldChromeDoesNotSupportFeature},NO_TTI_CPU_IDLE_PERIOD:{code:"NO_TTI_CPU_IDLE_PERIOD",message:jt.pageLoadTookTooLong},NO_TTI_NETWORK_IDLE_PERIOD:{code:"NO_TTI_NETWORK_IDLE_PERIOD",message:jt.pageLoadTookTooLong},NO_DOCUMENT_REQUEST:{code:"NO_DOCUMENT_REQUEST",message:jt.pageLoadFailed,lhrRuntimeError:!0},FAILED_DOCUMENT_REQUEST:{code:"FAILED_DOCUMENT_REQUEST",message:jt.pageLoadFailedWithDetails,lhrRuntimeError:!0},ERRORED_DOCUMENT_REQUEST:{code:"ERRORED_DOCUMENT_REQUEST",message:jt.pageLoadFailedWithStatusCode,lhrRuntimeError:!0},INSECURE_DOCUMENT_REQUEST:{code:"INSECURE_DOCUMENT_REQUEST",message:jt.pageLoadFailedInsecure,lhrRuntimeError:!0},CHROME_INTERSTITIAL_ERROR:{code:"CHROME_INTERSTITIAL_ERROR",message:jt.pageLoadFailedInterstitial,
lhrRuntimeError:!0},PAGE_HUNG:{code:"PAGE_HUNG",message:jt.pageLoadFailedHung,lhrRuntimeError:!0},NOT_HTML:{code:"NOT_HTML",message:jt.notHtml,lhrRuntimeError:!0},TRACING_ALREADY_STARTED:{code:"TRACING_ALREADY_STARTED",message:jt.internalChromeError,pattern:/Tracing.*started/,lhrRuntimeError:!0},PARSING_PROBLEM:{code:"PARSING_PROBLEM",message:jt.internalChromeError,pattern:/Parsing problem/,lhrRuntimeError:!0},READ_FAILED:{code:"READ_FAILED",message:jt.internalChromeError,pattern:/Read failed/,lhrRuntimeError:!0},INVALID_URL:{code:"INVALID_URL",message:jt.urlInvalid},PROTOCOL_TIMEOUT:{code:"PROTOCOL_TIMEOUT",message:jt.protocolTimeout,lhrRuntimeError:!0},DNS_FAILURE:{code:"DNS_FAILURE",message:jt.dnsFailure,lhrRuntimeError:!0},CRI_TIMEOUT:{code:"CRI_TIMEOUT",message:jt.criTimeout,lhrRuntimeError:!0},MISSING_REQUIRED_ARTIFACT:{code:"MISSING_REQUIRED_ARTIFACT",message:jt.missingRequiredArtifact},ERRORED_REQUIRED_ARTIFACT:{code:"ERRORED_REQUIRED_ARTIFACT",message:jt.erroredRequiredArtifact},
TARGET_CRASHED:{code:"TARGET_CRASHED",message:jt.targetCrashed,lhrRuntimeError:!0}};ce.errors=tge;ce.NO_ERROR="NO_ERROR";ce.UNKNOWN_ERROR="UNKNOWN_ERROR"});function ige(e){return!e||!e.startsWith("chrome://")?e:(e.endsWith("/")&&(e=e.replace(/\/$/,"")),e.replace(/^chrome:\/\/chrome\//,"chrome://"))}var rge,nge,age,oge,ev,he,Vt=g(()=>{"use strict";d();U7();uo();Pr();rge=["https:","http:","chrome:","chrome-extension:"],nge=["data","https","wss","blob","chrome","chrome-extension","about","filesystem"],age=["localhost","127.0.0.1"],oge=["blob","data","intent","file","filesystem","chrome-extension"];i(ige,"rewriteChromeInternalUrl");ev=class e{static{i(this,"UrlUtils")}static isValid(t){try{return new URL(t),!0}catch{return!1}}static hostsMatch(t,r){try{return new URL(t).host===new URL(r).host}catch{return!1}}static originsMatch(t,r){try{return new URL(t).origin===new URL(r).origin}catch{return!1}}static getOrigin(t){try{let r=new URL(t);return r.protocol==="chrome-extension:"?Bt.getChromeExtensionOrigin(t):r.host&&r.origin||null}catch{return null}}static getRootDomain(t){let r=Bt.createOrReturnURL(t);return B7(r.href)||r.hostname}static rootDomainsMatch(t,r){
let n,a;try{n=Bt.createOrReturnURL(t),a=Bt.createOrReturnURL(r)}catch{return!1}if(!n.hostname||!a.hostname)return!1;let o=e.getRootDomain(n),s=e.getRootDomain(a);return o===s}static getURLDisplayName(t,r){return Bt.getURLDisplayName(new URL(t),r)}static elideDataURI(t){try{return new URL(t).protocol==="data:"?Bt.truncate(t,100):t}catch{return t}}static equalWithExcludedFragments(t,r){[t,r]=[t,r].map(ige);try{let n=new URL(t);n.hash="";let a=new URL(r);return a.hash="",n.href===a.href}catch{return!1}}static isProtocolAllowed(t){try{let r=new URL(t);return rge.includes(r.protocol)}catch{return!1}}static isLikeLocalhost(t){return age.includes(t)||t.endsWith(".localhost")}static isSecureScheme(t){return nge.includes(t)}static isNonNetworkProtocol(t){let r=t.includes(":")?t.slice(0,t.indexOf(":")):t;return oge.includes(r)}static guessMimeType(t){let r;try{r=new URL(t)}catch{return}if(r.protocol==="data:"){let o=r.pathname.match(/^(image\/(png|jpeg|svg\+xml|webp|gif|avif))[;,]/);return o?o[1]:
void 0}let n=r.pathname.toLowerCase().match(/\.(png|jpeg|jpg|svg|webp|gif|avif)$/);if(!n)return;let a=n[1];return a==="svg"?"image/svg+xml":a==="jpg"?"image/jpeg":`image/${a}`}static normalizeUrl(t){if(t&&this.isValid(t)&&this.isProtocolAllowed(t))return new URL(t).href;throw new ce(ce.errors.INVALID_URL)}};ev.INVALID_URL_DEBUG_STRING="Lighthouse was unable to determine the URL of some script executions. It's possible a Chrome extension or other eval'd code is the source.";he=ev});var z7,H7,G7,W7,V7,$7,Y7,tv,ge,Rr=g(()=>{"use strict";d();yn();wr();Vt();z7="X-TCPMs",H7="X-SSLMs",G7="X-RequestMs",W7="X-ResponseMs",V7="X-TotalMs",$7="X-TotalFetchedSize",Y7="X-ProtocolIsH2",tv={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch",FedCM:"FedCM"},ge=class e{static{i(this,"NetworkRequest")}constructor(){this.requestId="",this.connectionId=0,this.connectionReused=!1,this.url="",this.protocol="",this.isSecure=!1,this.isValid=!1,this.parsedURL={scheme:""},this.documentURL="",this.rendererStartTime=-1,this.networkRequestTime=-1,this.responseHeadersEndTime=-1,this.networkEndTime=-1,this.transferSize=0,this.responseHeadersTransferSize=0,this.resourceSize=0,this.fromDiskCache=!1,this.
fromMemoryCache=!1,this.fromPrefetchCache=!1,this.lrStatistics=void 0,this.finished=!1,this.requestMethod="",this.statusCode=-1,this.redirectSource=void 0,this.redirectDestination=void 0,this.redirects=void 0,this.failed=!1,this.localizedFailDescription="",this.initiator={type:"other"},this.timing=void 0,this.resourceType=void 0,this.mimeType="",this.priority="Low",this.initiatorRequest=void 0,this.responseHeaders=[],this.responseHeadersText="",this.fetchedViaServiceWorker=!1,this.frameId="",this.sessionId=void 0,this.sessionTargetType=void 0,this.fromWorker=!1,this.isLinkPreload=!1}hasErrorStatusCode(){return this.statusCode>=400}setInitiatorRequest(t){this.initiatorRequest=t}onRequestWillBeSent(t){this.requestId=t.requestId;let r;try{r=new URL(t.request.url)}catch{return}this.url=t.request.url,this.documentURL=t.documentURL,this.parsedURL={scheme:r.protocol.split(":")[0],host:r.hostname,securityOrigin:r.origin},this.isSecure=he.isSecureScheme(this.parsedURL.scheme),this.rendererStartTime=
t.timestamp*1e3,this.networkRequestTime=this.rendererStartTime,this.responseHeadersEndTime=this.rendererStartTime,this.requestMethod=t.request.method,this.initiator=t.initiator,this.resourceType=t.type&&tv[t.type],this.priority=t.request.initialPriority,this.frameId=t.frameId,this.isLinkPreload=t.initiator.type==="preload"||!!t.request.isLinkPreload,this.isValid=!0}onRequestServedFromCache(){this.fromMemoryCache=!0}onResponseReceived(t){this._onResponse(t.response,t.timestamp,t.type),this._updateProtocolForLightrider(),this.frameId=t.frameId}onResponseReceivedExtraInfo(t){this.responseHeadersText=t.headersText||""}onDataReceived(t){this.resourceSize+=t.dataLength,t.encodedDataLength!==-1&&(this.transferSize+=t.encodedDataLength)}onLoadingFinished(t){this.finished||(this.finished=!0,this.networkEndTime=t.timestamp*1e3,t.encodedDataLength>=0&&(this.transferSize=t.encodedDataLength),this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),
this._updateTimingsForLightrider())}onLoadingFailed(t){this.finished||(this.finished=!0,this.networkEndTime=t.timestamp*1e3,this.failed=!0,this.resourceType=t.type&&tv[t.type],this.localizedFailDescription=t.errorText,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onResourceChangedPriority(t){this.priority=t.newPriority}onRedirectResponse(t){if(!t.redirectResponse)throw new Error("Missing redirectResponse data");this._onResponse(t.redirectResponse,t.timestamp,t.type),this.resourceType=void 0,this.finished=!0,this.networkEndTime=t.timestamp*1e3,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming()}setSession(t){this.sessionId=t}get isOutOfProcessIframe(){return this.sessionTargetType==="iframe"}_onResponse(t,r,n){this.url=t.url,this.connectionId=t.connectionId,this.connectionReused=t.connectionReused,t.protocol&&(this.protocol=t.protocol),
this.responseTimestamp=r*1e3,this.transferSize=t.encodedDataLength,this.responseHeadersTransferSize=t.encodedDataLength,typeof t.fromDiskCache=="boolean"&&(this.fromDiskCache=t.fromDiskCache),typeof t.fromPrefetchCache=="boolean"&&(this.fromPrefetchCache=t.fromPrefetchCache),this.statusCode=t.status,this.timing=t.timing,n&&(this.resourceType=tv[n]),this.mimeType=t.mimeType,this.responseHeaders=e._headersDictToHeadersArray(t.headers),this.fetchedViaServiceWorker=!!t.fromServiceWorker,this.fromMemoryCache&&(this.timing=void 0),this.timing&&this._recomputeTimesWithResourceTiming(this.timing)}_recomputeTimesWithResourceTiming(t){if(t.requestTime===-1||t.receiveHeadersEnd===-1)return;this.networkRequestTime=t.requestTime*1e3;let r=this.networkRequestTime+t.receiveHeadersEnd;this.responseHeadersEndTime=r,this.responseTimestamp!==void 0&&(this.responseHeadersEndTime=Math.min(this.responseHeadersEndTime,this.responseTimestamp)),this.responseHeadersEndTime=Math.max(this.responseHeadersEndTime,this.
networkRequestTime),this.networkEndTime=Math.max(this.networkEndTime,this.responseHeadersEndTime)}_updateResponseHeadersEndTimeIfNecessary(){this.responseHeadersEndTime=Math.min(this.networkEndTime,this.responseHeadersEndTime)}_updateTransferSizeForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(n=>n.name===$7);if(!t)return;let r=parseFloat(t.value);isNaN(r)||(this.transferSize=r)}_updateProtocolForLightrider(){globalThis.isLightrider&&this.responseHeaders.some(t=>t.name===Y7)&&(this.protocol="h2")}_backfillReceiveHeaderStartTiming(){!this.timing||this.timing.receiveHeadersStart!==void 0||(this.timing.receiveHeadersStart=this.timing.receiveHeadersEnd)}_updateTimingsForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(p=>p.name===V7);if(!t)return;let r=parseInt(t.value),n=this.responseHeaders.find(p=>p.name===z7),a=this.responseHeaders.find(p=>p.name===H7),o=this.responseHeaders.find(p=>p.name===G7),s=this.responseHeaders.find(
p=>p.name===W7),c=n?Math.max(0,parseInt(n.value)):0,u=a?Math.max(0,parseInt(a.value)):0,l=o?Math.max(0,parseInt(o.value)):0,m=s?Math.max(0,parseInt(s.value)):0;if(!Number.isNaN(c+l+m+r)){if(c+l+m!==r){if(Math.abs(c+l+m-r)>=25)return;r=c+l+m}u>c||(this.lrStatistics={endTimeDeltaMs:this.networkEndTime-(this.networkRequestTime+r),TCPMs:c,requestMs:l,responseMs:m},this.serverResponseTime=m)}}static getRequestIdForBackend(t){return t.replace(/(:redirect)+$/,"")}static _headersDictToHeadersArray(t){let r=[];for(let n of Object.keys(t)){let a=t[n].split(`
`);for(let o=0;o<a.length;++o)r.push({name:n,value:a[o]})}return r}static get TYPES(){return tv}static asLanternNetworkRequest(t){let r=t.timing,n;return globalThis.isLightrider&&t.lrStatistics&&(t.protocol.startsWith("h3")?r={connectStart:0,connectEnd:t.lrStatistics.TCPMs}:(r={connectStart:0,sslStart:t.lrStatistics.TCPMs/2,connectEnd:t.lrStatistics.TCPMs,sslEnd:t.lrStatistics.TCPMs},n=t.lrStatistics.requestMs)),t.fromWorker=t.sessionTargetType==="worker",{rawRequest:t,...t,timing:r,serverResponseTime:n}}static isNonNetworkRequest(t){return he.isNonNetworkProtocol(t.protocol)||he.isNonNetworkProtocol(t.parsedURL.scheme)}static isSecureRequest(t){return he.isSecureScheme(t.parsedURL.scheme)||he.isSecureScheme(t.protocol)||he.isLikeLocalhost(t.parsedURL.host)||e.isHstsRequest(t)}static isHstsRequest(t){let r=t.redirectDestination;return r?t.responseHeaders.find(o=>o.name==="Non-Authoritative-Reason")?.value==="HSTS"&&e.isSecureRequest(r):!1}static isContentEncoded(t){let r=globalThis.isLightrider?
[/^x-original-content-encoding$/i]:[/^content-encoding$/i,/^x-content-encoding-over-network$/i],n=["gzip","br","deflate","zstd"];return t.responseHeaders.some(a=>r.some(o=>a.name.match(o))&&n.includes(a.value))}static getResourceSizeOnNetwork(t){return Math.min(t.resourceSize||0,t.transferSize||1/0)}};ge.HEADER_TCP=z7;ge.HEADER_SSL=H7;ge.HEADER_REQ=G7;ge.HEADER_RES=W7;ge.HEADER_TOTAL=V7;ge.HEADER_FETCHED_SIZE=$7;ge.HEADER_PROTOCOL_IS_H2=Y7});var sge,ll,JS=g(()=>{"use strict";d();qo();pt();yn();wr();Rr();sge=It,ll=class e extends sge{static{i(this,"NetworkRecorder")}constructor(){super(),this._records=[],this._recordsById=new Map}getRawRecords(){return Array.from(this._records)}onRequestStarted(t){this._records.push(t),this._recordsById.set(t.requestId,t),this.emit("requeststarted",t)}onRequestFinished(t){this.emit("requestfinished",t)}onRequestWillBeSent(t){let r=t.params,n=this._findRealRequestAndSetSession(r.requestId,t.targetType,t.sessionId);if(!n){let s=new ge;s.onRequestWillBeSent(r),s.sessionId=t.sessionId,s.sessionTargetType=t.targetType,this.onRequestStarted(s),q.verbose("network",`request will be sent to ${s.url}`);return}if(!r.redirectResponse)return;let a={...r,initiator:n.initiator,requestId:`${n.requestId}:redirect`},o=new ge;o.onRequestWillBeSent(a),n.onRedirectResponse(r),q.verbose("network",`${n.url} redirected to ${o.url}`),n.redirectDestination=o,o.redirectSource=n,this.onRequestStarted(o),this.onRequestFinished(
n)}onRequestServedFromCache(t){let r=t.params,n=this._findRealRequestAndSetSession(r.requestId,t.targetType,t.sessionId);n&&(q.verbose("network",`${n.url} served from cache`),n.onRequestServedFromCache())}onResponseReceived(t){let r=t.params,n=this._findRealRequestAndSetSession(r.requestId,t.targetType,t.sessionId);n&&(q.verbose("network",`${n.url} response received`),n.onResponseReceived(r))}onResponseReceivedExtraInfo(t){let r=t.params,n=this._findRealRequestAndSetSession(r.requestId,t.targetType,t.sessionId);n&&(q.verbose("network",`${n.url} response received extra info`),n.onResponseReceivedExtraInfo(r))}onDataReceived(t){let r=t.params,n=this._findRealRequestAndSetSession(r.requestId,t.targetType,t.sessionId);n&&(q.verbose("network",`${n.url} data received`),n.onDataReceived(r))}onLoadingFinished(t){let r=t.params,n=this._findRealRequestAndSetSession(r.requestId,t.targetType,t.sessionId);n&&(q.verbose("network",`${n.url} loading finished`),n.onLoadingFinished(r),this.onRequestFinished(
n))}onLoadingFailed(t){let r=t.params,n=this._findRealRequestAndSetSession(r.requestId,t.targetType,t.sessionId);n&&(q.verbose("network",`${n.url} loading failed`),n.onLoadingFailed(r),this.onRequestFinished(n))}onResourceChangedPriority(t){let r=t.params,n=this._findRealRequestAndSetSession(r.requestId,t.targetType,t.sessionId);n&&n.onResourceChangedPriority(r)}dispatch(t){switch(t.method){case"Network.requestWillBeSent":return this.onRequestWillBeSent(t);case"Network.requestServedFromCache":return this.onRequestServedFromCache(t);case"Network.responseReceived":return this.onResponseReceived(t);case"Network.responseReceivedExtraInfo":return this.onResponseReceivedExtraInfo(t);case"Network.dataReceived":return this.onDataReceived(t);case"Network.loadingFinished":return this.onLoadingFinished(t);case"Network.loadingFailed":return this.onLoadingFailed(t);case"Network.resourceChangedPriority":return this.onResourceChangedPriority(t);default:return}}_findRealRequestAndSetSession(t,r,n){let a=this.
_recordsById.get(t);if(!(!a||!a.isValid)){for(;a.redirectDestination;)a=a.redirectDestination;return a.setSession(n),a.sessionTargetType=r,a}}static _chooseInitiatorRequest(t,r){if(t.redirectSource)return t.redirectSource;let n=Lr.PageDependencyGraph.getNetworkInitiators(t)[0],a=r.get(n)||[];if(a=a.filter(o=>o.responseHeadersEndTime<=t.rendererStartTime&&o.finished&&!o.failed),a.length>1){let o=a.filter(s=>s.resourceType!==ge.TYPES.Other);o.length&&(a=o)}if(a.length>1){let o=a.filter(s=>s.frameId===t.frameId);o.length&&(a=o)}if(a.length>1&&t.initiator.type==="parser"){let o=a.filter(s=>s.resourceType===ge.TYPES.Document);o.length&&(a=o)}if(a.length>1){let o=a.filter(s=>s.isLinkPreload);if(o.length){let s=a.filter(u=>!u.isLinkPreload),c=s.every(u=>u.fromDiskCache||u.fromMemoryCache);s.length&&c&&(a=o)}}return a.length===1?a[0]:null}static recordsFromLogs(t){let r=new e;t.forEach(o=>r.dispatch(o));let n=r.getRawRecords().filter(o=>o.isValid),a=new Map;for(let o of n){let s=a.get(o.url)||
[];s.push(o),a.set(o.url,s)}for(let o of n){let s=e._chooseInitiatorRequest(o,a);s&&o.setInitiatorRequest(s);let c=o;for(;c.redirectDestination;)c=c.redirectDestination;if(c===o||c.redirects)continue;let u=[];for(let l=c.redirectSource;l;l=l.redirectSource)u.unshift(l);c.redirects=u}return n}}});var XS,ke,Ot=g(()=>{"use strict";d();yn();tt();JS();XS=class{static{i(this,"NetworkRecords")}static async compute_(t){return ll.recordsFromLogs(t)}},ke=fe(XS,null)});var ZS,$a,Nc=g(()=>{"use strict";d();pt();wr();tt();Ot();ZS=class{static{i(this,"NetworkAnalysis")}static async compute_(t,r){let n=await ke.request(t,r),a=Ht.NetworkAnalyzer.analyze(n);return a||(q.error("NetworkAnalysis","Network analysis failed due to lack of transfer data"),{throughput:0,rtt:Number.POSITIVE_INFINITY,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map})}},$a=fe(ZS,null)});var QS,tn,Co=g(()=>{"use strict";d();tt();wr();Nc();QS=class{static{i(this,"LoadSimulator")}static async compute_(t,r){let n=await $a.request(t.devtoolsLog,r);return ni.Simulator.createSimulator({...t.settings,networkAnalysis:n})}static convertAnalysisToSaveableLanternData(t){let r={additionalRttByOrigin:{},serverResponseTimeByOrigin:{}};for(let[n,a]of t.additionalRttByOrigin.entries())n.startsWith("http")&&(r.additionalRttByOrigin[n]=a);for(let[n,a]of t.serverResponseTimeByOrigin.entries())n.startsWith("http")&&(r.serverResponseTimeByOrigin[n]=a);return r}},tn=fe(QS,["devtoolsLog","settings"])});async function t2(e,t,r){let n=ya.createWriteStream(r?t+".gz":t);r?await yw.promises.pipeline(e,w8(),n):await yw.promises.pipeline(e,n)}function e2(e,t){if(ya.existsSync(e+".gz")&&(e=e+".gz"),!e.endsWith(".json.gz"))return JSON.parse(ya.readFileSync(e,"utf8"),t);let r=D8(ya.readFileSync(e));return JSON.parse(r.toString("utf8"),t)}function K7(e,t){return e.endsWith(t)||e.endsWith(t+".gz")}function Z7(e){if(q.log("Reading artifacts from disk:",e),!ya.existsSync(e))throw new Error("No saved artifacts found at "+e);let t=e2(fr.join(e,rv),ce.parseReviver),r=ya.readdirSync(e);return r.filter(n=>K7(n,Pc)).forEach(n=>{t.devtoolsLogs||(t.devtoolsLogs={});let a=n.replace(Pc+".gz","").replace(Pc,""),o=e2(fr.join(e,n));t.devtoolsLogs[a]=o,a===nv&&(t.DevtoolsLog=o),a===av&&(t.DevtoolsLogError=o)}),r.filter(n=>K7(n,Lc)).forEach(n=>{t.traces||(t.traces={});let a=e2(fr.join(e,n)),o=n.replace(Lc+".gz","").replace(Lc,"");t.traces[o]=Array.isArray(a)?{traceEvents:a}:a,o===nv&&(t.Trace=t.traces[o]),o===av&&
(t.TraceError=t.traces[o])}),Array.isArray(t.Timing)&&t.Timing.forEach(n=>n.gather=!0),t}function cge(e,t){return t instanceof Error?ce.stringifyReplacer(t):t}async function Q7(e,t,r={}){let n={msg:"Saving artifacts",id:"lh:assetSaver:saveArtifacts"};q.time(n),ya.mkdirSync(t,{recursive:!0});let a=ya.readdirSync(t);for(let h of a)(h.endsWith(Lc)||h.endsWith(Pc)||h.endsWith(Lc+".gz")||h.endsWith(Pc+".gz")||h===rv||h===rv+".gz")&&ya.unlinkSync(`${t}/${h}`);let{traces:o,devtoolsLogs:s,DevtoolsLog:c,Trace:u,DevtoolsLogError:l,TraceError:m,...p}=e;u&&await J7(u,`${t}/${nv}${Lc}`,r),m&&await J7(m,`${t}/${av}${Lc}`,r),c&&await X7(c,`${t}/${nv}${Pc}`,r),l&&await X7(l,`${t}/${av}${Pc}`,r);let f=JSON.stringify(p,cge,2);await t2(function*(){yield f,yield`
`},`${t}/${rv}`,!!r.gzip),q.log("Artifacts saved to disk in folder:",t),q.timeEnd(n)}function e9(e,t){ya.writeFileSync(`${t}/lhr.report.json`,JSON.stringify(e,null,2))}function*t9(e){if(yield`[
`,e.length>0){let r=e[Symbol.iterator](),n=r.next().value;yield`  ${JSON.stringify(n)}`;let a=500,o="";for(let s of r)o+=`,
  ${JSON.stringify(s)}`,a--,a===0&&(yield o,a=500,o="");yield o}yield`
]`}function*uge(e){let{traceEvents:t,...r}=e;yield`{
`,yield'"traceEvents": ',yield*t9(t);for(let[n,a]of Object.entries(r))yield`,
"${n}": ${JSON.stringify(a,null,2)}`;yield`}
`}function J7(e,t,r={}){let n=uge(e);retu