import"../../ui/components/switch/switch.js";import"../../ui/components/cards/cards.js";import*as e from"../../ui/components/chrome_link/chrome_link.js";import*as t from"../../core/common/common.js";import*as i from"../../core/host/host.js";import*as s from"../../core/i18n/i18n.js";import*as r from"../../core/root/root.js";import*as o from"../../core/sdk/sdk.js";import"../../ui/components/buttons/buttons.js";import*as n from"../../ui/components/input/input.js";import*as a from"../../ui/legacy/legacy.js";import*as c from"../../ui/lit/lit.js";import{render as l,html as d}from"../../ui/lit/lit.js";import*as u from"../../ui/visual_logging/visual_logging.js";import"../../ui/legacy/components/data_grid/data_grid.js";import*as h from"../../core/platform/platform.js";import*as p from"../../models/issues_manager/issues_manager.js";import*as g from"../network/forward/forward.js";import*as m from"../../ui/components/icon_button/icon_button.js";var y=`.overflow-auto{height:100%}.controls{display:flex;flex-direction:column;padding:var(--sys-size-5) var(--sys-size-3) var(--sys-size-5) var(--sys-size-5);min-width:var(--sys-size-33)}.header{display:flex;flex-direction:column;gap:var(--sys-size-2);padding-left:var(--sys-size-5)}h1{margin:0;font:var(--sys-typescale-headline4)}.card-container{max-width:100%}.card{display:flex;flex-direction:column;padding:var(--sys-size-6) var(--sys-size-8);gap:var(--sys-size-6);&.enterprise-disabled{color:var(--sys-color-token-subtle)}}.card-header{display:flex;align-items:center}.card-header > .lhs{width:100%;display:flex;justify-content:space-between;align-items:center;padding-right:var(--sys-size-9);& > devtools-icon{height:var(--sys-size-11);width:var(--sys-size-11)}}.text{display:flex;flex-direction:column;gap:var(--sys-size-2)}h2{font:var(--sys-typescale-headline5);margin:0}.body{font:var(--sys-typescale-body4-regular)}.checkbox-label{gap:var(--sys-size-8);display:flex;align-items:center}.card-row{padding-top:var(--sys-size-4);padding-bottom:var(--sys-size-4);padding-left:var(--sys-size-8)}h3{font:var(--sys-typescale-body4-medium);margin:0}.x-link{color:var(--sys-color-primary);text-decoration-line:underline;cursor:pointer}.enterprise{display:flex;flex-direction:row;justify-content:space-between;gap:var(--sys-size-9);padding:var(--sys-size-6) var(--sys-size-8) var(--sys-size-6) var(--sys-size-11);align-items:center;> .anchor{display:flex;flex-direction:row;gap:var(--sys-size-9)}}input[type="checkbox"]{flex-shrink:0}.main-text{color:var(--sys-color-on-surface)}.subtext{color:var(--sys-color-on-surface-subtle)}\n/*# sourceURL=${import.meta.resolve("./cookieControlsView.css")} */`;const{render:v,html:w}=c,b={viewTitle:"Controls",viewExplanation:"Test how this site will perform if third-party cookies are limited in ChatGPT Atlas",cardTitle:"Temporarily limit third-party cookies",cardDisclaimer:"Only when DevTools is open",siteReloadMessage:"To apply your updated controls, reload the page",exceptions:"Exceptions",exceptionsExplanation:"Scenarios that grant access to third-party cookies",gracePeriodTitle:"Third-party cookie grace period",gracePeriodExplanation:"If this site or a site embedded on it is enrolled in the {PH1}, then the site can access third-party cookies",enrollGracePeriod:"To use this, enroll this site or sites embedded on it in the {PH1}",gracePeriod:"grace period",heuristicTitle:"Heuristics based exception",heuristicExplanation:"In {PH1} like pop-ups or redirects, a site embedded on this site can access third-party cookies",scenarios:"predefined scenarios",enterpriseDisclaimer:"Your organization manages third-party cookie access for this site",enterpriseTooltip:"This setting is managed by your organization",viewDetails:"View details",enableFlag:"To use this, set {PH1} to Default",tpcdMetadataGrants:"#tpcd-metadata-grants",tpcdHeuristicsGrants:"#tpcd-heuristics-grants"},S=s.i18n.registerUIStrings("panels/security/CookieControlsView.ts",b),f=s.i18n.getLocalizedString.bind(void 0,S),k=s.i18n.getFormatLocalizedString.bind(void 0,S);function x(){a.InspectorView.InspectorView.instance().displayDebuggedTabReloadRequiredWarning(f(b.siteReloadMessage))}class C extends a.Widget.VBox{#e;#t;#i;constructor(e,i=(e,i,s)=>{const r=t.Settings.Settings.instance().createSetting("enterprise-enabled",!(!this.#i||!this.#i.managedBlockThirdPartyCookies||"boolean"!=typeof this.#i.managedBlockThirdPartyCookies)&&this.#i.managedBlockThirdPartyCookies,"Global"),o=t.Settings.Settings.instance().createSetting("cookie-control-override-enabled",!(!this.#i||!this.#i.thirdPartyCookieRestrictionEnabled)&&this.#i.thirdPartyCookieRestrictionEnabled,"Global"),n=t.Settings.Settings.instance().createSetting("grace-period-mitigation-disabled",!this.#i||!this.#i.thirdPartyCookieMetadataEnabled||this.#i.thirdPartyCookieMetadataEnabled,"Global"),l=t.Settings.Settings.instance().createSetting("heuristic-mitigation-disabled",!this.#i||!this.#i.thirdPartyCookieHeuristicsEnabled||this.#i.thirdPartyCookieHeuristicsEnabled,"Global"),d=w`
      <div class="card-header">
        <div class="lhs">
          <div class="text">
            <h2 class="main-text">${f(b.cardTitle)}</h2>
            <div class="body subtext">${f(b.cardDisclaimer)}</div>
          </div>
          ${Boolean(r.get())?w`
            <devtools-icon
              tabindex="0"
              name="domain"
              ${c.Directives.ref(e=>{a.Tooltip.Tooltip.install(e,f(b.enterpriseTooltip)),e.role="img"})}>
            </devtools-icon>`:c.nothing}
        </div>
        <div>
          <devtools-switch
            .checked=${Boolean(o.get())}
            .disabled=${Boolean(r.get())}
            .label=${"Temporarily limit third-party cookies, only when DevTools is open"}
            data-testid="cookie-control-override"
            @switchchange=${()=>{e.inputChanged(!o.get(),o)}}
            jslog=${u.toggle(o.name).track({click:!0})}
          >
          </devtools-switch>
        </div>
      </div>
    `,h=!!this.#i&&!this.#i.thirdPartyCookieMetadataEnabled||r.get()||!o.get()||!this.#t,p=w`
      <div class="card-row">
        <label class='checkbox-label'>
          <input type='checkbox'
            .disabled=${h}
            .checked=${!h&&!Boolean(n.get())}
            @change=${()=>{e.inputChanged(!n.get(),n)}}
            jslog=${u.toggle(n.name).track({click:!0})}
          >
          <div class="text">
            <div class="body main-text">${f(b.gracePeriodTitle)}</div>
            <div class="body subtext">
              ${Boolean(r.get())?k(b.gracePeriodExplanation,{PH1:f(b.gracePeriod)}):this.#i&&!this.#i?.thirdPartyCookieMetadataEnabled?k(b.enableFlag,{PH1:this.getChromeFlagsLink(b.tpcdMetadataGrants)}):k(this.#t?b.gracePeriodExplanation:b.enrollGracePeriod,{PH1:a.Fragment.html`<x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/grace-period" jslog=${u.link("grace-period-link").track({click:!0})}>${f(b.gracePeriod)}</x-link>`})}
            </div>
          </div>
        </label>
      </div>
    `,g=!!this.#i&&!this.#i.thirdPartyCookieHeuristicsEnabled||r.get()||!o.get(),m=w`
      <div class="card-row">
        <label class='checkbox-label'>
          <input type='checkbox'
            .disabled=${g}
            .checked=${!g&&!Boolean(l.get())}
            @change=${()=>{e.inputChanged(!l.get(),l)}}
            jslog=${u.toggle(l.name).track({click:!0})}
          >
          <div class='text'>
            <div class="body main-text">${f(b.heuristicTitle)}</div>
            <div class="body subtext">
              ${Boolean(r.get())?k(b.heuristicExplanation,{PH1:f(b.scenarios)}):this.#i&&!this.#i.thirdPartyCookieHeuristicsEnabled?k(b.enableFlag,{PH1:this.getChromeFlagsLink(b.tpcdHeuristicsGrants)}):k(b.heuristicExplanation,{PH1:a.Fragment.html`<x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/heuristics-based-exceptions" jslog=${u.link("heuristic-link").track({click:!0})}>${f(b.scenarios)}</x-link>`})}
            </div>
          </div>
        </label>
      </div>
    `,y=w`
      <div class="enterprise">
        <div class="text body">${f(b.enterpriseDisclaimer)}</div>
          <div class="anchor">
            <devtools-icon
            name="domain"
            ></devtools-icon>
            <devtools-button
            @click=${e.openChromeCookieSettings}
            aria-label="View details of third-party cookie access in Settings"
            .variant=${"outlined"}
            jslog=${u.action("view-details").track({click:!0})}>
            ${f(b.viewDetails)}
          </devtools-button>
        </div>
      </div>
    `;v(w`
      <div class="overflow-auto">
        <div class="controls">
          <div class="header">
            <h1>${f(b.viewTitle)}</h1>
            <div class="body">${f(b.viewExplanation)}</div>
          </div>
          <devtools-card class="card-container">
            <div class=${Boolean(r.get())?"card enterprise-disabled":"card"}>
              ${d}
              <div>
                <div class="card-row text">
                  <h3 class="main-text">${f(b.exceptions)}</h3>
                  <div class="body subtext">${f(b.exceptionsExplanation)}</div>
                </div>
                ${p}
                ${m}
              </div>
            </div>
          </devtools-card>
          ${Boolean(r.get())?y:c.nothing}
        </div>
      </div>
    `,s,{host:this})}){super(e,{useShadowDom:!0}),this.#e=i,this.#t=!1,this.#i=r.Runtime.hostConfig.thirdPartyCookieControls,this.registerRequiredCSS(n.checkboxStyles,y),o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.#s,this),o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.ResourceAdded,this.checkGracePeriodActive,this),this.checkGracePeriodActive().catch(e=>{console.error(e)}),this.requestUpdate()}performUpdate(){this.#e(this,this,this.contentElement)}inputChanged(e,t){t.set(e),x(),this.requestUpdate()}openChromeCookieSettings(){const e=o.TargetManager.TargetManager.instance().rootTarget();if(null===e)return;const t="chrome://settings/cookies";e.targetAgent().invoke_createTarget({url:t}).then(e=>{e.getError()&&i.InspectorFrontendHost.InspectorFrontendHostInstance.openInNewTab(t)})}#s(){this.#t=!1,this.checkGracePeriodActive().catch(e=>{console.error(e)})}async checkGracePeriodActive(e){if(!this.#i||!this.#i.thirdPartyCookieMetadataEnabled)return;if(this.#t)return;const t=o.TargetManager.TargetManager.instance().primaryPageTarget();if(!t)return;const i=[];if(e)i.push(e.data.url);else for(const e of o.TargetManager.TargetManager.instance().models(o.ResourceTreeModel.ResourceTreeModel))e.forAllResources(e=>(i.push(e.url),!0));const s=await t.storageAgent().invoke_getAffectedUrlsForThirdPartyCookieMetadata({firstPartyUrl:t.inspectedURL(),thirdPartyUrls:i});s.matchedUrls&&s.matchedUrls.length>0&&(this.#t=!0,this.requestUpdate())}getChromeFlagsLink(t){const i=new e.ChromeLink.ChromeLink;return i.textContent=t,i.href="chrome://flags/"+t,i.setAttribute("tabindex","0"),i}}var T=Object.freeze({__proto__:null,CookieControlsView:C,i18nFormatString:k,i18nString:f,showInfobar:x}),E=`.report{display:flex;flex-direction:column;width:100%;height:100%;max-height:100%;gap:var(--sys-size-6);padding-top:var(--sys-size-5)}.header{display:flex;flex-direction:column;flex-shrink:0;gap:var(--sys-size-2);padding-left:var(--sys-size-6);padding-right:var(--sys-size-6);min-width:var(--sys-size-31);h1{font:var(--sys-typescale-headline4);margin:0}}.body{font:var(--sys-typescale-body4-regular)}.x-link{color:var(--sys-color-primary);text-decoration-line:underline;cursor:pointer}.filter{padding-right:var(--sys-size-6);flex-shrink:0}.filters-container{display:flex;padding-left:var(--sys-size-5)}devtools-data-grid{flex:auto;margin-left:-1px}.empty-report{display:flex;flex-direction:column;align-items:center;gap:var(--sys-size-2);padding:var(--sys-size-11) var(--sys-size-6) 0 var(--sys-size-6);flex-shrink:0;min-width:var(--sys-size-31)}.empty-report-title{font:var(--sys-typescale-headline5)}.cookie-off{width:var(--sys-size-11);height:var(--sys-size-11)}\n/*# sourceURL=${import.meta.resolve("./cookieReportView.css")} */`;const{render:I,html:P,Directives:{ref:R}}=c,A={title:"Third-party cookies",body:"This site might not work if third-party cookies and other cookies are limited in Chrome.",learnMoreLink:"Learn more about how third-party cookies are used",name:"Name",domain:"Domain",type:"Type",platform:"Platform",recommendation:"Recommendation",status:"Status",allowed:"Allowed",allowedByException:"Allowed by exception",blocked:"Blocked",unknown:"Unknown",report:"Third-Party Cookie Report",emptyReport:"Not a crumb left",emptyReportExplanation:"No issues with third-party cookies found",gitHubResource:"Review {PH1} from third-party site",guidance:"guidance",gracePeriod:"Review {PH1}. Grace period exception is active.",reportedIssues:"reported issues",heuristics:"Action needed later. Heuristics based exception is active.",other:"Contact third-party site for more info",adCookieTypeString:"Advertising",analyticsCookieTypeString:"Analytics",socialCookieTypeString:"Social",videoCookieTypeString:"Video",utilityCookieTypeString:"Utility",hostingCookieTypeString:"Hosting",marketingCookieTypeString:"Marketing",customerSuccessCookieTypeString:"Customer Success",contentCookieTypeString:"Content",cdnCookieTypeString:"CDN",tagManagerCookieTypeString:"Tag Manager",consentProviderCookieTypeString:"Consent Provider",otherCookieTypeString:"Other",showRequestsWithThisCookie:"Show requests with this cookie"},M=s.i18n.registerUIStrings("panels/security/CookieReportView.ts",A),L=s.i18n.getLocalizedString.bind(void 0,M);class D extends a.Widget.VBox{#r;namedBitSetFilterUI;#o=new Map;#e;filterItems=[];searchText;constructor(e,i=(e,t,i)=>{I(P`
        <div class="report overflow-auto">
            <div class="header">
              <h1>${L(A.title)}</h1>
              <div class="body">${L(A.body)} <x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/prepare/audit-cookies" jslog=${u.link("learn-more").track({click:!0})}>${L(A.learnMoreLink)}</x-link></div>
            </div>
            ${e.cookieRows.length>0?P`
                <div class="filters-container">
                  <devtools-toolbar>
                    <devtools-toolbar-input
                      type="filter"
                      style="flex-grow: 0.4;"
                      @change=${e.onSearchFilterChanged}
                      value=${e.searchText}
                    ></devtools-toolbar-input>
                  </devtools-toolbar>
                  <devtools-named-bit-set-filter
                    class="filter"
                    aria-label="Third-party cookie status filters"
                    @filterChanged=${e.onFilterChanged}
                    .options=${{items:e.filterItems}}
                    ${R(e=>{e instanceof a.FilterBar.NamedBitSetFilterUIElement&&(t.namedBitSetFilterUI=e.getOrCreateNamedBitSetFilterUI())})}
                  ></devtools-named-bit-set-filter>
                </div>
                <!-- @ts-ignore -->
                <devtools-data-grid
                  name=${L(A.report)}
                  striped
                  .filters=${e.filters}
                  @sort=${e.onSortingChanged}
                  @contextmenu=${e.populateContextMenu.bind(e)}
                >
                  <table>
                    <tr>
                      <th id="name" sortable>${L(A.name)}</th>
                      <th id="domain" sortable>${L(A.domain)}</th>
                      <th id="type" sortable>${L(A.type)}</th>
                      <th id="platform" sortable>${L(A.platform)}</th>
                      <th id="status" sortable>${L(A.status)}</th>
                      <th id="recommendation" sortable>${L(A.recommendation)}</th>
                    </tr>
                    ${[...e.cookieRows.values()].map(e=>P`
                      <tr data-name=${e.name} data-domain=${e.domain}>
                        <td>${e.name}</td>
                        <td>${e.domain}</td>
                        <td>${D.getCookieTypeString(e.type)}</td>
                        <td>${e.platform??L(A.unknown)}</td>
                        <td>${D.getStatusString(e.status)}</td>
                        <td>${D.getRecommendation(e.domain,e.insight)}</td>
                      </tr>
                    `)}
                  </table>
                </devtools-data-grid>
              `:P`
                <div class="empty-report">
                  <devtools-icon
                    class="cookie-off"
                    name="cookie_off"
                  ></devtools-icon>
                  <div class="empty-report-title">
                    ${L(A.emptyReport)}
                  </div>
                  <div class="body">
                    ${L(A.emptyReportExplanation)}
                  </div>
                </div>
              `}

        </div>
    `,i,{host:this})}){super(e,{useShadowDom:!0}),this.#e=i,this.registerRequiredCSS(E),this.searchText=t.Settings.Settings.instance().createSetting("cookie-report-search-query","").get(),o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.#s,this),this.#r=p.IssuesManager.IssuesManager.instance(),this.#r.addEventListener("IssueAdded",this.#n,this);for(const e of this.#r.issues())e instanceof p.CookieIssue.CookieIssue&&this.#a(e);this.requestUpdate()}performUpdate(){this.filterItems=this.#c();const e={cookieRows:[...this.#o.values()].filter(e=>!this.namedBitSetFilterUI||this.namedBitSetFilterUI.accept(D.getStatusString(e.status))),filters:[{key:"name,domain",regex:RegExp(h.StringUtilities.escapeForRegExp(this.searchText),"i"),negative:!1}],searchText:this.searchText,filterItems:this.filterItems,onSearchFilterChanged:e=>this.onSearchFilterChanged(e),onFilterChanged:()=>this.requestUpdate(),onSortingChanged:()=>this.requestUpdate(),populateContextMenu:this.populateContextMenu.bind(this)};this.#e(e,this,this.contentElement)}#s(){this.#o.clear(),this.namedBitSetFilterUI=void 0,this.requestUpdate()}#n(e){if(e.data.issue instanceof p.CookieIssue.CookieIssue){if(this.#o.has(e.data.issue.cookieId()))return;this.#a(e.data.issue),this.requestUpdate()}}#a(e){const t=e.makeCookieReportEntry();t&&this.#o.set(e.cookieId(),t)}onSearchFilterChanged(e){this.searchText=e.detail?e.detail:"",t.Settings.Settings.instance().createSetting("cookie-report-search-query","").set(this.searchText),this.requestUpdate()}#c(){const e=[];return this.#o.values().some(e=>0===e.status)&&e.push({name:A.blocked,label:()=>L(A.blocked),title:A.blocked,jslogContext:"blocked"}),this.#o.values().some(e=>1===e.status)&&e.push({name:A.allowed,label:()=>L(A.allowed),title:A.allowed,jslogContext:"allowed"}),this.#o.values().some(e=>2===e.status||3===e.status)&&e.push({name:A.allowedByException,label:()=>L(A.allowedByException),title:A.allowedByException,jslogContext:"allowed-by-exception"}),e}populateContextMenu(e){const{menu:i,element:s}=e.detail,{domain:r,name:o}=s?.dataset;r&&o&&i.revealSection().appendItem(L(A.showRequestsWithThisCookie),()=>{const e=g.UIFilter.UIRequestFilter.filters([{filterType:g.UIFilter.FilterType.CookieDomain,filterValue:r},{filterType:g.UIFilter.FilterType.CookieName,filterValue:o}]);t.Revealer.reveal(e)},{jslogContext:"show-requests-with-this-cookie"})}static getStatusString(e){switch(e){case 0:return L(A.blocked);case 2:case 3:return L(A.allowedByException);case 1:return L(A.allowed)}}static getRecommendation(e,t){const i=document.createElement("div");return I(D.getRecommendationText(e,t),i,{host:this}),i}static getRecommendationText(e,i){if(!i)return P`${L(A.other)}`;switch(i.type){case"GitHubResource":{const e=a.XLink.XLink.create(i.tableEntryUrl?i.tableEntryUrl:"https://github.com/privacysandbox/privacy-sandbox-dev-support/blob/main/3pc-migration-readiness.md",L(A.guidance),void 0,void 0,"readiness-list-link");return P`${s.i18n.getFormatLocalizedString(M,A.gitHubResource,{PH1:e})}`}case"GracePeriod":{const i=o.TargetManager.TargetManager.instance().primaryPageTarget()?.inspectedURL(),r=a.XLink.XLink.create("https://developers.google.com/privacy-sandbox/cookies/dashboard?url="+(i?t.ParsedURL.ParsedURL.fromString(i)?.host+"+":"")+("."===e.charAt(0)?e.substring(1):e),L(A.reportedIssues),void 0,void 0,"compatibility-lookup-link");return P`${s.i18n.getFormatLocalizedString(M,A.gracePeriod,{PH1:r})}`}case"Heuristics":return P`${L(A.heuristics)}`;default:return P`${L(A.other)}`}}static getCookieTypeString(e){if(!e)return L(A.otherCookieTypeString);switch(e){case"ad":return L(A.adCookieTypeString);case"analytics":return L(A.analyticsCookieTypeString);case"social":return L(A.socialCookieTypeString);case"video":return L(A.videoCookieTypeString);case"utility":return L(A.utilityCookieTypeString);case"hosting":return L(A.hostingCookieTypeString);case"marketing":return L(A.marketingCookieTypeString);case"customer-success":return L(A.customerSuccessCookieTypeString);case"content":return L(A.contentCookieTypeString);case"cdn":return L(A.cdnCookieTypeString);case"tag-manager":return L(A.tagManagerCookieTypeString);case"consent-provider":return L(A.consentProviderCookieTypeString);default:return L(A.otherCookieTypeString)}}}var U=Object.freeze({__proto__:null,CookieReportView:D,i18nString:L}),H=`@scope to (devtools-widget > *){:scope{width:100%;box-shadow:none}.overflow-auto{height:100%}.ip-protection{display:flex;flex-direction:column;padding:var(--sys-size-5) var(--sys-size-3) var(--sys-size-5) var(--sys-size-5);min-width:fit-content;min-height:fit-content;height:100%}.header{display:flex;flex-direction:column;gap:var(--sys-size-2);padding-left:var(--sys-size-5)}h1{margin:0;font:var(--sys-typescale-headline4)}.card-container{max-width:100%}.card{display:flex;flex-direction:column;padding:var(--sys-size-6) var(--sys-size-8);gap:var(--sys-size-6);&.enterprise-disabled{color:var(--sys-color-token-subtle)}}.card-header{display:flex;align-items:center}.card-header > .lhs{width:100%;display:flex;justify-content:space-between;align-items:center;padding-right:var(--sys-size-9);& > devtools-icon{height:var(--sys-size-11);width:var(--sys-size-11)}}.text{display:flex;flex-direction:column;gap:var(--sys-size-2)}h2{font:var(--sys-typescale-headline5);margin:0}.body{font:var(--sys-typescale-body4-regular)}.card-row{display:flex;justify-content:space-between;align-items:center;padding-top:var(--sys-size-4);padding-bottom:var(--sys-size-4);padding-left:var(--sys-size-8)}h3{font:var(--sys-typescale-body4-medium);margin:0}.main-text{color:var(--sys-color-on-surface)}.subtext{color:var(--sys-color-on-surface-subtle)}.empty-report{margin:var(--sys-size-5);display:flex;flex-grow:1;justify-content:center;align-items:center;flex-direction:column;text-align:center;min-height:fit-content;min-width:fit-content}devtools-data-grid{flex:auto}.status-badge{display:flex;align-items:center}.status-icon{width:1.5rem;height:1.5rem}.green-status-icon{color:var(--sys-color-green)}.red-status-icon{color:var(--sys-color-error)}}\n/*# sourceURL=${import.meta.resolve("./ipProtectionView.css")} */`;const{render:$,html:F}=c,{widgetConfig:V}=a.Widget,O={viewTitle:"IP Protection Proxy Controls",viewExplanation:"Test how this site will perform if IP Proxy is enabled in Chrome",cardTitle:"IP Protection Proxy Status",bypassTitle:"Bypass IP Protection",bypassDescription:"Temporarily bypass IP protection for testing",notInIncognito:"IP proxy unavailable",openIncognito:"IP proxy is only available within incognito mode. Open site in incognito.",idColumn:"ID",urlColumn:"URL",methodColumn:"Method",statusColumn:"Status",proxyRequests:"Proxy Requests",Available:"IP Protection is enabled and active.",FeatureNotEnabled:"IP Protection feature is not enabled.",MaskedDomainListNotEnabled:"Masked Domain List feature is not enabled.",MaskedDomainListNotPopulated:"Masked Domain List is not populated.",AuthTokensUnavailable:"Limit for authentication tokens was reached. IP Protection will be paused.",Unavailable:"IP Protection is unavailable.",BypassedByDevTools:"IP Protection is being bypassed by DevTools.",statusUnknown:"Status unknown"},z=s.i18n.registerUIStrings("panels/security/IPProtectionView.ts",O),N=s.i18n.getLocalizedString.bind(void 0,z),q=(e,t,i)=>{const{status:s}=e,o=N(s?O[s]:O.statusUnknown),n=F`
    <div class="card-header">
      <div class="lhs">
        <div class="text">
          <h2 class="main-text">${N(O.cardTitle)}</h2>
          <div class="body subtext">${o}</div>
        </div>
      </div>
      <div class="status-badge">
       ${"Available"===s?F`<devtools-icon class="status-icon green-status-icon" role="presentation" name="check-circle"></devtools-icon>`:F`<devtools-icon class="status-icon red-status-icon" role="presentation" name="cross-circle-filled"></devtools-icon>`}
      </div>
    </div>
  `;$(F`
    <style>
      ${H}
    </style>
    ${r.Runtime.hostConfig.isOffTheRecord?F`
      <div class="overflow-auto">
        <div class="ip-protection">
          <div class="header">
            <h1>${N(O.viewTitle)}</h1>
            <div class="body">${N(O.viewExplanation)}</div>
          </div>
          <devtools-card class="card-container">
            <div class="card">
              ${n}
              <div>
                <div class="card-row">
                  <div class="lhs">
                    <h3 class="main-text">${N(O.bypassTitle)}</h3>
                    <div class="body subtext">${N(O.bypassDescription)}</div>
                  </div>
                  <div>
                    <devtools-switch></devtools-switch>
                  </div>
                </div>
              </div>
            </div>
          </devtools-card>
          <devtools-data-grid striped name=${N(O.proxyRequests)}>
          <table>
            <thead>
              <tr>
                <th id="id" sortable>${N(O.idColumn)}</th>
                <th id="url" sortable>${N(O.urlColumn)}</th>
                <th id="method" sortable>${N(O.methodColumn)}</th>
                <th id="status" sortable>${N(O.statusColumn)}</th>
              </tr>
            </thead>
            <tbody id="proxy-requests-body">
              ${e.proxyRequests.map((e,t)=>F`
                <tr data-request-id=${e.requestId}>
                  <td>${t+1}</td>
                  <td>${e.url}</td>
                  <td>${e.requestMethod}</td>
                  <td>${String(e.statusCode)}</td>
                </tr>
              `)}
            </tbody>
          </table>
        </devtools-data-grid>
        </div>
      </div>
    `:F`
      <div class="empty-report">
        <devtools-widget
          class="learn-more"
          .widgetConfig=${V(a.EmptyWidget.EmptyWidget,{header:N(O.notInIncognito),text:N(O.openIncognito),link:"https://support.google.com/chrome/answer/95464?hl=en&co=GENIE.Platform%3DDesktop"})}>
        </devtools-widget>
      </div>
    `}
  `,i)};class B extends a.Widget.VBox{#e;#l=[];#d=null;constructor(e,t=q){super(e,{useShadowDom:!0}),this.#e=t,this.#l=[{requestId:"1",url:"https://example.com/api/data",requestMethod:"GET",statusCode:200},{requestId:"2",url:"https://example.com/api/submit",requestMethod:"POST",statusCode:404},{requestId:"3",url:"https://example.com/assets/style.css",requestMethod:"GET",statusCode:200}]}async wasShown(){super.wasShown(),o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.#u,this),await this.#u()}willHide(){o.TargetManager.TargetManager.instance().removeModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.#u,this),super.willHide()}async#u(){const e=o.TargetManager.TargetManager.instance().primaryPageTarget();if(!e)return this.#d=null,void this.requestUpdate();const t=e.model(o.NetworkManager.NetworkManager);if(!t)return this.#d=null,void this.requestUpdate();const i=await t.getIpProtectionProxyStatus();this.#d=i,this.requestUpdate()}get proxyRequests(){return this.#l}performUpdate(){const e={status:this.#d,proxyRequests:this.#l};this.#e(e,this,this.contentElement)}}var G=Object.freeze({__proto__:null,DEFAULT_VIEW:q,IPProtectionView:B,i18nString:N});const j={theSecurityOfThisPageIsUnknown:"The security of this page is unknown.",thisPageIsNotSecure:"This page is not secure.",thisPageIsSecureValidHttps:"This page is secure (valid HTTPS).",thisPageIsNotSecureBrokenHttps:"This page is not secure (broken HTTPS).",cipherWithMAC:"{PH1} with {PH2}",keyExchangeWithGroup:"{PH1} with {PH2}"},W=s.i18n.registerUIStrings("panels/security/SecurityModel.ts",j),_=s.i18n.getLocalizedString.bind(void 0,W),K=s.i18n.getLazilyComputedLocalizedString.bind(void 0,W);class X extends o.SDKModel.SDKModel{dispatcher;securityAgent;constructor(e){super(e),this.dispatcher=new se(this),this.securityAgent=e.securityAgent(),e.registerSecurityDispatcher(this.dispatcher),this.securityAgent.invoke_enable()}resourceTreeModel(){return this.target().model(o.ResourceTreeModel.ResourceTreeModel)}networkManager(){return this.target().model(o.NetworkManager.NetworkManager)}}function Y(e,t){const i=["info","insecure-broken","insecure","neutral","secure","unknown"];return i.indexOf(e)-i.indexOf(t)}var J;o.SDKModel.SDKModel.register(X,{capabilities:512,autostart:!1}),function(e){e.VisibleSecurityStateChanged="VisibleSecurityStateChanged"}(J||(J={}));const Q={unknown:K(j.theSecurityOfThisPageIsUnknown),insecure:K(j.thisPageIsNotSecure),neutral:K(j.thisPageIsNotSecure),secure:K(j.thisPageIsSecureValidHttps),"insecure-broken":K(j.thisPageIsNotSecureBrokenHttps)};class Z{securityState;certificateSecurityState;safetyTipInfo;securityStateIssueIds;constructor(e,t,i,s){this.securityState=e,this.certificateSecurityState=t?new ee(t):null,this.safetyTipInfo=i?new te(i):null,this.securityStateIssueIds=s}}class ee{protocol;keyExchange;keyExchangeGroup;cipher;mac;certificate;subjectName;issuer;validFrom;validTo;certificateNetworkError;certificateHasWeakSignature;certificateHasSha1Signature;modernSSL;obsoleteSslProtocol;obsoleteSslKeyExchange;obsoleteSslCipher;obsoleteSslSignature;constructor(e){this.protocol=e.protocol,this.keyExchange=e.keyExchange,this.keyExchangeGroup=e.keyExchangeGroup||null,this.cipher=e.cipher,this.mac=e.mac||null,this.certificate=e.certificate,this.subjectName=e.subjectName,this.issuer=e.issuer,this.validFrom=e.validFrom,this.validTo=e.validTo,this.certificateNetworkError=e.certificateNetworkError||null,this.certificateHasWeakSignature=e.certificateHasWeakSignature,this.certificateHasSha1Signature=e.certificateHasSha1Signature,this.modernSSL=e.modernSSL,this.obsoleteSslProtocol=e.obsoleteSslProtocol,this.obsoleteSslKeyExchange=e.obsoleteSslKeyExchange,this.obsoleteSslCipher=e.obsoleteSslCipher,this.obsoleteSslSignature=e.obsoleteSslSignature}isCertificateExpiringSoon(){const e=new Date(1e3*this.validTo).getTime();return e<new Date(Date.now()).setHours(48)&&e>Date.now()}getKeyExchangeName(){return this.keyExchangeGroup?this.keyExchange?_(j.keyExchangeWithGroup,{PH1:this.keyExchange,PH2:this.keyExchangeGroup}):this.keyExchangeGroup:this.keyExchange}getCipherFullName(){return this.mac?_(j.cipherWithMAC,{PH1:this.cipher,PH2:this.mac}):this.cipher}}class te{safetyTipStatus;safeUrl;constructor(e){this.safetyTipStatus=e.safetyTipStatus,this.safeUrl=e.safeUrl||null}}class ie{securityState;title;summary;description;certificate;mixedContentType;recommendations;constructor(e,t,i,s,r=[],o="none",n=[]){this.securityState=e,this.title=t,this.summary=i,this.description=s,this.certificate=r,this.mixedContentType=o,this.recommendations=n}}class se{model;constructor(e){this.model=e}securityStateChanged(e){}visibleSecurityStateChanged({visibleSecurityState:e}){const t=new Z(e.securityState,e.certificateSecurityState||null,e.safetyTipInfo||null,e.securityStateIssueIds);this.model.dispatchEventToListeners(J.VisibleSecurityStateChanged,t)}certificateError(e){}}var re=Object.freeze({__proto__:null,CertificateSecurityState:ee,get Events(){return J},PageVisibleSecurityState:Z,SecurityModel:X,SecurityStyleExplanation:ie,SummaryMessages:Q,securityStateCompare:Y}),oe=`.lock-icon,\n.security-property{height:var(--sys-size-9);width:var(--sys-size-9)}.lock-icon-secure{color:var(--sys-color-green)}.lock-icon-insecure{color:var(--sys-color-error)}.lock-icon-insecure-broken{color:var(--sys-color-error)}.security-property-secure{color:var(--sys-color-green)}.security-property-neutral{color:var(--sys-color-error)}.security-property-insecure{color:var(--sys-color-error)}.security-property-insecure-broken{color:var(--sys-color-error)}.security-property-info{color:var(--sys-color-on-surface-subtle)}.security-property-unknown{color:var(--sys-color-on-surface-subtle)}.url-scheme-secure{color:var(--sys-color-green)}.url-scheme-neutral,\n.url-scheme-insecure,\n.url-scheme-insecure-broken{color:var(--sys-color-error)}\n/*# sourceURL=${import.meta.resolve("./lockIcon.css")} */`,ne=`.devtools-link{display:inline-block}.security-main-view{overflow:hidden auto;background-color:var(--sys-color-cdt-base-container)}.security-main-view > div{flex-shrink:0}.security-summary-section-title{font-size:15px;margin:12px 16px;user-select:text}.lock-spectrum{margin:8px 16px;display:flex;align-items:flex-start}.security-summary .lock-icon{flex:none;width:16px;height:16px;margin:0}.security-summary .lock-icon-neutral{margin:0 16px}.security-summary:not(.security-summary-secure) .lock-icon-secure,\n.security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n.security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n.security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken{color:var(--sys-color-state-disabled)}@media (forced-colors: active){.security-summary-neutral .lock-icon-neutral{color:Highlight}.security-summary:not(.security-summary-secure) .lock-icon-secure,\n  .security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n  .security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n  .security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken{color:canvastext}}.triangle-pointer-container{margin:8px 24px 0;padding:0}.triangle-pointer-wrapper{transform:translateX(0);transition:transform 0.3s}.triangle-pointer{width:12px;height:12px;margin-bottom:-6px;margin-left:-6px;transform:rotate(-45deg);border-style:solid;border-width:1px 1px 0 0;background:var(--sys-color-cdt-base-container);border-color:var(--sys-color-neutral-outline)}.security-summary-secure .triangle-pointer-wrapper{transform:translateX(0)}.security-summary-neutral .triangle-pointer-wrapper{transform:translateX(32px)}.security-summary-insecure .triangle-pointer-wrapper{transform:translateX(64px)}.security-summary-insecure-broken .triangle-pointer-wrapper{transform:translateX(64px)}.security-summary-text{padding:16px 24px;border-style:solid;border-width:1px 0;font-size:15px;background:var(--sys-color-cdt-base-container);border-color:var(--sys-color-neutral-outline);user-select:text}.security-summary-secure .triangle-pointer,\n.security-summary-secure .security-summary-text,\n.security-explanation-title-secure{color:var(--sys-color-green)}.security-summary-insecure-broken .triangle-pointer,\n.security-summary-insecure-broken .security-summary-text,\n.security-explanation-title-neutral,\n.security-explanation-title-insecure,\n.security-explanation-title-insecure-broken{color:var(--sys-color-error)}.security-explanation-list{padding-bottom:16px}.security-explanation-list:empty{border-bottom:none;padding:0}.security-explanations-main{margin-top:-5px;background-color:var(--sys-color-cdt-base-container);border-bottom:1px solid var(--sys-color-divider)}.security-explanations-extra{background-color:transparent}.security-explanation{padding:11px;display:flex;white-space:nowrap;border:none;color:var(--sys-color-token-subtle)}.security-explanation-text{flex:auto;white-space:normal;max-width:400px}.origin-button{margin-top:var(--sys-size-4)}.security-explanation .security-property{flex:none;width:16px;height:16px;margin-right:16px}.security-explanation-title{color:var(--sys-color-token-subtle);margin-top:1px;margin-bottom:8px}.security-mixed-content{margin-top:8px}.security-explanation-recommendations{padding-inline-start:16px}.security-explanation-recommendations > li{margin-bottom:4px}\n/*# sourceURL=${import.meta.resolve("./mainView.css")} */`;class ae extends a.TreeOutline.TreeElement{constructor(e="",t=!1,i){super(e,t,i),a.ARIAUtils.setLabel(this.listItemElement,e)}get elemId(){return"overview"}showElement(){throw new Error("Unimplemented Method")}onselect(e){if(e){const e=this.elemId;this.listItemElement.dispatchEvent(new CustomEvent("update-sidebar-selection",{bubbles:!0,composed:!0,detail:{id:e}})),this.showElement()}return!1}}class ce extends Event{static eventName="showorigin";origin;constructor(e){super(ce.eventName,{bubbles:!0,composed:!0}),this.origin=e}}class le extends ae{#h;#p;#g=null;constructor(e,t,i=null){super(),this.#p=t,this.#g=i,this.listItemElement.classList.add(e),this.#h=null,this.setSecurityState("unknown")}setSecurityState(e){this.#h=e,this.#p(this)}securityState(){return this.#h}origin(){return this.#g}showElement(){this.listItemElement.dispatchEvent(new ce(this.#g))}}var de=`.title-section{padding:16px 0 24px;border-bottom:1px solid var(--sys-color-divider)}.title-section-header{padding-left:16px;padding-bottom:10px;font-size:14px}.security-origin-view{overflow:hidden scroll;display:block;user-select:text}.security-origin-view .origin-view-section{border-bottom:1px solid var(--sys-color-divider);padding:12px 6px 12px 24px;font-size:12px}.origin-view-notes{margin-top:2px;color:var(--sys-color-token-subtle)}.origin-view-section-notes{margin-top:6px;color:var(--sys-color-token-subtle)}.security-origin-view .origin-display{font-size:12px;padding-left:var(--sys-size-8);display:flex;align-items:center}.title-section > .view-network-button{padding:6px 0 0 16px}.security-origin-view .origin-display devtools-icon{width:var(--sys-size-8);height:var(--sys-size-8);margin-right:var(--sys-size-6)}.security-origin-view .origin-view-section-title{margin-top:4px;margin-bottom:4px;font-weight:bold}.security-origin-view .details-table{border-spacing:0}.security-origin-view .details-table-row{white-space:nowrap;overflow:hidden;line-height:22px;vertical-align:top}.security-origin-view .details-table-row > td{padding:0}.security-origin-view .details-table-row > td:first-child{color:var(--sys-color-token-subtle);width:calc(120px + 1em);text-align:right;padding-right:1em}.security-origin-view .details-table-row > td:nth-child(2){white-space:normal}.security-origin-view .sct-details .details-table .details-table-row:last-child td:last-child{border-bottom:1px solid var(--sys-color-divider);padding-bottom:10px}.security-origin-view .sct-details .details-table:last-child .details-table-row:last-child td:last-child{border-bottom:none;padding-bottom:0}.security-origin-view .details-toggle{margin-left:126px}.security-origin-view .sct-toggle{margin-left:145px;padding-top:5px}.security-origin-view .details-table .empty-san{color:var(--sys-color-state-disabled)}.security-origin-view .details-table .san-entry{display:block}.security-origin-view .truncated-san .truncated-entry{display:none}.origin-view-section:last-child{border-bottom:none}.devtools-link{display:inline-flex}\n/*# sourceURL=${import.meta.resolve("./originView.css")} */`;class ue extends ae{constructor(e,t){super(e,!1,t),this.setLeadingIcons([m.Icon.create("gear","cookie-icon")])}get elemId(){return"controls"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showFlagControls",{bubbles:!0,composed:!0}))}}class he extends ae{constructor(e,t){super(e,!1,t),this.setLeadingIcons([m.Icon.create("cookie","cookie-icon")])}get elemId(){return"report"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showCookieReport",{bubbles:!0,composed:!0}))}}class pe extends ae{constructor(e,t){super(e,!1,t),this.setLeadingIcons([m.Icon.create("shield","shield-icon")])}get elemId(){return"protection"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showIPProtection",{bubbles:!0,composed:!0}))}}var ge=`.tree-outline-disclosure{width:100%}.tree-outline li.security-group-list-item{& + ol{padding-left:0}&::before{display:none}&:not(:first-child){margin-top:var(--sys-size-6)}}.security-main-view-reload-message{color:var(--sys-color-token-subtle)}.tree-outline li.security-sidebar-origins + .children > li{&.selected{.url-scheme-secure{color:var(--sys-color-green)}.url-scheme-neutral,\n    .url-scheme-insecure,\n    .url-scheme-insecure-broken{color:var(--sys-color-error)}}}.security-main-view-reload-message,\n.tree-outline li.security-sidebar-origins,\n.tree-outline li.security-group-list-item,\n.tree-outline span{font:var(--sys-typescale-body4-medium);&:hover:not(:has(devtools-checkbox)) .selection{background:transparent}}.tree-outline li{& .leading-icons{flex:none}& .tree-element-title,\n  .highlighted-url,\n  .title{overflow:hidden;text-overflow:ellipsis}}\n/*# sourceURL=${import.meta.resolve("./sidebar.css")} */`;const me={security:"Security",privacy:"Privacy",cookieReport:"Third-party cookies",flagControls:"Controls",ipProtection:"IP Protection",mainOrigin:"Main origin",nonsecureOrigins:"Non-secure origins",secureOrigins:"Secure origins",unknownCanceled:"Unknown / canceled",overview:"Overview",reloadToViewDetails:"Reload to view details"},ye=s.i18n.registerUIStrings("panels/security/SecurityPanelSidebar.ts",me),ve=s.i18n.getLocalizedString.bind(void 0,ye);class we extends a.Widget.VBox{#m;sidebarTree;#y;#v;securityOverviewElement;#w;cookieReportTreeElement;ipProtectionTreeElement;#b;#S;#f;constructor(e){if(super(e),this.#m=t.Settings.Settings.instance().createSetting("security-last-selected-element-path",""),this.#f=null,this.sidebarTree=new a.TreeOutline.TreeOutlineInShadow("NavigationTree"),this.sidebarTree.registerRequiredCSS(oe,ge),this.sidebarTree.element.classList.add("security-sidebar"),this.contentElement.appendChild(this.sidebarTree.element),r.Runtime.hostConfig.devToolsPrivacyUI?.enabled){const e=this.#k(ve(me.privacy),"privacy");this.#w=new ue(ve(me.flagControls),"cookie-flag-controls"),e.appendChild(this.#w),this.cookieReportTreeElement=new he(ve(me.cookieReport),"cookie-report"),e.appendChild(this.cookieReportTreeElement),r.Runtime.hostConfig.devToolsIpProtectionPanelInDevTools?.enabled&&(this.ipProtectionTreeElement=new pe(ve(me.ipProtection),"ip-protection"),e.appendChild(this.ipProtectionTreeElement)),""===this.#m.get()&&this.#m.set(this.#w.elemId)}const i=ve(me.security),s=this.#k(i,"security");this.securityOverviewElement=new le("security-main-view-sidebar-tree-item",this.#p),this.securityOverviewElement.tooltip=ve(me.overview),s.appendChild(this.securityOverviewElement),this.#y=new Map([[Le.MainOrigin,{title:ve(me.mainOrigin)}],[Le.NonSecure,{title:ve(me.nonsecureOrigins),icon:Pe("insecure","lock-icon lock-icon-insecure")}],[Le.Secure,{title:ve(me.secureOrigins),icon:Pe("secure","lock-icon lock-icon-secure")}],[Le.Unknown,{title:ve(me.unknownCanceled),icon:Pe("unknown","lock-icon lock-icon-unknown")}]]),this.#v=new Map;for(const e of Object.values(Le)){const t=this.#x(this.#y.get(e)?.title,this.#y.get(e)?.icon);this.#v.set(e,t),s.appendChild(t)}this.#S=new a.TreeOutline.TreeElement(ve(me.reloadToViewDetails)),this.#S.selectable=!1,this.#S.listItemElement.classList.add("security-main-view-reload-message");this.#v.get(Le.MainOrigin).appendChild(this.#S),this.#C(),this.#b=new Map,this.element.addEventListener("update-sidebar-selection",e=>{const t=e.detail.id;this.#m.set(t)}),this.showLastSelectedElement()}showLastSelectedElement(){this.#w&&this.#m.get()===this.#w.elemId?(this.#w.select(),this.#w.showElement()):this.cookieReportTreeElement&&this.#m.get()===this.cookieReportTreeElement.elemId?(this.cookieReportTreeElement.select(),this.cookieReportTreeElement.showElement()):this.ipProtectionTreeElement&&this.#m.get()===this.ipProtectionTreeElement.elemId?(this.ipProtectionTreeElement.select(),this.ipProtectionTreeElement.showElement()):(this.securityOverviewElement.select(),this.securityOverviewElement.showElement())}#k(e,t){const i=new a.TreeOutline.TreeElement(e,!0,t);return i.listItemElement.classList.add("security-group-list-item"),i.setCollapsible(!1),i.selectable=!1,this.sidebarTree.appendChild(i),a.ARIAUtils.markAsHeading(i.listItemElement,3),a.ARIAUtils.setLabel(i.childrenListElement,e),i}#T(e){return this.#y.get(e)?.title}#E(e){return this.#v.get(e)}#x(e,t){const i=new a.TreeOutline.TreeElement(e,!0);return i.selectable=!1,i.expand(),i.listItemElement.classList.add("security-sidebar-origins"),t&&i.setLeadingIcons([t]),a.ARIAUtils.setLabel(i.childrenListElement,e),i}toggleOriginsList(e){for(const t of this.#v.values())t.hidden=e}addOrigin(e,t){this.#S.hidden=!0;const i=new le("security-sidebar-tree-item",this.#p,e);i.tooltip=e,this.#b.set(e,i),this.updateOrigin(e,t)}setMainOrigin(e){this.#f=e}get mainOrigin(){return this.#f}get originGroups(){return this.#v}updateOrigin(e,t){const i=this.#b.get(e);let s;if(i.setSecurityState(t),e===this.#f)s=this.#v.get(Le.MainOrigin),s.title=ve(me.mainOrigin),s.setLeadingIcons([Re(t,`lock-icon lock-icon-${t}`)]),a.ARIAUtils.setLabel(s.childrenListElement,s.title);else switch(t){case"secure":s=this.#E(Le.Secure);break;case"unknown":s=this.#E(Le.Unknown);break;default:s=this.#E(Le.NonSecure)}const r=i.parent;r!==s&&(r&&(r.removeChild(i),0===r.childCount()&&(r.hidden=!0)),s.appendChild(i),s.hidden=!1)}#C(){for(const[e,t]of this.#v)if(e===Le.MainOrigin){for(let e=t.childCount()-1;e>0;e--)t.removeChildAtIndex(e);t.title=this.#T(Le.MainOrigin),t.hidden=!1,this.#S.hidden=!1}else t.removeChildren(),t.hidden=!0}clearOrigins(){this.#C(),this.#b.clear()}focus(){this.sidebarTree.focus()}#p(e){if(e instanceof le){const t=e.securityState()??"unknown",i=e.listItemElement.classList.contains("security-main-view-sidebar-tree-item"),s=i?Re(t,`lock-icon lock-icon-${t}`):Pe(t,`security-property security-property-${t}`),r=i?(()=>{const e=document.createElement("span");return e.classList.add("title"),e.textContent=ve(me.overview),e})():Ae(e.origin()??h.DevToolsPath.EmptyUrlString,t);e.setLeadingIcons([s]),e.listItemElement.lastChild&&e.listItemElement.removeChild(e.listItemElement.lastChild),e.listItemElement.appendChild(r)}}}const{widgetConfig:be}=a.Widget,Se={securityOverview:"Security overview",secure:"Secure",info:"Info",notSecure:"Not secure",viewCertificate:"View certificate",notSecureBroken:"Not secure (broken)",thisPageIsDangerousFlaggedBy:"This page is dangerous (flagged by Google Safe Browsing).",flaggedByGoogleSafeBrowsing:"Flagged by Google Safe Browsing",toCheckThisPagesStatusVisit:"To check this page's status, visit g.co/safebrowsingstatus.",thisIsAnErrorPage:"This is an error page.",thisPageIsInsecureUnencrypted:"This page is insecure (unencrypted HTTP).",thisPageHasANonhttpsSecureOrigin:"This page has a non-HTTPS secure origin.",thisPageIsSuspicious:"This page is suspicious",chromeHasDeterminedThatThisSiteS:"Chrome has determined that this site could be fake or fraudulent.",ifYouBelieveThisIsShownIn:"If you believe this is shown in error please visit https://g.co/chrome/lookalike-warnings.",possibleSpoofingUrl:"Possible spoofing URL",thisSitesHostnameLooksSimilarToP:"This site's hostname looks similar to {PH1}. Attackers sometimes mimic sites by making small, hard-to-see changes to the domain name.",ifYouBelieveThisIsShownInErrorSafety:"If you believe this is shown in error please visit https://g.co/chrome/lookalike-warnings.",thisPageIsSuspiciousFlaggedBy:"This page is suspicious (flagged by Chrome).",certificate:"Certificate",insecureSha:"insecure (SHA-1)",theCertificateChainForThisSite:"The certificate chain for this site contains a certificate signed using SHA-1.",subjectAlternativeNameMissing:"`Subject Alternative Name` missing",theCertificateForThisSiteDoesNot:"The certificate for this site does not contain a `Subject Alternative Name` extension containing a domain name or IP address.",missing:"missing",thisSiteIsMissingAValidTrusted:"This site is missing a valid, trusted certificate ({PH1}).",validAndTrusted:"valid and trusted",theConnectionToThisSiteIsUsingA:"The connection to this site is using a valid, trusted server certificate issued by {PH1}.",publickeypinningBypassed:"Public-Key-Pinning bypassed",publickeypinningWasBypassedByA:"Public-Key-Pinning was bypassed by a local root certificate.",certificateExpiresSoon:"Certificate expires soon",theCertificateForThisSiteExpires:"The certificate for this site expires in less than 48 hours and needs to be renewed.",connection:"Connection",secureConnectionSettings:"secure connection settings",theConnectionToThisSiteIs:"The connection to this site is encrypted and authenticated using {PH1}, {PH2}, and {PH3}.",sIsObsoleteEnableTlsOrLater:"{PH1} is obsolete. Enable TLS 1.2 or later.",rsaKeyExchangeIsObsoleteEnableAn:"RSA key exchange is obsolete. Enable an ECDHE-based cipher suite.",sIsObsoleteEnableAnAesgcmbased:"{PH1} is obsolete. Enable an AES-GCM-based cipher suite.",theServerSignatureUsesShaWhichIs:"The server signature uses SHA-1, which is obsolete. Enable a SHA-2 signature algorithm instead. (Note this is different from the signature in the certificate.)",obsoleteConnectionSettings:"obsolete connection settings",resources:"Resources",activeMixedContent:"active mixed content",youHaveRecentlyAllowedNonsecure:"You have recently allowed non-secure content (such as scripts or iframes) to run on this site.",mixedContent:"mixed content",thisPageIncludesHttpResources:"This page includes HTTP resources.",nonsecureForm:"non-secure form",thisPageIncludesAFormWithA:'This page includes a form with a non-secure "action" attribute.',activeContentWithCertificate:"active content with certificate errors",youHaveRecentlyAllowedContent:"You have recently allowed content loaded with certificate errors (such as scripts or iframes) to run on this site.",contentWithCertificateErrors:"content with certificate errors",thisPageIncludesResourcesThat:"This page includes resources that were loaded with certificate errors.",allServedSecurely:"all served securely",allResourcesOnThisPageAreServed:"All resources on this page are served securely.",blockedMixedContent:"Blocked mixed content",yourPageRequestedNonsecure:"Your page requested non-secure resources that were blocked.",reloadThePageToRecordRequestsFor:"Reload the page to record requests for HTTP resources.",viewDRequestsInNetworkPanel:"{n, plural, =1 {View # request in Network Panel} other {View # requests in Network Panel}}",origin:"Origin",viewRequestsInNetworkPanel:"View requests in Network Panel",protocol:"Protocol",keyExchange:"Key exchange",cipher:"Cipher",serverSignature:"Server signature",encryptedClientHello:"Encrypted ClientHello",certificateTransparency:"Certificate Transparency",subject:"Subject",validFrom:"Valid from",validUntil:"Valid until",issuer:"Issuer",openFullCertificateDetails:"Open full certificate details",sct:"SCT",logName:"Log name",logId:"Log ID",validationStatus:"Validation status",source:"Source",issuedAt:"Issued at",hashAlgorithm:"Hash algorithm",signatureAlgorithm:"Signature algorithm",signatureData:"Signature data",showFullDetails:"Show full details",hideFullDetails:"Hide full details",thisRequestCompliesWithChromes:"This request complies with `Chrome`'s Certificate Transparency policy.",thisRequestDoesNotComplyWith:"This request does not comply with `Chrome`'s Certificate Transparency policy.",thisResponseWasLoadedFromCache:"This response was loaded from cache. Some security details might be missing.",theSecurityDetailsAboveAreFrom:"The security details above are from the first inspected response.",thisOriginIsANonhttpsSecure:"This origin is a non-HTTPS secure origin.",yourConnectionToThisOriginIsNot:"Your connection to this origin is not secure.",noSecurityInformation:"No security information",noSecurityDetailsAreAvailableFor:"No security details are available for this origin.",na:"(n/a)",showLess:"Show less",showMoreSTotal:"Show more ({PH1} total)",unknownField:"unknown",enabled:"enabled"},fe=s.i18n.registerUIStrings("panels/security/SecurityPanel.ts",Se),ke=s.i18n.getLocalizedString.bind(void 0,fe);let xe;const Ce=new Map([[513,"RSA with SHA-1"],[1025,"RSA with SHA-256"],[1281,"RSA with SHA-384"],[1537,"RSA with SHA-512"],[1027,"ECDSA with SHA-256"],[1283,"ECDSA with SHA-384"],[2052,"RSA-PSS with SHA-256"],[2053,"RSA-PSS with SHA-384"],[2054,"RSA-PSS with SHA-512"]]),Te="lock",Ee="warning",Ie="indeterminate-question-box";function Pe(e,t){let i;switch(e){case"neutral":case"insecure":case"insecure-broken":i=Ee;break;case"secure":i=Te;break;case"info":case"unknown":i=Ie}return m.Icon.create(i,t)}function Re(e,t){let i;switch(e){case"unknown":case"neutral":i=Ie;break;case"insecure":case"insecure-broken":i=Ee;break;case"secure":i=Te;break;case"info":throw new Error(`Unexpected security state ${e}`)}return m.Icon.create(i,t)}function Ae(e,t){const i="://",s=e.indexOf(i);if(-1===s){const t=document.createElement("span");return t.textContent=e,t}const r=document.createElement("span");r.classList.add("highlighted-url");const o=e.substr(0,s),n=e.substr(s+3);return r.createChild("span","url-scheme-"+t).textContent=o,r.createChild("span","url-scheme-separator").textContent=i,r.createChild("span").textContent=n,r}class Me extends a.Panel.Panel{view;mainView;sidebar;lastResponseReceivedForLoaderId;origins;filterRequestCounts;visibleView;eventListeners;securityModel;splitWidget;constructor(e=(e,t,i)=>{l(d`
    <devtools-split-view direction="column" name="security"
      ${a.Widget.widgetRef(a.SplitWidget.SplitWidget,e=>{t.splitWidget=e})}>
        <devtools-widget
          slot="sidebar"
          .widgetConfig=${be(we)}
          @showIPProtection=${()=>t.setVisibleView(new B)}
          @showCookieReport=${()=>t.setVisibleView(new D)}
          @showFlagControls=${()=>t.setVisibleView(new C)}
          ${a.Widget.widgetRef(we,e=>{t.sidebar=e})}>
        </devtools-widget>
    </devtools-split-view>`,i,{host:this})}){super("security"),this.view=e,this.update(),this.sidebar.setMinimumSize(100,25),this.sidebar.element.classList.add("panel-sidebar"),this.sidebar.element.setAttribute("jslog",`${u.pane("sidebar").track({resize:!0})}`),this.mainView=new De,this.mainView.panel=this,this.element.addEventListener(ce.eventName,e=>{e.origin?this.showOrigin(e.origin):this.setVisibleView(this.mainView)}),this.lastResponseReceivedForLoaderId=new Map,this.origins=new Map,this.filterRequestCounts=new Map,this.visibleView=null,this.eventListeners=[],this.securityModel=null,o.TargetManager.TargetManager.instance().observeModels(X,this,{scoped:!0}),o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.onPrimaryPageChanged,this),this.sidebar.showLastSelectedElement()}static instance(e={forceNew:null}){const{forceNew:t}=e;return xe&&!t||(xe=new Me),xe}static createCertificateViewerButtonForOrigin(e,t){const s=a.UIUtils.createTextButton(e,async e=>{e.consume();const s=await o.NetworkManager.MultitargetNetworkManager.instance().getCertificate(t);s.length>0&&i.InspectorFrontendHost.InspectorFrontendHostInstance.showCertificateViewer(s)},{className:"origin-button",jslogContext:"security.view-certificate-for-origin",title:e});return a.ARIAUtils.markAsButton(s),s}static createCertificateViewerButtonForCert(e,t){const s=a.UIUtils.createTextButton(e,e=>{e.consume(),i.InspectorFrontendHost.InspectorFrontendHostInstance.showCertificateViewer(t)},{className:"origin-button",jslogContext:"security.view-certificate"});return a.ARIAUtils.markAsButton(s),s}update(){this.view({panel:this},this,this.contentElement)}updateVisibleSecurityState(e){this.sidebar.securityOverviewElement.setSecurityState(e.securityState),this.mainView.updateVisibleSecurityState(e)}onVisibleSecurityStateChanged({data:e}){this.updateVisibleSecurityState(e)}showOrigin(e){const t=this.origins.get(e);t&&(t.originView||(t.originView=new Ue(e,t)),this.setVisibleView(t.originView))}wasShown(){super.wasShown(),this.visibleView||this.sidebar.showLastSelectedElement()}focus(){this.sidebar.focus()}setVisibleView(e){this.visibleView!==e&&(this.visibleView&&this.visibleView.detach(),this.visibleView=e,e&&this.splitWidget.setMainWidget(e))}onResponseReceived(e){const i=e.data.request;i.resourceType()===t.ResourceType.resourceTypes.Document&&i.loaderId&&this.lastResponseReceivedForLoaderId.set(i.loaderId,i)}processRequest(e){const i=t.ParsedURL.ParsedURL.extractOrigin(e.url());if(!i)return;let s=e.securityState();"blockable"!==e.mixedContentType&&"optionally-blockable"!==e.mixedContentType||(s="insecure");const r=this.origins.get(i);if(r){if(Y(s,r.securityState)<0){r.securityState=s;const t=e.securityDetails();t&&(r.securityDetails=t),this.sidebar.updateOrigin(i,s),r.originView&&r.originView.setSecurityState(s)}}else{const t={securityState:s,securityDetails:e.securityDetails(),loadedFromCache:e.cached(),originView:void 0};this.origins.set(i,t),this.sidebar.addOrigin(i,s)}}onRequestFinished(e){const t=e.data;this.updateFilterRequestCounts(t),this.processRequest(t)}updateFilterRequestCounts(e){if("none"===e.mixedContentType)return;let t="all";e.wasBlocked()?t="blocked":"blockable"===e.mixedContentType?t="block-overridden":"optionally-blockable"===e.mixedContentType&&(t="displayed");const i=this.filterRequestCounts.get(t);i?this.filterRequestCounts.set(t,i+1):this.filterRequestCounts.set(t,1),this.mainView.refreshExplanations()}filterRequestCount(e){return this.filterRequestCounts.get(e)||0}modelAdded(e){if(e.target()!==e.target().outermostTarget())return;this.securityModel=e;const i=e.resourceTreeModel(),s=e.networkManager();this.eventListeners.length&&t.EventTarget.removeEventListeners(this.eventListeners),this.eventListeners=[e.addEventListener(J.VisibleSecurityStateChanged,this.onVisibleSecurityStateChanged,this),i.addEventListener(o.ResourceTreeModel.Events.InterstitialShown,this.onInterstitialShown,this),i.addEventListener(o.ResourceTreeModel.Events.InterstitialHidden,this.onInterstitialHidden,this),s.addEventListener(o.NetworkManager.Events.ResponseReceived,this.onResponseReceived,this),s.addEventListener(o.NetworkManager.Events.RequestFinished,this.onRequestFinished,this)],i.isInterstitialShowing&&this.onInterstitialShown()}modelRemoved(e){this.securityModel===e&&(this.securityModel=null,t.EventTarget.removeEventListeners(this.eventListeners))}onPrimaryPageChanged(e){const{frame:i}=e.data,s=this.lastResponseReceivedForLoaderId.get(i.loaderId);this.sidebar.showLastSelectedElement(),this.sidebar.clearOrigins(),this.origins.clear(),this.lastResponseReceivedForLoaderId.clear(),this.filterRequestCounts.clear(),this.mainView.refreshExplanations();const r=t.ParsedURL.ParsedURL.extractOrigin(s?s.url():i.url);this.sidebar.setMainOrigin(r),s&&this.processRequest(s)}onInterstitialShown(){this.sidebar.showLastSelectedElement(),this.sidebar.toggleOriginsList(!0)}onInterstitialHidden(){this.sidebar.toggleOriginsList(!1)}}var Le;!function(e){e.MainOrigin="MainOrigin",e.NonSecure="NonSecure",e.Secure="Secure",e.Unknown="Unknown"}(Le||(Le={}));class De extends a.Widget.VBox{panel;summarySection;securityExplanationsMain;securityExplanationsExtra;lockSpectrum;summaryText;explanations;securityState;constructor(e){super(e,{jslog:`${u.pane("security.main-view")}`}),this.registerRequiredCSS(oe,ne),this.setMinimumSize(200,100),this.contentElement.classList.add("security-main-view"),this.summarySection=this.contentElement.createChild("div","security-summary"),this.securityExplanationsMain=this.contentElement.createChild("div","security-explanation-list security-explanations-main"),this.securityExplanationsExtra=this.contentElement.createChild("div","security-explanation-list security-explanations-extra");const t=this.summarySection.createChild("div","security-summary-section-title");t.textContent=ke(Se.securityOverview),a.ARIAUtils.markAsHeading(t,1);const i=this.summarySection.createChild("div","lock-spectrum");this.lockSpectrum=new Map([["secure",i.appendChild(Re("secure","lock-icon lock-icon-secure"))],["neutral",i.appendChild(Re("neutral","lock-icon lock-icon-neutral"))],["insecure",i.appendChild(Re("insecure","lock-icon lock-icon-insecure"))]]),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("secure"),ke(Se.secure)),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("neutral"),ke(Se.info)),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),ke(Se.notSecure)),this.summarySection.createChild("div","triangle-pointer-container").createChild("div","triangle-pointer-wrapper").createChild("div","triangle-pointer"),this.summaryText=this.summarySection.createChild("div","security-summary-text"),a.ARIAUtils.markAsHeading(this.summaryText,2),this.explanations=null,this.securityState=null}getLockSpectrumDiv(e){const t=this.lockSpectrum.get(e);if(!t)throw new Error(`Invalid argument: ${e}`);return t}addExplanation(e,t){const i=e.createChild("div","security-explanation");i.classList.add("security-explanation-"+t.securityState);const s=Pe(t.securityState,"security-property security-property-"+t.securityState);i.appendChild(s);const r=i.createChild("div","security-explanation-text"),o=r.createChild("div","security-explanation-title");if(t.title?(o.createChild("span").textContent=t.title+" - ",o.createChild("span","security-explanation-title-"+t.securityState).textContent=t.summary):o.textContent=t.summary,r.createChild("div").textContent=t.description,t.certificate.length&&r.appendChild(Me.createCertificateViewerButtonForCert(ke(Se.viewCertificate),t.certificate)),t.recommendations?.length){const e=r.createChild("ul","security-explanation-recommendations");for(const i of t.recommendations)e.createChild("li").textContent=i}return r}updateVisibleSecurityState(e){this.summarySection.classList.remove("security-summary-"+this.securityState),this.securityState=e.securityState,this.summarySection.classList.add("security-summary-"+this.securityState),"insecure"===this.securityState?(this.getLockSpectrumDiv("insecure").classList.add("lock-icon-insecure"),this.getLockSpectrumDiv("insecure").classList.remove("lock-icon-insecure-broken"),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),ke(Se.notSecure))):"insecure-broken"===this.securityState&&(this.getLockSpectrumDiv("insecure").classList.add("lock-icon-insecure-broken"),this.getLockSpectrumDiv("insecure").classList.remove("lock-icon-insecure"),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),ke(Se.notSecureBroken)));const{summary:t,explanations:i}=this.getSecuritySummaryAndExplanations(e);this.summaryText.textContent=t||Q[this.securityState](),this.explanations=this.orderExplanations(i),this.refreshExplanations()}getSecuritySummaryAndExplanations(e){const{securityState:t,securityStateIssueIds:i}=e;let s;const r=[];if(s=this.explainSafetyTipSecurity(e,s,r),i.includes("malicious-content"))s=ke(Se.thisPageIsDangerousFlaggedBy),r.unshift(new ie("insecure",void 0,ke(Se.flaggedByGoogleSafeBrowsing),ke(Se.toCheckThisPagesStatusVisit)));else{if(i.includes("is-error-page")&&null===e.certificateSecurityState?.certificateNetworkError)return s=ke(Se.thisIsAnErrorPage),{summary:s,explanations:r};"insecure-broken"===t&&i.includes("scheme-is-not-cryptographic")&&(s=s||ke(Se.thisPageIsInsecureUnencrypted))}return i.includes("scheme-is-not-cryptographic")?("neutral"!==t||i.includes("insecure-origin")||(s=ke(Se.thisPageHasANonhttpsSecureOrigin)),{summary:s,explanations:r}):(this.explainCertificateSecurity(e,r),this.explainConnectionSecurity(e,r),this.explainContentSecurity(e,r),{summary:s,explanations:r})}explainSafetyTipSecurity(e,t,i){const{securityStateIssueIds:s,safetyTipInfo:r}=e,o=[];if(s.includes("bad_reputation")){const e=`${ke(Se.chromeHasDeterminedThatThisSiteS)}\n\n${ke(Se.ifYouBelieveThisIsShownIn)}`;o.push({summary:ke(Se.thisPageIsSuspicious),description:e})}else if(s.includes("lookalike")&&r?.safeUrl){const e=new URL(r.safeUrl).hostname,t=`${ke(Se.thisSitesHostnameLooksSimilarToP,{PH1:e})}\n\n${ke(Se.ifYouBelieveThisIsShownInErrorSafety)}`;o.push({summary:ke(Se.possibleSpoofingUrl),description:t})}return o.length>0&&(t=t||ke(Se.thisPageIsSuspiciousFlaggedBy),i.push(new ie("insecure",void 0,o[0].summary,o[0].description))),t}explainCertificateSecurity(e,t){const{certificateSecurityState:i,securityStateIssueIds:s}=e,r=ke(Se.certificate);if(i?.certificateHasSha1Signature){const e=ke(Se.insecureSha),s=ke(Se.theCertificateChainForThisSite);i.certificateHasWeakSignature?t.push(new ie("insecure",r,e,s,i.certificate,"none")):t.push(new ie("neutral",r,e,s,i.certificate,"none"))}i&&s.includes("cert-missing-subject-alt-name")&&t.push(new ie("insecure",r,ke(Se.subjectAlternativeNameMissing),ke(Se.theCertificateForThisSiteDoesNot),i.certificate,"none")),i&&null!==i.certificateNetworkError?t.push(new ie("insecure",r,ke(Se.missing),ke(Se.thisSiteIsMissingAValidTrusted,{PH1:i.certificateNetworkError}),i.certificate,"none")):i&&!i.certificateHasSha1Signature&&t.push(new ie("secure",r,ke(Se.validAndTrusted),ke(Se.theConnectionToThisSiteIsUsingA,{PH1:i.issuer}),i.certificate,"none")),s.includes("pkp-bypassed")&&t.push(new ie("info",r,ke(Se.publickeypinningBypassed),ke(Se.publickeypinningWasBypassedByA))),i?.isCertificateExpiringSoon()&&t.push(new ie("info",void 0,ke(Se.certificateExpiresSoon),ke(Se.theCertificateForThisSiteExpires)))}explainConnectionSecurity(e,t){const i=e.certificateSecurityState;if(!i)return;const s=ke(Se.connection);if(i.modernSSL)return void t.push(new ie("secure",s,ke(Se.secureConnectionSettings),ke(Se.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()})));const r=[];i.obsoleteSslProtocol&&r.push(ke(Se.sIsObsoleteEnableTlsOrLater,{PH1:i.protocol})),i.obsoleteSslKeyExchange&&r.push(ke(Se.rsaKeyExchangeIsObsoleteEnableAn)),i.obsoleteSslCipher&&r.push(ke(Se.sIsObsoleteEnableAnAesgcmbased,{PH1:i.cipher})),i.obsoleteSslSignature&&r.push(ke(Se.theServerSignatureUsesShaWhichIs)),t.push(new ie("info",s,ke(Se.obsoleteConnectionSettings),ke(Se.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()}),void 0,void 0,r))}explainContentSecurity(e,t){let i=!0;const s=ke(Se.resources),r=e.securityStateIssueIds;r.includes("ran-mixed-content")&&(i=!1,t.push(new ie("insecure",s,ke(Se.activeMixedContent),ke(Se.youHaveRecentlyAllowedNonsecure),[],"blockable"))),r.includes("displayed-mixed-content")&&(i=!1,t.push(new ie("neutral",s,ke(Se.mixedContent),ke(Se.thisPageIncludesHttpResources),[],"optionally-blockable"))),r.includes("contained-mixed-form")&&(i=!1,t.push(new ie("neutral",s,ke(Se.nonsecureForm),ke(Se.thisPageIncludesAFormWithA)))),null===e.certificateSecurityState?.certificateNetworkError&&(r.includes("ran-content-with-cert-error")&&(i=!1,t.push(new ie("insecure",s,ke(Se.activeContentWithCertificate),ke(Se.youHaveRecentlyAllowedContent)))),r.includes("displayed-content-with-cert-errors")&&(i=!1,t.push(new ie("neutral",s,ke(Se.contentWithCertificateErrors),ke(Se.thisPageIncludesResourcesThat))))),i&&(r.includes("scheme-is-not-cryptographic")||t.push(new ie("secure",s,ke(Se.allServedSecurely),ke(Se.allResourcesOnThisPageAreServed))))}orderExplanations(e){if(0===e.length)return e;const t=["insecure","neutral","secure","info"],i=[];for(const s of t)i.push(...e.filter(e=>e.securityState===s));return i}refreshExplanations(){if(this.securityExplanationsMain.removeChildren(),this.securityExplanationsExtra.removeChildren(),this.explanations){for(const e of this.explanations)if("info"===e.securityState)this.addExplanation(this.securityExplanationsExtra,e);else switch(e.mixedContentType){case"blockable":this.addMixedContentExplanation(this.securityExplanationsMain,e,"block-overridden");break;case"optionally-blockable":this.addMixedContentExplanation(this.securityExplanationsMain,e,"displayed");break;default:this.addExplanation(this.securityExplanationsMain,e)}if(this.panel.filterRequestCount("blocked")>0){const e={securityState:"info",summary:ke(Se.blockedMixedContent),description:ke(Se.yourPageRequestedNonsecure),mixedContentType:"blockable",certificate:[],title:""};this.addMixedContentExplanation(this.securityExplanationsMain,e,"blocked")}}}addMixedContentExplanation(e,t,i){const s=this.addExplanation(e,t),r=this.panel.filterRequestCount(i);if(!r){return void(s.createChild("div","security-mixed-content").textContent=ke(Se.reloadThePageToRecordRequestsFor))}const o=s.createChild("button","security-mixed-content devtools-link text-button link-style");a.ARIAUtils.markAsLink(o),o.tabIndex=0,o.textContent=ke(Se.viewDRequestsInNetworkPanel,{n:r}),o.addEventListener("click",this.showNetworkFilter.bind(this,i))}showNetworkFilter(e,i){i.consume(),t.Revealer.reveal(g.UIFilter.UIRequestFilter.filters([{filterType:g.UIFilter.FilterType.MixedContent,filterValue:e}]))}}class Ue extends a.Widget.VBox{originLockIcon;constructor(e,i){super({jslog:`${u.pane("security.origin-view")}`}),this.registerRequiredCSS(de,oe),this.setMinimumSize(200,100),this.element.classList.add("security-origin-view");const r=this.element.createChild("div","title-section"),o=r.createChild("div","title-section-header");o.textContent=ke(Se.origin),a.ARIAUtils.markAsHeading(o,1);const n=r.createChild("div","origin-display");this.originLockIcon=n.createChild("span");const c=Pe(i.securityState,`security-property security-property-${i.securityState}`);this.originLockIcon.appendChild(c),n.appendChild(Ae(e,i.securityState));const l=r.createChild("div","view-network-button"),d=a.UIUtils.createTextButton(ke(Se.viewRequestsInNetworkPanel),i=>{i.consume();const s=new t.ParsedURL.ParsedURL(e);t.Revealer.reveal(g.UIFilter.UIRequestFilter.filters([{filterType:g.UIFilter.FilterType.Domain,filterValue:s.host},{filterType:g.UIFilter.FilterType.Scheme,filterValue:s.scheme}]))},{jslogContext:"reveal-in-network"});if(l.appendChild(d),a.ARIAUtils.markAsLink(d),i.securityDetails){const h=this.element.createChild("div","origin-view-section"),p=h.createChild("div","origin-view-section-title");p.textContent=ke(Se.connection),a.ARIAUtils.markAsHeading(p,2);let m=new He;if(h.appendChild(m.element()),m.addRow(ke(Se.protocol),i.securityDetails.protocol),i.securityDetails.keyExchange&&i.securityDetails.keyExchangeGroup?m.addRow(ke(Se.keyExchange),i.securityDetails.keyExchange+" with "+i.securityDetails.keyExchangeGroup):i.securityDetails.keyExchange?m.addRow(ke(Se.keyExchange),i.securityDetails.keyExchange):i.securityDetails.keyExchangeGroup&&m.addRow(ke(Se.keyExchange),i.securityDetails.keyExchangeGroup),i.securityDetails.serverSignatureAlgorithm){let I=Ce.get(i.securityDetails.serverSignatureAlgorithm);I??=ke(Se.unknownField)+" ("+i.securityDetails.serverSignatureAlgorithm+")",m.addRow(ke(Se.serverSignature),I)}m.addRow(ke(Se.cipher),i.securityDetails.cipher+(i.securityDetails.mac?" with "+i.securityDetails.mac:"")),i.securityDetails.encryptedClientHello&&m.addRow(ke(Se.encryptedClientHello),ke(Se.enabled));const y=this.element.createChild("div","origin-view-section"),v=y.createChild("div","origin-view-section-title");v.textContent=ke(Se.certificate),a.ARIAUtils.markAsHeading(v,2);const w=i.securityDetails.signedCertificateTimestampList.length,b=i.securityDetails.certificateTransparencyCompliance;let S;if(w||"unknown"!==b){S=this.element.createChild("div","origin-view-section");const P=S.createChild("div","origin-view-section-title");P.textContent=ke(Se.certificateTransparency),a.ARIAUtils.markAsHeading(P,2)}const f=this.createSanDiv(i.securityDetails.sanList),k=new Date(1e3*i.securityDetails.validFrom).toUTCString(),x=new Date(1e3*i.securityDetails.validTo).toUTCString();if(m=new He,y.appendChild(m.element()),m.addRow(ke(Se.subject),i.securityDetails.subjectName),m.addRow(s.i18n.lockedString("SAN"),f),m.addRow(ke(Se.validFrom),k),m.addRow(ke(Se.validUntil),x),m.addRow(ke(Se.issuer),i.securityDetails.issuer),m.addRow("",Me.createCertificateViewerButtonForOrigin(ke(Se.openFullCertificateDetails),e)),!S)return;const C=new He;C.element().classList.add("sct-summary"),S.appendChild(C.element());for(let R=0;R<w;R++){const A=i.securityDetails.signedCertificateTimestampList[R];C.addRow(ke(Se.sct),A.logDescription+" ("+A.origin+", "+A.status+")")}const T=S.createChild("div","sct-details");T.classList.add("hidden");for(let M=0;M<w;M++){const L=new He;T.appendChild(L.element());const D=i.securityDetails.signedCertificateTimestampList[M];L.addRow(ke(Se.logName),D.logDescription),L.addRow(ke(Se.logId),D.logId.replace(/(.{2})/g,"$1 ")),L.addRow(ke(Se.validationStatus),D.status),L.addRow(ke(Se.source),D.origin),L.addRow(ke(Se.issuedAt),new Date(D.timestamp).toUTCString()),L.addRow(ke(Se.hashAlgorithm),D.hashAlgorithm),L.addRow(ke(Se.signatureAlgorithm),D.signatureAlgorithm),L.addRow(ke(Se.signatureData),D.signatureData.replace(/(.{2})/g,"$1 "))}if(w){function U(){let e;const t=!T.classList.contains("hidden");e=ke(t?Se.showFullDetails:Se.hideFullDetails),H.textContent=e,a.ARIAUtils.setLabel(H,e),a.ARIAUtils.setExpanded(H,!t),C.element().classList.toggle("hidden"),T.classList.toggle("hidden")}const H=a.UIUtils.createTextButton(ke(Se.showFullDetails),U,{className:"details-toggle",jslogContext:"security.toggle-scts-details"});S.appendChild(H)}switch(b){case"compliant":S.createChild("div","origin-view-section-notes").textContent=ke(Se.thisRequestCompliesWithChromes);break;case"not-compliant":S.createChild("div","origin-view-section-notes").textContent=ke(Se.thisRequestDoesNotComplyWith)}const E=this.element.createChild("div","origin-view-section origin-view-notes");i.loadedFromCache&&(E.createChild("div").textContent=ke(Se.thisResponseWasLoadedFromCache)),E.createChild("div").textContent=ke(Se.theSecurityDetailsAboveAreFrom)}else if("secure"===i.securityState){const $=this.element.createChild("div","origin-view-section"),F=$.createChild("div","origin-view-section-title");F.textContent=ke(Se.secure),a.ARIAUtils.markAsHeading(F,2),$.createChild("div").textContent=ke(Se.thisOriginIsANonhttpsSecure)}else if("unknown"!==i.securityState){const V=this.element.createChild("div","origin-view-section"),O=V.createChild("div","origin-view-section-title");O.textContent=ke(Se.notSecure),a.ARIAUtils.markAsHeading(O,2),V.createChild("div").textContent=ke(Se.yourConnectionToThisOriginIsNot)}else{const z=this.element.createChild("div","origin-view-section"),N=z.createChild("div","origin-view-section-title");N.textContent=ke(Se.noSecurityInformation),a.ARIAUtils.markAsHeading(N,2),z.createChild("div").textContent=ke(Se.noSecurityDetailsAreAvailableFor)}}createSanDiv(e){const t=document.createElement("div");if(0===e.length)t.textContent=ke(Se.na),t.classList.add("empty-san");else{const i=2,s=e.length>i+1;for(let r=0;r<e.length;r++){const o=t.createChild("span","san-entry");o.textContent=e[r],s&&r>=i&&o.classList.add("truncated-entry")}if(s){function n(){const i=t.classList.contains("truncated-san");let s;i?(t.classList.remove("truncated-san"),s=ke(Se.showLess)):(t.classList.add("truncated-san"),s=ke(Se.showMoreSTotal,{PH1:e.length})),c.textContent=s,a.ARIAUtils.setLabel(c,s),a.ARIAUtils.setExpanded(c,i)}const c=a.UIUtils.createTextButton(ke(Se.showMoreSTotal,{PH1:e.length}),n,{jslogContext:"security.toggle-san-truncation"});t.appendChild(c),n()}}return t}setSecurityState(e){this.originLockIcon.removeChildren();const t=Pe(e,`security-property security-property-${e}`);this.originLockIcon.appendChild(t)}}class He{#I;constructor(){this.#I=document.createElement("table"),this.#I.classList.add("details-table")}element(){return this.#I}addRow(e,t){const i=this.#I.createChild("tr","details-table-row");i.createChild("td").textContent=e;const s=i.createChild("td");"string"==typeof t?s.textContent=t:s.appendChild(t)}}var $e=Object.freeze({__proto__:null,get OriginGroup(){return Le},SecurityDetailsTable:He,SecurityMainView:De,SecurityOriginView:Ue,SecurityPanel:Me,SecurityRevealer:class{async reveal(){await a.ViewManager.ViewManager.instance().showView("security");const e=a.ViewManager.ViewManager.instance().view("security");if(e){const t=await e.widget();if(!(t instanceof Me&&t.sidebar.cookieReportTreeElement))throw new Error("Expected securityPanel to be an instance of SecurityPanel with a cookieReportTreeElement in the sidebar");t.sidebar.cookieReportTreeElement.select(!1,!0)}}},createHighlightedUrl:Ae,getSecurityStateIconForDetailedView:Pe,getSecurityStateIconForOverview:Re});export{T as CookieControlsView,U as CookieReportView,G as IPProtectionView,re as SecurityModel,$e as SecurityPanel};
//# sourceMappingURL=security.js.map
