import*as e from"../../core/common/common.js";import*as t from"../../core/platform/platform.js";import*as o from"../../core/sdk/sdk.js";import*as s from"../../models/text_utils/text_utils.js";import*as r from"../../models/workspace/workspace.js";import*as i from"../../core/i18n/i18n.js";import*as a from"../../ui/legacy/components/data_grid/data_grid.js";import*as n from"../../ui/legacy/legacy.js";import{Directives as c,render as l,html as d,nothing as h}from"../../ui/lit/lit.js";import*as u from"../../core/host/host.js";import*as g from"../../models/bindings/bindings.js";import"../../ui/components/buttons/buttons.js";import*as p from"../../ui/visual_logging/visual_logging.js";var v;!function(e){e.CoverageUpdated="CoverageUpdated",e.CoverageReset="CoverageReset",e.SourceMapResolved="SourceMapResolved"}(v||(v={}));class f extends o.SDKModel.SDKModel{cpuProfilerModel;cssModel;debuggerModel;coverageByURL;coverageByContentProvider;coverageUpdateTimes;suspensionState;pollTimer;currentPollPromise;shouldResumePollingOnResume;jsBacklog;cssBacklog;performanceTraceRecording;sourceMapManager;willResolveSourceMaps;processSourceMapBacklog;constructor(e){super(e),this.cpuProfilerModel=e.model(o.CPUProfilerModel.CPUProfilerModel),this.cssModel=e.model(o.CSSModel.CSSModel),this.debuggerModel=e.model(o.DebuggerModel.DebuggerModel),this.sourceMapManager=this.debuggerModel?.sourceMapManager()||null,this.sourceMapManager?.addEventListener(o.SourceMapManager.Events.SourceMapAttached,this.sourceMapAttached,this),this.coverageByURL=new Map,this.coverageByContentProvider=new Map,this.coverageUpdateTimes=new Set,this.suspensionState="Active",this.pollTimer=null,this.currentPollPromise=null,this.shouldResumePollingOnResume=!1,this.jsBacklog=[],this.cssBacklog=[],this.performanceTraceRecording=!1,this.willResolveSourceMaps=!1,this.processSourceMapBacklog=[]}async start(e){if("Active"!==this.suspensionState)throw new Error("Cannot start CoverageModel while it is not active.");const t=[];return this.cssModel&&(this.clearCSS(),this.cssModel.addEventListener(o.CSSModel.Events.StyleSheetAdded,this.handleStyleSheetAdded,this),t.push(this.cssModel.startCoverage())),this.cpuProfilerModel&&t.push(this.cpuProfilerModel.startPreciseCoverage(e,this.preciseCoverageDeltaUpdate.bind(this))),await Promise.all(t),Boolean(this.cssModel||this.cpuProfilerModel)}async sourceMapAttached(e){const t=e.data.client,o=e.data.sourceMap;this.processSourceMapBacklog.push({script:t,sourceMap:o}),this.willResolveSourceMaps||(this.willResolveSourceMaps=!0,setTimeout(this.resolveSourceMapsAndUpdate.bind(this),500))}async resolveSourceMapsAndUpdate(){this.willResolveSourceMaps=!1;const e=this.processSourceMapBacklog;this.processSourceMapBacklog=[],await Promise.all(e.map(({script:e,sourceMap:t})=>this.resolveSourceMap(e,t))),this.dispatchEventToListeners(v.SourceMapResolved)}async resolveSourceMap(e,t){const o=e.sourceURL,r=this.coverageByURL.get(o);if(r&&0===r.sourcesURLCoverageInfo.size){const o=s.ContentData.ContentData.contentDataOrEmpty(await e.requestContentData()),[i,a]=this.calculateSizeForSources(t,o.textObj,e.contentLength);r.setSourceSegments(a);for(const e of t.sourceURLs())this.addCoverageForSource(e,i.get(e)||0,r.type(),r)}}async preciseCoverageDeltaUpdate(e,t){this.coverageUpdateTimes.add(e);const o=await this.backlogOrProcessJSCoverage(t,e);o.length&&this.dispatchEventToListeners(v.CoverageUpdated,o)}async stop(){await this.stopPolling();const e=[];this.cpuProfilerModel&&e.push(this.cpuProfilerModel.stopPreciseCoverage()),this.cssModel&&(e.push(this.cssModel.stopCoverage()),this.cssModel.removeEventListener(o.CSSModel.Events.StyleSheetAdded,this.handleStyleSheetAdded,this)),await Promise.all(e)}reset(){this.coverageByURL=new Map,this.coverageByContentProvider=new Map,this.coverageUpdateTimes=new Set,this.dispatchEventToListeners(v.CoverageReset)}async startPolling(){this.currentPollPromise||"Active"!==this.suspensionState||await this.pollLoop()}async pollLoop(){this.clearTimer(),this.currentPollPromise=this.pollAndCallback(),await this.currentPollPromise,("Active"===this.suspensionState||this.performanceTraceRecording)&&(this.pollTimer=window.setTimeout(()=>this.pollLoop(),200))}async stopPolling(){this.clearTimer(),await this.currentPollPromise,this.currentPollPromise=null,await this.pollAndCallback()}async pollAndCallback(){if("Suspended"===this.suspensionState&&!this.performanceTraceRecording)return;const e=await this.takeAllCoverage();console.assert("Suspended"!==this.suspensionState||Boolean(this.performanceTraceRecording),"CoverageModel was suspended while polling."),e.length&&this.dispatchEventToListeners(v.CoverageUpdated,e)}clearTimer(){this.pollTimer&&(clearTimeout(this.pollTimer),this.pollTimer=null)}async preSuspendModel(e){"Active"===this.suspensionState&&(this.suspensionState="Suspending","performance-timeline"!==e?this.currentPollPromise&&(await this.stopPolling(),this.shouldResumePollingOnResume=!0):this.performanceTraceRecording=!0)}async suspendModel(e){this.suspensionState="Suspended"}async resumeModel(){}async postResumeModel(){this.suspensionState="Active",this.performanceTraceRecording=!1,this.shouldResumePollingOnResume&&(this.shouldResumePollingOnResume=!1,await this.startPolling())}entries(){return Array.from(this.coverageByURL.values())}getCoverageForUrl(e){return this.coverageByURL.get(e)||null}usageForRange(e,t,o){const s=this.coverageByContentProvider.get(e);return s?.usageForRange(t,o)}clearCSS(){for(const e of this.coverageByContentProvider.values()){if(1!==e.type())continue;const t=e.getContentProvider();this.coverageByContentProvider.delete(t);const o=this.coverageByURL.get(e.url());if(!o)continue;const s=`${t.startLine}:${t.startColumn}`;o.removeCoverageEntry(s,e),0===o.numberOfEntries()&&this.coverageByURL.delete(e.url())}if(this.cssModel)for(const e of this.cssModel.getAllStyleSheetHeaders())this.addStyleSheetToCSSCoverage(e)}async takeAllCoverage(){const[e,t]=await Promise.all([this.takeCSSCoverage(),this.takeJSCoverage()]);return[...e,...t]}async takeJSCoverage(){if(!this.cpuProfilerModel)return[];const{coverage:e,timestamp:t}=await this.cpuProfilerModel.takePreciseCoverage();return this.coverageUpdateTimes.add(t),await this.backlogOrProcessJSCoverage(e,t)}async backlogOrProcessJSCoverage(e,t){if(e.length>0&&this.jsBacklog.push({rawCoverageData:e,stamp:t}),"Active"!==this.suspensionState)return[];const o=(e,t)=>e.stamp-t.stamp,s=[];for(const{rawCoverageData:e,stamp:t}of this.jsBacklog.sort(o))s.push(await this.processJSCoverage(e,t));return this.jsBacklog=[],s.flat()}async processJSBacklog(){this.backlogOrProcessJSCoverage([],0)}async processJSCoverage(e,t){if(!this.debuggerModel)return[];const o=[];for(const s of e){const e=this.debuggerModel.scriptForId(s.scriptId);if(!e)continue;const r=[];let i=2;for(const e of s.functions){!1!==e.isBlockCoverage||1===e.ranges.length&&!e.ranges[0].count||(i|=4);for(const t of e.ranges)r.push(t)}const a=await this.addCoverage(e,e.contentLength,e.lineOffset,e.columnOffset,r,i,t);a&&o.push(...a)}return o}handleStyleSheetAdded(e){this.addStyleSheetToCSSCoverage(e.data)}async takeCSSCoverage(){if(!this.cssModel||"Active"!==this.suspensionState)return[];const{coverage:e,timestamp:t}=await this.cssModel.takeCoverageDelta();return this.coverageUpdateTimes.add(t),await this.backlogOrProcessCSSCoverage(e,t)}async backlogOrProcessCSSCoverage(e,t){if(e.length>0&&this.cssBacklog.push({rawCoverageData:e,stamp:t}),"Active"!==this.suspensionState)return[];const o=(e,t)=>e.stamp-t.stamp,s=[];for(const{rawCoverageData:e,stamp:t}of this.cssBacklog.sort(o))s.push(await this.processCSSCoverage(e,t));return this.cssBacklog=[],s.flat()}async processCSSCoverage(e,t){if(!this.cssModel)return[];const o=[],s=new Map;for(const t of e){const e=this.cssModel.styleSheetHeaderForId(t.styleSheetId);if(!e)continue;let o=s.get(e);o||(o=[],s.set(e,o)),o.push({startOffset:t.startOffset,endOffset:t.endOffset,count:Number(t.used)})}for(const e of s){const s=e[0],r=e[1],i=await this.addCoverage(s,s.contentLength,s.startLine,s.startColumn,r,1,t);i&&o.push(...i)}return o}static convertToDisjointSegments(e,t){e.sort((e,t)=>e.startOffset-t.startOffset);const o=[],s=[];for(const t of e){let e=s[s.length-1];for(;e&&e.endOffset<=t.startOffset;)r(e.endOffset,e.count),s.pop(),e=s[s.length-1];r(t.startOffset,e?e.count:0),s.push(t)}for(let e=s.pop();e;e=s.pop())r(e.endOffset,e.count);function r(e,s){const r=o[o.length-1];if(r){if(r.end===e)return;if(r.count===s)return void(r.end=e)}o.push({end:e,count:s,stamp:t})}return o}addStyleSheetToCSSCoverage(e){this.addCoverage(e,e.contentLength,e.startLine,e.startColumn,[],1,Date.now())}calculateSizeForSources(e,t,o){const s=new Map,r=[],i=function(e,o,s,r){if(e===s)return r-o;if(t){const i=t.offsetFromPosition(e,o);return t.offsetFromPosition(s,r)-i}return r},a=e.mappings();if(0===a.length)return[s,r];let n=a[0],c=0;c+=t?t.offsetFromPosition(n.lineNumber,n.columnNumber):i(0,0,n.lineNumber,n.columnNumber),r.push({end:c,sourceUrl:""});for(let l=0;l<a.length;l++){const d=a[l],h=e.findEntryRanges(d.lineNumber,d.columnNumber);if(h){const e=h.range,r=h.sourceURL,n=s.get(r)||0;let c=0;if(l===a.length-1){c=o-t.offsetFromPosition(e.startLine,e.startColumn)}else c=i(e.startLine,e.startColumn,e.endLine,e.endColumn);s.set(r,n+c)}if(c+=i(n.lineNumber,n.columnNumber,d.lineNumber,d.columnNumber),d.sourceURL!==n.sourceURL)if(t){const e=t.offsetFromPosition(d.lineNumber,d.columnNumber);r.push({end:e,sourceUrl:n.sourceURL||""})}else r.push({end:c,sourceUrl:n.sourceURL||""});n=d,l===a.length-1&&r.push({end:o,sourceUrl:d.sourceURL||""})}return[s,r]}async addCoverage(e,t,o,r,i,a,n){const c=[],l=e.contentURL();if(!l)return null;let d=this.coverageByURL.get(l),h=!1;if(!d){h=!0,d=new S(l),this.coverageByURL.set(l,d);const o=await(this.sourceMapManager?.sourceMapForClientPromise(e));if(o){const r=s.ContentData.ContentData.contentDataOrEmpty(await e.requestContentData()),[i,n]=this.calculateSizeForSources(o,r.textObj,t);d.setSourceSegments(n);for(const e of o.sourceURLs()){const t=this.addCoverageForSource(e,i.get(e)||0,a,d);t&&c.push(t)}}}const u=d.ensureEntry(e,t,o,r,a);this.coverageByContentProvider.set(e,u);const g=f.convertToDisjointSegments(i,n),p=g[g.length-1];p&&p.end<t&&g.push({end:t,stamp:n,count:0});const v=u.mergeCoverage(g);if(!h&&0===v)return null;d.addToSizes(v,0);for(const[e,t]of u.sourceDeltaMap){const o=d.sourcesURLCoverageInfo.get(e);o&&(o.addToSizes(t,0),o.lastSourceUsedRange=u.sourceUsedRangeMap.get(e)||[])}return c.push(u),c}addCoverageForSource(e,t,o,s){const i=r.Workspace.WorkspaceImpl.instance().uiSourceCodeForURL(e),a=new C(e,s),n=a.ensureEntry(i,t,0,0,o);return s.sourcesURLCoverageInfo.set(e,a),n}async exportReport(t){const o=[],s=Array.from(this.coverageByURL.keys()).sort();for(const t of s){const s=this.coverageByURL.get(t);if(!s)continue;const r=s.url();r.startsWith("extensions::")||e.ParsedURL.schemeIs(r,"chrome-extension:")||o.push(...await s.entriesForExport())}await t.write(JSON.stringify(o,void 0,2)),t.close()}}function m(e,t){const[o,s]=e.split(":"),[r,i]=t.split(":");return Number.parseInt(o,10)-Number.parseInt(r,10)||Number.parseInt(s,10)-Number.parseInt(i,10)}o.SDKModel.SDKModel.register(f,{capabilities:0,autostart:!1});class S extends e.ObjectWrapper.ObjectWrapper{#e;coverageInfoByLocation;#t;#o;#s;#r;sourcesURLCoverageInfo=new Map;sourceSegments;constructor(e){super(),this.#e=e,this.coverageInfoByLocation=new Map,this.#t=0,this.#o=0,this.#r=!1}url(){return this.#e}type(){return this.#s}size(){return this.#t}usedSize(){return this.#o}unusedSize(){return this.#t-this.#o}usedPercentage(){return 0===this.#t?0:this.unusedSize()&&this.size()?this.usedSize()/this.size():0}unusedPercentage(){return 0===this.#t?1:this.unusedSize()/this.size()}isContentScript(){return this.#r}entries(){return this.coverageInfoByLocation.values()}numberOfEntries(){return this.coverageInfoByLocation.size}removeCoverageEntry(e,t){this.coverageInfoByLocation.delete(e)&&this.addToSizes(-t.getUsedSize(),-t.getSize())}addToSizes(e,t){this.#o+=e,this.#t+=t,0===e&&0===t||this.dispatchEventToListeners(S.Events.SizesChanged)}setSourceSegments(e){this.sourceSegments=e}ensureEntry(e,t,s,r,i){const a=`${s}:${r}`;let n=this.coverageInfoByLocation.get(a);return 2&i&&!this.coverageInfoByLocation.size&&e instanceof o.Script.Script&&(this.#r=e.isContentScript()),this.#s|=i,n?(n.addCoverageType(i),n):(2&i&&!this.coverageInfoByLocation.size&&e instanceof o.Script.Script&&(this.#r=e.isContentScript()),n=new y(e,t,s,r,i,this),this.coverageInfoByLocation.set(a,n),this.addToSizes(0,t),n)}async getFullText(){let e=!1;const t=this.url();for(const o of this.coverageInfoByLocation.values()){const{lineOffset:s,columnOffset:r}=o.getOffsets();if(s||r){e=Boolean(t);break}}if(!e)return null;const r=o.ResourceTreeModel.ResourceTreeModel.resourceForURL(t);if(!r)return null;return s.ContentData.ContentData.contentDataOrEmpty(await r.requestContentData()).textObj}entriesForExportBasedOnFullText(e){const t=Array.from(this.coverageInfoByLocation.keys()).sort(m),o={url:this.url(),ranges:[],text:e.value()};for(const s of t){const t=this.coverageInfoByLocation.get(s);if(!t)continue;const{lineOffset:r,columnOffset:i}=t.getOffsets(),a=e?e.offsetFromPosition(r,i):0;o.ranges.push(...t.rangesForExport(a))}return o}async entriesForExportBasedOnContent(){const e=Array.from(this.coverageInfoByLocation.keys()).sort(m),t=[];for(const o of e){const e=this.coverageInfoByLocation.get(o);if(!e)continue;const r={url:this.url(),ranges:e.rangesForExport(),text:s.ContentData.ContentData.textOr(await e.getContentProvider().requestContentData(),null)};t.push(r)}return t}async entriesForExport(){const e=await this.getFullText();return e?[await this.entriesForExportBasedOnFullText(e)]:await this.entriesForExportBasedOnContent()}}class C extends S{generatedURLCoverageInfo;lastSourceUsedRange=[];constructor(e,t){super(e),this.generatedURLCoverageInfo=t}}!function(e){let t;!function(e){e.SizesChanged="SizesChanged"}(t=e.Events||(e.Events={}))}(S||(S={}));const b=(e,t)=>{const o=[];let s=0,r=0;for(;s<e.length&&r<t.length;){const i=e[s],a=t[r],n=(i.count||0)+(a.count||0),c=Math.min(i.end,a.end),l=o[o.length-1],d=Math.min(i.stamp,a.stamp);l&&l.count===n&&l.stamp===d?l.end=c:o.push({end:c,count:n,stamp:d}),i.end<=a.end&&s++,i.end>=a.end&&r++}for(;s<e.length;s++)o.push(e[s]);for(;r<t.length;r++)o.push(t[r]);return o};class y{contentProvider;size;usedSize;statsByTimestamp;lineOffset;columnOffset;coverageType;segments;generatedUrlCoverageInfo;sourceUsedSizeMap=new Map;sourceDeltaMap=new Map;sourceUsedRangeMap=new Map;constructor(e,t,o,s,r,i){this.contentProvider=e,this.size=t,this.usedSize=0,this.statsByTimestamp=new Map,this.lineOffset=o,this.columnOffset=s,this.coverageType=r,this.generatedUrlCoverageInfo=i,this.segments=[]}getContentProvider(){return this.contentProvider}url(){return this.contentProvider.contentURL()}type(){return this.coverageType}addCoverageType(e){this.coverageType|=e}getOffsets(){return{lineOffset:this.lineOffset,columnOffset:this.columnOffset}}mergeCoverage(e){const t=this.usedSize;return this.segments=b(this.segments,e),this.updateStats(),this.generatedUrlCoverageInfo.sourceSegments&&this.generatedUrlCoverageInfo.sourceSegments.length>0&&this.updateSourceCoverage(),this.usedSize-t}getSize(){return this.size}getUsedSize(){return this.usedSize}usageForRange(e,o){let s=t.ArrayUtilities.upperBound(this.segments,e,(e,t)=>e-t.end);for(;s<this.segments.length&&this.segments[s].end<o;++s)if(this.segments[s].count)return!0;return s<this.segments.length&&Boolean(this.segments[s].count)}updateStats(){this.statsByTimestamp=new Map,this.usedSize=0;let e=0;for(const t of this.segments){let o=this.statsByTimestamp.get(t.stamp);if(void 0===o&&(o=0),t.count){const s=t.end-e;this.usedSize+=s,this.statsByTimestamp.set(t.stamp,o+s)}e=t.end}}updateSourceCoverage(){const e=new Map;this.sourceDeltaMap=new Map,this.sourceUsedRangeMap=new Map;const t=this.generatedUrlCoverageInfo.sourceSegments||[];let o=0,s=0;for(const r of this.segments){const i=r.end;if(r.count)for(let r=s;r<t.length;r++){const a=0===r?0:t[r-1].end+1,n=t[r].end,c=Math.max(o,a),l=Math.min(i,n);if(c<=l){const o=l-c+1,i={start:c,end:l};e.has(t[r].sourceUrl)?e.set(t[r].sourceUrl,e.get(t[r].sourceUrl)+o):e.set(t[r].sourceUrl,o),this.sourceUsedRangeMap.has(t[r].sourceUrl)?this.sourceUsedRangeMap.get(t[r].sourceUrl)?.push(i):this.sourceUsedRangeMap.set(t[r].sourceUrl,[i]),s=r}if(i<n)break}o=i+1}for(const[t,o]of e){const e=this.sourceUsedSizeMap.get(t)||0;e!==o&&(this.sourceUsedSizeMap.set(t,o),this.sourceDeltaMap.set(t,o-e))}}rangesForExport(e=0){const t=[];let o=0;for(const s of this.segments){if(s.count){const r=t.length>0?t[t.length-1]:null;r&&r.end===o+e?r.end=s.end+e:t.push({start:o+e,end:s.end+e})}o=s.end}return t}}var B=Object.freeze({__proto__:null,CoverageInfo:y,CoverageModel:f,get Events(){return v},SourceURLCoverageInfo:C,get URLCoverageInfo(){return S},mergeSegments:b}),P=`.data-grid{border:none}.data-grid td .url-outer{width:100%;display:inline-flex;justify-content:flex-start}.data-grid td .url-outer .filter-highlight{font-weight:bold}.data-grid td .url-prefix{overflow-x:hidden;text-overflow:ellipsis}.data-grid td .url-suffix{flex:none}.data-grid td .bar{display:inline-block;height:8px;border:1px solid transparent}.data-grid td .bar-unused-size{background-color:var(--app-color-coverage-unused)}.data-grid td .bar-used-size{background-color:var(--app-color-coverage-used)}.data-grid td .percent-value{width:7ex;display:inline-block;color:var(--sys-color-on-surface-subtle)}@media (forced-colors: active){.data-grid td .bar-container{forced-color-adjust:none}.data-grid td .bar-unused-size{background-color:ButtonText}.data-grid td .bar-used-size{background-color:ButtonFace}.data-grid td .bar{border-color:ButtonText}.data-grid .selected td .bar{border-top-color:HighlightText;border-bottom-color:HighlightText}.data-grid .selected td .bar:last-child{border-right-color:HighlightText}.data-grid .selected td .bar:first-child{border-left-color:HighlightText}.data-grid:focus tr.selected span.percent-value{color:HighlightText}}\n/*# sourceURL=${import.meta.resolve("./coverageListView.css")} */`;const w={css:"CSS",jsPerFunction:"JS (per function)",jsPerBlock:"JS (per block)",url:"URL",type:"Type",totalBytes:"Total Bytes",unusedBytes:"Unused Bytes",usageVisualization:"Usage Visualization",codeCoverage:"Code Coverage",jsCoverageWithPerFunction:"JS coverage with per function granularity: Once a function was executed, the whole function is marked as covered.",jsCoverageWithPerBlock:"JS coverage with per block granularity: Once a block of JavaScript was executed, that block is marked as covered.",sBytes:"{n, plural, =1 {# byte} other {# bytes}}",sBytesS:"{n, plural, =1 {# byte, {percentage}} other {# bytes, {percentage}}}",sBytesSBelongToFunctionsThatHave:"{PH1} bytes ({PH2}) belong to functions that have not (yet) been executed.",sBytesSBelongToBlocksOf:"{PH1} bytes ({PH2}) belong to blocks of JavaScript that have not (yet) been executed.",sBytesSBelongToFunctionsThatHaveExecuted:"{PH1} bytes ({PH2}) belong to functions that have executed at least once.",sBytesSBelongToBlocksOfJavascript:"{PH1} bytes ({PH2}) belong to blocks of JavaScript that have executed at least once.",sOfFileUnusedSOfFileUsed:"{PH1} % of file unused, {PH2} % of file used"},R=i.i18n.registerUIStrings("panels/coverage/CoverageListView.ts",w),x=i.i18n.getLocalizedString.bind(void 0,R),{styleMap:T}=c;function M(e){const t=[];return 1&e&&t.push(x(w.css)),4&e?t.push(x(w.jsPerFunction)):2&e&&t.push(x(w.jsPerBlock)),t.join("+")}class U extends n.Widget.VBox{nodeForUrl;highlightRegExp;dataGrid;constructor(){super({useShadowDom:!0}),this.registerRequiredCSS(P),this.nodeForUrl=new Map,this.highlightRegExp=null;const e=[{id:"url",title:x(w.url),width:"250px",weight:3,fixedWidth:!1,sortable:!0,disclosure:!0},{id:"type",title:x(w.type),width:"45px",weight:1,fixedWidth:!0,sortable:!0},{id:"size",title:x(w.totalBytes),width:"60px",fixedWidth:!0,sortable:!0,align:"right",weight:1},{id:"unused-size",title:x(w.unusedBytes),width:"100px",fixedWidth:!0,sortable:!0,align:"right",sort:a.DataGrid.Order.Descending,weight:1},{id:"bars",title:x(w.usageVisualization),width:"250px",fixedWidth:!1,sortable:!0,weight:1}];this.dataGrid=a.SortableDataGrid.SortableDataGrid.create(["dummy"],[],x(w.codeCoverage)),this.dataGrid.removeColumn("dummy");for(const t of e)this.dataGrid.addColumn(t);this.dataGrid.setColumnsVisibility(new Set(e.map(e=>e.id))),this.dataGrid.setResizeMethod("last"),this.dataGrid.setStriped(!0),this.dataGrid.element.classList.add("flex-auto"),this.dataGrid.addEventListener("OpenedNode",this.onOpenedNode,this);const t=this.dataGrid.asWidget();t.show(this.contentElement),this.setDefaultFocusedChild(t)}update(e,t){this.highlightRegExp=t;const o=e.reduce((e,t)=>Math.max(e,t.size),0),s=new Set(e.map(e=>e.url));for(const[e,t]of this.nodeForUrl.entries())s.has(e)||(t.remove(),this.nodeForUrl.delete(e));let r=!1;for(const t of e){let e=this.nodeForUrl.get(t.url);e?(r=e.refreshIfNeeded(o,t)||r,t.sources.length>0&&this.updateSourceNodes(t.sources,o,e),e.setHighlight(this.highlightRegExp)):(e=new E(t,o),this.nodeForUrl.set(t.url,e),this.appendNodeByType(e),t.sources.length>0&&this.updateSourceNodes(t.sources,o,e),e.setHighlight(this.highlightRegExp),r=!0)}r&&this.dataGrid.dispatchEventToListeners("SortingChanged")}updateSourceNodes(e,t,o){for(const s of e){const e=this.nodeForUrl.get(s.url);if(e)e.refreshIfNeeded(t,s);else{const e=new E(s,t);o.appendChild(e),this.nodeForUrl.set(s.url,e)}}}reset(){this.nodeForUrl.clear(),this.dataGrid.rootNode().removeChildren()}appendNodeByType(e){if(e.coverageInfo.generatedUrl){const t=this.nodeForUrl.get(e.coverageInfo.generatedUrl);t?.appendChild(e)}else this.dataGrid.rootNode().appendChild(e)}selectByUrl(e){const t=this.nodeForUrl.get(e);t&&t.revealAndSelect()}onOpenedNode(){this.revealSourceForSelectedNode()}async revealSourceForSelectedNode(){const t=this.dataGrid.selectedNode;if(!t)return;const o=t.coverageInfo,s=r.Workspace.WorkspaceImpl.instance().uiSourceCodeForURL(o.url);s&&this.dataGrid.selectedNode===t&&e.Revealer.reveal(s)}}let L=null;let k=null;class E extends a.SortableDataGrid.SortableDataGridNode{coverageInfo;lastUsedSize;url;maxSize;highlightRegExp;constructor(e,t){super(),this.coverageInfo=e,this.url=e.url,this.maxSize=t,this.highlightRegExp=null,this.#i(e)}#i(e){this.data.url=this.url,this.data.type=M(e.type),this.data.size=e.size,this.data["unused-size"]=e.unusedSize,this.data.bars=e.unusedSize,this.coverageInfo=e}setHighlight(e){if(this.highlightRegExp!==e){this.highlightRegExp=e;for(const e of this.children)e.setHighlight(this.highlightRegExp);this.refresh()}}refreshIfNeeded(e,t){return(this.lastUsedSize!==t.usedSize||e!==this.maxSize)&&(this.lastUsedSize=t.usedSize,this.maxSize=e,this.refresh(),this.#i(t),!0)}createCell(e){const t=this.createTD(e),o=this.coverageInfo,s=e=>(k||(k=new Intl.NumberFormat(i.DevToolsLocale.DevToolsLocale.instance().locale)),k).format(e??0),r=e=>(L||(L=new Intl.NumberFormat(i.DevToolsLocale.DevToolsLocale.instance().locale,{style:"percent",maximumFractionDigits:1})),L).format(e??0);switch(e){case"url":{n.Tooltip.Tooltip.install(t,this.url),this.setCellAccessibleName(this.url,t,e);const o=/^(.*)(\/[^/]*)$/.exec(this.url);l(d`
          <div class="url-outer">
            <div class="url-prefix">${o?o[1]:this.url}</div>
            <div class="url-suffix">${o?o[2]:""}</div>
          </div>`,t),this.highlightRegExp&&this.highlight(t,this.url);break}case"type":n.Tooltip.Tooltip.install(t,4&o.type?x(w.jsCoverageWithPerFunction):2&o.type?x(w.jsCoverageWithPerBlock):""),l(M(this.coverageInfo.type),t);break;case"size":this.setCellAccessibleName(x(w.sBytes,{n:o.size||0}),t,e),l(d`<span>${s(o.size)}</span>`,t);break;case"unused-size":this.setCellAccessibleName(x(w.sBytesS,{n:o.unusedSize,percentage:r(o.unusedPercentage)}),t,e),l(d`
          <span>${s(o.unusedSize)}</span>
          <span class="percent-value">
            ${r(o.unusedPercentage)}
          </span>`,t);break;case"bars":this.setCellAccessibleName(x(w.sOfFileUnusedSOfFileUsed,{PH1:r(o.unusedPercentage),PH2:r(o.usedPercentage)}),t,e),l(d`
          <div class="bar-container">
            ${o.unusedSize>0?d`
              <div class="bar bar-unused-size"
                  title=${4&o.type?x(w.sBytesSBelongToFunctionsThatHave,{PH1:o.unusedSize,PH2:r(o.unusedPercentage)}):2&o.type?x(w.sBytesSBelongToBlocksOf,{PH1:o.unusedSize,PH2:r(o.unusedPercentage)}):""}
                  style=${T({width:(o.unusedSize/this.maxSize*100||0)+"%"})}>
              </div>`:h}
            ${o.usedSize>0?d`
            <div class="bar bar-used-size"
                  title=${4&o.type?x(w.sBytesSBelongToFunctionsThatHaveExecuted,{PH1:o.usedSize,PH2:r(o.usedPercentage)}):2&o.type?x(w.sBytesSBelongToBlocksOfJavascript,{PH1:o.usedSize,PH2:r(o.usedPercentage)}):""}
                  { PH1: info.usedSize, PH2: formatPercent(info.usedPercentage) })}
                style=${T({width:(o.usedSize/this.maxSize*100||0)+"%"})}>
            </div>`:h}
          </div>`,t)}return t}highlight(e,t){if(!this.highlightRegExp)return;const o=this.highlightRegExp.exec(t);if(!o?.length)return;const r=new s.TextRange.SourceRange(o.index,o[0].length);n.UIUtils.highlightRangesWithStyleClass(e,[r],"filter-highlight")}}var z=Object.freeze({__proto__:null,CoverageListView:U,GridNode:E,coverageTypeToString:M});const F="coverage";class I{coverageModel;textByProvider;uiSourceCodeByContentProvider;#a;#n;#c;constructor(e,o,s,i){this.coverageModel=e,this.#a=o,this.#n=s,this.#c=i,this.textByProvider=new Map,this.uiSourceCodeByContentProvider=new t.MapUtilities.Multimap;for(const e of this.#a.uiSourceCodes())e.setDecorationData(F,this);this.#a.addEventListener(r.Workspace.Events.UISourceCodeAdded,this.onUISourceCodeAdded,this)}reset(){for(const e of this.#a.uiSourceCodes())e.setDecorationData(F,void 0)}dispose(){this.reset(),this.#a.removeEventListener(r.Workspace.Events.UISourceCodeAdded,this.onUISourceCodeAdded,this)}update(e){for(const t of e)for(const e of this.uiSourceCodeByContentProvider.get(t.getContentProvider()))e.setDecorationData(F,this)}async usageByLine(e,t){const o=[];await this.updateTexts(e,t);for(const{startLine:s,startColumn:r,endLine:i,endColumn:a}of t){const t=this.rawLocationsForSourceLocation(e,s,r),n=this.rawLocationsForSourceLocation(e,i,a),[c,l]=await Promise.all([t,n]);let d;for(let e=0,t=0;e<c.length;++e){const o=c[e];for(;t<l.length&&I.compareLocations(o,l[t])>=0;)++t;if(t>=l.length||l[t].id!==o.id)continue;const s=l[t++],r=this.textByProvider.get(s.contentProvider);if(!r)continue;const i=r.value();let a=Math.min(r.offsetFromPosition(o.line,o.column),i.length-1),n=Math.min(r.offsetFromPosition(s.line,s.column),i.length-1);for(;a<=n&&/\s/.test(i[a]);)++a;for(;a<=n&&/\s/.test(i[n]);)--n;if(a<=n&&(d=this.coverageModel.usageForRange(s.contentProvider,a,n)),d)break}o.push(d)}return o}async updateTexts(e,t){const o=[];for(const s of t)for(const t of await this.rawLocationsForSourceLocation(e,s.startLine,0))this.textByProvider.has(t.contentProvider)||(this.textByProvider.set(t.contentProvider,null),this.uiSourceCodeByContentProvider.set(t.contentProvider,e),o.push(this.updateTextForProvider(t.contentProvider)));await Promise.all(o)}async updateTextForProvider(e){const t=s.ContentData.ContentData.contentDataOrEmpty(await e.requestContentData());this.textByProvider.set(e,t.textObj)}async rawLocationsForSourceLocation(e,t,o){const s=[],i=e.contentType();if(i.hasScripts()){let r=await this.#n.uiLocationToRawLocations(e,t,o);r=r.filter(e=>!!e.script());for(const e of r){const t=e.script();t&&(t.isInlineScript()&&i.isDocument()&&(e.lineNumber-=t.lineOffset,e.lineNumber||(e.columnNumber-=t.columnOffset)),s.push({id:`js:${e.scriptId}`,contentProvider:t,line:e.lineNumber,column:e.columnNumber}))}}if(i.isStyleSheet()||i.isDocument()){const a=this.#c.uiLocationToRawLocations(new r.UISourceCode.UILocation(e,t,o));for(const e of a){const t=e.header();t&&(t.isInline&&i.isDocument()&&(e.lineNumber-=t.startLine,e.lineNumber||(e.columnNumber-=t.startColumn)),s.push({id:`css:${e.styleSheetId}`,contentProvider:t,line:e.lineNumber,column:e.columnNumber}))}}return s.sort(I.compareLocations)}static compareLocations(e,t){return e.id.localeCompare(t.id)||e.line-t.line||e.column-t.column}onUISourceCodeAdded(e){e.data.setDecorationData(F,this)}}var A=Object.freeze({__proto__:null,CoverageDecorationManager:I,decoratorType:F}),O=`:host{overflow:hidden}.coverage-toolbar-container{display:flex;border-bottom:1px solid var(--sys-color-divider);flex:0 0 auto}.coverage-toolbar{flex:auto}.coverage-toolbar-summary{background-color:var(--sys-color-cdt-base-container);border-top:1px solid var(--sys-color-divider);padding-left:5px;flex:0 0 19px;display:flex;padding-right:5px}.coverage-toolbar-summary .coverage-message{padding-top:2px;padding-left:1ex;text-overflow:ellipsis;white-space:nowrap;overflow:hidden}.coverage-results{overflow-y:auto;display:flex;flex:auto}.bfcache-page,\n.prerender-page{justify-content:center;align-items:center;padding:20px}.bfcache-page .message,\n.prerender-page .message{white-space:pre-line;text-align:center}\n/*# sourceURL=${import.meta.resolve("./coverageView.css")} */`;const D={chooseCoverageGranularityPer:"Choose coverage granularity: Per function has low overhead, per block has significant overhead.",perFunction:"Per function",perBlock:"Per block",filterByUrl:"Filter by URL",filterCoverageByType:"Filter coverage by type",all:"All",css:"CSS",javascript:"JavaScript",includeExtensionContentScripts:"Include extension content scripts",contentScripts:"Content scripts",noCoverageData:"No coverage data",reloadPage:"Reload page",startRecording:"Start recording",clickTheReloadButtonSToReloadAnd:'Click the "{PH1}" button to reload and start capturing coverage.',clickTheRecordButtonSToStart:'Click the "{PH1}" button to start capturing coverage.',bfcacheNoCapture:"Could not capture coverage info because the page was served from the back/forward cache.",activationNoCapture:"Could not capture coverage info because the page was prerendered in the background.",reloadPrompt:"Click the reload button {PH1} to reload and get coverage.",filteredSTotalS:"Filtered: {PH1}  Total: {PH2}",sOfSSUsedSoFarSUnused:"{PH1} of {PH2} ({PH3}%) used so far, {PH4} unused."},N=i.i18n.registerUIStrings("panels/coverage/CoverageView.ts",D),V=i.i18n.getLocalizedString.bind(void 0,N);let H;class j extends n.Widget.VBox{model;decorationManager;coverageTypeComboBox;coverageTypeComboBoxSetting;toggleRecordAction;toggleRecordButton;inlineReloadButton;startWithReloadButton;clearAction;exportAction;textFilterRegExp;filterInput;typeFilterValue;filterByTypeComboBox;showContentScriptsSetting;contentScriptsCheckbox;coverageResultsElement;landingPage;bfcacheReloadPromptPage;activationReloadPromptPage;listView;statusToolbarElement;statusMessageElement;constructor(){super({jslog:`${p.panel("coverage").track({resize:!0})}`,useShadowDom:!0}),this.registerRequiredCSS(O),this.model=null,this.decorationManager=null;const t=this.contentElement.createChild("div","coverage-toolbar-container");t.setAttribute("jslog",`${p.toolbar()}`),t.role="toolbar";const s=t.createChild("devtools-toolbar","coverage-toolbar");s.role="presentation",s.wrappable=!0,this.coverageTypeComboBox=new n.Toolbar.ToolbarComboBox(this.onCoverageTypeComboBoxSelectionChanged.bind(this),V(D.chooseCoverageGranularityPer),void 0,"coverage-type");const r=[{label:V(D.perFunction),value:6},{label:V(D.perBlock),value:2}];for(const e of r)this.coverageTypeComboBox.addOption(this.coverageTypeComboBox.createOption(e.label,`${e.value}`));this.coverageTypeComboBoxSetting=e.Settings.Settings.instance().createSetting("coverage-view-coverage-type",0),this.coverageTypeComboBox.setSelectedIndex(this.coverageTypeComboBoxSetting.get()),this.coverageTypeComboBox.setEnabled(!0),s.appendToolbarItem(this.coverageTypeComboBox),this.toggleRecordAction=n.ActionRegistry.ActionRegistry.instance().getAction("coverage.toggle-recording"),this.toggleRecordButton=n.Toolbar.Toolbar.createActionButton(this.toggleRecordAction),s.appendToolbarItem(this.toggleRecordButton);const i=o.TargetManager.TargetManager.instance().primaryPageTarget(),a=i?.model(o.ResourceTreeModel.ResourceTreeModel);this.inlineReloadButton=null,a&&(this.startWithReloadButton=n.Toolbar.Toolbar.createActionButton("coverage.start-with-reload"),s.appendToolbarItem(this.startWithReloadButton),this.toggleRecordButton.setEnabled(!1),this.toggleRecordButton.setVisible(!1)),this.clearAction=n.ActionRegistry.ActionRegistry.instance().getAction("coverage.clear"),this.clearAction.setEnabled(!1),s.appendToolbarItem(n.Toolbar.Toolbar.createActionButton(this.clearAction)),s.appendSeparator(),this.exportAction=n.ActionRegistry.ActionRegistry.instance().getAction("coverage.export"),this.exportAction.setEnabled(!1),s.appendToolbarItem(n.Toolbar.Toolbar.createActionButton(this.exportAction)),this.textFilterRegExp=null,s.appendSeparator(),this.filterInput=new n.Toolbar.ToolbarFilter(V(D.filterByUrl),1,1),this.filterInput.setEnabled(!1),this.filterInput.addEventListener("TextChanged",this.onFilterChanged,this),s.appendToolbarItem(this.filterInput),s.appendSeparator(),this.typeFilterValue=null,this.filterByTypeComboBox=new n.Toolbar.ToolbarComboBox(this.onFilterByTypeChanged.bind(this),V(D.filterCoverageByType),void 0,"coverage-by-type");const c=[{label:V(D.all),value:""},{label:V(D.css),value:1},{label:V(D.javascript),value:6}];for(const e of c)this.filterByTypeComboBox.addOption(this.filterByTypeComboBox.createOption(e.label,`${e.value}`));this.filterByTypeComboBox.setSelectedIndex(0),this.filterByTypeComboBox.setEnabled(!1),s.appendToolbarItem(this.filterByTypeComboBox),s.appendSeparator(),this.showContentScriptsSetting=e.Settings.Settings.instance().createSetting("show-content-scripts",!1),this.showContentScriptsSetting.addChangeListener(this.onFilterChanged,this),this.contentScriptsCheckbox=new n.Toolbar.ToolbarSettingCheckbox(this.showContentScriptsSetting,V(D.includeExtensionContentScripts),V(D.contentScripts)),this.contentScriptsCheckbox.setEnabled(!1),s.appendToolbarItem(this.contentScriptsCheckbox),this.coverageResultsElement=this.contentElement.createChild("div","coverage-results"),this.landingPage=this.buildLandingPage(),this.bfcacheReloadPromptPage=this.buildReloadPromptPage(V(D.bfcacheNoCapture),"bfcache-page"),this.activationReloadPromptPage=this.buildReloadPromptPage(V(D.activationNoCapture),"prerender-page"),this.listView=new U,this.statusToolbarElement=this.contentElement.createChild("div","coverage-toolbar-summary"),this.statusMessageElement=this.statusToolbarElement.createChild("div","coverage-message"),this.landingPage.show(this.coverageResultsElement)}static instance(){return H||(H=new j),H}static removeInstance(){H=void 0}buildLandingPage(){const e=new n.EmptyWidget.EmptyWidget(V(D.noCoverageData),"");if(e.link="https://developer.chrome.com/docs/devtools/coverage",this.startWithReloadButton){const t=n.ActionRegistry.ActionRegistry.instance().getAction("coverage.start-with-reload");if(t){e.text=V(D.clickTheReloadButtonSToReloadAnd,{PH1:V(D.reloadPage)});const o=n.UIUtils.createTextButton(V(D.reloadPage),()=>t.execute(),{jslogContext:t.id(),variant:"tonal"});e.contentElement.append(o)}}else{e.text=V(D.clickTheRecordButtonSToStart,{PH1:V(D.startRecording)});const t=n.UIUtils.createTextButton(V(D.startRecording),()=>this.toggleRecordAction.execute(),{jslogContext:this.toggleRecordAction.id(),variant:"tonal"});e.contentElement.append(t)}return e}buildReloadPromptPage(e,t){const o=new n.Widget.VBox,s=document.createElement("div");s.classList.add("message"),s.textContent=e,o.contentElement.appendChild(s),this.inlineReloadButton=n.UIUtils.createInlineButton(n.Toolbar.Toolbar.createActionButton("inspector-main.reload"));const r=i.i18n.getFormatLocalizedString(N,D.reloadPrompt,{PH1:this.inlineReloadButton});return r.classList.add("message"),o.contentElement.appendChild(r),o.element.classList.add(t),o}clear(){this.model&&this.model.reset(),this.reset()}reset(){this.decorationManager&&(this.decorationManager.dispose(),this.decorationManager=null),this.listView.reset(),this.listView.detach(),this.landingPage.show(this.coverageResultsElement),this.statusMessageElement.textContent="",this.filterInput.setEnabled(!1),this.filterByTypeComboBox.setEnabled(!1),this.contentScriptsCheckbox.setEnabled(!1),this.exportAction.setEnabled(!1)}toggleRecording(){!this.toggleRecordAction.toggled()?this.startRecording({reload:!1,jsCoveragePerBlock:this.isBlockCoverageSelected()}):this.stopRecording()}isBlockCoverageSelected(){const e=this.coverageTypeComboBox.selectedOption();return 2===Number(e?e.value:Number.NaN)}selectCoverageType(e){const t=e?1:0;this.coverageTypeComboBox.setSelectedIndex(t)}onCoverageTypeComboBoxSelectionChanged(){this.coverageTypeComboBoxSetting.set(this.coverageTypeComboBox.selectedIndex())}async startRecording(e){let t,s;this.startWithReloadButton?.element.hasFocus()||this.inlineReloadButton?.hasFocus()?s=!0:this.hasFocus()&&(t=!0),this.reset();const i=o.TargetManager.TargetManager.instance().primaryPageTarget();if(!i)return;const{reload:a,jsCoveragePerBlock:n}={reload:!1,jsCoveragePerBlock:!1,...e};if(this.model&&!a||(this.model=i.model(f)),!this.model)return;u.userMetrics.actionTaken(u.UserMetrics.Action.CoverageStarted),n&&u.userMetrics.actionTaken(u.UserMetrics.Action.CoverageStartedPerBlock);if(!await this.model.start(Boolean(n)))return;this.selectCoverageType(Boolean(n)),this.model.addEventListener(v.CoverageUpdated,this.onCoverageDataReceived,this),this.model.addEventListener(v.SourceMapResolved,this.updateListView,this);const c=i.model(o.ResourceTreeModel.ResourceTreeModel);o.TargetManager.TargetManager.instance().addModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.onPrimaryPageChanged,this),this.decorationManager=new I(this.model,r.Workspace.WorkspaceImpl.instance(),g.DebuggerWorkspaceBinding.DebuggerWorkspaceBinding.instance(),g.CSSWorkspaceBinding.CSSWorkspaceBinding.instance()),this.toggleRecordAction.setToggled(!0),this.clearAction.setEnabled(!1),this.startWithReloadButton&&(this.startWithReloadButton.setEnabled(!1),this.startWithReloadButton.setVisible(!1),this.toggleRecordButton.setEnabled(!0),this.toggleRecordButton.setVisible(!0),s&&this.toggleRecordButton.focus()),this.coverageTypeComboBox.setEnabled(!1),this.filterInput.setEnabled(!0),this.filterByTypeComboBox.setEnabled(!0),this.contentScriptsCheckbox.setEnabled(!0),this.landingPage.isShowing()&&this.landingPage.detach(),this.listView.show(this.coverageResultsElement),t&&!s&&this.listView.focus(),a&&c?c.reloadPage():this.model.startPolling()}onCoverageDataReceived(e){const t=e.data;this.updateViews(t)}updateListView(){const e=(this.model?.entries()||[]).map(e=>this.toCoverageListItem(e)).filter(e=>this.isVisible(e)).map(e=>({...e,sources:e.sources.filter(e=>this.isVisible(e))}));this.listView.update(e,this.textFilterRegExp)}toCoverageListItem(e){return{url:e.url(),type:e.type(),size:e.size(),usedSize:e.usedSize(),unusedSize:e.unusedSize(),usedPercentage:e.usedPercentage(),unusedPercentage:e.unusedPercentage(),sources:[...e.sourcesURLCoverageInfo.values()].map(this.toCoverageListItem,this),isContentScript:e.isContentScript(),generatedUrl:e instanceof C?e.generatedURLCoverageInfo.url():void 0}}async stopRecording(){o.TargetManager.TargetManager.instance().removeModelListener(o.ResourceTreeModel.ResourceTreeModel,o.ResourceTreeModel.Events.PrimaryPageChanged,this.onPrimaryPageChanged,this),this.hasFocus()&&this.listView.focus(),this.model&&(await this.model.stop(),this.model.removeEventListener(v.CoverageUpdated,this.onCoverageDataReceived,this)),this.toggleRecordAction.setToggled(!1),this.coverageTypeComboBox.setEnabled(!0),this.startWithReloadButton&&(this.startWithReloadButton.setEnabled(!0),this.startWithReloadButton.setVisible(!0),this.toggleRecordButton.setEnabled(!1),this.toggleRecordButton.setVisible(!1)),this.clearAction.setEnabled(!0)}async onPrimaryPageChanged(e){const t=e.data.frame,o=t.resourceTreeModel().target().model(f);if(o){if(this.model!==o){this.model&&(await this.model.stop(),this.model.removeEventListener(v.CoverageUpdated,this.onCoverageDataReceived,this)),this.model=o;if(!await this.model.start(this.isBlockCoverageSelected()))return;this.model.addEventListener(v.CoverageUpdated,this.onCoverageDataReceived,this),this.decorationManager=new I(this.model,r.Workspace.WorkspaceImpl.instance(),g.DebuggerWorkspaceBinding.DebuggerWorkspaceBinding.instance(),g.CSSWorkspaceBinding.CSSWorkspaceBinding.instance())}this.bfcacheReloadPromptPage.isShowing()&&(this.bfcacheReloadPromptPage.detach(),this.listView.show(this.coverageResultsElement)),this.activationReloadPromptPage.isShowing()&&(this.activationReloadPromptPage.detach(),this.listView.show(this.coverageResultsElement)),t.backForwardCacheDetails.restoredFromCache&&(this.listView.detach(),this.bfcacheReloadPromptPage.show(this.coverageResultsElement)),"Activation"===e.data.type&&(this.listView.detach(),this.activationReloadPromptPage.show(this.coverageResultsElement)),this.model.reset(),this.decorationManager?.reset(),this.listView.reset(),this.model.startPolling()}}updateViews(e){this.updateStats(),this.updateListView(),this.exportAction.setEnabled(null!==this.model&&this.model.entries().length>0),this.decorationManager?.update(e)}updateStats(){const e={total:0,unused:0},t={total:0,unused:0},o=null!==this.textFilterRegExp;if(this.model)for(const o of this.model.entries()){e.total+=o.size(),e.unused+=o.unusedSize();const s=this.toCoverageListItem(o);if(this.isVisible(s))if(this.textFilterRegExp?.test(o.url()))t.total+=o.size(),t.unused+=o.unusedSize();else for(const e of o.sourcesURLCoverageInfo.values())this.isVisible(this.toCoverageListItem(e))&&(t.total+=e.size(),t.unused+=e.unusedSize())}function s({total:e,unused:t}){const o=e-t,s=e?Math.round(100*o/e):0;return V(D.sOfSSUsedSoFarSUnused,{PH1:i.ByteUtilities.bytesToString(o),PH2:i.ByteUtilities.bytesToString(e),PH3:s,PH4:i.ByteUtilities.bytesToString(t)})}this.statusMessageElement.textContent=o?V(D.filteredSTotalS,{PH1:s(t),PH2:s(e)}):s(e)}onFilterChanged(){if(!this.listView)return;const e=this.filterInput.value();this.textFilterRegExp=e?t.StringUtilities.createPlainTextSearchRegex(e,"i"):null,this.updateListView(),this.updateStats()}onFilterByTypeChanged(){if(!this.listView)return;u.userMetrics.actionTaken(u.UserMetrics.Action.CoverageReportFiltered);const e=this.filterByTypeComboBox.selectedOption(),t=e?.value;this.typeFilterValue=parseInt(t||"",10)||null,this.updateListView(),this.updateStats()}isVisible(e){const t=e.url;if(t.startsWith(j.EXTENSION_BINDINGS_URL_PREFIX))return!1;if(e.isContentScript&&!this.showContentScriptsSetting.get())return!1;if(this.typeFilterValue&&!(e.type&this.typeFilterValue))return!1;if(e.sources.length>0)for(const t of e.sources)if(this.isVisible(t))return!0;return!this.textFilterRegExp||this.textFilterRegExp.test(t)}async exportReport(){const e=new g.FileUtils.FileOutputStream,o=`Coverage-${t.DateUtilities.toISO8601Compact(new Date)}.json`;await e.open(o)&&this.model&&await this.model.exportReport(e)}selectCoverageItemByUrl(e){this.listView.selectByUrl(e)}static EXTENSION_BINDINGS_URL_PREFIX="extensions::";wasShown(){n.Context.Context.instance().setFlavor(j,this),super.wasShown()}willHide(){super.willHide(),n.Context.Context.instance().setFlavor(j,null)}}var W=Object.freeze({__proto__:null,ActionDelegate:class{handleAction(e,t){const o="coverage";return n.ViewManager.ViewManager.instance().showView(o,!1,!0).then(()=>{const e=n.ViewManager.ViewManager.instance().view(o);return e?.widget()}).then(e=>this.#l(e,t)),!0}#l(e,t){switch(t){case"coverage.toggle-recording":e.toggleRecording();break;case"coverage.start-with-reload":e.startRecording({reload:!0,jsCoveragePerBlock:e.isBlockCoverageSelected()});break;case"coverage.clear":e.clear();break;case"coverage.export":e.exportReport();break;default:console.assert(!1,`Unknown action: ${t}`)}}},CoverageView:j});export{A as CoverageDecorationManager,z as CoverageListView,B as CoverageModel,W as CoverageView};
//# sourceMappingURL=coverage.js.map
