export declare class UserMetrics {
    #private;
    constructor();
    panelShown(panelName: string, isLaunching?: boolean): void;
    settingsPanelShown(settingsViewId: string): void;
    sourcesPanelFileDebugged(mediaType?: string): void;
    sourcesPanelFileOpened(mediaType?: string): void;
    networkPanelResponsePreviewOpened(mediaType: string): void;
    actionTaken(action: Action): void;
    panelLoaded(panelName: string, histogramName: string): void;
    setLaunchPanel(panelName: string | null): void;
    performanceTraceLoad(measure: PerformanceMeasure): void;
    keybindSetSettingChanged(keybindSet: string): void;
    keyboardShortcutFired(actionId: string): void;
    issuesPanelOpenedFrom(issueOpener: IssueOpener): void;
    issuesPanelIssueExpanded(issueExpandedCategory: string | undefined): void;
    issuesPanelResourceOpened(issueCategory: string, type: string): void;
    issueCreated(code: string): void;
    experimentEnabledAtLaunch(experimentId: string): void;
    navigationSettingAtFirstTimelineLoad(state: TimelineNavigationSetting): void;
    experimentDisabledAtLaunch(experimentId: string): void;
    experimentChanged(experimentId: string, isEnabled: boolean): void;
    developerResourceLoaded(developerResourceLoaded: DeveloperResourceLoaded): void;
    developerResourceScheme(developerResourceScheme: DeveloperResourceScheme): void;
    language(language: Intl.UnicodeBCP47LocaleIdentifier): void;
    syncSetting(devtoolsSyncSettingEnabled: boolean): void;
    recordingAssertion(value: RecordingAssertion): void;
    recordingToggled(value: RecordingToggled): void;
    recordingReplayFinished(value: RecordingReplayFinished): void;
    recordingReplaySpeed(value: RecordingReplaySpeed): void;
    recordingReplayStarted(value: RecordingReplayStarted): void;
    recordingEdited(value: RecordingEdited): void;
    recordingExported(value: RecordingExported): void;
    recordingCodeToggled(value: RecordingCodeToggled): void;
    recordingCopiedToClipboard(value: RecordingCopiedToClipboard): void;
    lighthouseModeRun(type: LighthouseModeRun): void;
    lighthouseCategoryUsed(type: LighthouseCategoryUsed): void;
    swatchActivated(swatch: SwatchType): void;
    animationPlaybackRateChanged(playbackRate: AnimationsPlaybackRate): void;
    workspacesPopulated(wallClockTimeInMilliseconds: number): void;
    visualLoggingProcessingDone(timeInMilliseconds: number): void;
    freestylerQueryLength(numberOfCharacters: number): void;
    freestylerEvalResponseSize(bytes: number): void;
    performanceAINetworkSummaryResponseSize(bytes: number): void;
    performanceAINetworkRequestDetailResponseSize(bytes: number): void;
    performanceAIMainThreadActivityResponseSize(bytes: number): void;
}
/**
 * The numeric enum values are not necessarily continuous! It is possible that
 * values have been removed, which results in gaps in the sequence of values.
 * When adding a new value:
 * 1. Add an entry to the bottom of the enum before 'MAX_VALUE'.
 * 2. Set the value of the new entry to the current value of 'MAX_VALUE'.
 * 2. Increment the value of 'MAX_VALUE' by 1.
 * When removing a value which is no longer needed:
 * 1. Delete the line with the unneeded value
 * 2. Do not update any 'MAX_VALUE' or any other value.
 */
export declare enum Action {
    WindowDocked = 1,
    WindowUndocked = 2,
    ScriptsBreakpointSet = 3,
    TimelineStarted = 4,
    ProfilesCPUProfileTaken = 5,
    ProfilesHeapProfileTaken = 6,
    ConsoleEvaluated = 8,
    FileSavedInWorkspace = 9,
    DeviceModeEnabled = 10,
    AnimationsPlaybackRateChanged = 11,
    RevisionApplied = 12,
    FileSystemDirectoryContentReceived = 13,
    StyleRuleEdited = 14,
    CommandEvaluatedInConsolePanel = 15,
    DOMPropertiesExpanded = 16,
    ResizedViewInResponsiveMode = 17,
    TimelinePageReloadStarted = 18,
    ConnectToNodeJSFromFrontend = 19,
    ConnectToNodeJSDirectly = 20,
    CpuThrottlingEnabled = 21,
    CpuProfileNodeFocused = 22,
    CpuProfileNodeExcluded = 23,
    SelectFileFromFilePicker = 24,
    SelectCommandFromCommandMenu = 25,
    ChangeInspectedNodeInElementsPanel = 26,
    StyleRuleCopied = 27,
    CoverageStarted = 28,
    LighthouseStarted = 29,
    LighthouseFinished = 30,
    ShowedThirdPartyBadges = 31,
    LighthouseViewTrace = 32,
    FilmStripStartedRecording = 33,
    CoverageReportFiltered = 34,
    CoverageStartedPerBlock = 35,
    'SettingsOpenedFromGear-deprecated' = 36,
    'SettingsOpenedFromMenu-deprecated' = 37,
    'SettingsOpenedFromCommandMenu-deprecated' = 38,
    TabMovedToDrawer = 39,
    TabMovedToMainPanel = 40,
    CaptureCssOverviewClicked = 41,
    VirtualAuthenticatorEnvironmentEnabled = 42,
    SourceOrderViewActivated = 43,
    UserShortcutAdded = 44,
    ShortcutRemoved = 45,
    ShortcutModified = 46,
    CustomPropertyLinkClicked = 47,
    CustomPropertyEdited = 48,
    ServiceWorkerNetworkRequestClicked = 49,
    ServiceWorkerNetworkRequestClosedQuickly = 50,
    NetworkPanelServiceWorkerRespondWith = 51,
    NetworkPanelCopyValue = 52,
    ConsoleSidebarOpened = 53,
    PerfPanelTraceImported = 54,
    PerfPanelTraceExported = 55,
    StackFrameRestarted = 56,
    CaptureTestProtocolClicked = 57,
    BreakpointRemovedFromRemoveButton = 58,
    BreakpointGroupExpandedStateChanged = 59,
    HeaderOverrideFileCreated = 60,
    HeaderOverrideEnableEditingClicked = 61,
    HeaderOverrideHeaderAdded = 62,
    HeaderOverrideHeaderEdited = 63,
    HeaderOverrideHeaderRemoved = 64,
    HeaderOverrideHeadersFileEdited = 65,
    PersistenceNetworkOverridesEnabled = 66,
    PersistenceNetworkOverridesDisabled = 67,
    BreakpointRemovedFromContextMenu = 68,
    BreakpointsInFileRemovedFromRemoveButton = 69,
    BreakpointsInFileRemovedFromContextMenu = 70,
    BreakpointsInFileCheckboxToggled = 71,
    BreakpointsInFileEnabledDisabledFromContextMenu = 72,
    BreakpointConditionEditedFromSidebar = 73,
    WorkspaceTabAddFolder = 74,
    WorkspaceTabRemoveFolder = 75,
    OverrideTabAddFolder = 76,
    OverrideTabRemoveFolder = 77,
    WorkspaceSourceSelected = 78,
    OverridesSourceSelected = 79,
    StyleSheetInitiatorLinkClicked = 80,
    BreakpointRemovedFromGutterContextMenu = 81,
    BreakpointRemovedFromGutterToggle = 82,
    StylePropertyInsideKeyframeEdited = 83,
    OverrideContentFromSourcesContextMenu = 84,
    OverrideContentFromNetworkContextMenu = 85,
    OverrideScript = 86,
    OverrideStyleSheet = 87,
    OverrideDocument = 88,
    OverrideFetchXHR = 89,
    OverrideImage = 90,
    OverrideFont = 91,
    OverrideContentContextMenuSetup = 92,
    OverrideContentContextMenuAbandonSetup = 93,
    OverrideContentContextMenuActivateDisabled = 94,
    OverrideContentContextMenuOpenExistingFile = 95,
    OverrideContentContextMenuSaveNewFile = 96,
    ShowAllOverridesFromSourcesContextMenu = 97,
    ShowAllOverridesFromNetworkContextMenu = 98,
    AnimationGroupsCleared = 99,
    AnimationsPaused = 100,
    AnimationsResumed = 101,
    AnimatedNodeDescriptionClicked = 102,
    AnimationGroupScrubbed = 103,
    AnimationGroupReplayed = 104,
    OverrideTabDeleteFolderContextMenu = 105,
    WorkspaceDropFolder = 107,
    WorkspaceSelectFolder = 108,
    OverrideContentContextMenuSourceMappedWarning = 109,
    OverrideContentContextMenuRedirectToDeployed = 110,
    NewStyleRuleAdded = 111,
    TraceExpanded = 112,
    InsightConsoleMessageShown = 113,
    InsightRequestedViaContextMenu = 114,
    InsightRequestedViaHoverButton = 115,
    InsightRatedPositive = 117,
    InsightRatedNegative = 118,
    InsightClosed = 119,
    InsightErrored = 120,
    InsightHoverButtonShown = 121,
    SelfXssWarningConsoleMessageShown = 122,
    SelfXssWarningDialogShown = 123,
    SelfXssAllowPastingInConsole = 124,
    SelfXssAllowPastingInDialog = 125,
    ToggleEmulateFocusedPageFromStylesPaneOn = 126,
    ToggleEmulateFocusedPageFromStylesPaneOff = 127,
    ToggleEmulateFocusedPageFromRenderingTab = 128,
    ToggleEmulateFocusedPageFromCommandMenu = 129,
    InsightGenerated = 130,
    InsightErroredApi = 131,
    InsightErroredMarkdown = 132,
    ToggleShowWebVitals = 133,
    InsightErroredPermissionDenied = 134,
    InsightErroredCannotSend = 135,
    InsightErroredRequestFailed = 136,
    InsightErroredCannotParseChunk = 137,
    InsightErroredUnknownChunk = 138,
    InsightErroredOther = 139,
    AutofillReceived = 140,
    AutofillReceivedAndTabAutoOpened = 141,
    AnimationGroupSelected = 142,
    ScrollDrivenAnimationGroupSelected = 143,
    ScrollDrivenAnimationGroupScrubbed = 144,
    AiAssistanceOpenedFromElementsPanel = 145,
    AiAssistanceOpenedFromStylesTab = 146,
    ConsoleFilterByContext = 147,
    ConsoleFilterBySource = 148,
    ConsoleFilterByUrl = 149,
    InsightConsentReminderShown = 150,
    InsightConsentReminderCanceled = 151,
    InsightConsentReminderConfirmed = 152,
    InsightsOnboardingShown = 153,
    InsightsOnboardingCanceledOnPage1 = 154,
    InsightsOnboardingCanceledOnPage2 = 155,
    InsightsOnboardingConfirmed = 156,
    InsightsOnboardingNextPage = 157,
    InsightsOnboardingPrevPage = 158,
    InsightsOnboardingFeatureDisabled = 159,
    InsightsOptInTeaserShown = 160,
    InsightsOptInTeaserSettingsLinkClicked = 161,
    InsightsOptInTeaserConfirmedInSettings = 162,
    InsightsReminderTeaserShown = 163,
    InsightsReminderTeaserConfirmed = 164,
    InsightsReminderTeaserCanceled = 165,
    InsightsReminderTeaserSettingsLinkClicked = 166,
    InsightsReminderTeaserAbortedInSettings = 167,
    GeneratingInsightWithoutDisclaimer = 168,
    AiAssistanceOpenedFromElementsPanelFloatingButton = 169,
    AiAssistanceOpenedFromNetworkPanel = 170,
    AiAssistanceOpenedFromSourcesPanel = 171,
    AiAssistanceOpenedFromSourcesPanelFloatingButton = 172,
    AiAssistanceOpenedFromPerformancePanelCallTree = 173,
    AiAssistanceOpenedFromNetworkPanelFloatingButton = 174,
    AiAssistancePanelOpened = 175,
    AiAssistanceQuerySubmitted = 176,
    AiAssistanceAnswerReceived = 177,
    AiAssistanceDynamicSuggestionClicked = 178,
    AiAssistanceSideEffectConfirmed = 179,
    AiAssistanceSideEffectRejected = 180,
    AiAssistanceError = 181,
    AiAssistanceOpenedFromPerformanceInsight = 182,
    AiAssistanceOpenedFromPerformanceFullButton = 183,
    AiCodeCompletionResponseServedFromCache = 184,
    AiCodeCompletionRequestTriggered = 185,
    AiCodeCompletionSuggestionDisplayed = 186,
    AiCodeCompletionSuggestionAccepted = 187,
    AiCodeCompletionError = 188,
    AttributeLinkClicked = 189,
    MAX_VALUE = 190
}
export declare enum PanelCodes {
    elements = 1,
    resources = 2,
    network = 3,
    sources = 4,
    timeline = 5,
    'heap-profiler' = 6,
    console = 8,
    layers = 9,
    'console-view' = 10,
    animations = 11,
    'network.config' = 12,
    rendering = 13,
    sensors = 14,
    'sources.search' = 15,
    security = 16,
    'js-profiler' = 17,
    lighthouse = 18,
    coverage = 19,
    'protocol-monitor' = 20,
    'remote-devices' = 21,
    'web-audio' = 22,
    'changes.changes' = 23,
    'performance.monitor' = 24,
    'release-note' = 25,
    'live-heap-profile' = 26,
    'sources.quick' = 27,
    'network.blocked-urls' = 28,
    'settings-preferences' = 29,
    'settings-workspace' = 30,
    'settings-experiments' = 31,
    'settings-blackbox' = 32,
    'settings-devices' = 33,
    'settings-throttling-conditions' = 34,
    'settings-emulation-locations' = 35,
    'settings-shortcuts' = 36,
    'issues-pane' = 37,
    'settings-keybinds' = 38,
    cssoverview = 39,
    'chrome-recorder' = 40,
    'trust-tokens' = 41,
    'reporting-api' = 42,
    'interest-groups' = 43,
    'back-forward-cache' = 44,
    'service-worker-cache' = 45,
    'background-service-background-fetch' = 46,
    'background-service-background-sync' = 47,
    'background-service-push-messaging' = 48,
    'background-service-notifications' = 49,
    'background-service-payment-handler' = 50,
    'background-service-periodic-background-sync' = 51,
    'service-workers' = 52,
    'app-manifest' = 53,
    storage = 54,
    cookies = 55,
    'frame-details' = 56,
    'frame-resource' = 57,
    'frame-window' = 58,
    'frame-worker' = 59,
    'dom-storage' = 60,
    'indexed-db' = 61,
    'web-sql' = 62,
    'performance-insights' = 63,
    preloading = 64,
    'bounce-tracking-mitigations' = 65,
    'developer-resources' = 66,
    'autofill-view' = 67,
    freestyler = 68,
    MAX_VALUE = 69
}
export declare enum MediaTypes {
    Unknown = 0,
    'text/css' = 2,
    'text/html' = 3,
    'application/xml' = 4,
    'application/wasm' = 5,
    'application/manifest+json' = 6,
    'application/x-aspx' = 7,
    'application/jsp' = 8,
    'text/x-c++src' = 9,
    'text/x-coffeescript' = 10,
    'application/vnd.dart' = 11,
    'text/typescript' = 12,
    'text/typescript-jsx' = 13,
    'application/json' = 14,
    'text/x-csharp' = 15,
    'text/x-java' = 16,
    'text/x-less' = 17,
    'application/x-httpd-php' = 18,
    'text/x-python' = 19,
    'text/x-sh' = 20,
    'text/x-gss' = 21,
    'text/x-sass' = 22,
    'text/x-scss' = 23,
    'text/markdown' = 24,
    'text/x-clojure' = 25,
    'text/jsx' = 26,
    'text/x-go' = 27,
    'text/x-kotlin' = 28,
    'text/x-scala' = 29,
    'text/x.svelte' = 30,
    'text/javascript+plain' = 31,
    'text/javascript+minified' = 32,
    'text/javascript+sourcemapped' = 33,
    'text/x.angular' = 34,
    'text/x.vue' = 35,
    'text/javascript+snippet' = 36,
    'text/javascript+eval' = 37,// Scripts resulting from console inputs or page "eval"s with no sourceUrl comment.
    MAX_VALUE = 38
}
export declare enum KeybindSetSettings {
    devToolsDefault = 0,
    vsCode = 1,
    MAX_VALUE = 2
}
export declare enum KeyboardShortcutAction {
    OtherShortcut = 0,
    'quick-open.show-command-menu' = 1,
    'console.clear' = 2,
    'console.toggle' = 3,
    'debugger.step' = 4,
    'debugger.step-into' = 5,
    'debugger.step-out' = 6,
    'debugger.step-over' = 7,
    'debugger.toggle-breakpoint' = 8,
    'debugger.toggle-breakpoint-enabled' = 9,
    'debugger.toggle-pause' = 10,
    'elements.edit-as-html' = 11,
    'elements.hide-element' = 12,
    'elements.redo' = 13,
    'elements.toggle-element-search' = 14,
    'elements.undo' = 15,
    'main.search-in-panel.find' = 16,
    'main.toggle-drawer' = 17,
    'network.hide-request-details' = 18,
    'network.search' = 19,
    'network.toggle-recording' = 20,
    'quick-open.show' = 21,
    'settings.show' = 22,
    'sources.search' = 23,
    'background-service.toggle-recording' = 24,
    'components.collect-garbage' = 25,
    'console.clear.history' = 26,
    'console.create-pin' = 27,
    'coverage.start-with-reload' = 28,
    'coverage.toggle-recording' = 29,
    'debugger.breakpoint-input-window' = 30,
    'debugger.evaluate-selection' = 31,
    'debugger.next-call-frame' = 32,
    'debugger.previous-call-frame' = 33,
    'debugger.run-snippet' = 34,
    'debugger.toggle-breakpoints-active' = 35,
    'elements.capture-area-screenshot' = 36,
    'emulation.capture-full-height-screenshot' = 37,
    'emulation.capture-node-screenshot' = 38,
    'emulation.capture-screenshot' = 39,
    'emulation.show-sensors' = 40,
    'emulation.toggle-device-mode' = 41,
    'help.release-notes' = 42,
    'help.report-issue' = 43,
    'input.start-replaying' = 44,
    'input.toggle-pause' = 45,
    'input.toggle-recording' = 46,
    'inspector-main.focus-debuggee' = 47,
    'inspector-main.hard-reload' = 48,
    'inspector-main.reload' = 49,
    'live-heap-profile.start-with-reload' = 50,
    'live-heap-profile.toggle-recording' = 51,
    'main.debug-reload' = 52,
    'main.next-tab' = 53,
    'main.previous-tab' = 54,
    'main.search-in-panel.cancel' = 55,
    'main.search-in-panel.find-next' = 56,
    'main.search-in-panel.find-previous' = 57,
    'main.toggle-dock' = 58,
    'main.zoom-in' = 59,
    'main.zoom-out' = 60,
    'main.zoom-reset' = 61,
    'network-conditions.network-low-end-mobile' = 62,
    'network-conditions.network-mid-tier-mobile' = 63,
    'network-conditions.network-offline' = 64,
    'network-conditions.network-online' = 65,
    'profiler.heap-toggle-recording' = 66,
    'profiler.js-toggle-recording' = 67,
    'resources.clear' = 68,
    'settings.documentation' = 69,
    'settings.shortcuts' = 70,
    'sources.add-folder-to-workspace' = 71,
    'sources.add-to-watch' = 72,
    'sources.close-all' = 73,
    'sources.close-editor-tab' = 74,
    'sources.create-snippet' = 75,
    'sources.go-to-line' = 76,
    'sources.go-to-member' = 77,
    'sources.jump-to-next-location' = 78,
    'sources.jump-to-previous-location' = 79,
    'sources.rename' = 80,
    'sources.save' = 81,
    'sources.save-all' = 82,
    'sources.switch-file' = 83,
    'timeline.jump-to-next-frame' = 84,
    'timeline.jump-to-previous-frame' = 85,
    'timeline.load-from-file' = 86,
    'timeline.next-recording' = 87,
    'timeline.previous-recording' = 88,
    'timeline.record-reload' = 89,
    'timeline.save-to-file' = 90,
    'timeline.show-history' = 91,
    'timeline.toggle-recording' = 92,
    'sources.increment-css' = 93,
    'sources.increment-css-by-ten' = 94,
    'sources.decrement-css' = 95,
    'sources.decrement-css-by-ten' = 96,
    'layers.reset-view' = 97,
    'layers.pan-mode' = 98,
    'layers.rotate-mode' = 99,
    'layers.zoom-in' = 100,
    'layers.zoom-out' = 101,
    'layers.up' = 102,
    'layers.down' = 103,
    'layers.left' = 104,
    'layers.right' = 105,
    'help.report-translation-issue' = 106,
    'rendering.toggle-prefers-color-scheme' = 107,
    'chrome-recorder.start-recording' = 108,
    'chrome-recorder.replay-recording' = 109,
    'chrome-recorder.toggle-code-view' = 110,
    'chrome-recorder.copy-recording-or-step' = 111,
    'elements.new-style-rule' = 114,
    'elements.refresh-event-listeners' = 115,
    'coverage.clear' = 116,
    'coverage.export' = 117,
    'timeline.dim-third-parties' = 118,
    'main.toggle-drawer-orientation' = 119,
    MAX_VALUE = 120
}
export declare const enum IssueOpener {
    CONSOLE_INFO_BAR = 0,
    LEARN_MORE_LINK_COEP = 1,
    STATUS_BAR_ISSUES_COUNTER = 2,
    HAMBURGER_MENU = 3,
    ADORNER = 4,
    COMMAND_MENU = 5,
    MAX_VALUE = 6
}
/**
 * This list should contain the currently active Devtools Experiments,
 * gaps are expected.
 */
export declare enum DevtoolsExperiments {
    'capture-node-creation-stacks' = 1,
    'live-heap-profile' = 11,
    'protocol-monitor' = 13,
    'sampling-heap-profiler-timeline' = 17,
    'show-option-tp-expose-internals-in-heap-snapshot' = 18,
    'timeline-invalidation-tracking' = 26,
    'timeline-show-all-events' = 27,
    'timeline-v8-runtime-call-stats' = 28,
    apca = 39,
    'font-editor' = 41,
    'full-accessibility-tree' = 42,
    'contrast-issues' = 44,
    'experimental-cookie-features' = 45,
    'instrumentation-breakpoints' = 61,
    'authored-deployed-grouping' = 63,
    'just-my-code' = 65,
    'use-source-map-scopes' = 76,
    'timeline-show-postmessage-events' = 86,
    'timeline-enhanced-traces' = 90,
    'timeline-compiled-sources' = 91,
    'timeline-debug-mode' = 93,
    MAX_VALUE = 110
}
export declare enum IssueExpanded {
    CrossOriginEmbedderPolicy = 0,
    MixedContent = 1,
    SameSiteCookie = 2,
    HeavyAd = 3,
    ContentSecurityPolicy = 4,
    Other = 5,
    Generic = 6,
    ThirdPartyPhaseoutCookie = 7,
    GenericCookie = 8,
    MAX_VALUE = 9
}
export declare enum IssueResourceOpened {
    CrossOriginEmbedderPolicyRequest = 0,
    CrossOriginEmbedderPolicyElement = 1,
    MixedContentRequest = 2,
    SameSiteCookieCookie = 3,
    SameSiteCookieRequest = 4,
    HeavyAdElement = 5,
    ContentSecurityPolicyDirective = 6,
    ContentSecurityPolicyElement = 7,
    MAX_VALUE = 13
}
/**
 * This list should contain the currently active issue types,
 * gaps are expected.
 */
export declare enum IssueCreated {
    MixedContentIssue = 0,
    'ContentSecurityPolicyIssue::kInlineViolation' = 1,
    'ContentSecurityPolicyIssue::kEvalViolation' = 2,
    'ContentSecurityPolicyIssue::kURLViolation' = 3,
    'ContentSecurityPolicyIssue::kTrustedTypesSinkViolation' = 4,
    'ContentSecurityPolicyIssue::kTrustedTypesPolicyViolation' = 5,
    'HeavyAdIssue::NetworkTotalLimit' = 6,
    'HeavyAdIssue::CpuTotalLimit' = 7,
    'HeavyAdIssue::CpuPeakLimit' = 8,
    'CrossOriginEmbedderPolicyIssue::CoepFrameResourceNeedsCoepHeader' = 9,
    'CrossOriginEmbedderPolicyIssue::CoopSandboxedIFrameCannotNavigateToCoopPage' = 10,
    'CrossOriginEmbedderPolicyIssue::CorpNotSameOrigin' = 11,
    'CrossOriginEmbedderPolicyIssue::CorpNotSameOriginAfterDefaultedToSameOriginByCoep' = 12,
    'CrossOriginEmbedderPolicyIssue::CorpNotSameSite' = 13,
    'CookieIssue::ExcludeSameSiteNoneInsecure::ReadCookie' = 14,
    'CookieIssue::ExcludeSameSiteNoneInsecure::SetCookie' = 15,
    'CookieIssue::WarnSameSiteNoneInsecure::ReadCookie' = 16,
    'CookieIssue::WarnSameSiteNoneInsecure::SetCookie' = 17,
    'CookieIssue::WarnSameSiteStrictLaxDowngradeStrict::Secure' = 18,
    'CookieIssue::WarnSameSiteStrictLaxDowngradeStrict::Insecure' = 19,
    'CookieIssue::WarnCrossDowngrade::ReadCookie::Secure' = 20,
    'CookieIssue::WarnCrossDowngrade::ReadCookie::Insecure' = 21,
    'CookieIssue::WarnCrossDowngrade::SetCookie::Secure' = 22,
    'CookieIssue::WarnCrossDowngrade::SetCookie::Insecure' = 23,
    'CookieIssue::ExcludeNavigationContextDowngrade::Secure' = 24,
    'CookieIssue::ExcludeNavigationContextDowngrade::Insecure' = 25,
    'CookieIssue::ExcludeContextDowngrade::ReadCookie::Secure' = 26,
    'CookieIssue::ExcludeContextDowngrade::ReadCookie::Insecure' = 27,
    'CookieIssue::ExcludeContextDowngrade::SetCookie::Secure' = 28,
    'CookieIssue::ExcludeContextDowngrade::SetCookie::Insecure' = 29,
    'CookieIssue::ExcludeSameSiteUnspecifiedTreatedAsLax::ReadCookie' = 30,
    'CookieIssue::ExcludeSameSiteUnspecifiedTreatedAsLax::SetCookie' = 31,
    'CookieIssue::WarnSameSiteUnspecifiedLaxAllowUnsafe::ReadCookie' = 32,
    'CookieIssue::WarnSameSiteUnspecifiedLaxAllowUnsafe::SetCookie' = 33,
    'CookieIssue::WarnSameSiteUnspecifiedCrossSiteContext::ReadCookie' = 34,
    'CookieIssue::WarnSameSiteUnspecifiedCrossSiteContext::SetCookie' = 35,
    'SharedArrayBufferIssue::TransferIssue' = 36,
    'SharedArrayBufferIssue::CreationIssue' = 37,
    LowTextContrastIssue = 41,
    'CorsIssue::InsecurePrivateNetwork' = 42,
    'CorsIssue::InvalidHeaders' = 44,
    'CorsIssue::WildcardOriginWithCredentials' = 45,
    'CorsIssue::PreflightResponseInvalid' = 46,
    'CorsIssue::OriginMismatch' = 47,
    'CorsIssue::AllowCredentialsRequired' = 48,
    'CorsIssue::MethodDisallowedByPreflightResponse' = 49,
    'CorsIssue::HeaderDisallowedByPreflightResponse' = 50,
    'CorsIssue::RedirectContainsCredentials' = 51,
    'CorsIssue::DisallowedByMode' = 52,
    'CorsIssue::CorsDisabledScheme' = 53,
    'CorsIssue::PreflightMissingAllowExternal' = 54,
    'CorsIssue::PreflightInvalidAllowExternal' = 55,
    'CorsIssue::NoCorsRedirectModeNotFollow' = 57,
    'QuirksModeIssue::QuirksMode' = 58,
    'QuirksModeIssue::LimitedQuirksMode' = 59,
    DeprecationIssue = 60,
    'ClientHintIssue::MetaTagAllowListInvalidOrigin' = 61,
    'ClientHintIssue::MetaTagModifiedHTML' = 62,
    'CorsIssue::PreflightAllowPrivateNetworkError' = 63,
    'GenericIssue::CrossOriginPortalPostMessageError' = 64,
    'GenericIssue::FormLabelForNameError' = 65,
    'GenericIssue::FormDuplicateIdForInputError' = 66,
    'GenericIssue::FormInputWithNoLabelError' = 67,
    'GenericIssue::FormAutocompleteAttributeEmptyError' = 68,
    'GenericIssue::FormEmptyIdAndNameAttributesForInputError' = 69,
    'GenericIssue::FormAriaLabelledByToNonExistingId' = 70,
    'GenericIssue::FormInputAssignedAutocompleteValueToIdOrNameAttributeError' = 71,
    'GenericIssue::FormLabelHasNeitherForNorNestedInput' = 72,
    'GenericIssue::FormLabelForMatchesNonExistingIdError' = 73,
    'GenericIssue::FormHasPasswordFieldWithoutUsernameFieldError' = 74,
    'GenericIssue::FormInputHasWrongButWellIntendedAutocompleteValueError' = 75,
    'StylesheetLoadingIssue::LateImportRule' = 76,
    'StylesheetLoadingIssue::RequestFailed' = 77,
    'CorsIssue::PreflightMissingPrivateNetworkAccessId' = 78,
    'CorsIssue::PreflightMissingPrivateNetworkAccessName' = 79,
    'CorsIssue::PrivateNetworkAccessPermissionUnavailable' = 80,
    'CorsIssue::PrivateNetworkAccessPermissionDenied' = 81,
    'CookieIssue::WarnThirdPartyPhaseout::ReadCookie' = 82,
    'CookieIssue::WarnThirdPartyPhaseout::SetCookie' = 83,
    'CookieIssue::ExcludeThirdPartyPhaseout::ReadCookie' = 84,
    'CookieIssue::ExcludeThirdPartyPhaseout::SetCookie' = 85,
    'ElementAccessibilityIssue::DisallowedSelectChild' = 86,
    'ElementAccessibilityIssue::DisallowedOptGroupChild' = 87,
    'ElementAccessibilityIssue::NonPhrasingContentOptionChild' = 88,
    'ElementAccessibilityIssue::InteractiveContentOptionChild' = 89,
    'ElementAccessibilityIssue::InteractiveContentLegendChild' = 90,
    'SRIMessageSignatureIssue::MissingSignatureHeader' = 91,
    'SRIMessageSignatureIssue::MissingSignatureInputHeader' = 92,
    'SRIMessageSignatureIssue::InvalidSignatureHeader' = 93,
    'SRIMessageSignatureIssue::InvalidSignatureInputHeader' = 94,
    'SRIMessageSignatureIssue::SignatureHeaderValueIsNotByteSequence' = 95,
    'SRIMessageSignatureIssue::SignatureHeaderValueIsParameterized' = 96,
    'SRIMessageSignatureIssue::SignatureHeaderValueIsIncorrectLength' = 97,
    'SRIMessageSignatureIssue::SignatureInputHeaderMissingLabel' = 98,
    'SRIMessageSignatureIssue::SignatureInputHeaderValueNotInnerList' = 99,
    'SRIMessageSignatureIssue::SignatureInputHeaderValueMissingComponents' = 100,
    'SRIMessageSignatureIssue::SignatureInputHeaderInvalidComponentType' = 101,
    'SRIMessageSignatureIssue::SignatureInputHeaderInvalidComponentName' = 102,
    'SRIMessageSignatureIssue::SignatureInputHeaderInvalidHeaderComponentParameter' = 103,
    'SRIMessageSignatureIssue::SignatureInputHeaderInvalidDerivedComponentParameter' = 104,
    'SRIMessageSignatureIssue::SignatureInputHeaderKeyIdLength' = 105,
    'SRIMessageSignatureIssue::SignatureInputHeaderInvalidParameter' = 106,
    'SRIMessageSignatureIssue::SignatureInputHeaderMissingRequiredParameters' = 107,
    'SRIMessageSignatureIssue::ValidationFailedSignatureExpired' = 108,
    'SRIMessageSignatureIssue::ValidationFailedInvalidLength' = 109,
    'SRIMessageSignatureIssue::ValidationFailedSignatureMismatch' = 110,
    'CorsIssue::LocalNetworkAccessPermissionDenied' = 111,
    'SRIMessageSignatureIssue::ValidationFailedIntegrityMismatch' = 112,
    'ElementAccessibilityIssue::InteractiveContentSummaryDescendant' = 113,
    MAX_VALUE = 114
}
export declare const enum DeveloperResourceLoaded {
    LOAD_THROUGH_PAGE_VIA_TARGET = 0,
    LOAD_THROUGH_PAGE_VIA_FRAME = 1,
    LOAD_THROUGH_PAGE_FAILURE = 2,
    LOAD_THROUGH_PAGE_FALLBACK = 3,
    FALLBACK_AFTER_FAILURE = 4,
    FALLBACK_PER_OVERRIDE = 5,
    FALLBACK_PER_PROTOCOL = 6,
    FALLBACK_FAILURE = 7,
    MAX_VALUE = 8
}
export declare const enum DeveloperResourceScheme {
    OTHER = 0,
    UKNOWN = 1,
    HTTP = 2,
    HTTPS = 3,
    HTTP_LOCALHOST = 4,
    HTTPS_LOCALHOST = 5,
    DATA = 6,
    FILE = 7,
    BLOB = 8,
    MAX_VALUE = 9
}
export declare enum Language {
    af = 1,
    am = 2,
    ar = 3,
    as = 4,
    az = 5,
    be = 6,
    bg = 7,
    bn = 8,
    bs = 9,
    ca = 10,
    cs = 11,
    cy = 12,
    da = 13,
    de = 14,
    el = 15,
    'en-GB' = 16,
    'en-US' = 17,
    'es-419' = 18,
    es = 19,
    et = 20,
    eu = 21,
    fa = 22,
    fi = 23,
    fil = 24,
    'fr-CA' = 25,
    fr = 26,
    gl = 27,
    gu = 28,
    he = 29,
    hi = 30,
    hr = 31,
    hu = 32,
    hy = 33,
    id = 34,
    is = 35,
    it = 36,
    ja = 37,
    ka = 38,
    kk = 39,
    km = 40,
    kn = 41,
    ko = 42,
    ky = 43,
    lo = 44,
    lt = 45,
    lv = 46,
    mk = 47,
    ml = 48,
    mn = 49,
    mr = 50,
    ms = 51,
    my = 52,
    ne = 53,
    nl = 54,
    no = 55,
    or = 56,
    pa = 57,
    pl = 58,
    'pt-PT' = 59,
    pt = 60,
    ro = 61,
    ru = 62,
    si = 63,
    sk = 64,
    sl = 65,
    sq = 66,
    'sr-Latn' = 67,
    sr = 68,
    sv = 69,
    sw = 70,
    ta = 71,
    te = 72,
    th = 73,
    tr = 74,
    uk = 75,
    ur = 76,
    uz = 77,
    vi = 78,
    zh = 79,
    'zh-HK' = 80,
    'zh-TW' = 81,
    zu = 82,
    MAX_VALUE = 83
}
export declare const enum SyncSetting {
    CHROME_SYNC_DISABLED = 1,
    CHROME_SYNC_SETTINGS_DISABLED = 2,
    DEVTOOLS_SYNC_SETTING_DISABLED = 3,
    DEVTOOLS_SYNC_SETTING_ENABLED = 4,
    MAX_VALUE = 5
}
export declare const enum RecordingToggled {
    RECORDING_STARTED = 1,
    RECORDING_FINISHED = 2,
    MAX_VALUE = 3
}
export declare const enum RecordingAssertion {
    ASSERTION_ADDED = 1,
    PROPERTY_ASSERTION_EDITED = 2,
    ATTRIBUTE_ASSERTION_EDITED = 3,
    MAX_VALUE = 4
}
export declare const enum RecordingReplayFinished {
    SUCCESS = 1,
    TIMEOUT_ERROR_SELECTORS = 2,
    TIMEOUT_ERROR_TARGET = 3,
    OTHER_ERROR = 4,
    MAX_VALUE = 5
}
export declare const enum RecordingReplaySpeed {
    NORMAL = 1,
    SLOW = 2,
    VERY_SLOW = 3,
    EXTREMELY_SLOW = 4,
    MAX_VALUE = 5
}
export declare const enum RecordingReplayStarted {
    REPLAY_ONLY = 1,
    REPLAY_WITH_PERFORMANCE_TRACING = 2,
    REPLAY_VIA_EXTENSION = 3,
    MAX_VALUE = 4
}
export declare const enum RecordingEdited {
    SELECTOR_PICKER_USED = 1,
    STEP_ADDED = 2,
    STEP_REMOVED = 3,
    SELECTOR_ADDED = 4,
    SELECTOR_REMOVED = 5,
    SELECTOR_PART_ADDED = 6,
    SELECTOR_PART_EDITED = 7,
    SELECTOR_PART_REMOVED = 8,
    TYPE_CHANGED = 9,
    OTHER_EDITING = 10,
    MAX_VALUE = 11
}
export declare const enum RecordingExported {
    TO_PUPPETEER = 1,
    TO_JSON = 2,
    TO_PUPPETEER_REPLAY = 3,
    TO_EXTENSION = 4,
    TO_LIGHTHOUSE = 5,
    MAX_VALUE = 6
}
export declare const enum RecordingCodeToggled {
    CODE_SHOWN = 1,
    CODE_HIDDEN = 2,
    MAX_VALUE = 3
}
export declare const enum RecordingCopiedToClipboard {
    COPIED_RECORDING_WITH_PUPPETEER = 1,
    COPIED_RECORDING_WITH_JSON = 2,
    COPIED_RECORDING_WITH_REPLAY = 3,
    COPIED_RECORDING_WITH_EXTENSION = 4,
    COPIED_STEP_WITH_PUPPETEER = 5,
    COPIED_STEP_WITH_JSON = 6,
    COPIED_STEP_WITH_REPLAY = 7,
    COPIED_STEP_WITH_EXTENSION = 8,
    MAX_VALUE = 9
}
export declare enum ManifestSectionCodes {
    OtherSection = 0,
    Identity = 1,
    Presentation = 2,
    'Protocol Handlers' = 3,
    Icons = 4,
    'Window Controls Overlay' = 5,
    MAX_VALUE = 6
}
export declare const enum LighthouseModeRun {
    NAVIGATION = 0,
    TIMESPAN = 1,
    SNAPSHOT = 2,
    LEGACY_NAVIGATION = 3,
    MAX_VALUE = 4
}
export declare const enum LighthouseCategoryUsed {
    PERFORMANCE = 0,
    ACCESSIBILITY = 1,
    BEST_PRACTICES = 2,
    SEO = 3,
    PWA = 4,
    PUB_ADS = 5,
    MAX_VALUE = 6
}
export declare const enum SwatchType {
    VAR_LINK = 0,
    ANIMATION_NAME_LINK = 1,
    COLOR = 2,
    ANIMATION_TIMING = 3,
    SHADOW = 4,
    GRID = 5,
    FLEX = 6,
    ANGLE = 7,
    LENGTH = 8,
    POSITION_TRY_LINK = 10,
    ATTR_LINK = 11,
    MAX_VALUE = 12
}
export declare const enum BadgeType {
    GRID = 0,
    SUBGRID = 1,
    FLEX = 2,
    AD = 3,
    SCROLL_SNAP = 4,
    CONTAINER = 5,
    SLOT = 6,
    TOP_LAYER = 7,
    REVEAL = 8,
    MAX_VALUE = 9
}
export declare const enum AnimationsPlaybackRate {
    PERCENT_100 = 0,
    PERCENT_25 = 1,
    PERCENT_10 = 2,
    OTHER = 3,
    MAX_VALUE = 4
}
export declare const enum TimelineNavigationSetting {
    CLASSIC_AT_SESSION_FIRST_TRACE = 0,
    MODERN_AT_SESSION_FIRST_TRACE = 1,
    SWITCHED_TO_CLASSIC = 2,
    SWITCHED_TO_MODERN = 3,
    MAX_VALUE = 4
}
