// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/runtime_enabled_features_test_helpers.h.tmpl
// and input files:
//   ../../third_party/blink/renderer/platform/runtime_enabled_features.json5


#ifndef THIRD_PARTY_BLINK_RENDERER_PLATFORM_RUNTIME_ENABLED_FEATURES_TEST_HELPERS_H_
#define THIRD_PARTY_BLINK_RENDERER_PLATFORM_RUNTIME_ENABLED_FEATURES_TEST_HELPERS_H_

#include "base/check_op.h"
#include "base/memory/protected_memory.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {

// Don't use this class directly. Use Scoped*ForTest instead.
class RuntimeEnabledFeaturesTestHelpers {
 public:
  template <bool& data_member>
  class [[nodiscard]] ScopedRuntimeEnabledFeature {
   public:
    ScopedRuntimeEnabledFeature(bool enabled)
        : enabled_(enabled), original_(data_member) { data_member = enabled; }
    ~ScopedRuntimeEnabledFeature() {
      CHECK_EQ(enabled_, data_member);
      data_member = original_;
    }
   private:
    bool enabled_;
    bool original_;
  };

  template <base::ProtectedMemory<bool>& data_member>
  class [[nodiscard]] ScopedRuntimeEnabledProtectedFeature {
   public:
    ScopedRuntimeEnabledProtectedFeature(bool enabled)
        : enabled_(enabled), original_(*data_member) {
      base::AutoWritableMemory data_member_writer(data_member);
      data_member_writer.GetProtectedData() = enabled;
    }
    ~ScopedRuntimeEnabledProtectedFeature() {
      CHECK_EQ(enabled_, *data_member);
      base::AutoWritableMemory data_member_writer(data_member);
      data_member_writer.GetProtectedData() = original_;
    }
   private:
    bool enabled_;
    bool original_;
  };

  using ScopedAbortByPlaceholderLayout = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_abort_by_placeholder_layout_enabled_>;
  using ScopedAboutBlankPageRespectsDarkModeOnUserAction = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_about_blank_page_respects_dark_mode_on_user_action_enabled_>;
  using ScopedAccelerated2dCanvas = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accelerated_2d_canvas_enabled_>;
  using ScopedAcceleratedSmallCanvases = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accelerated_small_canvases_enabled_>;
  using ScopedAccessibilityAriaVirtualContent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accessibility_aria_virtual_content_enabled_>;
  using ScopedAccessibilityCustomElementRoleNone = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accessibility_custom_element_role_none_enabled_>;
  using ScopedAccessibilityExposeDisplayNone = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accessibility_expose_display_none_enabled_>;
  using ScopedAccessibilityImplicitActions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accessibility_implicit_actions_enabled_>;
  using ScopedAccessibilityMinRoleTabbable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accessibility_min_role_tabbable_enabled_>;
  using ScopedAccessibilityOSLevelBoldText = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accessibility_os_level_bold_text_enabled_>;
  using ScopedAccessibilityProhibitedNames = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accessibility_prohibited_names_enabled_>;
  using ScopedAccessibilitySerializationSizeMetrics = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accessibility_serialization_size_metrics_enabled_>;
  using ScopedAccessibilityUseAXPositionForDocumentMarkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_accessibility_use_ax_position_for_document_markers_enabled_>;
  using ScopedAccessKeyLabel = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_access_key_label_enabled_>;
  using ScopedAddressSpace = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_address_space_enabled_>;
  using ScopedAdInterestGroupAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ad_interest_group_api_enabled_>;
  using ScopedAdjustDOMOffsetToLayoutOffsetForSecureText = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_adjust_dom_offset_to_layout_offset_for_secure_text_enabled_>;
  using ScopedAdjustEndOfNextParagraphIfMovedParagraphIsUpdated = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_adjust_end_of_next_paragraph_if_moved_paragraph_is_updated_enabled_>;
  using ScopedAdTagging = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ad_tagging_enabled_>;
  using ScopedAIPageContentPaidContentAnnotation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_page_content_paid_content_annotation_enabled_>;
  using ScopedAIPromptAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_prompt_api_enabled_>;
  using ScopedAIPromptAPIForExtension = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_prompt_api_for_extension_enabled_>;
  using ScopedAIPromptAPIForWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_prompt_api_for_workers_enabled_>;
  using ScopedAIPromptAPIMultimodalInput = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_prompt_api_multimodal_input_enabled_>;
  using ScopedAIPromptAPIStructuredOutput = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_prompt_api_structured_output_enabled_>;
  using ScopedAIProofreadingAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_proofreading_api_enabled_>;
  using ScopedAIRewriterAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_rewriter_api_enabled_>;
  using ScopedAIRewriterAPIForWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_rewriter_api_for_workers_enabled_>;
  using ScopedAISummarizationAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_summarization_api_enabled_>;
  using ScopedAISummarizationAPIForWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_summarization_api_for_workers_enabled_>;
  using ScopedAIWriterAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_writer_api_enabled_>;
  using ScopedAIWriterAPIForWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ai_writer_api_for_workers_enabled_>;
  using ScopedAlignZoomToCenter = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_align_zoom_to_center_enabled_>;
  using ScopedAllowContentInitiatedDataUrlNavigations = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_allow_content_initiated_data_url_navigations_enabled_>;
  using ScopedAllowCopyingEmptyLastTableCell = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_allow_copying_empty_last_table_cell_enabled_>;
  using ScopedAllowPreloadingWithCSPMetaTag = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_allow_preloading_with_csp_meta_tag_enabled_>;
  using ScopedAllowSameSiteNoneCookiesInSandbox = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_allow_same_site_none_cookies_in_sandbox_enabled_>;
  using ScopedAllowSkippingEditingBoundaryToMergeEnd = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_allow_skipping_editing_boundary_to_merge_end_enabled_>;
  using ScopedAllowSvgUseToReferenceExternalDocumentRoot = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_allow_svg_use_to_reference_external_document_root_enabled_>;
  using ScopedAllowSyntheticTimingForCanvasCapture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_allow_synthetic_timing_for_canvas_capture_enabled_>;
  using ScopedAllowURNsInIframes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_allow_ur_ns_in_iframes_enabled_>;
  using ScopedAncestorRevealingNewSpec = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ancestor_revealing_new_spec_enabled_>;
  using ScopedAnchorPositionAdjustmentWithoutOverflow = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_anchor_position_adjustment_without_overflow_enabled_>;
  using ScopedAnchorsVisibleInitialValue = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_anchors_visible_initial_value_enabled_>;
  using ScopedAndroidDownloadableFontsMatching = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_android_downloadable_fonts_matching_enabled_>;
  using ScopedAnimationProgressAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_animation_progress_api_enabled_>;
  using ScopedAnimationTrigger = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_animation_trigger_enabled_>;
  using ScopedAnimationWorklet = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_animation_worklet_enabled_>;
  using ScopedAnonymousIframe = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_anonymous_iframe_enabled_>;
  using ScopedAOMAriaRelationshipProperties = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_aom_aria_relationship_properties_enabled_>;
  using ScopedAOMAriaRelationshipPropertiesAriaOwns = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_aom_aria_relationship_properties_aria_owns_enabled_>;
  using ScopedAppTitle = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_app_title_enabled_>;
  using ScopedAriaActions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_aria_actions_enabled_>;
  using ScopedAriaNotify = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_aria_notify_enabled_>;
  using ScopedAriaNotifyV2 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_aria_notify_v_2_enabled_>;
  using ScopedAriaRowColIndexText = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_aria_row_col_index_text_enabled_>;
  using ScopedAsymmetricWordBoundaryFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_asymmetric_word_boundary_fix_enabled_>;
  using ScopedAsyncSetCookie = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_async_set_cookie_enabled_>;
  using ScopedAttributionReporting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_attribution_reporting_enabled_>;
  using ScopedAudioContextOnError = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_audio_context_on_error_enabled_>;
  using ScopedAudioContextPlayoutStats = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_audio_context_playout_stats_enabled_>;
  using ScopedAudioContextSetSinkId = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_audio_context_set_sink_id_enabled_>;
  using ScopedAudioOutputDevices = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_audio_output_devices_enabled_>;
  using ScopedAudioVideoTracks = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_audio_video_tracks_enabled_>;
  using ScopedAuthenticatorPasswordsOnlyImmediateRequests = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_authenticator_passwords_only_immediate_requests_enabled_>;
  using ScopedAutoDarkMode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_auto_dark_mode_enabled_>;
  using ScopedAutomationControlled = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_automation_controlled_enabled_>;
  using ScopedAutoPictureInPictureVideoHeuristics = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_auto_picture_in_picture_video_heuristics_enabled_>;
  using ScopedAvoidForcedLayoutOnInvisibleDocumentClose = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_avoid_forced_layout_on_invisible_document_close_enabled_>;
  using ScopedAvoidNormalizingVisiblePositionsWhenStartEqualsEnd = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_avoid_normalizing_visible_positions_when_start_equals_end_enabled_>;
  using ScopedBackdropRootForClipPathWithBackdropFilter = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_backdrop_root_for_clip_path_with_backdrop_filter_enabled_>;
  using ScopedBackfaceVisibilityInterop = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_backface_visibility_interop_enabled_>;
  using ScopedBackForwardCache = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_back_forward_cache_enabled_>;
  using ScopedBackForwardCacheExperimentHTTPHeader = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_back_forward_cache_experiment_http_header_enabled_>;
  using ScopedBackForwardCacheNotRestoredReasons = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_back_forward_cache_not_restored_reasons_enabled_>;
  using ScopedBackForwardCacheRestorationPerformanceEntry = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_back_forward_cache_restoration_performance_entry_enabled_>;
  using ScopedBackForwardCacheUpdateNotRestoredReasonsName = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_back_forward_cache_update_not_restored_reasons_name_enabled_>;
  using ScopedBackForwardTransitions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_back_forward_transitions_enabled_>;
  using ScopedBackgroundFetch = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_background_fetch_enabled_>;
  using ScopedBackgroundPageFreezeOptOut = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_background_page_freeze_opt_out_enabled_>;
  using ScopedBarcodeDetector = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_barcode_detector_enabled_>;
  using ScopedBidiCaretAffinity = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_bidi_caret_affinity_enabled_>;
  using ScopedBlinkExtensionChromeOS = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_blink_extension_chrome_os_enabled_>;
  using ScopedBlinkExtensionChromeOSKiosk = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_blink_extension_chrome_os_kiosk_enabled_>;
  using ScopedBlinkExtensionWebView = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_blink_extension_web_view_enabled_>;
  using ScopedBlinkExtensionWebViewMediaIntegrity = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_blink_extension_web_view_media_integrity_enabled_>;
  using ScopedBlinkLifecycleScriptForbidden = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_blink_lifecycle_script_forbidden_enabled_>;
  using ScopedBlinkRuntimeCallStats = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_blink_runtime_call_stats_enabled_>;
  using ScopedBlobBytes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_blob_bytes_enabled_>;
  using ScopedBlockCanvasReadback = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_block_canvas_readback_enabled_>;
  using ScopedBlockingFocusWithoutUserActivation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_blocking_focus_without_user_activation_enabled_>;
  using ScopedBoundaryEventDispatchTracksNodeRemoval = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_boundary_event_dispatch_tracks_node_removal_enabled_>;
  using ScopedBrowserInitiatedAutomaticPictureInPicture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_browser_initiated_automatic_picture_in_picture_enabled_>;
  using ScopedBrowserVerifiedUserActivationKeyboard = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_browser_verified_user_activation_keyboard_enabled_>;
  using ScopedBrowserVerifiedUserActivationMouse = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_browser_verified_user_activation_mouse_enabled_>;
  using ScopedBufferedBytesConsumerLimitSize = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_buffered_bytes_consumer_limit_size_enabled_>;
  using ScopedBuiltInAIAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_built_in_aiapi_enabled_>;
  using ScopedBypassPepcSecurityForTesting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_bypass_pepc_security_for_testing_enabled_>;
  using ScopedCacheStorageCodeCacheHint = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_cache_storage_code_cache_hint_enabled_>;
  using ScopedCallExitNodeWithoutLayoutObject = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_call_exit_node_without_layout_object_enabled_>;
  using ScopedCanvas2dCanvasFilter = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_2d_canvas_filter_enabled_>;
  using ScopedCanvas2dGPUTransfer = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_2d_gpu_transfer_enabled_>;
  using ScopedCanvas2dImageChromium = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_2d_image_chromium_enabled_>;
  using ScopedCanvas2dLayers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_2d_layers_enabled_>;
  using ScopedCanvas2dLayersWithOptions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_2d_layers_with_options_enabled_>;
  using ScopedCanvas2dMesh = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_2d_mesh_enabled_>;
  using ScopedCanvasDrawElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_draw_element_enabled_>;
  using ScopedCanvasDrawElementInSubtree = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_draw_element_in_subtree_enabled_>;
  using ScopedCanvasFloatingPoint = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_floating_point_enabled_>;
  using ScopedCanvasGlobalHDRHeadroom = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_global_hdr_headroom_enabled_>;
  using ScopedCanvasGradientCSSColor4 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_gradient_css_color_4_enabled_>;
  using ScopedCanvasHDR = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_hdr_enabled_>;
  using ScopedCanvasInterventionsTest = ScopedRuntimeEnabledProtectedFeature<
    RuntimeEnabledFeaturesBase::is_canvas_interventions_test_enabled_>;
  using ScopedCanvasTextCacheLimit = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_text_cache_limit_enabled_>;
  using ScopedCanvasTextNg = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_text_ng_enabled_>;
  using ScopedCanvasTextTexImage2DFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_text_tex_image_2d_fix_enabled_>;
  using ScopedCanvasUsesArcPaintOp = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_canvas_uses_arc_paint_op_enabled_>;
  using ScopedCapabilityDelegationDisplayCaptureRequest = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_capability_delegation_display_capture_request_enabled_>;
  using ScopedCaptureController = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_capture_controller_enabled_>;
  using ScopedCapturedMouseEvents = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_captured_mouse_events_enabled_>;
  using ScopedCapturedSurfaceControl = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_captured_surface_control_enabled_>;
  using ScopedCapturedSurfaceResolution = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_captured_surface_resolution_enabled_>;
  using ScopedCaptureHandle = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_capture_handle_enabled_>;
  using ScopedCaretPositionFromPointTextareaFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_caret_position_from_point_textarea_fix_enabled_>;
  using ScopedCaretWithTextAffinityUpstream = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_caret_with_text_affinity_upstream_enabled_>;
  using ScopedCascadedAfterChangeStyle = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_cascaded_after_change_style_enabled_>;
  using ScopedCCTNewRFMPushBehavior = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_cct_new_rfm_push_behavior_enabled_>;
  using ScopedCheckForCanonicalPositionInIdleSpellCheck = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_check_for_canonical_position_in_idle_spell_check_enabled_>;
  using ScopedCheckVisibilityExtraProperties = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_check_visibility_extra_properties_enabled_>;
  using ScopedClientHintUAHighEntropyValuesPermissionPolicy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_client_hint_ua_high_entropy_values_permission_policy_enabled_>;
  using ScopedClipboardChangeEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_clipboard_change_event_enabled_>;
  using ScopedClipboardEventTargetCanBeFocusedElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_clipboard_event_target_can_be_focused_element_enabled_>;
  using ScopedClipboardItemWithDOMStringSupport = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_clipboard_item_with_dom_string_support_enabled_>;
  using ScopedClipElementVisibleBoundsInLocalRoot = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_clip_element_visible_bounds_in_local_root_enabled_>;
  using ScopedClipPathNestedRasterOptimization = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_clip_path_nested_raster_optimization_enabled_>;
  using ScopedCoalesceSelectionchangeEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_coalesce_selectionchange_event_enabled_>;
  using ScopedCoepReflection = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_coep_reflection_enabled_>;
  using ScopedCollapseZeroWidthSpaceWhenReuseItem = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_collapse_zero_width_space_when_reuse_item_enabled_>;
  using ScopedColorSpaceRec2100Linear = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_color_space_rec_2100_linear_enabled_>;
  using ScopedCommandEventNotComposed = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_command_event_not_composed_enabled_>;
  using ScopedComposedPathEmptyAfterDispatch = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_composed_path_empty_after_dispatch_enabled_>;
  using ScopedCompositeBGColorAnimation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_composite_bg_color_animation_enabled_>;
  using ScopedCompositeBoxShadowAnimation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_composite_box_shadow_animation_enabled_>;
  using ScopedCompositeClipPathAnimation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_composite_clip_path_animation_enabled_>;
  using ScopedCompositedAnimationsCancelledAsynchronously = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_composited_animations_cancelled_asynchronously_enabled_>;
  using ScopedCompositedSelectionUpdate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_composited_selection_update_enabled_>;
  using ScopedCompositingDecisionAtAnimationPhaseBoundaries = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_compositing_decision_at_animation_phase_boundaries_enabled_>;
  using ScopedCompositionForegroundMarkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_composition_foreground_markers_enabled_>;
  using ScopedCompressionDictionaryTransport = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_compression_dictionary_transport_enabled_>;
  using ScopedComputedAccessibilityInfo = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_computed_accessibility_info_enabled_>;
  using ScopedComputePressure = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_compute_pressure_enabled_>;
  using ScopedComputePressureOwnContributionEstimate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_compute_pressure_own_contribution_estimate_enabled_>;
  using ScopedConsiderSubOrSuperScriptAncestorAlignForCaretSelection = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_consider_sub_or_super_script_ancestor_align_for_caret_selection_enabled_>;
  using ScopedContactsManager = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_contacts_manager_enabled_>;
  using ScopedContactsManagerExtraProperties = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_contacts_manager_extra_properties_enabled_>;
  using ScopedContainerTiming = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_container_timing_enabled_>;
  using ScopedContainerTypeNoLayoutContainment = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_container_type_no_layout_containment_enabled_>;
  using ScopedContentIndex = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_content_index_enabled_>;
  using ScopedContextMenu = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_context_menu_enabled_>;
  using ScopedControlledFrame = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_controlled_frame_enabled_>;
  using ScopedCookieDeprecationFacilitatedTesting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_cookie_deprecation_facilitated_testing_enabled_>;
  using ScopedCoopRestrictProperties = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_coop_restrict_properties_enabled_>;
  using ScopedCorrectTemplateFormParsing = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_correct_template_form_parsing_enabled_>;
  using ScopedCorsRFC1918 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_cors_rfc_1918_enabled_>;
  using ScopedCrashReportingStorageAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_crash_reporting_storage_api_enabled_>;
  using ScopedCreateInlineContentsExcludeOutOfFlow = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_create_inline_contents_exclude_out_of_flow_enabled_>;
  using ScopedCSPHashesV1 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_csp_hashes_v_1_enabled_>;
  using ScopedCSPReportHash = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_csp_report_hash_enabled_>;
  using ScopedCSSAccentColorKeyword = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_accent_color_keyword_enabled_>;
  using ScopedCSSAltCounter = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_alt_counter_enabled_>;
  using ScopedCSSAnchorScope = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_anchor_scope_enabled_>;
  using ScopedCSSAnchorSimplifiedFragmentation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_anchor_simplified_fragmentation_enabled_>;
  using ScopedCSSAnchorUpdate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_anchor_update_enabled_>;
  using ScopedCSSAnchorWithTransforms = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_anchor_with_transforms_enabled_>;
  using ScopedCSSAtRuleCounterStyleImageSymbols = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_at_rule_counter_style_image_symbols_enabled_>;
  using ScopedCSSAtRuleCounterStyleSpeakAsDescriptor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_at_rule_counter_style_speak_as_descriptor_enabled_>;
  using ScopedCSSBorderShape = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_border_shape_enabled_>;
  using ScopedCSSCalcSimplificationAndSerialization = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_calc_simplification_and_serialization_enabled_>;
  using ScopedCSSCaretAnimation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_caret_animation_enabled_>;
  using ScopedCSSCaretShape = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_caret_shape_enabled_>;
  using ScopedCSSCaseSensitiveSelector = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_case_sensitive_selector_enabled_>;
  using ScopedCSSChUnitSpecCompliantFallback = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_ch_unit_spec_compliant_fallback_enabled_>;
  using ScopedCSSColorContrast = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_color_contrast_enabled_>;
  using ScopedCSSColorTypedOM = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_color_typed_om_enabled_>;
  using ScopedCSSContainerNameNotTreeScoped = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_container_name_not_tree_scoped_enabled_>;
  using ScopedCSSContainerProgressNotation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_container_progress_notation_enabled_>;
  using ScopedCSSContainerStyleQueriesRange = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_container_style_queries_range_enabled_>;
  using ScopedCSSCornerShape = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_corner_shape_enabled_>;
  using ScopedCSSCornersShorthand = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_corners_shorthand_enabled_>;
  using ScopedCSSCrossFade = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_cross_fade_enabled_>;
  using ScopedCSSCustomMedia = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_custom_media_enabled_>;
  using ScopedCSSDynamicRangeLimit = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_dynamic_range_limit_enabled_>;
  using ScopedCSSEnumeratedCustomProperties = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_enumerated_custom_properties_enabled_>;
  using ScopedCSSExponentialFunctions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_exponential_functions_enabled_>;
  using ScopedCSSFallbackContainerQueries = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_fallback_container_queries_enabled_>;
  using ScopedCSSFilterBrightnessNonNegativePercentage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_filter_brightness_non_negative_percentage_enabled_>;
  using ScopedCssFitWidthText = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_fit_width_text_enabled_>;
  using ScopedCSSFontSizeAdjust = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_font_size_adjust_enabled_>;
  using ScopedCSSFunctions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_functions_enabled_>;
  using ScopedCSSGapDecoration = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_gap_decoration_enabled_>;
  using ScopedCSSGridGapSuppression = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_grid_gap_suppression_enabled_>;
  using ScopedCSSHexAlphaColor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_hex_alpha_color_enabled_>;
  using ScopedCSSIdentFunction = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_ident_function_enabled_>;
  using ScopedCSSInert = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_inert_enabled_>;
  using ScopedCSSInlineIfForMediaQueries = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_inline_if_for_media_queries_enabled_>;
  using ScopedCSSInlineIfForStyleQueries = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_inline_if_for_style_queries_enabled_>;
  using ScopedCSSInlineIfForSupportsQueries = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_inline_if_for_supports_queries_enabled_>;
  using ScopedCSSKeyframesRuleLength = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_keyframes_rule_length_enabled_>;
  using ScopedCSSLayoutAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_layout_api_enabled_>;
  using ScopedCSSLetterAndWordSpacingPercentage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_letter_and_word_spacing_percentage_enabled_>;
  using ScopedCSSLineClamp = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_line_clamp_enabled_>;
  using ScopedCSSLineClampLineBreakingEllipsis = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_line_clamp_line_breaking_ellipsis_enabled_>;
  using ScopedCSSLogicalCombinationPseudo = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_logical_combination_pseudo_enabled_>;
  using ScopedCSSMarkerNestedPseudoElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_marker_nested_pseudo_element_enabled_>;
  using ScopedCSSMasonryLayout = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_masonry_layout_enabled_>;
  using ScopedCSSMediaProgressNotation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_media_progress_notation_enabled_>;
  using ScopedCSSMixins = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_mixins_enabled_>;
  using ScopedCSSNegatedFeatureless = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_negated_featureless_enabled_>;
  using ScopedCSSNestedPseudoElements = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_nested_pseudo_elements_enabled_>;
  using ScopedCSSOverscrollGestures = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_overscroll_gestures_enabled_>;
  using ScopedCSSPaintAPIArguments = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_paint_api_arguments_enabled_>;
  using ScopedCSSParserIgnoreCharsetForURLs = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_parser_ignore_charset_for_urls_enabled_>;
  using ScopedCSSPositionStickyStaticScrollPosition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_position_sticky_static_scroll_position_enabled_>;
  using ScopedCSSPreferredTextScale = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_preferred_text_scale_enabled_>;
  using ScopedCSSProgressNotation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_progress_notation_enabled_>;
  using ScopedCSSPseudoColumn = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_pseudo_column_enabled_>;
  using ScopedCSSPseudoElementInterface = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_pseudo_element_interface_enabled_>;
  using ScopedCSSPseudoHasSlotted = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_pseudo_has_slotted_enabled_>;
  using ScopedCSSPseudoPlayingPaused = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_pseudo_playing_paused_enabled_>;
  using ScopedCSSPseudoScrollButtons = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_pseudo_scroll_buttons_enabled_>;
  using ScopedCSSPseudoScrollMarkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_pseudo_scroll_markers_enabled_>;
  using ScopedCSSResizeAuto = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_resize_auto_enabled_>;
  using ScopedCSSRevertRule = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_revert_rule_enabled_>;
  using ScopedCSSRubyOverhang = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_ruby_overhang_enabled_>;
  using ScopedCSSSafePrintableInset = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_safe_printable_inset_enabled_>;
  using ScopedCSSScopeImport = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scope_import_enabled_>;
  using ScopedCSSScrollDirectionContainerQueries = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_direction_container_queries_enabled_>;
  using ScopedCSSScrollInitialTarget = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_initial_target_enabled_>;
  using ScopedCSSScrollMarkerGroupModes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_marker_group_modes_enabled_>;
  using ScopedCSSScrollMarkerTargetBeforeAfter = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_marker_target_before_after_enabled_>;
  using ScopedCSSScrollSnapChangeEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_snap_change_event_enabled_>;
  using ScopedCSSScrollSnapChangingEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_snap_changing_event_enabled_>;
  using ScopedCSSScrollSnapEventConstructorExposed = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_snap_event_constructor_exposed_enabled_>;
  using ScopedCSSScrollSnapEvents = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_snap_events_enabled_>;
  using ScopedCSSScrollStart = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_start_enabled_>;
  using ScopedCSSScrollTargetGroup = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_target_group_enabled_>;
  using ScopedCSSScrollTargetGroupAriaCurrent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_scroll_target_group_aria_current_enabled_>;
  using ScopedCSSSelectorFragmentAnchor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_selector_fragment_anchor_enabled_>;
  using ScopedCSSSiblingFunctions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_sibling_functions_enabled_>;
  using ScopedCSSSiblingFunctionsInContainerQueries = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_sibling_functions_in_container_queries_enabled_>;
  using ScopedCSSSignRelatedFunctions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_sign_related_functions_enabled_>;
  using ScopedCSSSupportsAtRuleFunction = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_supports_at_rule_function_enabled_>;
  using ScopedCSSSupportsForImportRules = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_supports_for_import_rules_enabled_>;
  using ScopedCSSSystemAccentColor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_system_accent_color_enabled_>;
  using ScopedCSSTextAlignMatchParent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_text_align_match_parent_enabled_>;
  using ScopedCSSTextAutoSpace = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_text_auto_space_enabled_>;
  using ScopedCssTextDecorationLineBlinkSerialization = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_text_decoration_line_blink_serialization_enabled_>;
  using ScopedCSSTextSpacing = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_text_spacing_enabled_>;
  using ScopedCSSTransitionNoneRunningTransitionsFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_transition_none_running_transitions_fix_enabled_>;
  using ScopedCSSTreeScopedTimelines = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_tree_scoped_timelines_enabled_>;
  using ScopedCSSTypedArithmetic = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_typed_arithmetic_enabled_>;
  using ScopedCSSUserSelectContain = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_user_select_contain_enabled_>;
  using ScopedCSSVideoDynamicRangeMediaQueries = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_video_dynamic_range_media_queries_enabled_>;
  using ScopedCSSViewTransitionAutoName = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_css_view_transition_auto_name_enabled_>;
  using ScopedCustomizableSelectInPage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_customizable_select_in_page_enabled_>;
  using ScopedCustomizableSelectMultiplePopup = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_customizable_select_multiple_popup_enabled_>;
  using ScopedCustomScrollbarApplyMinimumThumbLength = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_custom_scrollbar_apply_minimum_thumb_length_enabled_>;
  using ScopedCustomValidityNormalizeNewlines = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_custom_validity_normalize_newlines_enabled_>;
  using ScopedDatabase = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_database_enabled_>;
  using ScopedDecoupleComputedBorderWidthFromStyle = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_decouple_computed_border_width_from_style_enabled_>;
  using ScopedDecoupleResolvedColumnRuleWidthFromStyle = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_decouple_resolved_column_rule_width_from_style_enabled_>;
  using ScopedDelegatesFocusTextControlInputFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_delegates_focus_text_control_input_fix_enabled_>;
  using ScopedDeprecateCursorMovementIterator = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_deprecate_cursor_movement_iterator_enabled_>;
  using ScopedDeprecateUnloadOptOut = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_deprecate_unload_opt_out_enabled_>;
  using ScopedDesktopCaptureDisableLocalEchoControl = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_desktop_capture_disable_local_echo_control_enabled_>;
  using ScopedDesktopPWAsAdditionalWindowingControls = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_desktop_pw_as_additional_windowing_controls_enabled_>;
  using ScopedDesktopPWAsSubApps = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_desktop_pw_as_sub_apps_enabled_>;
  using ScopedDeviceAttributes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_device_attributes_enabled_>;
  using ScopedDeviceAttributesPermissionPolicy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_device_attributes_permission_policy_enabled_>;
  using ScopedDeviceBoundSessionCredentials = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_device_bound_session_credentials_enabled_>;
  using ScopedDeviceBoundSessionCredentials2 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_device_bound_session_credentials_2_enabled_>;
  using ScopedDeviceOrientationRequestPermission = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_device_orientation_request_permission_enabled_>;
  using ScopedDevicePosture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_device_posture_enabled_>;
  using ScopedDialogCloseWhenOpenRemoved = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_dialog_close_when_open_removed_enabled_>;
  using ScopedDialogNewFocusBehavior = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_dialog_new_focus_behavior_enabled_>;
  using ScopedDialogSubmitShadowBoundaries = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_dialog_submit_shadow_boundaries_enabled_>;
  using ScopedDigitalGoods = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_digital_goods_enabled_>;
  using ScopedDigitalGoodsV2_1 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_digital_goods_v_2_1_enabled_>;
  using ScopedDirectSockets = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_direct_sockets_enabled_>;
  using ScopedDirectSocketsInServiceWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_direct_sockets_in_service_workers_enabled_>;
  using ScopedDirectSocketsInSharedWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_direct_sockets_in_shared_workers_enabled_>;
  using ScopedDisableDifferentOriginSubframeDialogSuppression = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_disable_different_origin_subframe_dialog_suppression_enabled_>;
  using ScopedDisableReduceAcceptLanguage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_disable_reduce_accept_language_enabled_>;
  using ScopedDispatchHiddenVisibilityTransitions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_dispatch_hidden_visibility_transitions_enabled_>;
  using ScopedDispatchSelectionchangeEventPerElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_dispatch_selectionchange_event_per_element_enabled_>;
  using ScopedDisplayContentsFocusable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_display_contents_focusable_enabled_>;
  using ScopedDisplayCutoutAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_display_cutout_api_enabled_>;
  using ScopedDocumentActiveViewTransition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_active_view_transition_enabled_>;
  using ScopedDocumentCookie = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_cookie_enabled_>;
  using ScopedDocumentDomain = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_domain_enabled_>;
  using ScopedDocumentIsolationPolicy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_isolation_policy_enabled_>;
  using ScopedDocumentOpenOriginAliasRemoval = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_open_origin_alias_removal_enabled_>;
  using ScopedDocumentOpenSandboxInheritanceRemoval = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_open_sandbox_inheritance_removal_enabled_>;
  using ScopedDocumentPatching = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_patching_enabled_>;
  using ScopedDocumentPictureInPictureAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_picture_in_picture_api_enabled_>;
  using ScopedDocumentPictureInPicturePreferInitialPlacement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_picture_in_picture_prefer_initial_placement_enabled_>;
  using ScopedDocumentPictureInPictureUserActivation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_picture_in_picture_user_activation_enabled_>;
  using ScopedDocumentPolicyDocumentDomain = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_policy_document_domain_enabled_>;
  using ScopedDocumentPolicyExpectNoLinkedResources = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_policy_expect_no_linked_resources_enabled_>;
  using ScopedDocumentPolicyIncludeJSCallStacksInCrashReports = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_policy_include_js_call_stacks_in_crash_reports_enabled_>;
  using ScopedDocumentPolicyNegotiation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_policy_negotiation_enabled_>;
  using ScopedDocumentPolicyNetworkEfficiencyGuardrails = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_policy_network_efficiency_guardrails_enabled_>;
  using ScopedDocumentPolicySyncXHR = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_policy_sync_xhr_enabled_>;
  using ScopedDocumentWrite = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_document_write_enabled_>;
  using ScopedDOMPartsAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_dom_parts_api_enabled_>;
  using ScopedDOMPartsAPIMinimal = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_dom_parts_api_minimal_enabled_>;
  using ScopedDynamicSafeAreaInsets = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_dynamic_safe_area_insets_enabled_>;
  using ScopedEditEmojiUnicode11 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_edit_emoji_unicode_11_enabled_>;
  using ScopedElementCapture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_element_capture_enabled_>;
  using ScopedElementInnerTextHandleFirstLineStyle = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_element_inner_text_handle_first_line_style_enabled_>;
  using ScopedElementInternalsDotType = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_element_internals_dot_type_enabled_>;
  using ScopedEnforceAnonymityExposure = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_enforce_anonymity_exposure_enabled_>;
  using ScopedEnterInOpenShadowRoots = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_enter_in_open_shadow_roots_enabled_>;
  using ScopedEventTimingInteractionCount = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_event_timing_interaction_count_enabled_>;
  using ScopedExperimentalContentSecurityPolicyFeatures = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_experimental_content_security_policy_features_enabled_>;
  using ScopedExperimentalJSProfilerMarkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_experimental_js_profiler_markers_enabled_>;
  using ScopedExperimentalMachineLearningNeuralNetwork = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_experimental_machine_learning_neural_network_enabled_>;
  using ScopedExperimentalPolicies = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_experimental_policies_enabled_>;
  using ScopedExposeCSSFontFeatureValuesRule = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_expose_css_font_feature_values_rule_enabled_>;
  using ScopedExposeRenderTimeNonTaoDelayedImage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_expose_render_time_non_tao_delayed_image_enabled_>;
  using ScopedExtendedTextMetrics = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_extended_text_metrics_enabled_>;
  using ScopedExternalPopupMenuClickEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_external_popup_menu_click_event_enabled_>;
  using ScopedEyeDropperAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_eye_dropper_api_enabled_>;
  using ScopedFaceDetector = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_face_detector_enabled_>;
  using ScopedFastPositionIterator = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fast_position_iterator_enabled_>;
  using ScopedFedCm = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fed_cm_enabled_>;
  using ScopedFedCmAutofill = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fed_cm_autofill_enabled_>;
  using ScopedFedCmDelegation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fed_cm_delegation_enabled_>;
  using ScopedFedCmErrorAttribute = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fed_cm_error_attribute_enabled_>;
  using ScopedFedCmIdPRegistration = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fed_cm_id_p_registration_enabled_>;
  using ScopedFedCmLightweightMode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fed_cm_lightweight_mode_enabled_>;
  using ScopedFedCmMultipleIdentityProviders = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fed_cm_multiple_identity_providers_enabled_>;
  using ScopedFencedFrames = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fenced_frames_enabled_>;
  using ScopedFencedFramesAPIChanges = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fenced_frames_api_changes_enabled_>;
  using ScopedFencedFramesDefaultMode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fenced_frames_default_mode_enabled_>;
  using ScopedFencedFramesLocalUnpartitionedDataAccess = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fenced_frames_local_unpartitioned_data_access_enabled_>;
  using ScopedFetchBodyBytes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fetch_body_bytes_enabled_>;
  using ScopedFetchLaterAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fetch_later_api_enabled_>;
  using ScopedFetchRetry = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fetch_retry_enabled_>;
  using ScopedFetchUploadStreaming = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fetch_upload_streaming_enabled_>;
  using ScopedFileHandling = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_handling_enabled_>;
  using ScopedFileHandlingIcons = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_handling_icons_enabled_>;
  using ScopedFileSystem = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_enabled_>;
  using ScopedFileSystemAccess = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_access_enabled_>;
  using ScopedFileSystemAccessAPIExperimental = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_access_api_experimental_enabled_>;
  using ScopedFileSystemAccessGetCloudIdentifiers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_access_get_cloud_identifiers_enabled_>;
  using ScopedFileSystemAccessLocal = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_access_local_enabled_>;
  using ScopedFileSystemAccessLockingScheme = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_access_locking_scheme_enabled_>;
  using ScopedFileSystemAccessOriginPrivate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_access_origin_private_enabled_>;
  using ScopedFileSystemAccessRevokeReadOnRemove = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_access_revoke_read_on_remove_enabled_>;
  using ScopedFileSystemAccessWriteMode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_access_write_mode_enabled_>;
  using ScopedFileSystemObserver = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_observer_enabled_>;
  using ScopedFileSystemObserverUnobserve = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_file_system_observer_unobserve_enabled_>;
  using ScopedFindFirstMisspellingEndWhenNonEditable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_find_first_misspelling_end_when_non_editable_enabled_>;
  using ScopedFirstLineOnListItem = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_first_line_on_list_item_enabled_>;
  using ScopedFirstLineTextMetrics = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_first_line_text_metrics_enabled_>;
  using ScopedFixNextPositionCalculationInInsertList = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fix_next_position_calculation_in_insert_list_enabled_>;
  using ScopedFledge = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_enabled_>;
  using ScopedFledgeAuctionDealSupport = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_auction_deal_support_enabled_>;
  using ScopedFledgeBiddingAndAuctionServerAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_bidding_and_auction_server_api_enabled_>;
  using ScopedFledgeBiddingAndAuctionServerAPIMultiSeller = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_bidding_and_auction_server_api_multi_seller_enabled_>;
  using ScopedFledgeClickiness = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_clickiness_enabled_>;
  using ScopedFledgeCustomMaxAuctionAdComponents = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_custom_max_auction_ad_components_enabled_>;
  using ScopedFledgeDeprecatedRenderURLReplacements = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_deprecated_render_url_replacements_enabled_>;
  using ScopedFledgeDirectFromSellerSignalsHeaderAdSlot = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_direct_from_seller_signals_header_ad_slot_enabled_>;
  using ScopedFledgeDirectFromSellerSignalsWebBundles = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_direct_from_seller_signals_web_bundles_enabled_>;
  using ScopedFledgeMultiBid = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_multi_bid_enabled_>;
  using ScopedFledgePrivateModelTraining = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_private_model_training_enabled_>;
  using ScopedFledgeRealTimeReporting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_real_time_reporting_enabled_>;
  using ScopedFledgeSellerNonce = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_seller_nonce_enabled_>;
  using ScopedFledgeSellerScriptExecutionMode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_seller_script_execution_mode_enabled_>;
  using ScopedFledgeTrustedSignalsKVv1CreativeScanning = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_trusted_signals_k_vv_1_creative_scanning_enabled_>;
  using ScopedFledgeTrustedSignalsKVv2ContextualData = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_trusted_signals_k_vv_2_contextual_data_enabled_>;
  using ScopedFledgeTrustedSignalsKVv2Support = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fledge_trusted_signals_k_vv_2_support_enabled_>;
  using ScopedFlexWrapBalance = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_flex_wrap_balance_enabled_>;
  using ScopedFluentOverlayScrollbars = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fluent_overlay_scrollbars_enabled_>;
  using ScopedFluentScrollbars = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fluent_scrollbars_enabled_>;
  using ScopedFocusgroup = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_focusgroup_enabled_>;
  using ScopedFocusgroupGrid = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_focusgroup_grid_enabled_>;
  using ScopedFontAccess = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_access_enabled_>;
  using ScopedFontFallbackForTabSize = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_fallback_for_tab_size_enabled_>;
  using ScopedFontFamilyPostscriptMatchingCTMigration = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_family_postscript_matching_ct_migration_enabled_>;
  using ScopedFontFamilyStyleMatchingCTMigration = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_family_style_matching_ct_migration_enabled_>;
  using ScopedFontFeatureSettingsDescriptor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_feature_settings_descriptor_enabled_>;
  using ScopedFontLanguageOverride = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_language_override_enabled_>;
  using ScopedFontMatchAliasesAsLastResort = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_match_aliases_as_last_resort_enabled_>;
  using ScopedFontPresentWin = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_present_win_enabled_>;
  using ScopedFontSrcLocalMatching = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_src_local_matching_enabled_>;
  using ScopedFontStyleObliqueZeroDegreeAsNormal = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_style_oblique_zero_degree_as_normal_enabled_>;
  using ScopedFontSystemFallbackNotoCjk = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_system_fallback_noto_cjk_enabled_>;
  using ScopedFontVariationSettingsDescriptor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_font_variation_settings_descriptor_enabled_>;
  using ScopedForcedColors = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_forced_colors_enabled_>;
  using ScopedForceEagerMeasureMemory = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_force_eager_measure_memory_enabled_>;
  using ScopedForceReduceMotion = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_force_reduce_motion_enabled_>;
  using ScopedFormControlRange = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_form_control_range_enabled_>;
  using ScopedFormControlRestoreStateIfAutocompleteOff = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_form_control_restore_state_if_autocomplete_off_enabled_>;
  using ScopedFractionalScrollOffsets = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_fractional_scroll_offsets_enabled_>;
  using ScopedFreezeFramesOnVisibility = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_freeze_frames_on_visibility_enabled_>;
  using ScopedGamepadMultitouch = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_gamepad_multitouch_enabled_>;
  using ScopedGeolocationElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_geolocation_element_enabled_>;
  using ScopedGetAllScreensMedia = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_get_all_screens_media_enabled_>;
  using ScopedGetComputedStyleOutsideFlatTree = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_get_computed_style_outside_flat_tree_enabled_>;
  using ScopedGetDisplayMedia = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_get_display_media_enabled_>;
  using ScopedGetDisplayMediaRequiresUserActivation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_get_display_media_requires_user_activation_enabled_>;
  using ScopedGetDisplayMediaWindowAudioCapture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_get_display_media_window_audio_capture_enabled_>;
  using ScopedGetElementsByNameOnlyHTMLElements = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_get_elements_by_name_only_html_elements_enabled_>;
  using ScopedGetUserMediaEchoCancellationModes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_get_user_media_echo_cancellation_modes_enabled_>;
  using ScopedGroupEffect = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_group_effect_enabled_>;
  using ScopedHandleDeletionAtStartAndEndBoundaryContainingHiddenElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_handle_deletion_at_start_and_end_boundary_containing_hidden_element_enabled_>;
  using ScopedHandleDisconnectedSelectionDuringDOMChanges = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_handle_disconnected_selection_during_dom_changes_enabled_>;
  using ScopedHandleShadowDOMInSubstringUtil = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_handle_shadow_dom_in_substring_util_enabled_>;
  using ScopedHandwritingRecognition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_handwriting_recognition_enabled_>;
  using ScopedHasUAVisualTransition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_has_ua_visual_transition_enabled_>;
  using ScopedHeadingOffset = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_heading_offset_enabled_>;
  using ScopedHighlightByLayoutObject = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_highlight_by_layout_object_enabled_>;
  using ScopedHighlightPointerEvents = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_highlight_pointer_events_enabled_>;
  using ScopedHighlightsFromPoint = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_highlights_from_point_enabled_>;
  using ScopedHitTestBorderRadiusForStackingContext = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_hit_test_border_radius_for_stacking_context_enabled_>;
  using ScopedHrefTranslate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_href_translate_enabled_>;
  using ScopedHrElementGray = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_hr_element_gray_enabled_>;
  using ScopedHTMLAnchorAttribute = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_anchor_attribute_enabled_>;
  using ScopedHTMLCommandActionsV2 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_command_actions_v_2_enabled_>;
  using ScopedHTMLCommandActionToggleInterest = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_command_action_toggle_interest_enabled_>;
  using ScopedHTMLCommandRequestClose = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_command_request_close_enabled_>;
  using ScopedHTMLElementScrollParent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_element_scroll_parent_enabled_>;
  using ScopedHTMLImageElementActualNaturalSize = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_image_element_actual_natural_size_enabled_>;
  using ScopedHTMLInterestForAttribute = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_interest_for_attribute_enabled_>;
  using ScopedHTMLInterestForInterestHintPseudo = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_interest_for_interest_hint_pseudo_enabled_>;
  using ScopedHTMLLinkElementAttributeValueChanges = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_link_element_attribute_value_changes_enabled_>;
  using ScopedHTMLParserYieldAndDelayOftenForTesting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_parser_yield_and_delay_often_for_testing_enabled_>;
  using ScopedHTMLParserYieldByUserTiming = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_parser_yield_by_user_timing_enabled_>;
  using ScopedHTMLPrintingArtifactAnnotations = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_html_printing_artifact_annotations_enabled_>;
  using ScopedICUCapitalization = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_icu_capitalization_enabled_>;
  using ScopedIgnoreLetterSpacingInCursiveScripts = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ignore_letter_spacing_in_cursive_scripts_enabled_>;
  using ScopedImageDataPixelFormat = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_image_data_pixel_format_enabled_>;
  using ScopedImplicitRootScroller = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_implicit_root_scroller_enabled_>;
  using ScopedImprovedSourceRetargeting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_improved_source_retargeting_enabled_>;
  using ScopedIncomingCallNotifications = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_incoming_call_notifications_enabled_>;
  using ScopedIndexedDbGetAllRecords = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_indexed_db_get_all_records_enabled_>;
  using ScopedInertElementNonEditable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_inert_element_non_editable_enabled_>;
  using ScopedInfiniteCullRect = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_infinite_cull_rect_enabled_>;
  using ScopedInheritUserModifyWithoutContenteditable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_inherit_user_modify_without_contenteditable_enabled_>;
  using ScopedInnerHTMLParserFastpathLogFailure = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_inner_html_parser_fastpath_log_failure_enabled_>;
  using ScopedInputEventDataTransferForInsertCmd = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_input_event_data_transfer_for_insert_cmd_enabled_>;
  using ScopedInputInSelect = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_input_in_select_enabled_>;
  using ScopedInputMultipleFieldsUI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_input_multiple_fields_ui_enabled_>;
  using ScopedInsertBlockquoteBeforeOuterBlock = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_insert_blockquote_before_outer_block_enabled_>;
  using ScopedInsertLineBreakIfInlineListItem = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_insert_line_break_if_inline_list_item_enabled_>;
  using ScopedInsertLineBreakIfPhrasingContent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_insert_line_break_if_phrasing_content_enabled_>;
  using ScopedInspectorGhostRules = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_inspector_ghost_rules_enabled_>;
  using ScopedInstalledApp = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_installed_app_enabled_>;
  using ScopedInstallOnDeviceSpeechRecognition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_install_on_device_speech_recognition_enabled_>;
  using ScopedIntegrityPolicyScript = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_integrity_policy_script_enabled_>;
  using ScopedInteractivityInertImportant = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_interactivity_inert_important_enabled_>;
  using ScopedInterestGroupsInSharedStorageWorklet = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_interest_groups_in_shared_storage_worklet_enabled_>;
  using ScopedIntersectionObserverScrollMargin = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_intersection_observer_scroll_margin_enabled_>;
  using ScopedInvertedColors = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_inverted_colors_enabled_>;
  using ScopedInvisibleSVGAnimationThrottling = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_invisible_svg_animation_throttling_enabled_>;
  using ScopedJavaScriptCompileHintsPerFunctionMagicRuntime = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_java_script_compile_hints_per_function_magic_runtime_enabled_>;
  using ScopedJavaScriptSourcePhaseImports = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_java_script_source_phase_imports_enabled_>;
  using ScopedKeyboardAccessibleTooltip = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_keyboard_accessible_tooltip_enabled_>;
  using ScopedKeyboardFocusabilityAfterFindInPage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_keyboard_focusability_after_find_in_page_enabled_>;
  using ScopedLangAttributeAwareFormControlUI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_lang_attribute_aware_form_control_ui_enabled_>;
  using ScopedLanguageDetectionAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_language_detection_api_enabled_>;
  using ScopedLanguageDetectionAPIForWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_language_detection_api_for_workers_enabled_>;
  using ScopedLayoutFlexNewRowAlgorithm = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_layout_flex_new_row_algorithm_enabled_>;
  using ScopedLayoutIgnoreMarginsForSticky = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_layout_ignore_margins_for_sticky_enabled_>;
  using ScopedLayoutNGShapeCache = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_layout_ng_shape_cache_enabled_>;
  using ScopedLazyInitializeMediaControls = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_lazy_initialize_media_controls_enabled_>;
  using ScopedLeftClickToHandleSuggestion = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_left_click_to_handle_suggestion_enabled_>;
  using ScopedLimitThirdPartyCookies = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_limit_third_party_cookies_enabled_>;
  using ScopedLineBreakOofNoOrc = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_line_break_oof_no_orc_enabled_>;
  using ScopedLinkBlurImprovement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_link_blur_improvement_enabled_>;
  using ScopedListOwnerMustHaveCSSBox = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_list_owner_must_have_css_box_enabled_>;
  using ScopedListStylePositionQuirkStandard = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_list_style_position_quirk_standard_enabled_>;
  using ScopedLocalNetworkAccessNonSecureContextAllowed = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_local_network_access_non_secure_context_allowed_enabled_>;
  using ScopedLocalNetworkAccessPermissionPolicy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_local_network_access_permission_policy_enabled_>;
  using ScopedLocalNetworkAccessWebRTC = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_local_network_access_web_rtc_enabled_>;
  using ScopedLockedMode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_locked_mode_enabled_>;
  using ScopedLongAnimationFrameSourceCharPosition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_long_animation_frame_source_char_position_enabled_>;
  using ScopedLongAnimationFrameSourceLineColumn = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_long_animation_frame_source_line_column_enabled_>;
  using ScopedLongAnimationFrameSourceLineColumnInterface = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_long_animation_frame_source_line_column_interface_enabled_>;
  using ScopedLongPressLinkSelectText = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_long_press_link_select_text_enabled_>;
  using ScopedLongTaskFromLongAnimationFrame = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_long_task_from_long_animation_frame_enabled_>;
  using ScopedMacCharacterFallbackCache = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_mac_character_fallback_cache_enabled_>;
  using ScopedMacDisableCtrlHomeEnd = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_mac_disable_ctrl_home_end_enabled_>;
  using ScopedMachineLearningNeuralNetwork = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_machine_learning_neural_network_enabled_>;
  using ScopedMacSystemClipboardPermissionCheck = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_mac_system_clipboard_permission_check_enabled_>;
  using ScopedManagedConfiguration = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_managed_configuration_enabled_>;
  using ScopedMaskDeserializationTimeForCrossOriginMessages = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_mask_deserialization_time_for_cross_origin_messages_enabled_>;
  using ScopedMathMLOperatorRTLMirroring = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_mathml_operator_rtl_mirroring_enabled_>;
  using ScopedMathMLSerializationOnCopy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_mathml_serialization_on_copy_enabled_>;
  using ScopedMeasureMemory = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_measure_memory_enabled_>;
  using ScopedMediaCapabilitiesEncodingInfo = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_capabilities_encoding_info_enabled_>;
  using ScopedMediaCapabilitiesSpatialAudio = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_capabilities_spatial_audio_enabled_>;
  using ScopedMediaCapture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_capture_enabled_>;
  using ScopedMediaCaptureBackgroundBlur = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_capture_background_blur_enabled_>;
  using ScopedMediaCaptureCameraControls = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_capture_camera_controls_enabled_>;
  using ScopedMediaCaptureConfigurationChange = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_capture_configuration_change_enabled_>;
  using ScopedMediaCaptureVoiceIsolation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_capture_voice_isolation_enabled_>;
  using ScopedMediaCastOverlayButton = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_cast_overlay_button_enabled_>;
  using ScopedMediaControlsExpandGesture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_controls_expand_gesture_enabled_>;
  using ScopedMediaControlsOverlayPlayButton = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_controls_overlay_play_button_enabled_>;
  using ScopedMediaElementVolumeGreaterThanOne = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_element_volume_greater_than_one_enabled_>;
  using ScopedMediaEngagementBypassAutoplayPolicies = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_engagement_bypass_autoplay_policies_enabled_>;
  using ScopedMediaLatencyHint = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_latency_hint_enabled_>;
  using ScopedMediaPlaybackWhileNotVisiblePermissionPolicy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_playback_while_not_visible_permission_policy_enabled_>;
  using ScopedMediaQueryNavigationControls = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_query_navigation_controls_enabled_>;
  using ScopedMediaSession = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_session_enabled_>;
  using ScopedMediaSessionChapterInformation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_session_chapter_information_enabled_>;
  using ScopedMediaSessionEnterPictureInPicture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_session_enter_picture_in_picture_enabled_>;
  using ScopedMediaSourceExperimental = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_source_experimental_enabled_>;
  using ScopedMediaSourceExtensionsForWebCodecs = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_source_extensions_for_webcodecs_enabled_>;
  using ScopedMediaSourceNewAbortAndDuration = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_source_new_abort_and_duration_enabled_>;
  using ScopedMediaStreamTrackTransfer = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_stream_track_transfer_enabled_>;
  using ScopedMediaStreamTrackWebSpeech = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_media_stream_track_web_speech_enabled_>;
  using ScopedMenuElements = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_menu_elements_enabled_>;
  using ScopedMessagePortCloseEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_message_port_close_event_enabled_>;
  using ScopedMiddleClickAutoscroll = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_middle_click_autoscroll_enabled_>;
  using ScopedMixedContentAutoupgradesUseIsMixedContentRestrictedInFrame = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_mixed_content_autoupgrades_use_is_mixed_content_restricted_in_frame_enabled_>;
  using ScopedMobileLayoutTheme = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_mobile_layout_theme_enabled_>;
  using ScopedModifyParagraphCrossEditingoundary = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_modify_paragraph_cross_editingoundary_enabled_>;
  using ScopedModulePreloadReferrer = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_module_preload_referrer_enabled_>;
  using ScopedMojoJS = ScopedRuntimeEnabledProtectedFeature<
    RuntimeEnabledFeaturesBase::is_mojo_js_enabled_>;
  using ScopedMojoJSTest = ScopedRuntimeEnabledProtectedFeature<
    RuntimeEnabledFeaturesBase::is_mojo_js_test_enabled_>;
  using ScopedMoveEndingSelectionToListChild = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_move_ending_selection_to_list_child_enabled_>;
  using ScopedMoveToParagraphStartOrEndSkipsNonEditable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_move_to_paragraph_start_or_end_skips_non_editable_enabled_>;
  using ScopedMulticastInDirectSockets = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_multicast_in_direct_sockets_enabled_>;
  using ScopedMulticolColumnWrapping = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_multicol_column_wrapping_enabled_>;
  using ScopedNavigateEventCanTransition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_navigate_event_can_transition_enabled_>;
  using ScopedNavigateEventCommitBehavior = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_navigate_event_commit_behavior_enabled_>;
  using ScopedNavigateEventPopstateLimitations = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_navigate_event_popstate_limitations_enabled_>;
  using ScopedNavigateEventSourceElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_navigate_event_source_element_enabled_>;
  using ScopedNavigationId = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_navigation_id_enabled_>;
  using ScopedNavigationTransitionDestination = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_navigation_transition_destination_enabled_>;
  using ScopedNavigatorContentUtils = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_navigator_content_utils_enabled_>;
  using ScopedNestedRubyMinMaxFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_nested_ruby_min_max_fix_enabled_>;
  using ScopedNestedViewTransition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_nested_view_transition_enabled_>;
  using ScopedNetInfoConstantType = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_net_info_constant_type_enabled_>;
  using ScopedNetInfoDownlinkMax = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_net_info_downlink_max_enabled_>;
  using ScopedNoFontAntialiasing = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_no_font_antialiasing_enabled_>;
  using ScopedNoIdleEncodingForWebTests = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_no_idle_encoding_for_web_tests_enabled_>;
  using ScopedNoIncreasingEndOffsetOnSplittingTextNodes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_no_increasing_end_offset_on_splitting_text_nodes_enabled_>;
  using ScopedNonEmptyBlockquotesOnOutdenting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_non_empty_blockquotes_on_outdenting_enabled_>;
  using ScopedNonStandardAppearanceValueSliderVertical = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_non_standard_appearance_value_slider_vertical_enabled_>;
  using ScopedNotificationConstructor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_notification_constructor_enabled_>;
  using ScopedNotificationContentImage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_notification_content_image_enabled_>;
  using ScopedNotifications = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_notifications_enabled_>;
  using ScopedNotificationTriggers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_notification_triggers_enabled_>;
  using ScopedNumberInputFullWidthChars = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_number_input_full_width_chars_enabled_>;
  using ScopedOffMainThreadCSSPaint = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_off_main_thread_css_paint_enabled_>;
  using ScopedOffscreenCanvasGetContextAttributes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_offscreen_canvas_get_context_attributes_enabled_>;
  using ScopedOffsetParentNewSpecBehaviorForFixedPosition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_offset_parent_new_spec_behavior_for_fixed_position_enabled_>;
  using ScopedOmitBlurEventOnElementRemoval = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_omit_blur_event_on_element_removal_enabled_>;
  using ScopedOnDeviceWebSpeechAvailable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_on_device_web_speech_available_enabled_>;
  using ScopedOptionLabelAttributeWhitespace = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_option_label_attribute_whitespace_enabled_>;
  using ScopedOrientationEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_orientation_event_enabled_>;
  using ScopedOriginAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_api_enabled_>;
  using ScopedOriginatingElementIsImplicitAnchor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_originating_element_is_implicit_anchor_enabled_>;
  using ScopedOriginIsolationHeader = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_isolation_header_enabled_>;
  using ScopedOriginPolicy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_policy_enabled_>;
  using ScopedOriginTrialsSampleAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_enabled_>;
  using ScopedOriginTrialsSampleAPIBrowserReadWrite = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_browser_read_write_enabled_>;
  using ScopedOriginTrialsSampleAPIDependent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_dependent_enabled_>;
  using ScopedOriginTrialsSampleAPIDeprecation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_deprecation_enabled_>;
  using ScopedOriginTrialsSampleAPIExpiryGracePeriod = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_expiry_grace_period_enabled_>;
  using ScopedOriginTrialsSampleAPIExpiryGracePeriodThirdParty = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_expiry_grace_period_third_party_enabled_>;
  using ScopedOriginTrialsSampleAPIImplied = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_implied_enabled_>;
  using ScopedOriginTrialsSampleAPIInvalidOS = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_invalid_os_enabled_>;
  using ScopedOriginTrialsSampleAPINavigation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_navigation_enabled_>;
  using ScopedOriginTrialsSampleAPIPersistentExpiryGracePeriod = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_persistent_expiry_grace_period_enabled_>;
  using ScopedOriginTrialsSampleAPIPersistentFeature = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_persistent_feature_enabled_>;
  using ScopedOriginTrialsSampleAPIPersistentInvalidOS = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_persistent_invalid_os_enabled_>;
  using ScopedOriginTrialsSampleAPIPersistentThirdPartyDeprecationFeature = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_persistent_third_party_deprecation_feature_enabled_>;
  using ScopedOriginTrialsSampleAPIThirdParty = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_origin_trials_sample_api_third_party_enabled_>;
  using ScopedOverscrollCustomization = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_overscroll_customization_enabled_>;
  using ScopedPagePopup = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_page_popup_enabled_>;
  using ScopedPagePopupCopyPaste = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_page_popup_copy_paste_enabled_>;
  using ScopedPageRevealEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_page_reveal_event_enabled_>;
  using ScopedPageSwapEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_page_swap_event_enabled_>;
  using ScopedPaintHoldingForIframes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_paint_holding_for_iframes_enabled_>;
  using ScopedPaintOffsetTranslationForBackdropFilterWithInlineElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_paint_offset_translation_for_backdrop_filter_with_inline_element_enabled_>;
  using ScopedPaintOffsetTranslationForComposited = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_paint_offset_translation_for_composited_enabled_>;
  using ScopedPaintTimingMixin = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_paint_timing_mixin_enabled_>;
  using ScopedPaintUnderInvalidationChecking = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_paint_under_invalidation_checking_enabled_>;
  using ScopedParakeet = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_parakeet_enabled_>;
  using ScopedPartialCompletionNotAllowedInMoveParagraphs = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_partial_completion_not_allowed_in_move_paragraphs_enabled_>;
  using ScopedPartitionedPopins = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_partitioned_popins_enabled_>;
  using ScopedPartitionVisitedLinkDatabaseWithSelfLinks = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_partition_visited_link_database_with_self_links_enabled_>;
  using ScopedPasswordReveal = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_password_reveal_enabled_>;
  using ScopedPaymentApp = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_payment_app_enabled_>;
  using ScopedPaymentLinkDetection = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_payment_link_detection_enabled_>;
  using ScopedPaymentMethodChangeEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_payment_method_change_event_enabled_>;
  using ScopedPaymentRequest = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_payment_request_enabled_>;
  using ScopedPerformanceManagerInstrumentation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_performance_manager_instrumentation_enabled_>;
  using ScopedPerformanceMarkFeatureUsage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_performance_mark_feature_usage_enabled_>;
  using ScopedPerformanceNavigateSystemEntropy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_performance_navigate_system_entropy_enabled_>;
  using ScopedPerformanceNavigationTimingConfidence = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_performance_navigation_timing_confidence_enabled_>;
  using ScopedPeriodicBackgroundSync = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_periodic_background_sync_enabled_>;
  using ScopedPerMethodCanMakePaymentQuota = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_per_method_can_make_payment_quota_enabled_>;
  using ScopedPermissionElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_permission_element_enabled_>;
  using ScopedPermissionElementIcon = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_permission_element_icon_enabled_>;
  using ScopedPermissions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_permissions_enabled_>;
  using ScopedPermissionsRequestRevoke = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_permissions_request_revoke_enabled_>;
  using ScopedPlaceholderVisibility = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_placeholder_visibility_enabled_>;
  using ScopedPNaCl = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_p_na_cl_enabled_>;
  using ScopedPointerEventDeviceId = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_pointer_event_device_id_enabled_>;
  using ScopedPointerLockOnAndroid = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_pointer_lock_on_android_enabled_>;
  using ScopedPointerRawUpdateOnlyInSecureContext = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_pointer_raw_update_only_in_secure_context_enabled_>;
  using ScopedPositionOutsideTabSpanCheckSiblingNode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_position_outside_tab_span_check_sibling_node_enabled_>;
  using ScopedPositionVisibilityIgnoreNonClipAncestors = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_position_visibility_ignore_non_clip_ancestors_enabled_>;
  using ScopedPotentialPermissionsPolicyReporting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_potential_permissions_policy_reporting_enabled_>;
  using ScopedPreciseMemoryInfo = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_precise_memory_info_enabled_>;
  using ScopedPreferDefaultScrollbarStyles = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_prefer_default_scrollbar_styles_enabled_>;
  using ScopedPreferNonCompositedScrolling = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_prefer_non_composited_scrolling_enabled_>;
  using ScopedPreferredAudioOutputDevices = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_preferred_audio_output_devices_enabled_>;
  using ScopedPrefersReducedData = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_prefers_reduced_data_enabled_>;
  using ScopedPreloadLinkRelDataUrls = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_preload_link_rel_data_urls_enabled_>;
  using ScopedPrerender2 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_prerender_2_enabled_>;
  using ScopedPrerenderUntilScript = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_prerender_until_script_enabled_>;
  using ScopedPresentation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_presentation_enabled_>;
  using ScopedPreserveDropEffect = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_preserve_drop_effect_enabled_>;
  using ScopedPreventUndoIfNotEditable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_prevent_undo_if_not_editable_enabled_>;
  using ScopedPrivateAggregationApiErrorReporting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_private_aggregation_api_error_reporting_enabled_>;
  using ScopedPrivateAggregationApiMaxContributions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_private_aggregation_api_max_contributions_enabled_>;
  using ScopedPrivateNetworkAccessNullIpAddress = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_private_network_access_null_ip_address_enabled_>;
  using ScopedPrivateStateTokens = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_private_state_tokens_enabled_>;
  using ScopedPrivateStateTokensAlwaysAllowIssuance = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_private_state_tokens_always_allow_issuance_enabled_>;
  using ScopedProgrammaticScrollPromise = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_programmatic_scroll_promise_enabled_>;
  using ScopedPropagateOverscrollBehaviorFromRoot = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_propagate_overscroll_behavior_from_root_enabled_>;
  using ScopedProtectedOriginTrialsSampleAPI = ScopedRuntimeEnabledProtectedFeature<
    RuntimeEnabledFeaturesBase::is_protected_origin_trials_sample_api_enabled_>;
  using ScopedProtectedOriginTrialsSampleAPIDependent = ScopedRuntimeEnabledProtectedFeature<
    RuntimeEnabledFeaturesBase::is_protected_origin_trials_sample_api_dependent_enabled_>;
  using ScopedProtectedOriginTrialsSampleAPIImplied = ScopedRuntimeEnabledProtectedFeature<
    RuntimeEnabledFeaturesBase::is_protected_origin_trials_sample_api_implied_enabled_>;
  using ScopedPseudoElementsFocusable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_pseudo_elements_focusable_enabled_>;
  using ScopedPushMessageDataBytes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_push_message_data_bytes_enabled_>;
  using ScopedPushMessaging = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_push_messaging_enabled_>;
  using ScopedPushMessagingSubscriptionChange = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_push_messaging_subscription_change_enabled_>;
  using ScopedQuotaExceededErrorUpdate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_quota_exceeded_error_update_enabled_>;
  using ScopedQuoteFirstLineStyle = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_quote_first_line_style_enabled_>;
  using ScopedRadioInputNextKeyboardFocusable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_radio_input_next_keyboard_focusable_enabled_>;
  using ScopedRadioKeyboardFocusableOptimize = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_radio_keyboard_focusable_optimize_enabled_>;
  using ScopedRasterInducingScroll = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_raster_inducing_scroll_enabled_>;
  using ScopedReadableStreamBYOBReaderReadMinOption = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_readable_stream_byob_reader_read_min_option_enabled_>;
  using ScopedRecordSameDocumentPresentationTimeOnce = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_record_same_document_presentation_time_once_enabled_>;
  using ScopedReduceAcceptLanguage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_reduce_accept_language_enabled_>;
  using ScopedReduceDeviceMemory = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_reduce_device_memory_enabled_>;
  using ScopedReduceHardwareConcurrency = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_reduce_hardware_concurrency_enabled_>;
  using ScopedReduceScreenSize = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_reduce_screen_size_enabled_>;
  using ScopedReduceUserAgentAndroidVersionDeviceModel = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_reduce_user_agent_android_version_device_model_enabled_>;
  using ScopedReduceUserAgentDataLinuxPlatformVersion = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_reduce_user_agent_data_linux_platform_version_enabled_>;
  using ScopedReduceUserAgentMinorVersion = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_reduce_user_agent_minor_version_enabled_>;
  using ScopedReduceUserAgentPlatformOsCpu = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_reduce_user_agent_platform_os_cpu_enabled_>;
  using ScopedRegionCapture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_region_capture_enabled_>;
  using ScopedRelatedWebsitePartitionAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_related_website_partition_api_enabled_>;
  using ScopedRelaxDOMValidNames = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_relax_dom_valid_names_enabled_>;
  using ScopedRelOpenerBcgDependencyHint = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rel_opener_bcg_dependency_hint_enabled_>;
  using ScopedRemotePlayback = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_remote_playback_enabled_>;
  using ScopedRemotePlaybackBackend = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_remote_playback_backend_enabled_>;
  using ScopedRemoveCharsetAutoDetectionForISO2022JP = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_remove_charset_auto_detection_for_iso_2022_jp_enabled_>;
  using ScopedRemoveCollapsedPlaceholderForContentEditable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_remove_collapsed_placeholder_for_content_editable_enabled_>;
  using ScopedRemoveDanglingMarkupInTarget = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_remove_dangling_markup_in_target_enabled_>;
  using ScopedRemoveDataUrlInSvgUse = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_remove_data_url_in_svg_use_enabled_>;
  using ScopedRemoveFormatFilterBackgroundColor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_remove_format_filter_background_color_enabled_>;
  using ScopedRemoveSelectionCanonicalizationInMoveParagraph = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_remove_selection_canonicalization_in_move_paragraph_enabled_>;
  using ScopedRemoveVisibleSelectionInDOMSelection = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_remove_visible_selection_in_dom_selection_enabled_>;
  using ScopedRenderBlockingFullFrameRate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_render_blocking_full_frame_rate_enabled_>;
  using ScopedRenderBlockingStatus = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_render_blocking_status_enabled_>;
  using ScopedRenderPriorityAttribute = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_render_priority_attribute_enabled_>;
  using ScopedReportFirstFrameTimeAsRenderTime = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_report_first_frame_time_as_render_time_enabled_>;
  using ScopedRequestMainFrameAfterFirstVideoFrame = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_request_main_frame_after_first_video_frame_enabled_>;
  using ScopedResolveVarStylesOnCopy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_resolve_var_styles_on_copy_enabled_>;
  using ScopedResourceTimingContentEncoding = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_resource_timing_content_encoding_enabled_>;
  using ScopedResourceTimingContentType = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_resource_timing_content_type_enabled_>;
  using ScopedResourceTimingInitiator = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_resource_timing_initiator_enabled_>;
  using ScopedResourceTimingUseCORSForBodySizes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_resource_timing_use_cors_for_body_sizes_enabled_>;
  using ScopedResponsiveIframes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_responsive_iframes_enabled_>;
  using ScopedRestrictGamepadAccess = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_restrict_gamepad_access_enabled_>;
  using ScopedRestrictOwnAudio = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_restrict_own_audio_enabled_>;
  using ScopedRestrictTabFocusForHiddenSVGElements = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_restrict_tab_focus_for_hidden_svg_elements_enabled_>;
  using ScopedRootScrollbarFollowsBrowserTheme = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_root_scrollbar_follows_browser_theme_enabled_>;
  using ScopedRouteMatching = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_route_matching_enabled_>;
  using ScopedRtcAudioJitterBufferMaxPackets = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_audio_jitter_buffer_max_packets_enabled_>;
  using ScopedRTCDataChannelPriority = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_data_channel_priority_enabled_>;
  using ScopedRTCEncodedFrameAudioLevel = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_encoded_frame_audio_level_enabled_>;
  using ScopedRTCEncodedFrameSetMetadata = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_encoded_frame_set_metadata_enabled_>;
  using ScopedRTCEncodedFrameTimestamps = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_encoded_frame_timestamps_enabled_>;
  using ScopedRTCEncodedVideoFrameAdditionalMetadata = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_encoded_video_frame_additional_metadata_enabled_>;
  using ScopedRTCJitterBufferTarget = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_jitter_buffer_target_enabled_>;
  using ScopedRTCLegacyCallbackBasedGetStats = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_legacy_callback_based_get_stats_enabled_>;
  using ScopedRTCRtpEncodingParametersCodec = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_rtp_encoding_parameters_codec_enabled_>;
  using ScopedRTCRtpScaleResolutionDownTo = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_rtp_scale_resolution_down_to_enabled_>;
  using ScopedRTCRtpScriptTransform = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_rtp_script_transform_enabled_>;
  using ScopedRTCRtpTransport = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_rtp_transport_enabled_>;
  using ScopedRTCStatsRelativePacketArrivalDelay = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_stats_relative_packet_arrival_delay_enabled_>;
  using ScopedRTCSvcScalabilityMode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_rtc_svc_scalability_mode_enabled_>;
  using ScopedRubyShortHeuristics = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_ruby_short_heuristics_enabled_>;
  using ScopedRunSnapshotPostLayoutStateSteps = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_run_snapshot_post_layout_state_steps_enabled_>;
  using ScopedSanitizerAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_sanitizer_api_enabled_>;
  using ScopedSchedulerYieldDisallowCrossFrameInheritance = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scheduler_yield_disallow_cross_frame_inheritance_enabled_>;
  using ScopedScopedCustomElementRegistry = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scoped_custom_element_registry_enabled_>;
  using ScopedScopedViewTransitions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scoped_view_transitions_enabled_>;
  using ScopedScreenDetailedHdrHeadroom = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_screen_detailed_hdr_headroom_enabled_>;
  using ScopedScriptedSpeechRecognition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scripted_speech_recognition_enabled_>;
  using ScopedScriptedSpeechSynthesis = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scripted_speech_synthesis_enabled_>;
  using ScopedScriptRunIteratorCombiningMarkAlways = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_script_run_iterator_combining_mark_always_enabled_>;
  using ScopedScriptRunIteratorCombiningMarks = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_script_run_iterator_combining_marks_enabled_>;
  using ScopedScriptTools = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_script_tools_enabled_>;
  using ScopedScrollAnchorPriorityCandidateSubtree = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scroll_anchor_priority_candidate_subtree_enabled_>;
  using ScopedScrollbarColor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scrollbar_color_enabled_>;
  using ScopedScrollbarWidth = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scrollbar_width_enabled_>;
  using ScopedScrollIntoViewNearest = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scroll_into_view_nearest_enabled_>;
  using ScopedScrollIntoViewRootFrameViewportBugFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scroll_into_view_root_frame_viewport_bug_fix_enabled_>;
  using ScopedScrollIntoViewSelfScrollFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scroll_into_view_self_scroll_fix_enabled_>;
  using ScopedScrollTimelineCurrentTime = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scroll_timeline_current_time_enabled_>;
  using ScopedScrollTimelineNamedRangeScroll = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scroll_timeline_named_range_scroll_enabled_>;
  using ScopedScrollTopLeftInterop = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_scroll_top_left_interop_enabled_>;
  using ScopedSearchTextHighlightPseudo = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_search_text_highlight_pseudo_enabled_>;
  using ScopedSecurePaymentConfirmation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_secure_payment_confirmation_enabled_>;
  using ScopedSecurePaymentConfirmationAvailabilityAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_secure_payment_confirmation_availability_api_enabled_>;
  using ScopedSecurePaymentConfirmationBrowserBoundKeys = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_secure_payment_confirmation_browser_bound_keys_enabled_>;
  using ScopedSecurePaymentConfirmationDebug = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_secure_payment_confirmation_debug_enabled_>;
  using ScopedSecurePaymentConfirmationOptOut = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_secure_payment_confirmation_opt_out_enabled_>;
  using ScopedSecurePaymentConfirmationUxRefresh = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_secure_payment_confirmation_ux_refresh_enabled_>;
  using ScopedSelectAudioOutput = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_select_audio_output_enabled_>;
  using ScopedSelectChildrenRemovedFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_select_children_removed_fix_enabled_>;
  using ScopedSelectedcontentelementAttribute = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_selectedcontentelement_attribute_enabled_>;
  using ScopedSelectionAndFocusedVisiblePositionMatch = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_selection_and_focused_visible_position_match_enabled_>;
  using ScopedSelectionHandleWithBottomClipped = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_selection_handle_with_bottom_clipped_enabled_>;
  using ScopedSelectionSetBaseAndExtentNonNullNode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_selection_set_base_and_extent_non_null_node_enabled_>;
  using ScopedSelectionUpdateToInitialSelectionInListify = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_selection_update_to_initial_selection_in_listify_enabled_>;
  using ScopedSelectiveClipboardFormatRead = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_selective_clipboard_format_read_enabled_>;
  using ScopedSelectivePermissionsIntervention = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_selective_permissions_intervention_enabled_>;
  using ScopedSelectMobileDesktopParity = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_select_mobile_desktop_parity_enabled_>;
  using ScopedSendBeaconThrowForBlobWithNonSimpleType = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_send_beacon_throw_for_blob_with_non_simple_type_enabled_>;
  using ScopedSensorExtraClasses = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_sensor_extra_classes_enabled_>;
  using ScopedSeparateDeferModuleScriptTasks = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_separate_defer_module_script_tasks_enabled_>;
  using ScopedSerial = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_serial_enabled_>;
  using ScopedSerializeViewTransitionStateInSPA = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_serialize_view_transition_state_in_spa_enabled_>;
  using ScopedSerialPortConnected = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_serial_port_connected_enabled_>;
  using ScopedServiceWorkerBackgroundSyncInDedicatedWorker = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_service_worker_background_sync_in_dedicated_worker_enabled_>;
  using ScopedServiceWorkerClientLifecycleState = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_service_worker_client_lifecycle_state_enabled_>;
  using ScopedServiceWorkerInDedicatedWorker = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_service_worker_in_dedicated_worker_enabled_>;
  using ScopedServiceWorkerStaticRouterTimingInfo = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_service_worker_static_router_timing_info_enabled_>;
  using ScopedSetSequentialFocusStartingPoint = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_set_sequential_focus_starting_point_enabled_>;
  using ScopedShadowRootReferenceTarget = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shadow_root_reference_target_enabled_>;
  using ScopedShadowRootReferenceTargetAriaOwns = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shadow_root_reference_target_aria_owns_enabled_>;
  using ScopedShapeResultCachedPreviousSafeToBreakOffset = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shape_result_cached_previous_safe_to_break_offset_enabled_>;
  using ScopedSharedArrayBuffer = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shared_array_buffer_enabled_>;
  using ScopedSharedArrayBufferUnrestrictedAccessAllowed = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shared_array_buffer_unrestricted_access_allowed_enabled_>;
  using ScopedSharedAutofill = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shared_autofill_enabled_>;
  using ScopedSharedStorageAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shared_storage_api_enabled_>;
  using ScopedSharedStorageWebLocks = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shared_storage_web_locks_enabled_>;
  using ScopedSharedWorker = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shared_worker_enabled_>;
  using ScopedSharedWorkerExtendedLifetime = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_shared_worker_extended_lifetime_enabled_>;
  using ScopedSideRelativeBackgroundPosition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_side_relative_background_position_enabled_>;
  using ScopedSignatureBasedInlineIntegrity = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_signature_based_inline_integrity_enabled_>;
  using ScopedSignatureBasedIntegrity = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_signature_based_integrity_enabled_>;
  using ScopedSkipAd = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_skip_ad_enabled_>;
  using ScopedSkipCallbacksWhenDevToolsNotOpen = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_skip_callbacks_when_dev_tools_not_open_enabled_>;
  using ScopedSkipLineBreakItemWhenIsCollapsed = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_skip_line_break_item_when_is_collapsed_enabled_>;
  using ScopedSkipOofItemForBreakCandidate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_skip_oof_item_for_break_candidate_enabled_>;
  using ScopedSkipTouchEventFilter = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_skip_touch_event_filter_enabled_>;
  using ScopedSkipUnselectableContentInSerialization = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_skip_unselectable_content_in_serialization_enabled_>;
  using ScopedSmartCard = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_smart_card_enabled_>;
  using ScopedSmartZoom = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_smart_zoom_enabled_>;
  using ScopedSmilKeyTimesKeyPointsAllowTrailingSemicolon = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_smil_key_times_key_points_allow_trailing_semicolon_enabled_>;
  using ScopedSoftNavigationDetection = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_soft_navigation_detection_enabled_>;
  using ScopedSoftNavigationDetectionAdvancedPaintAttribution = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_soft_navigation_detection_advanced_paint_attribution_enabled_>;
  using ScopedSoftNavigationDetectionPrePaintBasedAttribution = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_soft_navigation_detection_pre_paint_based_attribution_enabled_>;
  using ScopedSoftNavigationHeuristics = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_soft_navigation_heuristics_enabled_>;
  using ScopedSpatNavUsesCursorInheritance = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_spat_nav_uses_cursor_inheritance_enabled_>;
  using ScopedSpeakerSelection = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_speaker_selection_enabled_>;
  using ScopedSpecialRulesForNestedH1Elements = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_special_rules_for_nested_h_1_elements_enabled_>;
  using ScopedSpeculationRulesPrefetchWithSubresources = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_speculation_rules_prefetch_with_subresources_enabled_>;
  using ScopedSplitTextNotCleanupDummySpans = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_split_text_not_cleanup_dummy_spans_enabled_>;
  using ScopedSrcsetSelectionMatchesImageSet = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_srcset_selection_matches_image_set_enabled_>;
  using ScopedStableBlinkFeatures = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_stable_blink_features_enabled_>;
  using ScopedStandardizedBrowserZoom = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_standardized_browser_zoom_enabled_>;
  using ScopedStandardizedBrowserZoomOptOut = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_standardized_browser_zoom_opt_out_enabled_>;
  using ScopedStickyUserActivationAcrossSameOriginNavigation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_sticky_user_activation_across_same_origin_navigation_enabled_>;
  using ScopedStorageBuckets = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_storage_buckets_enabled_>;
  using ScopedStorageBucketsDurability = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_storage_buckets_durability_enabled_>;
  using ScopedStorageBucketsLocks = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_storage_buckets_locks_enabled_>;
  using ScopedStrictJsonMimeTypeTokenValidation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_strict_json_mime_type_token_validation_enabled_>;
  using ScopedStrictMimeTypesForWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_strict_mime_types_for_workers_enabled_>;
  using ScopedStylusHandwriting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_stylus_handwriting_enabled_>;
  using ScopedSvg2Cascade = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_2_cascade_enabled_>;
  using ScopedSvgAnchorElementDownloadAttribute = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_anchor_element_download_attribute_enabled_>;
  using ScopedSvgAnchorElementRelAttributes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_anchor_element_rel_attributes_enabled_>;
  using ScopedSvgAvoidCullingElementsWithTransformOperations = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_avoid_culling_elements_with_transform_operations_enabled_>;
  using ScopedSvgEagerPresAttrStyleUpdate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_eager_pres_attr_style_update_enabled_>;
  using ScopedSVGEmbeddedAsReplacedElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_embedded_as_replaced_element_enabled_>;
  using ScopedSvgEnableTextDecorationCssStyling = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_enable_text_decoration_css_styling_enabled_>;
  using ScopedSvgExternalResources = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_external_resources_enabled_>;
  using ScopedSvgFallBackToContainerSize = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_fall_back_to_container_size_enabled_>;
  using ScopedSvgFeConvolveMatrixZeroDivisorBehavior = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_fe_convolve_matrix_zero_divisor_behavior_enabled_>;
  using ScopedSvgFilterPaintsForHiddenContent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_filter_paints_for_hidden_content_enabled_>;
  using ScopedSvgIgnoreNegativeEllipseRadii = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_ignore_negative_ellipse_radii_enabled_>;
  using ScopedSvgImageNoExternalXslt = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_image_no_external_xslt_enabled_>;
  using ScopedSvgInlineRootPixelSnappingScaleAdjustment = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_inline_root_pixel_snapping_scale_adjustment_enabled_>;
  using ScopedSvgNoPixelSnappingScaleAdjustment = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_no_pixel_snapping_scale_adjustment_enabled_>;
  using ScopedSvgPartitionSVGDocumentResourcesInMemoryCache = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_partition_svg_document_resources_in_memory_cache_enabled_>;
  using ScopedSvgScriptElementAsyncAttribute = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_script_element_async_attribute_enabled_>;
  using ScopedSvgSizingWithPreserveAspectRatioNone = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_sizing_with_preserve_aspect_ratio_none_enabled_>;
  using ScopedSvgSmilPruneInstanceTimes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_smil_prune_instance_times_enabled_>;
  using ScopedSvgTextCentralBaselineTextDecorationFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_text_central_baseline_text_decoration_fix_enabled_>;
  using ScopedSvgTransformOnNestedSvgElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_transform_on_nested_svg_element_enabled_>;
  using ScopedSvgUseInstancesAttributeSync = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_svg_use_instances_attribute_sync_enabled_>;
  using ScopedSynthesizedKeyboardEventsForAccessibilityActions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_synthesized_keyboard_events_for_accessibility_actions_enabled_>;
  using ScopedSystemDefaultAccentColors = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_system_default_accent_colors_enabled_>;
  using ScopedSystemFallbackEmojiVSSupport = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_system_fallback_emoji_vs_support_enabled_>;
  using ScopedSystemWakeLock = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_system_wake_lock_enabled_>;
  using ScopedTableIsAutoFixedLayout = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_table_is_auto_fixed_layout_enabled_>;
  using ScopedTabSizeAncestor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_tab_size_ancestor_enabled_>;
  using ScopedTabSizeWithSpacing = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_tab_size_with_spacing_enabled_>;
  using ScopedTabWidthNegativePosition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_tab_width_negative_position_enabled_>;
  using ScopedTargetInShadowDeterminedBeforeListener = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_target_in_shadow_determined_before_listener_enabled_>;
  using ScopedTestBlinkFeatureDefault = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_test_blink_feature_default_enabled_>;
  using ScopedTestFeature = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_test_feature_enabled_>;
  using ScopedTestFeatureDependent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_test_feature_dependent_enabled_>;
  using ScopedTestFeatureForBrowserProcessReadWriteAccessOriginTrial = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_test_feature_for_browser_process_read_write_access_origin_trial_enabled_>;
  using ScopedTestFeatureImplied = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_test_feature_implied_enabled_>;
  using ScopedTestFeatureProtected = ScopedRuntimeEnabledProtectedFeature<
    RuntimeEnabledFeaturesBase::is_test_feature_protected_enabled_>;
  using ScopedTestFeatureProtectedDependent = ScopedRuntimeEnabledProtectedFeature<
    RuntimeEnabledFeaturesBase::is_test_feature_protected_dependent_enabled_>;
  using ScopedTestFeatureProtectedImplied = ScopedRuntimeEnabledProtectedFeature<
    RuntimeEnabledFeaturesBase::is_test_feature_protected_implied_enabled_>;
  using ScopedTestFeatureStable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_test_feature_stable_enabled_>;
  using ScopedTextareaLastLineRemovalFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_textarea_last_line_removal_fix_enabled_>;
  using ScopedTextareaLineEndingsAsBr = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_textarea_line_endings_as_br_enabled_>;
  using ScopedTextareaMultipleIfcs = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_textarea_multiple_ifcs_enabled_>;
  using ScopedTextareaSplitText = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_textarea_split_text_enabled_>;
  using ScopedTextDecorationOmitCurrentColor = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_decoration_omit_current_color_enabled_>;
  using ScopedTextDecorationShortSerialization = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_decoration_short_serialization_enabled_>;
  using ScopedTextDetector = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_detector_enabled_>;
  using ScopedTextDiffSplitFix = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_diff_split_fix_enabled_>;
  using ScopedTextEmphasisLetterSpacing = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_emphasis_letter_spacing_enabled_>;
  using ScopedTextEmphasisPositionAuto = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_emphasis_position_auto_enabled_>;
  using ScopedTextEmphasisPunctuationExceptions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_emphasis_punctuation_exceptions_enabled_>;
  using ScopedTextFragmentAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_fragment_api_enabled_>;
  using ScopedTextFragmentIdentifiers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_fragment_identifiers_enabled_>;
  using ScopedTextFragmentTapOpensContextMenu = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_fragment_tap_opens_context_menu_enabled_>;
  using ScopedTextMetricsBaselines = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_metrics_baselines_enabled_>;
  using ScopedTextOverflowString = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_overflow_string_enabled_>;
  using ScopedTextSpacingTrimFallback = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_spacing_trim_fallback_enabled_>;
  using ScopedTextSpacingTrimFallback2 = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_spacing_trim_fallback_2_enabled_>;
  using ScopedTextSpacingTrimYuGothicUI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_text_spacing_trim_yu_gothic_ui_enabled_>;
  using ScopedThirdPartyStoragePartitioningUserBypass = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_third_party_storage_partitioning_user_bypass_enabled_>;
  using ScopedTimerThrottlingForBackgroundTabs = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_timer_throttling_for_background_tabs_enabled_>;
  using ScopedTimestampBasedCLSTracking = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_timestamp_based_cls_tracking_enabled_>;
  using ScopedTimeZoneChangeEvent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_time_zone_change_event_enabled_>;
  using ScopedToggleEventSource = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_toggle_event_source_enabled_>;
  using ScopedTopicsAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_topics_api_enabled_>;
  using ScopedTopicsDocumentAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_topics_document_api_enabled_>;
  using ScopedTopicsImgAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_topics_img_api_enabled_>;
  using ScopedTopLevelTpcd = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_top_level_tpcd_enabled_>;
  using ScopedTouchDragAndContextMenu = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_touch_drag_and_context_menu_enabled_>;
  using ScopedTouchDragAndDrop = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_touch_drag_and_drop_enabled_>;
  using ScopedTouchDragOnShortPress = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_touch_drag_on_short_press_enabled_>;
  using ScopedTouchEventFeatureDetection = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_touch_event_feature_detection_enabled_>;
  using ScopedTouchTextEditingRedesign = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_touch_text_editing_redesign_enabled_>;
  using ScopedTpcd = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_tpcd_enabled_>;
  using ScopedTransferableRTCDataChannel = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_transferable_rtc_data_channel_enabled_>;
  using ScopedTranslateService = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_translate_service_enabled_>;
  using ScopedTranslationAPI = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_translation_api_enabled_>;
  using ScopedTranslationAPIForWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_translation_api_for_workers_enabled_>;
  using ScopedTraverseFlatTreeToHandleSlots = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_traverse_flat_tree_to_handle_slots_enabled_>;
  using ScopedTreatMhtmlInitialDocumentLoadsAsCrossDocument = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_treat_mhtml_initial_document_loads_as_cross_document_enabled_>;
  using ScopedTrustedTypesFromLiteral = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_trusted_types_from_literal_enabled_>;
  using ScopedTrustedTypesHTML = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_trusted_types_html_enabled_>;
  using ScopedTrustedTypesUseCodeLike = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_trusted_types_use_code_like_enabled_>;
  using ScopedTwoPhaseViewTransition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_two_phase_view_transition_enabled_>;
  using ScopedUnclosedFormControlIsInvalid = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_unclosed_form_control_is_invalid_enabled_>;
  using ScopedUnencodedDigest = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_unencoded_digest_enabled_>;
  using ScopedUnexposedTaskIds = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_unexposed_task_ids_enabled_>;
  using ScopedUnprefixedSpeechRecognition = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_unprefixed_speech_recognition_enabled_>;
  using ScopedUnrestrictedMeasureUserAgentSpecificMemory = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_unrestricted_measure_user_agent_specific_memory_enabled_>;
  using ScopedUnrestrictedSharedArrayBuffer = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_unrestricted_shared_array_buffer_enabled_>;
  using ScopedUnrestrictedUsb = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_unrestricted_usb_enabled_>;
  using ScopedUpdateComplexSafaAreaConstraints = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_update_complex_safa_area_constraints_enabled_>;
  using ScopedUpdateSelectionOnNodeInsertion = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_update_selection_on_node_insertion_enabled_>;
  using ScopedUpdateTrivalTextAfterFragmentCreationFromText = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_update_trival_text_after_fragment_creation_from_text_enabled_>;
  using ScopedURLPatternCompareComponent = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_url_pattern_compare_component_enabled_>;
  using ScopedURLPatternGenerate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_url_pattern_generate_enabled_>;
  using ScopedURLSearchParamsHasAndDeleteMultipleArgs = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_url_search_params_has_and_delete_multiple_args_enabled_>;
  using ScopedUseBeginFramePresentationFeedback = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_begin_frame_presentation_feedback_enabled_>;
  using ScopedUseLowQualityInterpolation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_low_quality_interpolation_enabled_>;
  using ScopedUseOriginalDomOffsetsForOffsetMap = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_original_dom_offsets_for_offset_map_enabled_>;
  using ScopedUsePersistentCacheForCodeCache = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_persistent_cache_for_code_cache_enabled_>;
  using ScopedUsePositionForPointInFlexibleBoxWithSingleChildElement = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_position_for_point_in_flexible_box_with_single_child_element_enabled_>;
  using ScopedUsePositionIfIsVisuallyEquivalentCandidate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_position_if_is_visually_equivalent_candidate_enabled_>;
  using ScopedUserDefinedEntryPointTiming = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_user_defined_entry_point_timing_enabled_>;
  using ScopedUseSelectionInDOMTreeAnchorInExtendSelection = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_selection_in_dom_tree_anchor_in_extend_selection_enabled_>;
  using ScopedUseShadowHostStyleCheckEditable = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_shadow_host_style_check_editable_enabled_>;
  using ScopedUseSpecValuesInTextFormatUpdateEventStyles = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_spec_values_in_text_format_update_event_styles_enabled_>;
  using ScopedUseUndoStepElementDispatchBeforeInput = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_use_undo_step_element_dispatch_before_input_enabled_>;
  using ScopedV8IdleTasks = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_v8_idle_tasks_enabled_>;
  using ScopedVideoAutoFullscreen = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_video_auto_fullscreen_enabled_>;
  using ScopedVideoFrameMetadataBackgroundBlur = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_video_frame_metadata_background_blur_enabled_>;
  using ScopedVideoFrameMetadataRtpTimestamp = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_video_frame_metadata_rtp_timestamp_enabled_>;
  using ScopedVideoFullscreenOrientationLock = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_video_fullscreen_orientation_lock_enabled_>;
  using ScopedVideoRotateToFullscreen = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_video_rotate_to_fullscreen_enabled_>;
  using ScopedVideoTrackGenerator = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_video_track_generator_enabled_>;
  using ScopedVideoTrackGeneratorInWindow = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_video_track_generator_in_window_enabled_>;
  using ScopedVideoTrackGeneratorInWorker = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_video_track_generator_in_worker_enabled_>;
  using ScopedViewportHeightClientHintHeader = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_viewport_height_client_hint_header_enabled_>;
  using ScopedViewportSegments = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_viewport_segments_enabled_>;
  using ScopedViewTransitionAnimationDelayInherit = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_view_transition_animation_delay_inherit_enabled_>;
  using ScopedViewTransitionAsyncFinished = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_view_transition_async_finished_enabled_>;
  using ScopedViewTransitionInheritAnimationProperties = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_view_transition_inherit_animation_properties_enabled_>;
  using ScopedViewTransitionLongCallbackTimeoutForTesting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_view_transition_long_callback_timeout_for_testing_enabled_>;
  using ScopedViewTransitionUpdateLifecycleBeforeReady = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_view_transition_update_lifecycle_before_ready_enabled_>;
  using ScopedVisibilityCollapseColumn = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_visibility_collapse_column_enabled_>;
  using ScopedWakeLock = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_wake_lock_enabled_>;
  using ScopedWarnOnContentVisibilityRenderAccess = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_warn_on_content_visibility_render_access_enabled_>;
  using ScopedWebAppInstallation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_app_installation_enabled_>;
  using ScopedWebAppLaunchQueue = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_app_launch_queue_enabled_>;
  using ScopedWebAppScopeExtensions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_app_scope_extensions_enabled_>;
  using ScopedWebAppTabStrip = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_app_tab_strip_enabled_>;
  using ScopedWebAppTabStripCustomizations = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_app_tab_strip_customizations_enabled_>;
  using ScopedWebAppTranslations = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_app_translations_enabled_>;
  using ScopedWebAssemblyCustomDescriptors = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_assembly_custom_descriptors_enabled_>;
  using ScopedWebAssemblyJSPromiseIntegration = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_assembly_js_promise_integration_enabled_>;
  using ScopedWebAudioBypassOutputBuffering = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_audio_bypass_output_buffering_enabled_>;
  using ScopedWebAudioBypassOutputBufferingOptOut = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_audio_bypass_output_buffering_opt_out_enabled_>;
  using ScopedWebAudioConfigurableRenderQuantum = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_audio_configurable_render_quantum_enabled_>;
  using ScopedWebAuth = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_auth_enabled_>;
  using ScopedWebAuthAuthenticatorAttachment = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_auth_authenticator_attachment_enabled_>;
  using ScopedWebAuthenticationAmbient = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_authentication_ambient_enabled_>;
  using ScopedWebAuthenticationAttestationFormats = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_authentication_attestation_formats_enabled_>;
  using ScopedWebAuthenticationChallengeUrl = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_authentication_challenge_url_enabled_>;
  using ScopedWebAuthenticationConditionalCreate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_authentication_conditional_create_enabled_>;
  using ScopedWebAuthenticationImmediateGet = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_authentication_immediate_get_enabled_>;
  using ScopedWebAuthenticationRemoteDesktopSupport = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_authentication_remote_desktop_support_enabled_>;
  using ScopedWebAuthenticationSupplementalPubKeys = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_authentication_supplemental_pub_keys_enabled_>;
  using ScopedWebBluetooth = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_bluetooth_enabled_>;
  using ScopedWebBluetoothGetDevices = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_bluetooth_get_devices_enabled_>;
  using ScopedWebBluetoothScanning = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_bluetooth_scanning_enabled_>;
  using ScopedWebBluetoothWatchAdvertisements = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_bluetooth_watch_advertisements_enabled_>;
  using ScopedWebCodecsCopyToRGB = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webcodecs_copy_to_rgb_enabled_>;
  using ScopedWebCodecsHBDFormats = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webcodecs_hbd_formats_enabled_>;
  using ScopedWebCodecsOrientation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webcodecs_orientation_enabled_>;
  using ScopedWebCodecsVideoEncoderBuffers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webcodecs_video_encoder_buffers_enabled_>;
  using ScopedWebFontResizeLCP = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_font_resize_lcp_enabled_>;
  using ScopedWebGLDeveloperExtensions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webgl_developer_extensions_enabled_>;
  using ScopedWebGLDraftExtensions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webgl_draft_extensions_enabled_>;
  using ScopedWebGLDrawingBufferStorage = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webgl_drawing_buffer_storage_enabled_>;
  using ScopedWebGLImageChromium = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webgl_image_chromium_enabled_>;
  using ScopedWebGLOnWebGPU = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webgl_on_webgpu_enabled_>;
  using ScopedWebGPUCompatibilityMode = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webgpu_compatibility_mode_enabled_>;
  using ScopedWebGPUDeveloperFeatures = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webgpu_developer_features_enabled_>;
  using ScopedWebGPUExperimentalFeatures = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_webgpu_experimental_features_enabled_>;
  using ScopedWebHID = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_hid_enabled_>;
  using ScopedWebHIDOnServiceWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_hid_on_service_workers_enabled_>;
  using ScopedWebIdentityDigitalCredentials = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_identity_digital_credentials_enabled_>;
  using ScopedWebIdentityDigitalCredentialsCreation = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_identity_digital_credentials_creation_enabled_>;
  using ScopedWebIDLBigIntUsesToBigInt = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_idl_big_int_uses_to_big_int_enabled_>;
  using ScopedWebNFC = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_nfc_enabled_>;
  using ScopedWebOTP = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_otp_enabled_>;
  using ScopedWebOTPAssertionFeaturePolicy = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_otp_assertion_feature_policy_enabled_>;
  using ScopedWebPreferences = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_preferences_enabled_>;
  using ScopedWebPrinting = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_printing_enabled_>;
  using ScopedWebShare = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_share_enabled_>;
  using ScopedWebSocketStream = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_websocket_stream_enabled_>;
  using ScopedWebSpeechRecognitionContext = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_speech_recognition_context_enabled_>;
  using ScopedWebTransportApplicationProtocol = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_transport_application_protocol_enabled_>;
  using ScopedWebTransportCustomCertificates = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_transport_custom_certificates_enabled_>;
  using ScopedWebTransportStats = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_transport_stats_enabled_>;
  using ScopedWebUIBundledCodeCacheAsyncFetch = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_ui_bundled_code_cache_async_fetch_enabled_>;
  using ScopedWebUSB = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_usb_enabled_>;
  using ScopedWebUSBOnDedicatedWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_usb_on_dedicated_workers_enabled_>;
  using ScopedWebUSBOnServiceWorkers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_usb_on_service_workers_enabled_>;
  using ScopedWebVTTRegions = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_vtt_regions_enabled_>;
  using ScopedWebXR = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_enabled_>;
  using ScopedWebXREnabledFeatures = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_enabled_features_enabled_>;
  using ScopedWebXRFrameRate = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_frame_rate_enabled_>;
  using ScopedWebXRFrontFacing = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_front_facing_enabled_>;
  using ScopedWebXRGPUBinding = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_gpu_binding_enabled_>;
  using ScopedWebXRHitTestEntityTypes = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_hit_test_entity_types_enabled_>;
  using ScopedWebXRImageTracking = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_image_tracking_enabled_>;
  using ScopedWebXRLayers = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_layers_enabled_>;
  using ScopedWebXRLayersCommon = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_layers_common_enabled_>;
  using ScopedWebXRPlaneDetection = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_plane_detection_enabled_>;
  using ScopedWebXRPoseMotionData = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_pose_motion_data_enabled_>;
  using ScopedWebXRSpecParity = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_web_xr_spec_parity_enabled_>;
  using ScopedWidthAndHeightAsPresentationAttributesOnNestedSvg = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_width_and_height_as_presentation_attributes_on_nested_svg_enabled_>;
  using ScopedWidthAndHeightStylePropertiesOnUseAndSymbol = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_width_and_height_style_properties_on_use_and_symbol_enabled_>;
  using ScopedWindowControlsOverlay = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_window_controls_overlay_enabled_>;
  using ScopedWindowDefaultStatus = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_window_default_status_enabled_>;
  using ScopedWordSpacingWhiteSpacePre = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_word_spacing_white_space_pre_enabled_>;
  using ScopedXMLSerializerConsistentDefaultNsDeclMatching = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_xml_serializer_consistent_default_ns_decl_matching_enabled_>;
  using ScopedXSLT = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_xslt_enabled_>;
  using ScopedZeroCopyTabCapture = ScopedRuntimeEnabledFeature<
      RuntimeEnabledFeaturesBase::is_zero_copy_tab_capture_enabled_>;
};

using ScopedAbortByPlaceholderLayoutForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAbortByPlaceholderLayout;
using ScopedAboutBlankPageRespectsDarkModeOnUserActionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAboutBlankPageRespectsDarkModeOnUserAction;
using ScopedAccelerated2dCanvasForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccelerated2dCanvas;
using ScopedAcceleratedSmallCanvasesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAcceleratedSmallCanvases;
using ScopedAccessibilityAriaVirtualContentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessibilityAriaVirtualContent;
using ScopedAccessibilityCustomElementRoleNoneForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessibilityCustomElementRoleNone;
using ScopedAccessibilityExposeDisplayNoneForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessibilityExposeDisplayNone;
using ScopedAccessibilityImplicitActionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessibilityImplicitActions;
using ScopedAccessibilityMinRoleTabbableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessibilityMinRoleTabbable;
using ScopedAccessibilityOSLevelBoldTextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessibilityOSLevelBoldText;
using ScopedAccessibilityProhibitedNamesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessibilityProhibitedNames;
using ScopedAccessibilitySerializationSizeMetricsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessibilitySerializationSizeMetrics;
using ScopedAccessibilityUseAXPositionForDocumentMarkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessibilityUseAXPositionForDocumentMarkers;
using ScopedAccessKeyLabelForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAccessKeyLabel;
using ScopedAddressSpaceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAddressSpace;
using ScopedAdInterestGroupAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAdInterestGroupAPI;
using ScopedAdjustDOMOffsetToLayoutOffsetForSecureTextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAdjustDOMOffsetToLayoutOffsetForSecureText;
using ScopedAdjustEndOfNextParagraphIfMovedParagraphIsUpdatedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAdjustEndOfNextParagraphIfMovedParagraphIsUpdated;
using ScopedAdTaggingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAdTagging;
using ScopedAIPageContentPaidContentAnnotationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIPageContentPaidContentAnnotation;
using ScopedAIPromptAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIPromptAPI;
using ScopedAIPromptAPIForExtensionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIPromptAPIForExtension;
using ScopedAIPromptAPIForWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIPromptAPIForWorkers;
using ScopedAIPromptAPIMultimodalInputForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIPromptAPIMultimodalInput;
using ScopedAIPromptAPIStructuredOutputForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIPromptAPIStructuredOutput;
using ScopedAIProofreadingAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIProofreadingAPI;
using ScopedAIRewriterAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIRewriterAPI;
using ScopedAIRewriterAPIForWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIRewriterAPIForWorkers;
using ScopedAISummarizationAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAISummarizationAPI;
using ScopedAISummarizationAPIForWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAISummarizationAPIForWorkers;
using ScopedAIWriterAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIWriterAPI;
using ScopedAIWriterAPIForWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAIWriterAPIForWorkers;
using ScopedAlignZoomToCenterForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAlignZoomToCenter;
using ScopedAllowContentInitiatedDataUrlNavigationsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAllowContentInitiatedDataUrlNavigations;
using ScopedAllowCopyingEmptyLastTableCellForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAllowCopyingEmptyLastTableCell;
using ScopedAllowPreloadingWithCSPMetaTagForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAllowPreloadingWithCSPMetaTag;
using ScopedAllowSameSiteNoneCookiesInSandboxForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAllowSameSiteNoneCookiesInSandbox;
using ScopedAllowSkippingEditingBoundaryToMergeEndForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAllowSkippingEditingBoundaryToMergeEnd;
using ScopedAllowSvgUseToReferenceExternalDocumentRootForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAllowSvgUseToReferenceExternalDocumentRoot;
using ScopedAllowSyntheticTimingForCanvasCaptureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAllowSyntheticTimingForCanvasCapture;
using ScopedAllowURNsInIframesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAllowURNsInIframes;
using ScopedAncestorRevealingNewSpecForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAncestorRevealingNewSpec;
using ScopedAnchorPositionAdjustmentWithoutOverflowForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAnchorPositionAdjustmentWithoutOverflow;
using ScopedAnchorsVisibleInitialValueForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAnchorsVisibleInitialValue;
using ScopedAndroidDownloadableFontsMatchingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAndroidDownloadableFontsMatching;
using ScopedAnimationProgressAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAnimationProgressAPI;
using ScopedAnimationTriggerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAnimationTrigger;
using ScopedAnimationWorkletForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAnimationWorklet;
using ScopedAnonymousIframeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAnonymousIframe;
using ScopedAOMAriaRelationshipPropertiesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAOMAriaRelationshipProperties;
using ScopedAOMAriaRelationshipPropertiesAriaOwnsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAOMAriaRelationshipPropertiesAriaOwns;
using ScopedAppTitleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAppTitle;
using ScopedAriaActionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAriaActions;
using ScopedAriaNotifyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAriaNotify;
using ScopedAriaNotifyV2ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAriaNotifyV2;
using ScopedAriaRowColIndexTextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAriaRowColIndexText;
using ScopedAsymmetricWordBoundaryFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAsymmetricWordBoundaryFix;
using ScopedAsyncSetCookieForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAsyncSetCookie;
using ScopedAttributionReportingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAttributionReporting;
using ScopedAudioContextOnErrorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAudioContextOnError;
using ScopedAudioContextPlayoutStatsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAudioContextPlayoutStats;
using ScopedAudioContextSetSinkIdForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAudioContextSetSinkId;
using ScopedAudioOutputDevicesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAudioOutputDevices;
using ScopedAudioVideoTracksForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAudioVideoTracks;
using ScopedAuthenticatorPasswordsOnlyImmediateRequestsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAuthenticatorPasswordsOnlyImmediateRequests;
using ScopedAutoDarkModeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAutoDarkMode;
using ScopedAutomationControlledForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAutomationControlled;
using ScopedAutoPictureInPictureVideoHeuristicsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAutoPictureInPictureVideoHeuristics;
using ScopedAvoidForcedLayoutOnInvisibleDocumentCloseForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAvoidForcedLayoutOnInvisibleDocumentClose;
using ScopedAvoidNormalizingVisiblePositionsWhenStartEqualsEndForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedAvoidNormalizingVisiblePositionsWhenStartEqualsEnd;
using ScopedBackdropRootForClipPathWithBackdropFilterForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackdropRootForClipPathWithBackdropFilter;
using ScopedBackfaceVisibilityInteropForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackfaceVisibilityInterop;
using ScopedBackForwardCacheForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackForwardCache;
using ScopedBackForwardCacheExperimentHTTPHeaderForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackForwardCacheExperimentHTTPHeader;
using ScopedBackForwardCacheNotRestoredReasonsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackForwardCacheNotRestoredReasons;
using ScopedBackForwardCacheRestorationPerformanceEntryForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackForwardCacheRestorationPerformanceEntry;
using ScopedBackForwardCacheUpdateNotRestoredReasonsNameForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackForwardCacheUpdateNotRestoredReasonsName;
using ScopedBackForwardTransitionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackForwardTransitions;
using ScopedBackgroundFetchForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackgroundFetch;
using ScopedBackgroundPageFreezeOptOutForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBackgroundPageFreezeOptOut;
using ScopedBarcodeDetectorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBarcodeDetector;
using ScopedBidiCaretAffinityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBidiCaretAffinity;
using ScopedBlinkExtensionChromeOSForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBlinkExtensionChromeOS;
using ScopedBlinkExtensionChromeOSKioskForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBlinkExtensionChromeOSKiosk;
using ScopedBlinkExtensionWebViewForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBlinkExtensionWebView;
using ScopedBlinkExtensionWebViewMediaIntegrityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBlinkExtensionWebViewMediaIntegrity;
using ScopedBlinkLifecycleScriptForbiddenForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBlinkLifecycleScriptForbidden;
using ScopedBlinkRuntimeCallStatsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBlinkRuntimeCallStats;
using ScopedBlobBytesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBlobBytes;
using ScopedBlockCanvasReadbackForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBlockCanvasReadback;
using ScopedBlockingFocusWithoutUserActivationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBlockingFocusWithoutUserActivation;
using ScopedBoundaryEventDispatchTracksNodeRemovalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBoundaryEventDispatchTracksNodeRemoval;
using ScopedBrowserInitiatedAutomaticPictureInPictureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBrowserInitiatedAutomaticPictureInPicture;
using ScopedBrowserVerifiedUserActivationKeyboardForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBrowserVerifiedUserActivationKeyboard;
using ScopedBrowserVerifiedUserActivationMouseForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBrowserVerifiedUserActivationMouse;
using ScopedBufferedBytesConsumerLimitSizeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBufferedBytesConsumerLimitSize;
using ScopedBuiltInAIAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBuiltInAIAPI;
using ScopedBypassPepcSecurityForTestingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedBypassPepcSecurityForTesting;
using ScopedCacheStorageCodeCacheHintForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCacheStorageCodeCacheHint;
using ScopedCallExitNodeWithoutLayoutObjectForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCallExitNodeWithoutLayoutObject;
using ScopedCanvas2dCanvasFilterForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvas2dCanvasFilter;
using ScopedCanvas2dGPUTransferForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvas2dGPUTransfer;
using ScopedCanvas2dImageChromiumForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvas2dImageChromium;
using ScopedCanvas2dLayersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvas2dLayers;
using ScopedCanvas2dLayersWithOptionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvas2dLayersWithOptions;
using ScopedCanvas2dMeshForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvas2dMesh;
using ScopedCanvasDrawElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasDrawElement;
using ScopedCanvasDrawElementInSubtreeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasDrawElementInSubtree;
using ScopedCanvasFloatingPointForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasFloatingPoint;
using ScopedCanvasGlobalHDRHeadroomForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasGlobalHDRHeadroom;
using ScopedCanvasGradientCSSColor4ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasGradientCSSColor4;
using ScopedCanvasHDRForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasHDR;
using ScopedCanvasInterventionsTestForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasInterventionsTest;
using ScopedCanvasTextCacheLimitForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasTextCacheLimit;
using ScopedCanvasTextNgForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasTextNg;
using ScopedCanvasTextTexImage2DFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasTextTexImage2DFix;
using ScopedCanvasUsesArcPaintOpForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCanvasUsesArcPaintOp;
using ScopedCapabilityDelegationDisplayCaptureRequestForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCapabilityDelegationDisplayCaptureRequest;
using ScopedCaptureControllerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCaptureController;
using ScopedCapturedMouseEventsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCapturedMouseEvents;
using ScopedCapturedSurfaceControlForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCapturedSurfaceControl;
using ScopedCapturedSurfaceResolutionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCapturedSurfaceResolution;
using ScopedCaptureHandleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCaptureHandle;
using ScopedCaretPositionFromPointTextareaFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCaretPositionFromPointTextareaFix;
using ScopedCaretWithTextAffinityUpstreamForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCaretWithTextAffinityUpstream;
using ScopedCascadedAfterChangeStyleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCascadedAfterChangeStyle;
using ScopedCCTNewRFMPushBehaviorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCCTNewRFMPushBehavior;
using ScopedCheckForCanonicalPositionInIdleSpellCheckForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCheckForCanonicalPositionInIdleSpellCheck;
using ScopedCheckVisibilityExtraPropertiesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCheckVisibilityExtraProperties;
using ScopedClientHintUAHighEntropyValuesPermissionPolicyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedClientHintUAHighEntropyValuesPermissionPolicy;
using ScopedClipboardChangeEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedClipboardChangeEvent;
using ScopedClipboardEventTargetCanBeFocusedElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedClipboardEventTargetCanBeFocusedElement;
using ScopedClipboardItemWithDOMStringSupportForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedClipboardItemWithDOMStringSupport;
using ScopedClipElementVisibleBoundsInLocalRootForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedClipElementVisibleBoundsInLocalRoot;
using ScopedClipPathNestedRasterOptimizationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedClipPathNestedRasterOptimization;
using ScopedCoalesceSelectionchangeEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCoalesceSelectionchangeEvent;
using ScopedCoepReflectionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCoepReflection;
using ScopedCollapseZeroWidthSpaceWhenReuseItemForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCollapseZeroWidthSpaceWhenReuseItem;
using ScopedColorSpaceRec2100LinearForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedColorSpaceRec2100Linear;
using ScopedCommandEventNotComposedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCommandEventNotComposed;
using ScopedComposedPathEmptyAfterDispatchForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedComposedPathEmptyAfterDispatch;
using ScopedCompositeBGColorAnimationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCompositeBGColorAnimation;
using ScopedCompositeBoxShadowAnimationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCompositeBoxShadowAnimation;
using ScopedCompositeClipPathAnimationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCompositeClipPathAnimation;
using ScopedCompositedAnimationsCancelledAsynchronouslyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCompositedAnimationsCancelledAsynchronously;
using ScopedCompositedSelectionUpdateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCompositedSelectionUpdate;
using ScopedCompositingDecisionAtAnimationPhaseBoundariesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCompositingDecisionAtAnimationPhaseBoundaries;
using ScopedCompositionForegroundMarkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCompositionForegroundMarkers;
using ScopedCompressionDictionaryTransportForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCompressionDictionaryTransport;
using ScopedComputedAccessibilityInfoForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedComputedAccessibilityInfo;
using ScopedComputePressureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedComputePressure;
using ScopedComputePressureOwnContributionEstimateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedComputePressureOwnContributionEstimate;
using ScopedConsiderSubOrSuperScriptAncestorAlignForCaretSelectionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedConsiderSubOrSuperScriptAncestorAlignForCaretSelection;
using ScopedContactsManagerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedContactsManager;
using ScopedContactsManagerExtraPropertiesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedContactsManagerExtraProperties;
using ScopedContainerTimingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedContainerTiming;
using ScopedContainerTypeNoLayoutContainmentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedContainerTypeNoLayoutContainment;
using ScopedContentIndexForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedContentIndex;
using ScopedContextMenuForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedContextMenu;
using ScopedControlledFrameForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedControlledFrame;
using ScopedCookieDeprecationFacilitatedTestingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCookieDeprecationFacilitatedTesting;
using ScopedCoopRestrictPropertiesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCoopRestrictProperties;
using ScopedCorrectTemplateFormParsingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCorrectTemplateFormParsing;
using ScopedCorsRFC1918ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCorsRFC1918;
using ScopedCrashReportingStorageAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCrashReportingStorageAPI;
using ScopedCreateInlineContentsExcludeOutOfFlowForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCreateInlineContentsExcludeOutOfFlow;
using ScopedCSPHashesV1ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSPHashesV1;
using ScopedCSPReportHashForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSPReportHash;
using ScopedCSSAccentColorKeywordForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSAccentColorKeyword;
using ScopedCSSAltCounterForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSAltCounter;
using ScopedCSSAnchorScopeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSAnchorScope;
using ScopedCSSAnchorSimplifiedFragmentationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSAnchorSimplifiedFragmentation;
using ScopedCSSAnchorUpdateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSAnchorUpdate;
using ScopedCSSAnchorWithTransformsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSAnchorWithTransforms;
using ScopedCSSAtRuleCounterStyleImageSymbolsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSAtRuleCounterStyleImageSymbols;
using ScopedCSSAtRuleCounterStyleSpeakAsDescriptorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSAtRuleCounterStyleSpeakAsDescriptor;
using ScopedCSSBorderShapeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSBorderShape;
using ScopedCSSCalcSimplificationAndSerializationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSCalcSimplificationAndSerialization;
using ScopedCSSCaretAnimationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSCaretAnimation;
using ScopedCSSCaretShapeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSCaretShape;
using ScopedCSSCaseSensitiveSelectorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSCaseSensitiveSelector;
using ScopedCSSChUnitSpecCompliantFallbackForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSChUnitSpecCompliantFallback;
using ScopedCSSColorContrastForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSColorContrast;
using ScopedCSSColorTypedOMForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSColorTypedOM;
using ScopedCSSContainerNameNotTreeScopedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSContainerNameNotTreeScoped;
using ScopedCSSContainerProgressNotationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSContainerProgressNotation;
using ScopedCSSContainerStyleQueriesRangeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSContainerStyleQueriesRange;
using ScopedCSSCornerShapeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSCornerShape;
using ScopedCSSCornersShorthandForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSCornersShorthand;
using ScopedCSSCrossFadeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSCrossFade;
using ScopedCSSCustomMediaForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSCustomMedia;
using ScopedCSSDynamicRangeLimitForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSDynamicRangeLimit;
using ScopedCSSEnumeratedCustomPropertiesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSEnumeratedCustomProperties;
using ScopedCSSExponentialFunctionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSExponentialFunctions;
using ScopedCSSFallbackContainerQueriesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSFallbackContainerQueries;
using ScopedCSSFilterBrightnessNonNegativePercentageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSFilterBrightnessNonNegativePercentage;
using ScopedCssFitWidthTextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCssFitWidthText;
using ScopedCSSFontSizeAdjustForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSFontSizeAdjust;
using ScopedCSSFunctionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSFunctions;
using ScopedCSSGapDecorationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSGapDecoration;
using ScopedCSSGridGapSuppressionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSGridGapSuppression;
using ScopedCSSHexAlphaColorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSHexAlphaColor;
using ScopedCSSIdentFunctionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSIdentFunction;
using ScopedCSSInertForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSInert;
using ScopedCSSInlineIfForMediaQueriesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSInlineIfForMediaQueries;
using ScopedCSSInlineIfForStyleQueriesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSInlineIfForStyleQueries;
using ScopedCSSInlineIfForSupportsQueriesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSInlineIfForSupportsQueries;
using ScopedCSSKeyframesRuleLengthForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSKeyframesRuleLength;
using ScopedCSSLayoutAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSLayoutAPI;
using ScopedCSSLetterAndWordSpacingPercentageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSLetterAndWordSpacingPercentage;
using ScopedCSSLineClampForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSLineClamp;
using ScopedCSSLineClampLineBreakingEllipsisForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSLineClampLineBreakingEllipsis;
using ScopedCSSLogicalCombinationPseudoForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSLogicalCombinationPseudo;
using ScopedCSSMarkerNestedPseudoElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSMarkerNestedPseudoElement;
using ScopedCSSMasonryLayoutForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSMasonryLayout;
using ScopedCSSMediaProgressNotationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSMediaProgressNotation;
using ScopedCSSMixinsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSMixins;
using ScopedCSSNegatedFeaturelessForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSNegatedFeatureless;
using ScopedCSSNestedPseudoElementsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSNestedPseudoElements;
using ScopedCSSOverscrollGesturesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSOverscrollGestures;
using ScopedCSSPaintAPIArgumentsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSPaintAPIArguments;
using ScopedCSSParserIgnoreCharsetForURLsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSParserIgnoreCharsetForURLs;
using ScopedCSSPositionStickyStaticScrollPositionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSPositionStickyStaticScrollPosition;
using ScopedCSSPreferredTextScaleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSPreferredTextScale;
using ScopedCSSProgressNotationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSProgressNotation;
using ScopedCSSPseudoColumnForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSPseudoColumn;
using ScopedCSSPseudoElementInterfaceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSPseudoElementInterface;
using ScopedCSSPseudoHasSlottedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSPseudoHasSlotted;
using ScopedCSSPseudoPlayingPausedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSPseudoPlayingPaused;
using ScopedCSSPseudoScrollButtonsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSPseudoScrollButtons;
using ScopedCSSPseudoScrollMarkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSPseudoScrollMarkers;
using ScopedCSSResizeAutoForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSResizeAuto;
using ScopedCSSRevertRuleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSRevertRule;
using ScopedCSSRubyOverhangForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSRubyOverhang;
using ScopedCSSSafePrintableInsetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSSafePrintableInset;
using ScopedCSSScopeImportForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScopeImport;
using ScopedCSSScrollDirectionContainerQueriesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollDirectionContainerQueries;
using ScopedCSSScrollInitialTargetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollInitialTarget;
using ScopedCSSScrollMarkerGroupModesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollMarkerGroupModes;
using ScopedCSSScrollMarkerTargetBeforeAfterForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollMarkerTargetBeforeAfter;
using ScopedCSSScrollSnapChangeEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollSnapChangeEvent;
using ScopedCSSScrollSnapChangingEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollSnapChangingEvent;
using ScopedCSSScrollSnapEventConstructorExposedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollSnapEventConstructorExposed;
using ScopedCSSScrollSnapEventsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollSnapEvents;
using ScopedCSSScrollStartForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollStart;
using ScopedCSSScrollTargetGroupForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollTargetGroup;
using ScopedCSSScrollTargetGroupAriaCurrentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSScrollTargetGroupAriaCurrent;
using ScopedCSSSelectorFragmentAnchorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSSelectorFragmentAnchor;
using ScopedCSSSiblingFunctionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSSiblingFunctions;
using ScopedCSSSiblingFunctionsInContainerQueriesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSSiblingFunctionsInContainerQueries;
using ScopedCSSSignRelatedFunctionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSSignRelatedFunctions;
using ScopedCSSSupportsAtRuleFunctionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSSupportsAtRuleFunction;
using ScopedCSSSupportsForImportRulesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSSupportsForImportRules;
using ScopedCSSSystemAccentColorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSSystemAccentColor;
using ScopedCSSTextAlignMatchParentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSTextAlignMatchParent;
using ScopedCSSTextAutoSpaceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSTextAutoSpace;
using ScopedCssTextDecorationLineBlinkSerializationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCssTextDecorationLineBlinkSerialization;
using ScopedCSSTextSpacingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSTextSpacing;
using ScopedCSSTransitionNoneRunningTransitionsFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSTransitionNoneRunningTransitionsFix;
using ScopedCSSTreeScopedTimelinesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSTreeScopedTimelines;
using ScopedCSSTypedArithmeticForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSTypedArithmetic;
using ScopedCSSUserSelectContainForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSUserSelectContain;
using ScopedCSSVideoDynamicRangeMediaQueriesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSVideoDynamicRangeMediaQueries;
using ScopedCSSViewTransitionAutoNameForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCSSViewTransitionAutoName;
using ScopedCustomizableSelectInPageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCustomizableSelectInPage;
using ScopedCustomizableSelectMultiplePopupForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCustomizableSelectMultiplePopup;
using ScopedCustomScrollbarApplyMinimumThumbLengthForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCustomScrollbarApplyMinimumThumbLength;
using ScopedCustomValidityNormalizeNewlinesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedCustomValidityNormalizeNewlines;
using ScopedDatabaseForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDatabase;
using ScopedDecoupleComputedBorderWidthFromStyleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDecoupleComputedBorderWidthFromStyle;
using ScopedDecoupleResolvedColumnRuleWidthFromStyleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDecoupleResolvedColumnRuleWidthFromStyle;
using ScopedDelegatesFocusTextControlInputFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDelegatesFocusTextControlInputFix;
using ScopedDeprecateCursorMovementIteratorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDeprecateCursorMovementIterator;
using ScopedDeprecateUnloadOptOutForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDeprecateUnloadOptOut;
using ScopedDesktopCaptureDisableLocalEchoControlForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDesktopCaptureDisableLocalEchoControl;
using ScopedDesktopPWAsAdditionalWindowingControlsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDesktopPWAsAdditionalWindowingControls;
using ScopedDesktopPWAsSubAppsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDesktopPWAsSubApps;
using ScopedDeviceAttributesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDeviceAttributes;
using ScopedDeviceAttributesPermissionPolicyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDeviceAttributesPermissionPolicy;
using ScopedDeviceBoundSessionCredentialsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDeviceBoundSessionCredentials;
using ScopedDeviceBoundSessionCredentials2ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDeviceBoundSessionCredentials2;
using ScopedDeviceOrientationRequestPermissionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDeviceOrientationRequestPermission;
using ScopedDevicePostureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDevicePosture;
using ScopedDialogCloseWhenOpenRemovedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDialogCloseWhenOpenRemoved;
using ScopedDialogNewFocusBehaviorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDialogNewFocusBehavior;
using ScopedDialogSubmitShadowBoundariesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDialogSubmitShadowBoundaries;
using ScopedDigitalGoodsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDigitalGoods;
using ScopedDigitalGoodsV2_1ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDigitalGoodsV2_1;
using ScopedDirectSocketsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDirectSockets;
using ScopedDirectSocketsInServiceWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDirectSocketsInServiceWorkers;
using ScopedDirectSocketsInSharedWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDirectSocketsInSharedWorkers;
using ScopedDisableDifferentOriginSubframeDialogSuppressionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDisableDifferentOriginSubframeDialogSuppression;
using ScopedDisableReduceAcceptLanguageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDisableReduceAcceptLanguage;
using ScopedDispatchHiddenVisibilityTransitionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDispatchHiddenVisibilityTransitions;
using ScopedDispatchSelectionchangeEventPerElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDispatchSelectionchangeEventPerElement;
using ScopedDisplayContentsFocusableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDisplayContentsFocusable;
using ScopedDisplayCutoutAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDisplayCutoutAPI;
using ScopedDocumentActiveViewTransitionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentActiveViewTransition;
using ScopedDocumentCookieForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentCookie;
using ScopedDocumentDomainForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentDomain;
using ScopedDocumentIsolationPolicyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentIsolationPolicy;
using ScopedDocumentOpenOriginAliasRemovalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentOpenOriginAliasRemoval;
using ScopedDocumentOpenSandboxInheritanceRemovalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentOpenSandboxInheritanceRemoval;
using ScopedDocumentPatchingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPatching;
using ScopedDocumentPictureInPictureAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPictureInPictureAPI;
using ScopedDocumentPictureInPicturePreferInitialPlacementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPictureInPicturePreferInitialPlacement;
using ScopedDocumentPictureInPictureUserActivationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPictureInPictureUserActivation;
using ScopedDocumentPolicyDocumentDomainForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPolicyDocumentDomain;
using ScopedDocumentPolicyExpectNoLinkedResourcesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPolicyExpectNoLinkedResources;
using ScopedDocumentPolicyIncludeJSCallStacksInCrashReportsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPolicyIncludeJSCallStacksInCrashReports;
using ScopedDocumentPolicyNegotiationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPolicyNegotiation;
using ScopedDocumentPolicyNetworkEfficiencyGuardrailsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPolicyNetworkEfficiencyGuardrails;
using ScopedDocumentPolicySyncXHRForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentPolicySyncXHR;
using ScopedDocumentWriteForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDocumentWrite;
using ScopedDOMPartsAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDOMPartsAPI;
using ScopedDOMPartsAPIMinimalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDOMPartsAPIMinimal;
using ScopedDynamicSafeAreaInsetsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedDynamicSafeAreaInsets;
using ScopedEditEmojiUnicode11ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedEditEmojiUnicode11;
using ScopedElementCaptureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedElementCapture;
using ScopedElementInnerTextHandleFirstLineStyleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedElementInnerTextHandleFirstLineStyle;
using ScopedElementInternalsDotTypeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedElementInternalsDotType;
using ScopedEnforceAnonymityExposureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedEnforceAnonymityExposure;
using ScopedEnterInOpenShadowRootsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedEnterInOpenShadowRoots;
using ScopedEventTimingInteractionCountForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedEventTimingInteractionCount;
using ScopedExperimentalContentSecurityPolicyFeaturesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedExperimentalContentSecurityPolicyFeatures;
using ScopedExperimentalJSProfilerMarkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedExperimentalJSProfilerMarkers;
using ScopedExperimentalMachineLearningNeuralNetworkForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedExperimentalMachineLearningNeuralNetwork;
using ScopedExperimentalPoliciesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedExperimentalPolicies;
using ScopedExposeCSSFontFeatureValuesRuleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedExposeCSSFontFeatureValuesRule;
using ScopedExposeRenderTimeNonTaoDelayedImageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedExposeRenderTimeNonTaoDelayedImage;
using ScopedExtendedTextMetricsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedExtendedTextMetrics;
using ScopedExternalPopupMenuClickEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedExternalPopupMenuClickEvent;
using ScopedEyeDropperAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedEyeDropperAPI;
using ScopedFaceDetectorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFaceDetector;
using ScopedFastPositionIteratorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFastPositionIterator;
using ScopedFedCmForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFedCm;
using ScopedFedCmAutofillForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFedCmAutofill;
using ScopedFedCmDelegationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFedCmDelegation;
using ScopedFedCmErrorAttributeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFedCmErrorAttribute;
using ScopedFedCmIdPRegistrationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFedCmIdPRegistration;
using ScopedFedCmLightweightModeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFedCmLightweightMode;
using ScopedFedCmMultipleIdentityProvidersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFedCmMultipleIdentityProviders;
using ScopedFencedFramesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFencedFrames;
using ScopedFencedFramesAPIChangesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFencedFramesAPIChanges;
using ScopedFencedFramesDefaultModeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFencedFramesDefaultMode;
using ScopedFencedFramesLocalUnpartitionedDataAccessForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFencedFramesLocalUnpartitionedDataAccess;
using ScopedFetchBodyBytesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFetchBodyBytes;
using ScopedFetchLaterAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFetchLaterAPI;
using ScopedFetchRetryForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFetchRetry;
using ScopedFetchUploadStreamingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFetchUploadStreaming;
using ScopedFileHandlingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileHandling;
using ScopedFileHandlingIconsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileHandlingIcons;
using ScopedFileSystemForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystem;
using ScopedFileSystemAccessForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemAccess;
using ScopedFileSystemAccessAPIExperimentalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemAccessAPIExperimental;
using ScopedFileSystemAccessGetCloudIdentifiersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemAccessGetCloudIdentifiers;
using ScopedFileSystemAccessLocalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemAccessLocal;
using ScopedFileSystemAccessLockingSchemeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemAccessLockingScheme;
using ScopedFileSystemAccessOriginPrivateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemAccessOriginPrivate;
using ScopedFileSystemAccessRevokeReadOnRemoveForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemAccessRevokeReadOnRemove;
using ScopedFileSystemAccessWriteModeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemAccessWriteMode;
using ScopedFileSystemObserverForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemObserver;
using ScopedFileSystemObserverUnobserveForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFileSystemObserverUnobserve;
using ScopedFindFirstMisspellingEndWhenNonEditableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFindFirstMisspellingEndWhenNonEditable;
using ScopedFirstLineOnListItemForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFirstLineOnListItem;
using ScopedFirstLineTextMetricsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFirstLineTextMetrics;
using ScopedFixNextPositionCalculationInInsertListForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFixNextPositionCalculationInInsertList;
using ScopedFledgeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledge;
using ScopedFledgeAuctionDealSupportForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeAuctionDealSupport;
using ScopedFledgeBiddingAndAuctionServerAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeBiddingAndAuctionServerAPI;
using ScopedFledgeBiddingAndAuctionServerAPIMultiSellerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeBiddingAndAuctionServerAPIMultiSeller;
using ScopedFledgeClickinessForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeClickiness;
using ScopedFledgeCustomMaxAuctionAdComponentsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeCustomMaxAuctionAdComponents;
using ScopedFledgeDeprecatedRenderURLReplacementsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeDeprecatedRenderURLReplacements;
using ScopedFledgeDirectFromSellerSignalsHeaderAdSlotForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeDirectFromSellerSignalsHeaderAdSlot;
using ScopedFledgeDirectFromSellerSignalsWebBundlesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeDirectFromSellerSignalsWebBundles;
using ScopedFledgeMultiBidForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeMultiBid;
using ScopedFledgePrivateModelTrainingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgePrivateModelTraining;
using ScopedFledgeRealTimeReportingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeRealTimeReporting;
using ScopedFledgeSellerNonceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeSellerNonce;
using ScopedFledgeSellerScriptExecutionModeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeSellerScriptExecutionMode;
using ScopedFledgeTrustedSignalsKVv1CreativeScanningForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeTrustedSignalsKVv1CreativeScanning;
using ScopedFledgeTrustedSignalsKVv2ContextualDataForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeTrustedSignalsKVv2ContextualData;
using ScopedFledgeTrustedSignalsKVv2SupportForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFledgeTrustedSignalsKVv2Support;
using ScopedFlexWrapBalanceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFlexWrapBalance;
using ScopedFluentOverlayScrollbarsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFluentOverlayScrollbars;
using ScopedFluentScrollbarsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFluentScrollbars;
using ScopedFocusgroupForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFocusgroup;
using ScopedFocusgroupGridForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFocusgroupGrid;
using ScopedFontAccessForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontAccess;
using ScopedFontFallbackForTabSizeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontFallbackForTabSize;
using ScopedFontFamilyPostscriptMatchingCTMigrationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontFamilyPostscriptMatchingCTMigration;
using ScopedFontFamilyStyleMatchingCTMigrationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontFamilyStyleMatchingCTMigration;
using ScopedFontFeatureSettingsDescriptorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontFeatureSettingsDescriptor;
using ScopedFontLanguageOverrideForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontLanguageOverride;
using ScopedFontMatchAliasesAsLastResortForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontMatchAliasesAsLastResort;
using ScopedFontPresentWinForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontPresentWin;
using ScopedFontSrcLocalMatchingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontSrcLocalMatching;
using ScopedFontStyleObliqueZeroDegreeAsNormalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontStyleObliqueZeroDegreeAsNormal;
using ScopedFontSystemFallbackNotoCjkForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontSystemFallbackNotoCjk;
using ScopedFontVariationSettingsDescriptorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFontVariationSettingsDescriptor;
using ScopedForcedColorsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedForcedColors;
using ScopedForceEagerMeasureMemoryForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedForceEagerMeasureMemory;
using ScopedForceReduceMotionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedForceReduceMotion;
using ScopedFormControlRangeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFormControlRange;
using ScopedFormControlRestoreStateIfAutocompleteOffForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFormControlRestoreStateIfAutocompleteOff;
using ScopedFractionalScrollOffsetsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFractionalScrollOffsets;
using ScopedFreezeFramesOnVisibilityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedFreezeFramesOnVisibility;
using ScopedGamepadMultitouchForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGamepadMultitouch;
using ScopedGeolocationElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGeolocationElement;
using ScopedGetAllScreensMediaForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGetAllScreensMedia;
using ScopedGetComputedStyleOutsideFlatTreeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGetComputedStyleOutsideFlatTree;
using ScopedGetDisplayMediaForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGetDisplayMedia;
using ScopedGetDisplayMediaRequiresUserActivationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGetDisplayMediaRequiresUserActivation;
using ScopedGetDisplayMediaWindowAudioCaptureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGetDisplayMediaWindowAudioCapture;
using ScopedGetElementsByNameOnlyHTMLElementsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGetElementsByNameOnlyHTMLElements;
using ScopedGetUserMediaEchoCancellationModesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGetUserMediaEchoCancellationModes;
using ScopedGroupEffectForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedGroupEffect;
using ScopedHandleDeletionAtStartAndEndBoundaryContainingHiddenElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHandleDeletionAtStartAndEndBoundaryContainingHiddenElement;
using ScopedHandleDisconnectedSelectionDuringDOMChangesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHandleDisconnectedSelectionDuringDOMChanges;
using ScopedHandleShadowDOMInSubstringUtilForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHandleShadowDOMInSubstringUtil;
using ScopedHandwritingRecognitionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHandwritingRecognition;
using ScopedHasUAVisualTransitionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHasUAVisualTransition;
using ScopedHeadingOffsetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHeadingOffset;
using ScopedHighlightByLayoutObjectForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHighlightByLayoutObject;
using ScopedHighlightPointerEventsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHighlightPointerEvents;
using ScopedHighlightsFromPointForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHighlightsFromPoint;
using ScopedHitTestBorderRadiusForStackingContextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHitTestBorderRadiusForStackingContext;
using ScopedHrefTranslateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHrefTranslate;
using ScopedHrElementGrayForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHrElementGray;
using ScopedHTMLAnchorAttributeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLAnchorAttribute;
using ScopedHTMLCommandActionsV2ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLCommandActionsV2;
using ScopedHTMLCommandActionToggleInterestForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLCommandActionToggleInterest;
using ScopedHTMLCommandRequestCloseForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLCommandRequestClose;
using ScopedHTMLElementScrollParentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLElementScrollParent;
using ScopedHTMLImageElementActualNaturalSizeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLImageElementActualNaturalSize;
using ScopedHTMLInterestForAttributeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLInterestForAttribute;
using ScopedHTMLInterestForInterestHintPseudoForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLInterestForInterestHintPseudo;
using ScopedHTMLLinkElementAttributeValueChangesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLLinkElementAttributeValueChanges;
using ScopedHTMLParserYieldAndDelayOftenForTestingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLParserYieldAndDelayOftenForTesting;
using ScopedHTMLParserYieldByUserTimingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLParserYieldByUserTiming;
using ScopedHTMLPrintingArtifactAnnotationsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedHTMLPrintingArtifactAnnotations;
using ScopedICUCapitalizationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedICUCapitalization;
using ScopedIgnoreLetterSpacingInCursiveScriptsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedIgnoreLetterSpacingInCursiveScripts;
using ScopedImageDataPixelFormatForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedImageDataPixelFormat;
using ScopedImplicitRootScrollerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedImplicitRootScroller;
using ScopedImprovedSourceRetargetingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedImprovedSourceRetargeting;
using ScopedIncomingCallNotificationsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedIncomingCallNotifications;
using ScopedIndexedDbGetAllRecordsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedIndexedDbGetAllRecords;
using ScopedInertElementNonEditableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInertElementNonEditable;
using ScopedInfiniteCullRectForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInfiniteCullRect;
using ScopedInheritUserModifyWithoutContenteditableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInheritUserModifyWithoutContenteditable;
using ScopedInnerHTMLParserFastpathLogFailureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInnerHTMLParserFastpathLogFailure;
using ScopedInputEventDataTransferForInsertCmdForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInputEventDataTransferForInsertCmd;
using ScopedInputInSelectForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInputInSelect;
using ScopedInputMultipleFieldsUIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInputMultipleFieldsUI;
using ScopedInsertBlockquoteBeforeOuterBlockForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInsertBlockquoteBeforeOuterBlock;
using ScopedInsertLineBreakIfInlineListItemForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInsertLineBreakIfInlineListItem;
using ScopedInsertLineBreakIfPhrasingContentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInsertLineBreakIfPhrasingContent;
using ScopedInspectorGhostRulesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInspectorGhostRules;
using ScopedInstalledAppForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInstalledApp;
using ScopedInstallOnDeviceSpeechRecognitionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInstallOnDeviceSpeechRecognition;
using ScopedIntegrityPolicyScriptForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedIntegrityPolicyScript;
using ScopedInteractivityInertImportantForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInteractivityInertImportant;
using ScopedInterestGroupsInSharedStorageWorkletForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInterestGroupsInSharedStorageWorklet;
using ScopedIntersectionObserverScrollMarginForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedIntersectionObserverScrollMargin;
using ScopedInvertedColorsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInvertedColors;
using ScopedInvisibleSVGAnimationThrottlingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedInvisibleSVGAnimationThrottling;
using ScopedJavaScriptCompileHintsPerFunctionMagicRuntimeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedJavaScriptCompileHintsPerFunctionMagicRuntime;
using ScopedJavaScriptSourcePhaseImportsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedJavaScriptSourcePhaseImports;
using ScopedKeyboardAccessibleTooltipForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedKeyboardAccessibleTooltip;
using ScopedKeyboardFocusabilityAfterFindInPageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedKeyboardFocusabilityAfterFindInPage;
using ScopedLangAttributeAwareFormControlUIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLangAttributeAwareFormControlUI;
using ScopedLanguageDetectionAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLanguageDetectionAPI;
using ScopedLanguageDetectionAPIForWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLanguageDetectionAPIForWorkers;
using ScopedLayoutFlexNewRowAlgorithmForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLayoutFlexNewRowAlgorithm;
using ScopedLayoutIgnoreMarginsForStickyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLayoutIgnoreMarginsForSticky;
using ScopedLayoutNGShapeCacheForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLayoutNGShapeCache;
using ScopedLazyInitializeMediaControlsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLazyInitializeMediaControls;
using ScopedLeftClickToHandleSuggestionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLeftClickToHandleSuggestion;
using ScopedLimitThirdPartyCookiesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLimitThirdPartyCookies;
using ScopedLineBreakOofNoOrcForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLineBreakOofNoOrc;
using ScopedLinkBlurImprovementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLinkBlurImprovement;
using ScopedListOwnerMustHaveCSSBoxForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedListOwnerMustHaveCSSBox;
using ScopedListStylePositionQuirkStandardForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedListStylePositionQuirkStandard;
using ScopedLocalNetworkAccessNonSecureContextAllowedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLocalNetworkAccessNonSecureContextAllowed;
using ScopedLocalNetworkAccessPermissionPolicyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLocalNetworkAccessPermissionPolicy;
using ScopedLocalNetworkAccessWebRTCForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLocalNetworkAccessWebRTC;
using ScopedLockedModeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLockedMode;
using ScopedLongAnimationFrameSourceCharPositionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLongAnimationFrameSourceCharPosition;
using ScopedLongAnimationFrameSourceLineColumnForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLongAnimationFrameSourceLineColumn;
using ScopedLongAnimationFrameSourceLineColumnInterfaceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLongAnimationFrameSourceLineColumnInterface;
using ScopedLongPressLinkSelectTextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLongPressLinkSelectText;
using ScopedLongTaskFromLongAnimationFrameForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedLongTaskFromLongAnimationFrame;
using ScopedMacCharacterFallbackCacheForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMacCharacterFallbackCache;
using ScopedMacDisableCtrlHomeEndForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMacDisableCtrlHomeEnd;
using ScopedMachineLearningNeuralNetworkForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMachineLearningNeuralNetwork;
using ScopedMacSystemClipboardPermissionCheckForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMacSystemClipboardPermissionCheck;
using ScopedManagedConfigurationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedManagedConfiguration;
using ScopedMaskDeserializationTimeForCrossOriginMessagesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMaskDeserializationTimeForCrossOriginMessages;
using ScopedMathMLOperatorRTLMirroringForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMathMLOperatorRTLMirroring;
using ScopedMathMLSerializationOnCopyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMathMLSerializationOnCopy;
using ScopedMeasureMemoryForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMeasureMemory;
using ScopedMediaCapabilitiesEncodingInfoForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaCapabilitiesEncodingInfo;
using ScopedMediaCapabilitiesSpatialAudioForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaCapabilitiesSpatialAudio;
using ScopedMediaCaptureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaCapture;
using ScopedMediaCaptureBackgroundBlurForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaCaptureBackgroundBlur;
using ScopedMediaCaptureCameraControlsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaCaptureCameraControls;
using ScopedMediaCaptureConfigurationChangeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaCaptureConfigurationChange;
using ScopedMediaCaptureVoiceIsolationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaCaptureVoiceIsolation;
using ScopedMediaCastOverlayButtonForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaCastOverlayButton;
using ScopedMediaControlsExpandGestureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaControlsExpandGesture;
using ScopedMediaControlsOverlayPlayButtonForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaControlsOverlayPlayButton;
using ScopedMediaElementVolumeGreaterThanOneForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaElementVolumeGreaterThanOne;
using ScopedMediaEngagementBypassAutoplayPoliciesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaEngagementBypassAutoplayPolicies;
using ScopedMediaLatencyHintForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaLatencyHint;
using ScopedMediaPlaybackWhileNotVisiblePermissionPolicyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaPlaybackWhileNotVisiblePermissionPolicy;
using ScopedMediaQueryNavigationControlsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaQueryNavigationControls;
using ScopedMediaSessionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaSession;
using ScopedMediaSessionChapterInformationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaSessionChapterInformation;
using ScopedMediaSessionEnterPictureInPictureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaSessionEnterPictureInPicture;
using ScopedMediaSourceExperimentalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaSourceExperimental;
using ScopedMediaSourceExtensionsForWebCodecsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaSourceExtensionsForWebCodecs;
using ScopedMediaSourceNewAbortAndDurationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaSourceNewAbortAndDuration;
using ScopedMediaStreamTrackTransferForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaStreamTrackTransfer;
using ScopedMediaStreamTrackWebSpeechForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMediaStreamTrackWebSpeech;
using ScopedMenuElementsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMenuElements;
using ScopedMessagePortCloseEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMessagePortCloseEvent;
using ScopedMiddleClickAutoscrollForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMiddleClickAutoscroll;
using ScopedMixedContentAutoupgradesUseIsMixedContentRestrictedInFrameForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMixedContentAutoupgradesUseIsMixedContentRestrictedInFrame;
using ScopedMobileLayoutThemeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMobileLayoutTheme;
using ScopedModifyParagraphCrossEditingoundaryForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedModifyParagraphCrossEditingoundary;
using ScopedModulePreloadReferrerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedModulePreloadReferrer;
using ScopedMojoJSForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMojoJS;
using ScopedMojoJSTestForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMojoJSTest;
using ScopedMoveEndingSelectionToListChildForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMoveEndingSelectionToListChild;
using ScopedMoveToParagraphStartOrEndSkipsNonEditableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMoveToParagraphStartOrEndSkipsNonEditable;
using ScopedMulticastInDirectSocketsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMulticastInDirectSockets;
using ScopedMulticolColumnWrappingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedMulticolColumnWrapping;
using ScopedNavigateEventCanTransitionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNavigateEventCanTransition;
using ScopedNavigateEventCommitBehaviorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNavigateEventCommitBehavior;
using ScopedNavigateEventPopstateLimitationsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNavigateEventPopstateLimitations;
using ScopedNavigateEventSourceElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNavigateEventSourceElement;
using ScopedNavigationIdForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNavigationId;
using ScopedNavigationTransitionDestinationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNavigationTransitionDestination;
using ScopedNavigatorContentUtilsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNavigatorContentUtils;
using ScopedNestedRubyMinMaxFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNestedRubyMinMaxFix;
using ScopedNestedViewTransitionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNestedViewTransition;
using ScopedNetInfoConstantTypeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNetInfoConstantType;
using ScopedNetInfoDownlinkMaxForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNetInfoDownlinkMax;
using ScopedNoFontAntialiasingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNoFontAntialiasing;
using ScopedNoIdleEncodingForWebTestsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNoIdleEncodingForWebTests;
using ScopedNoIncreasingEndOffsetOnSplittingTextNodesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNoIncreasingEndOffsetOnSplittingTextNodes;
using ScopedNonEmptyBlockquotesOnOutdentingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNonEmptyBlockquotesOnOutdenting;
using ScopedNonStandardAppearanceValueSliderVerticalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNonStandardAppearanceValueSliderVertical;
using ScopedNotificationConstructorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNotificationConstructor;
using ScopedNotificationContentImageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNotificationContentImage;
using ScopedNotificationsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNotifications;
using ScopedNotificationTriggersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNotificationTriggers;
using ScopedNumberInputFullWidthCharsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedNumberInputFullWidthChars;
using ScopedOffMainThreadCSSPaintForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOffMainThreadCSSPaint;
using ScopedOffscreenCanvasGetContextAttributesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOffscreenCanvasGetContextAttributes;
using ScopedOffsetParentNewSpecBehaviorForFixedPositionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOffsetParentNewSpecBehaviorForFixedPosition;
using ScopedOmitBlurEventOnElementRemovalForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOmitBlurEventOnElementRemoval;
using ScopedOnDeviceWebSpeechAvailableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOnDeviceWebSpeechAvailable;
using ScopedOptionLabelAttributeWhitespaceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOptionLabelAttributeWhitespace;
using ScopedOrientationEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOrientationEvent;
using ScopedOriginAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginAPI;
using ScopedOriginatingElementIsImplicitAnchorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginatingElementIsImplicitAnchor;
using ScopedOriginIsolationHeaderForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginIsolationHeader;
using ScopedOriginPolicyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginPolicy;
using ScopedOriginTrialsSampleAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPI;
using ScopedOriginTrialsSampleAPIBrowserReadWriteForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIBrowserReadWrite;
using ScopedOriginTrialsSampleAPIDependentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIDependent;
using ScopedOriginTrialsSampleAPIDeprecationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIDeprecation;
using ScopedOriginTrialsSampleAPIExpiryGracePeriodForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIExpiryGracePeriod;
using ScopedOriginTrialsSampleAPIExpiryGracePeriodThirdPartyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIExpiryGracePeriodThirdParty;
using ScopedOriginTrialsSampleAPIImpliedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIImplied;
using ScopedOriginTrialsSampleAPIInvalidOSForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIInvalidOS;
using ScopedOriginTrialsSampleAPINavigationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPINavigation;
using ScopedOriginTrialsSampleAPIPersistentExpiryGracePeriodForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIPersistentExpiryGracePeriod;
using ScopedOriginTrialsSampleAPIPersistentFeatureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIPersistentFeature;
using ScopedOriginTrialsSampleAPIPersistentInvalidOSForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIPersistentInvalidOS;
using ScopedOriginTrialsSampleAPIPersistentThirdPartyDeprecationFeatureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIPersistentThirdPartyDeprecationFeature;
using ScopedOriginTrialsSampleAPIThirdPartyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOriginTrialsSampleAPIThirdParty;
using ScopedOverscrollCustomizationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedOverscrollCustomization;
using ScopedPagePopupForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPagePopup;
using ScopedPagePopupCopyPasteForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPagePopupCopyPaste;
using ScopedPageRevealEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPageRevealEvent;
using ScopedPageSwapEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPageSwapEvent;
using ScopedPaintHoldingForIframesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPaintHoldingForIframes;
using ScopedPaintOffsetTranslationForBackdropFilterWithInlineElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPaintOffsetTranslationForBackdropFilterWithInlineElement;
using ScopedPaintOffsetTranslationForCompositedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPaintOffsetTranslationForComposited;
using ScopedPaintTimingMixinForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPaintTimingMixin;
using ScopedPaintUnderInvalidationCheckingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPaintUnderInvalidationChecking;
using ScopedParakeetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedParakeet;
using ScopedPartialCompletionNotAllowedInMoveParagraphsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPartialCompletionNotAllowedInMoveParagraphs;
using ScopedPartitionedPopinsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPartitionedPopins;
using ScopedPartitionVisitedLinkDatabaseWithSelfLinksForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPartitionVisitedLinkDatabaseWithSelfLinks;
using ScopedPasswordRevealForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPasswordReveal;
using ScopedPaymentAppForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPaymentApp;
using ScopedPaymentLinkDetectionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPaymentLinkDetection;
using ScopedPaymentMethodChangeEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPaymentMethodChangeEvent;
using ScopedPaymentRequestForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPaymentRequest;
using ScopedPerformanceManagerInstrumentationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPerformanceManagerInstrumentation;
using ScopedPerformanceMarkFeatureUsageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPerformanceMarkFeatureUsage;
using ScopedPerformanceNavigateSystemEntropyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPerformanceNavigateSystemEntropy;
using ScopedPerformanceNavigationTimingConfidenceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPerformanceNavigationTimingConfidence;
using ScopedPeriodicBackgroundSyncForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPeriodicBackgroundSync;
using ScopedPerMethodCanMakePaymentQuotaForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPerMethodCanMakePaymentQuota;
using ScopedPermissionElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPermissionElement;
using ScopedPermissionElementIconForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPermissionElementIcon;
using ScopedPermissionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPermissions;
using ScopedPermissionsRequestRevokeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPermissionsRequestRevoke;
using ScopedPlaceholderVisibilityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPlaceholderVisibility;
using ScopedPNaClForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPNaCl;
using ScopedPointerEventDeviceIdForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPointerEventDeviceId;
using ScopedPointerLockOnAndroidForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPointerLockOnAndroid;
using ScopedPointerRawUpdateOnlyInSecureContextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPointerRawUpdateOnlyInSecureContext;
using ScopedPositionOutsideTabSpanCheckSiblingNodeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPositionOutsideTabSpanCheckSiblingNode;
using ScopedPositionVisibilityIgnoreNonClipAncestorsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPositionVisibilityIgnoreNonClipAncestors;
using ScopedPotentialPermissionsPolicyReportingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPotentialPermissionsPolicyReporting;
using ScopedPreciseMemoryInfoForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPreciseMemoryInfo;
using ScopedPreferDefaultScrollbarStylesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPreferDefaultScrollbarStyles;
using ScopedPreferNonCompositedScrollingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPreferNonCompositedScrolling;
using ScopedPreferredAudioOutputDevicesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPreferredAudioOutputDevices;
using ScopedPrefersReducedDataForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPrefersReducedData;
using ScopedPreloadLinkRelDataUrlsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPreloadLinkRelDataUrls;
using ScopedPrerender2ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPrerender2;
using ScopedPrerenderUntilScriptForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPrerenderUntilScript;
using ScopedPresentationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPresentation;
using ScopedPreserveDropEffectForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPreserveDropEffect;
using ScopedPreventUndoIfNotEditableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPreventUndoIfNotEditable;
using ScopedPrivateAggregationApiErrorReportingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPrivateAggregationApiErrorReporting;
using ScopedPrivateAggregationApiMaxContributionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPrivateAggregationApiMaxContributions;
using ScopedPrivateNetworkAccessNullIpAddressForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPrivateNetworkAccessNullIpAddress;
using ScopedPrivateStateTokensForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPrivateStateTokens;
using ScopedPrivateStateTokensAlwaysAllowIssuanceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPrivateStateTokensAlwaysAllowIssuance;
using ScopedProgrammaticScrollPromiseForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedProgrammaticScrollPromise;
using ScopedPropagateOverscrollBehaviorFromRootForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPropagateOverscrollBehaviorFromRoot;
using ScopedProtectedOriginTrialsSampleAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedProtectedOriginTrialsSampleAPI;
using ScopedProtectedOriginTrialsSampleAPIDependentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedProtectedOriginTrialsSampleAPIDependent;
using ScopedProtectedOriginTrialsSampleAPIImpliedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedProtectedOriginTrialsSampleAPIImplied;
using ScopedPseudoElementsFocusableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPseudoElementsFocusable;
using ScopedPushMessageDataBytesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPushMessageDataBytes;
using ScopedPushMessagingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPushMessaging;
using ScopedPushMessagingSubscriptionChangeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedPushMessagingSubscriptionChange;
using ScopedQuotaExceededErrorUpdateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedQuotaExceededErrorUpdate;
using ScopedQuoteFirstLineStyleForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedQuoteFirstLineStyle;
using ScopedRadioInputNextKeyboardFocusableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRadioInputNextKeyboardFocusable;
using ScopedRadioKeyboardFocusableOptimizeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRadioKeyboardFocusableOptimize;
using ScopedRasterInducingScrollForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRasterInducingScroll;
using ScopedReadableStreamBYOBReaderReadMinOptionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReadableStreamBYOBReaderReadMinOption;
using ScopedRecordSameDocumentPresentationTimeOnceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRecordSameDocumentPresentationTimeOnce;
using ScopedReduceAcceptLanguageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReduceAcceptLanguage;
using ScopedReduceDeviceMemoryForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReduceDeviceMemory;
using ScopedReduceHardwareConcurrencyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReduceHardwareConcurrency;
using ScopedReduceScreenSizeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReduceScreenSize;
using ScopedReduceUserAgentAndroidVersionDeviceModelForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReduceUserAgentAndroidVersionDeviceModel;
using ScopedReduceUserAgentDataLinuxPlatformVersionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReduceUserAgentDataLinuxPlatformVersion;
using ScopedReduceUserAgentMinorVersionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReduceUserAgentMinorVersion;
using ScopedReduceUserAgentPlatformOsCpuForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReduceUserAgentPlatformOsCpu;
using ScopedRegionCaptureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRegionCapture;
using ScopedRelatedWebsitePartitionAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRelatedWebsitePartitionAPI;
using ScopedRelaxDOMValidNamesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRelaxDOMValidNames;
using ScopedRelOpenerBcgDependencyHintForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRelOpenerBcgDependencyHint;
using ScopedRemotePlaybackForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRemotePlayback;
using ScopedRemotePlaybackBackendForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRemotePlaybackBackend;
using ScopedRemoveCharsetAutoDetectionForISO2022JPForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRemoveCharsetAutoDetectionForISO2022JP;
using ScopedRemoveCollapsedPlaceholderForContentEditableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRemoveCollapsedPlaceholderForContentEditable;
using ScopedRemoveDanglingMarkupInTargetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRemoveDanglingMarkupInTarget;
using ScopedRemoveDataUrlInSvgUseForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRemoveDataUrlInSvgUse;
using ScopedRemoveFormatFilterBackgroundColorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRemoveFormatFilterBackgroundColor;
using ScopedRemoveSelectionCanonicalizationInMoveParagraphForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRemoveSelectionCanonicalizationInMoveParagraph;
using ScopedRemoveVisibleSelectionInDOMSelectionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRemoveVisibleSelectionInDOMSelection;
using ScopedRenderBlockingFullFrameRateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRenderBlockingFullFrameRate;
using ScopedRenderBlockingStatusForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRenderBlockingStatus;
using ScopedRenderPriorityAttributeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRenderPriorityAttribute;
using ScopedReportFirstFrameTimeAsRenderTimeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedReportFirstFrameTimeAsRenderTime;
using ScopedRequestMainFrameAfterFirstVideoFrameForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRequestMainFrameAfterFirstVideoFrame;
using ScopedResolveVarStylesOnCopyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedResolveVarStylesOnCopy;
using ScopedResourceTimingContentEncodingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedResourceTimingContentEncoding;
using ScopedResourceTimingContentTypeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedResourceTimingContentType;
using ScopedResourceTimingInitiatorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedResourceTimingInitiator;
using ScopedResourceTimingUseCORSForBodySizesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedResourceTimingUseCORSForBodySizes;
using ScopedResponsiveIframesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedResponsiveIframes;
using ScopedRestrictGamepadAccessForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRestrictGamepadAccess;
using ScopedRestrictOwnAudioForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRestrictOwnAudio;
using ScopedRestrictTabFocusForHiddenSVGElementsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRestrictTabFocusForHiddenSVGElements;
using ScopedRootScrollbarFollowsBrowserThemeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRootScrollbarFollowsBrowserTheme;
using ScopedRouteMatchingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRouteMatching;
using ScopedRtcAudioJitterBufferMaxPacketsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRtcAudioJitterBufferMaxPackets;
using ScopedRTCDataChannelPriorityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCDataChannelPriority;
using ScopedRTCEncodedFrameAudioLevelForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCEncodedFrameAudioLevel;
using ScopedRTCEncodedFrameSetMetadataForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCEncodedFrameSetMetadata;
using ScopedRTCEncodedFrameTimestampsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCEncodedFrameTimestamps;
using ScopedRTCEncodedVideoFrameAdditionalMetadataForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCEncodedVideoFrameAdditionalMetadata;
using ScopedRTCJitterBufferTargetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCJitterBufferTarget;
using ScopedRTCLegacyCallbackBasedGetStatsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCLegacyCallbackBasedGetStats;
using ScopedRTCRtpEncodingParametersCodecForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCRtpEncodingParametersCodec;
using ScopedRTCRtpScaleResolutionDownToForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCRtpScaleResolutionDownTo;
using ScopedRTCRtpScriptTransformForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCRtpScriptTransform;
using ScopedRTCRtpTransportForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCRtpTransport;
using ScopedRTCStatsRelativePacketArrivalDelayForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCStatsRelativePacketArrivalDelay;
using ScopedRTCSvcScalabilityModeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRTCSvcScalabilityMode;
using ScopedRubyShortHeuristicsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRubyShortHeuristics;
using ScopedRunSnapshotPostLayoutStateStepsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedRunSnapshotPostLayoutStateSteps;
using ScopedSanitizerAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSanitizerAPI;
using ScopedSchedulerYieldDisallowCrossFrameInheritanceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSchedulerYieldDisallowCrossFrameInheritance;
using ScopedScopedCustomElementRegistryForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScopedCustomElementRegistry;
using ScopedScopedViewTransitionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScopedViewTransitions;
using ScopedScreenDetailedHdrHeadroomForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScreenDetailedHdrHeadroom;
using ScopedScriptedSpeechRecognitionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScriptedSpeechRecognition;
using ScopedScriptedSpeechSynthesisForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScriptedSpeechSynthesis;
using ScopedScriptRunIteratorCombiningMarkAlwaysForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScriptRunIteratorCombiningMarkAlways;
using ScopedScriptRunIteratorCombiningMarksForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScriptRunIteratorCombiningMarks;
using ScopedScriptToolsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScriptTools;
using ScopedScrollAnchorPriorityCandidateSubtreeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScrollAnchorPriorityCandidateSubtree;
using ScopedScrollbarColorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScrollbarColor;
using ScopedScrollbarWidthForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScrollbarWidth;
using ScopedScrollIntoViewNearestForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScrollIntoViewNearest;
using ScopedScrollIntoViewRootFrameViewportBugFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScrollIntoViewRootFrameViewportBugFix;
using ScopedScrollIntoViewSelfScrollFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScrollIntoViewSelfScrollFix;
using ScopedScrollTimelineCurrentTimeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScrollTimelineCurrentTime;
using ScopedScrollTimelineNamedRangeScrollForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScrollTimelineNamedRangeScroll;
using ScopedScrollTopLeftInteropForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedScrollTopLeftInterop;
using ScopedSearchTextHighlightPseudoForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSearchTextHighlightPseudo;
using ScopedSecurePaymentConfirmationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSecurePaymentConfirmation;
using ScopedSecurePaymentConfirmationAvailabilityAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSecurePaymentConfirmationAvailabilityAPI;
using ScopedSecurePaymentConfirmationBrowserBoundKeysForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSecurePaymentConfirmationBrowserBoundKeys;
using ScopedSecurePaymentConfirmationDebugForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSecurePaymentConfirmationDebug;
using ScopedSecurePaymentConfirmationOptOutForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSecurePaymentConfirmationOptOut;
using ScopedSecurePaymentConfirmationUxRefreshForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSecurePaymentConfirmationUxRefresh;
using ScopedSelectAudioOutputForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectAudioOutput;
using ScopedSelectChildrenRemovedFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectChildrenRemovedFix;
using ScopedSelectedcontentelementAttributeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectedcontentelementAttribute;
using ScopedSelectionAndFocusedVisiblePositionMatchForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectionAndFocusedVisiblePositionMatch;
using ScopedSelectionHandleWithBottomClippedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectionHandleWithBottomClipped;
using ScopedSelectionSetBaseAndExtentNonNullNodeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectionSetBaseAndExtentNonNullNode;
using ScopedSelectionUpdateToInitialSelectionInListifyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectionUpdateToInitialSelectionInListify;
using ScopedSelectiveClipboardFormatReadForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectiveClipboardFormatRead;
using ScopedSelectivePermissionsInterventionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectivePermissionsIntervention;
using ScopedSelectMobileDesktopParityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSelectMobileDesktopParity;
using ScopedSendBeaconThrowForBlobWithNonSimpleTypeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSendBeaconThrowForBlobWithNonSimpleType;
using ScopedSensorExtraClassesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSensorExtraClasses;
using ScopedSeparateDeferModuleScriptTasksForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSeparateDeferModuleScriptTasks;
using ScopedSerialForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSerial;
using ScopedSerializeViewTransitionStateInSPAForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSerializeViewTransitionStateInSPA;
using ScopedSerialPortConnectedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSerialPortConnected;
using ScopedServiceWorkerBackgroundSyncInDedicatedWorkerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedServiceWorkerBackgroundSyncInDedicatedWorker;
using ScopedServiceWorkerClientLifecycleStateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedServiceWorkerClientLifecycleState;
using ScopedServiceWorkerInDedicatedWorkerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedServiceWorkerInDedicatedWorker;
using ScopedServiceWorkerStaticRouterTimingInfoForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedServiceWorkerStaticRouterTimingInfo;
using ScopedSetSequentialFocusStartingPointForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSetSequentialFocusStartingPoint;
using ScopedShadowRootReferenceTargetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedShadowRootReferenceTarget;
using ScopedShadowRootReferenceTargetAriaOwnsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedShadowRootReferenceTargetAriaOwns;
using ScopedShapeResultCachedPreviousSafeToBreakOffsetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedShapeResultCachedPreviousSafeToBreakOffset;
using ScopedSharedArrayBufferForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSharedArrayBuffer;
using ScopedSharedArrayBufferUnrestrictedAccessAllowedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSharedArrayBufferUnrestrictedAccessAllowed;
using ScopedSharedAutofillForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSharedAutofill;
using ScopedSharedStorageAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSharedStorageAPI;
using ScopedSharedStorageWebLocksForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSharedStorageWebLocks;
using ScopedSharedWorkerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSharedWorker;
using ScopedSharedWorkerExtendedLifetimeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSharedWorkerExtendedLifetime;
using ScopedSideRelativeBackgroundPositionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSideRelativeBackgroundPosition;
using ScopedSignatureBasedInlineIntegrityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSignatureBasedInlineIntegrity;
using ScopedSignatureBasedIntegrityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSignatureBasedIntegrity;
using ScopedSkipAdForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSkipAd;
using ScopedSkipCallbacksWhenDevToolsNotOpenForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSkipCallbacksWhenDevToolsNotOpen;
using ScopedSkipLineBreakItemWhenIsCollapsedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSkipLineBreakItemWhenIsCollapsed;
using ScopedSkipOofItemForBreakCandidateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSkipOofItemForBreakCandidate;
using ScopedSkipTouchEventFilterForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSkipTouchEventFilter;
using ScopedSkipUnselectableContentInSerializationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSkipUnselectableContentInSerialization;
using ScopedSmartCardForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSmartCard;
using ScopedSmartZoomForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSmartZoom;
using ScopedSmilKeyTimesKeyPointsAllowTrailingSemicolonForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSmilKeyTimesKeyPointsAllowTrailingSemicolon;
using ScopedSoftNavigationDetectionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSoftNavigationDetection;
using ScopedSoftNavigationDetectionAdvancedPaintAttributionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSoftNavigationDetectionAdvancedPaintAttribution;
using ScopedSoftNavigationDetectionPrePaintBasedAttributionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSoftNavigationDetectionPrePaintBasedAttribution;
using ScopedSoftNavigationHeuristicsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSoftNavigationHeuristics;
using ScopedSpatNavUsesCursorInheritanceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSpatNavUsesCursorInheritance;
using ScopedSpeakerSelectionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSpeakerSelection;
using ScopedSpecialRulesForNestedH1ElementsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSpecialRulesForNestedH1Elements;
using ScopedSpeculationRulesPrefetchWithSubresourcesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSpeculationRulesPrefetchWithSubresources;
using ScopedSplitTextNotCleanupDummySpansForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSplitTextNotCleanupDummySpans;
using ScopedSrcsetSelectionMatchesImageSetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSrcsetSelectionMatchesImageSet;
using ScopedStableBlinkFeaturesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStableBlinkFeatures;
using ScopedStandardizedBrowserZoomForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStandardizedBrowserZoom;
using ScopedStandardizedBrowserZoomOptOutForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStandardizedBrowserZoomOptOut;
using ScopedStickyUserActivationAcrossSameOriginNavigationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStickyUserActivationAcrossSameOriginNavigation;
using ScopedStorageBucketsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStorageBuckets;
using ScopedStorageBucketsDurabilityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStorageBucketsDurability;
using ScopedStorageBucketsLocksForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStorageBucketsLocks;
using ScopedStrictJsonMimeTypeTokenValidationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStrictJsonMimeTypeTokenValidation;
using ScopedStrictMimeTypesForWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStrictMimeTypesForWorkers;
using ScopedStylusHandwritingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedStylusHandwriting;
using ScopedSvg2CascadeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvg2Cascade;
using ScopedSvgAnchorElementDownloadAttributeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgAnchorElementDownloadAttribute;
using ScopedSvgAnchorElementRelAttributesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgAnchorElementRelAttributes;
using ScopedSvgAvoidCullingElementsWithTransformOperationsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgAvoidCullingElementsWithTransformOperations;
using ScopedSvgEagerPresAttrStyleUpdateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgEagerPresAttrStyleUpdate;
using ScopedSVGEmbeddedAsReplacedElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSVGEmbeddedAsReplacedElement;
using ScopedSvgEnableTextDecorationCssStylingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgEnableTextDecorationCssStyling;
using ScopedSvgExternalResourcesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgExternalResources;
using ScopedSvgFallBackToContainerSizeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgFallBackToContainerSize;
using ScopedSvgFeConvolveMatrixZeroDivisorBehaviorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgFeConvolveMatrixZeroDivisorBehavior;
using ScopedSvgFilterPaintsForHiddenContentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgFilterPaintsForHiddenContent;
using ScopedSvgIgnoreNegativeEllipseRadiiForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgIgnoreNegativeEllipseRadii;
using ScopedSvgImageNoExternalXsltForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgImageNoExternalXslt;
using ScopedSvgInlineRootPixelSnappingScaleAdjustmentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgInlineRootPixelSnappingScaleAdjustment;
using ScopedSvgNoPixelSnappingScaleAdjustmentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgNoPixelSnappingScaleAdjustment;
using ScopedSvgPartitionSVGDocumentResourcesInMemoryCacheForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgPartitionSVGDocumentResourcesInMemoryCache;
using ScopedSvgScriptElementAsyncAttributeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgScriptElementAsyncAttribute;
using ScopedSvgSizingWithPreserveAspectRatioNoneForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgSizingWithPreserveAspectRatioNone;
using ScopedSvgSmilPruneInstanceTimesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgSmilPruneInstanceTimes;
using ScopedSvgTextCentralBaselineTextDecorationFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgTextCentralBaselineTextDecorationFix;
using ScopedSvgTransformOnNestedSvgElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgTransformOnNestedSvgElement;
using ScopedSvgUseInstancesAttributeSyncForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSvgUseInstancesAttributeSync;
using ScopedSynthesizedKeyboardEventsForAccessibilityActionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSynthesizedKeyboardEventsForAccessibilityActions;
using ScopedSystemDefaultAccentColorsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSystemDefaultAccentColors;
using ScopedSystemFallbackEmojiVSSupportForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSystemFallbackEmojiVSSupport;
using ScopedSystemWakeLockForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedSystemWakeLock;
using ScopedTableIsAutoFixedLayoutForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTableIsAutoFixedLayout;
using ScopedTabSizeAncestorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTabSizeAncestor;
using ScopedTabSizeWithSpacingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTabSizeWithSpacing;
using ScopedTabWidthNegativePositionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTabWidthNegativePosition;
using ScopedTargetInShadowDeterminedBeforeListenerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTargetInShadowDeterminedBeforeListener;
using ScopedTestBlinkFeatureDefaultForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTestBlinkFeatureDefault;
using ScopedTestFeatureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTestFeature;
using ScopedTestFeatureDependentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTestFeatureDependent;
using ScopedTestFeatureForBrowserProcessReadWriteAccessOriginTrialForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTestFeatureForBrowserProcessReadWriteAccessOriginTrial;
using ScopedTestFeatureImpliedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTestFeatureImplied;
using ScopedTestFeatureProtectedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTestFeatureProtected;
using ScopedTestFeatureProtectedDependentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTestFeatureProtectedDependent;
using ScopedTestFeatureProtectedImpliedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTestFeatureProtectedImplied;
using ScopedTestFeatureStableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTestFeatureStable;
using ScopedTextareaLastLineRemovalFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextareaLastLineRemovalFix;
using ScopedTextareaLineEndingsAsBrForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextareaLineEndingsAsBr;
using ScopedTextareaMultipleIfcsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextareaMultipleIfcs;
using ScopedTextareaSplitTextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextareaSplitText;
using ScopedTextDecorationOmitCurrentColorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextDecorationOmitCurrentColor;
using ScopedTextDecorationShortSerializationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextDecorationShortSerialization;
using ScopedTextDetectorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextDetector;
using ScopedTextDiffSplitFixForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextDiffSplitFix;
using ScopedTextEmphasisLetterSpacingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextEmphasisLetterSpacing;
using ScopedTextEmphasisPositionAutoForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextEmphasisPositionAuto;
using ScopedTextEmphasisPunctuationExceptionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextEmphasisPunctuationExceptions;
using ScopedTextFragmentAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextFragmentAPI;
using ScopedTextFragmentIdentifiersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextFragmentIdentifiers;
using ScopedTextFragmentTapOpensContextMenuForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextFragmentTapOpensContextMenu;
using ScopedTextMetricsBaselinesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextMetricsBaselines;
using ScopedTextOverflowStringForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextOverflowString;
using ScopedTextSpacingTrimFallbackForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextSpacingTrimFallback;
using ScopedTextSpacingTrimFallback2ForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextSpacingTrimFallback2;
using ScopedTextSpacingTrimYuGothicUIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTextSpacingTrimYuGothicUI;
using ScopedThirdPartyStoragePartitioningUserBypassForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedThirdPartyStoragePartitioningUserBypass;
using ScopedTimerThrottlingForBackgroundTabsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTimerThrottlingForBackgroundTabs;
using ScopedTimestampBasedCLSTrackingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTimestampBasedCLSTracking;
using ScopedTimeZoneChangeEventForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTimeZoneChangeEvent;
using ScopedToggleEventSourceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedToggleEventSource;
using ScopedTopicsAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTopicsAPI;
using ScopedTopicsDocumentAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTopicsDocumentAPI;
using ScopedTopicsImgAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTopicsImgAPI;
using ScopedTopLevelTpcdForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTopLevelTpcd;
using ScopedTouchDragAndContextMenuForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTouchDragAndContextMenu;
using ScopedTouchDragAndDropForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTouchDragAndDrop;
using ScopedTouchDragOnShortPressForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTouchDragOnShortPress;
using ScopedTouchEventFeatureDetectionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTouchEventFeatureDetection;
using ScopedTouchTextEditingRedesignForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTouchTextEditingRedesign;
using ScopedTpcdForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTpcd;
using ScopedTransferableRTCDataChannelForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTransferableRTCDataChannel;
using ScopedTranslateServiceForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTranslateService;
using ScopedTranslationAPIForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTranslationAPI;
using ScopedTranslationAPIForWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTranslationAPIForWorkers;
using ScopedTraverseFlatTreeToHandleSlotsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTraverseFlatTreeToHandleSlots;
using ScopedTreatMhtmlInitialDocumentLoadsAsCrossDocumentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTreatMhtmlInitialDocumentLoadsAsCrossDocument;
using ScopedTrustedTypesFromLiteralForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTrustedTypesFromLiteral;
using ScopedTrustedTypesHTMLForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTrustedTypesHTML;
using ScopedTrustedTypesUseCodeLikeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTrustedTypesUseCodeLike;
using ScopedTwoPhaseViewTransitionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedTwoPhaseViewTransition;
using ScopedUnclosedFormControlIsInvalidForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUnclosedFormControlIsInvalid;
using ScopedUnencodedDigestForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUnencodedDigest;
using ScopedUnexposedTaskIdsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUnexposedTaskIds;
using ScopedUnprefixedSpeechRecognitionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUnprefixedSpeechRecognition;
using ScopedUnrestrictedMeasureUserAgentSpecificMemoryForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUnrestrictedMeasureUserAgentSpecificMemory;
using ScopedUnrestrictedSharedArrayBufferForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUnrestrictedSharedArrayBuffer;
using ScopedUnrestrictedUsbForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUnrestrictedUsb;
using ScopedUpdateComplexSafaAreaConstraintsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUpdateComplexSafaAreaConstraints;
using ScopedUpdateSelectionOnNodeInsertionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUpdateSelectionOnNodeInsertion;
using ScopedUpdateTrivalTextAfterFragmentCreationFromTextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUpdateTrivalTextAfterFragmentCreationFromText;
using ScopedURLPatternCompareComponentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedURLPatternCompareComponent;
using ScopedURLPatternGenerateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedURLPatternGenerate;
using ScopedURLSearchParamsHasAndDeleteMultipleArgsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedURLSearchParamsHasAndDeleteMultipleArgs;
using ScopedUseBeginFramePresentationFeedbackForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUseBeginFramePresentationFeedback;
using ScopedUseLowQualityInterpolationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUseLowQualityInterpolation;
using ScopedUseOriginalDomOffsetsForOffsetMapForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUseOriginalDomOffsetsForOffsetMap;
using ScopedUsePersistentCacheForCodeCacheForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUsePersistentCacheForCodeCache;
using ScopedUsePositionForPointInFlexibleBoxWithSingleChildElementForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUsePositionForPointInFlexibleBoxWithSingleChildElement;
using ScopedUsePositionIfIsVisuallyEquivalentCandidateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUsePositionIfIsVisuallyEquivalentCandidate;
using ScopedUserDefinedEntryPointTimingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUserDefinedEntryPointTiming;
using ScopedUseSelectionInDOMTreeAnchorInExtendSelectionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUseSelectionInDOMTreeAnchorInExtendSelection;
using ScopedUseShadowHostStyleCheckEditableForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUseShadowHostStyleCheckEditable;
using ScopedUseSpecValuesInTextFormatUpdateEventStylesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUseSpecValuesInTextFormatUpdateEventStyles;
using ScopedUseUndoStepElementDispatchBeforeInputForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedUseUndoStepElementDispatchBeforeInput;
using ScopedV8IdleTasksForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedV8IdleTasks;
using ScopedVideoAutoFullscreenForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedVideoAutoFullscreen;
using ScopedVideoFrameMetadataBackgroundBlurForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedVideoFrameMetadataBackgroundBlur;
using ScopedVideoFrameMetadataRtpTimestampForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedVideoFrameMetadataRtpTimestamp;
using ScopedVideoFullscreenOrientationLockForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedVideoFullscreenOrientationLock;
using ScopedVideoRotateToFullscreenForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedVideoRotateToFullscreen;
using ScopedVideoTrackGeneratorForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedVideoTrackGenerator;
using ScopedVideoTrackGeneratorInWindowForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedVideoTrackGeneratorInWindow;
using ScopedVideoTrackGeneratorInWorkerForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedVideoTrackGeneratorInWorker;
using ScopedViewportHeightClientHintHeaderForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedViewportHeightClientHintHeader;
using ScopedViewportSegmentsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedViewportSegments;
using ScopedViewTransitionAnimationDelayInheritForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedViewTransitionAnimationDelayInherit;
using ScopedViewTransitionAsyncFinishedForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedViewTransitionAsyncFinished;
using ScopedViewTransitionInheritAnimationPropertiesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedViewTransitionInheritAnimationProperties;
using ScopedViewTransitionLongCallbackTimeoutForTestingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedViewTransitionLongCallbackTimeoutForTesting;
using ScopedViewTransitionUpdateLifecycleBeforeReadyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedViewTransitionUpdateLifecycleBeforeReady;
using ScopedVisibilityCollapseColumnForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedVisibilityCollapseColumn;
using ScopedWakeLockForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWakeLock;
using ScopedWarnOnContentVisibilityRenderAccessForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWarnOnContentVisibilityRenderAccess;
using ScopedWebAppInstallationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAppInstallation;
using ScopedWebAppLaunchQueueForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAppLaunchQueue;
using ScopedWebAppScopeExtensionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAppScopeExtensions;
using ScopedWebAppTabStripForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAppTabStrip;
using ScopedWebAppTabStripCustomizationsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAppTabStripCustomizations;
using ScopedWebAppTranslationsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAppTranslations;
using ScopedWebAssemblyCustomDescriptorsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAssemblyCustomDescriptors;
using ScopedWebAssemblyJSPromiseIntegrationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAssemblyJSPromiseIntegration;
using ScopedWebAudioBypassOutputBufferingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAudioBypassOutputBuffering;
using ScopedWebAudioBypassOutputBufferingOptOutForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAudioBypassOutputBufferingOptOut;
using ScopedWebAudioConfigurableRenderQuantumForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAudioConfigurableRenderQuantum;
using ScopedWebAuthForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAuth;
using ScopedWebAuthAuthenticatorAttachmentForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAuthAuthenticatorAttachment;
using ScopedWebAuthenticationAmbientForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAuthenticationAmbient;
using ScopedWebAuthenticationAttestationFormatsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAuthenticationAttestationFormats;
using ScopedWebAuthenticationChallengeUrlForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAuthenticationChallengeUrl;
using ScopedWebAuthenticationConditionalCreateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAuthenticationConditionalCreate;
using ScopedWebAuthenticationImmediateGetForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAuthenticationImmediateGet;
using ScopedWebAuthenticationRemoteDesktopSupportForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAuthenticationRemoteDesktopSupport;
using ScopedWebAuthenticationSupplementalPubKeysForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebAuthenticationSupplementalPubKeys;
using ScopedWebBluetoothForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebBluetooth;
using ScopedWebBluetoothGetDevicesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebBluetoothGetDevices;
using ScopedWebBluetoothScanningForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebBluetoothScanning;
using ScopedWebBluetoothWatchAdvertisementsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebBluetoothWatchAdvertisements;
using ScopedWebCodecsCopyToRGBForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebCodecsCopyToRGB;
using ScopedWebCodecsHBDFormatsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebCodecsHBDFormats;
using ScopedWebCodecsOrientationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebCodecsOrientation;
using ScopedWebCodecsVideoEncoderBuffersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebCodecsVideoEncoderBuffers;
using ScopedWebFontResizeLCPForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebFontResizeLCP;
using ScopedWebGLDeveloperExtensionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebGLDeveloperExtensions;
using ScopedWebGLDraftExtensionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebGLDraftExtensions;
using ScopedWebGLDrawingBufferStorageForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebGLDrawingBufferStorage;
using ScopedWebGLImageChromiumForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebGLImageChromium;
using ScopedWebGLOnWebGPUForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebGLOnWebGPU;
using ScopedWebGPUCompatibilityModeForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebGPUCompatibilityMode;
using ScopedWebGPUDeveloperFeaturesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebGPUDeveloperFeatures;
using ScopedWebGPUExperimentalFeaturesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebGPUExperimentalFeatures;
using ScopedWebHIDForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebHID;
using ScopedWebHIDOnServiceWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebHIDOnServiceWorkers;
using ScopedWebIdentityDigitalCredentialsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebIdentityDigitalCredentials;
using ScopedWebIdentityDigitalCredentialsCreationForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebIdentityDigitalCredentialsCreation;
using ScopedWebIDLBigIntUsesToBigIntForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebIDLBigIntUsesToBigInt;
using ScopedWebNFCForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebNFC;
using ScopedWebOTPForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebOTP;
using ScopedWebOTPAssertionFeaturePolicyForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebOTPAssertionFeaturePolicy;
using ScopedWebPreferencesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebPreferences;
using ScopedWebPrintingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebPrinting;
using ScopedWebShareForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebShare;
using ScopedWebSocketStreamForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebSocketStream;
using ScopedWebSpeechRecognitionContextForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebSpeechRecognitionContext;
using ScopedWebTransportApplicationProtocolForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebTransportApplicationProtocol;
using ScopedWebTransportCustomCertificatesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebTransportCustomCertificates;
using ScopedWebTransportStatsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebTransportStats;
using ScopedWebUIBundledCodeCacheAsyncFetchForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebUIBundledCodeCacheAsyncFetch;
using ScopedWebUSBForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebUSB;
using ScopedWebUSBOnDedicatedWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebUSBOnDedicatedWorkers;
using ScopedWebUSBOnServiceWorkersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebUSBOnServiceWorkers;
using ScopedWebVTTRegionsForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebVTTRegions;
using ScopedWebXRForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXR;
using ScopedWebXREnabledFeaturesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXREnabledFeatures;
using ScopedWebXRFrameRateForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRFrameRate;
using ScopedWebXRFrontFacingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRFrontFacing;
using ScopedWebXRGPUBindingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRGPUBinding;
using ScopedWebXRHitTestEntityTypesForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRHitTestEntityTypes;
using ScopedWebXRImageTrackingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRImageTracking;
using ScopedWebXRLayersForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRLayers;
using ScopedWebXRLayersCommonForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRLayersCommon;
using ScopedWebXRPlaneDetectionForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRPlaneDetection;
using ScopedWebXRPoseMotionDataForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRPoseMotionData;
using ScopedWebXRSpecParityForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWebXRSpecParity;
using ScopedWidthAndHeightAsPresentationAttributesOnNestedSvgForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWidthAndHeightAsPresentationAttributesOnNestedSvg;
using ScopedWidthAndHeightStylePropertiesOnUseAndSymbolForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWidthAndHeightStylePropertiesOnUseAndSymbol;
using ScopedWindowControlsOverlayForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWindowControlsOverlay;
using ScopedWindowDefaultStatusForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWindowDefaultStatus;
using ScopedWordSpacingWhiteSpacePreForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedWordSpacingWhiteSpacePre;
using ScopedXMLSerializerConsistentDefaultNsDeclMatchingForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedXMLSerializerConsistentDefaultNsDeclMatching;
using ScopedXSLTForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedXSLT;
using ScopedZeroCopyTabCaptureForTest =
    RuntimeEnabledFeaturesTestHelpers::ScopedZeroCopyTabCapture;
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_PLATFORM_RUNTIME_ENABLED_FEATURES_TEST_HELPERS_H_
