
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated. Do not edit. Just generate.
//
// Manually re-generate:
// $ ninja -C ... third_party/blink/renderer/core/sanitizer:generated

#include "third_party/blink/renderer/core/sanitizer/sanitizer_builtins.h"
#include "third_party/blink/renderer/core/sanitizer/sanitizer.h"

#include "third_party/blink/renderer/core/html_names.h"
#include "third_party/blink/renderer/core/mathml_names.h"
#include "third_party/blink/renderer/core/svg_names.h"
#include "third_party/blink/renderer/core/xlink_names.h"
#include "third_party/blink/renderer/core/xml_names.h"
#include "third_party/blink/renderer/core/xmlns_names.h"

namespace blink {
namespace sanitizer_generated_builtins {

Sanitizer* BuildDefaultConfig() {
Sanitizer* sanitizer = MakeGarbageCollected<Sanitizer>(
  /* elements */ HashSet<QualifiedName> {
    html_names::kATag,
    html_names::kAbbrTag,
    html_names::kAcronymTag,
    html_names::kAddressTag,
    html_names::kAreaTag,
    html_names::kArticleTag,
    html_names::kAsideTag,
    html_names::kAudioTag,
    html_names::kBTag,
    html_names::kBasefontTag,
    html_names::kBdiTag,
    html_names::kBdoTag,
    html_names::kBgsoundTag,
    html_names::kBigTag,
    html_names::kBlockquoteTag,
    html_names::kBodyTag,
    html_names::kBrTag,
    html_names::kButtonTag,
    html_names::kCanvasTag,
    html_names::kCaptionTag,
    html_names::kCenterTag,
    html_names::kCiteTag,
    html_names::kCodeTag,
    html_names::kColTag,
    html_names::kColgroupTag,
    html_names::kCommandTag,
    html_names::kDataTag,
    html_names::kDatalistTag,
    html_names::kDdTag,
    html_names::kDelTag,
    html_names::kDetailsTag,
    html_names::kDfnTag,
    html_names::kDirTag,
    html_names::kDialogTag,
    html_names::kDivTag,
    html_names::kDlTag,
    html_names::kDtTag,
    html_names::kEmTag,
    html_names::kFencedframeTag,
    html_names::kFieldsetTag,
    html_names::kFigcaptionTag,
    html_names::kFigureTag,
    html_names::kFontTag,
    html_names::kFooterTag,
    html_names::kFormTag,
    html_names::kH1Tag,
    html_names::kH2Tag,
    html_names::kH3Tag,
    html_names::kH4Tag,
    html_names::kH5Tag,
    html_names::kH6Tag,
    html_names::kHeadTag,
    html_names::kHeaderTag,
    html_names::kHgroupTag,
    html_names::kHrTag,
    html_names::kHTMLTag,
    html_names::kITag,
    html_names::kImageTag,
    html_names::kImgTag,
    html_names::kInputTag,
    html_names::kInsTag,
    html_names::kKbdTag,
    html_names::kKeygenTag,
    html_names::kLabelTag,
    html_names::kLayerTag,
    html_names::kLegendTag,
    html_names::kLiTag,
    html_names::kLinkTag,
    html_names::kListingTag,
    html_names::kMainTag,
    html_names::kMapTag,
    html_names::kMarkTag,
    html_names::kMarqueeTag,
    html_names::kMenuTag,
    html_names::kMetaTag,
    html_names::kMeterTag,
    html_names::kNavTag,
    html_names::kNobrTag,
    html_names::kOlTag,
    html_names::kOptgroupTag,
    html_names::kOptionTag,
    html_names::kOutputTag,
    html_names::kPTag,
    html_names::kPermissionTag,
    html_names::kPictureTag,
    html_names::kPlaintextTag,
    html_names::kPreTag,
    html_names::kProgressTag,
    html_names::kQTag,
    html_names::kRbTag,
    html_names::kRpTag,
    html_names::kRtTag,
    html_names::kRTCTag,
    html_names::kRubyTag,
    html_names::kSTag,
    html_names::kSampTag,
    html_names::kSearchTag,
    html_names::kSectionTag,
    html_names::kSelectTag,
    html_names::kSlotTag,
    html_names::kSmallTag,
    html_names::kSourceTag,
    html_names::kSpanTag,
    html_names::kStrikeTag,
    html_names::kStrongTag,
    html_names::kStyleTag,
    html_names::kSubTag,
    html_names::kSummaryTag,
    html_names::kSupTag,
    html_names::kTableTag,
    html_names::kTbodyTag,
    html_names::kTdTag,
    html_names::kTemplateTag,
    html_names::kTextareaTag,
    html_names::kTfootTag,
    html_names::kThTag,
    html_names::kTheadTag,
    html_names::kTimeTag,
    html_names::kTitleTag,
    html_names::kTrTag,
    html_names::kTrackTag,
    html_names::kTtTag,
    html_names::kUTag,
    html_names::kUlTag,
    html_names::kVarTag,
    html_names::kVideoTag,
    html_names::kWbrTag,
    html_names::kXmpTag,
    html_names::kNoscriptTag,
    mathml_names::kAnnotationTag,
    mathml_names::kAnnotationXmlTag,
    mathml_names::kMactionTag,
    mathml_names::kMalignmarkTag,
    mathml_names::kMathTag,
    mathml_names::kMrootTag,
    mathml_names::kMsqrtTag,
    mathml_names::kMerrorTag,
    mathml_names::kMfracTag,
    mathml_names::kMglyphTag,
    mathml_names::kMsubTag,
    mathml_names::kMsupTag,
    mathml_names::kMsubsupTag,
    mathml_names::kMmultiscriptsTag,
    mathml_names::kMprescriptsTag,
    mathml_names::kMiTag,
    mathml_names::kMnTag,
    mathml_names::kMoTag,
    mathml_names::kMpaddedTag,
    mathml_names::kMphantomTag,
    mathml_names::kMrowTag,
    mathml_names::kMsTag,
    mathml_names::kMspaceTag,
    mathml_names::kMstyleTag,
    mathml_names::kMtableTag,
    mathml_names::kMtdTag,
    mathml_names::kMtrTag,
    mathml_names::kMtextTag,
    mathml_names::kMoverTag,
    mathml_names::kMunderTag,
    mathml_names::kMunderoverTag,
    mathml_names::kSemanticsTag,
    mathml_names::kNoneTag,
    svg_names::kATag,
    svg_names::kAnimateTag,
    svg_names::kAnimateColorTag,
    svg_names::kAnimateMotionTag,
    svg_names::kAnimateTransformTag,
    svg_names::kSetTag,
    svg_names::kCircleTag,
    svg_names::kClipPathTag,
    svg_names::kDefsTag,
    svg_names::kDescTag,
    svg_names::kEllipseTag,
    svg_names::kFEBlendTag,
    svg_names::kFEColorMatrixTag,
    svg_names::kFEComponentTransferTag,
    svg_names::kFECompositeTag,
    svg_names::kFEConvolveMatrixTag,
    svg_names::kFEDiffuseLightingTag,
    svg_names::kFEDisplacementMapTag,
    svg_names::kFEDistantLightTag,
    svg_names::kFEDropShadowTag,
    svg_names::kFEFloodTag,
    svg_names::kFEFuncATag,
    svg_names::kFEFuncBTag,
    svg_names::kFEFuncGTag,
    svg_names::kFEFuncRTag,
    svg_names::kFEGaussianBlurTag,
    svg_names::kFEImageTag,
    svg_names::kFEMergeTag,
    svg_names::kFEMergeNodeTag,
    svg_names::kFEMorphologyTag,
    svg_names::kFEOffsetTag,
    svg_names::kFEPointLightTag,
    svg_names::kFESpecularLightingTag,
    svg_names::kFESpotLightTag,
    svg_names::kFETileTag,
    svg_names::kFETurbulenceTag,
    svg_names::kFilterTag,
    svg_names::kForeignObjectTag,
    svg_names::kGTag,
    svg_names::kImageTag,
    svg_names::kLineTag,
    svg_names::kLinearGradientTag,
    svg_names::kMarkerTag,
    svg_names::kMaskTag,
    svg_names::kMetadataTag,
    svg_names::kMPathTag,
    svg_names::kPathTag,
    svg_names::kPatternTag,
    svg_names::kPolygonTag,
    svg_names::kPolylineTag,
    svg_names::kRadialGradientTag,
    svg_names::kRectTag,
    svg_names::kStopTag,
    svg_names::kStyleTag,
    svg_names::kSVGTag,
    svg_names::kSwitchTag,
    svg_names::kSymbolTag,
    svg_names::kTextTag,
    svg_names::kTextPathTag,
    svg_names::kTitleTag,
    svg_names::kTSpanTag,
    svg_names::kUseTag,
    svg_names::kViewTag,
  },
  /* removeElements */ HashSet<QualifiedName> {
  },
  /* replaceWithChildrenElements */ HashSet<QualifiedName> {
  },
  /* attributes */ HashSet<QualifiedName> {
    html_names::kAbbrAttr,
    mathml_names::kAccentAttr,
    mathml_names::kAccentunderAttr,
    html_names::kAcceptAttr,
    html_names::kAcceptCharsetAttr,
    html_names::kAccesskeyAttr,
    svg_names::kAccumulateAttr,
    html_names::kActionAttr,
    html_names::kAdauctionheadersAttr,
    svg_names::kAdditiveAttr,
    html_names::kAlignAttr,
    svg_names::kAlignmentBaselineAttr,
    html_names::kAlinkAttr,
    html_names::kAllowAttr,
    html_names::kAllowfullscreenAttr,
    html_names::kAllowpaymentrequestAttr,
    html_names::kAltAttr,
    svg_names::kAmplitudeAttr,
    html_names::kAnchorAttr,
    svg_names::kAnimateAttr,
    html_names::kArchiveAttr,
    html_names::kAriaActivedescendantAttr,
    html_names::kAriaAtomicAttr,
    html_names::kAriaAutocompleteAttr,
    html_names::kAriaBraillelabelAttr,
    html_names::kAriaBrailleroledescriptionAttr,
    html_names::kAriaBusyAttr,
    html_names::kAriaCheckedAttr,
    html_names::kAriaColcountAttr,
    html_names::kAriaColindexAttr,
    html_names::kAriaColindextextAttr,
    html_names::kAriaColspanAttr,
    html_names::kAriaControlsAttr,
    html_names::kAriaCurrentAttr,
    html_names::kAriaDescribedbyAttr,
    html_names::kAriaDescriptionAttr,
    html_names::kAriaDetailsAttr,
    html_names::kAriaDisabledAttr,
    html_names::kAriaErrormessageAttr,
    html_names::kAriaExpandedAttr,
    html_names::kAriaFlowtoAttr,
    html_names::kAriaHaspopupAttr,
    html_names::kAriaHiddenAttr,
    html_names::kAriaInvalidAttr,
    html_names::kAriaKeyshortcutsAttr,
    html_names::kAriaLabelAttr,
    html_names::kAriaLabeledbyAttr,
    html_names::kAriaLabelledbyAttr,
    html_names::kAriaLevelAttr,
    html_names::kAriaLiveAttr,
    html_names::kAriaModalAttr,
    html_names::kAriaMultilineAttr,
    html_names::kAriaMultiselectableAttr,
    html_names::kAriaOrientationAttr,
    html_names::kAriaOwnsAttr,
    html_names::kAriaPlaceholderAttr,
    html_names::kAriaPosinsetAttr,
    html_names::kAriaPressedAttr,
    html_names::kAriaReadonlyAttr,
    html_names::kAriaRelevantAttr,
    html_names::kAriaRequiredAttr,
    html_names::kAriaRoledescriptionAttr,
    html_names::kAriaRowcountAttr,
    html_names::kAriaRowindexAttr,
    html_names::kAriaRowindextextAttr,
    html_names::kAriaRowspanAttr,
    html_names::kAriaSelectedAttr,
    html_names::kAriaSetsizeAttr,
    html_names::kAriaSortAttr,
    html_names::kAriaValuemaxAttr,
    html_names::kAriaValueminAttr,
    html_names::kAriaValuenowAttr,
    html_names::kAriaValuetextAttr,
    html_names::kAriaVirtualcontentAttr,
    html_names::kAsAttr,
    svg_names::kAsyncAttr,
    svg_names::kAttributeNameAttr,
    svg_names::kAttributeTypeAttr,
    html_names::kAttributionsrcAttr,
    html_names::kAutocapitalizeAttr,
    html_names::kAutocompleteAttr,
    html_names::kAutocorrectAttr,
    svg_names::kAutofocusAttr,
    html_names::kAutoplayAttr,
    html_names::kAxisAttr,
    svg_names::kAzimuthAttr,
    html_names::kBackgroundAttr,
    svg_names::kBaseFrequencyAttr,
    svg_names::kBaseProfileAttr,
    svg_names::kBaselineShiftAttr,
    svg_names::kBeginAttr,
    html_names::kBehaviorAttr,
    html_names::kBgcolorAttr,
    svg_names::kBiasAttr,
    html_names::kBlockingAttr,
    html_names::kBorderAttr,
    html_names::kBordercolorAttr,
    html_names::kBrowsingtopicsAttr,
    svg_names::kBufferedRenderingAttr,
    svg_names::kByAttr,
    svg_names::kCalcModeAttr,
    html_names::kCaptureAttr,
    html_names::kCellpaddingAttr,
    html_names::kCellspacingAttr,
    html_names::kChallengeAttr,
    html_names::kCharAttr,
    html_names::kCharoffAttr,
    html_names::kCharsetAttr,
    html_names::kCheckedAttr,
    html_names::kCiteAttr,
    html_names::kClassAttr,
    html_names::kClassidAttr,
    html_names::kClearAttr,
    svg_names::kClipAttr,
    svg_names::kClipPathAttr,
    svg_names::kClipRuleAttr,
    svg_names::kClipPathUnitsAttr,
    html_names::kCodeAttr,
    html_names::kCodebaseAttr,
    html_names::kCodetypeAttr,
    svg_names::kColorAttr,
    svg_names::kColorInterpolationAttr,
    svg_names::kColorInterpolationFiltersAttr,
    svg_names::kColorRenderingAttr,
    html_names::kColsAttr,
    html_names::kColspanAttr,
    mathml_names::kColumnspanAttr,
    html_names::kCommandAttr,
    html_names::kCommandforAttr,
    html_names::kCompactAttr,
    html_names::kContentAttr,
    html_names::kContenteditableAttr,
    html_names::kControlsAttr,
    html_names::kControlslistAttr,
    html_names::kCoordsAttr,
    html_names::kCredentiallessAttr,
    svg_names::kCrossoriginAttr,
    html_names::kCspAttr,
    svg_names::kCursorAttr,
    svg_names::kCxAttr,
    svg_names::kCyAttr,
    svg_names::kDAttr,
    html_names::kDataAttr,
    html_names::kDataSrcAttr,
    html_names::kDatetimeAttr,
    html_names::kDeclareAttr,
    svg_names::kDecodingAttr,
    html_names::kDefaultAttr,
    html_names::kDeferAttr,
    mathml_names::kDefinitionURLAttr,
    html_names::kDelegatesfocusAttr,
    mathml_names::kDepthAttr,
    svg_names::kDiffuseConstantAttr,
    html_names::kDirAttr,
    svg_names::kDirectionAttr,
    html_names::kDirnameAttr,
    html_names::kDisabledAttr,
    html_names::kDisablepictureinpictureAttr,
    html_names::kDisableremoteplaybackAttr,
    svg_names::kDisplayAttr,
    mathml_names::kDisplaystyleAttr,
    svg_names::kDivisorAttr,
    svg_names::kDominantBaselineAttr,
    svg_names::kDownloadAttr,
    html_names::kDraggableAttr,
    svg_names::kDurAttr,
    svg_names::kDxAttr,
    svg_names::kDyAttr,
    svg_names::kEdgeModeAttr,
    html_names::kElementtimingAttr,
    svg_names::kElevationAttr,
    mathml_names::kEncodingAttr,
    html_names::kEnctypeAttr,
    svg_names::kEndAttr,
    html_names::kEnterkeyhintAttr,
    html_names::kEventAttr,
    svg_names::kExponentAttr,
    html_names::kExportpartsAttr,
    html_names::kFaceAttr,
    html_names::kFetchpriorityAttr,
    svg_names::kFillAttr,
    svg_names::kFillOpacityAttr,
    svg_names::kFillRuleAttr,
    svg_names::kFilterAttr,
    svg_names::kFilterUnitsAttr,
    svg_names::kFloodColorAttr,
    svg_names::kFloodOpacityAttr,
    svg_names::kFocusgroupAttr,
    svg_names::kFontFamilyAttr,
    svg_names::kFontSizeAttr,
    svg_names::kFontSizeAdjustAttr,
    svg_names::kFontStretchAttr,
    svg_names::kFontStyleAttr,
    svg_names::kFontVariantAttr,
    svg_names::kFontWeightAttr,
    html_names::kForAttr,
    mathml_names::kFormAttr,
    html_names::kFormactionAttr,
    svg_names::kFormatAttr,
    html_names::kFormenctypeAttr,
    html_names::kFormmethodAttr,
    html_names::kFormnovalidateAttr,
    html_names::kFormtargetAttr,
    svg_names::kFrAttr,
    html_names::kFrameAttr,
    html_names::kFrameborderAttr,
    svg_names::kFromAttr,
    svg_names::kFxAttr,
    svg_names::kFyAttr,
    svg_names::kG1Attr,
    svg_names::kG2Attr,
    svg_names::kGlyphRefAttr,
    svg_names::kGradientTransformAttr,
    svg_names::kGradientUnitsAttr,
    html_names::kHeadersAttr,
    svg_names::kHeightAttr,
    html_names::kHiddenAttr,
    html_names::kHighAttr,
    svg_names::kHrefAttr,
    html_names::kHreflangAttr,
    html_names::kHreftranslateAttr,
    html_names::kHspaceAttr,
    html_names::kHttpEquivAttr,
    html_names::kIdAttr,
    svg_names::kImageRenderingAttr,
    html_names::kImagesizesAttr,
    html_names::kImagesrcsetAttr,
    svg_names::kInAttr,
    svg_names::kIn2Attr,
    html_names::kIncrementalAttr,
    html_names::kInertAttr,
    html_names::kInputmodeAttr,
    html_names::kIntegrityAttr,
    svg_names::kInterceptAttr,
    svg_names::kInterestforAttr,
    html_names::kInvisibleAttr,
    html_names::kIsAttr,
    html_names::kIsmapAttr,
    html_names::kItempropAttr,
    svg_names::kKAttr,
    svg_names::kK1Attr,
    svg_names::kK2Attr,
    svg_names::kK3Attr,
    svg_names::kK4Attr,
    svg_names::kKernelMatrixAttr,
    svg_names::kKernelUnitLengthAttr,
    svg_names::kKeyPointsAttr,
    svg_names::kKeySplinesAttr,
    svg_names::kKeyTimesAttr,
    html_names::kKeytypeAttr,
    html_names::kKindAttr,
    html_names::kLabelAttr,
    svg_names::kLangAttr,
    html_names::kLanguageAttr,
    mathml_names::kLargeopAttr,
    html_names::kLatencyhintAttr,
    html_names::kLeftmarginAttr,
    svg_names::kLengthAdjustAttr,
    svg_names::kLetterSpacingAttr,
    svg_names::kLightingColorAttr,
    svg_names::kLimitingConeAngleAttr,
    mathml_names::kLinethicknessAttr,
    html_names::kLinkAttr,
    html_names::kListAttr,
    html_names::kLoadingAttr,
    svg_names::kLocalAttr,
    html_names::kLongdescAttr,
    html_names::kLoopAttr,
    html_names::kLowAttr,
    html_names::kLowsrcAttr,
    mathml_names::kLspaceAttr,
    html_names::kManifestAttr,
    html_names::kMarginheightAttr,
    html_names::kMarginwidthAttr,
    svg_names::kMarkerEndAttr,
    svg_names::kMarkerMidAttr,
    svg_names::kMarkerStartAttr,
    svg_names::kMarkerHeightAttr,
    svg_names::kMarkerUnitsAttr,
    svg_names::kMarkerWidthAttr,
    svg_names::kMaskAttr,
    svg_names::kMaskTypeAttr,
    svg_names::kMaskContentUnitsAttr,
    svg_names::kMaskUnitsAttr,
    mathml_names::kMathbackgroundAttr,
    mathml_names::kMathcolorAttr,
    mathml_names::kMathsizeAttr,
    mathml_names::kMathvariantAttr,
    svg_names::kMaxAttr,
    html_names::kMaxlengthAttr,
    mathml_names::kMaxsizeAttr,
    html_names::kMayscriptAttr,
    svg_names::kMediaAttr,
    svg_names::kMethodAttr,
    svg_names::kMinAttr,
    html_names::kMinlengthAttr,
    mathml_names::kMinsizeAttr,
    svg_names::kModeAttr,
    mathml_names::kMovablelimitsAttr,
    html_names::kMultipleAttr,
    html_names::kMutedAttr,
    svg_names::kNameAttr,
    html_names::kNohrefAttr,
    html_names::kNomoduleAttr,
    html_names::kNonceAttr,
    html_names::kNoresizeAttr,
    html_names::kNoshadeAttr,
    html_names::kNovalidateAttr,
    html_names::kNowrapAttr,
    svg_names::kNumOctavesAttr,
    html_names::kObjectAttr,
    svg_names::kOffsetAttr,
    svg_names::kOpacityAttr,
    html_names::kOpenAttr,
    svg_names::kOperatorAttr,
    html_names::kOptimumAttr,
    svg_names::kOrderAttr,
    svg_names::kOrientAttr,
    svg_names::kOriginAttr,
    svg_names::kOverflowAttr,
    svg_names::kPaintOrderAttr,
    html_names::kParsepartsAttr,
    html_names::kPartAttr,
    svg_names::kPathAttr,
    svg_names::kPathLengthAttr,
    html_names::kPatternAttr,
    svg_names::kPatternContentUnitsAttr,
    svg_names::kPatternTransformAttr,
    svg_names::kPatternUnitsAttr,
    html_names::kPingAttr,
    html_names::kPlaceholderAttr,
    html_names::kPlaysinlineAttr,
    svg_names::kPointerEventsAttr,
    svg_names::kPointsAttr,
    svg_names::kPointsAtXAttr,
    svg_names::kPointsAtYAttr,
    svg_names::kPointsAtZAttr,
    html_names::kPolicyAttr,
    html_names::kPopoverAttr,
    html_names::kPopovertargetAttr,
    html_names::kPopovertargetactionAttr,
    html_names::kPosterAttr,
    html_names::kPreloadAttr,
    svg_names::kPreserveAlphaAttr,
    svg_names::kPreserveAspectRatioAttr,
    svg_names::kPrimitiveUnitsAttr,
    html_names::kPrivatetokenAttr,
    html_names::kPropertyAttr,
    html_names::kPseudoAttr,
    svg_names::kRAttr,
    svg_names::kRadiusAttr,
    html_names::kReadonlyAttr,
    svg_names::kRefXAttr,
    svg_names::kRefYAttr,
    html_names::kReferrerpolicyAttr,
    svg_names::kRelAttr,
    svg_names::kRepeatCountAttr,
    svg_names::kRepeatDurAttr,
    html_names::kRequiredAttr,
    svg_names::kRequiredExtensionsAttr,
    svg_names::kRequiredFeaturesAttr,
    svg_names::kRestartAttr,
    svg_names::kResultAttr,
    html_names::kRevAttr,
    html_names::kReversedAttr,
    html_names::kRoleAttr,
    svg_names::kRotateAttr,
    html_names::kRowsAttr,
    mathml_names::kRowspanAttr,
    mathml_names::kRspaceAttr,
    html_names::kRulesAttr,
    svg_names::kRxAttr,
    svg_names::kRyAttr,
    html_names::kSandboxAttr,
    svg_names::kScaleAttr,
    html_names::kSchemeAttr,
    html_names::kScopeAttr,
    mathml_names::kScriptlevelAttr,
    html_names::kScrollamountAttr,
    html_names::kScrolldelayAttr,
    html_names::kScrollingAttr,
    svg_names::kSeedAttr,
    html_names::kSelectAttr,
    html_names::kSelectedAttr,
    html_names::kShadowrootAttr,
    html_names::kShadowrootclonableAttr,
    html_names::kShadowrootdelegatesfocusAttr,
    html_names::kShadowrootmodeAttr,
    html_names::kShadowrootserializableAttr,
    html_names::kShadowrootcustomelementregistryAttr,
    html_names::kShapeAttr,
    svg_names::kShapeRenderingAttr,
    html_names::kSharedstoragewritableAttr,
    html_names::kSizeAttr,
    html_names::kSizesAttr,
    svg_names::kSlopeAttr,
    html_names::kSlotAttr,
    svg_names::kSpacingAttr,
    html_names::kSpanAttr,
    svg_names::kSpecularConstantAttr,
    svg_names::kSpecularExponentAttr,
    html_names::kSpellcheckAttr,
    svg_names::kSpreadMethodAttr,
    html_names::kSrcAttr,
    html_names::kSrcdocAttr,
    html_names::kSrclangAttr,
    html_names::kSrcsetAttr,
    html_names::kStandbyAttr,
    html_names::kStartAttr,
    svg_names::kStartOffsetAttr,
    svg_names::kStdDeviationAttr,
    html_names::kStepAttr,
    svg_names::kStitchTilesAttr,
    svg_names::kStopColorAttr,
    svg_names::kStopOpacityAttr,
    mathml_names::kStretchyAttr,
    svg_names::kStrokeAttr,
    svg_names::kStrokeDasharrayAttr,
    svg_names::kStrokeDashoffsetAttr,
    svg_names::kStrokeLinecapAttr,
    svg_names::kStrokeLinejoinAttr,
    svg_names::kStrokeMiterlimitAttr,
    svg_names::kStrokeOpacityAttr,
    svg_names::kStrokeWidthAttr,
    svg_names::kStyleAttr,
    html_names::kSummaryAttr,
    svg_names::kSurfaceScaleAttr,
    mathml_names::kSymmetricAttr,
    svg_names::kSystemLanguageAttr,
    html_names::kTabindexAttr,
    svg_names::kTableValuesAttr,
    svg_names::kTargetAttr,
    svg_names::kTargetXAttr,
    svg_names::kTargetYAttr,
    html_names::kTextAttr,
    svg_names::kTextAnchorAttr,
    svg_names::kTextDecorationAttr,
    svg_names::kTextRenderingAttr,
    svg_names::kTextLengthAttr,
    svg_names::kTitleAttr,
    svg_names::kToAttr,
    html_names::kTopmarginAttr,
    svg_names::kTransformAttr,
    svg_names::kTransformOriginAttr,
    html_names::kTranslateAttr,
    html_names::kTruespeedAttr,
    svg_names::kTypeAttr,
    svg_names::kU1Attr,
    svg_names::kU2Attr,
    svg_names::kUnicodeBidiAttr,
    html_names::kUsemapAttr,
    html_names::kValignAttr,
    html_names::kValueAttr,
    svg_names::kValuesAttr,
    html_names::kValuetypeAttr,
    svg_names::kVectorEffectAttr,
    svg_names::kVersionAttr,
    svg_names::kViewBoxAttr,
    html_names::kVirtualkeyboardpolicyAttr,
    svg_names::kVisibilityAttr,
    html_names::kVlinkAttr,
    mathml_names::kVoffsetAttr,
    html_names::kVspaceAttr,
    html_names::kWebkitdirectoryAttr,
    svg_names::kWidthAttr,
    svg_names::kWordSpacingAttr,
    html_names::kWrapAttr,
    svg_names::kWritingModeAttr,
    html_names::kWritingsuggestionsAttr,
    svg_names::kXAttr,
    svg_names::kX1Attr,
    svg_names::kX2Attr,
    svg_names::kXChannelSelectorAttr,
    svg_names::kYAttr,
    svg_names::kY1Attr,
    svg_names::kY2Attr,
    svg_names::kYChannelSelectorAttr,
    svg_names::kZAttr,
    svg_names::kZoomAndPanAttr,
    xlink_names::kHrefAttr,
    xlink_names::kRoleAttr,
    xml_names::kLangAttr,
    xlink_names::kTypeAttr,
    xlink_names::kTitleAttr,
    xlink_names::kActuateAttr,
    xmlns_names::kXmlnsAttr,
    xlink_names::kArcroleAttr,
    xml_names::kSpaceAttr,
    xlink_names::kShowAttr,
  },
  /* removeAttributes */ HashSet<QualifiedName> {
  },
/* comments */ false,
/* dataAttributes */ false

);
return sanitizer;
}
}  // namespace sanitizer_generated_builtins
}  // namespace blink
