// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/element_type_helpers.h.tmpl
// and input files:
//   ../../third_party/blink/renderer/core/mathml/mathml_tag_names.json5


#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_MATHML_ELEMENT_TYPE_HELPERS_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_MATHML_ELEMENT_TYPE_HELPERS_H_

#include "third_party/blink/renderer/core/mathml/mathml_element.h"
#include "third_party/blink/renderer/core/mathml_names.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {

class Document;

// Type checking.
class MathMLFractionElement;
template <>
struct DowncastTraits<MathMLFractionElement> {
  // AllowFrom(const MathMLElement&) and AllowFrom(const Element&)
  // have the same code, but the MathMLElement ones are a little
  // more efficient because of the
  // MathMLElement::HasTagName(const MathMLQualifiedName&)
  // override.
  static bool AllowFrom(const MathMLElement& element) {
    return element.HasTagName(mathml_names::kMfracTag);
  }
  static bool AllowFrom(const Element& element) {
    return element.HasTagName(mathml_names::kMfracTag);
  }
  // Force this helper to only be instantiated when used. Otherwise, the
  // `IsA<...>` calls will always trigger a build failure since
  // MathMLFractionElement is forward declared and not included.
  template <typename T = MathMLFractionElement>
  static bool AllowFrom(const Node& node) {
    // UnsafeTo<> is safe because Is*Element(), by definition, only returns
    // true if `node` is derived from `Element`.
    return node.IsMathMLElement() && IsA<MathMLFractionElement>(UnsafeTo<MathMLElement>(node));
  }
};

class MathMLOperatorElement;
template <>
struct DowncastTraits<MathMLOperatorElement> {
  // AllowFrom(const MathMLElement&) and AllowFrom(const Element&)
  // have the same code, but the MathMLElement ones are a little
  // more efficient because of the
  // MathMLElement::HasTagName(const MathMLQualifiedName&)
  // override.
  static bool AllowFrom(const MathMLElement& element) {
    return element.HasTagName(mathml_names::kMoTag);
  }
  static bool AllowFrom(const Element& element) {
    return element.HasTagName(mathml_names::kMoTag);
  }
  // Force this helper to only be instantiated when used. Otherwise, the
  // `IsA<...>` calls will always trigger a build failure since
  // MathMLOperatorElement is forward declared and not included.
  template <typename T = MathMLOperatorElement>
  static bool AllowFrom(const Node& node) {
    // UnsafeTo<> is safe because Is*Element(), by definition, only returns
    // true if `node` is derived from `Element`.
    return node.IsMathMLElement() && IsA<MathMLOperatorElement>(UnsafeTo<MathMLElement>(node));
  }
};

class MathMLPaddedElement;
template <>
struct DowncastTraits<MathMLPaddedElement> {
  // AllowFrom(const MathMLElement&) and AllowFrom(const Element&)
  // have the same code, but the MathMLElement ones are a little
  // more efficient because of the
  // MathMLElement::HasTagName(const MathMLQualifiedName&)
  // override.
  static bool AllowFrom(const MathMLElement& element) {
    return element.HasTagName(mathml_names::kMpaddedTag);
  }
  static bool AllowFrom(const Element& element) {
    return element.HasTagName(mathml_names::kMpaddedTag);
  }
  // Force this helper to only be instantiated when used. Otherwise, the
  // `IsA<...>` calls will always trigger a build failure since
  // MathMLPaddedElement is forward declared and not included.
  template <typename T = MathMLPaddedElement>
  static bool AllowFrom(const Node& node) {
    // UnsafeTo<> is safe because Is*Element(), by definition, only returns
    // true if `node` is derived from `Element`.
    return node.IsMathMLElement() && IsA<MathMLPaddedElement>(UnsafeTo<MathMLElement>(node));
  }
};

class MathMLSpaceElement;
template <>
struct DowncastTraits<MathMLSpaceElement> {
  // AllowFrom(const MathMLElement&) and AllowFrom(const Element&)
  // have the same code, but the MathMLElement ones are a little
  // more efficient because of the
  // MathMLElement::HasTagName(const MathMLQualifiedName&)
  // override.
  static bool AllowFrom(const MathMLElement& element) {
    return element.HasTagName(mathml_names::kMspaceTag);
  }
  static bool AllowFrom(const Element& element) {
    return element.HasTagName(mathml_names::kMspaceTag);
  }
  // Force this helper to only be instantiated when used. Otherwise, the
  // `IsA<...>` calls will always trigger a build failure since
  // MathMLSpaceElement is forward declared and not included.
  template <typename T = MathMLSpaceElement>
  static bool AllowFrom(const Node& node) {
    // UnsafeTo<> is safe because Is*Element(), by definition, only returns
    // true if `node` is derived from `Element`.
    return node.IsMathMLElement() && IsA<MathMLSpaceElement>(UnsafeTo<MathMLElement>(node));
  }
};

class MathMLTableCellElement;
template <>
struct DowncastTraits<MathMLTableCellElement> {
  // AllowFrom(const MathMLElement&) and AllowFrom(const Element&)
  // have the same code, but the MathMLElement ones are a little
  // more efficient because of the
  // MathMLElement::HasTagName(const MathMLQualifiedName&)
  // override.
  static bool AllowFrom(const MathMLElement& element) {
    return element.HasTagName(mathml_names::kMtdTag);
  }
  static bool AllowFrom(const Element& element) {
    return element.HasTagName(mathml_names::kMtdTag);
  }
  // Force this helper to only be instantiated when used. Otherwise, the
  // `IsA<...>` calls will always trigger a build failure since
  // MathMLTableCellElement is forward declared and not included.
  template <typename T = MathMLTableCellElement>
  static bool AllowFrom(const Node& node) {
    // UnsafeTo<> is safe because Is*Element(), by definition, only returns
    // true if `node` is derived from `Element`.
    return node.IsMathMLElement() && IsA<MathMLTableCellElement>(UnsafeTo<MathMLElement>(node));
  }
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_MATHML_ELEMENT_TYPE_HELPERS_H_
