// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_WebAudio_h
#define blink_protocol_WebAudio_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace blink {
namespace protocol {
namespace WebAudio {
using GraphObjectId = String;
using ContextType = String;
using ContextState = String;
using NodeType = String;
using ChannelCountMode = String;
using ChannelInterpretation = String;
using ParamType = String;
using AutomationRate = String;
class ContextRealtimeData;
class BaseAudioContext;
class AudioListener;
class AudioNode;
class AudioParam;

// ------------- Forward and enum declarations.

namespace ContextTypeEnum {
CORE_EXPORT extern const char Realtime[];
CORE_EXPORT extern const char Offline[];
} // namespace ContextTypeEnum

namespace ContextStateEnum {
CORE_EXPORT extern const char Suspended[];
CORE_EXPORT extern const char Running[];
CORE_EXPORT extern const char Closed[];
CORE_EXPORT extern const char Interrupted[];
} // namespace ContextStateEnum

namespace ChannelCountModeEnum {
CORE_EXPORT extern const char ClampedMax[];
CORE_EXPORT extern const char Explicit[];
CORE_EXPORT extern const char Max[];
} // namespace ChannelCountModeEnum

namespace ChannelInterpretationEnum {
CORE_EXPORT extern const char Discrete[];
CORE_EXPORT extern const char Speakers[];
} // namespace ChannelInterpretationEnum

namespace AutomationRateEnum {
CORE_EXPORT extern const char ARate[];
CORE_EXPORT extern const char KRate[];
} // namespace AutomationRateEnum

// ------------- Type and builder declarations.

class CORE_EXPORT ContextRealtimeData : public ::crdtp::ProtocolObject<ContextRealtimeData> {
public:
    ~ContextRealtimeData() override { }

    double getCurrentTime() { return m_currentTime; }
    void setCurrentTime(double value) { m_currentTime = value; }

    double getRenderCapacity() { return m_renderCapacity; }
    void setRenderCapacity(double value) { m_renderCapacity = value; }

    double getCallbackIntervalMean() { return m_callbackIntervalMean; }
    void setCallbackIntervalMean(double value) { m_callbackIntervalMean = value; }

    double getCallbackIntervalVariance() { return m_callbackIntervalVariance; }
    void setCallbackIntervalVariance(double value) { m_callbackIntervalVariance = value; }

    template<int STATE>
    class ContextRealtimeDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CurrentTimeSet = 1 << 1,
            RenderCapacitySet = 1 << 2,
            CallbackIntervalMeanSet = 1 << 3,
            CallbackIntervalVarianceSet = 1 << 4,
            AllFieldsSet = (CurrentTimeSet | RenderCapacitySet | CallbackIntervalMeanSet | CallbackIntervalVarianceSet | 0)};


        ContextRealtimeDataBuilder<STATE | CurrentTimeSet>& setCurrentTime(double value)
        {
            static_assert(!(STATE & CurrentTimeSet), "property currentTime should not be set yet");
            m_result->setCurrentTime(value);
            return castState<CurrentTimeSet>();
        }

        ContextRealtimeDataBuilder<STATE | RenderCapacitySet>& setRenderCapacity(double value)
        {
            static_assert(!(STATE & RenderCapacitySet), "property renderCapacity should not be set yet");
            m_result->setRenderCapacity(value);
            return castState<RenderCapacitySet>();
        }

        ContextRealtimeDataBuilder<STATE | CallbackIntervalMeanSet>& setCallbackIntervalMean(double value)
        {
            static_assert(!(STATE & CallbackIntervalMeanSet), "property callbackIntervalMean should not be set yet");
            m_result->setCallbackIntervalMean(value);
            return castState<CallbackIntervalMeanSet>();
        }

        ContextRealtimeDataBuilder<STATE | CallbackIntervalVarianceSet>& setCallbackIntervalVariance(double value)
        {
            static_assert(!(STATE & CallbackIntervalVarianceSet), "property callbackIntervalVariance should not be set yet");
            m_result->setCallbackIntervalVariance(value);
            return castState<CallbackIntervalVarianceSet>();
        }

        std::unique_ptr<ContextRealtimeData> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContextRealtimeData;
        ContextRealtimeDataBuilder() : m_result(new ContextRealtimeData()) { }

        template<int STEP> ContextRealtimeDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContextRealtimeDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::WebAudio::ContextRealtimeData> m_result;
    };

    static ContextRealtimeDataBuilder<0> create()
    {
        return ContextRealtimeDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContextRealtimeData()
    {
          m_currentTime = 0;
          m_renderCapacity = 0;
          m_callbackIntervalMean = 0;
          m_callbackIntervalVariance = 0;
    }

    double m_currentTime;
    double m_renderCapacity;
    double m_callbackIntervalMean;
    double m_callbackIntervalVariance;
};


class CORE_EXPORT BaseAudioContext : public ::crdtp::ProtocolObject<BaseAudioContext> {
public:
    ~BaseAudioContext() override { }

    String getContextId() { return m_contextId; }
    void setContextId(const String& value) { m_contextId = value; }

    String getContextType() { return m_contextType; }
    void setContextType(const String& value) { m_contextType = value; }

    String getContextState() { return m_contextState; }
    void setContextState(const String& value) { m_contextState = value; }

    bool hasRealtimeData() { return !!m_realtimeData; }
    protocol::WebAudio::ContextRealtimeData* getRealtimeData(protocol::WebAudio::ContextRealtimeData* defaultValue) {
       return m_realtimeData ? m_realtimeData.get() : defaultValue;
    }
    const std::unique_ptr<protocol::WebAudio::ContextRealtimeData>& getRealtimeData() const {
       return m_realtimeData;
    }
    void setRealtimeData(std::unique_ptr<protocol::WebAudio::ContextRealtimeData> value) { m_realtimeData = std::move(value); }

    double getCallbackBufferSize() { return m_callbackBufferSize; }
    void setCallbackBufferSize(double value) { m_callbackBufferSize = value; }

    double getMaxOutputChannelCount() { return m_maxOutputChannelCount; }
    void setMaxOutputChannelCount(double value) { m_maxOutputChannelCount = value; }

    double getSampleRate() { return m_sampleRate; }
    void setSampleRate(double value) { m_sampleRate = value; }

    template<int STATE>
    class BaseAudioContextBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ContextIdSet = 1 << 1,
            ContextTypeSet = 1 << 2,
            ContextStateSet = 1 << 3,
            CallbackBufferSizeSet = 1 << 4,
            MaxOutputChannelCountSet = 1 << 5,
            SampleRateSet = 1 << 6,
            AllFieldsSet = (ContextIdSet | ContextTypeSet | ContextStateSet | CallbackBufferSizeSet | MaxOutputChannelCountSet | SampleRateSet | 0)};


        BaseAudioContextBuilder<STATE | ContextIdSet>& setContextId(const String& value)
        {
            static_assert(!(STATE & ContextIdSet), "property contextId should not be set yet");
            m_result->setContextId(value);
            return castState<ContextIdSet>();
        }

        BaseAudioContextBuilder<STATE | ContextTypeSet>& setContextType(const String& value)
        {
            static_assert(!(STATE & ContextTypeSet), "property contextType should not be set yet");
            m_result->setContextType(value);
            return castState<ContextTypeSet>();
        }

        BaseAudioContextBuilder<STATE | ContextStateSet>& setContextState(const String& value)
        {
            static_assert(!(STATE & ContextStateSet), "property contextState should not be set yet");
            m_result->setContextState(value);
            return castState<ContextStateSet>();
        }

        BaseAudioContextBuilder<STATE>& setRealtimeData(std::unique_ptr<protocol::WebAudio::ContextRealtimeData> value)
        {
            m_result->setRealtimeData(std::move(value));
            return *this;
        }

        BaseAudioContextBuilder<STATE | CallbackBufferSizeSet>& setCallbackBufferSize(double value)
        {
            static_assert(!(STATE & CallbackBufferSizeSet), "property callbackBufferSize should not be set yet");
            m_result->setCallbackBufferSize(value);
            return castState<CallbackBufferSizeSet>();
        }

        BaseAudioContextBuilder<STATE | MaxOutputChannelCountSet>& setMaxOutputChannelCount(double value)
        {
            static_assert(!(STATE & MaxOutputChannelCountSet), "property maxOutputChannelCount should not be set yet");
            m_result->setMaxOutputChannelCount(value);
            return castState<MaxOutputChannelCountSet>();
        }

        BaseAudioContextBuilder<STATE | SampleRateSet>& setSampleRate(double value)
        {
            static_assert(!(STATE & SampleRateSet), "property sampleRate should not be set yet");
            m_result->setSampleRate(value);
            return castState<SampleRateSet>();
        }

        std::unique_ptr<BaseAudioContext> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BaseAudioContext;
        BaseAudioContextBuilder() : m_result(new BaseAudioContext()) { }

        template<int STEP> BaseAudioContextBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BaseAudioContextBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::WebAudio::BaseAudioContext> m_result;
    };

    static BaseAudioContextBuilder<0> create()
    {
        return BaseAudioContextBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BaseAudioContext()
    {
          m_callbackBufferSize = 0;
          m_maxOutputChannelCount = 0;
          m_sampleRate = 0;
    }

    String m_contextId;
    String m_contextType;
    String m_contextState;
    std::unique_ptr<protocol::WebAudio::ContextRealtimeData> m_realtimeData;
    double m_callbackBufferSize;
    double m_maxOutputChannelCount;
    double m_sampleRate;
};


class CORE_EXPORT AudioListener : public ::crdtp::ProtocolObject<AudioListener> {
public:
    ~AudioListener() override { }

    String getListenerId() { return m_listenerId; }
    void setListenerId(const String& value) { m_listenerId = value; }

    String getContextId() { return m_contextId; }
    void setContextId(const String& value) { m_contextId = value; }

    template<int STATE>
    class AudioListenerBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ListenerIdSet = 1 << 1,
            ContextIdSet = 1 << 2,
            AllFieldsSet = (ListenerIdSet | ContextIdSet | 0)};


        AudioListenerBuilder<STATE | ListenerIdSet>& setListenerId(const String& value)
        {
            static_assert(!(STATE & ListenerIdSet), "property listenerId should not be set yet");
            m_result->setListenerId(value);
            return castState<ListenerIdSet>();
        }

        AudioListenerBuilder<STATE | ContextIdSet>& setContextId(const String& value)
        {
            static_assert(!(STATE & ContextIdSet), "property contextId should not be set yet");
            m_result->setContextId(value);
            return castState<ContextIdSet>();
        }

        std::unique_ptr<AudioListener> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AudioListener;
        AudioListenerBuilder() : m_result(new AudioListener()) { }

        template<int STEP> AudioListenerBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AudioListenerBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::WebAudio::AudioListener> m_result;
    };

    static AudioListenerBuilder<0> create()
    {
        return AudioListenerBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AudioListener()
    {
    }

    String m_listenerId;
    String m_contextId;
};


class CORE_EXPORT AudioNode : public ::crdtp::ProtocolObject<AudioNode> {
public:
    ~AudioNode() override { }

    String getNodeId() { return m_nodeId; }
    void setNodeId(const String& value) { m_nodeId = value; }

    String getContextId() { return m_contextId; }
    void setContextId(const String& value) { m_contextId = value; }

    String getNodeType() { return m_nodeType; }
    void setNodeType(const String& value) { m_nodeType = value; }

    double getNumberOfInputs() { return m_numberOfInputs; }
    void setNumberOfInputs(double value) { m_numberOfInputs = value; }

    double getNumberOfOutputs() { return m_numberOfOutputs; }
    void setNumberOfOutputs(double value) { m_numberOfOutputs = value; }

    double getChannelCount() { return m_channelCount; }
    void setChannelCount(double value) { m_channelCount = value; }

    String getChannelCountMode() { return m_channelCountMode; }
    void setChannelCountMode(const String& value) { m_channelCountMode = value; }

    String getChannelInterpretation() { return m_channelInterpretation; }
    void setChannelInterpretation(const String& value) { m_channelInterpretation = value; }

    template<int STATE>
    class AudioNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeIdSet = 1 << 1,
            ContextIdSet = 1 << 2,
            NodeTypeSet = 1 << 3,
            NumberOfInputsSet = 1 << 4,
            NumberOfOutputsSet = 1 << 5,
            ChannelCountSet = 1 << 6,
            ChannelCountModeSet = 1 << 7,
            ChannelInterpretationSet = 1 << 8,
            AllFieldsSet = (NodeIdSet | ContextIdSet | NodeTypeSet | NumberOfInputsSet | NumberOfOutputsSet | ChannelCountSet | ChannelCountModeSet | ChannelInterpretationSet | 0)};


        AudioNodeBuilder<STATE | NodeIdSet>& setNodeId(const String& value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        AudioNodeBuilder<STATE | ContextIdSet>& setContextId(const String& value)
        {
            static_assert(!(STATE & ContextIdSet), "property contextId should not be set yet");
            m_result->setContextId(value);
            return castState<ContextIdSet>();
        }

        AudioNodeBuilder<STATE | NodeTypeSet>& setNodeType(const String& value)
        {
            static_assert(!(STATE & NodeTypeSet), "property nodeType should not be set yet");
            m_result->setNodeType(value);
            return castState<NodeTypeSet>();
        }

        AudioNodeBuilder<STATE | NumberOfInputsSet>& setNumberOfInputs(double value)
        {
            static_assert(!(STATE & NumberOfInputsSet), "property numberOfInputs should not be set yet");
            m_result->setNumberOfInputs(value);
            return castState<NumberOfInputsSet>();
        }

        AudioNodeBuilder<STATE | NumberOfOutputsSet>& setNumberOfOutputs(double value)
        {
            static_assert(!(STATE & NumberOfOutputsSet), "property numberOfOutputs should not be set yet");
            m_result->setNumberOfOutputs(value);
            return castState<NumberOfOutputsSet>();
        }

        AudioNodeBuilder<STATE | ChannelCountSet>& setChannelCount(double value)
        {
            static_assert(!(STATE & ChannelCountSet), "property channelCount should not be set yet");
            m_result->setChannelCount(value);
            return castState<ChannelCountSet>();
        }

        AudioNodeBuilder<STATE | ChannelCountModeSet>& setChannelCountMode(const String& value)
        {
            static_assert(!(STATE & ChannelCountModeSet), "property channelCountMode should not be set yet");
            m_result->setChannelCountMode(value);
            return castState<ChannelCountModeSet>();
        }

        AudioNodeBuilder<STATE | ChannelInterpretationSet>& setChannelInterpretation(const String& value)
        {
            static_assert(!(STATE & ChannelInterpretationSet), "property channelInterpretation should not be set yet");
            m_result->setChannelInterpretation(value);
            return castState<ChannelInterpretationSet>();
        }

        std::unique_ptr<AudioNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AudioNode;
        AudioNodeBuilder() : m_result(new AudioNode()) { }

        template<int STEP> AudioNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AudioNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::WebAudio::AudioNode> m_result;
    };

    static AudioNodeBuilder<0> create()
    {
        return AudioNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AudioNode()
    {
          m_numberOfInputs = 0;
          m_numberOfOutputs = 0;
          m_channelCount = 0;
    }

    String m_nodeId;
    String m_contextId;
    String m_nodeType;
    double m_numberOfInputs;
    double m_numberOfOutputs;
    double m_channelCount;
    String m_channelCountMode;
    String m_channelInterpretation;
};


class CORE_EXPORT AudioParam : public ::crdtp::ProtocolObject<AudioParam> {
public:
    ~AudioParam() override { }

    String getParamId() { return m_paramId; }
    void setParamId(const String& value) { m_paramId = value; }

    String getNodeId() { return m_nodeId; }
    void setNodeId(const String& value) { m_nodeId = value; }

    String getContextId() { return m_contextId; }
    void setContextId(const String& value) { m_contextId = value; }

    String getParamType() { return m_paramType; }
    void setParamType(const String& value) { m_paramType = value; }

    String getRate() { return m_rate; }
    void setRate(const String& value) { m_rate = value; }

    double getDefaultValue() { return m_defaultValue; }
    void setDefaultValue(double value) { m_defaultValue = value; }

    double getMinValue() { return m_minValue; }
    void setMinValue(double value) { m_minValue = value; }

    double getMaxValue() { return m_maxValue; }
    void setMaxValue(double value) { m_maxValue = value; }

    template<int STATE>
    class AudioParamBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ParamIdSet = 1 << 1,
            NodeIdSet = 1 << 2,
            ContextIdSet = 1 << 3,
            ParamTypeSet = 1 << 4,
            RateSet = 1 << 5,
            DefaultValueSet = 1 << 6,
            MinValueSet = 1 << 7,
            MaxValueSet = 1 << 8,
            AllFieldsSet = (ParamIdSet | NodeIdSet | ContextIdSet | ParamTypeSet | RateSet | DefaultValueSet | MinValueSet | MaxValueSet | 0)};


        AudioParamBuilder<STATE | ParamIdSet>& setParamId(const String& value)
        {
            static_assert(!(STATE & ParamIdSet), "property paramId should not be set yet");
            m_result->setParamId(value);
            return castState<ParamIdSet>();
        }

        AudioParamBuilder<STATE | NodeIdSet>& setNodeId(const String& value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        AudioParamBuilder<STATE | ContextIdSet>& setContextId(const String& value)
        {
            static_assert(!(STATE & ContextIdSet), "property contextId should not be set yet");
            m_result->setContextId(value);
            return castState<ContextIdSet>();
        }

        AudioParamBuilder<STATE | ParamTypeSet>& setParamType(const String& value)
        {
            static_assert(!(STATE & ParamTypeSet), "property paramType should not be set yet");
            m_result->setParamType(value);
            return castState<ParamTypeSet>();
        }

        AudioParamBuilder<STATE | RateSet>& setRate(const String& value)
        {
            static_assert(!(STATE & RateSet), "property rate should not be set yet");
            m_result->setRate(value);
            return castState<RateSet>();
        }

        AudioParamBuilder<STATE | DefaultValueSet>& setDefaultValue(double value)
        {
            static_assert(!(STATE & DefaultValueSet), "property defaultValue should not be set yet");
            m_result->setDefaultValue(value);
            return castState<DefaultValueSet>();
        }

        AudioParamBuilder<STATE | MinValueSet>& setMinValue(double value)
        {
            static_assert(!(STATE & MinValueSet), "property minValue should not be set yet");
            m_result->setMinValue(value);
            return castState<MinValueSet>();
        }

        AudioParamBuilder<STATE | MaxValueSet>& setMaxValue(double value)
        {
            static_assert(!(STATE & MaxValueSet), "property maxValue should not be set yet");
            m_result->setMaxValue(value);
            return castState<MaxValueSet>();
        }

        std::unique_ptr<AudioParam> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AudioParam;
        AudioParamBuilder() : m_result(new AudioParam()) { }

        template<int STEP> AudioParamBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AudioParamBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::WebAudio::AudioParam> m_result;
    };

    static AudioParamBuilder<0> create()
    {
        return AudioParamBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AudioParam()
    {
          m_defaultValue = 0;
          m_minValue = 0;
          m_maxValue = 0;
    }

    String m_paramId;
    String m_nodeId;
    String m_contextId;
    String m_paramType;
    String m_rate;
    double m_defaultValue;
    double m_minValue;
    double m_maxValue;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse getRealtimeData(const String& in_contextId, std::unique_ptr<protocol::WebAudio::ContextRealtimeData>* out_realtimeData) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void contextCreated(std::unique_ptr<protocol::WebAudio::BaseAudioContext> context);
    void contextWillBeDestroyed(const String& contextId);
    void contextChanged(std::unique_ptr<protocol::WebAudio::BaseAudioContext> context);
    void audioListenerCreated(std::unique_ptr<protocol::WebAudio::AudioListener> listener);
    void audioListenerWillBeDestroyed(const String& contextId, const String& listenerId);
    void audioNodeCreated(std::unique_ptr<protocol::WebAudio::AudioNode> node);
    void audioNodeWillBeDestroyed(const String& contextId, const String& nodeId);
    void audioParamCreated(std::unique_ptr<protocol::WebAudio::AudioParam> param);
    void audioParamWillBeDestroyed(const String& contextId, const String& nodeId, const String& paramId);
    void nodesConnected(const String& contextId, const String& sourceId, const String& destinationId, std::optional<double> sourceOutputIndex = {}, std::optional<double> destinationInputIndex = {});
    void nodesDisconnected(const String& contextId, const String& sourceId, const String& destinationId, std::optional<double> sourceOutputIndex = {}, std::optional<double> destinationInputIndex = {});
    void nodeParamConnected(const String& contextId, const String& sourceId, const String& destinationId, std::optional<double> sourceOutputIndex = {});
    void nodeParamDisconnected(const String& contextId, const String& sourceId, const String& destinationId, std::optional<double> sourceOutputIndex = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace WebAudio
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_WebAudio_h)
