// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/storage.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Storage {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Storage";
const char Metainfo::commandPrefix[] = "Storage.";
const char Metainfo::version[] = "1.3";


namespace StorageTypeEnum {
const char Cookies[] = "cookies";
const char File_systems[] = "file_systems";
const char Indexeddb[] = "indexeddb";
const char Local_storage[] = "local_storage";
const char Shader_cache[] = "shader_cache";
const char Websql[] = "websql";
const char Service_workers[] = "service_workers";
const char Cache_storage[] = "cache_storage";
const char Interest_groups[] = "interest_groups";
const char Shared_storage[] = "shared_storage";
const char Storage_buckets[] = "storage_buckets";
const char All[] = "all";
const char Other[] = "other";
} // namespace StorageTypeEnum


CRDTP_BEGIN_DESERIALIZER(UsageForType)
    CRDTP_DESERIALIZE_FIELD("storageType", m_storageType),
    CRDTP_DESERIALIZE_FIELD("usage", m_usage),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(UsageForType)
    CRDTP_SERIALIZE_FIELD("storageType", m_storageType);
    CRDTP_SERIALIZE_FIELD("usage", m_usage);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(TrustTokens)
    CRDTP_DESERIALIZE_FIELD("count", m_count),
    CRDTP_DESERIALIZE_FIELD("issuerOrigin", m_issuerOrigin),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(TrustTokens)
    CRDTP_SERIALIZE_FIELD("issuerOrigin", m_issuerOrigin);
    CRDTP_SERIALIZE_FIELD("count", m_count);
CRDTP_END_SERIALIZER();



namespace InterestGroupAccessTypeEnum {
const char Join[] = "join";
const char Leave[] = "leave";
const char Update[] = "update";
const char Loaded[] = "loaded";
const char Bid[] = "bid";
const char Win[] = "win";
const char AdditionalBid[] = "additionalBid";
const char AdditionalBidWin[] = "additionalBidWin";
const char TopLevelBid[] = "topLevelBid";
const char TopLevelAdditionalBid[] = "topLevelAdditionalBid";
const char Clear[] = "clear";
} // namespace InterestGroupAccessTypeEnum


namespace InterestGroupAuctionEventTypeEnum {
const char Started[] = "started";
const char ConfigResolved[] = "configResolved";
} // namespace InterestGroupAuctionEventTypeEnum


namespace InterestGroupAuctionFetchTypeEnum {
const char BidderJs[] = "bidderJs";
const char BidderWasm[] = "bidderWasm";
const char SellerJs[] = "sellerJs";
const char BidderTrustedSignals[] = "bidderTrustedSignals";
const char SellerTrustedSignals[] = "sellerTrustedSignals";
} // namespace InterestGroupAuctionFetchTypeEnum


namespace SharedStorageAccessScopeEnum {
const char Window[] = "window";
const char SharedStorageWorklet[] = "sharedStorageWorklet";
const char ProtectedAudienceWorklet[] = "protectedAudienceWorklet";
const char Header[] = "header";
} // namespace SharedStorageAccessScopeEnum


namespace SharedStorageAccessMethodEnum {
const char AddModule[] = "addModule";
const char CreateWorklet[] = "createWorklet";
const char SelectURL[] = "selectURL";
const char Run[] = "run";
const char BatchUpdate[] = "batchUpdate";
const char Set[] = "set";
const char Append[] = "append";
const char Delete[] = "delete";
const char Clear[] = "clear";
const char Get[] = "get";
const char Keys[] = "keys";
const char Values[] = "values";
const char Entries[] = "entries";
const char Length[] = "length";
const char RemainingBudget[] = "remainingBudget";
} // namespace SharedStorageAccessMethodEnum


CRDTP_BEGIN_DESERIALIZER(SharedStorageEntry)
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStorageEntry)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SharedStorageMetadata)
    CRDTP_DESERIALIZE_FIELD("bytesUsed", m_bytesUsed),
    CRDTP_DESERIALIZE_FIELD("creationTime", m_creationTime),
    CRDTP_DESERIALIZE_FIELD("length", m_length),
    CRDTP_DESERIALIZE_FIELD("remainingBudget", m_remainingBudget),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStorageMetadata)
    CRDTP_SERIALIZE_FIELD("creationTime", m_creationTime);
    CRDTP_SERIALIZE_FIELD("length", m_length);
    CRDTP_SERIALIZE_FIELD("remainingBudget", m_remainingBudget);
    CRDTP_SERIALIZE_FIELD("bytesUsed", m_bytesUsed);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SharedStoragePrivateAggregationConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("contextId", m_contextId),
    CRDTP_DESERIALIZE_FIELD("filteringIdMaxBytes", m_filteringIdMaxBytes),
    CRDTP_DESERIALIZE_FIELD_OPT("maxContributions", m_maxContributions),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStoragePrivateAggregationConfig)
    CRDTP_SERIALIZE_FIELD("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin);
    CRDTP_SERIALIZE_FIELD("contextId", m_contextId);
    CRDTP_SERIALIZE_FIELD("filteringIdMaxBytes", m_filteringIdMaxBytes);
    CRDTP_SERIALIZE_FIELD("maxContributions", m_maxContributions);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SharedStorageReportingMetadata)
    CRDTP_DESERIALIZE_FIELD("eventType", m_eventType),
    CRDTP_DESERIALIZE_FIELD("reportingUrl", m_reportingUrl),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStorageReportingMetadata)
    CRDTP_SERIALIZE_FIELD("eventType", m_eventType);
    CRDTP_SERIALIZE_FIELD("reportingUrl", m_reportingUrl);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SharedStorageUrlWithMetadata)
    CRDTP_DESERIALIZE_FIELD("reportingMetadata", m_reportingMetadata),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStorageUrlWithMetadata)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("reportingMetadata", m_reportingMetadata);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SharedStorageAccessParams)
    CRDTP_DESERIALIZE_FIELD_OPT("batchSize", m_batchSize),
    CRDTP_DESERIALIZE_FIELD_OPT("batchUpdateId", m_batchUpdateId),
    CRDTP_DESERIALIZE_FIELD_OPT("dataOrigin", m_dataOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("ignoreIfPresent", m_ignoreIfPresent),
    CRDTP_DESERIALIZE_FIELD_OPT("keepAlive", m_keepAlive),
    CRDTP_DESERIALIZE_FIELD_OPT("key", m_key),
    CRDTP_DESERIALIZE_FIELD_OPT("operationId", m_operationId),
    CRDTP_DESERIALIZE_FIELD_OPT("operationName", m_operationName),
    CRDTP_DESERIALIZE_FIELD_OPT("privateAggregationConfig", m_privateAggregationConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("scriptSourceUrl", m_scriptSourceUrl),
    CRDTP_DESERIALIZE_FIELD_OPT("serializedData", m_serializedData),
    CRDTP_DESERIALIZE_FIELD_OPT("urlsWithMetadata", m_urlsWithMetadata),
    CRDTP_DESERIALIZE_FIELD_OPT("urnUuid", m_urnUuid),
    CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    CRDTP_DESERIALIZE_FIELD_OPT("withLock", m_withLock),
    CRDTP_DESERIALIZE_FIELD_OPT("workletOrdinal", m_workletOrdinal),
    CRDTP_DESERIALIZE_FIELD_OPT("workletTargetId", m_workletTargetId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStorageAccessParams)
    CRDTP_SERIALIZE_FIELD("scriptSourceUrl", m_scriptSourceUrl);
    CRDTP_SERIALIZE_FIELD("dataOrigin", m_dataOrigin);
    CRDTP_SERIALIZE_FIELD("operationName", m_operationName);
    CRDTP_SERIALIZE_FIELD("operationId", m_operationId);
    CRDTP_SERIALIZE_FIELD("keepAlive", m_keepAlive);
    CRDTP_SERIALIZE_FIELD("privateAggregationConfig", m_privateAggregationConfig);
    CRDTP_SERIALIZE_FIELD("serializedData", m_serializedData);
    CRDTP_SERIALIZE_FIELD("urlsWithMetadata", m_urlsWithMetadata);
    CRDTP_SERIALIZE_FIELD("urnUuid", m_urnUuid);
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("ignoreIfPresent", m_ignoreIfPresent);
    CRDTP_SERIALIZE_FIELD("workletOrdinal", m_workletOrdinal);
    CRDTP_SERIALIZE_FIELD("workletTargetId", m_workletTargetId);
    CRDTP_SERIALIZE_FIELD("withLock", m_withLock);
    CRDTP_SERIALIZE_FIELD("batchUpdateId", m_batchUpdateId);
    CRDTP_SERIALIZE_FIELD("batchSize", m_batchSize);
CRDTP_END_SERIALIZER();


namespace StorageBucketsDurabilityEnum {
const char Relaxed[] = "relaxed";
const char Strict[] = "strict";
} // namespace StorageBucketsDurabilityEnum


CRDTP_BEGIN_DESERIALIZER(StorageBucket)
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
    CRDTP_DESERIALIZE_FIELD("storageKey", m_storageKey),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StorageBucket)
    CRDTP_SERIALIZE_FIELD("storageKey", m_storageKey);
    CRDTP_SERIALIZE_FIELD("name", m_name);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(StorageBucketInfo)
    CRDTP_DESERIALIZE_FIELD("bucket", m_bucket),
    CRDTP_DESERIALIZE_FIELD("durability", m_durability),
    CRDTP_DESERIALIZE_FIELD("expiration", m_expiration),
    CRDTP_DESERIALIZE_FIELD("id", m_id),
    CRDTP_DESERIALIZE_FIELD("persistent", m_persistent),
    CRDTP_DESERIALIZE_FIELD("quota", m_quota),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StorageBucketInfo)
    CRDTP_SERIALIZE_FIELD("bucket", m_bucket);
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("expiration", m_expiration);
    CRDTP_SERIALIZE_FIELD("quota", m_quota);
    CRDTP_SERIALIZE_FIELD("persistent", m_persistent);
    CRDTP_SERIALIZE_FIELD("durability", m_durability);
CRDTP_END_SERIALIZER();


namespace AttributionReportingSourceTypeEnum {
const char Navigation[] = "navigation";
const char Event[] = "event";
} // namespace AttributionReportingSourceTypeEnum





CRDTP_BEGIN_DESERIALIZER(AttributionReportingFilterDataEntry)
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("values", m_values),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingFilterDataEntry)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("values", m_values);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingFilterConfig)
    CRDTP_DESERIALIZE_FIELD("filterValues", m_filterValues),
    CRDTP_DESERIALIZE_FIELD_OPT("lookbackWindow", m_lookbackWindow),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingFilterConfig)
    CRDTP_SERIALIZE_FIELD("filterValues", m_filterValues);
    CRDTP_SERIALIZE_FIELD("lookbackWindow", m_lookbackWindow);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingFilterPair)
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("notFilters", m_notFilters),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingFilterPair)
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
    CRDTP_SERIALIZE_FIELD("notFilters", m_notFilters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregationKeysEntry)
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregationKeysEntry)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingEventReportWindows)
    CRDTP_DESERIALIZE_FIELD("ends", m_ends),
    CRDTP_DESERIALIZE_FIELD("start", m_start),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingEventReportWindows)
    CRDTP_SERIALIZE_FIELD("start", m_start);
    CRDTP_SERIALIZE_FIELD("ends", m_ends);
CRDTP_END_SERIALIZER();


namespace AttributionReportingTriggerDataMatchingEnum {
const char Exact[] = "exact";
const char Modulus[] = "modulus";
} // namespace AttributionReportingTriggerDataMatchingEnum


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableDebugReportingData)
    CRDTP_DESERIALIZE_FIELD("keyPiece", m_keyPiece),
    CRDTP_DESERIALIZE_FIELD("types", m_types),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableDebugReportingData)
    CRDTP_SERIALIZE_FIELD("keyPiece", m_keyPiece);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("types", m_types);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableDebugReportingConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("budget", m_budget),
    CRDTP_DESERIALIZE_FIELD("debugData", m_debugData),
    CRDTP_DESERIALIZE_FIELD("keyPiece", m_keyPiece),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableDebugReportingConfig)
    CRDTP_SERIALIZE_FIELD("budget", m_budget);
    CRDTP_SERIALIZE_FIELD("keyPiece", m_keyPiece);
    CRDTP_SERIALIZE_FIELD("debugData", m_debugData);
    CRDTP_SERIALIZE_FIELD("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionScopesData)
    CRDTP_DESERIALIZE_FIELD("limit", m_limit),
    CRDTP_DESERIALIZE_FIELD("maxEventStates", m_maxEventStates),
    CRDTP_DESERIALIZE_FIELD("values", m_values),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionScopesData)
    CRDTP_SERIALIZE_FIELD("values", m_values);
    CRDTP_SERIALIZE_FIELD("limit", m_limit);
    CRDTP_SERIALIZE_FIELD("maxEventStates", m_maxEventStates);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingNamedBudgetDef)
    CRDTP_DESERIALIZE_FIELD("budget", m_budget),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingNamedBudgetDef)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("budget", m_budget);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingSourceRegistration)
    CRDTP_DESERIALIZE_FIELD("aggregatableDebugReportingConfig", m_aggregatableDebugReportingConfig),
    CRDTP_DESERIALIZE_FIELD("aggregatableReportWindow", m_aggregatableReportWindow),
    CRDTP_DESERIALIZE_FIELD("aggregationKeys", m_aggregationKeys),
    CRDTP_DESERIALIZE_FIELD_OPT("debugKey", m_debugKey),
    CRDTP_DESERIALIZE_FIELD("debugReporting", m_debugReporting),
    CRDTP_DESERIALIZE_FIELD("destinationLimitPriority", m_destinationLimitPriority),
    CRDTP_DESERIALIZE_FIELD("destinationSites", m_destinationSites),
    CRDTP_DESERIALIZE_FIELD("eventId", m_eventId),
    CRDTP_DESERIALIZE_FIELD("eventLevelEpsilon", m_eventLevelEpsilon),
    CRDTP_DESERIALIZE_FIELD("eventReportWindows", m_eventReportWindows),
    CRDTP_DESERIALIZE_FIELD("expiry", m_expiry),
    CRDTP_DESERIALIZE_FIELD("filterData", m_filterData),
    CRDTP_DESERIALIZE_FIELD("maxEventLevelReports", m_maxEventLevelReports),
    CRDTP_DESERIALIZE_FIELD("namedBudgets", m_namedBudgets),
    CRDTP_DESERIALIZE_FIELD("priority", m_priority),
    CRDTP_DESERIALIZE_FIELD("reportingOrigin", m_reportingOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("scopesData", m_scopesData),
    CRDTP_DESERIALIZE_FIELD("sourceOrigin", m_sourceOrigin),
    CRDTP_DESERIALIZE_FIELD("time", m_time),
    CRDTP_DESERIALIZE_FIELD("triggerData", m_triggerData),
    CRDTP_DESERIALIZE_FIELD("triggerDataMatching", m_triggerDataMatching),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingSourceRegistration)
    CRDTP_SERIALIZE_FIELD("time", m_time);
    CRDTP_SERIALIZE_FIELD("expiry", m_expiry);
    CRDTP_SERIALIZE_FIELD("triggerData", m_triggerData);
    CRDTP_SERIALIZE_FIELD("eventReportWindows", m_eventReportWindows);
    CRDTP_SERIALIZE_FIELD("aggregatableReportWindow", m_aggregatableReportWindow);
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("sourceOrigin", m_sourceOrigin);
    CRDTP_SERIALIZE_FIELD("reportingOrigin", m_reportingOrigin);
    CRDTP_SERIALIZE_FIELD("destinationSites", m_destinationSites);
    CRDTP_SERIALIZE_FIELD("eventId", m_eventId);
    CRDTP_SERIALIZE_FIELD("priority", m_priority);
    CRDTP_SERIALIZE_FIELD("filterData", m_filterData);
    CRDTP_SERIALIZE_FIELD("aggregationKeys", m_aggregationKeys);
    CRDTP_SERIALIZE_FIELD("debugKey", m_debugKey);
    CRDTP_SERIALIZE_FIELD("triggerDataMatching", m_triggerDataMatching);
    CRDTP_SERIALIZE_FIELD("destinationLimitPriority", m_destinationLimitPriority);
    CRDTP_SERIALIZE_FIELD("aggregatableDebugReportingConfig", m_aggregatableDebugReportingConfig);
    CRDTP_SERIALIZE_FIELD("scopesData", m_scopesData);
    CRDTP_SERIALIZE_FIELD("maxEventLevelReports", m_maxEventLevelReports);
    CRDTP_SERIALIZE_FIELD("namedBudgets", m_namedBudgets);
    CRDTP_SERIALIZE_FIELD("debugReporting", m_debugReporting);
    CRDTP_SERIALIZE_FIELD("eventLevelEpsilon", m_eventLevelEpsilon);
CRDTP_END_SERIALIZER();


namespace AttributionReportingSourceRegistrationResultEnum {
const char Success[] = "success";
const char InternalError[] = "internalError";
const char InsufficientSourceCapacity[] = "insufficientSourceCapacity";
const char InsufficientUniqueDestinationCapacity[] = "insufficientUniqueDestinationCapacity";
const char ExcessiveReportingOrigins[] = "excessiveReportingOrigins";
const char ProhibitedByBrowserPolicy[] = "prohibitedByBrowserPolicy";
const char SuccessNoised[] = "successNoised";
const char DestinationReportingLimitReached[] = "destinationReportingLimitReached";
const char DestinationGlobalLimitReached[] = "destinationGlobalLimitReached";
const char DestinationBothLimitsReached[] = "destinationBothLimitsReached";
const char ReportingOriginsPerSiteLimitReached[] = "reportingOriginsPerSiteLimitReached";
const char ExceedsMaxChannelCapacity[] = "exceedsMaxChannelCapacity";
const char ExceedsMaxScopesChannelCapacity[] = "exceedsMaxScopesChannelCapacity";
const char ExceedsMaxTriggerStateCardinality[] = "exceedsMaxTriggerStateCardinality";
const char ExceedsMaxEventStatesLimit[] = "exceedsMaxEventStatesLimit";
const char DestinationPerDayReportingLimitReached[] = "destinationPerDayReportingLimitReached";
} // namespace AttributionReportingSourceRegistrationResultEnum


namespace AttributionReportingSourceRegistrationTimeConfigEnum {
const char Include[] = "include";
const char Exclude[] = "exclude";
} // namespace AttributionReportingSourceRegistrationTimeConfigEnum


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableValueDictEntry)
    CRDTP_DESERIALIZE_FIELD("filteringId", m_filteringId),
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableValueDictEntry)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("filteringId", m_filteringId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableValueEntry)
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("values", m_values),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableValueEntry)
    CRDTP_SERIALIZE_FIELD("values", m_values);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingEventTriggerData)
    CRDTP_DESERIALIZE_FIELD("data", m_data),
    CRDTP_DESERIALIZE_FIELD_OPT("dedupKey", m_dedupKey),
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("priority", m_priority),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingEventTriggerData)
    CRDTP_SERIALIZE_FIELD("data", m_data);
    CRDTP_SERIALIZE_FIELD("priority", m_priority);
    CRDTP_SERIALIZE_FIELD("dedupKey", m_dedupKey);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableTriggerData)
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("keyPiece", m_keyPiece),
    CRDTP_DESERIALIZE_FIELD("sourceKeys", m_sourceKeys),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableTriggerData)
    CRDTP_SERIALIZE_FIELD("keyPiece", m_keyPiece);
    CRDTP_SERIALIZE_FIELD("sourceKeys", m_sourceKeys);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableDedupKey)
    CRDTP_DESERIALIZE_FIELD_OPT("dedupKey", m_dedupKey),
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableDedupKey)
    CRDTP_SERIALIZE_FIELD("dedupKey", m_dedupKey);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingNamedBudgetCandidate)
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingNamedBudgetCandidate)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingTriggerRegistration)
    CRDTP_DESERIALIZE_FIELD("aggregatableDebugReportingConfig", m_aggregatableDebugReportingConfig),
    CRDTP_DESERIALIZE_FIELD("aggregatableDedupKeys", m_aggregatableDedupKeys),
    CRDTP_DESERIALIZE_FIELD("aggregatableFilteringIdMaxBytes", m_aggregatableFilteringIdMaxBytes),
    CRDTP_DESERIALIZE_FIELD("aggregatableTriggerData", m_aggregatableTriggerData),
    CRDTP_DESERIALIZE_FIELD("aggregatableValues", m_aggregatableValues),
    CRDTP_DESERIALIZE_FIELD_OPT("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("debugKey", m_debugKey),
    CRDTP_DESERIALIZE_FIELD("debugReporting", m_debugReporting),
    CRDTP_DESERIALIZE_FIELD("eventTriggerData", m_eventTriggerData),
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("namedBudgets", m_namedBudgets),
    CRDTP_DESERIALIZE_FIELD("scopes", m_scopes),
    CRDTP_DESERIALIZE_FIELD("sourceRegistrationTimeConfig", m_sourceRegistrationTimeConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("triggerContextId", m_triggerContextId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingTriggerRegistration)
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
    CRDTP_SERIALIZE_FIELD("debugKey", m_debugKey);
    CRDTP_SERIALIZE_FIELD("aggregatableDedupKeys", m_aggregatableDedupKeys);
    CRDTP_SERIALIZE_FIELD("eventTriggerData", m_eventTriggerData);
    CRDTP_SERIALIZE_FIELD("aggregatableTriggerData", m_aggregatableTriggerData);
    CRDTP_SERIALIZE_FIELD("aggregatableValues", m_aggregatableValues);
    CRDTP_SERIALIZE_FIELD("aggregatableFilteringIdMaxBytes", m_aggregatableFilteringIdMaxBytes);
    CRDTP_SERIALIZE_FIELD("debugReporting", m_debugReporting);
    CRDTP_SERIALIZE_FIELD("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin);
    CRDTP_SERIALIZE_FIELD("sourceRegistrationTimeConfig", m_sourceRegistrationTimeConfig);
    CRDTP_SERIALIZE_FIELD("triggerContextId", m_triggerContextId);
    CRDTP_SERIALIZE_FIELD("aggregatableDebugReportingConfig", m_aggregatableDebugReportingConfig);
    CRDTP_SERIALIZE_FIELD("scopes", m_scopes);
    CRDTP_SERIALIZE_FIELD("namedBudgets", m_namedBudgets);
CRDTP_END_SERIALIZER();


namespace AttributionReportingEventLevelResultEnum {
const char Success[] = "success";
const char SuccessDroppedLowerPriority[] = "successDroppedLowerPriority";
const char InternalError[] = "internalError";
const char NoCapacityForAttributionDestination[] = "noCapacityForAttributionDestination";
const char NoMatchingSources[] = "noMatchingSources";
const char Deduplicated[] = "deduplicated";
const char ExcessiveAttributions[] = "excessiveAttributions";
const char PriorityTooLow[] = "priorityTooLow";
const char NeverAttributedSource[] = "neverAttributedSource";
const char ExcessiveReportingOrigins[] = "excessiveReportingOrigins";
const char NoMatchingSourceFilterData[] = "noMatchingSourceFilterData";
const char ProhibitedByBrowserPolicy[] = "prohibitedByBrowserPolicy";
const char NoMatchingConfigurations[] = "noMatchingConfigurations";
const char ExcessiveReports[] = "excessiveReports";
const char FalselyAttributedSource[] = "falselyAttributedSource";
const char ReportWindowPassed[] = "reportWindowPassed";
const char NotRegistered[] = "notRegistered";
const char ReportWindowNotStarted[] = "reportWindowNotStarted";
const char NoMatchingTriggerData[] = "noMatchingTriggerData";
} // namespace AttributionReportingEventLevelResultEnum


namespace AttributionReportingAggregatableResultEnum {
const char Success[] = "success";
const char InternalError[] = "internalError";
const char NoCapacityForAttributionDestination[] = "noCapacityForAttributionDestination";
const char NoMatchingSources[] = "noMatchingSources";
const char ExcessiveAttributions[] = "excessiveAttributions";
const char ExcessiveReportingOrigins[] = "excessiveReportingOrigins";
const char NoHistograms[] = "noHistograms";
const char InsufficientBudget[] = "insufficientBudget";
const char InsufficientNamedBudget[] = "insufficientNamedBudget";
const char NoMatchingSourceFilterData[] = "noMatchingSourceFilterData";
const char NotRegistered[] = "notRegistered";
const char ProhibitedByBrowserPolicy[] = "prohibitedByBrowserPolicy";
const char Deduplicated[] = "deduplicated";
const char ReportWindowPassed[] = "reportWindowPassed";
const char ExcessiveReports[] = "excessiveReports";
} // namespace AttributionReportingAggregatableResultEnum


namespace AttributionReportingReportResultEnum {
const char Sent[] = "sent";
const char Prohibited[] = "prohibited";
const char FailedToAssemble[] = "failedToAssemble";
const char Expired[] = "expired";
} // namespace AttributionReportingReportResultEnum


CRDTP_BEGIN_DESERIALIZER(RelatedWebsiteSet)
    CRDTP_DESERIALIZE_FIELD("associatedSites", m_associatedSites),
    CRDTP_DESERIALIZE_FIELD("primarySites", m_primarySites),
    CRDTP_DESERIALIZE_FIELD("serviceSites", m_serviceSites),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RelatedWebsiteSet)
    CRDTP_SERIALIZE_FIELD("primarySites", m_primarySites);
    CRDTP_SERIALIZE_FIELD("associatedSites", m_associatedSites);
    CRDTP_SERIALIZE_FIELD("serviceSites", m_serviceSites);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::cacheStorageContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& cacheName)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("storageKey"), storageKey);
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    serializer.AddField(crdtp::MakeSpan("cacheName"), cacheName);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.cacheStorageContentUpdated", serializer.Finish()));
}

void Frontend::cacheStorageListUpdated(const String& origin, const String& storageKey, const String& bucketId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("storageKey"), storageKey);
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.cacheStorageListUpdated", serializer.Finish()));
}

void Frontend::indexedDBContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& databaseName, const String& objectStoreName)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("storageKey"), storageKey);
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    serializer.AddField(crdtp::MakeSpan("databaseName"), databaseName);
    serializer.AddField(crdtp::MakeSpan("objectStoreName"), objectStoreName);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.indexedDBContentUpdated", serializer.Finish()));
}

void Frontend::indexedDBListUpdated(const String& origin, const String& storageKey, const String& bucketId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("storageKey"), storageKey);
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.indexedDBListUpdated", serializer.Finish()));
}

void Frontend::interestGroupAccessed(double accessTime, const String& type, const String& ownerOrigin, const String& name, std::optional<String> componentSellerOrigin, std::optional<double> bid, std::optional<String> bidCurrency, std::optional<String> uniqueAuctionId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("accessTime"), accessTime);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("ownerOrigin"), ownerOrigin);
    serializer.AddField(crdtp::MakeSpan("name"), name);
    serializer.AddField(crdtp::MakeSpan("componentSellerOrigin"), componentSellerOrigin);
    serializer.AddField(crdtp::MakeSpan("bid"), bid);
    serializer.AddField(crdtp::MakeSpan("bidCurrency"), bidCurrency);
    serializer.AddField(crdtp::MakeSpan("uniqueAuctionId"), uniqueAuctionId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.interestGroupAccessed", serializer.Finish()));
}

void Frontend::interestGroupAuctionEventOccurred(double eventTime, const String& type, const String& uniqueAuctionId, std::optional<String> parentAuctionId, std::unique_ptr<protocol::DictionaryValue> auctionConfig)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("eventTime"), eventTime);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("uniqueAuctionId"), uniqueAuctionId);
    serializer.AddField(crdtp::MakeSpan("parentAuctionId"), parentAuctionId);
    serializer.AddField(crdtp::MakeSpan("auctionConfig"), auctionConfig);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.interestGroupAuctionEventOccurred", serializer.Finish()));
}

void Frontend::interestGroupAuctionNetworkRequestCreated(const String& type, const String& requestId, std::unique_ptr<protocol::Array<String>> auctions)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("auctions"), auctions);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.interestGroupAuctionNetworkRequestCreated", serializer.Finish()));
}

void Frontend::sharedStorageAccessed(double accessTime, const String& scope, const String& method, const String& mainFrameId, const String& ownerOrigin, const String& ownerSite, std::unique_ptr<protocol::Storage::SharedStorageAccessParams> params)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("accessTime"), accessTime);
    serializer.AddField(crdtp::MakeSpan("scope"), scope);
    serializer.AddField(crdtp::MakeSpan("method"), method);
    serializer.AddField(crdtp::MakeSpan("mainFrameId"), mainFrameId);
    serializer.AddField(crdtp::MakeSpan("ownerOrigin"), ownerOrigin);
    serializer.AddField(crdtp::MakeSpan("ownerSite"), ownerSite);
    serializer.AddField(crdtp::MakeSpan("params"), params);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.sharedStorageAccessed", serializer.Finish()));
}

void Frontend::sharedStorageWorkletOperationExecutionFinished(double finishedTime, int executionTime, const String& method, const String& operationId, const String& workletTargetId, const String& mainFrameId, const String& ownerOrigin)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("finishedTime"), finishedTime);
    serializer.AddField(crdtp::MakeSpan("executionTime"), executionTime);
    serializer.AddField(crdtp::MakeSpan("method"), method);
    serializer.AddField(crdtp::MakeSpan("operationId"), operationId);
    serializer.AddField(crdtp::MakeSpan("workletTargetId"), workletTargetId);
    serializer.AddField(crdtp::MakeSpan("mainFrameId"), mainFrameId);
    serializer.AddField(crdtp::MakeSpan("ownerOrigin"), ownerOrigin);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.sharedStorageWorkletOperationExecutionFinished", serializer.Finish()));
}

void Frontend::storageBucketCreatedOrUpdated(std::unique_ptr<protocol::Storage::StorageBucketInfo> bucketInfo)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("bucketInfo"), bucketInfo);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.storageBucketCreatedOrUpdated", serializer.Finish()));
}

void Frontend::storageBucketDeleted(const String& bucketId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.storageBucketDeleted", serializer.Finish()));
}

void Frontend::attributionReportingSourceRegistered(std::unique_ptr<protocol::Storage::AttributionReportingSourceRegistration> registration, const String& result)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("registration"), registration);
    serializer.AddField(crdtp::MakeSpan("result"), result);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.attributionReportingSourceRegistered", serializer.Finish()));
}

void Frontend::attributionReportingTriggerRegistered(std::unique_ptr<protocol::Storage::AttributionReportingTriggerRegistration> registration, const String& eventLevel, const String& aggregatable)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("registration"), registration);
    serializer.AddField(crdtp::MakeSpan("eventLevel"), eventLevel);
    serializer.AddField(crdtp::MakeSpan("aggregatable"), aggregatable);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.attributionReportingTriggerRegistered", serializer.Finish()));
}

void Frontend::attributionReportingReportSent(const String& url, std::unique_ptr<protocol::DictionaryValue> body, const String& result, std::optional<int> netError, std::optional<String> netErrorName, std::optional<int> httpStatusCode)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("body"), body);
    serializer.AddField(crdtp::MakeSpan("result"), result);
    serializer.AddField(crdtp::MakeSpan("netError"), netError);
    serializer.AddField(crdtp::MakeSpan("netErrorName"), netErrorName);
    serializer.AddField(crdtp::MakeSpan("httpStatusCode"), httpStatusCode);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.attributionReportingReportSent", serializer.Finish()));
}

void Frontend::attributionReportingVerboseDebugReportSent(const String& url, std::unique_ptr<protocol::Array<protocol::DictionaryValue>> body, std::optional<int> netError, std::optional<String> netErrorName, std::optional<int> httpStatusCode)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("body"), body);
    serializer.AddField(crdtp::MakeSpan("netError"), netError);
    serializer.AddField(crdtp::MakeSpan("netErrorName"), netErrorName);
    serializer.AddField(crdtp::MakeSpan("httpStatusCode"), httpStatusCode);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.attributionReportingVerboseDebugReportSent", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void getStorageKeyForFrame(const crdtp::Dispatchable& dispatchable);
    void getStorageKey(const crdtp::Dispatchable& dispatchable);
    void clearDataForOrigin(const crdtp::Dispatchable& dispatchable);
    void clearDataForStorageKey(const crdtp::Dispatchable& dispatchable);
    void getCookies(const crdtp::Dispatchable& dispatchable);
    void setCookies(const crdtp::Dispatchable& dispatchable);
    void clearCookies(const crdtp::Dispatchable& dispatchable);
    void getUsageAndQuota(const crdtp::Dispatchable& dispatchable);
    void overrideQuotaForOrigin(const crdtp::Dispatchable& dispatchable);
    void trackCacheStorageForOrigin(const crdtp::Dispatchable& dispatchable);
    void trackCacheStorageForStorageKey(const crdtp::Dispatchable& dispatchable);
    void trackIndexedDBForOrigin(const crdtp::Dispatchable& dispatchable);
    void trackIndexedDBForStorageKey(const crdtp::Dispatchable& dispatchable);
    void untrackCacheStorageForOrigin(const crdtp::Dispatchable& dispatchable);
    void untrackCacheStorageForStorageKey(const crdtp::Dispatchable& dispatchable);
    void untrackIndexedDBForOrigin(const crdtp::Dispatchable& dispatchable);
    void untrackIndexedDBForStorageKey(const crdtp::Dispatchable& dispatchable);
    void getTrustTokens(const crdtp::Dispatchable& dispatchable);
    void clearTrustTokens(const crdtp::Dispatchable& dispatchable);
    void getInterestGroupDetails(const crdtp::Dispatchable& dispatchable);
    void setInterestGroupTracking(const crdtp::Dispatchable& dispatchable);
    void setInterestGroupAuctionTracking(const crdtp::Dispatchable& dispatchable);
    void getSharedStorageMetadata(const crdtp::Dispatchable& dispatchable);
    void getSharedStorageEntries(const crdtp::Dispatchable& dispatchable);
    void setSharedStorageEntry(const crdtp::Dispatchable& dispatchable);
    void deleteSharedStorageEntry(const crdtp::Dispatchable& dispatchable);
    void clearSharedStorageEntries(const crdtp::Dispatchable& dispatchable);
    void resetSharedStorageBudget(const crdtp::Dispatchable& dispatchable);
    void setSharedStorageTracking(const crdtp::Dispatchable& dispatchable);
    void setStorageBucketTracking(const crdtp::Dispatchable& dispatchable);
    void deleteStorageBucket(const crdtp::Dispatchable& dispatchable);
    void runBounceTrackingMitigations(const crdtp::Dispatchable& dispatchable);
    void setAttributionReportingLocalTestingMode(const crdtp::Dispatchable& dispatchable);
    void setAttributionReportingTracking(const crdtp::Dispatchable& dispatchable);
    void sendPendingAttributionReports(const crdtp::Dispatchable& dispatchable);
    void getRelatedWebsiteSets(const crdtp::Dispatchable& dispatchable);
    void getAffectedUrlsForThirdPartyCookieMetadata(const crdtp::Dispatchable& dispatchable);
    void setProtectedAudienceKAnonymity(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("clearCookies"),
          &DomainDispatcherImpl::clearCookies
    },
    {
          crdtp::SpanFrom("clearDataForOrigin"),
          &DomainDispatcherImpl::clearDataForOrigin
    },
    {
          crdtp::SpanFrom("clearDataForStorageKey"),
          &DomainDispatcherImpl::clearDataForStorageKey
    },
    {
          crdtp::SpanFrom("clearSharedStorageEntries"),
          &DomainDispatcherImpl::clearSharedStorageEntries
    },
    {
          crdtp::SpanFrom("clearTrustTokens"),
          &DomainDispatcherImpl::clearTrustTokens
    },
    {
          crdtp::SpanFrom("deleteSharedStorageEntry"),
          &DomainDispatcherImpl::deleteSharedStorageEntry
    },
    {
          crdtp::SpanFrom("deleteStorageBucket"),
          &DomainDispatcherImpl::deleteStorageBucket
    },
    {
          crdtp::SpanFrom("getAffectedUrlsForThirdPartyCookieMetadata"),
          &DomainDispatcherImpl::getAffectedUrlsForThirdPartyCookieMetadata
    },
    {
          crdtp::SpanFrom("getCookies"),
          &DomainDispatcherImpl::getCookies
    },
    {
          crdtp::SpanFrom("getInterestGroupDetails"),
          &DomainDispatcherImpl::getInterestGroupDetails
    },
    {
          crdtp::SpanFrom("getRelatedWebsiteSets"),
          &DomainDispatcherImpl::getRelatedWebsiteSets
    },
    {
          crdtp::SpanFrom("getSharedStorageEntries"),
          &DomainDispatcherImpl::getSharedStorageEntries
    },
    {
          crdtp::SpanFrom("getSharedStorageMetadata"),
          &DomainDispatcherImpl::getSharedStorageMetadata
    },
    {
          crdtp::SpanFrom("getStorageKey"),
          &DomainDispatcherImpl::getStorageKey
    },
    {
          crdtp::SpanFrom("getStorageKeyForFrame"),
          &DomainDispatcherImpl::getStorageKeyForFrame
    },
    {
          crdtp::SpanFrom("getTrustTokens"),
          &DomainDispatcherImpl::getTrustTokens
    },
    {
          crdtp::SpanFrom("getUsageAndQuota"),
          &DomainDispatcherImpl::getUsageAndQuota
    },
    {
          crdtp::SpanFrom("overrideQuotaForOrigin"),
          &DomainDispatcherImpl::overrideQuotaForOrigin
    },
    {
          crdtp::SpanFrom("resetSharedStorageBudget"),
          &DomainDispatcherImpl::resetSharedStorageBudget
    },
    {
          crdtp::SpanFrom("runBounceTrackingMitigations"),
          &DomainDispatcherImpl::runBounceTrackingMitigations
    },
    {
          crdtp::SpanFrom("sendPendingAttributionReports"),
          &DomainDispatcherImpl::sendPendingAttributionReports
    },
    {
          crdtp::SpanFrom("setAttributionReportingLocalTestingMode"),
          &DomainDispatcherImpl::setAttributionReportingLocalTestingMode
    },
    {
          crdtp::SpanFrom("setAttributionReportingTracking"),
          &DomainDispatcherImpl::setAttributionReportingTracking
    },
    {
          crdtp::SpanFrom("setCookies"),
          &DomainDispatcherImpl::setCookies
    },
    {
          crdtp::SpanFrom("setInterestGroupAuctionTracking"),
          &DomainDispatcherImpl::setInterestGroupAuctionTracking
    },
    {
          crdtp::SpanFrom("setInterestGroupTracking"),
          &DomainDispatcherImpl::setInterestGroupTracking
    },
    {
          crdtp::SpanFrom("setProtectedAudienceKAnonymity"),
          &DomainDispatcherImpl::setProtectedAudienceKAnonymity
    },
    {
          crdtp::SpanFrom("setSharedStorageEntry"),
          &DomainDispatcherImpl::setSharedStorageEntry
    },
    {
          crdtp::SpanFrom("setSharedStorageTracking"),
          &DomainDispatcherImpl::setSharedStorageTracking
    },
    {
          crdtp::SpanFrom("setStorageBucketTracking"),
          &DomainDispatcherImpl::setStorageBucketTracking
    },
    {
          crdtp::SpanFrom("trackCacheStorageForOrigin"),
          &DomainDispatcherImpl::trackCacheStorageForOrigin
    },
    {
          crdtp::SpanFrom("trackCacheStorageForStorageKey"),
          &DomainDispatcherImpl::trackCacheStorageForStorageKey
    },
    {
          crdtp::SpanFrom("trackIndexedDBForOrigin"),
          &DomainDispatcherImpl::trackIndexedDBForOrigin
    },
    {
          crdtp::SpanFrom("trackIndexedDBForStorageKey"),
          &DomainDispatcherImpl::trackIndexedDBForStorageKey
    },
    {
          crdtp::SpanFrom("untrackCacheStorageForOrigin"),
          &DomainDispatcherImpl::untrackCacheStorageForOrigin
    },
    {
          crdtp::SpanFrom("untrackCacheStorageForStorageKey"),
          &DomainDispatcherImpl::untrackCacheStorageForStorageKey
    },
    {
          crdtp::SpanFrom("untrackIndexedDBForOrigin"),
          &DomainDispatcherImpl::untrackIndexedDBForOrigin
    },
    {
          crdtp::SpanFrom("untrackIndexedDBForStorageKey"),
          &DomainDispatcherImpl::untrackIndexedDBForStorageKey
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct getStorageKeyForFrameParams : public crdtp::DeserializableProtocolObject<getStorageKeyForFrameParams> {
    String frameId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getStorageKeyForFrameParams)
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getStorageKeyForFrame(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getStorageKeyForFrameParams params;
    if (!getStorageKeyForFrameParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_storageKey;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getStorageKeyForFrame(params.frameId, &out_storageKey);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getStorageKeyForFrame"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("storageKey"), out_storageKey);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getStorageKeyParams : public crdtp::DeserializableProtocolObject<getStorageKeyParams> {
    std::optional<String> frameId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getStorageKeyParams)
    CRDTP_DESERIALIZE_FIELD_OPT("frameId", frameId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getStorageKey(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getStorageKeyParams params;
    if (!getStorageKeyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_storageKey;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getStorageKey(std::move(params.frameId), &out_storageKey);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getStorageKey"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("storageKey"), out_storageKey);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct clearDataForOriginParams : public crdtp::DeserializableProtocolObject<clearDataForOriginParams> {
    String origin;
    String storageTypes;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearDataForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
    CRDTP_DESERIALIZE_FIELD("storageTypes", storageTypes),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearDataForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearDataForOriginParams params;
    if (!clearDataForOriginParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->clearDataForOrigin(params.origin, params.storageTypes);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.clearDataForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct clearDataForStorageKeyParams : public crdtp::DeserializableProtocolObject<clearDataForStorageKeyParams> {
    String storageKey;
    String storageTypes;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearDataForStorageKeyParams)
    CRDTP_DESERIALIZE_FIELD("storageKey", storageKey),
    CRDTP_DESERIALIZE_FIELD("storageTypes", storageTypes),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearDataForStorageKey(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearDataForStorageKeyParams params;
    if (!clearDataForStorageKeyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->clearDataForStorageKey(params.storageKey, params.storageTypes);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.clearDataForStorageKey"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getCookiesParams : public crdtp::DeserializableProtocolObject<getCookiesParams> {
    std::optional<String> browserContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getCookiesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("browserContextId", browserContextId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getCookies(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getCookiesParams params;
    if (!getCookiesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Network::Cookie>> out_cookies;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getCookies(std::move(params.browserContextId), &out_cookies);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getCookies"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("cookies"), out_cookies);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setCookiesParams : public crdtp::DeserializableProtocolObject<setCookiesParams> {
    std::unique_ptr<protocol::Array<protocol::Network::CookieParam>> cookies;
    std::optional<String> browserContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setCookiesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("browserContextId", browserContextId),
    CRDTP_DESERIALIZE_FIELD("cookies", cookies),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setCookies(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setCookiesParams params;
    if (!setCookiesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setCookies(std::move(params.cookies), std::move(params.browserContextId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.setCookies"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct clearCookiesParams : public crdtp::DeserializableProtocolObject<clearCookiesParams> {
    std::optional<String> browserContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearCookiesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("browserContextId", browserContextId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearCookies(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearCookiesParams params;
    if (!clearCookiesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->clearCookies(std::move(params.browserContextId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.clearCookies"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getUsageAndQuotaParams : public crdtp::DeserializableProtocolObject<getUsageAndQuotaParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getUsageAndQuotaParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getUsageAndQuota(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getUsageAndQuotaParams params;
    if (!getUsageAndQuotaParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    double out_usage;
    double out_quota;
    bool out_overrideActive;
    std::unique_ptr<protocol::Array<protocol::Storage::UsageForType>> out_usageBreakdown;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getUsageAndQuota(params.origin, &out_usage, &out_quota, &out_overrideActive, &out_usageBreakdown);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getUsageAndQuota"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("usage"), out_usage);
          serializer.AddField(crdtp::MakeSpan("quota"), out_quota);
          serializer.AddField(crdtp::MakeSpan("overrideActive"), out_overrideActive);
          serializer.AddField(crdtp::MakeSpan("usageBreakdown"), out_usageBreakdown);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct overrideQuotaForOriginParams : public crdtp::DeserializableProtocolObject<overrideQuotaForOriginParams> {
    String origin;
    std::optional<double> quotaSize;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(overrideQuotaForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
    CRDTP_DESERIALIZE_FIELD_OPT("quotaSize", quotaSize),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::overrideQuotaForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    overrideQuotaForOriginParams params;
    if (!overrideQuotaForOriginParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->overrideQuotaForOrigin(params.origin, std::move(params.quotaSize));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.overrideQuotaForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct trackCacheStorageForOriginParams : public crdtp::DeserializableProtocolObject<trackCacheStorageForOriginParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(trackCacheStorageForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::trackCacheStorageForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    trackCacheStorageForOriginParams params;
    if (!trackCacheStorageForOriginParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->trackCacheStorageForOrigin(params.origin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.trackCacheStorageForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct trackCacheStorageForStorageKeyParams : public crdtp::DeserializableProtocolObject<trackCacheStorageForStorageKeyParams> {
    String storageKey;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(trackCacheStorageForStorageKeyParams)
    CRDTP_DESERIALIZE_FIELD("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::trackCacheStorageForStorageKey(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    trackCacheStorageForStorageKeyParams params;
    if (!trackCacheStorageForStorageKeyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->trackCacheStorageForStorageKey(params.storageKey);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.trackCacheStorageForStorageKey"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct trackIndexedDBForOriginParams : public crdtp::DeserializableProtocolObject<trackIndexedDBForOriginParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(trackIndexedDBForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::trackIndexedDBForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    trackIndexedDBForOriginParams params;
    if (!trackIndexedDBForOriginParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->trackIndexedDBForOrigin(params.origin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.trackIndexedDBForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct trackIndexedDBForStorageKeyParams : public crdtp::DeserializableProtocolObject<trackIndexedDBForStorageKeyParams> {
    String storageKey;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(trackIndexedDBForStorageKeyParams)
    CRDTP_DESERIALIZE_FIELD("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::trackIndexedDBForStorageKey(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    trackIndexedDBForStorageKeyParams params;
    if (!trackIndexedDBForStorageKeyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->trackIndexedDBForStorageKey(params.storageKey);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.trackIndexedDBForStorageKey"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct untrackCacheStorageForOriginParams : public crdtp::DeserializableProtocolObject<untrackCacheStorageForOriginParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(untrackCacheStorageForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::untrackCacheStorageForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    untrackCacheStorageForOriginParams params;
    if (!untrackCacheStorageForOriginParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->untrackCacheStorageForOrigin(params.origin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.untrackCacheStorageForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct untrackCacheStorageForStorageKeyParams : public crdtp::DeserializableProtocolObject<untrackCacheStorageForStorageKeyParams> {
    String storageKey;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(untrackCacheStorageForStorageKeyParams)
    CRDTP_DESERIALIZE_FIELD("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::untrackCacheStorageForStorageKey(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    untrackCacheStorageForStorageKeyParams params;
    if (!untrackCacheStorageForStorageKeyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->untrackCacheStorageForStorageKey(params.storageKey);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.untrackCacheStorageForStorageKey"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct untrackIndexedDBForOriginParams : public crdtp::DeserializableProtocolObject<untrackIndexedDBForOriginParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(untrackIndexedDBForOriginParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::untrackIndexedDBForOrigin(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    untrackIndexedDBForOriginParams params;
    if (!untrackIndexedDBForOriginParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->untrackIndexedDBForOrigin(params.origin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.untrackIndexedDBForOrigin"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct untrackIndexedDBForStorageKeyParams : public crdtp::DeserializableProtocolObject<untrackIndexedDBForStorageKeyParams> {
    String storageKey;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(untrackIndexedDBForStorageKeyParams)
    CRDTP_DESERIALIZE_FIELD("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::untrackIndexedDBForStorageKey(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    untrackIndexedDBForStorageKeyParams params;
    if (!untrackIndexedDBForStorageKeyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->untrackIndexedDBForStorageKey(params.storageKey);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.untrackIndexedDBForStorageKey"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getTrustTokens(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Storage::TrustTokens>> out_tokens;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getTrustTokens(&out_tokens);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getTrustTokens"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("tokens"), out_tokens);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct clearTrustTokensParams : public crdtp::DeserializableProtocolObject<clearTrustTokensParams> {
    String issuerOrigin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearTrustTokensParams)
    CRDTP_DESERIALIZE_FIELD("issuerOrigin", issuerOrigin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearTrustTokens(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearTrustTokensParams params;
    if (!clearTrustTokensParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    bool out_didDeleteTokens;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->clearTrustTokens(params.issuerOrigin, &out_didDeleteTokens);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.clearTrustTokens"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("didDeleteTokens"), out_didDeleteTokens);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getInterestGroupDetailsParams : public crdtp::DeserializableProtocolObject<getInterestGroupDetailsParams> {
    String ownerOrigin;
    String name;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getInterestGroupDetailsParams)
    CRDTP_DESERIALIZE_FIELD("name", name),
    CRDTP_DESERIALIZE_FIELD("ownerOrigin", ownerOrigin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getInterestGroupDetails(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getInterestGroupDetailsParams params;
    if (!getInterestGroupDetailsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::DictionaryValue> out_details;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getInterestGroupDetails(params.ownerOrigin, params.name, &out_details);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getInterestGroupDetails"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("details"), out_details);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setInterestGroupTrackingParams : public crdtp::DeserializableProtocolObject<setInterestGroupTrackingParams> {
    bool enable;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setInterestGroupTrackingParams)
    CRDTP_DESERIALIZE_FIELD("enable", enable),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setInterestGroupTracking(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setInterestGroupTrackingParams params;
    if (!setInterestGroupTrackingParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setInterestGroupTracking(params.enable);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.setInterestGroupTracking"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setInterestGroupAuctionTrackingParams : public crdtp::DeserializableProtocolObject<setInterestGroupAuctionTrackingParams> {
    bool enable;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setInterestGroupAuctionTrackingParams)
    CRDTP_DESERIALIZE_FIELD("enable", enable),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setInterestGroupAuctionTracking(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setInterestGroupAuctionTrackingParams params;
    if (!setInterestGroupAuctionTrackingParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setInterestGroupAuctionTracking(params.enable);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.setInterestGroupAuctionTracking"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getSharedStorageMetadataParams : public crdtp::DeserializableProtocolObject<getSharedStorageMetadataParams> {
    String ownerOrigin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getSharedStorageMetadataParams)
    CRDTP_DESERIALIZE_FIELD("ownerOrigin", ownerOrigin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getSharedStorageMetadata(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getSharedStorageMetadataParams params;
    if (!getSharedStorageMetadataParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Storage::SharedStorageMetadata> out_metadata;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getSharedStorageMetadata(params.ownerOrigin, &out_metadata);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getSharedStorageMetadata"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("metadata"), out_metadata);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getSharedStorageEntriesParams : public crdtp::DeserializableProtocolObject<getSharedStorageEntriesParams> {
    String ownerOrigin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getSharedStorageEntriesParams)
    CRDTP_DESERIALIZE_FIELD("ownerOrigin", ownerOrigin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getSharedStorageEntries(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getSharedStorageEntriesParams params;
    if (!getSharedStorageEntriesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Storage::SharedStorageEntry>> out_entries;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getSharedStorageEntries(params.ownerOrigin, &out_entries);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getSharedStorageEntries"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("entries"), out_entries);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setSharedStorageEntryParams : public crdtp::DeserializableProtocolObject<setSharedStorageEntryParams> {
    String ownerOrigin;
    String key;
    String value;
    std::optional<bool> ignoreIfPresent;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setSharedStorageEntryParams)
    CRDTP_DESERIALIZE_FIELD_OPT("ignoreIfPresent", ignoreIfPresent),
    CRDTP_DESERIALIZE_FIELD("key", key),
    CRDTP_DESERIALIZE_FIELD("ownerOrigin", ownerOrigin),
    CRDTP_DESERIALIZE_FIELD("value", value),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setSharedStorageEntry(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setSharedStorageEntryParams params;
    if (!setSharedStorageEntryParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setSharedStorageEntry(params.ownerOrigin, params.key, params.value, std::move(params.ignoreIfPresent));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.setSharedStorageEntry"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct deleteSharedStorageEntryParams : public crdtp::DeserializableProtocolObject<deleteSharedStorageEntryParams> {
    String ownerOrigin;
    String key;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(deleteSharedStorageEntryParams)
    CRDTP_DESERIALIZE_FIELD("key", key),
    CRDTP_DESERIALIZE_FIELD("ownerOrigin", ownerOrigin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::deleteSharedStorageEntry(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    deleteSharedStorageEntryParams params;
    if (!deleteSharedStorageEntryParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->deleteSharedStorageEntry(params.ownerOrigin, params.key);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.deleteSharedStorageEntry"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct clearSharedStorageEntriesParams : public crdtp::DeserializableProtocolObject<clearSharedStorageEntriesParams> {
    String ownerOrigin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearSharedStorageEntriesParams)
    CRDTP_DESERIALIZE_FIELD("ownerOrigin", ownerOrigin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearSharedStorageEntries(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearSharedStorageEntriesParams params;
    if (!clearSharedStorageEntriesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->clearSharedStorageEntries(params.ownerOrigin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.clearSharedStorageEntries"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct resetSharedStorageBudgetParams : public crdtp::DeserializableProtocolObject<resetSharedStorageBudgetParams> {
    String ownerOrigin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(resetSharedStorageBudgetParams)
    CRDTP_DESERIALIZE_FIELD("ownerOrigin", ownerOrigin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::resetSharedStorageBudget(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    resetSharedStorageBudgetParams params;
    if (!resetSharedStorageBudgetParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->resetSharedStorageBudget(params.ownerOrigin);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.resetSharedStorageBudget"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setSharedStorageTrackingParams : public crdtp::DeserializableProtocolObject<setSharedStorageTrackingParams> {
    bool enable;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setSharedStorageTrackingParams)
    CRDTP_DESERIALIZE_FIELD("enable", enable),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setSharedStorageTracking(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setSharedStorageTrackingParams params;
    if (!setSharedStorageTrackingParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setSharedStorageTracking(params.enable);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.setSharedStorageTracking"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setStorageBucketTrackingParams : public crdtp::DeserializableProtocolObject<setStorageBucketTrackingParams> {
    String storageKey;
    bool enable;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setStorageBucketTrackingParams)
    CRDTP_DESERIALIZE_FIELD("enable", enable),
    CRDTP_DESERIALIZE_FIELD("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setStorageBucketTracking(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setStorageBucketTrackingParams params;
    if (!setStorageBucketTrackingParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setStorageBucketTracking(params.storageKey, params.enable);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.setStorageBucketTracking"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct deleteStorageBucketParams : public crdtp::DeserializableProtocolObject<deleteStorageBucketParams> {
    std::unique_ptr<protocol::Storage::StorageBucket> bucket;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(deleteStorageBucketParams)
    CRDTP_DESERIALIZE_FIELD("bucket", bucket),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::deleteStorageBucket(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    deleteStorageBucketParams params;
    if (!deleteStorageBucketParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->deleteStorageBucket(std::move(params.bucket));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.deleteStorageBucket"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::runBounceTrackingMitigations(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_deletedSites;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->runBounceTrackingMitigations(&out_deletedSites);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.runBounceTrackingMitigations"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("deletedSites"), out_deletedSites);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setAttributionReportingLocalTestingModeParams : public crdtp::DeserializableProtocolObject<setAttributionReportingLocalTestingModeParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAttributionReportingLocalTestingModeParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAttributionReportingLocalTestingMode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAttributionReportingLocalTestingModeParams params;
    if (!setAttributionReportingLocalTestingModeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAttributionReportingLocalTestingMode(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.setAttributionReportingLocalTestingMode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setAttributionReportingTrackingParams : public crdtp::DeserializableProtocolObject<setAttributionReportingTrackingParams> {
    bool enable;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAttributionReportingTrackingParams)
    CRDTP_DESERIALIZE_FIELD("enable", enable),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAttributionReportingTracking(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAttributionReportingTrackingParams params;
    if (!setAttributionReportingTrackingParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAttributionReportingTracking(params.enable);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.setAttributionReportingTracking"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::sendPendingAttributionReports(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    int out_numSent;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->sendPendingAttributionReports(&out_numSent);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.sendPendingAttributionReports"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("numSent"), out_numSent);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getRelatedWebsiteSets(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Storage::RelatedWebsiteSet>> out_sets;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getRelatedWebsiteSets(&out_sets);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getRelatedWebsiteSets"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("sets"), out_sets);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getAffectedUrlsForThirdPartyCookieMetadataParams : public crdtp::DeserializableProtocolObject<getAffectedUrlsForThirdPartyCookieMetadataParams> {
    String firstPartyUrl;
    std::unique_ptr<protocol::Array<String>> thirdPartyUrls;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getAffectedUrlsForThirdPartyCookieMetadataParams)
    CRDTP_DESERIALIZE_FIELD("firstPartyUrl", firstPartyUrl),
    CRDTP_DESERIALIZE_FIELD("thirdPartyUrls", thirdPartyUrls),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getAffectedUrlsForThirdPartyCookieMetadata(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getAffectedUrlsForThirdPartyCookieMetadataParams params;
    if (!getAffectedUrlsForThirdPartyCookieMetadataParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_matchedUrls;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getAffectedUrlsForThirdPartyCookieMetadata(params.firstPartyUrl, std::move(params.thirdPartyUrls), &out_matchedUrls);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getAffectedUrlsForThirdPartyCookieMetadata"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("matchedUrls"), out_matchedUrls);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setProtectedAudienceKAnonymityParams : public crdtp::DeserializableProtocolObject<setProtectedAudienceKAnonymityParams> {
    String owner;
    String name;
    std::unique_ptr<protocol::Array<Binary>> hashes;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setProtectedAudienceKAnonymityParams)
    CRDTP_DESERIALIZE_FIELD("hashes", hashes),
    CRDTP_DESERIALIZE_FIELD("name", name),
    CRDTP_DESERIALIZE_FIELD("owner", owner),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setProtectedAudienceKAnonymity(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setProtectedAudienceKAnonymityParams params;
    if (!setProtectedAudienceKAnonymityParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setProtectedAudienceKAnonymity(params.owner, params.name, std::move(params.hashes));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.setProtectedAudienceKAnonymity"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Storage"), SortedRedirects(), std::move(dispatcher));
}

} // Storage
} // namespace blink
} // namespace protocol
