// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Performance_h
#define blink_protocol_Performance_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace blink {
namespace protocol {
namespace Performance {
class Metric;

// ------------- Forward and enum declarations.

namespace Enable {
namespace TimeDomainEnum {
CORE_EXPORT extern const char* TimeTicks;
CORE_EXPORT extern const char* ThreadTicks;
} // TimeDomainEnum
} // Enable

namespace SetTimeDomain {
namespace TimeDomainEnum {
CORE_EXPORT extern const char* TimeTicks;
CORE_EXPORT extern const char* ThreadTicks;
} // TimeDomainEnum
} // SetTimeDomain

// ------------- Type and builder declarations.

class CORE_EXPORT Metric : public ::crdtp::ProtocolObject<Metric> {
public:
    ~Metric() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    double getValue() { return m_value; }
    void setValue(double value) { m_value = value; }

    template<int STATE>
    class MetricBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        MetricBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        MetricBuilder<STATE | ValueSet>& setValue(double value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<Metric> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Metric;
        MetricBuilder() : m_result(new Metric()) { }

        template<int STEP> MetricBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MetricBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Performance::Metric> m_result;
    };

    static MetricBuilder<0> create()
    {
        return MetricBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Metric()
    {
          m_value = 0;
    }

    String m_name;
    double m_value;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable(std::optional<String> in_timeDomain) = 0;
    virtual DispatchResponse setTimeDomain(const String& in_timeDomain) = 0;
    virtual DispatchResponse getMetrics(std::unique_ptr<protocol::Array<protocol::Performance::Metric>>* out_metrics) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void metrics(std::unique_ptr<protocol::Array<protocol::Performance::Metric>> metrics, const String& title);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Performance
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Performance_h)
