// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Network_h
#define blink_protocol_Network_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/debugger.h"
#include "third_party/blink/renderer/core/inspector/protocol/runtime.h"
#include "third_party/blink/renderer/core/inspector/protocol/security.h"

namespace blink {
namespace protocol {
namespace Network {
using ResourceType = String;
using LoaderId = String;
using RequestId = String;
using InterceptionId = String;
using ErrorReason = String;
using TimeSinceEpoch = double;
using MonotonicTime = double;
using Headers = Object;
using ConnectionType = String;
using CookieSameSite = String;
using CookiePriority = String;
using CookieSourceScheme = String;
class ResourceTiming;
using ResourcePriority = String;
class PostDataEntry;
class Request;
class SignedCertificateTimestamp;
class SecurityDetails;
using CertificateTransparencyCompliance = String;
using BlockedReason = String;
using CorsError = String;
class CorsErrorStatus;
using ServiceWorkerResponseSource = String;
class TrustTokenParams;
using TrustTokenOperationType = String;
using AlternateProtocolUsage = String;
using ServiceWorkerRouterSource = String;
class ServiceWorkerRouterInfo;
class Response;
class WebSocketRequest;
class WebSocketResponse;
class WebSocketFrame;
class Initiator;
class CookiePartitionKey;
class Cookie;
using SetCookieBlockedReason = String;
using CookieBlockedReason = String;
using CookieExemptionReason = String;
class BlockedSetCookieWithReason;
class ExemptedSetCookieWithReason;
class AssociatedCookie;
class CookieParam;
class AuthChallenge;
class SignedExchangeSignature;
class SignedExchangeHeader;
using SignedExchangeErrorField = String;
class SignedExchangeError;
class SignedExchangeInfo;
using ContentEncoding = String;
class NetworkConditions;
using DirectSocketDnsQueryType = String;
class DirectTCPSocketOptions;
class DirectUDPSocketOptions;
class DirectUDPMessage;
using PrivateNetworkRequestPolicy = String;
using IPAddressSpace = String;
class ConnectTiming;
class ClientSecurityState;
using ReportStatus = String;
using ReportId = String;
class ReportingApiReport;
class ReportingApiEndpoint;

// ------------- Forward and enum declarations.

namespace ResourceTypeEnum {
CORE_EXPORT extern const char Document[];
CORE_EXPORT extern const char Stylesheet[];
CORE_EXPORT extern const char Image[];
CORE_EXPORT extern const char Media[];
CORE_EXPORT extern const char Font[];
CORE_EXPORT extern const char Script[];
CORE_EXPORT extern const char TextTrack[];
CORE_EXPORT extern const char XHR[];
CORE_EXPORT extern const char Fetch[];
CORE_EXPORT extern const char Prefetch[];
CORE_EXPORT extern const char EventSource[];
CORE_EXPORT extern const char WebSocket[];
CORE_EXPORT extern const char Manifest[];
CORE_EXPORT extern const char SignedExchange[];
CORE_EXPORT extern const char Ping[];
CORE_EXPORT extern const char CSPViolationReport[];
CORE_EXPORT extern const char Preflight[];
CORE_EXPORT extern const char FedCM[];
CORE_EXPORT extern const char Other[];
} // namespace ResourceTypeEnum

namespace ErrorReasonEnum {
CORE_EXPORT extern const char Failed[];
CORE_EXPORT extern const char Aborted[];
CORE_EXPORT extern const char TimedOut[];
CORE_EXPORT extern const char AccessDenied[];
CORE_EXPORT extern const char ConnectionClosed[];
CORE_EXPORT extern const char ConnectionReset[];
CORE_EXPORT extern const char ConnectionRefused[];
CORE_EXPORT extern const char ConnectionAborted[];
CORE_EXPORT extern const char ConnectionFailed[];
CORE_EXPORT extern const char NameNotResolved[];
CORE_EXPORT extern const char InternetDisconnected[];
CORE_EXPORT extern const char AddressUnreachable[];
CORE_EXPORT extern const char BlockedByClient[];
CORE_EXPORT extern const char BlockedByResponse[];
} // namespace ErrorReasonEnum

namespace ConnectionTypeEnum {
CORE_EXPORT extern const char None[];
CORE_EXPORT extern const char Cellular2g[];
CORE_EXPORT extern const char Cellular3g[];
CORE_EXPORT extern const char Cellular4g[];
CORE_EXPORT extern const char Bluetooth[];
CORE_EXPORT extern const char Ethernet[];
CORE_EXPORT extern const char Wifi[];
CORE_EXPORT extern const char Wimax[];
CORE_EXPORT extern const char Other[];
} // namespace ConnectionTypeEnum

namespace CookieSameSiteEnum {
CORE_EXPORT extern const char Strict[];
CORE_EXPORT extern const char Lax[];
CORE_EXPORT extern const char None[];
} // namespace CookieSameSiteEnum

namespace CookiePriorityEnum {
CORE_EXPORT extern const char Low[];
CORE_EXPORT extern const char Medium[];
CORE_EXPORT extern const char High[];
} // namespace CookiePriorityEnum

namespace CookieSourceSchemeEnum {
CORE_EXPORT extern const char Unset[];
CORE_EXPORT extern const char NonSecure[];
CORE_EXPORT extern const char Secure[];
} // namespace CookieSourceSchemeEnum

namespace ResourcePriorityEnum {
CORE_EXPORT extern const char VeryLow[];
CORE_EXPORT extern const char Low[];
CORE_EXPORT extern const char Medium[];
CORE_EXPORT extern const char High[];
CORE_EXPORT extern const char VeryHigh[];
} // namespace ResourcePriorityEnum

namespace CertificateTransparencyComplianceEnum {
CORE_EXPORT extern const char Unknown[];
CORE_EXPORT extern const char NotCompliant[];
CORE_EXPORT extern const char Compliant[];
} // namespace CertificateTransparencyComplianceEnum

namespace BlockedReasonEnum {
CORE_EXPORT extern const char Other[];
CORE_EXPORT extern const char Csp[];
CORE_EXPORT extern const char MixedContent[];
CORE_EXPORT extern const char Origin[];
CORE_EXPORT extern const char Inspector[];
CORE_EXPORT extern const char Integrity[];
CORE_EXPORT extern const char SubresourceFilter[];
CORE_EXPORT extern const char ContentType[];
CORE_EXPORT extern const char CoepFrameResourceNeedsCoepHeader[];
CORE_EXPORT extern const char CoopSandboxedIframeCannotNavigateToCoopPage[];
CORE_EXPORT extern const char CorpNotSameOrigin[];
CORE_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[];
CORE_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByDip[];
CORE_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip[];
CORE_EXPORT extern const char CorpNotSameSite[];
CORE_EXPORT extern const char SriMessageSignatureMismatch[];
} // namespace BlockedReasonEnum

namespace CorsErrorEnum {
CORE_EXPORT extern const char DisallowedByMode[];
CORE_EXPORT extern const char InvalidResponse[];
CORE_EXPORT extern const char WildcardOriginNotAllowed[];
CORE_EXPORT extern const char MissingAllowOriginHeader[];
CORE_EXPORT extern const char MultipleAllowOriginValues[];
CORE_EXPORT extern const char InvalidAllowOriginValue[];
CORE_EXPORT extern const char AllowOriginMismatch[];
CORE_EXPORT extern const char InvalidAllowCredentials[];
CORE_EXPORT extern const char CorsDisabledScheme[];
CORE_EXPORT extern const char PreflightInvalidStatus[];
CORE_EXPORT extern const char PreflightDisallowedRedirect[];
CORE_EXPORT extern const char PreflightWildcardOriginNotAllowed[];
CORE_EXPORT extern const char PreflightMissingAllowOriginHeader[];
CORE_EXPORT extern const char PreflightMultipleAllowOriginValues[];
CORE_EXPORT extern const char PreflightInvalidAllowOriginValue[];
CORE_EXPORT extern const char PreflightAllowOriginMismatch[];
CORE_EXPORT extern const char PreflightInvalidAllowCredentials[];
CORE_EXPORT extern const char PreflightMissingAllowExternal[];
CORE_EXPORT extern const char PreflightInvalidAllowExternal[];
CORE_EXPORT extern const char PreflightMissingAllowPrivateNetwork[];
CORE_EXPORT extern const char PreflightInvalidAllowPrivateNetwork[];
CORE_EXPORT extern const char InvalidAllowMethodsPreflightResponse[];
CORE_EXPORT extern const char InvalidAllowHeadersPreflightResponse[];
CORE_EXPORT extern const char MethodDisallowedByPreflightResponse[];
CORE_EXPORT extern const char HeaderDisallowedByPreflightResponse[];
CORE_EXPORT extern const char RedirectContainsCredentials[];
CORE_EXPORT extern const char InsecurePrivateNetwork[];
CORE_EXPORT extern const char InvalidPrivateNetworkAccess[];
CORE_EXPORT extern const char UnexpectedPrivateNetworkAccess[];
CORE_EXPORT extern const char NoCorsRedirectModeNotFollow[];
CORE_EXPORT extern const char PreflightMissingPrivateNetworkAccessId[];
CORE_EXPORT extern const char PreflightMissingPrivateNetworkAccessName[];
CORE_EXPORT extern const char PrivateNetworkAccessPermissionUnavailable[];
CORE_EXPORT extern const char PrivateNetworkAccessPermissionDenied[];
CORE_EXPORT extern const char LocalNetworkAccessPermissionDenied[];
} // namespace CorsErrorEnum

namespace ServiceWorkerResponseSourceEnum {
CORE_EXPORT extern const char CacheStorage[];
CORE_EXPORT extern const char HttpCache[];
CORE_EXPORT extern const char FallbackCode[];
CORE_EXPORT extern const char Network[];
} // namespace ServiceWorkerResponseSourceEnum

namespace TrustTokenOperationTypeEnum {
CORE_EXPORT extern const char Issuance[];
CORE_EXPORT extern const char Redemption[];
CORE_EXPORT extern const char Signing[];
} // namespace TrustTokenOperationTypeEnum

namespace AlternateProtocolUsageEnum {
CORE_EXPORT extern const char AlternativeJobWonWithoutRace[];
CORE_EXPORT extern const char AlternativeJobWonRace[];
CORE_EXPORT extern const char MainJobWonRace[];
CORE_EXPORT extern const char MappingMissing[];
CORE_EXPORT extern const char Broken[];
CORE_EXPORT extern const char DnsAlpnH3JobWonWithoutRace[];
CORE_EXPORT extern const char DnsAlpnH3JobWonRace[];
CORE_EXPORT extern const char UnspecifiedReason[];
} // namespace AlternateProtocolUsageEnum

namespace ServiceWorkerRouterSourceEnum {
CORE_EXPORT extern const char Network[];
CORE_EXPORT extern const char Cache[];
CORE_EXPORT extern const char FetchEvent[];
CORE_EXPORT extern const char RaceNetworkAndFetchHandler[];
CORE_EXPORT extern const char RaceNetworkAndCache[];
} // namespace ServiceWorkerRouterSourceEnum

namespace SetCookieBlockedReasonEnum {
CORE_EXPORT extern const char SecureOnly[];
CORE_EXPORT extern const char SameSiteStrict[];
CORE_EXPORT extern const char SameSiteLax[];
CORE_EXPORT extern const char SameSiteUnspecifiedTreatedAsLax[];
CORE_EXPORT extern const char SameSiteNoneInsecure[];
CORE_EXPORT extern const char UserPreferences[];
CORE_EXPORT extern const char ThirdPartyPhaseout[];
CORE_EXPORT extern const char ThirdPartyBlockedInFirstPartySet[];
CORE_EXPORT extern const char SyntaxError[];
CORE_EXPORT extern const char SchemeNotSupported[];
CORE_EXPORT extern const char OverwriteSecure[];
CORE_EXPORT extern const char InvalidDomain[];
CORE_EXPORT extern const char InvalidPrefix[];
CORE_EXPORT extern const char UnknownError[];
CORE_EXPORT extern const char SchemefulSameSiteStrict[];
CORE_EXPORT extern const char SchemefulSameSiteLax[];
CORE_EXPORT extern const char SchemefulSameSiteUnspecifiedTreatedAsLax[];
CORE_EXPORT extern const char SamePartyFromCrossPartyContext[];
CORE_EXPORT extern const char SamePartyConflictsWithOtherAttributes[];
CORE_EXPORT extern const char NameValuePairExceedsMaxSize[];
CORE_EXPORT extern const char DisallowedCharacter[];
CORE_EXPORT extern const char NoCookieContent[];
} // namespace SetCookieBlockedReasonEnum

namespace CookieBlockedReasonEnum {
CORE_EXPORT extern const char SecureOnly[];
CORE_EXPORT extern const char NotOnPath[];
CORE_EXPORT extern const char DomainMismatch[];
CORE_EXPORT extern const char SameSiteStrict[];
CORE_EXPORT extern const char SameSiteLax[];
CORE_EXPORT extern const char SameSiteUnspecifiedTreatedAsLax[];
CORE_EXPORT extern const char SameSiteNoneInsecure[];
CORE_EXPORT extern const char UserPreferences[];
CORE_EXPORT extern const char ThirdPartyPhaseout[];
CORE_EXPORT extern const char ThirdPartyBlockedInFirstPartySet[];
CORE_EXPORT extern const char UnknownError[];
CORE_EXPORT extern const char SchemefulSameSiteStrict[];
CORE_EXPORT extern const char SchemefulSameSiteLax[];
CORE_EXPORT extern const char SchemefulSameSiteUnspecifiedTreatedAsLax[];
CORE_EXPORT extern const char SamePartyFromCrossPartyContext[];
CORE_EXPORT extern const char NameValuePairExceedsMaxSize[];
CORE_EXPORT extern const char PortMismatch[];
CORE_EXPORT extern const char SchemeMismatch[];
CORE_EXPORT extern const char AnonymousContext[];
} // namespace CookieBlockedReasonEnum

namespace CookieExemptionReasonEnum {
CORE_EXPORT extern const char None[];
CORE_EXPORT extern const char UserSetting[];
CORE_EXPORT extern const char TPCDMetadata[];
CORE_EXPORT extern const char TPCDDeprecationTrial[];
CORE_EXPORT extern const char TopLevelTPCDDeprecationTrial[];
CORE_EXPORT extern const char TPCDHeuristics[];
CORE_EXPORT extern const char EnterprisePolicy[];
CORE_EXPORT extern const char StorageAccess[];
CORE_EXPORT extern const char TopLevelStorageAccess[];
CORE_EXPORT extern const char Scheme[];
CORE_EXPORT extern const char SameSiteNoneCookiesInSandbox[];
} // namespace CookieExemptionReasonEnum

namespace SignedExchangeErrorFieldEnum {
CORE_EXPORT extern const char SignatureSig[];
CORE_EXPORT extern const char SignatureIntegrity[];
CORE_EXPORT extern const char SignatureCertUrl[];
CORE_EXPORT extern const char SignatureCertSha256[];
CORE_EXPORT extern const char SignatureValidityUrl[];
CORE_EXPORT extern const char SignatureTimestamps[];
} // namespace SignedExchangeErrorFieldEnum

namespace ContentEncodingEnum {
CORE_EXPORT extern const char Deflate[];
CORE_EXPORT extern const char Gzip[];
CORE_EXPORT extern const char Br[];
CORE_EXPORT extern const char Zstd[];
} // namespace ContentEncodingEnum

namespace DirectSocketDnsQueryTypeEnum {
CORE_EXPORT extern const char Ipv4[];
CORE_EXPORT extern const char Ipv6[];
} // namespace DirectSocketDnsQueryTypeEnum

namespace PrivateNetworkRequestPolicyEnum {
CORE_EXPORT extern const char Allow[];
CORE_EXPORT extern const char BlockFromInsecureToMorePrivate[];
CORE_EXPORT extern const char WarnFromInsecureToMorePrivate[];
CORE_EXPORT extern const char PreflightBlock[];
CORE_EXPORT extern const char PreflightWarn[];
CORE_EXPORT extern const char PermissionBlock[];
CORE_EXPORT extern const char PermissionWarn[];
} // namespace PrivateNetworkRequestPolicyEnum

namespace IPAddressSpaceEnum {
CORE_EXPORT extern const char Loopback[];
CORE_EXPORT extern const char Local[];
CORE_EXPORT extern const char Public[];
CORE_EXPORT extern const char Unknown[];
} // namespace IPAddressSpaceEnum

namespace ReportStatusEnum {
CORE_EXPORT extern const char Queued[];
CORE_EXPORT extern const char Pending[];
CORE_EXPORT extern const char MarkedForRemoval[];
CORE_EXPORT extern const char Success[];
} // namespace ReportStatusEnum

namespace TrustTokenOperationDone {
namespace StatusEnum {
CORE_EXPORT extern const char* Ok;
CORE_EXPORT extern const char* InvalidArgument;
CORE_EXPORT extern const char* MissingIssuerKeys;
CORE_EXPORT extern const char* FailedPrecondition;
CORE_EXPORT extern const char* ResourceExhausted;
CORE_EXPORT extern const char* AlreadyExists;
CORE_EXPORT extern const char* ResourceLimited;
CORE_EXPORT extern const char* Unauthorized;
CORE_EXPORT extern const char* BadResponse;
CORE_EXPORT extern const char* InternalError;
CORE_EXPORT extern const char* UnknownError;
CORE_EXPORT extern const char* FulfilledLocally;
CORE_EXPORT extern const char* SiteIssuerLimit;
} // StatusEnum
} // TrustTokenOperationDone

// ------------- Type and builder declarations.

class CORE_EXPORT ResourceTiming : public ::crdtp::ProtocolObject<ResourceTiming> {
public:
    ~ResourceTiming() override { }

    double getRequestTime() { return m_requestTime; }
    void setRequestTime(double value) { m_requestTime = value; }

    double getProxyStart() { return m_proxyStart; }
    void setProxyStart(double value) { m_proxyStart = value; }

    double getProxyEnd() { return m_proxyEnd; }
    void setProxyEnd(double value) { m_proxyEnd = value; }

    double getDnsStart() { return m_dnsStart; }
    void setDnsStart(double value) { m_dnsStart = value; }

    double getDnsEnd() { return m_dnsEnd; }
    void setDnsEnd(double value) { m_dnsEnd = value; }

    double getConnectStart() { return m_connectStart; }
    void setConnectStart(double value) { m_connectStart = value; }

    double getConnectEnd() { return m_connectEnd; }
    void setConnectEnd(double value) { m_connectEnd = value; }

    double getSslStart() { return m_sslStart; }
    void setSslStart(double value) { m_sslStart = value; }

    double getSslEnd() { return m_sslEnd; }
    void setSslEnd(double value) { m_sslEnd = value; }

    double getWorkerStart() { return m_workerStart; }
    void setWorkerStart(double value) { m_workerStart = value; }

    double getWorkerReady() { return m_workerReady; }
    void setWorkerReady(double value) { m_workerReady = value; }

    double getWorkerFetchStart() { return m_workerFetchStart; }
    void setWorkerFetchStart(double value) { m_workerFetchStart = value; }

    double getWorkerRespondWithSettled() { return m_workerRespondWithSettled; }
    void setWorkerRespondWithSettled(double value) { m_workerRespondWithSettled = value; }

    bool hasWorkerRouterEvaluationStart() { return !!m_workerRouterEvaluationStart; }
    double getWorkerRouterEvaluationStart(double defaultValue) const {
       return m_workerRouterEvaluationStart.value_or(defaultValue);
    }
    const std::optional<double>& getWorkerRouterEvaluationStart() const {
       return m_workerRouterEvaluationStart;
    }
    void setWorkerRouterEvaluationStart(double value) { m_workerRouterEvaluationStart = value; }

    bool hasWorkerCacheLookupStart() { return !!m_workerCacheLookupStart; }
    double getWorkerCacheLookupStart(double defaultValue) const {
       return m_workerCacheLookupStart.value_or(defaultValue);
    }
    const std::optional<double>& getWorkerCacheLookupStart() const {
       return m_workerCacheLookupStart;
    }
    void setWorkerCacheLookupStart(double value) { m_workerCacheLookupStart = value; }

    double getSendStart() { return m_sendStart; }
    void setSendStart(double value) { m_sendStart = value; }

    double getSendEnd() { return m_sendEnd; }
    void setSendEnd(double value) { m_sendEnd = value; }

    double getPushStart() { return m_pushStart; }
    void setPushStart(double value) { m_pushStart = value; }

    double getPushEnd() { return m_pushEnd; }
    void setPushEnd(double value) { m_pushEnd = value; }

    double getReceiveHeadersStart() { return m_receiveHeadersStart; }
    void setReceiveHeadersStart(double value) { m_receiveHeadersStart = value; }

    double getReceiveHeadersEnd() { return m_receiveHeadersEnd; }
    void setReceiveHeadersEnd(double value) { m_receiveHeadersEnd = value; }

    template<int STATE>
    class ResourceTimingBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestTimeSet = 1 << 1,
            ProxyStartSet = 1 << 2,
            ProxyEndSet = 1 << 3,
            DnsStartSet = 1 << 4,
            DnsEndSet = 1 << 5,
            ConnectStartSet = 1 << 6,
            ConnectEndSet = 1 << 7,
            SslStartSet = 1 << 8,
            SslEndSet = 1 << 9,
            WorkerStartSet = 1 << 10,
            WorkerReadySet = 1 << 11,
            WorkerFetchStartSet = 1 << 12,
            WorkerRespondWithSettledSet = 1 << 13,
            SendStartSet = 1 << 14,
            SendEndSet = 1 << 15,
            PushStartSet = 1 << 16,
            PushEndSet = 1 << 17,
            ReceiveHeadersStartSet = 1 << 18,
            ReceiveHeadersEndSet = 1 << 19,
            AllFieldsSet = (RequestTimeSet | ProxyStartSet | ProxyEndSet | DnsStartSet | DnsEndSet | ConnectStartSet | ConnectEndSet | SslStartSet | SslEndSet | WorkerStartSet | WorkerReadySet | WorkerFetchStartSet | WorkerRespondWithSettledSet | SendStartSet | SendEndSet | PushStartSet | PushEndSet | ReceiveHeadersStartSet | ReceiveHeadersEndSet | 0)};


        ResourceTimingBuilder<STATE | RequestTimeSet>& setRequestTime(double value)
        {
            static_assert(!(STATE & RequestTimeSet), "property requestTime should not be set yet");
            m_result->setRequestTime(value);
            return castState<RequestTimeSet>();
        }

        ResourceTimingBuilder<STATE | ProxyStartSet>& setProxyStart(double value)
        {
            static_assert(!(STATE & ProxyStartSet), "property proxyStart should not be set yet");
            m_result->setProxyStart(value);
            return castState<ProxyStartSet>();
        }

        ResourceTimingBuilder<STATE | ProxyEndSet>& setProxyEnd(double value)
        {
            static_assert(!(STATE & ProxyEndSet), "property proxyEnd should not be set yet");
            m_result->setProxyEnd(value);
            return castState<ProxyEndSet>();
        }

        ResourceTimingBuilder<STATE | DnsStartSet>& setDnsStart(double value)
        {
            static_assert(!(STATE & DnsStartSet), "property dnsStart should not be set yet");
            m_result->setDnsStart(value);
            return castState<DnsStartSet>();
        }

        ResourceTimingBuilder<STATE | DnsEndSet>& setDnsEnd(double value)
        {
            static_assert(!(STATE & DnsEndSet), "property dnsEnd should not be set yet");
            m_result->setDnsEnd(value);
            return castState<DnsEndSet>();
        }

        ResourceTimingBuilder<STATE | ConnectStartSet>& setConnectStart(double value)
        {
            static_assert(!(STATE & ConnectStartSet), "property connectStart should not be set yet");
            m_result->setConnectStart(value);
            return castState<ConnectStartSet>();
        }

        ResourceTimingBuilder<STATE | ConnectEndSet>& setConnectEnd(double value)
        {
            static_assert(!(STATE & ConnectEndSet), "property connectEnd should not be set yet");
            m_result->setConnectEnd(value);
            return castState<ConnectEndSet>();
        }

        ResourceTimingBuilder<STATE | SslStartSet>& setSslStart(double value)
        {
            static_assert(!(STATE & SslStartSet), "property sslStart should not be set yet");
            m_result->setSslStart(value);
            return castState<SslStartSet>();
        }

        ResourceTimingBuilder<STATE | SslEndSet>& setSslEnd(double value)
        {
            static_assert(!(STATE & SslEndSet), "property sslEnd should not be set yet");
            m_result->setSslEnd(value);
            return castState<SslEndSet>();
        }

        ResourceTimingBuilder<STATE | WorkerStartSet>& setWorkerStart(double value)
        {
            static_assert(!(STATE & WorkerStartSet), "property workerStart should not be set yet");
            m_result->setWorkerStart(value);
            return castState<WorkerStartSet>();
        }

        ResourceTimingBuilder<STATE | WorkerReadySet>& setWorkerReady(double value)
        {
            static_assert(!(STATE & WorkerReadySet), "property workerReady should not be set yet");
            m_result->setWorkerReady(value);
            return castState<WorkerReadySet>();
        }

        ResourceTimingBuilder<STATE | WorkerFetchStartSet>& setWorkerFetchStart(double value)
        {
            static_assert(!(STATE & WorkerFetchStartSet), "property workerFetchStart should not be set yet");
            m_result->setWorkerFetchStart(value);
            return castState<WorkerFetchStartSet>();
        }

        ResourceTimingBuilder<STATE | WorkerRespondWithSettledSet>& setWorkerRespondWithSettled(double value)
        {
            static_assert(!(STATE & WorkerRespondWithSettledSet), "property workerRespondWithSettled should not be set yet");
            m_result->setWorkerRespondWithSettled(value);
            return castState<WorkerRespondWithSettledSet>();
        }

        ResourceTimingBuilder<STATE>& setWorkerRouterEvaluationStart(double value)
        {
            m_result->setWorkerRouterEvaluationStart(value);
            return *this;
        }

        ResourceTimingBuilder<STATE>& setWorkerCacheLookupStart(double value)
        {
            m_result->setWorkerCacheLookupStart(value);
            return *this;
        }

        ResourceTimingBuilder<STATE | SendStartSet>& setSendStart(double value)
        {
            static_assert(!(STATE & SendStartSet), "property sendStart should not be set yet");
            m_result->setSendStart(value);
            return castState<SendStartSet>();
        }

        ResourceTimingBuilder<STATE | SendEndSet>& setSendEnd(double value)
        {
            static_assert(!(STATE & SendEndSet), "property sendEnd should not be set yet");
            m_result->setSendEnd(value);
            return castState<SendEndSet>();
        }

        ResourceTimingBuilder<STATE | PushStartSet>& setPushStart(double value)
        {
            static_assert(!(STATE & PushStartSet), "property pushStart should not be set yet");
            m_result->setPushStart(value);
            return castState<PushStartSet>();
        }

        ResourceTimingBuilder<STATE | PushEndSet>& setPushEnd(double value)
        {
            static_assert(!(STATE & PushEndSet), "property pushEnd should not be set yet");
            m_result->setPushEnd(value);
            return castState<PushEndSet>();
        }

        ResourceTimingBuilder<STATE | ReceiveHeadersStartSet>& setReceiveHeadersStart(double value)
        {
            static_assert(!(STATE & ReceiveHeadersStartSet), "property receiveHeadersStart should not be set yet");
            m_result->setReceiveHeadersStart(value);
            return castState<ReceiveHeadersStartSet>();
        }

        ResourceTimingBuilder<STATE | ReceiveHeadersEndSet>& setReceiveHeadersEnd(double value)
        {
            static_assert(!(STATE & ReceiveHeadersEndSet), "property receiveHeadersEnd should not be set yet");
            m_result->setReceiveHeadersEnd(value);
            return castState<ReceiveHeadersEndSet>();
        }

        std::unique_ptr<ResourceTiming> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ResourceTiming;
        ResourceTimingBuilder() : m_result(new ResourceTiming()) { }

        template<int STEP> ResourceTimingBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ResourceTimingBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ResourceTiming> m_result;
    };

    static ResourceTimingBuilder<0> create()
    {
        return ResourceTimingBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ResourceTiming()
    {
          m_requestTime = 0;
          m_proxyStart = 0;
          m_proxyEnd = 0;
          m_dnsStart = 0;
          m_dnsEnd = 0;
          m_connectStart = 0;
          m_connectEnd = 0;
          m_sslStart = 0;
          m_sslEnd = 0;
          m_workerStart = 0;
          m_workerReady = 0;
          m_workerFetchStart = 0;
          m_workerRespondWithSettled = 0;
          m_sendStart = 0;
          m_sendEnd = 0;
          m_pushStart = 0;
          m_pushEnd = 0;
          m_receiveHeadersStart = 0;
          m_receiveHeadersEnd = 0;
    }

    double m_requestTime;
    double m_proxyStart;
    double m_proxyEnd;
    double m_dnsStart;
    double m_dnsEnd;
    double m_connectStart;
    double m_connectEnd;
    double m_sslStart;
    double m_sslEnd;
    double m_workerStart;
    double m_workerReady;
    double m_workerFetchStart;
    double m_workerRespondWithSettled;
    std::optional<double> m_workerRouterEvaluationStart;
    std::optional<double> m_workerCacheLookupStart;
    double m_sendStart;
    double m_sendEnd;
    double m_pushStart;
    double m_pushEnd;
    double m_receiveHeadersStart;
    double m_receiveHeadersEnd;
};


class CORE_EXPORT PostDataEntry : public ::crdtp::ProtocolObject<PostDataEntry> {
public:
    ~PostDataEntry() override { }

    bool hasBytes() { return !!m_bytes; }
    Binary getBytes(const Binary& defaultValue) const {
       return m_bytes.value_or(defaultValue);
    }
    const std::optional<Binary>& getBytes() const {
       return m_bytes;
    }
    void setBytes(const Binary& value) { m_bytes = value; }

    template<int STATE>
    class PostDataEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        PostDataEntryBuilder<STATE>& setBytes(const Binary& value)
        {
            m_result->setBytes(value);
            return *this;
        }

        std::unique_ptr<PostDataEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PostDataEntry;
        PostDataEntryBuilder() : m_result(new PostDataEntry()) { }

        template<int STEP> PostDataEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PostDataEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::PostDataEntry> m_result;
    };

    static PostDataEntryBuilder<0> create()
    {
        return PostDataEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PostDataEntry()
    {
    }

    std::optional<Binary> m_bytes;
};


class CORE_EXPORT Request : public ::crdtp::ProtocolObject<Request> {
public:
    ~Request() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    bool hasUrlFragment() { return !!m_urlFragment; }
    String getUrlFragment(const String& defaultValue) const {
       return m_urlFragment.value_or(defaultValue);
    }
    const std::optional<String>& getUrlFragment() const {
       return m_urlFragment;
    }
    void setUrlFragment(const String& value) { m_urlFragment = value; }

    String getMethod() { return m_method; }
    void setMethod(const String& value) { m_method = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    bool hasPostData() { return !!m_postData; }
    String getPostData(const String& defaultValue) const {
       return m_postData.value_or(defaultValue);
    }
    const std::optional<String>& getPostData() const {
       return m_postData;
    }
    void setPostData(const String& value) { m_postData = value; }

    bool hasHasPostData() { return !!m_hasPostData; }
    bool getHasPostData(bool defaultValue) const {
       return m_hasPostData.value_or(defaultValue);
    }
    const std::optional<bool>& getHasPostData() const {
       return m_hasPostData;
    }
    void setHasPostData(bool value) { m_hasPostData = value; }

    bool hasPostDataEntries() { return !!m_postDataEntries; }
    protocol::Array<protocol::Network::PostDataEntry>* getPostDataEntries(protocol::Array<protocol::Network::PostDataEntry>* defaultValue) {
       return m_postDataEntries ? m_postDataEntries.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Network::PostDataEntry>>& getPostDataEntries() const {
       return m_postDataEntries;
    }
    void setPostDataEntries(std::unique_ptr<protocol::Array<protocol::Network::PostDataEntry>> value) { m_postDataEntries = std::move(value); }

    bool hasMixedContentType() { return !!m_mixedContentType; }
    String getMixedContentType(const String& defaultValue) const {
       return m_mixedContentType.value_or(defaultValue);
    }
    const std::optional<String>& getMixedContentType() const {
       return m_mixedContentType;
    }
    void setMixedContentType(const String& value) { m_mixedContentType = value; }

    String getInitialPriority() { return m_initialPriority; }
    void setInitialPriority(const String& value) { m_initialPriority = value; }

    struct CORE_EXPORT ReferrerPolicyEnum {
        static const char* UnsafeUrl;
        static const char* NoReferrerWhenDowngrade;
        static const char* NoReferrer;
        static const char* Origin;
        static const char* OriginWhenCrossOrigin;
        static const char* SameOrigin;
        static const char* StrictOrigin;
        static const char* StrictOriginWhenCrossOrigin;
    }; // ReferrerPolicyEnum

    String getReferrerPolicy() { return m_referrerPolicy; }
    void setReferrerPolicy(const String& value) { m_referrerPolicy = value; }

    bool hasIsLinkPreload() { return !!m_isLinkPreload; }
    bool getIsLinkPreload(bool defaultValue) const {
       return m_isLinkPreload.value_or(defaultValue);
    }
    const std::optional<bool>& getIsLinkPreload() const {
       return m_isLinkPreload;
    }
    void setIsLinkPreload(bool value) { m_isLinkPreload = value; }

    bool hasTrustTokenParams() { return !!m_trustTokenParams; }
    protocol::Network::TrustTokenParams* getTrustTokenParams(protocol::Network::TrustTokenParams* defaultValue) {
       return m_trustTokenParams ? m_trustTokenParams.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::TrustTokenParams>& getTrustTokenParams() const {
       return m_trustTokenParams;
    }
    void setTrustTokenParams(std::unique_ptr<protocol::Network::TrustTokenParams> value) { m_trustTokenParams = std::move(value); }

    bool hasIsSameSite() { return !!m_isSameSite; }
    bool getIsSameSite(bool defaultValue) const {
       return m_isSameSite.value_or(defaultValue);
    }
    const std::optional<bool>& getIsSameSite() const {
       return m_isSameSite;
    }
    void setIsSameSite(bool value) { m_isSameSite = value; }

    bool hasIsAdRelated() { return !!m_isAdRelated; }
    bool getIsAdRelated(bool defaultValue) const {
       return m_isAdRelated.value_or(defaultValue);
    }
    const std::optional<bool>& getIsAdRelated() const {
       return m_isAdRelated;
    }
    void setIsAdRelated(bool value) { m_isAdRelated = value; }

    template<int STATE>
    class RequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            MethodSet = 1 << 2,
            HeadersSet = 1 << 3,
            InitialPrioritySet = 1 << 4,
            ReferrerPolicySet = 1 << 5,
            AllFieldsSet = (UrlSet | MethodSet | HeadersSet | InitialPrioritySet | ReferrerPolicySet | 0)};


        RequestBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        RequestBuilder<STATE>& setUrlFragment(const String& value)
        {
            m_result->setUrlFragment(value);
            return *this;
        }

        RequestBuilder<STATE | MethodSet>& setMethod(const String& value)
        {
            static_assert(!(STATE & MethodSet), "property method should not be set yet");
            m_result->setMethod(value);
            return castState<MethodSet>();
        }

        RequestBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        RequestBuilder<STATE>& setPostData(const String& value)
        {
            m_result->setPostData(value);
            return *this;
        }

        RequestBuilder<STATE>& setHasPostData(bool value)
        {
            m_result->setHasPostData(value);
            return *this;
        }

        RequestBuilder<STATE>& setPostDataEntries(std::unique_ptr<protocol::Array<protocol::Network::PostDataEntry>> value)
        {
            m_result->setPostDataEntries(std::move(value));
            return *this;
        }

        RequestBuilder<STATE>& setMixedContentType(const String& value)
        {
            m_result->setMixedContentType(value);
            return *this;
        }

        RequestBuilder<STATE | InitialPrioritySet>& setInitialPriority(const String& value)
        {
            static_assert(!(STATE & InitialPrioritySet), "property initialPriority should not be set yet");
            m_result->setInitialPriority(value);
            return castState<InitialPrioritySet>();
        }

        RequestBuilder<STATE | ReferrerPolicySet>& setReferrerPolicy(const String& value)
        {
            static_assert(!(STATE & ReferrerPolicySet), "property referrerPolicy should not be set yet");
            m_result->setReferrerPolicy(value);
            return castState<ReferrerPolicySet>();
        }

        RequestBuilder<STATE>& setIsLinkPreload(bool value)
        {
            m_result->setIsLinkPreload(value);
            return *this;
        }

        RequestBuilder<STATE>& setTrustTokenParams(std::unique_ptr<protocol::Network::TrustTokenParams> value)
        {
            m_result->setTrustTokenParams(std::move(value));
            return *this;
        }

        RequestBuilder<STATE>& setIsSameSite(bool value)
        {
            m_result->setIsSameSite(value);
            return *this;
        }

        RequestBuilder<STATE>& setIsAdRelated(bool value)
        {
            m_result->setIsAdRelated(value);
            return *this;
        }

        std::unique_ptr<Request> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Request;
        RequestBuilder() : m_result(new Request()) { }

        template<int STEP> RequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Request> m_result;
    };

    static RequestBuilder<0> create()
    {
        return RequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Request()
    {
    }

    String m_url;
    std::optional<String> m_urlFragment;
    String m_method;
    std::unique_ptr<protocol::Network::Headers> m_headers;
    std::optional<String> m_postData;
    std::optional<bool> m_hasPostData;
    std::unique_ptr<protocol::Array<protocol::Network::PostDataEntry>> m_postDataEntries;
    std::optional<String> m_mixedContentType;
    String m_initialPriority;
    String m_referrerPolicy;
    std::optional<bool> m_isLinkPreload;
    std::unique_ptr<protocol::Network::TrustTokenParams> m_trustTokenParams;
    std::optional<bool> m_isSameSite;
    std::optional<bool> m_isAdRelated;
};


class CORE_EXPORT SignedCertificateTimestamp : public ::crdtp::ProtocolObject<SignedCertificateTimestamp> {
public:
    ~SignedCertificateTimestamp() override { }

    String getStatus() { return m_status; }
    void setStatus(const String& value) { m_status = value; }

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value) { m_origin = value; }

    String getLogDescription() { return m_logDescription; }
    void setLogDescription(const String& value) { m_logDescription = value; }

    String getLogId() { return m_logId; }
    void setLogId(const String& value) { m_logId = value; }

    double getTimestamp() { return m_timestamp; }
    void setTimestamp(double value) { m_timestamp = value; }

    String getHashAlgorithm() { return m_hashAlgorithm; }
    void setHashAlgorithm(const String& value) { m_hashAlgorithm = value; }

    String getSignatureAlgorithm() { return m_signatureAlgorithm; }
    void setSignatureAlgorithm(const String& value) { m_signatureAlgorithm = value; }

    String getSignatureData() { return m_signatureData; }
    void setSignatureData(const String& value) { m_signatureData = value; }

    template<int STATE>
    class SignedCertificateTimestampBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StatusSet = 1 << 1,
            OriginSet = 1 << 2,
            LogDescriptionSet = 1 << 3,
            LogIdSet = 1 << 4,
            TimestampSet = 1 << 5,
            HashAlgorithmSet = 1 << 6,
            SignatureAlgorithmSet = 1 << 7,
            SignatureDataSet = 1 << 8,
            AllFieldsSet = (StatusSet | OriginSet | LogDescriptionSet | LogIdSet | TimestampSet | HashAlgorithmSet | SignatureAlgorithmSet | SignatureDataSet | 0)};


        SignedCertificateTimestampBuilder<STATE | StatusSet>& setStatus(const String& value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->setStatus(value);
            return castState<StatusSet>();
        }

        SignedCertificateTimestampBuilder<STATE | OriginSet>& setOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->setOrigin(value);
            return castState<OriginSet>();
        }

        SignedCertificateTimestampBuilder<STATE | LogDescriptionSet>& setLogDescription(const String& value)
        {
            static_assert(!(STATE & LogDescriptionSet), "property logDescription should not be set yet");
            m_result->setLogDescription(value);
            return castState<LogDescriptionSet>();
        }

        SignedCertificateTimestampBuilder<STATE | LogIdSet>& setLogId(const String& value)
        {
            static_assert(!(STATE & LogIdSet), "property logId should not be set yet");
            m_result->setLogId(value);
            return castState<LogIdSet>();
        }

        SignedCertificateTimestampBuilder<STATE | TimestampSet>& setTimestamp(double value)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
            m_result->setTimestamp(value);
            return castState<TimestampSet>();
        }

        SignedCertificateTimestampBuilder<STATE | HashAlgorithmSet>& setHashAlgorithm(const String& value)
        {
            static_assert(!(STATE & HashAlgorithmSet), "property hashAlgorithm should not be set yet");
            m_result->setHashAlgorithm(value);
            return castState<HashAlgorithmSet>();
        }

        SignedCertificateTimestampBuilder<STATE | SignatureAlgorithmSet>& setSignatureAlgorithm(const String& value)
        {
            static_assert(!(STATE & SignatureAlgorithmSet), "property signatureAlgorithm should not be set yet");
            m_result->setSignatureAlgorithm(value);
            return castState<SignatureAlgorithmSet>();
        }

        SignedCertificateTimestampBuilder<STATE | SignatureDataSet>& setSignatureData(const String& value)
        {
            static_assert(!(STATE & SignatureDataSet), "property signatureData should not be set yet");
            m_result->setSignatureData(value);
            return castState<SignatureDataSet>();
        }

        std::unique_ptr<SignedCertificateTimestamp> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedCertificateTimestamp;
        SignedCertificateTimestampBuilder() : m_result(new SignedCertificateTimestamp()) { }

        template<int STEP> SignedCertificateTimestampBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedCertificateTimestampBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedCertificateTimestamp> m_result;
    };

    static SignedCertificateTimestampBuilder<0> create()
    {
        return SignedCertificateTimestampBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedCertificateTimestamp()
    {
          m_timestamp = 0;
    }

    String m_status;
    String m_origin;
    String m_logDescription;
    String m_logId;
    double m_timestamp;
    String m_hashAlgorithm;
    String m_signatureAlgorithm;
    String m_signatureData;
};


class CORE_EXPORT SecurityDetails : public ::crdtp::ProtocolObject<SecurityDetails> {
public:
    ~SecurityDetails() override { }

    String getProtocol() { return m_protocol; }
    void setProtocol(const String& value) { m_protocol = value; }

    String getKeyExchange() { return m_keyExchange; }
    void setKeyExchange(const String& value) { m_keyExchange = value; }

    bool hasKeyExchangeGroup() { return !!m_keyExchangeGroup; }
    String getKeyExchangeGroup(const String& defaultValue) const {
       return m_keyExchangeGroup.value_or(defaultValue);
    }
    const std::optional<String>& getKeyExchangeGroup() const {
       return m_keyExchangeGroup;
    }
    void setKeyExchangeGroup(const String& value) { m_keyExchangeGroup = value; }

    String getCipher() { return m_cipher; }
    void setCipher(const String& value) { m_cipher = value; }

    bool hasMac() { return !!m_mac; }
    String getMac(const String& defaultValue) const {
       return m_mac.value_or(defaultValue);
    }
    const std::optional<String>& getMac() const {
       return m_mac;
    }
    void setMac(const String& value) { m_mac = value; }

    int getCertificateId() { return m_certificateId; }
    void setCertificateId(int value) { m_certificateId = value; }

    String getSubjectName() { return m_subjectName; }
    void setSubjectName(const String& value) { m_subjectName = value; }

    protocol::Array<String>* getSanList() { return m_sanList.get(); }
    void setSanList(std::unique_ptr<protocol::Array<String>> value) { m_sanList = std::move(value); }

    String getIssuer() { return m_issuer; }
    void setIssuer(const String& value) { m_issuer = value; }

    double getValidFrom() { return m_validFrom; }
    void setValidFrom(double value) { m_validFrom = value; }

    double getValidTo() { return m_validTo; }
    void setValidTo(double value) { m_validTo = value; }

    protocol::Array<protocol::Network::SignedCertificateTimestamp>* getSignedCertificateTimestampList() { return m_signedCertificateTimestampList.get(); }
    void setSignedCertificateTimestampList(std::unique_ptr<protocol::Array<protocol::Network::SignedCertificateTimestamp>> value) { m_signedCertificateTimestampList = std::move(value); }

    String getCertificateTransparencyCompliance() { return m_certificateTransparencyCompliance; }
    void setCertificateTransparencyCompliance(const String& value) { m_certificateTransparencyCompliance = value; }

    bool hasServerSignatureAlgorithm() { return !!m_serverSignatureAlgorithm; }
    int getServerSignatureAlgorithm(int defaultValue) const {
       return m_serverSignatureAlgorithm.value_or(defaultValue);
    }
    const std::optional<int>& getServerSignatureAlgorithm() const {
       return m_serverSignatureAlgorithm;
    }
    void setServerSignatureAlgorithm(int value) { m_serverSignatureAlgorithm = value; }

    bool getEncryptedClientHello() { return m_encryptedClientHello; }
    void setEncryptedClientHello(bool value) { m_encryptedClientHello = value; }

    template<int STATE>
    class SecurityDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProtocolSet = 1 << 1,
            KeyExchangeSet = 1 << 2,
            CipherSet = 1 << 3,
            CertificateIdSet = 1 << 4,
            SubjectNameSet = 1 << 5,
            SanListSet = 1 << 6,
            IssuerSet = 1 << 7,
            ValidFromSet = 1 << 8,
            ValidToSet = 1 << 9,
            SignedCertificateTimestampListSet = 1 << 10,
            CertificateTransparencyComplianceSet = 1 << 11,
            EncryptedClientHelloSet = 1 << 12,
            AllFieldsSet = (ProtocolSet | KeyExchangeSet | CipherSet | CertificateIdSet | SubjectNameSet | SanListSet | IssuerSet | ValidFromSet | ValidToSet | SignedCertificateTimestampListSet | CertificateTransparencyComplianceSet | EncryptedClientHelloSet | 0)};


        SecurityDetailsBuilder<STATE | ProtocolSet>& setProtocol(const String& value)
        {
            static_assert(!(STATE & ProtocolSet), "property protocol should not be set yet");
            m_result->setProtocol(value);
            return castState<ProtocolSet>();
        }

        SecurityDetailsBuilder<STATE | KeyExchangeSet>& setKeyExchange(const String& value)
        {
            static_assert(!(STATE & KeyExchangeSet), "property keyExchange should not be set yet");
            m_result->setKeyExchange(value);
            return castState<KeyExchangeSet>();
        }

        SecurityDetailsBuilder<STATE>& setKeyExchangeGroup(const String& value)
        {
            m_result->setKeyExchangeGroup(value);
            return *this;
        }

        SecurityDetailsBuilder<STATE | CipherSet>& setCipher(const String& value)
        {
            static_assert(!(STATE & CipherSet), "property cipher should not be set yet");
            m_result->setCipher(value);
            return castState<CipherSet>();
        }

        SecurityDetailsBuilder<STATE>& setMac(const String& value)
        {
            m_result->setMac(value);
            return *this;
        }

        SecurityDetailsBuilder<STATE | CertificateIdSet>& setCertificateId(int value)
        {
            static_assert(!(STATE & CertificateIdSet), "property certificateId should not be set yet");
            m_result->setCertificateId(value);
            return castState<CertificateIdSet>();
        }

        SecurityDetailsBuilder<STATE | SubjectNameSet>& setSubjectName(const String& value)
        {
            static_assert(!(STATE & SubjectNameSet), "property subjectName should not be set yet");
            m_result->setSubjectName(value);
            return castState<SubjectNameSet>();
        }

        SecurityDetailsBuilder<STATE | SanListSet>& setSanList(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & SanListSet), "property sanList should not be set yet");
            m_result->setSanList(std::move(value));
            return castState<SanListSet>();
        }

        SecurityDetailsBuilder<STATE | IssuerSet>& setIssuer(const String& value)
        {
            static_assert(!(STATE & IssuerSet), "property issuer should not be set yet");
            m_result->setIssuer(value);
            return castState<IssuerSet>();
        }

        SecurityDetailsBuilder<STATE | ValidFromSet>& setValidFrom(double value)
        {
            static_assert(!(STATE & ValidFromSet), "property validFrom should not be set yet");
            m_result->setValidFrom(value);
            return castState<ValidFromSet>();
        }

        SecurityDetailsBuilder<STATE | ValidToSet>& setValidTo(double value)
        {
            static_assert(!(STATE & ValidToSet), "property validTo should not be set yet");
            m_result->setValidTo(value);
            return castState<ValidToSet>();
        }

        SecurityDetailsBuilder<STATE | SignedCertificateTimestampListSet>& setSignedCertificateTimestampList(std::unique_ptr<protocol::Array<protocol::Network::SignedCertificateTimestamp>> value)
        {
            static_assert(!(STATE & SignedCertificateTimestampListSet), "property signedCertificateTimestampList should not be set yet");
            m_result->setSignedCertificateTimestampList(std::move(value));
            return castState<SignedCertificateTimestampListSet>();
        }

        SecurityDetailsBuilder<STATE | CertificateTransparencyComplianceSet>& setCertificateTransparencyCompliance(const String& value)
        {
            static_assert(!(STATE & CertificateTransparencyComplianceSet), "property certificateTransparencyCompliance should not be set yet");
            m_result->setCertificateTransparencyCompliance(value);
            return castState<CertificateTransparencyComplianceSet>();
        }

        SecurityDetailsBuilder<STATE>& setServerSignatureAlgorithm(int value)
        {
            m_result->setServerSignatureAlgorithm(value);
            return *this;
        }

        SecurityDetailsBuilder<STATE | EncryptedClientHelloSet>& setEncryptedClientHello(bool value)
        {
            static_assert(!(STATE & EncryptedClientHelloSet), "property encryptedClientHello should not be set yet");
            m_result->setEncryptedClientHello(value);
            return castState<EncryptedClientHelloSet>();
        }

        std::unique_ptr<SecurityDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SecurityDetails;
        SecurityDetailsBuilder() : m_result(new SecurityDetails()) { }

        template<int STEP> SecurityDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SecurityDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SecurityDetails> m_result;
    };

    static SecurityDetailsBuilder<0> create()
    {
        return SecurityDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SecurityDetails()
    {
          m_certificateId = 0;
          m_validFrom = 0;
          m_validTo = 0;
          m_encryptedClientHello = false;
    }

    String m_protocol;
    String m_keyExchange;
    std::optional<String> m_keyExchangeGroup;
    String m_cipher;
    std::optional<String> m_mac;
    int m_certificateId;
    String m_subjectName;
    std::unique_ptr<protocol::Array<String>> m_sanList;
    String m_issuer;
    double m_validFrom;
    double m_validTo;
    std::unique_ptr<protocol::Array<protocol::Network::SignedCertificateTimestamp>> m_signedCertificateTimestampList;
    String m_certificateTransparencyCompliance;
    std::optional<int> m_serverSignatureAlgorithm;
    bool m_encryptedClientHello;
};


class CORE_EXPORT CorsErrorStatus : public ::crdtp::ProtocolObject<CorsErrorStatus> {
public:
    ~CorsErrorStatus() override { }

    String getCorsError() { return m_corsError; }
    void setCorsError(const String& value) { m_corsError = value; }

    String getFailedParameter() { return m_failedParameter; }
    void setFailedParameter(const String& value) { m_failedParameter = value; }

    template<int STATE>
    class CorsErrorStatusBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CorsErrorSet = 1 << 1,
            FailedParameterSet = 1 << 2,
            AllFieldsSet = (CorsErrorSet | FailedParameterSet | 0)};


        CorsErrorStatusBuilder<STATE | CorsErrorSet>& setCorsError(const String& value)
        {
            static_assert(!(STATE & CorsErrorSet), "property corsError should not be set yet");
            m_result->setCorsError(value);
            return castState<CorsErrorSet>();
        }

        CorsErrorStatusBuilder<STATE | FailedParameterSet>& setFailedParameter(const String& value)
        {
            static_assert(!(STATE & FailedParameterSet), "property failedParameter should not be set yet");
            m_result->setFailedParameter(value);
            return castState<FailedParameterSet>();
        }

        std::unique_ptr<CorsErrorStatus> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CorsErrorStatus;
        CorsErrorStatusBuilder() : m_result(new CorsErrorStatus()) { }

        template<int STEP> CorsErrorStatusBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CorsErrorStatusBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::CorsErrorStatus> m_result;
    };

    static CorsErrorStatusBuilder<0> create()
    {
        return CorsErrorStatusBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CorsErrorStatus()
    {
    }

    String m_corsError;
    String m_failedParameter;
};


class CORE_EXPORT TrustTokenParams : public ::crdtp::ProtocolObject<TrustTokenParams> {
public:
    ~TrustTokenParams() override { }

    String getOperation() { return m_operation; }
    void setOperation(const String& value) { m_operation = value; }

    struct CORE_EXPORT RefreshPolicyEnum {
        static const char* UseCached;
        static const char* Refresh;
    }; // RefreshPolicyEnum

    String getRefreshPolicy() { return m_refreshPolicy; }
    void setRefreshPolicy(const String& value) { m_refreshPolicy = value; }

    bool hasIssuers() { return !!m_issuers; }
    protocol::Array<String>* getIssuers(protocol::Array<String>* defaultValue) {
       return m_issuers ? m_issuers.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getIssuers() const {
       return m_issuers;
    }
    void setIssuers(std::unique_ptr<protocol::Array<String>> value) { m_issuers = std::move(value); }

    template<int STATE>
    class TrustTokenParamsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OperationSet = 1 << 1,
            RefreshPolicySet = 1 << 2,
            AllFieldsSet = (OperationSet | RefreshPolicySet | 0)};


        TrustTokenParamsBuilder<STATE | OperationSet>& setOperation(const String& value)
        {
            static_assert(!(STATE & OperationSet), "property operation should not be set yet");
            m_result->setOperation(value);
            return castState<OperationSet>();
        }

        TrustTokenParamsBuilder<STATE | RefreshPolicySet>& setRefreshPolicy(const String& value)
        {
            static_assert(!(STATE & RefreshPolicySet), "property refreshPolicy should not be set yet");
            m_result->setRefreshPolicy(value);
            return castState<RefreshPolicySet>();
        }

        TrustTokenParamsBuilder<STATE>& setIssuers(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->setIssuers(std::move(value));
            return *this;
        }

        std::unique_ptr<TrustTokenParams> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TrustTokenParams;
        TrustTokenParamsBuilder() : m_result(new TrustTokenParams()) { }

        template<int STEP> TrustTokenParamsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TrustTokenParamsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::TrustTokenParams> m_result;
    };

    static TrustTokenParamsBuilder<0> create()
    {
        return TrustTokenParamsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TrustTokenParams()
    {
    }

    String m_operation;
    String m_refreshPolicy;
    std::unique_ptr<protocol::Array<String>> m_issuers;
};


class CORE_EXPORT ServiceWorkerRouterInfo : public ::crdtp::ProtocolObject<ServiceWorkerRouterInfo> {
public:
    ~ServiceWorkerRouterInfo() override { }

    bool hasRuleIdMatched() { return !!m_ruleIdMatched; }
    int getRuleIdMatched(int defaultValue) const {
       return m_ruleIdMatched.value_or(defaultValue);
    }
    const std::optional<int>& getRuleIdMatched() const {
       return m_ruleIdMatched;
    }
    void setRuleIdMatched(int value) { m_ruleIdMatched = value; }

    bool hasMatchedSourceType() { return !!m_matchedSourceType; }
    String getMatchedSourceType(const String& defaultValue) const {
       return m_matchedSourceType.value_or(defaultValue);
    }
    const std::optional<String>& getMatchedSourceType() const {
       return m_matchedSourceType;
    }
    void setMatchedSourceType(const String& value) { m_matchedSourceType = value; }

    bool hasActualSourceType() { return !!m_actualSourceType; }
    String getActualSourceType(const String& defaultValue) const {
       return m_actualSourceType.value_or(defaultValue);
    }
    const std::optional<String>& getActualSourceType() const {
       return m_actualSourceType;
    }
    void setActualSourceType(const String& value) { m_actualSourceType = value; }

    template<int STATE>
    class ServiceWorkerRouterInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        ServiceWorkerRouterInfoBuilder<STATE>& setRuleIdMatched(int value)
        {
            m_result->setRuleIdMatched(value);
            return *this;
        }

        ServiceWorkerRouterInfoBuilder<STATE>& setMatchedSourceType(const String& value)
        {
            m_result->setMatchedSourceType(value);
            return *this;
        }

        ServiceWorkerRouterInfoBuilder<STATE>& setActualSourceType(const String& value)
        {
            m_result->setActualSourceType(value);
            return *this;
        }

        std::unique_ptr<ServiceWorkerRouterInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ServiceWorkerRouterInfo;
        ServiceWorkerRouterInfoBuilder() : m_result(new ServiceWorkerRouterInfo()) { }

        template<int STEP> ServiceWorkerRouterInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ServiceWorkerRouterInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo> m_result;
    };

    static ServiceWorkerRouterInfoBuilder<0> create()
    {
        return ServiceWorkerRouterInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ServiceWorkerRouterInfo()
    {
    }

    std::optional<int> m_ruleIdMatched;
    std::optional<String> m_matchedSourceType;
    std::optional<String> m_actualSourceType;
};


class CORE_EXPORT Response : public ::crdtp::ProtocolObject<Response> {
public:
    ~Response() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    int getStatus() { return m_status; }
    void setStatus(int value) { m_status = value; }

    String getStatusText() { return m_statusText; }
    void setStatusText(const String& value) { m_statusText = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    bool hasHeadersText() { return !!m_headersText; }
    String getHeadersText(const String& defaultValue) const {
       return m_headersText.value_or(defaultValue);
    }
    const std::optional<String>& getHeadersText() const {
       return m_headersText;
    }
    void setHeadersText(const String& value) { m_headersText = value; }

    String getMimeType() { return m_mimeType; }
    void setMimeType(const String& value) { m_mimeType = value; }

    String getCharset() { return m_charset; }
    void setCharset(const String& value) { m_charset = value; }

    bool hasRequestHeaders() { return !!m_requestHeaders; }
    protocol::Network::Headers* getRequestHeaders(protocol::Network::Headers* defaultValue) {
       return m_requestHeaders ? m_requestHeaders.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::Headers>& getRequestHeaders() const {
       return m_requestHeaders;
    }
    void setRequestHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_requestHeaders = std::move(value); }

    bool hasRequestHeadersText() { return !!m_requestHeadersText; }
    String getRequestHeadersText(const String& defaultValue) const {
       return m_requestHeadersText.value_or(defaultValue);
    }
    const std::optional<String>& getRequestHeadersText() const {
       return m_requestHeadersText;
    }
    void setRequestHeadersText(const String& value) { m_requestHeadersText = value; }

    bool getConnectionReused() { return m_connectionReused; }
    void setConnectionReused(bool value) { m_connectionReused = value; }

    double getConnectionId() { return m_connectionId; }
    void setConnectionId(double value) { m_connectionId = value; }

    bool hasRemoteIPAddress() { return !!m_remoteIPAddress; }
    String getRemoteIPAddress(const String& defaultValue) const {
       return m_remoteIPAddress.value_or(defaultValue);
    }
    const std::optional<String>& getRemoteIPAddress() const {
       return m_remoteIPAddress;
    }
    void setRemoteIPAddress(const String& value) { m_remoteIPAddress = value; }

    bool hasRemotePort() { return !!m_remotePort; }
    int getRemotePort(int defaultValue) const {
       return m_remotePort.value_or(defaultValue);
    }
    const std::optional<int>& getRemotePort() const {
       return m_remotePort;
    }
    void setRemotePort(int value) { m_remotePort = value; }

    bool hasFromDiskCache() { return !!m_fromDiskCache; }
    bool getFromDiskCache(bool defaultValue) const {
       return m_fromDiskCache.value_or(defaultValue);
    }
    const std::optional<bool>& getFromDiskCache() const {
       return m_fromDiskCache;
    }
    void setFromDiskCache(bool value) { m_fromDiskCache = value; }

    bool hasFromServiceWorker() { return !!m_fromServiceWorker; }
    bool getFromServiceWorker(bool defaultValue) const {
       return m_fromServiceWorker.value_or(defaultValue);
    }
    const std::optional<bool>& getFromServiceWorker() const {
       return m_fromServiceWorker;
    }
    void setFromServiceWorker(bool value) { m_fromServiceWorker = value; }

    bool hasFromPrefetchCache() { return !!m_fromPrefetchCache; }
    bool getFromPrefetchCache(bool defaultValue) const {
       return m_fromPrefetchCache.value_or(defaultValue);
    }
    const std::optional<bool>& getFromPrefetchCache() const {
       return m_fromPrefetchCache;
    }
    void setFromPrefetchCache(bool value) { m_fromPrefetchCache = value; }

    bool hasFromEarlyHints() { return !!m_fromEarlyHints; }
    bool getFromEarlyHints(bool defaultValue) const {
       return m_fromEarlyHints.value_or(defaultValue);
    }
    const std::optional<bool>& getFromEarlyHints() const {
       return m_fromEarlyHints;
    }
    void setFromEarlyHints(bool value) { m_fromEarlyHints = value; }

    bool hasServiceWorkerRouterInfo() { return !!m_serviceWorkerRouterInfo; }
    protocol::Network::ServiceWorkerRouterInfo* getServiceWorkerRouterInfo(protocol::Network::ServiceWorkerRouterInfo* defaultValue) {
       return m_serviceWorkerRouterInfo ? m_serviceWorkerRouterInfo.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo>& getServiceWorkerRouterInfo() const {
       return m_serviceWorkerRouterInfo;
    }
    void setServiceWorkerRouterInfo(std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo> value) { m_serviceWorkerRouterInfo = std::move(value); }

    double getEncodedDataLength() { return m_encodedDataLength; }
    void setEncodedDataLength(double value) { m_encodedDataLength = value; }

    bool hasTiming() { return !!m_timing; }
    protocol::Network::ResourceTiming* getTiming(protocol::Network::ResourceTiming* defaultValue) {
       return m_timing ? m_timing.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::ResourceTiming>& getTiming() const {
       return m_timing;
    }
    void setTiming(std::unique_ptr<protocol::Network::ResourceTiming> value) { m_timing = std::move(value); }

    bool hasServiceWorkerResponseSource() { return !!m_serviceWorkerResponseSource; }
    String getServiceWorkerResponseSource(const String& defaultValue) const {
       return m_serviceWorkerResponseSource.value_or(defaultValue);
    }
    const std::optional<String>& getServiceWorkerResponseSource() const {
       return m_serviceWorkerResponseSource;
    }
    void setServiceWorkerResponseSource(const String& value) { m_serviceWorkerResponseSource = value; }

    bool hasResponseTime() { return !!m_responseTime; }
    double getResponseTime(double defaultValue) const {
       return m_responseTime.value_or(defaultValue);
    }
    const std::optional<double>& getResponseTime() const {
       return m_responseTime;
    }
    void setResponseTime(double value) { m_responseTime = value; }

    bool hasCacheStorageCacheName() { return !!m_cacheStorageCacheName; }
    String getCacheStorageCacheName(const String& defaultValue) const {
       return m_cacheStorageCacheName.value_or(defaultValue);
    }
    const std::optional<String>& getCacheStorageCacheName() const {
       return m_cacheStorageCacheName;
    }
    void setCacheStorageCacheName(const String& value) { m_cacheStorageCacheName = value; }

    bool hasProtocol() { return !!m_protocol; }
    String getProtocol(const String& defaultValue) const {
       return m_protocol.value_or(defaultValue);
    }
    const std::optional<String>& getProtocol() const {
       return m_protocol;
    }
    void setProtocol(const String& value) { m_protocol = value; }

    bool hasAlternateProtocolUsage() { return !!m_alternateProtocolUsage; }
    String getAlternateProtocolUsage(const String& defaultValue) const {
       return m_alternateProtocolUsage.value_or(defaultValue);
    }
    const std::optional<String>& getAlternateProtocolUsage() const {
       return m_alternateProtocolUsage;
    }
    void setAlternateProtocolUsage(const String& value) { m_alternateProtocolUsage = value; }

    String getSecurityState() { return m_securityState; }
    void setSecurityState(const String& value) { m_securityState = value; }

    bool hasSecurityDetails() { return !!m_securityDetails; }
    protocol::Network::SecurityDetails* getSecurityDetails(protocol::Network::SecurityDetails* defaultValue) {
       return m_securityDetails ? m_securityDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::SecurityDetails>& getSecurityDetails() const {
       return m_securityDetails;
    }
    void setSecurityDetails(std::unique_ptr<protocol::Network::SecurityDetails> value) { m_securityDetails = std::move(value); }

    bool hasIsIpProtectionUsed() { return !!m_isIpProtectionUsed; }
    bool getIsIpProtectionUsed(bool defaultValue) const {
       return m_isIpProtectionUsed.value_or(defaultValue);
    }
    const std::optional<bool>& getIsIpProtectionUsed() const {
       return m_isIpProtectionUsed;
    }
    void setIsIpProtectionUsed(bool value) { m_isIpProtectionUsed = value; }

    template<int STATE>
    class ResponseBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            StatusSet = 1 << 2,
            StatusTextSet = 1 << 3,
            HeadersSet = 1 << 4,
            MimeTypeSet = 1 << 5,
            CharsetSet = 1 << 6,
            ConnectionReusedSet = 1 << 7,
            ConnectionIdSet = 1 << 8,
            EncodedDataLengthSet = 1 << 9,
            SecurityStateSet = 1 << 10,
            AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | MimeTypeSet | CharsetSet | ConnectionReusedSet | ConnectionIdSet | EncodedDataLengthSet | SecurityStateSet | 0)};


        ResponseBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        ResponseBuilder<STATE | StatusSet>& setStatus(int value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->setStatus(value);
            return castState<StatusSet>();
        }

        ResponseBuilder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            static_assert(!(STATE & StatusTextSet), "property statusText should not be set yet");
            m_result->setStatusText(value);
            return castState<StatusTextSet>();
        }

        ResponseBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        ResponseBuilder<STATE>& setHeadersText(const String& value)
        {
            m_result->setHeadersText(value);
            return *this;
        }

        ResponseBuilder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            static_assert(!(STATE & MimeTypeSet), "property mimeType should not be set yet");
            m_result->setMimeType(value);
            return castState<MimeTypeSet>();
        }

        ResponseBuilder<STATE | CharsetSet>& setCharset(const String& value)
        {
            static_assert(!(STATE & CharsetSet), "property charset should not be set yet");
            m_result->setCharset(value);
            return castState<CharsetSet>();
        }

        ResponseBuilder<STATE>& setRequestHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            m_result->setRequestHeaders(std::move(value));
            return *this;
        }

        ResponseBuilder<STATE>& setRequestHeadersText(const String& value)
        {
            m_result->setRequestHeadersText(value);
            return *this;
        }

        ResponseBuilder<STATE | ConnectionReusedSet>& setConnectionReused(bool value)
        {
            static_assert(!(STATE & ConnectionReusedSet), "property connectionReused should not be set yet");
            m_result->setConnectionReused(value);
            return castState<ConnectionReusedSet>();
        }

        ResponseBuilder<STATE | ConnectionIdSet>& setConnectionId(double value)
        {
            static_assert(!(STATE & ConnectionIdSet), "property connectionId should not be set yet");
            m_result->setConnectionId(value);
            return castState<ConnectionIdSet>();
        }

        ResponseBuilder<STATE>& setRemoteIPAddress(const String& value)
        {
            m_result->setRemoteIPAddress(value);
            return *this;
        }

        ResponseBuilder<STATE>& setRemotePort(int value)
        {
            m_result->setRemotePort(value);
            return *this;
        }

        ResponseBuilder<STATE>& setFromDiskCache(bool value)
        {
            m_result->setFromDiskCache(value);
            return *this;
        }

        ResponseBuilder<STATE>& setFromServiceWorker(bool value)
        {
            m_result->setFromServiceWorker(value);
            return *this;
        }

        ResponseBuilder<STATE>& setFromPrefetchCache(bool value)
        {
            m_result->setFromPrefetchCache(value);
            return *this;
        }

        ResponseBuilder<STATE>& setFromEarlyHints(bool value)
        {
            m_result->setFromEarlyHints(value);
            return *this;
        }

        ResponseBuilder<STATE>& setServiceWorkerRouterInfo(std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo> value)
        {
            m_result->setServiceWorkerRouterInfo(std::move(value));
            return *this;
        }

        ResponseBuilder<STATE | EncodedDataLengthSet>& setEncodedDataLength(double value)
        {
            static_assert(!(STATE & EncodedDataLengthSet), "property encodedDataLength should not be set yet");
            m_result->setEncodedDataLength(value);
            return castState<EncodedDataLengthSet>();
        }

        ResponseBuilder<STATE>& setTiming(std::unique_ptr<protocol::Network::ResourceTiming> value)
        {
            m_result->setTiming(std::move(value));
            return *this;
        }

        ResponseBuilder<STATE>& setServiceWorkerResponseSource(const String& value)
        {
            m_result->setServiceWorkerResponseSource(value);
            return *this;
        }

        ResponseBuilder<STATE>& setResponseTime(double value)
        {
            m_result->setResponseTime(value);
            return *this;
        }

        ResponseBuilder<STATE>& setCacheStorageCacheName(const String& value)
        {
            m_result->setCacheStorageCacheName(value);
            return *this;
        }

        ResponseBuilder<STATE>& setProtocol(const String& value)
        {
            m_result->setProtocol(value);
            return *this;
        }

        ResponseBuilder<STATE>& setAlternateProtocolUsage(const String& value)
        {
            m_result->setAlternateProtocolUsage(value);
            return *this;
        }

        ResponseBuilder<STATE | SecurityStateSet>& setSecurityState(const String& value)
        {
            static_assert(!(STATE & SecurityStateSet), "property securityState should not be set yet");
            m_result->setSecurityState(value);
            return castState<SecurityStateSet>();
        }

        ResponseBuilder<STATE>& setSecurityDetails(std::unique_ptr<protocol::Network::SecurityDetails> value)
        {
            m_result->setSecurityDetails(std::move(value));
            return *this;
        }

        ResponseBuilder<STATE>& setIsIpProtectionUsed(bool value)
        {
            m_result->setIsIpProtectionUsed(value);
            return *this;
        }

        std::unique_ptr<Response> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Response;
        ResponseBuilder() : m_result(new Response()) { }

        template<int STEP> ResponseBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ResponseBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Response> m_result;
    };

    static ResponseBuilder<0> create()
    {
        return ResponseBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Response()
    {
          m_status = 0;
          m_connectionReused = false;
          m_connectionId = 0;
          m_encodedDataLength = 0;
    }

    String m_url;
    int m_status;
    String m_statusText;
    std::unique_ptr<protocol::Network::Headers> m_headers;
    std::optional<String> m_headersText;
    String m_mimeType;
    String m_charset;
    std::unique_ptr<protocol::Network::Headers> m_requestHeaders;
    std::optional<String> m_requestHeadersText;
    bool m_connectionReused;
    double m_connectionId;
    std::optional<String> m_remoteIPAddress;
    std::optional<int> m_remotePort;
    std::optional<bool> m_fromDiskCache;
    std::optional<bool> m_fromServiceWorker;
    std::optional<bool> m_fromPrefetchCache;
    std::optional<bool> m_fromEarlyHints;
    std::unique_ptr<protocol::Network::ServiceWorkerRouterInfo> m_serviceWorkerRouterInfo;
    double m_encodedDataLength;
    std::unique_ptr<protocol::Network::ResourceTiming> m_timing;
    std::optional<String> m_serviceWorkerResponseSource;
    std::optional<double> m_responseTime;
    std::optional<String> m_cacheStorageCacheName;
    std::optional<String> m_protocol;
    std::optional<String> m_alternateProtocolUsage;
    String m_securityState;
    std::unique_ptr<protocol::Network::SecurityDetails> m_securityDetails;
    std::optional<bool> m_isIpProtectionUsed;
};


class CORE_EXPORT WebSocketRequest : public ::crdtp::ProtocolObject<WebSocketRequest> {
public:
    ~WebSocketRequest() override { }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    template<int STATE>
    class WebSocketRequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            HeadersSet = 1 << 1,
            AllFieldsSet = (HeadersSet | 0)};


        WebSocketRequestBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        std::unique_ptr<WebSocketRequest> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WebSocketRequest;
        WebSocketRequestBuilder() : m_result(new WebSocketRequest()) { }

        template<int STEP> WebSocketRequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WebSocketRequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::WebSocketRequest> m_result;
    };

    static WebSocketRequestBuilder<0> create()
    {
        return WebSocketRequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WebSocketRequest()
    {
    }

    std::unique_ptr<protocol::Network::Headers> m_headers;
};


class CORE_EXPORT WebSocketResponse : public ::crdtp::ProtocolObject<WebSocketResponse> {
public:
    ~WebSocketResponse() override { }

    int getStatus() { return m_status; }
    void setStatus(int value) { m_status = value; }

    String getStatusText() { return m_statusText; }
    void setStatusText(const String& value) { m_statusText = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    bool hasHeadersText() { return !!m_headersText; }
    String getHeadersText(const String& defaultValue) const {
       return m_headersText.value_or(defaultValue);
    }
    const std::optional<String>& getHeadersText() const {
       return m_headersText;
    }
    void setHeadersText(const String& value) { m_headersText = value; }

    bool hasRequestHeaders() { return !!m_requestHeaders; }
    protocol::Network::Headers* getRequestHeaders(protocol::Network::Headers* defaultValue) {
       return m_requestHeaders ? m_requestHeaders.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::Headers>& getRequestHeaders() const {
       return m_requestHeaders;
    }
    void setRequestHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_requestHeaders = std::move(value); }

    bool hasRequestHeadersText() { return !!m_requestHeadersText; }
    String getRequestHeadersText(const String& defaultValue) const {
       return m_requestHeadersText.value_or(defaultValue);
    }
    const std::optional<String>& getRequestHeadersText() const {
       return m_requestHeadersText;
    }
    void setRequestHeadersText(const String& value) { m_requestHeadersText = value; }

    template<int STATE>
    class WebSocketResponseBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StatusSet = 1 << 1,
            StatusTextSet = 1 << 2,
            HeadersSet = 1 << 3,
            AllFieldsSet = (StatusSet | StatusTextSet | HeadersSet | 0)};


        WebSocketResponseBuilder<STATE | StatusSet>& setStatus(int value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->setStatus(value);
            return castState<StatusSet>();
        }

        WebSocketResponseBuilder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            static_assert(!(STATE & StatusTextSet), "property statusText should not be set yet");
            m_result->setStatusText(value);
            return castState<StatusTextSet>();
        }

        WebSocketResponseBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        WebSocketResponseBuilder<STATE>& setHeadersText(const String& value)
        {
            m_result->setHeadersText(value);
            return *this;
        }

        WebSocketResponseBuilder<STATE>& setRequestHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            m_result->setRequestHeaders(std::move(value));
            return *this;
        }

        WebSocketResponseBuilder<STATE>& setRequestHeadersText(const String& value)
        {
            m_result->setRequestHeadersText(value);
            return *this;
        }

        std::unique_ptr<WebSocketResponse> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WebSocketResponse;
        WebSocketResponseBuilder() : m_result(new WebSocketResponse()) { }

        template<int STEP> WebSocketResponseBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WebSocketResponseBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::WebSocketResponse> m_result;
    };

    static WebSocketResponseBuilder<0> create()
    {
        return WebSocketResponseBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WebSocketResponse()
    {
          m_status = 0;
    }

    int m_status;
    String m_statusText;
    std::unique_ptr<protocol::Network::Headers> m_headers;
    std::optional<String> m_headersText;
    std::unique_ptr<protocol::Network::Headers> m_requestHeaders;
    std::optional<String> m_requestHeadersText;
};


class CORE_EXPORT WebSocketFrame : public ::crdtp::ProtocolObject<WebSocketFrame> {
public:
    ~WebSocketFrame() override { }

    double getOpcode() { return m_opcode; }
    void setOpcode(double value) { m_opcode = value; }

    bool getMask() { return m_mask; }
    void setMask(bool value) { m_mask = value; }

    String getPayloadData() { return m_payloadData; }
    void setPayloadData(const String& value) { m_payloadData = value; }

    template<int STATE>
    class WebSocketFrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OpcodeSet = 1 << 1,
            MaskSet = 1 << 2,
            PayloadDataSet = 1 << 3,
            AllFieldsSet = (OpcodeSet | MaskSet | PayloadDataSet | 0)};


        WebSocketFrameBuilder<STATE | OpcodeSet>& setOpcode(double value)
        {
            static_assert(!(STATE & OpcodeSet), "property opcode should not be set yet");
            m_result->setOpcode(value);
            return castState<OpcodeSet>();
        }

        WebSocketFrameBuilder<STATE | MaskSet>& setMask(bool value)
        {
            static_assert(!(STATE & MaskSet), "property mask should not be set yet");
            m_result->setMask(value);
            return castState<MaskSet>();
        }

        WebSocketFrameBuilder<STATE | PayloadDataSet>& setPayloadData(const String& value)
        {
            static_assert(!(STATE & PayloadDataSet), "property payloadData should not be set yet");
            m_result->setPayloadData(value);
            return castState<PayloadDataSet>();
        }

        std::unique_ptr<WebSocketFrame> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WebSocketFrame;
        WebSocketFrameBuilder() : m_result(new WebSocketFrame()) { }

        template<int STEP> WebSocketFrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WebSocketFrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::WebSocketFrame> m_result;
    };

    static WebSocketFrameBuilder<0> create()
    {
        return WebSocketFrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WebSocketFrame()
    {
          m_opcode = 0;
          m_mask = false;
    }

    double m_opcode;
    bool m_mask;
    String m_payloadData;
};


class CORE_EXPORT Initiator : public ::crdtp::ProtocolObject<Initiator> {
public:
    ~Initiator() override { }

    struct CORE_EXPORT TypeEnum {
        static const char* Parser;
        static const char* Script;
        static const char* Preload;
        static const char* SignedExchange;
        static const char* Preflight;
        static const char* Other;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    bool hasStack() { return !!m_stack; }
    v8_inspector::protocol::Runtime::API::StackTrace* getStack(v8_inspector::protocol::Runtime::API::StackTrace* defaultValue) {
       return m_stack ? m_stack.get() : defaultValue;
    }
    const std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace>& getStack() const {
       return m_stack;
    }
    void setStack(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value) { m_stack = std::move(value); }

    bool hasUrl() { return !!m_url; }
    String getUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& getUrl() const {
       return m_url;
    }
    void setUrl(const String& value) { m_url = value; }

    bool hasLineNumber() { return !!m_lineNumber; }
    double getLineNumber(double defaultValue) const {
       return m_lineNumber.value_or(defaultValue);
    }
    const std::optional<double>& getLineNumber() const {
       return m_lineNumber;
    }
    void setLineNumber(double value) { m_lineNumber = value; }

    bool hasColumnNumber() { return !!m_columnNumber; }
    double getColumnNumber(double defaultValue) const {
       return m_columnNumber.value_or(defaultValue);
    }
    const std::optional<double>& getColumnNumber() const {
       return m_columnNumber;
    }
    void setColumnNumber(double value) { m_columnNumber = value; }

    bool hasRequestId() { return !!m_requestId; }
    String getRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& getRequestId() const {
       return m_requestId;
    }
    void setRequestId(const String& value) { m_requestId = value; }

    template<int STATE>
    class InitiatorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        InitiatorBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        InitiatorBuilder<STATE>& setStack(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value)
        {
            m_result->setStack(std::move(value));
            return *this;
        }

        InitiatorBuilder<STATE>& setUrl(const String& value)
        {
            m_result->setUrl(value);
            return *this;
        }

        InitiatorBuilder<STATE>& setLineNumber(double value)
        {
            m_result->setLineNumber(value);
            return *this;
        }

        InitiatorBuilder<STATE>& setColumnNumber(double value)
        {
            m_result->setColumnNumber(value);
            return *this;
        }

        InitiatorBuilder<STATE>& setRequestId(const String& value)
        {
            m_result->setRequestId(value);
            return *this;
        }

        std::unique_ptr<Initiator> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Initiator;
        InitiatorBuilder() : m_result(new Initiator()) { }

        template<int STEP> InitiatorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InitiatorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Initiator> m_result;
    };

    static InitiatorBuilder<0> create()
    {
        return InitiatorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Initiator()
    {
    }

    String m_type;
    std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> m_stack;
    std::optional<String> m_url;
    std::optional<double> m_lineNumber;
    std::optional<double> m_columnNumber;
    std::optional<String> m_requestId;
};


class CORE_EXPORT CookiePartitionKey : public ::crdtp::ProtocolObject<CookiePartitionKey> {
public:
    ~CookiePartitionKey() override { }

    String getTopLevelSite() { return m_topLevelSite; }
    void setTopLevelSite(const String& value) { m_topLevelSite = value; }

    bool getHasCrossSiteAncestor() { return m_hasCrossSiteAncestor; }
    void setHasCrossSiteAncestor(bool value) { m_hasCrossSiteAncestor = value; }

    template<int STATE>
    class CookiePartitionKeyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TopLevelSiteSet = 1 << 1,
            HasCrossSiteAncestorSet = 1 << 2,
            AllFieldsSet = (TopLevelSiteSet | HasCrossSiteAncestorSet | 0)};


        CookiePartitionKeyBuilder<STATE | TopLevelSiteSet>& setTopLevelSite(const String& value)
        {
            static_assert(!(STATE & TopLevelSiteSet), "property topLevelSite should not be set yet");
            m_result->setTopLevelSite(value);
            return castState<TopLevelSiteSet>();
        }

        CookiePartitionKeyBuilder<STATE | HasCrossSiteAncestorSet>& setHasCrossSiteAncestor(bool value)
        {
            static_assert(!(STATE & HasCrossSiteAncestorSet), "property hasCrossSiteAncestor should not be set yet");
            m_result->setHasCrossSiteAncestor(value);
            return castState<HasCrossSiteAncestorSet>();
        }

        std::unique_ptr<CookiePartitionKey> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookiePartitionKey;
        CookiePartitionKeyBuilder() : m_result(new CookiePartitionKey()) { }

        template<int STEP> CookiePartitionKeyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookiePartitionKeyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::CookiePartitionKey> m_result;
    };

    static CookiePartitionKeyBuilder<0> create()
    {
        return CookiePartitionKeyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookiePartitionKey()
    {
          m_hasCrossSiteAncestor = false;
    }

    String m_topLevelSite;
    bool m_hasCrossSiteAncestor;
};


class CORE_EXPORT Cookie : public ::crdtp::ProtocolObject<Cookie> {
public:
    ~Cookie() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getValue() { return m_value; }
    void setValue(const String& value) { m_value = value; }

    String getDomain() { return m_domain; }
    void setDomain(const String& value) { m_domain = value; }

    String getPath() { return m_path; }
    void setPath(const String& value) { m_path = value; }

    double getExpires() { return m_expires; }
    void setExpires(double value) { m_expires = value; }

    int getSize() { return m_size; }
    void setSize(int value) { m_size = value; }

    bool getHttpOnly() { return m_httpOnly; }
    void setHttpOnly(bool value) { m_httpOnly = value; }

    bool getSecure() { return m_secure; }
    void setSecure(bool value) { m_secure = value; }

    bool getSession() { return m_session; }
    void setSession(bool value) { m_session = value; }

    bool hasSameSite() { return !!m_sameSite; }
    String getSameSite(const String& defaultValue) const {
       return m_sameSite.value_or(defaultValue);
    }
    const std::optional<String>& getSameSite() const {
       return m_sameSite;
    }
    void setSameSite(const String& value) { m_sameSite = value; }

    String getPriority() { return m_priority; }
    void setPriority(const String& value) { m_priority = value; }

    bool getSameParty() { return m_sameParty; }
    void setSameParty(bool value) { m_sameParty = value; }

    String getSourceScheme() { return m_sourceScheme; }
    void setSourceScheme(const String& value) { m_sourceScheme = value; }

    int getSourcePort() { return m_sourcePort; }
    void setSourcePort(int value) { m_sourcePort = value; }

    bool hasPartitionKey() { return !!m_partitionKey; }
    protocol::Network::CookiePartitionKey* getPartitionKey(protocol::Network::CookiePartitionKey* defaultValue) {
       return m_partitionKey ? m_partitionKey.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::CookiePartitionKey>& getPartitionKey() const {
       return m_partitionKey;
    }
    void setPartitionKey(std::unique_ptr<protocol::Network::CookiePartitionKey> value) { m_partitionKey = std::move(value); }

    bool hasPartitionKeyOpaque() { return !!m_partitionKeyOpaque; }
    bool getPartitionKeyOpaque(bool defaultValue) const {
       return m_partitionKeyOpaque.value_or(defaultValue);
    }
    const std::optional<bool>& getPartitionKeyOpaque() const {
       return m_partitionKeyOpaque;
    }
    void setPartitionKeyOpaque(bool value) { m_partitionKeyOpaque = value; }

    template<int STATE>
    class CookieBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            DomainSet = 1 << 3,
            PathSet = 1 << 4,
            ExpiresSet = 1 << 5,
            SizeSet = 1 << 6,
            HttpOnlySet = 1 << 7,
            SecureSet = 1 << 8,
            SessionSet = 1 << 9,
            PrioritySet = 1 << 10,
            SamePartySet = 1 << 11,
            SourceSchemeSet = 1 << 12,
            SourcePortSet = 1 << 13,
            AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | SizeSet | HttpOnlySet | SecureSet | SessionSet | PrioritySet | SamePartySet | SourceSchemeSet | SourcePortSet | 0)};


        CookieBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        CookieBuilder<STATE | ValueSet>& setValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(value);
            return castState<ValueSet>();
        }

        CookieBuilder<STATE | DomainSet>& setDomain(const String& value)
        {
            static_assert(!(STATE & DomainSet), "property domain should not be set yet");
            m_result->setDomain(value);
            return castState<DomainSet>();
        }

        CookieBuilder<STATE | PathSet>& setPath(const String& value)
        {
            static_assert(!(STATE & PathSet), "property path should not be set yet");
            m_result->setPath(value);
            return castState<PathSet>();
        }

        CookieBuilder<STATE | ExpiresSet>& setExpires(double value)
        {
            static_assert(!(STATE & ExpiresSet), "property expires should not be set yet");
            m_result->setExpires(value);
            return castState<ExpiresSet>();
        }

        CookieBuilder<STATE | SizeSet>& setSize(int value)
        {
            static_assert(!(STATE & SizeSet), "property size should not be set yet");
            m_result->setSize(value);
            return castState<SizeSet>();
        }

        CookieBuilder<STATE | HttpOnlySet>& setHttpOnly(bool value)
        {
            static_assert(!(STATE & HttpOnlySet), "property httpOnly should not be set yet");
            m_result->setHttpOnly(value);
            return castState<HttpOnlySet>();
        }

        CookieBuilder<STATE | SecureSet>& setSecure(bool value)
        {
            static_assert(!(STATE & SecureSet), "property secure should not be set yet");
            m_result->setSecure(value);
            return castState<SecureSet>();
        }

        CookieBuilder<STATE | SessionSet>& setSession(bool value)
        {
            static_assert(!(STATE & SessionSet), "property session should not be set yet");
            m_result->setSession(value);
            return castState<SessionSet>();
        }

        CookieBuilder<STATE>& setSameSite(const String& value)
        {
            m_result->setSameSite(value);
            return *this;
        }

        CookieBuilder<STATE | PrioritySet>& setPriority(const String& value)
        {
            static_assert(!(STATE & PrioritySet), "property priority should not be set yet");
            m_result->setPriority(value);
            return castState<PrioritySet>();
        }

        CookieBuilder<STATE | SamePartySet>& setSameParty(bool value)
        {
            static_assert(!(STATE & SamePartySet), "property sameParty should not be set yet");
            m_result->setSameParty(value);
            return castState<SamePartySet>();
        }

        CookieBuilder<STATE | SourceSchemeSet>& setSourceScheme(const String& value)
        {
            static_assert(!(STATE & SourceSchemeSet), "property sourceScheme should not be set yet");
            m_result->setSourceScheme(value);
            return castState<SourceSchemeSet>();
        }

        CookieBuilder<STATE | SourcePortSet>& setSourcePort(int value)
        {
            static_assert(!(STATE & SourcePortSet), "property sourcePort should not be set yet");
            m_result->setSourcePort(value);
            return castState<SourcePortSet>();
        }

        CookieBuilder<STATE>& setPartitionKey(std::unique_ptr<protocol::Network::CookiePartitionKey> value)
        {
            m_result->setPartitionKey(std::move(value));
            return *this;
        }

        CookieBuilder<STATE>& setPartitionKeyOpaque(bool value)
        {
            m_result->setPartitionKeyOpaque(value);
            return *this;
        }

        std::unique_ptr<Cookie> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Cookie;
        CookieBuilder() : m_result(new Cookie()) { }

        template<int STEP> CookieBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Cookie> m_result;
    };

    static CookieBuilder<0> create()
    {
        return CookieBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Cookie()
    {
          m_expires = 0;
          m_size = 0;
          m_httpOnly = false;
          m_secure = false;
          m_session = false;
          m_sameParty = false;
          m_sourcePort = 0;
    }

    String m_name;
    String m_value;
    String m_domain;
    String m_path;
    double m_expires;
    int m_size;
    bool m_httpOnly;
    bool m_secure;
    bool m_session;
    std::optional<String> m_sameSite;
    String m_priority;
    bool m_sameParty;
    String m_sourceScheme;
    int m_sourcePort;
    std::unique_ptr<protocol::Network::CookiePartitionKey> m_partitionKey;
    std::optional<bool> m_partitionKeyOpaque;
};


class CORE_EXPORT BlockedSetCookieWithReason : public ::crdtp::ProtocolObject<BlockedSetCookieWithReason> {
public:
    ~BlockedSetCookieWithReason() override { }

    protocol::Array<String>* getBlockedReasons() { return m_blockedReasons.get(); }
    void setBlockedReasons(std::unique_ptr<protocol::Array<String>> value) { m_blockedReasons = std::move(value); }

    String getCookieLine() { return m_cookieLine; }
    void setCookieLine(const String& value) { m_cookieLine = value; }

    bool hasCookie() { return !!m_cookie; }
    protocol::Network::Cookie* getCookie(protocol::Network::Cookie* defaultValue) {
       return m_cookie ? m_cookie.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::Cookie>& getCookie() const {
       return m_cookie;
    }
    void setCookie(std::unique_ptr<protocol::Network::Cookie> value) { m_cookie = std::move(value); }

    template<int STATE>
    class BlockedSetCookieWithReasonBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BlockedReasonsSet = 1 << 1,
            CookieLineSet = 1 << 2,
            AllFieldsSet = (BlockedReasonsSet | CookieLineSet | 0)};


        BlockedSetCookieWithReasonBuilder<STATE | BlockedReasonsSet>& setBlockedReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & BlockedReasonsSet), "property blockedReasons should not be set yet");
            m_result->setBlockedReasons(std::move(value));
            return castState<BlockedReasonsSet>();
        }

        BlockedSetCookieWithReasonBuilder<STATE | CookieLineSet>& setCookieLine(const String& value)
        {
            static_assert(!(STATE & CookieLineSet), "property cookieLine should not be set yet");
            m_result->setCookieLine(value);
            return castState<CookieLineSet>();
        }

        BlockedSetCookieWithReasonBuilder<STATE>& setCookie(std::unique_ptr<protocol::Network::Cookie> value)
        {
            m_result->setCookie(std::move(value));
            return *this;
        }

        std::unique_ptr<BlockedSetCookieWithReason> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BlockedSetCookieWithReason;
        BlockedSetCookieWithReasonBuilder() : m_result(new BlockedSetCookieWithReason()) { }

        template<int STEP> BlockedSetCookieWithReasonBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BlockedSetCookieWithReasonBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::BlockedSetCookieWithReason> m_result;
    };

    static BlockedSetCookieWithReasonBuilder<0> create()
    {
        return BlockedSetCookieWithReasonBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BlockedSetCookieWithReason()
    {
    }

    std::unique_ptr<protocol::Array<String>> m_blockedReasons;
    String m_cookieLine;
    std::unique_ptr<protocol::Network::Cookie> m_cookie;
};


class CORE_EXPORT ExemptedSetCookieWithReason : public ::crdtp::ProtocolObject<ExemptedSetCookieWithReason> {
public:
    ~ExemptedSetCookieWithReason() override { }

    String getExemptionReason() { return m_exemptionReason; }
    void setExemptionReason(const String& value) { m_exemptionReason = value; }

    String getCookieLine() { return m_cookieLine; }
    void setCookieLine(const String& value) { m_cookieLine = value; }

    protocol::Network::Cookie* getCookie() { return m_cookie.get(); }
    void setCookie(std::unique_ptr<protocol::Network::Cookie> value) { m_cookie = std::move(value); }

    template<int STATE>
    class ExemptedSetCookieWithReasonBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ExemptionReasonSet = 1 << 1,
            CookieLineSet = 1 << 2,
            CookieSet = 1 << 3,
            AllFieldsSet = (ExemptionReasonSet | CookieLineSet | CookieSet | 0)};


        ExemptedSetCookieWithReasonBuilder<STATE | ExemptionReasonSet>& setExemptionReason(const String& value)
        {
            static_assert(!(STATE & ExemptionReasonSet), "property exemptionReason should not be set yet");
            m_result->setExemptionReason(value);
            return castState<ExemptionReasonSet>();
        }

        ExemptedSetCookieWithReasonBuilder<STATE | CookieLineSet>& setCookieLine(const String& value)
        {
            static_assert(!(STATE & CookieLineSet), "property cookieLine should not be set yet");
            m_result->setCookieLine(value);
            return castState<CookieLineSet>();
        }

        ExemptedSetCookieWithReasonBuilder<STATE | CookieSet>& setCookie(std::unique_ptr<protocol::Network::Cookie> value)
        {
            static_assert(!(STATE & CookieSet), "property cookie should not be set yet");
            m_result->setCookie(std::move(value));
            return castState<CookieSet>();
        }

        std::unique_ptr<ExemptedSetCookieWithReason> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ExemptedSetCookieWithReason;
        ExemptedSetCookieWithReasonBuilder() : m_result(new ExemptedSetCookieWithReason()) { }

        template<int STEP> ExemptedSetCookieWithReasonBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ExemptedSetCookieWithReasonBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ExemptedSetCookieWithReason> m_result;
    };

    static ExemptedSetCookieWithReasonBuilder<0> create()
    {
        return ExemptedSetCookieWithReasonBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ExemptedSetCookieWithReason()
    {
    }

    String m_exemptionReason;
    String m_cookieLine;
    std::unique_ptr<protocol::Network::Cookie> m_cookie;
};


class CORE_EXPORT AssociatedCookie : public ::crdtp::ProtocolObject<AssociatedCookie> {
public:
    ~AssociatedCookie() override { }

    protocol::Network::Cookie* getCookie() { return m_cookie.get(); }
    void setCookie(std::unique_ptr<protocol::Network::Cookie> value) { m_cookie = std::move(value); }

    protocol::Array<String>* getBlockedReasons() { return m_blockedReasons.get(); }
    void setBlockedReasons(std::unique_ptr<protocol::Array<String>> value) { m_blockedReasons = std::move(value); }

    bool hasExemptionReason() { return !!m_exemptionReason; }
    String getExemptionReason(const String& defaultValue) const {
       return m_exemptionReason.value_or(defaultValue);
    }
    const std::optional<String>& getExemptionReason() const {
       return m_exemptionReason;
    }
    void setExemptionReason(const String& value) { m_exemptionReason = value; }

    template<int STATE>
    class AssociatedCookieBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CookieSet = 1 << 1,
            BlockedReasonsSet = 1 << 2,
            AllFieldsSet = (CookieSet | BlockedReasonsSet | 0)};


        AssociatedCookieBuilder<STATE | CookieSet>& setCookie(std::unique_ptr<protocol::Network::Cookie> value)
        {
            static_assert(!(STATE & CookieSet), "property cookie should not be set yet");
            m_result->setCookie(std::move(value));
            return castState<CookieSet>();
        }

        AssociatedCookieBuilder<STATE | BlockedReasonsSet>& setBlockedReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & BlockedReasonsSet), "property blockedReasons should not be set yet");
            m_result->setBlockedReasons(std::move(value));
            return castState<BlockedReasonsSet>();
        }

        AssociatedCookieBuilder<STATE>& setExemptionReason(const String& value)
        {
            m_result->setExemptionReason(value);
            return *this;
        }

        std::unique_ptr<AssociatedCookie> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AssociatedCookie;
        AssociatedCookieBuilder() : m_result(new AssociatedCookie()) { }

        template<int STEP> AssociatedCookieBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AssociatedCookieBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::AssociatedCookie> m_result;
    };

    static AssociatedCookieBuilder<0> create()
    {
        return AssociatedCookieBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AssociatedCookie()
    {
    }

    std::unique_ptr<protocol::Network::Cookie> m_cookie;
    std::unique_ptr<protocol::Array<String>> m_blockedReasons;
    std::optional<String> m_exemptionReason;
};


class CORE_EXPORT CookieParam : public ::crdtp::ProtocolObject<CookieParam> {
public:
    ~CookieParam() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getValue() { return m_value; }
    void setValue(const String& value) { m_value = value; }

    bool hasUrl() { return !!m_url; }
    String getUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& getUrl() const {
       return m_url;
    }
    void setUrl(const String& value) { m_url = value; }

    bool hasDomain() { return !!m_domain; }
    String getDomain(const String& defaultValue) const {
       return m_domain.value_or(defaultValue);
    }
    const std::optional<String>& getDomain() const {
       return m_domain;
    }
    void setDomain(const String& value) { m_domain = value; }

    bool hasPath() { return !!m_path; }
    String getPath(const String& defaultValue) const {
       return m_path.value_or(defaultValue);
    }
    const std::optional<String>& getPath() const {
       return m_path;
    }
    void setPath(const String& value) { m_path = value; }

    bool hasSecure() { return !!m_secure; }
    bool getSecure(bool defaultValue) const {
       return m_secure.value_or(defaultValue);
    }
    const std::optional<bool>& getSecure() const {
       return m_secure;
    }
    void setSecure(bool value) { m_secure = value; }

    bool hasHttpOnly() { return !!m_httpOnly; }
    bool getHttpOnly(bool defaultValue) const {
       return m_httpOnly.value_or(defaultValue);
    }
    const std::optional<bool>& getHttpOnly() const {
       return m_httpOnly;
    }
    void setHttpOnly(bool value) { m_httpOnly = value; }

    bool hasSameSite() { return !!m_sameSite; }
    String getSameSite(const String& defaultValue) const {
       return m_sameSite.value_or(defaultValue);
    }
    const std::optional<String>& getSameSite() const {
       return m_sameSite;
    }
    void setSameSite(const String& value) { m_sameSite = value; }

    bool hasExpires() { return !!m_expires; }
    double getExpires(double defaultValue) const {
       return m_expires.value_or(defaultValue);
    }
    const std::optional<double>& getExpires() const {
       return m_expires;
    }
    void setExpires(double value) { m_expires = value; }

    bool hasPriority() { return !!m_priority; }
    String getPriority(const String& defaultValue) const {
       return m_priority.value_or(defaultValue);
    }
    const std::optional<String>& getPriority() const {
       return m_priority;
    }
    void setPriority(const String& value) { m_priority = value; }

    bool hasSameParty() { return !!m_sameParty; }
    bool getSameParty(bool defaultValue) const {
       return m_sameParty.value_or(defaultValue);
    }
    const std::optional<bool>& getSameParty() const {
       return m_sameParty;
    }
    void setSameParty(bool value) { m_sameParty = value; }

    bool hasSourceScheme() { return !!m_sourceScheme; }
    String getSourceScheme(const String& defaultValue) const {
       return m_sourceScheme.value_or(defaultValue);
    }
    const std::optional<String>& getSourceScheme() const {
       return m_sourceScheme;
    }
    void setSourceScheme(const String& value) { m_sourceScheme = value; }

    bool hasSourcePort() { return !!m_sourcePort; }
    int getSourcePort(int defaultValue) const {
       return m_sourcePort.value_or(defaultValue);
    }
    const std::optional<int>& getSourcePort() const {
       return m_sourcePort;
    }
    void setSourcePort(int value) { m_sourcePort = value; }

    bool hasPartitionKey() { return !!m_partitionKey; }
    protocol::Network::CookiePartitionKey* getPartitionKey(protocol::Network::CookiePartitionKey* defaultValue) {
       return m_partitionKey ? m_partitionKey.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::CookiePartitionKey>& getPartitionKey() const {
       return m_partitionKey;
    }
    void setPartitionKey(std::unique_ptr<protocol::Network::CookiePartitionKey> value) { m_partitionKey = std::move(value); }

    template<int STATE>
    class CookieParamBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        CookieParamBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        CookieParamBuilder<STATE | ValueSet>& setValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(value);
            return castState<ValueSet>();
        }

        CookieParamBuilder<STATE>& setUrl(const String& value)
        {
            m_result->setUrl(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setDomain(const String& value)
        {
            m_result->setDomain(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setPath(const String& value)
        {
            m_result->setPath(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setSecure(bool value)
        {
            m_result->setSecure(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setHttpOnly(bool value)
        {
            m_result->setHttpOnly(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setSameSite(const String& value)
        {
            m_result->setSameSite(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setExpires(double value)
        {
            m_result->setExpires(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setPriority(const String& value)
        {
            m_result->setPriority(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setSameParty(bool value)
        {
            m_result->setSameParty(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setSourceScheme(const String& value)
        {
            m_result->setSourceScheme(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setSourcePort(int value)
        {
            m_result->setSourcePort(value);
            return *this;
        }

        CookieParamBuilder<STATE>& setPartitionKey(std::unique_ptr<protocol::Network::CookiePartitionKey> value)
        {
            m_result->setPartitionKey(std::move(value));
            return *this;
        }

        std::unique_ptr<CookieParam> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieParam;
        CookieParamBuilder() : m_result(new CookieParam()) { }

        template<int STEP> CookieParamBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieParamBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::CookieParam> m_result;
    };

    static CookieParamBuilder<0> create()
    {
        return CookieParamBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieParam()
    {
    }

    String m_name;
    String m_value;
    std::optional<String> m_url;
    std::optional<String> m_domain;
    std::optional<String> m_path;
    std::optional<bool> m_secure;
    std::optional<bool> m_httpOnly;
    std::optional<String> m_sameSite;
    std::optional<double> m_expires;
    std::optional<String> m_priority;
    std::optional<bool> m_sameParty;
    std::optional<String> m_sourceScheme;
    std::optional<int> m_sourcePort;
    std::unique_ptr<protocol::Network::CookiePartitionKey> m_partitionKey;
};


class CORE_EXPORT AuthChallenge : public ::crdtp::ProtocolObject<AuthChallenge> {
public:
    ~AuthChallenge() override { }

    struct CORE_EXPORT SourceEnum {
        static const char* Server;
        static const char* Proxy;
    }; // SourceEnum

    bool hasSource() { return !!m_source; }
    String getSource(const String& defaultValue) const {
       return m_source.value_or(defaultValue);
    }
    const std::optional<String>& getSource() const {
       return m_source;
    }
    void setSource(const String& value) { m_source = value; }

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value) { m_origin = value; }

    String getScheme() { return m_scheme; }
    void setScheme(const String& value) { m_scheme = value; }

    String getRealm() { return m_realm; }
    void setRealm(const String& value) { m_realm = value; }

    template<int STATE>
    class AuthChallengeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OriginSet = 1 << 1,
            SchemeSet = 1 << 2,
            RealmSet = 1 << 3,
            AllFieldsSet = (OriginSet | SchemeSet | RealmSet | 0)};


        AuthChallengeBuilder<STATE>& setSource(const String& value)
        {
            m_result->setSource(value);
            return *this;
        }

        AuthChallengeBuilder<STATE | OriginSet>& setOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->setOrigin(value);
            return castState<OriginSet>();
        }

        AuthChallengeBuilder<STATE | SchemeSet>& setScheme(const String& value)
        {
            static_assert(!(STATE & SchemeSet), "property scheme should not be set yet");
            m_result->setScheme(value);
            return castState<SchemeSet>();
        }

        AuthChallengeBuilder<STATE | RealmSet>& setRealm(const String& value)
        {
            static_assert(!(STATE & RealmSet), "property realm should not be set yet");
            m_result->setRealm(value);
            return castState<RealmSet>();
        }

        std::unique_ptr<AuthChallenge> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AuthChallenge;
        AuthChallengeBuilder() : m_result(new AuthChallenge()) { }

        template<int STEP> AuthChallengeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AuthChallengeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::AuthChallenge> m_result;
    };

    static AuthChallengeBuilder<0> create()
    {
        return AuthChallengeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AuthChallenge()
    {
    }

    std::optional<String> m_source;
    String m_origin;
    String m_scheme;
    String m_realm;
};


class CORE_EXPORT SignedExchangeSignature : public ::crdtp::ProtocolObject<SignedExchangeSignature> {
public:
    ~SignedExchangeSignature() override { }

    String getLabel() { return m_label; }
    void setLabel(const String& value) { m_label = value; }

    String getSignature() { return m_signature; }
    void setSignature(const String& value) { m_signature = value; }

    String getIntegrity() { return m_integrity; }
    void setIntegrity(const String& value) { m_integrity = value; }

    bool hasCertUrl() { return !!m_certUrl; }
    String getCertUrl(const String& defaultValue) const {
       return m_certUrl.value_or(defaultValue);
    }
    const std::optional<String>& getCertUrl() const {
       return m_certUrl;
    }
    void setCertUrl(const String& value) { m_certUrl = value; }

    bool hasCertSha256() { return !!m_certSha256; }
    String getCertSha256(const String& defaultValue) const {
       return m_certSha256.value_or(defaultValue);
    }
    const std::optional<String>& getCertSha256() const {
       return m_certSha256;
    }
    void setCertSha256(const String& value) { m_certSha256 = value; }

    String getValidityUrl() { return m_validityUrl; }
    void setValidityUrl(const String& value) { m_validityUrl = value; }

    int getDate() { return m_date; }
    void setDate(int value) { m_date = value; }

    int getExpires() { return m_expires; }
    void setExpires(int value) { m_expires = value; }

    bool hasCertificates() { return !!m_certificates; }
    protocol::Array<String>* getCertificates(protocol::Array<String>* defaultValue) {
       return m_certificates ? m_certificates.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getCertificates() const {
       return m_certificates;
    }
    void setCertificates(std::unique_ptr<protocol::Array<String>> value) { m_certificates = std::move(value); }

    template<int STATE>
    class SignedExchangeSignatureBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LabelSet = 1 << 1,
            SignatureSet = 1 << 2,
            IntegritySet = 1 << 3,
            ValidityUrlSet = 1 << 4,
            DateSet = 1 << 5,
            ExpiresSet = 1 << 6,
            AllFieldsSet = (LabelSet | SignatureSet | IntegritySet | ValidityUrlSet | DateSet | ExpiresSet | 0)};


        SignedExchangeSignatureBuilder<STATE | LabelSet>& setLabel(const String& value)
        {
            static_assert(!(STATE & LabelSet), "property label should not be set yet");
            m_result->setLabel(value);
            return castState<LabelSet>();
        }

        SignedExchangeSignatureBuilder<STATE | SignatureSet>& setSignature(const String& value)
        {
            static_assert(!(STATE & SignatureSet), "property signature should not be set yet");
            m_result->setSignature(value);
            return castState<SignatureSet>();
        }

        SignedExchangeSignatureBuilder<STATE | IntegritySet>& setIntegrity(const String& value)
        {
            static_assert(!(STATE & IntegritySet), "property integrity should not be set yet");
            m_result->setIntegrity(value);
            return castState<IntegritySet>();
        }

        SignedExchangeSignatureBuilder<STATE>& setCertUrl(const String& value)
        {
            m_result->setCertUrl(value);
            return *this;
        }

        SignedExchangeSignatureBuilder<STATE>& setCertSha256(const String& value)
        {
            m_result->setCertSha256(value);
            return *this;
        }

        SignedExchangeSignatureBuilder<STATE | ValidityUrlSet>& setValidityUrl(const String& value)
        {
            static_assert(!(STATE & ValidityUrlSet), "property validityUrl should not be set yet");
            m_result->setValidityUrl(value);
            return castState<ValidityUrlSet>();
        }

        SignedExchangeSignatureBuilder<STATE | DateSet>& setDate(int value)
        {
            static_assert(!(STATE & DateSet), "property date should not be set yet");
            m_result->setDate(value);
            return castState<DateSet>();
        }

        SignedExchangeSignatureBuilder<STATE | ExpiresSet>& setExpires(int value)
        {
            static_assert(!(STATE & ExpiresSet), "property expires should not be set yet");
            m_result->setExpires(value);
            return castState<ExpiresSet>();
        }

        SignedExchangeSignatureBuilder<STATE>& setCertificates(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->setCertificates(std::move(value));
            return *this;
        }

        std::unique_ptr<SignedExchangeSignature> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedExchangeSignature;
        SignedExchangeSignatureBuilder() : m_result(new SignedExchangeSignature()) { }

        template<int STEP> SignedExchangeSignatureBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedExchangeSignatureBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedExchangeSignature> m_result;
    };

    static SignedExchangeSignatureBuilder<0> create()
    {
        return SignedExchangeSignatureBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedExchangeSignature()
    {
          m_date = 0;
          m_expires = 0;
    }

    String m_label;
    String m_signature;
    String m_integrity;
    std::optional<String> m_certUrl;
    std::optional<String> m_certSha256;
    String m_validityUrl;
    int m_date;
    int m_expires;
    std::unique_ptr<protocol::Array<String>> m_certificates;
};


class CORE_EXPORT SignedExchangeHeader : public ::crdtp::ProtocolObject<SignedExchangeHeader> {
public:
    ~SignedExchangeHeader() override { }

    String getRequestUrl() { return m_requestUrl; }
    void setRequestUrl(const String& value) { m_requestUrl = value; }

    int getResponseCode() { return m_responseCode; }
    void setResponseCode(int value) { m_responseCode = value; }

    protocol::Network::Headers* getResponseHeaders() { return m_responseHeaders.get(); }
    void setResponseHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_responseHeaders = std::move(value); }

    protocol::Array<protocol::Network::SignedExchangeSignature>* getSignatures() { return m_signatures.get(); }
    void setSignatures(std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeSignature>> value) { m_signatures = std::move(value); }

    String getHeaderIntegrity() { return m_headerIntegrity; }
    void setHeaderIntegrity(const String& value) { m_headerIntegrity = value; }

    template<int STATE>
    class SignedExchangeHeaderBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestUrlSet = 1 << 1,
            ResponseCodeSet = 1 << 2,
            ResponseHeadersSet = 1 << 3,
            SignaturesSet = 1 << 4,
            HeaderIntegritySet = 1 << 5,
            AllFieldsSet = (RequestUrlSet | ResponseCodeSet | ResponseHeadersSet | SignaturesSet | HeaderIntegritySet | 0)};


        SignedExchangeHeaderBuilder<STATE | RequestUrlSet>& setRequestUrl(const String& value)
        {
            static_assert(!(STATE & RequestUrlSet), "property requestUrl should not be set yet");
            m_result->setRequestUrl(value);
            return castState<RequestUrlSet>();
        }

        SignedExchangeHeaderBuilder<STATE | ResponseCodeSet>& setResponseCode(int value)
        {
            static_assert(!(STATE & ResponseCodeSet), "property responseCode should not be set yet");
            m_result->setResponseCode(value);
            return castState<ResponseCodeSet>();
        }

        SignedExchangeHeaderBuilder<STATE | ResponseHeadersSet>& setResponseHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & ResponseHeadersSet), "property responseHeaders should not be set yet");
            m_result->setResponseHeaders(std::move(value));
            return castState<ResponseHeadersSet>();
        }

        SignedExchangeHeaderBuilder<STATE | SignaturesSet>& setSignatures(std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeSignature>> value)
        {
            static_assert(!(STATE & SignaturesSet), "property signatures should not be set yet");
            m_result->setSignatures(std::move(value));
            return castState<SignaturesSet>();
        }

        SignedExchangeHeaderBuilder<STATE | HeaderIntegritySet>& setHeaderIntegrity(const String& value)
        {
            static_assert(!(STATE & HeaderIntegritySet), "property headerIntegrity should not be set yet");
            m_result->setHeaderIntegrity(value);
            return castState<HeaderIntegritySet>();
        }

        std::unique_ptr<SignedExchangeHeader> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedExchangeHeader;
        SignedExchangeHeaderBuilder() : m_result(new SignedExchangeHeader()) { }

        template<int STEP> SignedExchangeHeaderBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedExchangeHeaderBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedExchangeHeader> m_result;
    };

    static SignedExchangeHeaderBuilder<0> create()
    {
        return SignedExchangeHeaderBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedExchangeHeader()
    {
          m_responseCode = 0;
    }

    String m_requestUrl;
    int m_responseCode;
    std::unique_ptr<protocol::Network::Headers> m_responseHeaders;
    std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeSignature>> m_signatures;
    String m_headerIntegrity;
};


class CORE_EXPORT SignedExchangeError : public ::crdtp::ProtocolObject<SignedExchangeError> {
public:
    ~SignedExchangeError() override { }

    String getMessage() { return m_message; }
    void setMessage(const String& value) { m_message = value; }

    bool hasSignatureIndex() { return !!m_signatureIndex; }
    int getSignatureIndex(int defaultValue) const {
       return m_signatureIndex.value_or(defaultValue);
    }
    const std::optional<int>& getSignatureIndex() const {
       return m_signatureIndex;
    }
    void setSignatureIndex(int value) { m_signatureIndex = value; }

    bool hasErrorField() { return !!m_errorField; }
    String getErrorField(const String& defaultValue) const {
       return m_errorField.value_or(defaultValue);
    }
    const std::optional<String>& getErrorField() const {
       return m_errorField;
    }
    void setErrorField(const String& value) { m_errorField = value; }

    template<int STATE>
    class SignedExchangeErrorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            MessageSet = 1 << 1,
            AllFieldsSet = (MessageSet | 0)};


        SignedExchangeErrorBuilder<STATE | MessageSet>& setMessage(const String& value)
        {
            static_assert(!(STATE & MessageSet), "property message should not be set yet");
            m_result->setMessage(value);
            return castState<MessageSet>();
        }

        SignedExchangeErrorBuilder<STATE>& setSignatureIndex(int value)
        {
            m_result->setSignatureIndex(value);
            return *this;
        }

        SignedExchangeErrorBuilder<STATE>& setErrorField(const String& value)
        {
            m_result->setErrorField(value);
            return *this;
        }

        std::unique_ptr<SignedExchangeError> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedExchangeError;
        SignedExchangeErrorBuilder() : m_result(new SignedExchangeError()) { }

        template<int STEP> SignedExchangeErrorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedExchangeErrorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedExchangeError> m_result;
    };

    static SignedExchangeErrorBuilder<0> create()
    {
        return SignedExchangeErrorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedExchangeError()
    {
    }

    String m_message;
    std::optional<int> m_signatureIndex;
    std::optional<String> m_errorField;
};


class CORE_EXPORT SignedExchangeInfo : public ::crdtp::ProtocolObject<SignedExchangeInfo> {
public:
    ~SignedExchangeInfo() override { }

    protocol::Network::Response* getOuterResponse() { return m_outerResponse.get(); }
    void setOuterResponse(std::unique_ptr<protocol::Network::Response> value) { m_outerResponse = std::move(value); }

    bool getHasExtraInfo() { return m_hasExtraInfo; }
    void setHasExtraInfo(bool value) { m_hasExtraInfo = value; }

    bool hasHeader() { return !!m_header; }
    protocol::Network::SignedExchangeHeader* getHeader(protocol::Network::SignedExchangeHeader* defaultValue) {
       return m_header ? m_header.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::SignedExchangeHeader>& getHeader() const {
       return m_header;
    }
    void setHeader(std::unique_ptr<protocol::Network::SignedExchangeHeader> value) { m_header = std::move(value); }

    bool hasSecurityDetails() { return !!m_securityDetails; }
    protocol::Network::SecurityDetails* getSecurityDetails(protocol::Network::SecurityDetails* defaultValue) {
       return m_securityDetails ? m_securityDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::SecurityDetails>& getSecurityDetails() const {
       return m_securityDetails;
    }
    void setSecurityDetails(std::unique_ptr<protocol::Network::SecurityDetails> value) { m_securityDetails = std::move(value); }

    bool hasErrors() { return !!m_errors; }
    protocol::Array<protocol::Network::SignedExchangeError>* getErrors(protocol::Array<protocol::Network::SignedExchangeError>* defaultValue) {
       return m_errors ? m_errors.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeError>>& getErrors() const {
       return m_errors;
    }
    void setErrors(std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeError>> value) { m_errors = std::move(value); }

    template<int STATE>
    class SignedExchangeInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OuterResponseSet = 1 << 1,
            HasExtraInfoSet = 1 << 2,
            AllFieldsSet = (OuterResponseSet | HasExtraInfoSet | 0)};


        SignedExchangeInfoBuilder<STATE | OuterResponseSet>& setOuterResponse(std::unique_ptr<protocol::Network::Response> value)
        {
            static_assert(!(STATE & OuterResponseSet), "property outerResponse should not be set yet");
            m_result->setOuterResponse(std::move(value));
            return castState<OuterResponseSet>();
        }

        SignedExchangeInfoBuilder<STATE | HasExtraInfoSet>& setHasExtraInfo(bool value)
        {
            static_assert(!(STATE & HasExtraInfoSet), "property hasExtraInfo should not be set yet");
            m_result->setHasExtraInfo(value);
            return castState<HasExtraInfoSet>();
        }

        SignedExchangeInfoBuilder<STATE>& setHeader(std::unique_ptr<protocol::Network::SignedExchangeHeader> value)
        {
            m_result->setHeader(std::move(value));
            return *this;
        }

        SignedExchangeInfoBuilder<STATE>& setSecurityDetails(std::unique_ptr<protocol::Network::SecurityDetails> value)
        {
            m_result->setSecurityDetails(std::move(value));
            return *this;
        }

        SignedExchangeInfoBuilder<STATE>& setErrors(std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeError>> value)
        {
            m_result->setErrors(std::move(value));
            return *this;
        }

        std::unique_ptr<SignedExchangeInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SignedExchangeInfo;
        SignedExchangeInfoBuilder() : m_result(new SignedExchangeInfo()) { }

        template<int STEP> SignedExchangeInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SignedExchangeInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::SignedExchangeInfo> m_result;
    };

    static SignedExchangeInfoBuilder<0> create()
    {
        return SignedExchangeInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SignedExchangeInfo()
    {
          m_hasExtraInfo = false;
    }

    std::unique_ptr<protocol::Network::Response> m_outerResponse;
    bool m_hasExtraInfo;
    std::unique_ptr<protocol::Network::SignedExchangeHeader> m_header;
    std::unique_ptr<protocol::Network::SecurityDetails> m_securityDetails;
    std::unique_ptr<protocol::Array<protocol::Network::SignedExchangeError>> m_errors;
};


class CORE_EXPORT NetworkConditions : public ::crdtp::ProtocolObject<NetworkConditions> {
public:
    ~NetworkConditions() override { }

    String getUrlPattern() { return m_urlPattern; }
    void setUrlPattern(const String& value) { m_urlPattern = value; }

    double getLatency() { return m_latency; }
    void setLatency(double value) { m_latency = value; }

    double getDownloadThroughput() { return m_downloadThroughput; }
    void setDownloadThroughput(double value) { m_downloadThroughput = value; }

    double getUploadThroughput() { return m_uploadThroughput; }
    void setUploadThroughput(double value) { m_uploadThroughput = value; }

    bool hasConnectionType() { return !!m_connectionType; }
    String getConnectionType(const String& defaultValue) const {
       return m_connectionType.value_or(defaultValue);
    }
    const std::optional<String>& getConnectionType() const {
       return m_connectionType;
    }
    void setConnectionType(const String& value) { m_connectionType = value; }

    bool hasPacketLoss() { return !!m_packetLoss; }
    double getPacketLoss(double defaultValue) const {
       return m_packetLoss.value_or(defaultValue);
    }
    const std::optional<double>& getPacketLoss() const {
       return m_packetLoss;
    }
    void setPacketLoss(double value) { m_packetLoss = value; }

    bool hasPacketQueueLength() { return !!m_packetQueueLength; }
    int getPacketQueueLength(int defaultValue) const {
       return m_packetQueueLength.value_or(defaultValue);
    }
    const std::optional<int>& getPacketQueueLength() const {
       return m_packetQueueLength;
    }
    void setPacketQueueLength(int value) { m_packetQueueLength = value; }

    bool hasPacketReordering() { return !!m_packetReordering; }
    bool getPacketReordering(bool defaultValue) const {
       return m_packetReordering.value_or(defaultValue);
    }
    const std::optional<bool>& getPacketReordering() const {
       return m_packetReordering;
    }
    void setPacketReordering(bool value) { m_packetReordering = value; }

    template<int STATE>
    class NetworkConditionsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlPatternSet = 1 << 1,
            LatencySet = 1 << 2,
            DownloadThroughputSet = 1 << 3,
            UploadThroughputSet = 1 << 4,
            AllFieldsSet = (UrlPatternSet | LatencySet | DownloadThroughputSet | UploadThroughputSet | 0)};


        NetworkConditionsBuilder<STATE | UrlPatternSet>& setUrlPattern(const String& value)
        {
            static_assert(!(STATE & UrlPatternSet), "property urlPattern should not be set yet");
            m_result->setUrlPattern(value);
            return castState<UrlPatternSet>();
        }

        NetworkConditionsBuilder<STATE | LatencySet>& setLatency(double value)
        {
            static_assert(!(STATE & LatencySet), "property latency should not be set yet");
            m_result->setLatency(value);
            return castState<LatencySet>();
        }

        NetworkConditionsBuilder<STATE | DownloadThroughputSet>& setDownloadThroughput(double value)
        {
            static_assert(!(STATE & DownloadThroughputSet), "property downloadThroughput should not be set yet");
            m_result->setDownloadThroughput(value);
            return castState<DownloadThroughputSet>();
        }

        NetworkConditionsBuilder<STATE | UploadThroughputSet>& setUploadThroughput(double value)
        {
            static_assert(!(STATE & UploadThroughputSet), "property uploadThroughput should not be set yet");
            m_result->setUploadThroughput(value);
            return castState<UploadThroughputSet>();
        }

        NetworkConditionsBuilder<STATE>& setConnectionType(const String& value)
        {
            m_result->setConnectionType(value);
            return *this;
        }

        NetworkConditionsBuilder<STATE>& setPacketLoss(double value)
        {
            m_result->setPacketLoss(value);
            return *this;
        }

        NetworkConditionsBuilder<STATE>& setPacketQueueLength(int value)
        {
            m_result->setPacketQueueLength(value);
            return *this;
        }

        NetworkConditionsBuilder<STATE>& setPacketReordering(bool value)
        {
            m_result->setPacketReordering(value);
            return *this;
        }

        std::unique_ptr<NetworkConditions> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class NetworkConditions;
        NetworkConditionsBuilder() : m_result(new NetworkConditions()) { }

        template<int STEP> NetworkConditionsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NetworkConditionsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::NetworkConditions> m_result;
    };

    static NetworkConditionsBuilder<0> create()
    {
        return NetworkConditionsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    NetworkConditions()
    {
          m_latency = 0;
          m_downloadThroughput = 0;
          m_uploadThroughput = 0;
    }

    String m_urlPattern;
    double m_latency;
    double m_downloadThroughput;
    double m_uploadThroughput;
    std::optional<String> m_connectionType;
    std::optional<double> m_packetLoss;
    std::optional<int> m_packetQueueLength;
    std::optional<bool> m_packetReordering;
};


class CORE_EXPORT DirectTCPSocketOptions : public ::crdtp::ProtocolObject<DirectTCPSocketOptions> {
public:
    ~DirectTCPSocketOptions() override { }

    bool getNoDelay() { return m_noDelay; }
    void setNoDelay(bool value) { m_noDelay = value; }

    bool hasKeepAliveDelay() { return !!m_keepAliveDelay; }
    double getKeepAliveDelay(double defaultValue) const {
       return m_keepAliveDelay.value_or(defaultValue);
    }
    const std::optional<double>& getKeepAliveDelay() const {
       return m_keepAliveDelay;
    }
    void setKeepAliveDelay(double value) { m_keepAliveDelay = value; }

    bool hasSendBufferSize() { return !!m_sendBufferSize; }
    double getSendBufferSize(double defaultValue) const {
       return m_sendBufferSize.value_or(defaultValue);
    }
    const std::optional<double>& getSendBufferSize() const {
       return m_sendBufferSize;
    }
    void setSendBufferSize(double value) { m_sendBufferSize = value; }

    bool hasReceiveBufferSize() { return !!m_receiveBufferSize; }
    double getReceiveBufferSize(double defaultValue) const {
       return m_receiveBufferSize.value_or(defaultValue);
    }
    const std::optional<double>& getReceiveBufferSize() const {
       return m_receiveBufferSize;
    }
    void setReceiveBufferSize(double value) { m_receiveBufferSize = value; }

    bool hasDnsQueryType() { return !!m_dnsQueryType; }
    String getDnsQueryType(const String& defaultValue) const {
       return m_dnsQueryType.value_or(defaultValue);
    }
    const std::optional<String>& getDnsQueryType() const {
       return m_dnsQueryType;
    }
    void setDnsQueryType(const String& value) { m_dnsQueryType = value; }

    template<int STATE>
    class DirectTCPSocketOptionsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NoDelaySet = 1 << 1,
            AllFieldsSet = (NoDelaySet | 0)};


        DirectTCPSocketOptionsBuilder<STATE | NoDelaySet>& setNoDelay(bool value)
        {
            static_assert(!(STATE & NoDelaySet), "property noDelay should not be set yet");
            m_result->setNoDelay(value);
            return castState<NoDelaySet>();
        }

        DirectTCPSocketOptionsBuilder<STATE>& setKeepAliveDelay(double value)
        {
            m_result->setKeepAliveDelay(value);
            return *this;
        }

        DirectTCPSocketOptionsBuilder<STATE>& setSendBufferSize(double value)
        {
            m_result->setSendBufferSize(value);
            return *this;
        }

        DirectTCPSocketOptionsBuilder<STATE>& setReceiveBufferSize(double value)
        {
            m_result->setReceiveBufferSize(value);
            return *this;
        }

        DirectTCPSocketOptionsBuilder<STATE>& setDnsQueryType(const String& value)
        {
            m_result->setDnsQueryType(value);
            return *this;
        }

        std::unique_ptr<DirectTCPSocketOptions> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DirectTCPSocketOptions;
        DirectTCPSocketOptionsBuilder() : m_result(new DirectTCPSocketOptions()) { }

        template<int STEP> DirectTCPSocketOptionsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DirectTCPSocketOptionsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::DirectTCPSocketOptions> m_result;
    };

    static DirectTCPSocketOptionsBuilder<0> create()
    {
        return DirectTCPSocketOptionsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DirectTCPSocketOptions()
    {
          m_noDelay = false;
    }

    bool m_noDelay;
    std::optional<double> m_keepAliveDelay;
    std::optional<double> m_sendBufferSize;
    std::optional<double> m_receiveBufferSize;
    std::optional<String> m_dnsQueryType;
};


class CORE_EXPORT DirectUDPSocketOptions : public ::crdtp::ProtocolObject<DirectUDPSocketOptions> {
public:
    ~DirectUDPSocketOptions() override { }

    bool hasRemoteAddr() { return !!m_remoteAddr; }
    String getRemoteAddr(const String& defaultValue) const {
       return m_remoteAddr.value_or(defaultValue);
    }
    const std::optional<String>& getRemoteAddr() const {
       return m_remoteAddr;
    }
    void setRemoteAddr(const String& value) { m_remoteAddr = value; }

    bool hasRemotePort() { return !!m_remotePort; }
    int getRemotePort(int defaultValue) const {
       return m_remotePort.value_or(defaultValue);
    }
    const std::optional<int>& getRemotePort() const {
       return m_remotePort;
    }
    void setRemotePort(int value) { m_remotePort = value; }

    bool hasLocalAddr() { return !!m_localAddr; }
    String getLocalAddr(const String& defaultValue) const {
       return m_localAddr.value_or(defaultValue);
    }
    const std::optional<String>& getLocalAddr() const {
       return m_localAddr;
    }
    void setLocalAddr(const String& value) { m_localAddr = value; }

    bool hasLocalPort() { return !!m_localPort; }
    int getLocalPort(int defaultValue) const {
       return m_localPort.value_or(defaultValue);
    }
    const std::optional<int>& getLocalPort() const {
       return m_localPort;
    }
    void setLocalPort(int value) { m_localPort = value; }

    bool hasDnsQueryType() { return !!m_dnsQueryType; }
    String getDnsQueryType(const String& defaultValue) const {
       return m_dnsQueryType.value_or(defaultValue);
    }
    const std::optional<String>& getDnsQueryType() const {
       return m_dnsQueryType;
    }
    void setDnsQueryType(const String& value) { m_dnsQueryType = value; }

    bool hasSendBufferSize() { return !!m_sendBufferSize; }
    double getSendBufferSize(double defaultValue) const {
       return m_sendBufferSize.value_or(defaultValue);
    }
    const std::optional<double>& getSendBufferSize() const {
       return m_sendBufferSize;
    }
    void setSendBufferSize(double value) { m_sendBufferSize = value; }

    bool hasReceiveBufferSize() { return !!m_receiveBufferSize; }
    double getReceiveBufferSize(double defaultValue) const {
       return m_receiveBufferSize.value_or(defaultValue);
    }
    const std::optional<double>& getReceiveBufferSize() const {
       return m_receiveBufferSize;
    }
    void setReceiveBufferSize(double value) { m_receiveBufferSize = value; }

    template<int STATE>
    class DirectUDPSocketOptionsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        DirectUDPSocketOptionsBuilder<STATE>& setRemoteAddr(const String& value)
        {
            m_result->setRemoteAddr(value);
            return *this;
        }

        DirectUDPSocketOptionsBuilder<STATE>& setRemotePort(int value)
        {
            m_result->setRemotePort(value);
            return *this;
        }

        DirectUDPSocketOptionsBuilder<STATE>& setLocalAddr(const String& value)
        {
            m_result->setLocalAddr(value);
            return *this;
        }

        DirectUDPSocketOptionsBuilder<STATE>& setLocalPort(int value)
        {
            m_result->setLocalPort(value);
            return *this;
        }

        DirectUDPSocketOptionsBuilder<STATE>& setDnsQueryType(const String& value)
        {
            m_result->setDnsQueryType(value);
            return *this;
        }

        DirectUDPSocketOptionsBuilder<STATE>& setSendBufferSize(double value)
        {
            m_result->setSendBufferSize(value);
            return *this;
        }

        DirectUDPSocketOptionsBuilder<STATE>& setReceiveBufferSize(double value)
        {
            m_result->setReceiveBufferSize(value);
            return *this;
        }

        std::unique_ptr<DirectUDPSocketOptions> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DirectUDPSocketOptions;
        DirectUDPSocketOptionsBuilder() : m_result(new DirectUDPSocketOptions()) { }

        template<int STEP> DirectUDPSocketOptionsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DirectUDPSocketOptionsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::DirectUDPSocketOptions> m_result;
    };

    static DirectUDPSocketOptionsBuilder<0> create()
    {
        return DirectUDPSocketOptionsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DirectUDPSocketOptions()
    {
    }

    std::optional<String> m_remoteAddr;
    std::optional<int> m_remotePort;
    std::optional<String> m_localAddr;
    std::optional<int> m_localPort;
    std::optional<String> m_dnsQueryType;
    std::optional<double> m_sendBufferSize;
    std::optional<double> m_receiveBufferSize;
};


class CORE_EXPORT DirectUDPMessage : public ::crdtp::ProtocolObject<DirectUDPMessage> {
public:
    ~DirectUDPMessage() override { }

    Binary getData() { return m_data; }
    void setData(const Binary& value) { m_data = value; }

    bool hasRemoteAddr() { return !!m_remoteAddr; }
    String getRemoteAddr(const String& defaultValue) const {
       return m_remoteAddr.value_or(defaultValue);
    }
    const std::optional<String>& getRemoteAddr() const {
       return m_remoteAddr;
    }
    void setRemoteAddr(const String& value) { m_remoteAddr = value; }

    bool hasRemotePort() { return !!m_remotePort; }
    int getRemotePort(int defaultValue) const {
       return m_remotePort.value_or(defaultValue);
    }
    const std::optional<int>& getRemotePort() const {
       return m_remotePort;
    }
    void setRemotePort(int value) { m_remotePort = value; }

    template<int STATE>
    class DirectUDPMessageBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            DataSet = 1 << 1,
            AllFieldsSet = (DataSet | 0)};


        DirectUDPMessageBuilder<STATE | DataSet>& setData(const Binary& value)
        {
            static_assert(!(STATE & DataSet), "property data should not be set yet");
            m_result->setData(value);
            return castState<DataSet>();
        }

        DirectUDPMessageBuilder<STATE>& setRemoteAddr(const String& value)
        {
            m_result->setRemoteAddr(value);
            return *this;
        }

        DirectUDPMessageBuilder<STATE>& setRemotePort(int value)
        {
            m_result->setRemotePort(value);
            return *this;
        }

        std::unique_ptr<DirectUDPMessage> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DirectUDPMessage;
        DirectUDPMessageBuilder() : m_result(new DirectUDPMessage()) { }

        template<int STEP> DirectUDPMessageBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DirectUDPMessageBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::DirectUDPMessage> m_result;
    };

    static DirectUDPMessageBuilder<0> create()
    {
        return DirectUDPMessageBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DirectUDPMessage()
    {
    }

    Binary m_data;
    std::optional<String> m_remoteAddr;
    std::optional<int> m_remotePort;
};


class CORE_EXPORT ConnectTiming : public ::crdtp::ProtocolObject<ConnectTiming> {
public:
    ~ConnectTiming() override { }

    double getRequestTime() { return m_requestTime; }
    void setRequestTime(double value) { m_requestTime = value; }

    template<int STATE>
    class ConnectTimingBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestTimeSet = 1 << 1,
            AllFieldsSet = (RequestTimeSet | 0)};


        ConnectTimingBuilder<STATE | RequestTimeSet>& setRequestTime(double value)
        {
            static_assert(!(STATE & RequestTimeSet), "property requestTime should not be set yet");
            m_result->setRequestTime(value);
            return castState<RequestTimeSet>();
        }

        std::unique_ptr<ConnectTiming> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ConnectTiming;
        ConnectTimingBuilder() : m_result(new ConnectTiming()) { }

        template<int STEP> ConnectTimingBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ConnectTimingBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ConnectTiming> m_result;
    };

    static ConnectTimingBuilder<0> create()
    {
        return ConnectTimingBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ConnectTiming()
    {
          m_requestTime = 0;
    }

    double m_requestTime;
};


class CORE_EXPORT ClientSecurityState : public ::crdtp::ProtocolObject<ClientSecurityState> {
public:
    ~ClientSecurityState() override { }

    bool getInitiatorIsSecureContext() { return m_initiatorIsSecureContext; }
    void setInitiatorIsSecureContext(bool value) { m_initiatorIsSecureContext = value; }

    String getInitiatorIPAddressSpace() { return m_initiatorIPAddressSpace; }
    void setInitiatorIPAddressSpace(const String& value) { m_initiatorIPAddressSpace = value; }

    String getPrivateNetworkRequestPolicy() { return m_privateNetworkRequestPolicy; }
    void setPrivateNetworkRequestPolicy(const String& value) { m_privateNetworkRequestPolicy = value; }

    template<int STATE>
    class ClientSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            InitiatorIsSecureContextSet = 1 << 1,
            InitiatorIPAddressSpaceSet = 1 << 2,
            PrivateNetworkRequestPolicySet = 1 << 3,
            AllFieldsSet = (InitiatorIsSecureContextSet | InitiatorIPAddressSpaceSet | PrivateNetworkRequestPolicySet | 0)};


        ClientSecurityStateBuilder<STATE | InitiatorIsSecureContextSet>& setInitiatorIsSecureContext(bool value)
        {
            static_assert(!(STATE & InitiatorIsSecureContextSet), "property initiatorIsSecureContext should not be set yet");
            m_result->setInitiatorIsSecureContext(value);
            return castState<InitiatorIsSecureContextSet>();
        }

        ClientSecurityStateBuilder<STATE | InitiatorIPAddressSpaceSet>& setInitiatorIPAddressSpace(const String& value)
        {
            static_assert(!(STATE & InitiatorIPAddressSpaceSet), "property initiatorIPAddressSpace should not be set yet");
            m_result->setInitiatorIPAddressSpace(value);
            return castState<InitiatorIPAddressSpaceSet>();
        }

        ClientSecurityStateBuilder<STATE | PrivateNetworkRequestPolicySet>& setPrivateNetworkRequestPolicy(const String& value)
        {
            static_assert(!(STATE & PrivateNetworkRequestPolicySet), "property privateNetworkRequestPolicy should not be set yet");
            m_result->setPrivateNetworkRequestPolicy(value);
            return castState<PrivateNetworkRequestPolicySet>();
        }

        std::unique_ptr<ClientSecurityState> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ClientSecurityState;
        ClientSecurityStateBuilder() : m_result(new ClientSecurityState()) { }

        template<int STEP> ClientSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ClientSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ClientSecurityState> m_result;
    };

    static ClientSecurityStateBuilder<0> create()
    {
        return ClientSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ClientSecurityState()
    {
          m_initiatorIsSecureContext = false;
    }

    bool m_initiatorIsSecureContext;
    String m_initiatorIPAddressSpace;
    String m_privateNetworkRequestPolicy;
};


class CORE_EXPORT ReportingApiReport : public ::crdtp::ProtocolObject<ReportingApiReport> {
public:
    ~ReportingApiReport() override { }

    String getId() { return m_id; }
    void setId(const String& value) { m_id = value; }

    String getInitiatorUrl() { return m_initiatorUrl; }
    void setInitiatorUrl(const String& value) { m_initiatorUrl = value; }

    String getDestination() { return m_destination; }
    void setDestination(const String& value) { m_destination = value; }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    double getTimestamp() { return m_timestamp; }
    void setTimestamp(double value) { m_timestamp = value; }

    int getDepth() { return m_depth; }
    void setDepth(int value) { m_depth = value; }

    int getCompletedAttempts() { return m_completedAttempts; }
    void setCompletedAttempts(int value) { m_completedAttempts = value; }

    protocol::DictionaryValue* getBody() { return m_body.get(); }
    void setBody(std::unique_ptr<protocol::DictionaryValue> value) { m_body = std::move(value); }

    String getStatus() { return m_status; }
    void setStatus(const String& value) { m_status = value; }

    template<int STATE>
    class ReportingApiReportBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            InitiatorUrlSet = 1 << 2,
            DestinationSet = 1 << 3,
            TypeSet = 1 << 4,
            TimestampSet = 1 << 5,
            DepthSet = 1 << 6,
            CompletedAttemptsSet = 1 << 7,
            BodySet = 1 << 8,
            StatusSet = 1 << 9,
            AllFieldsSet = (IdSet | InitiatorUrlSet | DestinationSet | TypeSet | TimestampSet | DepthSet | CompletedAttemptsSet | BodySet | StatusSet | 0)};


        ReportingApiReportBuilder<STATE | IdSet>& setId(const String& value)
        {
            static_assert(!(STATE & IdSet), "property id should not be set yet");
            m_result->setId(value);
            return castState<IdSet>();
        }

        ReportingApiReportBuilder<STATE | InitiatorUrlSet>& setInitiatorUrl(const String& value)
        {
            static_assert(!(STATE & InitiatorUrlSet), "property initiatorUrl should not be set yet");
            m_result->setInitiatorUrl(value);
            return castState<InitiatorUrlSet>();
        }

        ReportingApiReportBuilder<STATE | DestinationSet>& setDestination(const String& value)
        {
            static_assert(!(STATE & DestinationSet), "property destination should not be set yet");
            m_result->setDestination(value);
            return castState<DestinationSet>();
        }

        ReportingApiReportBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        ReportingApiReportBuilder<STATE | TimestampSet>& setTimestamp(double value)
        {
            static_assert(!(STATE & TimestampSet), "property timestamp should not be set yet");
            m_result->setTimestamp(value);
            return castState<TimestampSet>();
        }

        ReportingApiReportBuilder<STATE | DepthSet>& setDepth(int value)
        {
            static_assert(!(STATE & DepthSet), "property depth should not be set yet");
            m_result->setDepth(value);
            return castState<DepthSet>();
        }

        ReportingApiReportBuilder<STATE | CompletedAttemptsSet>& setCompletedAttempts(int value)
        {
            static_assert(!(STATE & CompletedAttemptsSet), "property completedAttempts should not be set yet");
            m_result->setCompletedAttempts(value);
            return castState<CompletedAttemptsSet>();
        }

        ReportingApiReportBuilder<STATE | BodySet>& setBody(std::unique_ptr<protocol::DictionaryValue> value)
        {
            static_assert(!(STATE & BodySet), "property body should not be set yet");
            m_result->setBody(std::move(value));
            return castState<BodySet>();
        }

        ReportingApiReportBuilder<STATE | StatusSet>& setStatus(const String& value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->setStatus(value);
            return castState<StatusSet>();
        }

        std::unique_ptr<ReportingApiReport> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ReportingApiReport;
        ReportingApiReportBuilder() : m_result(new ReportingApiReport()) { }

        template<int STEP> ReportingApiReportBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ReportingApiReportBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ReportingApiReport> m_result;
    };

    static ReportingApiReportBuilder<0> create()
    {
        return ReportingApiReportBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ReportingApiReport()
    {
          m_timestamp = 0;
          m_depth = 0;
          m_completedAttempts = 0;
    }

    String m_id;
    String m_initiatorUrl;
    String m_destination;
    String m_type;
    double m_timestamp;
    int m_depth;
    int m_completedAttempts;
    std::unique_ptr<protocol::DictionaryValue> m_body;
    String m_status;
};


class CORE_EXPORT ReportingApiEndpoint : public ::crdtp::ProtocolObject<ReportingApiEndpoint> {
public:
    ~ReportingApiEndpoint() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    String getGroupName() { return m_groupName; }
    void setGroupName(const String& value) { m_groupName = value; }

    template<int STATE>
    class ReportingApiEndpointBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            GroupNameSet = 1 << 2,
            AllFieldsSet = (UrlSet | GroupNameSet | 0)};


        ReportingApiEndpointBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        ReportingApiEndpointBuilder<STATE | GroupNameSet>& setGroupName(const String& value)
        {
            static_assert(!(STATE & GroupNameSet), "property groupName should not be set yet");
            m_result->setGroupName(value);
            return castState<GroupNameSet>();
        }

        std::unique_ptr<ReportingApiEndpoint> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ReportingApiEndpoint;
        ReportingApiEndpointBuilder() : m_result(new ReportingApiEndpoint()) { }

        template<int STEP> ReportingApiEndpointBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ReportingApiEndpointBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::ReportingApiEndpoint> m_result;
    };

    static ReportingApiEndpointBuilder<0> create()
    {
        return ReportingApiEndpointBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ReportingApiEndpoint()
    {
    }

    String m_url;
    String m_groupName;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse setAcceptedEncodings(std::unique_ptr<protocol::Array<String>> in_encodings) = 0;
    virtual DispatchResponse clearAcceptedEncodingsOverride() = 0;
    virtual DispatchResponse canClearBrowserCache(bool* out_result) = 0;
    virtual DispatchResponse canClearBrowserCookies(bool* out_result) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse emulateNetworkConditions(bool in_offline, double in_latency, double in_downloadThroughput, double in_uploadThroughput, std::optional<String> in_connectionType, std::optional<double> in_packetLoss, std::optional<int> in_packetQueueLength, std::optional<bool> in_packetReordering) = 0;
    virtual DispatchResponse emulateNetworkConditionsByRule(bool in_offline, std::unique_ptr<protocol::Array<protocol::Network::NetworkConditions>> in_matchedNetworkConditions, std::unique_ptr<protocol::Array<String>>* out_ruleIds) = 0;
    virtual DispatchResponse overrideNetworkState(bool in_offline, double in_latency, double in_downloadThroughput, double in_uploadThroughput, std::optional<String> in_connectionType) = 0;
    virtual DispatchResponse enable(std::optional<int> in_maxTotalBufferSize, std::optional<int> in_maxResourceBufferSize, std::optional<int> in_maxPostDataSize, std::optional<bool> in_reportDirectSocketTraffic, std::optional<bool> in_enableDurableMessages) = 0;
    virtual DispatchResponse getCertificate(const String& in_origin, std::unique_ptr<protocol::Array<String>>* out_tableNames) = 0;
    class CORE_EXPORT GetResponseBodyCallback {
    public:
        virtual void sendSuccess(const String& body, bool base64Encoded) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetResponseBodyCallback() { }
    };
    virtual void getResponseBody(const String& in_requestId, std::unique_ptr<GetResponseBodyCallback> callback) = 0;
    class CORE_EXPORT GetRequestPostDataCallback {
    public:
        virtual void sendSuccess(const String& postData) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetRequestPostDataCallback() { }
    };
    virtual void getRequestPostData(const String& in_requestId, std::unique_ptr<GetRequestPostDataCallback> callback) = 0;
    virtual DispatchResponse replayXHR(const String& in_requestId) = 0;
    virtual DispatchResponse searchInResponseBody(const String& in_requestId, const String& in_query, std::optional<bool> in_caseSensitive, std::optional<bool> in_isRegex, std::unique_ptr<protocol::Array<v8_inspector::protocol::Debugger::API::SearchMatch>>* out_result) = 0;
    virtual DispatchResponse setBlockedURLs(std::unique_ptr<protocol::Array<String>> in_urls) = 0;
    virtual DispatchResponse setBypassServiceWorker(bool in_bypass) = 0;
    virtual DispatchResponse setCacheDisabled(bool in_cacheDisabled) = 0;
    virtual DispatchResponse setExtraHTTPHeaders(std::unique_ptr<protocol::Network::Headers> in_headers) = 0;
    virtual DispatchResponse setAttachDebugStack(bool in_enabled) = 0;
    virtual DispatchResponse streamResourceContent(const String& in_requestId, Binary* out_bufferedData) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void dataReceived(const String& requestId, double timestamp, int dataLength, int encodedDataLength, std::optional<Binary> data = {});
    void eventSourceMessageReceived(const String& requestId, double timestamp, const String& eventName, const String& eventId, const String& data);
    void loadingFailed(const String& requestId, double timestamp, const String& type, const String& errorText, std::optional<bool> canceled = {}, std::optional<String> blockedReason = {}, std::unique_ptr<protocol::Network::CorsErrorStatus> corsErrorStatus = {});
    void loadingFinished(const String& requestId, double timestamp, double encodedDataLength);
    void requestIntercepted(const String& interceptionId, std::unique_ptr<protocol::Network::Request> request, const String& frameId, const String& resourceType, bool isNavigationRequest, std::optional<bool> isDownload = {}, std::optional<String> redirectUrl = {}, std::unique_ptr<protocol::Network::AuthChallenge> authChallenge = {}, std::optional<String> responseErrorReason = {}, std::optional<int> responseStatusCode = {}, std::unique_ptr<protocol::Network::Headers> responseHeaders = {}, std::optional<String> requestId = {});
    void requestServedFromCache(const String& requestId);
    void requestWillBeSent(const String& requestId, const String& loaderId, const String& documentURL, std::unique_ptr<protocol::Network::Request> request, double timestamp, double wallTime, std::unique_ptr<protocol::Network::Initiator> initiator, bool redirectHasExtraInfo, std::unique_ptr<protocol::Network::Response> redirectResponse = {}, std::optional<String> type = {}, std::optional<String> frameId = {}, std::optional<bool> hasUserGesture = {});
    void resourceChangedPriority(const String& requestId, const String& newPriority, double timestamp);
    void signedExchangeReceived(const String& requestId, std::unique_ptr<protocol::Network::SignedExchangeInfo> info);
    void responseReceived(const String& requestId, const String& loaderId, double timestamp, const String& type, std::unique_ptr<protocol::Network::Response> response, bool hasExtraInfo, std::optional<String> frameId = {});
    void webSocketClosed(const String& requestId, double timestamp);
    void webSocketCreated(const String& requestId, const String& url, std::unique_ptr<protocol::Network::Initiator> initiator = {});
    void webSocketFrameError(const String& requestId, double timestamp, const String& errorMessage);
    void webSocketFrameReceived(const String& requestId, double timestamp, std::unique_ptr<protocol::Network::WebSocketFrame> response);
    void webSocketFrameSent(const String& requestId, double timestamp, std::unique_ptr<protocol::Network::WebSocketFrame> response);
    void webSocketHandshakeResponseReceived(const String& requestId, double timestamp, std::unique_ptr<protocol::Network::WebSocketResponse> response);
    void webSocketWillSendHandshakeRequest(const String& requestId, double timestamp, double wallTime, std::unique_ptr<protocol::Network::WebSocketRequest> request);
    void webTransportCreated(const String& transportId, const String& url, double timestamp, std::unique_ptr<protocol::Network::Initiator> initiator = {});
    void webTransportConnectionEstablished(const String& transportId, double timestamp);
    void webTransportClosed(const String& transportId, double timestamp);
    void directTCPSocketCreated(const String& identifier, const String& remoteAddr, int remotePort, std::unique_ptr<protocol::Network::DirectTCPSocketOptions> options, double timestamp, std::unique_ptr<protocol::Network::Initiator> initiator = {});
    void directTCPSocketOpened(const String& identifier, const String& remoteAddr, int remotePort, double timestamp, std::optional<String> localAddr = {}, std::optional<int> localPort = {});
    void directTCPSocketAborted(const String& identifier, const String& errorMessage, double timestamp);
    void directTCPSocketClosed(const String& identifier, double timestamp);
    void directTCPSocketChunkSent(const String& identifier, const Binary& data, double timestamp);
    void directTCPSocketChunkReceived(const String& identifier, const Binary& data, double timestamp);
    void directUDPSocketCreated(const String& identifier, std::unique_ptr<protocol::Network::DirectUDPSocketOptions> options, double timestamp, std::unique_ptr<protocol::Network::Initiator> initiator = {});
    void directUDPSocketOpened(const String& identifier, const String& localAddr, int localPort, double timestamp, std::optional<String> remoteAddr = {}, std::optional<int> remotePort = {});
    void directUDPSocketAborted(const String& identifier, const String& errorMessage, double timestamp);
    void directUDPSocketClosed(const String& identifier, double timestamp);
    void directUDPSocketChunkSent(const String& identifier, std::unique_ptr<protocol::Network::DirectUDPMessage> message, double timestamp);
    void directUDPSocketChunkReceived(const String& identifier, std::unique_ptr<protocol::Network::DirectUDPMessage> message, double timestamp);
    void requestWillBeSentExtraInfo(const String& requestId, std::unique_ptr<protocol::Array<protocol::Network::AssociatedCookie>> associatedCookies, std::unique_ptr<protocol::Network::Headers> headers, std::unique_ptr<protocol::Network::ConnectTiming> connectTiming, std::unique_ptr<protocol::Network::ClientSecurityState> clientSecurityState = {}, std::optional<bool> siteHasCookieInOtherPartition = {}, std::optional<String> appliedNetworkConditionsId = {});
    void responseReceivedExtraInfo(const String& requestId, std::unique_ptr<protocol::Array<protocol::Network::BlockedSetCookieWithReason>> blockedCookies, std::unique_ptr<protocol::Network::Headers> headers, const String& resourceIPAddressSpace, int statusCode, std::optional<String> headersText = {}, std::unique_ptr<protocol::Network::CookiePartitionKey> cookiePartitionKey = {}, std::optional<bool> cookiePartitionKeyOpaque = {}, std::unique_ptr<protocol::Array<protocol::Network::ExemptedSetCookieWithReason>> exemptedCookies = {});
    void responseReceivedEarlyHints(const String& requestId, std::unique_ptr<protocol::Network::Headers> headers);
    void trustTokenOperationDone(const String& status, const String& type, const String& requestId, std::optional<String> topLevelOrigin = {}, std::optional<String> issuerOrigin = {}, std::optional<int> issuedTokenCount = {});
    void policyUpdated();
    void subresourceWebBundleMetadataReceived(const String& requestId, std::unique_ptr<protocol::Array<String>> urls);
    void subresourceWebBundleMetadataError(const String& requestId, const String& errorMessage);
    void subresourceWebBundleInnerResponseParsed(const String& innerRequestId, const String& innerRequestURL, std::optional<String> bundleRequestId = {});
    void subresourceWebBundleInnerResponseError(const String& innerRequestId, const String& innerRequestURL, const String& errorMessage, std::optional<String> bundleRequestId = {});
    void reportingApiReportAdded(std::unique_ptr<protocol::Network::ReportingApiReport> report);
    void reportingApiReportUpdated(std::unique_ptr<protocol::Network::ReportingApiReport> report);
    void reportingApiEndpointsChangedForOrigin(const String& origin, std::unique_ptr<protocol::Array<protocol::Network::ReportingApiEndpoint>> endpoints);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Network
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Network_h)
