// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Memory_h
#define blink_protocol_Memory_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace blink {
namespace protocol {
namespace Memory {
class SamplingProfileNode;
class SamplingProfile;
class Module;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CORE_EXPORT SamplingProfileNode : public ::crdtp::ProtocolObject<SamplingProfileNode> {
public:
    ~SamplingProfileNode() override { }

    double getSize() { return m_size; }
    void setSize(double value) { m_size = value; }

    double getTotal() { return m_total; }
    void setTotal(double value) { m_total = value; }

    protocol::Array<String>* getStack() { return m_stack.get(); }
    void setStack(std::unique_ptr<protocol::Array<String>> value) { m_stack = std::move(value); }

    template<int STATE>
    class SamplingProfileNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SizeSet = 1 << 1,
            TotalSet = 1 << 2,
            StackSet = 1 << 3,
            AllFieldsSet = (SizeSet | TotalSet | StackSet | 0)};


        SamplingProfileNodeBuilder<STATE | SizeSet>& setSize(double value)
        {
            static_assert(!(STATE & SizeSet), "property size should not be set yet");
            m_result->setSize(value);
            return castState<SizeSet>();
        }

        SamplingProfileNodeBuilder<STATE | TotalSet>& setTotal(double value)
        {
            static_assert(!(STATE & TotalSet), "property total should not be set yet");
            m_result->setTotal(value);
            return castState<TotalSet>();
        }

        SamplingProfileNodeBuilder<STATE | StackSet>& setStack(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & StackSet), "property stack should not be set yet");
            m_result->setStack(std::move(value));
            return castState<StackSet>();
        }

        std::unique_ptr<SamplingProfileNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SamplingProfileNode;
        SamplingProfileNodeBuilder() : m_result(new SamplingProfileNode()) { }

        template<int STEP> SamplingProfileNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SamplingProfileNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Memory::SamplingProfileNode> m_result;
    };

    static SamplingProfileNodeBuilder<0> create()
    {
        return SamplingProfileNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SamplingProfileNode()
    {
          m_size = 0;
          m_total = 0;
    }

    double m_size;
    double m_total;
    std::unique_ptr<protocol::Array<String>> m_stack;
};


class CORE_EXPORT SamplingProfile : public ::crdtp::ProtocolObject<SamplingProfile> {
public:
    ~SamplingProfile() override { }

    protocol::Array<protocol::Memory::SamplingProfileNode>* getSamples() { return m_samples.get(); }
    void setSamples(std::unique_ptr<protocol::Array<protocol::Memory::SamplingProfileNode>> value) { m_samples = std::move(value); }

    protocol::Array<protocol::Memory::Module>* getModules() { return m_modules.get(); }
    void setModules(std::unique_ptr<protocol::Array<protocol::Memory::Module>> value) { m_modules = std::move(value); }

    template<int STATE>
    class SamplingProfileBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SamplesSet = 1 << 1,
            ModulesSet = 1 << 2,
            AllFieldsSet = (SamplesSet | ModulesSet | 0)};


        SamplingProfileBuilder<STATE | SamplesSet>& setSamples(std::unique_ptr<protocol::Array<protocol::Memory::SamplingProfileNode>> value)
        {
            static_assert(!(STATE & SamplesSet), "property samples should not be set yet");
            m_result->setSamples(std::move(value));
            return castState<SamplesSet>();
        }

        SamplingProfileBuilder<STATE | ModulesSet>& setModules(std::unique_ptr<protocol::Array<protocol::Memory::Module>> value)
        {
            static_assert(!(STATE & ModulesSet), "property modules should not be set yet");
            m_result->setModules(std::move(value));
            return castState<ModulesSet>();
        }

        std::unique_ptr<SamplingProfile> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SamplingProfile;
        SamplingProfileBuilder() : m_result(new SamplingProfile()) { }

        template<int STEP> SamplingProfileBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SamplingProfileBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Memory::SamplingProfile> m_result;
    };

    static SamplingProfileBuilder<0> create()
    {
        return SamplingProfileBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SamplingProfile()
    {
    }

    std::unique_ptr<protocol::Array<protocol::Memory::SamplingProfileNode>> m_samples;
    std::unique_ptr<protocol::Array<protocol::Memory::Module>> m_modules;
};


class CORE_EXPORT Module : public ::crdtp::ProtocolObject<Module> {
public:
    ~Module() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getUuid() { return m_uuid; }
    void setUuid(const String& value) { m_uuid = value; }

    String getBaseAddress() { return m_baseAddress; }
    void setBaseAddress(const String& value) { m_baseAddress = value; }

    double getSize() { return m_size; }
    void setSize(double value) { m_size = value; }

    template<int STATE>
    class ModuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            UuidSet = 1 << 2,
            BaseAddressSet = 1 << 3,
            SizeSet = 1 << 4,
            AllFieldsSet = (NameSet | UuidSet | BaseAddressSet | SizeSet | 0)};


        ModuleBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        ModuleBuilder<STATE | UuidSet>& setUuid(const String& value)
        {
            static_assert(!(STATE & UuidSet), "property uuid should not be set yet");
            m_result->setUuid(value);
            return castState<UuidSet>();
        }

        ModuleBuilder<STATE | BaseAddressSet>& setBaseAddress(const String& value)
        {
            static_assert(!(STATE & BaseAddressSet), "property baseAddress should not be set yet");
            m_result->setBaseAddress(value);
            return castState<BaseAddressSet>();
        }

        ModuleBuilder<STATE | SizeSet>& setSize(double value)
        {
            static_assert(!(STATE & SizeSet), "property size should not be set yet");
            m_result->setSize(value);
            return castState<SizeSet>();
        }

        std::unique_ptr<Module> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Module;
        ModuleBuilder() : m_result(new Module()) { }

        template<int STEP> ModuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ModuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Memory::Module> m_result;
    };

    static ModuleBuilder<0> create()
    {
        return ModuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Module()
    {
          m_size = 0;
    }

    String m_name;
    String m_uuid;
    String m_baseAddress;
    double m_size;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse getDOMCounters(int* out_documents, int* out_nodes, int* out_jsEventListeners) = 0;
    virtual DispatchResponse forciblyPurgeJavaScriptMemory() = 0;
    virtual DispatchResponse startSampling(std::optional<int> in_samplingInterval, std::optional<bool> in_suppressRandomness) = 0;
    virtual DispatchResponse stopSampling() = 0;
    virtual DispatchResponse getAllTimeSamplingProfile(std::unique_ptr<protocol::Memory::SamplingProfile>* out_profile) = 0;
    virtual DispatchResponse getSamplingProfile(std::unique_ptr<protocol::Memory::SamplingProfile>* out_profile) = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Memory
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Memory_h)
