// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/dom_snapshot.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace DOMSnapshot {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "DOMSnapshot";
const char Metainfo::commandPrefix[] = "DOMSnapshot.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(DOMNode)
    CRDTP_DESERIALIZE_FIELD_OPT("attributes", m_attributes),
    CRDTP_DESERIALIZE_FIELD("backendNodeId", m_backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("baseURL", m_baseURL),
    CRDTP_DESERIALIZE_FIELD_OPT("childNodeIndexes", m_childNodeIndexes),
    CRDTP_DESERIALIZE_FIELD_OPT("contentDocumentIndex", m_contentDocumentIndex),
    CRDTP_DESERIALIZE_FIELD_OPT("contentLanguage", m_contentLanguage),
    CRDTP_DESERIALIZE_FIELD_OPT("currentSourceURL", m_currentSourceURL),
    CRDTP_DESERIALIZE_FIELD_OPT("documentEncoding", m_documentEncoding),
    CRDTP_DESERIALIZE_FIELD_OPT("documentURL", m_documentURL),
    CRDTP_DESERIALIZE_FIELD_OPT("eventListeners", m_eventListeners),
    CRDTP_DESERIALIZE_FIELD_OPT("frameId", m_frameId),
    CRDTP_DESERIALIZE_FIELD_OPT("inputChecked", m_inputChecked),
    CRDTP_DESERIALIZE_FIELD_OPT("inputValue", m_inputValue),
    CRDTP_DESERIALIZE_FIELD_OPT("isClickable", m_isClickable),
    CRDTP_DESERIALIZE_FIELD_OPT("layoutNodeIndex", m_layoutNodeIndex),
    CRDTP_DESERIALIZE_FIELD("nodeName", m_nodeName),
    CRDTP_DESERIALIZE_FIELD("nodeType", m_nodeType),
    CRDTP_DESERIALIZE_FIELD("nodeValue", m_nodeValue),
    CRDTP_DESERIALIZE_FIELD_OPT("optionSelected", m_optionSelected),
    CRDTP_DESERIALIZE_FIELD_OPT("originURL", m_originURL),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoElementIndexes", m_pseudoElementIndexes),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoType", m_pseudoType),
    CRDTP_DESERIALIZE_FIELD_OPT("publicId", m_publicId),
    CRDTP_DESERIALIZE_FIELD_OPT("scrollOffsetX", m_scrollOffsetX),
    CRDTP_DESERIALIZE_FIELD_OPT("scrollOffsetY", m_scrollOffsetY),
    CRDTP_DESERIALIZE_FIELD_OPT("shadowRootType", m_shadowRootType),
    CRDTP_DESERIALIZE_FIELD_OPT("systemId", m_systemId),
    CRDTP_DESERIALIZE_FIELD_OPT("textValue", m_textValue),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DOMNode)
    CRDTP_SERIALIZE_FIELD("nodeType", m_nodeType);
    CRDTP_SERIALIZE_FIELD("nodeName", m_nodeName);
    CRDTP_SERIALIZE_FIELD("nodeValue", m_nodeValue);
    CRDTP_SERIALIZE_FIELD("textValue", m_textValue);
    CRDTP_SERIALIZE_FIELD("inputValue", m_inputValue);
    CRDTP_SERIALIZE_FIELD("inputChecked", m_inputChecked);
    CRDTP_SERIALIZE_FIELD("optionSelected", m_optionSelected);
    CRDTP_SERIALIZE_FIELD("backendNodeId", m_backendNodeId);
    CRDTP_SERIALIZE_FIELD("childNodeIndexes", m_childNodeIndexes);
    CRDTP_SERIALIZE_FIELD("attributes", m_attributes);
    CRDTP_SERIALIZE_FIELD("pseudoElementIndexes", m_pseudoElementIndexes);
    CRDTP_SERIALIZE_FIELD("layoutNodeIndex", m_layoutNodeIndex);
    CRDTP_SERIALIZE_FIELD("documentURL", m_documentURL);
    CRDTP_SERIALIZE_FIELD("baseURL", m_baseURL);
    CRDTP_SERIALIZE_FIELD("contentLanguage", m_contentLanguage);
    CRDTP_SERIALIZE_FIELD("documentEncoding", m_documentEncoding);
    CRDTP_SERIALIZE_FIELD("publicId", m_publicId);
    CRDTP_SERIALIZE_FIELD("systemId", m_systemId);
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
    CRDTP_SERIALIZE_FIELD("contentDocumentIndex", m_contentDocumentIndex);
    CRDTP_SERIALIZE_FIELD("pseudoType", m_pseudoType);
    CRDTP_SERIALIZE_FIELD("shadowRootType", m_shadowRootType);
    CRDTP_SERIALIZE_FIELD("isClickable", m_isClickable);
    CRDTP_SERIALIZE_FIELD("eventListeners", m_eventListeners);
    CRDTP_SERIALIZE_FIELD("currentSourceURL", m_currentSourceURL);
    CRDTP_SERIALIZE_FIELD("originURL", m_originURL);
    CRDTP_SERIALIZE_FIELD("scrollOffsetX", m_scrollOffsetX);
    CRDTP_SERIALIZE_FIELD("scrollOffsetY", m_scrollOffsetY);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(InlineTextBox)
    CRDTP_DESERIALIZE_FIELD("boundingBox", m_boundingBox),
    CRDTP_DESERIALIZE_FIELD("numCharacters", m_numCharacters),
    CRDTP_DESERIALIZE_FIELD("startCharacterIndex", m_startCharacterIndex),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InlineTextBox)
    CRDTP_SERIALIZE_FIELD("boundingBox", m_boundingBox);
    CRDTP_SERIALIZE_FIELD("startCharacterIndex", m_startCharacterIndex);
    CRDTP_SERIALIZE_FIELD("numCharacters", m_numCharacters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(LayoutTreeNode)
    CRDTP_DESERIALIZE_FIELD("boundingBox", m_boundingBox),
    CRDTP_DESERIALIZE_FIELD("domNodeIndex", m_domNodeIndex),
    CRDTP_DESERIALIZE_FIELD_OPT("inlineTextNodes", m_inlineTextNodes),
    CRDTP_DESERIALIZE_FIELD_OPT("isStackingContext", m_isStackingContext),
    CRDTP_DESERIALIZE_FIELD_OPT("layoutText", m_layoutText),
    CRDTP_DESERIALIZE_FIELD_OPT("paintOrder", m_paintOrder),
    CRDTP_DESERIALIZE_FIELD_OPT("styleIndex", m_styleIndex),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LayoutTreeNode)
    CRDTP_SERIALIZE_FIELD("domNodeIndex", m_domNodeIndex);
    CRDTP_SERIALIZE_FIELD("boundingBox", m_boundingBox);
    CRDTP_SERIALIZE_FIELD("layoutText", m_layoutText);
    CRDTP_SERIALIZE_FIELD("inlineTextNodes", m_inlineTextNodes);
    CRDTP_SERIALIZE_FIELD("styleIndex", m_styleIndex);
    CRDTP_SERIALIZE_FIELD("paintOrder", m_paintOrder);
    CRDTP_SERIALIZE_FIELD("isStackingContext", m_isStackingContext);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ComputedStyle)
    CRDTP_DESERIALIZE_FIELD("properties", m_properties),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ComputedStyle)
    CRDTP_SERIALIZE_FIELD("properties", m_properties);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(NameValue)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(NameValue)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();




CRDTP_BEGIN_DESERIALIZER(RareStringData)
    CRDTP_DESERIALIZE_FIELD("index", m_index),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RareStringData)
    CRDTP_SERIALIZE_FIELD("index", m_index);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(RareBooleanData)
    CRDTP_DESERIALIZE_FIELD("index", m_index),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RareBooleanData)
    CRDTP_SERIALIZE_FIELD("index", m_index);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(RareIntegerData)
    CRDTP_DESERIALIZE_FIELD("index", m_index),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RareIntegerData)
    CRDTP_SERIALIZE_FIELD("index", m_index);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();



CRDTP_BEGIN_DESERIALIZER(DocumentSnapshot)
    CRDTP_DESERIALIZE_FIELD("baseURL", m_baseURL),
    CRDTP_DESERIALIZE_FIELD_OPT("contentHeight", m_contentHeight),
    CRDTP_DESERIALIZE_FIELD("contentLanguage", m_contentLanguage),
    CRDTP_DESERIALIZE_FIELD_OPT("contentWidth", m_contentWidth),
    CRDTP_DESERIALIZE_FIELD("documentURL", m_documentURL),
    CRDTP_DESERIALIZE_FIELD("encodingName", m_encodingName),
    CRDTP_DESERIALIZE_FIELD("frameId", m_frameId),
    CRDTP_DESERIALIZE_FIELD("layout", m_layout),
    CRDTP_DESERIALIZE_FIELD("nodes", m_nodes),
    CRDTP_DESERIALIZE_FIELD("publicId", m_publicId),
    CRDTP_DESERIALIZE_FIELD_OPT("scrollOffsetX", m_scrollOffsetX),
    CRDTP_DESERIALIZE_FIELD_OPT("scrollOffsetY", m_scrollOffsetY),
    CRDTP_DESERIALIZE_FIELD("systemId", m_systemId),
    CRDTP_DESERIALIZE_FIELD("textBoxes", m_textBoxes),
    CRDTP_DESERIALIZE_FIELD("title", m_title),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DocumentSnapshot)
    CRDTP_SERIALIZE_FIELD("documentURL", m_documentURL);
    CRDTP_SERIALIZE_FIELD("title", m_title);
    CRDTP_SERIALIZE_FIELD("baseURL", m_baseURL);
    CRDTP_SERIALIZE_FIELD("contentLanguage", m_contentLanguage);
    CRDTP_SERIALIZE_FIELD("encodingName", m_encodingName);
    CRDTP_SERIALIZE_FIELD("publicId", m_publicId);
    CRDTP_SERIALIZE_FIELD("systemId", m_systemId);
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
    CRDTP_SERIALIZE_FIELD("nodes", m_nodes);
    CRDTP_SERIALIZE_FIELD("layout", m_layout);
    CRDTP_SERIALIZE_FIELD("textBoxes", m_textBoxes);
    CRDTP_SERIALIZE_FIELD("scrollOffsetX", m_scrollOffsetX);
    CRDTP_SERIALIZE_FIELD("scrollOffsetY", m_scrollOffsetY);
    CRDTP_SERIALIZE_FIELD("contentWidth", m_contentWidth);
    CRDTP_SERIALIZE_FIELD("contentHeight", m_contentHeight);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(NodeTreeSnapshot)
    CRDTP_DESERIALIZE_FIELD_OPT("attributes", m_attributes),
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", m_backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("contentDocumentIndex", m_contentDocumentIndex),
    CRDTP_DESERIALIZE_FIELD_OPT("currentSourceURL", m_currentSourceURL),
    CRDTP_DESERIALIZE_FIELD_OPT("inputChecked", m_inputChecked),
    CRDTP_DESERIALIZE_FIELD_OPT("inputValue", m_inputValue),
    CRDTP_DESERIALIZE_FIELD_OPT("isClickable", m_isClickable),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeName", m_nodeName),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeType", m_nodeType),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeValue", m_nodeValue),
    CRDTP_DESERIALIZE_FIELD_OPT("optionSelected", m_optionSelected),
    CRDTP_DESERIALIZE_FIELD_OPT("originURL", m_originURL),
    CRDTP_DESERIALIZE_FIELD_OPT("parentIndex", m_parentIndex),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoIdentifier", m_pseudoIdentifier),
    CRDTP_DESERIALIZE_FIELD_OPT("pseudoType", m_pseudoType),
    CRDTP_DESERIALIZE_FIELD_OPT("shadowRootType", m_shadowRootType),
    CRDTP_DESERIALIZE_FIELD_OPT("textValue", m_textValue),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(NodeTreeSnapshot)
    CRDTP_SERIALIZE_FIELD("parentIndex", m_parentIndex);
    CRDTP_SERIALIZE_FIELD("nodeType", m_nodeType);
    CRDTP_SERIALIZE_FIELD("shadowRootType", m_shadowRootType);
    CRDTP_SERIALIZE_FIELD("nodeName", m_nodeName);
    CRDTP_SERIALIZE_FIELD("nodeValue", m_nodeValue);
    CRDTP_SERIALIZE_FIELD("backendNodeId", m_backendNodeId);
    CRDTP_SERIALIZE_FIELD("attributes", m_attributes);
    CRDTP_SERIALIZE_FIELD("textValue", m_textValue);
    CRDTP_SERIALIZE_FIELD("inputValue", m_inputValue);
    CRDTP_SERIALIZE_FIELD("inputChecked", m_inputChecked);
    CRDTP_SERIALIZE_FIELD("optionSelected", m_optionSelected);
    CRDTP_SERIALIZE_FIELD("contentDocumentIndex", m_contentDocumentIndex);
    CRDTP_SERIALIZE_FIELD("pseudoType", m_pseudoType);
    CRDTP_SERIALIZE_FIELD("pseudoIdentifier", m_pseudoIdentifier);
    CRDTP_SERIALIZE_FIELD("isClickable", m_isClickable);
    CRDTP_SERIALIZE_FIELD("currentSourceURL", m_currentSourceURL);
    CRDTP_SERIALIZE_FIELD("originURL", m_originURL);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(LayoutTreeSnapshot)
    CRDTP_DESERIALIZE_FIELD_OPT("blendedBackgroundColors", m_blendedBackgroundColors),
    CRDTP_DESERIALIZE_FIELD("bounds", m_bounds),
    CRDTP_DESERIALIZE_FIELD_OPT("clientRects", m_clientRects),
    CRDTP_DESERIALIZE_FIELD("nodeIndex", m_nodeIndex),
    CRDTP_DESERIALIZE_FIELD_OPT("offsetRects", m_offsetRects),
    CRDTP_DESERIALIZE_FIELD_OPT("paintOrders", m_paintOrders),
    CRDTP_DESERIALIZE_FIELD_OPT("scrollRects", m_scrollRects),
    CRDTP_DESERIALIZE_FIELD("stackingContexts", m_stackingContexts),
    CRDTP_DESERIALIZE_FIELD("styles", m_styles),
    CRDTP_DESERIALIZE_FIELD("text", m_text),
    CRDTP_DESERIALIZE_FIELD_OPT("textColorOpacities", m_textColorOpacities),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LayoutTreeSnapshot)
    CRDTP_SERIALIZE_FIELD("nodeIndex", m_nodeIndex);
    CRDTP_SERIALIZE_FIELD("styles", m_styles);
    CRDTP_SERIALIZE_FIELD("bounds", m_bounds);
    CRDTP_SERIALIZE_FIELD("text", m_text);
    CRDTP_SERIALIZE_FIELD("stackingContexts", m_stackingContexts);
    CRDTP_SERIALIZE_FIELD("paintOrders", m_paintOrders);
    CRDTP_SERIALIZE_FIELD("offsetRects", m_offsetRects);
    CRDTP_SERIALIZE_FIELD("scrollRects", m_scrollRects);
    CRDTP_SERIALIZE_FIELD("clientRects", m_clientRects);
    CRDTP_SERIALIZE_FIELD("blendedBackgroundColors", m_blendedBackgroundColors);
    CRDTP_SERIALIZE_FIELD("textColorOpacities", m_textColorOpacities);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(TextBoxSnapshot)
    CRDTP_DESERIALIZE_FIELD("bounds", m_bounds),
    CRDTP_DESERIALIZE_FIELD("layoutIndex", m_layoutIndex),
    CRDTP_DESERIALIZE_FIELD("length", m_length),
    CRDTP_DESERIALIZE_FIELD("start", m_start),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(TextBoxSnapshot)
    CRDTP_SERIALIZE_FIELD("layoutIndex", m_layoutIndex);
    CRDTP_SERIALIZE_FIELD("bounds", m_bounds);
    CRDTP_SERIALIZE_FIELD("start", m_start);
    CRDTP_SERIALIZE_FIELD("length", m_length);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void getSnapshot(const crdtp::Dispatchable& dispatchable);
    void captureSnapshot(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("captureSnapshot"),
          &DomainDispatcherImpl::captureSnapshot
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getSnapshot"),
          &DomainDispatcherImpl::getSnapshot
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMSnapshot.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMSnapshot.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getSnapshotParams : public crdtp::DeserializableProtocolObject<getSnapshotParams> {
    std::unique_ptr<protocol::Array<String>> computedStyleWhitelist;
    std::optional<bool> includeEventListeners;
    std::optional<bool> includePaintOrder;
    std::optional<bool> includeUserAgentShadowTree;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getSnapshotParams)
    CRDTP_DESERIALIZE_FIELD("computedStyleWhitelist", computedStyleWhitelist),
    CRDTP_DESERIALIZE_FIELD_OPT("includeEventListeners", includeEventListeners),
    CRDTP_DESERIALIZE_FIELD_OPT("includePaintOrder", includePaintOrder),
    CRDTP_DESERIALIZE_FIELD_OPT("includeUserAgentShadowTree", includeUserAgentShadowTree),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getSnapshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getSnapshotParams params;
    if (!getSnapshotParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::DOMSnapshot::DOMNode>> out_domNodes;
    std::unique_ptr<protocol::Array<protocol::DOMSnapshot::LayoutTreeNode>> out_layoutTreeNodes;
    std::unique_ptr<protocol::Array<protocol::DOMSnapshot::ComputedStyle>> out_computedStyles;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getSnapshot(std::move(params.computedStyleWhitelist), std::move(params.includeEventListeners), std::move(params.includePaintOrder), std::move(params.includeUserAgentShadowTree), &out_domNodes, &out_layoutTreeNodes, &out_computedStyles);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMSnapshot.getSnapshot"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("domNodes"), out_domNodes);
          serializer.AddField(crdtp::MakeSpan("layoutTreeNodes"), out_layoutTreeNodes);
          serializer.AddField(crdtp::MakeSpan("computedStyles"), out_computedStyles);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct captureSnapshotParams : public crdtp::DeserializableProtocolObject<captureSnapshotParams> {
    std::unique_ptr<protocol::Array<String>> computedStyles;
    std::optional<bool> includePaintOrder;
    std::optional<bool> includeDOMRects;
    std::optional<bool> includeBlendedBackgroundColors;
    std::optional<bool> includeTextColorOpacities;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(captureSnapshotParams)
    CRDTP_DESERIALIZE_FIELD("computedStyles", computedStyles),
    CRDTP_DESERIALIZE_FIELD_OPT("includeBlendedBackgroundColors", includeBlendedBackgroundColors),
    CRDTP_DESERIALIZE_FIELD_OPT("includeDOMRects", includeDOMRects),
    CRDTP_DESERIALIZE_FIELD_OPT("includePaintOrder", includePaintOrder),
    CRDTP_DESERIALIZE_FIELD_OPT("includeTextColorOpacities", includeTextColorOpacities),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::captureSnapshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    captureSnapshotParams params;
    if (!captureSnapshotParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::DOMSnapshot::DocumentSnapshot>> out_documents;
    std::unique_ptr<protocol::Array<String>> out_strings;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->captureSnapshot(std::move(params.computedStyles), std::move(params.includePaintOrder), std::move(params.includeDOMRects), std::move(params.includeBlendedBackgroundColors), std::move(params.includeTextColorOpacities), &out_documents, &out_strings);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMSnapshot.captureSnapshot"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("documents"), out_documents);
          serializer.AddField(crdtp::MakeSpan("strings"), out_strings);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("DOMSnapshot"), SortedRedirects(), std::move(dispatcher));
}

} // DOMSnapshot
} // namespace blink
} // namespace protocol
