// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_CSS_h
#define blink_protocol_CSS_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"
#include "third_party/blink/renderer/core/inspector/protocol/page.h"

namespace blink {
namespace protocol {
namespace CSS {
using StyleSheetId = String;
using StyleSheetOrigin = String;
class PseudoElementMatches;
class CSSAnimationStyle;
class InheritedStyleEntry;
class InheritedAnimatedStyleEntry;
class InheritedPseudoElementMatches;
class RuleMatch;
class Value;
class Specificity;
class SelectorList;
class CSSStyleSheetHeader;
class CSSRule;
using CSSRuleType = String;
class RuleUsage;
class SourceRange;
class ShorthandEntry;
class CSSComputedStyleProperty;
class ComputedStyleExtraFields;
class CSSStyle;
class CSSProperty;
class CSSMedia;
class MediaQuery;
class MediaQueryExpression;
class CSSContainerQuery;
class CSSSupports;
class CSSScope;
class CSSLayer;
class CSSStartingStyle;
class CSSLayerData;
class PlatformFontUsage;
class FontVariationAxis;
class FontFace;
class CSSPositionTryRule;
class CSSKeyframesRule;
class CSSPropertyRegistration;
class CSSFontPaletteValuesRule;
class CSSPropertyRule;
class CSSFunctionParameter;
class CSSFunctionConditionNode;
class CSSFunctionNode;
class CSSFunctionRule;
class CSSKeyframeRule;
class StyleDeclarationEdit;

// ------------- Forward and enum declarations.

namespace StyleSheetOriginEnum {
CORE_EXPORT extern const char Injected[];
CORE_EXPORT extern const char UserAgent[];
CORE_EXPORT extern const char Inspector[];
CORE_EXPORT extern const char Regular[];
} // namespace StyleSheetOriginEnum

namespace CSSRuleTypeEnum {
CORE_EXPORT extern const char MediaRule[];
CORE_EXPORT extern const char SupportsRule[];
CORE_EXPORT extern const char ContainerRule[];
CORE_EXPORT extern const char LayerRule[];
CORE_EXPORT extern const char ScopeRule[];
CORE_EXPORT extern const char StyleRule[];
CORE_EXPORT extern const char StartingStyleRule[];
} // namespace CSSRuleTypeEnum

// ------------- Type and builder declarations.

class CORE_EXPORT PseudoElementMatches : public ::crdtp::ProtocolObject<PseudoElementMatches> {
public:
    ~PseudoElementMatches() override { }

    String getPseudoType() { return m_pseudoType; }
    void setPseudoType(const String& value) { m_pseudoType = value; }

    bool hasPseudoIdentifier() { return !!m_pseudoIdentifier; }
    String getPseudoIdentifier(const String& defaultValue) const {
       return m_pseudoIdentifier.value_or(defaultValue);
    }
    const std::optional<String>& getPseudoIdentifier() const {
       return m_pseudoIdentifier;
    }
    void setPseudoIdentifier(const String& value) { m_pseudoIdentifier = value; }

    protocol::Array<protocol::CSS::RuleMatch>* getMatches() { return m_matches.get(); }
    void setMatches(std::unique_ptr<protocol::Array<protocol::CSS::RuleMatch>> value) { m_matches = std::move(value); }

    template<int STATE>
    class PseudoElementMatchesBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PseudoTypeSet = 1 << 1,
            MatchesSet = 1 << 2,
            AllFieldsSet = (PseudoTypeSet | MatchesSet | 0)};


        PseudoElementMatchesBuilder<STATE | PseudoTypeSet>& setPseudoType(const String& value)
        {
            static_assert(!(STATE & PseudoTypeSet), "property pseudoType should not be set yet");
            m_result->setPseudoType(value);
            return castState<PseudoTypeSet>();
        }

        PseudoElementMatchesBuilder<STATE>& setPseudoIdentifier(const String& value)
        {
            m_result->setPseudoIdentifier(value);
            return *this;
        }

        PseudoElementMatchesBuilder<STATE | MatchesSet>& setMatches(std::unique_ptr<protocol::Array<protocol::CSS::RuleMatch>> value)
        {
            static_assert(!(STATE & MatchesSet), "property matches should not be set yet");
            m_result->setMatches(std::move(value));
            return castState<MatchesSet>();
        }

        std::unique_ptr<PseudoElementMatches> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PseudoElementMatches;
        PseudoElementMatchesBuilder() : m_result(new PseudoElementMatches()) { }

        template<int STEP> PseudoElementMatchesBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PseudoElementMatchesBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::PseudoElementMatches> m_result;
    };

    static PseudoElementMatchesBuilder<0> create()
    {
        return PseudoElementMatchesBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PseudoElementMatches()
    {
    }

    String m_pseudoType;
    std::optional<String> m_pseudoIdentifier;
    std::unique_ptr<protocol::Array<protocol::CSS::RuleMatch>> m_matches;
};


class CORE_EXPORT CSSAnimationStyle : public ::crdtp::ProtocolObject<CSSAnimationStyle> {
public:
    ~CSSAnimationStyle() override { }

    bool hasName() { return !!m_name; }
    String getName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& getName() const {
       return m_name;
    }
    void setName(const String& value) { m_name = value; }

    protocol::CSS::CSSStyle* getStyle() { return m_style.get(); }
    void setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_style = std::move(value); }

    template<int STATE>
    class CSSAnimationStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StyleSet = 1 << 1,
            AllFieldsSet = (StyleSet | 0)};


        CSSAnimationStyleBuilder<STATE>& setName(const String& value)
        {
            m_result->setName(value);
            return *this;
        }

        CSSAnimationStyleBuilder<STATE | StyleSet>& setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value)
        {
            static_assert(!(STATE & StyleSet), "property style should not be set yet");
            m_result->setStyle(std::move(value));
            return castState<StyleSet>();
        }

        std::unique_ptr<CSSAnimationStyle> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSAnimationStyle;
        CSSAnimationStyleBuilder() : m_result(new CSSAnimationStyle()) { }

        template<int STEP> CSSAnimationStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSAnimationStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSAnimationStyle> m_result;
    };

    static CSSAnimationStyleBuilder<0> create()
    {
        return CSSAnimationStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSAnimationStyle()
    {
    }

    std::optional<String> m_name;
    std::unique_ptr<protocol::CSS::CSSStyle> m_style;
};


class CORE_EXPORT InheritedStyleEntry : public ::crdtp::ProtocolObject<InheritedStyleEntry> {
public:
    ~InheritedStyleEntry() override { }

    bool hasInlineStyle() { return !!m_inlineStyle; }
    protocol::CSS::CSSStyle* getInlineStyle(protocol::CSS::CSSStyle* defaultValue) {
       return m_inlineStyle ? m_inlineStyle.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::CSSStyle>& getInlineStyle() const {
       return m_inlineStyle;
    }
    void setInlineStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_inlineStyle = std::move(value); }

    protocol::Array<protocol::CSS::RuleMatch>* getMatchedCSSRules() { return m_matchedCSSRules.get(); }
    void setMatchedCSSRules(std::unique_ptr<protocol::Array<protocol::CSS::RuleMatch>> value) { m_matchedCSSRules = std::move(value); }

    template<int STATE>
    class InheritedStyleEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            MatchedCSSRulesSet = 1 << 1,
            AllFieldsSet = (MatchedCSSRulesSet | 0)};


        InheritedStyleEntryBuilder<STATE>& setInlineStyle(std::unique_ptr<protocol::CSS::CSSStyle> value)
        {
            m_result->setInlineStyle(std::move(value));
            return *this;
        }

        InheritedStyleEntryBuilder<STATE | MatchedCSSRulesSet>& setMatchedCSSRules(std::unique_ptr<protocol::Array<protocol::CSS::RuleMatch>> value)
        {
            static_assert(!(STATE & MatchedCSSRulesSet), "property matchedCSSRules should not be set yet");
            m_result->setMatchedCSSRules(std::move(value));
            return castState<MatchedCSSRulesSet>();
        }

        std::unique_ptr<InheritedStyleEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InheritedStyleEntry;
        InheritedStyleEntryBuilder() : m_result(new InheritedStyleEntry()) { }

        template<int STEP> InheritedStyleEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InheritedStyleEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::InheritedStyleEntry> m_result;
    };

    static InheritedStyleEntryBuilder<0> create()
    {
        return InheritedStyleEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InheritedStyleEntry()
    {
    }

    std::unique_ptr<protocol::CSS::CSSStyle> m_inlineStyle;
    std::unique_ptr<protocol::Array<protocol::CSS::RuleMatch>> m_matchedCSSRules;
};


class CORE_EXPORT InheritedAnimatedStyleEntry : public ::crdtp::ProtocolObject<InheritedAnimatedStyleEntry> {
public:
    ~InheritedAnimatedStyleEntry() override { }

    bool hasAnimationStyles() { return !!m_animationStyles; }
    protocol::Array<protocol::CSS::CSSAnimationStyle>* getAnimationStyles(protocol::Array<protocol::CSS::CSSAnimationStyle>* defaultValue) {
       return m_animationStyles ? m_animationStyles.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::CSSAnimationStyle>>& getAnimationStyles() const {
       return m_animationStyles;
    }
    void setAnimationStyles(std::unique_ptr<protocol::Array<protocol::CSS::CSSAnimationStyle>> value) { m_animationStyles = std::move(value); }

    bool hasTransitionsStyle() { return !!m_transitionsStyle; }
    protocol::CSS::CSSStyle* getTransitionsStyle(protocol::CSS::CSSStyle* defaultValue) {
       return m_transitionsStyle ? m_transitionsStyle.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::CSSStyle>& getTransitionsStyle() const {
       return m_transitionsStyle;
    }
    void setTransitionsStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_transitionsStyle = std::move(value); }

    template<int STATE>
    class InheritedAnimatedStyleEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        InheritedAnimatedStyleEntryBuilder<STATE>& setAnimationStyles(std::unique_ptr<protocol::Array<protocol::CSS::CSSAnimationStyle>> value)
        {
            m_result->setAnimationStyles(std::move(value));
            return *this;
        }

        InheritedAnimatedStyleEntryBuilder<STATE>& setTransitionsStyle(std::unique_ptr<protocol::CSS::CSSStyle> value)
        {
            m_result->setTransitionsStyle(std::move(value));
            return *this;
        }

        std::unique_ptr<InheritedAnimatedStyleEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InheritedAnimatedStyleEntry;
        InheritedAnimatedStyleEntryBuilder() : m_result(new InheritedAnimatedStyleEntry()) { }

        template<int STEP> InheritedAnimatedStyleEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InheritedAnimatedStyleEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::InheritedAnimatedStyleEntry> m_result;
    };

    static InheritedAnimatedStyleEntryBuilder<0> create()
    {
        return InheritedAnimatedStyleEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InheritedAnimatedStyleEntry()
    {
    }

    std::unique_ptr<protocol::Array<protocol::CSS::CSSAnimationStyle>> m_animationStyles;
    std::unique_ptr<protocol::CSS::CSSStyle> m_transitionsStyle;
};


class CORE_EXPORT InheritedPseudoElementMatches : public ::crdtp::ProtocolObject<InheritedPseudoElementMatches> {
public:
    ~InheritedPseudoElementMatches() override { }

    protocol::Array<protocol::CSS::PseudoElementMatches>* getPseudoElements() { return m_pseudoElements.get(); }
    void setPseudoElements(std::unique_ptr<protocol::Array<protocol::CSS::PseudoElementMatches>> value) { m_pseudoElements = std::move(value); }

    template<int STATE>
    class InheritedPseudoElementMatchesBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PseudoElementsSet = 1 << 1,
            AllFieldsSet = (PseudoElementsSet | 0)};


        InheritedPseudoElementMatchesBuilder<STATE | PseudoElementsSet>& setPseudoElements(std::unique_ptr<protocol::Array<protocol::CSS::PseudoElementMatches>> value)
        {
            static_assert(!(STATE & PseudoElementsSet), "property pseudoElements should not be set yet");
            m_result->setPseudoElements(std::move(value));
            return castState<PseudoElementsSet>();
        }

        std::unique_ptr<InheritedPseudoElementMatches> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InheritedPseudoElementMatches;
        InheritedPseudoElementMatchesBuilder() : m_result(new InheritedPseudoElementMatches()) { }

        template<int STEP> InheritedPseudoElementMatchesBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InheritedPseudoElementMatchesBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::InheritedPseudoElementMatches> m_result;
    };

    static InheritedPseudoElementMatchesBuilder<0> create()
    {
        return InheritedPseudoElementMatchesBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InheritedPseudoElementMatches()
    {
    }

    std::unique_ptr<protocol::Array<protocol::CSS::PseudoElementMatches>> m_pseudoElements;
};


class CORE_EXPORT RuleMatch : public ::crdtp::ProtocolObject<RuleMatch> {
public:
    ~RuleMatch() override { }

    protocol::CSS::CSSRule* getRule() { return m_rule.get(); }
    void setRule(std::unique_ptr<protocol::CSS::CSSRule> value) { m_rule = std::move(value); }

    protocol::Array<int>* getMatchingSelectors() { return m_matchingSelectors.get(); }
    void setMatchingSelectors(std::unique_ptr<protocol::Array<int>> value) { m_matchingSelectors = std::move(value); }

    template<int STATE>
    class RuleMatchBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RuleSet = 1 << 1,
            MatchingSelectorsSet = 1 << 2,
            AllFieldsSet = (RuleSet | MatchingSelectorsSet | 0)};


        RuleMatchBuilder<STATE | RuleSet>& setRule(std::unique_ptr<protocol::CSS::CSSRule> value)
        {
            static_assert(!(STATE & RuleSet), "property rule should not be set yet");
            m_result->setRule(std::move(value));
            return castState<RuleSet>();
        }

        RuleMatchBuilder<STATE | MatchingSelectorsSet>& setMatchingSelectors(std::unique_ptr<protocol::Array<int>> value)
        {
            static_assert(!(STATE & MatchingSelectorsSet), "property matchingSelectors should not be set yet");
            m_result->setMatchingSelectors(std::move(value));
            return castState<MatchingSelectorsSet>();
        }

        std::unique_ptr<RuleMatch> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RuleMatch;
        RuleMatchBuilder() : m_result(new RuleMatch()) { }

        template<int STEP> RuleMatchBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RuleMatchBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::RuleMatch> m_result;
    };

    static RuleMatchBuilder<0> create()
    {
        return RuleMatchBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RuleMatch()
    {
    }

    std::unique_ptr<protocol::CSS::CSSRule> m_rule;
    std::unique_ptr<protocol::Array<int>> m_matchingSelectors;
};


class CORE_EXPORT Value : public ::crdtp::ProtocolObject<Value> {
public:
    ~Value() override { }

    String getText() { return m_text; }
    void setText(const String& value) { m_text = value; }

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    bool hasSpecificity() { return !!m_specificity; }
    protocol::CSS::Specificity* getSpecificity(protocol::CSS::Specificity* defaultValue) {
       return m_specificity ? m_specificity.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::Specificity>& getSpecificity() const {
       return m_specificity;
    }
    void setSpecificity(std::unique_ptr<protocol::CSS::Specificity> value) { m_specificity = std::move(value); }

    template<int STATE>
    class ValueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TextSet = 1 << 1,
            AllFieldsSet = (TextSet | 0)};


        ValueBuilder<STATE | TextSet>& setText(const String& value)
        {
            static_assert(!(STATE & TextSet), "property text should not be set yet");
            m_result->setText(value);
            return castState<TextSet>();
        }

        ValueBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setRange(std::move(value));
            return *this;
        }

        ValueBuilder<STATE>& setSpecificity(std::unique_ptr<protocol::CSS::Specificity> value)
        {
            m_result->setSpecificity(std::move(value));
            return *this;
        }

        std::unique_ptr<Value> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Value;
        ValueBuilder() : m_result(new Value()) { }

        template<int STEP> ValueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ValueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::Value> m_result;
    };

    static ValueBuilder<0> create()
    {
        return ValueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Value()
    {
    }

    String m_text;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    std::unique_ptr<protocol::CSS::Specificity> m_specificity;
};


class CORE_EXPORT Specificity : public ::crdtp::ProtocolObject<Specificity> {
public:
    ~Specificity() override { }

    int getA() { return m_a; }
    void setA(int value) { m_a = value; }

    int getB() { return m_b; }
    void setB(int value) { m_b = value; }

    int getC() { return m_c; }
    void setC(int value) { m_c = value; }

    template<int STATE>
    class SpecificityBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ASet = 1 << 1,
            BSet = 1 << 2,
            CSet = 1 << 3,
            AllFieldsSet = (ASet | BSet | CSet | 0)};


        SpecificityBuilder<STATE | ASet>& setA(int value)
        {
            static_assert(!(STATE & ASet), "property a should not be set yet");
            m_result->setA(value);
            return castState<ASet>();
        }

        SpecificityBuilder<STATE | BSet>& setB(int value)
        {
            static_assert(!(STATE & BSet), "property b should not be set yet");
            m_result->setB(value);
            return castState<BSet>();
        }

        SpecificityBuilder<STATE | CSet>& setC(int value)
        {
            static_assert(!(STATE & CSet), "property c should not be set yet");
            m_result->setC(value);
            return castState<CSet>();
        }

        std::unique_ptr<Specificity> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Specificity;
        SpecificityBuilder() : m_result(new Specificity()) { }

        template<int STEP> SpecificityBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SpecificityBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::Specificity> m_result;
    };

    static SpecificityBuilder<0> create()
    {
        return SpecificityBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Specificity()
    {
          m_a = 0;
          m_b = 0;
          m_c = 0;
    }

    int m_a;
    int m_b;
    int m_c;
};


class CORE_EXPORT SelectorList : public ::crdtp::ProtocolObject<SelectorList> {
public:
    ~SelectorList() override { }

    protocol::Array<protocol::CSS::Value>* getSelectors() { return m_selectors.get(); }
    void setSelectors(std::unique_ptr<protocol::Array<protocol::CSS::Value>> value) { m_selectors = std::move(value); }

    String getText() { return m_text; }
    void setText(const String& value) { m_text = value; }

    template<int STATE>
    class SelectorListBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SelectorsSet = 1 << 1,
            TextSet = 1 << 2,
            AllFieldsSet = (SelectorsSet | TextSet | 0)};


        SelectorListBuilder<STATE | SelectorsSet>& setSelectors(std::unique_ptr<protocol::Array<protocol::CSS::Value>> value)
        {
            static_assert(!(STATE & SelectorsSet), "property selectors should not be set yet");
            m_result->setSelectors(std::move(value));
            return castState<SelectorsSet>();
        }

        SelectorListBuilder<STATE | TextSet>& setText(const String& value)
        {
            static_assert(!(STATE & TextSet), "property text should not be set yet");
            m_result->setText(value);
            return castState<TextSet>();
        }

        std::unique_ptr<SelectorList> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SelectorList;
        SelectorListBuilder() : m_result(new SelectorList()) { }

        template<int STEP> SelectorListBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SelectorListBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::SelectorList> m_result;
    };

    static SelectorListBuilder<0> create()
    {
        return SelectorListBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SelectorList()
    {
    }

    std::unique_ptr<protocol::Array<protocol::CSS::Value>> m_selectors;
    String m_text;
};


class CORE_EXPORT CSSStyleSheetHeader : public ::crdtp::ProtocolObject<CSSStyleSheetHeader> {
public:
    ~CSSStyleSheetHeader() override { }

    String getStyleSheetId() { return m_styleSheetId; }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    String getFrameId() { return m_frameId; }
    void setFrameId(const String& value) { m_frameId = value; }

    String getSourceURL() { return m_sourceURL; }
    void setSourceURL(const String& value) { m_sourceURL = value; }

    bool hasSourceMapURL() { return !!m_sourceMapURL; }
    String getSourceMapURL(const String& defaultValue) const {
       return m_sourceMapURL.value_or(defaultValue);
    }
    const std::optional<String>& getSourceMapURL() const {
       return m_sourceMapURL;
    }
    void setSourceMapURL(const String& value) { m_sourceMapURL = value; }

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value) { m_origin = value; }

    String getTitle() { return m_title; }
    void setTitle(const String& value) { m_title = value; }

    bool hasOwnerNode() { return !!m_ownerNode; }
    int getOwnerNode(int defaultValue) const {
       return m_ownerNode.value_or(defaultValue);
    }
    const std::optional<int>& getOwnerNode() const {
       return m_ownerNode;
    }
    void setOwnerNode(int value) { m_ownerNode = value; }

    bool getDisabled() { return m_disabled; }
    void setDisabled(bool value) { m_disabled = value; }

    bool hasHasSourceURL() { return !!m_hasSourceURL; }
    bool getHasSourceURL(bool defaultValue) const {
       return m_hasSourceURL.value_or(defaultValue);
    }
    const std::optional<bool>& getHasSourceURL() const {
       return m_hasSourceURL;
    }
    void setHasSourceURL(bool value) { m_hasSourceURL = value; }

    bool getIsInline() { return m_isInline; }
    void setIsInline(bool value) { m_isInline = value; }

    bool getIsMutable() { return m_isMutable; }
    void setIsMutable(bool value) { m_isMutable = value; }

    bool getIsConstructed() { return m_isConstructed; }
    void setIsConstructed(bool value) { m_isConstructed = value; }

    double getStartLine() { return m_startLine; }
    void setStartLine(double value) { m_startLine = value; }

    double getStartColumn() { return m_startColumn; }
    void setStartColumn(double value) { m_startColumn = value; }

    double getLength() { return m_length; }
    void setLength(double value) { m_length = value; }

    double getEndLine() { return m_endLine; }
    void setEndLine(double value) { m_endLine = value; }

    double getEndColumn() { return m_endColumn; }
    void setEndColumn(double value) { m_endColumn = value; }

    bool hasLoadingFailed() { return !!m_loadingFailed; }
    bool getLoadingFailed(bool defaultValue) const {
       return m_loadingFailed.value_or(defaultValue);
    }
    const std::optional<bool>& getLoadingFailed() const {
       return m_loadingFailed;
    }
    void setLoadingFailed(bool value) { m_loadingFailed = value; }

    template<int STATE>
    class CSSStyleSheetHeaderBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StyleSheetIdSet = 1 << 1,
            FrameIdSet = 1 << 2,
            SourceURLSet = 1 << 3,
            OriginSet = 1 << 4,
            TitleSet = 1 << 5,
            DisabledSet = 1 << 6,
            IsInlineSet = 1 << 7,
            IsMutableSet = 1 << 8,
            IsConstructedSet = 1 << 9,
            StartLineSet = 1 << 10,
            StartColumnSet = 1 << 11,
            LengthSet = 1 << 12,
            EndLineSet = 1 << 13,
            EndColumnSet = 1 << 14,
            AllFieldsSet = (StyleSheetIdSet | FrameIdSet | SourceURLSet | OriginSet | TitleSet | DisabledSet | IsInlineSet | IsMutableSet | IsConstructedSet | StartLineSet | StartColumnSet | LengthSet | EndLineSet | EndColumnSet | 0)};


        CSSStyleSheetHeaderBuilder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& value)
        {
            static_assert(!(STATE & StyleSheetIdSet), "property styleSheetId should not be set yet");
            m_result->setStyleSheetId(value);
            return castState<StyleSheetIdSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | FrameIdSet>& setFrameId(const String& value)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
            m_result->setFrameId(value);
            return castState<FrameIdSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | SourceURLSet>& setSourceURL(const String& value)
        {
            static_assert(!(STATE & SourceURLSet), "property sourceURL should not be set yet");
            m_result->setSourceURL(value);
            return castState<SourceURLSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE>& setSourceMapURL(const String& value)
        {
            m_result->setSourceMapURL(value);
            return *this;
        }

        CSSStyleSheetHeaderBuilder<STATE | OriginSet>& setOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->setOrigin(value);
            return castState<OriginSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | TitleSet>& setTitle(const String& value)
        {
            static_assert(!(STATE & TitleSet), "property title should not be set yet");
            m_result->setTitle(value);
            return castState<TitleSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE>& setOwnerNode(int value)
        {
            m_result->setOwnerNode(value);
            return *this;
        }

        CSSStyleSheetHeaderBuilder<STATE | DisabledSet>& setDisabled(bool value)
        {
            static_assert(!(STATE & DisabledSet), "property disabled should not be set yet");
            m_result->setDisabled(value);
            return castState<DisabledSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE>& setHasSourceURL(bool value)
        {
            m_result->setHasSourceURL(value);
            return *this;
        }

        CSSStyleSheetHeaderBuilder<STATE | IsInlineSet>& setIsInline(bool value)
        {
            static_assert(!(STATE & IsInlineSet), "property isInline should not be set yet");
            m_result->setIsInline(value);
            return castState<IsInlineSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | IsMutableSet>& setIsMutable(bool value)
        {
            static_assert(!(STATE & IsMutableSet), "property isMutable should not be set yet");
            m_result->setIsMutable(value);
            return castState<IsMutableSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | IsConstructedSet>& setIsConstructed(bool value)
        {
            static_assert(!(STATE & IsConstructedSet), "property isConstructed should not be set yet");
            m_result->setIsConstructed(value);
            return castState<IsConstructedSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | StartLineSet>& setStartLine(double value)
        {
            static_assert(!(STATE & StartLineSet), "property startLine should not be set yet");
            m_result->setStartLine(value);
            return castState<StartLineSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | StartColumnSet>& setStartColumn(double value)
        {
            static_assert(!(STATE & StartColumnSet), "property startColumn should not be set yet");
            m_result->setStartColumn(value);
            return castState<StartColumnSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | LengthSet>& setLength(double value)
        {
            static_assert(!(STATE & LengthSet), "property length should not be set yet");
            m_result->setLength(value);
            return castState<LengthSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | EndLineSet>& setEndLine(double value)
        {
            static_assert(!(STATE & EndLineSet), "property endLine should not be set yet");
            m_result->setEndLine(value);
            return castState<EndLineSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE | EndColumnSet>& setEndColumn(double value)
        {
            static_assert(!(STATE & EndColumnSet), "property endColumn should not be set yet");
            m_result->setEndColumn(value);
            return castState<EndColumnSet>();
        }

        CSSStyleSheetHeaderBuilder<STATE>& setLoadingFailed(bool value)
        {
            m_result->setLoadingFailed(value);
            return *this;
        }

        std::unique_ptr<CSSStyleSheetHeader> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSStyleSheetHeader;
        CSSStyleSheetHeaderBuilder() : m_result(new CSSStyleSheetHeader()) { }

        template<int STEP> CSSStyleSheetHeaderBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSStyleSheetHeaderBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSStyleSheetHeader> m_result;
    };

    static CSSStyleSheetHeaderBuilder<0> create()
    {
        return CSSStyleSheetHeaderBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSStyleSheetHeader()
    {
          m_disabled = false;
          m_isInline = false;
          m_isMutable = false;
          m_isConstructed = false;
          m_startLine = 0;
          m_startColumn = 0;
          m_length = 0;
          m_endLine = 0;
          m_endColumn = 0;
    }

    String m_styleSheetId;
    String m_frameId;
    String m_sourceURL;
    std::optional<String> m_sourceMapURL;
    String m_origin;
    String m_title;
    std::optional<int> m_ownerNode;
    bool m_disabled;
    std::optional<bool> m_hasSourceURL;
    bool m_isInline;
    bool m_isMutable;
    bool m_isConstructed;
    double m_startLine;
    double m_startColumn;
    double m_length;
    double m_endLine;
    double m_endColumn;
    std::optional<bool> m_loadingFailed;
};


class CORE_EXPORT CSSRule : public ::crdtp::ProtocolObject<CSSRule> {
public:
    ~CSSRule() override { }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    protocol::CSS::SelectorList* getSelectorList() { return m_selectorList.get(); }
    void setSelectorList(std::unique_ptr<protocol::CSS::SelectorList> value) { m_selectorList = std::move(value); }

    bool hasNestingSelectors() { return !!m_nestingSelectors; }
    protocol::Array<String>* getNestingSelectors(protocol::Array<String>* defaultValue) {
       return m_nestingSelectors ? m_nestingSelectors.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getNestingSelectors() const {
       return m_nestingSelectors;
    }
    void setNestingSelectors(std::unique_ptr<protocol::Array<String>> value) { m_nestingSelectors = std::move(value); }

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value) { m_origin = value; }

    protocol::CSS::CSSStyle* getStyle() { return m_style.get(); }
    void setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_style = std::move(value); }

    bool hasOriginTreeScopeNodeId() { return !!m_originTreeScopeNodeId; }
    int getOriginTreeScopeNodeId(int defaultValue) const {
       return m_originTreeScopeNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getOriginTreeScopeNodeId() const {
       return m_originTreeScopeNodeId;
    }
    void setOriginTreeScopeNodeId(int value) { m_originTreeScopeNodeId = value; }

    bool hasMedia() { return !!m_media; }
    protocol::Array<protocol::CSS::CSSMedia>* getMedia(protocol::Array<protocol::CSS::CSSMedia>* defaultValue) {
       return m_media ? m_media.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::CSSMedia>>& getMedia() const {
       return m_media;
    }
    void setMedia(std::unique_ptr<protocol::Array<protocol::CSS::CSSMedia>> value) { m_media = std::move(value); }

    bool hasContainerQueries() { return !!m_containerQueries; }
    protocol::Array<protocol::CSS::CSSContainerQuery>* getContainerQueries(protocol::Array<protocol::CSS::CSSContainerQuery>* defaultValue) {
       return m_containerQueries ? m_containerQueries.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::CSSContainerQuery>>& getContainerQueries() const {
       return m_containerQueries;
    }
    void setContainerQueries(std::unique_ptr<protocol::Array<protocol::CSS::CSSContainerQuery>> value) { m_containerQueries = std::move(value); }

    bool hasSupports() { return !!m_supports; }
    protocol::Array<protocol::CSS::CSSSupports>* getSupports(protocol::Array<protocol::CSS::CSSSupports>* defaultValue) {
       return m_supports ? m_supports.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::CSSSupports>>& getSupports() const {
       return m_supports;
    }
    void setSupports(std::unique_ptr<protocol::Array<protocol::CSS::CSSSupports>> value) { m_supports = std::move(value); }

    bool hasLayers() { return !!m_layers; }
    protocol::Array<protocol::CSS::CSSLayer>* getLayers(protocol::Array<protocol::CSS::CSSLayer>* defaultValue) {
       return m_layers ? m_layers.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::CSSLayer>>& getLayers() const {
       return m_layers;
    }
    void setLayers(std::unique_ptr<protocol::Array<protocol::CSS::CSSLayer>> value) { m_layers = std::move(value); }

    bool hasScopes() { return !!m_scopes; }
    protocol::Array<protocol::CSS::CSSScope>* getScopes(protocol::Array<protocol::CSS::CSSScope>* defaultValue) {
       return m_scopes ? m_scopes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::CSSScope>>& getScopes() const {
       return m_scopes;
    }
    void setScopes(std::unique_ptr<protocol::Array<protocol::CSS::CSSScope>> value) { m_scopes = std::move(value); }

    bool hasRuleTypes() { return !!m_ruleTypes; }
    protocol::Array<String>* getRuleTypes(protocol::Array<String>* defaultValue) {
       return m_ruleTypes ? m_ruleTypes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getRuleTypes() const {
       return m_ruleTypes;
    }
    void setRuleTypes(std::unique_ptr<protocol::Array<String>> value) { m_ruleTypes = std::move(value); }

    bool hasStartingStyles() { return !!m_startingStyles; }
    protocol::Array<protocol::CSS::CSSStartingStyle>* getStartingStyles(protocol::Array<protocol::CSS::CSSStartingStyle>* defaultValue) {
       return m_startingStyles ? m_startingStyles.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::CSSStartingStyle>>& getStartingStyles() const {
       return m_startingStyles;
    }
    void setStartingStyles(std::unique_ptr<protocol::Array<protocol::CSS::CSSStartingStyle>> value) { m_startingStyles = std::move(value); }

    template<int STATE>
    class CSSRuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SelectorListSet = 1 << 1,
            OriginSet = 1 << 2,
            StyleSet = 1 << 3,
            AllFieldsSet = (SelectorListSet | OriginSet | StyleSet | 0)};


        CSSRuleBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        CSSRuleBuilder<STATE | SelectorListSet>& setSelectorList(std::unique_ptr<protocol::CSS::SelectorList> value)
        {
            static_assert(!(STATE & SelectorListSet), "property selectorList should not be set yet");
            m_result->setSelectorList(std::move(value));
            return castState<SelectorListSet>();
        }

        CSSRuleBuilder<STATE>& setNestingSelectors(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->setNestingSelectors(std::move(value));
            return *this;
        }

        CSSRuleBuilder<STATE | OriginSet>& setOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->setOrigin(value);
            return castState<OriginSet>();
        }

        CSSRuleBuilder<STATE | StyleSet>& setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value)
        {
            static_assert(!(STATE & StyleSet), "property style should not be set yet");
            m_result->setStyle(std::move(value));
            return castState<StyleSet>();
        }

        CSSRuleBuilder<STATE>& setOriginTreeScopeNodeId(int value)
        {
            m_result->setOriginTreeScopeNodeId(value);
            return *this;
        }

        CSSRuleBuilder<STATE>& setMedia(std::unique_ptr<protocol::Array<protocol::CSS::CSSMedia>> value)
        {
            m_result->setMedia(std::move(value));
            return *this;
        }

        CSSRuleBuilder<STATE>& setContainerQueries(std::unique_ptr<protocol::Array<protocol::CSS::CSSContainerQuery>> value)
        {
            m_result->setContainerQueries(std::move(value));
            return *this;
        }

        CSSRuleBuilder<STATE>& setSupports(std::unique_ptr<protocol::Array<protocol::CSS::CSSSupports>> value)
        {
            m_result->setSupports(std::move(value));
            return *this;
        }

        CSSRuleBuilder<STATE>& setLayers(std::unique_ptr<protocol::Array<protocol::CSS::CSSLayer>> value)
        {
            m_result->setLayers(std::move(value));
            return *this;
        }

        CSSRuleBuilder<STATE>& setScopes(std::unique_ptr<protocol::Array<protocol::CSS::CSSScope>> value)
        {
            m_result->setScopes(std::move(value));
            return *this;
        }

        CSSRuleBuilder<STATE>& setRuleTypes(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->setRuleTypes(std::move(value));
            return *this;
        }

        CSSRuleBuilder<STATE>& setStartingStyles(std::unique_ptr<protocol::Array<protocol::CSS::CSSStartingStyle>> value)
        {
            m_result->setStartingStyles(std::move(value));
            return *this;
        }

        std::unique_ptr<CSSRule> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSRule;
        CSSRuleBuilder() : m_result(new CSSRule()) { }

        template<int STEP> CSSRuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSRuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSRule> m_result;
    };

    static CSSRuleBuilder<0> create()
    {
        return CSSRuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSRule()
    {
    }

    std::optional<String> m_styleSheetId;
    std::unique_ptr<protocol::CSS::SelectorList> m_selectorList;
    std::unique_ptr<protocol::Array<String>> m_nestingSelectors;
    String m_origin;
    std::unique_ptr<protocol::CSS::CSSStyle> m_style;
    std::optional<int> m_originTreeScopeNodeId;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSMedia>> m_media;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSContainerQuery>> m_containerQueries;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSSupports>> m_supports;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSLayer>> m_layers;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSScope>> m_scopes;
    std::unique_ptr<protocol::Array<String>> m_ruleTypes;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSStartingStyle>> m_startingStyles;
};


class CORE_EXPORT RuleUsage : public ::crdtp::ProtocolObject<RuleUsage> {
public:
    ~RuleUsage() override { }

    String getStyleSheetId() { return m_styleSheetId; }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    double getStartOffset() { return m_startOffset; }
    void setStartOffset(double value) { m_startOffset = value; }

    double getEndOffset() { return m_endOffset; }
    void setEndOffset(double value) { m_endOffset = value; }

    bool getUsed() { return m_used; }
    void setUsed(bool value) { m_used = value; }

    template<int STATE>
    class RuleUsageBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StyleSheetIdSet = 1 << 1,
            StartOffsetSet = 1 << 2,
            EndOffsetSet = 1 << 3,
            UsedSet = 1 << 4,
            AllFieldsSet = (StyleSheetIdSet | StartOffsetSet | EndOffsetSet | UsedSet | 0)};


        RuleUsageBuilder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& value)
        {
            static_assert(!(STATE & StyleSheetIdSet), "property styleSheetId should not be set yet");
            m_result->setStyleSheetId(value);
            return castState<StyleSheetIdSet>();
        }

        RuleUsageBuilder<STATE | StartOffsetSet>& setStartOffset(double value)
        {
            static_assert(!(STATE & StartOffsetSet), "property startOffset should not be set yet");
            m_result->setStartOffset(value);
            return castState<StartOffsetSet>();
        }

        RuleUsageBuilder<STATE | EndOffsetSet>& setEndOffset(double value)
        {
            static_assert(!(STATE & EndOffsetSet), "property endOffset should not be set yet");
            m_result->setEndOffset(value);
            return castState<EndOffsetSet>();
        }

        RuleUsageBuilder<STATE | UsedSet>& setUsed(bool value)
        {
            static_assert(!(STATE & UsedSet), "property used should not be set yet");
            m_result->setUsed(value);
            return castState<UsedSet>();
        }

        std::unique_ptr<RuleUsage> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RuleUsage;
        RuleUsageBuilder() : m_result(new RuleUsage()) { }

        template<int STEP> RuleUsageBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RuleUsageBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::RuleUsage> m_result;
    };

    static RuleUsageBuilder<0> create()
    {
        return RuleUsageBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RuleUsage()
    {
          m_startOffset = 0;
          m_endOffset = 0;
          m_used = false;
    }

    String m_styleSheetId;
    double m_startOffset;
    double m_endOffset;
    bool m_used;
};


class CORE_EXPORT SourceRange : public ::crdtp::ProtocolObject<SourceRange> {
public:
    ~SourceRange() override { }

    int getStartLine() { return m_startLine; }
    void setStartLine(int value) { m_startLine = value; }

    int getStartColumn() { return m_startColumn; }
    void setStartColumn(int value) { m_startColumn = value; }

    int getEndLine() { return m_endLine; }
    void setEndLine(int value) { m_endLine = value; }

    int getEndColumn() { return m_endColumn; }
    void setEndColumn(int value) { m_endColumn = value; }

    template<int STATE>
    class SourceRangeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StartLineSet = 1 << 1,
            StartColumnSet = 1 << 2,
            EndLineSet = 1 << 3,
            EndColumnSet = 1 << 4,
            AllFieldsSet = (StartLineSet | StartColumnSet | EndLineSet | EndColumnSet | 0)};


        SourceRangeBuilder<STATE | StartLineSet>& setStartLine(int value)
        {
            static_assert(!(STATE & StartLineSet), "property startLine should not be set yet");
            m_result->setStartLine(value);
            return castState<StartLineSet>();
        }

        SourceRangeBuilder<STATE | StartColumnSet>& setStartColumn(int value)
        {
            static_assert(!(STATE & StartColumnSet), "property startColumn should not be set yet");
            m_result->setStartColumn(value);
            return castState<StartColumnSet>();
        }

        SourceRangeBuilder<STATE | EndLineSet>& setEndLine(int value)
        {
            static_assert(!(STATE & EndLineSet), "property endLine should not be set yet");
            m_result->setEndLine(value);
            return castState<EndLineSet>();
        }

        SourceRangeBuilder<STATE | EndColumnSet>& setEndColumn(int value)
        {
            static_assert(!(STATE & EndColumnSet), "property endColumn should not be set yet");
            m_result->setEndColumn(value);
            return castState<EndColumnSet>();
        }

        std::unique_ptr<SourceRange> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SourceRange;
        SourceRangeBuilder() : m_result(new SourceRange()) { }

        template<int STEP> SourceRangeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SourceRangeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::SourceRange> m_result;
    };

    static SourceRangeBuilder<0> create()
    {
        return SourceRangeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SourceRange()
    {
          m_startLine = 0;
          m_startColumn = 0;
          m_endLine = 0;
          m_endColumn = 0;
    }

    int m_startLine;
    int m_startColumn;
    int m_endLine;
    int m_endColumn;
};


class CORE_EXPORT ShorthandEntry : public ::crdtp::ProtocolObject<ShorthandEntry> {
public:
    ~ShorthandEntry() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getValue() { return m_value; }
    void setValue(const String& value) { m_value = value; }

    bool hasImportant() { return !!m_important; }
    bool getImportant(bool defaultValue) const {
       return m_important.value_or(defaultValue);
    }
    const std::optional<bool>& getImportant() const {
       return m_important;
    }
    void setImportant(bool value) { m_important = value; }

    template<int STATE>
    class ShorthandEntryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        ShorthandEntryBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        ShorthandEntryBuilder<STATE | ValueSet>& setValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(value);
            return castState<ValueSet>();
        }

        ShorthandEntryBuilder<STATE>& setImportant(bool value)
        {
            m_result->setImportant(value);
            return *this;
        }

        std::unique_ptr<ShorthandEntry> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ShorthandEntry;
        ShorthandEntryBuilder() : m_result(new ShorthandEntry()) { }

        template<int STEP> ShorthandEntryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ShorthandEntryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::ShorthandEntry> m_result;
    };

    static ShorthandEntryBuilder<0> create()
    {
        return ShorthandEntryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ShorthandEntry()
    {
    }

    String m_name;
    String m_value;
    std::optional<bool> m_important;
};


class CORE_EXPORT CSSComputedStyleProperty : public ::crdtp::ProtocolObject<CSSComputedStyleProperty> {
public:
    ~CSSComputedStyleProperty() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getValue() { return m_value; }
    void setValue(const String& value) { m_value = value; }

    template<int STATE>
    class CSSComputedStylePropertyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        CSSComputedStylePropertyBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        CSSComputedStylePropertyBuilder<STATE | ValueSet>& setValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<CSSComputedStyleProperty> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSComputedStyleProperty;
        CSSComputedStylePropertyBuilder() : m_result(new CSSComputedStyleProperty()) { }

        template<int STEP> CSSComputedStylePropertyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSComputedStylePropertyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSComputedStyleProperty> m_result;
    };

    static CSSComputedStylePropertyBuilder<0> create()
    {
        return CSSComputedStylePropertyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSComputedStyleProperty()
    {
    }

    String m_name;
    String m_value;
};


class CORE_EXPORT ComputedStyleExtraFields : public ::crdtp::ProtocolObject<ComputedStyleExtraFields> {
public:
    ~ComputedStyleExtraFields() override { }

    bool getIsAppearanceBase() { return m_isAppearanceBase; }
    void setIsAppearanceBase(bool value) { m_isAppearanceBase = value; }

    template<int STATE>
    class ComputedStyleExtraFieldsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IsAppearanceBaseSet = 1 << 1,
            AllFieldsSet = (IsAppearanceBaseSet | 0)};


        ComputedStyleExtraFieldsBuilder<STATE | IsAppearanceBaseSet>& setIsAppearanceBase(bool value)
        {
            static_assert(!(STATE & IsAppearanceBaseSet), "property isAppearanceBase should not be set yet");
            m_result->setIsAppearanceBase(value);
            return castState<IsAppearanceBaseSet>();
        }

        std::unique_ptr<ComputedStyleExtraFields> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ComputedStyleExtraFields;
        ComputedStyleExtraFieldsBuilder() : m_result(new ComputedStyleExtraFields()) { }

        template<int STEP> ComputedStyleExtraFieldsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ComputedStyleExtraFieldsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::ComputedStyleExtraFields> m_result;
    };

    static ComputedStyleExtraFieldsBuilder<0> create()
    {
        return ComputedStyleExtraFieldsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ComputedStyleExtraFields()
    {
          m_isAppearanceBase = false;
    }

    bool m_isAppearanceBase;
};


class CORE_EXPORT CSSStyle : public ::crdtp::ProtocolObject<CSSStyle> {
public:
    ~CSSStyle() override { }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    protocol::Array<protocol::CSS::CSSProperty>* getCssProperties() { return m_cssProperties.get(); }
    void setCssProperties(std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> value) { m_cssProperties = std::move(value); }

    protocol::Array<protocol::CSS::ShorthandEntry>* getShorthandEntries() { return m_shorthandEntries.get(); }
    void setShorthandEntries(std::unique_ptr<protocol::Array<protocol::CSS::ShorthandEntry>> value) { m_shorthandEntries = std::move(value); }

    bool hasCssText() { return !!m_cssText; }
    String getCssText(const String& defaultValue) const {
       return m_cssText.value_or(defaultValue);
    }
    const std::optional<String>& getCssText() const {
       return m_cssText;
    }
    void setCssText(const String& value) { m_cssText = value; }

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    template<int STATE>
    class CSSStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CssPropertiesSet = 1 << 1,
            ShorthandEntriesSet = 1 << 2,
            AllFieldsSet = (CssPropertiesSet | ShorthandEntriesSet | 0)};


        CSSStyleBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        CSSStyleBuilder<STATE | CssPropertiesSet>& setCssProperties(std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> value)
        {
            static_assert(!(STATE & CssPropertiesSet), "property cssProperties should not be set yet");
            m_result->setCssProperties(std::move(value));
            return castState<CssPropertiesSet>();
        }

        CSSStyleBuilder<STATE | ShorthandEntriesSet>& setShorthandEntries(std::unique_ptr<protocol::Array<protocol::CSS::ShorthandEntry>> value)
        {
            static_assert(!(STATE & ShorthandEntriesSet), "property shorthandEntries should not be set yet");
            m_result->setShorthandEntries(std::move(value));
            return castState<ShorthandEntriesSet>();
        }

        CSSStyleBuilder<STATE>& setCssText(const String& value)
        {
            m_result->setCssText(value);
            return *this;
        }

        CSSStyleBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setRange(std::move(value));
            return *this;
        }

        std::unique_ptr<CSSStyle> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSStyle;
        CSSStyleBuilder() : m_result(new CSSStyle()) { }

        template<int STEP> CSSStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSStyle> m_result;
    };

    static CSSStyleBuilder<0> create()
    {
        return CSSStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSStyle()
    {
    }

    std::optional<String> m_styleSheetId;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> m_cssProperties;
    std::unique_ptr<protocol::Array<protocol::CSS::ShorthandEntry>> m_shorthandEntries;
    std::optional<String> m_cssText;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
};


class CORE_EXPORT CSSProperty : public ::crdtp::ProtocolObject<CSSProperty> {
public:
    ~CSSProperty() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getValue() { return m_value; }
    void setValue(const String& value) { m_value = value; }

    bool hasImportant() { return !!m_important; }
    bool getImportant(bool defaultValue) const {
       return m_important.value_or(defaultValue);
    }
    const std::optional<bool>& getImportant() const {
       return m_important;
    }
    void setImportant(bool value) { m_important = value; }

    bool hasImplicit() { return !!m_implicit; }
    bool getImplicit(bool defaultValue) const {
       return m_implicit.value_or(defaultValue);
    }
    const std::optional<bool>& getImplicit() const {
       return m_implicit;
    }
    void setImplicit(bool value) { m_implicit = value; }

    bool hasText() { return !!m_text; }
    String getText(const String& defaultValue) const {
       return m_text.value_or(defaultValue);
    }
    const std::optional<String>& getText() const {
       return m_text;
    }
    void setText(const String& value) { m_text = value; }

    bool hasParsedOk() { return !!m_parsedOk; }
    bool getParsedOk(bool defaultValue) const {
       return m_parsedOk.value_or(defaultValue);
    }
    const std::optional<bool>& getParsedOk() const {
       return m_parsedOk;
    }
    void setParsedOk(bool value) { m_parsedOk = value; }

    bool hasDisabled() { return !!m_disabled; }
    bool getDisabled(bool defaultValue) const {
       return m_disabled.value_or(defaultValue);
    }
    const std::optional<bool>& getDisabled() const {
       return m_disabled;
    }
    void setDisabled(bool value) { m_disabled = value; }

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    bool hasLonghandProperties() { return !!m_longhandProperties; }
    protocol::Array<protocol::CSS::CSSProperty>* getLonghandProperties(protocol::Array<protocol::CSS::CSSProperty>* defaultValue) {
       return m_longhandProperties ? m_longhandProperties.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>>& getLonghandProperties() const {
       return m_longhandProperties;
    }
    void setLonghandProperties(std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> value) { m_longhandProperties = std::move(value); }

    template<int STATE>
    class CSSPropertyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        CSSPropertyBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        CSSPropertyBuilder<STATE | ValueSet>& setValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(value);
            return castState<ValueSet>();
        }

        CSSPropertyBuilder<STATE>& setImportant(bool value)
        {
            m_result->setImportant(value);
            return *this;
        }

        CSSPropertyBuilder<STATE>& setImplicit(bool value)
        {
            m_result->setImplicit(value);
            return *this;
        }

        CSSPropertyBuilder<STATE>& setText(const String& value)
        {
            m_result->setText(value);
            return *this;
        }

        CSSPropertyBuilder<STATE>& setParsedOk(bool value)
        {
            m_result->setParsedOk(value);
            return *this;
        }

        CSSPropertyBuilder<STATE>& setDisabled(bool value)
        {
            m_result->setDisabled(value);
            return *this;
        }

        CSSPropertyBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setRange(std::move(value));
            return *this;
        }

        CSSPropertyBuilder<STATE>& setLonghandProperties(std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> value)
        {
            m_result->setLonghandProperties(std::move(value));
            return *this;
        }

        std::unique_ptr<CSSProperty> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSProperty;
        CSSPropertyBuilder() : m_result(new CSSProperty()) { }

        template<int STEP> CSSPropertyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSPropertyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSProperty> m_result;
    };

    static CSSPropertyBuilder<0> create()
    {
        return CSSPropertyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSProperty()
    {
    }

    String m_name;
    String m_value;
    std::optional<bool> m_important;
    std::optional<bool> m_implicit;
    std::optional<String> m_text;
    std::optional<bool> m_parsedOk;
    std::optional<bool> m_disabled;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>> m_longhandProperties;
};


class CORE_EXPORT CSSMedia : public ::crdtp::ProtocolObject<CSSMedia> {
public:
    ~CSSMedia() override { }

    String getText() { return m_text; }
    void setText(const String& value) { m_text = value; }

    struct CORE_EXPORT SourceEnum {
        static const char* MediaRule;
        static const char* ImportRule;
        static const char* LinkedSheet;
        static const char* InlineSheet;
    }; // SourceEnum

    String getSource() { return m_source; }
    void setSource(const String& value) { m_source = value; }

    bool hasSourceURL() { return !!m_sourceURL; }
    String getSourceURL(const String& defaultValue) const {
       return m_sourceURL.value_or(defaultValue);
    }
    const std::optional<String>& getSourceURL() const {
       return m_sourceURL;
    }
    void setSourceURL(const String& value) { m_sourceURL = value; }

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    bool hasMediaList() { return !!m_mediaList; }
    protocol::Array<protocol::CSS::MediaQuery>* getMediaList(protocol::Array<protocol::CSS::MediaQuery>* defaultValue) {
       return m_mediaList ? m_mediaList.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::MediaQuery>>& getMediaList() const {
       return m_mediaList;
    }
    void setMediaList(std::unique_ptr<protocol::Array<protocol::CSS::MediaQuery>> value) { m_mediaList = std::move(value); }

    template<int STATE>
    class CSSMediaBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TextSet = 1 << 1,
            SourceSet = 1 << 2,
            AllFieldsSet = (TextSet | SourceSet | 0)};


        CSSMediaBuilder<STATE | TextSet>& setText(const String& value)
        {
            static_assert(!(STATE & TextSet), "property text should not be set yet");
            m_result->setText(value);
            return castState<TextSet>();
        }

        CSSMediaBuilder<STATE | SourceSet>& setSource(const String& value)
        {
            static_assert(!(STATE & SourceSet), "property source should not be set yet");
            m_result->setSource(value);
            return castState<SourceSet>();
        }

        CSSMediaBuilder<STATE>& setSourceURL(const String& value)
        {
            m_result->setSourceURL(value);
            return *this;
        }

        CSSMediaBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setRange(std::move(value));
            return *this;
        }

        CSSMediaBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        CSSMediaBuilder<STATE>& setMediaList(std::unique_ptr<protocol::Array<protocol::CSS::MediaQuery>> value)
        {
            m_result->setMediaList(std::move(value));
            return *this;
        }

        std::unique_ptr<CSSMedia> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSMedia;
        CSSMediaBuilder() : m_result(new CSSMedia()) { }

        template<int STEP> CSSMediaBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSMediaBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSMedia> m_result;
    };

    static CSSMediaBuilder<0> create()
    {
        return CSSMediaBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSMedia()
    {
    }

    String m_text;
    String m_source;
    std::optional<String> m_sourceURL;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    std::optional<String> m_styleSheetId;
    std::unique_ptr<protocol::Array<protocol::CSS::MediaQuery>> m_mediaList;
};


class CORE_EXPORT MediaQuery : public ::crdtp::ProtocolObject<MediaQuery> {
public:
    ~MediaQuery() override { }

    protocol::Array<protocol::CSS::MediaQueryExpression>* getExpressions() { return m_expressions.get(); }
    void setExpressions(std::unique_ptr<protocol::Array<protocol::CSS::MediaQueryExpression>> value) { m_expressions = std::move(value); }

    bool getActive() { return m_active; }
    void setActive(bool value) { m_active = value; }

    template<int STATE>
    class MediaQueryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ExpressionsSet = 1 << 1,
            ActiveSet = 1 << 2,
            AllFieldsSet = (ExpressionsSet | ActiveSet | 0)};


        MediaQueryBuilder<STATE | ExpressionsSet>& setExpressions(std::unique_ptr<protocol::Array<protocol::CSS::MediaQueryExpression>> value)
        {
            static_assert(!(STATE & ExpressionsSet), "property expressions should not be set yet");
            m_result->setExpressions(std::move(value));
            return castState<ExpressionsSet>();
        }

        MediaQueryBuilder<STATE | ActiveSet>& setActive(bool value)
        {
            static_assert(!(STATE & ActiveSet), "property active should not be set yet");
            m_result->setActive(value);
            return castState<ActiveSet>();
        }

        std::unique_ptr<MediaQuery> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MediaQuery;
        MediaQueryBuilder() : m_result(new MediaQuery()) { }

        template<int STEP> MediaQueryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MediaQueryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::MediaQuery> m_result;
    };

    static MediaQueryBuilder<0> create()
    {
        return MediaQueryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MediaQuery()
    {
          m_active = false;
    }

    std::unique_ptr<protocol::Array<protocol::CSS::MediaQueryExpression>> m_expressions;
    bool m_active;
};


class CORE_EXPORT MediaQueryExpression : public ::crdtp::ProtocolObject<MediaQueryExpression> {
public:
    ~MediaQueryExpression() override { }

    double getValue() { return m_value; }
    void setValue(double value) { m_value = value; }

    String getUnit() { return m_unit; }
    void setUnit(const String& value) { m_unit = value; }

    String getFeature() { return m_feature; }
    void setFeature(const String& value) { m_feature = value; }

    bool hasValueRange() { return !!m_valueRange; }
    protocol::CSS::SourceRange* getValueRange(protocol::CSS::SourceRange* defaultValue) {
       return m_valueRange ? m_valueRange.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getValueRange() const {
       return m_valueRange;
    }
    void setValueRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_valueRange = std::move(value); }

    bool hasComputedLength() { return !!m_computedLength; }
    double getComputedLength(double defaultValue) const {
       return m_computedLength.value_or(defaultValue);
    }
    const std::optional<double>& getComputedLength() const {
       return m_computedLength;
    }
    void setComputedLength(double value) { m_computedLength = value; }

    template<int STATE>
    class MediaQueryExpressionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ValueSet = 1 << 1,
            UnitSet = 1 << 2,
            FeatureSet = 1 << 3,
            AllFieldsSet = (ValueSet | UnitSet | FeatureSet | 0)};


        MediaQueryExpressionBuilder<STATE | ValueSet>& setValue(double value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(value);
            return castState<ValueSet>();
        }

        MediaQueryExpressionBuilder<STATE | UnitSet>& setUnit(const String& value)
        {
            static_assert(!(STATE & UnitSet), "property unit should not be set yet");
            m_result->setUnit(value);
            return castState<UnitSet>();
        }

        MediaQueryExpressionBuilder<STATE | FeatureSet>& setFeature(const String& value)
        {
            static_assert(!(STATE & FeatureSet), "property feature should not be set yet");
            m_result->setFeature(value);
            return castState<FeatureSet>();
        }

        MediaQueryExpressionBuilder<STATE>& setValueRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setValueRange(std::move(value));
            return *this;
        }

        MediaQueryExpressionBuilder<STATE>& setComputedLength(double value)
        {
            m_result->setComputedLength(value);
            return *this;
        }

        std::unique_ptr<MediaQueryExpression> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MediaQueryExpression;
        MediaQueryExpressionBuilder() : m_result(new MediaQueryExpression()) { }

        template<int STEP> MediaQueryExpressionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MediaQueryExpressionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::MediaQueryExpression> m_result;
    };

    static MediaQueryExpressionBuilder<0> create()
    {
        return MediaQueryExpressionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MediaQueryExpression()
    {
          m_value = 0;
    }

    double m_value;
    String m_unit;
    String m_feature;
    std::unique_ptr<protocol::CSS::SourceRange> m_valueRange;
    std::optional<double> m_computedLength;
};


class CORE_EXPORT CSSContainerQuery : public ::crdtp::ProtocolObject<CSSContainerQuery> {
public:
    ~CSSContainerQuery() override { }

    String getText() { return m_text; }
    void setText(const String& value) { m_text = value; }

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    bool hasName() { return !!m_name; }
    String getName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& getName() const {
       return m_name;
    }
    void setName(const String& value) { m_name = value; }

    bool hasPhysicalAxes() { return !!m_physicalAxes; }
    String getPhysicalAxes(const String& defaultValue) const {
       return m_physicalAxes.value_or(defaultValue);
    }
    const std::optional<String>& getPhysicalAxes() const {
       return m_physicalAxes;
    }
    void setPhysicalAxes(const String& value) { m_physicalAxes = value; }

    bool hasLogicalAxes() { return !!m_logicalAxes; }
    String getLogicalAxes(const String& defaultValue) const {
       return m_logicalAxes.value_or(defaultValue);
    }
    const std::optional<String>& getLogicalAxes() const {
       return m_logicalAxes;
    }
    void setLogicalAxes(const String& value) { m_logicalAxes = value; }

    bool hasQueriesScrollState() { return !!m_queriesScrollState; }
    bool getQueriesScrollState(bool defaultValue) const {
       return m_queriesScrollState.value_or(defaultValue);
    }
    const std::optional<bool>& getQueriesScrollState() const {
       return m_queriesScrollState;
    }
    void setQueriesScrollState(bool value) { m_queriesScrollState = value; }

    bool hasQueriesAnchored() { return !!m_queriesAnchored; }
    bool getQueriesAnchored(bool defaultValue) const {
       return m_queriesAnchored.value_or(defaultValue);
    }
    const std::optional<bool>& getQueriesAnchored() const {
       return m_queriesAnchored;
    }
    void setQueriesAnchored(bool value) { m_queriesAnchored = value; }

    template<int STATE>
    class CSSContainerQueryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TextSet = 1 << 1,
            AllFieldsSet = (TextSet | 0)};


        CSSContainerQueryBuilder<STATE | TextSet>& setText(const String& value)
        {
            static_assert(!(STATE & TextSet), "property text should not be set yet");
            m_result->setText(value);
            return castState<TextSet>();
        }

        CSSContainerQueryBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setRange(std::move(value));
            return *this;
        }

        CSSContainerQueryBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        CSSContainerQueryBuilder<STATE>& setName(const String& value)
        {
            m_result->setName(value);
            return *this;
        }

        CSSContainerQueryBuilder<STATE>& setPhysicalAxes(const String& value)
        {
            m_result->setPhysicalAxes(value);
            return *this;
        }

        CSSContainerQueryBuilder<STATE>& setLogicalAxes(const String& value)
        {
            m_result->setLogicalAxes(value);
            return *this;
        }

        CSSContainerQueryBuilder<STATE>& setQueriesScrollState(bool value)
        {
            m_result->setQueriesScrollState(value);
            return *this;
        }

        CSSContainerQueryBuilder<STATE>& setQueriesAnchored(bool value)
        {
            m_result->setQueriesAnchored(value);
            return *this;
        }

        std::unique_ptr<CSSContainerQuery> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSContainerQuery;
        CSSContainerQueryBuilder() : m_result(new CSSContainerQuery()) { }

        template<int STEP> CSSContainerQueryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSContainerQueryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSContainerQuery> m_result;
    };

    static CSSContainerQueryBuilder<0> create()
    {
        return CSSContainerQueryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSContainerQuery()
    {
    }

    String m_text;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    std::optional<String> m_styleSheetId;
    std::optional<String> m_name;
    std::optional<String> m_physicalAxes;
    std::optional<String> m_logicalAxes;
    std::optional<bool> m_queriesScrollState;
    std::optional<bool> m_queriesAnchored;
};


class CORE_EXPORT CSSSupports : public ::crdtp::ProtocolObject<CSSSupports> {
public:
    ~CSSSupports() override { }

    String getText() { return m_text; }
    void setText(const String& value) { m_text = value; }

    bool getActive() { return m_active; }
    void setActive(bool value) { m_active = value; }

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    template<int STATE>
    class CSSSupportsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TextSet = 1 << 1,
            ActiveSet = 1 << 2,
            AllFieldsSet = (TextSet | ActiveSet | 0)};


        CSSSupportsBuilder<STATE | TextSet>& setText(const String& value)
        {
            static_assert(!(STATE & TextSet), "property text should not be set yet");
            m_result->setText(value);
            return castState<TextSet>();
        }

        CSSSupportsBuilder<STATE | ActiveSet>& setActive(bool value)
        {
            static_assert(!(STATE & ActiveSet), "property active should not be set yet");
            m_result->setActive(value);
            return castState<ActiveSet>();
        }

        CSSSupportsBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setRange(std::move(value));
            return *this;
        }

        CSSSupportsBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        std::unique_ptr<CSSSupports> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSSupports;
        CSSSupportsBuilder() : m_result(new CSSSupports()) { }

        template<int STEP> CSSSupportsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSSupportsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSSupports> m_result;
    };

    static CSSSupportsBuilder<0> create()
    {
        return CSSSupportsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSSupports()
    {
          m_active = false;
    }

    String m_text;
    bool m_active;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    std::optional<String> m_styleSheetId;
};


class CORE_EXPORT CSSScope : public ::crdtp::ProtocolObject<CSSScope> {
public:
    ~CSSScope() override { }

    String getText() { return m_text; }
    void setText(const String& value) { m_text = value; }

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    template<int STATE>
    class CSSScopeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TextSet = 1 << 1,
            AllFieldsSet = (TextSet | 0)};


        CSSScopeBuilder<STATE | TextSet>& setText(const String& value)
        {
            static_assert(!(STATE & TextSet), "property text should not be set yet");
            m_result->setText(value);
            return castState<TextSet>();
        }

        CSSScopeBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setRange(std::move(value));
            return *this;
        }

        CSSScopeBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        std::unique_ptr<CSSScope> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSScope;
        CSSScopeBuilder() : m_result(new CSSScope()) { }

        template<int STEP> CSSScopeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSScopeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSScope> m_result;
    };

    static CSSScopeBuilder<0> create()
    {
        return CSSScopeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSScope()
    {
    }

    String m_text;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    std::optional<String> m_styleSheetId;
};


class CORE_EXPORT CSSLayer : public ::crdtp::ProtocolObject<CSSLayer> {
public:
    ~CSSLayer() override { }

    String getText() { return m_text; }
    void setText(const String& value) { m_text = value; }

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    template<int STATE>
    class CSSLayerBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TextSet = 1 << 1,
            AllFieldsSet = (TextSet | 0)};


        CSSLayerBuilder<STATE | TextSet>& setText(const String& value)
        {
            static_assert(!(STATE & TextSet), "property text should not be set yet");
            m_result->setText(value);
            return castState<TextSet>();
        }

        CSSLayerBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setRange(std::move(value));
            return *this;
        }

        CSSLayerBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        std::unique_ptr<CSSLayer> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSLayer;
        CSSLayerBuilder() : m_result(new CSSLayer()) { }

        template<int STEP> CSSLayerBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSLayerBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSLayer> m_result;
    };

    static CSSLayerBuilder<0> create()
    {
        return CSSLayerBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSLayer()
    {
    }

    String m_text;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    std::optional<String> m_styleSheetId;
};


class CORE_EXPORT CSSStartingStyle : public ::crdtp::ProtocolObject<CSSStartingStyle> {
public:
    ~CSSStartingStyle() override { }

    bool hasRange() { return !!m_range; }
    protocol::CSS::SourceRange* getRange(protocol::CSS::SourceRange* defaultValue) {
       return m_range ? m_range.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::SourceRange>& getRange() const {
       return m_range;
    }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    template<int STATE>
    class CSSStartingStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        CSSStartingStyleBuilder<STATE>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            m_result->setRange(std::move(value));
            return *this;
        }

        CSSStartingStyleBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        std::unique_ptr<CSSStartingStyle> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSStartingStyle;
        CSSStartingStyleBuilder() : m_result(new CSSStartingStyle()) { }

        template<int STEP> CSSStartingStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSStartingStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSStartingStyle> m_result;
    };

    static CSSStartingStyleBuilder<0> create()
    {
        return CSSStartingStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSStartingStyle()
    {
    }

    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    std::optional<String> m_styleSheetId;
};


class CORE_EXPORT CSSLayerData : public ::crdtp::ProtocolObject<CSSLayerData> {
public:
    ~CSSLayerData() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    bool hasSubLayers() { return !!m_subLayers; }
    protocol::Array<protocol::CSS::CSSLayerData>* getSubLayers(protocol::Array<protocol::CSS::CSSLayerData>* defaultValue) {
       return m_subLayers ? m_subLayers.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::CSSLayerData>>& getSubLayers() const {
       return m_subLayers;
    }
    void setSubLayers(std::unique_ptr<protocol::Array<protocol::CSS::CSSLayerData>> value) { m_subLayers = std::move(value); }

    double getOrder() { return m_order; }
    void setOrder(double value) { m_order = value; }

    template<int STATE>
    class CSSLayerDataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            OrderSet = 1 << 2,
            AllFieldsSet = (NameSet | OrderSet | 0)};


        CSSLayerDataBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        CSSLayerDataBuilder<STATE>& setSubLayers(std::unique_ptr<protocol::Array<protocol::CSS::CSSLayerData>> value)
        {
            m_result->setSubLayers(std::move(value));
            return *this;
        }

        CSSLayerDataBuilder<STATE | OrderSet>& setOrder(double value)
        {
            static_assert(!(STATE & OrderSet), "property order should not be set yet");
            m_result->setOrder(value);
            return castState<OrderSet>();
        }

        std::unique_ptr<CSSLayerData> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSLayerData;
        CSSLayerDataBuilder() : m_result(new CSSLayerData()) { }

        template<int STEP> CSSLayerDataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSLayerDataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSLayerData> m_result;
    };

    static CSSLayerDataBuilder<0> create()
    {
        return CSSLayerDataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSLayerData()
    {
          m_order = 0;
    }

    String m_name;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSLayerData>> m_subLayers;
    double m_order;
};


class CORE_EXPORT PlatformFontUsage : public ::crdtp::ProtocolObject<PlatformFontUsage> {
public:
    ~PlatformFontUsage() override { }

    String getFamilyName() { return m_familyName; }
    void setFamilyName(const String& value) { m_familyName = value; }

    String getPostScriptName() { return m_postScriptName; }
    void setPostScriptName(const String& value) { m_postScriptName = value; }

    bool getIsCustomFont() { return m_isCustomFont; }
    void setIsCustomFont(bool value) { m_isCustomFont = value; }

    double getGlyphCount() { return m_glyphCount; }
    void setGlyphCount(double value) { m_glyphCount = value; }

    template<int STATE>
    class PlatformFontUsageBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FamilyNameSet = 1 << 1,
            PostScriptNameSet = 1 << 2,
            IsCustomFontSet = 1 << 3,
            GlyphCountSet = 1 << 4,
            AllFieldsSet = (FamilyNameSet | PostScriptNameSet | IsCustomFontSet | GlyphCountSet | 0)};


        PlatformFontUsageBuilder<STATE | FamilyNameSet>& setFamilyName(const String& value)
        {
            static_assert(!(STATE & FamilyNameSet), "property familyName should not be set yet");
            m_result->setFamilyName(value);
            return castState<FamilyNameSet>();
        }

        PlatformFontUsageBuilder<STATE | PostScriptNameSet>& setPostScriptName(const String& value)
        {
            static_assert(!(STATE & PostScriptNameSet), "property postScriptName should not be set yet");
            m_result->setPostScriptName(value);
            return castState<PostScriptNameSet>();
        }

        PlatformFontUsageBuilder<STATE | IsCustomFontSet>& setIsCustomFont(bool value)
        {
            static_assert(!(STATE & IsCustomFontSet), "property isCustomFont should not be set yet");
            m_result->setIsCustomFont(value);
            return castState<IsCustomFontSet>();
        }

        PlatformFontUsageBuilder<STATE | GlyphCountSet>& setGlyphCount(double value)
        {
            static_assert(!(STATE & GlyphCountSet), "property glyphCount should not be set yet");
            m_result->setGlyphCount(value);
            return castState<GlyphCountSet>();
        }

        std::unique_ptr<PlatformFontUsage> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PlatformFontUsage;
        PlatformFontUsageBuilder() : m_result(new PlatformFontUsage()) { }

        template<int STEP> PlatformFontUsageBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PlatformFontUsageBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::PlatformFontUsage> m_result;
    };

    static PlatformFontUsageBuilder<0> create()
    {
        return PlatformFontUsageBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PlatformFontUsage()
    {
          m_isCustomFont = false;
          m_glyphCount = 0;
    }

    String m_familyName;
    String m_postScriptName;
    bool m_isCustomFont;
    double m_glyphCount;
};


class CORE_EXPORT FontVariationAxis : public ::crdtp::ProtocolObject<FontVariationAxis> {
public:
    ~FontVariationAxis() override { }

    String getTag() { return m_tag; }
    void setTag(const String& value) { m_tag = value; }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    double getMinValue() { return m_minValue; }
    void setMinValue(double value) { m_minValue = value; }

    double getMaxValue() { return m_maxValue; }
    void setMaxValue(double value) { m_maxValue = value; }

    double getDefaultValue() { return m_defaultValue; }
    void setDefaultValue(double value) { m_defaultValue = value; }

    template<int STATE>
    class FontVariationAxisBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TagSet = 1 << 1,
            NameSet = 1 << 2,
            MinValueSet = 1 << 3,
            MaxValueSet = 1 << 4,
            DefaultValueSet = 1 << 5,
            AllFieldsSet = (TagSet | NameSet | MinValueSet | MaxValueSet | DefaultValueSet | 0)};


        FontVariationAxisBuilder<STATE | TagSet>& setTag(const String& value)
        {
            static_assert(!(STATE & TagSet), "property tag should not be set yet");
            m_result->setTag(value);
            return castState<TagSet>();
        }

        FontVariationAxisBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        FontVariationAxisBuilder<STATE | MinValueSet>& setMinValue(double value)
        {
            static_assert(!(STATE & MinValueSet), "property minValue should not be set yet");
            m_result->setMinValue(value);
            return castState<MinValueSet>();
        }

        FontVariationAxisBuilder<STATE | MaxValueSet>& setMaxValue(double value)
        {
            static_assert(!(STATE & MaxValueSet), "property maxValue should not be set yet");
            m_result->setMaxValue(value);
            return castState<MaxValueSet>();
        }

        FontVariationAxisBuilder<STATE | DefaultValueSet>& setDefaultValue(double value)
        {
            static_assert(!(STATE & DefaultValueSet), "property defaultValue should not be set yet");
            m_result->setDefaultValue(value);
            return castState<DefaultValueSet>();
        }

        std::unique_ptr<FontVariationAxis> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FontVariationAxis;
        FontVariationAxisBuilder() : m_result(new FontVariationAxis()) { }

        template<int STEP> FontVariationAxisBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FontVariationAxisBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::FontVariationAxis> m_result;
    };

    static FontVariationAxisBuilder<0> create()
    {
        return FontVariationAxisBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FontVariationAxis()
    {
          m_minValue = 0;
          m_maxValue = 0;
          m_defaultValue = 0;
    }

    String m_tag;
    String m_name;
    double m_minValue;
    double m_maxValue;
    double m_defaultValue;
};


class CORE_EXPORT FontFace : public ::crdtp::ProtocolObject<FontFace> {
public:
    ~FontFace() override { }

    String getFontFamily() { return m_fontFamily; }
    void setFontFamily(const String& value) { m_fontFamily = value; }

    String getFontStyle() { return m_fontStyle; }
    void setFontStyle(const String& value) { m_fontStyle = value; }

    String getFontVariant() { return m_fontVariant; }
    void setFontVariant(const String& value) { m_fontVariant = value; }

    String getFontWeight() { return m_fontWeight; }
    void setFontWeight(const String& value) { m_fontWeight = value; }

    String getFontStretch() { return m_fontStretch; }
    void setFontStretch(const String& value) { m_fontStretch = value; }

    String getFontDisplay() { return m_fontDisplay; }
    void setFontDisplay(const String& value) { m_fontDisplay = value; }

    String getUnicodeRange() { return m_unicodeRange; }
    void setUnicodeRange(const String& value) { m_unicodeRange = value; }

    String getSrc() { return m_src; }
    void setSrc(const String& value) { m_src = value; }

    String getPlatformFontFamily() { return m_platformFontFamily; }
    void setPlatformFontFamily(const String& value) { m_platformFontFamily = value; }

    bool hasFontVariationAxes() { return !!m_fontVariationAxes; }
    protocol::Array<protocol::CSS::FontVariationAxis>* getFontVariationAxes(protocol::Array<protocol::CSS::FontVariationAxis>* defaultValue) {
       return m_fontVariationAxes ? m_fontVariationAxes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::CSS::FontVariationAxis>>& getFontVariationAxes() const {
       return m_fontVariationAxes;
    }
    void setFontVariationAxes(std::unique_ptr<protocol::Array<protocol::CSS::FontVariationAxis>> value) { m_fontVariationAxes = std::move(value); }

    template<int STATE>
    class FontFaceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FontFamilySet = 1 << 1,
            FontStyleSet = 1 << 2,
            FontVariantSet = 1 << 3,
            FontWeightSet = 1 << 4,
            FontStretchSet = 1 << 5,
            FontDisplaySet = 1 << 6,
            UnicodeRangeSet = 1 << 7,
            SrcSet = 1 << 8,
            PlatformFontFamilySet = 1 << 9,
            AllFieldsSet = (FontFamilySet | FontStyleSet | FontVariantSet | FontWeightSet | FontStretchSet | FontDisplaySet | UnicodeRangeSet | SrcSet | PlatformFontFamilySet | 0)};


        FontFaceBuilder<STATE | FontFamilySet>& setFontFamily(const String& value)
        {
            static_assert(!(STATE & FontFamilySet), "property fontFamily should not be set yet");
            m_result->setFontFamily(value);
            return castState<FontFamilySet>();
        }

        FontFaceBuilder<STATE | FontStyleSet>& setFontStyle(const String& value)
        {
            static_assert(!(STATE & FontStyleSet), "property fontStyle should not be set yet");
            m_result->setFontStyle(value);
            return castState<FontStyleSet>();
        }

        FontFaceBuilder<STATE | FontVariantSet>& setFontVariant(const String& value)
        {
            static_assert(!(STATE & FontVariantSet), "property fontVariant should not be set yet");
            m_result->setFontVariant(value);
            return castState<FontVariantSet>();
        }

        FontFaceBuilder<STATE | FontWeightSet>& setFontWeight(const String& value)
        {
            static_assert(!(STATE & FontWeightSet), "property fontWeight should not be set yet");
            m_result->setFontWeight(value);
            return castState<FontWeightSet>();
        }

        FontFaceBuilder<STATE | FontStretchSet>& setFontStretch(const String& value)
        {
            static_assert(!(STATE & FontStretchSet), "property fontStretch should not be set yet");
            m_result->setFontStretch(value);
            return castState<FontStretchSet>();
        }

        FontFaceBuilder<STATE | FontDisplaySet>& setFontDisplay(const String& value)
        {
            static_assert(!(STATE & FontDisplaySet), "property fontDisplay should not be set yet");
            m_result->setFontDisplay(value);
            return castState<FontDisplaySet>();
        }

        FontFaceBuilder<STATE | UnicodeRangeSet>& setUnicodeRange(const String& value)
        {
            static_assert(!(STATE & UnicodeRangeSet), "property unicodeRange should not be set yet");
            m_result->setUnicodeRange(value);
            return castState<UnicodeRangeSet>();
        }

        FontFaceBuilder<STATE | SrcSet>& setSrc(const String& value)
        {
            static_assert(!(STATE & SrcSet), "property src should not be set yet");
            m_result->setSrc(value);
            return castState<SrcSet>();
        }

        FontFaceBuilder<STATE | PlatformFontFamilySet>& setPlatformFontFamily(const String& value)
        {
            static_assert(!(STATE & PlatformFontFamilySet), "property platformFontFamily should not be set yet");
            m_result->setPlatformFontFamily(value);
            return castState<PlatformFontFamilySet>();
        }

        FontFaceBuilder<STATE>& setFontVariationAxes(std::unique_ptr<protocol::Array<protocol::CSS::FontVariationAxis>> value)
        {
            m_result->setFontVariationAxes(std::move(value));
            return *this;
        }

        std::unique_ptr<FontFace> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FontFace;
        FontFaceBuilder() : m_result(new FontFace()) { }

        template<int STEP> FontFaceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FontFaceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::FontFace> m_result;
    };

    static FontFaceBuilder<0> create()
    {
        return FontFaceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FontFace()
    {
    }

    String m_fontFamily;
    String m_fontStyle;
    String m_fontVariant;
    String m_fontWeight;
    String m_fontStretch;
    String m_fontDisplay;
    String m_unicodeRange;
    String m_src;
    String m_platformFontFamily;
    std::unique_ptr<protocol::Array<protocol::CSS::FontVariationAxis>> m_fontVariationAxes;
};


class CORE_EXPORT CSSPositionTryRule : public ::crdtp::ProtocolObject<CSSPositionTryRule> {
public:
    ~CSSPositionTryRule() override { }

    protocol::CSS::Value* getName() { return m_name.get(); }
    void setName(std::unique_ptr<protocol::CSS::Value> value) { m_name = std::move(value); }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value) { m_origin = value; }

    protocol::CSS::CSSStyle* getStyle() { return m_style.get(); }
    void setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_style = std::move(value); }

    bool getActive() { return m_active; }
    void setActive(bool value) { m_active = value; }

    template<int STATE>
    class CSSPositionTryRuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            OriginSet = 1 << 2,
            StyleSet = 1 << 3,
            ActiveSet = 1 << 4,
            AllFieldsSet = (NameSet | OriginSet | StyleSet | ActiveSet | 0)};


        CSSPositionTryRuleBuilder<STATE | NameSet>& setName(std::unique_ptr<protocol::CSS::Value> value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(std::move(value));
            return castState<NameSet>();
        }

        CSSPositionTryRuleBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        CSSPositionTryRuleBuilder<STATE | OriginSet>& setOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->setOrigin(value);
            return castState<OriginSet>();
        }

        CSSPositionTryRuleBuilder<STATE | StyleSet>& setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value)
        {
            static_assert(!(STATE & StyleSet), "property style should not be set yet");
            m_result->setStyle(std::move(value));
            return castState<StyleSet>();
        }

        CSSPositionTryRuleBuilder<STATE | ActiveSet>& setActive(bool value)
        {
            static_assert(!(STATE & ActiveSet), "property active should not be set yet");
            m_result->setActive(value);
            return castState<ActiveSet>();
        }

        std::unique_ptr<CSSPositionTryRule> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSPositionTryRule;
        CSSPositionTryRuleBuilder() : m_result(new CSSPositionTryRule()) { }

        template<int STEP> CSSPositionTryRuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSPositionTryRuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSPositionTryRule> m_result;
    };

    static CSSPositionTryRuleBuilder<0> create()
    {
        return CSSPositionTryRuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSPositionTryRule()
    {
          m_active = false;
    }

    std::unique_ptr<protocol::CSS::Value> m_name;
    std::optional<String> m_styleSheetId;
    String m_origin;
    std::unique_ptr<protocol::CSS::CSSStyle> m_style;
    bool m_active;
};


class CORE_EXPORT CSSKeyframesRule : public ::crdtp::ProtocolObject<CSSKeyframesRule> {
public:
    ~CSSKeyframesRule() override { }

    protocol::CSS::Value* getAnimationName() { return m_animationName.get(); }
    void setAnimationName(std::unique_ptr<protocol::CSS::Value> value) { m_animationName = std::move(value); }

    protocol::Array<protocol::CSS::CSSKeyframeRule>* getKeyframes() { return m_keyframes.get(); }
    void setKeyframes(std::unique_ptr<protocol::Array<protocol::CSS::CSSKeyframeRule>> value) { m_keyframes = std::move(value); }

    template<int STATE>
    class CSSKeyframesRuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AnimationNameSet = 1 << 1,
            KeyframesSet = 1 << 2,
            AllFieldsSet = (AnimationNameSet | KeyframesSet | 0)};


        CSSKeyframesRuleBuilder<STATE | AnimationNameSet>& setAnimationName(std::unique_ptr<protocol::CSS::Value> value)
        {
            static_assert(!(STATE & AnimationNameSet), "property animationName should not be set yet");
            m_result->setAnimationName(std::move(value));
            return castState<AnimationNameSet>();
        }

        CSSKeyframesRuleBuilder<STATE | KeyframesSet>& setKeyframes(std::unique_ptr<protocol::Array<protocol::CSS::CSSKeyframeRule>> value)
        {
            static_assert(!(STATE & KeyframesSet), "property keyframes should not be set yet");
            m_result->setKeyframes(std::move(value));
            return castState<KeyframesSet>();
        }

        std::unique_ptr<CSSKeyframesRule> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSKeyframesRule;
        CSSKeyframesRuleBuilder() : m_result(new CSSKeyframesRule()) { }

        template<int STEP> CSSKeyframesRuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSKeyframesRuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSKeyframesRule> m_result;
    };

    static CSSKeyframesRuleBuilder<0> create()
    {
        return CSSKeyframesRuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSKeyframesRule()
    {
    }

    std::unique_ptr<protocol::CSS::Value> m_animationName;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSKeyframeRule>> m_keyframes;
};


class CORE_EXPORT CSSPropertyRegistration : public ::crdtp::ProtocolObject<CSSPropertyRegistration> {
public:
    ~CSSPropertyRegistration() override { }

    String getPropertyName() { return m_propertyName; }
    void setPropertyName(const String& value) { m_propertyName = value; }

    bool hasInitialValue() { return !!m_initialValue; }
    protocol::CSS::Value* getInitialValue(protocol::CSS::Value* defaultValue) {
       return m_initialValue ? m_initialValue.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::Value>& getInitialValue() const {
       return m_initialValue;
    }
    void setInitialValue(std::unique_ptr<protocol::CSS::Value> value) { m_initialValue = std::move(value); }

    bool getInherits() { return m_inherits; }
    void setInherits(bool value) { m_inherits = value; }

    String getSyntax() { return m_syntax; }
    void setSyntax(const String& value) { m_syntax = value; }

    template<int STATE>
    class CSSPropertyRegistrationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PropertyNameSet = 1 << 1,
            InheritsSet = 1 << 2,
            SyntaxSet = 1 << 3,
            AllFieldsSet = (PropertyNameSet | InheritsSet | SyntaxSet | 0)};


        CSSPropertyRegistrationBuilder<STATE | PropertyNameSet>& setPropertyName(const String& value)
        {
            static_assert(!(STATE & PropertyNameSet), "property propertyName should not be set yet");
            m_result->setPropertyName(value);
            return castState<PropertyNameSet>();
        }

        CSSPropertyRegistrationBuilder<STATE>& setInitialValue(std::unique_ptr<protocol::CSS::Value> value)
        {
            m_result->setInitialValue(std::move(value));
            return *this;
        }

        CSSPropertyRegistrationBuilder<STATE | InheritsSet>& setInherits(bool value)
        {
            static_assert(!(STATE & InheritsSet), "property inherits should not be set yet");
            m_result->setInherits(value);
            return castState<InheritsSet>();
        }

        CSSPropertyRegistrationBuilder<STATE | SyntaxSet>& setSyntax(const String& value)
        {
            static_assert(!(STATE & SyntaxSet), "property syntax should not be set yet");
            m_result->setSyntax(value);
            return castState<SyntaxSet>();
        }

        std::unique_ptr<CSSPropertyRegistration> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSPropertyRegistration;
        CSSPropertyRegistrationBuilder() : m_result(new CSSPropertyRegistration()) { }

        template<int STEP> CSSPropertyRegistrationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSPropertyRegistrationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSPropertyRegistration> m_result;
    };

    static CSSPropertyRegistrationBuilder<0> create()
    {
        return CSSPropertyRegistrationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSPropertyRegistration()
    {
          m_inherits = false;
    }

    String m_propertyName;
    std::unique_ptr<protocol::CSS::Value> m_initialValue;
    bool m_inherits;
    String m_syntax;
};


class CORE_EXPORT CSSFontPaletteValuesRule : public ::crdtp::ProtocolObject<CSSFontPaletteValuesRule> {
public:
    ~CSSFontPaletteValuesRule() override { }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value) { m_origin = value; }

    protocol::CSS::Value* getFontPaletteName() { return m_fontPaletteName.get(); }
    void setFontPaletteName(std::unique_ptr<protocol::CSS::Value> value) { m_fontPaletteName = std::move(value); }

    protocol::CSS::CSSStyle* getStyle() { return m_style.get(); }
    void setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_style = std::move(value); }

    template<int STATE>
    class CSSFontPaletteValuesRuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OriginSet = 1 << 1,
            FontPaletteNameSet = 1 << 2,
            StyleSet = 1 << 3,
            AllFieldsSet = (OriginSet | FontPaletteNameSet | StyleSet | 0)};


        CSSFontPaletteValuesRuleBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        CSSFontPaletteValuesRuleBuilder<STATE | OriginSet>& setOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->setOrigin(value);
            return castState<OriginSet>();
        }

        CSSFontPaletteValuesRuleBuilder<STATE | FontPaletteNameSet>& setFontPaletteName(std::unique_ptr<protocol::CSS::Value> value)
        {
            static_assert(!(STATE & FontPaletteNameSet), "property fontPaletteName should not be set yet");
            m_result->setFontPaletteName(std::move(value));
            return castState<FontPaletteNameSet>();
        }

        CSSFontPaletteValuesRuleBuilder<STATE | StyleSet>& setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value)
        {
            static_assert(!(STATE & StyleSet), "property style should not be set yet");
            m_result->setStyle(std::move(value));
            return castState<StyleSet>();
        }

        std::unique_ptr<CSSFontPaletteValuesRule> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSFontPaletteValuesRule;
        CSSFontPaletteValuesRuleBuilder() : m_result(new CSSFontPaletteValuesRule()) { }

        template<int STEP> CSSFontPaletteValuesRuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSFontPaletteValuesRuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSFontPaletteValuesRule> m_result;
    };

    static CSSFontPaletteValuesRuleBuilder<0> create()
    {
        return CSSFontPaletteValuesRuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSFontPaletteValuesRule()
    {
    }

    std::optional<String> m_styleSheetId;
    String m_origin;
    std::unique_ptr<protocol::CSS::Value> m_fontPaletteName;
    std::unique_ptr<protocol::CSS::CSSStyle> m_style;
};


class CORE_EXPORT CSSPropertyRule : public ::crdtp::ProtocolObject<CSSPropertyRule> {
public:
    ~CSSPropertyRule() override { }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value) { m_origin = value; }

    protocol::CSS::Value* getPropertyName() { return m_propertyName.get(); }
    void setPropertyName(std::unique_ptr<protocol::CSS::Value> value) { m_propertyName = std::move(value); }

    protocol::CSS::CSSStyle* getStyle() { return m_style.get(); }
    void setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_style = std::move(value); }

    template<int STATE>
    class CSSPropertyRuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OriginSet = 1 << 1,
            PropertyNameSet = 1 << 2,
            StyleSet = 1 << 3,
            AllFieldsSet = (OriginSet | PropertyNameSet | StyleSet | 0)};


        CSSPropertyRuleBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        CSSPropertyRuleBuilder<STATE | OriginSet>& setOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->setOrigin(value);
            return castState<OriginSet>();
        }

        CSSPropertyRuleBuilder<STATE | PropertyNameSet>& setPropertyName(std::unique_ptr<protocol::CSS::Value> value)
        {
            static_assert(!(STATE & PropertyNameSet), "property propertyName should not be set yet");
            m_result->setPropertyName(std::move(value));
            return castState<PropertyNameSet>();
        }

        CSSPropertyRuleBuilder<STATE | StyleSet>& setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value)
        {
            static_assert(!(STATE & StyleSet), "property style should not be set yet");
            m_result->setStyle(std::move(value));
            return castState<StyleSet>();
        }

        std::unique_ptr<CSSPropertyRule> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSPropertyRule;
        CSSPropertyRuleBuilder() : m_result(new CSSPropertyRule()) { }

        template<int STEP> CSSPropertyRuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSPropertyRuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSPropertyRule> m_result;
    };

    static CSSPropertyRuleBuilder<0> create()
    {
        return CSSPropertyRuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSPropertyRule()
    {
    }

    std::optional<String> m_styleSheetId;
    String m_origin;
    std::unique_ptr<protocol::CSS::Value> m_propertyName;
    std::unique_ptr<protocol::CSS::CSSStyle> m_style;
};


class CORE_EXPORT CSSFunctionParameter : public ::crdtp::ProtocolObject<CSSFunctionParameter> {
public:
    ~CSSFunctionParameter() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    template<int STATE>
    class CSSFunctionParameterBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            TypeSet = 1 << 2,
            AllFieldsSet = (NameSet | TypeSet | 0)};


        CSSFunctionParameterBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        CSSFunctionParameterBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        std::unique_ptr<CSSFunctionParameter> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSFunctionParameter;
        CSSFunctionParameterBuilder() : m_result(new CSSFunctionParameter()) { }

        template<int STEP> CSSFunctionParameterBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSFunctionParameterBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSFunctionParameter> m_result;
    };

    static CSSFunctionParameterBuilder<0> create()
    {
        return CSSFunctionParameterBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSFunctionParameter()
    {
    }

    String m_name;
    String m_type;
};


class CORE_EXPORT CSSFunctionConditionNode : public ::crdtp::ProtocolObject<CSSFunctionConditionNode> {
public:
    ~CSSFunctionConditionNode() override { }

    bool hasMedia() { return !!m_media; }
    protocol::CSS::CSSMedia* getMedia(protocol::CSS::CSSMedia* defaultValue) {
       return m_media ? m_media.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::CSSMedia>& getMedia() const {
       return m_media;
    }
    void setMedia(std::unique_ptr<protocol::CSS::CSSMedia> value) { m_media = std::move(value); }

    bool hasContainerQueries() { return !!m_containerQueries; }
    protocol::CSS::CSSContainerQuery* getContainerQueries(protocol::CSS::CSSContainerQuery* defaultValue) {
       return m_containerQueries ? m_containerQueries.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::CSSContainerQuery>& getContainerQueries() const {
       return m_containerQueries;
    }
    void setContainerQueries(std::unique_ptr<protocol::CSS::CSSContainerQuery> value) { m_containerQueries = std::move(value); }

    bool hasSupports() { return !!m_supports; }
    protocol::CSS::CSSSupports* getSupports(protocol::CSS::CSSSupports* defaultValue) {
       return m_supports ? m_supports.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::CSSSupports>& getSupports() const {
       return m_supports;
    }
    void setSupports(std::unique_ptr<protocol::CSS::CSSSupports> value) { m_supports = std::move(value); }

    protocol::Array<protocol::CSS::CSSFunctionNode>* getChildren() { return m_children.get(); }
    void setChildren(std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionNode>> value) { m_children = std::move(value); }

    String getConditionText() { return m_conditionText; }
    void setConditionText(const String& value) { m_conditionText = value; }

    template<int STATE>
    class CSSFunctionConditionNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ChildrenSet = 1 << 1,
            ConditionTextSet = 1 << 2,
            AllFieldsSet = (ChildrenSet | ConditionTextSet | 0)};


        CSSFunctionConditionNodeBuilder<STATE>& setMedia(std::unique_ptr<protocol::CSS::CSSMedia> value)
        {
            m_result->setMedia(std::move(value));
            return *this;
        }

        CSSFunctionConditionNodeBuilder<STATE>& setContainerQueries(std::unique_ptr<protocol::CSS::CSSContainerQuery> value)
        {
            m_result->setContainerQueries(std::move(value));
            return *this;
        }

        CSSFunctionConditionNodeBuilder<STATE>& setSupports(std::unique_ptr<protocol::CSS::CSSSupports> value)
        {
            m_result->setSupports(std::move(value));
            return *this;
        }

        CSSFunctionConditionNodeBuilder<STATE | ChildrenSet>& setChildren(std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionNode>> value)
        {
            static_assert(!(STATE & ChildrenSet), "property children should not be set yet");
            m_result->setChildren(std::move(value));
            return castState<ChildrenSet>();
        }

        CSSFunctionConditionNodeBuilder<STATE | ConditionTextSet>& setConditionText(const String& value)
        {
            static_assert(!(STATE & ConditionTextSet), "property conditionText should not be set yet");
            m_result->setConditionText(value);
            return castState<ConditionTextSet>();
        }

        std::unique_ptr<CSSFunctionConditionNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSFunctionConditionNode;
        CSSFunctionConditionNodeBuilder() : m_result(new CSSFunctionConditionNode()) { }

        template<int STEP> CSSFunctionConditionNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSFunctionConditionNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSFunctionConditionNode> m_result;
    };

    static CSSFunctionConditionNodeBuilder<0> create()
    {
        return CSSFunctionConditionNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSFunctionConditionNode()
    {
    }

    std::unique_ptr<protocol::CSS::CSSMedia> m_media;
    std::unique_ptr<protocol::CSS::CSSContainerQuery> m_containerQueries;
    std::unique_ptr<protocol::CSS::CSSSupports> m_supports;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionNode>> m_children;
    String m_conditionText;
};


class CORE_EXPORT CSSFunctionNode : public ::crdtp::ProtocolObject<CSSFunctionNode> {
public:
    ~CSSFunctionNode() override { }

    bool hasCondition() { return !!m_condition; }
    protocol::CSS::CSSFunctionConditionNode* getCondition(protocol::CSS::CSSFunctionConditionNode* defaultValue) {
       return m_condition ? m_condition.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::CSSFunctionConditionNode>& getCondition() const {
       return m_condition;
    }
    void setCondition(std::unique_ptr<protocol::CSS::CSSFunctionConditionNode> value) { m_condition = std::move(value); }

    bool hasStyle() { return !!m_style; }
    protocol::CSS::CSSStyle* getStyle(protocol::CSS::CSSStyle* defaultValue) {
       return m_style ? m_style.get() : defaultValue;
    }
    const std::unique_ptr<protocol::CSS::CSSStyle>& getStyle() const {
       return m_style;
    }
    void setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_style = std::move(value); }

    template<int STATE>
    class CSSFunctionNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        CSSFunctionNodeBuilder<STATE>& setCondition(std::unique_ptr<protocol::CSS::CSSFunctionConditionNode> value)
        {
            m_result->setCondition(std::move(value));
            return *this;
        }

        CSSFunctionNodeBuilder<STATE>& setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value)
        {
            m_result->setStyle(std::move(value));
            return *this;
        }

        std::unique_ptr<CSSFunctionNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSFunctionNode;
        CSSFunctionNodeBuilder() : m_result(new CSSFunctionNode()) { }

        template<int STEP> CSSFunctionNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSFunctionNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSFunctionNode> m_result;
    };

    static CSSFunctionNodeBuilder<0> create()
    {
        return CSSFunctionNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSFunctionNode()
    {
    }

    std::unique_ptr<protocol::CSS::CSSFunctionConditionNode> m_condition;
    std::unique_ptr<protocol::CSS::CSSStyle> m_style;
};


class CORE_EXPORT CSSFunctionRule : public ::crdtp::ProtocolObject<CSSFunctionRule> {
public:
    ~CSSFunctionRule() override { }

    protocol::CSS::Value* getName() { return m_name.get(); }
    void setName(std::unique_ptr<protocol::CSS::Value> value) { m_name = std::move(value); }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value) { m_origin = value; }

    protocol::Array<protocol::CSS::CSSFunctionParameter>* getParameters() { return m_parameters.get(); }
    void setParameters(std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionParameter>> value) { m_parameters = std::move(value); }

    protocol::Array<protocol::CSS::CSSFunctionNode>* getChildren() { return m_children.get(); }
    void setChildren(std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionNode>> value) { m_children = std::move(value); }

    template<int STATE>
    class CSSFunctionRuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            OriginSet = 1 << 2,
            ParametersSet = 1 << 3,
            ChildrenSet = 1 << 4,
            AllFieldsSet = (NameSet | OriginSet | ParametersSet | ChildrenSet | 0)};


        CSSFunctionRuleBuilder<STATE | NameSet>& setName(std::unique_ptr<protocol::CSS::Value> value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(std::move(value));
            return castState<NameSet>();
        }

        CSSFunctionRuleBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        CSSFunctionRuleBuilder<STATE | OriginSet>& setOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->setOrigin(value);
            return castState<OriginSet>();
        }

        CSSFunctionRuleBuilder<STATE | ParametersSet>& setParameters(std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionParameter>> value)
        {
            static_assert(!(STATE & ParametersSet), "property parameters should not be set yet");
            m_result->setParameters(std::move(value));
            return castState<ParametersSet>();
        }

        CSSFunctionRuleBuilder<STATE | ChildrenSet>& setChildren(std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionNode>> value)
        {
            static_assert(!(STATE & ChildrenSet), "property children should not be set yet");
            m_result->setChildren(std::move(value));
            return castState<ChildrenSet>();
        }

        std::unique_ptr<CSSFunctionRule> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSFunctionRule;
        CSSFunctionRuleBuilder() : m_result(new CSSFunctionRule()) { }

        template<int STEP> CSSFunctionRuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSFunctionRuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSFunctionRule> m_result;
    };

    static CSSFunctionRuleBuilder<0> create()
    {
        return CSSFunctionRuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSFunctionRule()
    {
    }

    std::unique_ptr<protocol::CSS::Value> m_name;
    std::optional<String> m_styleSheetId;
    String m_origin;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionParameter>> m_parameters;
    std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionNode>> m_children;
};


class CORE_EXPORT CSSKeyframeRule : public ::crdtp::ProtocolObject<CSSKeyframeRule> {
public:
    ~CSSKeyframeRule() override { }

    bool hasStyleSheetId() { return !!m_styleSheetId; }
    String getStyleSheetId(const String& defaultValue) const {
       return m_styleSheetId.value_or(defaultValue);
    }
    const std::optional<String>& getStyleSheetId() const {
       return m_styleSheetId;
    }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    String getOrigin() { return m_origin; }
    void setOrigin(const String& value) { m_origin = value; }

    protocol::CSS::Value* getKeyText() { return m_keyText.get(); }
    void setKeyText(std::unique_ptr<protocol::CSS::Value> value) { m_keyText = std::move(value); }

    protocol::CSS::CSSStyle* getStyle() { return m_style.get(); }
    void setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value) { m_style = std::move(value); }

    template<int STATE>
    class CSSKeyframeRuleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OriginSet = 1 << 1,
            KeyTextSet = 1 << 2,
            StyleSet = 1 << 3,
            AllFieldsSet = (OriginSet | KeyTextSet | StyleSet | 0)};


        CSSKeyframeRuleBuilder<STATE>& setStyleSheetId(const String& value)
        {
            m_result->setStyleSheetId(value);
            return *this;
        }

        CSSKeyframeRuleBuilder<STATE | OriginSet>& setOrigin(const String& value)
        {
            static_assert(!(STATE & OriginSet), "property origin should not be set yet");
            m_result->setOrigin(value);
            return castState<OriginSet>();
        }

        CSSKeyframeRuleBuilder<STATE | KeyTextSet>& setKeyText(std::unique_ptr<protocol::CSS::Value> value)
        {
            static_assert(!(STATE & KeyTextSet), "property keyText should not be set yet");
            m_result->setKeyText(std::move(value));
            return castState<KeyTextSet>();
        }

        CSSKeyframeRuleBuilder<STATE | StyleSet>& setStyle(std::unique_ptr<protocol::CSS::CSSStyle> value)
        {
            static_assert(!(STATE & StyleSet), "property style should not be set yet");
            m_result->setStyle(std::move(value));
            return castState<StyleSet>();
        }

        std::unique_ptr<CSSKeyframeRule> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSKeyframeRule;
        CSSKeyframeRuleBuilder() : m_result(new CSSKeyframeRule()) { }

        template<int STEP> CSSKeyframeRuleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSKeyframeRuleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::CSSKeyframeRule> m_result;
    };

    static CSSKeyframeRuleBuilder<0> create()
    {
        return CSSKeyframeRuleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSKeyframeRule()
    {
    }

    std::optional<String> m_styleSheetId;
    String m_origin;
    std::unique_ptr<protocol::CSS::Value> m_keyText;
    std::unique_ptr<protocol::CSS::CSSStyle> m_style;
};


class CORE_EXPORT StyleDeclarationEdit : public ::crdtp::ProtocolObject<StyleDeclarationEdit> {
public:
    ~StyleDeclarationEdit() override { }

    String getStyleSheetId() { return m_styleSheetId; }
    void setStyleSheetId(const String& value) { m_styleSheetId = value; }

    protocol::CSS::SourceRange* getRange() { return m_range.get(); }
    void setRange(std::unique_ptr<protocol::CSS::SourceRange> value) { m_range = std::move(value); }

    String getText() { return m_text; }
    void setText(const String& value) { m_text = value; }

    template<int STATE>
    class StyleDeclarationEditBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StyleSheetIdSet = 1 << 1,
            RangeSet = 1 << 2,
            TextSet = 1 << 3,
            AllFieldsSet = (StyleSheetIdSet | RangeSet | TextSet | 0)};


        StyleDeclarationEditBuilder<STATE | StyleSheetIdSet>& setStyleSheetId(const String& value)
        {
            static_assert(!(STATE & StyleSheetIdSet), "property styleSheetId should not be set yet");
            m_result->setStyleSheetId(value);
            return castState<StyleSheetIdSet>();
        }

        StyleDeclarationEditBuilder<STATE | RangeSet>& setRange(std::unique_ptr<protocol::CSS::SourceRange> value)
        {
            static_assert(!(STATE & RangeSet), "property range should not be set yet");
            m_result->setRange(std::move(value));
            return castState<RangeSet>();
        }

        StyleDeclarationEditBuilder<STATE | TextSet>& setText(const String& value)
        {
            static_assert(!(STATE & TextSet), "property text should not be set yet");
            m_result->setText(value);
            return castState<TextSet>();
        }

        std::unique_ptr<StyleDeclarationEdit> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StyleDeclarationEdit;
        StyleDeclarationEditBuilder() : m_result(new StyleDeclarationEdit()) { }

        template<int STEP> StyleDeclarationEditBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StyleDeclarationEditBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::CSS::StyleDeclarationEdit> m_result;
    };

    static StyleDeclarationEditBuilder<0> create()
    {
        return StyleDeclarationEditBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StyleDeclarationEdit()
    {
    }

    String m_styleSheetId;
    std::unique_ptr<protocol::CSS::SourceRange> m_range;
    String m_text;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse addRule(const String& in_styleSheetId, const String& in_ruleText, std::unique_ptr<protocol::CSS::SourceRange> in_location, std::optional<int> in_nodeForPropertySyntaxValidation, std::unique_ptr<protocol::CSS::CSSRule>* out_rule) = 0;
    virtual DispatchResponse collectClassNames(const String& in_styleSheetId, std::unique_ptr<protocol::Array<String>>* out_classNames) = 0;
    virtual DispatchResponse createStyleSheet(const String& in_frameId, std::optional<bool> in_force, String* out_styleSheetId) = 0;
    virtual DispatchResponse disable() = 0;
    class CORE_EXPORT EnableCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~EnableCallback() { }
    };
    virtual void enable(std::unique_ptr<EnableCallback> callback) = 0;
    virtual DispatchResponse forcePseudoState(int in_nodeId, std::unique_ptr<protocol::Array<String>> in_forcedPseudoClasses) = 0;
    virtual DispatchResponse forceStartingStyle(int in_nodeId, bool in_forced) = 0;
    virtual DispatchResponse getBackgroundColors(int in_nodeId, std::unique_ptr<protocol::Array<String>>* out_backgroundColors, std::optional<String>* out_computedFontSize, std::optional<String>* out_computedFontWeight) = 0;
    virtual DispatchResponse getComputedStyleForNode(int in_nodeId, std::unique_ptr<protocol::Array<protocol::CSS::CSSComputedStyleProperty>>* out_computedStyle, std::unique_ptr<protocol::CSS::ComputedStyleExtraFields>* out_extraFields) = 0;
    virtual DispatchResponse resolveValues(std::unique_ptr<protocol::Array<String>> in_values, int in_nodeId, std::optional<String> in_propertyName, std::optional<String> in_pseudoType, std::optional<String> in_pseudoIdentifier, std::unique_ptr<protocol::Array<String>>* out_results) = 0;
    virtual DispatchResponse getLonghandProperties(const String& in_shorthandName, const String& in_value, std::unique_ptr<protocol::Array<protocol::CSS::CSSProperty>>* out_longhandProperties) = 0;
    virtual DispatchResponse getInlineStylesForNode(int in_nodeId, std::unique_ptr<protocol::CSS::CSSStyle>* out_inlineStyle, std::unique_ptr<protocol::CSS::CSSStyle>* out_attributesStyle) = 0;
    virtual DispatchResponse getAnimatedStylesForNode(int in_nodeId, std::unique_ptr<protocol::Array<protocol::CSS::CSSAnimationStyle>>* out_animationStyles, std::unique_ptr<protocol::CSS::CSSStyle>* out_transitionsStyle, std::unique_ptr<protocol::Array<protocol::CSS::InheritedAnimatedStyleEntry>>* out_inherited) = 0;
    virtual DispatchResponse getMatchedStylesForNode(int in_nodeId, std::unique_ptr<protocol::CSS::CSSStyle>* out_inlineStyle, std::unique_ptr<protocol::CSS::CSSStyle>* out_attributesStyle, std::unique_ptr<protocol::Array<protocol::CSS::RuleMatch>>* out_matchedCSSRules, std::unique_ptr<protocol::Array<protocol::CSS::PseudoElementMatches>>* out_pseudoElements, std::unique_ptr<protocol::Array<protocol::CSS::InheritedStyleEntry>>* out_inherited, std::unique_ptr<protocol::Array<protocol::CSS::InheritedPseudoElementMatches>>* out_inheritedPseudoElements, std::unique_ptr<protocol::Array<protocol::CSS::CSSKeyframesRule>>* out_cssKeyframesRules, std::unique_ptr<protocol::Array<protocol::CSS::CSSPositionTryRule>>* out_cssPositionTryRules, std::optional<int>* out_activePositionFallbackIndex, std::unique_ptr<protocol::Array<protocol::CSS::CSSPropertyRule>>* out_cssPropertyRules, std::unique_ptr<protocol::Array<protocol::CSS::CSSPropertyRegistration>>* out_cssPropertyRegistrations, std::unique_ptr<protocol::CSS::CSSFontPaletteValuesRule>* out_cssFontPaletteValuesRule, std::optional<int>* out_parentLayoutNodeId, std::unique_ptr<protocol::Array<protocol::CSS::CSSFunctionRule>>* out_cssFunctionRules) = 0;
    virtual DispatchResponse getEnvironmentVariables(std::unique_ptr<protocol::DictionaryValue>* out_environmentVariables) = 0;
    virtual DispatchResponse getMediaQueries(std::unique_ptr<protocol::Array<protocol::CSS::CSSMedia>>* out_medias) = 0;
    virtual DispatchResponse getPlatformFontsForNode(int in_nodeId, std::unique_ptr<protocol::Array<protocol::CSS::PlatformFontUsage>>* out_fonts) = 0;
    virtual DispatchResponse getStyleSheetText(const String& in_styleSheetId, String* out_text) = 0;
    virtual DispatchResponse getLayersForNode(int in_nodeId, std::unique_ptr<protocol::CSS::CSSLayerData>* out_rootLayer) = 0;
    virtual DispatchResponse getLocationForSelector(const String& in_styleSheetId, const String& in_selectorText, std::unique_ptr<protocol::Array<protocol::CSS::SourceRange>>* out_ranges) = 0;
    virtual DispatchResponse trackComputedStyleUpdatesForNode(std::optional<int> in_nodeId) = 0;
    virtual DispatchResponse trackComputedStyleUpdates(std::unique_ptr<protocol::Array<protocol::CSS::CSSComputedStyleProperty>> in_propertiesToTrack) = 0;
    class CORE_EXPORT TakeComputedStyleUpdatesCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<int>> nodeIds) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~TakeComputedStyleUpdatesCallback() { }
    };
    virtual void takeComputedStyleUpdates(std::unique_ptr<TakeComputedStyleUpdatesCallback> callback) = 0;
    virtual DispatchResponse setEffectivePropertyValueForNode(int in_nodeId, const String& in_propertyName, const String& in_value) = 0;
    virtual DispatchResponse setPropertyRulePropertyName(const String& in_styleSheetId, std::unique_ptr<protocol::CSS::SourceRange> in_range, const String& in_propertyName, std::unique_ptr<protocol::CSS::Value>* out_propertyName) = 0;
    virtual DispatchResponse setKeyframeKey(const String& in_styleSheetId, std::unique_ptr<protocol::CSS::SourceRange> in_range, const String& in_keyText, std::unique_ptr<protocol::CSS::Value>* out_keyText) = 0;
    virtual DispatchResponse setMediaText(const String& in_styleSheetId, std::unique_ptr<protocol::CSS::SourceRange> in_range, const String& in_text, std::unique_ptr<protocol::CSS::CSSMedia>* out_media) = 0;
    virtual DispatchResponse setContainerQueryText(const String& in_styleSheetId, std::unique_ptr<protocol::CSS::SourceRange> in_range, const String& in_text, std::unique_ptr<protocol::CSS::CSSContainerQuery>* out_containerQuery) = 0;
    virtual DispatchResponse setSupportsText(const String& in_styleSheetId, std::unique_ptr<protocol::CSS::SourceRange> in_range, const String& in_text, std::unique_ptr<protocol::CSS::CSSSupports>* out_supports) = 0;
    virtual DispatchResponse setScopeText(const String& in_styleSheetId, std::unique_ptr<protocol::CSS::SourceRange> in_range, const String& in_text, std::unique_ptr<protocol::CSS::CSSScope>* out_scope) = 0;
    virtual DispatchResponse setRuleSelector(const String& in_styleSheetId, std::unique_ptr<protocol::CSS::SourceRange> in_range, const String& in_selector, std::unique_ptr<protocol::CSS::SelectorList>* out_selectorList) = 0;
    virtual DispatchResponse setStyleSheetText(const String& in_styleSheetId, const String& in_text, std::optional<String>* out_sourceMapURL) = 0;
    virtual DispatchResponse setStyleTexts(std::unique_ptr<protocol::Array<protocol::CSS::StyleDeclarationEdit>> in_edits, std::optional<int> in_nodeForPropertySyntaxValidation, std::unique_ptr<protocol::Array<protocol::CSS::CSSStyle>>* out_styles) = 0;
    virtual DispatchResponse startRuleUsageTracking() = 0;
    virtual DispatchResponse stopRuleUsageTracking(std::unique_ptr<protocol::Array<protocol::CSS::RuleUsage>>* out_ruleUsage) = 0;
    virtual DispatchResponse takeCoverageDelta(std::unique_ptr<protocol::Array<protocol::CSS::RuleUsage>>* out_coverage, double* out_timestamp) = 0;
    virtual DispatchResponse setLocalFontsEnabled(bool in_enabled) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void fontsUpdated(std::unique_ptr<protocol::CSS::FontFace> font = {});
    void mediaQueryResultChanged();
    void styleSheetAdded(std::unique_ptr<protocol::CSS::CSSStyleSheetHeader> header);
    void styleSheetChanged(const String& styleSheetId);
    void styleSheetRemoved(const String& styleSheetId);
    void computedStyleUpdated(int nodeId);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace CSS
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_CSS_h)
