// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/cache_storage.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace CacheStorage {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "CacheStorage";
const char Metainfo::commandPrefix[] = "CacheStorage.";
const char Metainfo::version[] = "1.3";


namespace CachedResponseTypeEnum {
const char Basic[] = "basic";
const char Cors[] = "cors";
const char Default[] = "default";
const char Error[] = "error";
const char OpaqueResponse[] = "opaqueResponse";
const char OpaqueRedirect[] = "opaqueRedirect";
} // namespace CachedResponseTypeEnum


CRDTP_BEGIN_DESERIALIZER(DataEntry)
    CRDTP_DESERIALIZE_FIELD("requestHeaders", m_requestHeaders),
    CRDTP_DESERIALIZE_FIELD("requestMethod", m_requestMethod),
    CRDTP_DESERIALIZE_FIELD("requestURL", m_requestURL),
    CRDTP_DESERIALIZE_FIELD("responseHeaders", m_responseHeaders),
    CRDTP_DESERIALIZE_FIELD("responseStatus", m_responseStatus),
    CRDTP_DESERIALIZE_FIELD("responseStatusText", m_responseStatusText),
    CRDTP_DESERIALIZE_FIELD("responseTime", m_responseTime),
    CRDTP_DESERIALIZE_FIELD("responseType", m_responseType),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DataEntry)
    CRDTP_SERIALIZE_FIELD("requestURL", m_requestURL);
    CRDTP_SERIALIZE_FIELD("requestMethod", m_requestMethod);
    CRDTP_SERIALIZE_FIELD("requestHeaders", m_requestHeaders);
    CRDTP_SERIALIZE_FIELD("responseTime", m_responseTime);
    CRDTP_SERIALIZE_FIELD("responseStatus", m_responseStatus);
    CRDTP_SERIALIZE_FIELD("responseStatusText", m_responseStatusText);
    CRDTP_SERIALIZE_FIELD("responseType", m_responseType);
    CRDTP_SERIALIZE_FIELD("responseHeaders", m_responseHeaders);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Cache)
    CRDTP_DESERIALIZE_FIELD("cacheId", m_cacheId),
    CRDTP_DESERIALIZE_FIELD("cacheName", m_cacheName),
    CRDTP_DESERIALIZE_FIELD("securityOrigin", m_securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("storageBucket", m_storageBucket),
    CRDTP_DESERIALIZE_FIELD("storageKey", m_storageKey),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Cache)
    CRDTP_SERIALIZE_FIELD("cacheId", m_cacheId);
    CRDTP_SERIALIZE_FIELD("securityOrigin", m_securityOrigin);
    CRDTP_SERIALIZE_FIELD("storageKey", m_storageKey);
    CRDTP_SERIALIZE_FIELD("storageBucket", m_storageBucket);
    CRDTP_SERIALIZE_FIELD("cacheName", m_cacheName);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Header)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Header)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CachedResponse)
    CRDTP_DESERIALIZE_FIELD("body", m_body),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CachedResponse)
    CRDTP_SERIALIZE_FIELD("body", m_body);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void deleteCache(const crdtp::Dispatchable& dispatchable);
    void deleteEntry(const crdtp::Dispatchable& dispatchable);
    void requestCacheNames(const crdtp::Dispatchable& dispatchable);
    void requestCachedResponse(const crdtp::Dispatchable& dispatchable);
    void requestEntries(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("deleteCache"),
          &DomainDispatcherImpl::deleteCache
    },
    {
          crdtp::SpanFrom("deleteEntry"),
          &DomainDispatcherImpl::deleteEntry
    },
    {
          crdtp::SpanFrom("requestCacheNames"),
          &DomainDispatcherImpl::requestCacheNames
    },
    {
          crdtp::SpanFrom("requestCachedResponse"),
          &DomainDispatcherImpl::requestCachedResponse
    },
    {
          crdtp::SpanFrom("requestEntries"),
          &DomainDispatcherImpl::requestEntries
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class DeleteCacheCallbackImpl : public Backend::DeleteCacheCallback, public DomainDispatcher::Callback {
public:
    DeleteCacheCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("CacheStorage.deleteCache"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct deleteCacheParams : public crdtp::DeserializableProtocolObject<deleteCacheParams> {
    String cacheId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(deleteCacheParams)
    CRDTP_DESERIALIZE_FIELD("cacheId", cacheId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::deleteCache(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    deleteCacheParams params;
    if (!deleteCacheParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->deleteCache(params.cacheId, std::make_unique<DeleteCacheCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class DeleteEntryCallbackImpl : public Backend::DeleteEntryCallback, public DomainDispatcher::Callback {
public:
    DeleteEntryCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("CacheStorage.deleteEntry"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct deleteEntryParams : public crdtp::DeserializableProtocolObject<deleteEntryParams> {
    String cacheId;
    String request;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(deleteEntryParams)
    CRDTP_DESERIALIZE_FIELD("cacheId", cacheId),
    CRDTP_DESERIALIZE_FIELD("request", request),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::deleteEntry(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    deleteEntryParams params;
    if (!deleteEntryParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->deleteEntry(params.cacheId, params.request, std::make_unique<DeleteEntryCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class RequestCacheNamesCallbackImpl : public Backend::RequestCacheNamesCallback, public DomainDispatcher::Callback {
public:
    RequestCacheNamesCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("CacheStorage.requestCacheNames"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<protocol::CacheStorage::Cache>> caches) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("caches"), caches);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct requestCacheNamesParams : public crdtp::DeserializableProtocolObject<requestCacheNamesParams> {
    std::optional<String> securityOrigin;
    std::optional<String> storageKey;
    std::unique_ptr<protocol::Storage::StorageBucket> storageBucket;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(requestCacheNamesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("securityOrigin", securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("storageBucket", storageBucket),
    CRDTP_DESERIALIZE_FIELD_OPT("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::requestCacheNames(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    requestCacheNamesParams params;
    if (!requestCacheNamesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->requestCacheNames(std::move(params.securityOrigin), std::move(params.storageKey), std::move(params.storageBucket), std::make_unique<RequestCacheNamesCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class RequestCachedResponseCallbackImpl : public Backend::RequestCachedResponseCallback, public DomainDispatcher::Callback {
public:
    RequestCachedResponseCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("CacheStorage.requestCachedResponse"), message) { }

    void sendSuccess(std::unique_ptr<protocol::CacheStorage::CachedResponse> response) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("response"), response);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct requestCachedResponseParams : public crdtp::DeserializableProtocolObject<requestCachedResponseParams> {
    String cacheId;
    String requestURL;
    std::unique_ptr<protocol::Array<protocol::CacheStorage::Header>> requestHeaders;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(requestCachedResponseParams)
    CRDTP_DESERIALIZE_FIELD("cacheId", cacheId),
    CRDTP_DESERIALIZE_FIELD("requestHeaders", requestHeaders),
    CRDTP_DESERIALIZE_FIELD("requestURL", requestURL),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::requestCachedResponse(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    requestCachedResponseParams params;
    if (!requestCachedResponseParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->requestCachedResponse(params.cacheId, params.requestURL, std::move(params.requestHeaders), std::make_unique<RequestCachedResponseCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class RequestEntriesCallbackImpl : public Backend::RequestEntriesCallback, public DomainDispatcher::Callback {
public:
    RequestEntriesCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("CacheStorage.requestEntries"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<protocol::CacheStorage::DataEntry>> cacheDataEntries, double returnCount) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("cacheDataEntries"), cacheDataEntries);
        serializer.AddField(crdtp::MakeSpan("returnCount"), returnCount);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct requestEntriesParams : public crdtp::DeserializableProtocolObject<requestEntriesParams> {
    String cacheId;
    std::optional<int> skipCount;
    std::optional<int> pageSize;
    std::optional<String> pathFilter;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(requestEntriesParams)
    CRDTP_DESERIALIZE_FIELD("cacheId", cacheId),
    CRDTP_DESERIALIZE_FIELD_OPT("pageSize", pageSize),
    CRDTP_DESERIALIZE_FIELD_OPT("pathFilter", pathFilter),
    CRDTP_DESERIALIZE_FIELD_OPT("skipCount", skipCount),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::requestEntries(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    requestEntriesParams params;
    if (!requestEntriesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->requestEntries(params.cacheId, std::move(params.skipCount), std::move(params.pageSize), std::move(params.pathFilter), std::make_unique<RequestEntriesCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("CacheStorage"), SortedRedirects(), std::move(dispatcher));
}

} // CacheStorage
} // namespace blink
} // namespace protocol
