// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_CSS_VALUE_KEYWORDS_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_CSS_VALUE_KEYWORDS_H_

#include <string.h>
#include <stdint.h>

#include <string_view>

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/css/parser/css_parser_mode.h"

namespace blink {

enum class CSSValueID {
  kInvalid = 0,
  kInherit = 1,
  kInitial = 2,
  kNone = 3,
  kHidden = 4,
  kInset = 5,
  kGroove = 6,
  kOutset = 7,
  kRidge = 8,
  kDotted = 9,
  kDashed = 10,
  kSolid = 11,
  kDouble = 12,
  kCaption = 13,
  kIcon = 14,
  kMenu = 15,
  kMessageBox = 16,
  kSmallCaption = 17,
  kWebkitMiniControl = 18,
  kWebkitSmallControl = 19,
  kWebkitControl = 20,
  kStatusBar = 21,
  kItalic = 22,
  kOblique = 23,
  kAll = 24,
  kCommonLigatures = 25,
  kNoCommonLigatures = 26,
  kDiscretionaryLigatures = 27,
  kNoDiscretionaryLigatures = 28,
  kHistoricalLigatures = 29,
  kNoHistoricalLigatures = 30,
  kContextual = 31,
  kNoContextual = 32,
  kSmallCaps = 33,
  kAllSmallCaps = 34,
  kPetiteCaps = 35,
  kAllPetiteCaps = 36,
  kUnicase = 37,
  kTitlingCaps = 38,
  kJis78 = 39,
  kJis83 = 40,
  kJis90 = 41,
  kJis04 = 42,
  kSimplified = 43,
  kTraditional = 44,
  kFullWidth = 45,
  kProportionalWidth = 46,
  kRuby = 47,
  kLiningNums = 48,
  kOldstyleNums = 49,
  kProportionalNums = 50,
  kTabularNums = 51,
  kDiagonalFractions = 52,
  kStackedFractions = 53,
  kOrdinal = 54,
  kSlashedZero = 55,
  kStylistic = 56,
  kHistoricalForms = 57,
  kStyleset = 58,
  kCharacterVariant = 59,
  kSwash = 60,
  kOrnaments = 61,
  kAnnotation = 62,
  kNormal = 63,
  kBold = 64,
  kBolder = 65,
  kLighter = 66,
  kWeight = 67,
  kUltraCondensed = 68,
  kExtraCondensed = 69,
  kCondensed = 70,
  kSemiCondensed = 71,
  kSemiExpanded = 72,
  kExpanded = 73,
  kExtraExpanded = 74,
  kUltraExpanded = 75,
  kXxSmall = 76,
  kXSmall = 77,
  kSmall = 78,
  kMedium = 79,
  kLarge = 80,
  kXLarge = 81,
  kXxLarge = 82,
  kXxxLarge = 83,
  kSmaller = 84,
  kLarger = 85,
  kWebkitXxxLarge = 86,
  kExHeight = 87,
  kCapHeight = 88,
  kChWidth = 89,
  kIcWidth = 90,
  kIcHeight = 91,
  kSerif = 92,
  kSansSerif = 93,
  kCursive = 94,
  kFantasy = 95,
  kMonospace = 96,
  kSystemUi = 97,
  kWebkitBody = 98,
  kMath = 99,
  kSwap = 100,
  kFallback = 101,
  kOptional = 102,
  kFontTech = 103,
  kFontFormat = 104,
  kEmoji = 105,
  kUnicode = 106,
  kPaletteMix = 107,
  kAqua = 108,
  kBlack = 109,
  kBlue = 110,
  kFuchsia = 111,
  kGray = 112,
  kGreen = 113,
  kLime = 114,
  kMaroon = 115,
  kNavy = 116,
  kOlive = 117,
  kOrange = 118,
  kPurple = 119,
  kRed = 120,
  kSilver = 121,
  kTeal = 122,
  kWhite = 123,
  kYellow = 124,
  kTransparent = 125,
  kWebkitLink = 126,
  kWebkitActivelink = 127,
  kAccentcolor = 128,
  kAccentcolortext = 129,
  kActiveborder = 130,
  kActivecaption = 131,
  kActivetext = 132,
  kAppworkspace = 133,
  kBackground = 134,
  kButtonborder = 135,
  kButtonface = 136,
  kButtonhighlight = 137,
  kButtonshadow = 138,
  kButtontext = 139,
  kCanvas = 140,
  kCanvastext = 141,
  kCaptiontext = 142,
  kField = 143,
  kFieldtext = 144,
  kGraytext = 145,
  kHighlight = 146,
  kHighlighttext = 147,
  kInactiveborder = 148,
  kInactivecaption = 149,
  kInactivecaptiontext = 150,
  kInfobackground = 151,
  kInfotext = 152,
  kLinktext = 153,
  kMark = 154,
  kMarktext = 155,
  kMenutext = 156,
  kSelecteditem = 157,
  kSelecteditemtext = 158,
  kScrollbar = 159,
  kThreeddarkshadow = 160,
  kThreedface = 161,
  kThreedhighlight = 162,
  kThreedlightshadow = 163,
  kThreedshadow = 164,
  kVisitedtext = 165,
  kWindow = 166,
  kWindowframe = 167,
  kWindowtext = 168,
  kInternalActiveListBoxSelection = 169,
  kInternalActiveListBoxSelectionText = 170,
  kInternalInactiveListBoxSelection = 171,
  kInternalInactiveListBoxSelectionText = 172,
  kWebkitFocusRingColor = 173,
  kCurrentcolor = 174,
  kGrey = 175,
  kInternalQuirkInherit = 176,
  kInternalSpellingErrorColor = 177,
  kInternalGrammarErrorColor = 178,
  kInternalSearchColor = 179,
  kInternalSearchTextColor = 180,
  kInternalCurrentSearchColor = 181,
  kInternalCurrentSearchTextColor = 182,
  kAliceblue = 183,
  kAntiquewhite = 184,
  kAquamarine = 185,
  kAzure = 186,
  kBeige = 187,
  kBisque = 188,
  kBlanchedalmond = 189,
  kBlueviolet = 190,
  kBrown = 191,
  kBurlywood = 192,
  kCadetblue = 193,
  kChartreuse = 194,
  kChocolate = 195,
  kCoral = 196,
  kCornflowerblue = 197,
  kCornsilk = 198,
  kCrimson = 199,
  kCyan = 200,
  kDarkblue = 201,
  kDarkcyan = 202,
  kDarkgoldenrod = 203,
  kDarkgray = 204,
  kDarkgreen = 205,
  kDarkgrey = 206,
  kDarkkhaki = 207,
  kDarkmagenta = 208,
  kDarkolivegreen = 209,
  kDarkorange = 210,
  kDarkorchid = 211,
  kDarkred = 212,
  kDarksalmon = 213,
  kDarkseagreen = 214,
  kDarkslateblue = 215,
  kDarkslategray = 216,
  kDarkslategrey = 217,
  kDarkturquoise = 218,
  kDarkviolet = 219,
  kDeeppink = 220,
  kDeepskyblue = 221,
  kDimgray = 222,
  kDimgrey = 223,
  kDodgerblue = 224,
  kFirebrick = 225,
  kFloralwhite = 226,
  kForestgreen = 227,
  kGainsboro = 228,
  kGhostwhite = 229,
  kGold = 230,
  kGoldenrod = 231,
  kGreenyellow = 232,
  kHoneydew = 233,
  kHotpink = 234,
  kIndianred = 235,
  kIndigo = 236,
  kIvory = 237,
  kKhaki = 238,
  kLavender = 239,
  kLavenderblush = 240,
  kLawngreen = 241,
  kLemonchiffon = 242,
  kLightblue = 243,
  kLightcoral = 244,
  kLightcyan = 245,
  kLightgoldenrodyellow = 246,
  kLightgray = 247,
  kLightgreen = 248,
  kLightgrey = 249,
  kLightpink = 250,
  kLightsalmon = 251,
  kLightseagreen = 252,
  kLightskyblue = 253,
  kLightslategray = 254,
  kLightslategrey = 255,
  kLightsteelblue = 256,
  kLightyellow = 257,
  kLimegreen = 258,
  kLinen = 259,
  kMagenta = 260,
  kMediumaquamarine = 261,
  kMediumblue = 262,
  kMediumorchid = 263,
  kMediumpurple = 264,
  kMediumseagreen = 265,
  kMediumslateblue = 266,
  kMediumspringgreen = 267,
  kMediumturquoise = 268,
  kMediumvioletred = 269,
  kMidnightblue = 270,
  kMintcream = 271,
  kMistyrose = 272,
  kMoccasin = 273,
  kNavajowhite = 274,
  kOldlace = 275,
  kOlivedrab = 276,
  kOrangered = 277,
  kOrchid = 278,
  kPalegoldenrod = 279,
  kPalegreen = 280,
  kPaleturquoise = 281,
  kPalevioletred = 282,
  kPapayawhip = 283,
  kPeachpuff = 284,
  kPeru = 285,
  kPink = 286,
  kPlum = 287,
  kPowderblue = 288,
  kRebeccapurple = 289,
  kRosybrown = 290,
  kRoyalblue = 291,
  kSaddlebrown = 292,
  kSalmon = 293,
  kSandybrown = 294,
  kSeagreen = 295,
  kSeashell = 296,
  kSienna = 297,
  kSkyblue = 298,
  kSlateblue = 299,
  kSlategray = 300,
  kSlategrey = 301,
  kSnow = 302,
  kSpringgreen = 303,
  kSteelblue = 304,
  kTan = 305,
  kThistle = 306,
  kTomato = 307,
  kTurquoise = 308,
  kViolet = 309,
  kWheat = 310,
  kWhitesmoke = 311,
  kYellowgreen = 312,
  kRepeat = 313,
  kRepeatX = 314,
  kRepeatY = 315,
  kNoRepeat = 316,
  kClear = 317,
  kCopy = 318,
  kSourceOver = 319,
  kSourceIn = 320,
  kSourceOut = 321,
  kSourceAtop = 322,
  kDestinationOver = 323,
  kDestinationIn = 324,
  kDestinationOut = 325,
  kDestinationAtop = 326,
  kXor = 327,
  kPlusLighter = 328,
  kSubtract = 329,
  kIntersect = 330,
  kExclude = 331,
  kBaseline = 332,
  kMiddle = 333,
  kSub = 334,
  kSuper = 335,
  kTextTop = 336,
  kTextBottom = 337,
  kTop = 338,
  kBottom = 339,
  kWebkitBaselineMiddle = 340,
  kWebkitAuto = 341,
  kLeft = 342,
  kRight = 343,
  kCenter = 344,
  kJustify = 345,
  kMatchParent = 346,
  kWebkitLeft = 347,
  kWebkitRight = 348,
  kWebkitCenter = 349,
  kWebkitMatchParent = 350,
  kInternalCenter = 351,
  kInlineStart = 352,
  kInlineEnd = 353,
  kOutside = 354,
  kInside = 355,
  kDisc = 356,
  kCircle = 357,
  kSquare = 358,
  kDisclosureOpen = 359,
  kDisclosureClosed = 360,
  kDecimal = 361,
  kInline = 362,
  kBlock = 363,
  kFlowRoot = 364,
  kFlow = 365,
  kTable = 366,
  kFlex = 367,
  kGrid = 368,
  kMasonry = 369,
  kContents = 370,
  kTableRowGroup = 371,
  kTableHeaderGroup = 372,
  kTableFooterGroup = 373,
  kTableRow = 374,
  kTableColumnGroup = 375,
  kTableColumn = 376,
  kTableCell = 377,
  kTableCaption = 378,
  kRubyText = 379,
  kInlineBlock = 380,
  kInlineTable = 381,
  kInlineFlex = 382,
  kInlineGrid = 383,
  kInlineMasonry = 384,
  kWebkitBox = 385,
  kWebkitInlineBox = 386,
  kWebkitFlex = 387,
  kWebkitInlineFlex = 388,
  kLayout = 389,
  kInlineLayout = 390,
  kListItem = 391,
  kAuto = 392,
  kCrosshair = 393,
  kDefault = 394,
  kPointer = 395,
  kMove = 396,
  kVerticalText = 397,
  kCell = 398,
  kContextMenu = 399,
  kAlias = 400,
  kProgress = 401,
  kNoDrop = 402,
  kNotAllowed = 403,
  kZoomIn = 404,
  kZoomOut = 405,
  kEResize = 406,
  kNeResize = 407,
  kNwResize = 408,
  kNResize = 409,
  kSeResize = 410,
  kSwResize = 411,
  kSResize = 412,
  kWResize = 413,
  kEwResize = 414,
  kNsResize = 415,
  kNeswResize = 416,
  kNwseResize = 417,
  kColResize = 418,
  kRowResize = 419,
  kText = 420,
  kWait = 421,
  kHelp = 422,
  kAllScroll = 423,
  kGrab = 424,
  kGrabbing = 425,
  kWebkitGrab = 426,
  kWebkitGrabbing = 427,
  kWebkitZoomIn = 428,
  kWebkitZoomOut = 429,
  kLtr = 430,
  kRtl = 431,
  kCapitalize = 432,
  kUppercase = 433,
  kLowercase = 434,
  kMathAuto = 435,
  kVisible = 436,
  kCollapse = 437,
  kPreserve = 438,
  kPreserveBreaks = 439,
  kPretty = 440,
  kA3 = 441,
  kA4 = 442,
  kA5 = 443,
  kAbove = 444,
  kAbsolute = 445,
  kAlways = 446,
  kAvoid = 447,
  kB4 = 448,
  kB5 = 449,
  kBelow = 450,
  kBidiOverride = 451,
  kBlink = 452,
  kBoth = 453,
  kBreakSpaces = 454,
  kCloseQuote = 455,
  kEmbed = 456,
  kFixed = 457,
  kHand = 458,
  kHide = 459,
  kIsolate = 460,
  kIsolateOverride = 461,
  kPlaintext = 462,
  kWebkitIsolate = 463,
  kWebkitIsolateOverride = 464,
  kWebkitPlaintext = 465,
  kJisB5 = 466,
  kJisB4 = 467,
  kLandscape = 468,
  kLedger = 469,
  kLegal = 470,
  kLetter = 471,
  kLineThrough = 472,
  kLocal = 473,
  kNoCloseQuote = 474,
  kNoOpenQuote = 475,
  kNowrap = 476,
  kOpenQuote = 477,
  kOverlay = 478,
  kOverline = 479,
  kPortrait = 480,
  kPre = 481,
  kPreLine = 482,
  kPreWrap = 483,
  kRelative = 484,
  kScroll = 485,
  kSeparate = 486,
  kShow = 487,
  kStatic = 488,
  kThick = 489,
  kThin = 490,
  kUnderline = 491,
  kView = 492,
  kWavy = 493,
  kCompact = 494,
  kStretch = 495,
  kStart = 496,
  kEnd = 497,
  kClone = 498,
  kSlice = 499,
  kReverse = 500,
  kHorizontal = 501,
  kVertical = 502,
  kInlineAxis = 503,
  kBlockAxis = 504,
  kFlexStart = 505,
  kFlexEnd = 506,
  kSpaceBetween = 507,
  kSpaceAround = 508,
  kSpaceEvenly = 509,
  kUnsafe = 510,
  kSafe = 511,
  kAnchorCenter = 512,
  kRow = 513,
  kRowReverse = 514,
  kColumn = 515,
  kColumnReverse = 516,
  kWrap = 517,
  kWrapReverse = 518,
  kAutoFlow = 519,
  kDense = 520,
  kReadOnly = 521,
  kReadWrite = 522,
  kReadWritePlaintextOnly = 523,
  kElement = 524,
  kWebkitMinContent = 525,
  kWebkitMaxContent = 526,
  kWebkitFillAvailable = 527,
  kWebkitFitContent = 528,
  kMinContent = 529,
  kMaxContent = 530,
  kFitContent = 531,
  kFromElement = 532,
  kNoAutospace = 533,
  kCap = 534,
  kEx = 535,
  kTrimBoth = 536,
  kTrimEnd = 537,
  kTrimStart = 538,
  kClip = 539,
  kEllipsis = 540,
  kSpellingError = 541,
  kGrammarError = 542,
  kFromFont = 543,
  kSpaceAll = 544,
  kSpaceFirst = 545,
  kBreakAll = 546,
  kKeepAll = 547,
  kAutoPhrase = 548,
  kBreakWord = 549,
  kSpace = 550,
  kLoose = 551,
  kStrict = 552,
  kAfterWhiteSpace = 553,
  kAnywhere = 554,
  kManual = 555,
  kCheckbox = 556,
  kRadio = 557,
  kButton = 558,
  kListbox = 559,
  kInternalMediaControl = 560,
  kMenulist = 561,
  kMenulistButton = 562,
  kMeter = 563,
  kProgressBar = 564,
  kSearchfield = 565,
  kTextfield = 566,
  kTextarea = 567,
  kSliderVertical = 568,
  kRound = 569,
  kBaseSelect = 570,
  kInternalAutoBase = 571,
  kInternalPartialInterestContent = 572,
  kBorder = 573,
  kBorderBox = 574,
  kContent = 575,
  kContentBox = 576,
  kPadding = 577,
  kPaddingBox = 578,
  kMarginBox = 579,
  kNoClip = 580,
  kContain = 581,
  kCover = 582,
  kLogical = 583,
  kVisual = 584,
  kReplace = 585,
  kAccumulate = 586,
  kAlternate = 587,
  kAlternateReverse = 588,
  kForwards = 589,
  kBackwards = 590,
  kInfinite = 591,
  kRunning = 592,
  kPaused = 593,
  kFlat = 594,
  kPreserve3d = 595,
  kFillBox = 596,
  kViewBox = 597,
  kEase = 598,
  kLinear = 599,
  kEaseIn = 600,
  kEaseOut = 601,
  kEaseInOut = 602,
  kJumpBoth = 603,
  kJumpEnd = 604,
  kJumpNone = 605,
  kJumpStart = 606,
  kStepStart = 607,
  kStepEnd = 608,
  kSteps = 609,
  kFrames = 610,
  kCubicBezier = 611,
  kDocument = 612,
  kReset = 613,
  kZoom = 614,
  kVisiblepainted = 615,
  kVisiblefill = 616,
  kVisiblestroke = 617,
  kPainted = 618,
  kFill = 619,
  kStroke = 620,
  kBoundingBox = 621,
  kSpellOut = 622,
  kDigits = 623,
  kLiteralPunctuation = 624,
  kNoPunctuation = 625,
  kAntialiased = 626,
  kSubpixelAntialiased = 627,
  kOptimizespeed = 628,
  kOptimizelegibility = 629,
  kGeometricprecision = 630,
  kCrispedges = 631,
  kEconomy = 632,
  kExact = 633,
  kLr = 634,
  kRl = 635,
  kTb = 636,
  kLrTb = 637,
  kRlTb = 638,
  kTbRl = 639,
  kHorizontalTb = 640,
  kVerticalRl = 641,
  kVerticalLr = 642,
  kSidewaysRl = 643,
  kSidewaysLr = 644,
  kAfter = 645,
  kBefore = 646,
  kInterCharacter = 647,
  kOver = 648,
  kUnder = 649,
  kFilled = 650,
  kOpen = 651,
  kDot = 652,
  kDoubleCircle = 653,
  kTriangle = 654,
  kSesame = 655,
  kEllipse = 656,
  kClosestSide = 657,
  kClosestCorner = 658,
  kFarthestSide = 659,
  kFarthestCorner = 660,
  kMixed = 661,
  kSideways = 662,
  kSidewaysRight = 663,
  kUpright = 664,
  kVerticalRight = 665,
  kOn = 666,
  kOff = 667,
  kOptimizequality = 668,
  kPixelated = 669,
  kWebkitOptimizeContrast = 670,
  kFromImage = 671,
  kRotateLeft = 672,
  kRotateRight = 673,
  kNonzero = 674,
  kEvenodd = 675,
  kAt = 676,
  kAlphabetic = 677,
  kBorderless = 678,
  kFullscreen = 679,
  kStandalone = 680,
  kMinimalUi = 681,
  kBrowser = 682,
  kWindowControlsOverlay = 683,
  kTabbed = 684,
  kPictureInPicture = 685,
  kMinimized = 686,
  kMaximized = 687,
  kPaged = 688,
  kSlow = 689,
  kFast = 690,
  kSticky = 691,
  kCoarse = 692,
  kFine = 693,
  kOnDemand = 694,
  kHover = 695,
  kMultiply = 696,
  kScreen = 697,
  kDarken = 698,
  kLighten = 699,
  kColorDodge = 700,
  kColorBurn = 701,
  kHardLight = 702,
  kSoftLight = 703,
  kDifference = 704,
  kExclusion = 705,
  kHue = 706,
  kSaturation = 707,
  kColor = 708,
  kLuminosity = 709,
  kScaleDown = 710,
  kBalance = 711,
  kNotch = 712,
  kScoop = 713,
  kSquircle = 714,
  kSuperellipse = 715,
  kDrag = 716,
  kNoDrag = 717,
  kSpan = 718,
  kMinmax = 719,
  kSubgrid = 720,
  kProgressive = 721,
  kInterlace = 722,
  kMarkers = 723,
  kAlpha = 724,
  kLuminance = 725,
  kMatchSource = 726,
  kSRGB = 727,
  kLinearrgb = 728,
  kButt = 729,
  kMiter = 730,
  kBevel = 731,
  kBeforeEdge = 732,
  kAfterEdge = 733,
  kCentral = 734,
  kTextBeforeEdge = 735,
  kTextAfterEdge = 736,
  kIdeographic = 737,
  kHanging = 738,
  kMathematical = 739,
  kRowOverColumn = 740,
  kColumnOverRow = 741,
  kIntersection = 742,
  kSpanningItem = 743,
  kUseScript = 744,
  kNoChange = 745,
  kResetSize = 746,
  kDynamic = 747,
  kNonScalingStroke = 748,
  kInternalExtendToZoom = 749,
  kPanX = 750,
  kPanY = 751,
  kPanLeft = 752,
  kPanRight = 753,
  kPanUp = 754,
  kPanDown = 755,
  kManipulation = 756,
  kPinchZoom = 757,
  kLastBaseline = 758,
  kFirstBaseline = 759,
  kFirst = 760,
  kLast = 761,
  kSelfStart = 762,
  kSelfEnd = 763,
  kLegacy = 764,
  kSmooth = 765,
  kScrollPosition = 766,
  kRevert = 767,
  kRevertLayer = 768,
  kRevertRule = 769,
  kUnset = 770,
  kLinearGradient = 771,
  kRadialGradient = 772,
  kConicGradient = 773,
  kRepeatingLinearGradient = 774,
  kRepeatingRadialGradient = 775,
  kRepeatingConicGradient = 776,
  kPaint = 777,
  kCrossFade = 778,
  kWebkitCrossFade = 779,
  kWebkitGradient = 780,
  kWebkitLinearGradient = 781,
  kWebkitRadialGradient = 782,
  kWebkitRepeatingLinearGradient = 783,
  kWebkitRepeatingRadialGradient = 784,
  kWebkitImageSet = 785,
  kImageSet = 786,
  kType = 787,
  kTo = 788,
  kColorStop = 789,
  kRadial = 790,
  kAttr = 791,
  kCounter = 792,
  kCounters = 793,
  kRect = 794,
  kPolygon = 795,
  kShape = 796,
  kBy = 797,
  kLine = 798,
  kClose = 799,
  kHline = 800,
  kVline = 801,
  kArc = 802,
  kCw = 803,
  kCcw = 804,
  kCurve = 805,
  kOrigin = 806,
  kWith = 807,
  kFormat = 808,
  kCollection = 809,
  kEmbeddedOpentype = 810,
  kOpentype = 811,
  kSVG = 812,
  kTruetype = 813,
  kWoff = 814,
  kWoff2 = 815,
  kTech = 816,
  kFeaturesOpentype = 817,
  kFeaturesAat = 818,
  kFeaturesGraphite = 819,
  kColorCOLRv0 = 820,
  kColorCOLRv1 = 821,
  kColorSVG = 822,
  kColorSbix = 823,
  kColorCBDT = 824,
  kVariations = 825,
  kPalettes = 826,
  kIncremental = 827,
  kInvert = 828,
  kGrayscale = 829,
  kSepia = 830,
  kSaturate = 831,
  kHueRotate = 832,
  kOpacity = 833,
  kBrightness = 834,
  kContrast = 835,
  kBlur = 836,
  kDropShadow = 837,
  kUrl = 838,
  kRgb = 839,
  kRgba = 840,
  kHsl = 841,
  kHsla = 842,
  kHwb = 843,
  kLab = 844,
  kOklab = 845,
  kLch = 846,
  kOklch = 847,
  kLightDark = 848,
  kSRGBLinear = 849,
  kDisplayP3 = 850,
  kA98Rgb = 851,
  kProphotoRgb = 852,
  kXyz = 853,
  kXyzD50 = 854,
  kXyzD65 = 855,
  kShorter = 856,
  kLonger = 857,
  kDecreasing = 858,
  kIncreasing = 859,
  kIn = 860,
  kColorMix = 861,
  kFrom = 862,
  kR = 863,
  kG = 864,
  kB = 865,
  kH = 866,
  kS = 867,
  kL = 868,
  kW = 869,
  kA = 870,
  kC = 871,
  kMatrix = 872,
  kMatrix3d = 873,
  kPerspective = 874,
  kRotate = 875,
  kRotateX = 876,
  kRotateY = 877,
  kRotateZ = 878,
  kRotate3d = 879,
  kScale = 880,
  kScaleX = 881,
  kScaleY = 882,
  kScaleZ = 883,
  kScale3d = 884,
  kSkew = 885,
  kSkewX = 886,
  kSkewY = 887,
  kTranslate = 888,
  kTranslateX = 889,
  kTranslateY = 890,
  kTranslateZ = 891,
  kTranslate3d = 892,
  kX = 893,
  kY = 894,
  kZ = 895,
  kPath = 896,
  kRay = 897,
  kSides = 898,
  kStrokeBox = 899,
  kCalc = 900,
  kWebkitCalc = 901,
  kMin = 902,
  kMax = 903,
  kClamp = 904,
  kCalcSize = 905,
  kAny = 906,
  kSin = 907,
  kCos = 908,
  kAsin = 909,
  kAtan = 910,
  kAtan2 = 911,
  kAcos = 912,
  kMod = 913,
  kRem = 914,
  kUp = 915,
  kDown = 916,
  kToZero = 917,
  kSign = 918,
  kAbs = 919,
  kPow = 920,
  kSqrt = 921,
  kHypot = 922,
  kLog = 923,
  kExp = 924,
  kInfinity = 925,
  kNegativeInfinity = 926,
  kNan = 927,
  kPi = 928,
  kE = 929,
  kMandatory = 930,
  kProximity = 931,
  kStyle = 932,
  kSize = 933,
  kBlockSize = 934,
  kInlineSize = 935,
  kViewTransition = 936,
  kScrollState = 937,
  kBlockStart = 938,
  kBlockEnd = 939,
  kAnchored = 940,
  kAutoFill = 941,
  kAutoFit = 942,
  kVar = 943,
  kInternalVariableValue = 944,
  kEnv = 945,
  kArg = 946,
  kAvoidPage = 947,
  kPage = 948,
  kRecto = 949,
  kVerso = 950,
  kAvoidColumn = 951,
  kP3 = 952,
  kRec2020 = 953,
  kAdd = 954,
  kAutoAdd = 955,
  kTrue = 956,
  kFalse = 957,
  kNoPreference = 958,
  kDark = 959,
  kLight = 960,
  kOnly = 961,
  kReduce = 962,
  kActive = 963,
  kPreserveParentColor = 964,
  kBackButton = 965,
  kFabricated = 966,
  kSelector = 967,
  kAtRule = 968,
  kContinuous = 969,
  kFolded = 970,
  kStable = 971,
  kBothEdges = 972,
  kMore = 973,
  kLess = 974,
  kCustom = 975,
  kCyclic = 976,
  kSymbolic = 977,
  kNumeric = 978,
  kAdditive = 979,
  kExtends = 980,
  kInternalSimpChineseInformal = 981,
  kInternalSimpChineseFormal = 982,
  kInternalTradChineseInformal = 983,
  kInternalTradChineseFormal = 984,
  kInternalKoreanHangulFormal = 985,
  kInternalKoreanHanjaInformal = 986,
  kInternalKoreanHanjaFormal = 987,
  kInternalHebrew = 988,
  kInternalLowerArmenian = 989,
  kInternalUpperArmenian = 990,
  kInternalEthiopicNumeric = 991,
  kBullets = 992,
  kNumbers = 993,
  kWords = 994,
  kStandard = 995,
  kHigh = 996,
  kNoLimit = 997,
  kConstrained = 998,
  kDynamicRangeLimitMix = 999,
  kLayer = 1000,
  kSupports = 1001,
  kScope = 1002,
  kColorContrast = 1003,
  kVs = 1004,
  kAA = 1005,
  kAALarge = 1006,
  kAAA = 1007,
  kAAALarge = 1008,
  kDrop = 1009,
  kRaise = 1010,
  kXywh = 1011,
  kAnchor = 1012,
  kAnchorSize = 1013,
  kWidth = 1014,
  kHeight = 1015,
  kSelfBlock = 1016,
  kSelfInline = 1017,
  kEntry = 1018,
  kExit = 1019,
  kEntryCrossing = 1020,
  kExitCrossing = 1021,
  kRoot = 1022,
  kNearest = 1023,
  kSelf = 1024,
  kAllowDiscrete = 1025,
  kInverted = 1026,
  kLayered = 1027,
  kMatchElement = 1028,
  kEnabled = 1029,
  kInitialOnly = 1030,
  kSpanLeft = 1031,
  kSpanRight = 1032,
  kXStart = 1033,
  kXEnd = 1034,
  kSpanXStart = 1035,
  kSpanXEnd = 1036,
  kXSelfStart = 1037,
  kXSelfEnd = 1038,
  kSpanXSelfStart = 1039,
  kSpanXSelfEnd = 1040,
  kSpanAll = 1041,
  kSpanTop = 1042,
  kSpanBottom = 1043,
  kYStart = 1044,
  kYEnd = 1045,
  kSpanYStart = 1046,
  kSpanYEnd = 1047,
  kYSelfStart = 1048,
  kYSelfEnd = 1049,
  kSpanYSelfStart = 1050,
  kSpanYSelfEnd = 1051,
  kSpanBlockStart = 1052,
  kSpanBlockEnd = 1053,
  kSelfBlockStart = 1054,
  kSelfBlockEnd = 1055,
  kSpanSelfBlockStart = 1056,
  kSpanSelfBlockEnd = 1057,
  kSpanInlineStart = 1058,
  kSpanInlineEnd = 1059,
  kSelfInlineStart = 1060,
  kSelfInlineEnd = 1061,
  kSpanSelfInlineStart = 1062,
  kSpanSelfInlineEnd = 1063,
  kSpanStart = 1064,
  kSpanEnd = 1065,
  kSpanSelfStart = 1066,
  kSpanSelfEnd = 1067,
  kPositionArea = 1068,
  kInternalTextareaAuto = 1069,
  kMostWidth = 1070,
  kMostHeight = 1071,
  kMostBlockSize = 1072,
  kMostInlineSize = 1073,
  kFlipBlock = 1074,
  kFlipInline = 1075,
  kFlipStart = 1076,
  kAnchorsVisible = 1077,
  kNoOverflow = 1078,
  kFlexVisual = 1079,
  kFlexFlow = 1080,
  kGridRows = 1081,
  kGridColumns = 1082,
  kGridOrder = 1083,
  kSourceOrder = 1084,
  kContextFill = 1085,
  kContextStroke = 1086,
  kPerLine = 1087,
  kConsistent = 1088,
  kFontSize = 1089,
  kScaleInline = 1090,
  kLetterSpacing = 1091,
  kMediaProgress = 1092,
  kContainerProgress = 1093,
  kOf = 1094,
  kBlinkFeature = 1095,
  kNumericOnly = 1096,
  kAllowKeywords = 1097,
  kInert = 1098,
  kSiblingCount = 1099,
  kSiblingIndex = 1100,
  kIdent = 1101,
  kReturns = 1102,
  kOnce = 1103,
  kState = 1104,
  kIf = 1105,
  kElse = 1106,
  kMedia = 1107,
  kTabs = 1108,
  kLinks = 1109,
  kBar = 1110,
  kUnderscore = 1111,
  kWebkitLegacy = 1112,
  kNoEllipsis = 1113,
  kTrigger = 1114,
};

constexpr int kNumCSSValueKeywords = 1115;
constexpr size_t kMaxCSSValueKeywordLength = 42;

inline bool IsValidCSSValueID(CSSValueID id)
{
    return id != CSSValueID::kInvalid;
}

CORE_EXPORT std::string_view GetCSSValueName(CSSValueID);

template <typename StringType>
inline StringType GetCSSValueNameAs(CSSValueID value_id) {
  return StringType(base::as_byte_span(GetCSSValueName(value_id)));
}

bool IsValueAllowedInMode(CSSValueID id, CSSParserMode mode);

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_CSS_VALUE_KEYWORDS_H_
