// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_transient_input_hit_test_options_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/modules/xr/xr_ray.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"entityTypes",
"offsetRay",
"profile",
};


}  // namespace 

XRTransientInputHitTestOptionsInit* XRTransientInputHitTestOptionsInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  XRTransientInputHitTestOptionsInit* dictionary = MakeGarbageCollected<XRTransientInputHitTestOptionsInit>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "XRTransientInputHitTestOptionsInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 XRTransientInputHitTestOptionsInit::XRTransientInputHitTestOptionsInit() {
  
}

 XRTransientInputHitTestOptionsInit::XRTransientInputHitTestOptionsInit(v8::Isolate* isolate) {
  
}



Vector<V8XRHitTestTrackableType> XRTransientInputHitTestOptionsInit::getEntityTypesOr(const Vector<V8XRHitTestTrackableType>& fallback_value) const {
  if (!hasEntityTypes()) {
  return fallback_value;
}
return member_entity_types_;
}

Vector<V8XRHitTestTrackableType> XRTransientInputHitTestOptionsInit::getEntityTypesOr(Vector<V8XRHitTestTrackableType>&& fallback_value) const {
  if (!hasEntityTypes()) {
  return std::move(fallback_value);
}
return member_entity_types_;
}

void XRTransientInputHitTestOptionsInit::setEntityTypes(const Vector<V8XRHitTestTrackableType>& value) {
  member_entity_types_ = value;
has_entity_types_ = true;
}

void XRTransientInputHitTestOptionsInit::setEntityTypes(Vector<V8XRHitTestTrackableType>&& value) {
  member_entity_types_ = std::move(value);
has_entity_types_ = true;
}











void XRTransientInputHitTestOptionsInit::setProfile(const String& value) {
  member_profile_ = value;
}

void XRTransientInputHitTestOptionsInit::setProfile(String&& value) {
  member_profile_ = std::move(value);
}




void XRTransientInputHitTestOptionsInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_offset_ray_);
bindings::InputDictionaryBase::Trace(visitor);
}

void XRTransientInputHitTestOptionsInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "XRTransientInputHitTestOptionsInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (RuntimeEnabledFeatures::WebXRHitTestEntityTypesEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("entityTypes");
if (!bindings::GetDictionaryMemberFromV8Object<IDLArray<V8XRHitTestTrackableType>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_entity_types_, member_entity_types_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("offsetRay");
if (!bindings::GetDictionaryMemberFromV8Object<XRRay, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_offset_ray_, member_offset_ray_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("profile");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_profile_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> XRTransientInputHitTestOptionsInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
