// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_TRACKED_IMAGE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_TRACKED_IMAGE_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ImageBitmap;

class MODULES_EXPORT XRTrackedImageInit : public bindings::InputDictionaryBase {
  
  public:
static XRTrackedImageInit* Create() {
  return MakeGarbageCollected<XRTrackedImageInit>();
}
static XRTrackedImageInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRTrackedImageInit>(isolate);
}
static XRTrackedImageInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRTrackedImageInit();
explicit  XRTrackedImageInit(v8::Isolate* isolate);

bool hasImage() const {
  return true;
}
ImageBitmap* image() const {
  return member_image_.Get();
}
void setImage(ImageBitmap* value) {
  member_image_ = value;
DCHECK(member_image_);
}

bool hasWidthInMeters() const {
  return true;
}
float widthInMeters() const {
  return member_width_in_meters_;
}
void setWidthInMeters(float value) {
  member_width_in_meters_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<ImageBitmap> member_image_;
float member_width_in_meters_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_TRACKED_IMAGE_INIT_H_
