// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_render_state_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/modules/xr/xr_layer.h"
#include "third_party/blink/renderer/modules/xr/xr_webgl_layer.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"baseLayer",
"depthFar",
"depthNear",
"inlineVerticalFieldOfView",
"layers",
};


}  // namespace 

XRRenderStateInit* XRRenderStateInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  XRRenderStateInit* dictionary = MakeGarbageCollected<XRRenderStateInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "XRRenderStateInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 XRRenderStateInit::XRRenderStateInit() {
  
}

 XRRenderStateInit::XRRenderStateInit(v8::Isolate* isolate) {
  
}






































void XRRenderStateInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_base_layer_);
visitor->Trace(member_layers_);
bindings::InputDictionaryBase::Trace(visitor);
}

void XRRenderStateInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "XRRenderStateInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("baseLayer");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<XRWebGLLayer>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_base_layer_, member_base_layer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("depthFar");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_depth_far_, member_depth_far_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("depthNear");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_depth_near_, member_depth_near_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("inlineVerticalFieldOfView");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_inline_vertical_field_of_view_, member_inline_vertical_field_of_view_, class_like_name, exception_state)) {
  return;
}
if (RuntimeEnabledFeatures::WebXRLayersCommonEnabled()) {
  dictionary_from_v8_context.SetCurrentPropertyName("layers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLSequence<XRLayer>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_layers_, member_layers_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> XRRenderStateInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
