// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_PROJECTION_LAYER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_PROJECTION_LAYER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_texture_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT XRProjectionLayerInit : public bindings::InputDictionaryBase {
  
  public:
static XRProjectionLayerInit* Create() {
  return MakeGarbageCollected<XRProjectionLayerInit>();
}
static XRProjectionLayerInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRProjectionLayerInit>(isolate);
}
static XRProjectionLayerInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRProjectionLayerInit();
explicit  XRProjectionLayerInit(v8::Isolate* isolate);

bool hasColorFormat() const {
  return true;
}
uint32_t colorFormat() const {
  return member_color_format_;
}
void setColorFormat(uint32_t value) {
  member_color_format_ = value;
}

bool hasDepthFormat() const {
  return true;
}
uint32_t depthFormat() const {
  return member_depth_format_;
}
void setDepthFormat(uint32_t value) {
  member_depth_format_ = value;
}

bool hasScaleFactor() const {
  return true;
}
double scaleFactor() const {
  return member_scale_factor_;
}
void setScaleFactor(double value) {
  member_scale_factor_ = value;
}

bool hasTextureType() const {
  return true;
}
V8XRTextureType textureType() const {
  return member_texture_type_;
}
void setTextureType(V8XRTextureType value) {
  member_texture_type_ = value;
}
void setTextureType(V8XRTextureType::Enum value) {
  member_texture_type_ = V8XRTextureType(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_color_format_{0x1908};
uint32_t member_depth_format_{0x1902};
double member_scale_factor_{1.0};
V8XRTextureType member_texture_type_{V8XRTextureType::Enum::kTexture};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_PROJECTION_LAYER_INIT_H_
