// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_INPUT_SOURCES_CHANGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_INPUT_SOURCES_CHANGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class XRInputSource;
class XRSession;

class MODULES_EXPORT XRInputSourcesChangeEventInit : public EventInit {
  
  public:
static XRInputSourcesChangeEventInit* Create() {
  return MakeGarbageCollected<XRInputSourcesChangeEventInit>();
}
static XRInputSourcesChangeEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRInputSourcesChangeEventInit>(isolate);
}
static XRInputSourcesChangeEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRInputSourcesChangeEventInit();
explicit  XRInputSourcesChangeEventInit(v8::Isolate* isolate);

bool hasAdded() const {
  return true;
}
const HeapVector<Member<XRInputSource>>& added() const {
  return member_added_;
}
void setAdded(const HeapVector<Member<XRInputSource>>& value);
void setAdded(HeapVector<Member<XRInputSource>>&& value);

bool hasRemoved() const {
  return true;
}
const HeapVector<Member<XRInputSource>>& removed() const {
  return member_removed_;
}
void setRemoved(const HeapVector<Member<XRInputSource>>& value);
void setRemoved(HeapVector<Member<XRInputSource>>&& value);

bool hasSession() const {
  return true;
}
XRSession* session() const {
  return member_session_.Get();
}
void setSession(XRSession* value) {
  member_session_ = value;
DCHECK(member_session_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



HeapVector<Member<XRInputSource>> member_added_;
HeapVector<Member<XRInputSource>> member_removed_;
Member<XRSession> member_session_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_INPUT_SOURCES_CHANGE_EVENT_INIT_H_
