// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_GPU_PROJECTION_LAYER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_GPU_PROJECTION_LAYER_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT XRGPUProjectionLayerInit : public bindings::InputDictionaryBase {
  
  public:
static XRGPUProjectionLayerInit* Create() {
  return MakeGarbageCollected<XRGPUProjectionLayerInit>();
}
static XRGPUProjectionLayerInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRGPUProjectionLayerInit>(isolate);
}
static XRGPUProjectionLayerInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRGPUProjectionLayerInit();
explicit  XRGPUProjectionLayerInit(v8::Isolate* isolate);

bool hasColorFormat() const {
  return true;
}
V8GPUTextureFormat colorFormat() const {
  return member_color_format_;
}
void setColorFormat(V8GPUTextureFormat value) {
  member_color_format_ = value;
}
void setColorFormat(V8GPUTextureFormat::Enum value) {
  member_color_format_ = V8GPUTextureFormat(value);
}

bool hasDepthStencilFormat() const {
  return has_depth_stencil_format_;
}
const std::optional<V8GPUTextureFormat>& depthStencilFormat() const {
  DCHECK(hasDepthStencilFormat());
return member_depth_stencil_format_;
}
std::optional<V8GPUTextureFormat> getDepthStencilFormatOr(const std::optional<V8GPUTextureFormat>& fallback_value) const {
  if (!hasDepthStencilFormat()) {
  return fallback_value;
}
return member_depth_stencil_format_;
}
void setDepthStencilFormat(const std::optional<V8GPUTextureFormat>& value) {
  member_depth_stencil_format_ = value;
has_depth_stencil_format_ = true;
}
void setDepthStencilFormat(V8GPUTextureFormat value) {
  member_depth_stencil_format_ = value;
has_depth_stencil_format_ = true;
}
void setDepthStencilFormat(V8GPUTextureFormat::Enum value) {
  member_depth_stencil_format_ = V8GPUTextureFormat(value);
has_depth_stencil_format_ = true;
}

bool hasScaleFactor() const {
  return true;
}
double scaleFactor() const {
  return member_scale_factor_;
}
void setScaleFactor(double value) {
  member_scale_factor_ = value;
}

bool hasTextureUsage() const {
  return true;
}
uint32_t textureUsage() const {
  return member_texture_usage_;
}
void setTextureUsage(uint32_t value) {
  member_texture_usage_ = value;
}


// Obsolete accessor functions
bool hasDepthStencilFormatNonNull() const {
  return hasDepthStencilFormat() && depthStencilFormat().has_value();
}
V8GPUTextureFormat depthStencilFormatNonNull() const {
  DCHECK(hasDepthStencilFormatNonNull());
return depthStencilFormat().value();
}

void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_depth_stencil_format_ = false;

V8GPUTextureFormat member_color_format_{static_cast<V8GPUTextureFormat::Enum>(0)};
std::optional<V8GPUTextureFormat> member_depth_stencil_format_;
double member_scale_factor_{1.0};
uint32_t member_texture_usage_{0x10};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_GPU_PROJECTION_LAYER_INIT_H_
