// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_EQUIRECT_LAYER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_EQUIRECT_LAYER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_layer_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_texture_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class XRRigidTransform;

class MODULES_EXPORT XREquirectLayerInit : public XRLayerInit {
  
  public:
static XREquirectLayerInit* Create() {
  return MakeGarbageCollected<XREquirectLayerInit>();
}
static XREquirectLayerInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XREquirectLayerInit>(isolate);
}
static XREquirectLayerInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XREquirectLayerInit();
explicit  XREquirectLayerInit(v8::Isolate* isolate);

bool hasCentralHorizontalAngle() const {
  return true;
}
float centralHorizontalAngle() const {
  return member_central_horizontal_angle_;
}
void setCentralHorizontalAngle(float value) {
  member_central_horizontal_angle_ = value;
}

bool hasLowerVerticalAngle() const {
  return true;
}
float lowerVerticalAngle() const {
  return member_lower_vertical_angle_;
}
void setLowerVerticalAngle(float value) {
  member_lower_vertical_angle_ = value;
}

bool hasRadius() const {
  return true;
}
float radius() const {
  return member_radius_;
}
void setRadius(float value) {
  member_radius_ = value;
}

bool hasTextureType() const {
  return true;
}
V8XRTextureType textureType() const {
  return member_texture_type_;
}
void setTextureType(V8XRTextureType value) {
  member_texture_type_ = value;
}
void setTextureType(V8XRTextureType::Enum value) {
  member_texture_type_ = V8XRTextureType(value);
}

bool hasTransform() const {
  return has_transform_;
}
XRRigidTransform* transform() const {
  DCHECK(hasTransform());
return member_transform_.Get();
}
XRRigidTransform* getTransformOr(XRRigidTransform* fallback_value) const {
  if (!hasTransform()) {
  return fallback_value;
}
return member_transform_.Get();
}
void setTransform(XRRigidTransform* value) {
  member_transform_ = value;
has_transform_ = true;
}

bool hasUpperVerticalAngle() const {
  return true;
}
float upperVerticalAngle() const {
  return member_upper_vertical_angle_;
}
void setUpperVerticalAngle(float value) {
  member_upper_vertical_angle_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = XRLayerInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_transform_ = false;

float member_central_horizontal_angle_{6.28318};
float member_lower_vertical_angle_{-1.570795};
float member_radius_{0};
V8XRTextureType member_texture_type_{V8XRTextureType::Enum::kTexture};
Member<XRRigidTransform> member_transform_;
float member_upper_vertical_angle_{1.570795};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_EQUIRECT_LAYER_INIT_H_
